var width;
var height;
var multiplierX;
var multiplierY;
var answers = [];
var objectsNumber = 10;

window.onload = function() {
  init();
};

$(window).resize(function() {
    clearTimeout(window.resizedFinished);
    window.resizedFinished = setTimeout(function(){
        calculateMultipliers();
    }, 250);
});

// this function is necessary to compensate for the difference between the dimensions of the svg and the window size
function calculateMultipliers() {
    width = $(window).width();
    height = $(window).height();
    if (width / height < 1.777) {
        multiplierX = 1920 / width;
        multiplierY = multiplierX;
    } else {
        multiplierY = 1080 / height;
        multiplierX = multiplierY;
    }
}

$(document).ready(function(){

    calculateMultipliers();

  $('#info-button').click(function(){
    var html = '<div class="iframe-container">\n' +
      '        <div class="close-iframe"><img src="assets/close.svg" class="close-button-x"></div>\n' +
      '        <iframe src="info.html" class="info-iframe"></iframe>\n' +
      '    </div>';
    $('body').append(html);

    $('.close-iframe').click(function(){
      $('.iframe-container').remove();
    });
  });

  $('#help-button').click(function(){
    var html = '<div class="iframe-container">\n' +
      '        <div class="close-iframe"><img src="assets/close.svg" class="close-button-x"></div>\n' +
      '        <iframe src="help.html" class="info-iframe"></iframe>\n' +
      '    </div>';
    $('body').append(html);

    $('.close-iframe').click(function(){
      $('.iframe-container').remove();
    });
  });

  $('.close-intro').click(function(){
    $('body').removeClass('blur');
    $('.intro-container').addClass('hidden');
  });

  swal({
    icon: 'info',
    title: 'Πλήρης Οθόνη;',
    text: 'Μήπως θα ήθελες να ανοίξεις τον εννοιολογικό χάρτη σε λειτουργία πλήρους οθόνης; Θα είναι περισσότερο απολαυστικό!',
    buttons: {
      confirm: {
        text: "Ναι! Τέλεια ιδέα!",
        value: true,
        visible: true,
        className: "go-fullscreen-ok",
        closeModal: true
      },
      cancel: {
        text: "Όχι...",
          value: null,
          visible: true,
          className: "go-fullscreen-cancel",
          closeModal: true,
      }
    }
  }).then(function(result) {
      if(result){
        if (screenfull.enabled) {
          screenfull.request();
        }
      }
  });
});

function objectDropped (object) {
    // dropped[object] = true;
}

function objectRemoved (object){
    // delete dropped[object];
    delete answers[object];
}

function checkall() {

}

function dragStopped(){
}

function dragStarted(event){
    resetAnswers();
}

function resetAnswers(){
    $('#viomaza-correct, #piriniki-correct, #aioliki-correct, #geothermiki-correct, #iliaki-correct, #idroilektriki-correct, #fusiko-aerio-correct, #petrelaio-correct, #gaianthrakes-correct, #mi-ananeosimes-correct').attr('display','none');
    $('#viomaza-wrong, #piriniki-wrong, #aioliki-wrong, #geothermiki-wrong, #iliaki-wrong, #idroilektriki-wrong, #fusiko-aerio-wrong, #petrelaio-wrong, #gaianthrakes-wrong, #mi-ananeosimes-wrong').attr('display','none');
}

function evaluate(object, target){
  // console.log('object is ', object);
  // console.log('target is ', target);
    if ((
            ['idroilektriki', 'iliaki', 'aioliki', 'geothermiki', 'viomaza'].includes(object) &&
            ['cont-ananeosimes', 'cont-ananeosimes2', 'cont-ananeosimes3', 'cont-ananeosimes4', 'cont-ananeosimes5'].includes(target)
        ) || (
            ['fusiko-aerio', 'petrelaio', 'gaianthrakes'].includes(object) &&
            ['cont-orikta', 'cont-orikta2', 'cont-orikta3'].includes(target)
        ) || (
            ['mi-ananeosimes'].includes(object) &&
            ['cont-mi-ananeosimes'].includes(target)
        ) || (
            ['piriniki'].includes(object) &&
            ['cont-piriniki'].includes(target)
        )
    ) {
        answers[object] = true;
        // console.log('correct');
    } else {
        answers[object] = false;
        // console.log('wrong');
    }
}

function init() {

  // enable draggables to be dropped into ananeosimes
  interact('#cont-ananeosimes, #cont-ananeosimes2, #cont-ananeosimes3, #cont-ananeosimes4, #cont-ananeosimes5, #cont-mi-ananeosimes, #cont-orikta, #cont-orikta2, #cont-orikta3, #cont-piriniki').dropzone({
    // only accept elements matching this CSS selector
    accept: '#viomaza, #piriniki, #aioliki, #geothermiki, #iliaki, #idroilektriki, #fusiko-aerio, #petrelaio, #gaianthrakes, #mi-ananeosimes',
    // Require a 25% element overlap for a drop to be possible
    overlap: 0.25,

    // listen for drop related events:

    ondropactivate: function (event) {
      // add active dropzone feedback
      event.target.classList.add('drop-active');
    },
    ondragenter: function (event) {
      var draggableElement = event.relatedTarget,
        dropzoneElement = event.target;

      // feedback the possibility of a drop
      dropzoneElement.classList.add('drop-target');
      draggableElement.classList.add('can-drop');
    },
    ondragleave: function (event) {
      // remove the drop feedback style
      event.target.classList.remove('drop-target');
      event.relatedTarget.classList.remove('can-drop');

      objectRemoved(event.relatedTarget.id);
    },
    ondrop: function (event) {
      // event.relatedTarget.textContent = 'Dropped';
      evaluate(event.relatedTarget.id, event.target.id);
      objectDropped(event.relatedTarget.id);
    },
    ondropdeactivate: function (event) {
      // remove active dropzone feedback
      event.target.classList.remove('drop-active');
      event.target.classList.remove('drop-target');
    }
  });

  interact('#viomaza, #piriniki, #aioliki, #geothermiki, #iliaki, #idroilektriki, #fusiko-aerio, #petrelaio, #gaianthrakes, #mi-ananeosimes')
    .draggable({
      inertia: true,
      restrict: {
        restriction: "parent",
        endOnly: true,
        elementRect: {top: 0, left: 0, bottom: 1, right: 1}
      },
      autoScroll: true,
      // dragMoveListener from the dragging demo above
      onmove: dragMoveListener,
      onstart: function(event) {
        dragStarted(event)
      },
      onend: dragStopped
    });

  function dragMoveListener(event) {
    var target = event.target,
      // keep the dragged position in the data-x/data-y attributes
      x = (parseFloat(target.getAttribute('data-x')) || 0) + (event.dx * multiplierX), // we compensate for the difference between svg size and window size with these multipliers
      y = (parseFloat(target.getAttribute('data-y')) || 0) + (event.dy * multiplierY);

    // translate the element
    target.style.webkitTransform =
      target.style.transform =
        'translate(' + x + 'px, ' + y + 'px)';

    // update the posiion attributes
    target.setAttribute('data-x', x);
    target.setAttribute('data-y', y);
  }

  // this is used later in the resizing and gesture demos
  window.dragMoveListener = dragMoveListener;

  $('#check-answers').click(function () {

    if (Object.keys(answers).length === 10) {

        for (var a in answers) {
            if (answers[a]) {
                $('#'+a+'-correct').attr('display', '');
            } else {
                $('#'+a+'-wrong').attr('display', '');
            }
        }

      if(Object.values(answers).includes(false)){
        swal('Ουπς...', 'Κάτι δεν πάει καλά. Κάποιες έννοιες δεν βρίσκονται στην κατάλληλη θέση. Μπορείς να τις σύρεις στην κατάλληλη θέση;', 'error');
      } else {
        swal({
              title: 'Τέλεια!',
              text: 'Έχεις τοποθετήσει σωστά όλες τις έννοιες!',
              icon: 'success'
        });
      }
    } else {
        swal('Πρόσεξε!', 'Πρέπει να σύρεις όλες τις έννοιες στην κατάλληλη θέση!', 'warning');
    }
  });
}
