var OpusDecoder;((function(){"use strict";var VINT_SIZES=[0,8,7,7,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1];var VINT_MASKS=[255,127,63,31,15,7,3,1,0];var OPUS_SIG=[65,95,79,80,85,83];var PAUSE_DURATION=16;var PRE_STATE=0;var READY_STATE=1;var WAIT_STATE=2;var PAUSED_STATE=3;var _state=PRE_STATE;var _queue=[];var _decoder=null;var _audioBuffer=null;var _audioContext=null;var _inputPointer=null;var _outputBuffer=null;var _outputPointer=null;var _outputOffset=0;var _requestCounter=0;var _requests=[];Module={onRuntimeInitialized:DecodeNextTrack};if(!self["performance"]){if(!Date.now){Date.now=(function(){return(new Date).getTime()})}self["performance"]={"now":Date.now}}function ReadVInt(data,position,length,initialMask){var value=data.getUint8(position)&initialMask;for(var i=1;i<length;i++)value=(value<<8)+data.getUint8(position+i);return value}function CalculateAudioBufferSize(rate,channels,duration){return rate/1e3*channels*duration}function CreateDecoder(duration){var frequency=48e3;var channels=1;var bufferSize=2048;var length=CalculateAudioBufferSize(frequency,channels,duration);_audioBuffer=new Float32Array(length);if(!_outputBuffer){_outputPointer=Module._malloc(bufferSize<<2);_outputBuffer=new Float32Array(Module.HEAPU8.buffer,_outputPointer,bufferSize)}if(!_inputPointer){_inputPointer=Module._malloc(bufferSize)}_decoder=Module._create_decoder(frequency,channels);if(_decoder<0)throw new Error("Failed to create decoder")}function DestroyDecoder(){Module._destroy_decoder(_decoder);_decoder=null;_outputOffset=0}OpusDecoder=function DecodeOpusTrack(buffer,callback,outputBuffer){_queue.unshift([buffer,callback,outputBuffer]);if(_state==PAUSED_STATE)DecodeNextTrack()};function DecodeNextTrack(){var entry=_queue.pop();if(entry){var buffer=entry[0];var callback=entry[1];var ctx=entry[2];var start=performance.now();var error;_audioContext=ctx||null;_state=WAIT_STATE;try{ParseMaster(new DataView(buffer),0,buffer.byteLength)}catch(e){error=e}DestroyDecoder();if(error){callback(error)}else{var time=(performance.now()-start)/1e3;callback(null,_audioBuffer,time)}_audioBuffer=null;_state=READY_STATE;setTimeout(DecodeNextTrack,PAUSE_DURATION)}else _state=PAUSED_STATE}function ParseFrame(data){var length=data.length;Module.HEAPU8.set(data,_inputPointer);var ret=Module._decode_frame(_decoder,_inputPointer,length,_outputPointer,4096);if(ret>0){_audioBuffer.set(new Float32Array(Module.HEAPU8.buffer,_outputPointer,ret),_outputOffset);_outputOffset+=ret}else{throw new Error("Failed to parse frame")}}function ParseBlock(data,position,size){var firstByte,tagLength,mask,trackEntry,timeCode,flags,lacing;firstByte=data.getUint8(position);tagLength=VINT_SIZES[firstByte];mask=VINT_MASKS[tagLength];trackEntry=ReadVInt(data,position,tagLength,mask);position+=tagLength;timeCode=data.getInt16(position);position+=2;flags=data.getUint8(position);position+=1;size-=tagLength+3;lacing=flags&6;if(lacing)throw"Lacing not supported";ParseFrame(new Uint8Array(data.buffer,position,size))}function ParseDuration(data,position,size){var duration;if(size==4)duration=data.getFloat32(position);else if(size==8)duration=data.getFloat64(position);else throw new Error("Invalid size");CreateDecoder(duration)}function TestOpus(data,position){for(var i=0,l=6;i<l;i++){if(data.getUint8(position+i)!=OPUS_SIG[i])throw new Error("Contains non opus data")}}function ParseMaster(data,position,length){var firstByte,tagLength,id,sizeLength,mask,size;var end=position+length;while(position<end){firstByte=data.getUint8(position);tagLength=VINT_SIZES[firstByte];if(tagLength>4||tagLength==0)throw"Invalid tag length "+tagLength;id=ReadVInt(data,position,tagLength,255);position+=tagLength;firstByte=data.getUint8(position);sizeLength=VINT_SIZES[firstByte];mask=VINT_MASKS[sizeLength];if(sizeLength==0)throw"Invalid size length";size=ReadVInt(data,position,sizeLength,mask);position+=sizeLength;switch(id){case 408125543:case 357149030:case 524531317:case 374648427:case 174:ParseMaster(data,position,size);break;case 17545:ParseDuration(data,position,size);break;case 134:TestOpus(data,position,size);break;case 163:ParseBlock(data,position,size);break}position+=size}}function WorkerRequest(url,cb){var id=_requestCounter++;postMessage({"type":"request","id":id,"url":url});_requests.push([id,cb])}function CompleteRequest(id,err,data){for(var i=0,l=_requests.length;i<l;i++){if(_requests[i][0]==id){_requests[i][1](err,data);_requests.splice(i,1);break}}}if(self["importScripts"]){self.addEventListener("message",(function(e){var data=e.data;var type=data["type"];var id=data["id"];var buffer=data["buffer"];var error=data["error"];if(type=="request"){CompleteRequest(id,error,buffer)}else{OpusDecoder(buffer,(function(err,output,time){if(err){postMessage({"type":"error","id":id,"value":err.toString()})}else{postMessage({"type":"complete","id":id,"value":output,"time":time})}}))}}));if(self["IS_WKWEBVIEW"]){self["fetch"]=(function(url){return new Promise((function(resolve,reject){WorkerRequest(url,(function(err,data){if(err){reject(err)}else{resolve({"ok":true,"arrayBuffer":(function(){return Promise.resolve(data)})})}}))}))});Module["readAsync"]=function readAsync(url,onload,onerror){WorkerRequest(url,(function(err,data){if(err)onerror(err);else onload(data)}))}}}}))();var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function shell_read(){throw"no read() available"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status,toThrow){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function shell_read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function shell_print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function shell_printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}if(!Module["quit"]){Module["quit"]=(function(status,toThrow){throw toThrow})}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value;return value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){if(sig.length===1){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func)}}else if(sig.length===2){sigCache[func]=function dynCall_wrapper(arg){return Runtime.dynCall(sig,func,[arg])}}else{sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,Array.prototype.slice.call(arguments))}}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=(ret+size+15|0)&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=0;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=Runtime.stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource=null;function ensureJSsource(){if(!JSsource){JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){ensureJSsource();funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"=("+convertCode.returnValue+");"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){ensureJSsource();funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function demangle(func){var __cxa_demangle_func=Module["___cxa_demangle"]||Module["__cxa_demangle"];if(__cxa_demangle_func){try{var s=func.substr(1);var len=lengthBytesUTF8(s)+1;var buf=_malloc(len);stringToUTF8(s,buf,len);var status=_malloc(4);var ret=__cxa_demangle_func(buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}return func}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}Module["stackTrace"]=stackTrace;var HEAP,buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||33554432;if(TOTAL_MEMORY<TOTAL_STACK)Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}HEAP32[0]=1668509029;HEAP16[1]=25459;if(HEAPU8[2]!==115||HEAPU8[3]!==99)throw"Runtime error: expected the system to be little-endian!";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){Runtime.warnOnce("writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!");var lastChar,end;if(dontAddNull){end=buffer+lengthBytesUTF8(string);lastChar=HEAP8[end]}stringToUTF8(string,buffer,Infinity);if(dontAddNull)HEAP8[end]=lastChar}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_round=Math.round;var Math_min=Math.min;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=Runtime.GLOBAL_BASE;STATICTOP=STATIC_BASE+27440;__ATINIT__.push();memoryInitializer=self["cr_opusAsmBinaryUrl"]||"opus.asm.js.mem";var tempDoublePtr=STATICTOP;STATICTOP+=16;Module["_bitshift64Ashr"]=_bitshift64Ashr;Module["___muldsi3"]=___muldsi3;Module["___muldi3"]=___muldi3;function _llvm_stackrestore(p){var self=_llvm_stacksave;var ret=self.LLVM_SAVEDSTACKS[p];self.LLVM_SAVEDSTACKS.splice(p,1);Runtime.stackRestore(ret)}Module["_i64Add"]=_i64Add;Module["_memset"]=_memset;Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}Module["_sbrk"]=_sbrk;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;Module["_memmove"]=_memmove;function _llvm_stacksave(){var self=_llvm_stacksave;if(!self.LLVM_SAVEDSTACKS){self.LLVM_SAVEDSTACKS=[]}self.LLVM_SAVEDSTACKS.push(Runtime.stackSave());return self.LLVM_SAVEDSTACKS.length-1}DYNAMICTOP_PTR=allocate(1,"i32",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=Runtime.alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"_llvm_stackrestore":_llvm_stackrestore,"___setErrNo":___setErrNo,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_llvm_stacksave":_llvm_stacksave,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.DYNAMICTOP_PTR|0;var j=env.tempDoublePtr|0;var k=env.ABORT|0;var l=env.STACKTOP|0;var m=env.STACK_MAX|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0;var y=0;var z=global.Math.floor;var A=global.Math.abs;var B=global.Math.sqrt;var C=global.Math.pow;var D=global.Math.cos;var E=global.Math.sin;var F=global.Math.tan;var G=global.Math.acos;var H=global.Math.asin;var I=global.Math.atan;var J=global.Math.atan2;var K=global.Math.exp;var L=global.Math.log;var M=global.Math.ceil;var N=global.Math.imul;var O=global.Math.min;var P=global.Math.max;var Q=global.Math.clz32;var R=env.abort;var S=env.assert;var T=env.enlargeMemory;var U=env.getTotalMemory;var V=env.abortOnCannotGrowMemory;var W=env._llvm_stackrestore;var X=env.___setErrNo;var Y=env._emscripten_memcpy_big;var Z=env._llvm_stacksave;var _=0.0;
// EMSCRIPTEN_START_FUNCS
function qb(a,b,e,f,h,i,j,k,l,m,n){a=a|0;b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=+l;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,C=0.0,D=0.0,E=0.0,F=0;y=c[a>>2]|0;z=c[a+24>>2]|0;if((e|0)==1){n=c[a+28>>2]|0;i=(c[a+32>>2]|0)>7;if(!y){if(i){n=Ea(n,1)|0;c[a+32>>2]=(c[a+32>>2]|0)+-8}else n=0;if(c[a+4>>2]|0)g[b>>2]=n|0?-1.0:1.0}else{if(i){e=+g[b>>2]<0.0&1;Eb(n,e,1);c[a+32>>2]=(c[a+32>>2]|0)+-8;n=e}else n=0;if(c[a+4>>2]|0)g[b>>2]=n|0?-1.0:1.0}if(!k){k=1;return k|0}c[k>>2]=c[b>>2];k=1;return k|0}A=(z|0)>0?z:0;do if((i|0)!=0&(m|0)!=0){if((z|0)<1?!((h|0)>1|(z|0?(((e>>>0)/(h>>>0)|0)&1|0)==0:0)):0){x=i;break}zc(m|0,i|0,e<<2|0)|0;x=m}else x=i;while(0);a:do if((z|0)>0){s=(x|0)==0;if(!y){o=0;while(1){if((!s?(p=1<<o,q=e>>o>>1,(o|0)!=31):0)?(q|0)>0:0){i=0;do{m=0;do{r=x+((N(p<<1,m)|0)+i<<2)|0;E=+g[r>>2]*.7071067690849304;t=x+(((m<<1|1)<<o)+i<<2)|0;D=+g[t>>2]*.7071067690849304;g[r>>2]=E+D;g[t>>2]=E-D;m=m+1|0}while((m|0)!=(q|0));i=i+1|0}while((i|0)!=(p|0))}n=(d[23486+(n>>4)>>0]|0)<<2|(d[23486+(n&15)>>0]|0);o=o+1|0;if((o|0)>=(A|0))break a}}else r=0;do{p=1<<r;q=e>>r>>1;i=(r|0)==31;if(!i?(q|0)>0:0){m=0;do{o=0;do{F=b+((N(p<<1,o)|0)+m<<2)|0;D=+g[F>>2]*.7071067690849304;t=b+(((o<<1|1)<<r)+m<<2)|0;E=+g[t>>2]*.7071067690849304;g[F>>2]=D+E;g[t>>2]=D-E;o=o+1|0}while((o|0)!=(q|0));m=m+1|0}while((m|0)!=(p|0))}if(!(s|i)?(q|0)>0:0){i=0;do{m=0;do{t=x+((N(p<<1,m)|0)+i<<2)|0;D=+g[t>>2]*.7071067690849304;F=x+(((m<<1|1)<<r)+i<<2)|0;E=+g[F>>2]*.7071067690849304;g[t>>2]=D+E;g[F>>2]=D-E;m=m+1|0}while((m|0)!=(q|0));i=i+1|0}while((i|0)!=(p|0))}n=(d[23486+(n>>4)>>0]|0)<<2|(d[23486+(n&15)>>0]|0);r=r+1|0}while((r|0)<(A|0))}while(0);r=((e>>>0)/(h>>>0)|0)<<A;b:do if((r&1|0)==0&(z|0)<0){t=(x|0)==0;if(!y){i=h>>A;q=z;p=0;while(1){r=r>>1;if((i|0)>0&(t^1)?(u=i<<1,(r|0)>0):0){m=0;do{o=0;do{w=x+((N(u,o)|0)+m<<2)|0;D=+g[w>>2]*.7071067690849304;F=x+((N(o<<1|1,i)|0)+m<<2)|0;E=+g[F>>2]*.7071067690849304;g[w>>2]=D+E;g[F>>2]=D-E;o=o+1|0}while((o|0)!=(r|0));m=m+1|0}while((m|0)!=(i|0))}n=n<<i|n;i=i<<1;p=p+1|0;if((r&1|0)==0&(q|0)<-1)q=q+1|0;else{s=p;break b}}}else{i=h>>A;s=z;q=0}while(1){r=r>>1;m=(i|0)>0;if(m?(v=i<<1,(r|0)>0):0){o=0;do{p=0;do{u=b+((N(v,p)|0)+o<<2)|0;D=+g[u>>2]*.7071067690849304;F=b+((N(p<<1|1,i)|0)+o<<2)|0;E=+g[F>>2]*.7071067690849304;g[u>>2]=D+E;g[F>>2]=D-E;p=p+1|0}while((p|0)!=(r|0));o=o+1|0}while((o|0)!=(i|0))}if(!(t|m^1)?(w=i<<1,(r|0)>0):0){m=0;do{o=0;do{u=x+((N(w,o)|0)+m<<2)|0;D=+g[u>>2]*.7071067690849304;F=x+((N(o<<1|1,i)|0)+m<<2)|0;E=+g[F>>2]*.7071067690849304;g[u>>2]=D+E;g[F>>2]=D-E;o=o+1|0}while((o|0)!=(r|0));m=m+1|0}while((m|0)!=(i|0))}n=n<<i|n;i=i<<1;m=q+1|0;if((r&1|0)==0&(s|0)<-1){s=s+1|0;q=m}else{s=m;break}}}else{i=h>>A;s=0}while(0);m=(i|0)>1;if(m){if(y|0)tb(b,r>>A,i<<A,(h|0)==1&1);if(x|0)tb(x,r>>A,i<<A,(h|0)==1&1)}n=ub(a,b,e,f,i,x,j,l,n)|0;if(!(c[a+4>>2]|0)){F=n;return F|0}if(m)vb(b,r>>A,i<<A,(h|0)==1&1);if((s|0)>0){q=0;do{i=i>>1;r=r<<1;n=n>>>i|n;p=r>>1;if((i|0)>0?(r|0)>0:0){m=0;do{o=0;do{a=b+((N(i<<1,o)|0)+m<<2)|0;D=+g[a>>2]*.7071067690849304;F=b+((N(o<<1|1,i)|0)+m<<2)|0;E=+g[F>>2]*.7071067690849304;g[a>>2]=D+E;g[F>>2]=D-E;o=o+1|0}while((o|0)!=(p|0));m=m+1|0}while((m|0)!=(i|0))}q=q+1|0}while((q|0)!=(s|0));r=i}else r=i;if((z|0)>0){q=0;do{n=d[23502+n>>0]|0;o=1<<q;p=e>>q>>1;if((q|0)!=31?(p|0)>0:0){i=0;do{m=0;do{z=b+((N(o<<1,m)|0)+i<<2)|0;D=+g[z>>2]*.7071067690849304;F=b+(((m<<1|1)<<q)+i<<2)|0;E=+g[F>>2]*.7071067690849304;g[z>>2]=D+E;g[F>>2]=D-E;m=m+1|0}while((m|0)!=(p|0));i=i+1|0}while((i|0)!=(o|0))}q=q+1|0}while((q|0)<(A|0));m=n}else m=n;i=r<<A;if(k|0?(C=+B(+(+(e|0))),(e|0)>0):0){n=0;do{g[k+(n<<2)>>2]=C*+g[b+(n<<2)>>2];n=n+1|0}while((n|0)!=(e|0))}F=m&(1<<i)+-1;return F|0}function rb(a,b,d,e,f,h,i,j,k,m,n){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=n|0;var o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0,C=0,D=0.0;C=l;l=l+32|0;c[C+4>>2]=f;c[C>>2]=n;u=c[a>>2]|0;y=c[a+28>>2]|0;if((e|0)==1){n=d|0?2:1;f=c[a+32>>2]|0;if(!u){s=0;t=b;while(1){if((f|0)>7){o=Ea(y,1)|0;f=(c[a+32>>2]|0)+-8|0;c[a+32>>2]=f}else o=0;if(c[a+4>>2]|0)g[t>>2]=o|0?-1.0:1.0;s=s+1|0;if((s|0)>=(n|0))break;else t=d}}else{s=0;t=b;while(1){if((f|0)>7){o=+g[t>>2]<0.0&1;Eb(y,o,1);f=(c[a+32>>2]|0)+-8|0;c[a+32>>2]=f}else o=0;if(c[a+4>>2]|0)g[t>>2]=o|0?-1.0:1.0;s=s+1|0;if((s|0)>=(n|0))break;else t=d}}if(!k){d=1;l=C;return d|0}c[k>>2]=c[b>>2];d=1;l=C;return d|0}sb(a,C+8|0,b,d,e,C+4|0,h,h,j,1,C);A=c[C+8>>2]|0;v=c[C+8+16>>2]|0;f=c[C+8+20>>2]|0;z=+(c[C+8+4>>2]|0)*.000030517578125;p=+(c[C+8+8>>2]|0)*.000030517578125;w=c[C+4>>2]|0;do if((e|0)==2){o=(v|0)!=0&(v|0)!=16384?8:0;c[a+32>>2]=(c[a+32>>2]|0)-(o+f);s=(v|0)>8192?d:b;t=(v|0)>8192?b:d;if((v|0)<16384)switch(v|0){case 0:{f=0;break}default:x=17}else switch(v|0){case 16384:{f=0;break}default:x=17}do if((x|0)==17)if(!u){f=Ea(y,1)|0;break}else{f=+g[s>>2]*+g[t+4>>2]-+g[s+4>>2]*+g[t>>2]<0.0&1;Eb(y,f,1);break}while(0);y=1-(f<<1)|0;f=qb(a,s,2,w-o|0,h,i,j,k,1.0,m,n)|0;g[t>>2]=+g[s+4>>2]*+(0-y|0);g[t+4>>2]=+(y|0)*+g[s>>2];if(c[a+4>>2]|0){g[b>>2]=z*+g[b>>2];g[b+4>>2]=z*+g[b+4>>2];q=p*+g[d>>2];g[d>>2]=q;g[d+4>>2]=p*+g[d+4>>2];r=+g[b>>2];g[b>>2]=r-q;g[d>>2]=r+ +g[d>>2];r=+g[b+4>>2];g[b+4>>2]=r-+g[d+4>>2];g[d+4>>2]=r+ +g[d+4>>2];if((e|0)==2)break;else{x=26;break}}else{d=f;l=C;return d|0}}else{t=(w-(c[C+8+12>>2]|0)|0)/2|0;t=(w|0)<(t|0)?w:t;t=(t|0)>0?t:0;f=(c[a+32>>2]|0)-f|0;c[a+32>>2]=f;o=c[C>>2]|0;if((t|0)<(w-t|0)){s=qb(a,d,e,w-t|0,h,0,j,0,p,0,o>>h)|0;f=(c[a+32>>2]|0)-f+(w-t)|0;f=qb(a,b,e,((v|0)!=16384&(f|0)>24?f+-24|0:0)+t|0,h,i,j,k,1.0,m,o)|0}else{s=qb(a,b,e,t,h,i,j,k,1.0,m,o)|0;f=(c[a+32>>2]|0)-f+t|0;f=qb(a,d,e,((v|0)!=0&(f|0)>24?f+-24|0:0)+(w-t)|0,h,0,j,0,p,0,o>>h)|0}f=s|f;if(!(c[a+4>>2]|0)){d=f;l=C;return d|0}else x=26}while(0);do if((x|0)==26){if((e|0)>0){o=0;q=0.0;p=0.0;do{r=+g[d+(o<<2)>>2];q=q+r*+g[b+(o<<2)>>2];p=p+r*r;o=o+1|0}while((o|0)!=(e|0))}else{q=0.0;p=0.0}r=z*z+p;p=z*q*2.0;if(r+p<6.000000284984708e-04|r-p<6.000000284984708e-04){zc(d|0,b|0,e<<2|0)|0;break}q=1.0/+B(+(r-p));p=1.0/+B(+(r+p));if((e|0)>0){o=0;do{k=b+(o<<2)|0;D=z*+g[k>>2];a=d+(o<<2)|0;r=+g[a>>2];g[k>>2]=q*(D-r);g[a>>2]=p*(D+r);o=o+1|0}while((o|0)!=(e|0))}else{d=f;l=C;return d|0}}while(0);if((A|0)!=0&(e|0)>0)o=0;else{d=f;l=C;return d|0}do{b=d+(o<<2)|0;g[b>>2]=-+g[b>>2];o=o+1|0}while((o|0)!=(e|0));l=C;return f|0}function sb(a,d,e,f,h,i,j,k,l,m,n){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,C=0;v=c[a+8>>2]|0;w=c[a+12>>2]|0;C=c[a+28>>2]|0;x=c[a+36>>2]|0;A=(b[(c[v+56>>2]|0)+(w<<1)>>1]|0)+(l<<3)|0;z=c[i>>2]|0;l=((h|0)==2&(m|0)!=0?-2:-1)+(h<<1)|0;l=((N((A>>1)-((h|0)==2&(m|0)!=0?16:4)|0,l)|0)+z|0)/(l|0)|0;l=(z-A+-32|0)<(l|0)?z-A+-32|0:l;l=(l|0)<64?l:64;if((l|0)<4)l=1;else l=(b[20192+((l&7)<<1)>>1]>>14-(l>>>3))+1&-2;z=(w|0)<(c[a+16>>2]|0)|(m|0)!=0^1?l:1;y=(c[a>>2]|0)!=0;if(y)o=Ya(e,f,m,h,c[a+44>>2]|0)|0;else o=0;A=wa(C)|0;do if((z|0)==1)if(m|0){if(y){if((o|0)>8192){o=(c[a+52>>2]|0)==0;if(o&(h|0)>0){l=0;do{z=f+(l<<2)|0;g[z>>2]=-+g[z>>2];l=l+1|0}while((l|0)!=(h|0));l=o&1}else l=o&1}else l=0;s=+g[x+(w<<2)>>2];q=+g[x+((c[v+8>>2]|0)+w<<2)>>2];r=+B(+(s*s+1.0000000036274937e-15+q*q))+1.0000000036274937e-15;if((h|0)>0){o=0;do{z=e+(o<<2)|0;g[z>>2]=s/r*+g[z>>2]+q/r*+g[f+(o<<2)>>2];o=o+1|0}while((o|0)!=(h|0))}}else l=0;do if((c[i>>2]|0)>16?(c[a+32>>2]|0)>16:0)if(y){Cb(C,l,2);break}else{l=Ba(C,2)|0;break}else l=0;while(0);o=(c[a+52>>2]|0)==0?l:0;u=56}else u=57;else{do if(y){p=N(o,z)|0;if(!m){if(!((p+8192>>14|0)<(z|0)&((p+8192>>14|0)>0&(c[a+56>>2]|0)!=0))){o=p+8192>>14;u=23;break}a=((p+8192>>14<<14>>>0)/(z>>>0)|0)<<16;a=(N(a>>13,a>>16)|0)+32768>>16;a=32768-a+(((N((((N((((N(a,-626)|0)+16384|0)>>>15<<16)+542441472>>16,a)|0)+16384|0)>>>15<<16)+-501415936>>16,a)|0)+16384|0)>>>15)<<16>>16;o=16384-((p+8192>>14<<14>>>0)/(z>>>0)|0)<<16;o=(N(o>>13,o>>16)|0)+32768>>16;o=32768-o+(((N((((N((((N(o,-626)|0)+16384|0)>>>15<<16)+542441472>>16,o)|0)+16384|0)>>>15<<16)+-501415936>>16,o)|0)+16384|0)>>>15)<<16>>16;t=32-(Q(a|0)|0)|0;u=32-(Q(o|0)|0)|0;u=(N((u-t<<11)-(((N((((N(a<<15-t<<16>>16,-2597)|0)+16384|0)>>>15<<16)+519831552>>16,a<<15-t<<16>>16)|0)+16384|0)>>>15)+(((N((((N(o<<15-u<<16>>16,-2597)|0)+16384|0)>>>15<<16)+519831552>>16,o<<15-u<<16>>16)|0)+16384|0)>>>15)<<16>>16,(h<<23)+-8388608>>16)|0)+16384>>15;o=c[i>>2]|0;o=(u|0)>(o|0)?z:(u|0)<(0-o|0)?0:p+8192>>14;u=23;break}l=c[a+48>>2]|0;if(!l){o=p+8192>>14;u=13;break}else{o=((((o|0)>8192?32767:-32767)|0)/(z|0)|0)+p>>14;o=(o|0)>0?o:0;o=((z|0)>(o|0)?o:z+-1|0)+(l>>>31^1)|0;u=13;break}}else u=13;while(0);do if((u|0)==13)if((h|0)>2&(m|0)!=0){t=(((z|0)/2|0)+1|0)*3|0;a=t+((z|0)/2|0)|0;if(y){p=(o|0)<=((z|0)/2|0|0);if(p){k=o*3|0;l=k}else{l=o*3|0;k=t+~((z|0)/2|0)+o|0}Bb(C,k,p?l+3|0:t-((z|0)/2|0)+o|0,a);break}else{f=ya(C,a)|0;l=(N(((z|0)/2|0)+1|0,-2)|0)+f|0;l=(f|0)<(t|0)?(f|0)/3|0:l;if((l|0)<=((z|0)/2|0|0)){o=l*3|0;p=l*3|0}else{o=l*3|0;p=t+~((z|0)/2|0)+l|0}Aa(C,p,(l|0)<=((z|0)/2|0|0)?o+3|0:t-((z|0)/2|0)+l|0,a);u=36;break}}else u=23;while(0);do if((u|0)==23){if((k|0)>1|(m|0)!=0)if(y){Db(C,o,z+1|0);break}else{l=Da(C,z+1|0)|0;u=36;break}t=N((z>>1)+1|0,(z>>1)+1|0)|0;if(y){p=(o|0)<=(z>>1|0);l=o+1|0;a=z+1-o|0;if(p)k=(N(l,o)|0)>>1;else k=t-((N(a,z+2-o|0)|0)>>1)|0;Bb(C,k,k+(p?l:a)|0,t);break}else{l=ya(C,t)|0;if((l|0)<((N((z>>1)+1|0,z>>1)|0)>>1|0)){l=((Hb(l<<3|1)|0)+-1|0)>>>1;o=(N(l+1|0,l)|0)>>>1;p=l+1|0}else{l=((z+1<<1)-(Hb((t-l<<3)+-7|0)|0)|0)>>>1;o=t-((N(z+1-l|0,z+2-l|0)|0)>>1)|0;p=z+1-l|0}Aa(C,o,o+p|0,t);u=36;break}}while(0);if((u|0)==36){o=(l<<14>>>0)/(z>>>0)|0;u=57;break}o=o<<14;if((m|0)!=0&y)if(z>>>0>o>>>0){s=+g[x+(w<<2)>>2];q=+g[x+((c[v+8>>2]|0)+w<<2)>>2];r=+B(+(s*s+1.0000000036274937e-15+q*q))+1.0000000036274937e-15;if((h|0)>0)l=0;else{o=0;u=56;break}do{y=e+(l<<2)|0;g[y>>2]=s/r*+g[y>>2]+q/r*+g[f+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0));o=(o>>>0)/(z>>>0)|0;u=57}else{if((h|0)>0)l=0;else{o=(o>>>0)/(z>>>0)|0;u=57;break}do{x=e+(l<<2)|0;s=+g[x>>2]*.7071067690849304;y=f+(l<<2)|0;r=+g[y>>2]*.7071067690849304;g[x>>2]=s+r;g[y>>2]=r-s;l=l+1|0}while((l|0)!=(h|0));o=(o>>>0)/(z>>>0)|0;u=57}else{o=(o>>>0)/(z>>>0)|0;u=57}}while(0);a:do if((u|0)==56){l=(wa(C)|0)-A|0;c[i>>2]=(c[i>>2]|0)-l}else if((u|0)==57){l=(wa(C)|0)-A|0;c[i>>2]=(c[i>>2]|0)-l;b:do if((o|0)<16384)switch(o|0){case 0:{o=0;break a}default:{}}else{switch(o|0){case 16384:break;default:break b}c[n>>2]=c[n>>2]&(1<<j)+-1<<j;C=16384;A=0;j=0;h=32767;i=16384;n=l;c[d>>2]=j;j=d+4|0;c[j>>2]=A;j=d+8|0;c[j>>2]=h;j=d+12|0;c[j>>2]=C;j=d+16|0;c[j>>2]=i;d=d+20|0;c[d>>2]=n;return}while(0);A=o<<16;A=(N(A>>13,A>>16)|0)+32768>>16;A=32768-A+(((N((((N((((N(A,-626)|0)+16384|0)>>>15<<16)+542441472>>16,A)|0)+16384|0)>>>15<<16)+-501415936>>16,A)|0)+16384|0)>>>15)<<16>>16;i=16384-o<<16;i=(N(i>>13,i>>16)|0)+32768>>16;i=32768-i+(((N((((N((((N(i,-626)|0)+16384|0)>>>15<<16)+542441472>>16,i)|0)+16384|0)>>>15<<16)+-501415936>>16,i)|0)+16384|0)>>>15)<<16>>16;j=32-(Q(A|0)|0)|0;C=32-(Q(i|0)|0)|0;C=(N((C-j<<11)-(((N((((N(A<<15-j<<16>>16,-2597)|0)+16384|0)>>>15<<16)+519831552>>16,A<<15-j<<16>>16)|0)+16384|0)>>>15)+(((N((((N(i<<15-C<<16>>16,-2597)|0)+16384|0)>>>15<<16)+519831552>>16,i<<15-C<<16>>16)|0)+16384|0)>>>15)<<16>>16,(h<<23)+-8388608>>16)|0)+16384>>15;j=0;h=i;i=o;n=l;c[d>>2]=j;j=d+4|0;c[j>>2]=A;j=d+8|0;c[j>>2]=h;j=d+12|0;c[j>>2]=C;j=d+16|0;c[j>>2]=i;d=d+20|0;c[d>>2]=n;return}while(0);c[n>>2]=c[n>>2]&(1<<j)+-1;C=-16384;A=32767;j=o;h=0;i=0;n=l;c[d>>2]=j;j=d+4|0;c[j>>2]=A;j=d+8|0;c[j>>2]=h;j=d+12|0;c[j>>2]=C;j=d+16|0;c[j>>2]=i;d=d+20|0;c[d>>2]=n;return}function tb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;j=l;h=N(d,b)|0;i=l;l=l+((1*(h<<2)|0)+15&-16)|0;if(!e){if((d|0)>0&(b|0)>0)e=0;else{d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}do{g=N(e,b)|0;f=0;do{c[i+(f+g<<2)>>2]=c[a+((N(f,d)|0)+e<<2)>>2];f=f+1|0}while((f|0)!=(b|0));e=e+1|0}while((e|0)!=(d|0));d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}else{if((d|0)>0&(b|0)>0)e=0;else{d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}do{g=N(c[12056+(d<<2)+-8+(e<<2)>>2]|0,b)|0;f=0;do{c[i+(g+f<<2)>>2]=c[a+((N(f,d)|0)+e<<2)>>2];f=f+1|0}while((f|0)!=(b|0));e=e+1|0}while((e|0)!=(d|0));d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}}function ub(e,f,h,i,j,k,m,n,o){e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=+n;o=o|0;var p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0,x=0,y=0;y=l;l=l+32|0;c[y+4>>2]=i;c[y>>2]=o;v=c[e>>2]|0;s=c[e+8>>2]|0;w=c[e+20>>2]|0;x=c[e+28>>2]|0;s=(c[s+100>>2]|0)+(b[(c[s+96>>2]|0)+((N(c[s+8>>2]|0,m+1|0)|0)+(c[e+12>>2]|0)<<1)>>1]|0)|0;p=a[s>>0]|0;if((m|0)!=-1?((h|0)>2?((d[s+(p&255)>>0]|0)+12|0)<(i|0):0):0){if((j|0)==1)c[y>>2]=o&1|o<<1;sb(e,y+8|0,f,f+(h>>>1<<2)|0,h>>>1,y+4|0,j+1>>1,j,m+-1|0,0,y);p=c[y+8+12>>2]|0;o=c[y+8+16>>2]|0;q=c[y+8+20>>2]|0;t=+(c[y+8+4>>2]|0)*.000030517578125;u=+(c[y+8+8>>2]|0)*.000030517578125;do if(!((j|0)<2|(o&16383|0)==0))if((o|0)>8192){p=p-(p>>5-m)|0;break}else{p=(p+(h>>>1<<3>>6-m)|0)<0?p+(h>>>1<<3>>6-m)|0:0;break}while(0);s=c[y+4>>2]|0;i=(s-p|0)/2|0;i=(s|0)<(i|0)?s:i;i=(i|0)>0?i:0;r=(c[e+32>>2]|0)-q|0;c[e+32>>2]=r;p=(k|0)==0?0:k+(h>>>1<<2)|0;q=c[y>>2]|0;if((i|0)<(s-i|0)){p=(ub(e,f+(h>>>1<<2)|0,h>>>1,s-i|0,j+1>>1,p,m+-1|0,u*n,q>>(j+1>>1))|0)<<(j>>1);x=(c[e+32>>2]|0)-r+(s-i)|0;p=ub(e,f,h>>>1,((o|0)!=16384&(x|0)>24?x+-24|0:0)+i|0,j+1>>1,k,m+-1|0,t*n,q)|0|p}else{k=ub(e,f,h>>>1,i,j+1>>1,k,m+-1|0,t*n,q)|0;x=(c[e+32>>2]|0)-r+i|0;p=(ub(e,f+(h>>>1<<2)|0,h>>>1,((o|0)!=0&(x|0)>24?x+-24|0:0)+(s-i)|0,j+1>>1,p,m+-1|0,u*n,q>>(j+1>>1))|0)<<(j>>1)|k}e=p;l=y;return e|0}q=(d[s+(((p&255)+1|0)>>>1)>>0]|0)<(i+-1|0);r=q?((p&255)+1|0)>>>1:0;q=q?p&255:((p&255)+1|0)>>>1;p=(d[s+((r+1+q|0)>>>1)>>0]|0)<(i+-1|0);m=p?(r+1+q|0)>>>1:r;q=p?q:(r+1+q|0)>>>1;p=(d[s+(m+1+q>>1)>>0]|0)<(i+-1|0);r=p?m+1+q>>1:m;q=p?q:m+1+q>>1;m=(d[s+(r+1+q>>1)>>0]|0)<(i+-1|0);p=m?r+1+q>>1:r;q=m?q:r+1+q>>1;r=(d[s+(p+1+q>>1)>>0]|0)<(i+-1|0);m=r?p+1+q>>1:p;q=r?q:p+1+q>>1;p=(d[s+(m+1+q>>1)>>0]|0)<(i+-1|0);r=p?m+1+q>>1:m;q=p?q:m+1+q>>1;if(!r)p=-1;else p=d[s+r>>0]|0;p=(i+-1-p|0)>((d[s+q>>0]|0)-(i+-1)|0)?q:r;a:do if(p|0){while(1){q=c[e+32>>2]|0;m=q-((d[s+p>>0]|0)+1)|0;c[e+32>>2]=m;if(!((p|0)>0&(m|0)<0))break;c[e+32>>2]=q;p=p+-1|0;if(!p)break a}p=(p|0)<8?p:(p&7|8)<<(p>>3)+-1;if(!v){e=Wa(f,h,p,w,j,x,n)|0;l=y;return e|0}else{e=Va(f,h,p,w,j,x,n,c[e+4>>2]|0,c[e+44>>2]|0)|0;l=y;return e|0}}while(0);if(!(c[e+4>>2]|0)){e=0;l=y;return e|0}p=(1<<j)+-1&o;c[y>>2]=p;if(!p){wc(f|0,0,h<<2|0)|0;e=0;l=y;return e|0}if(!k)if((h|0)>0){p=c[e+40>>2]|0;q=0;do{p=(N(p,1664525)|0)+1013904223|0;g[f+(q<<2)>>2]=+(p>>20|0);q=q+1|0}while((q|0)!=(h|0));c[e+40>>2]=p;p=(1<<j)+-1|0}else p=(1<<j)+-1|0;else if((h|0)>0){q=c[e+40>>2]|0;r=0;do{q=(N(q,1664525)|0)+1013904223|0;g[f+(r<<2)>>2]=+g[k+(r<<2)>>2]+(q&32768|0?.00390625:-.00390625);r=r+1|0}while((r|0)!=(h|0));c[e+40>>2]=q}Xa(f,h,n,c[e+44>>2]|0);e=p;l=y;return e|0}function vb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;j=l;h=N(d,b)|0;i=l;l=l+((1*(h<<2)|0)+15&-16)|0;if(!e){if((d|0)>0&(b|0)>0)e=0;else{d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}do{g=N(e,b)|0;f=0;do{c[i+((N(f,d)|0)+e<<2)>>2]=c[a+(f+g<<2)>>2];f=f+1|0}while((f|0)!=(b|0));e=e+1|0}while((e|0)!=(d|0));d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}else{if((d|0)>0&(b|0)>0)e=0;else{d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}do{g=N(c[12056+(d<<2)+-8+(e<<2)>>2]|0,b)|0;f=0;do{c[i+((N(f,d)|0)+e<<2)>>2]=c[a+(g+f<<2)>>2];f=f+1|0}while((f|0)!=(b|0));e=e+1|0}while((e|0)!=(d|0));d=h<<2;zc(a|0,i|0,d|0)|0;l=j;return}}function wb(a){a=a|0;var b=0;a:do if((a|0)<16e3)if((a|0)<12e3){switch(a|0){case 8e3:break;default:{b=6;break a}}a=6;break}else{switch(a|0){case 12e3:break;default:{b=6;break a}}a=4;break}else{if((a|0)<24e3){switch(a|0){case 16e3:break;default:{b=6;break a}}a=3;break}if((a|0)>=48e3)switch(a|0){case 48e3:{a=1;break a}default:{b=6;break a}}switch(a|0){case 24e3:break;default:{b=6;break a}}a=2}while(0);if((b|0)==6)a=0;return a|0}function xb(a,b,c,d,e,f,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;h=+h;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;if(f==0.0&h==0.0){if((b|0)==(a|0))return;Ac(a|0,b|0,e<<2|0)|0;return}u=(c|0)>15?c:15;v=(d|0)>15?d:15;r=+g[12176+(i*12|0)>>2]*f;s=+g[12176+(i*12|0)+4>>2]*f;t=+g[12176+(i*12|0)+8>>2]*f;w=+g[12176+(j*12|0)>>2]*h;x=+g[12176+(j*12|0)+4>>2]*h;y=+g[12176+(j*12|0)+8>>2]*h;m=(u|0)==(v|0)&f==h&(i|0)==(j|0)?0:l;if((m|0)>0){c=0;n=+g[b+(1-v<<2)>>2];o=+g[b+(0-v<<2)>>2];p=+g[b+(~v<<2)>>2];q=+g[b+(-2-v<<2)>>2];while(1){f=+g[b+(2-v+c<<2)>>2];z=+g[k+(c<<2)>>2];j=c-u|0;g[a+(c<<2)>>2]=(q+f)*(y*(z*z))+((n+p)*(x*(z*z))+(o*(w*(z*z))+(+g[b+(c<<2)>>2]+ +g[b+(j<<2)>>2]*(r*(1.0-z*z))+s*(1.0-z*z)*(+g[b+(j+1<<2)>>2]+ +g[b+(j+-1<<2)>>2])+t*(1.0-z*z)*(+g[b+(j+2<<2)>>2]+ +g[b+(j+-2<<2)>>2]))));c=c+1|0;if((c|0)==(m|0)){c=m;break}else{z=n;n=f;q=p;p=o;o=z}}}else c=0;if(h==0.0){if((b|0)==(a|0))return;Ac(a+(m<<2)|0,b+(m<<2)|0,e-m<<2|0)|0;return}l=a+(c<<2)|0;d=b+(c<<2)|0;m=e-c|0;if((m|0)<=0)return;c=0;n=+g[d+(1-v<<2)>>2];o=+g[d+(0-v<<2)>>2];p=+g[d+(~v<<2)>>2];q=+g[d+(-2-v<<2)>>2];while(1){f=+g[d+(2-v+c<<2)>>2];g[l+(c<<2)>>2]=y*(q+f)+(x*(p+n)+(w*o+ +g[d+(c<<2)>>2]));c=c+1|0;if((c|0)==(m|0))break;else{z=n;n=f;q=p;p=o;o=z}}return}function yb(a,e,f,g){a=a|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=c[a+8>>2]|0;if((h|0)<=0)return;j=c[a+32>>2]|0;k=c[a+104>>2]|0;l=b[j>>1]|0;i=0;do{m=i;i=i+1|0;n=l;l=b[j+(i<<1)>>1]|0;c[e+(m<<2)>>2]=(N(N((l<<16>>16)-(n<<16>>16)<<f,g)|0,(d[k+((N(h,g+-1+(f<<1)|0)|0)+m)>>0]|0)+64|0)|0)>>2;h=c[a+8>>2]|0}while((i|0)<(h|0));return}function zb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=c[a+(b+-1<<2)>>2]|0;f=k>>>31;i=b+-1|0;k=(k|0)>-1?k:0-k|0;do{j=i;i=i+-1|0;h=b-i|0;f=(c[(c[12212+(((h|0)<(k|0)?h:k)<<2)>>2]|0)+(((h|0)>(k|0)?h:k)<<2)>>2]|0)+f|0;l=c[a+(i<<2)>>2]|0;k=((l|0)>-1?l:0-l|0)+k|0;g=k+1|0;if((l|0)<0)f=(c[(c[12212+(((h|0)>(k|0)?g:h)<<2)>>2]|0)+(((h|0)>(g|0)?h:g)<<2)>>2]|0)+f|0}while((j|0)>1);Db(e,f,(c[(c[12212+(((d+1|0)>(b|0)?b:d+1|0)<<2)>>2]|0)+(((d+1|0)<(b|0)?b:d+1|0)<<2)>>2]|0)+(c[(c[12212+(((b|0)<(d|0)?b:d)<<2)>>2]|0)+(((b|0)>(d|0)?b:d)<<2)>>2]|0)|0);return}function Ab(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,g=0,h=0,i=0,j=0,k=0,l=0,m=0.0;e=Da(e,(c[(c[12212+(((d+1|0)>(b|0)?b:d+1|0)<<2)>>2]|0)+(((d+1|0)<(b|0)?b:d+1|0)<<2)>>2]|0)+(c[(c[12212+(((b|0)<(d|0)?b:d)<<2)>>2]|0)+(((b|0)>(d|0)?b:d)<<2)>>2]|0)|0)|0;if((b|0)>2){k=b;l=a;f=0.0;while(1){j=d+1|0;do if((d|0)<(k|0)){g=c[(c[12212+(d<<2)>>2]|0)+(k<<2)>>2]|0;h=c[(c[12212+(j<<2)>>2]|0)+(k<<2)>>2]|0;if(e>>>0>=g>>>0&e>>>0<h>>>0){c[l>>2]=0;e=e-g|0;break}i=e>>>0>=h>>>0;h=e-(i?h:0)|0;while(1){g=d+-1|0;e=c[(c[12212+(g<<2)>>2]|0)+(k<<2)>>2]|0;if(h>>>0<e>>>0)d=g;else break}j=j+(i<<31>>31)-d^i<<31>>31;c[l>>2]=j<<16>>16;e=h-e|0;d=g;f=f+ +((j&65535)<<16>>16)*+((j&65535)<<16>>16)}else{h=c[12212+(k<<2)>>2]|0;i=c[h+(j<<2)>>2]|0;j=e>>>0>=i>>>0;i=e-(j?i:0)|0;if((c[h+(k<<2)>>2]|0)>>>0>i>>>0){e=k;do{e=e+-1|0;g=c[(c[12212+(e<<2)>>2]|0)+(k<<2)>>2]|0}while(g>>>0>i>>>0);h=e;e=g}else{g=d;while(1){e=c[h+(g<<2)>>2]|0;if(e>>>0>i>>>0)g=g+-1|0;else{h=g;break}}}j=(j<<31>>31)+d-h^j<<31>>31;c[l>>2]=j<<16>>16;e=i-e|0;d=h;f=f+ +((j&65535)<<16>>16)*+((j&65535)<<16>>16)}while(0);k=k+-1|0;if((k|0)<=2)break;else l=l+4|0}a=a+(b+-2<<2)|0}else f=0.0;k=d<<1|1;b=e>>>0>=k>>>0;k=e-(b?k:0)|0;l=k-(((k+1|0)>>>1|0)==0?0:((k+1|0)>>>1<<1)+-1|0)|0;b=(b<<31>>31)+d-((k+1|0)>>>1)^b<<31>>31;c[a>>2]=b<<16>>16;c[a+4>>2]=(((k+1|0)>>>1)-l^0-l)<<16>>16;m=+(((((k+1|0)>>>1)-l^0-l)&65535)<<16>>16);return +(f+ +((b&65535)<<16>>16)*+((b&65535)<<16>>16)+m*m)}function Bb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[b+28>>2]|0;if(!d)g=g-(N((g>>>0)/(f>>>0)|0,f-e|0)|0)|0;else{h=g-(N((g>>>0)/(f>>>0)|0,f-d|0)|0)|0;c[b+32>>2]=h+(c[b+32>>2]|0);g=N((g>>>0)/(f>>>0)|0,e-d|0)|0}c[b+28>>2]=g;if(g>>>0>=8388609)return;e=c[b+32>>2]|0;do{f=e>>>23;if((f|0)==255)c[b+36>>2]=(c[b+36>>2]|0)+1;else{d=e>>>31;g=c[b+40>>2]|0;if((g|0)>-1){e=c[b+24>>2]|0;if(((c[b+8>>2]|0)+e|0)>>>0<(c[b+4>>2]|0)>>>0){h=c[b>>2]|0;c[b+24>>2]=e+1;a[h+e>>0]=g+d;g=0}else g=-1;c[b+44>>2]=c[b+44>>2]|g}g=c[b+36>>2]|0;if(g|0)do{e=c[b+24>>2]|0;if(((c[b+8>>2]|0)+e|0)>>>0<(c[b+4>>2]|0)>>>0){g=c[b>>2]|0;c[b+24>>2]=e+1;a[g+e>>0]=d+255;g=c[b+36>>2]|0;e=0}else e=-1;c[b+44>>2]=c[b+44>>2]|e;g=g+-1|0;c[b+36>>2]=g}while((g|0)!=0);c[b+40>>2]=f&255;e=c[b+32>>2]|0;g=c[b+28>>2]|0}e=e<<8&2147483392;c[b+32>>2]=e;g=g<<8;c[b+28>>2]=g;c[b+20>>2]=(c[b+20>>2]|0)+8}while(g>>>0<8388609);return}function Cb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=c[b+28>>2]|0;if(d|0)c[b+32>>2]=(c[b+32>>2]|0)+(f-(f>>>e));f=d|0?f>>>e:f-(f>>>e)|0;c[b+28>>2]=f;if(f>>>0>=8388609)return;e=c[b+32>>2]|0;do{g=e>>>23;if((g|0)==255)c[b+36>>2]=(c[b+36>>2]|0)+1;else{d=e>>>31;f=c[b+40>>2]|0;if((f|0)>-1){e=c[b+24>>2]|0;if(((c[b+8>>2]|0)+e|0)>>>0<(c[b+4>>2]|0)>>>0){h=c[b>>2]|0;c[b+24>>2]=e+1;a[h+e>>0]=f+d;f=0}else f=-1;c[b+44>>2]=c[b+44>>2]|f}f=c[b+36>>2]|0;if(f|0)do{e=c[b+24>>2]|0;if(((c[b+8>>2]|0)+e|0)>>>0<(c[b+4>>2]|0)>>>0){f=c[b>>2]|0;c[b+24>>2]=e+1;a[f+e>>0]=d+255;f=c[b+36>>2]|0;e=0}else e=-1;c[b+44>>2]=c[b+44>>2]|e;f=f+-1|0;c[b+36>>2]=f}while((f|0)!=0);c[b+40>>2]=g&255;e=c[b+32>>2]|0;f=c[b+28>>2]|0}e=e<<8&2147483392;c[b+32>>2]=e;f=f<<8;c[b+28>>2]=f;c[b+20>>2]=(c[b+20>>2]|0)+8}while(f>>>0<8388609);return}function Db(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=32-(Q(e+-1|0)|0)|0;if((k|0)<=8){Bb(b,d,d+1|0,e);return}Bb(b,d>>>(k+-8|0),(d>>>(k+-8|0))+1|0,((e+-1|0)>>>(k+-8|0))+1|0);e=c[b+12>>2]|0;f=c[b+16>>2]|0;if((f+(k+-8)|0)>>>0>32){i=((7-f|0)>-8?7-f|0:-8)+f|0;j=f;do{g=c[b+8>>2]|0;h=c[b+4>>2]|0;if((g+(c[b+24>>2]|0)|0)>>>0<h>>>0){l=c[b>>2]|0;c[b+8>>2]=g+1;a[l+(h-(g+1))>>0]=e;g=0}else g=-1;c[b+44>>2]=c[b+44>>2]|g;e=e>>>8;j=j+-8|0}while((j|0)>7);f=f+-8-(i&-8)|0}c[b+12>>2]=((1<<k+-8)+-1&d)<<f|e;c[b+16>>2]=f+(k+-8);c[b+20>>2]=(c[b+20>>2]|0)+(k+-8);return}function Eb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=c[b+12>>2]|0;g=c[b+16>>2]|0;if((g+e|0)>>>0>32){j=g+((7-g|0)>-8?7-g|0:-8)&-8;k=g;do{h=c[b+8>>2]|0;i=c[b+4>>2]|0;if((h+(c[b+24>>2]|0)|0)>>>0<i>>>0){l=c[b>>2]|0;c[b+8>>2]=h+1;a[l+(i-(h+1))>>0]=f;h=0}else h=-1;c[b+44>>2]=c[b+44>>2]|h;f=f>>>8;k=k+-8|0}while((k|0)>7);g=g+-8-j|0}c[b+12>>2]=d<<g|f;c[b+16>>2]=g+e;c[b+20>>2]=(c[b+20>>2]|0)+e;return}function Fb(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,O=0,P=0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0,ea=0,fa=0;C=l;l=l+32|0;e=c[a+8>>2]|0;c[C>>2]=1;f=1;h=0;while(1){i=h<<1;A=b[a+12+((i|1)<<1)>>1]|0;f=N(f,b[a+12+(i<<1)>>1]|0)|0;i=h+1|0;c[C+(i<<2)>>2]=f;if(A<<16>>16==1)break;else h=i}A=(e|0)>0?e:0;if((h|0)<=-1){l=C;return}y=b[a+12+((i<<1)+-1<<1)>>1]|0;while(1){e=h<<1;if(!h)z=1;else z=b[a+12+(e+-1<<1)>>1]|0;a:do switch(b[a+12+(e<<1)>>1]|0){case 2:{e=c[C+(h<<2)>>2]|0;if((e|0)>0){f=d;i=0;while(1){u=f+32|0;x=+g[u>>2];y=f+36|0;j=+g[y>>2];w=+g[f>>2];g[u>>2]=w-x;u=f+4|0;v=+g[u>>2];g[y>>2]=v-j;g[f>>2]=x+w;g[u>>2]=j+v;u=f+40|0;v=+g[u>>2];y=f+44|0;j=+g[y>>2];t=f+8|0;w=+g[t>>2];g[u>>2]=w-(v+j)*.7071067690849304;u=f+12|0;x=+g[u>>2];g[y>>2]=x-(j-v)*.7071067690849304;g[t>>2]=w+(v+j)*.7071067690849304;g[u>>2]=(j-v)*.7071067690849304+x;u=f+52|0;x=+g[u>>2];t=f+48|0;v=+g[t>>2];y=f+16|0;j=+g[y>>2];g[t>>2]=j-x;t=f+20|0;w=+g[t>>2];g[u>>2]=v+w;g[y>>2]=x+j;g[t>>2]=w-v;t=f+60|0;v=+g[t>>2];y=f+56|0;w=+g[y>>2];u=f+24|0;j=+g[u>>2];g[y>>2]=j-(v-w)*.7071067690849304;y=f+28|0;x=+g[y>>2];g[t>>2]=x-(v+w)*-.7071067690849304;g[u>>2]=j+(v-w)*.7071067690849304;g[y>>2]=(v+w)*-.7071067690849304+x;i=i+1|0;if((i|0)==(e|0))break;else f=f+64|0}}break}case 4:{q=c[C+(h<<2)>>2]|0;if((y|0)==1){if((q|0)>0){e=d;f=0}else break a;while(1){G=+g[e>>2];o=e+16|0;F=+g[o>>2];r=e+4|0;j=+g[r>>2];p=e+20|0;v=+g[p>>2];s=e+8|0;w=+g[s>>2];u=e+24|0;x=+g[u>>2];t=e+12|0;E=+g[t>>2];y=e+28|0;D=+g[y>>2];g[o>>2]=G+F-(w+x);g[p>>2]=j+v-(E+D);g[e>>2]=G+F+(w+x);g[r>>2]=j+v+(E+D);g[s>>2]=G-F+(E-D);g[t>>2]=j-v-(w-x);g[u>>2]=G-F-(E-D);g[y>>2]=j-v+(w-x);f=f+1|0;if((f|0)==(q|0))break a;else e=e+32|0}}k=y<<1;m=y*3|0;if((q|0)>0?(B=c[a+48>>2]|0,(y|0)>0):0){f=0;do{e=d+((N(f,z)|0)<<3)|0;i=0;n=B;o=B;p=B;while(1){r=e+(y<<3)|0;j=+g[r>>2];v=+g[n>>2];s=e+(y<<3)+4|0;w=+g[s>>2];x=+g[n+4>>2];Q=e+(k<<3)|0;I=+g[Q>>2];K=+g[o>>2];P=e+(k<<3)+4|0;J=+g[P>>2];H=+g[o+4>>2];t=e+(m<<3)|0;D=+g[t>>2];E=+g[p>>2];u=e+(m<<3)+4|0;F=+g[u>>2];G=+g[p+4>>2];M=+g[e>>2];O=e+4|0;L=+g[O>>2];g[e>>2]=I*K-J*H+M;g[O>>2]=K*J+I*H+L;g[Q>>2]=I*K-J*H+M-(j*v-w*x+(D*E-F*G));g[P>>2]=K*J+I*H+L-(v*w+j*x+(E*F+D*G));g[e>>2]=j*v-w*x+(D*E-F*G)+ +g[e>>2];g[O>>2]=v*w+j*x+(E*F+D*G)+ +g[O>>2];g[r>>2]=M-(I*K-J*H)+(v*w+j*x-(E*F+D*G));g[s>>2]=L-(K*J+I*H)-(j*v-w*x-(D*E-F*G));g[t>>2]=M-(I*K-J*H)-(v*w+j*x-(E*F+D*G));g[u>>2]=L-(K*J+I*H)+(j*v-w*x-(D*E-F*G));i=i+1|0;if((i|0)==(y|0))break;else{e=e+8|0;n=n+(q<<A<<3)|0;o=o+(q<<A<<1<<3)|0;p=p+((q<<A)*3<<3)|0}}f=f+1|0}while((f|0)!=(q|0))}break}case 3:{e=c[C+(h<<2)>>2]|0;n=c[a+48>>2]|0;m=y<<1;j=+g[n+((N(e<<A,y)|0)<<3)+4>>2];if((e|0)>0){i=0;do{f=d+((N(i,z)|0)<<3)|0;k=y;o=n;p=n;while(1){P=f+(y<<3)|0;F=+g[P>>2];G=+g[o>>2];Q=f+(y<<3)+4|0;H=+g[Q>>2];I=+g[o+4>>2];u=f+(m<<3)|0;J=+g[u>>2];K=+g[p>>2];O=f+(m<<3)+4|0;L=+g[O>>2];M=+g[p+4>>2];g[P>>2]=+g[f>>2]-(F*G-H*I+(J*K-L*M))*.5;t=f+4|0;g[Q>>2]=+g[t>>2]-(G*H+F*I+(K*L+J*M))*.5;g[f>>2]=F*G-H*I+(J*K-L*M)+ +g[f>>2];g[t>>2]=G*H+F*I+(K*L+J*M)+ +g[t>>2];g[u>>2]=j*(G*H+F*I-(K*L+J*M))+ +g[P>>2];g[O>>2]=+g[Q>>2]-j*(F*G-H*I-(J*K-L*M));g[P>>2]=+g[P>>2]-j*(G*H+F*I-(K*L+J*M));g[Q>>2]=j*(F*G-H*I-(J*K-L*M))+ +g[Q>>2];k=k+-1|0;if(!k)break;else{f=f+8|0;o=o+(e<<A<<3)|0;p=p+(e<<A<<1<<3)|0}}i=i+1|0}while((i|0)!=(e|0))}break}case 5:{i=c[C+(h<<2)>>2]|0;u=c[a+48>>2]|0;Q=N(i<<A,y)|0;j=+g[u+(Q<<3)>>2];v=+g[u+(Q<<3)+4>>2];Q=N(i<<A<<1,y)|0;w=+g[u+(Q<<3)>>2];x=+g[u+(Q<<3)+4>>2];if((i|0)>0){t=y<<1;r=y*3|0;s=y<<2;p=(y|0)>0;q=0;do{e=d+((N(q,z)|0)<<3)|0;if(p){k=e;m=e+(y<<3)|0;n=e+(t<<3)|0;o=e+(r<<3)|0;e=e+(s<<3)|0;f=0;while(1){F=+g[k>>2];ea=k+4|0;J=+g[ea>>2];ba=+g[m>>2];fa=N(f,i<<A)|0;aa=+g[u+(fa<<3)>>2];da=m+4|0;$=+g[da>>2];_=+g[u+(fa<<3)+4>>2];V=+g[n>>2];fa=N(f<<1,i<<A)|0;U=+g[u+(fa<<3)>>2];P=n+4|0;T=+g[P>>2];S=+g[u+(fa<<3)+4>>2];R=+g[o>>2];fa=N((i<<A)*3|0,f)|0;D=+g[u+(fa<<3)>>2];Q=o+4|0;E=+g[Q>>2];M=+g[u+(fa<<3)+4>>2];Z=+g[e>>2];fa=N(f<<2,i<<A)|0;Y=+g[u+(fa<<3)>>2];O=e+4|0;X=+g[O>>2];W=+g[u+(fa<<3)+4>>2];H=ba*aa-$*_+(Z*Y-X*W);L=aa*$+ba*_+(Y*X+Z*W);G=V*U-T*S+(R*D-E*M);K=U*T+V*S+(D*E+R*M);g[k>>2]=F+(G+H);g[ea>>2]=J+(K+L);ca=x*(U*T+V*S-(D*E+R*M))+v*(aa*$+ba*_-(Y*X+Z*W));I=x*(V*U-T*S-(R*D-E*M))+v*(ba*aa-$*_-(Z*Y-X*W));g[m>>2]=F+(w*G+j*H)-ca;g[da>>2]=I+(J+(w*K+j*L));g[e>>2]=ca+(F+(w*G+j*H));g[O>>2]=J+(w*K+j*L)-I;I=v*(U*T+V*S-(D*E+R*M))-x*(aa*$+ba*_-(Y*X+Z*W));M=x*(ba*aa-$*_-(Z*Y-X*W))-v*(V*U-T*S-(R*D-E*M));g[n>>2]=I+(F+(j*G+w*H));g[P>>2]=M+(J+(j*K+w*L));g[o>>2]=F+(j*G+w*H)-I;g[Q>>2]=J+(j*K+w*L)-M;f=f+1|0;if((f|0)==(y|0))break;else{k=k+8|0;m=m+8|0;n=n+8|0;o=o+8|0;e=e+8|0}}}q=q+1|0}while((q|0)!=(i|0))}break}default:{}}while(0);if((h|0)>0){h=h+-1|0;y=z}else break}l=C;return}function Gb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;h=za(a,15)|0;if(h>>>0<b>>>0){c=0;h=b;i=0;h=h+c|0;g=h>>>0<32768;h=g?h:32768;Aa(a,c,h,32768);return i|0}d=(N(16384-c|0,32736-b|0)|0)>>>15;a:do if(!d){d=d+1|0;e=1;i=5}else{f=b;d=d+1|0;e=1;while(1){g=d<<1;b=g+f|0;if(h>>>0<b>>>0){b=e;break a}e=e+1|0;d=(N(g+-2|0,c)|0)>>>15;if(!d){d=d+1|0;i=5;break}else{f=b;d=d+1|0}}}while(0);if((i|0)==5){i=(h-b|0)>>>1;f=(i<<1)+b|0;b=i+e|0}i=f+d|0;c=h>>>0<i>>>0?f:i;g=d;i=h>>>0<i>>>0?0-b|0:b;h=g+c|0;g=h>>>0<32768;h=g?h:32768;Aa(a,c,h,32768);return i|0}function Hb(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;c=31-(Q(a|0)|0)>>1;b=1<<c;e=0;while(1){f=(e<<1)+b<<c;d=a>>>0<f>>>0;e=(d?0:b)+e|0;if((c|0)<=0)break;else{a=a-(d?0:f)|0;b=b>>>1;c=c+-1|0}}return e|0}function Ib(a){a=a|0;wc(a+4|0,0,4260)|0;c[a+2376>>2]=1;c[a>>2]=65536;c[a+4168>>2]=0;gc(a);Qb(a);return 0}function Jb(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,m=0,n=0,o=0;n=l;l=l+144|0;j=c[b+2328>>2]|0;c[n+136>>2]=0;switch(g|0){case 0:{k=b+2388|0;m=4;break}case 2:{if((c[b+2420+(c[b+2388>>2]<<2)>>2]|0)==1){k=b+2388|0;m=4}else m=5;break}default:m=5}if((m|0)==4){m=Z()|0;o=l;l=l+((1*((j+15&-16)<<1)|0)+15&-16)|0;Lb(b,d,c[k>>2]|0,g,h);Mb(d,o,a[b+2765>>0]|0,a[b+2766>>0]|0,c[b+2328>>2]|0);Kb(b,n,h);jc(b,n,e,o,i);Rb(b,n,e,0,i);c[b+4160>>2]=0;c[b+4164>>2]=a[b+2765>>0];c[b+2376>>2]=0;W(m|0)}else if((m|0)==5){a[b+2765>>0]=c[b+4164>>2];Rb(b,n,e,1,i)}m=c[b+2328>>2]|0;o=(c[b+2336>>2]|0)-m|0;Ac(b+1348|0,b+1348+(m<<1)|0,o<<1|0)|0;zc(b+1348+(o<<1)|0,e|0,c[b+2328>>2]<<1|0)|0;hc(b,n,e,j);Ub(b,e,j);c[b+2308>>2]=c[n+((c[b+2324>>2]|0)+-1<<2)>>2];c[f>>2]=j;l=n;return 0}function Kb(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;j=l;l=l+64|0;Ob(e+16|0,d+2736|0,d+2312|0,(f|0)==2&1,c[d+2324>>2]|0);Pb(j+32|0,d+2744|0,c[d+2732>>2]|0);ac(e+64|0,j+32|0,c[d+2340>>2]|0,c[d+4168>>2]|0);if((c[d+2376>>2]|0)!=1){f=a[d+2767>>0]|0;if(f<<24>>24<4){g=c[d+2340>>2]|0;if((g|0)>0){h=0;do{k=b[d+2344+(h<<1)>>1]|0;b[j+(h<<1)>>1]=((N((b[j+32+(h<<1)>>1]|0)-k|0,f<<24>>24)|0)>>>2)+k;h=h+1|0}while((h|0)<(g|0))}ac(e+32|0,j,g,c[d+4168>>2]|0)}else i=7}else{a[d+2767>>0]=4;i=7}if((i|0)==7)zc(e+32|0,e+64|0,c[d+2340>>2]<<1|0)|0;f=c[d+2340>>2]|0;zc(d+2344|0,j+32|0,f<<1|0)|0;if(c[d+4160>>2]|0){Xb(e+32|0,f,63570);Xb(e+64|0,c[d+2340>>2]|0,63570)}if((a[d+2765>>0]|0)!=2){wc(e|0,0,c[d+2324>>2]<<2|0)|0;wc(e+96|0,0,(c[d+2324>>2]|0)*10|0)|0;a[d+2768>>0]=0;d=0;k=e+136|0;c[k>>2]=d;l=j;return}Yb(b[d+2762>>1]|0,a[d+2764>>0]|0,e,c[d+2316>>2]|0,c[d+2324>>2]|0);f=c[17372+(a[d+2768>>0]<<2)>>2]|0;g=c[d+2324>>2]|0;if((g|0)>0){h=0;do{i=(a[d+2740+h>>0]|0)*5|0;k=h*5|0;b[e+96+(k<<1)>>1]=a[f+i>>0]<<7;b[e+96+(k+1<<1)>>1]=a[f+(i+1)>>0]<<7;b[e+96+(k+2<<1)>>1]=a[f+(i+2)>>0]<<7;b[e+96+(k+3<<1)>>1]=a[f+(i+3)>>0]<<7;b[e+96+(k+4<<1)>>1]=a[f+(i+4)>>0]<<7;h=h+1|0}while((h|0)<(g|0))}d=b[19844+(a[d+2769>>0]<<1)>>1]|0;k=e+136|0;c[k>>2]=d;l=j;return}function Lb(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,m=0;m=l;l=l+48|0;if((i|0)==0?(c[f+2404+(h<<2)>>2]|0)==0:0)h=Ca(g,23416,8)|0;else h=(Ca(g,23412,8)|0)+2|0;i=h>>>1;a[f+2765>>0]=i;a[f+2766>>0]=h&1;if((j|0)==2)a[f+2736>>0]=Ca(g,23574,8)|0;else{a[f+2736>>0]=(Ca(g,23550+(i<<24>>24<<3)|0,8)|0)<<3;i=Ca(g,23441,8)|0;a[f+2736>>0]=(d[f+2736>>0]|0)+i}if((c[f+2324>>2]|0)>1){h=1;do{a[f+2736+h>>0]=Ca(g,23574,8)|0;h=h+1|0}while((h|0)<(c[f+2324>>2]|0))}h=c[f+2732>>2]|0;h=Ca(g,(c[h+16>>2]|0)+(N(a[f+2765>>0]>>1,b[h>>1]|0)|0)|0,8)|0;a[f+2744>>0]=h;Wb(m,m+32|0,c[f+2732>>2]|0,h<<24>>24);h=c[f+2732>>2]|0;a:do if((b[h+2>>1]|0)>0){i=0;while(1){h=Ca(g,(c[h+28>>2]|0)+(b[m+(i<<1)>>1]|0)|0,8)|0;switch(h|0){case 0:{h=0-(Ca(g,23449,8)|0)|0;break}case 8:{h=(Ca(g,23449,8)|0)+8|0;break}default:{}}i=i+1|0;a[f+2744+i>>0]=h+252;h=c[f+2732>>2]|0;if((i|0)>=(b[h+2>>1]|0))break a}}while(0);if((c[f+2324>>2]|0)==4)h=(Ca(g,23418,8)|0)&255;else h=4;a[f+2767>>0]=h;h=a[f+2765>>0]|0;if(h<<24>>24!=2){k=h;k=k<<24>>24;j=f+2396|0;c[j>>2]=k;j=Ca(g,23426,8)|0;j=j&255;g=f+2770|0;a[g>>0]=j;l=m;return}if(((j|0)==2?(c[f+2396>>2]|0)==2:0)?(k=Ca(g,25698,8)|0,(k<<16|0)>0):0){h=k+65527+(e[f+2400>>1]|0)&65535;b[f+2762>>1]=h;i=f+2400|0}else{h=(Ca(g,25666,8)|0)<<16>>16;b[f+2762>>1]=N(h,c[f+2316>>2]>>1)|0;h=Ca(g,c[f+2380>>2]|0,8)|0;h=(e[f+2762>>1]|0)+h&65535;b[f+2762>>1]=h;i=f+2400|0}b[i>>1]=h;a[f+2764>>0]=Ca(g,c[f+2384>>2]|0,8)|0;h=Ca(g,23615,8)|0;a[f+2768>>0]=h;if((c[f+2324>>2]|0)>0?(a[f+2740>>0]=Ca(g,c[17360+(h<<24>>24<<2)>>2]|0,8)|0,(c[f+2324>>2]|0)>1):0){h=1;do{a[f+2740+h>>0]=Ca(g,c[17360+(a[f+2768>>0]<<2)>>2]|0,8)|0;h=h+1|0}while((h|0)<(c[f+2324>>2]|0))}if(!j)h=(Ca(g,23409,8)|0)&255;else h=0;a[f+2769>>0]=h;k=a[f+2765>>0]|0;k=k<<24>>24;j=f+2396|0;c[j>>2]=k;j=Ca(g,23426,8)|0;j=j&255;g=f+2770|0;a[g>>0]=j;l=m;return}function Mb(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0;p=l;l=l+160|0;i=25779+((Ca(a,25959+((e>>1)*9|0)|0,8)|0)*18|0)|0;n=(((g>>4<<4|0)<(g|0)&1)+(g>>4)|0)>0;if(n)m=0;else{ic(a,d,g,e,f,p+80|0);l=p;return}do{k=p+(m<<2)|0;c[k>>2]=0;o=Ca(a,i,8)|0;j=p+80+(m<<2)|0;c[j>>2]=o;if((o|0)==17){h=0;do{h=h+1|0;c[k>>2]=h;o=Ca(a,25941+((h|0)==10&1)|0,8)|0;c[j>>2]=o}while((o|0)==17)}m=m+1|0}while((m|0)!=(((g>>4<<4|0)<(g|0)&1)+(g>>4)|0));if(n)j=0;else{ic(a,d,g,e,f,p+80|0);l=p;return}do{h=c[p+80+(j<<2)>>2]|0;i=d+(j<<16>>12<<1)|0;if((h|0)>0)Vb(i,a,h);else{h=i+32|0;do{b[i>>1]=0;i=i+2|0}while((i|0)<(h|0))}j=j+1|0}while((j|0)!=(((g>>4<<4|0)<(g|0)&1)+(g>>4)|0));if(n)m=0;else{ic(a,d,g,e,f,p+80|0);l=p;return}do{h=c[p+(m<<2)>>2]|0;if((h|0)>0){j=d+(m<<16>>12<<1)|0;o=0;do{k=j+(o<<1)|0;i=b[k>>1]|0;n=0;do{i=(Ca(a,23407,8)|0)+(i<<1)|0;n=n+1|0}while((n|0)!=(h|0));b[k>>1]=i;o=o+1|0}while((o|0)!=16);o=p+80+(m<<2)|0;c[o>>2]=c[o>>2]|h<<5}m=m+1|0}while((m|0)!=(((g>>4<<4|0)<(g|0)&1)+(g>>4)|0));ic(a,d,g,e,f,p+80|0);l=p;return}function Nb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;c[b+2332>>2]=(d<<16>>16)*5;h=N(c[b+2324>>2]<<16>>16,(d<<16>>16)*327680>>16)|0;if((c[b+2316>>2]|0)==(d|0)?(c[b+2320>>2]|0)==(e|0):0){e=0;i=4}else{f=bb(b+2432|0,(d<<16>>16)*1e3|0,e,0)|0;c[b+2320>>2]=e;if((c[b+2316>>2]|0)==(d|0)){e=f;i=4}else g=1}if((i|0)==4)if((h|0)==(c[b+2328>>2]|0)){i=e;return i|0}else{g=0;f=e}e=(c[b+2324>>2]|0)==4;c[b+2384>>2]=(d|0)==8?(e?25753:25776):e?25719:25764;if(g){c[b+2336>>2]=(d<<16>>16)*20;c[b+2340>>2]=(d|4|0)==12?10:16;c[b+2732>>2]=(d|4|0)==12?17384:17424;switch(d|0){case 16:{e=23441;i=9;break}case 12:{e=23435;i=9;break}default:if((d|0)==8){e=23426;i=9}}if((i|0)==9)c[b+2380>>2]=e;c[b+2376>>2]=1;c[b+2308>>2]=100;a[b+2312>>0]=10;c[b+4164>>2]=0;wc(b+1284|0,0,1024)|0}c[b+2316>>2]=d;c[b+2328>>2]=h;i=f;return i|0}function Ob(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;if((g|0)>0)i=0;else return;do{h=a[d+i>>0]|0;if(!(i|f)){j=(a[e>>0]|0)+-16|0;h=(h|0)>(j|0)?h:j}else{j=a[e>>0]|0;h=((h+-4|0)>(j+8|0)?(h+-4<<1)-(j+8)|0:h+-4|0)+j|0}j=h<<24;j=(j|0)>1056964608?63:(j|0)<0?0:j>>24;a[e>>0]=j;c[b+(i<<2)>>2]=Zb(((j*29|0)+2090+(j*7281>>16)|0)<3967?(j*29|0)+2090+(j*7281>>16)|0:3967)|0;i=i+1|0}while((i|0)!=(g|0));return}function Pb(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,m=0,n=0,o=0;o=l;l=l+80|0;Wb(o+32|0,o+64|0,g,a[f>>0]|0);n=b[g+2>>1]|0;if(n<<16>>16>0){j=b[g+4>>1]|0;k=n<<16>>16;h=0;do{m=k;k=k+-1|0;i=(N(d[o+64+k>>0]|0,h<<16>>16)|0)>>8;h=a[f+1+k>>0]|0;if(h<<24>>24>0)h=(h<<24>>24<<10)+-102|0;else h=h<<24>>24?h<<24>>24<<10|102:h<<24>>24<<10;h=(N(h>>16,j)|0)+i+((N(h&65535,j)|0)>>16)|0;b[o+(k<<1)>>1]=h}while((m|0)>1);h=n<<16>>16}else h=n<<16>>16;k=N(h,a[f>>0]|0)|0;j=(c[g+8>>2]|0)+k|0;k=(c[g+12>>2]|0)+(k<<1)|0;if(n<<16>>16>0)i=0;else{n=h;g=g+36|0;g=c[g>>2]|0;bc(e,g,n);l=o;return}do{h=(d[j+i>>0]<<7)+((b[o+(i<<1)>>1]<<14|0)/(b[k+(i<<1)>>1]|0)|0)|0;b[e+(i<<1)>>1]=(h|0)>32767?32767:((h|0)>0?h:0)&65535;i=i+1|0;h=b[g+2>>1]|0}while((i|0)<(h|0));g=g+36|0;g=c[g>>2]|0;bc(e,g,h);l=o;return}function Qb(a){a=a|0;c[a+4172>>2]=c[a+2328>>2]<<7;c[a+4244>>2]=65536;c[a+4248>>2]=65536;c[a+4260>>2]=20;c[a+4256>>2]=2;return}function Rb(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;i=c[d+2316>>2]|0;if((i|0)!=(c[d+4252>>2]|0)){c[d+4172>>2]=c[d+2328>>2]<<7;c[d+4244>>2]=65536;c[d+4248>>2]=65536;c[d+4260>>2]=20;c[d+4256>>2]=2;c[d+4252>>2]=i}if(g|0){Sb(d,e,f,h);c[d+4160>>2]=(c[d+4160>>2]|0)+1;return}k=a[d+2765>>0]|0;c[d+4164>>2]=k<<24>>24;do if(k<<24>>24==2){i=c[d+2324>>2]|0;h=c[e+(i+-1<<2)>>2]|0;if((i|0)==0|(h|0)<1)h=0;else{f=0;j=0;k=0;while(1){g=(i+-1-k|0)*5|0;g=(b[e+96+(g+1<<1)>>1]|0)+(b[e+96+(g<<1)>>1]|0)+(b[e+96+(g+2<<1)>>1]|0)+(b[e+96+(g+3<<1)>>1]|0)+(b[e+96+(g+4<<1)>>1]|0)|0;if((g|0)>(f|0)){h=e+96+((i+65535+j<<16>>16)*5<<1)|0;b[d+4176>>1]=b[h>>1]|0;b[d+4176+2>>1]=b[h+2>>1]|0;b[d+4176+4>>1]=b[h+4>>1]|0;b[d+4176+6>>1]=b[h+6>>1]|0;b[d+4176+8>>1]=b[h+8>>1]|0;c[d+4172>>2]=c[e+(i+-1+j<<2)>>2]<<8;h=c[e+(i+-1<<2)>>2]|0;f=g}g=k+1|0;if((g|0)==(i|0)?1:(N(c[d+2332>>2]|0,g)|0)>=(h|0)){h=f;break}else{j=~k;k=g}}}c[d+4176>>2]=0;c[d+4176+4>>2]=0;b[d+4176+8>>1]=0;b[d+4180>>1]=h;if((h|0)<11469){b[d+4176>>1]=0;b[d+4178>>1]=0;b[d+4180>>1]=(N((11744256/(((h|0)>1?h:1)>>>0)|0)<<16>>16,h<<16>>16)|0)>>>10;b[d+4182>>1]=0;b[d+4184>>1]=0;h=d+2332|0;break}if((h|0)>15565){b[d+4176>>1]=0;b[d+4178>>1]=0;b[d+4180>>1]=(N((255016960/(h>>>0)|0)<<16>>16,h<<16>>16)|0)>>>14;b[d+4182>>1]=0;b[d+4184>>1]=0;h=d+2332|0}else h=d+2332|0}else{c[d+4172>>2]=(i<<16>>16)*4608;c[d+4176>>2]=0;c[d+4176+4>>2]=0;b[d+4176+8>>1]=0;i=c[d+2324>>2]|0;h=d+2332|0}while(0);zc(d+4186|0,e+64|0,c[d+2340>>2]<<1|0)|0;b[d+4240>>1]=c[e+136>>2];k=e+16+(i+-2<<2)|0;e=c[k+4>>2]|0;c[d+4244>>2]=c[k>>2];c[d+4244+4>>2]=e;c[d+4260>>2]=c[h>>2];c[d+4256>>2]=i;return}function Sb(d,f,g,h){d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,X=0,Y=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;K=l;l=l+64|0;p=(c[d+2328>>2]|0)+(c[d+2336>>2]|0)|0;H=Z()|0;J=l;l=l+((1*(p<<2)|0)+15&-16)|0;p=l;l=l+((1*(c[d+2336>>2]<<1)|0)+15&-16)|0;c[K>>2]=c[d+4244>>2]>>6;I=c[d+4248>>2]|0;c[K+4>>2]=I>>6;if(c[d+2376>>2]|0){j=d+4186|0;m=j+32|0;do{b[j>>1]=0;j=j+2|0}while((j|0)<(m|0))}Tb(K+12|0,K+20|0,K+8|0,K+16|0,d+4|0,K,c[d+2332>>2]|0,c[d+2324>>2]|0);z=(N((((c[K+12>>2]>>c[K+16>>2]|0)<(c[K+8>>2]>>c[K+20>>2]|0))<<31>>31)+(c[d+4256>>2]|0)|0,c[d+4260>>2]|0)|0)+-128|0;z=d+4+(((z|0)>0?z:0)<<2)|0;k=b[d+4228>>1]|0;j=c[d+4160>>2]|0;j=(j|0)<1?j:1;y=b[20208+(j<<1)>>1]|0;j=b[((c[d+4164>>2]|0)==2?20212:20216)+(j<<1)>>1]|0;Xb(d+4186|0,c[d+2340>>2]|0,64881);i=c[d+2340>>2]|0;zc(K+24|0,d+4186|0,i<<1|0)|0;do if(!(c[d+4160>>2]|0))if((c[d+4164>>2]|0)==2){F=16384-(e[d+4176>>1]|0)-(e[d+4178>>1]|0)-(e[d+4180>>1]|0)|0;G=e[d+4182>>1]|0;k=e[d+4184>>1]|0;k=(N(b[d+4240>>1]|0,(F-G-k&65535)<<16>>16>3277?F-G-k&65535:3277)|0)>>>14&65535;break}else{i=$b(d+4186|0,i)|0;i=(i|0)<134217728?i:134217728;i=((i|0)>4194304?i:4194304)<<3;j=((N(i&65528,j)|0)>>16)+(N(i>>16,j)|0)>>14;i=c[d+2340>>2]|0;k=16384;break}while(0);r=c[d+4224>>2]|0;o=(c[d+4172>>2]>>7)+1>>1;q=c[d+2336>>2]|0;n=q+-2-i-o|0;_b(p+(n<<1)|0,d+1348+(n<<1)|0,K+24|0,q-n|0,i,h);F=c[d+4248>>2]|0;i=Q(((F|0)>0?F:0-F|0)|0)|0;m=(536870911/(F<<i+-1>>16|0)|0)<<16;G=536870912-(N(F<<i+-1>>16,m>>16)|0)-((N(F<<i+-1&65535,m>>16)|0)>>16)<<3;m=(N(G,((536870911/(F<<i+-1>>16|0)|0)>>15)+1>>1)|0)+m+(N(G>>16,m>>16)|0)+((N(G&65528,m>>16)|0)>>16)|0;if((62-i+-46|0)<1){G=-2147483648>>46-(62-i);E=2147483647>>>(46-(62-i)|0);F=(G|0)>(E|0)?G:E;G=(G|0)>(E|0)?E:G;i=((m|0)>(F|0)?F:(m|0)<(G|0)?G:m)<<46-(62-i)}else i=(62-i+-46|0)<32?m>>62-i+-46:0;m=(i|0)<1073741823?i:1073741823;F=c[d+2340>>2]|0;G=c[d+2336>>2]|0;if((F+n|0)<(G|0)){i=F+n|0;do{E=b[p+(i<<1)>>1]|0;c[J+(i<<2)>>2]=((N(E,m&65535)|0)>>16)+(N(E,m>>16)|0);i=i+1|0}while((i|0)<(G|0))}x=c[d+2324>>2]|0;if((x|0)>0){v=j<<16>>16;u=c[d+2332>>2]|0;w=0;m=r;i=q;while(1){if((u|0)>0){j=k<<16>>16;p=b[d+4176>>1]|0;s=b[d+4178>>1]|0;q=b[d+4180>>1]|0;t=b[d+4182>>1]|0;n=b[d+4184>>1]|0;r=0;h=J+(i+2-o<<2)|0;while(1){P=c[h>>2]|0;R=N(p<<16>>16,P>>16)|0;P=(N(p<<16>>16,P&65535)|0)>>16;M=c[h+-4>>2]|0;O=N(s<<16>>16,M>>16)|0;M=(N(s<<16>>16,M&65535)|0)>>16;o=c[h+-8>>2]|0;L=N(q<<16>>16,o>>16)|0;o=(N(q<<16>>16,o&65535)|0)>>16;B=c[h+-12>>2]|0;A=N(t<<16>>16,B>>16)|0;B=(N(t<<16>>16,B&65535)|0)>>16;D=c[h+-16>>2]|0;C=N(n<<16>>16,D>>16)|0;D=(N(n<<16>>16,D&65535)|0)>>16;m=(N(m,196314165)|0)+907633515|0;E=c[z+(m>>>25<<2)>>2]|0;c[J+(i<<2)>>2]=R+2+P+O+M+L+o+A+B+C+D+(N(E>>16,j)|0)+((N(E&65535,j)|0)>>16)<<2;i=i+1|0;r=r+1|0;if((r|0)>=(u|0)){o=t;h=i;break}else h=h+4|0}}else{p=b[d+4176>>1]|0;s=b[d+4178>>1]|0;q=b[d+4180>>1]|0;o=b[d+4182>>1]|0;n=b[d+4184>>1]|0;j=k<<16>>16;h=i}b[d+4176>>1]=(N(p<<16>>16,y)|0)>>>15;b[d+4178>>1]=(N(s<<16>>16,y)|0)>>>15;b[d+4180>>1]=(N(q<<16>>16,y)|0)>>>15;b[d+4182>>1]=(N(o<<16>>16,y)|0)>>>15;b[d+4184>>1]=(N(n<<16>>16,y)|0)>>>15;R=(N(j,v)|0)>>>15&65535;k=(a[d+2765>>0]|0)==0?k:R;R=c[d+4172>>2]|0;i=(c[d+2316>>2]<<16>>16)*4608|0;i=(((R>>16)*655|0)+R+(((R&65535)*655|0)>>>16)|0)<(i|0)?((R>>16)*655|0)+R+(((R&65535)*655|0)>>>16)|0:i;c[d+4172>>2]=i;w=w+1|0;if((w|0)>=(x|0)){o=(i>>7)+1>>1;r=m;break}else{o=(i>>7)+1>>1;i=h}}}j=J+(G+-16<<2)|0;i=d+1284|0;m=j+64|0;do{c[j>>2]=c[i>>2];j=j+4|0;i=i+4|0}while((j|0)<(m|0));h=c[d+2328>>2]|0;if((h|0)<=0){i=J+(G+-16<<2)+(h<<2)|0;j=d+1284|0;m=j+64|0;do{c[j>>2]=c[i>>2];j=j+4|0;i=i+4|0}while((j|0)<(m|0));c[d+4224>>2]=r;b[d+4228>>1]=k;c[f>>2]=o;R=f+4|0;c[R>>2]=o;R=f+8|0;c[R>>2]=o;R=f+12|0;c[R>>2]=o;W(H|0);l=K;return}u=b[K+24>>1]|0;v=b[K+24+2>>1]|0;w=b[K+24+4>>1]|0;x=b[K+24+6>>1]|0;y=b[K+24+8>>1]|0;z=b[K+24+10>>1]|0;A=b[K+24+12>>1]|0;B=b[K+24+14>>1]|0;C=b[K+24+16>>1]|0;D=b[K+24+18>>1]|0;i=c[J+(G+-16<<2)+60>>2]|0;n=c[J+(G+-16<<2)+52>>2]|0;p=c[J+(G+-16<<2)+44>>2]|0;q=c[J+(G+-16<<2)+36>>2]|0;s=c[J+(G+-16<<2)+28>>2]|0;E=0;do{t=E+16|0;m=E+15|0;da=N(u,i>>16)|0;ca=(N(u,i&65535)|0)>>16;_=n;n=c[J+(G+-16<<2)+(E+14<<2)>>2]|0;ba=N(v,n>>16)|0;aa=(N(v,n&65535)|0)>>16;$=N(w,_>>16)|0;_=(N(w,_&65535)|0)>>16;U=p;p=c[J+(G+-16<<2)+(E+12<<2)>>2]|0;Y=N(x,p>>16)|0;X=(N(x,p&65535)|0)>>16;V=N(y,U>>16)|0;U=(N(y,U&65535)|0)>>16;L=q;q=c[J+(G+-16<<2)+(E+10<<2)>>2]|0;T=N(z,q>>16)|0;S=(N(z,q&65535)|0)>>16;j=N(A,L>>16)|0;L=(N(A,L&65535)|0)>>16;R=s;s=c[J+(G+-16<<2)+(E+8<<2)>>2]|0;M=N(B,s>>16)|0;O=(N(B,s&65535)|0)>>16;P=N(C,R>>16)|0;R=(N(C,R&65535)|0)>>16;i=c[J+(G+-16<<2)+(E+6<<2)>>2]|0;i=da+(F>>1)+ca+ba+aa+$+_+Y+X+V+U+T+S+j+L+M+O+P+R+(N(D,i>>16)|0)+((N(D,i&65535)|0)>>16)|0;if((F|0)>10){j=10;do{da=c[J+(G+-16<<2)+(m-j<<2)>>2]|0;ca=b[K+24+(j<<1)>>1]|0;i=(N(ca,da>>16)|0)+i+((N(ca,da&65535)|0)>>16)|0;j=j+1|0}while((j|0)!=(F|0))}j=c[J+(G+-16<<2)+(t<<2)>>2]|0;i=(i|0)>134217727?2147483632:((i|0)>-134217728?i:-134217728)<<4;if((j+i|0)>-1)i=(j&i|0)<0?-2147483648:j+i|0;else i=(j|i|0)>-1?2147483647:j+i|0;c[J+(G+-16<<2)+(t<<2)>>2]=i;ca=(((N(I>>6<<16>>16,i&65535)|0)>>16)+(N(I>>6<<16>>16,i>>16)|0)+(N((I>>21)+1>>1,i)|0)>>7)+1>>1;da=(ca|0)>-32768?ca:-32768;b[g+(E<<1)>>1]=(ca|0)>32767|(da|0)>32767&((ca|0)>32767^1)?32767:da&65535;E=E+1|0}while((E|0)<(h|0));i=J+(G+-16<<2)+(h<<2)|0;j=d+1284|0;m=j+64|0;do{c[j>>2]=c[i>>2];j=j+4|0;i=i+4|0}while((j|0)<(m|0));c[d+4224>>2]=r;b[d+4228>>1]=k;c[f>>2]=o;da=f+4|0;c[da>>2]=o;da=f+8|0;c[da>>2]=o;da=f+12|0;c[da>>2]=o;W(H|0);l=K;return}function Tb(a,d,e,f,g,h,i,j){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,m=0,n=0,o=0,p=0,q=0;p=l;o=l;l=l+((1*(i<<1<<1)|0)+15&-16)|0;if((i|0)<=0){g=o+(i<<1)|0;ec(a,d,o,i);ec(e,f,g,i);l=p;return}n=N(j+-2|0,i)|0;k=c[h>>2]|0;m=0;do{q=c[g+(m+n<<2)>>2]|0;q=((N(k<<16>>16,q&65535)|0)>>16)+(N(k<<16>>16,q>>16)|0)+(N((k>>15)+1>>1,q)|0)>>8;b[o+(m<<1)>>1]=(q|0)>32767?32767:((q|0)>-32768?q:-32768)&65535;m=m+1|0}while((m|0)!=(i|0));n=N(j+-1|0,i)|0;k=c[h+4>>2]|0;m=0;do{q=c[g+(m+n<<2)>>2]|0;q=((N(k<<16>>16,q&65535)|0)>>16)+(N(k<<16>>16,q>>16)|0)+(N((k>>15)+1>>1,q)|0)>>8;b[o+(i<<1)+(m<<1)>>1]=(q|0)>32767?32767:((q|0)>-32768?q:-32768)&65535;m=m+1|0}while((m|0)!=(i|0));k=o+(i<<1)|0;ec(a,d,o,i);ec(e,f,k,i);l=p;return}function Ub(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;i=l;l=l+16|0;if(c[a+4160>>2]|0){ec(a+4232|0,a+4236|0,d,e);e=1;a=a+4220|0;c[a>>2]=e;l=i;return}if(!(c[a+4220>>2]|0)){e=0;a=a+4220|0;c[a>>2]=e;l=i;return}ec(i,i+4|0,d,e);f=c[i+4>>2]|0;g=c[a+4236>>2]|0;if((f|0)<=(g|0)){if((f|0)<(g|0))c[i>>2]=c[i>>2]>>g-f}else c[a+4232>>2]=c[a+4232>>2]>>f-g;f=c[i>>2]|0;g=c[a+4232>>2]|0;if((f|0)<=(g|0)){e=0;a=a+4220|0;c[a>>2]=e;l=i;return}h=Q(g|0)|0;c[a+4232>>2]=g<<h+-1;f=f>>((25-h|0)>0?25-h|0:0);c[i>>2]=f;f=(g<<h+-1|0)/(((f|0)>1?f:1)|0)|0;if((f|0)<1)f=0;else{g=Q(f|0)|0;do if(24-g|0)if((24-g|0)<0){f=f>>>(24-g+32|0)|f<<0-(24-g);break}else{f=f<<32-(24-g)|f>>>(24-g|0);break}while(0);h=((g&1|0)==0?46214:32768)>>>(g>>>1);f=(N(f&127,13959168)|0)>>>16;f=(N(f,h>>16)|0)+h+((N(f,h&65535)|0)>>>16)<<4}h=((65536-f|0)/(e|0)|0)<<2;if((e|0)>0)g=0;else{e=0;a=a+4220|0;c[a>>2]=e;l=i;return}do{j=d+(g<<1)|0;k=b[j>>1]|0;b[j>>1]=((N(k,f&65532)|0)>>>16)+(N(k,f>>16)|0);f=f+h|0;g=g+1|0}while((f|0)<65537&(g|0)<(e|0));g=0;f=a+4220|0;c[f>>2]=g;l=i;return}function Vb(a,c,e){a=a|0;c=c|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if((e|0)>0){g=Ca(c,26433+(d[26585+e>>0]|0)|0,8)|0;if((g<<16|0)>0){h=Ca(c,26281+(d[26585+(g<<16>>16)>>0]|0)|0,8)|0;if((h<<16|0)>0){i=Ca(c,26129+(d[26585+(h<<16>>16)>>0]|0)|0,8)|0;if((i<<16|0)>0){f=Ca(c,25977+(d[26585+(i<<16>>16)>>0]|0)|0,8)|0;b[a>>1]=f;j=e-g<<16>>16;e=(g<<16>>16)-h<<16>>16;g=(h<<16>>16)-i<<16>>16;h=(i<<16>>16)-f&65535;f=a+2|0}else{f=e-g<<16>>16;e=(g<<16>>16)-h<<16>>16;g=(h<<16>>16)-i<<16>>16;i=a+2|0;k=7}}else{f=e-g<<16>>16;e=(g<<16>>16)-h<<16>>16;k=4}}else{f=e-g<<16>>16;e=0;k=4}}else{f=0;e=0;k=4}if((k|0)==4){g=0;i=a+2|0;k=7}if((k|0)==7){b[a>>1]=0;j=f;h=0;f=i}b[f>>1]=h;if((g|0)>0){f=Ca(c,25977+(d[26585+g>>0]|0)|0,8)|0;b[a+4>>1]=f;f=g-f&65535}else{b[a+4>>1]=0;f=0}b[a+6>>1]=f;if((e|0)>0){f=Ca(c,26129+(d[26585+e>>0]|0)|0,8)|0;e=e-f<<16>>16;if((f<<16|0)>0){h=Ca(c,25977+(d[26585+(f<<16>>16)>>0]|0)|0,8)|0;b[a+8>>1]=h;h=(f<<16>>16)-h&65535;f=e;e=a+10|0}else{f=e;e=a+8|0;g=a+10|0;k=15}}else{f=0;e=a+8|0;g=a+10|0;k=15}if((k|0)==15){b[e>>1]=0;h=0;e=g}b[e>>1]=h;if((f|0)>0){e=Ca(c,25977+(d[26585+f>>0]|0)|0,8)|0;b[a+12>>1]=e;e=f-e&65535}else{b[a+12>>1]=0;e=0}b[a+14>>1]=e;if((j|0)>0){f=Ca(c,26281+(d[26585+j>>0]|0)|0,8)|0;e=j-f<<16>>16;if((f<<16|0)>0){h=Ca(c,26129+(d[26585+(f<<16>>16)>>0]|0)|0,8)|0;if((h<<16|0)>0){j=Ca(c,25977+(d[26585+(h<<16>>16)>>0]|0)|0,8)|0;b[a+16>>1]=j;g=(f<<16>>16)-h<<16>>16;h=(h<<16>>16)-j&65535;f=a+18|0}else{g=(f<<16>>16)-h<<16>>16;f=a+16|0;i=a+18|0;k=24}}else k=21}else{e=0;k=21}if((k|0)==21){g=0;f=a+16|0;i=a+18|0;k=24}if((k|0)==24){b[f>>1]=0;h=0;f=i}b[f>>1]=h;if((g|0)>0){f=Ca(c,25977+(d[26585+g>>0]|0)|0,8)|0;b[a+20>>1]=f;f=g-f&65535}else{b[a+20>>1]=0;f=0}b[a+22>>1]=f;if((e|0)>0){f=Ca(c,26129+(d[26585+e>>0]|0)|0,8)|0;e=e-f<<16>>16;if((f<<16|0)>0){g=Ca(c,25977+(d[26585+(f<<16>>16)>>0]|0)|0,8)|0;b[a+24>>1]=g;g=(f<<16>>16)-g&65535;f=a+26|0}else{f=a+24|0;h=a+26|0;k=32}}else{e=0;f=a+24|0;h=a+26|0;k=32}if((k|0)==32){b[f>>1]=0;g=0;f=h}b[f>>1]=g;if((e|0)>0){k=Ca(c,25977+(d[26585+e>>0]|0)|0,8)|0;b[a+28>>1]=k;k=e-k&65535;b[a+30>>1]=k;return}else{b[a+28>>1]=0;k=0;b[a+30>>1]=k;return}}function Wb(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;h=b[f+2>>1]|0;if(h<<16>>16<=0)return;h=(c[f+24>>2]|0)+((N(h<<16>>16,g)|0)/2|0)|0;g=0;while(1){j=a[h>>0]|0;b[d+(g<<1)>>1]=((j&255)>>>1&7)*9;a[e+g>>0]=a[(c[f+20>>2]|0)+(((b[f+2>>1]|0)+-1&0-(j&1))+g)>>0]|0;i=g|1;b[d+(i<<1)>>1]=((j&255)>>>5)*9&255;a[e+i>>0]=a[(c[f+20>>2]|0)+(i+((b[f+2>>1]|0)+-1&0-((j&255)>>>4&1)))>>0]|0;g=g+2|0;if((g|0)>=(b[f+2>>1]|0))break;else h=h+1|0}return}function Xb(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0,g=0;if((c|0)>1){e=d;f=0;do{g=a+(f<<1)|0;b[g>>1]=(((N(b[g>>1]|0,e)|0)>>>15)+1|0)>>>1;e=(((N(e,d+-65536|0)|0)>>15)+1>>1)+e|0;f=f+1|0}while((f|0)!=(c+-1|0))}else e=d;b[a+(c+-1<<1)>>1]=(((N(b[a+(c+-1<<1)>>1]|0,e)|0)>>>15)+1|0)>>>1;return}function Yb(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;i=(f|0)==8?((g|0)==4?11:3):(g|0)==4?34:12;h=(f|0)==8?((g|0)==4?26700:26670):(g|0)==4?26744:26676;if((g|0)<=0)return;l=(f<<16>>15|0)>((f<<16>>16)*18|0)?f<<16>>15:(f<<16>>16)*18|0;k=(f<<16>>15|0)>((f<<16>>16)*18|0)?(f<<16>>16)*18|0:f<<16>>15;j=0;do{m=(f<<16>>15)+(b<<16>>16)+(a[h+((N(j,i)|0)+(d<<24>>24))>>0]|0)|0;c[e+(j<<2)>>2]=(m|0)>(l|0)?l:(m|0)<(k|0)?k:m;j=j+1|0}while((j|0)!=(g|0));return}function Zb(a){a=a|0;var b=0,c=0;if((a|0)<0){a=0;return a|0}if((a|0)>3966){a=2147483647;return a|0}c=((N(N(a&127,-174)|0,128-(a&127)|0)|0)>>16)+(a&127)|0;b=N(c,1<<(a>>>7)>>7)|0;a=((a|0)<2048?c<<(a>>>7)>>7:b)+(1<<(a>>>7))|0;return a|0}function _b(a,c,d,e,f,g){a=a|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;if((f|0)>=(e|0)){e=f<<1;wc(a|0,0,e|0)|0;return}if((f|0)>6)h=f;else{g=f;do{i=c+(g+-1<<1)|0;j=N(b[d>>1]|0,b[i>>1]|0)|0;j=(N(b[d+2>>1]|0,b[i+-2>>1]|0)|0)+j|0;j=j+(N(b[d+4>>1]|0,b[i+-4>>1]|0)|0)|0;j=j+(N(b[d+6>>1]|0,b[i+-6>>1]|0)|0)|0;j=j+(N(b[d+8>>1]|0,b[i+-8>>1]|0)|0)|0;j=j+(N(b[d+10>>1]|0,b[i+-10>>1]|0)|0)|0;j=((b[i+2>>1]<<12)-j>>11)+1>>1;b[a+(g<<1)>>1]=(j|0)>32767?32767:((j|0)>-32768?j:-32768)&65535;g=g+1|0}while((g|0)!=(e|0));e=f<<1;wc(a|0,0,e|0)|0;return}do{g=c+(h+-1<<1)|0;j=N(b[d>>1]|0,b[g>>1]|0)|0;j=(N(b[d+2>>1]|0,b[g+-2>>1]|0)|0)+j|0;j=j+(N(b[d+4>>1]|0,b[g+-4>>1]|0)|0)|0;j=j+(N(b[d+6>>1]|0,b[g+-6>>1]|0)|0)|0;j=j+(N(b[d+8>>1]|0,b[g+-8>>1]|0)|0)|0;i=6;j=j+(N(b[d+10>>1]|0,b[g+-10>>1]|0)|0)|0;do{k=(N(b[d+(i<<1)>>1]|0,b[g+(0-i<<1)>>1]|0)|0)+j|0;j=k+(N(b[d+((i|1)<<1)>>1]|0,b[g+(~i<<1)>>1]|0)|0)|0;i=i+2|0}while((i|0)<(f|0));k=((b[g+2>>1]<<12)-j>>11)+1>>1;b[a+(h<<1)>>1]=(k|0)>32767?32767:((k|0)>-32768?k:-32768)&65535;h=h+1|0}while((h|0)!=(e|0));k=f<<1;wc(a|0,0,k|0)|0;return}function $b(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=l;l=l+96|0;if((d|0)>0){e=0;f=0;do{q=b[a+(f<<1)>>1]|0;e=q+e|0;c[r+(f<<2)>>2]=q<<12;f=f+1|0}while((f|0)!=(d|0));if((e|0)>4095){q=0;l=r;return q|0}}a=c[r+(d+-1<<2)>>2]|0;a:do if((d|0)>1){g=0;e=(a+16773022|0)>>>0>33546044;f=1073741824;h=d;p=d+-1|0;b:while(1){if(e){a=0;d=21;break}o=0-(a<<7)|0;uc(o|0,((o|0)<0)<<31>>31|0,o|0,((o|0)<0)<<31>>31|0)|0;a=1073741824-y|0;q=uc(a|0,((a|0)<0)<<31>>31|0,f|0,g|0)|0;q=xc(q|0,y|0,30)|0;if((q&-4|0)<107374){a=0;d=21;break}i=Q(((a|0)>0?a:0-a|0)|0)|0;n=(536870911/(a<<i+-1>>16|0)|0)<<16;m=536870912-(N(n>>16,a<<i+-1>>16)|0)-((N(n>>16,a<<i+-1&65535)|0)>>16)<<3;a=(N(m,((536870911/(a<<i+-1>>16|0)|0)>>15)+1>>1)|0)+n+(N(m>>16,n>>16)|0)+((N(m&65528,n>>16)|0)>>16)|0;if((-30-(32-i)+(62-i)|0)<1){m=0-(-30-(32-i)+(62-i))|0;k=(-2147483648>>m|0)>(2147483647>>>m|0)?-2147483648>>m:2147483647>>>m;n=(-2147483648>>m|0)>(2147483647>>>m|0)?2147483647>>>m:-2147483648>>m;m=((a|0)>(k|0)?k:(a|0)<(n|0)?n:a)<<m}else m=(-30-(32-i)+(62-i)|0)<32?a>>-30-(32-i)+(62-i):0;k=h>>>1;n=p+-1|0;if(k|0){j=((m|0)<0)<<31>>31;if((32-i|0)==1){h=0;do{d=r+(h<<2)|0;a=c[d>>2]|0;g=r+(n-h<<2)|0;e=c[g>>2]|0;f=uc(e|0,((e|0)<0)<<31>>31|0,o|0,((o|0)<0)<<31>>31|0)|0;f=xc(f|0,y|0,30)|0;f=vc(f|0,y|0,1,0)|0;f=xc(f|0,y|0,1)|0;f=(((a-f|0)>-1?a:a^-2147483648)&((a-f|0)>-1?f^-2147483648:f)|0)<0?a-f>>31^-2147483648:a-f|0;f=uc(f|0,((f|0)<0)<<31>>31|0,m|0,j|0)|0;i=sc(f|0,y|0,1)|0;f=vc(i|0,y|0,f&1|0,0)|0;i=vc(f|0,y|0,-2147483648,0)|0;s=y;if(s>>>0>0|(s|0)==0&i>>>0>4294967295){a=0;d=21;break b}c[d>>2]=f;a=uc(a|0,((a|0)<0)<<31>>31|0,o|0,((o|0)<0)<<31>>31|0)|0;a=xc(a|0,y|0,30)|0;a=vc(a|0,y|0,1,0)|0;a=xc(a|0,y|0,1)|0;a=(((e-a|0)>-1?e:e^-2147483648)&((e-a|0)>-1?a^-2147483648:a)|0)<0?e-a>>31^-2147483648:e-a|0;a=uc(a|0,((a|0)<0)<<31>>31|0,m|0,j|0)|0;s=sc(a|0,y|0,1)|0;a=vc(s|0,y|0,a&1|0,0)|0;s=vc(a|0,y|0,-2147483648,0)|0;i=y;if(i>>>0>0|(i|0)==0&s>>>0>4294967295){a=0;d=21;break b}c[g>>2]=a;h=h+1|0}while((h|0)<(k|0))}else{h=0;do{d=r+(h<<2)|0;a=c[d>>2]|0;g=r+(n-h<<2)|0;e=c[g>>2]|0;f=uc(e|0,((e|0)<0)<<31>>31|0,o|0,((o|0)<0)<<31>>31|0)|0;f=xc(f|0,y|0,30)|0;f=vc(f|0,y|0,1,0)|0;f=xc(f|0,y|0,1)|0;f=(((a-f|0)>-1?a:a^-2147483648)&((a-f|0)>-1?f^-2147483648:f)|0)<0?a-f>>31^-2147483648:a-f|0;f=uc(f|0,((f|0)<0)<<31>>31|0,m|0,j|0)|0;f=sc(f|0,y|0,32-i+-1|0)|0;f=vc(f|0,y|0,1,0)|0;f=sc(f|0,y|0,1)|0;s=vc(f|0,y|0,-2147483648,0)|0;t=y;if(t>>>0>0|(t|0)==0&s>>>0>4294967295){a=0;d=21;break b}c[d>>2]=f;a=uc(a|0,((a|0)<0)<<31>>31|0,o|0,((o|0)<0)<<31>>31|0)|0;a=xc(a|0,y|0,30)|0;a=vc(a|0,y|0,1,0)|0;a=xc(a|0,y|0,1)|0;a=(((e-a|0)>-1?e:e^-2147483648)&((e-a|0)>-1?a^-2147483648:a)|0)<0?e-a>>31^-2147483648:e-a|0;a=uc(a|0,((a|0)<0)<<31>>31|0,m|0,j|0)|0;a=sc(a|0,y|0,32-i+-1|0)|0;a=vc(a|0,y|0,1,0)|0;a=sc(a|0,y|0,1)|0;t=vc(a|0,y|0,-2147483648,0)|0;s=y;if(s>>>0>0|(s|0)==0&t>>>0>4294967295){a=0;d=21;break b}c[g>>2]=a;h=h+1|0}while((h|0)<(k|0))}}a=c[r+(n<<2)>>2]|0;e=(a+16773022|0)>>>0>33546044;if((p|0)<=1){f=q&-4;a=((q&-4|0)<0)<<31>>31;break a}else{h=p;g=((q&-4|0)<0)<<31>>31;f=q&-4;p=n}}if((d|0)==21){l=r;return a|0}}else{e=(a+16773022|0)>>>0>33546044;f=1073741824;a=0}while(0);if(e){t=0;l=r;return t|0}t=0-(c[r>>2]<<7)|0;uc(t|0,((t|0)<0)<<31>>31|0,t|0,((t|0)<0)<<31>>31|0)|0;t=1073741824-y|0;t=uc(t|0,((t|0)<0)<<31>>31|0,f|0,a|0)|0;t=xc(t|0,y|0,30)|0;t=(t&-4|0)<107374?0:t&-4;l=r;return t|0}function ac(a,e,f,g){a=a|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,m=0,n=0,o=0;o=l;l=l+304|0;g=(f|0)==16?26644:26660;if((f|0)>0){h=0;do{m=b[e+(h<<1)>>1]|0;n=b[21940+(m>>8<<1)>>1]|0;n=((N((b[21940+((m>>8)+1<<1)>>1]|0)-n|0,m-(m>>8<<8)|0)|0)+(n<<8)>>3)+1>>1;c[o+200+(d[g+h>>0]<<2)>>2]=n;h=h+1|0}while((h|0)!=(f|0));g=c[o+200>>2]|0}else g=0;c[o+148>>2]=65536;g=0-g|0;c[o+148+4>>2]=g;a:do if((f>>1|0)>1){i=g;j=65536;e=1;while(1){k=c[o+200+(e<<1<<2)>>2]|0;n=o+148+(e<<2)|0;h=uc(k|0,((k|0)<0)<<31>>31|0,i|0,((i|0)<0)<<31>>31|0)|0;h=xc(h|0,y|0,15)|0;h=vc(h|0,y|0,1,0)|0;h=xc(h|0,y|0,1)|0;m=e+1|0;c[o+148+(m<<2)>>2]=(j<<1)-h;if((e|0)>1){h=c[o+148+(e+-2<<2)>>2]|0;g=e+-1|0;j=uc(j|0,((j|0)<0)<<31>>31|0,k|0,((k|0)<0)<<31>>31|0)|0;j=xc(j|0,y|0,15)|0;j=vc(j|0,y|0,1,0)|0;j=xc(j|0,y|0,1)|0;c[o+148+(e<<2)>>2]=h+i-j;if((g|0)>1)do{e=c[o+148+(g<<2)>>2]|0;i=h;h=c[o+148+(g+-2<<2)>>2]|0;j=g;g=g+-1|0;i=uc(i|0,((i|0)<0)<<31>>31|0,k|0,((k|0)<0)<<31>>31|0)|0;i=xc(i|0,y|0,15)|0;i=vc(i|0,y|0,1,0)|0;i=xc(i|0,y|0,1)|0;c[o+148+(j<<2)>>2]=h+e-i}while((g|0)>1);g=c[o+148+4>>2]|0}g=g-k|0;c[o+148+4>>2]=g;if((m|0)==(f>>1|0))break a;i=c[o+148+(m<<2)>>2]|0;j=c[n>>2]|0;e=m}}while(0);c[o+96>>2]=65536;g=0-(c[o+200+4>>2]|0)|0;c[o+96+4>>2]=g;b:do if((f>>1|0)>1){i=65536;j=g;e=1;while(1){k=c[o+200+4+(e<<1<<2)>>2]|0;n=o+96+(e<<2)|0;h=uc(k|0,((k|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;h=xc(h|0,y|0,15)|0;h=vc(h|0,y|0,1,0)|0;h=xc(h|0,y|0,1)|0;m=e+1|0;c[o+96+(m<<2)>>2]=(i<<1)-h;if((e|0)>1){h=c[o+96+(e+-2<<2)>>2]|0;g=e+-1|0;i=uc(i|0,((i|0)<0)<<31>>31|0,k|0,((k|0)<0)<<31>>31|0)|0;i=xc(i|0,y|0,15)|0;i=vc(i|0,y|0,1,0)|0;i=xc(i|0,y|0,1)|0;c[o+96+(e<<2)>>2]=h+j-i;if((g|0)>1)do{e=c[o+96+(g<<2)>>2]|0;i=h;h=c[o+96+(g+-2<<2)>>2]|0;j=g;g=g+-1|0;i=uc(i|0,((i|0)<0)<<31>>31|0,k|0,((k|0)<0)<<31>>31|0)|0;i=xc(i|0,y|0,15)|0;i=vc(i|0,y|0,1,0)|0;i=xc(i|0,y|0,1)|0;c[o+96+(j<<2)>>2]=h+e-i}while((g|0)>1);g=c[o+96+4>>2]|0}g=g-k|0;c[o+96+4>>2]=g;if((m|0)==(f>>1|0))break b;i=c[n>>2]|0;j=c[o+96+(m<<2)>>2]|0;e=m}}while(0);if((f>>1|0)>0){g=c[o+148>>2]|0;h=c[o+96>>2]|0;e=0;do{n=e;e=e+1|0;m=g;g=c[o+148+(e<<2)>>2]|0;m=m+g|0;k=h;h=c[o+96+(e<<2)>>2]|0;k=h-k|0;c[o+(n<<2)>>2]=0-(k+m);c[o+(f+-1-n<<2)>>2]=k-m}while((e|0)!=(f>>1|0))}fc(a,o,12,17,f);if($b(a,f)|0){l=o;return}if((f|0)>0)g=0;else{g=0;do{kc(o,f,65536-(2<<g)|0);g=g+1|0}while((g|0)<16&($b(a,f)|0)==0);l=o;return}do{kc(o,f,65536-(2<<g)|0);h=0;do{b[a+(h<<1)>>1]=(((c[o+(h<<2)>>2]|0)>>>4)+1|0)>>>1;h=h+1|0}while((h|0)!=(f|0));g=g+1|0}while((g|0)<16&($b(a,f)|0)==0);l=o;return}function bc(a,c,d){a=a|0;c=c|0;d=d|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=0;do{f=b[a>>1]|0;j=b[c>>1]|0;if((d|0)>1){h=f;g=0;i=1;f=(f<<16>>16)-(j<<16>>16)|0;do{l=h;h=b[a+(i<<1)>>1]|0;l=(h<<16>>16)-(l<<16>>16)-(b[c+(i<<1)>>1]|0)|0;k=(l|0)<(f|0);g=k?i:g;f=k?l:f;i=i+1|0}while((i|0)!=(d|0))}else{g=0;f=(f<<16>>16)-(j<<16>>16)|0}k=b[c+(d<<1)>>1]|0;i=32768-(b[a+(d+-1<<1)>>1]|0)-(k<<16>>16)|0;h=(i|0)<(f|0);l=h?d:g;if(((h?i:f)|0)>-1){n=23;break}if(!l)b[a>>1]=j;else{if((l|0)==(d|0)){g=a+(d+-1<<1)|0;f=32768-(k<<16>>16)|0}else{if((l|0)>0)if((l|0)==1)f=j<<16>>16;else{f=j<<16>>16;g=1;do{f=(b[c+(g<<1)>>1]|0)+f|0;g=g+1|0}while((g|0)!=(l|0))}else f=0;i=b[c+(l<<1)>>1]|0;h=(i>>1)+f|0;if((l|0)<(d|0))if((d+-1|0)>(l|0)){g=d+-1|0;f=32768-(k<<16>>16)|0;do{f=f-(b[c+(g<<1)>>1]|0)|0;g=g+-1|0}while((g|0)>(l|0))}else f=32768-(k<<16>>16)|0;else f=32768;g=f-(i>>1)|0;f=(b[a+(l<<1)>>1]|0)+(b[a+(l+-1<<1)>>1]|0)|0;k=(h|0)>(g|0)?h:g;g=(h|0)>(g|0)?g:h;f=(((f>>1)+(f&1)|0)>(k|0)?k:((f>>1)+(f&1)|0)<(g|0)?g:(f>>1)+(f&1)|0)-(i>>>1)|0;b[a+(l+-1<<1)>>1]=f;g=a+(l<<1)|0;f=f+(e[c+(l<<1)>>1]|0)|0}b[g>>1]=f}m=m+1|0}while((m|0)<20);if((n|0)==23)return;if((m|0)!=20)return;dc(a,d);n=b[a>>1]|0;f=b[c>>1]|0;f=(n|0)>(f|0)?n:f;b[a>>1]=f;if((d|0)>1){g=1;do{n=a+(g<<1)|0;l=b[n>>1]|0;m=(b[c+(g<<1)>>1]|0)+f|0;m=(m|0)>32767?32767:((m|0)>-32768?m:-32768)<<16>>16;f=(l|0)>(m|0)?l:m;b[n>>1]=f;g=g+1|0}while((g|0)!=(d|0))}n=b[a+(d+-1<<1)>>1]|0;f=32768-(b[c+(d<<1)>>1]|0)|0;f=(n|0)<(f|0)?n:f;b[a+(d+-1<<1)>>1]=f;if((d+-2|0)>-1)g=d+-2|0;else return;while(1){d=a+(g<<1)|0;m=b[d>>1]|0;n=(f<<16>>16)-(b[c+(g+1<<1)>>1]|0)|0;f=(m|0)<(n|0)?m:n;b[d>>1]=f;if((g|0)<=0)break;else g=g+-1|0}return}function cc(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;if((g|0)<=0)return;j=b[f>>1]|0;h=b[f+2>>1]|0;f=c[a>>2]|0;i=0;do{k=(b[e+(i<<1)>>1]<<8)+f|0;c[d+(i<<2)>>2]=k;f=(N(k<<2>>16,j)|0)+(c[a+4>>2]|0)+((N(k<<2&65532,j)|0)>>16)|0;c[a>>2]=f;c[a+4>>2]=((N(h,k<<2&65532)|0)>>16)+(N(h,k<<2>>16)|0);i=i+1|0}while((i|0)!=(g|0));return}function dc(a,c){a=a|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((c|0)>1)h=1;else return;do{g=b[a+(h<<1)>>1]|0;f=h;while(1){d=f+-1|0;e=b[a+(d<<1)>>1]|0;if(g<<16>>16>=e<<16>>16){d=f;break}b[a+(f<<1)>>1]=e;if((f|0)>1)f=d;else break}b[a+(d<<1)>>1]=g;h=h+1|0}while((h|0)!=(c|0));return}function ec(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;i=31-(Q(f|0)|0)|0;if((f|0)>1){h=0;g=f;do{j=b[e+(h<<1)>>1]|0;j=N(j,j)|0;k=b[e+((h|1)<<1)>>1]|0;g=(((N(k,k)|0)+j|0)>>>i)+g|0;h=h+2|0}while((h|0)<(f+-1|0));h=f&-2}else{h=0;g=f}if((h|0)<(f|0)){k=b[e+(h<<1)>>1]|0;g=((N(k,k)|0)>>>i)+g|0}j=i+3-(Q(g|0)|0)|0;j=(j|0)>0?j:0;if((f|0)>1){g=0;i=0;do{k=b[e+(g<<1)>>1]|0;k=N(k,k)|0;h=b[e+((g|1)<<1)>>1]|0;i=(((N(h,h)|0)+k|0)>>>j)+i|0;g=g+2|0}while((g|0)<(f+-1|0));h=f&-2;g=i}else{h=0;g=0}if((h|0)>=(f|0)){k=g;c[d>>2]=j;c[a>>2]=k;return}k=b[e+(h<<1)>>1]|0;k=((N(k,k)|0)>>>j)+g|0;c[d>>2]=j;c[a>>2]=k;return}function fc(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;if((g|0)>0){h=0;i=0}else return;do{j=0;k=0;do{l=c[d+(j<<2)>>2]|0;l=(l|0)>0?l:0-l|0;m=(l|0)>(k|0);i=m?j:i;k=m?l:k;j=j+1|0}while((j|0)!=(g|0));if((f-e|0)==1)j=(k>>1)+(k&1)|0;else j=(k>>f-e+-1)+1>>1;if((j|0)<=32767)break;m=(j|0)<163838?j:163838;kc(d,g,65470-(((m<<14)+-536854528|0)/((N(m,i+1|0)|0)>>2|0)|0)|0);h=h+1|0}while((h|0)<10);if((h|0)==10){if((g|0)<=0)return;if((f-e|0)==1){h=0;do{m=d+(h<<2)|0;l=c[m>>2]|0;l=((l>>1)+(l&1)|0)>32767?32767:((l>>1)+(l&1)|0)>-32768?(l>>1)+(l&1)|0:-32768;b[a+(h<<1)>>1]=l;c[m>>2]=l<<16>>15;h=h+1|0}while((h|0)!=(g|0));return}else{h=0;do{m=d+(h<<2)|0;l=(c[m>>2]>>f-e+-1)+1>>1;l=(l|0)>32767?32767:(l|0)>-32768?l:-32768;b[a+(h<<1)>>1]=l;c[m>>2]=l<<16>>16<<f-e;h=h+1|0}while((h|0)!=(g|0));return}}else{if((g|0)<=0)return;if((f-e|0)==1){h=0;do{m=c[d+(h<<2)>>2]|0;b[a+(h<<1)>>1]=(m>>>1)+(m&1);h=h+1|0}while((h|0)!=(g|0));return}else{h=0;do{b[a+(h<<1)>>1]=((c[d+(h<<2)>>2]>>f-e+-1)+1|0)>>>1;h=h+1|0}while((h|0)!=(g|0));return}}}function gc(a){a=a|0;var d=0,e=0,f=0;d=c[a+2340>>2]|0;if((d|0)>0){e=0;f=0;do{e=e+(32767/(d+1|0)|0)|0;b[a+4052+(f<<1)>>1]=e;f=f+1|0}while((f|0)<(c[a+2340>>2]|0))}c[a+4148>>2]=0;c[a+4152>>2]=3176576;return}function hc(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,X=0,Y=0,_=0,$=0,aa=0;I=l;l=l+32|0;g=c[a+2316>>2]|0;if((g|0)!=(c[a+4156>>2]|0)){i=c[a+2340>>2]|0;if((i|0)>0){g=0;h=0;do{g=g+(32767/(i+1|0)|0)|0;b[a+4052+(h<<1)>>1]=g;h=h+1|0}while((h|0)<(c[a+2340>>2]|0));g=c[a+2316>>2]|0}c[a+4148>>2]=0;c[a+4152>>2]=3176576;c[a+4156>>2]=g}if(!(c[a+4160>>2]|0)){if(!(c[a+4164>>2]|0)){if((c[a+2340>>2]|0)>0){g=0;do{H=a+4052+(g<<1)|0;F=b[H>>1]|0;G=(b[a+2344+(g<<1)>>1]|0)-F|0;b[H>>1]=((G>>16)*16348|0)+F+(((G&65535)*16348|0)>>>16);g=g+1|0}while((g|0)<(c[a+2340>>2]|0))}m=c[a+2324>>2]|0;if((m|0)>0){j=0;k=0;g=0;while(1){h=c[d+16+(j<<2)>>2]|0;i=(h|0)>(k|0);g=i?j:g;j=j+1|0;if((j|0)>=(m|0))break;else k=i?h:k}}else g=0;H=c[a+2332>>2]|0;Ac(a+2772+(H<<2)|0,a+2772|0,N((m<<2)+-4|0,H)|0)|0;H=c[a+2332>>2]|0;zc(a+2772|0,a+4+((N(H,g)|0)<<2)|0,H<<2|0)|0;g=c[a+2324>>2]|0;if((g|0)>0){h=c[a+4148>>2]|0;i=0;do{H=(c[d+16+(i<<2)>>2]|0)-h|0;h=((H>>16)*4634|0)+h+(((H&65535)*4634|0)>>>16)|0;c[a+4148>>2]=h;i=i+1|0}while((i|0)<(g|0))}}if(!(c[a+4160>>2]|0)){wc(a+4084|0,0,c[a+2340>>2]<<2|0)|0;l=I;return}}G=Z()|0;H=l;l=l+((1*(f+16<<2)|0)+15&-16)|0;g=b[a+4228>>1]|0;h=c[a+4248>>2]|0;g=((N(h<<16>>16,g&65535)|0)>>16)+(N(h<<16>>16,g>>16)|0)+(N((h>>15)+1>>1,g)|0)|0;h=c[a+4148>>2]|0;if((h|0)>8388608|(g|0)>2097151){j=16;i=N(g>>16,g>>16)|0;g=N(h>>16,h>>16)|0}else{j=8;i=((N(g<<16>>16,g&65535)|0)>>16)+(N(g<<16>>16,g>>16)|0)+(N((g>>15)+1>>1,g)|0)|0;g=((N(h<<16>>16,h&65535)|0)>>16)+(N(h<<16>>16,h>>16)|0)+(N((h>>15)+1>>1,h)|0)|0}g=g-(i<<5)|0;if((g|0)<1)g=0;else{h=Q(g|0)|0;do if(24-h|0)if((24-h|0)<0){g=g>>>(24-h+32|0)|g<<0-(24-h);break}else{g=g<<32-(24-h)|g>>>(24-h|0);break}while(0);F=((h&1|0)==0?46214:32768)>>>(h>>>1);g=(N(g&127,13959168)|0)>>>16;g=(N(g,F>>16)|0)+F+((N(g,F&65535)|0)>>>16)|0}i=255;while(1)if((i|0)>(f|0))i=i>>1;else break;F=g<<j;g=c[a+4152>>2]|0;if((f|0)>0){h=0;do{g=(N(g,196314165)|0)+907633515|0;c[H+64+(h<<2)>>2]=c[a+2772+((g>>24&i)<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}c[a+4152>>2]=g;ac(I,a+4052|0,c[a+2340>>2]|0,c[a+4168>>2]|0);g=H;h=a+4084|0;i=g+64|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(i|0));if((f|0)>0){j=c[a+2340>>2]|0;o=b[I>>1]|0;p=b[I+2>>1]|0;q=b[I+4>>1]|0;r=b[I+6>>1]|0;s=b[I+8>>1]|0;t=b[I+10>>1]|0;u=b[I+12>>1]|0;v=b[I+14>>1]|0;w=b[I+16>>1]|0;x=b[I+18>>1]|0;y=b[I+20>>1]|0;z=b[I+22>>1]|0;A=b[I+24>>1]|0;B=b[I+26>>1]|0;C=b[I+28>>1]|0;D=b[I+30>>1]|0;g=c[H+60>>2]|0;k=c[H+52>>2]|0;m=c[H+44>>2]|0;d=c[H+36>>2]|0;n=c[H+28>>2]|0;E=0;do{aa=N(o,g>>16)|0;$=(N(o,g&65535)|0)>>16;V=k;k=c[H+(E+14<<2)>>2]|0;_=N(p,k>>16)|0;Y=(N(p,k&65535)|0)>>16;X=N(q,V>>16)|0;V=(N(q,V&65535)|0)>>16;R=m;m=c[H+(E+12<<2)>>2]|0;U=N(r,m>>16)|0;T=(N(r,m&65535)|0)>>16;S=N(s,R>>16)|0;R=(N(s,R&65535)|0)>>16;L=d;d=c[H+(E+10<<2)>>2]|0;P=N(t,d>>16)|0;O=(N(t,d&65535)|0)>>16;M=N(u,L>>16)|0;L=(N(u,L&65535)|0)>>16;i=n;n=c[H+(E+8<<2)>>2]|0;K=N(v,n>>16)|0;J=(N(v,n&65535)|0)>>16;h=N(w,i>>16)|0;i=(N(w,i&65535)|0)>>16;g=c[H+(E+6<<2)>>2]|0;g=aa+(j>>1)+$+_+Y+X+V+U+T+S+R+P+O+M+L+K+J+h+i+(N(x,g>>16)|0)+((N(x,g&65535)|0)>>16)|0;if((j|0)==16){R=c[H+(E+5<<2)>>2]|0;P=N(y,R>>16)|0;R=(N(y,R&65535)|0)>>16;T=c[H+(E+4<<2)>>2]|0;S=N(z,T>>16)|0;T=(N(z,T&65535)|0)>>16;V=c[H+(E+3<<2)>>2]|0;U=N(A,V>>16)|0;V=(N(A,V&65535)|0)>>16;Y=c[H+(E+2<<2)>>2]|0;X=N(B,Y>>16)|0;Y=(N(B,Y&65535)|0)>>16;$=c[H+(E+1<<2)>>2]|0;_=N(C,$>>16)|0;$=(N(C,$&65535)|0)>>16;aa=c[H+(E<<2)>>2]|0;g=P+g+R+S+T+U+V+X+Y+_+$+(N(D,aa>>16)|0)+((N(D,aa&65535)|0)>>16)|0}i=H+(E+16<<2)|0;h=c[i>>2]|0;g=(g|0)>134217727?2147483632:((g|0)>-134217728?g:-134217728)<<4;if((g+h|0)>-1)g=(g&h|0)<0?-2147483648:g+h|0;else g=(g|h|0)>-1?2147483647:g+h|0;c[i>>2]=g;aa=e+(E<<1)|0;$=((N(g>>16,F<<10>>16)|0)+(N(g,(F>>21)+1>>1)|0)+((N(g&65535,F<<10>>16)|0)>>16)>>7)+1>>1;$=(($|0)>32767?32767:($|0)>-32768?$:-32768)+(b[aa>>1]|0)|0;b[aa>>1]=($|0)>32767?32767:(($|0)>-32768?$:-32768)&65535;E=E+1|0}while((E|0)!=(f|0))}g=a+4084|0;h=H+(f<<2)|0;i=g+64|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(i|0));W(G|0);l=I;return}function ic(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,m=0,n=0,o=0;n=l;l=l+16|0;a[n+1>>0]=0;if((f+8>>4|0)>0)m=0;else{l=n;return}while(1){j=c[i+(m<<2)>>2]|0;if((j|0)>0){a[n>>0]=a[26602+(((g<<1)+h<<16>>16)*7|0)+((j&31)>>>0<6?j&31:6)>>0]|0;k=0;do{j=e+(k<<1)|0;if((b[j>>1]|0)>0){o=((Ca(d,n,8)|0)<<1)+-1|0;b[j>>1]=N(b[j>>1]|0,o)|0}k=k+1|0}while((k|0)!=16)}m=m+1|0;if((m|0)==(f+8>>4|0))break;else e=e+32|0}l=n;return}function jc(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,X=0;F=l;l=l+32|0;x=c[d+2336>>2]|0;z=Z()|0;B=l;l=l+((1*(x<<1)|0)+15&-16)|0;x=c[d+2328>>2]|0;C=l;l=l+((1*(x+(c[d+2336>>2]|0)<<2)|0)+15&-16)|0;A=c[d+2332>>2]|0;D=l;l=l+((1*(A<<2)|0)+15&-16)|0;E=l;l=l+((1*(A+16<<2)|0)+15&-16)|0;A=(a[d+2767>>0]|0)<4;if((x|0)>0){o=b[19836+(a[d+2765>>0]>>1<<2)+(a[d+2766>>0]<<1)>>1]<<4;n=0;i=a[d+2770>>0]|0;while(1){k=(N(i,196314165)|0)+907633515|0;j=b[g+(n<<1)>>1]|0;m=d+4+(n<<2)|0;c[m>>2]=j<<16>>16<<14;if(j<<16>>16<=0)if(j<<16>>16<0){i=j<<16>>16<<14|1280;t=7}else i=j<<16>>16<<14;else{i=(j<<16>>16<<14)+-1280|0;t=7}if((t|0)==7){t=0;c[m>>2]=i}x=i+o|0;c[m>>2]=(k|0)<0?0-x|0:x;n=n+1|0;if((n|0)>=(c[d+2328>>2]|0))break;else i=(j<<16>>16)+k|0}}i=E;j=d+1284|0;k=i+64|0;do{c[i>>2]=c[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));if((c[d+2324>>2]|0)<=0){i=d+1284|0;j=E;k=i+64|0;do{c[i>>2]=c[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));W(z|0);l=F;return}v=0;w=d+4|0;x=f;m=c[d+2336>>2]|0;while(1){p=e+32+(v>>1<<5)|0;zc(F|0,p|0,c[d+2340>>2]<<1|0)|0;s=e+96+(v*5<<1)|0;o=a[d+2765>>0]|0;u=c[e+16+(v<<2)>>2]|0;g=Q(((u|0)>0?u:0-u|0)|0)|0;n=(536870911/(u<<g+-1>>16|0)|0)<<16;i=536870912-(N(u<<g+-1>>16,n>>16)|0)-((N(u<<g+-1&65535,n>>16)|0)>>16)<<3;i=(N(i,((536870911/(u<<g+-1>>16|0)|0)>>15)+1>>1)|0)+n+(N(i>>16,n>>16)|0)+((N(i&65528,n>>16)|0)>>16)|0;if((62-g+-47|0)<1){t=-2147483648>>47-(62-g);q=2147483647>>>(47-(62-g)|0);r=(t|0)>(q|0)?t:q;t=(t|0)>(q|0)?q:t;i=((i|0)>(r|0)?r:(i|0)<(t|0)?t:i)<<47-(62-g)}else i=(62-g+-47|0)<32?i>>62-g+-47:0;j=c[d>>2]|0;if((u|0)==(j|0))k=65536;else{k=Q(((j|0)>0?j:0-j|0)|0)|0;r=((N(n>>16,j<<k+-1&65535)|0)>>16)+(N(n>>16,j<<k+-1>>16)|0)|0;t=uc(r|0,((r|0)<0)<<31>>31|0,u<<g+-1|0,((u<<g+-1|0)<0)<<31>>31|0)|0;t=xc(t|0,y|0,29)|0;j=(N((j<<k+-1)-(t&-8)>>16,n>>16)|0)+r+((N((j<<k+-1)-(t&-8)&65535,n>>16)|0)>>16)|0;if((k+28+(1-g)|0)<16){k=16-(k+28+(1-g))|0;r=(-2147483648>>k|0)>(2147483647>>>k|0)?-2147483648>>k:2147483647>>>k;t=(-2147483648>>k|0)>(2147483647>>>k|0)?2147483647>>>k:-2147483648>>k;k=((j|0)>(r|0)?r:(j|0)<(t|0)?t:j)<<k}else k=(k+28+(1-g)+-16|0)<32?j>>k+28+(1-g)+-16:0;g=k>>16;j=k&65535;n=0;do{t=E+(n<<2)|0;r=c[t>>2]|0;c[t>>2]=((N(r<<16>>16,j)|0)>>16)+(N(r<<16>>16,g)|0)+(N((r>>15)+1>>1,k)|0);n=n+1|0}while((n|0)!=16)}c[d>>2]=u;if(((c[d+4160>>2]|0)!=0?(c[d+4164>>2]|0)==2:0)?(v|0)<2&o<<24>>24!=2:0){b[s>>1]=0;b[s+2>>1]=0;b[s+4>>1]=0;b[s+6>>1]=0;b[s+8>>1]=0;b[s+4>>1]=4096;r=c[d+2308>>2]|0;c[e+(v<<2)>>2]=r;t=27}else t=24;do if((t|0)==24)if(o<<24>>24==2){r=c[e+(v<<2)>>2]|0;t=27;break}else{i=c[d+2332>>2]|0;q=w;t=41;break}while(0);if((t|0)==27){t=0;o=(v|0)==0;n=(v|0)==2;if(o|A&n){k=c[d+2336>>2]|0;j=c[d+2340>>2]|0;g=-2-r+k-j|0;if(n){zc(d+1348+(k<<1)|0,f|0,c[d+2332>>2]<<2|0)|0;k=c[d+2336>>2]|0;j=c[d+2340>>2]|0}_b(B+(g<<1)|0,d+1348+((N(c[d+2332>>2]|0,v)|0)+g<<1)|0,p,k-g|0,j,h);if(o){q=c[e+136>>2]<<16>>16;i=((N(q,i&65535)|0)>>16)+(N(q,i>>16)|0)<<2}if((r|0)>-2){p=i>>16;o=c[d+2336>>2]|0;j=i&65535;g=m+-1|0;i=r+1|0;k=0;n=0;while(1){q=b[B+(k+-1+o<<1)>>1]|0;c[C+(g+k<<2)>>2]=((N(q,j)|0)>>16)+(N(q,p)|0);if((n|0)==(i|0))break;else{k=~n;n=n+1|0}}}}else if((k|0)!=65536&(r|0)>-2){g=k>>16;o=m+-1|0;j=k&65535;i=r+1|0;n=0;while(1){q=C+(o-n<<2)|0;p=c[q>>2]|0;c[q>>2]=((N(p<<16>>16,j)|0)>>16)+(N(p<<16>>16,g)|0)+(N((p>>15)+1>>1,k)|0);if((n|0)==(i|0))break;else n=n+1|0}}i=c[d+2332>>2]|0;if((i|0)>0){g=b[s>>1]|0;o=b[s+2>>1]|0;p=b[s+4>>1]|0;q=b[s+6>>1]|0;k=b[s+8>>1]|0;n=0;j=C+(m+2-r<<2)|0;while(1){K=c[j>>2]|0;L=N(g,K>>16)|0;K=(N(g,K&65535)|0)>>16;I=c[j+-4>>2]|0;J=N(o,I>>16)|0;I=(N(o,I&65535)|0)>>16;G=c[j+-8>>2]|0;H=N(p,G>>16)|0;G=(N(p,G&65535)|0)>>16;s=c[j+-12>>2]|0;r=N(q,s>>16)|0;s=(N(q,s&65535)|0)>>16;t=c[j+-16>>2]|0;t=L+2+K+J+I+H+G+r+s+(N(k,t>>16)|0)+((N(k,t&65535)|0)>>16)|0;t=(t<<1)+(c[w+(n<<2)>>2]|0)|0;c[D+(n<<2)>>2]=t;c[C+(m<<2)>>2]=t<<1;m=m+1|0;n=n+1|0;if((n|0)>=(i|0)){q=D;t=41;break}else j=j+4|0}}else n=i}if((t|0)==41)if((i|0)>0){i=c[E+60>>2]|0;k=c[E+44>>2]|0;g=c[E+36>>2]|0;o=c[E+28>>2]|0;p=0;do{L=c[d+2340>>2]|0;V=b[F>>1]|0;X=N(V,i>>16)|0;V=(N(V,i&65535)|0)>>16;T=c[E+(p+14<<2)>>2]|0;R=b[F+2>>1]|0;U=N(R,T>>16)|0;T=(N(R,T&65535)|0)>>16;R=c[E+(p+13<<2)>>2]|0;j=b[F+4>>1]|0;S=N(j,R>>16)|0;R=(N(j,R&65535)|0)>>16;j=k;k=c[E+(p+12<<2)>>2]|0;O=b[F+6>>1]|0;P=N(O,k>>16)|0;O=(N(O,k&65535)|0)>>16;t=b[F+8>>1]|0;M=N(t,j>>16)|0;j=(N(t,j&65535)|0)>>16;t=g;g=c[E+(p+10<<2)>>2]|0;r=b[F+10>>1]|0;n=N(r,g>>16)|0;r=(N(r,g&65535)|0)>>16;J=b[F+12>>1]|0;s=N(J,t>>16)|0;t=(N(J,t&65535)|0)>>16;J=o;o=c[E+(p+8<<2)>>2]|0;H=b[F+14>>1]|0;G=N(H,o>>16)|0;H=(N(H,o&65535)|0)>>16;i=b[F+16>>1]|0;I=N(i,J>>16)|0;J=(N(i,J&65535)|0)>>16;i=c[E+(p+6<<2)>>2]|0;K=b[F+18>>1]|0;i=X+(L>>1)+V+U+T+S+R+P+O+M+j+n+r+s+t+G+H+I+J+(N(K,i>>16)|0)+((N(K,i&65535)|0)>>16)|0;if((L|0)==16){K=c[E+(p+5<<2)>>2]|0;M=b[F+20>>1]|0;J=N(M,K>>16)|0;K=(N(M,K&65535)|0)>>16;M=c[E+(p+4<<2)>>2]|0;P=b[F+22>>1]|0;L=N(P,M>>16)|0;M=(N(P,M&65535)|0)>>16;P=c[E+(p+3<<2)>>2]|0;S=b[F+24>>1]|0;O=N(S,P>>16)|0;P=(N(S,P&65535)|0)>>16;S=c[E+(p+2<<2)>>2]|0;U=b[F+26>>1]|0;R=N(U,S>>16)|0;S=(N(U,S&65535)|0)>>16;U=c[E+(p+1<<2)>>2]|0;X=b[F+28>>1]|0;T=N(X,U>>16)|0;U=(N(X,U&65535)|0)>>16;X=c[E+(p<<2)>>2]|0;V=b[F+30>>1]|0;i=J+i+K+L+M+O+P+R+S+T+U+(N(V,X>>16)|0)+((N(V,X&65535)|0)>>16)|0}j=c[q+(p<<2)>>2]|0;i=(i|0)>134217727?2147483632:((i|0)>-134217728?i:-134217728)<<4;if((i+j|0)>-1)i=(i&j|0)<0?-2147483648:i+j|0;else i=(i|j|0)>-1?2147483647:i+j|0;c[E+(p+16<<2)>>2]=i;n=((N(i>>16,u>>>6<<16>>16)|0)+(N(i,(u>>21)+1>>1)|0)+((N(i&65535,u>>>6<<16>>16)|0)>>16)>>7)+1>>1;b[x+(p<<1)>>1]=(n|0)>32767?32767:((n|0)>-32768?n:-32768)&65535;p=p+1|0;n=c[d+2332>>2]|0}while((p|0)<(n|0))}else n=i;i=E;j=E+(n<<2)|0;k=i+64|0;do{c[i>>2]=c[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));v=v+1|0;if((v|0)>=(c[d+2324>>2]|0))break;else{w=w+(n<<2)|0;x=x+(n<<1)|0}}i=d+1284|0;j=E;k=i+64|0;do{c[i>>2]=c[j>>2];i=i+4|0;j=j+4|0}while((i|0)<(k|0));W(z|0);l=F;return}function kc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if((b|0)>1){f=d&65535;g=d;h=0;e=d>>16;while(1){i=a+(h<<2)|0;j=c[i>>2]|0;c[i>>2]=((N(j<<16>>16,f)|0)>>16)+(N(j<<16>>16,e)|0)+(N((j>>15)+1>>1,g)|0);e=(((N(g,d+-65536|0)|0)>>15)+1>>1)+g|0;h=h+1|0;if((h|0)==(b+-1|0)){f=e&65535;g=e;e=e>>16;break}else{f=e&65535;g=e;e=e>>16}}}else{f=d&65535;g=d;e=d>>16}j=c[a+(b+-1<<2)>>2]|0;c[a+(b+-1<<2)>>2]=((N(j<<16>>16,f)|0)>>16)+(N(j<<16>>16,e)|0)+(N((j>>15)+1>>1,g)|0);return}function lc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=l;l=l+16|0;do if(a>>>0<245){n=a>>>0<11?16:a+11&-8;k=c[6720]|0;if(k>>>(n>>>3)&3|0){d=26920+((k>>>(n>>>3)&1^1)+(n>>>3)<<1<<2)|0;a=c[d+8>>2]|0;b=c[a+8>>2]|0;if((d|0)==(b|0))c[6720]=k&~(1<<(k>>>(n>>>3)&1^1)+(n>>>3));else{c[b+12>>2]=d;c[d+8>>2]=b}v=(k>>>(n>>>3)&1^1)+(n>>>3)<<3;c[a+4>>2]=v|3;c[a+v+4>>2]=c[a+v+4>>2]|1;v=a+8|0;l=w;return v|0}m=c[6722]|0;if(n>>>0>m>>>0){if(k>>>(n>>>3)|0){a=k>>>(n>>>3)<<(n>>>3)&(2<<(n>>>3)|0-(2<<(n>>>3)));e=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);f=e>>>(e>>>5&8)>>>(e>>>(e>>>5&8)>>>2&4);f=(e>>>5&8|((a&0-a)+-1|0)>>>12&16|e>>>(e>>>5&8)>>>2&4|f>>>1&2|f>>>(f>>>1&2)>>>1&1)+(f>>>(f>>>1&2)>>>(f>>>(f>>>1&2)>>>1&1))|0;e=c[26920+(f<<1<<2)+8>>2]|0;a=c[e+8>>2]|0;if((26920+(f<<1<<2)|0)==(a|0)){c[6720]=k&~(1<<f);a=k&~(1<<f)}else{c[a+12>>2]=26920+(f<<1<<2);c[26920+(f<<1<<2)+8>>2]=a;a=k}c[e+4>>2]=n|3;c[e+n+4>>2]=(f<<3)-n|1;c[e+n+((f<<3)-n)>>2]=(f<<3)-n;if(m|0){d=c[6725]|0;if(!(a&1<<(m>>>3))){c[6720]=a|1<<(m>>>3);a=26920+(m>>>3<<1<<2)+8|0;b=26920+(m>>>3<<1<<2)|0}else{a=26920+(m>>>3<<1<<2)+8|0;b=c[26920+(m>>>3<<1<<2)+8>>2]|0}c[a>>2]=d;c[b+12>>2]=d;c[d+8>>2]=b;c[d+12>>2]=26920+(m>>>3<<1<<2)}c[6722]=(f<<3)-n;c[6725]=e+n;v=e+8|0;l=w;return v|0}j=c[6721]|0;if(j){b=((j&0-j)+-1|0)>>>(((j&0-j)+-1|0)>>>12&16);d=b>>>(b>>>5&8)>>>(b>>>(b>>>5&8)>>>2&4);d=c[27184+((b>>>5&8|((j&0-j)+-1|0)>>>12&16|b>>>(b>>>5&8)>>>2&4|d>>>1&2|d>>>(d>>>1&2)>>>1&1)+(d>>>(d>>>1&2)>>>(d>>>(d>>>1&2)>>>1&1))<<2)>>2]|0;b=(c[d+4>>2]&-8)-n|0;a=c[d+16+(((c[d+16>>2]|0)==0&1)<<2)>>2]|0;if(!a){i=b;h=d}else{do{h=(c[a+4>>2]&-8)-n|0;i=h>>>0<b>>>0;b=i?h:b;d=i?a:d;a=c[a+16+(((c[a+16>>2]|0)==0&1)<<2)>>2]|0}while((a|0)!=0);i=b;h=d}g=h+n|0;if(h>>>0<g>>>0){f=c[h+24>>2]|0;a=c[h+12>>2]|0;do if((a|0)==(h|0)){b=h+20|0;a=c[b>>2]|0;if(!a){b=h+16|0;a=c[b>>2]|0;if(!a){b=0;break}}while(1){e=a+20|0;d=c[e>>2]|0;if(d|0){a=d;b=e;continue}e=a+16|0;d=c[e>>2]|0;if(!d)break;else{a=d;b=e}}c[b>>2]=0;b=a}else{b=c[h+8>>2]|0;c[b+12>>2]=a;c[a+8>>2]=b;b=a}while(0);do if(f|0){a=c[h+28>>2]|0;if((h|0)==(c[27184+(a<<2)>>2]|0)){c[27184+(a<<2)>>2]=b;if(!b){c[6721]=j&~(1<<a);break}}else{c[f+16+(((c[f+16>>2]|0)!=(h|0)&1)<<2)>>2]=b;if(!b)break}c[b+24>>2]=f;a=c[h+16>>2]|0;if(a|0){c[b+16>>2]=a;c[a+24>>2]=b}a=c[h+20>>2]|0;if(a|0){c[b+20>>2]=a;c[a+24>>2]=b}}while(0);if(i>>>0<16){v=i+n|0;c[h+4>>2]=v|3;v=h+v+4|0;c[v>>2]=c[v>>2]|1}else{c[h+4>>2]=n|3;c[g+4>>2]=i|1;c[g+i>>2]=i;if(m|0){d=c[6725]|0;if(!(k&1<<(m>>>3))){c[6720]=k|1<<(m>>>3);a=26920+(m>>>3<<1<<2)+8|0;b=26920+(m>>>3<<1<<2)|0}else{a=26920+(m>>>3<<1<<2)+8|0;b=c[26920+(m>>>3<<1<<2)+8>>2]|0}c[a>>2]=d;c[b+12>>2]=d;c[d+8>>2]=b;c[d+12>>2]=26920+(m>>>3<<1<<2)}c[6722]=i;c[6725]=g}v=h+8|0;l=w;return v|0}}}}else if(a>>>0<=4294967231){n=a+11&-8;e=c[6721]|0;if(e){if((a+11|0)>>>8)if(n>>>0>16777215)j=31;else{j=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);j=14-((j+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((j<<((j+520192|0)>>>16&4))+245760|0)>>>16&2)+(j<<((j+520192|0)>>>16&4)<<(((j<<((j+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;j=n>>>(j+7|0)&1|j<<1}else j=0;a=c[27184+(j<<2)>>2]|0;a:do if(!a){d=0-n|0;a=0;b=0;u=57}else{h=0-n|0;g=0;i=n<<((j|0)==31?0:25-(j>>>1)|0);b=0;while(1){d=(c[a+4>>2]&-8)-n|0;if(d>>>0<h>>>0)if(!d){d=0;f=a;b=a;u=61;break a}else b=a;else d=h;f=c[a+20>>2]|0;a=c[a+16+(i>>>31<<2)>>2]|0;g=(f|0)==0|(f|0)==(a|0)?g:f;f=(a|0)==0;if(f){a=g;u=57;break}else{h=d;i=i<<((f^1)&1)}}}while(0);if((u|0)==57){if((a|0)==0&(b|0)==0){a=2<<j;if(!(e&(a|0-a)))break;m=(e&(a|0-a)&0-(e&(a|0-a)))+-1|0;b=m>>>(m>>>12&16)>>>(m>>>(m>>>12&16)>>>5&8);a=b>>>(b>>>2&4)>>>(b>>>(b>>>2&4)>>>1&2);a=c[27184+((m>>>(m>>>12&16)>>>5&8|m>>>12&16|b>>>2&4|b>>>(b>>>2&4)>>>1&2|a>>>1&1)+(a>>>(a>>>1&1))<<2)>>2]|0;b=0}if(!a){i=d;j=b}else{f=a;u=61}}if((u|0)==61)while(1){u=0;a=(c[f+4>>2]&-8)-n|0;m=a>>>0<d>>>0;a=m?a:d;b=m?f:b;f=c[f+16+(((c[f+16>>2]|0)==0&1)<<2)>>2]|0;if(!f){i=a;j=b;break}else{d=a;u=61}}if((j|0)!=0?i>>>0<((c[6722]|0)-n|0)>>>0:0){h=j+n|0;if(j>>>0>=h>>>0){v=0;l=w;return v|0}g=c[j+24>>2]|0;a=c[j+12>>2]|0;do if((a|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){a=0;break}}while(1){f=a+20|0;d=c[f>>2]|0;if(d|0){a=d;b=f;continue}f=a+16|0;d=c[f>>2]|0;if(!d)break;else{a=d;b=f}}c[b>>2]=0}else{v=c[j+8>>2]|0;c[v+12>>2]=a;c[a+8>>2]=v}while(0);do if(g){b=c[j+28>>2]|0;if((j|0)==(c[27184+(b<<2)>>2]|0)){c[27184+(b<<2)>>2]=a;if(!a){c[6721]=e&~(1<<b);e=e&~(1<<b);break}}else{c[g+16+(((c[g+16>>2]|0)!=(j|0)&1)<<2)>>2]=a;if(!a)break}c[a+24>>2]=g;b=c[j+16>>2]|0;if(b|0){c[a+16>>2]=b;c[b+24>>2]=a}b=c[j+20>>2]|0;if(b){c[a+20>>2]=b;c[b+24>>2]=a}}while(0);do if(i>>>0>=16){c[j+4>>2]=n|3;c[h+4>>2]=i|1;c[h+i>>2]=i;d=i>>>3;if(i>>>0<256){a=c[6720]|0;if(!(a&1<<d)){c[6720]=a|1<<d;a=26920+(d<<1<<2)+8|0;b=26920+(d<<1<<2)|0}else{a=26920+(d<<1<<2)+8|0;b=c[26920+(d<<1<<2)+8>>2]|0}c[a>>2]=h;c[b+12>>2]=h;c[h+8>>2]=b;c[h+12>>2]=26920+(d<<1<<2);break}a=i>>>8;if(a)if(i>>>0>16777215)a=31;else{v=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);a=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(v+245760|0)>>>16&2)+(v<<((v+245760|0)>>>16&2)>>>15)|0;a=i>>>(a+7|0)&1|a<<1}else a=0;d=27184+(a<<2)|0;c[h+28>>2]=a;c[h+16+4>>2]=0;c[h+16>>2]=0;b=1<<a;if(!(e&b)){c[6721]=e|b;c[d>>2]=h;c[h+24>>2]=d;c[h+12>>2]=h;c[h+8>>2]=h;break}b=i<<((a|0)==31?0:25-(a>>>1)|0);d=c[d>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(i|0)){u=97;break}e=d+16+(b>>>31<<2)|0;a=c[e>>2]|0;if(!a){u=96;break}else{b=b<<1;d=a}}if((u|0)==96){c[e>>2]=h;c[h+24>>2]=d;c[h+12>>2]=h;c[h+8>>2]=h;break}else if((u|0)==97){u=d+8|0;v=c[u>>2]|0;c[v+12>>2]=h;c[u>>2]=h;c[h+8>>2]=v;c[h+12>>2]=d;c[h+24>>2]=0;break}}else{v=i+n|0;c[j+4>>2]=v|3;v=j+v+4|0;c[v>>2]=c[v>>2]|1}while(0);v=j+8|0;l=w;return v|0}}}else n=-1;while(0);d=c[6722]|0;if(d>>>0>=n>>>0){b=d-n|0;a=c[6725]|0;if(b>>>0>15){v=a+n|0;c[6725]=v;c[6722]=b;c[v+4>>2]=b|1;c[v+b>>2]=b;c[a+4>>2]=n|3}else{c[6722]=0;c[6725]=0;c[a+4>>2]=d|3;c[a+d+4>>2]=c[a+d+4>>2]|1}v=a+8|0;l=w;return v|0}f=c[6723]|0;if(f>>>0>n>>>0){t=f-n|0;c[6723]=t;v=c[6726]|0;u=v+n|0;c[6726]=u;c[u+4>>2]=t|1;c[v+4>>2]=n|3;v=v+8|0;l=w;return v|0}if(!(c[6838]|0)){c[6840]=4096;c[6839]=4096;c[6841]=-1;c[6842]=-1;c[6843]=0;c[6831]=0;c[w>>2]=w&-16^1431655768;c[6838]=w&-16^1431655768;a=4096}else a=c[6840]|0;g=n+48|0;h=n+47|0;j=a+h|0;i=0-a|0;if((j&i)>>>0<=n>>>0){v=0;l=w;return v|0}a=c[6830]|0;if(a|0?(m=c[6828]|0,(m+(j&i)|0)>>>0<=m>>>0?1:(m+(j&i)|0)>>>0>a>>>0):0){v=0;l=w;return v|0}b:do if(!(c[6831]&4)){b=c[6726]|0;c:do if(b){d=27328;while(1){a=c[d>>2]|0;if(a>>>0<=b>>>0?(p=d+4|0,(a+(c[p>>2]|0)|0)>>>0>b>>>0):0)break;a=c[d+8>>2]|0;if(!a){u=118;break c}else d=a}if((j-f&i)>>>0<2147483647){a=yc(j-f&i|0)|0;if((a|0)==((c[d>>2]|0)+(c[p>>2]|0)|0))if((a|0)==(-1|0))a=j-f&i;else{h=a;g=j-f&i;u=135;break b}else{e=a;d=j-f&i;u=126}}else a=0}else u=118;while(0);do if((u|0)==118){b=yc(0)|0;if((b|0)!=(-1|0)?(q=c[6839]|0,q=((q+-1&b|0)==0?0:(q+-1+b&0-q)-b|0)+(j&i)|0,o=c[6828]|0,q>>>0>n>>>0&q>>>0<2147483647):0){p=c[6830]|0;if(p|0?(q+o|0)>>>0<=o>>>0|(q+o|0)>>>0>p>>>0:0){a=0;break}a=yc(q|0)|0;if((a|0)==(b|0)){h=b;g=q;u=135;break b}else{e=a;d=q;u=126}}else a=0}while(0);do if((u|0)==126){b=0-d|0;if(!(g>>>0>d>>>0&(d>>>0<2147483647&(e|0)!=(-1|0))))if((e|0)==(-1|0)){a=0;break}else{h=e;g=d;u=135;break b}a=c[6840]|0;a=h-d+a&0-a;if(a>>>0>=2147483647){h=e;g=d;u=135;break b}if((yc(a|0)|0)==(-1|0)){yc(b|0)|0;a=0;break}else{h=e;g=a+d|0;u=135;break b}}while(0);c[6831]=c[6831]|4;u=133}else{a=0;u=133}while(0);if(((u|0)==133?(j&i)>>>0<2147483647:0)?(r=yc(j&i|0)|0,s=yc(0)|0,t=(s-r|0)>>>0>(n+40|0)>>>0,!((r|0)==(-1|0)|t^1|r>>>0<s>>>0&((r|0)!=(-1|0)&(s|0)!=(-1|0))^1)):0){h=r;g=t?s-r|0:a;u=135}if((u|0)==135){a=(c[6828]|0)+g|0;c[6828]=a;if(a>>>0>(c[6829]|0)>>>0)c[6829]=a;j=c[6726]|0;do if(j){f=27328;while(1){a=c[f>>2]|0;e=f+4|0;b=c[e>>2]|0;if((h|0)==(a+b|0)){u=145;break}d=c[f+8>>2]|0;if(!d)break;else f=d}if(((u|0)==145?(c[f+12>>2]&8|0)==0:0)?j>>>0<h>>>0&j>>>0>=a>>>0:0){c[e>>2]=b+g;u=(j+8&7|0)==0?0:0-(j+8)&7;v=(c[6723]|0)+(g-u)|0;c[6726]=j+u;c[6723]=v;c[j+u+4>>2]=v|1;c[j+u+v+4>>2]=40;c[6727]=c[6842];break}if(h>>>0<(c[6724]|0)>>>0)c[6724]=h;d=h+g|0;b=27328;while(1){if((c[b>>2]|0)==(d|0)){u=153;break}a=c[b+8>>2]|0;if(!a)break;else b=a}if((u|0)==153?(c[b+12>>2]&8|0)==0:0){c[b>>2]=h;m=b+4|0;c[m>>2]=(c[m>>2]|0)+g;m=h+8|0;m=h+((m&7|0)==0?0:0-m&7)|0;a=d+((d+8&7|0)==0?0:0-(d+8)&7)|0;k=m+n|0;i=a-m-n|0;c[m+4>>2]=n|3;do if((a|0)!=(j|0)){if((a|0)==(c[6725]|0)){v=(c[6722]|0)+i|0;c[6722]=v;c[6725]=k;c[k+4>>2]=v|1;c[k+v>>2]=v;break}h=c[a+4>>2]|0;if((h&3|0)==1){d:do if(h>>>0<256){b=c[a+8>>2]|0;d=c[a+12>>2]|0;if((d|0)==(b|0)){c[6720]=c[6720]&~(1<<(h>>>3));break}else{c[b+12>>2]=d;c[d+8>>2]=b;break}}else{g=c[a+24>>2]|0;b=c[a+12>>2]|0;do if((b|0)==(a|0)){b=c[a+16+4>>2]|0;if(!b){b=c[a+16>>2]|0;if(!b){b=0;break}else f=a+16|0}else f=a+16+4|0;while(1){e=b+20|0;d=c[e>>2]|0;if(d|0){b=d;f=e;continue}e=b+16|0;d=c[e>>2]|0;if(!d)break;else{b=d;f=e}}c[f>>2]=0}else{v=c[a+8>>2]|0;c[v+12>>2]=b;c[b+8>>2]=v}while(0);if(!g)break;d=c[a+28>>2]|0;do if((a|0)!=(c[27184+(d<<2)>>2]|0)){c[g+16+(((c[g+16>>2]|0)!=(a|0)&1)<<2)>>2]=b;if(!b)break d}else{c[27184+(d<<2)>>2]=b;if(b|0)break;c[6721]=c[6721]&~(1<<d);break d}while(0);c[b+24>>2]=g;d=c[a+16>>2]|0;if(d|0){c[b+16>>2]=d;c[d+24>>2]=b}d=c[a+16+4>>2]|0;if(!d)break;c[b+20>>2]=d;c[d+24>>2]=b}while(0);a=a+(h&-8)|0;f=(h&-8)+i|0}else f=i;d=a+4|0;c[d>>2]=c[d>>2]&-2;c[k+4>>2]=f|1;c[k+f>>2]=f;d=f>>>3;if(f>>>0<256){a=c[6720]|0;if(!(a&1<<d)){c[6720]=a|1<<d;a=26920+(d<<1<<2)+8|0;b=26920+(d<<1<<2)|0}else{a=26920+(d<<1<<2)+8|0;b=c[26920+(d<<1<<2)+8>>2]|0}c[a>>2]=k;c[b+12>>2]=k;c[k+8>>2]=b;c[k+12>>2]=26920+(d<<1<<2);break}a=f>>>8;do if(!a)b=0;else{if(f>>>0>16777215){b=31;break}b=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=f>>>(b+7|0)&1|b<<1}while(0);e=27184+(b<<2)|0;c[k+28>>2]=b;c[k+16+4>>2]=0;c[k+16>>2]=0;a=c[6721]|0;d=1<<b;if(!(a&d)){c[6721]=a|d;c[e>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}b=f<<((b|0)==31?0:25-(b>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(f|0)){u=194;break}e=d+16+(b>>>31<<2)|0;a=c[e>>2]|0;if(!a){u=193;break}else{b=b<<1;d=a}}if((u|0)==193){c[e>>2]=k;c[k+24>>2]=d;c[k+12>>2]=k;c[k+8>>2]=k;break}else if((u|0)==194){u=d+8|0;v=c[u>>2]|0;c[v+12>>2]=k;c[u>>2]=k;c[k+8>>2]=v;c[k+12>>2]=d;c[k+24>>2]=0;break}}else{v=(c[6723]|0)+i|0;c[6723]=v;c[6726]=k;c[k+4>>2]=v|1}while(0);v=m+8|0;l=w;return v|0}b=27328;while(1){a=c[b>>2]|0;if(a>>>0<=j>>>0?(v=a+(c[b+4>>2]|0)|0,v>>>0>j>>>0):0)break;b=c[b+8>>2]|0}f=v+-47+((v+-47+8&7|0)==0?0:0-(v+-47+8)&7)|0;f=f>>>0<(j+16|0)>>>0?j:f;a=h+8|0;a=(a&7|0)==0?0:0-a&7;u=h+a|0;a=g+-40-a|0;c[6726]=u;c[6723]=a;c[u+4>>2]=a|1;c[u+a+4>>2]=40;c[6727]=c[6842];c[f+4>>2]=27;c[f+8>>2]=c[6832];c[f+8+4>>2]=c[6833];c[f+8+8>>2]=c[6834];c[f+8+12>>2]=c[6835];c[6832]=h;c[6833]=g;c[6835]=0;c[6834]=f+8;a=f+24|0;do{u=a;a=a+4|0;c[a>>2]=7}while((u+8|0)>>>0<v>>>0);if((f|0)!=(j|0)){c[f+4>>2]=c[f+4>>2]&-2;c[j+4>>2]=f-j|1;c[f>>2]=f-j;if((f-j|0)>>>0<256){d=26920+((f-j|0)>>>3<<1<<2)|0;a=c[6720]|0;if(!(a&1<<((f-j|0)>>>3))){c[6720]=a|1<<((f-j|0)>>>3);a=d+8|0;b=d}else{a=d+8|0;b=c[d+8>>2]|0}c[a>>2]=j;c[b+12>>2]=j;c[j+8>>2]=b;c[j+12>>2]=d;break}if((f-j|0)>>>8)if((f-j|0)>>>0>16777215)b=31;else{b=(f-j|0)>>>8<<((((f-j|0)>>>8)+1048320|0)>>>16&8);b=14-((b+520192|0)>>>16&4|(((f-j|0)>>>8)+1048320|0)>>>16&8|((b<<((b+520192|0)>>>16&4))+245760|0)>>>16&2)+(b<<((b+520192|0)>>>16&4)<<(((b<<((b+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;b=(f-j|0)>>>(b+7|0)&1|b<<1}else b=0;e=27184+(b<<2)|0;c[j+28>>2]=b;c[j+20>>2]=0;c[j+16>>2]=0;a=c[6721]|0;d=1<<b;if(!(a&d)){c[6721]=a|d;c[e>>2]=j;c[j+24>>2]=e;c[j+12>>2]=j;c[j+8>>2]=j;break}b=f-j<<((b|0)==31?0:25-(b>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(f-j|0)){u=216;break}e=d+16+(b>>>31<<2)|0;a=c[e>>2]|0;if(!a){u=215;break}else{b=b<<1;d=a}}if((u|0)==215){c[e>>2]=j;c[j+24>>2]=d;c[j+12>>2]=j;c[j+8>>2]=j;break}else if((u|0)==216){u=d+8|0;v=c[u>>2]|0;c[v+12>>2]=j;c[u>>2]=j;c[j+8>>2]=v;c[j+12>>2]=d;c[j+24>>2]=0;break}}}else{v=c[6724]|0;if((v|0)==0|h>>>0<v>>>0)c[6724]=h;c[6832]=h;c[6833]=g;c[6835]=0;c[6729]=c[6838];c[6728]=-1;a=0;do{v=26920+(a<<1<<2)|0;c[v+12>>2]=v;c[v+8>>2]=v;a=a+1|0}while((a|0)!=32);v=h+8|0;v=(v&7|0)==0?0:0-v&7;u=h+v|0;v=g+-40-v|0;c[6726]=u;c[6723]=v;c[u+4>>2]=v|1;c[u+v+4>>2]=40;c[6727]=c[6842]}while(0);a=c[6723]|0;if(a>>>0>n>>>0){t=a-n|0;c[6723]=t;v=c[6726]|0;u=v+n|0;c[6726]=u;c[u+4>>2]=t|1;c[v+4>>2]=n|3;v=v+8|0;l=w;return v|0}}c[(oc()|0)>>2]=12;v=0;l=w;return v|0}function mc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;if(!a)return;b=c[6724]|0;d=c[a+-4>>2]|0;k=a+-8+(d&-8)|0;do if(!(d&1)){e=c[a+-8>>2]|0;if(!(d&3))return;g=a+-8+(0-e)|0;h=e+(d&-8)|0;if(g>>>0<b>>>0)return;if((g|0)==(c[6725]|0)){a=c[k+4>>2]|0;if((a&3|0)!=3){i=g;j=g;b=h;break}c[6722]=h;c[k+4>>2]=a&-2;c[g+4>>2]=h|1;c[g+h>>2]=h;return}if(e>>>0<256){a=c[g+8>>2]|0;b=c[g+12>>2]|0;if((b|0)==(a|0)){c[6720]=c[6720]&~(1<<(e>>>3));i=g;j=g;b=h;break}else{c[a+12>>2]=b;c[b+8>>2]=a;i=g;j=g;b=h;break}}f=c[g+24>>2]|0;a=c[g+12>>2]|0;do if((a|0)==(g|0)){a=c[g+16+4>>2]|0;if(!a){a=c[g+16>>2]|0;if(!a){a=0;break}else e=g+16|0}else e=g+16+4|0;while(1){d=a+20|0;b=c[d>>2]|0;if(b|0){a=b;e=d;continue}d=a+16|0;b=c[d>>2]|0;if(!b)break;else{a=b;e=d}}c[e>>2]=0}else{j=c[g+8>>2]|0;c[j+12>>2]=a;c[a+8>>2]=j}while(0);if(f){b=c[g+28>>2]|0;if((g|0)==(c[27184+(b<<2)>>2]|0)){c[27184+(b<<2)>>2]=a;if(!a){c[6721]=c[6721]&~(1<<b);i=g;j=g;b=h;break}}else{c[f+16+(((c[f+16>>2]|0)!=(g|0)&1)<<2)>>2]=a;if(!a){i=g;j=g;b=h;break}}c[a+24>>2]=f;b=c[g+16>>2]|0;if(b|0){c[a+16>>2]=b;c[b+24>>2]=a}b=c[g+16+4>>2]|0;if(b){c[a+20>>2]=b;c[b+24>>2]=a;i=g;j=g;b=h}else{i=g;j=g;b=h}}else{i=g;j=g;b=h}}else{i=a+-8|0;j=a+-8|0;b=d&-8}while(0);if(i>>>0>=k>>>0)return;d=c[k+4>>2]|0;if(!(d&1))return;if(!(d&2)){a=c[6725]|0;if((k|0)==(c[6726]|0)){k=(c[6723]|0)+b|0;c[6723]=k;c[6726]=j;c[j+4>>2]=k|1;if((j|0)!=(a|0))return;c[6725]=0;c[6722]=0;return}if((k|0)==(a|0)){k=(c[6722]|0)+b|0;c[6722]=k;c[6725]=i;c[j+4>>2]=k|1;c[i+k>>2]=k;return}f=(d&-8)+b|0;do if(d>>>0<256){b=c[k+8>>2]|0;a=c[k+12>>2]|0;if((a|0)==(b|0)){c[6720]=c[6720]&~(1<<(d>>>3));break}else{c[b+12>>2]=a;c[a+8>>2]=b;break}}else{g=c[k+24>>2]|0;a=c[k+12>>2]|0;do if((a|0)==(k|0)){a=c[k+16+4>>2]|0;if(!a){a=c[k+16>>2]|0;if(!a){b=0;break}else e=k+16|0}else e=k+16+4|0;while(1){d=a+20|0;b=c[d>>2]|0;if(b|0){a=b;e=d;continue}d=a+16|0;b=c[d>>2]|0;if(!b)break;else{a=b;e=d}}c[e>>2]=0;b=a}else{b=c[k+8>>2]|0;c[b+12>>2]=a;c[a+8>>2]=b;b=a}while(0);if(g|0){a=c[k+28>>2]|0;if((k|0)==(c[27184+(a<<2)>>2]|0)){c[27184+(a<<2)>>2]=b;if(!b){c[6721]=c[6721]&~(1<<a);break}}else{c[g+16+(((c[g+16>>2]|0)!=(k|0)&1)<<2)>>2]=b;if(!b)break}c[b+24>>2]=g;a=c[k+16>>2]|0;if(a|0){c[b+16>>2]=a;c[a+24>>2]=b}a=c[k+16+4>>2]|0;if(a|0){c[b+20>>2]=a;c[a+24>>2]=b}}}while(0);c[j+4>>2]=f|1;c[i+f>>2]=f;if((j|0)==(c[6725]|0)){c[6722]=f;return}}else{c[k+4>>2]=d&-2;c[j+4>>2]=b|1;c[i+b>>2]=b;f=b}d=f>>>3;if(f>>>0<256){a=c[6720]|0;if(!(a&1<<d)){c[6720]=a|1<<d;a=26920+(d<<1<<2)+8|0;b=26920+(d<<1<<2)|0}else{a=26920+(d<<1<<2)+8|0;b=c[26920+(d<<1<<2)+8>>2]|0}c[a>>2]=j;c[b+12>>2]=j;c[j+8>>2]=b;c[j+12>>2]=26920+(d<<1<<2);return}a=f>>>8;if(a)if(f>>>0>16777215)b=31;else{b=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=f>>>(b+7|0)&1|b<<1}else b=0;e=27184+(b<<2)|0;c[j+28>>2]=b;c[j+20>>2]=0;c[j+16>>2]=0;a=c[6721]|0;d=1<<b;do if(a&d){b=f<<((b|0)==31?0:25-(b>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(f|0)){a=73;break}e=d+16+(b>>>31<<2)|0;a=c[e>>2]|0;if(!a){a=72;break}else{b=b<<1;d=a}}if((a|0)==72){c[e>>2]=j;c[j+24>>2]=d;c[j+12>>2]=j;c[j+8>>2]=j;break}else if((a|0)==73){i=d+8|0;k=c[i>>2]|0;c[k+12>>2]=j;c[i>>2]=j;c[j+8>>2]=k;c[j+12>>2]=d;c[j+24>>2]=0;break}}else{c[6721]=a|d;c[e>>2]=j;c[j+24>>2]=e;c[j+12>>2]=j;c[j+8>>2]=j}while(0);k=(c[6728]|0)+-1|0;c[6728]=k;if(!k)a=27336;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[6728]=-1;return}function nc(){return 27376}function oc(){return (pc()|0)+64|0}function pc(){return qc()|0}function qc(){return 17464}function rc(){}function sc(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){y=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}y=(b|0)<0?-1:0;return b>>c-32|0}function tc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=N(b&65535,a&65535)|0;e=(c>>>16)+(N(b&65535,a>>>16)|0)|0;d=N(b>>>16,a&65535)|0;return (y=(e>>>16)+(N(b>>>16,a>>>16)|0)+(((e&65535)+d|0)>>>16)|0,e+d<<16|c&65535|0)|0}function uc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=tc(a,c)|0;f=y;return (y=(N(b,c)|0)+(N(d,a)|0)+f|f&0,e|0|0)|0}function vc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return (y=b+d+(a+c>>>0>>>0<a>>>0|0)>>>0,a+c>>>0|0)|0}function wc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=b+e|0;d=d&255;if((e|0)>=67){while(b&3){a[b>>0]=d;b=b+1|0}g=d|d<<8|d<<16|d<<24;while((b|0)<=((f&-4)-64|0)){c[b>>2]=g;c[b+4>>2]=g;c[b+8>>2]=g;c[b+12>>2]=g;c[b+16>>2]=g;c[b+20>>2]=g;c[b+24>>2]=g;c[b+28>>2]=g;c[b+32>>2]=g;c[b+36>>2]=g;c[b+40>>2]=g;c[b+44>>2]=g;c[b+48>>2]=g;c[b+52>>2]=g;c[b+56>>2]=g;c[b+60>>2]=g;b=b+64|0}while((b|0)<(f&-4|0)){c[b>>2]=g;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return f-e|0}function xc(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){y=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}y=0;return b>>>c-32|0}function yc(a){a=a|0;var b=0,d=0;d=a+15&-16|0;b=c[i>>2]|0;a=b+d|0;if((d|0)>0&(a|0)<(b|0)|(a|0)<0){V()|0;X(12);return -1}c[i>>2]=a;if((a|0)>(U()|0)?(T()|0)==0:0){c[i>>2]=b;X(12);return -1}return b|0}function zc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if((e|0)>=8192)return Y(b|0,d|0,e|0)|0;h=b|0;g=b+e|0;if((b&3)==(d&3)){while(b&3){if(!e)return h|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}e=g&-4|0;f=e-64|0;while((b|0)<=(f|0)){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];c[b+20>>2]=c[d+20>>2];c[b+24>>2]=c[d+24>>2];c[b+28>>2]=c[d+28>>2];c[b+32>>2]=c[d+32>>2];c[b+36>>2]=c[d+36>>2];c[b+40>>2]=c[d+40>>2];c[b+44>>2]=c[d+44>>2];c[b+48>>2]=c[d+48>>2];c[b+52>>2]=c[d+52>>2];c[b+56>>2]=c[d+56>>2];c[b+60>>2]=c[d+60>>2];b=b+64|0;d=d+64|0}while((b|0)<(e|0)){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}}else{e=g-4|0;while((b|0)<(e|0)){a[b>>0]=a[d>>0]|0;a[b+1>>0]=a[d+1>>0]|0;a[b+2>>0]=a[d+2>>0]|0;a[b+3>>0]=a[d+3>>0]|0;b=b+4|0;d=d+4|0}}while((b|0)<(g|0)){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0}return h|0}function Ac(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else zc(b,c,d)|0;return b|0}
function $(a){a=a|0;var b=0;b=l;l=l+a|0;l=l+15&-16;return b|0}function aa(){return l|0}function ba(a){a=a|0;l=a}function ca(a,b){a=a|0;b=b|0;l=a;m=b}function da(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function ea(a){a=a|0;y=a}function fa(){return y|0}function ga(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return na(a,b,c,d,e,0)|0}function ha(a,b){a=a|0;b=b|0;var c=0;c=l;l=l+16|0;a=ka(a,b,c)|0;l=c;return a|0}function ia(a){a=a|0;oa(a);return}function ja(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=l;l=l+16|0;a:do if((b|0)<16e3)if((b|0)<12e3){switch(b|0){case 8e3:break a;default:e=-1}l=f;return e|0}else{switch(b|0){case 12e3:break a;default:e=-1}l=f;return e|0}else{if((b|0)<24e3){switch(b|0){case 16e3:break a;default:e=-1}l=f;return e|0}if((b|0)<48e3){switch(b|0){case 24e3:break a;default:e=-1}l=f;return e|0}else{switch(b|0){case 48e3:break a;default:e=-1}l=f;return e|0}}while(0);if((d+-1|0)>>>0>1){a=-1;l=f;return a|0}if(!(Za(f+8|0)|0)){c[f+8>>2]=(c[f+8>>2]|0)+3&-4;e=pa(d)|0;e=e+88+(c[f+8>>2]|0)|0}else e=0;wc(a|0,0,e|0)|0;if(Za(f+4|0)|0){a=-3;l=f;return a|0}e=(c[f+4>>2]|0)+3&-4;c[f+4>>2]=e;c[a+4>>2]=88;c[a>>2]=e+88;c[a+8>>2]=d;c[a+48>>2]=d;c[a+12>>2]=b;c[a+24>>2]=b;c[a+16>>2]=d;if(_a(a+88|0)|0){a=-3;l=f;return a|0}if(qa(a+(e+88)|0,b,d)|0){a=-3;l=f;return a|0}c[f>>2]=0;ra(a+(e+88)|0,10016,f)|0;c[a+60>>2]=0;c[a+64>>2]=(b|0)/400|0;c[a+44>>2]=0;a=0;l=f;return a|0}function ka(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=l;l=l+16|0;a:do if((a|0)<16e3)if((a|0)<12e3)switch(a|0){case 8e3:{e=2;break a}default:break a}else switch(a|0){case 12e3:{e=2;break a}default:break a}else{if((a|0)<24e3)switch(a|0){case 16e3:{e=2;break a}default:break a}if((a|0)<48e3)switch(a|0){case 24e3:{e=2;break a}default:break a}else switch(a|0){case 48e3:{e=2;break a}default:break a}}while(0);if((e|0)==2?(b+-1|0)>>>0<=1:0){if(!(Za(g)|0)){c[g>>2]=(c[g>>2]|0)+3&-4;e=pa(b)|0;e=e+88+(c[g>>2]|0)|0}else e=0;f=lc(e)|0;if(!f){if(!d){d=0;l=g;return d|0}c[d>>2]=-7;d=0;l=g;return d|0}e=ja(f,a,b)|0;if(d|0)c[d>>2]=e;if(!e){d=f;l=g;return d|0}mc(f);d=0;l=g;return d|0}if(!d){d=0;l=g;return d|0}c[d>>2]=-1;d=0;l=g;return d|0}function la(e,f,h,i,j,k,m,n,o){e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=l;l=l+112|0;if(k>>>0>1){e=-1;l=y;return e|0}if((f|0)==0|((h|0)==0|(k|0)!=0)?(j|0)%((c[e+12>>2]|0)/400|0|0)|0|0:0){e=-1;l=y;return e|0}if((f|0)==0|(h|0)==0){q=0;do{p=ma(e,0,0,i+((N(c[e+8>>2]|0,q)|0)<<2)|0,j-q|0,0)|0;q=((p|0)<0?0:p)+q|0;if((p|0)<0){w=p;x=43;break}}while((q|0)<(j|0));if((x|0)==43){l=y;return w|0}c[e+72>>2]=q;e=q;l=y;return e|0}if((h|0)<0){e=-1;l=y;return e|0}q=d[f>>0]|0;v=(q&128|0)==0?((q&96|0)==96?1001:1e3):1002;do if(!(q&128))if((q&96|0)==96){t=q>>>4&1|1104;break}else{t=(q>>>5&3)+1101|0;break}else t=(q>>>5&3|0)==0?1101:(q>>>5&3)+1102|0;while(0);u=kb(f,c[e+12>>2]|0)|0;s=((a[f>>0]&4)>>>2)+1|0;r=lb(f,h,m,y+104|0,0,y+8|0,y,n)|0;if((r|0)<0){e=r;l=y;return e|0}n=f+(c[y>>2]|0)|0;if(!k){if((N(r,u)|0)>(j|0)){e=-2;l=y;return e|0}c[e+56>>2]=v;c[e+52>>2]=t;c[e+64>>2]=u;c[e+48>>2]=s;a:do if((r|0)>0){m=0;p=0;while(1){h=y+8+(m<<1)|0;q=ma(e,n,b[h>>1]|0,i+((N(c[e+8>>2]|0,p)|0)<<2)|0,j-p|0,0)|0;if((q|0)<0){w=q;break}p=q+p|0;m=m+1|0;if((m|0)>=(r|0))break a;else n=n+(b[h>>1]|0)|0}l=y;return w|0}else p=0;while(0);c[e+72>>2]=p;if(!o){g[e+80>>2]=0.0;g[e+76>>2]=0.0;e=p;l=y;return e|0}else{jb(i,p,c[e+8>>2]|0,e+76|0);e=p;l=y;return e|0}}if(!((v|0)==1002|(u|0)>(j|0))?(c[e+56>>2]|0)!=1002:0){m=c[e+72>>2]|0;do if(!(j-u|0))p=e+8|0;else{if(!((j-u|0)%((c[e+12>>2]|0)/400|0|0)|0)){h=0;while(1){q=ma(e,0,0,i+((N(c[e+8>>2]|0,h)|0)<<2)|0,j-u-h|0,0)|0;h=((q|0)<0?0:q)+h|0;if((q|0)<0){p=q;break}if((h|0)>=(j-u|0)){x=30;break}}if((x|0)==30){c[e+72>>2]=h;p=h}if((p|0)>=0){p=e+8|0;break}}else p=-1;c[e+72>>2]=m;e=p;l=y;return e|0}while(0);c[e+56>>2]=v;c[e+52>>2]=t;c[e+64>>2]=u;c[e+48>>2]=s;p=ma(e,n,b[y+8>>1]|0,i+((N(c[p>>2]|0,j-u|0)|0)<<2)|0,u,1)|0;if((p|0)<0){e=p;l=y;return e|0}c[e+72>>2]=j;e=j;l=y;return e|0}if((j|0)%((c[e+12>>2]|0)/400|0|0)|0|0){e=-1;l=y;return e|0}q=0;do{p=ma(e,0,0,i+((N(c[e+8>>2]|0,q)|0)<<2)|0,j-q|0,0)|0;q=((p|0)<0?0:p)+q|0;if((p|0)<0){w=p;x=43;break}}while((q|0)<(j|0));if((x|0)==43){l=y;return w|0}c[e+72>>2]=q;e=q;l=y;return e|0}function ma(a,d,e,f,h,i){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,O=0.0,P=0,R=0,S=0.0;R=l;l=l+144|0;c[R+84>>2]=0;t=a+(c[a+4>>2]|0)|0;D=a+(c[a>>2]|0)|0;B=c[a+12>>2]|0;q=((B|0)/50|0)>>1;I=((B|0)/50|0)>>2;M=((B|0)/50|0)>>3;if((M|0)>(h|0)){a=-2;l=R;return a|0}k=(((B|0)/25|0)*3|0)>(h|0)?h:((B|0)/25|0)*3|0;do if((e|0)>=2)if(d){j=c[a+64>>2]|0;o=c[a+56>>2]|0;xa(R+96|0,d,e);h=c[a+60>>2]|0;if((h|0)>0){if(!(!((h|0)==1002|(o|0)==1002^1)?!(c[a+68>>2]|0):0)){if((o|0)==1002){m=1;h=1002;r=19;break}if((h|0)!=1002){m=1;h=o;r=19;break}}L=N(c[a+8>>2]|0,I)|0;n=(o|0)==1002?1:L;h=Z()|0;m=l;l=l+((1*(((o|0)==1002?L:1)<<2)|0)+15&-16)|0;if((o|0)==1002){ma(a,0,0,m,(I|0)<(j|0)?I:j,0)|0;L=h;J=j;p=1;z=(o|0)==1002;A=d;h=1002;w=m;u=n;v=1}else{L=h;J=j;p=1;z=(o|0)==1002;A=d;h=o;w=0;u=n;v=1}}else{m=1;h=o;r=19}}else r=5;else{r=c[a+64>>2]|0;k=(k|0)<(r|0)?k:r;r=5}while(0);do if((r|0)==5){h=c[a+60>>2]|0;if(!h){h=N(c[a+8>>2]|0,k)|0;if((h|0)<=0){a=k;l=R;return a|0}wc(f|0,0,h<<2|0)|0;a=k;l=R;return a|0}if((k|0)<=((B|0)/50|0|0)){if((k|0)>=((B|0)/50|0|0)){j=k;m=0;d=0;r=19;break}j=(k|0)>(q|0)?q:(k|0)<(q|0)&((k|0)>(I|0)&(h|0)!=1e3)?I:k;m=0;d=0;r=19;break}j=k;while(1){h=ma(a,0,0,f,(j|0)<((B|0)/50|0|0)?j:(B|0)/50|0,0)|0;j=j-h|0;if((h|0)<0){r=103;break}f=f+((N(c[a+8>>2]|0,h)|0)<<2)|0;if((j|0)<=0){h=k;r=103;break}}if((r|0)==103){l=R;return h|0}}while(0);if((r|0)==19){L=Z()|0;J=j;p=m;z=(h|0)==1002;A=d;w=0;u=1;v=0}a:do if((J|0)>(k|0))h=-1;else{do if(!z){y=(N(c[a+8>>2]|0,(q|0)>(J|0)?q:J)|0)<<1;q=l;l=l+((1*y|0)+15&-16)|0;if((c[a+60>>2]|0)==1002)_a(t)|0;y=(J*1e3|0)/(c[a+12>>2]|0)|0;c[a+32>>2]=(y|0)>10?y:10;if(p){c[a+20>>2]=c[a+48>>2];if((h|0)==1e3){j=c[a+52>>2]|0;j=(j|0)==1101?8e3:(j|0)==1102?12e3:16e3}else j=16e3;c[a+28>>2]=j}j=(A|0)==0?1:i<<1;if(!j){j=0;k=q;do{if($a(t,a+16|0,0,(j|0)==0&1,R+96|0,k,R+88|0,c[a+44>>2]|0)|0){h=-3;break a}y=c[R+88>>2]|0;k=k+((N(c[a+8>>2]|0,y)|0)<<1)|0;j=y+j|0}while((j|0)<(J|0))}else{k=0;m=q;do{if($a(t,a+16|0,j,(k|0)==0&1,R+96|0,m,R+88|0,c[a+44>>2]|0)|0?(c[R+88>>2]=J,s=N(c[a+8>>2]|0,J)|0,(s|0)>0):0)wc(m|0,0,s<<1|0)|0;y=c[R+88>>2]|0;m=m+((N(c[a+8>>2]|0,y)|0)<<1)|0;k=y+k|0}while((k|0)<(J|0))}if((i|0)==0&p?(y=Q(c[R+96+28>>2]|0)|0,((c[R+96+20>>2]|0)+-15+y+((c[a+56>>2]|0)==1001?20:0)|0)<=(e<<3|0)):0){if((h|0)==1001){j=Ba(R+96|0,12)|0;if(!j){k=0;m=1;y=1001;n=0;o=0;d=q;break}k=Ba(R+96|0,1)|0;m=(Da(R+96|0,256)|0)+2|0;d=c[R+96+20>>2]|0;n=c[R+96+28>>2]|0}else{k=Ba(R+96|0,1)|0;d=c[R+96+20>>2]|0;n=c[R+96+28>>2]|0;m=e-(d+-25+(Q(n|0)|0)>>3)|0;j=1}e=e-m|0;n=(e<<3|0)<(d+-32+(Q(n|0)|0)|0);o=n?0:m;c[R+96+4>>2]=(c[R+96+4>>2]|0)-o;m=1;e=n?0:e;y=h;n=n?0:j;d=q}else{k=0;m=1;y=h;n=0;o=0;d=q}}else{d=l;l=l+16|0;k=0;m=0;y=1002;n=0;o=0}while(0);j=m?17:0;switch(c[a+52>>2]|0){case 1101:{h=13;break}case 1103:case 1102:{h=17;break}case 1104:{h=19;break}default:h=21}c[R>>2]=h;ra(D,10012,R)|0;c[R+8>>2]=c[a+48>>2];ra(D,10008,R+8|0)|0;x=(n|0)!=0;h=l;l=l+((1*((x?1:u)<<2)|0)+15&-16)|0;q=v&(x^1);if(m&q){ma(a,0,0,h,(I|0)<(J|0)?I:J,0)|0;s=h}else s=w;if(x){w=(N(c[a+8>>2]|0,I)|0)<<2;h=l;l=l+((1*w|0)+15&-16)|0;if(!k){m=0;t=0;k=h}else{c[R+16>>2]=0;ra(D,10010,R+16|0)|0;sa(D,A+e|0,o,h,I,0,0)|0;c[R+24>>2]=R+84;ra(D,4031,R+24|0)|0;m=1;t=1;k=h}}else{w=l;l=l+16|0;m=0;t=(k|0)!=0;k=w}c[R+32>>2]=j;ra(D,10010,R+32|0)|0;if((y|0)==1e3){b[R+32>>1]=-1;h=N(c[a+8>>2]|0,J)|0;if((h|0)>0)wc(f|0,0,h<<2|0)|0;do if((c[a+60>>2]|0)==1001){if(m?c[a+68>>2]|0:0)break;c[R+48>>2]=0;ra(D,10010,R+48|0)|0;sa(D,R+32|0,2,f,M,0,0)|0}while(0);r=0}else{h=((B|0)/50|0|0)<(J|0)?(B|0)/50|0:J;B=c[a+60>>2]|0;if((y|0)!=(B|0)&(B|0)>0?(c[a+68>>2]|0)==0:0)ra(D,4028,R+40|0)|0;r=sa(D,i|0?0:A,e,f,h,R+96|0,0)|0}if(!z?(C=N(c[a+8>>2]|0,J)|0,(C|0)>0):0){h=0;do{B=f+(h<<2)|0;g[B>>2]=+g[B>>2]+ +(b[d+(h<<1)>>1]|0)*.000030517578125;h=h+1|0}while((h|0)<(C|0))}c[R+56>>2]=R+32;ra(D,10015,R+56|0)|0;p=c[(c[R+32>>2]|0)+60>>2]|0;if(!((n|0)==0|t)?(ra(D,4028,R+64|0)|0,c[R+72>>2]=0,ra(D,10010,R+72|0)|0,sa(D,A+e|0,o,k,I,0,0)|0,c[R+80>>2]=R+84,ra(D,4031,R+80|0)|0,E=c[a+8>>2]|0,F=f+((N(E,J-M|0)|0)<<2)|0,G=k+((N(E,M)|0)<<2)|0,H=48e3/(c[a+12>>2]|0)|0,(M|0)>0&(E|0)>0):0){h=0;do{j=0;do{S=+g[p+((N(j,H)|0)<<2)>>2];D=(N(j,E)|0)+h|0;g[F+(D<<2)>>2]=S*S*+g[G+(D<<2)>>2]+(1.0-S*S)*+g[F+(D<<2)>>2];j=j+1|0}while((j|0)!=(M|0));h=h+1|0}while((h|0)!=(E|0))}if(m){n=c[a+8>>2]|0;if((n|0)>0&(M|0)>0){h=0;do{j=0;do{H=(N(j,n)|0)+h|0;c[f+(H<<2)>>2]=c[k+(H<<2)>>2];j=j+1|0}while((j|0)!=(M|0));h=h+1|0}while((h|0)<(n|0))}d=N(n,M)|0;h=k+(d<<2)|0;k=48e3/(c[a+12>>2]|0)|0;if((M|0)>0&(n|0)>0){j=0;do{m=0;do{S=+g[p+((N(m,k)|0)<<2)>>2];H=(N(m,n)|0)+j|0;g[f+(d<<2)+(H<<2)>>2]=S*S*+g[f+(d<<2)+(H<<2)>>2]+(1.0-S*S)*+g[h+(H<<2)>>2];m=m+1|0}while((m|0)!=(M|0));j=j+1|0}while((j|0)!=(n|0))}}b:do if(q){n=c[a+8>>2]|0;if((J|0)<(I|0)){j=48e3/(c[a+12>>2]|0)|0;if((M|0)>0&(n|0)>0)h=0;else break;while(1){k=0;do{S=+g[p+((N(k,j)|0)<<2)>>2];I=(N(k,n)|0)+h|0;g[f+(I<<2)>>2]=S*S*+g[f+(I<<2)>>2]+(1.0-S*S)*+g[s+(I<<2)>>2];k=k+1|0}while((k|0)!=(M|0));h=h+1|0;if((h|0)==(n|0))break b}}d=N(n,M)|0;if((d|0)>0){h=0;do{c[f+(h<<2)>>2]=c[s+(h<<2)>>2];h=h+1|0}while((h|0)<(d|0))}h=s+(d<<2)|0;k=48e3/(c[a+12>>2]|0)|0;if((M|0)>0&(n|0)>0){j=0;do{m=0;do{S=+g[p+((N(m,k)|0)<<2)>>2];I=(N(m,n)|0)+j|0;g[f+(d<<2)+(I<<2)>>2]=S*S*+g[f+(d<<2)+(I<<2)>>2]+(1.0-S*S)*+g[h+(I<<2)>>2];m=m+1|0}while((m|0)!=(M|0));j=j+1|0}while((j|0)!=(n|0))}}while(0);h=c[a+40>>2]|0;if(h|0?(O=+K(+(+(h|0)*6.488140788860619e-04*.6931471805599453)),P=N(c[a+8>>2]|0,J)|0,(P|0)>0):0){h=0;do{M=f+(h<<2)|0;g[M>>2]=O*+g[M>>2];h=h+1|0}while((h|0)<(P|0))}if((e|0)<2)h=0;else h=c[R+84>>2]^c[R+96+28>>2];c[a+84>>2]=h;c[a+60>>2]=y;c[a+68>>2]=x&(t^1)&1;h=(r|0)<0?r:J}while(0);W(L|0);a=h;l=R;return a|0}function na(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;if((e|0)<1){a=-1;return a|0}a=la(a,b,c,d,e,f,0,0,0)|0;return a|0}function oa(a){a=a|0;mc(a);return}function pa(a){a=a|0;var b=0;b=Ga(48e3,960,0)|0;return (c[b+8>>2]<<5)+92+(N((c[b+4>>2]<<2)+8288|0,a)|0)|0}function qa(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=l;l=l+16|0;e=Ga(48e3,960,0)|0;if(d>>>0>2){a=-1;l=f;return a|0}if(!a){a=-7;l=f;return a|0}wc(a|0,0,(c[e+8>>2]<<5)+92+(N((c[e+4>>2]<<2)+8288|0,d)|0)|0)|0;c[a>>2]=e;c[a+4>>2]=c[e+4>>2];c[a+8>>2]=d;c[a+12>>2]=d;c[a+16>>2]=1;c[a+20>>2]=0;c[a+24>>2]=c[e+12>>2];c[a+28>>2]=1;c[a+32>>2]=0;c[a+36>>2]=0;ra(a,4028,f)|0;b=wb(b)|0;c[a+16>>2]=b;a=((b|0)==0)<<31>>31;l=f;return a|0}function ra(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=l;l=l+16|0;c[f>>2]=d;do switch(b|0){case 10010:{e=(c[f>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[f>>2]=e+4;if((b|0)>=0?(b|0)<(c[(c[a>>2]|0)+8>>2]|0):0){c[a+20>>2]=b;b=28}else b=29;break}case 10012:{e=(c[f>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[f>>2]=e+4;if((b|0)>=1?(b|0)<=(c[(c[a>>2]|0)+8>>2]|0):0){c[a+24>>2]=b;b=28}else b=29;break}case 10008:{e=(c[f>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[f>>2]=e+4;if((b+-1|0)>>>0>1)b=29;else{c[a+12>>2]=b;b=28}break}case 10007:{e=(c[f>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[f>>2]=e+4;if(!b)b=29;else{c[b>>2]=c[a+44>>2];c[a+44>>2]=0;b=28}break}case 4027:{e=(c[f>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[f>>2]=e+4;if(!b)b=29;else{c[b>>2]=(c[a+4>>2]|0)/(c[a+16>>2]|0)|0;b=28}break}case 4028:{e=c[a+8>>2]|0;d=a+92+((N((c[a+4>>2]|0)+2048|0,e)|0)<<2)+(e*24<<2)|0;h=c[a>>2]|0;b=c[h+8>>2]|0;wc(a+40|0,0,(b<<5)+52+(N((c[h+4>>2]<<2)+8288|0,e)|0)|0)|0;if((b|0)>0){e=0;do{g[d+(b<<1<<2)+(b<<1<<2)+(e<<2)>>2]=-28.0;g[d+(b<<1<<2)+(e<<2)>>2]=-28.0;e=e+1|0}while((e|0)<(c[(c[a>>2]|0)+8>>2]<<1|0))}c[a+56>>2]=1;b=28;break}case 4033:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;if(!b)b=29;else{c[b>>2]=c[a+60>>2];b=28}break}case 10015:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;if(!b)b=29;else{c[b>>2]=c[a>>2];b=28}break}case 10016:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;c[a+28>>2]=b;b=28;break}case 4031:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;if(!b)b=29;else{c[b>>2]=c[a+40>>2];b=28}break}case 4046:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;if(b>>>0>1)b=29;else{c[a+32>>2]=b;b=28}break}case 4047:{h=(c[f>>2]|0)+(4-1)&~(4-1);b=c[h>>2]|0;c[f>>2]=h+4;if(!b)b=29;else{c[b>>2]=c[a+32>>2];b=28}break}default:{h=-5;l=f;return h|0}}while(0);if((b|0)==28){h=0;l=f;return h|0}else if((b|0)==29){h=-1;l=f;return h|0}return 0}function sa(d,e,f,h,i,j,k){d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,X=0,Y=0,_=0,$=0.0,aa=0.0;_=l;l=l+80|0;V=c[d+8>>2]|0;c[_+8>>2]=0;c[_+4>>2]=0;J=c[d+12>>2]|0;X=c[d>>2]|0;Y=c[X+8>>2]|0;K=c[X+4>>2]|0;u=c[X+32>>2]|0;O=c[d+20>>2]|0;P=c[d+24>>2]|0;U=N(c[d+16>>2]|0,i)|0;T=d+92+((N(K+2048|0,V)|0)<<2)+(V*24<<2)|0;R=T+(Y<<1<<2)|0;S=R+(Y<<1<<2)|0;n=c[X+36>>2]|0;if((n|0)<0){d=-1;l=_;return d|0}i=c[X+44>>2]|0;H=0;while(1){if((i<<H|0)==(U|0))break;if((H|0)<(n|0))H=H+1|0;else{i=-1;o=81;break}}if((o|0)==81){l=_;return i|0}I=1<<H;if(f>>>0>1275|(h|0)==0){d=-1;l=_;return d|0}i=0;do{M=d+92+((N(i,K+2048|0)|0)<<2)|0;c[_+24+(i<<2)>>2]=M;c[_+16+(i<<2)>>2]=M+8192+(0-U<<2);i=i+1|0}while((i|0)<(V|0));G=c[X+12>>2]|0;G=(P|0)>(G|0)?G:P;if((e|0)==0|(f|0)<2){ta(d,U,H);ua(_+16|0,h,U,V,c[d+16>>2]|0,X+16|0,d+84|0,k);d=(U|0)/(c[d+16>>2]|0)|0;l=_;return d|0}c[d+56>>2]=(c[d+52>>2]|0)!=0&1;if(!j){xa(_+32|0,e,f);j=_+32|0}if((J|0)==1&(Y|0)>0){i=0;do{M=T+(i<<2)|0;L=i+Y|0;c[M>>2]=c[T+((+g[M>>2]>+g[T+(L<<2)>>2]?i:L)<<2)>>2];i=i+1|0}while((i|0)!=(Y|0))}L=j+20|0;i=c[L>>2]|0;M=j+28|0;n=c[M>>2]|0;e=i+-32+(Q(n|0)|0)|0;if((e|0)<(f<<3|0))if((e|0)==1){i=Ba(j,15)|0;if(!i){i=0;e=1;E=0}else{e=c[L>>2]|0;n=c[M>>2]|0;o=18}}else{i=0;E=0}else{e=i;i=1;o=18}if((o|0)==18){c[L>>2]=(f<<3)+32-e-(Q(n|0)|0)+e;e=f<<3;E=1}if((O|0)!=0|(e+16|0)>(f<<3|0)){D=0;C=0;m=0.0}else{if(!(Ba(j,1)|0)){m=0.0;n=0;e=0}else{o=Da(j,6)|0;o=(Ea(j,o+4|0)|0)+-1+(16<<o)|0;n=Ea(j,3)|0;if(((c[L>>2]|0)+-30+(Q(c[M>>2]|0)|0)|0)>(f<<3|0))e=0;else e=Ca(j,22198,2)|0;m=+(n+1|0)*.09375;n=o}D=n;C=e;e=(c[L>>2]|0)+-32+(Q(c[M>>2]|0)|0)|0}if((H|0)<1|(e+3|0)>(f<<3|0))A=0;else{A=Ba(j,3)|0;e=(c[L>>2]|0)+-32+(Q(c[M>>2]|0)|0)|0}B=(A|0)!=0;z=B?I:0;if((e+3|0)>(f<<3|0))n=0;else n=Ba(j,3)|0;Pa(X,O,P,T,n,j,J,H);F=Z()|0;y=l;l=l+((1*(Y<<2)|0)+15&-16)|0;s=c[j+4>>2]<<3;o=(c[L>>2]|0)+-32+(Q(c[M>>2]|0)|0)|0;n=B?2:4;t=(H|0)>0&(o+(n|1)|0)>>>0<=s>>>0;if((O|0)<(P|0)){r=B?4:5;p=0;e=O;q=n;n=0;while(1){if((q+o|0)>>>0<=(s-(t&1)|0)>>>0){x=(Ba(j,q)|0)^p;p=x;o=(c[L>>2]|0)+-32+(Q(c[M>>2]|0)|0)|0;n=x|n}c[y+(e<<2)>>2]=p;e=e+1|0;if((e|0)==(P|0))break;else q=r}}else n=0;if(t?(x=A<<2,(a[n+x+(23518+(H<<3))>>0]|0)!=(a[n+(x|2)+(23518+(H<<3))>>0]|0)):0)n=(Ba(j,1)|0)<<1;else n=0;if((O|0)<(P|0)){n=n+(A<<2)|0;e=O;do{x=y+(e<<2)|0;c[x>>2]=a[n+(c[x>>2]|0)+(23518+(H<<3))>>0];e=e+1|0}while((e|0)!=(P|0))}if(((c[L>>2]|0)+-28+(Q(c[M>>2]|0)|0)|0)>(f<<3|0))x=2;else x=Ca(j,22201,5)|0;v=l;l=l+((1*(Y<<2)|0)+15&-16)|0;yb(X,v,H,J);w=l;l=l+((1*(Y<<2)|0)+15&-16)|0;n=wa(j)|0;if((O|0)<(P|0)){s=6;t=O;e=n;n=f<<6;while(1){q=t;t=t+1|0;r=(N((b[u+(t<<1)>>1]|0)-(b[u+(q<<1)>>1]|0)|0,J)|0)<<H;p=(r|0)>48?r:48;p=(r<<3|0)<(p|0)?r<<3:p;r=0;o=s;while(1){if(((o<<3)+e|0)>=(n|0))break;if((r|0)>=(c[v+(q<<2)>>2]|0))break;o=Ba(j,o)|0;e=wa(j)|0;if(!o)break;else{r=r+p|0;o=1;n=n-p|0}}c[w+(q<<2)>>2]=r;o=s+-1|0;if((t|0)==(P|0))break;else s=(r|0)>0?((o|0)>2?o:2):s}}else{e=n;n=f<<6}u=l;l=l+((1*(Y<<2)|0)+15&-16)|0;if((e+48|0)>(n|0))n=5;else n=Ca(j,22205,7)|0;e=(f<<6)-(wa(j)|0)+-1|0;q=(H|0)>1&B&(e|0)>=((H<<3)+16|0);r=q?8:0;s=l;l=l+((1*(Y<<2)|0)+15&-16)|0;t=l;l=l+((1*(Y<<2)|0)+15&-16)|0;e=Sa(X,O,P,w,v,n,_+8|0,_+4|0,e-r|0,_,s,u,t,J,H,j,0,0,0)|0;Qa(X,O,P,T,u,j,J);n=0;do{w=c[_+24+(n<<2)>>2]|0;Ac(w|0,w+(U<<2)|0,((K|0)/2|0)+2048-U<<2|0)|0;n=n+1|0}while((n|0)<(V|0));o=N(Y,J)|0;n=l;l=l+((1*o|0)+15&-16)|0;w=(N(U,J)|0)<<2;p=l;l=l+((1*w|0)+15&-16)|0;pb(0,X,O,P,p,(J|0)==2?p+(U<<2)|0:0,n,0,s,z,x,c[_+4>>2]|0,c[_+8>>2]|0,y,(f<<6)-r|0,c[_>>2]|0,j,H,e,d+40|0,0,c[d+36>>2]|0,c[d+32>>2]|0);if(q){z=(Ea(j,1)|0)==0;Ra(X,O,P,T,u,t,(f<<3)+32-(c[L>>2]|0)-(Q(c[M>>2]|0)|0)|0,j,J);if(!z)ob(X,p,n,H,J,U,O,P,T,R,S,s,c[d+40>>2]|0,c[d+36>>2]|0)}else Ra(X,O,P,T,u,t,(f<<3)+32-(c[L>>2]|0)-(Q(c[M>>2]|0)|0)|0,j,J);if(E&(o|0)>0){n=0;do{g[T+(n<<2)>>2]=-28.0;n=n+1|0}while((n|0)!=(o|0))}va(X,p,_+16|0,T,O,G,J,V,A,H,c[d+16>>2]|0,i,c[d+36>>2]|0);n=(H|0)!=0;if(n){i=0;do{H=c[d+60>>2]|0;H=(H|0)>15?H:15;c[d+60>>2]=H;E=c[d+64>>2]|0;E=(E|0)>15?E:15;c[d+64>>2]=E;G=c[_+16+(i<<2)>>2]|0;xb(G,G,E,H,c[X+44>>2]|0,+g[d+72>>2],+g[d+68>>2],c[d+80>>2]|0,c[d+76>>2]|0,c[X+60>>2]|0,K,c[d+36>>2]|0);H=c[X+44>>2]|0;xb(G+(H<<2)|0,G+(H<<2)|0,c[d+60>>2]|0,D,U-H|0,+g[d+68>>2],m,c[d+76>>2]|0,C,c[X+60>>2]|0,K,c[d+36>>2]|0);i=i+1|0}while((i|0)<(V|0))}else{i=0;do{H=c[d+60>>2]|0;H=(H|0)>15?H:15;c[d+60>>2]=H;G=c[d+64>>2]|0;G=(G|0)>15?G:15;c[d+64>>2]=G;E=c[_+16+(i<<2)>>2]|0;xb(E,E,G,H,c[X+44>>2]|0,+g[d+72>>2],+g[d+68>>2],c[d+80>>2]|0,c[d+76>>2]|0,c[X+60>>2]|0,K,c[d+36>>2]|0);i=i+1|0}while((i|0)<(V|0))}c[d+64>>2]=c[d+60>>2];c[d+72>>2]=c[d+68>>2];c[d+80>>2]=c[d+76>>2];c[d+60>>2]=D;g[d+68>>2]=m;c[d+76>>2]=C;if(n){c[d+64>>2]=D;g[d+72>>2]=m;c[d+80>>2]=C}if((J|0)==1)zc(T+(Y<<2)|0,T|0,Y<<2|0)|0;do if(B){if((Y|0)>0)i=0;else break;do{K=R+(i<<2)|0;J=T+(i<<2)|0;c[K>>2]=c[(+g[K>>2]<+g[J>>2]?K:J)>>2];i=i+1|0}while((i|0)<(Y<<1|0))}else{zc(S|0,R|0,Y<<3|0)|0;zc(R|0,T|0,Y<<3|0)|0;m=(c[d+52>>2]|0)<10?+(I|0)*1.0000000474974513e-03:1.0;if((Y|0)>0)i=0;else break;do{K=S+(Y<<1<<2)+(i<<2)|0;aa=m+ +g[K>>2];$=+g[T+(i<<2)>>2];g[K>>2]=aa<$?aa:$;i=i+1|0}while((i|0)<(Y<<1|0))}while(0);do if((O|0)>0){i=0;do{g[T+(i<<2)>>2]=0.0;g[S+(i<<2)>>2]=-28.0;g[R+(i<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(O|0));if((P|0)<(Y|0)){i=P;do{g[T+(i<<2)>>2]=0.0;g[S+(i<<2)>>2]=-28.0;g[R+(i<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(Y|0));i=0}else i=0;do{K=i+Y|0;g[T+(K<<2)>>2]=0.0;g[S+(K<<2)>>2]=-28.0;g[R+(K<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(O|0));if((P|0)<(Y|0))i=P;else break;do{P=i+Y|0;g[T+(P<<2)>>2]=0.0;g[S+(P<<2)>>2]=-28.0;g[R+(P<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(Y|0))}else{if((P|0)<(Y|0))i=P;else break;do{g[T+(i<<2)>>2]=0.0;g[S+(i<<2)>>2]=-28.0;g[R+(i<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(Y|0));i=P;do{P=i+Y|0;g[T+(P<<2)>>2]=0.0;g[S+(P<<2)>>2]=-28.0;g[R+(P<<2)>>2]=-28.0;i=i+1|0}while((i|0)!=(Y|0))}while(0);c[d+40>>2]=c[M>>2];ua(_+16|0,h,U,V,c[d+16>>2]|0,X+16|0,d+84|0,k);c[d+52>>2]=0;if(((c[L>>2]|0)+-32+(Q(c[M>>2]|0)|0)|0)>(f<<3|0))i=-3;else{if(c[j+44>>2]|0)c[d+44>>2]=1;i=(U|0)/(c[d+16>>2]|0)|0}W(F|0);d=i;l=_;return d|0}function ta(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0.0,i=0,j=0,k=0,m=0,n=0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,C=0,D=0,E=0,F=0.0;E=l;l=l+8304|0;C=c[a+8>>2]|0;w=c[a>>2]|0;n=c[w+8>>2]|0;D=c[w+4>>2]|0;r=c[w+32>>2]|0;f=0;do{A=a+92+((N(f,D+2048|0)|0)<<2)|0;c[E+8+(f<<2)>>2]=A;c[E+(f<<2)>>2]=A+8192+(0-d<<2);f=f+1|0}while((f|0)<(C|0));A=a+92+((N(D+2048|0,C)|0)<<2)|0;z=c[a+52>>2]|0;t=c[a+20>>2]|0;if(!((z|0)>4|(t|0)!=0)?(c[a+56>>2]|0)==0:0){if(!z){e=c[a+36>>2]|0;Ha(E+8|0,E+16|0,2048,C,e);Ja(E+16+1440|0,E+16|0,1328,620,E+4112|0,e);e=720-(c[E+4112>>2]|0)|0;c[a+48>>2]=e;v=a+36|0;x=1.0}else{v=a+36|0;x=.800000011920929;e=c[a+48>>2]|0}t=Z()|0;y=l;l=l+((1*(D<<2)|0)+15&-16)|0;u=E+4112+96|0;k=c[w+60>>2]|0;r=e<<1;r=(r|0)<1024?r:1024;p=(e|0)>0;s=1024-e|0;n=0;do{m=c[E+8+(n<<2)>>2]|0;f=0;do{c[u+(f<<2)>>2]=c[m+(f+1024<<2)>>2];f=f+1|0}while((f|0)!=1024);if(!z){Oa(u,E+16|0,k,D,24,1024,c[v>>2]|0)|0;g[E+16>>2]=+g[E+16>>2]*1.000100016593933;f=1;do{w=E+16+(f<<2)|0;q=+g[w>>2];o=+(f|0);g[w>>2]=q-o*(o*(q*6.400000711437315e-05));f=f+1|0}while((f|0)!=25);Ka(A+(n*24<<2)|0,E+16|0,24);f=0}else f=0;do{c[u+(1e3-r+f<<2)>>2]=c[m+(2024-r+f<<2)>>2];f=f+1|0}while((f|0)!=24);j=A+(n*24<<2)|0;La(E+4112+4192+(0-r<<2)|0,j,E+4112+4192+(0-r<<2)|0,r,24,c[v>>2]|0);if(p){o=1.0;h=1.0;f=0;do{q=+g[u+(1024-(r>>1)+f<<2)>>2];o=o+q*q;q=+g[u+(1024-r+f<<2)>>2];h=h+q*q;f=f+1|0}while((f|0)<(r>>1|0))}else{o=1.0;h=1.0}q=+B(+((o<h?o:h)/h));Ac(m|0,m+(d<<2)|0,2048-d<<2|0)|0;if((D+d|0)>0){o=0.0;h=x*q;i=0;f=0;while(1){w=(f|0)<(e|0);h=w?h:q*h;f=f-(w?0:e)|0;g[m+(i+(2048-d)<<2)>>2]=h*+g[u+(f+s<<2)>>2];F=+g[m+(1024-d+s+f<<2)>>2];o=o+F*F;i=i+1|0;if((i|0)==(D+d|0))break;else f=f+1|0}}else o=0.0;c[E+16>>2]=c[m+(2048-d+-1<<2)>>2];c[E+16+4>>2]=c[m+(2048-d+-2<<2)>>2];c[E+16+8>>2]=c[m+(2048-d+-3<<2)>>2];c[E+16+12>>2]=c[m+(2048-d+-4<<2)>>2];c[E+16+16>>2]=c[m+(2048-d+-5<<2)>>2];c[E+16+20>>2]=c[m+(2048-d+-6<<2)>>2];c[E+16+24>>2]=c[m+(2048-d+-7<<2)>>2];c[E+16+28>>2]=c[m+(2048-d+-8<<2)>>2];c[E+16+32>>2]=c[m+(2048-d+-9<<2)>>2];c[E+16+36>>2]=c[m+(2048-d+-10<<2)>>2];c[E+16+40>>2]=c[m+(2048-d+-11<<2)>>2];c[E+16+44>>2]=c[m+(2048-d+-12<<2)>>2];c[E+16+48>>2]=c[m+(2048-d+-13<<2)>>2];c[E+16+52>>2]=c[m+(2048-d+-14<<2)>>2];c[E+16+56>>2]=c[m+(2048-d+-15<<2)>>2];c[E+16+60>>2]=c[m+(2048-d+-16<<2)>>2];c[E+16+64>>2]=c[m+(2048-d+-17<<2)>>2];c[E+16+68>>2]=c[m+(2048-d+-18<<2)>>2];c[E+16+72>>2]=c[m+(2048-d+-19<<2)>>2];c[E+16+76>>2]=c[m+(2048-d+-20<<2)>>2];c[E+16+80>>2]=c[m+(2048-d+-21<<2)>>2];c[E+16+84>>2]=c[m+(2048-d+-22<<2)>>2];c[E+16+88>>2]=c[m+(2048-d+-23<<2)>>2];c[E+16+92>>2]=c[m+(2048-d+-24<<2)>>2];Na(m+8192+(0-d<<2)|0,j,m+8192+(0-d<<2)|0,D+d|0,24,E+16|0,c[v>>2]|0);if((D+d|0)>0){h=0.0;f=0;do{F=+g[m+(f+(2048-d)<<2)>>2];h=h+F*F;f=f+1|0}while((f|0)!=(D+d|0))}else h=0.0;if(o>h*.20000000298023224){if(o<h){h=+B(+((o+1.0)/(h+1.0)));if((D|0)>0){f=0;do{w=m+(f+(2048-d)<<2)|0;g[w>>2]=+g[w>>2]*(1.0-(1.0-h)*+g[k+(f<<2)>>2]);f=f+1|0}while((f|0)!=(D|0))}if((d|0)>0){f=D;do{w=m+(f+(2048-d)<<2)|0;g[w>>2]=h*+g[w>>2];f=f+1|0}while((f|0)<(D+d|0))}}}else if((D+d|0)>0)wc(m+(2048-d<<2)|0,0,D+d<<2|0)|0;j=c[a+60>>2]|0;F=-+g[a+68>>2];w=c[a+76>>2]|0;xb(y,m+8192|0,j,j,D,F,F,w,w,0,0,c[v>>2]|0);if((D|0)>1){f=0;i=0;while(1){j=D+-1+f|0;g[m+(i+2048<<2)>>2]=+g[k+(i<<2)>>2]*+g[y+(j<<2)>>2]+ +g[k+(j<<2)>>2]*+g[y+(i<<2)>>2];j=i+1|0;if((j|0)<((D|0)/2|0|0)){f=~i;i=j}else break}}n=n+1|0}while((n|0)<(C|0));W(t|0);d=z+1|0;c[a+52>>2]=d;l=E;return}f=c[a+24>>2]|0;m=c[w+12>>2]|0;m=(f|0)<(m|0)?f:m;u=(t|0)>(m|0)?t:m;y=N(C,d)|0;s=Z()|0;v=l;l=l+((1*(y<<2)|0)+15&-16)|0;h=(z|0)==0?1.5:.5;if((t|0)<(f|0)){i=0;do{k=N(i,n)|0;j=t;do{y=j+k|0;x=+g[A+(C*24<<2)+(n<<1<<2)+(n<<1<<2)+(n<<1<<2)+(y<<2)>>2];F=+g[A+(C*24<<2)+(y<<2)>>2]-h;g[A+(C*24<<2)+(y<<2)>>2]=x>F?x:F;j=j+1|0}while((j|0)!=(f|0));i=i+1|0}while((i|0)<(C|0))}f=c[a+40>>2]|0;if((C|0)>0?(t|0)<(m|0):0){p=0;do{n=N(p,d)|0;m=t;do{j=b[r+(m<<1)>>1]|0;m=m+1|0;k=(b[r+(m<<1)>>1]|0)-j<<e;if((k|0)>0){i=0;do{f=mb(f)|0;g[v+(i+((j<<e)+n)<<2)>>2]=+(f>>20|0);i=i+1|0}while((i|0)!=(k|0))}Xa(v+((j<<e)+n<<2)|0,k,1.0,c[a+36>>2]|0)}while((m|0)<(u|0));p=p+1|0}while((p|0)!=(C|0))}c[a+40>>2]=f;f=0;do{y=c[E+8+(f<<2)>>2]|0;Ac(y|0,y+(d<<2)|0,2048-d+(D>>>1)<<2|0)|0;f=f+1|0}while((f|0)<(C|0));va(w,v,E,A+(C*24<<2)|0,t,u,C,C,0,e,c[a+16>>2]|0,0,c[a+36>>2]|0);W(s|0);d=z+1|0;c[a+52>>2]=d;l=E;return}function ua(a,b,d,e,f,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0.0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0;t=l;if(!((e|0)!=2|(f|0)!=1|(j|0)!=0)){o=+g[h>>2];n=c[a>>2]|0;j=c[a+4>>2]|0;m=+g[i>>2];k=+g[i+4>>2];if((d|0)>0){h=0;while(1){m=m+(+g[n+(h<<2)>>2]+1.0000000031710769e-30);k=k+(+g[j+(h<<2)>>2]+1.0000000031710769e-30);a=h<<1;g[b+(a<<2)>>2]=m*.000030517578125;g[b+((a|1)<<2)>>2]=k*.000030517578125;h=h+1|0;if((h|0)==(d|0)){m=o*m;k=o*k;break}else{m=o*m;k=o*k}}}g[i>>2]=m;g[i+4>>2]=k;l=t;return}s=Z()|0;r=l;l=l+((1*(d<<2)|0)+15&-16)|0;m=+g[h>>2];if((f|0)>1){q=0;do{n=i+(q<<2)|0;k=+g[n>>2];j=c[a+(q<<2)>>2]|0;p=b+(q<<2)|0;if((d|0)>0){h=0;while(1){k=k+(+g[j+(h<<2)>>2]+1.0000000031710769e-30);g[r+(h<<2)>>2]=k;h=h+1|0;if((h|0)==(d|0)){k=m*k;break}else k=m*k}}g[n>>2]=k;if(((d|0)/(f|0)|0|0)>0){j=0;do{g[p+((N(j,e)|0)<<2)>>2]=+g[r+((N(j,f)|0)<<2)>>2]*.000030517578125;j=j+1|0}while((j|0)!=((d|0)/(f|0)|0|0))}q=q+1|0}while((q|0)<(e|0))}else{q=0;do{p=i+(q<<2)|0;k=+g[p>>2];j=c[a+(q<<2)>>2]|0;h=b+(q<<2)|0;if((d|0)>0){n=0;while(1){k=k+(+g[j+(n<<2)>>2]+1.0000000031710769e-30);g[h+((N(n,e)|0)<<2)>>2]=k*.000030517578125;n=n+1|0;if((n|0)==(d|0)){k=m*k;break}else k=m*k}}g[p>>2]=k;q=q+1|0}while((q|0)<(e|0))}W(s|0);l=t;return}function va(a,b,d,e,f,h,i,j,k,m,n,o,p){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;y=l;u=c[a+4>>2]|0;r=c[a+8>>2]|0;s=c[a+44>>2]|0;x=l;l=l+((1*(s<<m<<2)|0)+15&-16)|0;w=(c[a+36>>2]|0)-((k|0)==0?m:0)|0;v=(k|0)==0?s<<m:s;t=(k|0)==0?1:1<<m;if((i|0)==1&(j|0)==2){nb(a,b,x,e,f,h,1<<m,n,o);i=(c[d+4>>2]|0)+(((u|0)/2|0)<<2)|0;zc(i|0,x|0,s<<m<<2|0)|0;if((t|0)<=0){l=y;return}k=0;do{m=(c[d>>2]|0)+((N(k,v)|0)<<2)|0;Fa(a+64|0,i+(k<<2)|0,m,c[a+60>>2]|0,u,w,t,p);k=k+1|0}while((k|0)!=(t|0));if((t|0)<=0){l=y;return}k=0;do{m=(c[d+4>>2]|0)+((N(k,v)|0)<<2)|0;Fa(a+64|0,x+(k<<2)|0,m,c[a+60>>2]|0,u,w,t,p);k=k+1|0}while((k|0)!=(t|0));l=y;return}if((i|0)==2&(j|0)==1){i=(c[d>>2]|0)+(((u|0)/2|0)<<2)|0;nb(a,b,x,e,f,h,1<<m,n,o);nb(a,b+(s<<m<<2)|0,i,e+(r<<2)|0,f,h,1<<m,n,o);if((s<<m|0)>0){k=0;do{f=x+(k<<2)|0;g[f>>2]=+g[f>>2]*.5+ +g[i+(k<<2)>>2]*.5;k=k+1|0}while((k|0)!=(s<<m|0))}if((t|0)<=0){l=y;return}k=0;do{m=(c[d>>2]|0)+((N(k,v)|0)<<2)|0;Fa(a+64|0,x+(k<<2)|0,m,c[a+60>>2]|0,u,w,t,p);k=k+1|0}while((k|0)!=(t|0));l=y;return}else{if((t|0)>0)q=0;else{k=0;do{nb(a,b+((N(k,s<<m)|0)<<2)|0,x,e+((N(k,r)|0)<<2)|0,f,h,1<<m,n,o);k=k+1|0}while((k|0)<(j|0));l=y;return}do{nb(a,b+((N(q,s<<m)|0)<<2)|0,x,e+((N(q,r)|0)<<2)|0,f,h,1<<m,n,o);k=d+(q<<2)|0;i=0;do{z=(c[k>>2]|0)+((N(i,v)|0)<<2)|0;Fa(a+64|0,x+(i<<2)|0,z,c[a+60>>2]|0,u,w,t,p);i=i+1|0}while((i|0)!=(t|0));q=q+1|0}while((q|0)<(j|0));l=y;return}}function wa(a){a=a|0;var b=0,d=0;d=c[a+28>>2]|0;b=32-(Q(d|0)|0)|0;return (N(b,-8)|0)+(c[a+20>>2]<<3)+((d>>>(b+-16|0)>>>0>(c[8+((d>>>(b+-16|0)>>>12)+-8<<2)>>2]|0)>>>0)<<31>>31)+(8-(d>>>(b+-16|0)>>>12))|0}function xa(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;c[a>>2]=b;c[a+4>>2]=e;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=9;c[a+24>>2]=0;c[a+28>>2]=128;if(!e){g=0;f=0}else{c[a+24>>2]=1;g=d[b>>0]|0;f=1}c[a+40>>2]=g;h=g>>>1^127;c[a+32>>2]=h;c[a+44>>2]=0;c[a+20>>2]=17;c[a+28>>2]=32768;if(f>>>0<e>>>0){i=f+1|0;c[a+24>>2]=i;j=d[b+f>>0]|0}else{i=f;j=0}c[a+40>>2]=j;f=(h<<8|(j|g<<8)>>>1&255)^255;c[a+32>>2]=f;c[a+20>>2]=25;c[a+28>>2]=8388608;if(i>>>0<e>>>0){h=i+1|0;c[a+24>>2]=h;g=d[b+i>>0]|0}else{h=i;g=0}c[a+40>>2]=g;f=(f<<8&2147483392|(g|j<<8)>>>1&255)^255;c[a+32>>2]=f;c[a+20>>2]=33;c[a+28>>2]=-2147483648;if(h>>>0>=e>>>0){b=0;c[a+40>>2]=b;e=g<<8;e=b|e;e=e>>>1;b=f<<8;e=e&255;b=b&2147483392;e=b|e;e=e^255;c[a+32>>2]=e;return}c[a+24>>2]=h+1;b=d[b+h>>0]|0;c[a+40>>2]=b;e=g<<8;e=b|e;e=e>>>1;b=f<<8;e=e&255;b=b&2147483392;e=b|e;e=e^255;c[a+32>>2]=e;return}function ya(a,b){a=a|0;b=b|0;var d=0;d=((c[a+28>>2]|0)>>>0)/(b>>>0)|0;c[a+36>>2]=d;a=(((c[a+32>>2]|0)>>>0)/(d>>>0)|0)+1|0;return b-(a>>>0>b>>>0?b:a)|0}function za(a,b){a=a|0;b=b|0;var d=0;d=(c[a+28>>2]|0)>>>b;c[a+36>>2]=d;a=(((c[a+32>>2]|0)>>>0)/(d>>>0)|0)+1|0;return (1<<b)-(1<<b>>>0<a>>>0?1<<b:a)|0}function Aa(a,b,e,f){a=a|0;b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;g=c[a+36>>2]|0;f=N(g,f-e|0)|0;h=(c[a+32>>2]|0)-f|0;c[a+32>>2]=h;if(!b){f=(c[a+28>>2]|0)-f|0;l=a+28|0}else{f=N(g,e-b|0)|0;l=a+28|0}c[l>>2]=f;if(f>>>0>=8388609)return;k=c[a+4>>2]|0;j=c[a+20>>2]|0;e=c[a+24>>2]|0;b=c[a+40>>2]|0;while(1){j=j+8|0;c[a+20>>2]=j;f=f<<8;c[l>>2]=f;if(e>>>0<k>>>0){i=c[a>>2]|0;g=e+1|0;c[a+24>>2]=g;i=d[i+e>>0]|0}else{g=e;i=0}c[a+40>>2]=i;h=(h<<8&2147483392|(i|b<<8)>>>1&255)^255;c[a+32>>2]=h;if(f>>>0>=8388609)break;else{e=g;b=i}}return}function Ba(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=c[a+28>>2]|0;m=c[a+32>>2]|0;if(m>>>0<l>>>b>>>0){f=m;e=l>>>b}else{c[a+32>>2]=m-(l>>>b);f=m-(l>>>b)|0;e=l-(l>>>b)|0}c[a+28>>2]=e;if(e>>>0>=8388609)return m>>>0<l>>>b>>>0|0;k=c[a+4>>2]|0;n=c[a+20>>2]|0;i=c[a+24>>2]|0;j=c[a+40>>2]|0;while(1){n=n+8|0;c[a+20>>2]=n;e=e<<8;c[a+28>>2]=e;if(i>>>0<k>>>0){h=c[a>>2]|0;g=i+1|0;c[a+24>>2]=g;h=d[h+i>>0]|0}else{g=i;h=0}c[a+40>>2]=h;f=(f<<8&2147483392|(h|j<<8)>>>1&255)^255;c[a+32>>2]=f;if(e>>>0>=8388609)break;else{i=g;j=h}}return m>>>0<l>>>b>>>0|0}function Ca(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=c[a+28>>2]|0;h=c[a+32>>2]|0;l=-1;g=f;while(1){l=l+1|0;i=N(d[b+l>>0]|0,f>>>e)|0;if(h>>>0>=i>>>0)break;else g=i}c[a+32>>2]=h-i;f=g-i|0;c[a+28>>2]=f;if(f>>>0>=8388609)return l|0;k=c[a+4>>2]|0;i=h-i|0;j=c[a+20>>2]|0;b=c[a+24>>2]|0;g=c[a+40>>2]|0;while(1){j=j+8|0;c[a+20>>2]=j;f=f<<8;c[a+28>>2]=f;if(b>>>0<k>>>0){h=c[a>>2]|0;e=b+1|0;c[a+24>>2]=e;h=d[h+b>>0]|0}else{e=b;h=0}c[a+40>>2]=h;i=(i<<8&2147483392|(h|g<<8)>>>1&255)^255;c[a+32>>2]=i;if(f>>>0>=8388609)break;else{b=e;g=h}}return l|0}function Da(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=32-(Q(b+-1|0)|0)|0;if((m|0)<=8){f=c[a+28>>2]|0;c[a+36>>2]=(f>>>0)/(b>>>0)|0;g=c[a+32>>2]|0;e=b-((((g>>>0)/(((f>>>0)/(b>>>0)|0)>>>0)|0)+1|0)>>>0>b>>>0?b:((g>>>0)/(((f>>>0)/(b>>>0)|0)>>>0)|0)+1|0)|0;h=N(b+-1-e|0,(f>>>0)/(b>>>0)|0)|0;c[a+32>>2]=g-h;f=(e|0)==0?f-h|0:(f>>>0)/(b>>>0)|0;c[a+28>>2]=f;if(f>>>0>=8388609){a=e;return a|0}l=c[a+4>>2]|0;m=c[a+20>>2]|0;j=c[a+24>>2]|0;k=c[a+40>>2]|0;g=g-h|0;while(1){m=m+8|0;c[a+20>>2]=m;f=f<<8;c[a+28>>2]=f;if(j>>>0<l>>>0){i=c[a>>2]|0;h=j+1|0;c[a+24>>2]=h;i=d[i+j>>0]|0}else{h=j;i=0}c[a+40>>2]=i;g=((i|k<<8)>>>1&255|g<<8&2147483392)^255;c[a+32>>2]=g;if(f>>>0>=8388609)break;else{j=h;k=i}}return e|0}g=((b+-1|0)>>>(m+-8|0))+1|0;l=c[a+28>>2]|0;c[a+36>>2]=(l>>>0)/(g>>>0)|0;e=c[a+32>>2]|0;n=g-((((e>>>0)/(((l>>>0)/(g>>>0)|0)>>>0)|0)+1|0)>>>0>g>>>0?g:((e>>>0)/(((l>>>0)/(g>>>0)|0)>>>0)|0)+1|0)|0;f=N(((b+-1|0)>>>(m+-8|0))-n|0,(l>>>0)/(g>>>0)|0)|0;c[a+32>>2]=e-f;g=(n|0)==0?l-f|0:(l>>>0)/(g>>>0)|0;c[a+28>>2]=g;if(g>>>0<8388609){l=c[a+4>>2]|0;j=e-f|0;k=c[a+20>>2]|0;f=c[a+24>>2]|0;h=c[a+40>>2]|0;while(1){k=k+8|0;c[a+20>>2]=k;g=g<<8;c[a+28>>2]=g;if(f>>>0<l>>>0){i=c[a>>2]|0;e=f+1|0;c[a+24>>2]=e;i=d[i+f>>0]|0}else{e=f;i=0}c[a+40>>2]=i;j=((i|h<<8)>>>1&255|j<<8&2147483392)^255;c[a+32>>2]=j;if(g>>>0>=8388609)break;else{f=e;h=i}}}e=c[a+12>>2]|0;f=c[a+16>>2]|0;if(f>>>0<(m+-8|0)>>>0){j=((f+8|0)>25?f+8|0:25)+~f|0;i=c[a+4>>2]|0;g=c[a+8>>2]|0;k=f;do{if(g>>>0<i>>>0){l=c[a>>2]|0;h=g+1|0;c[a+8>>2]=h;g=h;h=d[l+(i-h)>>0]|0}else h=0;e=h<<k|e;k=k+8|0}while((k|0)<25);f=f+8+(j&-8)|0}c[a+12>>2]=e>>>(m+-8|0);c[a+16>>2]=f-(m+-8);c[a+20>>2]=(c[a+20>>2]|0)+(m+-8);e=e&(1<<m+-8)+-1|n<<m+-8;if(e>>>0<=(b+-1|0)>>>0){a=e;return a|0}c[a+44>>2]=1;a=b+-1|0;return a|0}function Ea(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[a+12>>2]|0;f=c[a+16>>2]|0;if(f>>>0<b>>>0){j=f+(((f+8|0)>25?f+8|0:25)+-1-f&-8)|0;i=c[a+4>>2]|0;g=c[a+8>>2]|0;do{if(g>>>0<i>>>0){k=c[a>>2]|0;h=g+1|0;c[a+8>>2]=h;g=h;h=d[k+(i-h)>>0]|0}else h=0;e=h<<f|e;f=f+8|0}while((f|0)<25);f=j+8|0}c[a+12>>2]=e>>>b;c[a+16>>2]=f-b;c[a+20>>2]=(c[a+20>>2]|0)+b;return e&(1<<b)+-1|0}function Fa(a,d,e,f,h,i,j,k){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;l=c[a>>2]|0;k=c[a+24>>2]|0;if((i|0)>0){n=0;m=l>>1;while(1){k=k+(m<<2)|0;n=n+1|0;l=m>>1;if((n|0)==(i|0))break;else m=l}}else{m=l;l=l>>1}p=m>>2;n=c[a+8+(i<<2)>>2]|0;if((p|0)>0){a=c[n+44>>2]|0;i=0;o=d;m=d+((N(l+-1|0,j)|0)<<2)|0;while(1){r=+g[m>>2];t=+g[k+(i<<2)>>2];s=+g[o>>2];q=+g[k+(i+p<<2)>>2];d=b[a>>1]<<1;g[e+(h>>1<<2)+((d|1)<<2)>>2]=r*t+s*q;g[e+(h>>1<<2)+(d<<2)>>2]=t*s-r*q;i=i+1|0;if((i|0)==(p|0))break;else{a=a+2|0;o=o+(j<<1<<2)|0;m=m+(0-(j<<1)<<2)|0}}}Fb(n,e+(h>>1<<2)|0);if((p+1>>1|0)>0){o=l+-1|0;l=e+(h>>1<<2)+(l<<2)|0;m=0;n=0;i=e+(h>>1<<2)|0;while(1){a=i+4|0;v=+g[a>>2];r=+g[i>>2];t=+g[k+(n<<2)>>2];u=+g[k+(n+p<<2)>>2];j=l+-4|0;l=l+-8|0;q=+g[j>>2];s=+g[l>>2];g[i>>2]=v*t+r*u;g[j>>2]=v*u-r*t;t=+g[k+(p+-1+m<<2)>>2];r=+g[k+(o+m<<2)>>2];g[l>>2]=q*t+s*r;g[a>>2]=q*r-s*t;a=n+1|0;if((a|0)==(p+1>>1|0))break;else{m=~n;n=a;i=i+8|0}}}if((h|0)<=1)return;m=0;n=f;k=f+(h<<2)|0;l=e+(h<<2)|0;while(1){k=k+-4|0;l=l+-4|0;s=+g[l>>2];u=+g[e>>2];t=+g[k>>2];v=+g[n>>2];g[e>>2]=u*t-s*v;g[l>>2]=s*t+u*v;m=m+1|0;if((m|0)>=((h|0)/2|0|0))break;else{n=n+4|0;e=e+4|0}}return}function Ga(a,b,d){a=a|0;b=b|0;d=d|0;if((a|0)==48e3?(b|0)==960|(b&2147483647|0)==480|(b&1073741823|0)==240|(b&536870911|0)==120:0){if(!d){b=40;return b|0}c[d>>2]=0;b=40;return b|0}if(!d){b=0;return b|0}c[d>>2]=-1;b=0;return b|0}function Ha(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,i=0,j=0,k=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0;u=l;l=l+48|0;i=c[a>>2]|0;if((d>>1|0)>1){j=1;do{v=j<<1;g[b+(j<<2)>>2]=(+g[i+(v<<2)>>2]+(+g[i+(v+-1<<2)>>2]+ +g[i+((v|1)<<2)>>2])*.5)*.5;j=j+1|0}while((j|0)!=(d>>1|0))}h=(+g[i+4>>2]*.5+ +g[i>>2])*.5;g[b>>2]=h;if((e|0)==2){j=c[a+4>>2]|0;if((d>>1|0)>1){i=1;do{a=i<<1;v=b+(i<<2)|0;g[v>>2]=+g[v>>2]+(+g[j+(a<<2)>>2]+(+g[j+(a+-1<<2)>>2]+ +g[j+((a|1)<<2)>>2])*.5)*.5;i=i+1|0}while((i|0)!=(d>>1|0));h=+g[b>>2]}g[b>>2]=h+(+g[j+4>>2]*.5+ +g[j>>2])*.5}Oa(b,u+16|0,0,0,4,d>>1,f)|0;g[u+16>>2]=+g[u+16>>2]*1.000100016593933;q=+g[u+16+4>>2];g[u+16+4>>2]=q-q*.00800000037997961*.00800000037997961;q=+g[u+16+8>>2];g[u+16+8>>2]=q-q*.01600000075995922*.01600000075995922;q=+g[u+16+12>>2];g[u+16+12>>2]=q-q*.024000000208616257*.024000000208616257;q=+g[u+16+16>>2];g[u+16+16>>2]=q-q*.03200000151991844*.03200000151991844;Ka(u,u+16|0,4);q=+g[u>>2]*.8999999761581421;g[u>>2]=q;r=+g[u+4>>2]*.809999942779541;g[u+4>>2]=r;s=+g[u+8>>2]*.7289999127388;g[u+8>>2]=s;t=+g[u+12>>2]*.6560999155044556;g[u+12>>2]=t;if((d>>1|0)>0){i=0;k=0.0;m=0.0;n=0.0;o=0.0;p=0.0}else{l=u;return}while(1){v=b+(i<<2)|0;h=+g[v>>2];g[v>>2]=t*.800000011920929*p+((t+s*.800000011920929)*o+((s+r*.800000011920929)*n+((r+q*.800000011920929)*m+((q+.800000011920929)*k+h))));i=i+1|0;if((i|0)==(d>>1|0))break;else{w=k;k=h;p=o;o=n;n=m;m=w}}l=u;return}function Ia(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,k=0,l=0.0,m=0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;if((f|0)>3){z=0;do{r=b+(z<<2)|0;l=+g[r>>2];t=+g[r+4>>2];v=+g[r+8>>2];if((e|0)>3){s=0.0;n=0.0;p=0.0;q=0.0;h=0;i=a;k=r+12|0;while(1){C=+g[i>>2];w=+g[k>>2];B=+g[i+4>>2];F=l;l=+g[k+4>>2];A=+g[i+8>>2];E=t;t=+g[k+8>>2];x=+g[i+12>>2];D=v;v=+g[k+12>>2];s=s+F*C+E*B+D*A+w*x;n=n+E*C+D*B+w*A+l*x;p=p+D*C+w*B+l*A+t*x;q=q+C*w+B*l+A*t+x*v;h=h+4|0;if((h|0)>=(e+-3|0))break;else{i=i+16|0;k=k+16|0}}h=(g[j>>2]=q,c[j>>2]|0);i=(g[j>>2]=p,c[j>>2]|0);k=(g[j>>2]=n,c[j>>2]|0);x=s;u=(e+-4&-4)+4|0;m=(g[j>>2]=s,c[j>>2]|0);o=a+((e+-4&-4)+4<<2)|0;r=r+((e+-4&-4)+7<<2)|0}else{x=0.0;n=0.0;p=0.0;q=0.0;u=0;m=0;k=0;i=0;h=0;o=a;r=r+12|0;w=0.0}y=u|1;if((u|0)<(e|0)){F=+g[o>>2];w=+g[r>>2];s=x+l*F;m=(g[j>>2]=s,c[j>>2]|0);n=n+t*F;k=(g[j>>2]=n,c[j>>2]|0);p=p+v*F;i=(g[j>>2]=p,c[j>>2]|0);F=q+F*w;q=F;h=(g[j>>2]=F,c[j>>2]|0);o=o+4|0;r=r+4|0}else s=x;if((y|0)<(e|0)){F=+g[o>>2];l=+g[r>>2];s=s+t*F;m=(g[j>>2]=s,c[j>>2]|0);n=n+v*F;k=(g[j>>2]=n,c[j>>2]|0);p=p+w*F;i=(g[j>>2]=p,c[j>>2]|0);F=q+F*l;q=F;h=(g[j>>2]=F,c[j>>2]|0);o=o+4|0;r=r+4|0}if((y+1|0)<(e|0)){F=+g[o>>2];m=(g[j>>2]=s+v*F,c[j>>2]|0);k=(g[j>>2]=n+w*F,c[j>>2]|0);i=(g[j>>2]=p+l*F,c[j>>2]|0);h=(g[j>>2]=q+F*+g[r>>2],c[j>>2]|0)}c[d+(z<<2)>>2]=m;c[d+((z|1)<<2)>>2]=k;c[d+((z|2)<<2)>>2]=i;c[d+((z|3)<<2)>>2]=h;z=z+4|0}while((z|0)<(f+-3|0));h=f&-4}else h=0;if((h|0)>=(f|0))return;if((e|0)<=0){wc(d+(h<<2)|0,0,f-h<<2|0)|0;return}do{i=b+(h<<2)|0;k=0;l=0.0;do{l=l+ +g[a+(k<<2)>>2]*+g[i+(k<<2)>>2];k=k+1|0}while((k|0)!=(e|0));g[d+(h<<2)>>2]=l;h=h+1|0}while((h|0)!=(f|0));return}function Ja(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0;z=l;l=l+16|0;c[z>>2]=0;c[z+4>>2]=0;y=Z()|0;m=l;l=l+((1*(d>>2<<2)|0)+15&-16)|0;n=l;l=l+((1*(e+d>>2<<2)|0)+15&-16)|0;x=l;l=l+((1*(e>>1<<2)|0)+15&-16)|0;if((d>>2|0)>0){h=0;do{c[m+(h<<2)>>2]=c[a+(h<<1<<2)>>2];h=h+1|0}while((h|0)!=(d>>2|0))}if((e+d>>2|0)>0){h=0;do{c[n+(h<<2)>>2]=c[b+(h<<1<<2)>>2];h=h+1|0}while((h|0)!=(e+d>>2|0))}Ia(m,n,x,d>>2,e>>2,0);c[z>>2]=0;c[z+4>>2]=1;if((d>>2|0)>0){i=1.0;h=0;do{u=+g[n+(h<<2)>>2];i=i+u*u;h=h+1|0}while((h|0)!=(d>>2|0))}else i=1.0;if((e>>2|0)>0){k=0.0;p=0.0;u=-1.0;r=-1.0;m=0;while(1){j=+g[x+(m<<2)>>2];if(j>0.0?(v=j*9.999999960041972e-13*(j*9.999999960041972e-13),p*v>r*i):0){if(k*v>u*i){c[z+4>>2]=c[z>>2];h=z;j=i;q=v;r=u}else{h=z+4|0;j=k;k=i;q=u;r=v}c[h>>2]=m;p=k}else{j=k;q=u}k=+g[n+(m+(d>>2)<<2)>>2];u=+g[n+(m<<2)>>2];i=i+(k*k-u*u);m=m+1|0;if((m|0)==(e>>2|0))break;else{i=i<1.0?1.0:i;k=j;u=q}}}a:do if((e>>1|0)>0){s=c[z>>2]<<1;t=c[z+4>>2]<<1;if((d>>1|0)>0)n=0;else{m=0;while(1){h=x+(m<<2)|0;g[h>>2]=0.0;a=m-s|0;if(!((((a|0)>-1?a:0-a|0)|0)>2?(a=m-t|0,(((a|0)>-1?a:0-a|0)|0)>2):0))g[h>>2]=0.0;m=m+1|0;if((m|0)==(e>>1|0)){n=d>>1;break a}}}do{m=x+(n<<2)|0;g[m>>2]=0.0;o=n-s|0;if(!((((o|0)>-1?o:0-o|0)|0)>2?(o=n-t|0,(((o|0)>-1?o:0-o|0)|0)>2):0)){h=b+(n<<2)|0;o=0;i=0.0;do{i=i+ +g[a+(o<<2)>>2]*+g[h+(o<<2)>>2];o=o+1|0}while((o|0)!=(d>>1|0));g[m>>2]=i<-1.0?-1.0:i}n=n+1|0}while((n|0)!=(e>>1|0));n=d>>1}else n=d>>1;while(0);c[z>>2]=0;c[z+4>>2]=1;if((n|0)>0){i=1.0;h=0;do{v=+g[b+(h<<2)>>2];i=i+v*v;h=h+1|0}while((h|0)!=(n|0))}else i=1.0;if((e>>1|0)>0){k=0.0;p=0.0;u=-1.0;r=-1.0;m=0}else{e=0;x=0;e=e<<1;x=e-x|0;c[f>>2]=x;W(y|0);l=z;return}while(1){j=+g[x+(m<<2)>>2];if(j>0.0?(w=j*9.999999960041972e-13*(j*9.999999960041972e-13),p*w>r*i):0){if(k*w>u*i){c[z+4>>2]=c[z>>2];h=z;j=i;q=w;r=u}else{h=z+4|0;j=k;k=i;q=u;r=w}c[h>>2]=m;p=k}else{j=k;q=u}u=+g[b+(m+n<<2)>>2];v=+g[b+(m<<2)>>2];i=i+(u*u-v*v);m=m+1|0;if((m|0)==(e>>1|0))break;else{i=i<1.0?1.0:i;k=j;u=q}}h=c[z>>2]|0;if(!((h|0)>0&(h|0)<((e>>1)+-1|0))){e=h;x=0;e=e<<1;x=e-x|0;c[f>>2]=x;W(y|0);l=z;return}j=+g[x+(h+-1<<2)>>2];k=+g[x+(h<<2)>>2];i=+g[x+(h+1<<2)>>2];if(i-j>(k-j)*.699999988079071){e=h;x=1;e=e<<1;x=e-x|0;c[f>>2]=x;W(y|0);l=z;return}e=h;x=(j-i>(k-i)*.699999988079071)<<31>>31;e=e<<1;x=e-x|0;c[f>>2]=x;W(y|0);l=z;return}function Ka(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0;e=+g[b>>2];wc(a|0,0,c<<2|0)|0;if(+g[b>>2]!=0.0)j=0;else return;while(1){if((j|0)>=(c|0)){d=9;break}if((j|0)>0){d=0;f=0.0;do{f=f+ +g[a+(d<<2)>>2]*+g[b+(j-d<<2)>>2];d=d+1|0}while((d|0)!=(j|0))}else f=0.0;i=j;j=j+1|0;f=(f+ +g[b+(j<<2)>>2])/e;g[a+(i<<2)>>2]=-f;h=j>>1;if((h|0)>0){d=0;do{n=a+(d<<2)|0;l=+g[n>>2];k=a+(i+-1-d<<2)|0;m=+g[k>>2];g[n>>2]=l+m*-f;g[k>>2]=m+l*-f;d=d+1|0}while((d|0)!=(h|0))}e=e-e*(f*f);if(e<+g[b>>2]*1.0000000474974513e-03){d=9;break}}if((d|0)==9)return}function La(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0,m=0,n=0,o=0;m=l;l=l+16|0;k=l;l=l+((1*(f<<2)|0)+15&-16)|0;if((f|0)>0){h=0;do{c[k+(h<<2)>>2]=c[b+(f+-1-h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}if((e|0)>3){h=0;do{o=a+(h<<2)|0;c[m>>2]=c[o>>2];n=h|1;c[m+4>>2]=c[a+(n<<2)>>2];b=h|2;c[m+8>>2]=c[a+(b<<2)>>2];i=h|3;c[m+12>>2]=c[a+(i<<2)>>2];Ma(k,o+(0-f<<2)|0,m,f);c[d+(h<<2)>>2]=c[m>>2];c[d+(n<<2)>>2]=c[m+4>>2];c[d+(b<<2)>>2]=c[m+8>>2];c[d+(i<<2)>>2]=c[m+12>>2];h=h+4|0}while((h|0)<(e+-3|0))}else h=0;if((h|0)>=(e|0)){l=m;return}if((f|0)<=0){do{c[d+(h<<2)>>2]=c[a+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0));l=m;return}do{b=h-f|0;i=0;j=+g[a+(h<<2)>>2];do{j=j+ +g[k+(i<<2)>>2]*+g[a+(b+i<<2)>>2];i=i+1|0}while((i|0)!=(f|0));g[d+(h<<2)>>2]=j;h=h+1|0}while((h|0)!=(e|0));l=m;return}function Ma(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;e=+g[b>>2];j=+g[b+4>>2];k=+g[b+8>>2];if((d|0)>3){l=+g[c+4>>2];m=+g[c+8>>2];n=+g[c+12>>2];o=+g[c>>2];f=0;i=a;p=b+12|0;while(1){q=+g[i>>2];h=+g[p>>2];v=e*q+o;g[c>>2]=v;t=j*q+l;g[c+4>>2]=t;s=k*q+m;g[c+8>>2]=s;q=q*h+n;g[c+12>>2]=q;r=+g[i+4>>2];e=+g[p+4>>2];v=j*r+v;g[c>>2]=v;t=k*r+t;g[c+4>>2]=t;g[c+8>>2]=h*r+s;q=r*e+q;g[c+12>>2]=q;u=+g[i+8>>2];j=+g[p+8>>2];v=k*u+v;g[c>>2]=v;g[c+4>>2]=h*u+t;s=e*u+(h*r+s);g[c+8>>2]=s;q=u*j+q;g[c+12>>2]=q;r=+g[i+12>>2];k=+g[p+12>>2];o=h*r+v;g[c>>2]=o;l=e*r+(h*u+t);g[c+4>>2]=l;m=j*r+s;g[c+8>>2]=m;n=r*k+q;g[c+12>>2]=n;f=f+4|0;if((f|0)>=(d+-3|0))break;else{i=i+16|0;p=p+16|0}}p=(d+-4&-4)+4|0;a=a+((d+-4&-4)+4<<2)|0;f=b+((d+-4&-4)+7<<2)|0}else{p=0;f=b+12|0;h=0.0}i=p|1;if((p|0)<(d|0)){v=+g[a>>2];h=+g[f>>2];g[c>>2]=e*v+ +g[c>>2];g[c+4>>2]=j*v+ +g[c+4>>2];g[c+8>>2]=k*v+ +g[c+8>>2];g[c+12>>2]=v*h+ +g[c+12>>2];a=a+4|0;f=f+4|0}if((i|0)<(d|0)){v=+g[a>>2];e=+g[f>>2];g[c>>2]=j*v+ +g[c>>2];g[c+4>>2]=k*v+ +g[c+4>>2];g[c+8>>2]=h*v+ +g[c+8>>2];g[c+12>>2]=v*e+ +g[c+12>>2];a=a+4|0;f=f+4|0}if((i+1|0)>=(d|0))return;u=+g[a>>2];v=+g[f>>2];g[c>>2]=k*u+ +g[c>>2];g[c+4>>2]=h*u+ +g[c+4>>2];g[c+8>>2]=e*u+ +g[c+8>>2];g[c+12>>2]=u*v+ +g[c+12>>2];return}function Na(a,b,d,e,f,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0.0,k=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0,t=0;n=l;l=l+16|0;k=l;l=l+((1*(f<<2)|0)+15&-16)|0;m=l;l=l+((1*(f+e<<2)|0)+15&-16)|0;if((f|0)>0){i=0;do{c[k+(i<<2)>>2]=c[b+(f+-1-i<<2)>>2];i=i+1|0}while((i|0)!=(f|0));if((f|0)>0){i=0;do{g[m+(i<<2)>>2]=-+g[h+(f+-1-i<<2)>>2];i=i+1|0}while((i|0)!=(f|0));i=f}else i=0}else i=0;if((f+e|0)>(i|0))wc(m+(i<<2)|0,0,f+e-i<<2|0)|0;if((e|0)>3){i=0;do{c[n>>2]=c[a+(i<<2)>>2];t=i|1;c[n+4>>2]=c[a+(t<<2)>>2];s=i|2;c[n+8>>2]=c[a+(s<<2)>>2];o=i|3;c[n+12>>2]=c[a+(o<<2)>>2];Ma(k,m+(i<<2)|0,n,f);j=+g[n>>2];p=i+f|0;g[m+(p<<2)>>2]=-j;g[d+(i<<2)>>2]=j;q=+g[n+4>>2]+ +g[b>>2]*-j;g[n+4>>2]=q;g[m+(p+1<<2)>>2]=-q;g[d+(t<<2)>>2]=q;r=+g[n+8>>2]+ +g[b>>2]*-q+ +g[b+4>>2]*-j;g[n+8>>2]=r;g[m+(p+2<<2)>>2]=-r;g[d+(s<<2)>>2]=r;j=+g[n+12>>2]+ +g[b>>2]*-r+ +g[b+4>>2]*-q+ +g[b+8>>2]*-j;g[m+(p+3<<2)>>2]=-j;g[d+(o<<2)>>2]=j;i=i+4|0}while((i|0)<(e+-3|0))}else i=0;a:do if((i|0)<(e|0)){if((f|0)<=0)while(1){t=c[a+(i<<2)>>2]|0;c[m+(i+f<<2)>>2]=t;c[d+(i<<2)>>2]=t;i=i+1|0;if((i|0)==(e|0))break a}do{b=0;j=+g[a+(i<<2)>>2];do{j=j-+g[k+(b<<2)>>2]*+g[m+(b+i<<2)>>2];b=b+1|0}while((b|0)!=(f|0));g[m+(i+f<<2)>>2]=j;g[d+(i<<2)>>2]=j;i=i+1|0}while((i|0)!=(e|0))}while(0);if((f|0)<=0){l=n;return}i=0;do{c[h+(i<<2)>>2]=c[d+(e+-1-i<<2)>>2];i=i+1|0}while((i|0)!=(f|0));l=n;return}function Oa(a,b,c,d,e,f,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0,k=0,m=0,n=0;m=l;k=l;l=l+((1*(f<<2)|0)+15&-16)|0;if(d){if((f|0)>0)zc(k|0,a|0,f<<2|0)|0;if((d|0)>0){j=0;do{i=+g[c+(j<<2)>>2];g[k+(j<<2)>>2]=+g[a+(j<<2)>>2]*i;n=f-j+-1|0;g[k+(n<<2)>>2]=i*+g[a+(n<<2)>>2];j=j+1|0}while((j|0)!=(d|0))}}else k=a;Ia(k,k,b,f-e|0,e+1|0,h);if((e|0)<0){l=m;return 0}else d=0;do{j=d+(f-e)|0;if((j|0)<(f|0)){i=0.0;do{i=i+ +g[k+(j<<2)>>2]*+g[k+(j-d<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}else i=0.0;n=b+(d<<2)|0;g[n>>2]=i+ +g[n>>2];d=d+1|0}while((d|0)!=(e+1|0));l=m;return 0}function Pa(a,b,e,f,h,i,j,k){a=a|0;b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var m=0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0,w=0.0;s=l;l=l+16|0;c[s>>2]=0;c[s+4>>2]=0;if(!h){p=+g[12008+(k<<2)>>2];q=+g[11992+(k<<2)>>2]}else{p=.149993896484375;q=0.0}if((b|0)>=(e|0)){l=s;return}r=(c[i+4>>2]<<3)+32|0;do{o=((b|0)<20?b:20)<<1;n=0;do{m=r-(c[i+20>>2]|0)-(Q(c[i+28>>2]|0)|0)|0;do if((m|0)<=14){if((m|0)>1){m=Ca(i,23343,2)|0;m=m>>1^0-(m&1);break}if((m|0)==1)m=0-(Ba(i,1)|0)|0;else m=-1}else m=Gb(i,(d[23007+(k*84|0)+(h*42|0)+o>>0]|0)<<7,(d[(o|1)+(23007+(k*84|0)+(h*42|0))>>0]|0)<<6)|0;while(0);t=+(m|0);v=f+((N(c[a+8>>2]|0,n)|0)+b<<2)|0;w=+g[v>>2];m=s+(n<<2)|0;u=+g[m>>2];g[v>>2]=t+(u+q*(w<-9.0?-9.0:w));g[m>>2]=t+u-p*t;n=n+1|0}while((n|0)<(j|0));b=b+1|0}while((b|0)!=(e|0));l=s;return}function Qa(a,b,d,e,f,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0.0;if((b|0)>=(d|0))return;do{l=f+(b<<2)|0;j=c[l>>2]|0;if((j|0)>=1){k=0;do{n=+(Ea(h,j)|0)+.5;j=c[l>>2]|0;m=e+((N(c[a+8>>2]|0,k)|0)+b<<2)|0;g[m>>2]=+g[m>>2]+(n*+(1<<14-j|0)*.00006103515625+-.5);k=k+1|0}while((k|0)<(i|0))}b=b+1|0}while((b|0)!=(d|0));return}function Ra(a,b,d,e,f,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0.0;if((b|0)>=(d|0))return;if((i|0)>=(k|0)){n=b;do{m=f+(n<<2)|0;if((c[m>>2]|0)<=7?(c[h+(n<<2)>>2]|0)==0:0){l=0;do{p=+(Ea(j,1)|0)+-.5;o=e+((N(c[a+8>>2]|0,l)|0)+n<<2)|0;g[o>>2]=+g[o>>2]+p*+(1<<13-(c[m>>2]|0)|0)*.00006103515625;i=i+-1|0;l=l+1|0}while((l|0)<(k|0))}n=n+1|0}while(!((n|0)>=(d|0)|(i|0)<(k|0)))}if((i|0)<(k|0))return;do{m=f+(b<<2)|0;if((c[m>>2]|0)<=7?(c[h+(b<<2)>>2]|0)==1:0){l=0;do{p=+(Ea(j,1)|0)+-.5;o=e+((N(c[a+8>>2]|0,l)|0)+b<<2)|0;g[o>>2]=+g[o>>2]+p*+(1<<13-(c[m>>2]|0)|0)*.00006103515625;i=i+-1|0;l=l+1|0}while((l|0)<(k|0))}b=b+1|0}while(!((b|0)>=(d|0)|(i|0)<(k|0)));return}function Sa(a,e,f,g,h,i,j,k,m,n,o,p,q,r,s,t,u,v,w){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;t=t|0;u=u|0;v=v|0;w=w|0;var x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;V=l;m=(m|0)>0?m:0;K=c[a+8>>2]|0;R=(m|0)>7?8:0;if((r|0)==2){U=d[23346+(f-e)>>0]|0;x=(m-R-U|0)>7?8:0;T=(m-R|0)<(U|0)?0:x;y=(m-R|0)<(U|0)?0:U;x=(m-R|0)<(U|0)?m-R|0:m-R-U-x|0}else{T=0;y=0;x=m-R|0}M=l;l=l+((1*(K<<2)|0)+15&-16)|0;O=l;l=l+((1*(K<<2)|0)+15&-16)|0;P=l;l=l+((1*(K<<2)|0)+15&-16)|0;L=l;l=l+((1*(K<<2)|0)+15&-16)|0;if((f|0)>(e|0)){A=c[a+32>>2]|0;z=N(i+-5-s|0,r)|0;m=b[A+(e<<1)>>1]|0;i=e;do{U=i;i=i+1|0;Q=m;m=b[A+(i<<1)>>1]|0;Q=(m<<16>>16)-(Q<<16>>16)|0;c[P+(U<<2)>>2]=(r<<3|0)>(Q*3<<s<<3>>4|0)?r<<3:Q*3<<s<<3>>4;J=(N(N(z,f+-1-U|0)|0,Q)|0)<<s+3>>6;c[L+(U<<2)>>2]=J-((Q<<s|0)==1?r<<3:0)}while((i|0)!=(f|0));Q=a+32|0;U=r<<3}else{Q=a+32|0;U=r<<3}I=c[a+48>>2]|0;E=I+-1|0;J=1;do{F=J+E>>1;a:do if((f|0)>(e|0)){B=c[Q>>2]|0;C=c[a+52>>2]|0;D=N(F,K)|0;i=f;z=0;m=0;while(1){A=i+-1|0;i=b[B+(i<<1)>>1]|0;b:do if(z){i=N((i<<16>>16)-(b[B+(A<<1)>>1]|0)|0,r)|0;i=(N(i,d[C+(A+D)>>0]|0)|0)<<s>>2;if((i|0)>0){i=(c[L+(A<<2)>>2]|0)+i|0;i=(i|0)>0?i:0}z=(c[g+(A<<2)>>2]|0)+i|0;i=A}else while(1){z=i;i=b[B+(A<<1)>>1]|0;z=N((z<<16>>16)-(i<<16>>16)|0,r)|0;z=(N(z,d[C+(A+D)>>0]|0)|0)<<s>>2;if((z|0)>0){z=(c[L+(A<<2)>>2]|0)+z|0;z=(z|0)>0?z:0}z=(c[g+(A<<2)>>2]|0)+z|0;if((z|0)>=(c[P+(A<<2)>>2]|0)){i=A;break b}m=((z|0)<(U|0)?0:U)+m|0;if((A|0)<=(e|0))break a;else A=A+-1|0}while(0);H=c[h+(i<<2)>>2]|0;m=((z|0)<(H|0)?z:H)+m|0;if((i|0)>(e|0))z=1;else break}}else m=0;while(0);H=(m|0)>(x|0);E=H?F+-1|0:E;J=H?J:F+1|0}while((J|0)<=(E|0));if((f|0)>(e|0)){F=c[Q>>2]|0;G=c[a+52>>2]|0;H=N(J+-1|0,K)|0;D=N(J,K)|0;E=(J|0)>1;m=b[F+(e<<1)>>1]|0;if((J|0)<(I|0)){B=e;i=e;do{C=B;B=B+1|0;A=m;m=b[F+(B<<1)>>1]|0;A=N((m<<16>>16)-(A<<16>>16)|0,r)|0;z=(N(A,d[G+(C+H)>>0]|0)|0)<<s>>2;A=(N(d[G+(C+D)>>0]|0,A)|0)<<s>>2;if((z|0)>0){z=(c[L+(C<<2)>>2]|0)+z|0;z=(z|0)>0?z:0}if((A|0)>0){A=(c[L+(C<<2)>>2]|0)+A|0;A=(A|0)>0?A:0}K=c[g+(C<<2)>>2]|0;J=(E?K:0)+z|0;i=(K|0)>0?C:i;K=K+A-J|0;c[M+(C<<2)>>2]=J;c[O+(C<<2)>>2]=(K|0)>0?K:0}while((B|0)!=(f|0));E=i}else{B=e;i=e;do{C=B;B=B+1|0;z=m;m=b[F+(B<<1)>>1]|0;z=N((m<<16>>16)-(z<<16>>16)|0,r)|0;z=(N(z,d[G+(C+H)>>0]|0)|0)<<s>>2;A=c[h+(C<<2)>>2]|0;if((z|0)>0){z=(c[L+(C<<2)>>2]|0)+z|0;z=(z|0)>0?z:0}if((A|0)>0){A=(c[L+(C<<2)>>2]|0)+A|0;A=(A|0)>0?A:0}K=c[g+(C<<2)>>2]|0;J=(E?K:0)+z|0;i=(K|0)>0?C:i;K=K+A-J|0;c[M+(C<<2)>>2]=J;c[O+(C<<2)>>2]=(K|0)>0?K:0}while((B|0)!=(f|0));E=i}if((f|0)>(e|0)){A=64;B=0;D=0;while(1){C=A+D>>1;z=f;i=0;m=0;c:while(1){z=z+-1|0;d:do if(i)i=((N(c[O+(z<<2)>>2]|0,C)|0)>>6)+(c[M+(z<<2)>>2]|0)|0;else while(1){i=((N(c[O+(z<<2)>>2]|0,C)|0)>>6)+(c[M+(z<<2)>>2]|0)|0;if((i|0)>=(c[P+(z<<2)>>2]|0))break d;m=((i|0)<(U|0)?0:U)+m|0;if((z|0)>(e|0))z=z+-1|0;else break c}while(0);g=c[h+(z<<2)>>2]|0;m=((i|0)<(g|0)?i:g)+m|0;if((z|0)>(e|0))i=1;else break}m=(m|0)>(x|0);D=m?D:C;B=B+1|0;if((B|0)==6){i=f;z=0;m=0;break}else A=m?C:A}while(1){i=i+-1|0;L=((N(c[O+(i<<2)>>2]|0,D)|0)>>6)+(c[M+(i<<2)>>2]|0)|0;A=z|0?1:(L|0)>=(c[P+(i<<2)>>2]|0);L=A?L:(L|0)<(U|0)?0:U;g=c[h+(i<<2)>>2]|0;g=(L|0)<(g|0)?L:g;c[o+(i<<2)>>2]=g;m=g+m|0;if((i|0)<=(e|0)){H=(r|0)>1;J=(r|0)>1&1;I=s<<3;G=E;break}else z=A?1:z}}else{H=(r|0)>1;J=(r|0)>1&1;m=0;I=s<<3;G=E}}else{H=(r|0)>1;J=(r|0)>1&1;m=0;I=s<<3;G=e}e:do if((f+-1|0)>(G|0)){F=U+8|0;if(!u){B=f;i=f+-1|0;while(1){M=x-m|0;A=c[Q>>2]|0;O=b[A+(B<<1)>>1]|0;w=b[A+(e<<1)>>1]|0;v=M-(N(O-w|0,(M>>>0)/((O-w|0)>>>0)|0)|0)|0;A=b[A+(i<<1)>>1]|0;C=o+(i<<2)|0;z=c[C>>2]|0;A=(N(O-A|0,(M>>>0)/((O-w|0)>>>0)|0)|0)+z+((v+(w-A)|0)>0?v+(w-A)|0:0)|0;w=c[P+(i<<2)>>2]|0;if((A|0)>=(((w|0)>(F|0)?w:F)|0)){if(Ba(t,1)|0){G=B;i=y;y=m;break e}z=c[C>>2]|0;A=A+-8|0;m=m+8|0}if((y|0)>0)B=d[23346+(i-e)>>0]|0;else B=y;w=(A|0)<(U|0)?0:U;m=m-(z+y)+w+B|0;c[C>>2]=w;z=i+-1|0;if((z|0)>(G|0)){w=i;y=B;i=z;B=w}else{y=B;S=50;break e}}}else{D=f;i=f+-1|0}while(1){M=x-m|0;C=c[Q>>2]|0;B=b[C+(D<<1)>>1]|0;z=b[C+(e<<1)>>1]|0;O=M-(N(B-z|0,(M>>>0)/((B-z|0)>>>0)|0)|0)|0;C=b[C+(i<<1)>>1]|0;E=o+(i<<2)|0;A=c[E>>2]|0;z=(N(B-C|0,(M>>>0)/((B-z|0)>>>0)|0)|0)+A+((O+(z-C)|0)>0?O+(z-C)|0:0)|0;O=c[P+(i<<2)>>2]|0;if((z|0)>=(((O|0)>(F|0)?O:F)|0)){if((D|0)<=(e+2|0))break;if(!((i|0)>(w|0)?1:(z|0)<=((N(B-C|0,(D|0)>17?((D|0)<=(v|0)?7:9):0)|0)<<s<<3>>4|0)))break;Cb(t,0,1);A=c[E>>2]|0;z=z+-8|0;m=m+8|0}if((y|0)>0)B=d[23346+(i-e)>>0]|0;else B=y;z=(z|0)<(U|0)?0:U;m=m-(A+y)+z+B|0;c[E>>2]=z;z=i+-1|0;if((z|0)>(G|0)){D=i;y=B;i=z}else{y=B;S=50;break e}}Cb(t,1,1);G=D;i=y;y=m}else{i=f;S=50}while(0);if((S|0)==50){G=i;i=y;y=m;x=x+R|0}do if((i|0)>0)if(!u){m=(Da(t,1-e+G|0)|0)+e|0;c[j>>2]=m;break}else{m=c[j>>2]|0;m=(m|0)<(G|0)?m:G;c[j>>2]=m;Db(t,m-e|0,1-e+G|0);m=c[j>>2]|0;break}else{c[j>>2]=0;m=0}while(0);S=(m|0)>(e|0);m=S?0:T;do if((T|0)>0&S)if(!u){c[k>>2]=Ba(t,1)|0;break}else{Cb(t,c[k>>2]|0,1);break}else c[k>>2]=0;while(0);z=m+(x-y)|0;F=c[Q>>2]|0;A=b[F+(e<<1)>>1]|0;i=(b[F+(G<<1)>>1]|0)-(A<<16>>16)|0;x=z-(N(i,(z>>>0)/(i>>>0)|0)|0)|0;if((G|0)>(e|0)){m=A;y=e;do{u=y;y=y+1|0;t=m;m=b[F+(y<<1)>>1]|0;t=N((m<<16>>16)-(t<<16>>16)|0,(z>>>0)/(i>>>0)|0)|0;c[o+(u<<2)>>2]=t+(c[o+(u<<2)>>2]|0)}while((y|0)!=(G|0));y=A;i=e;while(1){u=i;i=i+1|0;m=y;y=b[F+(i<<1)>>1]|0;m=(y<<16>>16)-(m<<16>>16)|0;m=(x|0)<(m|0)?x:m;c[o+(u<<2)>>2]=m+(c[o+(u<<2)>>2]|0);if((i|0)==(G|0))break;else x=x-m|0}E=H?4:3;D=A;m=0;do{C=e;e=e+1|0;A=D;D=b[F+(e<<1)>>1]|0;A=(D<<16>>16)-(A<<16>>16)<<s;B=(c[o+(C<<2)>>2]|0)+m|0;if((A|0)>1){x=B-(c[h+(C<<2)>>2]|0)|0;x=(x|0)>0?x:0;c[o+(C<<2)>>2]=B-x;i=N(A,r)|0;if((r|0)==2&(A|0)!=2?(c[k>>2]|0)==0:0)y=(C|0)<(c[j>>2]|0);else y=0;z=(y&1)+i|0;y=N((b[(c[a+56>>2]|0)+(C<<1)>>1]|0)+I|0,z)|0;i=N(z,-21)|0;i=((A|0)==2?z<<3>>2:0)+i+(y>>1)|0;if((i+(B-x)|0)<(z<<4|0))y=y>>2;else y=(i+(B-x)|0)<(z*24|0)?y>>3:0;u=y+i|0;t=(((((z<<2)+(B-x)+u|0)>0?(z<<2)+(B-x)+u|0:0)>>>0)/(z>>>0)|0)>>>3;c[p+(C<<2)>>2]=t;S=N(t,r)|0;T=c[o+(C<<2)>>2]|0;t=(S|0)>(T>>3|0)?T>>J>>3:t;t=(t|0)<8?t:8;c[p+(C<<2)>>2]=t;t=N(t,z<<3)|0;c[q+(C<<2)>>2]=(t|0)>=((c[o+(C<<2)>>2]|0)+u|0)&1;u=N(c[p+(C<<2)>>2]|0,U)|0;c[o+(C<<2)>>2]=(c[o+(C<<2)>>2]|0)-u}else{x=B-U|0;x=(x|0)>0?x:0;c[o+(C<<2)>>2]=B-x;c[p+(C<<2)>>2]=0;c[q+(C<<2)>>2]=1}if(!x)m=0;else{u=x>>>E;t=c[p+(C<<2)>>2]|0;u=(u|0)<(8-t|0)?u:8-t|0;c[p+(C<<2)>>2]=u+t;u=N(u,U)|0;c[q+(C<<2)>>2]=(u|0)>=(x-m|0)&1;m=x-u|0}}while((e|0)!=(G|0));e=G}else m=0;c[n>>2]=m;if((e|0)>=(f|0)){l=V;return G|0}do{a=o+(e<<2)|0;n=p+(e<<2)|0;c[n>>2]=c[a>>2]>>J>>3;c[a>>2]=0;c[q+(e<<2)>>2]=(c[n>>2]|0)<1&1;e=e+1|0}while((e|0)!=(f|0));l=V;return G|0}function Ta(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0.0;if((f<<1|0)>=(b|0)|(h|0)==0)return;q=+(b|0)/+((N(c[12024+(h+-1<<2)>>2]|0,f)|0)+b|0);r=+D(+(q*q*.5*1.5707963705062866));q=+D(+((1.0-q*q*.5)*1.5707963705062866));if((e<<3|0)>(b|0))f=0;else{f=1;while(1)if(((N((N(f,f)|0)+f|0,e)|0)+(e>>2)|0)<(b|0))f=f+1|0;else break}if((e|0)<=0)return;p=(f|0)==0;n=((b>>>0)/(e>>>0)|0)+-3|0;m=((b>>>0)/(e>>>0)|0)-f|0;o=((b>>>0)/(e>>>0)|0)-(f<<1)|0;l=0;do{k=N(l,(b>>>0)/(e>>>0)|0)|0;if((d|0)<0){if(!p){if((m|0)>0){h=a+(k<<2)|0;i=0;while(1){s=+g[h>>2];t=h+(f<<2)|0;j=+g[t>>2];g[t>>2]=r*s+q*j;g[h>>2]=q*s+j*-r;i=i+1|0;if((i|0)==(m|0))break;else h=h+4|0}}if((o|0)>0){h=a+(k<<2)+(o+-1<<2)|0;i=o+-1|0;while(1){j=+g[h>>2];t=h+(f<<2)|0;s=+g[t>>2];g[t>>2]=r*j+q*s;g[h>>2]=q*j+s*-r;if((i|0)>0){h=h+-4|0;i=i+-1|0}else break}}}if(((b>>>0)/(e>>>0)|0|0)>1){j=+g[a+(k<<2)>>2];h=a+(k<<2)|0;i=0;do{t=h;h=h+4|0;s=+g[h>>2];u=j;j=q*j+r*s;g[h>>2]=j;g[t>>2]=r*u+s*-q;i=i+1|0}while((i|0)!=(((b>>>0)/(e>>>0)|0)+-1|0))}if(((b>>>0)/(e>>>0)|0|0)>2){h=a+(k<<2)+(n<<2)|0;i=n;while(1){s=+g[h>>2];t=h+4|0;u=+g[t>>2];g[t>>2]=q*s+r*u;g[h>>2]=r*s+u*-q;if((i|0)>0){h=h+-4|0;i=i+-1|0}else break}}}else{if(((b>>>0)/(e>>>0)|0|0)>1){j=+g[a+(k<<2)>>2];h=a+(k<<2)|0;i=0;do{t=h;h=h+4|0;u=+g[h>>2];s=j;j=j*-q+r*u;g[h>>2]=j;g[t>>2]=r*s+q*u;i=i+1|0}while((i|0)!=(((b>>>0)/(e>>>0)|0)+-1|0))}if(((b>>>0)/(e>>>0)|0|0)>2){h=a+(k<<2)+(n<<2)|0;i=n;while(1){s=+g[h>>2];t=h+4|0;u=+g[t>>2];g[t>>2]=s*-q+r*u;g[h>>2]=r*s+q*u;if((i|0)>0){h=h+-4|0;i=i+-1|0}else break}}if(!p){if((m|0)>0){h=a+(k<<2)|0;i=0;while(1){s=+g[h>>2];t=h+(f<<2)|0;u=+g[t>>2];g[t>>2]=s*-r+q*u;g[h>>2]=q*s+r*u;i=i+1|0;if((i|0)==(m|0))break;else h=h+4|0}}if((o|0)>0){h=a+(k<<2)+(o+-1<<2)|0;i=o+-1|0;while(1){s=+g[h>>2];t=h+(f<<2)|0;u=+g[t>>2];g[t>>2]=s*-r+q*u;g[h>>2]=q*s+r*u;if((i|0)>0){h=h+-4|0;i=i+-1|0}else break}}}}l=l+1|0}while((l|0)!=(e|0));return}function Ua(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,i=0.0,j=0,k=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0;u=l;s=l;l=l+((1*(e<<2)|0)+15&-16)|0;t=l;l=l+((1*(e<<2)|0)+15&-16)|0;wc(s|0,0,((e|0)>1?e:1)<<2|0)|0;f=0;do{r=a+(f<<2)|0;q=+g[r>>2];c[t+(f<<2)>>2]=q<0.0&1;g[r>>2]=+A(+q);c[b+(f<<2)>>2]=0;f=f+1|0}while((f|0)<(e|0));if((e>>1|0)<(d|0)){f=0;h=0.0;do{h=h+ +g[a+(f<<2)>>2];f=f+1|0}while((f|0)<(e|0));if(!(h>1.0000000036274937e-15&h<64.0)){g[a>>2]=1.0;wc(a+4|0,0,(((e|0)>2?e:2)<<2)+-4|0)|0;h=1.0}k=(+(d|0)+.800000011920929)*(1.0/h);j=0;f=d;i=0.0;h=0.0;do{q=+g[a+(j<<2)>>2];r=~~+z(+(k*q));c[b+(j<<2)>>2]=r;h=h+ +(r|0)*+(r|0);i=i+q*+(r|0);g[s+(j<<2)>>2]=+(r|0)*2.0;f=f-r|0;j=j+1|0}while((j|0)<(e|0))}else{f=d;i=0.0;h=0.0}if((f|0)<=(e+3|0)){if((f|0)>0){q=+g[a>>2];r=0;while(1){o=h+1.0;n=i+q;m=o+ +g[s>>2];p=0;n=n*n;j=1;while(1){h=i+ +g[a+(j<<2)>>2];k=o+ +g[s+(j<<2)>>2];d=m*(h*h)>n*k;p=d?j:p;j=j+1|0;if((j|0)>=(e|0))break;else{m=d?k:m;n=d?h*h:n}}i=i+ +g[a+(p<<2)>>2];j=s+(p<<2)|0;h=+g[j>>2];g[j>>2]=h+2.0;p=b+(p<<2)|0;c[p>>2]=(c[p>>2]|0)+1;r=r+1|0;if((r|0)==(f|0)){h=o+h;break}else h=o+h}}}else{q=+(f|0);h=h+q*q+q*+g[s>>2];c[b>>2]=(c[b>>2]|0)+f}f=0;do{a=b+(f<<2)|0;s=c[t+(f<<2)>>2]|0;c[a>>2]=(c[a>>2]^0-s)+s;f=f+1|0}while((f|0)<(e|0));l=u;return +h}function Va(a,b,d,e,f,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=+i;j=j|0;k=k|0;var m=0.0,n=0,o=0;o=l;n=l;l=l+((1*(b+3<<2)|0)+15&-16)|0;Ta(a,b,1,f,d,e);m=+Ua(a,n,d,b,0);zb(n,b,d,h);if(j|0){m=1.0/+B(+m)*i;k=0;do{g[a+(k<<2)>>2]=m*+(c[n+(k<<2)>>2]|0);k=k+1|0}while((k|0)<(b|0));Ta(a,b,-1,f,d,e)}if((f|0)<2){b=1;l=o;return b|0}k=0;a=0;do{j=N(a,(b>>>0)/(f>>>0)|0)|0;h=0;d=0;do{d=c[n+(h+j<<2)>>2]|d;h=h+1|0}while((h|0)<((b>>>0)/(f>>>0)|0|0));k=((d|0)!=0&1)<<a|k;a=a+1|0}while((a|0)!=(f|0));l=o;return k|0}function Wa(a,b,d,e,f,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=+i;var j=0,k=0,m=0;m=l;k=l;l=l+((1*(b<<2)|0)+15&-16)|0;i=1.0/+B(+(+Ab(k,b,d,h)))*i;h=0;do{g[a+(h<<2)>>2]=i*+(c[k+(h<<2)>>2]|0);h=h+1|0}while((h|0)<(b|0));Ta(a,b,-1,f,d,e);if((f|0)<2){k=1;l=m;return k|0}h=0;j=0;do{a=N(j,(b>>>0)/(f>>>0)|0)|0;d=0;e=0;do{e=c[k+(d+a<<2)>>2]|e;d=d+1|0}while((d|0)<((b>>>0)/(f>>>0)|0|0));h=((e|0)!=0&1)<<j|h;j=j+1|0}while((j|0)!=(f|0));l=m;return h|0}function Xa(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;var e=0,f=0.0,h=0.0;if((b|0)>0){d=0;f=0.0}else return;do{h=+g[a+(d<<2)>>2];f=f+h*h;d=d+1|0}while((d|0)!=(b|0));f=1.0/+B(+(f+1.0000000036274937e-15))*c;if((b|0)>0){e=0;d=a}else return;while(1){g[d>>2]=f*+g[d>>2];e=e+1|0;if((e|0)==(b|0))break;else d=d+4|0}return}function Ya(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0;if(!c)if((d|0)>0){e=0;f=0.0;do{i=+g[a+(e<<2)>>2];f=f+i*i;e=e+1|0}while((e|0)!=(d|0));h=f+1.0000000036274937e-15;e=0;f=0.0;do{i=+g[b+(e<<2)>>2];f=f+i*i;e=e+1|0}while((e|0)!=(d|0));f=f+1.0000000036274937e-15}else{h=1.0000000036274937e-15;f=1.0000000036274937e-15}else if((d|0)>0){h=1.0000000036274937e-15;f=1.0000000036274937e-15;e=0;do{j=+g[a+(e<<2)>>2];i=+g[b+(e<<2)>>2];h=h+(j+i)*(j+i);f=f+(j-i)*(j-i);e=e+1|0}while((e|0)!=(d|0))}else{h=1.0000000036274937e-15;f=1.0000000036274937e-15}i=+B(+h);h=+B(+f);if(i*i+h*h<1.000000045813705e-18){j=0.0;j=j*10430.3818359375;j=j+.5;j=+z(+j);b=~~j;return b|0}f=h<0.0?-1.5707963705062866:1.5707963705062866;if(i*i<h*h){j=f+-(i*h*(h*h+i*i*.43157973885536194))/((h*h+i*i*.6784840226173401)*(h*h+i*i*.0859554186463356));j=j*10430.3818359375;j=j+.5;j=+z(+j);b=~~j;return b|0}else{j=f+i*h*(i*i+h*h*.43157973885536194)/((i*i+h*h*.6784840226173401)*(i*i+h*h*.0859554186463356))-(i*h<0.0?-1.5707963705062866:1.5707963705062866);j=j*10430.3818359375;j=j+.5;j=+z(+j);b=~~j;return b|0}return 0}function Za(a){a=a|0;c[a>>2]=8552;return 0}function _a(a){a=a|0;var b=0;Ib(a)|0;b=Ib(a+4264|0)|0;c[a+8528>>2]=0;c[a+8528+4>>2]=0;c[a+8528+8>>2]=0;c[a+8548>>2]=0;return b|0}function $a(d,f,g,h,i,j,k,m){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=l;l=l+672|0;c[w+20>>2]=0;c[w>>2]=0;c[w+4>>2]=0;n=c[f+4>>2]|0;if((h|0)!=0&(n|0)>0){h=0;do{c[d+(h*4264|0)+2388>>2]=0;h=h+1|0}while((h|0)<(n|0))}if((n|0)>(c[d+8544>>2]|0)){n=Ib(d+4264|0)|0;h=c[f+4>>2]|0}else{h=n;n=0}if((h|0)==1?(c[d+8544>>2]|0)==2:0)v=(c[f+12>>2]|0)==((c[d+2316>>2]|0)*1e3|0);else v=0;a:do if((c[d+2388>>2]|0)==0&(h|0)>0){p=0;b:while(1){switch(c[f+16>>2]|0){case 10:case 0:{h=1;o=2;break}case 20:{h=1;o=4;break}case 40:{h=2;o=4;break}case 60:{h=3;o=4;break}default:{h=-203;u=119;break b}}c[d+(p*4264|0)+2392>>2]=h;c[d+(p*4264|0)+2324>>2]=o;h=c[f+12>>2]>>10;switch(h|0){case 7:case 11:case 15:break;default:{h=-200;u=119;break b}}n=(Nb(d+(p*4264|0)|0,h+1|0,c[f+8>>2]|0)|0)+n|0;p=p+1|0;h=c[f+4>>2]|0;if((p|0)>=(h|0))break a}if((u|0)==119){l=w;return h|0}}while(0);o=c[f>>2]|0;do if((o|0)==2)if((h|0)==2){if((c[d+8540>>2]|0)!=1?(c[d+8544>>2]|0)!=1:0){o=2;h=2;break}c[d+8528>>2]=0;c[d+8536>>2]=0;zc(d+6696|0,d+2432|0,300)|0;o=c[f>>2]|0;h=c[f+4>>2]|0}else o=2;while(0);c[d+8540>>2]=o;c[d+8544>>2]=h;if(((c[f+8>>2]|0)+-8e3|0)>>>0>4e4){d=-200;l=w;return d|0}if((g|0)!=1?(c[d+2388>>2]|0)==0:0){if((h|0)>0){q=0;do{p=d+(q*4264|0)+2392|0;t=(c[p>>2]|0)>0;h=Ba(i,1)|0;if(t){o=0;do{c[d+(q*4264|0)+2404+(o<<2)>>2]=h;o=o+1|0;t=(o|0)<(c[p>>2]|0);h=Ba(i,1)|0}while(t)}c[d+(q*4264|0)+2416>>2]=h;q=q+1|0;h=c[f+4>>2]|0}while((q|0)<(h|0));if((h|0)>0){q=0;do{o=d+(q*4264|0)+2420|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;do if(c[d+(q*4264|0)+2416>>2]|0){p=d+(q*4264|0)+2392|0;h=c[p>>2]|0;if((h|0)==1){c[o>>2]=1;break}h=(Ca(i,c[12048+(h+-2<<2)>>2]|0,8)|0)+1|0;if((c[p>>2]|0)>0){o=0;do{c[d+(q*4264|0)+2420+(o<<2)>>2]=h>>>o&1;o=o+1|0}while((o|0)<(c[p>>2]|0))}}while(0);q=q+1|0;h=c[f+4>>2]|0}while((q|0)<(h|0))}}if((g|0)==0?(c[d+2392>>2]|0)>0:0){s=0;do{if((h|0)>0){r=d+6684+(s<<2)|0;q=s+-1|0;if((s|0)>0){p=0;do{o=d+(p*4264|0)|0;if(c[d+(p*4264|0)+2420+(s<<2)>>2]|0){do if((p|0)==0&(h|0)==2){hb(i,w);if(c[r>>2]|0)break;ib(i,w+20|0)}while(0);Lb(o,i,s,1,(c[d+(p*4264|0)+2420+(q<<2)>>2]|0)==0?0:2);Mb(i,w+24|0,a[d+(p*4264|0)+2765>>0]|0,a[d+(p*4264|0)+2766>>0]|0,c[d+(p*4264|0)+2328>>2]|0);h=c[f+4>>2]|0}p=p+1|0}while((p|0)<(h|0))}else{p=0;do{o=d+(p*4264|0)|0;if(c[d+(p*4264|0)+2420+(s<<2)>>2]|0){do if((p|0)==0&(h|0)==2){hb(i,w);if(c[r>>2]|0)break;ib(i,w+20|0)}while(0);Lb(o,i,s,1,0);Mb(i,w+24|0,a[d+(p*4264|0)+2765>>0]|0,a[d+(p*4264|0)+2766>>0]|0,c[d+(p*4264|0)+2328>>2]|0);h=c[f+4>>2]|0}p=p+1|0}while((p|0)<(h|0))}}s=s+1|0}while((s|0)<(c[d+2392>>2]|0))}}do if((h|0)==2){switch(g|0){case 0:{hb(i,w);if(!(c[d+6668+(c[d+2388>>2]<<2)>>2]|0))u=59;else u=60;break}case 2:{if((c[d+2420+(c[d+2388>>2]<<2)>>2]|0)==1){hb(i,w);if(!(c[d+6684+(c[d+2388>>2]<<2)>>2]|0))u=59;else u=60}else u=55;break}default:u=55}if((u|0)==55){c[w>>2]=b[d+8528>>1];c[w+4>>2]=b[d+8530>>1];break}else if((u|0)==59){ib(i,w+20|0);break}else if((u|0)==60){c[w+20>>2]=0;break}}while(0);h=c[f+4>>2]|0;if((h|0)==2&(c[w+20>>2]|0)==0)if((c[d+8548>>2]|0)==1){wc(d+5548|0,0,1024)|0;c[d+6572>>2]=100;a[d+6576>>0]=10;c[d+8428>>2]=0;c[d+6640>>2]=1;h=c[f+4>>2]|0}else h=2;s=N(h,c[f+12>>2]|0)|0;s=(s|0)<(N(c[f>>2]|0,c[f+8>>2]|0)|0);if(s)h=1;else h=N((c[d+2328>>2]|0)+2|0,h)|0;t=Z()|0;q=l;l=l+((1*(h<<1)|0)+15&-16)|0;q=s?j:q;c[w+8>>2]=q;p=q+(c[d+2328>>2]<<1)+4|0;c[w+8+4>>2]=p;if(g)if(c[d+8548>>2]|0){o=c[f+4>>2]|0;if((g|0)==2&(o|0)==2){h=(c[d+6684+(c[d+6652>>2]<<2)>>2]|0)==1;u=71}else h=0}else{h=1;u=71}else{h=(c[w+20>>2]|0)==0;u=71}if((u|0)==71)o=c[f+4>>2]|0;if((o|0)>0){c:do if(h){o=0;do{h=(c[d+2388>>2]|0)-o|0;do if((h|0)<1)h=0;else{if((g|0)==2){h=c[d+(o*4264|0)+2420+(h+-1<<2)>>2]|0?2:0;break}if((o|0)>0?c[d+8548>>2]|0:0){h=1;break}h=2}while(0);n=(Jb(d+(o*4264|0)|0,i,(c[w+8+(o<<2)>>2]|0)+4|0,w+16|0,g,h,m)|0)+n|0;h=d+(o*4264|0)+2388|0;c[h>>2]=(c[h>>2]|0)+1;o=o+1|0;h=c[f+4>>2]|0}while((o|0)<(h|0))}else{if((g|0)==2)o=0;else{o=0;while(1){if(!o)n=(Jb(d,i,q+4|0,w+16|0,g,(c[d+2388>>2]|0)>0?2:0,m)|0)+n|0;else wc((c[w+8+(o<<2)>>2]|0)+4|0,0,c[w+16>>2]<<1|0)|0;h=d+(o*4264|0)+2388|0;c[h>>2]=(c[h>>2]|0)+1;o=o+1|0;h=c[f+4>>2]|0;if((o|0)>=(h|0))break c}}do{if(!o){h=c[d+2388>>2]|0;if((h|0)<1)h=0;else h=c[d+2420+(h+-1<<2)>>2]|0?2:0;n=(Jb(d,i,q+4|0,w+16|0,2,h,m)|0)+n|0}else wc((c[w+8+(o<<2)>>2]|0)+4|0,0,c[w+16>>2]<<1|0)|0;h=d+(o*4264|0)+2388|0;c[h>>2]=(c[h>>2]|0)+1;o=o+1|0;h=c[f+4>>2]|0}while((o|0)<(h|0))}while(0);if((h|0)==2&(c[f>>2]|0)==2){ab(d+8528|0,q,p,w,c[d+2316>>2]|0,c[w+16>>2]|0);r=d+2316|0;p=c[w+16>>2]|0}else u=94}else u=94;if((u|0)==94){p=e[d+8532>>1]|e[d+8532+2>>1]<<16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=c[w+16>>2]|0;r=e[q+(p<<1)>>1]|e[q+(p<<1)+2>>1]<<16;b[d+8532>>1]=r;b[d+8532+2>>1]=r>>>16;r=d+2316|0}o=N(c[f+8>>2]|0,p)|0;o=(o|0)/((c[r>>2]<<16>>16)*1e3|0)|0;c[k>>2]=o;h=c[f>>2]|0;if((h|0)==2){q=l;l=l+((1*(o<<1)|0)+15&-16)|0}else q=j;o=c[f+4>>2]|0;if(s){u=c[d+2328>>2]|0;m=(N(u+2|0,o)|0)<<1;i=l;l=l+((1*m|0)+15&-16)|0;zc(i|0,j|0,N(o<<1,u+2|0)|0)|0;c[w+8>>2]=i;c[w+8+4>>2]=i+(u<<1)+4}d:do if((((h|0)<(o|0)?h:o)|0)>0){h=p;p=0;while(1){n=(cb(d+(p*4264|0)+2432|0,q,(c[w+8+(p<<2)>>2]|0)+2|0,h)|0)+n|0;h=c[f>>2]|0;if((h|0)==2){h=c[k>>2]|0;if((h|0)>0){o=0;do{b[j+((o<<1)+p<<1)>>1]=b[q+(o<<1)>>1]|0;o=o+1|0}while((o|0)<(h|0));h=c[f>>2]|0}else h=2}p=p+1|0;o=c[f+4>>2]|0;if((p|0)>=(((h|0)<(o|0)?h:o)|0))break d;h=c[w+16>>2]|0}}while(0);do if((h|0)==2&(o|0)==1)if(v){n=(cb(d+6696|0,q,(c[w+8>>2]|0)+2|0,c[w+16>>2]|0)|0)+n|0;h=c[k>>2]|0;if((h|0)>0)o=0;else break;do{b[j+((o<<1|1)<<1)>>1]=b[q+(o<<1)>>1]|0;o=o+1|0}while((o|0)<(h|0))}else{h=c[k>>2]|0;if((h|0)>0)o=0;else break;do{k=o<<1;b[j+((k|1)<<1)>>1]=b[j+(k<<1)>>1]|0;o=o+1|0}while((o|0)<(h|0))}while(0);if((c[d+4164>>2]|0)==2)h=N(c[12036+((c[r>>2]|0)+-8>>2<<2)>>2]|0,c[d+2308>>2]|0)|0;else h=0;c[f+20>>2]=h;if((g|0)==1){if((c[d+8544>>2]|0)>0){h=0;do{a[d+(h*4264|0)+2312>>0]=10;h=h+1|0}while((h|0)<(c[d+8544>>2]|0))}}else c[d+8548>>2]=c[w+20>>2];W(t|0);d=n;l=w;return d|0}function ab(a,d,f,g,h,i){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=e[a+4>>1]|e[a+4+2>>1]<<16;b[d>>1]=j;b[d+2>>1]=j>>>16;j=e[a+8>>1]|e[a+8+2>>1]<<16;b[f>>1]=j;b[f+2>>1]=j>>>16;j=e[d+(i<<1)>>1]|e[d+(i<<1)+2>>1]<<16;b[a+4>>1]=j;b[a+4+2>>1]=j>>>16;j=e[f+(i<<1)>>1]|e[f+(i<<1)+2>>1]<<16;b[a+8>>1]=j;b[a+8+2>>1]=j>>>16;j=b[a>>1]|0;k=b[a+2>>1]|0;p=c[g>>2]|0;o=((N(p-j<<16>>16,(65536/(h<<3|0)|0)<<16>>16)|0)>>15)+1>>1;n=c[g+4>>2]|0;m=((N(n-k<<16>>16,(65536/(h<<3|0)|0)<<16>>16)|0)>>15)+1>>1;if((h|0)>0){l=0;g=k;do{j=j+o|0;g=g+m|0;r=l;l=l+1|0;t=b[d+(l<<1)>>1]|0;r=(b[d+(r+2<<1)>>1]|0)+(b[d+(r<<1)>>1]|0)+(t<<1)|0;k=f+(l<<1)|0;q=j<<16>>16;s=g<<16>>16;q=((b[k>>1]<<8)+(N(t>>5,s)|0)+((N(t<<11&63488,s)|0)>>16)+(N(r>>7,q)|0)+((N(r<<9&65024,q)|0)>>16)>>7)+1>>1;b[k>>1]=(q|0)>32767?32767:((q|0)>-32768?q:-32768)&65535}while((l|0)<(h<<3|0))}if((h<<3|0)<(i|0)){g=h<<3;do{s=g;g=g+1|0;r=b[d+(g<<1)>>1]|0;s=(b[d+(s+2<<1)>>1]|0)+(b[d+(s<<1)>>1]|0)+(r<<1)|0;t=f+(g<<1)|0;s=((b[t>>1]<<8)+(N(r>>5,n<<16>>16)|0)+((N(r<<11&63488,n<<16>>16)|0)>>16)+(N(s>>7,p<<16>>16)|0)+((N(s<<9&65024,p<<16>>16)|0)>>16)>>7)+1>>1;b[t>>1]=(s|0)>32767?32767:((s|0)>-32768?s:-32768)&65535}while((g|0)!=(i|0))}b[a>>1]=p;b[a+2>>1]=n;if((i|0)>0)g=0;else return;do{g=g+1|0;q=d+(g<<1)|0;r=b[q>>1]|0;t=f+(g<<1)|0;s=b[t>>1]|0;b[q>>1]=(s+r|0)>32767?32767:((s+r|0)>-32768?s+r|0:-32768)&65535;b[t>>1]=(r-s|0)>32767?32767:((r-s|0)>-32768?r-s|0:-32768)&65535}while((g|0)!=(i|0));return}function bb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;wc(b|0,0,300)|0;if(!f){a:do if((d|0)>=12e3)if((d|0)<16e3){switch(d|0){case 12e3:break a;default:f=-1}return f|0}else{switch(d|0){case 16e3:break a;default:f=-1}return f|0}else{switch(d|0){case 8e3:break a;default:f=-1}return f|0}while(0);b:do if((e|0)<16e3)if((e|0)<12e3){switch(e|0){case 8e3:break b;default:f=-1}return f|0}else{switch(e|0){case 12e3:break b;default:f=-1}return f|0}else{if((e|0)<24e3){switch(e|0){case 16e3:break b;default:f=-1}return f|0}if((e|0)<48e3){switch(e|0){case 24e3:break b;default:f=-1}return f|0}else{switch(e|0){case 48e3:break b;default:f=-1}return f|0}}while(0);f=((e>>>12)-((e|0)>16e3&1)>>((e|0)>24e3&1))+-1+(23471+(((d>>>12)+-1|0)*5|0))|0}else{c:do if((d|0)<16e3)if((d|0)<12e3){switch(d|0){case 8e3:break c;default:f=-1}return f|0}else{switch(d|0){case 12e3:break c;default:f=-1}return f|0}else{if((d|0)<24e3){switch(d|0){case 16e3:break c;default:f=-1}return f|0}if((d|0)<48e3){switch(d|0){case 24e3:break c;default:f=-1}return f|0}else{switch(d|0){case 48e3:break c;default:f=-1}return f|0}}while(0);d:do if((e|0)>=12e3)if((e|0)<16e3){switch(e|0){case 12e3:break d;default:f=-1}return f|0}else{switch(e|0){case 16e3:break d;default:f=-1}return f|0}else{switch(e|0){case 8e3:break d;default:f=-1}return f|0}while(0);f=(e>>>12)+-1+(23456+((((d>>>12)-((d|0)>16e3&1)>>((d|0)>24e3&1))+-1|0)*3|0))|0}c[b+292>>2]=a[f>>0];c[b+284>>2]=(d>>>0)/1e3|0;c[b+288>>2]=(e>>>0)/1e3|0;c[b+268>>2]=((d>>>0)/1e3|0)*10;do if((e|0)>(d|0))if((d<<1|0)==(e|0)){c[b+264>>2]=1;f=0;break}else{c[b+264>>2]=2;f=1;break}else{if((e|0)>=(d|0)){c[b+264>>2]=0;f=0;break}c[b+264>>2]=3;if((e<<2|0)==(d*3|0)){c[b+280>>2]=3;c[b+276>>2]=18;c[b+296>>2]=19850;f=0;break}if((e*3|0)==(d<<1|0)){c[b+280>>2]=2;c[b+276>>2]=18;c[b+296>>2]=19908;f=0;break}if((e<<1|0)==(d|0)){c[b+280>>2]=1;c[b+276>>2]=24;c[b+296>>2]=19948;f=0;break}if((e*3|0)==(d|0)){c[b+280>>2]=1;c[b+276>>2]=36;c[b+296>>2]=19976;f=0;break}if((e<<2|0)==(d|0)){c[b+280>>2]=1;c[b+276>>2]=36;c[b+296>>2]=20016;f=0;break}if((e*6|0)==(d|0)){c[b+280>>2]=1;c[b+276>>2]=36;c[b+296>>2]=20056;f=0;break}else{b=-1;return b|0}}while(0);g=d<<f;f=((d<<(f|14)|0)/(e|0)|0)<<2;while(1)if(((N(f>>16,e<<16>>16)|0)+(N(f,((e>>>15)+1|0)>>>1)|0)+((N(f&65535,e<<16>>16)|0)>>16)|0)<(g|0))f=f+1|0;else break;c[b+272>>2]=f;b=0;return b|0}function cb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=c[a+292>>2]|0;f=(c[a+284>>2]|0)-g|0;zc(a+168+(g<<1)|0,d|0,f<<1|0)|0;switch(c[a+264>>2]|0){case 1:{gb(a,b,a+168|0,c[a+284>>2]|0);gb(a,b+(c[a+288>>2]<<1)|0,d+(f<<1)|0,e-(c[a+284>>2]|0)|0);break}case 2:{eb(a,b,a+168|0,c[a+284>>2]|0);eb(a,b+(c[a+288>>2]<<1)|0,d+(f<<1)|0,e-(c[a+284>>2]|0)|0);break}case 3:{db(a,b,a+168|0,c[a+284>>2]|0);db(a,b+(c[a+288>>2]<<1)|0,d+(f<<1)|0,e-(c[a+284>>2]|0)|0);break}default:{zc(b|0,a+168|0,c[a+284>>2]<<1|0)|0;zc(b+(c[a+288>>2]<<1)|0,d+(f<<1)|0,e-(c[a+284>>2]|0)<<1|0)|0}}g=c[a+292>>2]|0;zc(a+168|0,d+(e-g<<1)|0,g<<1|0)|0;return 0}function db(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;o=l;i=c[a+268>>2]|0;g=c[a+276>>2]|0;n=l;l=l+((1*(g+i<<2)|0)+15&-16)|0;zc(n|0,a+24|0,g<<2|0)|0;k=c[a+296>>2]|0;m=c[a+272>>2]|0;h=k;while(1){j=(f|0)<(i|0)?f:i;cc(a,n+(g<<2)|0,e,h,j);h=c[a+280>>2]|0;switch(c[a+276>>2]|0){case 18:{if((j<<16|0)>0){i=0;while(1){p=n+(i>>16<<2)|0;g=(N(i&65535,h<<16>>16)|0)>>16;E=k+4+(g*9<<1)|0;Y=c[p>>2]|0;V=b[E>>1]|0;X=N(V,Y>>16)|0;Y=(N(V,Y&65535)|0)>>16;V=c[p+4>>2]|0;T=b[E+2>>1]|0;W=N(T,V>>16)|0;V=(N(T,V&65535)|0)>>16;T=c[p+8>>2]|0;R=b[E+4>>1]|0;U=N(R,T>>16)|0;T=(N(R,T&65535)|0)>>16;R=c[p+12>>2]|0;P=b[E+6>>1]|0;S=N(P,R>>16)|0;R=(N(P,R&65535)|0)>>16;P=c[p+16>>2]|0;M=b[E+8>>1]|0;Q=N(M,P>>16)|0;P=(N(M,P&65535)|0)>>16;M=c[p+20>>2]|0;K=b[E+10>>1]|0;O=N(K,M>>16)|0;M=(N(K,M&65535)|0)>>16;K=c[p+24>>2]|0;I=b[E+12>>1]|0;L=N(I,K>>16)|0;K=(N(I,K&65535)|0)>>16;I=c[p+28>>2]|0;G=b[E+14>>1]|0;J=N(G,I>>16)|0;I=(N(G,I&65535)|0)>>16;G=c[p+32>>2]|0;E=b[E+16>>1]|0;H=N(E,G>>16)|0;G=(N(E,G&65535)|0)>>16;g=k+4+((h+-1-g|0)*9<<1)|0;E=c[p+68>>2]|0;C=b[g>>1]|0;F=N(C,E>>16)|0;E=(N(C,E&65535)|0)>>16;C=c[p+64>>2]|0;A=b[g+2>>1]|0;D=N(A,C>>16)|0;C=(N(A,C&65535)|0)>>16;A=c[p+60>>2]|0;y=b[g+4>>1]|0;B=N(y,A>>16)|0;A=(N(y,A&65535)|0)>>16;y=c[p+56>>2]|0;w=b[g+6>>1]|0;z=N(w,y>>16)|0;y=(N(w,y&65535)|0)>>16;w=c[p+52>>2]|0;u=b[g+8>>1]|0;x=N(u,w>>16)|0;w=(N(u,w&65535)|0)>>16;u=c[p+48>>2]|0;s=b[g+10>>1]|0;v=N(s,u>>16)|0;u=(N(s,u&65535)|0)>>16;s=c[p+44>>2]|0;q=b[g+12>>1]|0;t=N(q,s>>16)|0;s=(N(q,s&65535)|0)>>16;q=c[p+40>>2]|0;Z=b[g+14>>1]|0;r=N(Z,q>>16)|0;q=(N(Z,q&65535)|0)>>16;p=c[p+36>>2]|0;g=b[g+16>>1]|0;p=(Y+X+W+V+U+T+S+R+Q+P+O+M+L+K+J+I+H+G+F+E+D+C+B+A+z+y+x+w+v+u+t+s+r+q+(N(g,p>>16)|0)+((N(g,p&65535)|0)>>16)>>5)+1>>1;g=d+2|0;b[d>>1]=(p|0)>32767?32767:((p|0)>-32768?p:-32768)&65535;i=i+m|0;if((i|0)>=(j<<16|0)){d=g;break}else d=g}}break}case 24:{if((j<<16|0)>0){h=0;while(1){g=n+(h>>16<<2)|0;Z=(c[g+92>>2]|0)+(c[g>>2]|0)|0;C=b[k+4>>1]|0;D=N(Z>>16,C)|0;C=(N(Z&65535,C)|0)>>16;Z=(c[g+88>>2]|0)+(c[g+4>>2]|0)|0;F=b[k+6>>1]|0;E=N(Z>>16,F)|0;F=(N(Z&65535,F)|0)>>16;Z=(c[g+84>>2]|0)+(c[g+8>>2]|0)|0;H=b[k+8>>1]|0;G=N(Z>>16,H)|0;H=(N(Z&65535,H)|0)>>16;Z=(c[g+80>>2]|0)+(c[g+12>>2]|0)|0;J=b[k+10>>1]|0;I=N(Z>>16,J)|0;J=(N(Z&65535,J)|0)>>16;Z=(c[g+76>>2]|0)+(c[g+16>>2]|0)|0;L=b[k+12>>1]|0;K=N(Z>>16,L)|0;L=(N(Z&65535,L)|0)>>16;Z=(c[g+72>>2]|0)+(c[g+20>>2]|0)|0;O=b[k+14>>1]|0;M=N(Z>>16,O)|0;O=(N(Z&65535,O)|0)>>16;Z=(c[g+68>>2]|0)+(c[g+24>>2]|0)|0;Q=b[k+16>>1]|0;P=N(Z>>16,Q)|0;Q=(N(Z&65535,Q)|0)>>16;Z=(c[g+64>>2]|0)+(c[g+28>>2]|0)|0;S=b[k+18>>1]|0;R=N(Z>>16,S)|0;S=(N(Z&65535,S)|0)>>16;Z=(c[g+60>>2]|0)+(c[g+32>>2]|0)|0;U=b[k+20>>1]|0;T=N(Z>>16,U)|0;U=(N(Z&65535,U)|0)>>16;Z=(c[g+56>>2]|0)+(c[g+36>>2]|0)|0;W=b[k+22>>1]|0;V=N(Z>>16,W)|0;W=(N(Z&65535,W)|0)>>16;Z=(c[g+52>>2]|0)+(c[g+40>>2]|0)|0;Y=b[k+24>>1]|0;X=N(Z>>16,Y)|0;Y=(N(Z&65535,Y)|0)>>16;g=(c[g+48>>2]|0)+(c[g+44>>2]|0)|0;Z=b[k+26>>1]|0;Z=(C+D+E+F+G+H+I+J+K+L+M+O+P+Q+R+S+T+U+V+W+X+Y+(N(g>>16,Z)|0)+((N(g&65535,Z)|0)>>16)>>5)+1>>1;g=d+2|0;b[d>>1]=(Z|0)>32767?32767:((Z|0)>-32768?Z:-32768)&65535;h=h+m|0;if((h|0)>=(j<<16|0)){d=g;break}else d=g}}break}case 36:{if((j<<16|0)>0){h=0;while(1){g=n+(h>>16<<2)|0;Z=(c[g+140>>2]|0)+(c[g>>2]|0)|0;q=b[k+4>>1]|0;r=N(Z>>16,q)|0;q=(N(Z&65535,q)|0)>>16;Z=(c[g+136>>2]|0)+(c[g+4>>2]|0)|0;t=b[k+6>>1]|0;s=N(Z>>16,t)|0;t=(N(Z&65535,t)|0)>>16;Z=(c[g+132>>2]|0)+(c[g+8>>2]|0)|0;v=b[k+8>>1]|0;u=N(Z>>16,v)|0;v=(N(Z&65535,v)|0)>>16;Z=(c[g+128>>2]|0)+(c[g+12>>2]|0)|0;x=b[k+10>>1]|0;w=N(Z>>16,x)|0;x=(N(Z&65535,x)|0)>>16;Z=(c[g+124>>2]|0)+(c[g+16>>2]|0)|0;z=b[k+12>>1]|0;y=N(Z>>16,z)|0;z=(N(Z&65535,z)|0)>>16;Z=(c[g+120>>2]|0)+(c[g+20>>2]|0)|0;B=b[k+14>>1]|0;A=N(Z>>16,B)|0;B=(N(Z&65535,B)|0)>>16;Z=(c[g+116>>2]|0)+(c[g+24>>2]|0)|0;D=b[k+16>>1]|0;C=N(Z>>16,D)|0;D=(N(Z&65535,D)|0)>>16;Z=(c[g+112>>2]|0)+(c[g+28>>2]|0)|0;F=b[k+18>>1]|0;E=N(Z>>16,F)|0;F=(N(Z&65535,F)|0)>>16;Z=(c[g+108>>2]|0)+(c[g+32>>2]|0)|0;H=b[k+20>>1]|0;G=N(Z>>16,H)|0;H=(N(Z&65535,H)|0)>>16;Z=(c[g+104>>2]|0)+(c[g+36>>2]|0)|0;J=b[k+22>>1]|0;I=N(Z>>16,J)|0;J=(N(Z&65535,J)|0)>>16;Z=(c[g+100>>2]|0)+(c[g+40>>2]|0)|0;L=b[k+24>>1]|0;K=N(Z>>16,L)|0;L=(N(Z&65535,L)|0)>>16;Z=(c[g+96>>2]|0)+(c[g+44>>2]|0)|0;O=b[k+26>>1]|0;M=N(Z>>16,O)|0;O=(N(Z&65535,O)|0)>>16;Z=(c[g+92>>2]|0)+(c[g+48>>2]|0)|0;Q=b[k+28>>1]|0;P=N(Z>>16,Q)|0;Q=(N(Z&65535,Q)|0)>>16;Z=(c[g+88>>2]|0)+(c[g+52>>2]|0)|0;S=b[k+30>>1]|0;R=N(Z>>16,S)|0;S=(N(Z&65535,S)|0)>>16;Z=(c[g+84>>2]|0)+(c[g+56>>2]|0)|0;U=b[k+32>>1]|0;T=N(Z>>16,U)|0;U=(N(Z&65535,U)|0)>>16;Z=(c[g+80>>2]|0)+(c[g+60>>2]|0)|0;W=b[k+34>>1]|0;V=N(Z>>16,W)|0;W=(N(Z&65535,W)|0)>>16;Z=(c[g+76>>2]|0)+(c[g+64>>2]|0)|0;Y=b[k+36>>1]|0;X=N(Z>>16,Y)|0;Y=(N(Z&65535,Y)|0)>>16;g=(c[g+72>>2]|0)+(c[g+68>>2]|0)|0;Z=b[k+38>>1]|0;Z=(q+r+s+t+u+v+w+x+y+z+A+B+C+D+E+F+G+H+I+J+K+L+M+O+P+Q+R+S+T+U+V+W+X+Y+(N(g>>16,Z)|0)+((N(g&65535,Z)|0)>>16)>>5)+1>>1;g=d+2|0;b[d>>1]=(Z|0)>32767?32767:((Z|0)>-32768?Z:-32768)&65535;h=h+m|0;if((h|0)>=(j<<16|0)){d=g;break}else d=g}}break}default:{}}f=f-j|0;g=c[a+276>>2]|0;if((f|0)<=1)break;zc(n|0,n+(j<<2)|0,g<<2|0)|0;i=c[a+268>>2]|0;h=c[a+296>>2]|0;e=e+(j<<1)|0}zc(a+24|0,n+(j<<2)|0,g<<2|0)|0;l=o;return}function eb(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0;m=l;g=c[a+268>>2]|0;k=l;l=l+((1*((g<<1)+8<<1)|0)+15&-16)|0;b[k>>1]=b[a+24>>1]|0;b[k+2>>1]=b[a+24+2>>1]|0;b[k+4>>1]=b[a+24+4>>1]|0;b[k+6>>1]=b[a+24+6>>1]|0;b[k+8>>1]=b[a+24+8>>1]|0;b[k+10>>1]=b[a+24+10>>1]|0;b[k+12>>1]=b[a+24+12>>1]|0;b[k+14>>1]=b[a+24+14>>1]|0;j=c[a+272>>2]|0;while(1){i=(f|0)<(g|0)?f:g;fb(a,k+16|0,e,i);if((i<<17|0)>0){h=0;g=d;while(1){d=((h&65535)*12|0)>>>16;n=k+(h>>16<<1)|0;o=N(b[20096+(d<<3)>>1]|0,b[n>>1]|0)|0;o=(N(b[20096+(d<<3)+2>>1]|0,b[n+2>>1]|0)|0)+o|0;o=o+(N(b[20096+(d<<3)+4>>1]|0,b[n+4>>1]|0)|0)|0;o=o+(N(b[20096+(d<<3)+6>>1]|0,b[n+6>>1]|0)|0)|0;o=o+(N(b[20096+(11-d<<3)+6>>1]|0,b[n+8>>1]|0)|0)|0;o=o+(N(b[20096+(11-d<<3)+4>>1]|0,b[n+10>>1]|0)|0)|0;o=o+(N(b[20096+(11-d<<3)+2>>1]|0,b[n+12>>1]|0)|0)|0;n=(o+(N(b[20096+(11-d<<3)>>1]|0,b[n+14>>1]|0)|0)>>14)+1>>1;d=g+2|0;b[g>>1]=(n|0)>32767?32767:((n|0)>-32768?n:-32768)&65535;h=h+j|0;if((h|0)>=(i<<17|0))break;else g=d}}f=f-i|0;if((f|0)<=0)break;g=k+(i<<1<<1)|0;b[k>>1]=b[g>>1]|0;b[k+2>>1]=b[g+2>>1]|0;b[k+4>>1]=b[g+4>>1]|0;b[k+6>>1]=b[g+6>>1]|0;b[k+8>>1]=b[g+8>>1]|0;b[k+10>>1]=b[g+10>>1]|0;b[k+12>>1]=b[g+12>>1]|0;b[k+14>>1]=b[g+14>>1]|0;g=c[a+268>>2]|0;e=e+(i<<1)|0}o=k+(i<<1<<1)|0;b[a+24>>1]=b[o>>1]|0;b[a+24+2>>1]=b[o+2>>1]|0;b[a+24+4>>1]=b[o+4>>1]|0;b[a+24+6>>1]=b[o+6>>1]|0;b[a+24+8>>1]=b[o+8>>1]|0;b[a+24+10>>1]=b[o+10>>1]|0;b[a+24+12>>1]=b[o+12>>1]|0;b[a+24+14>>1]=b[o+14>>1]|0;l=m;return}function fb(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((f|0)<=0)return;g=c[a+20>>2]|0;h=c[a+4>>2]|0;i=c[a+8>>2]|0;j=c[a+12>>2]|0;k=c[a+16>>2]|0;l=c[a>>2]|0;m=0;do{p=b[e+(m<<1)>>1]<<10;q=p-l|0;n=(((q&65535)*1746|0)>>>16)+((q>>16)*1746|0)+l|0;l=(((q&65535)*1746|0)>>>16)+((q>>16)*1746|0)+p|0;q=n-h|0;o=(((q&65535)*14986|0)>>>16)+((q>>16)*14986|0)+h|0;h=(((q&65535)*14986|0)>>>16)+((q>>16)*14986|0)+n|0;n=o-i|0;q=((N(n&65535,-26453)|0)>>16)+(N(n>>16,-26453)|0)|0;i=n+o+q|0;n=m<<1;b[d+(n<<1)>>1]=((q+o>>9)+1>>1|0)>32767?32767:(((q+o>>9)+1>>1|0)>-32768?(q+o>>9)+1>>1:-32768)&65535;o=p-j|0;q=(((o&65535)*6854|0)>>>16)+((o>>16)*6854|0)+j|0;j=(((o&65535)*6854|0)>>>16)+((o>>16)*6854|0)+p|0;p=q-k|0;o=(((p&65535)*25769|0)>>>16)+((p>>16)*25769|0)+k|0;k=(((p&65535)*25769|0)>>>16)+((p>>16)*25769|0)+q|0;q=o-g|0;p=((N(q&65535,-9994)|0)>>16)+(N(q>>16,-9994)|0)|0;g=q+o+p|0;b[d+((n|1)<<1)>>1]=((p+o>>9)+1>>1|0)>32767?32767:(((p+o>>9)+1>>1|0)>-32768?(p+o>>9)+1>>1:-32768)&65535;m=m+1|0}while((m|0)!=(f|0));c[a>>2]=l;c[a+4>>2]=h;c[a+8>>2]=i;c[a+12>>2]=j;c[a+16>>2]=k;c[a+20>>2]=g;return}function gb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;fb(a,b,c,d);return}function hb(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;j=Ca(a,23370,8)|0;g=(N((j|0)/5|0,-5)|0)+j|0;k=Ca(a,23423,8)|0;i=Ca(a,23430,8)|0;h=Ca(a,23423,8)|0;f=Ca(a,23430,8)|0;e=b[19804+(k+(((j|0)/5|0)*3|0)<<1)>>1]|0;a=(b[19804+(k+(((j|0)/5|0)*3|0)+1<<1)>>1]|0)-e|0;e=(N((N(a>>16,429522944)|0)+((a&65535)*6554|0)>>16,i<<17>>16|1)|0)+e|0;a=b[19804+(h+(g*3|0)<<1)>>1]|0;g=(b[19804+(h+(g*3|0)+1<<1)>>1]|0)-a|0;a=(N((N(g>>16,429522944)|0)+((g&65535)*6554|0)>>16,f<<17>>16|1)|0)+a|0;c[d+4>>2]=a;c[d>>2]=e-a;return}function ib(a,b){a=a|0;b=b|0;c[b>>2]=Ca(a,23395,8)|0;return}function jb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0;if(!((d|0)!=0&((a|0)!=0&((b|0)>0&(c|0)>0))))return;f=N(c,b)|0;if((f|0)>0){e=0;do{r=a+(e<<2)|0;o=+g[r>>2];q=(o>2.0?2.0:o)<-2.0;g[r>>2]=o>2.0|q?(q?-2.0:2.0):o;e=e+1|0}while((e|0)!=(f|0));r=0}else r=0;do{p=a+(r<<2)|0;q=d+(r<<2)|0;h=+g[q>>2];f=0;do{e=p+((N(f,c)|0)<<2)|0;i=+g[e>>2];if(h*i>=0.0)break;g[e>>2]=i+i*(h*i);f=f+1|0}while((f|0)<(b|0));o=+g[p>>2];n=0;while(1){a:do if((n|0)<(b|0)){e=n;do{l=+g[p+((N(e,c)|0)<<2)>>2];if(l>1.0|l<-1.0)break a;e=e+1|0}while((e|0)<(b|0))}else e=n;while(0);if((e|0)==(b|0)){h=0.0;break}l=+g[p+((N(e,c)|0)<<2)>>2];h=+A(+l);m=e;while(1){if((m|0)<=0)break;f=m+-1|0;if(!(l*+g[p+((N(f,c)|0)<<2)>>2]>=0.0))break;else m=f}b:do if((e|0)<(b|0)){j=e;i=h;while(1){h=+g[p+((N(j,c)|0)<<2)>>2];if(!(l*h>=0.0)){h=i;k=e;break b}h=+A(+h);f=h>i;h=f?h:i;f=f?j:e;e=j+1|0;if((e|0)<(b|0)){j=e;i=h;e=f}else{j=e;k=f;break}}}else{j=e;k=e}while(0);if(!m)f=l*+g[p>>2]>=0.0;else f=0;h=(h+-1.0)/(h*h);h=l>0.0?-(h+h*2.399999914359796e-07):h+h*2.399999914359796e-07;if((m|0)<(j|0)){e=m;do{m=p+((N(e,c)|0)<<2)|0;l=+g[m>>2];g[m>>2]=l+l*(h*l);e=e+1|0}while((e|0)!=(j|0))}if((k|0)>1&f?(t=o-+g[p>>2],s=t/+(k|0),(n|0)<(k|0)):0){e=n;i=t;do{i=i-s;n=p+((N(e,c)|0)<<2)|0;l=i+ +g[n>>2];m=(l>1.0?1.0:l)<-1.0;g[n>>2]=l>1.0|m?(m?-1.0:1.0):l;e=e+1|0}while((e|0)!=(k|0))}if((j|0)==(b|0))break;else n=j}g[q>>2]=h;r=r+1|0}while((r|0)!=(c|0));return}function kb(a,b){a=a|0;b=b|0;a=d[a>>0]|0;if(a&128|0){b=(b<<(a>>>3&3)|0)/400|0;return b|0}if((a&96|0)==96){b=(b|0)/((a&8|0?50:100)|0)|0;return b|0}if((a>>>3&3|0)==3){b=(b*60|0)/1e3|0;return b|0}else{b=(b<<(a>>>3&3)|0)/100|0;return b|0}return 0}function lb(e,f,g,h,i,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0;if((f|0)<0|(j|0)==0){P=-1;return P|0}if(!f){P=-4;return P|0}P=a[e>>0]|0;do if(!(P&128)){if((P&96|0)==96){n=48e3/((P&8|0?50:100)>>>0)|0;break}if(((P&255)>>>3&3|0)==3)n=2880;else n=(48e3<<((P&255)>>>3&3)>>>0)/100|0}else n=(48e3<<((P&255)>>>3&3)>>>0)/400|0;while(0);a:do switch(P&3){case 0:{A=0;B=1;z=e+1|0;y=f+-1|0;p=f+-1|0;w=0;t=43;break}case 1:{if(!g)if(!(f+-1&1)){b[j>>1]=(f+-1|0)/2|0;C=2;D=e+1|0;E=(f+-1|0)/2|0;F=0;t=56;break a}else{P=-4;return P|0}else{J=1;M=2;H=e+1|0;L=f+-1|0;G=f+-1|0;O=0;t=44}break}case 2:{do if((f|0)>=2){n=a[e+1>>0]|0;if((n&255)<252){n=n&255;o=1}else{if((f|0)<3)break;n=(d[e+2>>0]<<2)+(n&255)&65535;o=2}b[j>>1]=n;p=f+-1-o|0;n=n<<16>>16;if((p|0)<(n|0)){P=-4;return P|0}else{A=0;B=2;z=e+1+o|0;y=p-n|0;w=0;t=43;break a}}while(0);b[j>>1]=-1;P=-4;return P|0}default:{if((f|0)<2){P=-4;return P|0}x=d[e+1>>0]|0;if((x&63|0)==0|(N(x&63,n)|0)>>>0>5760){P=-4;return P|0}if(x&64){n=e+2|0;o=f+-2|0;q=0;do{if((o|0)<1){v=-4;t=68;break}u=n;n=n+1|0;u=a[u>>0]|0;s=u<<24>>24==-1?254:u&255;o=o+-1-s|0;q=s+q|0}while(u<<24>>24==-1);if((t|0)==68)return v|0;if((o|0)<0){P=-4;return P|0}else{r=n;s=o}}else{r=e+2|0;s=f+-2|0;q=0}if(!(x&128)){if(g|0){J=x>>>7^1;M=x&63;H=r;L=f+-1|0;G=s;O=q;t=44;break a}o=(s|0)/(x&63|0)|0;if((N(o,x&63)|0)!=(s|0)){P=-4;return P|0}if((x&63)>>>0<=1){C=x&63;D=r;E=o;F=q;t=56;break a}n=0;while(1){b[j+(n<<1)>>1]=o;n=n+1|0;if((n|0)==((x&63)+-1|0)){A=x>>>7^1;B=x&63;z=r;y=o;p=s;w=q;t=43;break a}}}if((x&63)>>>0>1){t=0;u=s;f=s;while(1){s=j+(t<<1)|0;if((f|0)<1){t=34;break}n=a[r>>0]|0;if((n&255)<252){n=n&255;o=1}else{if((f|0)<2){t=34;break}n=(d[r+1>>0]<<2)+(n&255)&65535;o=2}b[s>>1]=n;f=f-o|0;n=n<<16>>16;if((n|0)>(f|0)){v=-4;t=68;break}r=r+o|0;u=u-n-o|0;t=t+1|0;if((t|0)>=((x&63)+-1|0)){t=37;break}}if((t|0)==34){b[s>>1]=-1;P=-4;return P|0}else if((t|0)==37){if((u|0)<0)v=-4;else{A=x>>>7^1;B=x&63;z=r;y=u;p=f;w=q;t=43;break a}return v|0}else if((t|0)==68)return v|0}else{A=x>>>7^1;B=x&63;z=r;y=s;p=s;w=q;t=43}}}while(0);if((t|0)==43)if(!g){C=B;D=z;E=y;F=w;t=56}else{J=A;M=B;H=z;L=y;G=p;O=w;t=44}do if((t|0)==44){n=j+(M<<1)+-2|0;do if((G|0)>=1){m=a[H>>0]|0;if((m&255)<252){q=m&255;r=1;break}if((G|0)>=2){q=(d[H+1>>0]<<2)+(m&255)&65535;r=2}else{q=-1;r=-1}}else{q=-1;r=-1}while(0);b[n>>1]=q;o=G-r|0;p=M+-1|0;n=q<<16>>16;if(q<<16>>16<0|(n|0)>(o|0)){P=-4;return P|0}m=H+r|0;if(!J){if((n+r|0)>(L|0))v=-4;else{K=M;I=O;break}return v|0}if((N(n,M)|0)>(o|0)){P=-4;return P|0}if((M|0)>1?(b[j>>1]=q,(p|0)!=1):0){n=1;do{b[j+(n<<1)>>1]=b[j+(p<<1)>>1]|0;n=n+1|0}while((n|0)!=(p|0));K=M;I=O}else{K=M;I=O}}else if((t|0)==56)if((E|0)>1275){P=-4;return P|0}else{b[j+(C+-1<<1)>>1]=E;K=C;m=D;I=F;break}while(0);if(k|0)c[k>>2]=m-e;if((K|0)>0)if(!i){n=0;do{m=m+(b[j+(n<<1)>>1]|0)|0;n=n+1|0}while((n|0)!=(K|0))}else{n=0;do{c[i+(n<<2)>>2]=m;m=m+(b[j+(n<<1)>>1]|0)|0;n=n+1|0}while((n|0)!=(K|0))}if(l|0)c[l>>2]=I-e+m;if(!h){P=K;return P|0}a[h>>0]=P;P=K;return P|0}function mb(a){a=a|0;return (N(a,1664525)|0)+1013904223|0}function nb(a,d,e,f,h,i,j,k,l){a=a|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0.0,n=0,o=0,p=0,q=0,r=0,s=0;q=c[a+32>>2]|0;p=N(c[a+44>>2]|0,j)|0;a=N(b[q+(i<<1)>>1]|0,j)|0;if((k|0)!=1)a=(a|0)<((p|0)/(k|0)|0|0)?a:(p|0)/(k|0)|0;o=(l|0)==0?a:0;n=(l|0)==0?i:0;i=(l|0)==0?h:0;a=b[q+(i<<1)>>1]|0;l=N(a<<16>>16,j)|0;if((l|0)>0){wc(e|0,0,l<<2|0)|0;k=e+(l<<2)|0}else k=e;if((i|0)<(n|0))h=d+(l<<2)|0;else{f=e+(o<<2)|0;e=p-o|0;e=e<<2;wc(f|0,0,e|0)|0;return}do{l=N(a<<16>>16,j)|0;r=i;i=i+1|0;a=b[q+(i<<1)>>1]|0;d=N(a<<16>>16,j)|0;m=+g[f+(r<<2)>>2]+ +g[11892+(r<<2)>>2];m=+K(+((m>32.0?32.0:m)*.6931471805599453));do{s=h;h=h+4|0;r=k;k=k+4|0;g[r>>2]=m*+g[s>>2];l=l+1|0}while((l|0)<(d|0))}while((i|0)!=(n|0));r=e+(o<<2)|0;s=p-o|0;s=s<<2;wc(r|0,0,s|0)|0;return}function ob(a,e,f,h,i,j,k,l,m,n,o,p,q,r){a=a|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0.0,t=0,u=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0,C=0.0,D=0,E=0,F=0.0,G=0.0;if((k|0)>=(l|0))return;do{E=c[a+32>>2]|0;A=k;k=k+1|0;E=(b[E+(k<<1)>>1]|0)-(b[E+(A<<1)>>1]|0)|0;C=+K(+(+(((((c[p+(A<<2)>>2]|0)+1|0)>>>0)/(E>>>0)|0)>>>h|0)*-.125*.6931471805599453))*.5;z=1.0/+B(+(+(E<<h|0)));D=N(A,i)|0;y=0;do{t=c[a+8>>2]|0;v=(N(t,y)|0)+A|0;u=+g[n+(v<<2)>>2];s=+g[o+(v<<2)>>2];if((i|0)==1){G=+g[n+(t+A<<2)>>2];F=+g[o+(t+A<<2)>>2];u=u>G?u:G;s=s>F?s:F}s=+g[m+(v<<2)>>2]-(u<s?u:s);s=+K(+(-(s<0.0?0.0:s)*.6931471805599453))*2.0;s=(h|0)==3?s*1.4142135381698608:s;s=z*(C<s?C:s);x=e+((N(y,j)|0)<<2)|0;x=x+(b[(c[a+32>>2]|0)+(A<<1)>>1]<<h<<2)|0;if((h|0)!=31){v=f+(y+D)|0;if((E|0)>0){w=0;t=0;do{if(!(d[v>>0]&1<<w)){t=0;do{q=(N(q,1664525)|0)+1013904223|0;g[x+((t<<h)+w<<2)>>2]=q&32768|0?s:-s;t=t+1|0}while((t|0)!=(E|0));t=1}w=w+1|0}while((w|0)<(1<<h|0))}else{v=d[v>>0]|0;w=0;t=0;do{t=(v&1<<w|0)==0?1:t;w=w+1|0}while((w|0)<(1<<h|0))}if(t)Xa(x,E<<h,1.0,r)}y=y+1|0}while((y|0)<(i|0))}while((k|0)!=(l|0));return}function pb(e,f,h,i,j,k,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C){e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;t=t|0;u=u|0;v=v|0;w=w|0;x=x|0;y=y|0;z=z|0;A=A|0;B=B|0;C=C|0;var D=0,E=0,F=0.0,G=0.0,H=0,I=0,J=0.0,K=0.0,L=0,M=0.0,O=0.0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,X=0,Y=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0;pa=l;l=l+1552|0;ma=c[f+32>>2]|0;na=k|0?2:1;la=(e|0)!=0&(k|0)!=0&(r|0)==0&(A|0)>7;ha=p|0?1<<x:1;ia=b[ma+(h<<1)>>1]<<x;A=N((b[ma+((c[f+8>>2]|0)+-1<<1)>>1]<<x)-ia|0,na)|0;fa=Z()|0;ja=l;l=l+((1*(A<<2)|0)+15&-16)|0;A=c[f+8>>2]|0;p=b[ma+(A+-1<<1)>>1]|0;ga=ja+(p<<x<<2)+(0-ia<<2)|0;if(la){p=(b[ma+(A<<1)>>1]|0)-p<<x;D=l;l=l+((1*(p<<2)|0)+15&-16)|0}else{D=j+(p<<x<<2)|0;p=1}da=l;l=l+((1*(p<<2)|0)+15&-16)|0;ea=l;l=l+((1*(p<<2)|0)+15&-16)|0;c[pa+208+36>>2]=n;c[pa+208+28>>2]=w;c[pa+208>>2]=e;c[pa+208+16>>2]=s;c[pa+208+8>>2]=f;A=c[z>>2]|0;c[pa+208+40>>2]=A;c[pa+208+20>>2]=q;c[pa+208+44>>2]=B;c[pa+208+52>>2]=C;c[pa+208+4>>2]=(la|(e|0)!=0^1)&1;c[pa+208+48>>2]=0;c[pa+208+56>>2]=(ha|0)>1&1;if((h|0)>=(i|0)){u=A;c[z>>2]=u;W(fa|0);l=pa;return}ca=l;l=l+((1*(p<<2)|0)+15&-16)|0;ba=l;l=l+((1*(p<<2)|0)+15&-16)|0;aa=l;l=l+((1*(p<<2)|0)+15&-16)|0;$=k|0?ja:0;_=h;B=0;A=1;while(1){c[pa+208+12>>2]=_;Q=(_|0)==(i+-1|0);S=ma+(_<<1)|0;C=b[S>>1]<<x;p=k|0?k+(C<<2)|0:0;X=_;_=_+1|0;Y=(b[ma+(_<<1)>>1]<<x)-C|0;V=wa(w)|0;T=v-((X|0)==(h|0)?0:V)|0;c[pa+208+32>>2]=u-V+-1;if((X|0)<(y|0)?(oa=(c[o+(X<<2)>>2]|0)+((T|0)/(((y-X|0)<3?y-X|0:3)|0)|0)|0,oa=(u-V|0)<(oa|0)?u-V|0:oa,(oa|0)>=0):0)U=(oa|0)<16383?oa:16383;else U=0;if(la|(e|0)!=0^1)B=((b[S>>1]<<x)-Y|0)<(b[ma+(h<<1)>>1]<<x|0)?B:(A|0)!=0|(B|0)==0?X:B;L=c[t+(X<<2)>>2]|0;c[pa+208+24>>2]=L;I=(X|0)<(c[f+12>>2]|0);R=I?p:$;P=I?j+(C<<2)|0:ja;D=(la|Q^1)&I?D:0;if((B|0)!=0&((q|0)!=3|(ha|0)>1|(L|0)<0)){v=(b[ma+(B<<1)>>1]<<x)-ia-Y|0;v=(v|0)>0?v:0;A=B;do A=A+-1|0;while((b[ma+(A<<1)>>1]<<x|0)>(v+ia|0));E=B+-1|0;while(1){p=E+1|0;if((b[ma+(p<<1)>>1]<<x|0)<(v+ia+Y|0))E=p;else{p=0;C=0;break}}while(1){L=N(A,na)|0;p=d[m+L>>0]|p;C=d[m+(na+-1+L)>>0]|C;if((A|0)<(E|0))A=A+1|0;else{H=p;I=C;break}}}else{v=-1;H=(1<<ha)+-1|0;I=(1<<ha)+-1|0}A=(r|0)==0;if((e|0)!=0^la|((X|0)!=(s|0)|A))if(A|(X|0)!=(s|0)^1)ka=26;else{E=(U|0)/2|0;p=(v|0)!=-1;A=p?ja+(v<<2)|0:0;if(Q){A=qb(pa+208|0,P,Y,E,ha,A,x,0,1.0,D,H)|0;v=p?ga+(v<<2)|0:0;p=0}else{A=qb(pa+208|0,P,Y,E,ha,A,x,ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0,1.0,D,H)|0;v=p?ga+(v<<2)|0:0;p=ga+(b[S>>1]<<x<<2)+(0-ia<<2)|0}C=A;A=qb(pa+208|0,R,Y,E,ha,v,x,p,1.0,D,I)|0}else{p=b[S>>1]<<x;if((p|0)>(ia|0)){A=0;do{ka=ja+(A<<2)|0;g[ka>>2]=(+g[ka>>2]+ +g[ga+(A<<2)>>2])*.5;A=A+1|0}while((A|0)<(p-ia|0));ka=26}else ka=26}do if((ka|0)==26){ka=0;if(!R){if(Q)A=0;else A=ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0;A=qb(pa+208|0,P,Y,U,ha,(v|0)==-1?0:ja+(v<<2)|0,x,A,1.0,D,I|H)|0;r=0;C=A;break}if(!(la&(X|0)<(s|0))){c[pa+208+48>>2]=0;if(Q)A=0;else A=ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0;A=rb(pa+208|0,P,R,Y,U,ha,(v|0)==-1?0:ja+(v<<2)|0,x,A,D,I|H)|0;r=0;C=A;break}K=+g[n+(X<<2)>>2];M=+g[n+((c[f+8>>2]|0)+X<<2)>>2];O=(K<M?K:M)/3.0;E=I|H;H=c[w>>2]|0;I=c[w+4>>2]|0;c[pa+24>>2]=c[w+8>>2];c[pa+24+4>>2]=c[w+8+4>>2];c[pa+24+8>>2]=c[w+8+8>>2];c[pa+24+12>>2]=c[w+8+12>>2];L=c[w+24>>2]|0;c[pa>>2]=c[w+28>>2];c[pa+4>>2]=c[w+28+4>>2];c[pa+8>>2]=c[w+28+8>>2];c[pa+12>>2]=c[w+28+12>>2];c[pa+16>>2]=c[w+28+16>>2];p=pa+100|0;C=pa+208|0;r=p+60|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));zc(da|0,P|0,Y<<2|0)|0;zc(ea|0,R|0,Y<<2|0)|0;c[pa+208+48>>2]=-1;v=(v|0)!=-1?ja+(v<<2)|0:0;if(Q)A=0;else A=ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0;A=rb(pa+208|0,P,R,Y,U,ha,v,x,A,D,E)|0;if((Y|0)>0){p=0;F=0.0;do{F=F+ +g[da+(p<<2)>>2]*+g[P+(p<<2)>>2];p=p+1|0}while((p|0)!=(Y|0));G=(K+O)*F;p=0;F=0.0;do{F=F+ +g[ea+(p<<2)>>2]*+g[R+(p<<2)>>2];p=p+1|0}while((p|0)!=(Y|0))}else{G=(K+O)*0.0;F=0.0}J=G+(M+O)*F;p=pa+160|0;C=w;r=p+48|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));p=pa+40|0;C=pa+208|0;r=p+60|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));zc(aa|0,P|0,Y<<2|0)|0;zc(ba|0,R|0,Y<<2|0)|0;if(!Q)zc(ca|0,ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0,Y<<2|0)|0;zc(pa+268|0,H+L|0,I-L|0)|0;c[w>>2]=H;c[w+4>>2]=I;c[w+8>>2]=c[pa+24>>2];c[w+8+4>>2]=c[pa+24+4>>2];c[w+8+8>>2]=c[pa+24+8>>2];c[w+8+12>>2]=c[pa+24+12>>2];c[w+24>>2]=L;c[w+28>>2]=c[pa>>2];c[w+28+4>>2]=c[pa+4>>2];c[w+28+8>>2]=c[pa+8>>2];c[w+28+12>>2]=c[pa+12>>2];c[w+28+16>>2]=c[pa+16>>2];p=pa+208|0;C=pa+100|0;r=p+60|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));zc(P|0,da|0,Y<<2|0)|0;zc(R|0,ea|0,Y<<2|0)|0;if((X|0)==(h+1|0)){p=c[f+32>>2]|0;C=b[p+(h+1<<1)>>1]|0;r=C-(b[p+(h<<1)>>1]|0)<<x;C=(b[p+(h+2<<1)>>1]|0)-C<<x;zc(ja+(r<<2)|0,ja+((r<<1)-C<<2)|0,C-r<<2|0)|0}c[pa+208+48>>2]=1;if(Q)p=0;else p=ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0;C=rb(pa+208|0,P,R,Y,U,ha,v,x,p,D,E)|0;if((Y|0)>0){p=0;F=0.0;do{F=F+ +g[da+(p<<2)>>2]*+g[P+(p<<2)>>2];p=p+1|0}while((p|0)!=(Y|0));G=(K+O)*F;p=0;F=0.0;do{F=F+ +g[ea+(p<<2)>>2]*+g[R+(p<<2)>>2];p=p+1|0}while((p|0)!=(Y|0))}else{G=(K+O)*0.0;F=0.0}if(!(J>=G+(M+O)*F))A=C;else{p=w;C=pa+160|0;r=p+48|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));p=pa+208|0;C=pa+40|0;r=p+60|0;do{c[p>>2]=c[C>>2];p=p+4|0;C=C+4|0}while((p|0)<(r|0));zc(P|0,aa|0,Y<<2|0)|0;zc(R|0,ba|0,Y<<2|0)|0;if(!Q)zc(ja+(b[S>>1]<<x<<2)+(0-ia<<2)|0,ca|0,Y<<2|0)|0;zc(H+L|0,pa+268|0,I-L|0)|0}r=0;C=A}while(0);v=N(X,na)|0;a[m+v>>0]=C;a[m+(na+-1+v)>>0]=A;v=T+V+(c[o+(X<<2)>>2]|0)|0;c[pa+208+56>>2]=0;if((_|0)==(i|0))break;else A=(U|0)>(Y<<3|0)&1}u=c[pa+208+40>>2]|0;c[z>>2]=u;W(fa|0);l=pa;return}

// EMSCRIPTEN_END_FUNCS
return{setThrew:da,_bitshift64Lshr:xc,_decode_frame:ga,_bitshift64Ashr:sc,_memset:wc,_sbrk:yc,_memcpy:zc,___errno_location:oc,___muldi3:uc,stackAlloc:$,getTempRet0:fa,setTempRet0:ea,_i64Add:vc,_emscripten_get_global_libc:nc,_create_decoder:ha,stackSave:aa,___muldsi3:tc,_destroy_decoder:ia,_free:mc,runPostSets:rc,establishStackSpace:ca,_memmove:Ac,stackRestore:ba,_malloc:lc,stackAlloc:$,stackSave:aa,stackRestore:ba,establishStackSpace:ca,setThrew:da,setTempRet0:ea,getTempRet0:fa}})


// EMSCRIPTEN_END_ASM
(Module.asmGlobalArg,Module.asmLibraryArg,buffer);var setThrew=Module["setThrew"]=asm["setThrew"];var _bitshift64Lshr=Module["_bitshift64Lshr"]=asm["_bitshift64Lshr"];var _decode_frame=Module["_decode_frame"]=asm["_decode_frame"];var _bitshift64Ashr=Module["_bitshift64Ashr"]=asm["_bitshift64Ashr"];var _memset=Module["_memset"]=asm["_memset"];var _sbrk=Module["_sbrk"]=asm["_sbrk"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var ___errno_location=Module["___errno_location"]=asm["___errno_location"];var ___muldi3=Module["___muldi3"]=asm["___muldi3"];var stackAlloc=Module["stackAlloc"]=asm["stackAlloc"];var getTempRet0=Module["getTempRet0"]=asm["getTempRet0"];var setTempRet0=Module["setTempRet0"]=asm["setTempRet0"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var _emscripten_get_global_libc=Module["_emscripten_get_global_libc"]=asm["_emscripten_get_global_libc"];var _create_decoder=Module["_create_decoder"]=asm["_create_decoder"];var stackSave=Module["stackSave"]=asm["stackSave"];var ___muldsi3=Module["___muldsi3"]=asm["___muldsi3"];var _destroy_decoder=Module["_destroy_decoder"]=asm["_destroy_decoder"];var _free=Module["_free"]=asm["_free"];var runPostSets=Module["runPostSets"]=asm["runPostSets"];var establishStackSpace=Module["establishStackSpace"]=asm["establishStackSpace"];var _memmove=Module["_memmove"]=asm["_memmove"];var stackRestore=Module["stackRestore"]=asm["stackRestore"];var _malloc=Module["_malloc"]=asm["_malloc"];Runtime.stackAlloc=Module["stackAlloc"];Runtime.stackSave=Module["stackSave"];Runtime.stackRestore=Module["stackRestore"];Runtime.establishStackSpace=Module["establishStackSpace"];Runtime.setTempRet0=Module["setTempRet0"];Runtime.getTempRet0=Module["getTempRet0"];Module["asm"]=asm;if(memoryInitializer){if(typeof Module["locateFile"]==="function"){memoryInitializer=Module["locateFile"](memoryInitializer)}else if(Module["memoryInitializerPrefixURL"]){memoryInitializer=Module["memoryInitializerPrefixURL"]+memoryInitializer}if(ENVIRONMENT_IS_NODE||ENVIRONMENT_IS_SHELL){var data=Module["readBinary"](memoryInitializer);HEAPU8.set(data,Runtime.GLOBAL_BASE)}else{addRunDependency("memory initializer");var applyMemoryInitializer=(function(data){if(data.byteLength)data=new Uint8Array(data);HEAPU8.set(data,Runtime.GLOBAL_BASE);if(Module["memoryInitializerRequest"])delete Module["memoryInitializerRequest"].response;removeRunDependency("memory initializer")});function doBrowserLoad(){Module["readAsync"](memoryInitializer,applyMemoryInitializer,(function(){throw"could not load memory initializer "+memoryInitializer}))}if(Module["memoryInitializerRequest"]){function useRequest(){var request=Module["memoryInitializerRequest"];if(request.status!==200&&request.status!==0){console.warn("a problem seems to have happened with Module.memoryInitializerRequest, status: "+request.status+", retrying "+memoryInitializer);doBrowserLoad();return}applyMemoryInitializer(request.response)}if(Module["memoryInitializerRequest"].response){setTimeout(useRequest,0)}else{Module["memoryInitializerRequest"].addEventListener("load",useRequest)}}else{doBrowserLoad()}}}function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"])run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);try{var ret=Module["_main"](argc,argv,0);exit(ret,true)}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{var toLog=e;if(e&&typeof e==="object"&&e.stack){toLog=[e,e.stack]}Module.printErr("exception thrown: "+toLog);Module["quit"](1,e)}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;if(ABORT)return;ensureInitRuntime();preMain();if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(Module["_main"]&&shouldRunNow)Module["callMain"](args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status,implicit){if(implicit&&Module["noExitRuntime"]){return}if(Module["noExitRuntime"]){}else{ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();if(Module["onExit"])Module["onExit"](status)}if(ENVIRONMENT_IS_NODE){process["exit"](status)}Module["quit"](status,new ExitStatus(status))}Module["exit"]=Module.exit=exit;var abortDecorators=[];function abort(what){if(Module["onAbort"]){Module["onAbort"](what)}if(what!==undefined){Module.print(what);Module.printErr(what);what=JSON.stringify(what)}else{what=""}ABORT=true;EXITSTATUS=1;var extra="\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";var output="abort("+what+") at "+stackTrace()+extra;if(abortDecorators){abortDecorators.forEach((function(decorator){output=decorator(output,what)}))}throw output}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}Module["noExitRuntime"]=true;run()




