/**
 * This is a demo for MapChart.
 *
 * Refer to the following link(s) for reference:
 * @see {@link https://www.amcharts.com/docs/v4/chart-types/map/}
 */

// Themes begin
am4core.useTheme(am4themes_animated);
// Themes end

var chart = am4core.create("chartdiv", am4maps.MapChart);

// Set map definition
chart.geodata = am4geodata_worldUltra;
chart.language.locale = am4lang_el_GR;


// Set projection
chart.projection = new am4maps.projections.Orthographic();
chart.panBehavior = "rotateLongLat";
chart.deltaLatitude = -20;
chart.padding(20,20,20,20);

// Add zoom control
chart.zoomControl = new am4maps.ZoomControl();
chart.seriesContainer.cursorOverStyle = am4core.MouseCursorStyle.grab;
chart.seriesContainer.cursorDownStyle = am4core.MouseCursorStyle.grabbing;

var homeButton = new am4core.Button();
homeButton.events.on("hit", function(){
  chart.goHome();
});
homeButton.icon = new am4core.Sprite();
homeButton.padding(7, 5, 7, 5);
homeButton.width = 30;
homeButton.icon.path = "M16,8 L14,8 L14,16 L10,16 L10,10 L6,10 L6,16 L2,16 L2,8 L0,8 L8,0 L16,8 Z M16,8";
homeButton.marginBottom = 10;
homeButton.parent = chart.zoomControl;
homeButton.insertBefore(chart.zoomControl.plusButton);

chart.backgroundSeries.mapPolygons.template.polygon.fill = am4core.color("#aadaff");
chart.backgroundSeries.mapPolygons.template.polygon.fillOpacity = 0;
// Create map polygon series
var polygonSeries = chart.series.push(new am4maps.MapPolygonSeries());

// Make map load polygon (like country names) data from GeoJSON
polygonSeries.useGeodata = true;

// Add some data
polygonSeries.data = 
[{
	"name":"Τουβαλού",
	"id":"TV",
}, {
	"name": "Νήσος Μπουβέ",
	"id": "BV",
	}, {
	"name":"Γιβραλτάρ",
	"id":"GI",
}, {
	"name": "Νησιά Γκλοριόσο",
	"id": "GO",
}, {
	"name": "Νήσος Χουάν ντε Νόβα",
	"id": "JU",
}, {
	"name": "Νήσος Τζάρβις",
	"id": "UM-DQ",
}, {
	"name":"Νήσος Μπέικερ",
	"id":"UM-FQ",
}, {
	"name":"Νήσος Χόουλαντ",
	"id":"UM-HQ",
}, {
	"name":"Ατόλη Τζόνστον",
	"id":"UM-JQ",	
}, {
	"name":"Νήσοι Μιντγουέι",
	"id":"UM-MQ",	
}, {
	"name":"Νήσος Γουέικ",
	"id":"UM-WQ",	
}, {
	"name":"Νήσοι Μποναίρ, Άγιος Ευστάθιος και Σάμπα",
	"id":"BQ",	
}, {
	"name":"Ολλανδία",
	"id":"NL",	
}, {
	"name":"Ζιμπάμπουε",
	"id":"ZW",	
}, {
	"name":"Ζάμπια",
	"id":"ZM",		
}, {
	"name":"Νότια Αφρική",
	"id":"ZA",		
}, {
	"name":"Υεμένη",
	"id":"YE",		
}, {
	"name":"Σαμόα",
	"id":"WS",		
}, {
	"name":"Ουώλλις και Φουτούνα",
	"id":"WF",		
}, {
	"name":"Παλαιστινιακά Εδάφη",
	"id":"PS",		
}, {
	"name":"Βανουάτου",
	"id":"VU",		
}, {
	"name":"Βιετνάμ",
	"id":"VN",		
}, {
	"name":"Αμερικανικές Παρθένοι Νήσοι",
	"id":"VI",		
}, {
	"name":"Βρετανικές Παρθένοι Νήσοι",
	"id":"VG",		
}, {
	"name":"Βενεζουέλα",
	"id":"VE",	
}, {
	"name":"Άγιος Βικέντιος και Γρεναδίνες",
	"id":"VC",	
}, {
	"name":"Βατικανό",
	"id":"VA",	
}, {
	"name":"Ουζμπεκιστάν",
	"id":"UZ",	
}, {
	"name": "Η.Π.Α",
	"id": "US",	
}, {
	"name":"Ουρουγουάη",
	"id":"UY",		
}, {
	"name":"Ουκρανία",
	"id":"UA",		
}, {
	"name":"Ουγκάντα",
	"id":"UG",	
}, {
	"name":"Τανζανία",
	"id":"TZ",		
}, {
	"name":"Ταϊβάν",
	"id":"TW",		
}, {
	"name":"Τουρκία",
	"id":"TR",		
}, {
	"name":"Τυνησία",
	"id":"TN",	
}, {
	"name":"Τρίνινταντ και Τομπάκο",
	"id":"TT",	
}, {
	"name":"Τόγκα",
	"id":"TO",	
}, {
	"name":"Τίμορ-Λέστε",
	"id":"TL",	
}, {
	"name":"Τουρκμενιστάν",
	"id":"TM",	
}, {
	"name":"Τοκελάου",
	"id":"TK",	
}, {
	"name":"Τατζικιστάν",
	"id":"TJ",	
}, {
	"name":"Ταϋλάνδη",
	"id":"TH",	
}, {
	"name":"Τόγκο",
	"id":"TG",	
}, {
	"name":"Τσάντ",
	"id":"TD",	
}, {
	"name":"Νήσοι Τουρκ και Κάικος",
	"id":"TC",
}, {
	"name":"Συρία",
	"id":"SY",
}, {
	"name":"Σεϋχέλλες",
	"id":"SC",
}, {
	"name":"Άγιος Μαρτίνος",
	"id":"SX",
}, {
	"name":"Σουαζιλάνδη",
	"id":"SZ",
}, {
	"name":"Σουηδία",
	"id":"SE",
}, {
	"name":"Σλοβενία",
	"id":"SI",
}, {
	"name":"Σλοβακία",
	"id":"SK",
}, {
	"name":"Σουρινάμ",
	"id":"SR",
}, {
	"name":"Σάο Τόμε και Πρίνσιπε",
	"id":"ST",
}, {
	"name":"Σερβία",
	"id":"RS",
}, {
	"name":"Σεντ Πιέρ και Μικελόν",
	"id":"PM",
}, {
	"name":"Σομαλία",
	"id":"SO",
}, {
	"name":"Άγιος Μαρίνος",
	"id":"SM",
}, {
	"name":"Ελ Σαλβαδόρ",
	"id":"SV",
}, {
	"name":"Σιέρα Λεόνε",
	"id":"SL",
}, {
	"name":"Νήσοι Σολομώντα",
	"id":"SB",
}, {
	"name":"Αγία Ελένη",
	"id":"SH",
}, {
	"name":"Νότιος Γεωργία και Νότιοι Νήσοι Σάντουιτς",
	"id":"GS",
}, {
	"name":"Σενεγάλη",
	"id":"SN",
}, {
	"name":"Νότιο Σουδάν",
	"id":"SS",
}, {
	"name":"Σουδάν",
	"id":"SD",
}, {
	"name":"Σαουδική Αραβία",
	"id":"SA",	
}, {
	"name":"Δυτική Σαχάρα",
	"id":"EH",
}, {
	"name":"Ρουάντα",
	"id":"RW",
}, {
	"name":"Ρωσία",
	"id":"RU",
}, {
	"name":"Ρουμανία",
	"id":"RO",
}, {
	"name":"Ρεϋνιόν",
	"id":"RE",
}, {
	"name":"Κατάρ",
	"id":"QA",
}, {
	"name":"Γαλλική Πολυνησία",
	"id":"PF",
}, {
	"name":"Παραγουάη",
	"id":"PY",
}, {
	"name":"Πορτογαλία",
	"id":"PT",
}, {
	"name":"Βόρεια Κορέα",
	"id":"KP",
}, {
	"name":"Πουέρτο Ρίκο",
	"id":"PR",
}, {
	"name":"Πολωνία",
	"id":"PL",
}, {
	"name":"Παπούα Νέα Γουινέα",
	"id":"PG",
}, {
	"name":"Παλάου",
	"id":"PW",
}, {
	"name":"Φιλιππίνες",
	"id":"PH",
}, {
	"name":"Περού",
	"id":"PE",
}, {
	"name":"Νήσοι Πίτκερν",
	"id":"PN",
}, {
	"name":"Παναμάς",
	"id":"PA",
}, {
	"name":"Πακιστάν",
	"id":"PK",
}, {
	"name":"Ομάν",
	"id":"OM",
}, {
	"name":"Νέα Ζηλανδία",
	"id":"NZ",
}, {
	"name":"Σβάλμπαρντ και Γιαν Μάγεν",
	"id":"SJ",
}, {
	"name":"Ναουρού",
	"id":"NR",
}, {
	"name":"Νεπάλ",
	"id":"NP",
}, {
	"name":"Νορβηγία",
	"id":"NO",
}, {
	"name":"Νίουε",
	"id":"NU",
}, {
	"name":"Νικαράγουα",
	"id":"NI",
}, {
	"name":"Νιγηρία",
	"id":"NG",
}, {
	"name":"Νήσος Νόρφολκ",
	"id":"NF",
}, {
	"name":"Νίγηρας",
	"id":"NE",
}, {
	"name":"Νέα Καληδονία",
	"id":"NC",
}, {
	"name":"Ναμίμπια",
	"id":"NA",
}, {
	"name":"Μαγιότ",
	"id":"YT",
}, {
	"name":"Μαλαισία",
	"id":"MY",
}, {
	"name":"Μαλάουι",
	"id":"MW",
}, {
	"name":"Μαυρίκιος",
	"id":"MU",
}, {
	"name":"Μαρτινίκα",
	"id":"MQ",
}, {
	"name":"Μονσεράτ",
	"id":"MS",
}, {
	"name":"Μαυριτανία",
	"id":"MR",
}, {
	"name":"Μοζαμβίκη",
	"id":"MZ",
}, {
	"name":"Νήσοι Βόρειες Μαριάνες",
	"id":"MP",
}, {
	"name":"Μογγολία",
	"id":"MN",
}, {
	"name":"Μαυροβούνιο",
	"id":"ME",
}, {
	"name":"Μιανμάρ",
	"id":"MM",
}, {
	"name":"Μάλτα",
	"id":"MT",
}, {
	"name":"Μάλι",
	"id":"ML",
}, {
	"name":"Βόρεια Μακεδονία",
	"id":"MK",	
}, {
	"name":"Νήσοι Μάρσαλ",
	"id":"MH",
}, {
	"name":"Μεξικό",
	"id":"MX",
}, {
	"name":"Μαλδίβες",
	"id":"MV",
}, {
	"name":"Μαδαγασκάρη",
	"id":"MG",
}, {
	"name":"Μολδαβία",
	"id":"MD",
}, {
	"name":"Μονακό",
	"id":"MC",
}, {
	"name":"Μαρόκο",
	"id":"MA",
}, {
	"name":"Άγιος Μαρτίνος",
	"id":"MF",
}, {
	"name":"Μακάο",
	"id":"MO",
}, {
	"name":"Λετονία",
	"id":"LV",
}, {
	"name":"Λουξεμβούργο",
	"id":"LU",
}, {
	"name":"Λιθουανία",
	"id":"LT",
}, {
	"name":"Λεσότο",
	"id":"LS",
}, {
	"name":"Σρι Λάνκα",
	"id":"LK",
}, {
	"name":"Λιχτενστάιν",
	"id":"LI",
}, {
	"name":"Αγία Λουκία",
	"id":"LC",
}, {
	"name":"Λιβύη",
	"id":"LY",
}, {
	"name":"Λιβερία",
	"id":"LR",
}, {
	"name":"Λίβανος",
	"id":"LB",
}, {
	"name":"Λάος",
	"id":"LA",
}, {
	"name":"Κουβέιτ",
	"id":"KW",
}, {
	"name":"Κόσοβο",
	"id":"XK",
}, {
	"name":"Νότια Κορέα",
	"id":"KR",
}, {
	"name":"Σέντ Κιτς και Νέβις",
	"id":"KN",
}, {
	"name":"Κιριμπάτι",
	"id":"KI",
}, {
	"name":"Καμπότζη",
	"id":"KH",
}, {
	"name":"Κιργιστάν",
	"id":"KG",
}, {
	"name":"Κένυα",
	"id":"KE",
}, {
	"name":"Καζακστάν",
	"id":"KZ",
}, {
	"name":"Ιαπωνία",
	"id":"JP",
}, {
	"name":"Ιορδανία",
	"id":"JO",
}, {
	"name":"Τζέρσεϊ",
	"id":"JE",
}, {
	"name":"Τζαμάικα",
	"id":"JM",
}, {
	"name":"Ιταλία",
	"id":"IT",
}, {
	"name":"Ισραήλ",
	"id":"IL",
}, {
	"name":"Ισλανδία",
	"id":"IS",
}, {
	"name":"Ιράκ",
	"id":"IQ",
}, {
	"name":"Ιράν",
	"id":"IR",
}, {
	"name":"Ιρλανδία",
	"id":"IE",
}, {
	"name":"Βρετανικά Εδάφη Ινδικού Ωκεανού",
	"id":"IO",
}, {
	"name":"Ινδία",
	"id":"IN",
}, {
	"name":"Νήσος Μαν",
	"id":"IM",
}, {
	"name":"Ινδονησία",
	"id":"ID",
}, {
	"name":"Ουγγαρία",
	"id":"HU",
}, {
	"name":"Αϊτή",
	"id":"HT",	
}, {
	"name":"Κροατία",
	"id":"HR",
}, {
	"name":"Ονδούρα",
	"id":"HN",
}, {
	"name":"Νήσοι Χερντ και Μακ Ντόναλντ",
	"id":"HM",
}, {
	"name":"Χόνγκ Κόνγκ",
	"id":"HK",
}, {
	"name":"Γουιάνα",
	"id":"GY",
}, {
	"name":"Γκουάμ",
	"id":"GU",
}, {
	"name":"Γαλλική Γουιάνα",
	"id":"GF",
}, {
	"name":"Γουατεμάλα",
	"id":"GT",
}, {
	"name":"Γροιλανδία",
	"id":"GL",
}, {
	"name":"Γρενάδα",
	"id":"GD",
}, {
	"name":"Ελλάδα",
	"id":"GR",
}, {
	"name":"Ισημερινή Γουινέα",
	"id":"GQ",
}, {
	"name":"Γουινέα-Μπισάου",
	"id":"GW",
}, {
	"name":"Γκάμπια",
	"id":"GM",
}, {
	"name":"Γουαδελούπη",
	"id":"GP",
}, {
	"name":"Γουινέα",
	"id":"GN",
}, {
	"name":"Γκάνα",
	"id":"GH",
}, {
	"name":"Γκέρνσεϊ",
	"id":"GG",
}, {
	"name":"Γεωργία",
	"id":"GE",
}, {
	"name":"Γκαμπόν",
	"id":"GA",	
}, {
	"name":"Ομόσπονδες Πολιτείες της Μικρονησίας",
	"id":"FM",
}, {
	"name":"Νήσοι Φερόες",
	"id":"FO",
}, {
	"name":"Νήσοι Φώκλαντ",
	"id":"FK",
}, {
	"name": "Φίτζι",
	"id": "FJ",
}, {
	"name": "Φινλανδία",
	"id": "FI",
}, {
	"name": "Αιθιοπία",
	"id": "ET",
}, {
	"name": "Εσθονία",
	"id": "EE",
}, {
	"name": "Ισπανία",
	"id": "ES",
}, {
	"name": "Ερυθραία",
	"id": "ER",
}, {
	"name": "Ηνωμένο Βασίλειο",
	"id": "GB",
}, {
	"name": "Αίγυπτος",
	"id": "EG",
}, {
	"name": "Ισημερινός",
	"id": "EC",
}, {
	"name": "Αλγερία",
	"id": "DZ",
}, {
	"name": "Δομινικανή Δημοκρατία",
	"id": "DO",
}, {
	"name": "Δανία",
	"id": "DK",
}, {
	"name": "Δομίνικα",
	"id": "DM",
}, {
	"name": "Τζιμπουτί",
	"id": "DJ",
}, {
	"name": "Γερμανία",
	"id": "DE",
}, {
	"name": "Τσεχία",
	"id": "CZ",
}, {
	"name": "Κύπρος",
	"id": "CY",
}, {
	"name": "Νήσοι Κάιμαν",
	"id": "KY",
}, {
	"name": "Νήσος Χριστουγέννων",
	"id": "CX",
}, {
	"name": "Κουρακάο",
	"id": "CW",
}, {
	"name": "Κούβα",
	"id": "CU",
}, {
	"name": "Κόστα Ρίκα",
	"id": "CR",
}, {
	"name": "Πράσινο Ακρωτήριο",
	"id": "CV",
}, {
	"name": "Κομόρος",
	"id": "KM",
}, {
	"name": "Κολομβία",
	"id": "CO",
}, {
	"name": "Νήσοι Κουκ",
	"id": "CK",
}, {
	"name": "Δημοκρατία του Κογκό",
	"id": "CG",
}, {
	"name": "Λαϊκή Δημοκρατία του Κογκό",
	"id": "CD",
}, {
	"name": "Καμερούν",
	"id": "CM",
}, {
	"name": "Ακτή Ελεφαντοστού",
	"id": "CI",
}, {
	"name": "Κίνα",
	"id": "CN",
}, {
	"name": "Χιλή",
	"id": "CL",
}, {
	"name": "Ελβετία",
	"id": "CH",
}, {
	"name": "Νησιά Κόκος",
	"id": "CC",
}, {
	"name": "Καναδάς",
	"id": "CA",
}, {
	"name": "Κεντροαφρικανική Δημοκρατία",
	"id": "CF",
}, {
	"name": "Βέλγιο",
	"id": "BE",
}, {
	"name": "Μποτσουάνα",
	"id": "BW",
}, {
	"name": "Μπουτάν",
	"id": "BT",
}, {
	"name": "Μπρουνέι",
	"id": "BN",
}, {
	"name": "Μπαρμπάντος",
	"id": "BB",
}, {
	"name": "Βραζιλία",
	"id": "BR",
}, {
	"name": "Βολιβία",
	"id": "BO",
}, {
	"name": "Βερμούδες",
	"id": "BM",
}, {
	"name": "Μπελίζ",
	"id": "BZ",
}, {
	"name": "Λευκορωσία",
	"id": "BY",
}, {
	"name": "Άγιος Βαρθολομαίος",
	"id": "BL",
}, {
	"name": "Μπαχάμες",
	"id": "BS",
}, {
	"name": "Μπαχρέιν",
	"id": "BH",
}, {
	"name": "Βοσνία και Ερζεγοβίνη",
	"id": "BA",
}, {
	"name": "Βουλγαρία",
	"id": "BG",
}, {
	"name": "Μπαγκλαντές",
	"id": "BD",
}, {
	"name": "Μπουργκίνα Φάσο",
	"id": "BF",
}, {
	"name": "Μπενίν",
	"id": "BJ",
}, {
	"name": "Μπουρούντι",
	"id": "BI",
}, {
	"name": "Αζερμπαϊτζάν",
	"id": "AZ",
}, {
	"name": "Αυστρία",
	"id": "AT",
}, {
	"name": "Αυστραλία",
	"id": "AU",
}, {
	"name": "Γαλλικά νότια και ανταρκτικά νησιά",
	"id": "TF",
}, {
	"name": "Ανταρκτική",
	"id": "AQ",
}, {
	"name": "Αμερικανική Σαμόα",
	"id": "AS",
}, {
	"name": "Αρμενία",
	"id": "AM",
}, {
	"name": "Αργεντινή",
	"id": "AR",
}, {
	"name": "Ηνωμένα Αραβικά Εμιράτα",
	"id": "AE",
}, {
	"name": "Ανδόρα",
	"id": "AD",
}, {
	"name": "Νήσοι Άλαντ",
	"id": "AX",
}, {
	"name": "Αλβανία",
	"id": "AL",
}, {
	"name": "Ανγκουίλα",
	"id": "AI",
}, {
	"name": "Αγκόλα",
	"id": "AO",
}, {
	"name": "Αφγανιστάν",
	"id": "AF",
}, {
	"name": "Αντίγκουα και Μπαρμπούντα",
	"id": "AG",
}, {
	"name": "Γαλλία",
	"id": "FR",
}];
var lineSeries = chart.series.push(new am4maps.MapLineSeries());
lineSeries.mapLines.template.strokeWidth = 1;
lineSeries.mapLines.template.stroke = am4core.color("#e03e96");
lineSeries.mapLines.template.line.strokeOpacity = 0.8;
lineSeries.data = [{
  "multiGeoLine": [
    [
      { "latitude": 0, "longitude": 0 },
	  { "latitude": 0, "longitude": 60 },
	  { "latitude": 0, "longitude": 120 },
	  { "latitude": 0, "longitude": 180 },
	  { "latitude": 0, "longitude": 240 },
	  { "latitude": 0, "longitude": 300 },
      { "latitude": 0, "longitude": 360 },

	  { "latitude": 60, "longitude": 0 },
	  { "latitude": 120, "longitude": 0 },
	  { "latitude": 180, "longitude": 0 },
	  { "latitude": 240, "longitude": 0 },
	  { "latitude": 300, "longitude": 0 },
      { "latitude": 360, "longitude": 0 },
	  
	  { "latitude": 66.5605, "longitude": 0 },
	  { "latitude": 66.5605, "longitude": 10 },
	  { "latitude": 66.5605, "longitude": 20 },
	  { "latitude": 66.5605, "longitude": 30 },
	  { "latitude": 66.5605, "longitude": 40 },
      { "latitude": 66.5605, "longitude": 50 },
	  { "latitude": 66.5605, "longitude": 60 },
	  { "latitude": 66.5605, "longitude": 70 },
	  { "latitude": 66.5605, "longitude": 80 },
	  { "latitude": 66.5605, "longitude": 90 },
	  { "latitude": 66.5605, "longitude": 100 },
	  { "latitude": 66.5605, "longitude": 110 },
	  { "latitude": 66.5605, "longitude": 120 },
	  { "latitude": 66.5605, "longitude": 130 },
	  { "latitude": 66.5605, "longitude": 140 },
      { "latitude": 66.5605, "longitude": 150 },
	  { "latitude": 66.5605, "longitude": 160 },
	  { "latitude": 66.5605, "longitude": 170 },
	  { "latitude": 66.5605, "longitude": 180 },
	  { "latitude": 66.5605, "longitude": 190 },
	  { "latitude": 66.5605, "longitude": 200 },
      { "latitude": 66.5605, "longitude": 210 },
	  { "latitude": 66.5605, "longitude": 220 },
	  { "latitude": 66.5605, "longitude": 230 },
	  { "latitude": 66.5605, "longitude": 240 },
      { "latitude": 66.5605, "longitude": 250 },
	  { "latitude": 66.5605, "longitude": 260 },
	  { "latitude": 66.5605, "longitude": 270 },
	  { "latitude": 66.5605, "longitude": 280 },
	  { "latitude": 66.5605, "longitude": 290 },
	  { "latitude": 66.5605, "longitude": 300 },
      { "latitude": 66.5605, "longitude": 310 },
	  { "latitude": 66.5605, "longitude": 320 },
	  { "latitude": 66.5605, "longitude": 330 },
	  { "latitude": 66.5605, "longitude": 340 },
      { "latitude": 66.5605, "longitude": 350 },
	  { "latitude": 66.5605, "longitude": 360 },
	  
	  { "latitude": -66.5605, "longitude": 0 },
	  { "latitude": -66.5605, "longitude": 10 },
	  { "latitude": -66.5605, "longitude": 20 },
	  { "latitude": -66.5605, "longitude": 30 },
	  { "latitude": -66.5605, "longitude": 40 },
      { "latitude": -66.5605, "longitude": 50 },
	  { "latitude": -66.5605, "longitude": 60 },
	  { "latitude": -66.5605, "longitude": 70 },
	  { "latitude": -66.5605, "longitude": 80 },
	  { "latitude": -66.5605, "longitude": 90 },
	  { "latitude": -66.5605, "longitude": 100 },
	  { "latitude": -66.5605, "longitude": 110 },
	  { "latitude": -66.5605, "longitude": 120 },
	  { "latitude": -66.5605, "longitude": 130 },
	  { "latitude": -66.5605, "longitude": 140 },
      { "latitude": -66.5605, "longitude": 150 },
	  { "latitude": -66.5605, "longitude": 160 },
	  { "latitude": -66.5605, "longitude": 170 },
	  { "latitude": -66.5605, "longitude": 180 },
	  { "latitude": -66.5605, "longitude": 190 },
	  { "latitude": -66.5605, "longitude": 200 },
      { "latitude": -66.5605, "longitude": 210 },
	  { "latitude": -66.5605, "longitude": 220 },
	  { "latitude": -66.5605, "longitude": 230 },
	  { "latitude": -66.5605, "longitude": 240 },
      { "latitude": -66.5605, "longitude": 250 },
	  { "latitude": -66.5605, "longitude": 260 },
	  { "latitude": -66.5605, "longitude": 270 },
	  { "latitude": -66.5605, "longitude": 280 },
	  { "latitude": -66.5605, "longitude": 290 },
	  { "latitude": -66.5605, "longitude": 300 },
      { "latitude": -66.5605, "longitude": 310 },
	  { "latitude": -66.5605, "longitude": 320 },
	  { "latitude": -66.5605, "longitude": 330 },
	  { "latitude": -66.5605, "longitude": 340 },
      { "latitude": -66.5605, "longitude": 350 },
	  { "latitude": -66.5605, "longitude": 360 },
	  
	  { "latitude": 23.4394, "longitude": 0 },
	  { "latitude": 23.4394, "longitude": 10 },
	  { "latitude": 23.4394, "longitude": 20 },
	  { "latitude": 23.4394, "longitude": 30 },
	  { "latitude": 23.4394, "longitude": 40 },
      { "latitude": 23.4394, "longitude": 50 },
	  { "latitude": 23.4394, "longitude": 60 },
	  { "latitude": 23.4394, "longitude": 70 },
	  { "latitude": 23.4394, "longitude": 80 },
	  { "latitude": 23.4394, "longitude": 90 },
	  { "latitude": 23.4394, "longitude": 100 },
	  { "latitude": 23.4394, "longitude": 110 },
	  { "latitude": 23.4394, "longitude": 120 },
	  { "latitude": 23.4394, "longitude": 130 },
	  { "latitude": 23.4394, "longitude": 140 },
      { "latitude": 23.4394, "longitude": 150 },
	  { "latitude": 23.4394, "longitude": 160 },
	  { "latitude": 23.4394, "longitude": 170 },
	  { "latitude": 23.4394, "longitude": 180 },
	  { "latitude": 23.4394, "longitude": 190 },
	  { "latitude": 23.4394, "longitude": 200 },
      { "latitude": 23.4394, "longitude": 210 },
	  { "latitude": 23.4394, "longitude": 220 },
	  { "latitude": 23.4394, "longitude": 230 },
	  { "latitude": 23.4394, "longitude": 240 },
      { "latitude": 23.4394, "longitude": 250 },
	  { "latitude": 23.4394, "longitude": 260 },
	  { "latitude": 23.4394, "longitude": 270 },
	  { "latitude": 23.4394, "longitude": 280 },
	  { "latitude": 23.4394, "longitude": 290 },
	  { "latitude": 23.4394, "longitude": 300 },
      { "latitude": 23.4394, "longitude": 310 },
	  { "latitude": 23.4394, "longitude": 320 },
	  { "latitude": 23.4394, "longitude": 330 },
	  { "latitude": 23.4394, "longitude": 340 },
      { "latitude": 23.4394, "longitude": 350 },
	  { "latitude": 23.4394, "longitude": 360 },
	  
	  { "latitude": -23.4394, "longitude": 0 },
	  { "latitude": -23.4394, "longitude": 10 },
	  { "latitude": -23.4394, "longitude": 20 },
	  { "latitude": -23.4394, "longitude": 30 },
	  { "latitude": -23.4394, "longitude": 40 },
      { "latitude": -23.4394, "longitude": 50 },
	  { "latitude": -23.4394, "longitude": 60 },
	  { "latitude": -23.4394, "longitude": 70 },
	  { "latitude": -23.4394, "longitude": 80 },
	  { "latitude": -23.4394, "longitude": 90 },
	  { "latitude": -23.4394, "longitude": 100 },
	  { "latitude": -23.4394, "longitude": 110 },
	  { "latitude": -23.4394, "longitude": 120 },
	  { "latitude": -23.4394, "longitude": 130 },
	  { "latitude": -23.4394, "longitude": 140 },
      { "latitude": -23.4394, "longitude": 150 },
	  { "latitude": -23.4394, "longitude": 160 },
	  { "latitude": -23.4394, "longitude": 170 },
	  { "latitude": -23.4394, "longitude": 180 },
	  { "latitude": -23.4394, "longitude": 190 },
	  { "latitude": -23.4394, "longitude": 200 },
      { "latitude": -23.4394, "longitude": 210 },
	  { "latitude": -23.4394, "longitude": 220 },
	  { "latitude": -23.4394, "longitude": 230 },
	  { "latitude": -23.4394, "longitude": 240 },
      { "latitude": -23.4394, "longitude": 250 },
	  { "latitude": -23.4394, "longitude": 260 },
	  { "latitude": -23.4394, "longitude": 270 },
	  { "latitude": -23.4394, "longitude": 280 },
	  { "latitude": -23.4394, "longitude": 290 },
	  { "latitude": -23.4394, "longitude": 300 },
      { "latitude": -23.4394, "longitude": 310 },
	  { "latitude": -23.4394, "longitude": 320 },
	  { "latitude": -23.4394, "longitude": 330 },
	  { "latitude": -23.4394, "longitude": 340 },
      { "latitude": -23.4394, "longitude": 350 },
	  { "latitude": -23.4394, "longitude": 360 }
		  
    ]
  ]
}];


// Configure series
var polygonTemplate = polygonSeries.mapPolygons.template;
polygonTemplate.tooltipText = "{name}";
polygonTemplate.fill = am4core.color("#47c78a");
polygonTemplate.stroke = am4core.color("#454a58");
polygonTemplate.strokeWidth = 0.5;

var graticuleSeries = chart.series.push(new am4maps.GraticuleSeries());
graticuleSeries.mapLines.template.line.stroke = am4core.color("#ffffff");
graticuleSeries.mapLines.template.line.strokeOpacity = 0.3;
graticuleSeries.fitExtent = false;

chart.backgroundSeries.mapPolygons.template.polygon.fillOpacity = 0.8;
chart.backgroundSeries.mapPolygons.template.polygon.fill = am4core.color("#aadaff");

// Create image series
var imageSeries = chart.series.push(new am4maps.MapImageSeries());

// Create image
var imageSeriesTemplate = imageSeries.mapImages.template;
var marker = imageSeriesTemplate.createChild(am4core.Image);
marker.width = 76;
marker.height = 18;
marker.nonScaling = true;
marker.tooltipText = "{title}";
marker.horizontalCenter = "middle";
marker.verticalCenter = "middle";
marker.propertyFields.href = "flag";

// Set property fields
imageSeriesTemplate.propertyFields.latitude = "latitude";
imageSeriesTemplate.propertyFields.longitude = "longitude";

// Add data for the three cities
imageSeries.data = [{
  "latitude": 0,
  "longitude": -5,
  "title": "Ισημερινός",
  "flag": "equator.png"

}];



// Create hover state and set alternative fill color
var hs = polygonTemplate.states.create("hover");
hs.properties.fill = chart.colors.getIndex(0).brighten(-0.5);

let animation;
setTimeout(function(){
  animation = chart.animate({property:"deltaLongitude", to:100000}, 20000000);
}, 3000)

chart.seriesContainer.events.on("down", function(){
if(animation){
  animation.stop();
}
})
