
/*
    This file is part of "ChoiCo" a web application for designing digital games, written by Marianthi Grizioti for the National and Kapodistrian University of Athens (Educational Technology Lab).
    Copyright (C) 2017-2018.
    ChoiCo is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ChoiCo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*/
$("#language").on({
	'click' : function () {
		if ($("#language").attr('src') == "media/imgs/english.png"){
			changeLanguage ("Eng");

		}
		else {

			changeLanguage ("Gr");
		}
	}

});

changeLanguage = function (lang){
	 if (lang === "Eng"){
		  $("#language").attr("src", "media/imgs/greek.png")
		 introText = english.introText
		 introSubText = english.introSubText

		 $("#designMode").attr("src", english.designButtonSrc)
		 $("#playMode").attr("src", english.playButtonSrc)
		 $("#openYourFile").html(english.openYourFile)
		 $("#onlineExamples").html(english.onlineExamples)
		 $("#tab1").html(english.tab1)
		 $("#tab2").html(english.tab2)
		 $("#tab3").html(english.tab3)
		 $("#tab4").html(english.tab4)
		 $("#uploadImg").attr("title", english.uploadImgDisc)
		 $("#addPoint").attr("title", english.addPointDisc)
		 $("#addInstructions").attr("title", english.addInstructionsDisc)
		 $("#deleteIco").attr("title", english.deleteIcoDisc)
		 $("#settingsIco").attr("title", english.settingsIcoDisc)
		 $("#addAttribute").attr("title", english.addAttributeDisc)
		 $("#home").attr("title", english.homeDisc)
		 $("#pointsLimit").html(english.pointsLimitTxt)
		 	$("#score").html(english.gameValues);
				$("#score").html(english.gameValues);
		 $("#manual").html(english.manualDisc)
		 $("#manual").attr("href", "http://etl.ppp.uoa.gr/choico/manuals/choico_user_manual_EN.pdf")
		 $("#contact").html(english.contactDisc)
		 $("#deletePoint").html(english.deletePointText)
		 $("#typeLabel").html(english.typeLabel)
		 $("#visibilityLabel").html(english.visibilityLabel)

		designModeText = english.designModeText;
		playModeText = english.playModeText;
		tab1Message = english.tab1Message;
		tab3Message = english.tab3Message;
		markersMessage = english.markersMessage;
		homeMessage = english.homeMessage;
		popUpMessage = english.popUpMessage;
		layersRemoveMessage = english.layersRemoveMessage;
		gameInstructionsDefault = english.gameInstructionsDefault;
		$("#pointInfo").html(english.pointInfoText)
		$("#select").html(english.selectButton)
		$("#gameStatus").html(english.gameStatusText)
		$("#foodText").html(english.perfectVilleText)
		$("#foodGame").attr("onclick","window.open(http://etl.ppp.uoa.gr/choico/?foodEng);");
		$("#envyText").html(english.envyText)
		$("#perfectVilleText").html(english.perfectVilleText)
		$("#perfectVilleGame").attr("onclick","window.open(http://etl.ppp.uoa.gr/choico/?perfectVilleEng);");
		$("#badiText").html(english.badiText)
		$("#mpText").html(english.mpText)
		$("#pcText").html(english.pcText)
		$("#composteText").html(english.composteText)
		$("#orientText").html(english.orientText)
		$("#electricianText").html(english.electricianText)
		$("#supermarketText").html(english.supermarketText)
		$("#ethicsText").html(english.ethicsText)

		//PLAYMODE
		pointsVisitedText = english.pointsVisited;
 	 var pVisit = $("#pointsVisited");
 	if (pVisit.length>0){
 		pVisit.html(pointsVisitedText)
 	}

		$('#selectBox option[value=text]').text('text');
		$('#selectBox option[value=number]').text('number');
		$('#selectBox option[value=url]').text('url');
		$('#selectBox option[value=date]').text('date');
		$('#selectBox option[value=file]').text('image');
		$('#visibilityBox option[value=visible]').text('Visible');
		$('#visibilityBox option[value=hidden]').text('Hidden');
				gameStartedText = english.gameStartedText;
		 if(myGame.mode === 1 ){
			 $("#introT").html(designModeText);
		 }
		 else if (myGame.mode === 2)
			 $("#introT").html(playModeText);
		else{
			 $("#introT").html(introText);
			 $("#introST").html(introSubText);
		}

	 }
	 else if (lang === "Gr"){
		 	  $("#language").attr("src", "media/imgs/english.png")
		 	 introText = greek.introText
		 introSubText = greek.introSubText
		designModeText = greek.designModeText;
		playModeText = greek.playModeText;
		pointsVisitedText = greek.pointsVisited;
		var pVisit = $("#pointsVisited");
		if (pVisit.length>0){
			pVisit.html(pointsVisitedText)
		}
		  $("#designMode").attr("src", greek.designButtonSrc)
		 $("#playMode").attr("src", greek.playButtonSrc)
		 $("#openYourFile").html(greek.openYourFile)
		 $("#onlineExamples").html(greek.onlineExamples)
		 $("#tab1").html(greek.tab1)
		 $("#tab2").html(greek.tab2)
		 $("#tab3").html(greek.tab3)
		 $("#tab4").html(greek.tab4)
		  $("#uploadImg").attr("title", greek.uploadImgDisc)
		  $("#addPoint").attr("title", greek.addPointDisc)
		  $("#addInstructions").attr("title", greek.addInstructionsDisc)
		  $("#deleteIco").attr("title", greek.deleteIcoDisc)
		  $("#settingsIco").attr("title", greek.settingsIcoDisc)
		  $("#addAttribute").attr("title", greek.addAttributeDisc)
		 $("#pointsLimit").html(greek.pointsLimitTxt)
		 $("#manual").html(greek.manualDisc)
		 $("#manual").attr("href", "http://etl.ppp.uoa.gr/choico/manuals/choico_user_manual_GR.pdf")
		 $("#contact").html(greek.contactDisc)
		  $("#home").attr("title", greek.homeDisc)
		 markersMessage = greek.markersMessage;
		tab1Message = greek.tab1Message;
		tab3Message = greek.tab3Message;
		homeMessage = greek.homeMessage;
		popUpMessage = greek.popUpMessage;
		layersRemoveMessage = greek.layersRemoveMessage;
		gameInstructionsDefault = greek.gameInstructionsDefault;
		$("#score").html(greek.gameValues);
		$("#deletePoint").html(greek.deletePointText)
	 $("#typeLabel").html(greek.typeLabel)
	 $("#visibilityLabel").html(greek.visibilityLabel)

		$('#selectBox option[value=text]').text('Κείμενο');
		$('#selectBox option[value=number]').text('Αριθμός');
		$('#selectBox option[value=url]').text('σύνδεσμος');
		$('#selectBox option[value=date]').text('ημ/νία');
		$('#selectBox option[value=file]').text('εικόνα');
		$('#visibilityBox option[value=visible]').text('Εμφάνιση');
		$('#visibilityBox option[value=hidden]').text('Απόκρυψη');
		$("#pointInfo").html(greek.pointInfoText)
		$("#select").html(greek.selectButton)
		$("#gameStatus").html(greek.gameStatusText)
		$("#foodGame").attr("onclick","window.open('http://etl.ppp.uoa.gr/choico/?foodGr')");
		$("#foodText").html(greek.foodText)
		$("#envyText").html(greek.envyText)
		$("#perfectVilleText").html(greek.perfectVilleText)
		$("#perfectVilleGame").attr("onclick","window.open('http://etl.ppp.uoa.gr/choico/?perfectVilleGr')");
		$("#badiText").html(greek.badiText)
		$("#mpText").html(greek.mpText)
		$("#pcText").html(greek.pcText)
		$("#composteText").html(greek.composteText)
		$("#orientText").html(greek.orientText)
		$("#electricianText").html(greek.electricianText)
		$("#supermarketText").html(greek.supermarketText)
		$("#ethicsText").html(greek.ethicsText)
		//PLAYMODE
		gameStartedText = greek.gameStartedText;
		 $("#pointInfo").html(greek.pointInfoText)
		 $("#select").html(greek.selectButton)
		 $("#gameStatus").html(greek.gameStatusText)
		 if(myGame.mode === 1 ){
			 $("#introT").html(designModeText);
		 }
		 else if (myGame.mode === 2)
			 $("#introT").html(playModeText);
		else{
			 $("#introT").html(introText);
			 $("#introST").html(introSubText);
		}

	 }

 }
