//the water that the user selected using the slider
var currentWater;

//the maximum level of water
var max;

//all the objects in the current category in an array format
var cat;

//the multiplier that compensates for the height of the slider
var multiplier;

//the total score that user has accumulated in stars
var stars = 0;

//the target value that the user must guess...
var targetValue;

//the extra info that will be displayed when the user submit the guess...
var extraInfo;

var help_open = info_open = false;

var waterdata = (function() {
    var json = null;
    $.ajax({
        'async': false,
        'global': false,
        'url': "data/water-data.json",
        'dataType': "json",
        'success': function (data) {
            json = data;

            var sel = getUrlParameter('category');
            cat = json[sel];
            max = cat.max;

            $('.current .number').text((0.5*max).toFixed(0));
            currentWater = 0.5*max;
            fixHeights();
            setWaterLevel();

            $(".slider").draggable({
              axis: "y",
              containment: "parent",
              drag: function() {

                var sliderTopPosition = $('.slider').position().top;

                $('.tracker').css('top', (sliderTopPosition + 25) + 'px');

                var trackerHeight = $('.tracker-wrapper').height();

                var score = (trackerHeight - sliderTopPosition + 25) / trackerHeight * max;

                currentWater = score;

                // Update water consumption score in trackers.
                $('.current .number').text(score.toFixed(0));

                $('.tracker .steps').css('top', 11-sliderTopPosition);

              }
            });

            $('.slider.ui-draggable.ui-draggable-handle').css('top', $('.tracker-wrapper').height()*(1-currentWater/max) + 25);

            showItem();

        }
    });
    return json;
})();

$(document).ready(function(){
  fixHeights();
  $('#submit-answer').click(function(){
    evaluate();
  });


    $('#help').on('click', function(){
       var help = '<div class="iframe-container help-iframe">\n' +
         '        <div class="close-iframe"><img src="images/close.svg" class="close-button-x"></div>\n' +
         '        <iframe src="help.html" class="help-iframe"></iframe>\n' +
         '    </div>';

       if(!help_open && !info_open){
         $('body').append(help);
         $('.wrapper').addClass('blur');
         help_open = true;
         $('.close-iframe').click(function(){
           help_open = false;
           info_open = false;
           $('.iframe-container').remove();
           $('.wrapper').removeClass('blur');
         });
       }
    });

    $('#info').on('click', function(){
       var info = '<div class="iframe-container info-frame">\n' +
         '        <div class="close-iframe"><img src="images/close.svg" class="close-button-x"></div>\n' +
         '        <iframe src="info.html" class="info-iframe"></iframe>\n' +
         '    </div>';

       if(!info_open && !help_open){
         $('body').append(info);
         $('.wrapper').addClass('blur');
         info_open = true;
         $('.close-iframe').click(function(){
           info_open = false;
           help_open = false;
           $('.iframe-container').remove();
           $('.wrapper').removeClass('blur');
         });
       }
    });

    $('.close-iframe').click(function(){
      help_open = false;
      info_open = false;
      $('.iframe-container').remove();
      $('.wrapper').removeClass('blur');
    });
});

$(window).resize(function() {
    clearTimeout(window.resizedFinished);
    window.resizedFinished = setTimeout(function(){
      fixHeights();
      setWaterLevel();
    }, 250);
});

function evaluate() {
    var stars3 = max*0.10;
    var stars2 = max*0.15;
    var stars1 = max*0.20;
    var star = '<img class="swal-star" src="images/star.svg" alt="star">';
    var title;
    var newstars;

    if ((targetValue < currentWater + stars3) && (targetValue > currentWater - stars3)) {
        title = 'Τέλεια! Τα κατάφερες εξαιρετικά! Μάντεψες με μεγάλη ακρίβεια τον όγκο του νερού!';
        star += star + star;
        newstars = 3;
    } else if ((targetValue < currentWater + stars2) && (targetValue > currentWater - stars2)) {
        title = 'Μπράβο! Κατάφερες να εκτιμήσεις αρκετά καλά πόσο περίπου νερό απαιτείται.';
        star += star;
        newstars = 2;
    } else if ((targetValue < currentWater + stars1) && (targetValue > currentWater - stars1)) {
        title = 'Αρκετά καλή προσπάθεια. Η εκτίμηση σου δεν απέχει πολύ από τον πραγματικό όγκο.';
        newstars = 1;
    } else {
        title = 'Τα λίτρα που εκτίμησες απέχουν πολύ από τον πραγματικό όγκο. Σκέψου λίγο πιο προσεκτικά σε επόμενα προϊόντα.';
        star = '<img class="swal-star" src="images/star-gray.svg" alt="star-gray">';
        newstars = 0;
    }

    var html = star +
    '<div class="swal-title">' + title + '</div>' +
    '<div class="amount-text">Ο ΑΚΡΙΒΗΣ ΟΓΚΟΣ ΤΟΥ ΝΕΡΟΥ ΠΟΥ ΑΠΑΙΤΕΙΤΑΙ ΕΙΝΑΙ:</div><div class="target-value"><span>' + targetValue + '</span><div class="liters">ΛΙΤΡΑ<br/>ΝΕΡΟΥ</div></div>';

    if (extraInfo) {
        html += '<div class="extra-info">' + extraInfo + '</div>';
    }

    Swal.fire({
        html: html
    }).then(function(result){
        updateScore(newstars);
        showItem();
    });
}

function updateScore(val) {
    stars += val;
    $('.star-count').text(stars);
}

function showItem() {
    var item = cat.items.pop();
    if (item) {
        $('.item-image').attr('src', 'images/items/' + item.id + '.png');
        targetValue = item.water;
        extraInfo = item.extra;
    } else {
        // no more items left... go back to choose category
        var html = '<div class="swal-title">Ολοκλήρωσες αυτή την κατηγορία προϊόντων...</div>' +
        '<div class="target-value">Συγκέντρωσες συνολικά ' + stars + ' αστέρια! Προσπάθησε και με κάποια άλλη κατηγορία!</div>';
        Swal.fire({
            html: html
        }).then(function(result){
            window.location.href = 'choose-category.html';
        });
    }

}

function setWaterLevel() {
  var h = $('.tracker-wrapper').height();
  var top = h*(1-currentWater/max);
  $('.tracker').css('top', top + 50);
  $('.slider.ui-draggable.ui-draggable-handle').css('top', top + 25);
  $('.tracker .steps').css('top', -top - 14);
}

function fixHeights() {

  var imageheight = $('.image-back').height();
  $('.right-col, .left-col').height(imageheight);

  $('.tracker-wrapper').css('height', 0.37*imageheight);

  $('.step').css('padding-bottom', $('.tracker-wrapper').height()/6 - 27);
}

function getUrlParameter(sParam) {
    var sPageURL = window.location.search.substring(1),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;
    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
};
