/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 1.0
Last Update: 2019-06-20
-------------------------------------------------- */


// Update stage will render next frame
createjs.Ticker.framerate = 30;
createjs.Ticker.addEventListener("tick", tickHandler);

function tickHandler(e) {
	stage.update();
}


function round(value, precision = 0) {
	var a;
	
	if (precision == 0) {
		a = Math.round(value);
	} else {
		a = Math.round(value * Math.pow(10, precision)) / Math.pow(10, precision);
	}
	return a;
}


function update_circuit() {

	var IStart, TStart, OnStateDuration, status_timer;

	var CStart = parseInt( $("#num_cstart").val() );
	var UserTemperature = parseFloat( $("#num_temperature").val() );

	var FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );
	FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal


	// Update Thermical Switch
	if (FridgeTemperature >= UserTemperature + 0.9) {
		switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, 0, 30, 3).drawRect(13, -23, 3, 25);	// On
	} else {
		switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, -10, 30, 3).drawRect(13, -23, 3, 15);	// Off
	}
	stage.update();

	// Update I Start and T Start
	IStart = 0.239 * CStart - 8.25;
	TStart = 0.01667 * CStart - 0.2667;
	istart_text.text = IStart.toFixed(2) + " Α";
	tstart_text.text = TStart.toFixed(2) + " N*m";

	stage.update();

	// Check if main switch is closed
	if ( $("#circuit_switch").prop("checked") ) {
		
		if (CStart < config.cstart_threshold ) {

			// Update Amper Meter
			if (FridgeTemperature >= UserTemperature + 0.9) {
				IAmp = IStart;
				ammeter_text.text = IAmp.toFixed(2) + "A";
			} else {
				IAmp = 0;
				ammeter_text.text = IAmp.toFixed(2) + "A";
			}
			stage.update();

			update_status('error');
			
		} else {
			// CStart >= 88μF

			if (generator_status=='off' && FridgeTemperature >= UserTemperature + 0.9) {

				IAmp = 0;
			
				// Set state to INIT
				update_status('init');

				var init_duration = 0;

				var init_timer = setInterval(function() {

					init_duration += 500;
					
					// Update Amper meter
					IAmp = 1/config.init_state_duration * (2.55 - IStart) * (init_duration / 1000) + IStart;
					if (IAmp < 2.55) {
						IAmp = 2.55;
					}
					ammeter_text.text = IAmp.toFixed(2) + "A";

					stage.update();

					if ($("#circuit_switch").prop("checked")==false) {
						// console.log('stop init');
						clearInterval(init_timer);
						init_duration = 0;
						IAmp = 0;
						ammeter_text.text = IAmp.toFixed(2) + "A";
						stage.update();
					}

					if (init_duration > config.init_state_duration * 1000) {
						// console.log('stop init2');						
						clearInterval(init_timer);
						init_duration = 0;
						stage.update();
					}

				}, 500); // 1 sec = 1000
				
				
				// Set state to ON
				status_timer = setTimeout(function(){
				
					if ( $("#circuit_switch").prop("checked") ) {
					
						update_status('on');

						IAmp = 2.55;
						ammeter_text.text = IAmp.toFixed(2) + "A";

						UserTemperature = parseFloat( $("#num_temperature").val() );
						FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );
						FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal

						OnStateDuration = (FridgeTemperature - UserTemperature + 1) * 5;
						// console.log ('Duration: ' + OnStateDuration);
						stage.update();

						clearInterval(on_timer);
						clearInterval(off_timer);

						var on_duration = 0;

						on_timer = setInterval(function() {

							IAmp = 2.55;
							ammeter_text.text = IAmp.toFixed(2) + "A";

							UserTemperature = parseFloat( $("#num_temperature").val() );
							FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );
							FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal

							if (FridgeTemperature > UserTemperature - 1) {
								// decrease temperature every 0.5 sec
								// if (on_duration % 500 == 0) {
									FridgeTemperature -= 0.1;
									$("#num_fridge_temperature").val( FridgeTemperature )
									temperature_text.text = FridgeTemperature.toFixed(1);
									switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, 0, 30, 3).drawRect(13, -23, 3, 25);	// On
								// }

								// update I/O pressures and temperatures
								for (var pt=37; pt>=0; pt--) {
									if (in_pressure > in_pressure_array[pt]) {
										in_pressure = in_pressure_array[pt];			// from 4.7 to 1
										in_temperature = in_temperature_array[pt];		// from 20 to -10
										out_pressure = out_pressure_array[pt];			// from 4.7 to 12.2
										out_temperature = out_temperature_array[pt];	// from 20 to 50
										break;
									}
								}

								
								// update labels
								in_anar_text.text = in_pressure.toFixed(1) + " bar";
								in_temperature_text.text = in_temperature.toFixed(1) + "°C";
								out_katath_text.text = out_pressure.toFixed(1) + " bar";
								out_temperature_text.text = out_temperature.toFixed(1) + "°C";

								stage.update();
								on_duration += 500;

							} else {
								
								clearInterval(on_timer);
								switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, -10, 30, 3).drawRect(13, -23, 3, 15);	// Off
								
								stage.update();
								update_status('off');
							}

						}, 500);	// 1 sec = 1000
					
					}	// if $("#circuit_switch").prop("checked") 

				}, config.init_state_duration * 1000); // 1 sec = 1000
			}
		}

	} else {
		IAmp = 0;
		IStart = 0;
		TStart = 0;
		generator_status = 'off';
		update_status('off');
	}

}

function update_status(status) {

	var off_duration = 0;
	var error_duration = 0;
	var UserTemperature = parseFloat( $("#num_temperature").val() );
	var FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );

	FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal

	switch(status) {

		case "off":
			console.log('status: off');
			status_box.graphics.clear().beginFill("#f22222").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 380, 42); // red: #f22222, green: #4e700c, orange: #f0af00
			status_box_txt.text = config.status_off_text;
			createjs.Tween.get(status_box_txt, {loop:false, override:true}).to({alpha:1, visible:true}, 500);
			ammeter_text.text = "0.00A";
			switchR.y = config.center_y - 105;

			stage.update();

			clearInterval(on_timer);
			clearInterval(off_timer);
			clearInterval(error_timer);

			off_duration = 0;
			off_timer = setInterval(function() {

				UserTemperature = parseFloat( $("#num_temperature").val() );
				FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );
				FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal
				
				// Set Generator to ON again
				if ($("#circuit_switch").prop("checked") && FridgeTemperature >= UserTemperature + 0.9) {
					clearInterval(off_timer);
					clearInterval(error_timer);
					generator_status = 'off';
					update_circuit();
				}

				//  Increase temperature
				if (FridgeTemperature < config.environment_temperature || in_pressure < 4 || in_temperature > 20 || out_pressure > 4 || out_temperature < 20) {

					if (FridgeTemperature < config.environment_temperature) {
						
						FridgeTemperature += 0.1;
						$("#num_fridge_temperature").val( FridgeTemperature )
						temperature_text.text = FridgeTemperature.toFixed(1);

						// Update Thermical Switch
						if (FridgeTemperature >= UserTemperature + 1) {
							switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, 0, 30, 3).drawRect(13, -23, 3, 25);	// On
						} else {
							switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, -10, 30, 3).drawRect(13, -23, 3, 15);	// Off
						}
					}

					if (in_pressure != config.in_pressure_off) {

						// update I/O pressures and temperatures
						for (var pt=0; pt<38; pt++) {
							// every 3 sec
							if (off_duration % 3000 == 0 && in_pressure < in_pressure_array[pt]) {
								in_pressure =  in_pressure_array[pt];		 // from 1 to 4.7
								in_temperature = in_temperature_array[pt];	 // from -10 to 20
								out_pressure = out_pressure_array[pt];		 // from 12.2 to 4.7
								out_temperature = out_temperature_array[pt]; // from 50 to 20
								break;
							}
						}

						// update labels
						in_anar_text.text = in_pressure.toFixed(1) + " bar";
						in_temperature_text.text = in_temperature.toFixed(1) + "°C";
						out_katath_text.text = out_pressure.toFixed(1) + " bar";
						out_temperature_text.text = out_temperature.toFixed(1) + "°C";
					}

					off_duration += 1500;
					stage.update();

				} else {
					off_duration = 0;
					clearInterval(off_timer);
					error_duration = 0;
					clearInterval(error_timer);
					stage.update();
				}

			}, 1500); // 1 sec = 1000

			stop_compressor_animation();
			stop_io_animation();

			generator_status = 'off';
			break;

		case "error":
			console.log('status: error');
			status_box.graphics.clear().beginFill("#f22222").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 380, 42); // red: #f22222, green: #4e700c, orange: #f0af00
			status_box_txt.text = config.status_error_text;
			createjs.Tween.get(status_box_txt, {loop:false, override:true}).to({alpha:1, visible:true}, 500);
			switchR.y = config.center_y - 105;

			stage.update();

			clearInterval(on_timer);
			clearInterval(off_timer);
			clearInterval(error_timer);

			error_duration = 0;
			error_timer = setInterval(function() {

				UserTemperature = parseFloat( $("#num_temperature").val() );
				FridgeTemperature = parseFloat( $("#num_fridge_temperature").val() );
				FridgeTemperature = round(FridgeTemperature, 1);	// round to 1 decimal

				// Increase temperature
				if (FridgeTemperature < config.environment_temperature || in_pressure < 4 || in_temperature > 20 || out_pressure > 4 || out_temperature < 20) {

					if (FridgeTemperature < config.environment_temperature) {
							
						FridgeTemperature += 0.1;
						$("#num_fridge_temperature").val( FridgeTemperature )
						temperature_text.text = FridgeTemperature.toFixed(1);

						// Update Thermical Switch
						if (FridgeTemperature >= UserTemperature + 1) {
							switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, 0, 30, 3).drawRect(13, -23, 3, 25);	// On
						} else {
							switchT.graphics.clear().beginFill("#ff9c00").drawRect(0, -10, 30, 3).drawRect(13, -23, 3, 15);	// Off
						}
					}

					if (in_pressure != config.in_pressure_off) {

						// update I/O pressures and temperatures
						for (var pt=0; pt<38; pt++) {
							if (in_pressure < in_pressure_array[pt]) {
								in_pressure =  in_pressure_array[pt];		 // from 1 to 4.7
								in_temperature = in_temperature_array[pt];	 // from -10 to 20
								out_pressure = out_pressure_array[pt];		 // from 12.2 to 4.7
								out_temperature = out_temperature_array[pt]; // from 50 to 20
								break;
							}
						}


						// update labels
						in_anar_text.text = in_pressure.toFixed(1) + " bar";
						in_temperature_text.text = in_temperature.toFixed(1) + "°C";
						out_katath_text.text = out_pressure.toFixed(1) + " bar";
						out_temperature_text.text = out_temperature.toFixed(1) + "°C";
					}

					error_duration += 1500;
					stage.update();
					

				} else {
					error_duration = 0;
					clearInterval(error_timer);
					off_duration = 0;
					clearInterval(off_timer);
					stage.update();
				}

			}, 1500); // 1 sec = 1000

			stop_compressor_animation();
			stop_io_animation();

			generator_status = 'error';
			break;

		case "init":
			console.log('status: init');
			status_box.graphics.clear().beginFill("#f0af00").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 380, 42); // red: #f22222, green: #4e700c, orange: #f0af00
			status_box_txt.text = config.status_init_text;
			createjs.Tween.get(status_box_txt, {loop:false, override:true}).to({alpha:1, visible:true}, 500);
			switchR.y = config.center_y - 120;

			show_compressor_animation();
			stop_io_animation();

			generator_status = 'init';
			break;

		case "on":
			console.log('status: on');
			status_box.graphics.clear().beginFill("#4e700c").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 380, 42); // red: #f22222, green: #4e700c, orange: #f0af00
			status_box_txt.text = config.status_on_text;
			createjs.Tween.get(status_box_txt, {loop:true}).to({alpha:0.2, visible:true}, 400).to({alpha:1, visible:true}, 400).wait(1500);
			IAmp = 2.55;
			ammeter_text.text = IAmp.toFixed(2) + "A";
			switchR.y = config.center_y - 105;
			stage.update();

			show_compressor_animation();
			show_io_animation();

			generator_status = 'on';
			break;
	}
	
	// Update stage
	stage.update();

	return true;

}


function show_compressor_animation() {

	// Move compressor
	createjs.Tween.get(compressor, {loop:true})
		.to({x:compressor.x - 2}, 50)
		.to({x:compressor.x + 2}, 100);


	// Update stage
	stage.update();

	return true;

}


function stop_compressor_animation() {

	createjs.Tween.removeTweens(compressor);

	compressor.x = config.center_x - 115;
	compressor.y = config.center_y + 204;
	
	// Update stage
	stage.update();

	return true;

}



function show_io_animation() {

	// Output arrows
	out_arrow.x = config.center_x + 50;
	out_arrow2.x = config.center_x + 85;
	out_arrow3.x = config.center_x + 120;
	//out_arrows.visible = true;

	// Move out arrows
	createjs.Tween.get(out_arrows, {loop:true})
		.to({alpha:1, visible:true}, 500)
		.to({x:out_arrows.x + 30}, 1500)
		.to({alpha:0, visible:false}, 500);

	// Input arrows
	in_arrow.x = config.center_x + 70;
	in_arrow2.x = config.center_x + 105;
	in_arrow3.x = config.center_x + 140;
	//in_arrows.visible = true;

	// Move in arrows
	createjs.Tween.get(in_arrows, {loop:true})
		.to({alpha:1, visible:true}, 500)
		.to({x:in_arrows.x - 30}, 1500)
		.to({alpha:0, visible:false}, 500);
	
	// Update stage
	stage.update();

	return true;

}



function stop_io_animation() {

	createjs.Tween.removeTweens(out_arrows);
	createjs.Tween.removeTweens(in_arrows);

	out_arrows.x = 0;
	in_arrows.x = 0;
	
	out_arrow.x = config.center_x + 70;
	out_arrow2.x = config.center_x + 105;
	out_arrow3.x = config.center_x + 140;

	in_arrow.x = config.center_x + 70;
	in_arrow2.x = config.center_x + 105;
	in_arrow3.x = config.center_x + 140;

	// Update stage
	stage.update();

	return true;

}
