/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 1.0
Last Update: 2018-12-20
-------------------------------------------------- */

// Initialize Canvas
var canvas = document.getElementById("canvas");
var context = canvas.getContext('2d');
var stage = new createjs.Stage("canvas");




// Main Switch open
var switch0_open = new createjs.Shape();
switch0_open.graphics.beginFill("#ff9c00").drawRect(0, 0, 34, 3);
switch0_open.x = config.center_x - 390;
switch0_open.y = config.center_y - 197;
switch0_open.rotation = -65;
stage.setChildIndex(switch0_open, 0);
stage.addChild(switch0_open);


// Main Switch closed
var switch0_closed = new createjs.Shape();
switch0_closed.graphics.beginFill("#ff9c00").drawRect(0, 0, 34, 3);
switch0_closed.x = config.center_x - 373;
switch0_closed.y = config.center_y - 192;
switch0_closed.rotation = -90;
stage.setChildIndex(switch0_closed, 1);
stage.addChild(switch0_closed);


// Switch D1 click area
var switch0_area = new createjs.Shape();
switch0_area.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 20, 45);
switch0_area.x = config.center_x - 390;
switch0_area.y = config.center_y - 230;
switch0_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(switch0_area);


// Thermical Switch
var switchT = new createjs.Shape();
switchT.graphics.beginFill("#ff9c00").drawRect(0, 0, 30, 3).drawRect(13, -23, 3, 25);		// On
// switchT.graphics.beginFill("#ff9c00").drawRect(0, -10, 30, 3).drawRect(13, -23, 3, 15);	// Off
switchT.x = config.center_x - 148;
switchT.y = config.center_y - 285;
stage.setChildIndex(switchT, 1);
stage.addChild(switchT);




// Rele Entasis Switch
var switchR_img = new Image();
switchR_img.src = 'images/rele-entasis-switch.png';

var switchR = new createjs.Bitmap(switchR_img);
switchR.scaleX = switchR.scaleY = 0.3;
switchR.x = config.center_x - 154;
switchR.y = config.center_y - 105;	// Open: 105 - Close: 120

switchR_img.onload = function () {
	stage.addChild(switchR);
	stage.setChildIndex(switchR, 2);
	stage.update();
}




// Circuit without labels
var circuit_img = new Image();
circuit_img.src = 'images/circuit-no-labels.png';

var circuit = new createjs.Bitmap(circuit_img);
circuit.scaleX = circuit.scaleY = 1;
circuit.x = config.center_x - 450;
circuit.y = config.center_y - 410;

circuit_img.onload = function () {
	stage.addChild(circuit);
	stage.setChildIndex(circuit, 3);
	stage.update();
}



// Circuit with labels
var circuit2_img = new Image();
circuit2_img.src = 'images/circuit-with-labels.png';

var circuit2 = new createjs.Bitmap(circuit2_img);
circuit2.scaleX = circuit2.scaleY = 1;
circuit2.x = config.center_x - 450;
circuit2.y = config.center_y - 410;

circuit2_img.onload = function () {
	stage.addChild(circuit2);
	stage.setChildIndex(circuit2, 4);
	stage.update();
}


// Compressor
var compressor_img = new Image();
compressor_img.src = 'images/compressor.png';

var compressor = new createjs.Bitmap(compressor_img);
compressor.scaleX = compressor.scaleY = 1;
compressor.x = config.center_x - 115;
compressor.y = config.center_y + 204;

compressor_img.onload = function () {
	stage.addChild(compressor);
	stage.setChildIndex(compressor, 5);
	stage.update();
}


// Output Arrow (red)
var out_arrow_img = new Image();
out_arrow_img.src = 'images/arrow-red.png';

var out_arrow = new createjs.Bitmap(out_arrow_img);
out_arrow.scaleX = out_arrow.scaleY = 0.5;
out_arrow.x = config.center_x + 70;
out_arrow.y = config.center_y +	282;

out_arrow2 = out_arrow.clone();
out_arrow2.x = config.center_x + 105;
out_arrow3 = out_arrow.clone();
out_arrow3.x = config.center_x + 140;

var out_arrows = new createjs.Container();
out_arrows.addChild(out_arrow);
out_arrows.addChild(out_arrow2);
out_arrows.addChild(out_arrow3);

out_arrow_img.onload = function () {
	stage.addChild(out_arrows);
	stage.setChildIndex(out_arrows, 6);
	stage.update();
}


// Input Arrow (blue)
var in_arrow_img = new Image();
in_arrow_img.src = 'images/arrow-blue.png';

var in_arrow = new createjs.Bitmap(in_arrow_img);
in_arrow.scaleX = in_arrow.scaleY = 0.5;
in_arrow.x = config.center_x + 70;
in_arrow.y = config.center_y + 309;

in_arrow2 = in_arrow.clone();
in_arrow2.x = config.center_x + 105;
in_arrow3 = in_arrow.clone();
in_arrow3.x = config.center_x + 140;


var in_arrows = new createjs.Container();
in_arrows.addChild(in_arrow);
in_arrows.addChild(in_arrow2);
in_arrows.addChild(in_arrow3);

in_arrow_img.onload = function () {
	stage.addChild(in_arrows);
	stage.setChildIndex(in_arrows, 7);
	stage.update();
}


// Status Box
var status_box = new createjs.Shape();
status_box.graphics.beginFill("#f22222").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 380, 42);	// red: #f22222, green: #4e700c, orange: #f0af00
status_box.x = config.center_x - 170;
status_box.y = config.center_y + 125;
stage.addChild(status_box);
stage.setChildIndex(status_box, 9);

// Status Text
var status_box_txt = new createjs.Text();
// status_box_txt.text = config.status_off_text;
status_box_txt.font = "17px Arial";
status_box_txt.color = "#ffffff";
status_box_txt.textAlign = "center";
status_box_txt.x = config.center_x + 20;
status_box_txt.y = config.center_y + 137;
stage.addChild(status_box_txt);
stage.setChildIndex(status_box_txt, 10);




// Amper Meter Text
var ammeter_text = new createjs.Text();
ammeter_text.font = "20px digital-7";
ammeter_text.textAlign = "right";
ammeter_text.text = "0.00A";
ammeter_text.x = config.center_x + 54;
ammeter_text.y = config.center_y - 392;
stage.addChild(ammeter_text);


// Thermometer Text
var temperature_text = new createjs.Text();
temperature_text.font = "20px Arial";
temperature_text.color = "#ffffff";
temperature_text.textAlign = "right";
temperature_text.text = "16.0";
temperature_text.x = config.center_x - 195;
temperature_text.y = config.center_y + 300;
stage.addChild(temperature_text);

// I Start
var istart_text = new createjs.Text();
istart_text.font = "17px Arial";
istart_text.color = "#ffffff";
istart_text.textAlign = "right";
istart_text.text = "-";
istart_text.x = config.center_x + 420;
istart_text.y = config.center_y - 367;
stage.addChild(istart_text);


// Ropi Start (T Start)
var tstart_text = new createjs.Text();
tstart_text.font = "17px Arial";
tstart_text.color = "#ffffff";
tstart_text.textAlign = "right";
tstart_text.text = "-";
tstart_text.x = config.center_x + 420;
tstart_text.y = config.center_y - 344;
stage.addChild(tstart_text);


// Out Katathlipsi
var out_katath_text = new createjs.Text();
out_katath_text.font = "20px Arial";
out_katath_text.color = "#d03b3b";
out_katath_text.textAlign = "center";
out_katath_text.text = config.out_pressure_off.toFixed(1) + " bar";
out_katath_text.x = config.center_x + 370;
out_katath_text.y = config.center_y + 235;
stage.addChild(out_katath_text);

// Out Temperature
var out_temperature_text = new createjs.Text();
out_temperature_text.font = "20px Arial";
out_temperature_text.color = "#d03b3b";
out_temperature_text.textAlign = "center";
out_temperature_text.text = config.out_temperature_off.toFixed(1) + "°C";
out_temperature_text.x = config.center_x + 370;
out_temperature_text.y = config.center_y + 255;
stage.addChild(out_temperature_text);


// In Anarofisi
var in_anar_text = new createjs.Text();
in_anar_text.font = "20px Arial";
in_anar_text.color = "#3c89b1";
in_anar_text.textAlign = "center";
in_anar_text.text = config.in_pressure_off.toFixed(1) + " bar";
in_anar_text.x = config.center_x + 270;
in_anar_text.y = config.center_y + 260;
stage.addChild(in_anar_text);

// In Temperature
var in_temperature_text = new createjs.Text();
in_temperature_text.font = "20px Arial";
in_temperature_text.color = "#3c89b1";
in_temperature_text.textAlign = "center";
in_temperature_text.text = config.in_temperature_off.toFixed(1) + "°C";
in_temperature_text.x = config.center_x + 270;
in_temperature_text.y = config.center_y + 280;
stage.addChild(in_temperature_text);


// Info points areas
var info_area = [], info_box = [], info_text = [], i;

for (i=0; i<=6; i++) {
	info_area[i] = new createjs.Shape();
	info_area[i].cursor = "pointer";

	info_box[i] = new createjs.Shape();
	
	info_text[i] = new createjs.Text();
	info_text[i].font = "14px Arial";
	info_text[i].color = "#1d3e56";
	info_text[i].textAlign = "left";
	info_text[i].lineWidth = 310;
	info_text[i].lineHeight = 18;
}


// Thermostatis
info_area[0].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 120, 30);
info_area[0].x = config.center_x - 195;
info_area[0].y = config.center_y - 274;

info_box[0].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 350, 220, 20);
info_box[0].x = config.center_x - 220;
info_box[0].y = config.center_y - 240;

info_text[0].text = config.info_thermostatis;
info_text[0].x = config.center_x - 200;
info_text[0].y = config.center_y - 220;

// Thermiko Sympiesti
info_area[1].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 110, 45);
info_area[1].x = config.center_x - 335;
info_area[1].y = config.center_y - 105;

info_box[1].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 385, 170, 20);
info_box[1].x = config.center_x - 380;
info_box[1].y = config.center_y - 50;

info_text[1].text = config.info_thermiko;
info_text[1].lineWidth = 350;
info_text[1].x = config.center_x - 360;
info_text[1].y = config.center_y - 30;

// Rele Entasis
info_area[2].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 130, 30);
info_area[2].x = config.center_x - 205;
info_area[2].y = config.center_y - 5;

info_box[2].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 350, 125, 20);
info_box[2].x = config.center_x - 70;
info_box[2].y = config.center_y - 20;

info_text[2].text = config.info_rele_entasis;
info_text[2].x = config.center_x - 50;
info_text[2].y = config.center_y - 0;

// Piknotis Ekkinisis
info_area[3].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 110, 45);
info_area[3].x = config.center_x - 70;
info_area[3].y = config.center_y - 95;

info_box[3].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 350, 145, 20);
info_box[3].x = config.center_x - 320;
info_box[3].y = config.center_y - 40;

info_text[3].text = config.info_cstart;
info_text[3].x = config.center_x - 300;
info_text[3].y = config.center_y - 20;

// Piknotis Leitourgias
info_area[4].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 120, 50);
info_area[4].x = config.center_x + 30;
info_area[4].y = config.center_y - 10;

info_box[4].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 400, 160, 20);
info_box[4].x = config.center_x - 380;
info_box[4].y = config.center_y - 40;

info_text[4].text = config.info_crun;
info_text[4].lineWidth = 360;
info_text[4].x = config.center_x - 360;
info_text[4].y = config.center_y - 20;

// Voithitiko Tyligma Start
info_area[5].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 160, 45);
info_area[5].x = config.center_x + 250;
info_area[5].y = config.center_y - 270;

info_box[5].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 350, 200, 20);
info_box[5].x = config.center_x - 100;
info_box[5].y = config.center_y - 300;

info_text[5].text = config.info_lstart;
info_text[5].x = config.center_x - 80;
info_text[5].y = config.center_y - 280;

// Kyrio Tyligma Run
info_area[6].graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 130, 45);
info_area[6].x = config.center_x + 280;
info_area[6].y = config.center_y + 35;

info_box[6].graphics.beginFill("#c6d9ee").beginStroke("#ffffff").setStrokeStyle(3).drawRoundRect(0, 0, 350, 105, 20);
info_box[6].x = config.center_x - 70;
info_box[6].y = config.center_y + 15;

info_text[6].text = config.info_lrun;
info_text[6].x = config.center_x - 50;
info_text[6].y = config.center_y + 30;


for (i=0; i<=6; i++) {
	stage.addChild(info_area[i]);
	stage.addChild(info_box[i]);
	stage.addChild(info_text[i]);
}



stage.update();