/**
 * 
 */
function initialise(){
    maxWidth=parseInt($(window).width()/5);
    maxHeight=parseInt($(window).height()*0.8);
    trimLibrary();
    showAppTitle();
    initialiseEvents();

    initialiseEvents();
    generateNewProblem();
}

function initialiseEvents(){
    // touch events
    $(".picToShow").on("click tap touchstart",function(evt){
        evt.stopImmediatePropagation();
        if($(this).hasClass("picToShowSelected")){
            $(this).removeClass("picToShowSelected");
        }
        else{
            $(this).addClass("picToShowSelected");
        }
    });
    
    $("#showCaptions").bind("change keyup touchend",function(event,ui){
    	if($("#showCaptions:checked").val()=="show"){
    		buttonCaptionsVisible=true;
    	}
    	else{
    		buttonCaptionsVisible=false;
    	}
    	showButtonCaptions();
    });

    $("#randomSelection").bind("change keyup touchend",function(event,ui){
    	if($("#randomSelection:checked").val()=="rndSelection"){
    		selectRandomly=true;
    	}
    	else{
    		selectRandomly=false;
    	}
    });

    $("#showInfo").on("touchend",function(evt){
        $("#showInfo").trigger("click");
    });

    $("#btnCheckAnswer").on("click tap touchstart",function(evt){
        evt.stopImmediatePropagation();
        checkAnswer();
    });
    
    $("#btnNewProblem").on("click tap touchstart",function(evt){
        evt.stopImmediatePropagation();
        generateNewProblem();
    });

    $("#btnShowSolution").on("click tap touchstart",function(evt){
        evt.stopImmediatePropagation();
        showSolution();
    });
}

function performRandomSelection(collection,noOfPicsToSelect,predefinedError){
    var errorSwitch="";
    var alreadySelected=[];
    for(var j=0;j<collection.length;j++){
        alreadySelected.push(false);
    }
    for(var j=0;j<noOfPicsToSelect;j++){
        var i=-1;
        do{
            i=parseInt(Math.random()*collection.length);
        }while(alreadySelected[i]);
        alreadySelected[i]=true;
        if(predefinedError){
            errorSwitch="E";
        }
        else{
            errorSwitch=$(collection[i]).attr("data-type");
        }
        selectedPicToShow.push([collection[i].id,errorSwitch]);
    }
}

function generateNewProblem(){
	if(minimumCorrect>0){
		repetitionsCounter++;
		if(repetitionsCounter==noOfProblems){
			minimumCorrect--;
		}
	}

	if(selectRandomly){
	    problemID=parseInt(Math.random()*noOfProblems);
	}
	else{
	    problemID++;
	    if(problemID==noOfProblems) problemID=0;
	}
    prepareSelection();
    
    for(var i=0;i<maxNoOfPicsToShow;i++){
    	$("#pic"+i).removeAttr("style");
    }
    $("#result").html("");

    //καθορισμός πλήθους "ορθών" εικόνων
    if(singleCategory){
        noOfMainPicsToShow=maxNoOfPicsToShow;
    }
    else{
        noOfMainPicsToShow=parseInt(maxNoOfPicsToShow*Math.random())+minimumCorrect;//μπορεί και καμία
    }
    //έλεγχος αν το διαθέσιμο πλήθος επαρκεί 
    noOfMainPicsToShow=Math.min(noOfMainPicsToShow,noOfAvailableMainPics);
    //υπολογισμός αναγκαίων πρόσθετων εικόνων
    if(singleCategory){
        noOfAdditionalPicsToShow=0;
    }
    else{
        noOfAdditionalPicsToShow=Math.max(0,maxNoOfPicsToShow-noOfMainPicsToShow);
    }
    noOfTotalPicsToShow=noOfMainPicsToShow+noOfAdditionalPicsToShow;
    //Επιλογή κύριων εικόνων
    selectedPicToShow=[];
    performRandomSelection(availableCorrect,noOfMainPicsToShow,!definiteError);
    //Επιλογή δευτερευουσών εικόνων
    if(noOfAdditionalPicsToShow>0)performRandomSelection(availableRest,noOfAdditionalPicsToShow,definiteError);
    scrambleSelected();
    showSelectedPics();
}


function prepareSelection(){
    singleCategory=false;
    switch(problemID){
    case problemSerial:
        availableCorrect=$(".series");
        availableRest=$(".loop, .conditional");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή ακολουθίας;";
        break;
    case problemSimpleConditional:
        availableCorrect=$(".simpleIF");
        availableRest=$(".conditional").not(".simpleIF");
        prompt="Επίλεξε τα διαγράμματα ροής που περιλαμβάνουν δομή απλής επιλογής;";
        break;
    case problemComplexConditional:
        availableCorrect=$(".complexIF");
        availableRest=$(".conditional").not(".complexIF");
        prompt="Επίλεξε τα διαγράμματα ροής που περιλαμβάνουν δομή σύνθετης επιλογής;";
        break;
    case problemMultiConditional:
        availableCorrect=$(".multiIF");
        availableRest=$(".conditional").not(".multiIF");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή πολλαπλής επιλογής;";
        break;
    case problemNestedConditional:
        availableCorrect=$(".nestedIF");
        availableRest=$(".conditional").not(".nestedIF");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν εμφωλευμένες δομές επιλογής;";
        break;
    case problemConditionalGeneral:
        availableCorrect=$(".conditionals");
        availableRest=$(".series, .loop");
        prompt="Επίλεξε τα διαγράμματα ροής που περιλαμβάνουν δομή επιλογής;";
        break;
    case problemWhileLoop:
        availableCorrect=$(".while, .for");
        availableRest=$(".loop").not(".while").not(".for");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επανάληψης ΟΣΟ;";
        break;
    case problemForLoop:
        availableCorrect=$(".while, .for");
        availableRest=$(".loop").not(".while").not(".for");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επανάληψης ΓΙΑ;";
        break;
    case problemRepeatLoop:
        availableCorrect=$("[id^=repeat]");
        availableRest=$(".loop").not(".repeat");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επανάληψης ΜΕΧΡΙΣ_ΟΤΟΥ;";
        break;
    case problemLoopGeneral:
        availableCorrect=$(".loop");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επανάληψης;";
        availableRest=$(".series, .conditional");
        break;
    case problemSerialCorrect:
        availableCorrect=$(".series");//MONO
        singleCategory=true;
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή ακολουθίας;";
        break;
    case problemConditionalCorrect:
        availableCorrect=$(".conditional");//MONO
        singleCategory=true;
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επιλογής;";
        break;
    case problemLoopCorrect:
        availableCorrect=$(".loop");//MONO
        singleCategory=true;
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επανάληψης;";
        break;
    case problemNestedLoops:
        availableCorrect=$(".nestedLoop");
        availableRest=$(".loop").not(".nestedLoop");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν εμφωλευμένες δομές επανάληψης;";
        break;
    case problemNestedLoopsCorrect:
        availableCorrect=$(".nestedLoop");//MONO
        singleCategory=true;
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν εμφωλευμένες δομές επανάληψης;";
        break;
    case problemLoopNestingIF:
        availableCorrect=$(".loopNestingIF");
        availableRest=$(".nestedLoop");
        prompt="Επίλεξε τα διαγράμματα ροής που απεικονίζουν δομή επιλογής εμφωλευμένη σε δομή επανάληψης;";
        break;
    }
    noOfAvailableMainPics=availableCorrect.length;
}

function showPrompt(){
    $("#prompt").html(prompt);
}

function scrambleSelected(){
    var scrambledIndex=0;
	selectedPosition=[-1,-1,-1,-1,-1];
	for(var i=0;i<noOfTotalPicsToShow;i++){
	    do{
	        scrambledIndex=parseInt(Math.random()*noOfTotalPicsToShow);
	    }while(selectedPosition[scrambledIndex]!=-1);
	    selectedPosition[scrambledIndex]=i;
	}
}

function showSelectedPics(){
	$(".picToShowSelected").removeClass("picToShowSelected");
	for(var i=0;i<maxNoOfPicsToShow;i++){
		$("#pic"+i+"OK").hide();
		$("#pic"+i+"Error").hide();
	}
    for(var i=0;i<maxNoOfPicsToShow;i++){
        if(selectedPosition[i]>=noOfTotalPicsToShow){
            $("#pic"+selectedPosition[i]).hide();
        }
        else{
        	$("#pic"+selectedPosition[i]).attr("src",$("#"+selectedPicToShow[i][0]).attr("src"));
            $("#pic"+selectedPosition[i]).show();
        	$("#pic"+selectedPosition[i]).attr("style",$("#"+selectedPicToShow[i][0]).attr("style"));
        }
    }
    showPrompt();
}

function checkAnswer(){
    var msg="";
    var target=0;
    for(var i=0;i<noOfTotalPicsToShow;i++){
        if(selectedPicToShow[i][1]=="C"){
            target++;            
        }
    }
    var counter=0;
    var indx=0;
    for(var i=0;i<noOfTotalPicsToShow;i++){
        indx=selectedPosition[i];
        if($("#pic"+indx).hasClass("picToShowSelected")){
        	if(selectedPicToShow[i][1]=="C"){
                counter++;
        	}
        }
    }
    if(counter==target){
    	if($(".picToShowSelected").length==target){
        	if(target==0){
        		msg="Πολύ σωστά! Αντιλήφθηκες ότι δεν απεικονίζεται κανένα ορθό διάγραμμα ροής.";
        	}
        	else{
        		msg="Πολύ σωστά! Εντόπισες όλα τα κατάλληλα διαγράμματα ροής.";
        	}
    	}
        else if($(".picToShowSelected").length>target){
            msg="Ρίξε μια προσεκτικότερη ματιά. Έχεις επιλέξει περισσότερα από όσα θα έπρεπε...";
        }
    }
    else if(counter<target){
    	var supplementaty="";
    	if(counter>0) supplementaty="και άλλα ";
        msg="Ξαναδές τις επιλογές σου. Υπάρχουν "+supplementaty+"διαγράμματα ροής που άνήκουν στην επιθυμητή κατηγορία.";
    }
    $("#result").html(msg);
}

function showSolution(){
	$("#result").html("");
    for(var i=0;i<noOfTotalPicsToShow;i++){
        indx=selectedPosition[i];
    	if(selectedPicToShow[i][1]=="C"){
            $("#pic"+indx+"OK").show();
            $("#pic"+indx+"Error").hide();
    	}
    	else{
            $("#pic"+indx+"OK").hide();
            $("#pic"+indx+"Error").show();
    	}
    }	
}

function trimLibrary(){
	$(".picLib").each(function(){
	    var originalW=$(this).width();
	    var originalH=$(this).height();
	    if(originalW>maxWidth){
	        $(this).css("width",maxWidth+"px");
	        $(this).css("height",parseInt(maxWidth*originalH/originalW)+"px");
	    }
	    originalW=$(this).width();
	    originalH=$(this).height();
	    if(originalH>maxHeight){
	        $(this).css("height",maxHeight+"px");
	        $(this).css("width",parseInt(maxHeight*originalW/originalH)+"px");
	    }
	});
}

function showButtonCaptions(){
	if(buttonCaptionsVisible){
        $("#btnNewProblem").html("Νέο πρόβλημα");
        $("#btnCheckAnswer").html("Υποβολή");
        $("#btnShowSolution").html("Λύση");
        $(".btnMenu").css({"width":"175px"});
        $(".buttonData").width(160);
 	}
	else{
        $("#btnNewProblem").html("");
        $("#btnCheckAnswer").html("");
        $("#btnShowSolution").html("");
        $(".btnMenu").css({"width":"30px"});
        $(".buttonData").width(40);
    }
}