/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 1.0
Last Update: 2018-12-20
-------------------------------------------------- */


// Update stage will render next frame
createjs.Ticker.framerate = 30;
createjs.Ticker.addEventListener("tick", tickHandler);

function tickHandler(e) {
	// Rotate Sun
	sun.rotation += 0.5;

	stage.update();
}

function update_status_box(level) {

	// red: #f22222, green: #4e700c, orange: #f0af00
	if (level == 'error') {
		status_box.graphics.clear().beginFill("#f22222").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 600, 50);
	} else if (level == 'warning') {
		status_box.graphics.clear().beginFill("#f0af00").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 600, 50);
	} else if (level == 'success') {
		status_box.graphics.clear().beginFill("#4e700c").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 600, 50);
	}

	stage.update();

	return true;
}



function calc_consuming_energy() {

	var wh_light1, wh_light2;

	consuming_energy = 0;

	// lighting
	light1.visible = $("#light1").val()>0 ? true : false;
	light2.visible = $("#light2").val()>0 ? true : false;

	$("#hr_light1").html(parseInt($("#light1").val())>0 ? $("#light1").val() + " / " : "");
	$("#hr_light2").html(parseInt($("#light2").val())>0 ? $("#light2").val() + " / " : "");

	if ($("input[name='lights_type']:checked").val() == "traditional") {
		// traditional
		wh_light1 = parseInt($("#light1").val()) * config.light1_traditional;
		wh_light2 = parseInt($("#light2").val()) * config.light2_traditional;
		$("#wh_light1").html(wh_light1);
		$("#wh_light2").html(wh_light2);
		consuming_energy += (wh_light1 + wh_light2);
		light1_box.graphics.clear().beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
		light2_box.graphics.clear().beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
	} else {
		// led
		wh_light1 = parseInt($("#light1").val()) * config.light1_led;
		wh_light2 = parseInt($("#light2").val()) * config.light2_led;
		$("#wh_light1").html(wh_light1);
		$("#wh_light2").html(wh_light2);
		consuming_energy += (wh_light1 + wh_light2);
		// green box
		light1_box.graphics.clear().beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
		light2_box.graphics.clear().beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
	}



	// white_devices
	kitchen.visible = $("#kitchen").val()>0 ? true : false;
	refrigerator.visible = $("#refrigerator").val()>0 ? true : false;
	washing_machine.visible = $("#washing_machine").val()>0 ? true : false;
	dishwasher.visible = $("#dishwasher").val()>0 ? true : false;

	$("#hr_kitchen").html(parseInt($("#kitchen").val())>0 ? $("#kitchen").val() + " / " : "");
	$("#hr_refrigerator").html(parseInt($("#refrigerator").val())>0 ? $("#refrigerator").val() + " / " : "");
	$("#hr_washing_machine").html(parseInt($("#washing_machine").val())>0 ? $("#washing_machine").val() + " / " : "");
	$("#hr_dishwasher").html(parseInt($("#dishwasher").val())>0 ? $("#dishwasher").val() + " / " : "");

	var wh_kitchen = parseInt($("#kitchen").val()) * config.kitchen;
	var wh_refrigerator = parseInt($("#refrigerator").val() ) * config.refrigerator;
	var wh_washing_machine = parseInt($("#washing_machine").val()) * config.washing_machine;
	var wh_dishwasher = parseInt($("#dishwasher").val()) * config.dishwasher;	

	$("#wh_kitchen").html(wh_kitchen);
	$("#wh_refrigerator").html(wh_refrigerator);
	$("#wh_washing_machine").html(wh_washing_machine);
	$("#wh_dishwasher").html(wh_dishwasher);
	
	consuming_energy += (wh_kitchen + wh_refrigerator + wh_washing_machine + wh_dishwasher);



	// cooling_heating
	air_condition.visible = $("#air_condition").val()>0 ? true : false;
	fan.visible = $("#fan").val()>0 ? true : false;
	heater.visible = $("#heater").val()>0 ? true : false;
	fireplace.visible = $("#fireplace").val()>0 ? true : false;
	boiler.visible = $("#water_heater").val()>0 ? true : false;
	solar_boiler.visible = $("#solar_heater").val()>0 ? true : false;

	$("#hr_air_condition").html(parseInt($("#air_condition").val())>0 ? $("#air_condition").val() + " / " : "");
	$("#hr_fan").html(parseInt($("#fan").val())>0 ? $("#fan").val() + " / " : "");
	$("#hr_heater").html(parseInt($("#heater").val())>0 ? $("#heater").val() + " / " : "");
	$("#hr_fireplace").html(parseInt($("#fireplace").val())>0 ? $("#fireplace").val() + " / " : "");
	$("#hr_water_heater").html(parseInt($("#water_heater").val())>0 ? $("#water_heater").val() + " / " : "");
	$("#hr_solar_heater").html(parseInt($("#solar_heater").val())>0 ? $("#solar_heater").val() + " / " : "");

	var wh_air_condition = parseInt($("#air_condition").val()) * config.air_condition;
	var wh_fan = parseInt($("#fan").val()) * config.fan;
	var wh_heater = parseInt($("#heater").val()) * config.heater;
	var wh_fireplace = parseInt($("#fireplace").val()) * config.fireplace;
	var wh_water_heater = parseInt($("#water_heater").val()) * config.water_heater;
	var wh_solar_heater = parseInt($("#solar_heater").val()) * config.solar_heater;
	
	$("#wh_air_condition").html(wh_air_condition);
	$("#wh_fan").html(wh_fan);
	$("#wh_heater").html(wh_heater);
	$("#wh_fireplace").html(wh_fireplace);
	$("#wh_water_heater").html(wh_water_heater);
	$("#wh_solar_heater").html(wh_solar_heater);

	consuming_energy += (wh_air_condition + wh_fan + wh_heater + wh_fireplace + wh_water_heater + wh_solar_heater);



	// electronics
	tv.visible = $("#tv").val()>0 ? true : false;
	pc.visible = $("#pc").val()>0 ? true : false;
	laptop.visible = $("#laptop").val()>0 ? true : false;

	$("#hr_tv").html(parseInt($("#tv").val())>0 ? $("#tv").val() + " / " : "");
	$("#hr_pc").html(parseInt($("#pc").val())>0 ? $("#pc").val() + " / " : "");
	$("#hr_laptop").html(parseInt($("#laptop").val())>0 ? $("#laptop").val() + " / " : "");

	var wh_tv = parseInt($("#tv").val()) * config.tv;
	var wh_pc = parseInt($("#pc").val()) * config.pc;
	var wh_laptop = parseInt($("#laptop").val()) * config.laptop;
	
	$("#wh_tv").html(wh_tv);
	$("#wh_pc").html(wh_pc);
	$("#wh_laptop").html(wh_laptop);
	
	consuming_energy += (wh_tv + wh_pc + wh_laptop);



	// other_devices
	vacuum_cleaner.visible = $("#vacuum_cleaner").val()>0 ? true : false;
	iron.visible = $("#iron").val()>0 ? true : false;

	$("#hr_vacuum_cleaner").html(parseInt($("#vacuum_cleaner").val())>0 ? $("#vacuum_cleaner").val() + " / " : "");
	$("#hr_iron").html(parseInt($("#iron").val())>0 ? $("#iron").val() + " / " : "");

	var wh_vacuum_cleaner = parseInt($("#vacuum_cleaner").val()) * config.vacuum_cleaner;
	var wh_iron = parseInt($("#iron").val()) * config.iron;
	
	$("#wh_vacuum_cleaner").html(wh_vacuum_cleaner);
	$("#wh_iron").html(wh_iron);
	
	consuming_energy += (wh_vacuum_cleaner + wh_iron);


	if (consuming_energy > 0) {
		// Calculate Eferdia
		consuming_energy = consuming_energy * 1.25;

		consume_txt.text = consuming_energy.toFixed(0) + " Wh / ημέρα";
		consume_box.visible = true;
		consume_label.visible = true;
		consume_txt.visible = true;
	} else {
		consume_box.visible = false;
		consume_label.visible = false;
		consume_txt.visible = false;
	}

	// console.log ('consuming energy: ' + consuming_energy);

	stage.update();

	return true;

}


function get_ed() {
	
	var place = $("input[name='place']:checked").val();
	var month = parseInt($("#month").val()) - 1;
	var ed = 0;

	switch(place) {
		case "pylos":
			ed = ed_pylos[month];
			break;
		case "thassos":
			ed = ed_thassos[month];
			break;
		case "paris":
			ed = ed_paris[month];
			break;
		case "stockholm":
			ed = ed_stockholm[month];
			break;
	}

	// console.log('ed: ' + ed);

	return ed;
}



function calc_co2(duration) {

	co2_lignite = 0;
	co2_petrol = 0;
	co2_gas = 0;

	if (consuming_energy > 0 && pv_energy > 0) {

		// calculate CO2 emission in a day
		var co2_pv = consuming_energy / 1000 * 0.03;

		co2_lignite = (consuming_energy / 1000 * 3.75) - co2_pv;
		co2_petrol = (consuming_energy / 1000 * 3.06) - co2_pv;
		co2_gas = (consuming_energy / 1000 * 0.24) - co2_pv;

		if (duration=='month') {
			co2_lignite = (consuming_energy * 30 / 1000 * 3.75) - (co2_pv * 30);
			co2_petrol = (consuming_energy * 30 / 1000 * 3.06) - (co2_pv * 30);
			co2_gas = (consuming_energy * 30 / 1000 * 0.24) - (co2_pv * 30);
		} else if (duration=='year') {
			co2_lignite = (consuming_energy * 365 / 1000 * 3.75) - (co2_pv * 365);
			co2_petrol = (consuming_energy * 365 / 1000 * 3.06) - (co2_pv * 365);
			co2_gas = (consuming_energy * 365 / 1000 * 0.24) - (co2_pv * 365);
		}

		if (co2_lignite < 0) co2_lignite = 0;
		if (co2_petrol < 0) co2_petrol = 0;
		if (co2_gas < 0) co2_gas = 0;

		co2_lignite_txt.text = "Λιγνίτη ≈ " + co2_lignite.toFixed(1) + " Kg CO₂-eq";
		co2_petrol_txt.text = "Πετρέλαιο ≈ " + co2_petrol.toFixed(1) + " Kg CO₂-eq";
		co2_gas_txt.text = "Φυσικό Αέριο ≈ " + co2_gas.toFixed(1) + " Kg CO₂-eq";

	}

	stage.update();
	
	return true;
}



function show_co2(status) {

	if (status==true) {
		co2.visible = true;
		co2_label.visible = true;
		co2_lignite_txt.visible = true;
		co2_petrol_txt.visible = true;
		co2_gas_txt.visible = true;
		co2_duration_txt.visible = true;
		co2_duration_line.visible = true;
		co2_area_day.visible = true;
		co2_area_month.visible = true;
		co2_area_year.visible = true;
		co2_area_day.cursor = "pointer";
		co2_area_month.cursor = "pointer";
		co2_area_year.cursor = "pointer";

		// animate co2 image
		createjs.Tween.get(co2, {loop:true, override:true}).to({alpha:0.7}, 500).to({alpha:1}, 500).wait(1500).to({alpha:0.7}, 500);

	} else {
		co2.visible = false;
		co2_label.visible = false;
		co2_lignite_txt.visible = false;
		co2_petrol_txt.visible = false;
		co2_gas_txt.visible = false;
		co2_duration_txt.visible = false;
		co2_duration_line.visible = false;
		co2_area_day.visible = false;
		co2_area_month.visible = false;
		co2_area_year.visible = false;

		// stop animatiton of co2 image
		createjs.Tween.get(co2, {loop:false, override:true}).to({alpha:1, visible:false}, 500);

	}

	stage.update();
	
	return true;

}



function calc_pv_energy() {

	pv_energy = 0;
	pv_area_panels = 0;

	pv_panels_ideal = 0;

	var panels_max = 0;
	var panel_type = $("input[name='panel_type']:checked").val();
	var panels = parseInt($("#panels").val());

	// Hide all panels on the roofs
	for (var i=0; i<54; i++) {
		if (typeof panel1[i] !== 'undefined') {
			panel1[i].visible = false;
		}
	}
	for (var i=0; i<42; i++) {
		if (typeof panel2[i] !== 'undefined') {
			panel2[i].visible = false;
		}
	}

	if (panels > 0) {
		if (panel_type == "275W") {

			// pv area
			panels_max = parseInt(config.pv_area_roof / 1.6 / 1.15);
			config.panels_max = panels_max;
			$('#num_panels').attr('max', panels_max);
			$('#panels').attr('max', panels_max);

			// fix max number of panels
			if (panels > panels_max) {
				panels = panels_max;
				$("#num_panels").val(panels);
				$("#panels").val(panels);
			}
			pv_area_panels = parseInt(panels * 1.6 * 1.15);

			// pv energy
			pv_energy = panels * 275 * get_ed();

			// pv panels ideal number
			pv_panels_ideal = consuming_energy / 275 / get_ed();

			// Round to +1 if there is a decimal
			if (pv_panels_ideal > 0 && pv_panels_ideal > parseInt(pv_panels_ideal)) {
				pv_panels_ideal = parseInt(pv_panels_ideal) + 1;
			} else {
				pv_panels_ideal = parseInt(pv_panels_ideal);
			}

			// show 275W panels on the roof
			for (var i=0; i<panels; i++) {
				panel1[i].visible = true;
			}
			
		} else if (panel_type == "330W") {

			// pv area
			// panels_max = parseInt(config.pv_area_roof / 2 / 1.15);
			panels_max = 42; // in order to show all panels!
			config.panels_max = panels_max;
			$('#num_panels').attr('max', panels_max);
			$('#panels').attr('max', panels_max);

			// fix max number of panels
			if (panels > panels_max) {
				panels = panels_max;
				$("#num_panels").val(panels);
				$("#panels").val(panels);
			}
			pv_area_panels = parseInt(panels * 2 * 1.15);

			// pv energy
			pv_energy = panels * 330 * get_ed();

			// pv panels ideal number
			pv_panels_ideal = consuming_energy / 330 / get_ed();

			// Round to +1 if there is a decimal
			if (pv_panels_ideal > 0 && pv_panels_ideal > parseInt(pv_panels_ideal)) {
				pv_panels_ideal = parseInt(pv_panels_ideal) + 1;
			} else {
				pv_panels_ideal = parseInt(pv_panels_ideal);
			}

			// show 330W panels on the roof
			for (var i=0; i<panels; i++) {
				panel2[i].visible = true;
			}
		}
	}


	$("#pv_area_panels").html(pv_area_panels);

	// console.log('pv_energy: ' + pv_energy);

	if (pv_energy > 0) {
		pv_txt.text = pv_energy.toFixed(0) + " Wh / ημέρα";
		pv_box.visible = true;
		pv_label.visible = true;
		pv_txt.visible = true;
	} else {
		pv_box.visible = false;
		pv_label.visible = false;
		pv_txt.visible = false;
	}

	stage.update();

	return true;
}


function calc_batteries() {
	
	batteries_ideal = 0;

	var batteries_type = $("input[name='batteries_type']:checked").val();

	if ($("#batteries").val() > 0) {
		batteries_txt.text = $("#batteries").val();
		batteries_box.visible = true;
		batteries_txt.visible = true;
	} else {
		batteries_box.visible = false;
		batteries_txt.visible = false;
	}

	if (batteries_type == "100HA") {
		batteries_ideal = (consuming_energy / 12 / 100) * 1.5;
	} else if (batteries_type == "200HA") {
		batteries_ideal = (consuming_energy / 12 / 200) * 1.5;
	}

	// Round to +1 if there is a decimal
	if (batteries_ideal > 0 && batteries_ideal > parseInt(batteries_ideal)) {
		batteries_ideal = parseInt(batteries_ideal) + 1;
	} else {
		batteries_ideal = parseInt(batteries_ideal);
	}

	// console.log("Ideal batteries: " + batteries_ideal);

	return true;
}



function update_status() {

	calc_consuming_energy();
	calc_pv_energy();
	calc_batteries();
	
	// Hide CO2 emission
	show_co2(false);

	// make status message blinking
	createjs.Tween.get(status_txt, {loop:true, override:true}).to({alpha:0.2, visible:true}, 400).to({alpha:1, visible:true}, 400).wait(1500);

	// Show magnifier
	if (pv_energy > 0 && $("#batteries").val() > 0) {
		magnifier.visible = true;
		zoom_area.visible = true;

		// Animate Magnifier
		createjs.Tween.get(magnifier, {loop:true, override:true}).to({scale:0.95}, 1500).to({scale:1}, 1500).wait(500);
		stage.update();

	} else {

		// magnifier.setPaused(true);

		createjs.Tween.get(magnifier, {loop:false, override:true}).to({scale:1}, 1500);

		magnifier.visible = false;
		zoom_area.visible = false;
		diagram.visible = false;
		diagram_area_close.visible = false;
		panels_box.visible = false;
		panels_txt.visible = false;

		batteries_box.x = config.center_x + 170;
		batteries_box.y = config.center_y + 160;

		batteries_txt.x = config.center_x + 170;
		batteries_txt.y = config.center_y + 150;

		stage.update();
	}

	// Update panels number if diagram is visible
	panels_txt.text = $("#panels").val();


	// Place status alerts in ASCEDING ORDER

	// Errors
	if (!$("input[name='place']:checked").val()) {
		update_status_box("error");
		status_txt.text = config.alert_place;
		stage.update();
		return true;
	}

	if ($("#month").val() == "") {
		update_status_box("error");
		status_txt.text = config.alert_month;
		stage.update();
		return true;
	}

	if (consuming_energy == 0) {
		update_status_box("error");
		status_txt.text = config.alert_consume;
		stage.update();
		return true;
	}

	if (!$("input[name='panel_type']:checked").val()) {
		update_status_box("error");
		status_txt.text = config.alert_pv_type;
		stage.update();
		return true;
	}

	if (parseInt($("#panels").val()) == 0) {
		update_status_box("error");
		status_txt.text = config.alert_pv_num;
		stage.update();
		return true;
	}

	if (!$("input[name='batteries_type']:checked").val()) {
		update_status_box("error");
		status_txt.text = config.alert_batteries_type;
		stage.update();
		return true;
	}

	if (parseInt($("#batteries").val()) == 0) {
		update_status_box("error");
		status_txt.text = config.alert_batteries_num;
		stage.update();
		return true;
	}

	// Warnings
	if (consuming_energy > pv_energy) {
		update_status_box("warning");
		status_txt.text = config.warning_pv_not_enough;
		stage.update();
		return true;
	}

	if ($("#month").val() != "12") {
		update_status_box("warning");
		status_txt.text = config.warning_wrong_month;
		stage.update();
		return true;
	}

	if (parseInt($("#batteries").val()) < batteries_ideal) {
		update_status_box("warning");
		status_txt.text = config.warning_batteries_not_enough;
		stage.update();
		return true;
	}

	// if (pv_energy > consuming_energy * 1.25) {
	if (parseInt($("#panels").val()) > pv_panels_ideal) {
		update_status_box("warning");
		status_txt.text = config.warning_pv_not_required;
		stage.update();
		return true;
	}

	if (parseInt($("#batteries").val()) > batteries_ideal) {
		update_status_box("warning");
		status_txt.text = config.warning_batteries_not_required;
		stage.update();
		return true;
	}

	// Everything seems OK
	// Show co2 emissions gained
	calc_co2(co2_duration);
	show_co2(true);

	// Congratulate user
	status_txt.text = config.system_success;
	update_status_box("success");

	// stop blinking text
	createjs.Tween.get(status_txt, {loop:false, override:true}).to({alpha:1, visible:true}, 500);


	// Update stage
	stage.update();

	return true;
}
