/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 1.0
Last Update: 2018-12-20
-------------------------------------------------- */

// Initialize Canvas
var canvas = document.getElementById("canvas");
var context = canvas.getContext('2d');
var stage = new createjs.Stage("canvas");

// Enable Mouseover on stage
stage.enableMouseOver();


// Sun
var sun_img = new Image();
sun_img.src = 'images/sun.png';

var sun = new createjs.Bitmap(sun_img);
sun.scaleX = sun.scaleY = 0.9;
sun.regX = sun.regY = 64;	// needed in order to rotate to its center
sun.x = config.center_x + 310;
sun.y = config.center_y - 240;
// sun.alpha = 1;

sun_img.onload = function () {
	stage.addChild(sun);
	stage.setChildIndex(sun, 1);
	stage.update();
}

// Clouds
var clouds_img = new Image();
clouds_img.src = 'images/clouds-thassos.png';

var clouds = new createjs.Bitmap(clouds_img);
clouds.scaleX = clouds.scaleY = 0.9;
clouds.x = config.center_x + 180;
clouds.y = config.center_y - 250;

clouds_img.onload = function () {
	stage.addChild(clouds);
	stage.setChildIndex(clouds, 2);
	stage.update();
}






// Devices
var light1_box = new createjs.Shape();
light1_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
light1_box.x = config.center_x - 390;
light1_box.y = config.center_y + 100;

var light1_label = new createjs.Text("Φωτ. Σαλονιού", "14px Arial", "#ffffff");
light1_label.x = config.center_x - 380;
light1_label.y = config.center_y + 109;

var light1 = new createjs.Container();
light1.addChild(light1_box, light1_label);


var light2_box = new createjs.Shape();
light2_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
light2_box.x = config.center_x - 260;
light2_box.y = config.center_y - 120;

var light2_label = new createjs.Text("Φωτ. Δωματίου", "14px Arial", "#ffffff");
light2_label.x = config.center_x - 250;
light2_label.y = config.center_y - 111;

var light2 = new createjs.Container();
light2.addChild(light2_box, light2_label);

var kitchen_box = new createjs.Shape();
kitchen_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 70, 30, 6);
kitchen_box.x = config.center_x - 60;
kitchen_box.y = config.center_y + 180;

var kitchen_label = new createjs.Text("Κουζίνα", "14px Arial", "#ffffff");
kitchen_label.x = config.center_x - 50;
kitchen_label.y = config.center_y + 189;

var kitchen = new createjs.Container();
kitchen.addChild(kitchen_box, kitchen_label);



var washing_machine_box = new createjs.Shape();
washing_machine_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
washing_machine_box.x = config.center_x - 50;
washing_machine_box.y = config.center_y + 110;

var washing_machine_label = new createjs.Text("Πλυντ. Ρούχων", "14px Arial", "#ffffff");
washing_machine_label.x = config.center_x - 40;
washing_machine_label.y = config.center_y + 119;

var washing_machine = new createjs.Container();
washing_machine.addChild(washing_machine_box, washing_machine_label);



var dishwasher_box = new createjs.Shape();
dishwasher_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 110, 30, 6);
dishwasher_box.x = config.center_x - 60;
dishwasher_box.y = config.center_y + 215;

var dishwasher_label = new createjs.Text("Πλυντ. Πιάτων", "14px Arial", "#ffffff");
dishwasher_label.x = config.center_x - 50;
dishwasher_label.y = config.center_y + 224;

var dishwasher = new createjs.Container();
dishwasher.addChild(dishwasher_box, dishwasher_label);


var refrigerator_box = new createjs.Shape();
refrigerator_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 64, 30, 6);
refrigerator_box.x = config.center_x + 52;
refrigerator_box.y = config.center_y + 215;

var refrigerator_label = new createjs.Text("Ψυγείο", "14px Arial", "#ffffff");
refrigerator_label.x = config.center_x + 62;
refrigerator_label.y = config.center_y + 224;

var refrigerator = new createjs.Container();
refrigerator.addChild(refrigerator_box, refrigerator_label);




var tv_box = new createjs.Shape();
tv_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 40, 30, 6);
tv_box.x = config.center_x - 280;
tv_box.y = config.center_y + 50;

var tv_label = new createjs.Text("TV", "14px Arial", "#ffffff");
tv_label.x = config.center_x - 270;
tv_label.y = config.center_y + 59;

var tv = new createjs.Container();
tv.addChild(tv_box, tv_label);



var pc_box = new createjs.Shape();
pc_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 40, 30, 6);
pc_box.x = config.center_x - 160;
pc_box.y = config.center_y - 30;

var pc_label = new createjs.Text("PC", "14px Arial", "#ffffff");
pc_label.x = config.center_x - 150;
pc_label.y = config.center_y - 21;

var pc = new createjs.Container();
pc.addChild(pc_box, pc_label);



// House
var house_img = new Image();
house_img.src = 'images/house.png';

var house = new createjs.Bitmap(house_img);
house.scaleX = house.scaleY = 1;
house.x = config.center_x - 400;
house.y = config.center_y - 200;


house_img.onload = function () {
	stage.addChild(house);		// this should be loaded first in order to be at backstage
	stage.setChildIndex(house, 3);
	
	stage.addChild(light1, light2);
	stage.addChild(kitchen, refrigerator, washing_machine, dishwasher);
	stage.addChild(boiler, solar_boiler);
	stage.addChild(tv, pc);

	stage.setChildIndex(kitchen, 4);
	stage.setChildIndex(refrigerator, 5);
	stage.setChildIndex(washing_machine, 6);
	stage.setChildIndex(dishwasher, 7);
	stage.setChildIndex(boiler, 8);
	stage.setChildIndex(solar_boiler, 9);
	stage.setChildIndex(tv, 10);
	stage.setChildIndex(pc, 11);

	stage.update();
}



var fan_img = new Image();
fan_img.src = 'images/fan.png';

var fan_ico = new createjs.Bitmap(fan_img);
fan_ico.scaleX = fan_ico.scaleY = 1;
fan_ico.x = config.center_x - 25;
fan_ico.y = config.center_y + 5;

var fan_box = new createjs.Shape();
fan_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 100, 30, 6);
fan_box.x = config.center_x - 130;
fan_box.y = config.center_y + 30;

var fan_label = new createjs.Text("Ανεμιστήρας", "14px Arial", "#ffffff");
fan_label.x = config.center_x - 120;
fan_label.y = config.center_y + 39;

var fan = new createjs.Container();
fan.addChild(fan_ico, fan_box, fan_label);

fan_img.onload = function () {
	stage.addChild(fan);
	stage.setChildIndex(fan, 12);
	stage.update();
}


var fireplace_img = new Image();
fireplace_img.src = 'images/fireplace.png';

var fireplace_ico = new createjs.Bitmap(fireplace_img);
fireplace_ico.scaleX = fireplace_ico.scaleY = 1;
fireplace_ico.x = config.center_x - 95;
fireplace_ico.y = config.center_y + 72;

var fireplace_box = new createjs.Shape();
fireplace_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 55, 30, 6);
fireplace_box.x = config.center_x - 155;
fireplace_box.y = config.center_y + 90;

var fireplace_label = new createjs.Text("Τζάκι", "14px Arial", "#ffffff");
fireplace_label.x = config.center_x - 145;
fireplace_label.y = config.center_y + 99;

var fireplace = new createjs.Container();
fireplace.addChild(fireplace_ico, fireplace_box, fireplace_label);

fireplace_img.onload = function () {
	stage.addChild(fireplace);
	stage.setChildIndex(fireplace, 13);
	stage.update();
}




var air_condition_img = new Image();
air_condition_img.src = 'images/air-condition.png';

var air_condition_ico = new createjs.Bitmap(air_condition_img);
air_condition_ico.scaleX = air_condition_ico.scaleY = 1;
air_condition_ico.x = config.center_x - 290;
air_condition_ico.y = config.center_y - 2;

var air_condition_box = new createjs.Shape();
air_condition_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 95, 30, 6);
air_condition_box.x = config.center_x - 390;
air_condition_box.y = config.center_y + 10;

var air_condition_label = new createjs.Text("Κλιματιστικό", "14px Arial", "#ffffff");
air_condition_label.x = config.center_x - 380;
air_condition_label.y = config.center_y + 19;

var air_condition = new createjs.Container();
air_condition.addChild(air_condition_ico, air_condition_box, air_condition_label);

air_condition_img.onload = function () {
	stage.addChild(air_condition);
	stage.setChildIndex(air_condition, 14);
	stage.update();
}



var boiler_img = new Image();
boiler_img.src = 'images/boiler.png';

var boiler_ico = new createjs.Bitmap(boiler_img);
boiler_ico.scaleX = boiler_ico.scaleY = 1;
boiler_ico.x = config.center_x + 125;
boiler_ico.y = config.center_y + 55;

var boiler_box = new createjs.Shape();
boiler_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 135, 30, 6);
boiler_box.x = config.center_x - 15;
boiler_box.y = config.center_y + 75;

var boiler_label = new createjs.Text("Ηλ. Θερμοσίφωνας", "14px Arial", "#ffffff");
boiler_label.x = config.center_x - 5;
boiler_label.y = config.center_y + 84;

var boiler = new createjs.Container();
boiler.addChild(boiler_ico, boiler_box, boiler_label);

boiler_img.onload = function () {
	stage.addChild(boiler);
	stage.setChildIndex(boiler, 15);
	stage.update();
}



var solar_boiler_img = new Image();
solar_boiler_img.src = 'images/solar-boiler.png';

var solar_boiler_ico = new createjs.Bitmap(solar_boiler_img);
solar_boiler_ico.scaleX = solar_boiler_ico.scaleY = 1;
solar_boiler_ico.x = config.center_x - 245;
solar_boiler_ico.y = config.center_y - 90;

var solar_boiler_box = new createjs.Shape();
solar_boiler_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 165, 30, 6);
solar_boiler_box.x = config.center_x - 400;
solar_boiler_box.y = config.center_y - 50;

var solar_boiler_label = new createjs.Text("Ηλιακός Θερμοσίφωνας", "14px Arial", "#ffffff");
solar_boiler_label.x = config.center_x - 390;
solar_boiler_label.y = config.center_y - 41;

var solar_boiler = new createjs.Container();
solar_boiler.addChild(solar_boiler_ico, solar_boiler_box, solar_boiler_label);

solar_boiler_img.onload = function () {
	stage.addChild(solar_boiler);
	stage.setChildIndex(solar_boiler, 16);
	stage.update();
}



var laptop_img = new Image();
laptop_img.src = 'images/laptop.png';

var laptop_ico = new createjs.Bitmap(laptop_img);
laptop_ico.scaleX = laptop_ico.scaleY = 1;
laptop_ico.x = config.center_x + 15;
laptop_ico.y = config.center_y - 25;

var laptop_box = new createjs.Shape();
laptop_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 65, 30, 6);
laptop_box.x = config.center_x - 55;
laptop_box.y = config.center_y - 30;

var laptop_label = new createjs.Text("Laptop", "14px Arial", "#ffffff");
laptop_label.x = config.center_x - 45;
laptop_label.y = config.center_y - 22;

var laptop = new createjs.Container();
laptop.addChild(laptop_ico, laptop_box, laptop_label);

laptop_img.onload = function () {
	stage.addChild(laptop);
	stage.setChildIndex(laptop, 17);
	stage.update();
}



var iron_img = new Image();
iron_img.src = 'images/iron.png';

var iron_ico = new createjs.Bitmap(iron_img);
iron_ico.scaleX = iron_ico.scaleY = 1;
iron_ico.x = config.center_x - 130;
iron_ico.y = config.center_y + 145;

var iron_box = new createjs.Shape();
iron_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 88, 30, 6);
iron_box.x = config.center_x - 230;
iron_box.y = config.center_y + 140;

var iron_label = new createjs.Text("Ηλ. Σίδερο", "14px Arial", "#ffffff");
iron_label.x = config.center_x - 220;
iron_label.y = config.center_y + 149;

var iron = new createjs.Container();
iron.addChild(iron_ico, iron_box, iron_label);

iron_img.onload = function () {
	stage.addChild(iron);
	stage.setChildIndex(iron, 18);
	stage.update();
}



var vacuum_cleaner_img = new Image();
vacuum_cleaner_img.src = 'images/vacuum-cleaner.png';

var vacuum_cleaner_ico = new createjs.Bitmap(vacuum_cleaner_img);
vacuum_cleaner_ico.scaleX = vacuum_cleaner_ico.scaleY = 1;
vacuum_cleaner_ico.x = config.center_x - 115;
vacuum_cleaner_ico.y = config.center_y + 185;

var vacuum_cleaner_box = new createjs.Shape();
vacuum_cleaner_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 95, 30, 6);
vacuum_cleaner_box.x = config.center_x - 210;
vacuum_cleaner_box.y = config.center_y + 200;
stage.addChild(vacuum_cleaner_box);

var vacuum_cleaner_label = new createjs.Text("Ηλ. Σκούπα", "14px Arial", "#ffffff");
vacuum_cleaner_label.x = config.center_x - 200;
vacuum_cleaner_label.y = config.center_y + 209;
stage.addChild(vacuum_cleaner_label);

var vacuum_cleaner = new createjs.Container();
vacuum_cleaner.addChild(vacuum_cleaner_ico, vacuum_cleaner_box, vacuum_cleaner_label);

vacuum_cleaner_img.onload = function () {
	stage.addChild(vacuum_cleaner);
	stage.setChildIndex(vacuum_cleaner, 19);
	stage.update();
}

// Magnifier
var magnifier_img = new Image();
magnifier_img.src = 'images/magnifier.png';

var magnifier = new createjs.Bitmap(magnifier_img);
magnifier.scaleX = magnifier.scaleY = 1;
magnifier.x = config.center_x + 170;
magnifier.y = config.center_y + 60;

magnifier_img.onload = function () {
	stage.addChild(magnifier);
	stage.setChildIndex(magnifier, 20);
	stage.update();
}

var zoom_area = new createjs.Shape();
zoom_area.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 80, 80);
zoom_area.x = config.center_x + 170;
zoom_area.y = config.center_y + 60;
zoom_area.cursor = "pointer";
stage.addChild(zoom_area);
stage.setChildIndex(zoom_area, 21);


// Solar Panels
var panel_img = new Image();
panel_img.src = 'images/solar-panel.png';



// Panels of 275W - 1.6 m2
var panel1 = new Array();

panel1[0] = new createjs.Bitmap(panel_img);
panel1[0].scaleX = panel1[0].scaleY = 0.56;
panel1[0].x = config.center_x + 106;
panel1[0].y = config.center_y - 132;

// Panels of 330W - 2.0 m2
var panel2 = new Array();

panel2[0] = new createjs.Bitmap(panel_img);
panel2[0].scaleX = panel2[0].scaleY = 0.7;
panel2[0].x = config.center_x + 100;
panel2[0].y = config.center_y - 132;

// Add panels to stage
panel_img.onload = function () {

	// Panels of 275W - 1.6 m2
	stage.addChild(panel1[0]);

	for (var i=1; i<10; i++) {
		panel1[i] = panel1[0].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	panel1[10] = panel1[0].clone();
	panel1[10].x = panel1[0].x - (30 * 0.56);
	panel1[10].y = panel1[0].y - (43 * 0.56);
	stage.addChild(panel1[10]);

	for (var i=11; i<20; i++) {
		panel1[i] = panel1[i-1].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	panel1[20] = panel1[10].clone();
	panel1[20].x = panel1[10].x - (30 * 0.56);
	panel1[20].y = panel1[10].y - (43 * 0.56);
	stage.addChild(panel1[20]);

	for (var i=21; i<30; i++) {
		panel1[i] = panel1[i-1].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	// panels in the 2nd roof
	panel1[30] = panel1[0].clone();
	panel1[30].x = config.center_x + 248;
	panel1[30].y = config.center_y - 36;
	stage.addChild(panel1[30]);

	for (var i=31; i<38; i++) {
		panel1[i] = panel1[i-1].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	panel1[38] = panel1[30].clone();
	panel1[38].x = panel1[30].x - (30 * 0.56);
	panel1[38].y = panel1[30].y - (43 * 0.56);
	stage.addChild(panel1[38]);

	for (var i=39; i<46; i++) {
		panel1[i] = panel1[i-1].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	panel1[46] = panel1[38].clone();
	panel1[46].x = panel1[38].x - (30 * 0.56);
	panel1[46].y = panel1[38].y - (43 * 0.56);
	stage.addChild(panel1[46]);

	for (var i=47; i<54; i++) {
		panel1[i] = panel1[i-1].clone();
		panel1[i].x = panel1[i-1].x - (37 * 0.56);
		panel1[i].y = panel1[i-1].y + (12 * 0.56);
		stage.addChild(panel1[i]);
	}

	// Hide the 54 panels of 275W
	for (var i=0; i<54; i++) {
		if (typeof panel1[i] !== 'undefined') {
			panel1[i].visible = false;
		}
	}

	stage.update();


	// Panels of 330W - 2.0 m2
	stage.addChild(panel2[0]);

	for (var i=1; i<8; i++) {
		panel2[i] = panel2[0].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	panel2[8] = panel2[0].clone();
	panel2[8].x = panel2[0].x - (30 * 0.7);
	panel2[8].y = panel2[0].y - (43 * 0.7);
	stage.addChild(panel2[8]);

	for (var i=9; i<16; i++) {
		panel2[i] = panel2[i-1].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	panel2[16] = panel2[8].clone();
	panel2[16].x = panel2[8].x - (30 * 0.7);
	panel2[16].y = panel2[8].y - (43 * 0.7);
	stage.addChild(panel2[16]);

	for (var i=17; i<24; i++) {
		panel2[i] = panel2[i-1].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	// panels in the 2nd roof
	panel2[24] = panel2[0].clone();
	panel2[24].x = config.center_x + 240;
	panel2[24].y = config.center_y - 38;
	stage.addChild(panel2[24]);

	for (var i=25; i<30; i++) {
		panel2[i] = panel2[i-1].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	panel2[30] = panel2[24].clone();
	panel2[30].x = panel2[24].x - (30 * 0.7);
	panel2[30].y = panel2[24].y - (43 * 0.7);
	stage.addChild(panel2[30]);

	for (var i=31; i<36; i++) {
		panel2[i] = panel2[i-1].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	panel2[36] = panel2[30].clone();
	panel2[36].x = panel2[30].x - (30 * 0.7);
	panel2[36].y = panel2[30].y - (43 * 0.7);
	stage.addChild(panel2[36]);

	for (var i=37; i<42; i++) {
		panel2[i] = panel2[i-1].clone();
		panel2[i].x = panel2[i-1].x - (37 * 0.7);
		panel2[i].y = panel2[i-1].y + (12 * 0.7);
		stage.addChild(panel2[i]);
	}

	// Hide the 42 panels of 330W
	for (var i=0; i<42; i++) {
		if (typeof panel2[i] !== 'undefined') {
			panel2[i].visible = false;
		}
	}

	stage.update();
}




// House Repair after panels
var house_repair_img = new Image();
house_repair_img.src = 'images/house-repair.png';

var house_repair = new createjs.Bitmap(house_repair_img);
house_repair.scaleX = house_repair.scaleY = 1;
house_repair.x = config.center_x + 71;
house_repair.y = config.center_y - 68;


// Electric heater
var heater_img = new Image();
heater_img.src = 'images/heater.png';

var heater_ico = new createjs.Bitmap(heater_img);
heater_ico.scaleX = heater_ico.scaleY = 1;
heater_ico.x = config.center_x + 70;
heater_ico.y = config.center_y - 15;

var heater_box = new createjs.Shape();
heater_box.graphics.beginFill("#003471").beginStroke("#ffffff").setStrokeStyle(1).drawRoundRect(0, 0, 95, 30, 6);
heater_box.x = config.center_x + 0;
heater_box.y = config.center_y + 40;

var heater_label = new createjs.Text("Θερμ. Σώμα", "14px Arial", "#ffffff");
heater_label.x = config.center_x + 10;
heater_label.y = config.center_y + 49;

var heater = new createjs.Container();
heater.addChild(heater_ico, heater_box, heater_label);



// Electrical Diagram
var diagram_img = new Image();
diagram_img.src = 'images/electrical-diagram.png';

var diagram = new createjs.Bitmap(diagram_img);
diagram.scaleX = diagram.scaleY = 1;
diagram.x = config.center_x - 200;
diagram.y = config.center_y - 100;

var diagram_area_close = new createjs.Shape();
diagram_area_close.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawCircle(0, 0, 20);
diagram_area_close.x = config.center_x + 375;
diagram_area_close.y = config.center_y - 80;
diagram_area_close.cursor = "pointer";


// Batteries Box
var batteries_box = new createjs.Shape();
batteries_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(2).drawCircle(0, 0, 20);
batteries_box.x = config.center_x + 170;
batteries_box.y = config.center_y + 160;

var batteries_txt = new createjs.Text("0", "20px Arial", "#ffffff");
batteries_txt.textAlign = "center";
batteries_txt.x = config.center_x + 170;
batteries_txt.y = config.center_y + 150;

// Panels Box
var panels_box = new createjs.Shape();
panels_box.graphics.beginFill("#236ab8").beginStroke("#eeeeee").setStrokeStyle(2).drawCircle(0, 0, 20);
panels_box.x = config.center_x + 100;
panels_box.y = config.center_y + 60;

var panels_txt = new createjs.Text("0", "20px Arial", "#ffffff");
panels_txt.textAlign = "center";
panels_txt.x = config.center_x + 100;
panels_txt.y = config.center_y + 50;



house_repair_img.onload = function() {
	stage.addChild(house_repair);
	stage.setChildIndex(house_repair, 200);

	heater_img.onload = function() {
		stage.addChild(heater);
		stage.setChildIndex(heater, 201);

		diagram_img.onload = function() {
			stage.addChild(diagram);
			stage.setChildIndex(diagram, 202);

			stage.addChild(batteries_box);
			stage.setChildIndex(batteries_box, 203);

			stage.addChild(batteries_txt);
			stage.setChildIndex(batteries_txt, 204);

			stage.addChild(panels_box);
			stage.setChildIndex(panels_box, 205);

			stage.addChild(panels_txt);
			stage.setChildIndex(panels_txt, 206);

			stage.addChild(diagram_area_close);
			stage.setChildIndex(diagram_area_close, 207);

			stage.update();
		}
	}
}




// Consuming Box
var consume_box = new createjs.Shape();
consume_box.graphics.beginFill("#4f8dd7").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 240, 70);
consume_box.x = config.center_x - 400;
consume_box.y = config.center_y - 195;
stage.addChild(consume_box);
stage.setChildIndex(consume_box, 300);

// Consuming Label
var consume_label = new createjs.Text();
consume_label.text = config.consume_label;
consume_label.font = "16px Arial";
consume_label.color = "#ffffff";
consume_label.textAlign = "center";
consume_label.x = config.center_x - 280;
consume_label.y = config.center_y - 180;
stage.addChild(consume_label);
stage.setChildIndex(consume_label, 301);

// Consuming Text2
var consume_txt = new createjs.Text();
consume_txt.text = "0 Wh";
consume_txt.font = "24px Arial";
consume_txt.color = "#ffffff";
consume_txt.textAlign = "center";
consume_txt.x = config.center_x - 280;
consume_txt.y = config.center_y - 160;
stage.addChild(consume_txt);
stage.setChildIndex(consume_txt, 302);




// Photovoltaics Box
var pv_box = new createjs.Shape();
pv_box.graphics.beginFill("#427010").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 240, 70);
pv_box.x = config.center_x + 160;
pv_box.y = config.center_y - 175;
stage.addChild(pv_box);
stage.setChildIndex(pv_box, 303);

// Photovoltaics Label
var pv_label = new createjs.Text();
pv_label.text = config.pv_label;
pv_label.font = "16px Arial";
pv_label.color = "#ffffff";
pv_label.textAlign = "center";
pv_label.x = config.center_x + 280;
pv_label.y = config.center_y - 160;
stage.addChild(pv_label);
stage.setChildIndex(pv_label, 304);

// Photovoltaics Text
var pv_txt = new createjs.Text();
pv_txt.text = "0 Wh";
pv_txt.font = "24px Arial";
pv_txt.color = "#ffffff";
pv_txt.textAlign = "center";
pv_txt.x = config.center_x + 280;
pv_txt.y = config.center_y - 140;
stage.addChild(pv_txt);
stage.setChildIndex(pv_txt, 305);



// CO2
var co2_img = new Image();
co2_img.src = 'images/co2.png';

var co2 = new createjs.Bitmap(co2_img);
co2.scaleX = co2.scaleY = 0.75;
co2.x = config.center_x - 340;
co2.y = config.center_y - 295;
co2.alpha = 0.8;

co2_img.onload = function () {
	stage.addChild(co2);
	stage.setChildIndex(co2, 306);
	stage.update();
}


// CO2 Title
var co2_label = new createjs.Text();
co2_label.text = config.co2_label;
co2_label.font = "15px Arial";
co2_label.color = "#222222";
co2_label.textAlign = "left";
co2_label.x = config.center_x - 230;
co2_label.y = config.center_y - 295;
stage.addChild(co2_label);
stage.setChildIndex(co2_label, 307);


// CO2 Lignite
var co2_lignite_txt = new createjs.Text();
co2_lignite_txt.text = "";
co2_lignite_txt.font = "bold 14px Arial";
co2_lignite_txt.color = "#222222";
co2_lignite_txt.textAlign = "left";
co2_lignite_txt.x = config.center_x - 230;
co2_lignite_txt.y = config.center_y - 260;
stage.addChild(co2_lignite_txt);
stage.setChildIndex(co2_lignite_txt, 308);

// CO2 Petrol
var co2_petrol_txt = new createjs.Text();
co2_petrol_txt.text = "";
co2_petrol_txt.font = "bold 14px Arial";
co2_petrol_txt.color = "#222222";
co2_petrol_txt.textAlign = "left";
co2_petrol_txt.x = config.center_x - 230;
co2_petrol_txt.y = config.center_y - 240;
stage.addChild(co2_petrol_txt);
stage.setChildIndex(co2_petrol_txt, 309);

// CO2 Gas
var co2_gas_txt = new createjs.Text();
co2_gas_txt.text = "";
co2_gas_txt.font = "bold 14px Arial";
co2_gas_txt.color = "#222222";
co2_gas_txt.textAlign = "left";
co2_gas_txt.x = config.center_x - 230;
co2_gas_txt.y = config.center_y - 220;
stage.addChild(co2_gas_txt);
stage.setChildIndex(co2_gas_txt, 310);


// CO2 Day/Month/Year
var co2_duration_txt = new createjs.Text("Επιλέξτε διάρκεια:\nανά ημέρα / μήνα / έτος", "15px Arial", "#222222");
co2_duration_txt.textAlign = "left";
co2_duration_txt.x = config.center_x - 0;
co2_duration_txt.y = config.center_y - 255;
stage.addChild(co2_duration_txt);
stage.setChildIndex(co2_duration_txt, 311);

var co2_duration_line = new createjs.Shape();
co2_duration_line.graphics.beginStroke("#222222").setStrokeStyle(2).moveTo(0, 0).lineTo(46, 0);	// 46, 40, 36
co2_duration_line.x = config.center_x + 26;		// 26, 78, 124 
co2_duration_line.y = config.center_y - 224;
stage.addChild(co2_duration_line);
stage.setChildIndex(co2_duration_line, 312);

var co2_area_day = new createjs.Shape();
co2_area_day.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 46, 20);
co2_area_day.x = config.center_x + 26;
co2_area_day.y = config.center_y - 242;
co2_area_day.cursor = "pointer";
stage.addChild(co2_area_day);
stage.setChildIndex(co2_area_day, 313);

var co2_area_month = new createjs.Shape();
co2_area_month.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 40, 20);
co2_area_month.x = config.center_x + 78;
co2_area_month.y = config.center_y - 242;
co2_area_month.cursor = "pointer";
stage.addChild(co2_area_month);
stage.setChildIndex(co2_area_month, 314);

var co2_area_year = new createjs.Shape();
co2_area_year.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRect(0, 0, 36, 20);
co2_area_year.x = config.center_x + 124;
co2_area_year.y = config.center_y - 242;
co2_area_year.cursor = "pointer";
stage.addChild(co2_area_year);
stage.setChildIndex(co2_area_year, 315);



// Status Box
var status_box = new createjs.Shape();
status_box.graphics.beginFill("#f22222").beginStroke("#ffffff").setStrokeStyle(3).drawRect(0, 0, 600, 50); // red: #f22222, green: #4e700c, orange: #f0af00
status_box.x = config.center_x - 300;
status_box.y = config.center_y + 400;
stage.addChild(status_box);
stage.setChildIndex(status_box, 316);

// Status Text
var status_txt = new createjs.Text();
status_txt.text = config.alert_place;
status_txt.font = "17px Arial";
status_txt.color = "#ffffff";
status_txt.textAlign = "center";
status_txt.x = config.center_x - 0;
status_txt.y = config.center_y + 415;
stage.addChild(status_txt);
stage.setChildIndex(status_txt, 317);




stage.update();
