Clazz.declarePackage ("JSV.export");
Clazz.load (null, "JSV.export.JDXExporter", ["java.io.FileWriter", "java.text.SimpleDateFormat", "java.util.Arrays", "$.Calendar", "JU.SB", "JSV.common.Coordinate", "$.ExportType", "JSV.export.JDXCompressor", "JSV.source.FileReader", "JSV.util.JSVTxt"], function () {
c$ = Clazz.declareType (JSV["export"], "JDXExporter");
c$.$export = $_M(c$, "$export", 
function (type, path, spectrum, startIndex, endIndex) {
var data = JSV["export"].JDXExporter.toStringAux (type, spectrum, startIndex, endIndex);
if (path == null) return data;
var writer =  new java.io.FileWriter (path);
writer.write (data);
writer.close ();
return " (" + data.length + " bytes)";
}, "JSV.common.ExportType,~S,JSV.common.JDXSpectrum,~N,~N");
c$.toStringAux = $_M(c$, "toStringAux", 
($fz = function (type, spectrum, startIndex, endIndex) {
var buffer =  new JU.SB ();
var newXYCoords = spectrum.getXYCoords ();
var tabDataSet = "";
var tmpDataClass = "XYDATA";
if (spectrum.isHZtoPPM ()) {
var xyCoords = newXYCoords;
newXYCoords =  new Array (xyCoords.length);
for (var i = 0; i < xyCoords.length; i++) newXYCoords[i] = xyCoords[i].copy ();

JSV.common.Coordinate.applyScale (newXYCoords, spectrum.getObservedFreq (), 1);
}var xCompFactor = spectrum.getXFactor ();
var isIntegerX = JSV["export"].JDXExporter.areIntegers (newXYCoords, startIndex, endIndex, 1.0, true);
if (!isIntegerX && !JSV["export"].JDXExporter.areIntegers (newXYCoords, startIndex, endIndex, xCompFactor, true)) xCompFactor = 1;
var minY = JSV.common.Coordinate.getMinY (newXYCoords, startIndex, endIndex);
var maxY = JSV.common.Coordinate.getMaxY (newXYCoords, startIndex, endIndex);
var yCompFactor = spectrum.getYFactor ();
switch (type) {
case JSV.common.ExportType.XY:
yCompFactor = 1;
tmpDataClass = (spectrum.isContinuous () ? "XYDATA" : "XYPOINTS");
break;
case JSV.common.ExportType.PAC:
yCompFactor = 1;
break;
default:
var isIntegerY = JSV["export"].JDXExporter.areIntegers (newXYCoords, startIndex, endIndex, 1.0, false);
if (!isIntegerY && !JSV["export"].JDXExporter.areIntegers (newXYCoords, startIndex, endIndex, yCompFactor, false)) {
yCompFactor = (maxY - minY) / 1000000.0;
}break;
}
var step = 1;
if (spectrum.isExportXAxisLeftToRight () != (spectrum.getFirstX () < spectrum.getLastX ())) {
var t = startIndex;
startIndex = endIndex;
endIndex = t;
step = -1;
}switch (type) {
case JSV.common.ExportType.DIF:
case JSV.common.ExportType.DIFDUP:
tabDataSet = JSV["export"].JDXCompressor.compressDIF (newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor, type === JSV.common.ExportType.DIFDUP);
break;
case JSV.common.ExportType.FIX:
tabDataSet = JSV["export"].JDXCompressor.compressFIX (newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
break;
case JSV.common.ExportType.PAC:
tabDataSet = JSV["export"].JDXCompressor.compressPAC (newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
break;
case JSV.common.ExportType.SQZ:
tabDataSet = JSV["export"].JDXCompressor.compressSQZ (newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
break;
case JSV.common.ExportType.XY:
tabDataSet = JSV["export"].JDXCompressor.getXYList (newXYCoords, startIndex, endIndex, step);
break;
default:
break;
}
var index = java.util.Arrays.binarySearch (JSV.source.FileReader.VAR_LIST_TABLE[0], tmpDataClass);
var varList = JSV.source.FileReader.VAR_LIST_TABLE[1][index];
buffer.append (JSV["export"].JDXExporter.getHeaderString (spectrum, tmpDataClass, minY, maxY, xCompFactor, yCompFactor, startIndex, endIndex));
buffer.append ("##" + tmpDataClass + "= " + varList + JSV.util.JSVTxt.newLine);
buffer.append (tabDataSet);
buffer.append ("##END=");
return buffer.toString ();
}, $fz.isPrivate = true, $fz), "JSV.common.ExportType,JSV.common.JDXSpectrum,~N,~N");
c$.getHeaderString = $_M(c$, "getHeaderString", 
($fz = function (spec, tmpDataClass, minY, maxY, tmpXFactor, tmpYFactor, startIndex, endIndex) {
var buffer =  new JU.SB ();
buffer.append ("##TITLE= ").append (spec.getTitle ()).append (JSV.util.JSVTxt.newLine);
buffer.append ("##JCAMP-DX= 5.01").append (JSV.util.JSVTxt.newLine);
buffer.append ("##DATA TYPE= ").append (spec.getDataType ()).append (JSV.util.JSVTxt.newLine);
buffer.append ("##DATA CLASS= ").append (tmpDataClass).append (JSV.util.JSVTxt.newLine);
buffer.append ("##ORIGIN= ").append (spec.getOrigin ()).append (JSV.util.JSVTxt.newLine);
buffer.append ("##OWNER= ").append (spec.getOwner ()).append (JSV.util.JSVTxt.newLine);
var d = spec.getDate ();
var longdate = "";
var currentTime = ( new java.text.SimpleDateFormat ("yyyy/MM/dd HH:mm:ss.SSSS ZZZZ")).format (java.util.Calendar.getInstance ().getTime ());
if (spec.getLongDate ().equals ("") || d.length != 8) {
longdate = currentTime + " $$ export date from JSpecView";
} else if (d.length == 8) {
longdate = (d.charAt (0) < '5' ? "20" : "19") + d + " " + spec.getTime ();
} else {
longdate = spec.getLongDate ();
}buffer.append ("##LONGDATE= ").append (longdate).append (JSV.util.JSVTxt.newLine);
var headerTable = spec.getHeaderTable ();
for (var i = 0; i < headerTable.size (); i++) {
var entry = headerTable.get (i);
var label = entry[0];
var dataSet = entry[1];
var nl = (dataSet.startsWith ("<") && dataSet.contains ("</") ? JSV.util.JSVTxt.newLine : "");
buffer.append (label).append ("= ").append (nl).append (dataSet).append (JSV.util.JSVTxt.newLine);
}
var observedFreq = spec.getObservedFreq ();
if (!spec.is1D ()) buffer.append ("##NUM DIM= ").appendI (spec.numDim).append (JSV.util.JSVTxt.newLine);
if (observedFreq != 1.7976931348623157E308) buffer.append ("##.OBSERVE FREQUENCY= ").appendD (observedFreq).append (JSV.util.JSVTxt.newLine);
if (spec.observedNucl !== "") buffer.append ("##.OBSERVE NUCLEUS= ").append (spec.observedNucl).append (JSV.util.JSVTxt.newLine);
buffer.append ("##XUNITS= ").append (spec.isHZtoPPM () ? "HZ" : spec.getXUnits ()).append (JSV.util.JSVTxt.newLine);
buffer.append ("##YUNITS= ").append (spec.getYUnits ()).append (JSV.util.JSVTxt.newLine);
buffer.append ("##XFACTOR= ").append (JSV.util.JSVTxt.fixExponentInt (tmpXFactor)).append (JSV.util.JSVTxt.newLine);
buffer.append ("##YFACTOR= ").append (JSV.util.JSVTxt.fixExponentInt (tmpYFactor)).append (JSV.util.JSVTxt.newLine);
var f = (spec.isHZtoPPM () ? observedFreq : 1);
var xyCoords = spec.getXYCoords ();
buffer.append ("##FIRSTX= ").append (JSV.util.JSVTxt.fixExponentInt (xyCoords[startIndex].getXVal () * f)).append (JSV.util.JSVTxt.newLine);
buffer.append ("##FIRSTY= ").append (JSV.util.JSVTxt.fixExponentInt (xyCoords[startIndex].getYVal ())).append (JSV.util.JSVTxt.newLine);
buffer.append ("##LASTX= ").append (JSV.util.JSVTxt.fixExponentInt (xyCoords[endIndex].getXVal () * f)).append (JSV.util.JSVTxt.newLine);
buffer.append ("##NPOINTS= ").appendI ((Math.abs (endIndex - startIndex) + 1)).append (JSV.util.JSVTxt.newLine);
buffer.append ("##MINY= ").append (JSV.util.JSVTxt.fixExponentInt (minY)).append (JSV.util.JSVTxt.newLine);
buffer.append ("##MAXY= ").append (JSV.util.JSVTxt.fixExponentInt (maxY)).append (JSV.util.JSVTxt.newLine);
return buffer.toString ();
}, $fz.isPrivate = true, $fz), "JSV.common.JDXSpectrum,~S,~N,~N,~N,~N,~N,~N");
c$.areIntegers = $_M(c$, "areIntegers", 
($fz = function (xyCoords, startIndex, endIndex, factor, isX) {
for (var i = startIndex; i <= endIndex; i++) {
var x = (isX ? xyCoords[i].getXVal () : xyCoords[i].getYVal ()) / factor;
if (JSV.util.JSVTxt.isAlmostInteger (x)) return false;
}
return true;
}, $fz.isPrivate = true, $fz), "~A,~N,~N,~N,~B");
Clazz.defineStatics (c$,
"FACTOR_DIVISOR", 1000000);
});
