﻿/*
// (c) by Sitsanlis Ilias
// ΑΔΕΙΑ ΧΡΗΣΗΣ
// Αναφορά Δημιουργού - Μη Εμπορική Χρήση - Παρόμοια Διανομή 4.0 Διεθνές (CC BY-NC-SA 4.0)
// https://creativecommons.org/licenses/by-nc-sa/4.0/deed.el
// Οι παραπάνω γραμμές σε οποιαδήποτε διανομή δεν μπορεί να αφαιρεθούν.
*/

var canvas, stage, self, last, p1, p2, p3, p4, vectors, liquid, box, myDistance, pDistance, vecT, vecB, percent = .8,
    showVariablesFlag = !0,
    PI = Math.PI,
    toDeg = 180 / PI,
    toRad = PI / 180,
    X0 = 250,
    Y0 = 300,
    t = 0,
    dt = 1 / 120,
    isInSlowMotion = !1,
    dtInitial = dt,
    dtSlow = dt,
    factor = .5,
    playMovie = !1,
    framePlay = !1,
    xScale = 50,
    yScale = -xScale,
    FScale = .6,
    hgScale = xScale / 5,
    h = 1,
    ρ = 1e3,
    ρυ = 2e3,
    H = 5.1,
    Lt = 3,
    Lb = 3,
    pScale = .001,
    g = 10,
    p0 = 0,
    Yt = Y0 + H * yScale,
    Yb = Y0,
    container = new createjs.Shape,
    vectorDensity = 25,
    displayText = new createjs.Text;
displayText.font = "16px Trebuchet MS", displayText.x = 50, displayText.y = 375;
var hText = new createjs.Text;

function init() {
    stage = new createjs.Stage(document.getElementById("demoCanvas")), createjs.Touch.enable(stage), stage.enableMouseOver(), canvas = document.getElementById("demoCanvas"), self = stage, (p1 = makeDragPoint("#aaaaaa", "p1")).set({
        x: X0 - Lb / 2 * xScale,
        y: Y0
    }), p1.addEventListener("mousedown", mouseDownGen), p1.addEventListener("pressup", pressUpGen), p1.mouseChildren = !1, self.addChild(p1), (p2 = makeDragPoint("#aaaaaa", "p2")).set({
        x: X0 + Lb / 2 * xScale,
        y: Y0
    }), p2.addEventListener("mousedown", mouseDownGen), p2.addEventListener("pressup", pressUpGen), p2.mouseChildren = !1, self.addChild(p2), (p3 = makeDragPoint("#666666", "p3")).set({
        x: X0 - Lb / 2 * xScale,
        y: Yt
    }), p3.addEventListener("mousedown", mouseDownGen), p3.addEventListener("pressup", pressUpGen), p3.mouseChildren = !1, self.addChild(p3), (p4 = makeDragPoint("#666666", "p4")).set({
        x: X0 + Lb / 2 * xScale,
        y: Yt
    }), p4.addEventListener("mousedown", mouseDownGen), p4.addEventListener("pressup", pressUpGen), p4.mouseChildren = !1, self.addChild(p4), self.addChild(container), vectors = new createjs.Container, self.addChild(vectors), liquid = new createjs.Shape, self.addChild(liquid), self.addChild(displayText), self.addChild(hText), myDistance = new createjs.Shape, self.addChild(myDistance), pDistance = new createjs.Shape, self.addChild(pDistance), (vecT = createVector("#990099", !0, !1)).set({
        x: 100,
        y: 100
    }), vecT.addEventListener("mousedown", mouseDownVector), vecT.addEventListener("pressup", pressUpVector), vecT.mouseChildren = !1, vecT.rotation = 90, vecT.name = "vecT", self.addChild(vecT), (vecB = createVector("#990099", !0, !1)).set({
        x: 100,
        y: 100
    }), vecB.addEventListener("mousedown", mouseDownVector), vecB.addEventListener("pressup", pressUpVector), vecB.mouseChildren = !1, vecB.rotation = -90, vecB.name = "vecB", self.addChild(vecB), box = new createjs.Shape, self.addChild(box), initialize(), createjs.Ticker.setFPS(60), createjs.Ticker.addEventListener("tick", tick), canvas.style.visibility = "visible", document.getElementById("variables").style.visibility = "visible"
}

function initialize() {
    $("#pAtmSpinner").spinner().val(p0 / 1e3), $("#pAtmSlider").slider({
        value: 0
    }), $("#densitySpinner").spinner().val(ρ), $("#densitySlider").slider({
        value: 50
    }), $("#gravitySpinner").spinner().val(g), $("#gravitySlider").slider({
        value: g
    }), $("#files").val("4"), $("#files").selectmenu("refresh"), showHideVariables(), handleComplete(), drawBox(), createRegister(), restart()
}

function restart() {
    box.x = X0, box.y = p3.y - h * yScale, positions()
}

function tick(e) {
    playMovie && (framePlay && (framePlay = playMovie = !1), positions())
}

function positions() {
    if ($("#forces").is(":checked") ? (drawVectors(), vectors.visible = !0) : vectors.visible = !1, 0 != g) {
        var e = .4 * ρ / ρυ * h * xScale;
        last = e
    }
    drawPipeLines(last, box.y), displayText.text = "h = " + h.toFixed(1) + " m, p = " + ((p0 + ρ * g * Number(h.toFixed(1))) / 1e3).toFixed(1) + " kPa", myDistance.drawDistance("#000000", box.x + 5, box.y, box.x + 5, p3.y, 20), pDistance.drawDistance("#000000", X0 + 210, 160 + e, X0 + 210, 160 - e, 20), hText.x = box.x + 30, hText.y = box.y - h * xScale / 2 - 5, hText.visible = .2 < h, hText.text = "h";
    var t = pScale * (p0 + ρ * g * h);
    vecT.setScaleX(t), vecT.x = box.x, vecT.y = box.y, vecT.regX = t + 5, vecB.setScaleX(t), vecB.x = box.x, vecB.y = box.y, vecB.regX = t + 5, drawContainer(), stage.update()
}

function drawContainer() {
    var e = 1 - ρ / 1e3,
        t = Math.round(127 + 128 * e * .25),
        a = container.graphics;
    a.clear();
    var i = Math.atan2(p3.y - p1.y, p3.x - p1.x),
        s = Math.cos(i),
        n = Math.sin(i),
        r = Math.atan2(p4.y - p2.y, p4.x - p2.x),
        l = Math.cos(r),
        o = Math.sin(r);
    a.beginFill("#00" + t.toString(16) + "FF"), a.mt(p3.x, p3.y).lt(p1.x, p1.y).lt(p2.x, p2.y).lt(p4.x, p4.y).lt(p3.x, p3.y), a.endFill(), a.setStrokeStyle(2), a.beginStroke("#000000"), a.mt(p3.x + 10 * s, p3.y + 10 * n).lt(p1.x, p1.y).lt(p2.x, p2.y).lt(p4.x + 10 * l, p4.y + 10 * o), a.endStroke()
}

function drawVectors() {
    vectors.removeAllChildren(), addVectors(p2.x, p2.y, p4.x, p4.y, 1), addVectors(p1.x, p1.y, p3.x, p3.y, -1), addVectors(p1.x, p1.y, p2.x, p2.y, 0)
}

function addVectors(e, t, a, s, n) {
    var r = Math.sqrt((a - e) * (a - e) + (s - t) * (s - t)),
        l = Math.atan2(s - t, a - e),
        o = Math.floor(r / vectorDensity),
        d = vectorDensity / 2,
        p = Math.cos(l),
        c = Math.sin(l),
        x = r,
        v = (r - 2 * d) / o;
    if (0 < v && d <= x)
        for (i = d; i <= x; i += v) {
            var h = createVector("#990099", !1, !1);
            h.x = e + p * i, h.y = t + c * i, h.rotation = l * toDeg + 90, 0 != n ? h.setScaleX(n * pScale * (p0 + ρ * g * (t + c * i - s) / xScale)) : h.setScaleX(pScale * (p0 + ρ * g * Math.abs(p1.y - p3.y) / xScale)), vectors.addChild(h)
        }
}

function drawBox() {
    var e = box.graphics;
    e.setStrokeStyle(1), e.beginStroke("#000000"), e.beginFill("#ffffff"), e.r(0, 0, 30, 10), box.hitArea = new createjs.Shape, box.hitArea.graphics.beginStroke("#FFFFFF"), box.hitArea.graphics.beginFill("#FFFFFF"), box.hitArea.graphics.dc(15, 5, 15), box.hitArea.graphics.endStroke(), box.hitArea.alpha = .01, box.regX = 15, box.regY = 5, box.name = "box", box.addEventListener("mousedown", mouseDownGen), box.addEventListener("pressup", pressUpGen), box.mouseChildren = !1
}

function drawPipeLines(e, t) {
    var a = 20,
        i = 200,
        s = 30,
        n = liquid.graphics;
    n.clear(), n.setStrokeStyle(1), n.beginFill("#ffffff"), n.beginStroke("#ffffff"), n.mt(X0 - 2, t).lt(X0 - 2, a).lt(X0 + 2, a).lt(X0 + 2, t).lt(X0 - 2, t), n.endFill(), n.setStrokeStyle(.6), n.beginStroke("#000000");
    for (var r = -10; r <= 10; r++) n.mt(X0 + 180, 160 + r * hgScale).lt(X0 + 180 + 100, 160 + r * hgScale);
    n.setStrokeStyle(1), n.beginFill("#FF0000"), n.mt(X0 - 4 + i + 4, 160 + e).arc(X0 - 4 + i + 4 + s, 280, s, Math.PI, 0, !0).lt(X0 - 4 + i + 60 + 4, 160 - e), n.lt(X0 - 12 + i + 60 + 4 + 16, 160 - e).arc(X0 - 12 + i + s + 8 + 4, 280, 38, 0, Math.PI, !1).lt(X0 - 12 + i + 4, 160 + e), n.endFill(), n.beginStroke("#000000"), n.mt(X0 - 2, t).lt(X0 - 2, a).lt(X0 - 2 + i, a).lt(X0 - 2 + i, 160), n.lt(X0 - 4 + i + 4, 160).arc(X0 - 4 + i + 4 + s, 280, s, Math.PI, 0, !0).lt(X0 - 4 + i + 60 + 4, a), n.mt(X0 + 2, t).lt(X0 + 2, 24).lt(X0 + i - 6, 24).lt(X0 - 6 + i, 160), n.lt(X0 - 12 + i + 4, 160).arc(X0 - 12 + i + s + 8 + 4, 280, 38, Math.PI, 0, !0).lt(X0 - 12 + i + 60 + 4 + 16, a)
}
hText.font = "italic 12px Times New Roman";