Clazz.declarePackage ("JSV.common");
Clazz.load (["java.lang.Enum"], "JSV.common.ScriptToken", ["java.util.Hashtable", "JU.List", "$.SB", "JSV.common.ScriptTokenizer"], function () {
c$ = Clazz.decorateAsClass (function () {
this.tip = null;
Clazz.instantialize (this, arguments);
}, JSV.common, "ScriptToken", Enum);
$_M(c$, "getTip", 
function () {
return "  " + (this.tip === "T" ? "TRUE/FALSE/TOGGLE" : this.tip === "TF" ? "TRUE or FALSE" : this.tip === "C" ? "<color>" : this.tip);
});
Clazz.makeConstructor (c$, 
($fz = function () {
}, $fz.isPrivate = true, $fz));
Clazz.makeConstructor (c$, 
($fz = function (tip) {
this.tip = tip;
}, $fz.isPrivate = true, $fz), "~S");
c$.getScriptToken = $_M(c$, "getScriptToken", 
function (name) {
if (JSV.common.ScriptToken.htParams == null) {
($t$ = JSV.common.ScriptToken.htParams =  new java.util.Hashtable (), JSV.common.ScriptToken.prototype.htParams = JSV.common.ScriptToken.htParams, $t$);
for (var item, $item = 0, $$item = JSV.common.ScriptToken.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) JSV.common.ScriptToken.htParams.put (item.name (), item);

}var st = JSV.common.ScriptToken.htParams.get (name.toUpperCase ());
return (st == null ? JSV.common.ScriptToken.UNKNOWN : st);
}, "~S");
c$.getScriptTokenList = $_M(c$, "getScriptTokenList", 
function (name, isExact) {
name = name.toUpperCase ();
var list =  new JU.List ();
var st = JSV.common.ScriptToken.getScriptToken (name);
if (isExact) {
if (st != null) list.addLast (st);
} else {
for (var entry, $entry = JSV.common.ScriptToken.htParams.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) if (entry.getKey ().startsWith (name) && entry.getValue ().tip != null) list.addLast (entry.getValue ());

}return list;
}, "~S,~B");
c$.getValue = $_M(c$, "getValue", 
function (st, params, cmd) {
if (!params.hasMoreTokens ()) return "";
switch (st) {
default:
return JSV.common.ScriptTokenizer.nextStringToken (params, true);
case JSV.common.ScriptToken.CLOSE:
case JSV.common.ScriptToken.EXPORT:
case JSV.common.ScriptToken.INTEGRATION:
case JSV.common.ScriptToken.INTEGRATE:
case JSV.common.ScriptToken.JMOL:
case JSV.common.ScriptToken.LABEL:
case JSV.common.ScriptToken.LOAD:
case JSV.common.ScriptToken.PEAK:
case JSV.common.ScriptToken.PLOTCOLORS:
case JSV.common.ScriptToken.YSCALE:
case JSV.common.ScriptToken.GETPROPERTY:
return JSV.common.ScriptToken.removeCommandName (cmd);
case JSV.common.ScriptToken.SELECT:
case JSV.common.ScriptToken.OVERLAY:
case JSV.common.ScriptToken.VIEW:
case JSV.common.ScriptToken.ZOOM:
return JSV.common.ScriptToken.removeCommandName (cmd).$replace (',', ' ').trim ();
}
}, "JSV.common.ScriptToken,JSV.common.ScriptTokenizer,~S");
c$.removeCommandName = $_M(c$, "removeCommandName", 
($fz = function (cmd) {
var pt = cmd.indexOf (" ");
if (pt < 0) return "";
return cmd.substring (pt).trim ();
}, $fz.isPrivate = true, $fz), "~S");
c$.getKey = $_M(c$, "getKey", 
function (eachParam) {
var key = eachParam.nextToken ();
if (key.startsWith ("#") || key.startsWith ("//")) return null;
if (key.equalsIgnoreCase ("SET")) key = eachParam.nextToken ();
return key.toUpperCase ();
}, "JSV.common.ScriptTokenizer");
c$.getTokens = $_M(c$, "getTokens", 
function (value) {
var tokens =  new JU.List ();
var st =  new JSV.common.ScriptTokenizer (value, false);
while (st.hasMoreTokens ()) {
var s = JSV.common.ScriptTokenizer.nextStringToken (st, false);
if (s.startsWith ("//") || s.startsWith ("#")) break;
tokens.addLast (s);
}
return tokens;
}, "~S");
c$.getNameList = $_M(c$, "getNameList", 
function (list) {
if (list.size () == 0) return "";
var sb =  new JU.SB ();
for (var i = 0; i < list.size (); i++) sb.append (",").append (list.get (i).toString ());

return sb.toString ().substring (1);
}, "JU.List");
c$.htParams = null;
Clazz.defineEnumConstant (c$, "UNKNOWN", 0, []);
Clazz.defineEnumConstant (c$, "APPLETID", 1, []);
Clazz.defineEnumConstant (c$, "APPLETREADYCALLBACKFUNCTIONNAME", 2, []);
Clazz.defineEnumConstant (c$, "AUTOINTEGRATE", 3, ["TF"]);
Clazz.defineEnumConstant (c$, "BACKGROUNDCOLOR", 4, ["C"]);
Clazz.defineEnumConstant (c$, "CLOSE", 5, ["spectrumId or fileName or ALL"]);
Clazz.defineEnumConstant (c$, "COMPOUNDMENUON", 6, ["TF"]);
Clazz.defineEnumConstant (c$, "COORDCALLBACKFUNCTIONNAME", 7, []);
Clazz.defineEnumConstant (c$, "COORDINATESCOLOR", 8, ["C"]);
Clazz.defineEnumConstant (c$, "COORDINATESON", 9, ["T"]);
Clazz.defineEnumConstant (c$, "DEBUG", 10, ["TF"]);
Clazz.defineEnumConstant (c$, "DISPLAYFONTNAME", 11, ["fontName"]);
Clazz.defineEnumConstant (c$, "DISPLAY1D", 12, ["T"]);
Clazz.defineEnumConstant (c$, "DISPLAY2D", 13, ["T"]);
Clazz.defineEnumConstant (c$, "ENABLEZOOM", 14, ["T"]);
Clazz.defineEnumConstant (c$, "ENDINDEX", 15, []);
Clazz.defineEnumConstant (c$, "EXPORT", 16, ["[XY,DIF,DIFDUP,PAC,FIX,SQZ,AML,CML,JPG,PNG,SVG] \"filename\""]);
Clazz.defineEnumConstant (c$, "FINDX", 17, ["x-value"]);
Clazz.defineEnumConstant (c$, "GETPROPERTY", 18, ["[ALL] [propertyName]"]);
Clazz.defineEnumConstant (c$, "GETSOLUTIONCOLOR", 19, []);
Clazz.defineEnumConstant (c$, "GRIDCOLOR", 20, ["C"]);
Clazz.defineEnumConstant (c$, "GRIDON", 21, ["T"]);
Clazz.defineEnumConstant (c$, "HIDDEN", 22, ["TF"]);
Clazz.defineEnumConstant (c$, "HIGHLIGHTCOLOR", 23, ["C"]);
Clazz.defineEnumConstant (c$, "INTEGRALOFFSET", 24, ["percent"]);
Clazz.defineEnumConstant (c$, "INTEGRALRANGE", 25, ["percent"]);
Clazz.defineEnumConstant (c$, "INTEGRATE", 26, []);
Clazz.defineEnumConstant (c$, "INTEGRATION", 27, ["ON/OFF/AUTO/TOGGLE/MIN value/MARK ppm1-ppm2:norm,ppm3-ppm4,... (start with 0-0 to clear)"]);
Clazz.defineEnumConstant (c$, "INTEGRALPLOTCOLOR", 28, []);
Clazz.defineEnumConstant (c$, "INTEGRATIONRATIOS", 29, []);
Clazz.defineEnumConstant (c$, "INTERFACE", 30, []);
Clazz.defineEnumConstant (c$, "IRMODE", 31, ["A or T or TOGGLE"]);
Clazz.defineEnumConstant (c$, "JMOL", 32, ["...Jmol command..."]);
Clazz.defineEnumConstant (c$, "JSV", 33, []);
Clazz.defineEnumConstant (c$, "LABEL", 34, ["x y [color and/or \"text\"]"]);
Clazz.defineEnumConstant (c$, "LINK", 35, ["AB or ABC or NONE or ALL"]);
Clazz.defineEnumConstant (c$, "LOAD", 36, ["[APPEND] \"fileName\" [first] [last]; use \"\" to reload current file"]);
Clazz.defineEnumConstant (c$, "LOADFILECALLBACKFUNCTIONNAME", 37, []);
Clazz.defineEnumConstant (c$, "LOADIMAGINARY", 38, ["T/F - default is to NOT load imaginary spectra"]);
Clazz.defineEnumConstant (c$, "MENUON", 39, []);
Clazz.defineEnumConstant (c$, "OBSCURE", 40, []);
Clazz.defineEnumConstant (c$, "OVERLAY", 41, []);
Clazz.defineEnumConstant (c$, "OVERLAYSTACKED", 42, ["TF"]);
Clazz.defineEnumConstant (c$, "PEAK", 43, ["<type(IR,CNMR,HNMR,MS, etc)> id=xxx or \"match\" [ALL], for example: PEAK HNMR id=3"]);
Clazz.defineEnumConstant (c$, "PEAKCALLBACKFUNCTIONNAME", 44, []);
Clazz.defineEnumConstant (c$, "PEAKLIST", 45, [" Example: PEAKLIST threshold=20 [%, or include=10] skip=0 interpolate=parabolic [or NONE]"]);
Clazz.defineEnumConstant (c$, "PEAKTABCOLOR", 46, ["C"]);
Clazz.defineEnumConstant (c$, "PLOTAREACOLOR", 47, ["C"]);
Clazz.defineEnumConstant (c$, "PLOTCOLOR", 48, ["C"]);
Clazz.defineEnumConstant (c$, "PLOTCOLORS", 49, ["color,color,color,..."]);
Clazz.defineEnumConstant (c$, "PRINT", 50, []);
Clazz.defineEnumConstant (c$, "REVERSEPLOT", 51, ["T"]);
Clazz.defineEnumConstant (c$, "SCALEBY", 52, ["factor"]);
Clazz.defineEnumConstant (c$, "SCALECOLOR", 53, ["C"]);
Clazz.defineEnumConstant (c$, "SCRIPT", 54, ["filename.jsv"]);
Clazz.defineEnumConstant (c$, "SELECT", 55, ["spectrumID, spectrumID,..."]);
Clazz.defineEnumConstant (c$, "SETPEAK", 56, ["x (ppm) or NONE does peak search, unlike SETX -- NMR only"]);
Clazz.defineEnumConstant (c$, "SETX", 57, ["x (ppm) does no peak search, unlike SETPEAK -- NMR only"]);
Clazz.defineEnumConstant (c$, "SHIFTX", 58, ["dx (ppm) or NONE -- NMR only"]);
Clazz.defineEnumConstant (c$, "SHOWERRORS", 59, []);
Clazz.defineEnumConstant (c$, "SHOWINTEGRATION", 60, ["T"]);
Clazz.defineEnumConstant (c$, "SHOWKEY", 61, ["T"]);
Clazz.defineEnumConstant (c$, "SHOWMEASUREMENTS", 62, ["T"]);
Clazz.defineEnumConstant (c$, "SHOWMENU", 63, []);
Clazz.defineEnumConstant (c$, "SHOWPEAKLIST", 64, ["T"]);
Clazz.defineEnumConstant (c$, "SHOWPROPERTIES", 65, []);
Clazz.defineEnumConstant (c$, "SHOWSOURCE", 66, []);
Clazz.defineEnumConstant (c$, "SPECTRUM", 67, ["spectrumID"]);
Clazz.defineEnumConstant (c$, "SPECTRUMNUMBER", 68, []);
Clazz.defineEnumConstant (c$, "STACKOFFSETY", 69, ["percent"]);
Clazz.defineEnumConstant (c$, "STARTINDEX", 70, []);
Clazz.defineEnumConstant (c$, "SYNCCALLBACKFUNCTIONNAME", 71, []);
Clazz.defineEnumConstant (c$, "SYNCID", 72, []);
Clazz.defineEnumConstant (c$, "TEST", 73, []);
Clazz.defineEnumConstant (c$, "TITLEON", 74, ["T"]);
Clazz.defineEnumConstant (c$, "TITLEBOLDON", 75, ["T"]);
Clazz.defineEnumConstant (c$, "TITLECOLOR", 76, ["C"]);
Clazz.defineEnumConstant (c$, "TITLEFONTNAME", 77, ["fontName"]);
Clazz.defineEnumConstant (c$, "UNITSCOLOR", 78, ["C"]);
Clazz.defineEnumConstant (c$, "VERSION", 79, []);
Clazz.defineEnumConstant (c$, "VIEW", 80, ["spectrumID, spectrumID, ... Example: VIEW 3.1, 3.2  or  VIEW \"acetophenone\""]);
Clazz.defineEnumConstant (c$, "XSCALEON", 81, ["T"]);
Clazz.defineEnumConstant (c$, "XUNITSON", 82, ["T"]);
Clazz.defineEnumConstant (c$, "YSCALE", 83, ["[ALL] lowValue highValue"]);
Clazz.defineEnumConstant (c$, "YSCALEON", 84, ["T"]);
Clazz.defineEnumConstant (c$, "YUNITSON", 85, ["T"]);
Clazz.defineEnumConstant (c$, "WINDOW", 86, []);
Clazz.defineEnumConstant (c$, "ZOOM", 87, ["OUT or x1,x2 or x1,y1 x2,y2"]);
Clazz.defineEnumConstant (c$, "ZOOMBOXCOLOR", 88, []);
Clazz.defineEnumConstant (c$, "ZOOMBOXCOLOR2", 89, []);
});
