var canvas;
var cntx;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}

function initialiseEvents(){
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });

    $("#visualisation").on("mousedown touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });
} 

function initialiseGUI(){

}

function initialValues(){
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");
    imgBattery=document.getElementById("BatterySmall");
    /*BatteryWidth=$("#BatterySmall").width();
    BatteryHeight=$("#BatterySmall").height();*/

    imgLight=document.getElementById("lightOff");
    imgFPBoard=document.getElementById("FPBoard");
    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    //Φόντα οθόνης
    drawIntroImage();
    drawLogoImage();
    //Εικόνες
    drawIntroImage();
    if (IntroStep<IntroLastStep) drawButtonNext();
    if (IntroStep>1) drawButtonBack();
    if (IntroStep==PantognosthsStep) {
        drawTransparentSwitch();
        drawFPBoard();
        if (transparentOn){
            DrawWiresInternal();
            DrawBattery(BatteryLeft,BatteryTop,BatteryWidth,BatteryHeight);
        }
        DrawLight();
        DrawWires();
    }
    showUserPrompts();
}

function drawIntroImage(){
	var slctdIndx=IntroStep;
	var PictureOffset=FirstExampleStep;
	if(IntroStep==ExamplesStep || IntroStep==ExplanationStep){
		if(IntroStep==ExplanationStep) PictureOffset=FirstExplanationStep;
		var listIndex=document.getElementById("selections").selectedIndex;
		if(listIndex!=0){
			slctdIndx=PictureOffset-1+listIndex;
		}
	}
    Intro=document.getElementById("img"+slctdIndx);
	
    var picTop=(height-Intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+Intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
    cntx.drawImage(Intro,1,picTop);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (buttonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function buttonNextHover(){
    if (mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function drawButtonBack(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (buttonBackHover()){
        cntx.drawImage(imgBackStepSelected,BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled,BackStepLeft,BackStepTop);
    }
}

function buttonBackHover(){
    if (mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){
    if(IntroStep==PantognosthsStep){
    	CorrectAnswer=false;
        if(LeftWireHover()){
            DraggingLeftWire=true;
        }
        else if(RightWireHover()){
            DraggingRightWire=true;
        }
    }
}

function handleMouseMove(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    if(IntroStep==PantognosthsStep){
        if (mx>=transparentSwitchLeft && mx<transparentSwitchLeft+switchSize && my>=transparentSwitchTop && my<transparentSwitchTop+switchSize){
            transparentSwitchHover=true;
        }
        else {
            transparentSwitchHover=false;
        }
        
        if(LeftWireHover() || RightWireHover()){
            canvas.style.cursor="pointer";
        }
        else{
            canvas.style.cursor="default";
        }
        if(DraggingLeftWire){
            if (my>TopPanelHeight && my<BottomPanelTop){
                LeftWireX=mx;
                LeftWireY=my;
            }
        }
        else if(DraggingRightWire){
            if(my>TopPanelHeight && my<BottomPanelTop){
                RightWireX=mx;
                RightWireY=my;
            }
        }
    }

    drawBasicScreen();
    //console.log("mx="+mx+" , my="+my);
}

function handleMouseUp(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        showHTML();
    }
    if(mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && IntroStep<IntroLastStep) {
        IntroStep++;
        ResetWires();
        LoadChoiceList();
        drawBasicScreen();
    }
    if(mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && IntroStep>1) {
        IntroStep--;
        ResetWires();
        LoadChoiceList();
        drawBasicScreen();
    }
    if(IntroStep==PantognosthsStep){
        if(DraggingLeftWire){
            DraggingLeftWire=false;
            CheckLeftConnection();
        }
        if(DraggingRightWire){
            DraggingRightWire=false;
            CheckRightConnection();
        }
        CorrectAnswer=false;
        if(Math.abs(LeftWireX-RightWireX)>100 && LeftConnection>-1 && LeftConnection<8 && RightConnection>-1 && RightConnection<8){
            if(RightWireX-LeftWireX>100){
            	CorrectAnswer=Pair[LeftConnection]==RightConnection;
            }
            else if(LeftWireX-RightWireX>100){
            	CorrectAnswer=Pair[RightConnection]==LeftConnection;
            }
        }
        if(transparentSwitchHover){
            transparentOn=!transparentOn;
            wireOffsetY=maxWireOffsetY-wireOffsetY;
        }
        drawBasicScreen();
    }
}

function showUserPrompts(){
    var vTxtOffset=15;
    var promptYCoord;
    promptYCoord=BottomPanelTop+15;
    if (IntroStep==ExamplesStep) {
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Για να δεις διάφορα παραδείγματα μηχανών που κάνουν ό,τι και ο άνθρωπος");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"χρησιμοποιήσε την πτυσσόμενη λίστα που βλέπεις εδώ.");
        promptYCoord=promptYCoord+2*vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Όταν είσαι έτοιμος, προχώρησε στο επόμενο βήμα.");
    }
    else if (IntroStep==ExplanationStep) {
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Για να καταλάβεις λίγο καλύτερα τη λειτουργία του Φωτεινού Παντογνώστη.");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"χρησιμοποιήσε την πτυσσόμενη λίστα που βλέπεις εδώ.");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Ταυτόχρονα θα πάρεις μια ιδέα για τη λειτουργία του Ηλεκτρονικού Υπολογιστή.");
        promptYCoord=promptYCoord+2*vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Εναλλακτικά, μπορείς να παίξεις με ένα διαφανή Φωτεινό Παντογνώστη στην επόμενη σελίδα");
    }
    else if (IntroStep==PantognosthsStep) {
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Πιάσε με το ποντίκι σου τα καλώδια που θα βρεις στην κορυφή του Φωτεινού Παντογνώστη.");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Μετακίνησέ τα μέχρι τα ανοίγματα της αντίστοχης στήλης.");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"Αν θες να δεις τι γίνεται κάτω από το χαρτί,");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",70,promptYCoord,"κάνε το Φωτεινό Παντογνώστη διαφανή.");
    }
}

function drawTransparentSwitch(){
    if(transparentSwitchHover){
        cntx.strokeStyle="#0000ff";
        cntx.fillStyle="#ffffff";
    }
    else{
        cntx.strokeStyle="#000000";
        cntx.fillStyle="#e1e1e1";
    }
    cntx.fillRect(transparentSwitchLeft,transparentSwitchTop,switchSize,switchSize);
    cntx.beginPath();
    cntx.rect(transparentSwitchLeft,transparentSwitchTop,switchSize,switchSize);
    if(transparentOn){
        cntx.moveTo(transparentSwitchLeft+switchSize,transparentSwitchTop+switchSize);
        cntx.lineTo(transparentSwitchLeft,transparentSwitchTop);
        cntx.moveTo(transparentSwitchLeft+switchSize,transparentSwitchTop);
        cntx.lineTo(transparentSwitchLeft,transparentSwitchTop+switchSize);
    }
    cntx.stroke();
    cnvsWrite(LetterColor,fontSize-2,"Arial",transparentSwitchLeft+switchSize+captionPadding,transparentSwitchTop+switchSize,"Διαφανής Παντογνώστης");
}

function ResetWires(){
    LeftWireX=200;
    LeftWireY=LeftWY1;
    RightWireX=596;
    RightWireY=RightWY1;
    LeftConnection=-1;
    RightConnection=-1;
    CorrectAnswer=false;
}

function DrawWires(){
    var Grey=150,Width=6;
    cntx.beginPath();
    cntx.strokeStyle="#000000";
    cntx.fillStyle="#000000";
    //Σχεδίαση αριστερού καλωδίου
    cntx.fillRect(LeftWX1,LeftWY1-Width/2-wireOffsetY,LeftWX2-LeftWX1,Width);
    cntx.fillRect(LeftWX1-Width/2,Math.min(LeftWY1,LeftWireY)-Width/2-wireOffsetY,Width,Math.abs(LeftWireY-LeftWY1)+Width+wireOffsetY);
    cntx.fillRect(Math.min(LeftWX1,LeftWireX),LeftWireY-Width/2,Math.abs(LeftWireX-LeftWX1),Width);
    if (CorrectAnswer && transparentOn){
        cntx.strokeStyle="#ffff00";
        cntx.moveTo(LeftWX2,LeftWY1-wireOffsetY);
        cntx.lineTo(LeftWX1,LeftWY1-wireOffsetY);
        cntx.moveTo(LeftWX1,LeftWY1-wireOffsetY);
        cntx.lineTo(LeftWX1,LeftWireY);
        cntx.moveTo(LeftWX1,LeftWireY);
        cntx.lineTo(LeftWireX,LeftWireY);
    }
    cntx.fillStyle="rgb("+Grey+","+Grey+","+Grey+")";
    cntx.arc(LeftWireX,LeftWireY,PlugRadius,0,2*Math.PI);
    if(CorrectAnswer && transparentOn){
        cntx.strokeStyle="#ffff00";
    }
    else{
        cntx.strokeStyle="#000000";
    }
    cntx.arc(LeftWireX,LeftWireY,PlugRadius,0,2*Math.PI);
    //Σχεδίαση δεξιού καλωδίου
    cntx.strokeStyle="#000000";
    cntx.fillStyle="#000000";
    cntx.fillRect(RightWX1,RightWY1-Width/2,27,Width);
    cntx.fillRect(RightWX2-Width/2,Math.min(RightWY1,RightWireY)-Width/2,Width,Math.abs(RightWireY-RightWY1)+Width);
    cntx.fillRect(Math.min(RightWX2,RightWireX),RightWireY-Width/2,Math.abs(RightWireX-RightWX2),Width);
    if(CorrectAnswer && transparentOn){
        cntx.strokeStyle="#ffff00";
        cntx.moveTo(RightWX1,RightWY1);
        cntx.lineTo(RightWX2,RightWY1);
        cntx.moveTo(RightWX2,RightWY1);
        cntx.lineTo(RightWX2,RightWireY);
        cntx.moveTo(RightWX2,RightWireY);
        cntx.lineTo(RightWireX,RightWireY);
    }
    cntx.stroke();
    cntx.fill();
    cntx.fillStyle="rgb("+Grey+","+Grey+","+Grey+")";
    cntx.arc(RightWireX,RightWireY,PlugRadius,0,2*Math.PI);
    cntx.fill();
    cntx.beginPath();
    if(CorrectAnswer && transparentOn){
        cntx.strokeStyle="#ffff00";
    }
    else{
        cntx.strokeStyle="#000000";
    }
    cntx.arc(RightWireX,RightWireY,PlugRadius,0,2*Math.PI);
    cntx.stroke();
    cntx.fill();
}

function DrawWiresInternal(){
    var i,X1,Y1,X2,Y2;
    cntx.lineWidth=5;
    cntx.beginPath();
    cntx.strokeStyle="#000000";
    for(i=0;i<8;i++){
        X1=354;
        Y1=164+i*40+8;
        X2=450;
        Y2=164+Pair[i]*40+8;
        cntx.moveTo(X1,Y1);
        cntx.lineTo(X2,Y2);
    }
    //Μπαταρία με αριστερό καλώδιο
    cntx.moveTo(LeftWX1,LeftWY1-wireOffsetY);
    cntx.lineTo(BatteryLeft,LeftWY1-wireOffsetY);
    //Μπαταρία με λαμπτήρα
    cntx.moveTo(BatteryLeft+BatteryWidth,BatteryTop+BatteryHeight/2);
    cntx.lineTo(LightLeft+10,BatteryTop+BatteryHeight/2);
    //Λαμπτήρας με δεξί καλώδιο
    cntx.moveTo(LightLeft+LightWidth/2,RightWY1);
    cntx.lineTo(RightWX2,RightWY1);
    cntx.stroke();
    cntx.lineWidth=1;
    if(CorrectAnswer){
        cntx.beginPath();
        X1=353;
        X2=449;
        Y1=164+LeftConnection*40+8;
        Y2=164+Pair[LeftConnection]*40+8;
        if(LeftWireX>RightWireX){
            Y1=164+RightConnection*40+8;
            Y2=164+Pair[RightConnection]*40+8;
        }
        cntx.strokeStyle="#ffff00";
        cntx.moveTo(X1,Y1);
        cntx.lineTo(X2,Y2);

        //Μπαταρία με αριστερό καλώδιο
        cntx.moveTo(LeftWX1,LeftWY1-wireOffsetY);
        cntx.lineTo(BatteryLeft,LeftWY1-wireOffsetY);
        //Μπαταρία με λαμπτήρα
        cntx.moveTo(BatteryLeft+BatteryWidth,BatteryTop+BatteryHeight/2);
        cntx.lineTo(LightLeft+10,BatteryTop+BatteryHeight/2);
        //Λαμπτήρας με δεξί καλώδιο
        cntx.moveTo(LightLeft+LightWidth/2,RightWY1);
        cntx.lineTo(RightWX2,RightWY1);
        cntx.stroke();
    }
}

function DrawBattery(LeftCoord,TopCoord,WidthToUse,HeightToUse){
    cntx.drawImage(imgBattery,BatteryLeft,BatteryTop);
}

function DrawLight(){
    if(CorrectAnswer){
        imgLight=document.getElementById("lightOn");       
    }
    else{
        imgLight=document.getElementById("lightOff");
    }
    /*LightWidth=$("#lightOff").width();
    LightHeight=$("#lightOff").height();*/
    LightLeft=(appletWidth-LightWidth)/2;
    LightTop=TopPanelHeight+20;
    cntx.drawImage(imgLight,LightLeft,LightTop);
}

function drawFPBoard(){
    var FPBoardWidth=imgFPBoard.naturalWidth;
    var FPBoardTop=TopPanelHeight+70;
    var FPBoardLeft=(appletWidth-FPBoardWidth)/2;
    cntx.drawImage(imgFPBoard,FPBoardLeft,FPBoardTop);
}

function LeftWireHover(){
    if(Math.abs(LeftWireX-mx)<=8 && Math.abs(LeftWireY-my)<=8){
        return true;
    }
    else{
        return false;
    }
}

function RightWireHover(){
    if(Math.abs(RightWireX-mx)<=8 && Math.abs(RightWireY-my)<=8){
        return true;
    }
    else{
        return false;
    }
}

function CheckLeftConnection(){
    var Connection;
    if(LeftWireX>=335 && LeftWireX<=353){
        Connection=parseInt((LeftWireY-164)/40);
        if (164+Connection*40<=LeftWireY && LeftWireY<=164+Connection*40+16){
            LeftConnection=Connection;
        }
        else{
            LeftConnection=-1;
        }
    }
    else if(LeftWireX>=450 && LeftWireX<=468){
        Connection=parseInt((LeftWireY-164)/40);
        if (164+Connection*40<=LeftWireY && LeftWireY<=164+Connection*40+16){
            LeftConnection=Connection;
        }
        else{
            LeftConnection=-1;
        }
    }
    else {
        LeftConnection=-1;
    }
}

function CheckRightConnection(){
    var Connection;
    if(RightWireX>=450 && RightWireX<=468){
        Connection=parseInt((RightWireY-164)/40);
        if(164+Connection*40<=RightWireY && RightWireY<=164+Connection*40+16){
            RightConnection=Connection;
        }
        else{
            RightConnection=-1;
        }
    }
    else if(RightWireX>=335 && RightWireX<=353){
        Connection=parseInt((RightWireY-164)/40);
        if(164+Connection*40<=RightWireY && RightWireY<=164+Connection*40+16){
            RightConnection=Connection;
        }
        else{
            RightConnection=-1;
        }
    }
    else {
        RightConnection=-1;
    }
}

function LoadChoiceList(){
	var newHTML="<select id='selections' onchange='drawBasicScreen()'>";
	if(IntroStep==ExamplesStep){
		newHTML+="<option value='(αρχική)'>(αρχική)</option>";
		newHTML+="<option value='Πρώτη Ομάδα'>Πρώτη Ομάδα</option>";
		newHTML+="<option value='Δεύτερη Ομάδα'>Δεύτερη Ομάδα</option>";
		newHTML+="<option value='Τρίτη Ομάδα'>Τρίτη Ομάδα</option>";
		newHTML+="</select>";
	}
	else if(IntroStep==ExplanationStep){
		newHTML+="<option value='(αρχική)'>(αρχική)</option>";
		newHTML+="<option value='Λειτουργία'>Λειτουργία</option>";
		newHTML+="<option value='Περιεχόμενα'>Περιεχόμενα</option>";
		newHTML+="<option value='Τρόπος παιχνιδιού'>Τρόπος παιχνιδιού</option>";
		newHTML+="<option value='Μηχανισμός (α)'>Μηχανισμός (α)</option>";
		newHTML+="<option value='Μηχανισμός (β)'>Μηχανισμός (β)</option>";
		newHTML+="<option value='Μηχανές υπολογισμών'>Μηχανές υπολογισμών</option>";
		newHTML+="<option value='Υπολογιστής'>Υπολογιστής</option>";
		newHTML+="</select>";
	}
	else{
		newHTML="";
	}
	document.getElementById("selectionDiv").innerHTML=newHTML;
}