Clazz.declarePackage ("JSV.export");
Clazz.load (["JSV.export.FormContext"], "JSV.export.FormExporter", ["java.io.FileWriter", "$.IOException", "java.text.SimpleDateFormat", "java.util.Calendar", "JSV.common.JSVFileManager", "J.util.Logger"], function () {
c$ = Clazz.decorateAsClass (function () {
this.context = null;
this.errMsg = null;
this.outputFile = null;
this.writer = null;
this.now = null;
this.formatter = null;
this.currentTime = null;
Clazz.instantialize (this, arguments);
}, JSV["export"], "FormExporter");
Clazz.prepareFields (c$, function () {
this.context =  new JSV["export"].FormContext ();
});
$_M(c$, "initForm", 
function (fileName) {
this.outputFile = fileName;
var now = java.util.Calendar.getInstance ();
var formatter =  new java.text.SimpleDateFormat ("yyyy/MM/dd HH:mm:ss.SSSS ZZZZ");
this.currentTime = formatter.format (now.getTime ());
}, "~S");
$_M(c$, "writeForm", 
function (templateFile) {
var error =  new Array (1);
var template = JSV.common.JSVFileManager.getResourceString (this, templateFile, error);
if (template == null) {
J.util.Logger.error (error[0]);
return error[0];
}this.errMsg = this.context.setTemplate (template);
if (this.errMsg != null) {
J.util.Logger.error (this.errMsg);
return this.errMsg;
}var writer = (this.outputFile == null ? null :  new java.io.FileWriter (this.outputFile));
this.errMsg = this.context.merge (writer);
if (writer == null) return this.errMsg;
if (this.errMsg != null) {
J.util.Logger.error (this.errMsg);
throw  new java.io.IOException (this.errMsg);
}try {
writer.flush ();
writer.close ();
} catch (ioe) {
if (Clazz.exceptionOf (ioe, java.io.IOException)) {
} else {
throw ioe;
}
}
return " OK";
}, "~S");
});
