Clazz.declarePackage ("JSV.common");
Clazz.load (null, "JSV.common.JSVFileManager", ["java.io.BufferedInputStream", "$.BufferedReader", "$.File", "$.FileInputStream", "$.IOException", "$.InputStreamReader", "$.StringReader", "java.net.URL", "java.util.Hashtable", "JU.SB", "JSV.common.JSVersion", "JSV.util.JSVEscape", "J.api.Interface", "J.util.Logger", "$.Parser", "$.Txt"], function () {
c$ = Clazz.declareType (JSV.common, "JSVFileManager");
$_M(c$, "isApplet", 
function () {
return (JSV.common.JSVFileManager.appletDocumentBase != null);
});
c$.getFileAsString = $_M(c$, "getFileAsString", 
function (name, appletDocumentBase) {
if (name == null) return null;
var br;
var sb =  new JU.SB ();
try {
br = JSV.common.JSVFileManager.getBufferedReaderFromName (name, appletDocumentBase, null);
var line;
while ((line = br.readLine ()) != null) {
sb.append (line);
sb.appendC ('\n');
}
br.close ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
return null;
} else {
throw e;
}
}
return sb.toString ();
}, "~S,java.net.URL");
c$.getBufferedReaderForInputStream = $_M(c$, "getBufferedReaderForInputStream", 
function ($in) {
try {
return  new java.io.BufferedReader ( new java.io.InputStreamReader ($in, "UTF-8"));
} catch (e) {
if (Clazz.exceptionOf (e, java.io.UnsupportedEncodingException)) {
return null;
} else {
throw e;
}
}
}, "java.io.InputStream");
c$.getBufferedReaderForString = $_M(c$, "getBufferedReaderForString", 
function (data) {
return (data == null ? null :  new java.io.BufferedReader ( new java.io.StringReader (data)));
}, "~S");
c$.getBufferedReaderFromName = $_M(c$, "getBufferedReaderFromName", 
function (name, appletDocumentBase, startCode) {
if (name == null) throw  new java.io.IOException ("Cannot find " + name);
var path = JSV.common.JSVFileManager.classifyName (name, appletDocumentBase);
return JSV.common.JSVFileManager.getUnzippedBufferedReaderFromName (path, appletDocumentBase, startCode);
}, "~S,java.net.URL,~S");
c$.classifyName = $_M(c$, "classifyName", 
function (name, appletDocumentBase) {
if (appletDocumentBase != null) {
if (name.indexOf (":\\") == 1 || name.indexOf (":/") == 1) name = "file:///" + name;
var url =  new java.net.URL (appletDocumentBase, name, null);
return url.toString ();
}if (JSV.common.JSVFileManager.isURL (name)) {
var url =  new java.net.URL (Clazz.castNullAs ("java.net.URL"), name, null);
return url.toString ();
}var file =  new java.io.File (name);
return file.getAbsolutePath ();
}, "~S,java.net.URL");
c$.isURL = $_M(c$, "isURL", 
function (name) {
for (var i = JSV.common.JSVFileManager.urlPrefixes.length; --i >= 0; ) if (name.startsWith (JSV.common.JSVFileManager.urlPrefixes[i])) return true;

return false;
}, "~S");
c$.urlTypeIndex = $_M(c$, "urlTypeIndex", 
function (name) {
for (var i = 0; i < JSV.common.JSVFileManager.urlPrefixes.length; ++i) {
if (name.startsWith (JSV.common.JSVFileManager.urlPrefixes[i])) {
return i;
}}
return -1;
}, "~S");
c$.isLocal = $_M(c$, "isLocal", 
function (fileName) {
if (fileName == null) return false;
var itype = JSV.common.JSVFileManager.urlTypeIndex (fileName);
return (itype < 0 || itype == 4);
}, "~S");
c$.getUnzippedBufferedReaderFromName = $_M(c$, "getUnzippedBufferedReaderFromName", 
($fz = function (name, appletDocumentBase, startCode) {
var subFileList = null;
if (name.indexOf ("|") >= 0) {
subFileList = J.util.Txt.split (name, "|");
if (subFileList != null && subFileList.length > 0) name = subFileList[0];
}if (name.startsWith ("http://SIMULATION/")) return JSV.common.JSVFileManager.getBufferedReaderForString (JSV.common.JSVFileManager.getSimulationJCampDX (name.substring ("http://SIMULATION/".length)));
if (JSV.common.JSVFileManager.viewer.isApplet) {
var ret = JSV.common.JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream ( new java.net.URL (Clazz.castNullAs ("java.net.URL"), name, null), null, null);
if (Clazz.instanceOf (ret, JU.SB) || Clazz.instanceOf (ret, String)) {
return  new java.io.BufferedReader ( new java.io.StringReader (ret.toString ()));
} else if (JSV.util.JSVEscape.isAB (ret)) {
return  new java.io.BufferedReader ( new java.io.StringReader ( String.instantialize (ret)));
} else {
return  new java.io.BufferedReader ( new java.io.InputStreamReader (ret, "UTF-8"));
}}var $in = JSV.common.JSVFileManager.getInputStream (name, true, appletDocumentBase);
var bis =  new java.io.BufferedInputStream ($in);
$in = bis;
if (JSV.common.JSVFileManager.isZipFile (bis)) return (J.api.Interface.getInterface ("JSV.util.JSVZipUtil")).newJSVZipFileSequentialReader ($in, subFileList, startCode);
if (JSV.common.JSVFileManager.isGzip (bis)) $in = (J.api.Interface.getInterface ("JSV.util.JSVZipUtil")).newGZIPInputStream ($in);
return  new java.io.BufferedReader ( new java.io.InputStreamReader ($in, "UTF-8"));
}, $fz.isPrivate = true, $fz), "~S,java.net.URL,~S");
c$.isZipFile = $_M(c$, "isZipFile", 
function (is) {
var abMagic =  Clazz.newByteArray (4, 0);
is.mark (5);
var countRead = is.read (abMagic, 0, 4);
is.reset ();
return (countRead == 4 && abMagic[0] == 0x50 && abMagic[1] == 0x4B && abMagic[2] == 0x03 && abMagic[3] == 0x04);
}, "java.io.InputStream");
c$.isGzip = $_M(c$, "isGzip", 
($fz = function (is) {
var abMagic =  Clazz.newByteArray (4, 0);
is.mark (5);
var countRead = is.read (abMagic, 0, 4);
is.reset ();
return (countRead == 4 && abMagic[0] == 0x1F && abMagic[1] == 0x8B);
}, $fz.isPrivate = true, $fz), "java.io.InputStream");
c$.getInputStream = $_M(c$, "getInputStream", 
function (name, showMsg, appletDocumentBase) {
var isURL = JSV.common.JSVFileManager.isURL (name);
var isApplet = (appletDocumentBase != null);
var $in = null;
var post = null;
var iurl;
if (isURL && (iurl = name.indexOf ("?POST?")) >= 0) {
post = name.substring (iurl + 6);
name = name.substring (0, iurl);
}if (isApplet || isURL) {
var url =  new java.net.URL (appletDocumentBase, name, null);
J.util.Logger.info ("JSVFileManager opening URL " + url + (post == null ? "" : " with POST of " + post.length + " bytes"));
var ret = JSV.common.JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream (url, null, post);
if (Clazz.instanceOf (ret, String)) {
J.util.Logger.info ("JSVFielManager could not get this URL:" + ret);
} else {
$in = ret;
}} else {
if (showMsg) J.util.Logger.info ("JSVFileManager opening file " + name);
var file =  new java.io.File (name);
$in =  new java.io.FileInputStream (file);
}return $in;
}, "~S,~B,java.net.URL");
c$.getSimulationJCampDX = $_M(c$, "getSimulationJCampDX", 
($fz = function (name) {
if (JSV.common.JSVFileManager.htSimulate == null) ($t$ = JSV.common.JSVFileManager.htSimulate =  new java.util.Hashtable (), JSV.common.JSVFileManager.prototype.htSimulate = JSV.common.JSVFileManager.htSimulate, $t$);
var key = "" + name.substring (name.indexOf ("V2000") + 1).hashCode ();
var jcamp = JSV.common.JSVFileManager.htSimulate.get (key);
if (jcamp == null) {
System.out.println ("creating " + name);
var isInline = name.startsWith ("MOL=");
var molFile = (isInline ? J.util.Txt.simpleReplace (name.substring (4), "\\n", "\n") : JSV.common.JSVFileManager.getFileAsString (J.util.Txt.simpleReplace (JSV.common.JSVFileManager.nciResolver, "%FILE", JSV.util.JSVEscape.escapeUrl (name.substring (1))), null));
var pt = molFile.indexOf ("\n");
molFile = "/JSpecView " + JSV.common.JSVersion.VERSION + molFile.substring (pt);
molFile = J.util.Txt.simpleReplace (molFile, "?", "_");
var json = JSV.common.JSVFileManager.getFileAsString (JSV.common.JSVFileManager.nmrdbServer + molFile, null);
System.out.println (json);
json = J.util.Txt.simpleReplace (json, "\\r\\n", "\n");
json = J.util.Txt.simpleReplace (json, "\\t", "\t");
json = J.util.Txt.simpleReplace (json, "\\n", "\n");
molFile = JSV.common.JSVFileManager.getQuotedJSONAttribute (json, "molfile", null);
var xml = JSV.common.JSVFileManager.getQuotedJSONAttribute (json, "xml", null);
xml = J.util.Txt.simpleReplace (xml, "</", "\n</");
xml = J.util.Txt.simpleReplace (xml, "><", ">\n<");
xml = J.util.Txt.simpleReplace (xml, "\\\"", "\"");
jcamp = JSV.common.JSVFileManager.getQuotedJSONAttribute (json, "jcamp", null);
jcamp = "##TITLE=" + (isInline ? "JMOL SIMULATION" : name) + "\n" + jcamp.substring (jcamp.indexOf ("\n##") + 1);
J.util.Logger.info (jcamp.substring (0, jcamp.indexOf ("##XYDATA") + 40) + "...");
pt = 0;
pt = jcamp.indexOf ("##.");
var id = name;
var pt1 = id.indexOf ("id='");
if (isInline && pt1 > 0) id = id.substring (pt1 + 4, (id + "'").indexOf ("'", pt1 + 4));
jcamp = jcamp.substring (0, pt) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + JSV.util.JSVEscape.eS (id) + "\n type=\"MOL\">\n" + molFile + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + xml + "\n" + jcamp.substring (pt);
JSV.common.JSVFileManager.htSimulate.put (key, jcamp);
}return jcamp;
}, $fz.isPrivate = true, $fz), "~S");
c$.getResource = $_M(c$, "getResource", 
($fz = function (object, fileName, error) {
var url = null;
try {
if ((url = object.getClass ().getResource ("resources/" + fileName)) == null) error[0] = "Couldn't find file: " + fileName;
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
error[0] = "Exception " + e.getMessage () + " in getResource " + fileName;
} else {
throw e;
}
}
return url;
}, $fz.isPrivate = true, $fz), "~O,~S,~A");
c$.getResourceString = $_M(c$, "getResourceString", 
function (object, name, error) {
var url = JSV.common.JSVFileManager.getResource (object, name, error);
if (url == null) {
error[0] = "Error loading resource " + name;
return null;
}var sb =  new JU.SB ();
try {
var br =  new java.io.BufferedReader ( new java.io.InputStreamReader (url.getContent (), "UTF-8"));
var line;
while ((line = br.readLine ()) != null) sb.append (line).append ("\n");

br.close ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
error[0] = e.getMessage ();
} else {
throw e;
}
}
var str = sb.toString ();
return str;
}, "~O,~S,~A");
c$.getJmolFilePath = $_M(c$, "getJmolFilePath", 
function (filePath, appletDocumentBase) {
try {
filePath = JSV.common.JSVFileManager.classifyName (filePath, appletDocumentBase);
} catch (e) {
if (Clazz.exceptionOf (e, java.net.MalformedURLException)) {
return null;
} else {
throw e;
}
}
return (appletDocumentBase == null ? filePath.$replace ('\\', '/') : filePath);
}, "~S,java.net.URL");
c$.getName = $_M(c$, "getName", 
function (fileName) {
if (fileName == null) return "String" + (($t$ = ++ JSV.common.JSVFileManager.stringCount, JSV.common.JSVFileManager.prototype.stringCount = JSV.common.JSVFileManager.stringCount, $t$));
if (JSV.common.JSVFileManager.isURL (fileName)) {
try {
if (fileName.startsWith ("http://SIMULATION/") && fileName.length > 100) return fileName.substring (0, Math.min (fileName.length, 30)) + "...";
var name = ( new java.net.URL (Clazz.castNullAs ("java.net.URL"), fileName, null)).getFile ();
return name.substring (name.lastIndexOf ('/') + 1);
} catch (e) {
if (Clazz.exceptionOf (e, java.net.MalformedURLException)) {
return null;
} else {
throw e;
}
}
}return (JSV.common.JSVFileManager.viewer.isApplet ? fileName : ( new java.io.File (fileName)).getName ());
}, "~S");
c$.getQuotedJSONAttribute = $_M(c$, "getQuotedJSONAttribute", 
function (json, key1, key2) {
if (key2 == null) key2 = key1;
key1 = "\"" + key1 + "\":";
key2 = "\"" + key2 + "\":";
var pt1 = json.indexOf (key1);
var pt2 = json.indexOf (key2, pt1);
return (pt1 < 0 || pt2 < 0 ? null : J.util.Parser.getQuotedStringAt (json, pt2 + key2.length));
}, "~S,~S,~S");
c$.setDocumentBase = $_M(c$, "setDocumentBase", 
function (v, documentBase) {
($t$ = JSV.common.JSVFileManager.viewer = v, JSV.common.JSVFileManager.prototype.viewer = JSV.common.JSVFileManager.viewer, $t$);
($t$ = JSV.common.JSVFileManager.appletDocumentBase = documentBase, JSV.common.JSVFileManager.prototype.appletDocumentBase = JSV.common.JSVFileManager.appletDocumentBase, $t$);
}, "JSV.common.JSViewer,java.net.URL");
Clazz.defineStatics (c$,
"SIMULATION_PROTOCOL", "http://SIMULATION/",
"appletDocumentBase", null,
"viewer", null,
"jsDocumentBase", "");
c$.urlPrefixes = c$.prototype.urlPrefixes = ["http:", "https:", "ftp:", "http://SIMULATION/", "file:"];
Clazz.defineStatics (c$,
"URL_LOCAL", 4,
"nciResolver", "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True",
"nmrdbServer", "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=",
"htSimulate", null,
"stringCount", 0);
});
