Clazz.declarePackage ("JSV.export");
Clazz.load (["JSV.api.ExportInterface"], "JSV.export.Exporter", ["java.io.ByteArrayOutputStream", "$.FileOutputStream", "$.FileWriter", "JSV.common.Annotation", "$.ExportType", "$.JSVFileManager", "$.ScriptToken", "JSV.export.AMLExporter", "$.CMLExporter", "$.JDXExporter", "$.SVGExporter", "JSV.util.JSVTxt", "J.io.Base64", "J.util.Logger", "$.Txt"], function () {
c$ = Clazz.declareType (JSV["export"], "Exporter", null, JSV.api.ExportInterface);
Clazz.makeConstructor (c$, 
function () {
});
Clazz.overrideMethod (c$, "exportCmd", 
function (jsvp, tokens, forInkscape) {
var mode = "XY";
var fileName = null;
switch (tokens.size ()) {
default:
return "EXPORT what?";
case 1:
fileName = J.util.Txt.trimQuotes (tokens.get (0));
var pt = fileName.indexOf (".");
if (pt < 0) return "EXPORT mode?";
break;
case 2:
mode = tokens.get (0).toUpperCase ();
fileName = J.util.Txt.trimQuotes (tokens.get (1));
break;
}
var ext = fileName.substring (fileName.lastIndexOf (".") + 1).toUpperCase ();
if (ext.equals ("JDX")) {
if (mode == null) mode = "XY";
} else if (JSV.common.ExportType.isExportMode (ext)) {
mode = ext;
} else if (JSV.common.ExportType.isExportMode (mode)) {
fileName += "." + mode;
}var type = JSV.common.ExportType.getType (mode);
if (forInkscape && type === JSV.common.ExportType.SVG) type = JSV.common.ExportType.SVGI;
return this.exportSpectrumOrImage (jsvp, type, -1, fileName);
}, "JSV.api.JSVPanel,JU.List,~B");
Clazz.overrideMethod (c$, "exportTheSpectrum", 
function (type, path, spec, startIndex, endIndex) {
var mode = JSV.common.ExportType.getType (type);
switch (mode) {
case JSV.common.ExportType.XY:
case JSV.common.ExportType.DIF:
case JSV.common.ExportType.DIFDUP:
case JSV.common.ExportType.FIX:
case JSV.common.ExportType.PAC:
case JSV.common.ExportType.SQZ:
return JSV["export"].JDXExporter.$export (mode, path, spec, startIndex, endIndex);
case JSV.common.ExportType.SVG:
case JSV.common.ExportType.SVGI:
return ( new JSV["export"].SVGExporter ()).exportAsSVG (path, spec, startIndex, endIndex, mode === JSV.common.ExportType.SVGI);
case JSV.common.ExportType.CML:
return ( new JSV["export"].CMLExporter ()).exportAsCML (path, spec, startIndex, endIndex);
case JSV.common.ExportType.AML:
return ( new JSV["export"].AMLExporter ()).exportAsAnIML (path, spec, startIndex, endIndex);
default:
return null;
}
}, "~S,~S,JSV.common.JDXSpectrum,~N,~N");
Clazz.overrideMethod (c$, "exportSpectrum", 
function (viewer, type) {
var jsvp = viewer.selectedPanel;
if (jsvp == null) return;
var eType = JSV.common.ExportType.getType (type);
switch (eType) {
case JSV.common.ExportType.PDF:
this.printPDF (viewer, "PDF");
break;
case JSV.common.ExportType.PNG:
case JSV.common.ExportType.JPG:
this.saveImage (viewer, eType);
break;
default:
this.exportSpectrumAsk (viewer, eType);
jsvp.getFocusNow (true);
}
}, "JSV.common.JSViewer,~S");
Clazz.overrideMethod (c$, "printPDF", 
function (viewer, pdfFileName) {
if (!viewer.si.isSigned ()) return "Error: Applet must be signed for the PRINT command.";
var isJob = (pdfFileName == null || pdfFileName.length == 0);
var isBase64 = (!isJob && pdfFileName.toLowerCase ().startsWith ("base64"));
var jsvp = viewer.selectedPanel;
if (jsvp == null) return null;
jsvp.getPanelData ().closeAllDialogsExcept (JSV.common.Annotation.AType.NONE);
var pl = viewer.getDialogPrint (isJob);
if (pl == null) return null;
if (isJob && pl.asPDF) {
isJob = false;
pdfFileName = "PDF";
}if (!isBase64 && !isJob) {
var helper = viewer.fileHelper;
helper.setFileChooser (JSV.common.ExportType.PDF);
if (pdfFileName.equals ("?") || pdfFileName.equalsIgnoreCase ("PDF")) pdfFileName = this.getSuggestedFileName (viewer, JSV.common.ExportType.PDF);
var file = helper.getFile (pdfFileName, jsvp, true);
if (file == null) return null;
viewer.setProperty ("directoryLastExporteFile", helper.setDirLastExported (file.getParent ()));
pdfFileName = file.getAbsolutePath ();
}var s = null;
try {
var os = (isJob ? null : isBase64 ?  new java.io.ByteArrayOutputStream () :  new java.io.FileOutputStream (pdfFileName));
var printJobTitle = jsvp.getPanelData ().getPrintJobTitle (true);
if (pl.showTitle) {
printJobTitle = jsvp.getInput ("Title?", "Title for Printing", printJobTitle);
if (printJobTitle == null) return null;
}jsvp.printPanel (pl, os, printJobTitle);
s = (isBase64 ? J.io.Base64.getBase64 ((os).toByteArray ()).toString () : "OK");
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
jsvp.showMessage (e.getMessage (), "File Error");
} else {
throw e;
}
}
return s;
}, "JSV.common.JSViewer,~S");
$_M(c$, "exportSpectrumOrImage", 
($fz = function (jsvp, imode, index, path) {
var spec;
var pd = jsvp.getPanelData ();
if (index < 0 && (index = pd.getCurrentSpectrumIndex ()) < 0) return "Error exporting spectrum: No spectrum selected";
spec = pd.getSpectrumAt (index);
var startIndex = pd.getStartingPointIndex (index);
var endIndex = pd.getEndingPointIndex (index);
var msg;
try {
switch (imode) {
case JSV.common.ExportType.SVG:
case JSV.common.ExportType.SVGI:
msg = ( new JSV["export"].SVGExporter ()).exportAsSVG (path, spec.getXYCoords (), spec.getTitle (), startIndex, endIndex, spec.getXUnits (), spec.getYUnits (), spec.isContinuous (), spec.isXIncreasing (), spec.isInverted (), pd.getColor (JSV.common.ScriptToken.PLOTAREACOLOR), pd.bgcolor, pd.getCurrentPlotColor (0), pd.getColor (JSV.common.ScriptToken.GRIDCOLOR), pd.getColor (JSV.common.ScriptToken.TITLECOLOR), pd.getColor (JSV.common.ScriptToken.SCALECOLOR), pd.getColor (JSV.common.ScriptToken.UNITSCOLOR), imode === JSV.common.ExportType.SVGI);
break;
default:
msg = this.exportTheSpectrum (imode.name (), path, spec, startIndex, endIndex);
}
return "OK - Exported " + imode.name () + ": " + path + msg;
} catch (ioe) {
if (Clazz.exceptionOf (ioe, java.io.IOException)) {
return "Error exporting " + path + ": " + ioe.getMessage ();
} else {
throw ioe;
}
}
}, $fz.isPrivate = true, $fz), "JSV.api.JSVPanel,JSV.common.ExportType,~N,~S");
$_M(c$, "saveImage", 
($fz = function (viewer, itype) {
var jsvp = viewer.selectedPanel;
viewer.fileHelper.setFileChooser (itype);
var name = this.getSuggestedFileName (viewer, itype);
var file = viewer.fileHelper.getFile (name, jsvp, true);
if (file != null) jsvp.saveImage (itype.toString ().toLowerCase (), file);
}, $fz.isPrivate = true, $fz), "JSV.common.JSViewer,JSV.common.ExportType");
$_M(c$, "exportSpectrumAsk", 
($fz = function (viewer, eType) {
viewer.fileHelper.setFileChooser (eType);
var items = this.getExportableItems (viewer, eType.equals (JSV.common.ExportType.SOURCE));
var jsvp = viewer.selectedPanel;
var index = (items == null ? -1 : viewer.getOptionFromDialog (items, "Export", "Choose a spectrum to export"));
if (index == -2147483648) return null;
var file = viewer.fileHelper.getFile (this.getSuggestedFileName (viewer, eType), jsvp, true);
if (file == null) return null;
var msg = "OK";
if (eType === JSV.common.ExportType.SOURCE) JSV["export"].Exporter.fileCopy (jsvp.getPanelData ().getSpectrum ().getFilePath (), file);
 else msg = this.exportSpectrumOrImage (jsvp, eType, index, file.getAbsolutePath ());
var isOK = msg.startsWith ("OK");
if (isOK) viewer.si.siUpdateRecentMenus (file.getAbsolutePath ());
return msg;
}, $fz.isPrivate = true, $fz), "JSV.common.JSViewer,JSV.common.ExportType");
$_M(c$, "getExportableItems", 
($fz = function (viewer, isSameType) {
var jsvp = viewer.selectedPanel;
var isView = viewer.currentSource.isView;
var nSpectra = jsvp.getPanelData ().getNumberOfSpectraInCurrentSet ();
if (nSpectra == 1 || !isView && isSameType || jsvp.getPanelData ().getCurrentSpectrumIndex () >= 0) return null;
var items =  new Array (nSpectra);
for (var i = 0; i < nSpectra; i++) items[i] = jsvp.getPanelData ().getSpectrumAt (i).getTitle ();

return items;
}, $fz.isPrivate = true, $fz), "JSV.common.JSViewer,~B");
$_M(c$, "getSuggestedFileName", 
($fz = function (viewer, imode) {
var pd = viewer.selectedPanel.getPanelData ();
var sourcePath = pd.getSpectrum ().getFilePath ();
var newName = JSV.common.JSVFileManager.getName (sourcePath);
var pt = newName.lastIndexOf (".");
var name = (pt < 0 ? newName : newName.substring (0, pt));
var ext = ".jdx";
var isPrint = false;
switch (imode) {
case JSV.common.ExportType.XY:
case JSV.common.ExportType.FIX:
case JSV.common.ExportType.PAC:
case JSV.common.ExportType.SQZ:
case JSV.common.ExportType.DIF:
case JSV.common.ExportType.DIFDUP:
case JSV.common.ExportType.SOURCE:
if (!(name.endsWith ("_" + imode))) name += "_" + imode;
ext = ".jdx";
break;
case JSV.common.ExportType.AML:
ext = ".xml";
break;
case JSV.common.ExportType.JPG:
case JSV.common.ExportType.PNG:
case JSV.common.ExportType.PDF:
isPrint = true;
default:
ext = "." + imode.toString ().toLowerCase ();
}
if (viewer.currentSource.isView) name = pd.getPrintJobTitle (isPrint);
name += ext;
return name;
}, $fz.isPrivate = true, $fz), "JSV.common.JSViewer,JSV.common.ExportType");
c$.fileCopy = $_M(c$, "fileCopy", 
($fz = function (name, file) {
try {
var br = JSV.common.JSVFileManager.getBufferedReaderFromName (name, null, null);
var writer =  new java.io.FileWriter (file.getAbsolutePath ());
var line = null;
while ((line = br.readLine ()) != null) {
writer.write (line);
writer.write (JSV.util.JSVTxt.newLine);
}
writer.close ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
J.util.Logger.error (e.getMessage ());
} else {
throw e;
}
}
}, $fz.isPrivate = true, $fz), "~S,java.io.File");
});
