Clazz.declarePackage ("JSV.export");
Clazz.load (["JSV.export.FormExporter"], "JSV.export.SVGExporter", ["java.lang.Boolean", "$.Double", "java.util.Hashtable", "JU.DecimalFormat", "$.List", "JSV.common.ColorParameters", "$.ScaleData", "JSV.util.JSVColorUtil", "J.util.Logger"], function () {
c$ = Clazz.declareType (JSV["export"], "SVGExporter", JSV["export"].FormExporter);
$_M(c$, "exportAsSVG", 
function (path, graph, startIndex, endIndex, forInkscape) {
return this.exportAsSVG (path, graph.getXYCoords (), "", startIndex, endIndex, graph.getXUnits (), graph.getYUnits (), graph.isContinuous (), graph.isXIncreasing (), graph.isInverted (), JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, JSV.common.ColorParameters.BLACK, forInkscape);
}, "~S,JSV.common.JDXSpectrum,~N,~N,~B");
$_M(c$, "exportAsSVG", 
function (fileName, xyCoords, title, startDataPointIndex, endDataPointIndex, xUnits, yUnits, isContinuous, increasing, isInverted, plotAreaColor, backgroundColor, plotColor, gridColor, titleColor, scaleColor, unitsColor, exportForInkscape) {
this.initForm (fileName);
var scaleData =  new JSV.common.ScaleData (xyCoords, startDataPointIndex, endDataPointIndex, isContinuous, isInverted);
var maxXOnScale = scaleData.maxXOnScale;
var minXOnScale = scaleData.minXOnScale;
var maxYOnScale = scaleData.maxYOnScale;
var minYOnScale = scaleData.minYOnScale;
var xStep = scaleData.steps[0];
var yStep = scaleData.steps[1];
var plotAreaWidth = JSV["export"].SVGExporter.svgWidth - JSV["export"].SVGExporter.leftInset - JSV["export"].SVGExporter.rightInset;
var plotAreaHeight = JSV["export"].SVGExporter.svgHeight - JSV["export"].SVGExporter.topInset - JSV["export"].SVGExporter.bottomInset;
var xScaleFactor = (plotAreaWidth / (maxXOnScale - minXOnScale));
var yScaleFactor = (plotAreaHeight / (maxYOnScale - minYOnScale));
var leftPlotArea = JSV["export"].SVGExporter.leftInset;
var rightPlotArea = JSV["export"].SVGExporter.leftInset + plotAreaWidth;
var topPlotArea = JSV["export"].SVGExporter.topInset;
var bottomPlotArea = JSV["export"].SVGExporter.topInset + plotAreaHeight;
var titlePosition = bottomPlotArea + 60;
this.context.put ("titlePosition",  new Integer (titlePosition));
var xPt;
var yPt;
var xStr;
var yStr;
var vertGridCoords =  new JU.List ();
var horizGridCoords =  new JU.List ();
for (var i = minXOnScale; i < maxXOnScale + xStep / 2; i += xStep) {
xPt = leftPlotArea + ((i - minXOnScale) * xScaleFactor);
yPt = topPlotArea;
xStr = JU.DecimalFormat.formatDecimalTrimmed (xPt, 6);
yStr = JU.DecimalFormat.formatDecimalTrimmed (yPt, 6);
var hash =  new java.util.Hashtable ();
hash.put ("xVal", xStr);
hash.put ("yVal", yStr);
vertGridCoords.addLast (hash);
}
for (var i = minYOnScale; i < maxYOnScale + yStep / 2; i += yStep) {
xPt = leftPlotArea;
yPt = topPlotArea + ((i - minYOnScale) * yScaleFactor);
xStr = JU.DecimalFormat.formatDecimalTrimmed (xPt, 6);
yStr = JU.DecimalFormat.formatDecimalTrimmed (yPt, 6);
var hash =  new java.util.Hashtable ();
hash.put ("xVal", xStr);
hash.put ("yVal", yStr);
horizGridCoords.addLast (hash);
}
var xScaleList =  new JU.List ();
var xScaleListReversed =  new JU.List ();
var yScaleList =  new JU.List ();
var precisionX = scaleData.precision[0];
var precisionY = scaleData.precision[1];
for (var i = minXOnScale; i < (maxXOnScale + xStep / 2); i += xStep) {
xPt = leftPlotArea + ((i - minXOnScale) * xScaleFactor);
xPt -= 10;
yPt = bottomPlotArea + 15;
xStr = JU.DecimalFormat.formatDecimalTrimmed (xPt, 6);
yStr = JU.DecimalFormat.formatDecimalTrimmed (yPt, 6);
var iStr = JU.DecimalFormat.formatDecimalDbl (i, precisionX);
var hash =  new java.util.Hashtable ();
hash.put ("xVal", xStr);
hash.put ("yVal", yStr);
hash.put ("number", iStr);
xScaleList.addLast (hash);
}
for (var i = minXOnScale, j = maxXOnScale; i < (maxXOnScale + xStep / 2); i += xStep, j -= xStep) {
xPt = leftPlotArea + ((j - minXOnScale) * xScaleFactor);
xPt -= 10;
yPt = bottomPlotArea + 15;
xStr = JU.DecimalFormat.formatDecimalTrimmed (xPt, 6);
yStr = JU.DecimalFormat.formatDecimalTrimmed (yPt, 6);
var iStr = JU.DecimalFormat.formatDecimalDbl (i, precisionX);
var hash =  new java.util.Hashtable ();
hash.put ("xVal", xStr);
hash.put ("yVal", yStr);
hash.put ("number", iStr);
xScaleListReversed.addLast (hash);
}
for (var i = minYOnScale; (i < maxYOnScale + yStep / 2); i += yStep) {
xPt = leftPlotArea - 55;
yPt = bottomPlotArea - ((i - minYOnScale) * yScaleFactor);
yPt += 3;
xStr = JU.DecimalFormat.formatDecimalTrimmed (xPt, 6);
yStr = JU.DecimalFormat.formatDecimalTrimmed (yPt, 6);
var iStr = JU.DecimalFormat.formatDecimalDbl (i, precisionY);
var hash =  new java.util.Hashtable ();
hash.put ("xVal", xStr);
hash.put ("yVal", yStr);
hash.put ("number", iStr);
yScaleList.addLast (hash);
}
var firstTranslateX;
var firstTranslateY;
var secondTranslateX;
var secondTranslateY;
var scaleX;
var scaleY;
if (increasing) {
firstTranslateX = leftPlotArea;
firstTranslateY = bottomPlotArea;
scaleX = xScaleFactor;
scaleY = -yScaleFactor;
secondTranslateX = -1 * minXOnScale;
secondTranslateY = -1 * minYOnScale;
} else {
firstTranslateX = rightPlotArea;
firstTranslateY = bottomPlotArea;
scaleX = -xScaleFactor;
scaleY = -yScaleFactor;
secondTranslateX = -minXOnScale;
secondTranslateY = -minYOnScale;
}var yTickA = minYOnScale - (yStep / 2);
var yTickB = yStep / 5;
this.context.put ("plotAreaColor", JSV.util.JSVColorUtil.colorToHexString (plotAreaColor));
this.context.put ("backgroundColor", JSV.util.JSVColorUtil.colorToHexString (backgroundColor));
this.context.put ("plotColor", JSV.util.JSVColorUtil.colorToHexString (plotColor));
this.context.put ("gridColor", JSV.util.JSVColorUtil.colorToHexString (gridColor));
this.context.put ("titleColor", JSV.util.JSVColorUtil.colorToHexString (titleColor));
this.context.put ("scaleColor", JSV.util.JSVColorUtil.colorToHexString (scaleColor));
this.context.put ("unitsColor", JSV.util.JSVColorUtil.colorToHexString (unitsColor));
this.context.put ("svgHeight",  new Integer (JSV["export"].SVGExporter.svgHeight));
this.context.put ("svgWidth",  new Integer (JSV["export"].SVGExporter.svgWidth));
this.context.put ("leftPlotArea",  new Integer (leftPlotArea));
this.context.put ("rightPlotArea",  new Integer (rightPlotArea));
this.context.put ("topPlotArea",  new Integer (topPlotArea));
this.context.put ("bottomPlotArea",  new Integer (bottomPlotArea));
this.context.put ("plotAreaHeight",  new Integer (plotAreaHeight));
this.context.put ("plotAreaWidth",  new Integer (plotAreaWidth));
this.context.put ("minXOnScale",  new Double (minXOnScale));
this.context.put ("maxXOnScale",  new Double (maxXOnScale));
this.context.put ("minYOnScale",  new Double (minYOnScale));
this.context.put ("maxYOnScale",  new Double (maxYOnScale));
this.context.put ("yTickA",  new Double (yTickA));
this.context.put ("yTickB",  new Double (yTickB));
this.context.put ("xScaleFactor",  new Double (xScaleFactor));
this.context.put ("yScaleFactor",  new Double (yScaleFactor));
this.context.put ("increasing",  new Boolean (increasing));
this.context.put ("verticalGridCoords", vertGridCoords);
this.context.put ("horizontalGridCoords", horizGridCoords);
var newXYCoords =  new JU.List ();
for (var i = startDataPointIndex; i <= endDataPointIndex; i++) newXYCoords.addLast (xyCoords[i]);

var firstX;
var firstY;
var lastX;
firstX = xyCoords[startDataPointIndex].getXVal ();
firstY = xyCoords[startDataPointIndex].getYVal ();
lastX = xyCoords[endDataPointIndex].getXVal ();
this.context.put ("title", title);
this.context.put ("xyCoords", newXYCoords);
this.context.put ("continuous",  new Boolean (isContinuous));
this.context.put ("firstTranslateX",  new Double (firstTranslateX));
this.context.put ("firstTranslateY",  new Double (firstTranslateY));
this.context.put ("scaleX",  new Double (scaleX));
this.context.put ("scaleY",  new Double (scaleY));
this.context.put ("secondTranslateX",  new Double (secondTranslateX));
this.context.put ("secondTranslateY",  new Double (secondTranslateY));
if (increasing) {
this.context.put ("xScaleList", xScaleList);
this.context.put ("xScaleListReversed", xScaleListReversed);
} else {
this.context.put ("xScaleList", xScaleListReversed);
this.context.put ("xScaleListReversed", xScaleList);
}this.context.put ("yScaleList", yScaleList);
this.context.put ("xUnits", xUnits);
this.context.put ("yUnits", yUnits);
this.context.put ("firstX", Double.$valueOf (firstX));
this.context.put ("firstY", Double.$valueOf (firstY));
this.context.put ("lastX", Double.$valueOf (lastX));
var xUnitLabelX = rightPlotArea - 50;
var xUnitLabelY = bottomPlotArea + 30;
var yUnitLabelX = leftPlotArea - 80;
var yUnitLabelY = Clazz.doubleToInt (bottomPlotArea / 2);
var tempX = yUnitLabelX;
yUnitLabelX = -yUnitLabelY;
yUnitLabelY = tempX;
this.context.put ("xUnitLabelX", "" + xUnitLabelX);
this.context.put ("xUnitLabelY", "" + xUnitLabelY);
this.context.put ("yUnitLabelX", "" + yUnitLabelX);
this.context.put ("yUnitLabelY", "" + yUnitLabelY);
this.context.put ("numDecimalPlacesX",  new Integer (Math.abs (scaleData.exportPrecision[0])));
this.context.put ("numDecimalPlacesY",  new Integer (Math.abs (scaleData.exportPrecision[1])));
var vm = (exportForInkscape ? "plot_ink.vm" : "plot.vm");
J.util.Logger.info ("SVGExporter using " + vm);
return this.writeForm (vm);
}, "~S,~A,~S,~N,~N,~S,~S,~B,~B,~B,javajs.api.GenericColor,javajs.api.GenericColor,javajs.api.GenericColor,javajs.api.GenericColor,javajs.api.GenericColor,javajs.api.GenericColor,javajs.api.GenericColor,~B");
Clazz.defineStatics (c$,
"svgWidth", 850,
"svgHeight", 400,
"leftInset", 100,
"rightInset", 200,
"bottomInset", 80,
"topInset", 20);
});
