var canvas;
var cntx;

$(document).ready(function(){
    prepareEnvironment();
});

function prepareEnvironment(){
    init();
}

window.onbeforeunload=function(){
    SimulationRunning=false;
    clearInterval(timerLoop);
    //return "Bye now!";
};

function initialiseExperiment(){
    weight[1]=0;
    LoadPictures();
    $("#scrPoleDirection").val(ScrValueOfEquilibrium);
    NetPoleHalfWidth=parseInt((PoleScale*imgPole.width-imgBase.width)/2);
    InitialiseWeights();
    BinaryWeightingCounter=0;
    SpecialWeightingCounter=0;
    WeightingCounter=0;
    SpecialWeightFound=false;
    if(IntroStep==scaleFirstStep || IntroStep==subtractWeightsStep){
        BinaryWeights=false;
    }
    else{
        BinaryWeights=true;
    }
    LoadWeight(3);
    LoadWeight(4);
    Define_dTheta();
}

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}
      
function initialiseEvents(){
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });

    $("#visualisation").on("mousedown touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });
    
    timerLoop=setInterval(function(){run();},simSpeed);
}

function initialiseGUI(){
    ScrValueOfEquilibrium=parseInt((parseInt($("#scrPoleDirection").attr("min"))+$("#scrPoleDirection").attr("max"))/2);
}

function initialValues(){
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");
    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    //Φόντα οθόνης
    drawIntroImage();
    drawLogoImage();
    if(IntroStep<5 || IntroStep==5 && WeightingCounter>2 || IntroStep==6 && (NextStepAfterSpecialWeight || SpecialWeightingCounter>1) || IntroStep==7 && BinaryWeightingCounter>1) drawButtonNext();
    if(IntroStep>1) drawButtonBack();
    
    if(IntroStep>=scaleFirstStep){
        $("#controlsDiv").show();
        DrawingFinished=false;
        DrawScale();
        DrawWeights();
        DrawingFinished=true;
        if(dTheta==0 && !isButtonPressed) ShowCount();
        
    }
    else{
        $("#controlsDiv").hide();
    }
    showUserPrompts();
}

function drawIntroImage(){
    if(IntroStep<scaleFirstStep){
        Intro=document.getElementById("img"+IntroStep);
    }
    else{
        //Define_dTheta();
        DefinePoleDirection();

        Intro=document.getElementById("img5");
    }
    var picTop=(height-Intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+Intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
    cntx.drawImage(Intro,1,picTop);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (buttonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function buttonNextHover(){
    if (mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function drawButtonBack(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if(buttonBackHover()){
        cntx.drawImage(imgBackStepSelected,BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled,BackStepLeft,BackStepTop);
    }
}

function buttonBackHover(){
    if(mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else{
        return false;
    }
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){
    if(SelectedWeight!=-1){
        isButtonPressed=true;
        WeightMouseXOffset=mx-imgWeightLeft[SelectedWeight];
        WeightMouseYOffset=my-imgWeightTop[SelectedWeight];
        WeightOnScale[SelectedWeight]=0;
    }
}

function handleMouseMove(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    if(isButtonPressed && SelectedWeight>-1){
        imgWeightLeft[SelectedWeight]=mx-WeightMouseXOffset;
        imgWeightTop[SelectedWeight]=my-WeightMouseYOffset;
    }
    else{
        var i=0;
        SelectedWeight=-1;
        while(SelectedWeight==-1 && i<=NoOfWeights()){
            if(WeightHover(i)) SelectedWeight=i;
            i++;
        }
        if(SelectedWeight!=-1){
            canvas.style.cursor="pointer";
        }
        else{
            canvas.style.cursor="default";
        }
    }
    drawBasicScreen();
    if(debug)console.log("mx="+mx+" , my="+my);
}

function handleMouseUp(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        showHTML();
    }
    else{
        if (mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && (IntroStep<5 || IntroStep==5 && WeightingCounter>2 || (IntroStep==6 && (NextStepAfterSpecialWeight || SpecialWeightingCounter>1)) || IntroStep==7 && BinaryWeightingCounter>1)){
            IntroStep++;
            if(IntroStep>=scaleFirstStep)initialiseExperiment();
            drawBasicScreen();
        }
        if(mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && IntroStep>1) {
            IntroStep--;
            if(IntroStep>=scaleFirstStep)initialiseExperiment();
            drawBasicScreen();
        }
        if(isButtonPressed){
            isButtonPressed=false;
            if(SelectedWeight>-1){
                if(imgLeftPlateLeft<=imgWeightLeft[SelectedWeight] && imgLeftPlateLeft+imgLeftPlate.width>imgWeightLeft[SelectedWeight]+imgWeight[SelectedWeight].width && imgLeftPlateTop<=imgWeightTop[SelectedWeight] && imgLeftPlateTop+imgLeftPlate.height>imgWeightTop[SelectedWeight]+imgWeight[SelectedWeight].height){
                    WeightOnScale[SelectedWeight]=1;
                }
                else if (imgRightPlateLeft<=imgWeightLeft[SelectedWeight] && imgRightPlateLeft+imgRightPlate.width>imgWeightLeft[SelectedWeight]+imgWeight[SelectedWeight].width && imgRightPlateTop<=imgWeightTop[SelectedWeight] && imgRightPlateTop+imgRightPlate.height>imgWeightTop[SelectedWeight]+imgWeight[SelectedWeight].height){
                    WeightOnScale[SelectedWeight]=-1;
                }
                else{
                  imgWeightLeft[SelectedWeight]=imgWeightOriginalLeft[SelectedWeight];
                  imgWeightTop[SelectedWeight]=imgWeightOriginalTop[SelectedWeight];
                }
            }
            CalculateWeights();
        }
        //drawBasicScreen();
    }
}

function showUserPrompts(){
    var promptLeft=55;
    var vTxtOffset=15;
    var promptYCoord;
    promptYCoord=BottomPanelTop+15;
    if(IntroStep==scaleFirstStep || IntroStep==subtractWeightsStep){
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Κάνε κλικ στο [Νέο Βάρος], για να δοκιμάσεις τις ικανότητές σου.");
        promptYCoord=promptYCoord+vTxtOffset;
        if(IntroStep==scaleFirstStep){
            cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Μπορείς να τοποθετήσεις σταθμά σε τάσι της ζυγαριάς με το ποντίκι σου.");
            promptYCoord=promptYCoord+vTxtOffset;
            cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Δοκίμασε να συνδυάσεις τα σταθμά για να ζυγίσεις το άγνωστο βάρος x.");
            promptYCoord=promptYCoord+vTxtOffset;
            cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Μπορείς να αφαιρέσεις σταθμά, σέρνοντάς τα έξω από το τάσι. Το κουμπί [Επαναφορά] επαναφέρει όλα τα σταθμά.");
            promptYCoord=promptYCoord+2*vTxtOffset;
            if(WeightingCounter>2){
                cnvsWrite("red",fontSize-1,"Arial",promptLeft,promptYCoord,"Στην επόμενη οθόνη μπορείς να πειραματιστείς με βάρη που θα... προκαλέσουν τη λογική σου.");
            }
        }
        else{ //IntroStep==subtractWeightsStep
            cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Πρέπει να σκεφτείς πολύ προσεκτικά για να καταφέρεις να ζυγίσεις κάποια από αυτά το βάρη...");
            promptYCoord=promptYCoord+vTxtOffset;
            if((NextStepAfterSpecialWeight || SpecialWeightingCounter>1) && dTheta==0){
                cnvsWrite("red",fontSize-1,"Arial",promptLeft,promptYCoord,"Στην επόμενη οθόνη μπορείς να χρησιμοποιήσεις πιο καλοδιαλεγμένα σταθμά.");
            }
            
        }
    }
    else if(IntroStep==binaryWeightsStep){
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Με τα 'δυαδικά' σταθμά δε θα χρειαστεί ποτέ να κάνεις αφαίρεση,");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"αφού μπορούν αθροιστικά να σχηματίσουν όλους τους αριθμούς (βάρη).");
        promptYCoord=promptYCoord+vTxtOffset;
        if(BinaryWeightingCounter>1 && dTheta==0){
            cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Στην επόμενη οθόνη μπορείς να πειραματιστείς με σταθμά μεγαλύτερης αξίας'.");
        }
    }
    else if(IntroStep==binaryWeightsFullStep){
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Ποια είναι η μεγαλύτερη μάζα που μπορείς να ζυγίσεις με τα σταθμά που βλέπεις εδώ;");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Μπορείς να μαντέψεις τις ενδείξεις που πρέπει να έχουν τα επόμενα σταθμά για να μπορέσεις");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"να ζυγίσεις μεγαλύτερες μάζες χωρίς αφαίρεση;");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"Άν διαθέτεις μια μάζα ίση προς 40 μονάδες, σε πόσα (ελάχιστο πλήθος) και ποια μέρη πρέπει να τη χωρίσεις,");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize-1,"Arial",promptLeft,promptYCoord,"ώστε να μπορείς να ζυγίσεις οποιαδήποτε ακέραια μάζα στο διάστημα 1-40;");
    }
}

function LoadPictures(){
    imgBase=document.getElementById("base");
    imgPole=document.getElementById("pole");
    imgLeftPlate=document.getElementById("leftPlate");
    imgRightPlate=document.getElementById("rightPlate");
    LoadWeights();
}

function LoadWeights(){
    for(var i=1;i<7;i++){
        LoadWeight(i);
    }
    LoadWeightX();
    WeightsInitialPosition();
}

function LoadWeight(i){
    if(i<3){
        imgWeight[i-1]=document.getElementById("weight"+i);
    }
    else if(i<5){
        if(BinaryWeights){
            imgWeight[i-1]=document.getElementById("weightbin"+i);
        }
        else{
            imgWeight[i-1]=document.getElementById("weight"+i);
        }
    }
    else{
        imgWeight[i-1]=document.getElementById("weightbin"+i);
    }
}

function LoadWeightX(){
    imgWeightX=document.getElementById("weightx");
}

function WeightsInitialPosition(){
    if(SelectedWeight!=-1)return;
    var WeightBaseCoord=450;
    var i;
    i=NoOfWeights();
    imgWeightLeft[i]=WeightScreenOffset;
    imgWeightTop[i]=WeightBaseCoord-imgWeight[i].height;
    while(i>0){
        i--;
        imgWeightLeft[i]=imgWeightLeft[i+1]+imgWeight[i+1].width+WeightScreenOffset;
        imgWeightTop[i]=WeightBaseCoord-imgWeight[i].height;
    }
    for (i=0;i<=NoOfWeights();i++){
        imgWeightOriginalLeft[i]=imgWeightLeft[i];
        imgWeightOriginalTop[i]=imgWeightTop[i];
        WeightOnScale[i]=0;
    }
}

function NoOfWeights(){
    if(IntroStep==binaryWeightsFullStep){
        return NoOfBinaryWeights-1;
    }
    else{
        return NoOfDecimalWeights-1;
    }
}

function InitialiseWeights(){
    WeightValue[0]=1;
    WeightValue[1]=2;
    if(BinaryWeights){
        WeightValue[2]=4;
        WeightValue[3]=8;
    }
    else{
        WeightValue[2]=5;
        WeightValue[3]=10;
    }
    WeightValue[4]=16;
    WeightValue[5]=32;
}

function DrawScale(){
    DrawPole();
    DrawLeftPlate();
    DrawRightPlate();
    DrawBase();
}

function DrawBase(){
    cntx.drawImage(base,imgBaseLeft,imgBaseTop);
}

function DrawPole(){
    var poleHalfWidth=imgPole.width*PoleScale/2;
    //Αποθήκευση καμβά πριν την περιστροφή/μετατόπιση αφετηρίας
    cntx.save();
    //Μετατόπιση αφετηρίας καμβά 
    cntx.translate(imgBaseLeft+imgBase.width/2,imgBaseTop+55+poleJointY);
    //περιστροφή καμβά 
    cntx.rotate(PoleDirection);
    //Σχεδίαση
    cntx.drawImage(pole,-poleHalfWidth,-poleJointY,imgPole.width*PoleScale,imgPole.height*PoleScale);
    //Επαναφορά καμβά
    cntx.restore();    
}

function DrawLeftPlate(){
    cntx.drawImage(leftPlate,imgLeftPlateLeft,imgLeftPlateTop);
}

function DrawRightPlate(){
    cntx.drawImage(rightPlate,imgRightPlateLeft,imgRightPlateTop);
}

function DefinePoleDirection(){
    var PlateOffset=5;
    
    PoleDirection=Math.PI*(parseInt($("#scrPoleDirection").val())-20)/180;
    
    imgPoleLeft=parseInt(imgBaseLeft-NetPoleHalfWidth*Math.cos(PoleDirection));
    imgPoleTop=imgBaseTop+50;
    
    imgLeftPlateLeft=parseInt(imgBaseLeft+imgBase.width/2-PoleScale*imgPole.width*Math.cos(PoleDirection)/2-imgLeftPlate.width/2)+PlateOffset;
    imgLeftPlateTop=parseInt(imgPoleTop+poleJointY-PoleScale*imgPole.width*Math.sin(PoleDirection)/2);
    
    imgRightPlateLeft=parseInt(imgBaseLeft+imgBase.width/2+PoleScale*imgPole.width*Math.cos(PoleDirection)/2-imgRightPlate.width/2)-PlateOffset;
    imgRightPlateTop=parseInt(imgPoleTop+poleJointY+PoleScale*imgPole.width*Math.sin(PoleDirection)/2);
}

function Define_dTheta(){
    CurrentState=stateAnimationPaused;
    if(weight[1]>weight[0]){
        dTheta=1;
    }
    else if(weight[1]<weight[0]){
        dTheta=-1;
    }
    else{
        if(parseInt($("#scrPoleDirection").val())==ScrValueOfEquilibrium){
            dTheta=0;
        }
        else if(parseInt($("#scrPoleDirection").val())>ScrValueOfEquilibrium){
            dTheta=-1;
        }
        else{
            dTheta=1;
        }
        if(IntroStep==subtractWeightsStep && SpecialWeightFound) NextStepAfterSpecialWeight=true;
    }
}

function DrawWeights(){
    var i,WeightLeftOffset=0,Denominator=2;
    if(IntroStep==8){
        WeightLeftOffset=10;
        Denominator=3;
    }
    //Draw unknown weight
    if(weight[1]!=0){
        imgWeightXLeft=imgRightPlateLeft+parseInt((imgRightPlate.width-imgWeightX.width)/2);
        imgWeightXTop=imgRightPlateTop+imgRightPlate.height-imgWeightX.height-WeightPlateOffset;
        cntx.drawImage(imgWeightX,imgWeightXLeft,imgWeightXTop);
    }
    
    //Draw known weights
    for(i=NoOfWeights();i>-1;i--){
        if(WeightOnScale[i]==1){
            imgWeightLeft[i]=WeightLeftOffset+imgLeftPlateLeft+4*imgLeftPlate.height/10-i*imgWeight[2].width/Denominator;
            imgWeightTop[i]=imgLeftPlateTop+imgLeftPlate.height-imgWeight[i].height-WeightPlateOffset;
            if(CurrentState==stateAnimationFinished){
                cntx.strokeStyle=ColOn;
            }
            else{
                cntx.strokeStyle="rgb(100,100,100)";
            }
            cntx.beginPath();
            cntx.rect(imgWeightOriginalLeft[i],imgWeightOriginalTop[i],imgWeight[i].width,imgWeight[i].height);
            cntx.stroke();
        }           
        else if(WeightOnScale[i]==-1){
            imgWeightLeft[i]=WeightLeftOffset+imgRightPlateLeft+parseInt((imgRightPlate.width-imgWeight[i].width)/Denominator);
            imgWeightTop[i]=imgRightPlateTop+imgRightPlate.height-imgWeight[i].height-WeightPlateOffset;
            cntx.strokeStyle="rgb(100,100,100)";
            cntx.beginPath();
            cntx.rect(imgWeightOriginalLeft[i],imgWeightOriginalTop[i],imgWeight[i].width,imgWeight[i].height);
            cntx.stroke();
        }
        else if(WeightOnScale[i]==0 && CurrentState==stateAnimationFinished){
            cntx.strokeStyle=ColOff;
            cntx.beginPath();
            cntx.rect(imgWeightOriginalLeft[i]-1,imgWeightOriginalTop[i]-1,imgWeight[i].width+1,imgWeight[i].height+1);
            cntx.stroke();
        }
        cntx.drawImage(imgWeight[i],imgWeightLeft[i],imgWeightTop[i]);
    }
}

function ShowCount(){
    var fontSizeToUse=bitsFont;//3*fontSize/2;
    var colorToUse="rgb(0,0,0)";
    var msg="";
    var sum=0,msgLeft=250;
    if(IntroStep==8) msgLeft=200;
    if(weight[0]>0){
        for(var i=NoOfWeights();i>-1;i--){
            if(i<NoOfWeights()){
                if(WeightOnScale[i]==-1){
                    msg=msg+"-";
                }
                else{
                    msg=msg+"+";
                }
            }
            else{
                 if(WeightOnScale[i]==-1) msg=msg+"-"; 
            }
            msg=msg+Math.abs(WeightOnScale[i])+"*"+WeightValue[i];
            sum=sum+WeightOnScale[i]*WeightValue[i];
        }
        msg=msg+" = "+sum;
    }
    if (sum==weight[1] && sum!=0){
        colorToUse="rgb(0,0,255)";
        msg=msg+"  =  x";
    }
    else {
        colorToUse="rgb(255,0,0)";
        if (sum!=0){
            if (sum>weight[1]) {
                msg=msg+" > x";
            }
            else {
                msg=msg+" < x";
            }
        }
    }
    cnvsWrite(colorToUse,fontSizeToUse,"Arial",msgLeft,TopPanelHeight+25,msg);
    if(IntroStep==6 && SpecialWeightFound){
        colorToUse="rgb(0,0,255)";
        cnvsWrite(colorToUse,fontSizeToUse,"Arial",10,TopPanelHeight+50,"Δύσκολο να πάει το μυαλό σου στην αφαίρεση, όταν κάνεις συνέχεια πρόσθεση!");
    }
    else if(IntroStep>=7 && sum==weight[1]){
        var code="",msg2;
        var msgXCoord=10;
        for(var i=NoOfWeights();i>-1;i--) {
            code=code+WeightOnScale[i];
            //bits[NoOfBits-i-1]=(byte)(WeightOnScale[i]);
            if(weight[0]!=0){
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",10,TopPanelHeight+70,"Η μέτρηση μπορεί να γραφτεί στη μορφή:");
                //Εμφάνιση συντελεστή
                msg2=WeightOnScale[i]+"";                   
                colorToUse="rgb(255,0,0)";
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",msgXCoord,TopPanelHeight+100,msg2);
                var msgWidth=cntx.measureText(msg2).width;
                msgXCoord=msgXCoord+msgWidth;
                //Εμφάνιση δύναμης του 2
                colorToUse="rgb(0,0,255)";
                msg2="*2";
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",msgXCoord,TopPanelHeight+100,msg2);
                msgXCoord=msgXCoord+cntx.measureText(msg2).width;
                //Εμφάνιση εκθέτη
                msg2=""+i;
                cnvsWrite(colorToUse,3*fontSize/4,"Arial",msgXCoord,TopPanelHeight+90,msg2);
                msgXCoord=msgXCoord+cntx.measureText(msg2).width;
                //Εμφάνιση συμβόλου πρόσθεσης
                if(i>0){
                    colorToUse="rgb(0,0,255)";
                    msg2="+";
                    cnvsWrite(colorToUse,fontSizeToUse,"Arial",msgXCoord,TopPanelHeight+100,msg2);
                    msgXCoord=msgXCoord+cntx.measureText(msg2).width;
                }
            }
        }
        if(!(code=="0000" || (IntroStep==8 && code=="000000"))){
            colorToUse="rgb(0,0,255)";
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",10,TopPanelHeight+130,"ή να κωδικοποιηθεί 'συνοπτικά' ως:");
            colorToUse="rgb(255,0,0)";
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",80,TopPanelHeight+160,""+code);
            colorToUse="rgb(0,0,255)";
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",10,TopPanelHeight+190,"δηλαδή σε ΔΥΑΔΙΚΗ μορφή");
            if(IntroStep==8 && CurrentState>stateAnimationPaused){
                DrawBytePlaceHolder();
                DrawByte();
            }
            if(CurrentState>=stateMoveFactorsX) DrawFactors();
            if(CurrentState>=stateFadeInNo) DrawDecimalValue();
        }
    }
}

function WeightHover(i){
    if(mx>=imgWeightLeft[i] && mx<=imgWeightLeft[i]+imgWeight[i].width && my>=imgWeightTop[i] && my<=imgWeightTop[i]+imgWeight[i].height){
        return true;
    }
    else{
        return false;
    }
}

function resetScale(){
    weight[0]=0;
    Define_dTheta();
    WeightsInitialPosition();
    //drawBasicScreen();
    CalculateWeights();
    simulationRunning=true;
}

function newWeight(){
    var NewWeightOK=false;
    var LastDigit;
    weight[0]=0;
    if(WeightingCounter<3) WeightingCounter++;
    while(!NewWeightOK){
        if(IntroStep==binaryWeightsFullStep){
            weight[1]=1+parseInt(Math.random()*63);
            CurrentState=stateAnimationPaused;
        }
        else{
            weight[1]=1+parseInt(Math.random()*15);
        }
        LastDigit=weight[1] % 10;
        if(IntroStep==scaleFirstStep && (LastDigit==4 || LastDigit==9)){
            NewWeightOK=false;
        }
        else if(IntroStep==subtractWeightsStep && LastDigit!=4 && LastDigit!=9 && SpecialWeightingCounter<2){
            NewWeightOK=false;
        }
        else{
            NewWeightOK=true;
        }
    }
    Define_dTheta();
    WeightsInitialPosition();
    if(IntroStep==binaryWeightsStep && BinaryWeightingCounter<2){
        BinaryWeightingCounter++;
    }
    else if(IntroStep==subtractWeightsStep && SpecialWeightingCounter<2){
        SpecialWeightingCounter++;
    }
    //drawBasicScreen();
    SimulationRunning=true;
}

function showSolution(){
    var i,WeightToFind=weight[1];
    WeightsInitialPosition();
    SpecialWeightFound=true;
    if(WeightToFind==4 && !BinaryWeights){
        WeightOnScale[2]=1;
        WeightOnScale[0]=-1;
        NextStepAfterSpecialWeight=true;
    }
    else if (WeightToFind==9 && !BinaryWeights){
        WeightOnScale[3]=1;
        WeightOnScale[0]=-1;
        NextStepAfterSpecialWeight=true;
    }
    else if (WeightToFind==14 && !BinaryWeights){
        WeightOnScale[3]=1;
        WeightOnScale[2]=1;
        WeightOnScale[0]=-1;
        NextStepAfterSpecialWeight=true;
    }
    else{
        var sum=0;
        i=NoOfWeights();
        while(sum<WeightToFind){
            if(WeightValue[i]<=WeightToFind-sum){
                sum=sum+WeightValue[i];
                WeightOnScale[i]=1;
            }
            i--;
        }
        SpecialWeightFound=false;
    }
    CalculateWeights();
    //drawBasicScreen();
    SimulationRunning=true;
}

function CalculateWeights(){
    var i,sum=0;
    for(i=0;i<=NoOfWeights();i++){
        sum=sum+WeightOnScale[i]*WeightValue[i];
    }
    weight[0]=sum;
    DefinePoleDirection();
    Define_dTheta();
    SimulationRunning=true;
}

function run(){
    if(SimulationRunning){
        if(weight[0]<weight[1]){
            //Αν είναι ήδη τέρμα δεξιά θέσε βήμα 0
            if(parseInt($("#scrPoleDirection").val())==parseInt($("#scrPoleDirection").attr("max"))){
                dTheta=0;
                SimulationRunning=false;
            }
        }
        else if(weight[0]>weight[1]){
            //Αν είναι ήδη τέρμα αριστερά θέσε βήμα 0
            if(parseInt($("#scrPoleDirection").val())==parseInt($("#scrPoleDirection").attr("min"))){
                dTheta=0;
                SimulationRunning=false;
            }
        }
        else{
            //Αν είναι σε ισορροπία θέσε βήμα 0
            if(parseInt($("#scrPoleDirection").val())==ScrValueOfEquilibrium){
                dTheta=0;
                if(CurrentState==stateAnimationPaused){
                    CurrentState=stateWaiting;
                }
                if(IntroStep<binaryWeightsFullStep){
                    SimulationRunning=false;
                }
                /*else{
                    SimulationRunning=false;
                }*/
            }
        }
        if(DrawingFinished){
            $("#scrPoleDirection").val(parseInt($("#scrPoleDirection").val())+dTheta);
            DefinePoleDirection();
            drawBasicScreen();
        }
        if(IntroStep==binaryWeightsFullStep){              
            HandleAnimation();
        }
    }
}

function HandleAnimation(){
    cntx.font=bitsFont+"px Arial";
    if(CurrentState==stateWaiting){
        InitialiseAnimation();
    }
    else if(CurrentState==stateFadeInNo){
        HandleFadeIn();
    }
    else if(CurrentState==stateGenerateFactors){
        GenerateFactors();
    }
    else if(CurrentState==stateMoveFactorsX){
        MoveFactors();
    }
    else if(CurrentState==stateFinaliseFactorsXPosition){
        FinaliseFactorsPosition();
    }
    else if(CurrentState==stateMoveFactorsY){
        MoveFactorsY();
    }
    else if(CurrentState==stateFinaliseFactorsYPosition){
        FinaliseFactorsYPosition();
    }
    else if(CurrentState==stateFillBits){
        FillBits();
    }
}

function InitialiseAnimation(){
    var i;
    DecimalValueR=0;
    DecimalValueG=0;
    DecimalValueB=0;
    for(i=0;i<NoOfBits;i++) bits[i]=0;
    DecimalValueColor=BackR;
    FactorColor=BackR;
    CurrentState=stateFadeInNo;
}

function HandleFadeIn(){
    DecimalValueColor=DecimalValueColor-3;
    if(DecimalValueColor<90){
        DecimalValueColor=0;
        CurrentState=stateGenerateFactors;
    }
}

function GenerateFactors(){
    var x,i,j,X1,X2,msgWidth;
    var message;
    x=weight[1];
    for(i=0;i<NoOfBits;i++){
        //Υπολογισμός bit
        j=NoOfBits-i-1;
        Auxbits[j]=parseInt(x % 2);
        //Υπολογισμός Παράγοντα
        Factors[j]=parseInt(Math.pow(2,i)*Auxbits[j]);
        //Αρχική x-συντεταγμένη παράγοντα
        FactorsXcoord[j]=DecimalValueXcoord;
        FactorsYcoord[j]=DecimalValueYcoord;
        //Υπολογισμός μεγέθους του βήματος
        X1=ByteLeft+NoOfDigitsPerPlaceHolder*j*BitWidth+BitBorder;
        X2=ByteLeft+NoOfDigitsPerPlaceHolder*(j+1)*BitWidth-BitBorder;
        message=""+Factors[j];
        //msgWidth=fm.stringWidth(message);
        msgWidth=cntx.measureText(message).width;
        FactorsFinalXcoord[j]=(X2-X1-msgWidth)/2+X1;
        //Επόμενο bit
        x=parseInt(x/2);
    }
    for(i=0;i<NoOfBits;i++){
        if(Factors[i]>0){
            FactorsFinalYcoord[i]=ByteTop+8*BitBorder;
        }
        else{
            FactorsFinalYcoord[i]=DecimalValueYcoord;
        }
        FactorsXstep[i]=(FactorsFinalXcoord[i]-DecimalValueXcoord)/NoOfSteps;
        if(FactorsXstep[i]<1) FactorsXstep[i]=1;
        if(Math.abs(FactorsXstep[i])<1) FactorsXstep[i]=Math.signum(FactorsXstep[i]);
        FactorsYstep[i]=(FactorsFinalYcoord[i]-DecimalValueYcoord)/NoOfYSteps;
        if(Math.abs(FactorsYstep[i])>-1) FactorsYstep[i]=Math.sign(FactorsYstep[i]);
    }
    CurrentState=stateMoveFactorsX;
}

function MoveFactors(){
    var ReadyForNextState=true;
    for(var i=0;i<NoOfBits;i++){
        FactorsXcoord[i]=parseInt(FactorsXcoord[i]+FactorsXstep[i]);
        if(FactorsXcoord[i]>FactorsFinalXcoord[i]){
            FactorsXcoord[i]=FactorsFinalXcoord[i];
        }
        else{
            ReadyForNextState=false;
        }
    }
    FactorColor=FactorColor-255/NoOfSteps;
    if(FactorColor<0){
        FactorColor=0;
        if(ReadyForNextState) CurrentState=stateFinaliseFactorsXPosition;
    }
}

function MoveFactorsY(){
    var done=false,NoMovement=true;
    for(var i=0;i<NoOfBits;i++){
        if(FactorsYstep[i]!=0) NoMovement=false;
        FactorsYcoord[i]=parseInt(FactorsYcoord[i]+FactorsYstep[i]);
        if(FactorsYcoord[i]<FactorsFinalYcoord[i]){
            FactorsYcoord[i]=FactorsFinalYcoord[i];
            done=true;
        }
    }
    if(done || NoMovement) CurrentState=stateFinaliseFactorsYPosition;
}

function FinaliseFactorsPosition(){
    for(var i=0;i<NoOfBits;i++){
        FactorsXcoord[i]=FactorsFinalXcoord[i];
    }
    CurrentState=stateMoveFactorsY;
}

function FinaliseFactorsYPosition(){
    for(var i=0;i<NoOfBits;i++){
        FactorsYcoord[i]=FactorsFinalYcoord[i];
    }
    CurrentState=stateFillBits;
}

function FillBits(){
    for(var i=0;i<NoOfBits;i++){
        bits[i]=Auxbits[i];
    }
    CurrentState=stateAnimationFinished;
}

function DrawFactors(){
    var colorToUse="rgb(0,0,0)";
    var fontSizeToUse=bitsFont;//3*fontSize/2;
    var MaxValue=0;
    MaxValue=NoOfBits;
    for(var i=0;i<MaxValue;i++){
        if(CurrentState==stateAnimationFinished){
            if(bits[i]==0){
                //backg.setColor(ColOff);
                colorToUse=ColOff;
            }
            else{
                //backg.setColor(ColOn);
                colorToUse=ColOn;
            }
        }
        else{
            //backg.setColor(new Color(FactorColor,FactorColor,FactorColor));
            colorToUse="rgb(FactorColor,FactorColor,FactorColor)";
        }
        //backg.drawString(""+Factors[i],FactorsXcoord[i],FactorsYcoord[i]);
        cnvsWrite(colorToUse,fontSizeToUse,"Arial",FactorsXcoord[i],FactorsYcoord[i],""+Factors[i]);
    }
}

function DrawDecimalValue(){
    var X1,X2,msgWidth;
    var DecimalValue=weight[1];
    X1=ByteLeft-NoOfDigitsPerPlaceHolder*BitWidth+BitBorder;
    X2=ByteLeft-BitBorder;
    //backg.setColor(new Color(DecimalValueColor,DecimalValueColor,DecimalValueColor));
    var colorToUse="rgb("+DecimalValueColor+","+DecimalValueColor+","+DecimalValueColor+")";
    //colorToUse="rgb(0,255,0)";
    var fontSizeToUse=bitsFont;//3*fontSize/2;
    //msgWidth=fm.stringWidth(""+weight[1]);
    msgWidth=cntx.measureText(""+weight[1]).width;
    if(CurrentState<=stateFadeInNo){
        DecimalValueXcoord=(X2-X1-msgWidth)/2+X1;
    }
    DecimalValueYcoord=ByteTop+20*BitBorder;
    //backg.drawString(""+DecimalValue,DecimalValueXcoord,DecimalValueYcoord);
    cnvsWrite(colorToUse,fontSizeToUse,"Arial",DecimalValueXcoord,DecimalValueYcoord,""+DecimalValue);
}

function valueChanged(){
    DefinePoleDirection();
    Define_dTheta();
    drawBasicScreen();
}


function DrawBytePlaceHolder(){
    var fontSizeToUse=bitsFont;//3*fontSize/2;
    var X1,X2,msgWidth,value;
    var message,colorToUse="rgb(0,0,0)";
    //Σχεδίαση θέσεων
    for(var i=0;i<NoOfBits;i++){
        //backg.setColor(new Color(0,0,200));
        cntx.strokeStyle="rgb(0,0,200)";
        X1=ByteLeft+NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder;
        X2=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder;
        cntx.beginPath();
        //backg.drawLine(X1,ByteTop,X2,ByteTop);
        cntx.moveTo(X1,ByteTop);
        cntx.lineTo(X2,ByteTop);
        
        //backg.drawLine(X1,ByteTop,X1,ByteTop-BitBorder);
        cntx.moveTo(X1,ByteTop);
        cntx.lineTo(X1,ByteTop-BitBorder);
        
        //backg.drawLine(X2,ByteTop,X2,ByteTop-BitBorder);
        cntx.moveTo(X2,ByteTop);
        cntx.lineTo(X2,ByteTop-BitBorder);
        cntx.stroke();
        
        value=parseInt(Math.pow(2,NoOfBits-i-1));
        message=""+value;
        //msgWidth=fm.stringWidth(message);
        msgWidth=cntx.measureText(message).width;
        //Σχεδίαση αξίας θέσης
        if(CurrentState==stateAnimationFinished){
            if(bits[i]==0){
                //backg.setColor(ColOff);
                colorToUse=ColOff;
            }
            else{
                //backg.setColor(ColOn);
                colorToUse=ColOn;
            }
        }
        else{
            //backg.setColor(new Color(0,0,0));
            colorToUse="rgb(0,0,0)";
        }
        //backg.drawString(message,(X2-X1-msgWidth)/2+X1,ByteTop+8*BitBorder);
        cnvsWrite(colorToUse,fontSizeToUse,"Arial",(X2-X1-msgWidth)/2+X1,ByteTop+8*BitBorder,message);
    }
}

function DrawByte(){
    var fontSizeToUse=bitsFont;//3*fontSize/2;
    var X1,X2,msgWidth;
    var message,colorToUse="rgb(0,0,0)";
    //fm=backg.getFontMetrics();
    for(var i=0;i<NoOfBits;i++){
        X1=ByteLeft+NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder;
        X2=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder;
        message=""+bits[i];
        //msgWidth=fm.stringWidth(message);
        msgWidth=cntx.measureText(message).width;
        if(bits[i]==1){
            //backg.setColor(new Color(0,0,255));
            colorToUse="rgb(0,0,255)";;
        }
        else {
            //backg.setColor(new Color(255,0,0));
            colorToUse="rgb(255,0,0)";;
        }
        //backg.drawString(message,(X2-X1-msgWidth)/2+X1,ByteTop-BitBorder);
        cnvsWrite(colorToUse,fontSizeToUse,"Arial",(X2-X1-msgWidth)/2+X1,ByteTop-BitBorder,message);
    }
}