;(function() {
	
	window.jsPlumbDemo = {
		init : function() {
				
			jsPlumb.importDefaults({
				// default drag options
				DragOptions : { cursor: 'pointer', zIndex:2000 },
				// default to blue at one end and green at the other
				EndpointStyles : [{ fillStyle:'#225588' }, { fillStyle:'#558822' }],
				// blue endpoints 7 px; green endpoints 11.
				Endpoints : [ [ "Dot", {radius:4} ], [ "Dot", { radius:5 } ]],
				// the overlays to decorate each connection with.  note that the label overlay uses a function to generate the label text; in this
				// case it returns the 'labelText' member that we set on each connection in the 'init' method below.
				ConnectionOverlays : [
					[ "Arrow", { location:0.99 } ],
					//[ "Label", { 
						//location:0.1,
						//id:"label",
						//cssClass:"aLabel"
					//}]
				]
				
				
				
			});			

//============================ update a list of connections
			var connections = [];
			var updateConnections = function(conn, remove) {
				if (!remove) connections.push(conn);
				else {
					var idx = -1;
					for (var i = 0; i < connections.length; i++) {
						if (connections[i] == conn) {
							idx = i; break;
						}
					}
					if (idx != -1) connections.splice(idx, 1);
				}
				if (connections.length > 0) {
					var s = "<table><tr><th>Όργανο</th><th>Έλεγχος</th></tr>";
					for (var j = 0; j < connections.length; j++) {
						
						from_elem = document.getElementById( connections[j].sourceId );
						from_con=from_elem.getElementsByTagName("textarea")[0].value ;
						fromid=connections[j].sourceId;
						fromNumber=fromid.substring( fromid.length-2, fromid.length-1);
						
						//to_elem = document.getElementById( connections[j].targetId ).value;
						toid=connections[j].targetId;
						toNumber=toid.substring(toid.length -2, toid.length-1);
						//alert(toNumber);
						//to_con=to_elem.getElementsByTagName("textarea")[0].value ;
						
						var result= "Λάθος";
						if (fromNumber == toNumber){
							result= "Σωστό";
						}
						
						//s = s + "<tr><td>" + connections[j].scope + "</td>" + "<td>" + connections[j].sourceId + "</td><td>" + connections[j].targetId + "</td></tr>";		
						//s = s + "<tr> " + "<td>" + connections[j].sourceId + "</td><td>" + connections[j].targetId + "</td></tr>";
						s = s + "<tr> " + "<td>" + from_con + "</td><td>" + result + "</td></tr>";
						//console.log( connections );
						
					}
					jsPlumbDemo.showConnectionInfo(s);
					
				} else 
					jsPlumbDemo.hideConnectionInfo();
			};				

			jsPlumb.bind("jsPlumbConnection", function(info, originalEvent) {
				updateConnections(info.connection);
                document.getElementById('NumOfConnections').innerHTML = connections.length;
                evaluate(connections);
				
			});
			jsPlumb.bind("jsPlumbConnectionDetached", function(info, originalEvent) {
				updateConnections(info.connection, true);
				document.getElementById('NumOfConnections').innerHTML = connections.length;
			});
//============================

			var mysize= function(){
				if(connections.length > 0){
				//return connections.length
                    document.getElementById('NumOfConnections').innerHTML = connections.length;
            }
			}
				

			// this is the paint style for the connecting lines..
			var connectorPaintStyle = {
				lineWidth:3,
				strokeStyle:"#ff3300",
				//joinstyle:"round"
			},
			// .. and this is the hover style. 
			connectorHoverStyle = {
				lineWidth:5,
				strokeStyle:"#0066cc"
			},
			// the definition of source endpoints (the small blue ones)
			sourceEndpoint = {
				endpoint:"Dot",
				paintStyle:{ fillStyle:"#225588",radius:7 },
				isSource:true,
				connector:[ "StateMachine", { stub:40 } ],
				connectorStyle:connectorPaintStyle,
				hoverPaintStyle:connectorHoverStyle,
				connectorHoverStyle:connectorHoverStyle,
                dragOptions:{},
                maxConnections:5,
                //overlays:[
                	//[ "Label", { 
	                	//location:[0.5, 1.5], 
	                	//label:"Drag",
	                	//label:"",
	                	//cssClass:"endpointSourceLabel" 
	                //} ]
                //]
			},
			// a source endpoint that sits at BottomCenter
			bottomSource = jsPlumb.extend( { anchor:"BottomCenter" }, sourceEndpoint),
			// the definition of target endpoints (will appear when the user drags a connection) 
			targetEndpoint = {
				endpoint:"Dot",					
				paintStyle:{ fillStyle:"#ff6600",radius:6 },
				hoverPaintStyle:connectorHoverStyle,
				maxConnections:1,
				dropOptions:{ hoverClass:"hover", activeClass:"active" },
				isTarget:true,			
                overlays:[
                	//[ "Label", { location:[0.5, -0.5], label:"Drop", cssClass:"endpointTargetLabel" } ]
                	[ "Label", { location:[0.5, -0.5], label:"", cssClass:"endpointTargetLabel" } ]
                ]
			},			
			init = function(connection) {
				connection.getOverlay("label").setLabel(connection.sourceId.substring(6) + "-" + connection.targetId.substring(6));
			};			

			var allSourceEndpoints = [], allTargetEndpoints = [];
				_addEndpoints = function(toId, sourceAnchors, targetAnchors) {
					for (var i = 0; i < sourceAnchors.length; i++) {
						var sourceUUID = toId + sourceAnchors[i];
						allSourceEndpoints.push(jsPlumb.addEndpoint(toId, sourceEndpoint, { anchor:sourceAnchors[i], uuid:sourceUUID }));
					}
					for (var j = 0; j < targetAnchors.length; j++) {
						var targetUUID = toId + targetAnchors[j];
						allTargetEndpoints.push(jsPlumb.addEndpoint(toId, targetEndpoint, { anchor:targetAnchors[j], uuid:targetUUID }));
					}
				};
			


			_addEndpoints("window20",["TopCenter"], []);
			_addEndpoints("window30",["TopCenter"], []);
			_addEndpoints("window40",["TopCenter"], []);
			_addEndpoints("window50",["TopCenter"], []);
			_addEndpoints("window60",["TopCenter"], []);
			
			//-----------------
			_addEndpoints("imagePoint21",[], ["TopCenter"]);//petala
			_addEndpoints("imagePoint31",[], ["TopCenter"]);//sepala
			_addEndpoints("imagePoint41",[], ["TopCenter"]);//misxos
			_addEndpoints("imagePoint51",[], ["TopCenter"]);//sthmones
			_addEndpoints("imagePoint61",[], ["TopCenter"]);//yperos
			
			// listen for new connections; initialise them the same way we initialise the connections at startup.
			//jsPlumb.bind("jsPlumbConnection", function(connInfo, originalEvent) { 
				//init(connInfo.connection);
			//});
						
			// make all the window divs draggable						
			jsPlumb.draggable(jsPlumb.getSelector(".window"));


			// listen for clicks on connections, and offer to delete connections on click.
			jsPlumb.bind("click", function(conn, originalEvent) {
				//if (confirm("Delete connection from " + conn.sourceId + " to " + conn.targetId + "?"))
					jsPlumb.detach(conn); 
			});			
		}
	};
})();
