/* auteur: Bernard Martin-Rabaud */
/* date de creation: 30/01/01 */

// *****************************************************
// JEU DU PENDU : LE JEU LUI-MEME
// *****************************************************


// *****************************************************
// SOMMAIRE GENERAL (1557, 935)
// [le 1 premier fichier est modifiable, mais pas les autres; il est possible de le gnrer par formulaire]
// - LES PARAMETRES ET DONNEES (dans fichier pendu_donnees.js) : VOS THEMES ET MOTS A DEVINER (133, 100)
// - CLASSE ET METHODES "ALPHABET" (pendu_alpha.js) : L'ALPHABET (94, 53)
// - CLASSE ET METHODES "MOT" (pendu_mot.js) : LE MOT A DEVINER (252, 168)
// - CLASSE ET METHODES "LETTRE" (pendu_lettres.js) : LES LETTRES DE L'ALPHABET ET DU MOT (211, 131)
// - CLASSE ET METHODES "POLICE" (pendu_police.js) : LA GESTION DES POLICES (67, 26)
// - CLASSE ET METHODES "IMAGE" (pendu_image.js) : L'IMAGE DU PENDU (165, 91)
// - CLASSE ET METHODES "SCORE" (pendu_score.js) : LE SCORE (158, 99)
// - CLASSE ET METHODES "THEMES" (pendu_theme.js) : LES THEMES DISPONIBLES (186, 118)
// - CLASSE ET METHODES "COMMENTAIRES" (pendu_comments.js) : LES COMMENTAIRES SELON LE NOMBR DE FAUTES (60, 24)
// - CLASSE ET METHODES "JEU" (ce fichier : pendu_jeu.js) : LE JEU (231, 125)
//   entre () : lignes de code avec commentaires, lignes de code sans commentaires
// POIDS DU SCRIPT :
//   avec commentaires : 60018 octets (38.5 octets / lignes)
//   sans commentaires : 30144 octets (32.2 octets / ligne, 50% poids avec commentaires)
//   67 % de lignes de commentaires par rapport au code pur
// *****************************************************


// *****************************************************
// VARIABLES GLOBALES
var polices = null;
var alphabet = null;
var jeu = null;
var texte = null;
var liste = null;
var image = null;
var score = null;
// *****************************************************

// *****************************************************
// PRINCIPE DE FONCTIONNEMENT DU SCRIPT

// A la base une application interactive ragit  des vnements. 
// Ce script commence  afficher le jeu dans la page HTML, 
// puis le jeu est dirig par les actions dclenches par le joueur.
// Le script est constitu d'un certain nombre d'objets spcialiss
// (image du pendu, lettres, mot  deviner, alphabet, thmes, aide, affichage du score)
// dont chacun a sa propre logique et son propre comportement. 
// Le script fonctionne par va-et-vient constants entre ces objets
// et les fonctions principales (ci-dessous) qui correspondent
// aux principales actions du joueur. En fait, les objets ont pour fonction
// d'assister le script principal (le jeu) dans des tches spcialises.
// Ils offrent galement l'avantage de pouvoir modifier des comportements
// sans toucher aux autres objets non concerns et surtout au script principal.
// *****************************************************

// *****************************************************
// JEU : VERSION DE BASE

// cration des objets principaux et champs de CJeu qui servent de variables globales
function CJeu() {
   alphabet = new CAlphabet();
   liste = new CListeThemes();
   image = new CDessinPendu();
   donnees();
   texte = new CATrouver();
   score = new CScore();
   this.fin_mot = false;
   this.erreurs = 6;
}

// METHODES DE LA CLASSE CJEU
// - init : crit, initialise et affiche les objets du jeu (au dpart du jeu)
// - rejouer : rinitialise et affiche ces objets
// - aide : affiche l'aide lorsqu'on clique sur "aide"
// - prec et suiv : lorsqu'on clique sur "mot prec" et "mot suiv"
// - terminer : lorsqu'un mot est termin (par un succs ou un chec)*
// - choix_lettre : lorsqu'on choisit une lettre de l'alphabet
// - change_theme : lorsqu'on slectionne un thme

// criture du bouton "rejouer"
function CJ_ecrit_rejouer() {
   return "<a href='javascript:jeu.rejouer()'><img name='rejouer' src='" + _rep_images + bouton_vide + "' width='102' height='26' border='0' alt='rejouer'" + fin_tag + "</a>";
}

// dmarre le jeu  l'ouverture de la page :
// - crit les lments du jeu dans la page "pendu.htm"
// - puis soit attend le choix d'un thme, soit donne un mot au hasard, s'il y a un seul thme 
function CJ_demarrer() {
   score.init();
   this.ecrit();
   if (liste.themes.length == 1) liste.choix_mot();
//   alphabet.reinit();
}

// criture des objets principaux dans la page "pendu.htm" ;
// le tout est inscrit dans un tableau de largeur 780 (pour tre visible dans une page 800x600)
//  3 lignes et 2 colonnes :
// 1re ligne : le logo et le titre (1 colonne chacun)
// 2me ligne : une courte prsentation-explication (sur 2 colonnes)
// 3me ligne : 1 colonne pour le dessin du pendu et 1 colonne pour le mot, l'alphabet et le score
function CJ_ecrit() {
   // criture du tableau
   var ch = "<table width='100%' border='0' cellspacing='0' cellpadding='8' >\n";
   // criture de la liste des thmes
   ch += "<tr><td>" + liste.ecrit() + "Slectionnez un thme</tr>\n";
   // criture de l'alphabet
   ch += "<tr><td align='center'>" + alphabet.ecrit() + "</td></tr>\n";
   // emplacement du bouton "rejouer"
   ch += "<tr><td align='right'>" + this.ecrit_rejouer() + "</td></tr>\n";
   // criture des cases du texte  deviner (seulement les cases)
   ch += "<tr><td align='center'>" + texte.ecrit() + "</td></tr>\n";
   // criture du tableau des scores
   ch += "<tr><td align='center'>" + score.ecrit() + "</td></tr>\n"; 
   ch += "</table>"; 
   document.write(ch);
}

// termine le jeu en cours lorsque le joueur a trouv ou s'il a fait 6 erreurs
// si "reussite" est vrai le jeu se termine avec succs,
// sinon par un chec;
// le score est mis  jour
function CJ_termine(erreur) {
   this.fin_mot = true;
   liste.mot_termine();
   if (erreur == this.erreurs) {
      texte.affiche_fin();
	  image.fin();
	  score.maj(false);
   }
   else score.maj(true);
   this.affiche_rejouer();
   alphabet.cache();
   window.focus();
   commentaire(erreur);
//   LComments[erreur].choix_lib();
}

// action dclenche lorsque l'utilisateur clique sur le bouton "rejouer"
// seulement lorsqu'on a fini le mot
function CJ_rejouer() {
   image.reinit();
   if (this.fin_mot) liste.choix_mot();
   this.fin_mot = false;
   this.cache_rejouer();
   alphabet.reinit();
}

// affichage du bouton rejouer
function CJ_affiche_rejouer() {
   document.images["rejouer"].src = _rep_images + "bouton_rejouer.gif";
}

// cahe le bouton rejouer
function CJ_cache_rejouer() {
   document.images["rejouer"].src = _rep_images + bouton_vide;
   window.focus();
}

// fonction de rollover sur les lettres de l'alphabet
function CJ_rollover(numlettre, passif) {
   alphabet.rollover(numlettre, passif);
}

// ajoute un lement du dessin du pendu
function CJ_sanctionner() {
   image.ajoute_elt(1);
}

// choix d'une lettre dans l'alphabet
function CJ_choisir(numlettre) {
   var choix_lettre = alphabet.choix_lettre(numlettre);
   if (choix_lettre) texte.choixLettre(choix_lettre);
}

// ragit au clic sur le bouton "extrmits"
function CJ_extremites() {
   texte.extremites(true);
}

// ragit au clic sur le bouton "dfinition"
function CJ_definition() {
   texte.affiche_def();
}

// ragit au clic sur le bouton "contexte"
function CJ_contexte() {
   texte.affiche_contexte();
}

// dclench lorsqu'on clique sur un thme dans la liste droulante des thmes
function CJ_choix_theme(numtheme) {
   liste.choix_theme(numtheme);
}

CJeu.prototype.ecrit = CJ_ecrit;
CJeu.prototype.demarrer = CJ_demarrer;
CJeu.prototype.termine = CJ_termine;
CJeu.prototype.rejouer = CJ_rejouer;
CJeu.prototype.ecrit_rejouer = CJ_ecrit_rejouer;
CJeu.prototype.affiche_rejouer = CJ_affiche_rejouer;
CJeu.prototype.cache_rejouer = CJ_cache_rejouer;
CJeu.prototype.rollover = CJ_rollover;
CJeu.prototype.choisir = CJ_choisir;
CJeu.prototype.sanctionner = CJ_sanctionner;
CJeu.prototype.extremites = CJ_extremites;
CJeu.prototype.definition = CJ_definition;
CJeu.prototype.contexte = CJ_contexte;
CJeu.prototype.choix_theme = CJ_choix_theme;

// *****************************************************
// FONCTIONS UTILITAIRES


function main() {
   jeu = new CJeu();
   jeu.demarrer();
}


