Clazz.declarePackage ("J.util");
Clazz.load (null, "J.util.Parser", ["JU.ArrayUtil", "$.ParserJS", "J.util.Logger", "$.Txt"], function () {
c$ = Clazz.declareType (J.util, "Parser");
c$.fixDataString = $_M(c$, "fixDataString", 
function (str) {
str = str.$replace (';', str.indexOf ('\n') < 0 ? '\n' : ' ');
str = J.util.Txt.trim (str, "\n \t");
str = J.util.Txt.simpleReplace (str, "\n ", "\n");
str = J.util.Txt.simpleReplace (str, "\n\n", "\n");
return str;
}, "~S");
c$.getQuotedStringAt = $_M(c$, "getQuotedStringAt", 
function (line, ipt0) {
var next = [ipt0];
return J.util.Parser.getQuotedStringNext (line, next);
}, "~S,~N");
c$.getQuotedStringNext = $_M(c$, "getQuotedStringNext", 
function (line, next) {
var value = line;
var i = next[0];
if (i < 0 || (i = value.indexOf ("\"", i)) < 0) return "";
next[0] = ++i;
value = value.substring (i);
i = -1;
while (++i < value.length && value.charAt (i) != '"') if (value.charAt (i) == '\\') i++;

next[0] += i + 1;
return value.substring (0, i);
}, "~S,~A");
c$.isOneOf = $_M(c$, "isOneOf", 
function (key, semiList) {
if (semiList.length == 0) return false;
if (semiList.charAt (0) != ';') semiList = ";" + semiList + ";";
return key.indexOf (";") < 0 && semiList.indexOf (';' + key + ';') >= 0;
}, "~S,~S");
c$.getQuotedAttribute = $_M(c$, "getQuotedAttribute", 
function (info, name) {
var i = info.indexOf (name + "=");
return (i < 0 ? null : J.util.Parser.getQuotedStringAt (info, i));
}, "~S,~S");
c$.approx = $_M(c$, "approx", 
function (f, n) {
return Math.round (f * n) / n;
}, "~N,~N");
c$.parseFloatArray2d = $_M(c$, "parseFloatArray2d", 
function (str) {
str = J.util.Parser.fixDataString (str);
var lines = J.util.Parser.markLines (str, '\n');
var nLines = lines.length;
var data = JU.ArrayUtil.newFloat2 (nLines);
for (var iLine = 0, pt = 0; iLine < nLines; pt = lines[iLine++]) {
var tokens = JU.ParserJS.getTokens (str.substring (pt, lines[iLine]));
JU.ParserJS.parseFloatArrayData (tokens, data[iLine] =  Clazz.newFloatArray (tokens.length, 0));
}
return data;
}, "~S");
c$.parseFloatArray3d = $_M(c$, "parseFloatArray3d", 
function (str) {
str = J.util.Parser.fixDataString (str);
var lines = J.util.Parser.markLines (str, '\n');
var nLines = lines.length;
var tokens = JU.ParserJS.getTokens (str.substring (0, lines[0]));
if (tokens.length != 3) return  Clazz.newFloatArray (0, 0, 0, 0);
var nX = JU.ParserJS.parseInt (tokens[0]);
var nY = JU.ParserJS.parseInt (tokens[1]);
var nZ = JU.ParserJS.parseInt (tokens[2]);
if (nX < 1 || nY < 1 || nZ < 1) return  Clazz.newFloatArray (1, 1, 1, 0);
var data = JU.ArrayUtil.newFloat3 (nX, nY);
var iX = 0;
var iY = 0;
for (var iLine = 1, pt = lines[0]; iLine < nLines && iX < nX; pt = lines[iLine++]) {
tokens = JU.ParserJS.getTokens (str.substring (pt, lines[iLine]));
if (tokens.length < nZ) continue;
JU.ParserJS.parseFloatArrayData (tokens, data[iX][iY] =  Clazz.newFloatArray (tokens.length, 0));
if (++iY == nY) {
iX++;
iY = 0;
}}
if (iX != nX) {
J.util.Logger.info ("Error reading 3D data -- nX = " + nX + ", but only " + iX + " blocks read");
return  Clazz.newFloatArray (1, 1, 1, 0);
}return data;
}, "~S");
c$.markLines = $_M(c$, "markLines", 
function (data, eol) {
var nLines = 0;
for (var i = data.length; --i >= 0; ) if (data.charAt (i) == eol) nLines++;

var lines =  Clazz.newIntArray (nLines + 1, 0);
nLines = 0;
var pt = 0;
while ((pt = data.indexOf (eol, pt)) >= 0) lines[nLines++] = ++pt;

lines[nLines] = data.length;
return lines;
}, "~S,~S");
Clazz.defineStatics (c$,
"FLOAT_MIN_SAFE", 2E-45);
});
