/*
 *
 * SpreadJS Library 1.0.0
 * http://wijmo.com/
 *
 * Copyright(c) GrapeCity, Inc.  All rights reserved.
 *
 * Licensed under the Wijmo Commercial License. Also available under the GNU GPL Version 3 license.
 * licensing@wijmo.com
 * http://wijmo.com/widgets/license/
 *
 *
 **/
(function(window, $)
{
    "use strict";;
    var version = $().jquery ? $().jquery.split('.') : "";
    if(parseInt(version[0],10) > 1 || parseInt(version[0],10) === 1 && parseInt(version[1],10) >= 9)
    {
        $.event.handle = $.event.dispatch;
        var matched,
            browser;
        $.uaMatch = function(ua)
        {
            ua = ua.toLowerCase();
            var match = /(chrome)[ \/]([\w.]+)/.exec(ua) || /(webkit)[ \/]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
            return{
                    browser: match[1] || "",
                    version: match[2] || "0"
                }
        };
        if(!$.browser)
        {
            matched = $.uaMatch(navigator.userAgent);
            browser = {};
            if(matched.browser)
            {
                browser[matched.browser] = true;
                browser.version = matched.version
            }
            if(browser.chrome)
                browser.webkit = true;
            else if(browser.webkit)
                browser.safari = true;
            $.browser = browser
        }
        var oldToggle = $.fn.toggle;
        $.fn.toggle = function(fn, fn2)
        {
            if(!$.isFunction(fn) || !$.isFunction(fn2))
                return oldToggle.apply(this,arguments);
            var args = arguments,
                guid = fn.guid || $.guid++,
                i = 0,
                toggler = function(event)
                {
                    var lastToggle = ($._data(this,"lastToggle" + fn.guid) || 0) % i;
                    $._data(this,"lastToggle" + fn.guid,lastToggle + 1);
                    event.preventDefault();
                    return args[lastToggle].apply(this,arguments) || false
                };
            toggler.guid = guid;
            while(i < args.length)
                args[i++].guid = guid;
            return this.click(toggler)
        };
        var oldSelf = $.fn.andSelf || $.fn.addBack;
        $.fn.andSelf = function()
        {
            return oldSelf.apply(this,arguments)
        }
    }
    version = $.ui.dialog.version ? $.ui.dialog.version.split('.') : "";
    if(parseInt(version[0],10) > 1 || parseInt(version[0],10) === 1 && parseInt(version[1],10) >= 10)
    {
        $.extend($.ui.dialog,{
            uuid: 0,
            maxZ: 0,
            getTitleId: function($el)
            {
                var id = $el.attr("id");
                if(!id)
                {
                    this.uuid += 1;
                    id = this.uuid
                }
                return"ui-dialog-title-" + id
            },
            overlay: function(dialog)
            {
                this.$el = $.ui.dialog.overlay.create(dialog)
            }
        });
        $.extend($.ui.dialog.overlay,{
            instances: [],
            oldInstances: [],
            maxZ: 0,
            events: $.map("focus,mousedown,mouseup,keydown,keypress,click".split(","),function(event)
            {
                return event + ".dialog-overlay"
            }).join(" "),
            create: function(dialog)
            {
                if(this.instances.length === 0)
                {
                    setTimeout(function()
                    {
                        if($.ui.dialog.overlay.instances.length)
                            $(document).bind($.ui.dialog.overlay.events,function(event)
                            {
                                if($(event.target).zIndex() < $.ui.dialog.overlay.maxZ)
                                    return false
                            })
                    },1);
                    $(window).bind("resize.dialog-overlay",$.ui.dialog.overlay.resize)
                }
                var $el = this.oldInstances.pop() || $("<div>").addClass("ui-widget-overlay");
                $(document).bind("keydown.dialog-overlay",function(event)
                {
                    var instances = $.ui.dialog.overlay.instances;
                    if(instances.length !== 0 && instances[instances.length - 1] === $el && dialog.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode && event.keyCode === $.ui.keyCode.ESCAPE)
                    {
                        dialog.close(event);
                        event.preventDefault()
                    }
                });
                $el.appendTo(document.body).css({
                    width: this.width(),
                    height: this.height()
                });
                if($.fn.bgiframe)
                    $el.bgiframe();
                this.instances.push($el);
                return $el
            },
            destroy: function($el)
            {
                var indexOf = $.inArray($el,this.instances),
                    maxZ = 0;
                if(indexOf !== -1)
                    this.oldInstances.push(this.instances.splice(indexOf,1)[0]);
                if(this.instances.length === 0)
                    $([document,window]).unbind(".dialog-overlay");
                $el.height(0).width(0).remove();
                $.each(this.instances,function()
                {
                    maxZ = Math.max(maxZ,this.css("z-index"))
                });
                this.maxZ = maxZ
            },
            height: function()
            {
                var scrollHeight,
                    offsetHeight;
                if($.ui.ie)
                {
                    scrollHeight = Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);
                    offsetHeight = Math.max(document.documentElement.offsetHeight,document.body.offsetHeight);
                    if(scrollHeight < offsetHeight)
                        return $(window).height() + "px";
                    else
                        return scrollHeight + "px"
                }
                else
                    return $(document).height() + "px"
            },
            width: function()
            {
                var scrollWidth,
                    offsetWidth;
                if($.ui.ie)
                {
                    scrollWidth = Math.max(document.documentElement.scrollWidth,document.body.scrollWidth);
                    offsetWidth = Math.max(document.documentElement.offsetWidth,document.body.offsetWidth);
                    if(scrollWidth < offsetWidth)
                        return $(window).width() + "px";
                    else
                        return scrollWidth + "px"
                }
                else
                    return $(document).width() + "px"
            },
            resize: function()
            {
                var $overlays = $([]);
                $.each($.ui.dialog.overlay.instances,function()
                {
                    $overlays = $overlays.add(this)
                });
                $overlays.css({
                    width: 0,
                    height: 0
                }).css({
                    width: $.ui.dialog.overlay.width(),
                    height: $.ui.dialog.overlay.height()
                })
            }
        });
        $.extend($.ui.dialog.overlay.prototype,{destroy: function()
            {
                $.ui.dialog.overlay.destroy(this.$el)
            }});
        if($.uiBackCompat !== false)
            (function($)
            {
                var _position = $.fn.position;
                $.fn.position = function(options)
                {
                    if(!options || !options.offset)
                        return _position.call(this,options);
                    var offset = options.offset.split(" "),
                        at = options.at.split(" ");
                    if(offset.length === 1)
                        offset[1] = offset[0];
                    if(/^\d/.test(offset[0]))
                        offset[0] = "+" + offset[0];
                    if(/^\d/.test(offset[1]))
                        offset[1] = "+" + offset[1];
                    if(at.length === 1)
                        if(/left|center|right/.test(at[0]))
                            at[1] = "center";
                        else
                        {
                            at[1] = at[0];
                            at[0] = "center"
                        }
                    return _position.call(this,$.extend(options,{
                            at: at[0] + offset[0] + " " + at[1] + offset[1],
                            offset: undefined
                        }))
                }
            })(jQuery)
    }
})(window,jQuery);
(function(window, $)
{
    "use strict";;
    var const_undefined = "undefined";
    var const_function = "function";
    var GrapeCity = window.GrapeCity;
    if(typeof GrapeCity === const_undefined)
        GrapeCity = window.GrapeCity = {Version: "1.0.0"};
    var UI = GrapeCity.UI;
    if(typeof UI === const_undefined)
        UI = GrapeCity.UI = {};
    var document = window.document;
    if(typeof $.event.special.gcmousewheel === const_undefined)
        (function($)
        {
            var domMS = 'DOMMouseScroll',
                ms = 'mousewheel';
            var types = [domMS,ms];
            function handler(event)
            {
                var args = [].slice.call(arguments,1),
                    delta = 0,
                    returnValue = true;
                event = $.event.fix(event || window.event);
                event.type = "gc" + ms;
                if((event.wheelDelta === undefined || event.wheelDelta === null) && (event.detail === undefined || event.detail === null))
                {
                    event.wheelDelta = event.originalEvent.wheelDelta;
                    event.detail = event.originalEvent.detail
                }
                if(event.wheelDelta)
                    delta = event.wheelDelta / 120;
                if(event.detail)
                    delta = -event.detail / 3;
                args.unshift(event,delta);
                return $.event.handle.apply(event.target || event.srcElement,args)
            }
            $.event.special.gcmousewheel = {
                setup: function()
                {
                    if(this.addEventListener)
                        for(var i = types.length; i; )
                        {
                            var t = types[--i];
                            if(t === ms)
                                this.addEventListener(domMS,handler,false);
                            this.addEventListener(t,handler,false)
                        }
                    else
                        this.attachEvent("on" + ms,handler)
                },
                teardown: function()
                {
                    if(this.removeEventListener)
                        for(var i = types.length; i; )
                        {
                            var t = types[--i];
                            if(t === ms)
                                this.removeEventListener(domMS,handler,false);
                            this.removeEventListener(t,handler,false)
                        }
                    else
                        this.detachEvent("on" + ms,handler)
                }
            };
            $.fn.extend({
                handlegcmousewheel: function(fn)
                {
                    return fn ? this.bind(ms,fn) : this.trigger(ms)
                },
                unhandlegcmousewheel: function(fn)
                {
                    return this.unbind(ms,fn)
                }
            })
        })(jQuery);
    var gcUIElement = "gcUIElement";
    UI.Global = function()
    {
        if(typeof window.gcGlobal === const_undefined)
            this._init()
    };
    UI.Global.prototype = {
        activeElement: null,
        _eventSuspended: 0,
        keyDown: function(event)
        {
            var gcGlobal = window.gcGlobal;
            if(gcGlobal._eventSuspended > 0)
                return;
            var activeElement = gcGlobal.activeElement;
            if(activeElement && activeElement._validationSelect)
            {
                var $select = $(activeElement._validationSelect);
                if($select.is(":visible"))
                    return
            }
            if(activeElement && activeElement.getCellType && activeElement.getActiveRowIndex && activeElement.getActiveColumnIndex)
            {
                var cellType = activeElement.getCellType(activeElement.getActiveRowIndex(),activeElement.getActiveColumnIndex());
                if(cellType && cellType.isReservedKey(event))
                    return
            }
            if(activeElement && activeElement.doKeyDown)
            {
                activeElement.doKeyDown(event);
                if((event.keyCode === UI.Key.z || event.keyCode === UI.Key.y) && event.ctrlKey && !event.altKey)
                    UI.cancelDefault(event)
            }
        },
        keyUp: function(event)
        {
            var gcGlobal = window.gcGlobal;
            if(gcGlobal._eventSuspended > 0)
                return;
            var activeElement = gcGlobal.activeElement;
            if(activeElement && activeElement.getCellType && activeElement.getActiveRowIndex && activeElement.getActiveColumnIndex)
            {
                var cellType = activeElement.getCellType(activeElement.getActiveRowIndex(),activeElement.getActiveColumnIndex());
                if(cellType && cellType.isReservedKey(event))
                    return
            }
            if(activeElement && activeElement.doKeyUp)
                activeElement.doKeyUp(event)
        },
        docSelectStart: function(event)
        {
            if(!document.all && window.gcGlobal && window.gcGlobal.activeElement)
                UI.cancelDefault(event);
            return false
        },
        getUIElement: function(e)
        {
            var w = e;
            while(w && w.tagName !== "BODY")
            {
                if(typeof w.getAttribute !== const_function)
                    break;
                var t = w.getAttribute(gcUIElement);
                if(!t)
                    t = w.gcUIElement;
                if(t)
                    return w;
                w = w.parentNode
            }
            return null
        },
        _init: function()
        {
            window.gcGlobal = this;
            this._eventSuspended = 0;
            var global = UI.Global;
            if($.browser.msie && document.documentMode !== undefined && document.documentMode !== null && document.documentMode < 9)
            {
                window.attachEvent('keydown',global.prototype.keyDown);
                window.attachEvent('keyup',global.prototype.keyUp);
                document.attachEvent('selectstart',global.prototype.docSelectStart)
            }
            else
            {
                window.addEventListener('keydown',global.prototype.keyDown,true);
                window.addEventListener('keyup',global.prototype.keyUp,true);
                document.addEventListener('selectstart',global.prototype.docSelectStart,true)
            }
            $(document).mousedown(function(e)
            {
                var ae = window.gcGlobal.activeElement;
                if(ae)
                {
                    var hitElement = global.prototype.getUIElement(e.target);
                    if(!hitElement && ae.endEdit)
                    {
                        ae.endEdit();
                        ae.repaint()
                    }
                    if(!hitElement && ae._disposeValidationUI)
                        ae._disposeValidationUI();
                    if(!hitElement)
                        window.gcGlobal.activeElement = null
                }
            });
            $(document).ready(function()
            {
                GrapeCity.UI.Global.prototype._createDummyObjects()
            })
        },
        _createDummyObjects: function()
        {
            var global = GrapeCity.UI.Global;
            if(!global.prototype._dummyContent)
            {
                var createSpan = function(className)
                    {
                        var t = document.createElement("span");
                        t.className = className;
                        t.style.display = "none";
                        document.body.insertBefore(t,null);
                        return t
                    };
                global.prototype._dummyHeader = createSpan("ui-widget-header ui-state-default");
                global.prototype._dummyContent = createSpan("ui-widget-content");
                global.prototype._dummyHover = createSpan("ui-state-hover");
                global.prototype._dummyHighlight = createSpan("ui-state-highlight")
            }
        },
        getWijmoThemeStyle: function(visualState)
        {
            var global = UI.Global,
                vs = UI.VisualState;
            var t = global.prototype._dummyHeader;
            if(visualState === vs.Highlight || visualState === vs.Selected)
                t = global.prototype._dummyHighlight;
            else if(visualState === vs.Hover)
                t = global.prototype._dummyHover;
            var ts = t.currentStyle;
            if(document.defaultView && document.defaultView.getComputedStyle)
                ts = document.defaultView.getComputedStyle(t,'');
            return ts
        },
        suspendEvent: function()
        {
            var gcGlobal = window.gcGlobal;
            gcGlobal._eventSuspended++
        },
        resumeEvent: function()
        {
            var gcGlobal = window.gcGlobal;
            gcGlobal._eventSuspended--;
            if(gcGlobal._eventSuspended < 0)
                gcGlobal._eventSuspended = 0
        }
    };
    window.gcGlobal = new UI.Global;
    UI.Key = {
        left: 37,
        right: 39,
        up: 38,
        down: 40,
        tab: 9,
        enter: 13,
        shift: 16,
        ctrl: 17,
        space: 32,
        altkey: 18,
        home: 36,
        end: 35,
        pup: 33,
        pdn: 34,
        backspace: 8,
        del: 46,
        esc: 27,
        c: 67,
        v: 86,
        x: 88,
        z: 90,
        y: 89
    };
    UI.KeyMap = function(key, ctrl, shift, alt, action)
    {
        this.key = key;
        this.ctrl = ctrl;
        this.shift = shift;
        this.alt = alt;
        this.action = action
    };
    Array.prototype.remove = function(item)
    {
        for(var i = 0; i < this.length; i++)
            if(this[i] === item)
            {
                this.splice(i,1);
                return
            }
    };
    Array.prototype.contains = function(item)
    {
        for(var i = 0; i < this.length; i++)
            if(this[i] === item)
                return true;
        return false
    };
    Array.prototype.indexOf = function(item, index)
    {
        if(index === undefined || index === null || isNaN(index))
            index = 0;
        for(var i = index; i < this.length; i++)
            if(this[i] === item)
                return i;
        return-1
    };
    if(!Array.prototype.map)
        Array.prototype.map = function(callback, thisArg)
        {
            var T,
                A,
                k;
            var O = window.Object(this);
            var len = O.length >>> 0;
            if(typeof callback !== "function")
                throw new TypeError(callback + " is not a function");
            if(thisArg)
                T = thisArg;
            A = new Array(len);
            k = 0;
            while(k < len)
            {
                var kValue,
                    mappedValue;
                if(k in O)
                {
                    kValue = O[k];
                    mappedValue = callback.call(T,kValue,k,O);
                    A[k] = mappedValue
                }
                k++
            }
            return A
        };
    UI.Point = function(x, y)
    {
        this.x = x;
        this.y = y;
        this.clone = function()
        {
            return new UI.Point(this.x,this.y)
        }
    };
    UI.Rect = function(x, y, w, h)
    {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h
    };
    UI.Rect.prototype.intersect = function(x, y, width, height)
    {
        return x < this.x + this.width && this.x < x + width && y < this.y + this.height && this.y < y + height
    };
    UI.Rect.prototype.intersectRect = function(rect)
    {
        return rect.x < this.x + this.width && this.x < rect.x + rect.width && rect.y < this.y + this.height && this.y < rect.y + rect.height
    };
    UI.Rect.prototype.contains = function(x, y)
    {
        return x < this.x + this.width && this.x < x && y < this.y + this.height && this.y < y
    };
    UI.Rect.prototype.getIntersectRect = function(rect)
    {
        if(this.intersectRect(rect))
        {
            var x1_s = this.x;
            var y1_s = this.y;
            var x1_e = this.x + this.width;
            var y1_e = this.y + this.height;
            var x2_s = rect.x;
            var y2_s = rect.y;
            var x2_e = rect.x + rect.width;
            var y2_e = rect.y + rect.height;
            var intersectX_s = Math.max(x1_s,x2_s);
            var intersectY_s = Math.max(y1_s,y2_s);
            var intersectX_e = Math.min(x1_e,x2_e);
            var intersectY_e = Math.min(y1_e,y2_e);
            var newX = intersectX_s;
            var newY = intersectY_s;
            var newWidth = intersectX_e - intersectX_s;
            var newHeight = intersectY_e - intersectY_s;
            if(newWidth > 0 && newHeight > 0)
                return new UI.Rect(newX,newY,newWidth,newHeight)
        }
        return null
    };
    UI.Direction = {
        up: 1,
        down: 2,
        left: 3,
        right: 4
    };
    UI.HorizontalAlign = {
        left: 0,
        center: 1,
        right: 2,
        general: 3
    };
    UI.VerticalAlign = {
        top: 0,
        center: 1,
        bottom: 2
    };
    UI.HorizontalPosition = {
        left: 0,
        center: 1,
        right: 2,
        nearest: 3
    };
    UI.VerticalPosition = {
        top: 0,
        center: 1,
        bottom: 2,
        nearest: 3
    };
    UI.HeaderAutoText = {
        blank: 0,
        numbers: 1,
        letters: 2
    };
    UI.ClipboardPasteOptions = {
        All: 0,
        Values: 1,
        Formatting: 2,
        Formulas: 3
    };
    UI.TextFileOpenFlags = {
        None: 0,
        IncludeRowHeader: 1,
        IncludeColumnHeader: 2,
        UnFormatted: 8,
        ImportFormula: 16
    };
    UI.VisualState = {
        Normal: 0,
        Highlight: 1,
        Selected: 2,
        Active: 3,
        Hover: 4
    };
    UI.ReferenceStyle = {
        A1: 0,
        R1C1: 1
    };
    UI.LineStyle = {
        empty: 0,
        thin: 1,
        medium: 2,
        dashed: 3,
        dotted: 4,
        thick: 5,
        double: 6,
        hair: 7,
        mediumDashed: 8,
        dashDot: 9,
        mediumDashDot: 10,
        dashDotDot: 11,
        mediumDashDotDot: 12,
        slantedDashDot: 13
    };
    UI.LineBorder = function(color, style)
    {
        this.color = color;
        this.style = style
    };
    UI.LineBorder.prototype = {
        color: "black",
        style: UI.LineStyle.empty,
        width: function(border)
        {
            if(border && border.style)
            {
                var LineStyle = UI.LineStyle;
                switch(border.style)
                {
                    case LineStyle.dashDot:
                    case LineStyle.thin:
                    case LineStyle.dashed:
                    case LineStyle.dotted:
                    case LineStyle.hair:
                    case LineStyle.dashDotDot:
                        return 1;
                    case LineStyle.medium:
                    case LineStyle.mediumDashDot:
                    case LineStyle.mediumDashDotDot:
                    case LineStyle.mediumDashed:
                    case LineStyle.slantedDashDot:
                        return 2;
                    case LineStyle.thick:
                    case LineStyle.double:
                        return 3
                }
            }
            return 0
        },
        _weight: function(border)
        {
            if(border && border.style)
            {
                var LineStyle = UI.LineStyle;
                switch(border.style)
                {
                    case LineStyle.dashDot:
                    case LineStyle.dashed:
                    case LineStyle.dotted:
                    case LineStyle.dashDotDot:
                    case LineStyle.hair:
                        return 100;
                    case LineStyle.thin:
                        return 101;
                    case LineStyle.slantedDashDot:
                    case LineStyle.mediumDashed:
                    case LineStyle.mediumDashDot:
                    case LineStyle.mediumDashDotDot:
                        return 198;
                    case LineStyle.medium:
                        return 199;
                    case LineStyle.thick:
                        return 300;
                    case LineStyle.double:
                        return 90;
                    case LineStyle.empty:
                        return 0
                }
            }
            return-2
        }
    };
    var _fontProps = function()
        {
            var dict = {};
            dict['font-style'] = function(value, domElement)
            {
                if(value)
                    domElement.style.fontStyle = value
            };
            dict['font-variant'] = function(value, domElement)
            {
                if(value)
                    domElement.style.fontVariant = value
            };
            dict['font-weight'] = function(value, domElement)
            {
                if(value)
                    domElement.style.fontWeight = value
            };
            dict['font-size'] = function(value, domElement)
            {
                if(value)
                    domElement.style.fontSize = value
            };
            dict['line-height'] = function(value, domElement)
            {
                if(value)
                    domElement.style.lineHeight = value
            };
            dict['font-family'] = function(value, domElement)
            {
                if(value)
                    domElement.style.fontFamily = value
            };
            return dict
        }();
    function buildFontString(cssStyle)
    {
        if($.browser.safari)
            return cssStyle.font;
        var f = cssStyle.fontStyle;
        f += " " + cssStyle.fontVariant;
        f += " " + cssStyle.fontWeight;
        f += " " + cssStyle.fontSize;
        f += "/" + cssStyle.lineHeight;
        f += " " + cssStyle.fontFamily;
        return f
    }
    function beginBulidFont(sheet)
    {
        var span = document.createElement("span");
        span.style.visibility = "hidden";
        span.style.top = "-10000px";
        span.style.left = "-10000px";
        span.style.position = "absolute";
        span.className = "gcFontDetectSpanStyle";
        span.setAttribute(gcUIElement,"gcFontDetectSpan");
        document.body.insertBefore(span,null);
        return{
                span: span,
                dispose: function()
                {
                    document.body.removeChild(span);
                    delete this.span
                }
            }
    }
    UI.FontFactory = function(sheet)
    {
        this._sheet = sheet
    };
    UI.FontFactory.prototype = {buildFont: function(opt, font)
        {
            var f = '';
            if(opt)
            {
                var res = beginBulidFont(this.sheet);
                try
                {
                    if(font)
                        res.span.style.font = font;
                    $.each(_fontProps,function(k, fn)
                    {
                        fn(opt.hasOwnProperty(k) ? opt[k] : null,res.span)
                    })
                }
                finally
                {
                    var fs = res.span.currentStyle;
                    if(document.defaultView && document.defaultView.getComputedStyle)
                        fs = document.defaultView.getComputedStyle(res.span,'');
                    f = buildFontString(fs);
                    res.dispose()
                }
            }
            return f
        }};
    UI.Style = function(backColor, foreColor, hAlign, vAlign, font, themeFont, formatter, borderLeft, borderTop, borderRight, borderBottom, locked, textIndent, wordWrap, shrinkToFit, backgroundImage, cellType)
    {
        this.backgroundImage = backgroundImage;
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.font = font;
        this.themeFont = themeFont;
        this.formatter = formatter;
        this.borderLeft = borderLeft;
        this.borderTop = borderTop;
        this.borderRight = borderRight;
        this.borderBottom = borderBottom;
        this.locked = locked;
        this.textIndent = textIndent;
        this.wordWrap = wordWrap;
        this.shrinkToFit = shrinkToFit;
        this.validator = undefined;
        this.cellType = cellType
    };
    UI.Style.prototype._initDefault = function()
    {
        this.backgroundImage = undefined;
        this.backColor = undefined;
        this.foreColor = undefined;
        this.hAlign = undefined;
        this.vAlign = undefined;
        this.font = undefined;
        this.themeFont = undefined;
        this.formatter = undefined;
        this.validator = undefined;
        this.borderLeft = undefined;
        this.borderTop = undefined;
        this.borderRight = undefined;
        this.borderBottom = undefined;
        this.locked = undefined;
        this.textIndent = undefined;
        this.wordWrap = undefined;
        this.shrinkToFit = undefined;
        this.cellType = undefined
    };
    UI.Style.prototype.copyFrom = function(style)
    {
        this.backgroundImage = style.backgroundImage;
        this.backColor = style.backColor;
        this.foreColor = style.foreColor;
        this.hAlign = style.hAlign;
        this.vAlign = style.vAlign;
        this.font = style.font;
        this.themeFont = style.themeFont;
        this.formatter = style.formatter;
        this._autoFormatter = style._autoFormatter;
        this.validator = style.validator;
        this.borderLeft = style.borderLeft;
        this.borderTop = style.borderTop;
        this.borderRight = style.borderRight;
        this.borderBottom = style.borderBottom;
        this.locked = style.locked;
        this.textIndent = style.textIndent;
        this.wordWrap = style.wordWrap;
        this.shrinkToFit = style.shrinkToFit;
        this.cellType = style.cellType
    };
    function _cloneLineBorder(border)
    {
        if(border && border instanceof UI.LineBorder)
            return new UI.LineBorder(border.color,border.style);
        return border
    }
    UI.Style.prototype.compose = function(style, force)
    {
        if(force || typeof this.backgroundImage === const_undefined)
            this.backgroundImage = style.backgroundImage;
        if(force || typeof this.backColor === const_undefined)
            this.backColor = style.backColor;
        if(force || typeof this.foreColor === const_undefined)
            this.foreColor = style.foreColor;
        if(force || typeof this.hAlign === const_undefined)
            this.hAlign = style.hAlign;
        if(force || typeof this.vAlign === const_undefined)
            this.vAlign = style.vAlign;
        if(force || typeof this.font === const_undefined)
            this.font = style.font;
        if(force || typeof this.themeFont === const_undefined)
            this.themeFont = style.themeFont;
        if(force || typeof this.formatter === const_undefined)
            this.formatter = style.formatter;
        if(force || typeof this.validator === const_undefined)
            this.validator = style.validator;
        if(force || typeof this._autoFormatter === const_undefined)
            this._autoFormatter = style._autoFormatter;
        if(force || typeof this.borderLeft === const_undefined)
            this.borderLeft = _cloneLineBorder(style.borderLeft);
        if(force || typeof this.borderTop === const_undefined)
            this.borderTop = _cloneLineBorder(style.borderTop);
        if(force || typeof this.borderRight === const_undefined)
            this.borderRight = _cloneLineBorder(style.borderRight);
        if(force || typeof this.borderBottom === const_undefined)
            this.borderBottom = _cloneLineBorder(style.borderBottom);
        if(force || typeof this.locked === const_undefined)
            this.locked = style.locked;
        if(force || typeof this.textIndent === const_undefined)
            this.textIndent = style.textIndent;
        if(force || typeof this.wordWrap === const_undefined)
            this.wordWrap = style.wordWrap;
        if(force || typeof this.shrinkToFit === const_undefined)
            this.shrinkToFit = style.shrinkToFit;
        if(force || typeof this.cellType === const_undefined)
            this.cellType = style.cellType
    };
    UI.Style.prototype.clear = function(propertyName)
    {
        if(arguments.length === 0)
        {
            this._initDefault();
            return
        }
        if(propertyName === "dataValidator")
            propertyName = "validator";
        this[propertyName] = undefined
    };
    var measureSpan;
    function composeFont(font, fontFamily)
    {
        if(!fontFamily)
            return font;
        if(!measureSpan)
        {
            var span = document.createElement("span");
            span.style.visibility = "hidden";
            span.style.top = "-10000px";
            span.style.left = "-10000px";
            document.body.insertBefore(span,null);
            measureSpan = span
        }
        if(font)
            measureSpan.style.font = font;
        else
            measureSpan.style.fontSize = '10pt';
        measureSpan.style.fontFamily = fontFamily;
        var fs = measureSpan.currentStyle;
        if(document.defaultView && document.defaultView.getComputedStyle)
            fs = document.defaultView.getComputedStyle(measureSpan,'');
        return buildFontString(fs)
    }
    UI.Style.prototype._normalize = function(theme)
    {
        var v,
            c;
        for(var p in this)
            if(theme && (p === 'foreColor' || p === 'backColor'))
            {
                v = this[p];
                if(v && theme.getColor)
                {
                    c = theme.getColor(v);
                    if(c)
                        this[p] = c
                }
            }
            else if(theme && (p === 'borderLeft' || p === 'borderTop' || p === 'borderRight' || p === 'borderBottom'))
            {
                var border = this[p];
                if(border)
                {
                    v = border.color;
                    if(v && theme.getColor)
                    {
                        c = theme.getColor(v);
                        if(c)
                            this[p].color = c
                    }
                }
            }
        if(this.themeFont && theme && theme.getFont)
            this.font = composeFont(this.font,theme.getFont(this.themeFont));
        return this
    };
    UI.NameInfo = function(name, expr, row, column)
    {
        this._name = name;
        this._baseRow = row;
        this._baseColumn = column;
        this._expr = expr
    };
    UI.NameInfo.prototype = {
        getName: function()
        {
            return this._name
        },
        getRow: function()
        {
            return this._baseRow
        },
        getColumn: function()
        {
            return this._baseColumn
        },
        getExpression: function()
        {
            return this._expr
        }
    };
    UI.createEventHandler = function(element, method)
    {
        return function()
            {
                return method.apply(element,arguments)
            }
    };
    UI.cancelDefault = function(e)
    {
        if(e.preventDefault)
        {
            e.preventDefault();
            e.stopPropagation()
        }
        else
        {
            e.cancelBubble = false;
            e.returnValue = false
        }
        return false
    };
    var canvasApiFound,
        slCanvasApiFound;
    UI._isStandardCanvas = function()
    {
        if(typeof canvasApiFound === const_undefined)
            canvasApiFound = typeof document.createElement("canvas").getContext !== const_undefined;
        return canvasApiFound
    };
    UI._isSilverlightCanvas = function()
    {
        if(UI._isStandardCanvas())
            return true;
        if(typeof slCanvasApiFound === const_undefined)
            slCanvasApiFound = typeof window.slcanvas !== const_undefined;
        return slCanvasApiFound
    };
    UI._useDoubleBuffer = function()
    {
        return UI._isStandardCanvas() || UI._isSilverlightCanvas()
    };
    UI.GcUIElement = function(x, y, w, h, name)
    {
        this._init(x,y,w,h,name)
    };
    UI.GcUIElement.prototype = {
        _init: function(x, y, w, h, name)
        {
            this._bounds = new UI.Rect(x,y,w,h);
            this._name = name
        },
        getBounds: function()
        {
            return this._bounds
        },
        setBounds: function(rect)
        {
            this._bounds.x = rect.x;
            this._bounds.y = rect.y;
            this._bounds.width = rect.width;
            this._bounds.height = rect.height
        },
        _draw: function(ctx)
        {
            if(!ctx)
                return;
            ctx.save();
            var lingrad = ctx.createLinearGradient(this._bounds.x,this._bounds.y,this._bounds.x,this._bounds.y + 40);
            lingrad.addColorStop(0,'#00ABEB');
            lingrad.addColorStop(1,'#fff');
            ctx.fillStyle = lingrad;
            ctx.fillRect(this._bounds.x,this._bounds.y,this._bounds.width,this._bounds.height);
            var t = this._name;
            if(t && t.length > 0)
            {
                ctx.fillStyle = "darkblue";
                ctx.font = "20pt Arial";
                ctx.fillText(t,this._bounds.x + 36,this._bounds.y + 28)
            }
            ctx.strokeStyle = "black";
            ctx.strokeRect(this._bounds.x,this._bounds.y,this._bounds.width,this._bounds.height);
            ctx.restore()
        },
        size: function(width, height)
        {
            this._bounds.width = width;
            this._bounds.height = height
        },
        move: function(x, y)
        {
            this._bounds.x = x;
            this._bounds.y = y
        }
    };
    UI._ThemeContext = function(owner)
    {
        this._owner = owner;
        if(owner)
            this._currentTheme = owner.currentTheme()
    };
    UI._ThemeContext.prototype = {
        owner: function(value)
        {
            if(arguments.length === 0)
                return this._owner;
            this._owner = value;
            if(this._owner)
                this._currentTheme = this._owner.currentTheme();
            return this
        },
        getColor: function(name)
        {
            if(this._currentTheme)
            {
                var colors = this._currentTheme.colors();
                if(colors)
                    return colors.getColor(name)
            }
            return name
        },
        getFont: function(name)
        {
            if(name)
            {
                if(this._currentTheme)
                {
                    var lowercaseName = name;
                    if(lowercaseName === "Body")
                        return this._currentTheme.bodyFont();
                    else if(lowercaseName === "Headings")
                        return this._currentTheme.headerFont()
                }
                return name
            }
            return null
        }
    };
    UI.Timer = function(host)
    {
        this.host = host;
        this.interval = null;
        this.action = null;
        this.intervalId = null;
        this.result = null;
        this.working = false
    };
    UI.Timer.prototype = {
        setAction: function(action)
        {
            if(typeof action === const_function)
                this.action = action
        },
        setInterval: function(interval)
        {
            if(!isNaN(interval) && interval > 0)
            {
                var oldInterval = this.interval;
                this.interval = interval;
                if(oldInterval !== interval)
                    this.start()
            }
            else
                this.stop()
        },
        start: function()
        {
            this.clear();
            if(!isNaN(this.interval))
            {
                var self = this;
                this.intervalId = window.setInterval(function()
                {
                    self.run()
                },this.interval)
            }
        },
        run: function()
        {
            this.working = true;
            if(typeof this.action === const_function)
                this.result = this.action.call(this.host)
        },
        stop: function()
        {
            this.clear();
            this.interval = null;
            this.action = null;
            this.intervalId = null;
            this.result = null;
            this.working = false
        },
        clear: function()
        {
            if(this.intervalId)
                window.clearInterval(this.intervalId)
        },
        _dispose: function()
        {
            this.stop();
            this.host = null
        }
    }
})(window,jQuery);
(function(window, $)
{
    "use strict";;
    var const_undefined = "undefined",
        const_function = "function",
        const_number = "number",
        const_string = "string",
        const_boolean = "boolean";
    var GrapeCity = window.GrapeCity;
    if(typeof GrapeCity === const_undefined)
        GrapeCity = window.GrapeCity = {};
    if(typeof GrapeCity.UI === const_undefined)
        GrapeCity.UI = {};
    var UI = GrapeCity.UI;
    var document = window.document;
    var ko = window.ko;
    var ImportExportOptions = function(flags)
        {
            var TextFileOpenFlags = UI.TextFileOpenFlags;
            var IncludeRowHeader = TextFileOpenFlags.IncludeRowHeader,
                IncludeColumnHeader = TextFileOpenFlags.IncludeColumnHeader,
                UnFormatted = TextFileOpenFlags.UnFormatted,
                ImportFormula = TextFileOpenFlags.ImportFormula;
            this.rowHeader = (flags & IncludeRowHeader) === IncludeRowHeader;
            this.columnHeader = (flags & IncludeColumnHeader) === IncludeColumnHeader;
            this.unFormatted = (flags & UnFormatted) === UnFormatted;
            this.formula = (flags & ImportFormula) === ImportFormula;
            this.expandRows = true;
            this.expandColumns = true
        };
    ImportExportOptions.prototype = {fixOptions: function(sheet)
        {
            var SheetArea = UI.SheetArea;
            if(!sheet)
                return;
            if(sheet.getColumnCount(SheetArea.rowHeader) <= 0)
                this.rowHeader = false;
            if(sheet.getRowCount(SheetArea.colHeader) <= 0)
                this.columnHeader = false
        }};
    function raiseInvalidRangeException(item, value, start, end)
    {
        throw new Error("Invalid " + item + ": " + value + " (must be between " + start + " and " + end + ").");
    }
    var staticMembers = {
            copyTo: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount, option)
            {
                staticMembers.checkArguments(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                var CopyToOption = UI.CopyToOption;
                src.suspendCalcService();
                dest.suspendCalcService();
                var savedValues = null;
                if((option & CopyToOption.BindingPath) > 0)
                    savedValues = staticMembers.copyBindingPath(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                try
                {
                    if((option & CopyToOption.Value) > 0)
                    {
                        staticMembers.copyValue(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                        if((option & CopyToOption.Formula) === 0)
                            staticMembers.clearFormula(dest,destRow,destColumn,copyRowCount,copyColumnCount);
                        if((option & CopyToOption.BindingPath) > 0)
                        {
                            var count = savedValues.length;
                            var baseRow = destRow < 0 ? 0 : destRow;
                            var baseCol = destColumn < 0 ? 0 : destColumn;
                            for(var i = 0; i < count; i++)
                            {
                                var cv = savedValues[i];
                                dest.setValue(baseRow + cv.row,baseCol + cv.col,cv.value)
                            }
                        }
                    }
                    if((option & CopyToOption.Formula) > 0)
                        staticMembers.copyFormula(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount)
                }
                finally
                {
                    src.resumeCalcService();
                    dest.resumeCalcService()
                }
                if((option & CopyToOption.Style) > 0)
                    staticMembers.copyStyle(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                if((option & CopyToOption.Sparkline) > 0)
                    staticMembers.copySparkline(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                if((option & CopyToOption.RangeGroup) > 0)
                {
                    if(srcRow < 0)
                        staticMembers.copyColumnRangeGroup(src,srcColumn,dest,destColumn,copyColumnCount);
                    if(srcColumn < 0)
                        staticMembers.copyRowRangeGroup(src,srcRow,dest,destRow,copyRowCount)
                }
                if((option & CopyToOption.Span) > 0)
                    staticMembers.copySpan(src,srcRow,srcColumn,dest,destRow,destColumn,copyRowCount,copyColumnCount);
                if(srcRow < 0)
                    staticMembers.copyColumnAxis(src,srcColumn,dest,destColumn,copyColumnCount,option);
                if(srcColumn < 0)
                    staticMembers.copyRowAxis(src,srcRow,dest,destRow,copyRowCount,option);
                if(srcRow < 0 && destRow < 0 && srcColumn < 0 && destColumn < 0)
                    staticMembers.copySheetInfo(src,dest,option);
                dest._raisePropertyChanged("[CopyTo]")
            },
            checkArguments: function(src, fromRow, fromColumn, dest, toRow, toColumn, rowCount, columnCount)
            {
                if(!src)
                    throw new Error("src");
                if(!dest)
                    throw new Error("dest");
                if(fromRow < -1 || fromRow >= src.getRowCount())
                    raiseInvalidRangeException("from row index",fromRow,"-1",src.getRowCount() - 1);
                if(fromColumn < -1 || fromColumn >= src.getColumnCount())
                    raiseInvalidRangeException("from column index",fromColumn,"-1",src.getColumnCount() - 1);
                if(toRow < -1 || toRow >= dest.getRowCount())
                    raiseInvalidRangeException("to row index",toRow,"-1",dest.getRowCount() - 1);
                if(toColumn < -1 || toColumn >= dest.getColumnCount())
                    raiseInvalidRangeException("to column index",toColumn,"-1",dest.getColumnCount() - 1);
                var fromColumn2 = fromColumn;
                if(fromColumn < 0)
                {
                    fromColumn2 = 0;
                    columnCount = src.getColumnCount()
                }
                var toColumn2 = toColumn < 0 ? 0 : toColumn;
                if(columnCount < 1 || fromColumn2 + columnCount > src.getColumnCount() || toColumn2 + columnCount > dest.getColumnCount())
                    raiseInvalidRangeException("column count",columnCount,"1",Math.min(src.getColumnCount() - fromColumn2,dest.getColumnCount() - toColumn2));
                var fromRow2 = fromRow;
                if(fromRow < 0)
                {
                    fromRow2 = 0;
                    rowCount = src.getRowCount()
                }
                var toRow2 = toRow < 0 ? 0 : toRow;
                if(rowCount < 1 || fromRow2 + rowCount > src.getRowCount() || toRow2 + rowCount > dest.getRowCount())
                    raiseInvalidRangeException("row count",rowCount,"1",Math.min(src.getRowCount() - fromRow2,dest.getRowCount() - toRow2))
            },
            copyValue: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var crossSheet = !(src === dest && src._name === dest._name);
                var SheetArea = UI.SheetArea,
                    hRowCount,
                    hColumnCount,
                    r,
                    c,
                    value;
                if(srcRow < 0)
                {
                    var fColumn = srcColumn;
                    var tColumn = destColumn;
                    hRowCount = Math.min(src.getRowCount(SheetArea.colHeader),dest.getRowCount(SheetArea.colHeader));
                    hColumnCount = copyColumnCount;
                    if(srcColumn < 0)
                    {
                        fColumn = 0;
                        hColumnCount = src.getColumnCount()
                    }
                    if(destColumn < 0)
                        tColumn = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src.getValue(r,fColumn + c,SheetArea.colHeader);
                                if(value === undefined || value === null)
                                    if(src.isColumnBound(fColumn + c) && (r === src.colHeaderAutoTextIndex || r === hRowCount - 1 && src.colHeaderAutoTextIndex === -1))
                                        value = src.getDataColumnName(fColumn + c);
                                if(value === undefined || value === null)
                                    dest._setValueInternal(r,tColumn + c,SheetArea.colHeader,null,true);
                                else
                                    dest._setValueInternal(r,tColumn + c,SheetArea.colHeader,staticMembers.cloneObject(value),true)
                            }
                    else
                    {
                        var savedColumnHeaderValues = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src._getModel(SheetArea.colHeader).getValue(r,fColumn + c);
                                if(value === undefined || value === null)
                                    if(src.isColumnBound(fColumn + c) && (r === src.colHeaderAutoTextIndex || r === hRowCount - 1 && src.colHeaderAutoTextIndex === -1))
                                        value = src.getDataColumnName(fColumn + c);
                                if(value !== undefined && value !== null)
                                    savedColumnHeaderValues.setValue(r,c,staticMembers.cloneObject(value))
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest._setValueInternal(r,tColumn + c,SheetArea.colHeader,savedColumnHeaderValues.getValue(r,c),true)
                    }
                }
                if(srcColumn < 0)
                {
                    var fRow = srcRow;
                    var tRow = destRow;
                    hRowCount = copyRowCount;
                    hColumnCount = Math.min(src.getColumnCount(SheetArea.rowHeader),dest.getColumnCount(SheetArea.rowHeader));
                    if(srcRow < 0)
                    {
                        fRow = 0;
                        hRowCount = src.getRowCount()
                    }
                    if(destRow < 0)
                        tRow = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src.getValue(fRow + r,c,SheetArea.rowHeader);
                                if(value === undefined || value === null)
                                    dest._setValueInternal(tRow + r,c,SheetArea.rowHeader,null,true);
                                else
                                    dest._setValueInternal(tRow + r,c,SheetArea.rowHeader,staticMembers.cloneObject(value),true)
                            }
                    else
                    {
                        var savedRowHeaderValues = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src._getModel(SheetArea.rowHeader).getValue(fRow + r,c);
                                if(value !== undefined && value !== null)
                                    savedRowHeaderValues.setValue(r,c,staticMembers.cloneObject(value))
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest._setValueInternal(tRow + r,c,SheetArea.rowHeader,savedRowHeaderValues.getValue(r,c),true)
                    }
                }
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                if(crossSheet)
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            value = src.getValue(fromRow + r,fromColumn + c,SheetArea.viewport);
                            if(value === undefined || value === null)
                                dest._setValueInternal(toRow + r,toColumn + c,SheetArea.viewport,null,true);
                            else
                                dest._setValueInternal(toRow + r,toColumn + c,SheetArea.viewport,staticMembers.cloneObject(value),true)
                        }
                else
                {
                    var savedValues = new UI._GcSheetModel(rowCount,columnCount,null);
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            value = src.getValue(fromRow + r,fromColumn + c,SheetArea.viewport);
                            if(value !== undefined && value !== null)
                                savedValues.setValue(r,c,staticMembers.cloneObject(value))
                        }
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            dest._setValueInternal(toRow + r,toColumn + c,SheetArea.viewport,savedValues.getValue(r,c),true)
                }
            },
            copyBindingPath: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var savedValues = [];
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                {
                    var path;
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                        {
                            path = src.getBindingPath(fromRow + r,fromColumn + c);
                            dest.setBindingPath(toRow + r,toColumn + c,path);
                            if(path)
                                savedValues.push({
                                    row: r,
                                    col: c,
                                    value: src.getValue(fromRow + r,fromColumn + c)
                                })
                        }
                }
                else
                {
                    var savedPaths = new UI._GcSheetModel(rowCount,columnCount,null);
                    var path;
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                        {
                            path = src.getBindingPath(fromRow + r,fromColumn + c);
                            savedPaths.setBindingPath(r,c,path);
                            if(path)
                                savedValues.push({
                                    row: r,
                                    col: c,
                                    value: src.getValue(fromRow + r,fromColumn + c)
                                })
                        }
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                            dest.setBindingPath(toRow + r,toColumn + c,savedPaths.getBindingPath(r,c))
                }
                return savedValues
            },
            cloneObject: function(obj)
            {
                var objClone;
                if(typeof obj === const_number || typeof obj === const_string || typeof obj === const_boolean || typeof obj === const_undefined)
                {
                    objClone = obj;
                    return objClone
                }
                else if(obj instanceof Date)
                {
                    //objClone = new Date(obj);
                    objClone = new Date(obj.toUTCString());
                    return objClone
                }
                else if(obj instanceof Object)
                    objClone = new obj.constructor;
                else
                    objClone = new obj.constructor(obj.valueOf());
                for(var key in obj)
                    if(obj.hasOwnProperty(key) && objClone[key] !== obj[key])
                        if(typeof this[key] === 'object')
                            objClone[key] = staticMembers.cloneObject(obj[key]);
                        else
                            objClone[key] = obj[key];
                objClone.toString = obj.toString;
                objClone.valueOf = obj.valueOf;
                return objClone
            },
            clearFormula: function(sheet, row, column, rowCount, columnCount)
            {
                if(row < 0)
                {
                    row = 0;
                    rowCount = sheet.getRowCount()
                }
                if(column < 0)
                {
                    column = 0;
                    columnCount = sheet.getColumnCount()
                }
                for(var r = row; r < rowCount; r++)
                    for(var c = column; c < columnCount; c++)
                        sheet.setFormula(r,c,null)
            },
            _copyExpression: function(expr, row, column)
            {
                var newExpr = expr;
                var Calc = GrapeCity.Calc;
                var Expressions = Calc.Expressions;
                var Functions = Calc.Functions;
                var Parser = Calc.Parser;
                var Reference = Calc.Errors.Reference;
                var ErrorExpression = Expressions.ErrorExpression,
                    ExternalErrorExpression = Expressions.ExternalErrorExpression;
                if(expr instanceof Expressions.ParenthesesExpression)
                {
                    newExpr = $.extend(true,new Expressions.ParenthesesExpression,expr);
                    newExpr.argument = staticMembers._copyExpression(expr.argument,row,column)
                }
                else if(expr instanceof Expressions.CellExpression)
                {
                    newExpr = $.extend(true,new Expressions.CellExpression,expr);
                    if(expr.rowRelative && (expr.row + row < 0 || expr.row + row > Parser.maxRowCount))
                        return new ErrorExpression(Reference);
                    if(expr.columnRelative && (expr.column + column < 0 || expr.column + column > Parser.maxColumnCount))
                        return new ErrorExpression(Reference)
                }
                else if(expr instanceof Expressions.ExternalCellExpression)
                {
                    newExpr = $.extend(true,new Expressions.ExternalCellExpression,expr);
                    if(expr.rowRelative && (expr.row + row < 0 || expr.row + row > Parser.maxRowCount))
                        return new ExternalErrorExpression(expr.source,Reference);
                    if(expr.columnRelative && (expr.column + column < 0 || expr.column + column > Parser.maxColumnCount))
                        return new ExternalErrorExpression(expr.source,Reference)
                }
                else if(expr instanceof Expressions.RangeExpression)
                {
                    newExpr = $.extend(true,new Expressions.RangeExpression,expr);
                    if(expr.startRowRelative && (expr.startRow + row < 0 || expr.startRow + row > Parser.maxRowCount))
                        return new ErrorExpression(Reference);
                    if(expr.startColumnRelative && (expr.startColumn + column < 0 || expr.startColumn + column > Parser.maxColumnCount))
                        return new ErrorExpression(Reference);
                    if(expr.endRowRelative && (expr.endRow + row < 0 || expr.endRow + row > Parser.maxRowCount))
                        return new ErrorExpression(Reference);
                    if(expr.endColumnRelative && (expr.endColumn + column < 0 || expr.endColumn + column > Parser.maxColumnCount))
                        return new ErrorExpression(Reference)
                }
                else if(expr instanceof Expressions.ExternalRangeExpression)
                {
                    newExpr = $.extend(true,new Expressions.ExternalRangeExpression,expr);
                    if(expr.startRowRelative && (expr.startRow + row < 0 || expr.startRow + row > Parser.maxRowCount))
                        return new ExternalErrorExpression(expr.source,Reference);
                    if(expr.startColumnRelative && (expr.startColumn + column < 0 || expr.startColumn + column > Parser.maxColumnCount))
                        return new ExternalErrorExpression(expr.source,Reference);
                    if(expr.endRowRelative && (expr.endRow + row < 0 || expr.endRow + row > Parser.maxRowCount))
                        return new ExternalErrorExpression(expr.source,Reference);
                    if(expr.endColumnRelative && (expr.endColumn + column < 0 || expr.endColumn + column > Parser.maxColumnCount))
                        return new ExternalErrorExpression(expr.source,Reference)
                }
                else if(expr instanceof Expressions.UnaryOperatorExpression)
                {
                    newExpr = $.extend(true,new Expressions.UnaryOperatorExpression,expr);
                    newExpr.operand = staticMembers._copyExpression(expr.operand,row,column)
                }
                else if(expr instanceof Expressions.BinaryOperatorExpression)
                {
                    newExpr = $.extend(true,new Expressions.BinaryOperatorExpression,expr);
                    newExpr.left = staticMembers._copyExpression(expr.left,row,column);
                    newExpr.right = staticMembers._copyExpression(expr.right,row,column)
                }
                else if(expr instanceof Expressions.FunctionExpression)
                {
                    newExpr = $.extend(true,new Expressions.FunctionExpression(new Functions.Function),expr);
                    if(expr.args && expr.args.length > 0)
                        for(var i = 0; i < expr.args.length; i++)
                            newExpr.args[i] = staticMembers._copyExpression(expr.args[i],row,column)
                }
                return newExpr
            },
            copyFormula: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                var destSource = dest._getSheetSource();
                if(destSource)
                    destSource.unlinkCellExpression(toRow,toColumn,rowCount,columnCount);
                var m = new UI._GcSheetModel(rowCount,columnCount,null);
                var mc = new UI._GcSheetModel(rowCount,columnCount,null);
                var r,
                    c;
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                        mc.setFormula(r,c,src._calcDataModel.getFormula(r + fromRow,c + fromColumn));
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                    {
                        var expr = staticMembers._copyExpression(mc.getFormula(r,c),r + toRow,c + toColumn);
                        dest._dataModel.setFormula(r + toRow,c + toColumn,dest.getCalcService().unparse(expr,r + toRow,c + toColumn));
                        dest._calcDataModel.setFormula(r + toRow,c + toColumn,expr)
                    }
                if(destSource)
                {
                    destSource.linkCellExpression(toRow,toColumn,rowCount,columnCount);
                    destSource._addCellsToDirty(toRow,toColumn,rowCount,columnCount)
                }
            },
            copyStyle: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var crossSheet = !(src === dest && src._name === dest._name);
                var SheetArea = UI.SheetArea;
                var hRowCount,
                    hColumnCount,
                    r,
                    c,
                    style;
                if(srcRow < 0)
                {
                    var fColumn = srcColumn;
                    var tColumn = destColumn;
                    hRowCount = Math.min(src.getRowCount(SheetArea.colHeader),dest.getRowCount(SheetArea.colHeader));
                    hColumnCount = copyColumnCount;
                    if(srcColumn < 0)
                    {
                        fColumn = 0;
                        hColumnCount = src.getColumnCount()
                    }
                    if(destColumn < 0)
                        tColumn = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(r,fColumn + c,SheetArea.colHeader);
                                if(!style)
                                    dest.setStyle(r,tColumn + c,null,SheetArea.colHeader);
                                else
                                    dest.setStyle(r,tColumn + c,staticMembers.cloneObject(style),SheetArea.colHeader)
                            }
                    else
                    {
                        var savedColumnHeaderStyles = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(r,fColumn + c,SheetArea.colHeader);
                                if(style)
                                    savedColumnHeaderStyles.setValue(r,c,staticMembers.cloneObject(style))
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest.setStyle(r,tColumn + c,savedColumnHeaderStyles.getValue(r,c),SheetArea.colHeader)
                    }
                }
                if(srcColumn < 0)
                {
                    var fRow = srcRow;
                    var tRow = destRow;
                    hRowCount = copyRowCount;
                    hColumnCount = Math.min(src.getColumnCount(SheetArea.rowHeader),dest.getColumnCount(SheetArea.rowHeader));
                    if(srcRow < 0)
                    {
                        fRow = 0;
                        hRowCount = src.getRowCount()
                    }
                    if(destRow < 0)
                        tRow = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(fRow + r,c,SheetArea.rowHeader);
                                if(!style)
                                    dest.setStyle(tRow + r,c,null,SheetArea.rowHeader);
                                else
                                    dest.setStyle(tRow + r,c,staticMembers.cloneObject(style),SheetArea.rowHeader)
                            }
                    else
                    {
                        var savedRowHeaderStyles = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(fRow + r,c,SheetArea.rowHeader);
                                if(style)
                                    savedRowHeaderStyles.setValue(r,c,staticMembers.cloneObject(style))
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest.setStyle(tRow + r,c,savedRowHeaderStyles.getValue(r,c),SheetArea.rowHeader)
                    }
                }
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                if(crossSheet)
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            style = src.getActualStyle(fromRow + r,fromColumn + c,SheetArea.viewport);
                            if(!style)
                                dest.setStyle(toRow + r,toColumn + c,null,SheetArea.viewport);
                            else
                                dest.setStyle(toRow + r,toColumn + c,staticMembers.cloneObject(style),SheetArea.viewport)
                        }
                else
                {
                    var savedStyles = new UI._GcSheetModel(rowCount,columnCount,null);
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            style = src.getActualStyle(fromRow + r,fromColumn + c,SheetArea.viewport);
                            if(style)
                                savedStyles.setValue(r,c,staticMembers.cloneObject(style))
                        }
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            dest.setStyle(toRow + r,toColumn + c,savedStyles.getValue(r,c),SheetArea.viewport)
                }
            },
            copyColumnRangeGroup: function(src, srcColumn, dest, destColumn, copyColumnCount)
            {
                var fromColumn = srcColumn;
                var toColumn = destColumn;
                var columnCount = copyColumnCount;
                if(fromColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                    staticMembers.crossSheetCopyRangeGroup(src.colRangeGroup,fromColumn,dest.colRangeGroup,toColumn,columnCount);
                else
                {
                    var columnGroup = src.colRangeGroup;
                    if(columnGroup)
                        columnGroup._copy(fromColumn,toColumn,columnCount)
                }
            },
            crossSheetCopyRangeGroup: function(srcGroup, from, destGroup, to, count)
            {
                if(from < 0)
                    from = 0;
                if(to < 0)
                    to = 0;
                var clonedItems = {};
                if(srcGroup)
                {
                    var index = srcGroup.items.nextNonEmptyIndex(from - 1);
                    while(index >= 0 && index < from + count)
                    {
                        clonedItems[index - from] = new UI.RangeGroupItemInfo(srcGroup.items[index]);
                        index = srcGroup.items.nextNonEmptyIndex(index)
                    }
                }
                if(destGroup)
                {
                    destGroup.items.clear(to,count);
                    if(clonedItems.length > 0)
                        for(var key in clonedItems)
                            if(clonedItems.hasOwnProperty(key))
                            {
                                var value = clonedItems[key];
                                destGroup.items[to + key] = value
                            }
                }
            },
            copySparkline: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                var sparkline;
                if(crossSheet)
                {
                    sparkline = dest._sparklineGroupManager;
                    if(sparkline)
                        sparkline._exCopy(src,fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
                else
                {
                    sparkline = src._sparklineGroupManager;
                    if(sparkline)
                        sparkline._copy(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
            },
            copyRowRangeGroup: function(src, srcRow, dest, destRow, copyRowCount)
            {
                var fromRow = srcRow;
                var toRow = destRow;
                var rowCount = copyRowCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(destRow < 0)
                    toRow = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                    staticMembers.crossSheetCopyRangeGroup(src.rowRangeGroup,fromRow,dest.rowRangeGroup,toRow,rowCount);
                else
                {
                    var rowGroup = src.rowRangeGroup;
                    if(rowGroup)
                        rowGroup._copy(fromRow,toRow,rowCount)
                }
            },
            copySpan: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var SheetArea = UI.SheetArea;
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(fromColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                if(srcRow < 0)
                    if(crossSheet)
                        staticMembers.crossSheetCopySpans(src._colHeaderSpanModel,-1,fromColumn,dest._colHeaderSpanModel,-1,toColumn,-1,columnCount);
                    else
                    {
                        var csm = src._getSpanModel(SheetArea.colHeader);
                        if(csm)
                            csm.copy(-1,fromColumn,-1,toColumn,-1,columnCount)
                    }
                if(srcColumn < 0)
                    if(crossSheet)
                        staticMembers.crossSheetCopySpans(src._rowHeaderSpanModel,fromRow,-1,dest._rowHeaderSpanModel,toRow,-1,rowCount,-1);
                    else
                    {
                        var rsm = src._getSpanModel(SheetArea.rowHeader);
                        if(rsm)
                            rsm.copy(fromRow,-1,toRow,-1,rowCount,-1)
                    }
                if(crossSheet)
                    staticMembers.crossSheetCopySpans(src._spanModel,fromRow,fromColumn,dest._spanModel,toRow,toColumn,rowCount,columnCount);
                else
                {
                    var sm = src._getSpanModel(SheetArea.viewport);
                    if(sm)
                        sm.copy(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
            },
            crossSheetCopySpans: function(srcSpanModel, fromRow, fromColumn, destSpanModel, toRow, toColumn, rowCount, columnCount)
            {
                var srcSpans = staticMembers.getSpans(srcSpanModel);
                var destSpans = staticMembers.getSpans(destSpanModel);
                var addList = [],
                    i,
                    j,
                    cs,
                    span;
                if(fromRow === -1)
                {
                    if(srcSpans && srcSpans.length > 0)
                        for(i = 0; i < srcSpans.length; i++)
                        {
                            cs = srcSpans[i];
                            if(cs.col >= fromColumn && cs.col + cs.colCount <= fromColumn + columnCount)
                                addList.push(new UI.Range(cs.row,toColumn + cs.col - fromColumn,cs.rowCount,cs.colCount))
                        }
                    if(destSpans && destSpans.length > 0)
                        for(i = 0; i < destSpans.length; i++)
                        {
                            cs = destSpans[i];
                            if(cs.col >= toColumn && cs.col < toColumn + columnCount)
                                for(j = 0; j < destSpanModel.length; j++)
                                {
                                    span = destSpanModel[j];
                                    if(span.row === cs.row && span.col === cs.col)
                                    {
                                        destSpanModel.splice(j,1);
                                        break
                                    }
                                }
                        }
                }
                else if(fromColumn === -1)
                {
                    if(srcSpans && srcSpans.length > 0)
                        for(i = 0; i < srcSpans.length; i++)
                        {
                            cs = srcSpans[i];
                            if(fromRow <= cs.row && cs.row + cs.rowCount <= fromRow + rowCount)
                                addList.push(new UI.Range(toRow + cs.row - fromRow,cs.col,cs.rowCount,cs.colCount))
                        }
                    if(destSpans && destSpans.length > 0)
                        for(i = 0; i < destSpans.length; i++)
                        {
                            cs = destSpans[i];
                            if(cs.row >= toRow && cs.row < toRow + rowCount)
                                for(j = 0; j < destSpanModel.length; j++)
                                {
                                    span = destSpanModel[j];
                                    if(span.row === cs.row && span.col === cs.col)
                                    {
                                        destSpanModel.splice(j,1);
                                        break
                                    }
                                }
                        }
                }
                else
                {
                    if(srcSpans && srcSpans.length > 0)
                        for(i = 0; i < srcSpans.length; i++)
                        {
                            cs = srcSpans[i];
                            if(fromRow <= cs.row && cs.row < fromRow + rowCount && fromColumn <= cs.col && cs.col < fromColumn + columnCount)
                                addList.push(new UI.Range(toRow + cs.row - fromRow,toColumn + cs.col - fromColumn,cs.rowCount,cs.colCount))
                        }
                    if(destSpans && destSpans.length > 0)
                        for(i = 0; i < destSpans.length; i++)
                        {
                            cs = destSpans[i];
                            if(cs.row >= toRow && cs.row < toRow + rowCount && cs.col >= toColumn && cs.col < toColumn + columnCount)
                                for(j = 0; j < destSpanModel.length; j++)
                                {
                                    span = destSpanModel[j];
                                    if(span.row === cs.row && span.col === cs.col)
                                    {
                                        destSpanModel.splice(j,1);
                                        break
                                    }
                                }
                        }
                }
                if(addList.length > 0 && destSpanModel)
                    for(i = 0; i < addList.length; i++)
                    {
                        var cr = addList[i];
                        destSpanModel.push(cr)
                    }
            },
            getSpans: function(spanModel)
            {
                if(spanModel && spanModel.length > 0)
                    return spanModel.slice(0);
                return null
            },
            copyColumnAxis: function(src, srcColumn, dest, destColumn, copyColumnCount, option)
            {
                var fromColumn = srcColumn;
                var toColumn = destColumn;
                var columnCount = copyColumnCount;
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destColumn < 0)
                    toColumn = 0;
                var colHeader = UI.SheetArea.colHeader;
                for(var c = 0; c < columnCount; c++)
                {
                    var width = src._getActualColumnWidth(c + fromColumn);
                    if(width !== undefined && width !== null)
                        dest.setColumnWidth(c + toColumn,width);
                    var visible = src.getColumnVisible(c + fromColumn);
                    if(visible !== undefined && visible !== null)
                        dest.setColumnVisible(c + toColumn,visible);
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var style = src.getActualStyle(-1,c + fromColumn);
                        if(!style)
                            dest.setStyle(-1,c + toColumn,null);
                        else
                            dest.setStyle(-1,c + toColumn,staticMembers.cloneObject(style));
                        style = src.getActualStyle(-1,c + fromColumn,colHeader);
                        if(!style)
                            dest.setStyle(-1,c + toColumn,null,colHeader);
                        else
                            dest.setStyle(-1,c + toColumn,staticMembers.cloneObject(style),colHeader)
                    }
                }
                var colHeaderRowCount = Math.min(src.getRowCount(colHeader),dest.getRowCount(colHeader));
                for(var r = 0; r < colHeaderRowCount; r++)
                {
                    var height = src._getActualRowHeight(r,colHeader);
                    if(height !== undefined && height !== null)
                        dest.setRowHeight(r,height,colHeader)
                }
            },
            cloneAxisInfo: function(srcInfo, fromIndex, count)
            {
                var ret = [];
                for(var index = 0; index < count; index++)
                {
                    var axisInfo = srcInfo[fromIndex + index];
                    if(!axisInfo)
                        ret.push(null);
                    else
                    {
                        var vColumn = {};
                        for(var key in axisInfo)
                            if(axisInfo.hasOwnProperty(key))
                                vColumn[key] = axisInfo[key];
                        ret.push(vColumn)
                    }
                }
                return ret
            },
            getAxisInfo: function(srcInfo, fromIndex, count)
            {
                var ret = [];
                for(var index = 0; index < count; index++)
                    ret.push(srcInfo[fromIndex + index]);
                return ret
            },
            setAxisInfo: function(infos, destAxis, toIndex)
            {
                if(destAxis)
                    for(var index = 0; index < infos.length; index++)
                        destAxis[toIndex + index] = infos[index]
            },
            copyRowAxis: function(src, srcRow, dest, destRow, copyRowCount, option)
            {
                var fromRow = srcRow;
                var toRow = destRow;
                var rowCount = copyRowCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(destRow < 0)
                    toRow = 0;
                var rowHeader = UI.SheetArea.rowHeader;
                for(var r = 0; r < rowCount; r++)
                {
                    var height = src._getActualRowHeight(r + fromRow);
                    if(height !== undefined && height !== null)
                        dest.setRowHeight(r + toRow,height);
                    var visible = src.getRowVisible(r + fromRow);
                    if(visible !== undefined && visible !== null)
                        dest.setRowVisible(r + toRow,visible);
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var style = src.getActualStyle(r + fromRow,-1);
                        if(!style)
                            dest.setStyle(r + toRow,-1,null);
                        else
                            dest.setStyle(r + toRow,-1,staticMembers.cloneObject(style));
                        style = src.getActualStyle(r + fromRow,-1,rowHeader);
                        if(!style)
                            dest.setStyle(r + toRow,-1,null,rowHeader);
                        else
                            dest.setStyle(r + toRow,-1,staticMembers.cloneObject(style),rowHeader)
                    }
                }
                var rowHeaderColCount = Math.min(src.getColumnCount(rowHeader),dest.getColumnCount(rowHeader));
                for(var c = 0; c < rowHeaderColCount; c++)
                {
                    var width = src._getActualColumnWidth(c,rowHeader);
                    if(width !== undefined && width !== null)
                        dest.setColumnWidth(c,width,rowHeader)
                }
            },
            copySheetInfo: function(src, dest, option)
            {
                if(!(src === dest && src._name === dest._name))
                {
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var SheetArea = UI.SheetArea;
                        var colHeader = SheetArea.colHeader;
                        var rowHeader = SheetArea.rowHeader;
                        dest.setDefaultStyle(staticMembers.cloneObject(src.getDefaultStyle()));
                        dest.setDefaultStyle(staticMembers.cloneObject(src.getDefaultStyle(colHeader)),colHeader);
                        dest.setDefaultStyle(staticMembers.cloneObject(src.getDefaultStyle(rowHeader)),rowHeader)
                    }
                    dest.defaults.colWidth = src.defaults.colWidth;
                    dest.defaults.rowHeight = src.defaults.rowHeight;
                    dest.defaults.rowHeaderColWidth = src.defaults.rowHeaderColWidth
                }
            },
            moveTo: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount, option)
            {
                staticMembers.checkArguments(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                var CopyToOption = UI.CopyToOption;
                src.suspendCalcService();
                dest.suspendCalcService();
                var savedValues = null;
                if((option & CopyToOption.BindingPath) > 0)
                    savedValues = staticMembers.moveBindingPath(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                try
                {
                    if((option & CopyToOption.Value) > 0)
                    {
                        staticMembers.moveValue(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                        if((option & CopyToOption.Formula) === 0)
                            staticMembers.clearFormula(dest,destRow,destColumn,moveRowCount,moveColumnCount);
                        if((option & CopyToOption.BindingPath) > 0)
                        {
                            var count = savedValues.length;
                            var baseRow = destRow < 0 ? 0 : destRow;
                            var baseCol = destColumn < 0 ? 0 : destColumn;
                            for(var i = 0; i < count; i++)
                            {
                                var cv = savedValues[i];
                                dest.setValue(baseRow + cv.row,baseCol + cv.col,cv.value)
                            }
                        }
                    }
                    if((option & CopyToOption.Formula) > 0)
                        staticMembers.moveFormula(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount)
                }
                finally
                {
                    src.resumeCalcService();
                    dest.resumeCalcService()
                }
                if((option & CopyToOption.Style) > 0)
                    staticMembers.moveStyle(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                if((option & CopyToOption.Sparkline) > 0)
                    staticMembers.moveSparkline(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                if((option & CopyToOption.RangeGroup) > 0)
                {
                    if(srcRow < 0)
                        staticMembers.moveColumnRangeGroup(src,srcColumn,dest,destColumn,moveColumnCount);
                    if(srcColumn < 0)
                        staticMembers.moveRowRangeGroup(src,srcRow,dest,destRow,moveRowCount)
                }
                if((option & CopyToOption.Span) > 0)
                    staticMembers.moveSpan(src,srcRow,srcColumn,dest,destRow,destColumn,moveRowCount,moveColumnCount);
                if(srcRow < 0)
                    staticMembers.moveColumnAxis(src,srcColumn,dest,destColumn,moveColumnCount,option);
                if(srcColumn < 0)
                    staticMembers.moveRowAxis(src,srcRow,dest,destRow,moveRowCount,option);
                if(srcRow < 0 && destRow < 0 && srcColumn < 0 && destColumn < 0)
                    staticMembers.moveSheetInfo(src,dest,option);
                if(srcRow < 0)
                {
                    var fColumn = srcColumn;
                    var hColumnCount = moveColumnCount;
                    if(srcColumn < 0)
                    {
                        fColumn = 0;
                        hColumnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                    }
                    for(var c = 0; c < hColumnCount; c++)
                        if(src.isColumnBound(fColumn + c))
                            src._colInfos[fColumn + c] = null
                }
                var prop = "[MoveTo]";
                src._raisePropertyChanged(prop);
                dest._raisePropertyChanged(prop)
            },
            moveValue: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount)
            {
                var crossSheet = !(src === dest && src._name === dest._name);
                var colHeader = UI.SheetArea.colHeader,
                    hRowCount,
                    hColumnCount,
                    r,
                    c,
                    value;
                if(srcRow < 0)
                {
                    var fColumn = srcColumn;
                    var tColumn = destColumn;
                    hRowCount = Math.min(src.getRowCount(colHeader),dest.getRowCount(colHeader));
                    hColumnCount = moveColumnCount;
                    if(srcColumn < 0)
                    {
                        fColumn = 0;
                        hColumnCount = src.getColumnCount()
                    }
                    if(destColumn < 0)
                        tColumn = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src._getModel(colHeader).getValue(r,fColumn + c);
                                if(value === undefined || value === null)
                                    if(src.isColumnBound(fColumn + c) && (r === src.colHeaderAutoTextIndex || r === hRowCount - 1 && src.colHeaderAutoTextIndex === -1))
                                        value = src.getDataColumnName(fColumn + c);
                                if(value === undefined || value === null)
                                    dest._setValueInternal(r,tColumn + c,colHeader,null,true);
                                else
                                {
                                    dest._setValueInternal(r,tColumn + c,colHeader,value,true);
                                    src._setValueInternal(r,fColumn + c,colHeader,null,true)
                                }
                            }
                    else
                    {
                        var savedColumnHeaderValues = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src._getModel(colHeader).getValue(r,fColumn + c);
                                if(value === undefined || value === null)
                                    if(src.isColumnBound(fColumn + c) && (r === src.colHeaderAutoTextIndex || r === hRowCount - 1 && src.colHeaderAutoTextIndex === -1))
                                        value = src.getDataColumnName(fColumn + c);
                                if(value !== undefined && value !== null)
                                    savedColumnHeaderValues.setValue(r,c,value);
                                src._setValueInternal(r,fColumn + c,colHeader,null,true)
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest._setValueInternal(r,tColumn + c,colHeader,savedColumnHeaderValues.getValue(r,c),true)
                    }
                }
                var rowHeader = UI.SheetArea.rowHeader;
                if(srcColumn < 0)
                {
                    var fRow = srcRow;
                    var tRow = destRow;
                    hRowCount = moveRowCount;
                    hColumnCount = Math.min(src.getColumnCount(rowHeader),dest.getColumnCount(rowHeader));
                    if(srcRow < 0)
                    {
                        fRow = 0;
                        hRowCount = src.getRowCount()
                    }
                    if(destRow < 0)
                        tRow = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src.getValue(fRow + r,c,rowHeader);
                                if(value === undefined || value === null)
                                    dest._setValueInternal(tRow + r,c,rowHeader,null,true);
                                else
                                {
                                    dest._setValueInternal(tRow + r,c,rowHeader,value,true);
                                    src._setValueInternal(fRow + r,c,rowHeader,null,true)
                                }
                            }
                    else
                    {
                        var savedRowHeaderValues = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                value = src._getModel(rowHeader).getValue(fRow + r,c);
                                if(value !== undefined && value !== null)
                                    savedRowHeaderValues.setValue(r,c,value);
                                src._setValueInternal(fRow + r,c,rowHeader,null,true)
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest._setValueInternal(tRow + r,c,rowHeader,savedRowHeaderValues.getValue(r,c),true)
                    }
                }
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = moveRowCount;
                var columnCount = moveColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                if(crossSheet)
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            value = src.getValue(fromRow + r,fromColumn + c);
                            if(value === undefined || value === null)
                                dest._setValueInternal(toRow + r,toColumn + c,null,null,true);
                            else
                            {
                                dest._setValueInternal(toRow + r,toColumn + c,null,value,true);
                                src._setValueInternal(fromRow + r,fromColumn + c,null,null,true)
                            }
                        }
                else
                {
                    var savedValues = new UI._GcSheetModel(rowCount,columnCount,null);
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            value = src.getValue(fromRow + r,fromColumn + c);
                            if(value !== undefined && value !== null)
                                savedValues.setValue(r,c,value)
                        }
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            src._setValueInternal(fromRow + r,fromColumn + c,null,null,true);
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            dest._setValueInternal(toRow + r,toColumn + c,null,savedValues.getValue(r,c),true)
                }
            },
            moveFormula: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = moveRowCount;
                var columnCount = moveColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                var srcSource = src._getSheetSource();
                var destSource = dest._getSheetSource();
                if(srcSource)
                {
                    srcSource.unlinkCellExpression(fromRow,fromColumn,rowCount,columnCount);
                    srcSource._addDependentsToAdjust(fromRow,fromColumn,rowCount,columnCount)
                }
                if(destSource)
                {
                    destSource.unlinkCellExpression(toRow,toColumn,rowCount,columnCount);
                    destSource._addDependentsToAdjust(toRow,toColumn,rowCount,columnCount)
                }
                var srcModel = src._getModel(),
                    srcCalcModel = src._getCalcModel();
                var destModel = dest._getModel(),
                    destCalcModel = dest._getCalcModel();
                var expressions = [],
                    r,
                    c;
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                    {
                        expressions.push(srcCalcModel.getFormula(r + fromRow,c + fromColumn));
                        srcModel.setFormula(r + fromRow,c + fromColumn,null);
                        srcCalcModel.setFormula(r + fromRow,c + fromColumn,null)
                    }
                var calcSvc = dest.getCalcService();
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                    {
                        var expr = expressions.shift();
                        destModel.setFormula(r + toRow,c + toColumn,calcSvc.unparse(expr,r + toRow,c + toColumn));
                        destCalcModel.setFormula(r + toRow,c + toColumn,expr)
                    }
                if(srcSource)
                    srcSource._addCellsToAdjust(fromRow,fromColumn,rowCount,columnCount);
                if(destSource)
                    destSource._addCellsToAdjust(toRow,toColumn,rowCount,columnCount);
                if(srcSource && srcSource._controller)
                    srcSource._controller.adjustFormulasOnMove(srcSource,fromRow,fromColumn,destSource,toRow,toColumn,rowCount,columnCount);
                if(crossSheet === true && destSource && destSource._controller)
                    destSource._controller.adjustFormulasOnMove(srcSource,fromRow,fromColumn,destSource,toRow,toColumn,rowCount,columnCount)
            },
            moveStyle: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount)
            {
                var crossSheet = !(src === dest && src._name === dest._name);
                var colHeader = UI.SheetArea.colHeader,
                    hRowCount,
                    hColumnCount,
                    r,
                    c,
                    style;
                if(srcRow < 0)
                {
                    var fColumn = srcColumn;
                    var tColumn = destColumn;
                    hRowCount = Math.min(src.getRowCount(colHeader),dest.getRowCount(colHeader));
                    hColumnCount = moveColumnCount;
                    if(srcColumn < 0)
                    {
                        fColumn = 0;
                        hColumnCount = src.getColumnCount()
                    }
                    if(destColumn < 0)
                        tColumn = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(r,fColumn + c,colHeader);
                                if(!style)
                                    dest.setStyle(r,tColumn + c,null,colHeader);
                                else
                                {
                                    dest.setStyle(r,tColumn + c,staticMembers.cloneObject(style),colHeader);
                                    src.setStyle(r,fColumn + c,null,colHeader)
                                }
                            }
                    else
                    {
                        var savedColumnHeaderStyles = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(r,fColumn + c,colHeader);
                                if(style)
                                    savedColumnHeaderStyles.setValue(r,c,staticMembers.cloneObject(style));
                                src.setStyle(r,fColumn + c,null,colHeader)
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest.setStyle(r,tColumn + c,savedColumnHeaderStyles.getValue(r,c),colHeader)
                    }
                }
                var rowHeader = UI.SheetArea.rowHeader;
                if(srcColumn < 0)
                {
                    var fRow = srcRow;
                    var tRow = destRow;
                    hRowCount = moveRowCount;
                    hColumnCount = Math.min(src.getColumnCount(rowHeader),dest.getColumnCount(rowHeader));
                    if(srcRow < 0)
                    {
                        fRow = 0;
                        hRowCount = src.getRowCount()
                    }
                    if(destRow < 0)
                        tRow = 0;
                    if(crossSheet)
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(fRow + r,c,rowHeader);
                                if(!style)
                                    dest.setStyle(tRow + r,c,null,rowHeader);
                                else
                                {
                                    dest.setStyle(tRow + r,c,staticMembers.cloneObject(style),rowHeader);
                                    src.setStyle(fRow + r,c,null,rowHeader)
                                }
                            }
                    else
                    {
                        var savedRowHeaderStyles = new UI._GcSheetModel(hRowCount,hColumnCount,null);
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                            {
                                style = src.getActualStyle(fRow + r,c,rowHeader);
                                if(style)
                                    savedRowHeaderStyles.setValue(r,c,staticMembers.cloneObject(style));
                                src.setStyle(fRow + r,c,null,rowHeader)
                            }
                        for(r = 0; r < hRowCount; r++)
                            for(c = 0; c < hColumnCount; c++)
                                dest.setStyle(tRow + r,c,savedRowHeaderStyles.getValue(r,c),rowHeader)
                    }
                }
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = moveRowCount;
                var columnCount = moveColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                if(crossSheet)
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            style = src.getActualStyle(fromRow + r,fromColumn + c);
                            if(!style)
                                dest.setStyle(toRow + r,toColumn + c,null);
                            else
                            {
                                dest.setStyle(toRow + r,toColumn + c,staticMembers.cloneObject(style));
                                src.setStyle(fromRow + r,fromColumn + c,null)
                            }
                        }
                else
                {
                    var savedStyles = new UI._GcSheetModel(rowCount,columnCount,null);
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                        {
                            style = src.getActualStyle(fromRow + r,fromColumn + c);
                            if(style)
                                savedStyles.setValue(r,c,staticMembers.cloneObject(style));
                            src.setStyle(fromRow + r,fromColumn + c,null)
                        }
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            dest.setStyle(toRow + r,toColumn + c,savedStyles.getValue(r,c))
                }
            },
            moveSparkline: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = moveRowCount;
                var columnCount = moveColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                var sparkline;
                if(crossSheet)
                {
                    sparkline = dest._sparklineGroupManager;
                    if(sparkline)
                        sparkline._exMove(src,fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
                else
                {
                    sparkline = src._sparklineGroupManager;
                    if(sparkline)
                        sparkline._move(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
            },
            moveColumnRangeGroup: function(src, srcColumn, dest, destColumn, moveColumnCount)
            {
                var fromColumn = srcColumn;
                var toColumn = destColumn;
                var columnCount = moveColumnCount;
                if(fromColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                {
                    staticMembers.crossSheetCopyRangeGroup(src.colRangeGroup,fromColumn,dest.colRangeGroup,toColumn,columnCount);
                    if(src.colRangeGroup)
                        src.colRangeGroup.items.clear(fromColumn,columnCount)
                }
                else
                {
                    var columnGroup = src.colRangeGroup;
                    if(columnGroup)
                        columnGroup._move(fromColumn,toColumn,columnCount)
                }
            },
            moveRowRangeGroup: function(src, srcRow, dest, destRow, moveRowCount)
            {
                var fromRow = srcRow;
                var toRow = destRow;
                var rowCount = moveRowCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(destRow < 0)
                    toRow = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                {
                    staticMembers.crossSheetCopyRangeGroup(src.rowRangeGroup,fromRow,dest.rowRangeGroup,toRow,rowCount);
                    if(src.rowRangeGroup)
                        src.rowRangeGroup.items.clear(fromRow,rowCount)
                }
                else
                {
                    var rowGroup = src.rowRangeGroup;
                    if(rowGroup)
                        rowGroup._move(fromRow,toRow,rowCount)
                }
            },
            moveSpan: function(src, srcRow, srcColumn, dest, destRow, destColumn, moveRowCount, moveColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = moveRowCount;
                var columnCount = moveColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(fromColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var crossSheet = !(src === dest && src._name === dest._name);
                var SheetArea = UI.SheetArea;
                if(srcRow < 0)
                    if(crossSheet)
                    {
                        staticMembers.crossSheetCopySpans(src._colHeaderSpanModel,-1,fromColumn,dest._colHeaderSpanModel,-1,toColumn,-1,columnCount);
                        if(src._colHeaderSpanModel)
                            src._colHeaderSpanModel.clear(-1,fromColumn,-1,columnCount)
                    }
                    else
                    {
                        var csm = src._getSpanModel(SheetArea.colHeader);
                        if(csm)
                            csm.move(-1,fromColumn,-1,toColumn,-1,columnCount)
                    }
                if(srcColumn < 0)
                    if(crossSheet)
                    {
                        staticMembers.crossSheetCopySpans(src._rowHeaderSpanModel,fromRow,-1,dest._rowHeaderSpanModel,toRow,-1,rowCount,-1);
                        if(src._rowHeaderSpanModel)
                            src._rowHeaderSpanModel.clear(fromRow,-1,rowCount,-1)
                    }
                    else
                    {
                        var rsm = src._getSpanModel(SheetArea.rowHeader);
                        if(rsm)
                            rsm.move(fromRow,-1,toRow,-1,rowCount,-1)
                    }
                if(crossSheet)
                {
                    staticMembers.crossSheetCopySpans(src._spanModel,fromRow,fromColumn,dest._spanModel,toRow,toColumn,rowCount,columnCount);
                    if(src._spanModel)
                        src._spanModel.clear(fromRow,fromColumn,rowCount,columnCount)
                }
                else
                {
                    var sm = src._getSpanModel();
                    if(sm)
                        sm.move(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount)
                }
            },
            moveColumnAxis: function(src, srcColumn, dest, destColumn, moveColumnCount, option)
            {
                var fromColumn = srcColumn;
                var toColumn = destColumn;
                var columnCount = moveColumnCount;
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destColumn < 0)
                    toColumn = 0;
                var colHeader = UI.SheetArea.colHeader;
                for(var c = 0; c < columnCount; c++)
                {
                    var width = src._getActualColumnWidth(c + fromColumn);
                    if(width !== undefined && width !== null)
                    {
                        src.setColumnWidth(c + fromColumn,src.defaults.colWidth);
                        dest.setColumnWidth(c + toColumn,width)
                    }
                    var visible = src.getColumnVisible(c + fromColumn);
                    if(visible !== undefined && visible !== null)
                    {
                        src.setColumnVisible(c + fromColumn,true);
                        dest.setColumnVisible(c + toColumn,visible)
                    }
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var style = src.getActualStyle(-1,c + fromColumn);
                        if(!style)
                            dest.setStyle(-1,c + toColumn,null);
                        else
                        {
                            dest.setStyle(-1,c + toColumn,staticMembers.cloneObject(style));
                            src.setStyle(-1,c + fromColumn,null)
                        }
                        style = src.getActualStyle(-1,c + fromColumn,colHeader);
                        if(!style)
                            dest.setStyle(-1,c + toColumn,null,colHeader);
                        else
                        {
                            dest.setStyle(-1,c + toColumn,staticMembers.cloneObject(style),colHeader);
                            src.setStyle(-1,c + fromColumn,null,colHeader)
                        }
                    }
                }
                var colHeaderRowCount = Math.min(src.getRowCount(colHeader),dest.getRowCount(colHeader));
                for(var r = 0; r < colHeaderRowCount; r++)
                {
                    var height = src._getActualRowHeight(r,colHeader);
                    if(height !== undefined && height !== null)
                    {
                        src.setRowHeight(r,src.defaults.colHeaderRowHeight,colHeader);
                        dest.setRowHeight(r,height,colHeader)
                    }
                }
            },
            moveRowAxis: function(src, srcRow, dest, destRow, moveRowCount, option)
            {
                var fromRow = srcRow;
                var toRow = destRow;
                var rowCount = moveRowCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(destRow < 0)
                    toRow = 0;
                var rowHeader = UI.SheetArea.rowHeader;
                for(var r = 0; r < rowCount; r++)
                {
                    var height = src._getActualRowHeight(r + fromRow);
                    if(height !== undefined && height !== null)
                    {
                        src.setRowHeight(r + fromRow,src.defaults.rowHeight);
                        dest.setRowHeight(r + toRow,height)
                    }
                    var visible = src.getRowVisible(r + fromRow);
                    if(visible !== undefined && visible !== null)
                    {
                        src.setRowVisible(r + fromRow,true);
                        dest.setRowVisible(r + toRow,visible)
                    }
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var style = src.getActualStyle(r + fromRow,-1);
                        if(!style)
                            dest.setStyle(r + toRow,-1,null);
                        else
                        {
                            dest.setStyle(r + toRow,-1,staticMembers.cloneObject(style));
                            src.setStyle(r + fromRow,-1,null)
                        }
                        style = src.getActualStyle(r + fromRow,-1,rowHeader);
                        if(!style)
                            dest.setStyle(r + toRow,-1,null,rowHeader);
                        else
                        {
                            dest.setStyle(r + toRow,-1,staticMembers.cloneObject(style),rowHeader);
                            src.setStyle(r + fromRow,-1,null,rowHeader)
                        }
                    }
                }
                var rowHeaderColCount = Math.min(src.getColumnCount(rowHeader),dest.getColumnCount(rowHeader));
                for(var c = 0; c < rowHeaderColCount; c++)
                {
                    var width = src._getActualColumnWidth(c,rowHeader);
                    if(width !== undefined && width !== null)
                    {
                        src.setColumnWidth(c,src.defaults.rowHeaderColWidth,rowHeader);
                        dest.setColumnWidth(c,width,rowHeader)
                    }
                }
            },
            moveSheetInfo: function(src, dest, option)
            {
                if(!(src === dest && src._name === dest._name))
                {
                    if((option & UI.CopyToOption.Style) > 0)
                    {
                        var SheetArea = UI.SheetArea;
                        var colHeader = SheetArea.colHeader;
                        var rowHeader = SheetArea.rowHeader;
                        dest.setDefaultStyle(src.getDefaultStyle());
                        dest.setDefaultStyle(src.getDefaultStyle(colHeader),colHeader);
                        dest.setDefaultStyle(src.getDefaultStyle(rowHeader),rowHeader);
                        src.setDefaultStyle(null);
                        src.setDefaultStyle(null,colHeader);
                        src.setDefaultStyle(null,rowHeader)
                    }
                    dest.defaults.colWidth = src.defaults.colWidth;
                    dest.defaults.rowHeight = src.defaults.rowHeight;
                    dest.defaults.rowHeaderColWidth = src.defaults.rowHeaderColWidth;
                    src.defaults.colWidth = 62;
                    src.defaults.rowHeight = 20;
                    src.defaults.rowHeaderColWidth = 40
                }
            },
            moveBindingPath: function(src, srcRow, srcColumn, dest, destRow, destColumn, copyRowCount, copyColumnCount)
            {
                var fromRow = srcRow;
                var fromColumn = srcColumn;
                var toRow = destRow;
                var toColumn = destColumn;
                var rowCount = copyRowCount;
                var columnCount = copyColumnCount;
                if(srcRow < 0)
                {
                    fromRow = 0;
                    rowCount = Math.min(src.getRowCount(),dest.getRowCount())
                }
                if(srcColumn < 0)
                {
                    fromColumn = 0;
                    columnCount = Math.min(src.getColumnCount(),dest.getColumnCount())
                }
                if(destRow < 0)
                    toRow = 0;
                if(destColumn < 0)
                    toColumn = 0;
                var savedValues = [];
                var crossSheet = !(src === dest && src._name === dest._name);
                if(crossSheet)
                {
                    var path;
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                        {
                            path = src.getBindingPath(fromRow + r,fromColumn + c);
                            dest.setBindingPath(toRow + r,toColumn + c,path);
                            if(path)
                                savedValues.push({
                                    row: r,
                                    col: c,
                                    value: src.getValue(fromRow + r,fromColumn + c)
                                });
                            src.setBindingPath(fromRow + r,fromColumn + c,null)
                        }
                }
                else
                {
                    var savedPaths = new UI._GcSheetModel(rowCount,columnCount,null);
                    var path;
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                        {
                            path = src.getBindingPath(fromRow + r,fromColumn + c);
                            savedPaths.setBindingPath(r,c,path);
                            if(path)
                                savedValues.push({
                                    row: r,
                                    col: c,
                                    value: src.getValue(fromRow + r,fromColumn + c)
                                })
                        }
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            src.setBindingPath(fromRow + r,fromColumn + c,null);
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                            dest.setBindingPath(toRow + r,toColumn + c,savedPaths.getBindingPath(r,c))
                }
                return savedValues
            },
            setRangeText: function(sheet, row, column, data, rowDelimiter, columnDelimiter, cellDelimiter, flags)
            {
                if(!sheet)
                    throw new Error("sheet");
                if(row < -1 || row >= sheet.getRowCount())
                    raiseInvalidRangeException("row",row,"-1",sheet.getRowCount() - 1);
                if(column < -1 || column >= sheet.getColumnCount())
                    raiseInvalidRangeException("column",column,"-1",sheet.getColumnCount() - 1);
                if(data === undefined || data === null || data === "")
                    return;
                if(row === -1)
                    row = 0;
                if(column === -1)
                    column = 0;
                var sheetData = staticMembers.parseText(data,rowDelimiter,columnDelimiter,cellDelimiter);
                if(sheetData && sheetData.length > 0)
                    staticMembers.setSheetData(sheet,row,column,sheetData,flags)
            },
            getRangeText: function(sheet, row, rowCount, column, columnCount, rowDelimiter, columnDelimiter, cellDelimiter, forceCellDelimiter, flags)
            {
                if(!sheet)
                    throw new Error("sheet");
                if(row < -1 || row >= sheet.getRowCount())
                    raiseInvalidRangeException("row",row,"-1",sheet.getRowCount() - 1);
                if(rowCount < -1 || row + rowCount > sheet.getRowCount())
                    raiseInvalidRangeException("rowCount",row,"-1",sheet.getRowCount() - row);
                if(column < -1 || column >= sheet.getColumnCount())
                    raiseInvalidRangeException("column",column,"-1",sheet.getColumnCount() - 1);
                if(columnCount < -1 || column + columnCount > sheet.getColumnCount())
                    raiseInvalidRangeException("columnCount",column,"-1",sheet.getColumnCount() - column);
                var endRow = -1;
                var endColumn = -1;
                if(row === -1 && column === -1 && rowCount === -1 && columnCount === -1)
                {
                    row = 0;
                    column = 0;
                    endRow = sheet.getRowCount() - 1;
                    endColumn = sheet.getColumnCount() - 1
                }
                else
                {
                    if(row === -1)
                        row = 0;
                    if(column === -1)
                        column = 0;
                    if(rowCount === -1)
                        rowCount = sheet.getRowCount() - row;
                    if(columnCount === -1)
                        columnCount = sheet.getColumnCount() - column;
                    endRow = row + rowCount - 1;
                    endColumn = column + columnCount - 1
                }
                if(rowDelimiter === undefined || rowDelimiter === null || rowDelimiter === "")
                    rowDelimiter = "\r\n";
                if(columnDelimiter === undefined || columnDelimiter === null || columnDelimiter === "")
                    columnDelimiter = "\t";
                if(cellDelimiter === undefined || cellDelimiter === null || cellDelimiter === "")
                    cellDelimiter = "\"";
                var sbr = "";
                for(var r = row; r <= endRow; r++)
                {
                    var newLine = true;
                    for(var c = column; c <= endColumn; c++)
                    {
                        if(!newLine)
                            sbr += columnDelimiter;
                        newLine = false;
                        var cellStr = "";
                        var cellData = sheet.getValue(r,c);
                        if(cellData !== undefined && cellData !== null)
                            cellStr = cellData.toString();
                        sbr += cellStr
                    }
                    sbr += rowDelimiter
                }
                return sbr.toString()
            },
            parseText: function(data, rowDelimiter, columnDelimiter, cellDelimiter)
            {
                if(data === undefined || data === null || data === "")
                    return null;
                if(rowDelimiter === undefined || rowDelimiter === null || rowDelimiter === "")
                    rowDelimiter = "\r\n";
                if(columnDelimiter === undefined || columnDelimiter === null || columnDelimiter === "")
                    columnDelimiter = "\t";
                if(cellDelimiter === undefined || cellDelimiter === null || cellDelimiter === "")
                    cellDelimiter = "\"";
                if(!UI.StringHelper.EndsWith(data,rowDelimiter))
                    data += rowDelimiter;
                var sheetData = [],
                    rowData = [];
                var sbr = new UI.StringBuilder;
                var inCell = false;
                var dl = cellDelimiter.length;
                var rdl = rowDelimiter.length;
                var cdl = columnDelimiter.length;
                for(var index = 0; index < data.length; index++)
                {
                    sbr.Append(data[index]);
                    if(sbr.Length() >= dl && cellDelimiter === sbr.ToString(sbr.Length() - dl,dl))
                    {
                        if(inCell && data.length >= index + 1 + dl && cellDelimiter === data.substr(index + 1,dl))
                            index += dl
                    }
                    else if(sbr.Length() >= cdl && columnDelimiter === sbr.ToString(sbr.Length() - cdl,cdl))
                    {
                        sbr.Remove(sbr.Length() - cdl,cdl);
                        rowData.push(sbr.toString());
                        sbr.Remove(0,sbr.Length())
                    }
                    else if(sbr.Length() >= rdl && rowDelimiter === sbr.ToString(sbr.Length() - rdl,rdl))
                    {
                        sbr.Remove(sbr.Length() - rdl,rdl);
                        rowData.push(sbr.toString());
                        sheetData.push(rowData);
                        rowData = [];
                        sbr.Remove(0,sbr.Length())
                    }
                }
                return sheetData
            },
            setSheetData: function(sheet, rowIndex, columnIndex, data, flags)
            {
                var dataRowCount = data.length;
                var dataColumnCount = staticMembers.getMaxLength(data);
                if(dataRowCount === 0 || dataColumnCount === 0)
                    return;
                var opt = new ImportExportOptions(flags);
                opt.fixOptions(sheet);
                var SheetArea = UI.SheetArea;
                var rowHeaderColumnCount = opt.rowHeader ? sheet.getColumnCount(SheetArea.rowHeader) : 0;
                var columnHeaderRowCount = opt.columnHeader ? sheet.getRowCount(SheetArea.colHeader) : 0;
                var columnFooterRowCount = 0;
                dataColumnCount -= rowHeaderColumnCount;
                if(dataColumnCount <= 0)
                    dataColumnCount = 0;
                dataRowCount -= columnHeaderRowCount;
                if(dataRowCount <= 0)
                    columnFooterRowCount = 0;
                dataRowCount -= columnFooterRowCount;
                if(dataRowCount <= 0)
                    dataRowCount = 0;
                if(opt.expandRows && rowIndex + dataRowCount > sheet.getRowCount())
                    sheet.setRowCount(rowIndex + dataRowCount);
                if(opt.expandColumns && columnIndex + dataColumnCount > sheet.getColumnCount())
                    sheet.setColumnCount(columnIndex + dataColumnCount);
                for(var r = 0, sheetRowIndex = 0; r < data.length; r++, sheetRowIndex++)
                {
                    var rowData = data[r];
                    if(rowData.length <= 0)
                        continue;
                    if(columnHeaderRowCount > 0 && r < columnHeaderRowCount)
                        staticMembers.setRowData(sheet,rowData,sheetRowIndex,columnIndex,dataColumnCount,SheetArea.colHeader,opt);
                    else if(dataRowCount > 0 && sheetRowIndex < sheet.getRowCount())
                    {
                        if(r === columnHeaderRowCount)
                            sheetRowIndex = rowIndex;
                        staticMembers.setRowData(sheet,rowData,sheetRowIndex,0,rowHeaderColumnCount,SheetArea.rowHeader,opt);
                        rowData.splice(0,rowHeaderColumnCount);
                        staticMembers.setRowData(sheet,rowData,sheetRowIndex,columnIndex,dataColumnCount,SheetArea.viewport,opt)
                    }
                }
            },
            setRowData: function(sheet, rowData, sheetRowIndex, columnIndex, columnCount, area, opt)
            {
                for(var c = 0, sheetColumnIndex = columnIndex; c < rowData.length; c++, sheetColumnIndex++)
                    if(columnCount > 0 && sheetColumnIndex < sheet.getColumnCount(area))
                        staticMembers.setCellData(sheet,area,sheetRowIndex,sheetColumnIndex,rowData[c],opt)
            },
            setCellData: function(sheet, area, rowIndex, columnIndex, value, opt)
            {
                var setvalue = value;
                var autodisplayformatter = null;
                if(opt.unFormatted === false)
                {
                    var outPara = {value: value};
                    autodisplayformatter = (new UI.GeneralFormatter).GetPreferredDisplayFormatter(value,outPara);
                    setvalue = outPara.value
                }
                if(setvalue === undefined || setvalue === null)
                    sheet.setValue(rowIndex,columnIndex,setvalue,area);
                else if(value !== "")
                    if(opt.formula && value[0] === "=")
                        try
                        {
                            sheet.setFormula(rowIndex,columnIndex,value.substr(1),area)
                        }
                        catch(ex)
                        {
                            sheet.setText(rowIndex,columnIndex,value,area)
                        }
                    else
                    {
                        var style = sheet.getActualStyle(rowIndex,columnIndex,area);
                        if(style)
                            if(opt.unFormatted === false)
                            {
                                if(!style.formatter)
                                {
                                    var autoFormatter = new UI.AutoFormatter(autodisplayformatter);
                                    sheet.getCell(rowIndex,columnIndex,area)._setStyleProperty("_autoFormatter",autoFormatter)
                                }
                                else if(style.formatter.toString() === "@")
                                    setvalue = value.toString()
                            }
                            else if(style.formatter)
                                sheet.getCell(rowIndex,columnIndex,area).formatter(null);
                        sheet.setValue(rowIndex,columnIndex,setvalue,area)
                    }
                else
                    sheet.setValue(rowIndex,columnIndex,null,area)
            },
            getMaxLength: function(data)
            {
                if(data === undefined || data === null)
                    return 0;
                var len = 0;
                for(var i = 0; i < data.length; i++)
                {
                    var list = data[i];
                    len = Math.max(list.length,len)
                }
                return len
            },
            parseCsv: function(text, rowDelimiter, columnDelimiter, cellDelimiter)
            {
                var ret = null;
                var parsedText = staticMembers.parseText(text,rowDelimiter,columnDelimiter,cellDelimiter);
                if(parsedText)
                {
                    var rowCount = parsedText.length;
                    var columnCount = staticMembers.getMaxLength(parsedText);
                    var textArray = [];
                    for(var r = 0; r < rowCount; r++)
                    {
                        textArray[r] = [];
                        for(var c = 0; c < columnCount; c++)
                            if(c < parsedText[r].length)
                                textArray[r][c] = parsedText[r][c];
                            else
                                textArray[r][c] = null
                    }
                    ret = textArray
                }
                return ret
            }
        };
    var regExpKeyPattern = [/\\/g,/\(/g,/\[/g,/\{/g,/\^/g,/\$/g,/\|/g,/\)/g,/\+/g,/\./g];
    var questionMarkHolder = new RegExp("{113E2532-EAF5-444c-A5CB-3D7446971C4D}","g"),
        asteriskHolder = new RegExp("{E21523B3-0F1F-458f-B547-23D25713D0EC}","g");
    function fixFormulaKeyword(searchString, useWildCards, exactMatch)
    {
        for(var i in regExpKeyPattern)
            if(regExpKeyPattern[i])
                searchString = searchString.replace(regExpKeyPattern[i],regExpKeyPattern[i].source);
        if(useWildCards === true)
        {
            searchString = searchString.replace(/~\?/g,questionMarkHolder.source);
            searchString = searchString.replace(/~\*/g,asteriskHolder.source);
            searchString = searchString.replace(/\?/g,".");
            if(exactMatch)
                searchString = searchString.replace(/\*/g,"((.|\\n)+)");
            else
                searchString = searchString.replace(/\*/g,"((.|\\n)*)");
            searchString = searchString.replace(questionMarkHolder,"\\?");
            searchString = searchString.replace(asteriskHolder,"\\*")
        }
        else
        {
            searchString = searchString.replace(/\?/g,"\\?");
            searchString = searchString.replace(/\*/g,"\\*")
        }
        return searchString
    }
    UI.DataContext = function(read, create, update, remove)
    {
        this.read = read;
        this.create = create;
        this.update = update;
        this.remove = remove
    };
    var _gcSheet = ".gcSheet";
    var _gcSheetInternal = ".gcSheetInternal";
    var _mouseDown_gcSheet = "mousedown" + _gcSheet;
    var _mouseMove_gcSheet = "mousemove" + _gcSheet;
    var _mouseUp_gcSheet = "mouseup" + _gcSheet;
    var _mouseOut_gcSheet = "mouseout" + _gcSheet;
    var _dblclick_gcSheet = "dblclick" + _gcSheet;
    var _mouseWheel_gcSheet = "gcmousewheel" + _gcSheet;
    var _resize_gcSheet = "resize" + _gcSheet;
    var _value = "value";
    var _cssLeft = "left",
        _cssTop = "top",
        _cssWidth = "width",
        _cssHeight = "height",
        _cssHidden = "hidden",
        cssVisibility = "visibility";
    var ajax_Type = "POST",
        ajax_DataType = "json",
        ajax_MIME = "application/json;charset=UTF-8";
    var _jsonDateRegExp = new RegExp("^/Date\\(-?\\d+\\)/\\s*$");
    UI.EditorStatus = {
        Ready: 0,
        Enter: 1,
        Edit: 2
    };
    UI.GcSheet = function(name)
    {
        this._init(name)
    };
    UI.GcSheet.prototype = {
        getDataSource: function()
        {
            return this._dataSource
        },
        _isDataView: function(data)
        {
            var wijmo = window.wijmo;
            return wijmo && wijmo.data && wijmo.data.isDataView(data)
        },
        _dataChangedhandler: function(context)
        {
            if(this._updatingDataView)
                return;
            var self = this;
            this._bindToAutoRefresh(function(context)
            {
                if(context)
                {
                    self._dataViewUpdating = true;
                    if(!isNaN(context.length))
                        self.setRowCount(context.length);
                    self._dataViewUpdating = false
                }
            })(context)
        },
        _currentPositionChangedhandler: function(context)
        {
            var self = this;
            this._bindToAutoRefresh(function(context)
            {
                if(self._dataSource && self._dataSource.currentPosition)
                {
                    var pos = self._dataSource.currentPosition();
                    var pos = self._dataSource.currentPosition();
                    if(self._activeRowIndex !== pos)
                        self.setActiveCell(pos,self._activeColIndex)
                }
            })(context)
        },
        _isCellBinding: function(source)
        {
            return UI.CellBindingSource && source instanceof UI.CellBindingSource || source && source.hasOwnProperty("__cellBindingSource__")
        },
        getBindingPath: function(row, col, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = SheetArea.viewport;
            if(sheetArea === SheetArea.viewport)
            {
                var m = this._getModel(sheetArea);
                if(m)
                    return m.getBindingPath(row,col)
            }
            return null
        },
        setBindingPath: function(row, col, path, sheetArea)
        {
            return this._bindToAutoRefresh(function(row, col, path, sheetArea)
                {
                    var SheetArea = UI.SheetArea;
                    if(sheetArea === undefined || sheetArea === null)
                        sheetArea = SheetArea.viewport;
                    if(sheetArea === SheetArea.viewport)
                    {
                        var m = this._getModel(sheetArea);
                        if(m)
                            m.setBindingPath(row,col,path)
                    }
                    return this
                })(row,col,path,sheetArea)
        },
        _autoGenerateColumnCellType: function(col)
        {
            if(this._dataSource && this._colInfos && this._colInfos[col])
            {
                var item = this._getDataItem(this._dataSource,0);
                if(item)
                {
                    var value = item[this._colInfos[col].name];
                    if(typeof value === const_boolean)
                        this.setCellType(-1,col,new UI.CheckBoxCellType)
                }
            }
        },
        setDataSource: function(data, reset)
        {
            this._bindToAutoRefresh(function(data, reset)
            {
                if(!data || reset)
                    this.reset();
                if(this._dataSource && this._dataSource.dispose)
                    this._dataSource.dispose();
                this._dataSource = data;
                if(data && data.subscribe)
                    data.subscribe(this._dataChangedhandler,this);
                if(data && data.currentPosition && data.currentPosition.subscribe)
                    data.currentPosition.subscribe(this._currentPositionChangedhandler,this);
                if(this._isDataView(data))
                {
                    this.setRowCount(data.count());
                    if(this.autoGenerateColumns)
                    {
                        var ps = data.getProperties();
                        if(ps && ps.length > 0)
                        {
                            this.setColumnCount(ps.length);
                            this._colInfos = {};
                            for(var i = 0; i < ps.length; i++)
                                this._colInfos[i] = {name: ps[i].name}
                        }
                    }
                    else if(!this._colInfos)
                        this._colInfos = {}
                }
                else if(window.ko && window.ko.isObservable(data))
                {
                    this.setRowCount(data().length);
                    if(this.autoGenerateColumns)
                    {
                        var ps = this._getProperties(data()[0]);
                        if(ps && ps.length > 0)
                        {
                            this.setColumnCount(ps.length);
                            this._colInfos = {};
                            for(var i = 0; i < ps.length; i++)
                                this._colInfos[i] = {name: ps[i]}
                        }
                    }
                    else if(!this._colInfos)
                        this._colInfos = {}
                }
                else if(this._isCellBinding(data));
                else if(data && !isNaN(data.length))
                {
                    this.setRowCount(data.length);
                    if(this.autoGenerateColumns)
                    {
                        var ps = this._getProperties(data[0]);
                        if(ps && ps.length > 0)
                        {
                            this.setColumnCount(ps.length);
                            this._colInfos = {};
                            for(var i = 0; i < ps.length; i++)
                                this._colInfos[i] = {name: ps[i]}
                        }
                    }
                    else if(!this._colInfos)
                        this._colInfos = {}
                }
                this.doDataItemChanged()
            })(data,reset)
        },
        bindColumn: function(index, column)
        {
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                if(typeof column === const_string)
                    column = {name: column};
                if(!this._colInfos)
                    this._colInfos = {};
                this._colInfos[index] = column;
                if(column && column.formatter)
                    this.setFormatter(-1,index,column.formatter);
                if(column && column.cellType)
                    this.setCellType(-1,index,column.cellType)
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        bindColumns: function(columns)
        {
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                this._colInfos = {};
                if(columns)
                {
                    if(!isNaN(columns.length))
                        this.setColumnCount(columns.length);
                    for(var i = 0; i < columns.length; i++)
                    {
                        var colInfo = columns[i];
                        if(typeof colInfo === const_string)
                            colInfo = {name: colInfo};
                        this._colInfos[i] = colInfo;
                        if(colInfo && colInfo.formatter)
                            this.setFormatter(-1,i,colInfo.formatter);
                        if(colInfo && colInfo.cellType)
                            this.setCellType(-1,i,colInfo.cellType)
                    }
                }
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        getDataContext: function()
        {
            return this.dataContext
        },
        setDataContext: function(dataContext)
        {
            this.dataContext = dataContext;
            this.load()
        },
        _getDataLength: function(dataSource)
        {
            var ds = dataSource;
            if(ds)
            {
                var ko = window.ko;
                if(this._isDataView(ds))
                    return ds.count();
                else if(ko && ko.isObservable(ds))
                    return ds().length;
                else if(this._isCellBinding(ds))
                    return 0;
                else if(ds && !isNaN(ds.length))
                    return ds.length
            }
            return 0
        },
        _getDataItemType: function(dataSource)
        {
            var ds = dataSource;
            if(ds)
            {
                var dataLength = this._getDataLength(ds);
                for(var i = 0; i < dataLength; i++)
                {
                    var dataItem = this._getDataItem(ds,i);
                    if(dataItem)
                        return dataItem.constructor
                }
            }
            return null
        },
        _getDataItem: function(dataSource, row)
        {
            var ds = dataSource;
            var ko = window.ko;
            if(this._isDataView(ds))
                return ds.item(row);
            else if(ko && ko.isObservable(ds))
                return ds()[row];
            else if(this._isCellBinding(ds))
                return null;
            else
                return ds[row];
            return null
        },
        getDataItem: function(row)
        {
            var ds = this.getDataSource();
            if(!ds && this._getDataLength(ds) === 0)
                return null;
            var cc = this.getColumnCount();
            var t = {};
            var rowItem = this._getDataItem(ds,row);
            if(rowItem)
                for(var x in rowItem)
                    if(rowItem.hasOwnProperty(x) && typeof x !== const_function)
                        t[x] = rowItem[x];
            for(var i = 0; i < cc; i++)
            {
                var ci = this._colInfos[i];
                if(ci && ci.name && ci.name.length > 0)
                    t[ci.name] = this.getValue(row,i)
            }
            return t
        },
        getDirtyRows: function()
        {
            var rows = [];
            var dirtyNodes = this._dataModel.dirtyNodes;
            if(dirtyNodes)
                for(var t in dirtyNodes)
                    if(dirtyNodes.hasOwnProperty(t) && dirtyNodes[t] && dirtyNodes[t].rs === "e")
                        rows.push({
                            row: t,
                            item: this.getDataItem(t),
                            originalItem: !this._dataSource ? null : this._getDataItem(this._dataSource,t)
                        });
            return rows
        },
        getInsertRows: function()
        {
            var rows = [];
            var dirtyNodes = this._dataModel.dirtyNodes;
            if(dirtyNodes)
                for(var t in dirtyNodes)
                    if(dirtyNodes.hasOwnProperty(t) && dirtyNodes[t] && dirtyNodes[t].rs === "n")
                        rows.push({
                            row: t,
                            item: this.getDataItem(t)
                        });
            return rows
        },
        _getDeleteRows: function()
        {
            var rows = [];
            if(this.deletedRows)
                $.each(this.deletedRows,function(i, v)
                {
                    if(typeof v !== const_function)
                        if(v && v.data !== undefined && v.data !== null)
                            rows.push({
                                row: i,
                                originalItem: v.data
                            })
                });
            return rows
        },
        hasPendingChanges: function()
        {
            var dirtyNodes = this._dataModel.dirtyNodes,
                t;
            if(dirtyNodes)
                for(t in dirtyNodes)
                    if(dirtyNodes[t] && (dirtyNodes[t].rs === "e" || dirtyNodes[t].rs === "n"))
                        return true;
            if(this.deletedRows)
                for(t in this.deletedRows)
                    if(this.deletedRows[t])
                    {
                        var item = this.deletedRows[t];
                        if(typeof item !== const_function)
                            return true
                    }
            return false
        },
        clearPendingChanges: function()
        {
            this._dataModel.dirtyNodes = {};
            this.deletedRows = [];
            function clearDirty(items)
            {
                $.each(items,function(i, v)
                {
                    if(typeof i !== const_function && v && v.dirty)
                        v.dirty = null
                })
            }
            clearDirty(this._rowInfos);
            clearDirty(this._colInfos)
        },
        load: function()
        {
            if(!this.dataContext || !this.dataContext.read)
                return;
            var self = this;
            this._dataReceivedDelegate = function(event)
            {
                return self._onDataReceived(event)
            };
            $.getJSON(this.dataContext.read,this._dataReceivedDelegate)
        },
        updateRecord: function()
        {
            if(!this.autoUpdate || !this.dataContext || !this.dataContext.update || this.dataContext.update === "")
                return;
            var ds = this.getDataSource();
            if(!ds || this._getDataLength(ds) === 0)
                return;
            var self = this;
            this._dataUpdatedDelegate = function(event)
            {
                return self._onDataUpdated(event)
            };
            var n = this._activeRowIndex;
            if(n >= 0)
            {
                var item = this.getDataItem(n);
                var url = this.dataContext.update;
                if(this._dataModel.dataTable && this._dataModel.dataTable[n] && this._dataModel.dataTable[n].rs === "n")
                    url = this.dataContext.create;
                $.ajax({
                    url: url,
                    type: ajax_Type,
                    data: JSON.stringify(item),
                    dataType: ajax_DataType,
                    contentType: ajax_MIME,
                    success: this._dataUpdatedDelegate
                })
            }
        },
        _onDataUpdated: function(event){},
        _onDataReceived: function(event)
        {
            if(!event)
                return;
            var data = event.data;
            if(!data)
                return;
            this.setDataSource(data);
            if(!isNaN(event.total))
                this.setRowCount(event.total);
            if(window.localStorage)
            {
                var cc = this.getColumnCount();
                for(var i = 0; i < cc; i++)
                    if(window.localStorage["col," + i])
                        this.setColumnWidth(i,parseInt(window.localStorage["col," + i],10))
            }
            if(this.parent)
                this.parent._doResize();
            this.invalidateLayout();
            this.repaint()
        },
        _getProperties: function(t)
        {
            var r = [];
            if(t)
                for(var n in t)
                    if(typeof t[n] !== const_function)
                        r.push(n);
                    else if(typeof ko !== const_undefined && ko.isObservable(t[n]))
                        r.push(n);
            return r
        },
        referenceStyle: function(value)
        {
            var rs = UI.ReferenceStyle;
            if(arguments.length === 0)
                return this.getCalcService().useR1C1 ? rs.R1C1 : rs.A1;
            this.getCalcService().useR1C1 = value === rs.R1C1;
            return this
        },
        recalcAll: function()
        {
            var calcService = this.getCalcService();
            calcService.recalculateAll()
        },
        _recalcCell: function(model, row, col)
        {
            var calcService = this.getCalcService();
            calcService.recalculate({
                target: this,
                model: model
            },row,col)
        },
        getCalcService: function()
        {
            if(!this.calcService)
                this.calcService = new GrapeCity.Calc.Service(this);
            return this.calcService
        },
        _getCalcContexts: function()
        {
            var t = [];
            var vpModel = this._getModel();
            t.push({
                name: this._name,
                target: this,
                refModel: vpModel
            });
            return t
        },
        updateCalcContexts: function()
        {
            var calcService = this.getCalcService();
            calcService.contextChanged()
        },
        suspendCalcService: function()
        {
            if(this.calcService)
                this.calcService.suspend()
        },
        resumeCalcService: function()
        {
            if(this.calcService)
                this.calcService.resume()
        },
        _getSheetSource: function(sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
                return this._vpSheetSource;
            return null
        },
        getCustomFunction: function(name)
        {
            if(this._functions && name && name !== '')
                return this._functions[name.toUpperCase()];
            return null
        },
        addCustomFunction: function(fn)
        {
            if(!fn || !(fn instanceof GrapeCity.Calc.Functions.Function))
                throw new Error("invalid custom function");
            var fnName = fn.name.toUpperCase();
            if(!this._functions)
                this._functions = {};
            this._functions[fnName] = fn;
            this.recalcAll()
        },
        removeCustomFunction: function(name)
        {
            if(this._functions && name && name !== '')
            {
                name = name.toUpperCase();
                if(this._functions.hasOwnProperty(name))
                {
                    delete this._functions[name];
                    this.recalcAll()
                }
            }
        },
        clearCustomFunctions: function()
        {
            if(this._functions)
            {
                delete this._functions;
                this.recalcAll()
            }
        },
        _findCustomFunction: function(name)
        {
            if(!name || name === '')
                return null;
            var fn = this.getCustomFunction(name);
            if(!fn && this.parent && this.parent.getCustomFunction)
                fn = this.parent.getCustomFunction(name);
            return fn
        },
        getCustomName: function(name)
        {
            return this._names ? this._names[name] : null
        },
        addCustomName: function(name, formula, baseRow, baseCol)
        {
            if(!name || name === '' || !formula || formula === '')
                throw new Error("invalid custom name");
            if(!this._names)
                this._names = {};
            var calcService = this.getCalcService();
            var expr = calcService.parse(formula,baseRow,baseCol);
            this._names[name] = new UI.NameInfo(name,expr,baseRow,baseCol);
            var nameCalc = this._getSheetSource()._getNameCalc(name,true);
            if(nameCalc)
            {
                nameCalc.updateListening(true,true);
                nameCalc.addToDirty()
            }
            this.recalcAll()
        },
        removeCustomName: function(name)
        {
            if(this._names && name && name !== '' && this._names.hasOwnProperty(name))
            {
                delete this._names[name];
                var nameCalc = this._getSheetSource()._getNameCalc(name);
                if(nameCalc)
                {
                    nameCalc.updateListening(true,false);
                    nameCalc.addToDirty()
                }
                this.recalcAll()
            }
        },
        clearCustomNames: function()
        {
            if(this._names)
            {
                var names = this._names;
                delete this._names;
                var sheetSource = this._getSheetSource();
                for(var i = 0; i < names.length; i++)
                {
                    var nameCalc = sheetSource._getNameCalc(names[i]);
                    if(nameCalc)
                    {
                        nameCalc.updateListening(true,false);
                        nameCalc.addToDirty()
                    }
                }
                this.recalcAll()
            }
        },
        _findCustomName: function(name)
        {
            if(!name || name === '')
                return null;
            var cn = this.getCustomName(name);
            if(!cn && this.parent && this.parent.getCustomName)
                cn = this.parent.getCustomName(name);
            return cn
        },
        setFormula: function(row, col, value, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === SheetArea.colHeader || sheetArea === SheetArea.rowHeader)
                return;
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = SheetArea.viewport;
            var E = UI.Events;
            if(row < 0 || row >= this.getRowCount() || col < 0 || col >= this.getColumnCount())
            {
                this._trigger(E.InvalidOperation,{
                    sheet: this,
                    sheetName: this._name,
                    message: "Index out of range!"
                });
                return
            }
            var sheetSource = this._getSheetSource();
            if(sheetSource)
            {
                sheetSource.setFormula(row,col,value);
                if(this._conditionalFormats)
                    this._conditionalFormats._clearCache();
                if(this._eventHandler._eventSuspended < 1)
                    this._trigger(E.CellChanged,{
                        sheet: this,
                        sheetName: this._name,
                        row: row,
                        col: col,
                        sheetArea: sheetArea,
                        propertyName: "formula"
                    })
            }
        },
        getFormula: function(row, col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
            {
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    return sheetSource.getFormula(row,col)
            }
            return null
        },
        hasFormula: function(row, col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
            {
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    return sheetSource.hasFormula(row,col)
            }
            return false
        },
        _findFormulas: function(row, column, rowCount, columnCount){},
        _rebuildCalcNodes: function()
        {
            var calcModel = this._getCalcModel();
            if(!calcModel)
                return;
            var sheetSource = this._getSheetSource();
            if(!sheetSource)
                return;
            var row = calcModel.nextNonNullRow(-1);
            var rowCount = calcModel.getRowCount();
            var colCount = calcModel.getColumnCount();
            while(0 <= row && row < rowCount)
            {
                var col = calcModel.nextNonNullColumn(row,-1);
                while(0 <= col && col < colCount)
                {
                    var cellCalc = sheetSource._getCellCalc(row,col);
                    if(cellCalc)
                    {
                        cellCalc.stopListening();
                        cellCalc.startListening()
                    }
                    col = calcModel.nextNonNullColumn(row,col)
                }
                row = calcModel.nextNonNullRow(row)
            }
        },
        _name: "",
        defaults: null,
        gridline: null,
        borderColor: "black",
        borderWidth: 1,
        _zoomFactor: 1.0,
        frozenRowCount: 0,
        frozenColCount: 0,
        rowHeaderVisible: true,
        colHeaderVisible: true,
        rowHeaderAutoText: UI.HeaderAutoText.numbers,
        colHeaderAutoText: UI.HeaderAutoText.letters,
        rowHeaderAutoTextIndex: -1,
        colHeaderAutoTextIndex: -1,
        rowRangeGroup: null,
        colRangeGroup: null,
        _activeRowIndex: 0,
        _activeColIndex: 0,
        activeRowViewportIndex: 0,
        activeColViewportIndex: 0,
        _allowCellOverflow: false,
        maxCellOverflowDistance: 100,
        showEditingLocator: true,
        keyMap: null,
        isProtected: false,
        _allowUndo: true,
        _paintSuspended: false,
        _layoutSuspended: 0,
        checkingChanges: false,
        autoGenerateColumns: true,
        _allowEditorReservedLocations: true,
        _sheetTabColor: null,
        _frozenlineColor: "black",
        toJSON: function()
        {
            var sheet = this;
            return{
                    name: sheet._name,
                    defaults: sheet.defaults,
                    columns: sheet._colInfos,
                    rows: sheet._rowInfos,
                    autoGenerateColumns: sheet.autoGenerateColumns,
                    dataSource: sheet._dataSource,
                    frozenRowCount: sheet.frozenRowCount,
                    frozenColCount: sheet.frozenColCount,
                    rowCount: sheet.getRowCount(),
                    columnCount: sheet.getColumnCount(),
                    data: sheet._dataModel.toJSON(),
                    sparklineGroupManager: sheet._sparklineGroupManager.toJSON(),
                    spans: sheet._spanModel.toJSON(),
                    selections: sheet._selectionModel.toJSON(),
                    activeRow: sheet._activeRowIndex,
                    activeCol: sheet._activeColIndex,
                    gridline: sheet.gridline,
                    allowCellOverflow: sheet._allowCellOverflow,
                    referenceStyle: sheet.referenceStyle(),
                    _zoomFactor: sheet._zoomFactor,
                    theme: sheet.currentTheme(),
                    showRowRangeGroup: sheet._showRowRangeGroup,
                    showColumnRangeGroup: sheet._showColumnRangeGroup,
                    rowRangeGroup: sheet.rowRangeGroup.toJSON(),
                    colRangeGroup: sheet.colRangeGroup.toJSON(),
                    rowFilter: sheet._rowFilter ? sheet._rowFilter.toJSON() : undefined,
                    conditionalFormats: sheet.getConditionalFormats().toJSON(),
                    sheetTabColor: sheet._sheetTabColor,
                    frozenlineColor: sheet._frozenlineColor,
                    rowHeaderAutoText: sheet.rowHeaderAutoText,
                    colHeaderAutoText: sheet.colHeaderAutoText,
                    rowHeaderAutoTextIndex: sheet.rowHeaderAutoTextIndex,
                    colHeaderAutoTextIndex: sheet.colHeaderAutoTextIndex,
                    rowHeaderVisible: sheet.rowHeaderVisible,
                    colHeaderVisible: sheet.colHeaderVisible,
                    rowHeaderColCount: sheet.getColumnCount(UI.SheetArea.rowHeader),
                    colHeaderRowCount: sheet.getRowCount(UI.SheetArea.colHeader),
                    rowHeaderData: sheet._rowHeaderModel.toJSON(),
                    colHeaderData: sheet._colHeaderModel.toJSON(),
                    rowHeaderSpan: sheet._rowHeaderSpanModel.toJSON(),
                    colHeaderSpan: sheet._colHeaderSpanModel.toJSON(),
                    rowHeaderColInfos: sheet._rowHeaderColInfos,
                    colHeaderRowInfos: sheet._colHeaderRowInfos,
                    clipBoardOptions: sheet._clipBoardOptions,
                    isProtected: sheet.isProtected,
                    borderColor: sheet.borderColor,
                    borderWidth: sheet.borderWidth,
                    allowDragDrop: sheet._allowDragDrop,
                    allowDragFill: sheet._allowDragFill,
                    allowUndo: sheet._allowUndo,
                    allowEditorReservedLocations: sheet._allowEditorReservedLocations
                }
        },
        fromJSON: function(sheetSettings)
        {
            if(!sheetSettings)
                return;
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                var sheet = this;
                var rowCount = sheetSettings.rowCount;
                var columnCount = sheetSettings.columnCount;
                sheet._name = sheetSettings.name;
                if(sheetSettings.defaults)
                    sheet.defaults = sheetSettings.defaults;
                sheet.setRowCount(rowCount);
                sheet.setColumnCount(columnCount);
                sheet.setActiveCell(sheetSettings.activeRow,sheetSettings.activeCol);
                sheet.frozenRowCount = sheetSettings.frozenRowCount;
                sheet.frozenColCount = sheetSettings.frozenColCount;
                sheet.gridline = sheetSettings.gridline;
                sheet._allowCellOverflow = sheetSettings.allowCellOverflow;
                if(typeof sheetSettings.autoGenerateColumns !== const_undefined)
                    sheet.autoGenerateColumns = sheetSettings.autoGenerateColumns;
                if(sheetSettings.dataSource)
                    sheet._dataSource = sheetSettings.dataSource;
                if(sheetSettings.rows)
                {
                    sheet._rowInfos = sheetSettings.rows;
                    sheet._rowInfos.length = rowCount
                }
                if(sheetSettings.columns)
                {
                    sheet._colInfos = sheetSettings.columns;
                    sheet._colInfos.length = columnCount
                }
                if(sheetSettings.colStyles)
                    for(var t in sheetSettings.colStyles)
                        if(!isNaN(t))
                        {
                            var c = parseInt(t,10);
                            sheet.setStyle(-1,c,sheetSettings.colStyles[t],GrapeCity.UI.SheetArea.viewport)
                        }
                if(sheetSettings.rowStyles)
                    for(var t in sheetSettings.rowStyles)
                        if(!isNaN(t))
                        {
                            var r = parseInt(t,10);
                            sheet.setStyle(r,-1,sheetSettings.rowStyles[t],GrapeCity.UI.SheetArea.viewport)
                        }
                if(typeof sheetSettings.rowHeaderAutoText !== const_undefined)
                    sheet.rowHeaderAutoText = sheetSettings.rowHeaderAutoText;
                if(typeof sheetSettings.colHeaderAutoText !== const_undefined)
                    sheet.colHeaderAutoText = sheetSettings.colHeaderAutoText;
                if(typeof sheetSettings.rowHeaderAutoTextIndex !== const_undefined)
                    sheet.rowHeaderAutoTextIndex = sheetSettings.rowHeaderAutoTextIndex;
                if(typeof sheetSettings.colHeaderAutoTextIndex !== const_undefined)
                    sheet.colHeaderAutoTextIndex = sheetSettings.colHeaderAutoTextIndex;
                if(typeof sheetSettings.rowHeaderVisible !== const_undefined)
                    sheet.rowHeaderVisible = sheetSettings.rowHeaderVisible;
                if(typeof sheetSettings.colHeaderVisible !== const_undefined)
                    sheet.colHeaderVisible = sheetSettings.colHeaderVisible;
                if(typeof sheetSettings.rowHeaderColCount !== const_undefined)
                    sheet.setColumnCount(sheetSettings.rowHeaderColCount,UI.SheetArea.rowHeader);
                if(typeof sheetSettings.colHeaderRowCount !== const_undefined)
                    sheet.setRowCount(sheetSettings.colHeaderRowCount,UI.SheetArea.colHeader);
                if(sheetSettings.rowHeaderData)
                    sheet._rowHeaderModel.fromJSON(sheetSettings.rowHeaderData);
                if(sheetSettings.colHeaderData)
                    sheet._colHeaderModel.fromJSON(sheetSettings.colHeaderData);
                if(sheetSettings.rowHeaderSpan)
                    sheet._rowHeaderSpanModel.fromJSON(sheetSettings.rowHeaderSpan);
                if(sheetSettings.colHeaderSpan)
                    sheet._colHeaderSpanModel.fromJSON(sheetSettings.colHeaderSpan);
                if(sheetSettings.rowHeaderColInfos)
                    sheet._rowHeaderColInfos = sheetSettings.rowHeaderColInfos;
                if(sheetSettings.colHeaderRowInfos)
                    sheet._colHeaderRowInfos = sheetSettings.colHeaderRowInfos;
                if(typeof sheetSettings.referenceStyle !== const_undefined)
                    sheet.referenceStyle(sheetSettings.referenceStyle);
                if(typeof sheetSettings._zoomFactor !== const_undefined)
                    sheet._zoomFactor = sheetSettings._zoomFactor;
                if(sheetSettings.spans)
                    sheet._spanModel.fromJSON(sheetSettings.spans);
                if(sheetSettings.selections)
                {
                    sheet._clearSelectionImp();
                    sheet._selectionModel.fromJSON(sheetSettings.selections)
                }
                if(sheetSettings.data)
                {
                    sheet._dataModel.fromJSON(sheetSettings.data);
                    var data = sheetSettings.data.dataTable;
                    if(data)
                        for(var j in data)
                            if(typeof j !== const_function)
                                for(var k in data[j])
                                    if(typeof k !== const_function)
                                    {
                                        var node = data[j][k];
                                        var formula = node.formula;
                                        if(formula)
                                            sheet.setFormula(parseInt(j,10),parseInt(k,10),formula)
                                    }
                }
                if(sheetSettings.sparklineGroupManager)
                {
                    sheet._sparklineGroupManager.fromJSON(sheetSettings.sparklineGroupManager);
                    var groups = sheet._sparklineGroupManager.groups();
                    var model = sheet._getModel(),
                        sparklines,
                        sparkline;
                    for(var i = 0; i < groups.length; i++)
                    {
                        sparklines = groups[i]._innerList;
                        for(var j = 0; j < sparklines.length; j++)
                        {
                            sparkline = sparklines[j];
                            model.setSparkline(sparkline.row,sparkline.column,sparkline)
                        }
                    }
                }
                if(sheetSettings.theme)
                {
                    var st = sheetSettings.theme;
                    if(typeof st === "string" || typeof st === const_undefined)
                        sheet.currentTheme(st);
                    else
                    {
                        var tc = st._themeColor;
                        var BACKCOLOR1 = 0,
                            BACKCOLOR2 = 1,
                            TEXTCOLOR1 = 2,
                            TEXTCOLOR2 = 3,
                            ACCENT1 = 4,
                            ACCENT2 = 5,
                            ACCENT3 = 6,
                            ACCENT4 = 7,
                            ACCENT5 = 8,
                            ACCENT6 = 9,
                            HYPERLINK = 10,
                            FHYPERLINK = 11;
                        var text1 = tc._colorList[TEXTCOLOR1],
                            text2 = tc._colorList[TEXTCOLOR2],
                            background1 = tc._colorList[BACKCOLOR1],
                            background2 = tc._colorList[BACKCOLOR2],
                            accent1 = tc._colorList[ACCENT1],
                            accent2 = tc._colorList[ACCENT2],
                            accent3 = tc._colorList[ACCENT3],
                            accent4 = tc._colorList[ACCENT4],
                            accent5 = tc._colorList[ACCENT5],
                            accent6 = tc._colorList[ACCENT6],
                            hyperlink = tc._colorList[HYPERLINK],
                            followedHyperlink = tc._colorList[FHYPERLINK];
                        var themeColor = new UI.ThemeColor(st._name,new UI._Color(text1.a,text1.r,text1.g,text1.b),new UI._Color(text2.a,text2.r,text2.g,text2.b),new UI._Color(background1.a,background1.r,background1.g,background1.b),new UI._Color(background2.a,background2.r,background2.g,background2.b),new UI._Color(accent1.a,accent1.r,accent1.g,accent1.b),new UI._Color(accent2.a,accent2.r,accent2.g,accent2.b),new UI._Color(accent3.a,accent3.r,accent3.g,accent3.b),new UI._Color(accent4.a,accent4.r,accent4.g,accent4.b),new UI._Color(accent5.a,accent5.r,accent5.g,accent5.b),new UI._Color(accent6.a,accent6.r,accent6.g,accent6.b),new UI._Color(hyperlink.a,hyperlink.r,hyperlink.g,hyperlink.b),new UI._Color(followedHyperlink.a,followedHyperlink.r,followedHyperlink.g,followedHyperlink.b));
                        var theme = new UI.SpreadTheme(st._name,themeColor,st._headingFont,st._bodyFont);
                        sheet.currentTheme(theme)
                    }
                }
                if(typeof sheetSettings.showRowRangeGroup !== const_undefined)
                    sheet._showRowRangeGroup = sheetSettings.showRowRangeGroup;
                if(typeof sheetSettings.showColumnRangeGroup !== const_undefined)
                    sheet._showColumnRangeGroup = sheetSettings.showColumnRangeGroup;
                if(sheetSettings.rowRangeGroup)
                    sheet.rowRangeGroup.fromJSON(sheetSettings.rowRangeGroup);
                if(sheetSettings.colRangeGroup)
                    sheet.colRangeGroup.fromJSON(sheetSettings.colRangeGroup);
                if(sheetSettings.rowFilter)
                {
                    var range = sheetSettings.rowFilter.range;
                    var drf = new UI.HideRowFilter(new UI.Range(range.row,range.col,range.rowCount,range.colCount));
                    sheet.rowFilter(drf);
                    drf.fromJSON(sheetSettings.rowFilter)
                }
                else
                    sheet.rowFilter(null);
                if(sheetSettings.conditionalFormats)
                    sheet.getConditionalFormats().fromJSON(sheetSettings.conditionalFormats);
                if(sheetSettings.sheetTabColor)
                    sheet.sheetTabColor(sheetSettings.sheetTabColor);
                if(sheetSettings.frozenlineColor)
                    sheet.frozenlineColor(sheetSettings.frozenlineColor);
                if(typeof sheetSettings.clipBoardOptions !== const_undefined)
                    sheet._clipBoardOptions = sheetSettings.clipBoardOptions;
                if(typeof sheetSettings.isProtected !== const_undefined)
                    sheet.isProtected = sheetSettings.isProtected;
                if(sheetSettings.borderColor)
                    sheet.borderColor = sheetSettings.borderColor;
                if(typeof sheetSettings.borderWidth !== const_undefined)
                    sheet.borderWidth = sheetSettings.borderWidth;
                if(typeof sheetSettings.allowDragDrop !== const_undefined)
                    sheet._allowDragDrop = sheetSettings.allowDragDrop;
                if(typeof sheetSettings.allowDragFill !== const_undefined)
                    sheet._allowDragFill = sheetSettings.allowDragFill;
                if(typeof sheetSettings.allowUndo !== const_undefined)
                    sheet.allowUndo(sheetSettings.allowUndo);
                if(typeof sheetSettings.allowEditorReservedLocations !== const_undefined)
                    sheet.allowEditorReservedLocations(sheetSettings.allowEditorReservedLocations)
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        isPaintSuspended: function(value)
        {
            if(arguments.length === 0)
                return this._paintSuspended;
            else
            {
                if(this._paintSuspended !== value)
                {
                    this._paintSuspended = value;
                    if(!value && this._layoutSuspended <= 0)
                    {
                        this.invalidateLayout();
                        this.repaint()
                    }
                }
                return this
            }
        },
        getName: function()
        {
            return this._name
        },
        setName: function(name)
        {
            if(!this._isValidSheetName(name))
                throw'NotSupportedException';
            this._name = name;
            if(this.parent && this.parent._doTabHSResize)
                this.parent._doTabHSResize()
        },
        allowCellOverflow: function(value)
        {
            if(arguments.length === 0)
                return this._allowCellOverflow;
            var self = this;
            return this._bindToAutoRefresh(function(value)
                {
                    self._allowCellOverflow = value;
                    return self
                })(value)
        },
        allowUndo: function(value)
        {
            if(arguments.length === 0)
                return this._allowUndo;
            this._allowUndo = value;
            var undoManager = this.undoManager();
            if(undoManager)
                undoManager._allowUndo = value;
            return this
        },
        allowEditorReservedLocations: function(value)
        {
            if(arguments.length === 0)
                return this._allowEditorReservedLocations;
            this._allowEditorReservedLocations = value;
            return this
        },
        sheetTabColor: function(value)
        {
            if(arguments.length === 0)
                return this._sheetTabColor;
            this._sheetTabColor = value;
            if(this.parent && this.parent._doTabHSResize)
                this.parent._doTabHSResize();
            return this
        },
        frozenlineColor: function(value)
        {
            if(arguments.length === 0)
                return this._frozenlineColor;
            var self = this;
            return this._bindToAutoRefresh(function(value)
                {
                    self._frozenlineColor = value;
                    return self
                })(value)
        },
        addRows: function(row, count)
        {
            if(count <= 0)
                return;
            var ds = this.getDataSource();
            if(ds && this._isDataView(ds))
            {
                if(!ds.canAdd || !ds.canAdd())
                    return;
                row = this.getRowCount()
            }
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                if(row < 0 || row > this.getRowCount())
                    row = this.getRowCount();
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    sheetSource.onBeforeAddRemoveRows(row);
                var m = this._getModel();
                m.addRows(row,count);
                if(ds)
                {
                    var itemType = this._getDataItemType(ds);
                    if(this._isDataView(ds))
                    {
                        if(!this._dataViewUpdating)
                        {
                            this._updatingDataView = true;
                            if(itemType)
                            {
                                for(var i = 0; i < count; i++)
                                    ds.add(new itemType);
                                ds.commitEdit()
                            }
                            this._updatingDataView = false
                        }
                    }
                    else if(this._isCellBinding(ds));
                    else
                        for(var i = 0; i < count; i++)
                            if(itemType)
                                ds.splice(row,0,new itemType);
                            else
                                ds.splice(row,0,null)
                }
                var calc = this._getCalcModel();
                calc.addRows(row,count);
                var SheetArea = UI.SheetArea;
                var rm = this._getModel(SheetArea.rowHeader);
                rm.addRows(row,count);
                m.addElements(this._rowInfos,this.getRowCount(),row,count);
                var sm = this._getSpanModel(SheetArea.rowHeader);
                sm.addRows(row,count);
                sm = this._getSpanModel();
                sm.addRows(row,count);
                if(this._rowFilter)
                    this._rowFilter._addRows(row,count);
                if(this.rowRangeGroup)
                    this.rowRangeGroup._add(row,count);
                if(this._sparklineGroupManager)
                    this._sparklineGroupManager._addRows(row,count);
                if(this._conditionalFormats)
                    this._conditionalFormats._addRows(row,count);
                if(sheetSource)
                    sheetSource.onAfterAddRows(row,count);
                this._syncScrollbarSize();
                this.invalidateLayout()
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        _onDataDeleted: function(event){},
        deleteRows: function(row, count)
        {
            if(0 > row || row >= this.getRowCount() || count <= 0)
                return;
            var ds = this.getDataSource();
            if(ds && this._isDataView(ds))
                if(!ds.canRemove || !ds.canRemove())
                    return;
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    sheetSource.onBeforeAddRemoveRows(row);
                var m = this._getModel();
                if(this.autoUpdate && this.dataContext && this.dataContext.remove)
                    if(ds && ds.length > 0)
                    {
                        var self = this;
                        this._dataDeleteDelegate = function(event)
                        {
                            return self._onDataDeleted(event)
                        };
                        var n = row;
                        if(n >= 0)
                        {
                            var item = this.getDataItem(n);
                            $.ajax({
                                url: this.dataContext.remove,
                                type: ajax_Type,
                                data: JSON.stringify(item),
                                dataType: ajax_DataType,
                                contentType: ajax_MIME,
                                success: this._dataDeleteDelegate
                            })
                        }
                    }
                if(!this.deletedRows)
                    this.deletedRows = [];
                var dataLength = this._getDataLength(ds);
                for(var i = 0; i < count && row + i < m.rowCount; i++)
                {
                    var d = null;
                    if(ds && row + i < dataLength)
                        d = this._getDataItem(ds,row + i);
                    var k = null;
                    if(m.dataTable && m.dataTable[row + i])
                        k = m.dataTable[row + i].key;
                    this.deletedRows.push({
                        row: row + i,
                        data: d,
                        key: k
                    })
                }
                if(ds)
                    if(this._isDataView(ds))
                    {
                        if(!this._dataViewUpdating)
                        {
                            this._updatingDataView = true;
                            var removeCount = Math.min(count,dataLength - row);
                            for(var r = 0; r < removeCount; r++)
                                ds.remove(ds.item(row));
                            this._updatingDataView = false
                        }
                    }
                    else if(this._isCellBinding(ds));
                    else if(row < dataLength)
                        ds.splice(row,count);
                m.deleteRows(row,count);
                var calc = this._getCalcModel();
                calc.deleteRows(row,count);
                var SheetArea = UI.SheetArea;
                var rm = this._getModel(SheetArea.rowHeader);
                rm.deleteRows(row,count);
                m.deleteElements(this._rowInfos,this.getRowCount(),row,count);
                var sm = this._getSpanModel(SheetArea.rowHeader);
                sm.removeRows(row,count);
                sm = this._getSpanModel();
                sm.removeRows(row,count);
                if(this._rowFilter)
                    this._rowFilter._removeRows(row,count);
                if(this.rowRangeGroup)
                    this.rowRangeGroup._remove(row,count);
                if(this._sparklineGroupManager)
                    this._sparklineGroupManager._removeRows(row,count);
                if(this._conditionalFormats)
                    this._conditionalFormats._removeRows(row,count);
                var top = this._scrollTopRow;
                if(top >= 0)
                {
                    var newTop = -1;
                    for(var t = top; t >= this.frozenRowCount; t--)
                        if(this.getRowVisible(t) && this._getZoomRowHeight(t) > 0)
                        {
                            newTop = t;
                            break
                        }
                    if(newTop === -1)
                        newTop = 0;
                    if(top !== newTop)
                    {
                        this._trigger(UI.Events.TopRowChanged,{
                            sheet: this,
                            sheetName: this._name,
                            oldTopRow: top,
                            newTopRow: newTop
                        });
                        this._scrollTopRow = newTop;
                        this._syncVScrollbarPosition()
                    }
                }
                if(sheetSource)
                    sheetSource.onAfterRemoveRows(row,count);
                this._syncScrollbarSize();
                this.invalidateLayout()
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        addColumns: function(col, count)
        {
            if(count <= 0)
                return;
            this._bindToAutoRefresh(function(col, count)
            {
                if(col < 0 || col > this.getColumnCount())
                    col = this.getColumnCount();
                if(this.parent && this.parent.gcSpreadsheet)
                    return;
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    sheetSource.onBeforeAddRemoveColumns(col);
                var m = this._getModel();
                m.addColumns(col,count);
                var calc = this._getCalcModel();
                calc.addColumns(col,count);
                var SheetArea = UI.SheetArea;
                var cm = this._getModel(SheetArea.colHeader);
                cm.addColumns(col,count);
                m.addElements(this._colInfos,this.getColumnCount(),col,count);
                var sm = this._getSpanModel(SheetArea.colHeader);
                sm.addColumns(col,count);
                sm = this._getSpanModel();
                sm.addColumns(col,count);
                if(this._rowFilter)
                    this._rowFilter._addColumns(col,count);
                if(this._allowCellOverflow === true)
                    this._clearCellOverflowModelCache();
                if(this.colRangeGroup)
                    this.colRangeGroup._add(col,count);
                if(this._sparklineGroupManager)
                    this._sparklineGroupManager._addColumns(col,count);
                if(this._conditionalFormats)
                    this._conditionalFormats._addColumns(col,count);
                if(sheetSource)
                    sheetSource.onAfterAddColumns(col,count);
                this._syncScrollbarSize();
                this.invalidateLayout()
            })(col,count)
        },
        deleteColumns: function(col, count)
        {
            if(0 > col || col >= this.getColumnCount() || count <= 0)
                return;
            if(this.parent && this.parent.gcSpreadsheet)
                return;
            this._bindToAutoRefresh(function(col, count)
            {
                var sheetSource = this._getSheetSource();
                if(sheetSource)
                    sheetSource.onBeforeAddRemoveColumns(col);
                var m = this._getModel();
                m.deleteColumns(col,count);
                var calc = this._getCalcModel();
                calc.deleteColumns(col,count);
                var SheetArea = UI.SheetArea;
                var cm = this._getModel(SheetArea.colHeader);
                cm.deleteColumns(col,count);
                m.deleteElements(this._colInfos,this.getColumnCount(),col,count);
                var sm = this._getSpanModel(SheetArea.colHeader);
                sm.removeColumns(col,count);
                sm = this._getSpanModel(SheetArea.viewport);
                sm.removeColumns(col,count);
                if(this._rowFilter)
                    this._rowFilter._removeColumns(col,count);
                if(this._allowCellOverflow === true)
                    this._clearCellOverflowModelCache();
                if(this.colRangeGroup)
                    this.colRangeGroup._remove(col,count);
                if(this._sparklineGroupManager)
                    this._sparklineGroupManager._removeColumns(col,count);
                if(this._conditionalFormats)
                    this._conditionalFormats._removeColumns(col,count);
                var left = this._scrollLeftCol;
                if(left >= 0)
                {
                    var newLeft = -1;
                    for(var t = left; t >= this.frozenColCount; t--)
                        if(this.getColumnVisible(t) && this._getZoomColumnWidth(t) > 0)
                        {
                            newLeft = t;
                            break
                        }
                    if(newLeft === -1)
                        newLeft = 0;
                    if(left !== newLeft)
                    {
                        this._trigger(UI.Events.LeftColumnChanged,{
                            sheet: this,
                            sheetName: this._name,
                            oldLeftCol: left,
                            newLeftCol: newLeft
                        });
                        this._scrollLeftCol = newLeft;
                        this._syncHScollbarPosition()
                    }
                }
                if(sheetSource)
                    sheetSource.onAfterRemoveColumns(col,count);
                this._syncScrollbarSize();
                this.invalidateLayout()
            })(col,count)
        },
        setFrozenCount: function(rowCount, colCount)
        {
            if(rowCount === undefined || rowCount === null || rowCount < 0 || isNaN(rowCount))
                rowCount = 0;
            if(colCount === undefined || colCount === null || colCount < 0 || isNaN(colCount))
                colCount = 0;
            this._bindToAutoRefresh(function(rowCount, colCount)
            {
                var invalid = false;
                if(this.frozenRowCount !== rowCount)
                {
                    this._scrollTopRow += rowCount - this.frozenRowCount;
                    this.frozenRowCount = rowCount;
                    invalid = true
                }
                if(this.frozenColCount !== colCount)
                {
                    this._scrollLeftCol += colCount - this.frozenColCount;
                    this.frozenColCount = colCount;
                    invalid = true
                }
                if(invalid)
                {
                    this.invalidateLayout();
                    this._syncScrollbarSize()
                }
            })(rowCount,colCount)
        },
        getRowCount: function(sheetArea)
        {
            var m = this._getModel(sheetArea);
            return m ? m.rowCount : 0
        },
        getColumnCount: function(sheetArea)
        {
            var m = this._getModel(sheetArea);
            return m ? m.colCount : 0
        },
        setRowCount: function(rowCount, sheetArea)
        {
            rowCount = parseInt(rowCount,10);
            if(isNaN(rowCount))
                return;
            if(rowCount < 0)
                return;
            this._bindToAutoRefresh(function(rowCount, sheetArea)
            {
                var SheetArea = UI.SheetArea;
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = SheetArea.viewport;
                if(sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
                {
                    if(this._dataModel.rowCount > rowCount)
                        this.deleteRows(rowCount,this._dataModel.rowCount - rowCount);
                    this._dataModel.rowCount = this._calcDataModel.rowCount = this._rowHeaderModel.rowCount = rowCount;
                    if(this.frozenRowCount > rowCount)
                        this.setFrozenCount(rowCount,this.frozenColCount);
                    if(!this._rowInfos)
                        this._rowInfos = {};
                    if(this.rowRangeGroup)
                        this.rowRangeGroup._setCount(rowCount)
                }
                else if(sheetArea === SheetArea.colHeader)
                {
                    if(!this._colHeaderRowInfos)
                        this._colHeaderRowInfos = {};
                    this._colHeaderModel.rowCount = rowCount
                }
                if(this.rowRangeGroup)
                    this.rowRangeGroup.refresh();
                this._syncScrollbarSize();
                if(this._activeRowIndex >= rowCount && (sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader))
                {
                    this._clearSelectionImp();
                    this._setActiveCellImp(-1,-1,this.activeRowViewportIndex,this.activeColViewportIndex)
                }
            })(rowCount,sheetArea)
        },
        setColumnCount: function(colCount, sheetArea)
        {
            colCount = parseInt(colCount,10);
            if(isNaN(colCount))
                return;
            if(colCount < 0)
                return;
            this._bindToAutoRefresh(function(colCount, sheetArea)
            {
                var SheetArea = UI.SheetArea;
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = SheetArea.viewport;
                if(sheetArea === SheetArea.viewport || sheetArea === SheetArea.colHeader)
                {
                    if(this._dataModel.colCount > colCount)
                        this.deleteColumns(colCount,this._dataModel.colCount - colCount);
                    this._dataModel.colCount = this._calcDataModel.colCount = this._colHeaderModel.colCount = this._colFooterModel.colCount = colCount;
                    if(this.frozenColCount > colCount)
                        this.setFrozenCount(this.frozenRowCount,colCount);
                    if(!this._colInfos)
                        this._colInfos = {};
                    if(this.colRangeGroup)
                        this.colRangeGroup._setCount(colCount)
                }
                else if(sheetArea === SheetArea.rowHeader)
                {
                    if(!this._rowHeaderColInfos)
                        this._rowHeaderColInfos = {};
                    this._rowHeaderModel.colCount = colCount
                }
                if(this.colRangeGroup)
                    this.colRangeGroup.refresh();
                this._syncScrollbarSize();
                if(this._activeColIndex >= colCount && (sheetArea === SheetArea.viewport || sheetArea === SheetArea.colHeader))
                {
                    this._clearSelectionImp();
                    this._setActiveCellImp(-1,-1,this.activeRowViewportIndex,this.activeColViewportIndex)
                }
            })(colCount,sheetArea)
        },
        getText: function(row, col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var v = this.getValue(row,col,sheetArea);
            if(v === undefined || v === null)
                return"";
            else
            {
                var ct = this.getCellType(row,col,sheetArea);
                var style = this.getActualStyle(row,col,sheetArea);
                var fmt = style.formatter ? style.formatter : style._autoFormatter;
                v = ct.format(v,fmt);
                return v
            }
        },
        setText: function(row, col, value, sheetArea)
        {
            this._bindToAutoRefresh(function(row, col, value, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var t = value;
                var ct = this.getCellType(row,col,sheetArea);
                var formatStr = this.getCell(row,col,sheetArea).formatter();
                if(ct && formatStr)
                    t = ct.parse(value,formatStr);
                this.setValue(row,col,t,sheetArea)
            })(row,col,value,sheetArea)
        },
        getValue: function(row, col, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = SheetArea.viewport;
            var m = this._getModel(sheetArea);
            if(!m)
                return null;
            var t = this._getValueImp(m,row,col,sheetArea);
            var HeaderAutoText = UI.HeaderAutoText,
                index;
            var ko = window.ko;
            if(sheetArea === SheetArea.colHeader)
            {
                if(t === undefined || t === null)
                {
                    var ds = this.getDataSource();
                    if(this._isDataView(ds) || ds && ds.length > 0 || ko && ko.isObservable(ds))
                    {
                        var ci = this._colInfos[col];
                        if(ci && (this.colHeaderAutoTextIndex >= 0 && row === this.colHeaderAutoTextIndex || this.colHeaderAutoTextIndex === -1 && row === m.rowCount - 1))
                            t = ci.displayName || ci.name
                    }
                    if(t === undefined || t === null)
                    {
                        index = this.colHeaderAutoTextIndex;
                        if(index < 0 || index >= m.rowCount)
                            index = m.rowCount - 1;
                        if(row === index)
                            if(this.colHeaderAutoText === HeaderAutoText.letters)
                                t = this._indexToLetters(col + 1);
                            else if(this.colHeaderAutoText === HeaderAutoText.numbers)
                                t = col + 1
                    }
                }
            }
            else if(sheetArea === SheetArea.rowHeader)
                if(t === undefined || t === null)
                {
                    index = this.rowHeaderAutoTextIndex;
                    if(index < 0 || index >= m.colCount)
                        index = m.colCount - 1;
                    if(col === index)
                        if(this.rowHeaderAutoText === HeaderAutoText.letters)
                            t = this._indexToLetters(row + 1);
                        else if(this.rowHeaderAutoText === HeaderAutoText.numbers)
                            t = row + 1
                }
            return t
        },
        setValue: function(row, col, value, sheetArea, ignoreRecalc)
        {
            this._bindToAutoRefresh(function(row, col, value, sheetArea, ignoreRecalc)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var m = this._getModel(sheetArea);
                if(!m)
                    return;
                var rowCount = m.rowCount;
                var colCount = m.colCount;
                if(row < 0 || row >= rowCount || col < 0 || col >= colCount)
                    return;
                if(value !== undefined && value !== null && value.constructor === Date)
                    value = "/Date(" + value.getTime() + ")/";
                var oldValue = this._getValueImp(m,row,col,sheetArea);
                var ko = window.ko;
                if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
                {
                    var valueSet = false;
                    if(this._dataSource)
                        if(this._isDataView(this._dataSource))
                        {
                            var dataLength = this._dataSource.count();
                            if(row < dataLength)
                            {
                                var drow = this._dataSource.item(row);
                                if(drow)
                                {
                                    var ci = this._colInfos[col];
                                    if(ci && ci.name && ci.name.length > 0)
                                    {
                                        this._dataSource.setProperty(drow,ci.name,value);
                                        valueSet = true
                                    }
                                }
                            }
                        }
                        else if(ko && ko.isObservable(this._dataSource))
                        {
                            var dataLength = this._dataSource().length;
                            if(row < dataLength)
                            {
                                var drow = this._dataSource()[row];
                                if(drow)
                                {
                                    var ci = this._colInfos[col];
                                    if(ci && ci.name && ci.name.length > 0)
                                    {
                                        if(typeof ci.value === const_function)
                                            ci.value(drow,value);
                                        else if(typeof ko !== const_undefined && ko.isWriteableObservable(drow[ci.name]))
                                            drow[ci.name](value);
                                        else
                                            drow[ci.name] = value;
                                        valueSet = true
                                    }
                                }
                            }
                        }
                        else if(this._isCellBinding(this._dataSource))
                        {
                            var path = this.getBindingPath(row,col,sheetArea);
                            if(path)
                            {
                                this._dataSource.setValue(path,value);
                                valueSet = true
                            }
                        }
                        else
                        {
                            var dataLength = this._dataSource.length;
                            if(row < dataLength)
                            {
                                var drow = this._dataSource[row];
                                if(drow)
                                {
                                    var ci = this._colInfos[col];
                                    if(ci && ci.name && ci.name.length > 0)
                                    {
                                        if(typeof ci.value === const_function)
                                            ci.value(drow,value);
                                        else if(typeof ko !== const_undefined && ko.isWriteableObservable(drow[ci.name]))
                                            drow[ci.name](value);
                                        else
                                            drow[ci.name] = value;
                                        valueSet = true
                                    }
                                }
                            }
                        }
                    if(!valueSet || this.checkingChanges)
                    {
                        m.setValue(row,col,value);
                        this._activeRowDirty = true
                    }
                }
                else
                    m.setValue(row,col,value);
                if((sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport) && !ignoreRecalc)
                    this._recalcCell(m,row,col);
                if(this._allowCellOverflow)
                    this._clearCellOverflowModelCachebyRow(row,sheetArea);
                if(this._conditionalFormats)
                    this._conditionalFormats._clearCache();
                if(oldValue !== value)
                    this._trigger(UI.Events.CellChanged,{
                        sheet: this,
                        sheetName: this._name,
                        row: row,
                        col: col,
                        sheetArea: sheetArea,
                        propertyName: _value,
                        _oldValue: oldValue
                    })
            })(row,col,value,sheetArea,ignoreRecalc)
        },
        sortRange: function(row, column, rowCount, columnCount, byRows, sortInfo)
        {
            return this._bindToAutoRefresh(function(row, column, rowCount, columnCount, byRows, sortInfo)
                {
                    var oldState = this.isPaintSuspended();
                    this.isPaintSuspended(true);
                    try
                    {
                        var spans = this.getSpans(new UI.Range(row,column,rowCount,columnCount));
                        if(spans && spans.length > 0)
                            return false;
                        var rowcnt = this.getRowCount();
                        var colcnt = this.getColumnCount();
                        var ncol,
                            nrow,
                            modelrow,
                            modelcol,
                            modelrow2,
                            modelcol2;
                        var array,
                            data1,
                            data2;
                        if(row === -1)
                            row = 0;
                        if(rowCount === -1)
                            rowCount = rowcnt;
                        if(column === -1)
                            column = 0;
                        if(columnCount === -1)
                            columnCount = colcnt;
                        if(row < 0 || row >= rowcnt || column < 0 || column >= colcnt || rowCount < 0 || row + rowCount > rowcnt || columnCount < 0 || column + columnCount > colcnt || !sortInfo)
                            return false;
                        array = this._quickSort(row,column,rowCount,columnCount,byRows,sortInfo);
                        if(array)
                        {
                            var model = this._getModel(),
                                calcModel = this._getCalcModel(),
                                source = this._getSheetSource(),
                                viewIndex,
                                expr,
                                cellCalc;
                            if(byRows)
                                for(nrow = row; nrow < row + rowCount; nrow++)
                                {
                                    viewIndex = this._getSwapIndex(array,row,nrow,rowCount,true);
                                    if(nrow === viewIndex)
                                        continue;
                                    modelrow = nrow;
                                    modelrow2 = viewIndex;
                                    for(ncol = column; ncol < column + columnCount; ncol++)
                                    {
                                        modelcol = ncol;
                                        data1 = this.getValue(modelrow,modelcol);
                                        data2 = this.getValue(modelrow2,modelcol);
                                        var cell1Calc = source._getCellCalc(modelrow,modelcol,false);
                                        if(cell1Calc && cell1Calc.hasListeners())
                                            cell1Calc.addListenersToAdjust();
                                        var cell2Calc = source._getCellCalc(modelrow2,modelcol,false);
                                        if(cell2Calc && cell2Calc.hasListeners())
                                            cell2Calc.addListenersToAdjust();
                                        calcModel.swapNode(modelrow,modelcol,modelrow2,modelcol);
                                        expr = staticMembers._copyExpression(calcModel.getFormula(modelrow,modelcol),modelrow,modelcol);
                                        calcModel.setFormula(modelrow,modelcol,expr);
                                        cellCalc = source._getCellCalc(modelrow,modelcol,!!expr);
                                        if(cellCalc)
                                            cellCalc.startListening();
                                        expr = staticMembers._copyExpression(calcModel.getFormula(modelrow2,modelcol),modelrow2,modelcol);
                                        calcModel.setFormula(modelrow2,modelcol,expr);
                                        cellCalc = source._getCellCalc(modelrow2,modelcol,!!expr);
                                        if(cellCalc)
                                            cellCalc.startListening();
                                        source._controller.adjustFormulasOnSwap(calcModel,modelrow,modelcol,calcModel,modelrow2,modelcol,1,1);
                                        model.swapNode(modelrow,modelcol,modelrow2,modelcol);
                                        this.setValue(modelrow,modelcol,data2);
                                        this.setValue(modelrow2,modelcol,data1)
                                    }
                                }
                            else
                                for(ncol = column; ncol < column + columnCount; ncol++)
                                {
                                    viewIndex = this._getSwapIndex(array,column,ncol,columnCount,false);
                                    if(ncol === viewIndex)
                                        continue;
                                    modelcol = ncol;
                                    modelcol2 = viewIndex;
                                    for(nrow = row; nrow < row + rowCount; nrow++)
                                    {
                                        modelrow = nrow;
                                        data1 = this.getValue(modelrow,modelcol);
                                        data2 = this.getValue(modelrow,modelcol2);
                                        var cell1Calc = source._getCellCalc(modelrow,modelcol,false);
                                        if(cell1Calc && cell1Calc.hasListeners())
                                            cell1Calc.addListenersToAdjust();
                                        var cell2Calc = source._getCellCalc(modelrow,modelcol2,false);
                                        if(cell2Calc && cell2Calc.hasListeners())
                                            cell2Calc.addListenersToAdjust();
                                        calcModel.swapNode(modelrow,modelcol,modelrow,modelcol2);
                                        expr = staticMembers._copyExpression(calcModel.getFormula(modelrow,modelcol),modelrow,modelcol);
                                        calcModel.setFormula(modelrow,modelcol,expr);
                                        cellCalc = source._getCellCalc(modelrow,modelcol,!!expr);
                                        if(cellCalc)
                                            cellCalc.startListening();
                                        expr = staticMembers._copyExpression(calcModel.getFormula(modelrow,modelcol2),modelrow,modelcol2);
                                        calcModel.setFormula(modelrow,modelcol2,expr);
                                        cellCalc = source._getCellCalc(modelrow,modelcol2,!!expr);
                                        if(cellCalc)
                                            cellCalc.startListening();
                                        source._controller.adjustFormulasOnSwap(calcModel,modelrow,modelcol,calcModel,modelrow,modelcol2,1,1);
                                        model.swapNode(modelrow,modelcol,modelrow,modelcol2);
                                        this.setValue(modelrow,modelcol,data2);
                                        this.setValue(modelrow,modelcol2,data1)
                                    }
                                }
                            return true
                        }
                        return false
                    }
                    finally
                    {
                        this.resumeCalcService();
                        this.resumeEvent();
                        for(var r = 0; r < rowCount; r++)
                            for(var c = 0; c < columnCount; c++)
                                this._raiseCellChanged(_value,row + r,column + c,UI.SheetArea.viewport);
                        this._raisePropertyChanged("[sort]");
                        this.isPaintSuspended(oldState)
                    }
                })(row,column,rowCount,columnCount,byRows,sortInfo)
        },
        getActualStyle: function(row, column, sheetArea, sheetOnly)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var info = new UI.Style,
                composedStyle = this.getCompositeStyle(row,column,sheetArea);
            if(sheetArea === UI.SheetArea.viewport)
                if(!sheetOnly)
                {
                    var f = composedStyle.formatter;
                    if(f && f.HasFormatedColor && f.HasFormatedColor())
                    {
                        var clr = {};
                        f.Format(this.getValue(row,column),clr);
                        if(clr.value)
                            info.foreColor = clr.value
                    }
                    var conditionalFormats = this._conditionalFormats;
                    if(conditionalFormats && conditionalFormats.count() > 0)
                    {
                        var rules = conditionalFormats.getRules(row,column);
                        for(var n = 0; n < rules.length; n++)
                        {
                            var rule = rules[rules.length - 1 - n];
                            if(rule)
                                if(rule.isScaleRule())
                                {
                                    if(!(rule instanceof UI.DataBarRule || rule instanceof UI.IconSetRule))
                                    {
                                        var color = rule.evaluate(this,row,column,this.getValue(row,column,sheetArea));
                                        if(color)
                                            info.backColor = color
                                    }
                                }
                                else
                                {
                                    var expected = rule.evaluate(this,row,column,this.getValue(row,column,sheetArea));
                                    if(expected !== null && expected !== undefined)
                                        info.compose(expected)
                                }
                        }
                    }
                }
            info.compose(composedStyle);
            if(info.locked === undefined || info.locked === null)
                info.locked = true;
            return info._normalize(new UI._ThemeContext(this))
        },
        getStyle: function(row, col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var m = this._getModel(sheetArea);
            if(m)
                return m.getStyle(row,col);
            return null
        },
        setStyle: function(row, col, value, sheetArea)
        {
            this._bindToAutoRefresh(function(row, col, value, sheetArea)
            {
                var SheetArea = UI.SheetArea;
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = SheetArea.viewport;
                var m = this._getModel(sheetArea);
                if(m)
                {
                    m.setStyle(row,col,value);
                    if(value && value.formatter)
                    {
                        var formatter = value.formatter;
                        if(typeof formatter === const_string)
                            formatter = new UI.GeneralFormatter(formatter);
                        if(formatter && typeof formatter.Init === const_function)
                            formatter.Init()
                    }
                    var E = UI.Events;
                    var pn = "[styleinfo]";
                    if(row !== -1 && col !== -1)
                        this._trigger(E.CellChanged,{
                            sheet: this,
                            sheetName: this._name,
                            row: row,
                            col: col,
                            sheetArea: sheetArea,
                            propertyName: pn
                        });
                    else if(row !== -1 && col === -1)
                        this._trigger(E.RowChanged,{
                            sheet: this,
                            sheetName: this._name,
                            row: row,
                            sheetArea: sheetArea,
                            propertyName: pn
                        });
                    else if(row === -1 && col !== -1)
                        this._trigger(E.ColumnChanged,{
                            sheet: this,
                            sheetName: this._name,
                            col: col,
                            sheetArea: sheetArea,
                            propertyName: pn
                        })
                }
                if(this._allowCellOverflow)
                    if(sheetArea === SheetArea.colHeader || row === -1)
                        this._clearCellOverflowModelCache();
                    else if(sheetArea === SheetArea.viewport || col === -1)
                        this._clearCellOverflowModelCachebyRow(row,sheetArea)
            })(row,col,value,sheetArea)
        },
        getDefaultStyle: function(sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = SheetArea.viewport;
            var m = this._getModel(sheetArea);
            if(m)
            {
                var sheetDefStyle = m.getStyle(-1,-1);
                var defStyle = new UI.Style;
                if(sheetArea === SheetArea.colHeader || sheetArea === SheetArea.rowHeader)
                {
                    defStyle.foreColor = "black";
                    defStyle.hAlign = UI.HorizontalAlign.center;
                    defStyle.vAlign = UI.VerticalAlign.center
                }
                else
                {
                    defStyle.foreColor = "black";
                    defStyle.hAlign = UI.HorizontalAlign.general;
                    defStyle.vAlign = UI.VerticalAlign.top
                }
                if(sheetDefStyle)
                {
                    sheetDefStyle.compose(defStyle);
                    return sheetDefStyle
                }
                else
                {
                    m.setStyle(-1,-1,defStyle);
                    return defStyle
                }
            }
            return null
        },
        setDefaultStyle: function(style, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var m = this._getModel(sheetArea);
            if(m)
                m.setStyle(-1,-1,style)
        },
        getCompositeStyle: function(row, column, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var destInfo = new UI.Style;
            var m = this._getModel(sheetArea);
            if(m)
            {
                var rowCount = m.rowCount,
                    colCount = m.colCount,
                    tmp;
                if(0 <= row && row < rowCount && 0 <= column && column < colCount)
                {
                    var s = m.getStyle(row,column);
                    if(s)
                        destInfo.compose(s)
                }
                if(0 <= row && row < rowCount)
                {
                    tmp = m.getStyle(row,-1);
                    if(tmp)
                        destInfo.compose(tmp)
                }
                if(0 <= column && column < colCount)
                {
                    tmp = m.getStyle(-1,column);
                    if(tmp)
                        destInfo.compose(tmp)
                }
            }
            var sheetInfo = this.getDefaultStyle(sheetArea);
            if(sheetInfo)
                destInfo.compose(sheetInfo);
            return destInfo
        },
        getCellType: function(row, col, sheetArea)
        {
            var style = this.getActualStyle(row,col,sheetArea);
            if(style && style.cellType)
                return style.cellType;
            else
            {
                if(!this._defaultCellType)
                    this._defaultCellType = new UI.TextCellType;
                if(sheetArea === UI.SheetArea.corner)
                    return new UI.CornerCellType;
                else if(sheetArea === UI.SheetArea.colHeader)
                    return new UI.ColumnHeaderCellType;
                else if(sheetArea === UI.SheetArea.rowHeader)
                    return new UI.RowHeaderCellType;
                else
                    return this._defaultCellType
            }
        },
        setCellType: function(row, col, value, sheetArea)
        {
            var style = this.getStyle(row,col,sheetArea);
            if(!style)
                style = new UI.Style;
            style.cellType = value;
            this.setStyle(row,col,style,sheetArea)
        },
        getFormatter: function(row, col, sheetArea)
        {
            var style = this.getActualStyle(row,col,sheetArea);
            return style ? style.formatter : undefined
        },
        setFormatter: function(row, col, value, sheetArea)
        {
            var style = this.getStyle(row,col,sheetArea);
            if(!style)
                style = new UI.Style;
            style.formatter = value;
            this.setStyle(row,col,style,sheetArea)
        },
        getDataValidator: function(row, col, sheetArea)
        {
            var style = this.getActualStyle(row,col,sheetArea);
            return style ? style.validator : undefined
        },
        setDataValidator: function(row, col, value, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var style = this.getStyle(row,col,sheetArea);
            if(!style)
                style = new UI.Style;
            style.validator = value;
            this.setStyle(row,col,style,sheetArea);
            if(value)
            {
                if(value.condition instanceof UI.FormulaCondition && (value.condition._baseRow === undefined || value.condition._baseRow === null))
                    value.condition._baseRow = row !== -1 ? row : 0;
                if(value.condition instanceof UI.FormulaCondition && (value.condition._baseCol === undefined || value.condition._baseCol === null))
                    value.condition._baseCol = col !== -1 ? col : 0
            }
            var E = UI.Events,
                pn = "validator";
            this._trigger(E.CellChanged,{
                sheet: this,
                sheetName: this._name,
                row: row,
                col: col,
                sheetArea: sheetArea,
                propertyName: pn
            });
            if(row !== -1 && col === -1)
                this._trigger(E.RowChanged,{
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    sheetArea: sheetArea,
                    propertyName: pn
                });
            else if(row === -1 && col !== -1)
                this._trigger(E.ColumnChanged,{
                    sheet: this,
                    sheetName: this._name,
                    col: col,
                    sheetArea: sheetArea,
                    propertyName: pn
                })
        },
        isValid: function(row, column, value)
        {
            try
            {
                this._validatingRow = row;
                this._validatingColumn = column;
                this._validatingValue = value;
                this._isValidatingCell = true;
                var dv = this.getDataValidator(row,column);
                if(dv)
                    return dv.isValid(this,row,column,value)
            }
            finally
            {
                this._validatingRow = -1;
                this._validatingColumn = -1;
                this._validatingValue = null;
                this._isValidatingCell = false
            }
            return true
        },
        addSelection: function(row, column, rowCount, columnCount)
        {
            this._bindToAutoRefresh(function(row, column, rowCount, columnCount)
            {
                var r = row;
                var c = column;
                var rc = rowCount;
                var cc = columnCount;
                if(r !== -1 && c !== -1)
                {
                    var spans = this._getSpanModel().slice(0);
                    if(spans && spans.length > 0)
                    {
                        var newSelection = this._cellRangeInflate(spans,new UI.Range(row,column,rowCount,columnCount));
                        r = newSelection.row;
                        c = newSelection.col;
                        rc = newSelection.rowCount;
                        cc = newSelection.colCount
                    }
                }
                this._selectionModel.add(r,c,rc,cc)
            })(row,column,rowCount,columnCount)
        },
        getSelections: function()
        {
            return this._selectionModel
        },
        _addSpanImp: function(row, col, rowCount, colCount, sheetArea)
        {
            this._bindToAutoRefresh(function(row, col, rowCount, colCount, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var sm = this._getSpanModel(sheetArea);
                sm.clear(row,col,rowCount,colCount);
                var r = new UI.Range(row,col,rowCount,colCount);
                var newRange = this._getActualRange(r,sheetArea);
                sm.push(newRange);
                if(this._allowCellOverflow)
                    for(r = row; r < row + rowCount; r++)
                        this._clearCellOverflowModelCachebyRow(r,sheetArea);
                var selections = this.getSelections();
                for(var i = 0; i < selections.length; i++)
                    if(selections[i].intersect(row,col,rowCount,colCount))
                        selections[i] = selections[i].union(r)
            })(row,col,rowCount,colCount,sheetArea)
        },
        addSpan: function(row, col, rowCount, colCount, sheetArea)
        {
            if(rowCount === 1 && colCount === 1)
                return;
            if(sheetArea === UI.SheetArea.corner)
                return;
            var sm = this._getSpanModel(sheetArea);
            var enumrator = sm.getEnumerator(row,col,rowCount,colCount);
            var canSpan = true;
            while(enumrator.moveNext())
            {
                var range = enumrator.current();
                var selectionRange = new UI.Range(row,col,rowCount,colCount);
                if(!selectionRange.containsRange(range))
                {
                    canSpan = false;
                    break
                }
            }
            if(!canSpan)
                throw new Error("Invalid range");
            this._addSpanImp(row,col,rowCount,colCount,sheetArea)
        },
        removeSpan: function(row, col, sheetArea)
        {
            this._bindToAutoRefresh(function(row, col, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var sm = this._getSpanModel(sheetArea);
                for(var i = 0; i < sm.length; i++)
                {
                    var rg = sm[i];
                    if(rg.row === row && rg.col === col)
                    {
                        sm.splice(i,1);
                        if(this._allowCellOverflow)
                            for(var r = rg.row; r < rg.row + rg.rowCount; r++)
                                this._clearCellOverflowModelCachebyRow(r,sheetArea);
                        return
                    }
                }
            })(row,col,sheetArea)
        },
        repaint: function(clipRect)
        {
            if(!this._paintSuspended)
                this._render.repaint(clipRect)
        },
        startEdit: function(selectAll, defaultText)
        {
            this._startEditImp(this._getCanvas(),this._activeRowIndex,this._activeColIndex,null,null,selectAll,defaultText)
        },
        editorStatus: function()
        {
            return this._editorStatus ? this._editorStatus : UI.EditorStatus.Ready
        },
        isEditing: function()
        {
            return this._editorStatus === UI.EditorStatus.Enter || this._editorStatus === UI.EditorStatus.Edit
        },
        doKeyDown: function(event)
        {
            this._eventHandler.doKeyDown(event)
        },
        doKeyUp: function(event)
        {
            this._eventHandler.doKeyUp(event)
        },
        removeKeyMap: function(keyCode, ctrl, shift, alt, action)
        {
            if(!this.keyMap)
                return;
            for(var i = 0; i < this.keyMap.length; i++)
            {
                var ka = this.keyMap[i];
                if(ka && ka.key === keyCode && ka.ctrl === ctrl && ka.shift === shift && ka.alt === alt)
                {
                    this.keyMap.splice(i,1);
                    break
                }
            }
        },
        addKeyMap: function(keyCode, ctrl, shift, alt, action)
        {
            if(!this.keyMap)
                this.keyMap = [];
            var ka = this._getKeyAction(keyCode,ctrl,shift,alt);
            if(ka)
                ka.action = action;
            else
                this.keyMap.push(new UI.KeyMap(keyCode,ctrl,shift,alt,action))
        },
        moveActiveCell: function(dir, wrap, beginRow, beginCol, repaint, scrolled)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: this._activeRowIndex,
                    col: this._activeColIndex,
                    cancel: false
                };
            this._trigger(UI.Events.LeaveCell,args);
            if(args && args.cancel === true)
                return false;
            if(!this.endEdit())
                return false;
            if(this._activeRowDirty)
            {
                this.updateRecord();
                this._activeRowDirty = false
            }
            var prevRowIndex = this._activeRowIndex;
            var prevcolIndex = this._activeColIndex;
            if(beginRow === undefined || beginRow === null)
                beginRow = this._activeRowIndex;
            if(beginCol === undefined || beginCol === null)
                beginCol = this._activeColIndex;
            var Dir = UI.Direction;
            if(dir === Dir.left)
                this._moveActiveCellLeft(beginRow,beginCol,wrap,false,false);
            else if(dir === Dir.right)
                this._moveActiveCellRight(beginRow,beginCol,wrap,false,false);
            else if(dir === Dir.up)
                this._moveActiveCellUp(beginRow,beginCol,wrap,false,false);
            else if(dir === Dir.down)
                this._moveActiveCellDown(beginRow,beginCol,wrap,false,false);
            repaint = this.moveActiveCellEnd(dir,prevRowIndex,prevcolIndex,repaint,scrolled);
            return repaint
        },
        _moveActiveCellInSelection: function(dir)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: this._activeRowIndex,
                    col: this._activeColIndex,
                    cancel: false
                };
            this._trigger(UI.Events.LeaveCell,args);
            if(args && args.cancel === true)
                return;
            this.endEdit();
            if(this._activeRowDirty)
            {
                this.updateRecord();
                this._activeRowDirty = false
            }
            var prevRowIndex = this._activeRowIndex;
            var prevcolIndex = this._activeColIndex;
            if(dir === UI.Direction.left)
                this._moveActiveCellLeftInSelection(this._activeRowIndex,this._activeColIndex);
            else if(dir === UI.Direction.right)
                this._moveActiveCellRightInSelection(this._activeRowIndex,this._activeColIndex);
            this.moveActiveCellEnd(dir,prevRowIndex,prevcolIndex)
        },
        subscriptionHandlers: [],
        doDataItemChanged: function()
        {
            var self = this;
            this.activeDataItemChangedhandler = function(context)
            {
                self.repaint()
            };
            var dataItems = this.getDataSource();
            if(dataItems && typeof window.ko !== const_undefined)
            {
                while(this.subscriptionHandlers.length > 0)
                {
                    var s = this.subscriptionHandlers.pop();
                    if(typeof s.dispose === const_function)
                        s.dispose()
                }
                var item = null;
                if(this._isDataView(dataItems))
                {
                    if(dataItems.currentPosition)
                        dataItems.currentPosition(this._activeRowIndex);
                    item = dataItems.currentItem()
                }
                else if(this._isCellBinding(dataItems));
                else
                    item = dataItems[this._activeRowIndex];
                if(item)
                    for(var x in item)
                        if(item[x] && typeof item[x].subscribe === const_function)
                            this.subscriptionHandlers.push(item[x].subscribe(this.activeDataItemChangedhandler,null,null))
            }
        },
        moveActiveCellEnd: function(dir, prevRowIndex, prevcolIndex, repaint, scrolled)
        {
            var oldSelections = this._selectionModel.toArray();
            if(!this.shift && !this._isNavigateInSelection)
            {
                var activeSelectedRange = this._fixRange(this._getActiveSelectedRange());
                if(this._selectionModel.length > 1 || activeSelectedRange.rowCount > 1 || activeSelectedRange.colCount > 1)
                    repaint = true;
                this._clearSelectionImp()
            }
            var span = this._spanModel.find(this._activeRowIndex,this._activeColIndex);
            if(span)
            {
                this._activeRowCount = span.rowCount;
                this._activeColCount = span.colCount
            }
            else
            {
                this._activeRowCount = 1;
                this._activeColCount = 1
            }
            if(!this._isNavigateInSelection)
            {
                var activeRange = this._getExtendedRange(this._activeRowIndex,this._activeColIndex);
                var selectionPolicy = this.selectionPolicy(),
                    selectionUnit = this.selectionUnit();
                if(selectionPolicy === UI.SelectionPolicy.Single)
                    this._selectionModel.clear();
                else if(selectionPolicy === UI.SelectionPolicy.Range)
                    this._selectionModel.clear();
                if(selectionUnit === UI.SelectionUnit.Row)
                {
                    activeRange.col = -1;
                    activeRange.colCount = -1
                }
                else if(selectionUnit === UI.SelectionUnit.Column)
                {
                    activeRange.row = -1;
                    activeRange.rowCount = -1
                }
                this._replaceActiveSelectedRange(activeRange.row,activeRange.col,activeRange.rowCount,activeRange.colCount,false);
                var newSelections = this._selectionModel.toArray();
                if(this._eventHandler._notEqualSelecions(oldSelections,newSelections))
                {
                    var E = UI.Events;
                    this._trigger(E.SelectionChanging,{
                        sheet: this,
                        sheetName: this._name,
                        oldSelections: oldSelections,
                        newSelections: newSelections
                    });
                    this._trigger(E.SelectionChanged,{
                        sheet: this,
                        sheetName: this._name
                    })
                }
            }
            var firstCol = this.frozenColCount ? this._getNextVisualColumn(this.frozenColCount - 1) : this._getFirstVisualColumn();
            var firstRow1 = this.frozenRowCount ? this._getNextVisualRow(this.frozenRowCount - 1) : this._getFirstVisualRow();
            if(this._activeColIndex < this._scrollLeftCol && this._activeColIndex >= firstCol)
                scrolled = this._setLeftColumn(this._getPrevVisualColumn(this._activeColIndex + 1)) || scrolled;
            if(this._activeColIndex > this._getLastFullyVisibleColumn() && this._activeColIndex <= this._getLastVisualColumn())
            {
                var cls = this._getColumnLayout(1);
                if(!cls || cls.length <= 0)
                    return false;
                var w = 0;
                var c = this._activeColIndex;
                var sheetLayout1 = this._getSheetLayout();
                while(c > this._scrollLeftCol)
                {
                    w += this._getZoomColumnWidth(c);
                    if(w > sheetLayout1.viewportWidth)
                        break;
                    c--
                }
                var newLeftCol = this._getNextVisualColumn(c);
                scrolled = this._setLeftColumn(newLeftCol) || scrolled
            }
            if(this._activeRowIndex < this._scrollTopRow && this._activeRowIndex >= firstRow1)
                scrolled = this._setTopRow(this._getPrevVisualRow(this._activeRowIndex + 1)) || scrolled;
            if(this._activeRowIndex > this._getLastFullyVisibleRow() && this._activeRowIndex <= this._getLastVisualRow())
            {
                var rls = this._getRowLayout(1);
                if(!rls || rls.length <= 0)
                    return false;
                var firstRow2 = this.frozenRowCount ? this._getNextVisualRow(this.frozenRowCount - 1) : this._getFirstVisualRow();
                var h = 0;
                var r = this._activeRowIndex;
                var sheetLayout = this._getSheetLayout();
                while(r > this._scrollTopRow)
                {
                    h += this._getZoomRowHeight(r);
                    if(h > sheetLayout.viewportHeight)
                        break;
                    r--
                }
                var newTopRow = this._getNextVisualRow(r);
                scrolled = this._setTopRow(newTopRow) || scrolled
            }
            if(this._activeRowIndex === this._getLastVisualRow())
                scrolled = this._setTopRow(this._getLastPageTopRow()) || scrolled;
            if(this._activeColIndex === this._getLastVisualColumn())
                scrolled = this._setLeftColumn(this._getLastPageLeftColumn()) || scrolled;
            if(prevRowIndex != this._activeRowIndex)
                this.doDataItemChanged();
            if(repaint && !scrolled)
            {
                this.invalidateLayout();
                this.repaint();
                repaint = true
            }
            else if(!repaint && !scrolled)
            {
                var rs,
                    cs;
                var prevSpan = this._spanModel.find(prevRowIndex,prevcolIndex);
                if(prevSpan)
                {
                    rs = prevSpan.rowCount;
                    cs = prevSpan.colCount
                }
                else
                {
                    rs = 1;
                    cs = 1
                }
                this._render.repaintSelection(new UI.Range(prevRowIndex,prevcolIndex,rs,cs));
                this._render.repaintSelection(new UI.Range(this._activeRowIndex,this._activeColIndex,this._activeRowCount,this._activeColCount))
            }
            var handler = this._eventHandler;
            var bLoadData = handler.oldTop !== this._scrollTopRow;
            handler.oldTop = this._scrollTopRow;
            handler.oldLeft = this._scrollLeftCol;
            if(bLoadData)
            {
                var topRow = this.getViewportTopRow(1);
                var bottomRow = this.getViewportBottomRow(1);
                var start = Math.max(0,topRow - 60);
                if(start < this.getRowCount())
                    handler._loadData(start,2 * bottomRow - topRow)
            }
            this._trigger(UI.Events.EnterCell,{
                sheet: this,
                sheetName: this._name,
                row: this._activeRowIndex,
                col: this._activeColIndex
            });
            handler._updateValidationUI(this._activeRowIndex,this._activeColIndex);
            return repaint || scrolled
        },
        endEdit: function(ignoreValueChange)
        {
            var editor = this._editor;
            var action;
            if(editor && editor.parentNode)
            {
                var ct = this.getCellType(this._activeRowIndex,this._activeColIndex);
                var v = ct.getEditorValue(editor);
                var args = {
                        sheet: this,
                        sheetName: this._name,
                        row: this._activeRowIndex,
                        col: this._activeColIndex,
                        editingText: v,
                        cancel: false
                    };
                this._trigger(UI.Events.EditEnd,args);
                if(args && args.cancel === true)
                    return;
                if(this._activeRowIndex >= 0 && this._activeColIndex >= 0 && !ignoreValueChange)
                {
                    var oldValue = editor._oldValue;
                    if(ct.isEditingValueChanged(oldValue,v))
                    {
                        var cellEditInfo = {
                                row: this._activeRowIndex,
                                col: this._activeColIndex,
                                newValue: v,
                                autoFormat: true
                            };
                        action = new UI.UndoRedo.CellEditUndoAction(this,cellEditInfo);
                        this._doCommand(action);
                        var needRetry = action.applyResult === UI.DataValidationResult.Retry;
                        if(needRetry === true)
                        {
                            ct.focus(editor);
                            return false
                        }
                    }
                }
                this._dirty = true;
                ct.deactivateEditor(editor)
            }
            this._eventHandler._setFocus();
            this._editingTimeValue = false;
            if(this._editorStatus !== UI.EditorStatus.Ready)
            {
                var oldStatus = this._editorStatus;
                this._editorStatus = UI.EditorStatus.Ready;
                this._trigger(UI.Events.EditorStatusChanged,{
                    sheet: this,
                    sheetName: this._name,
                    oldStatus: oldStatus,
                    newStatus: UI.EditorStatus.Ready
                })
            }
            this._editor = null;
            if(action && action.applyResult === UI.DataValidationResult.Discard)
                return false;
            return true
        },
        hitTest: function(x, y, forMove)
        {
            this._getSheetLayout();
            var target = {
                    x: x,
                    y: y,
                    rowViewportIndex: null,
                    colViewportIndex: null,
                    row: -1,
                    col: -1,
                    resizeInfo: null,
                    hitTestType: null,
                    groupHitInfo: null,
                    filterButtonHitInfo: null,
                    dragInfo: null,
                    cellTypeHitInfo: null
                };
            var hitInfo = this._render.groupHitTest(x,y);
            if(hitInfo)
                target.groupHitInfo = hitInfo;
            else
            {
                target.rowViewportIndex = this._getRowPane(y);
                target.colViewportIndex = this._getColumnPane(x);
                target.row = this._getRowIndex(y,target.rowViewportIndex);
                target.col = this._getColumnIndex(x,target.colViewportIndex);
                if(target.rowViewportIndex >= 0 && target.rowViewportIndex < 2 && target.colViewportIndex >= 0)
                {
                    var cellLayout = this._getCellLayout(target.rowViewportIndex,target.colViewportIndex).findCell(target.row,target.col);
                    if(cellLayout)
                        if(forMove !== true)
                        {
                            target.row = cellLayout.row;
                            target.col = cellLayout.col
                        }
                }
                target.hitTestType = this._getSheetAreaFromHitTest(target);
                target.resizeInfo = this._eventHandler.getResizingRowCol(target,x,y);
                if(!target.resizeInfo)
                {
                    target.dragInfo = this._eventHandler.getDragInfo(target,x,y);
                    if(!target.dragInfo)
                    {
                        target.filterButtonHitInfo = this._getFilterButtonHitInfo(target,x,y);
                        if(!target.filterButtonHitInfo)
                            target.cellTypeHitInfo = this._getCellTypeHitInfo(target,x,y)
                    }
                }
            }
            return target
        },
        getCellRect: function(row, col, rowViewportIndex, colViewportIndex)
        {
            var SheetArea = UI.SheetArea;
            var sheetArea = SheetArea.viewport;
            if(rowViewportIndex === -1)
                sheetArea = SheetArea.colHeader;
            else if(colViewportIndex === -1)
                sheetArea = SheetArea.rowHeader;
            else if(rowViewportIndex === 2)
                sheetArea = SheetArea.colFooter;
            var Rect = UI.Rect;
            var sheetLayout = this._getSheetLayout();
            if(rowViewportIndex === -1 && colViewportIndex === -1)
                return new Rect(sheetLayout.headerX,sheetLayout.headerY,sheetLayout.rowHeaderWidth,sheetLayout.colHeaderHeight);
            var bounds = this._bounds;
            if(rowViewportIndex === undefined || rowViewportIndex === null)
                rowViewportIndex = row < this.frozenRowCount ? 0 : 1;
            if(colViewportIndex === undefined || colViewportIndex === null)
                colViewportIndex = col < this.frozenColCount ? 0 : 1;
            var rowLayout = this._getRowLayout(rowViewportIndex,sheetArea).findRow(row);
            var colLayout = this._getColumnLayout(colViewportIndex,sheetArea).findCol(col);
            var cellLayout = this._getCellLayout(rowViewportIndex,colViewportIndex,sheetArea).findCell(row,col);
            if(cellLayout)
                return new Rect(cellLayout.x - bounds.x,cellLayout.y - bounds.y,cellLayout.width,cellLayout.height);
            if(rowLayout && colLayout)
                return new Rect(colLayout.x - bounds.x,rowLayout.y - bounds.y,colLayout.width,rowLayout.height);
            else
                return new Rect
        },
        _setActiveCellImp: function(row, col, rowViewportIndex, colViewportIndex)
        {
            if(this._activeRowIndex !== row)
                if(this._activeRowDirty)
                {
                    this.updateRecord();
                    this._activeRowDirty = false
                }
            var span = this._spanModel.find(row,col);
            if(span)
            {
                this._activeRowCount = span.rowCount;
                this._activeColCount = span.colCount
            }
            else
            {
                this._activeRowCount = 1;
                this._activeColCount = 1
            }
            this._render.repaintSelection(new UI.Range(this._activeRowIndex,this._activeColIndex,1,1));
            this._activeRowIndex = row;
            this._activeColIndex = col;
            this._leadingCellRow = row;
            this._leadingCellCol = col;
            this.activeRowViewportIndex = rowViewportIndex;
            this.activeColViewportIndex = colViewportIndex;
            this._render.repaintSelection(new UI.Range(row,col,1,1))
        },
        setActiveCell: function(row, col, rowViewportIndex, colViewportIndex)
        {
            this._bindToAutoRefresh(function(row, col, rowViewportIndex, colViewportIndex)
            {
                var rowCount = this.getRowCount();
                var colCount = this.getColumnCount();
                if(row < 0)
                    row = 0;
                else if(row >= rowCount)
                    row = rowCount - 1;
                if(col < 0)
                    col = 0;
                else if(col >= colCount)
                    col = colCount - 1;
                this._clearSelectionImp();
                this._setActiveCellImp(row,col,rowViewportIndex,colViewportIndex);
                var span = this._spanModel.find(row,col);
                if(span)
                    this._setSelectedRange(span.row,span.col,span.rowCount,span.colCount);
                else
                    this._setSelectedRange(row,col,1,1)
            })(row,col,rowViewportIndex,colViewportIndex)
        },
        getActiveRowIndex: function()
        {
            return this._activeRowIndex
        },
        getActiveColumnIndex: function()
        {
            return this._activeColIndex
        },
        selectionPolicy: function(value)
        {
            if(arguments.length === 0)
                return this._selectionModel.selectionPolicy;
            this._selectionModel.selectionPolicy = value;
            return this
        },
        selectionUnit: function(value)
        {
            if(arguments.length === 0)
                return this._selectionModel.selectionUnit;
            this._selectionModel.selectionUnit = value;
            return this
        },
        getRowResizable: function(row, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var v = true;
            var infos = this._getRowInfos(sheetArea);
            if(infos && infos[row] && infos[row].resizable !== undefined && infos[row].resizable !== null)
                v = infos[row].resizable;
            return v
        },
        setRowResizable: function(row, value, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var infos = this._getRowInfos(sheetArea);
            if(!infos[row])
                infos[row] = {};
            infos[row].resizable = value;
            infos[row].dirty = true;
            this._trigger(UI.Events.RowChanged,{
                sheet: this,
                sheetName: this._name,
                row: row,
                sheetArea: sheetArea,
                propertyName: "resizable"
            })
        },
        getColumnResizable: function(col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var v = true;
            var infos = this._getColumnInfos(sheetArea);
            if(infos && infos[col] && infos[col].resizable !== undefined && infos[col].resizable !== null)
                v = infos[col].resizable;
            return v
        },
        setColumnResizable: function(col, value, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var infos = this._getColumnInfos(sheetArea);
            if(!infos[col])
                infos[col] = {};
            infos[col].resizable = value;
            infos[col].dirty = true;
            this._trigger(UI.Events.ColumnChanged,{
                sheet: this,
                sheetName: this._name,
                col: col,
                sheetArea: sheetArea,
                propertyName: "resizable"
            })
        },
        getRowHeight: function(row, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.rowHeader || sheetArea === UI.SheetArea.viewport)
            {
                if(row < 0 || row >= this.getRowCount(sheetArea))
                    return 0;
                if(this._rowFilter && this._rowFilter.isHideRowFilter())
                    if(this._rowFilter.isFiltered() && this._rowFilter.isRowFilteredOut(row))
                        return 0;
                if(this.rowRangeGroup && !this.rowRangeGroup._isEmpty())
                    if(this.rowRangeGroup.isCollapsed(row))
                        return 0
            }
            var h = this.defaults.rowHeight;
            if(sheetArea === UI.SheetArea.colHeader)
                h = this.defaults.colHeaderRowHeight;
            var infos = this._getRowInfos(sheetArea);
            if(infos && infos[row])
                if(infos[row].visible === false)
                    return 0;
                else if(!isNaN(infos[row].size))
                    h = parseInt(infos[row].size,10);
            return h
        },
        _getActualRowHeight: function(row, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.rowHeader || sheetArea === SheetArea.viewport)
                if(row < 0 || row >= this.getRowCount(sheetArea))
                    return 0;
            var h = this.defaults.rowHeight;
            if(sheetArea === UI.SheetArea.colHeader)
                h = this.defaults.colHeaderRowHeight;
            var infos = this._getRowInfos(sheetArea);
            if(infos && infos[row])
                if(!isNaN(infos[row].size))
                    h = parseInt(infos[row].size,10);
            return h
        },
        setRowHeight: function(row, value, sheetArea)
        {
            this._bindToAutoRefresh(function(row, value, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var infos = this._getRowInfos(sheetArea);
                if(!infos[row])
                    infos[row] = {};
                infos[row].size = value;
                infos[row].dirty = true;
                this._trigger(UI.Events.RowChanged,{
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    sheetArea: sheetArea,
                    propertyName: _cssHeight
                })
            })(row,value,sheetArea)
        },
        getRowVisible: function(row, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
            {
                if(this._rowFilter && this._rowFilter.isHideRowFilter())
                    if(this._rowFilter.isFiltered() && this._rowFilter.isRowFilteredOut(row))
                        return false;
                if(this.rowRangeGroup && !this.rowRangeGroup._isEmpty())
                    if(0 <= row && row < this.getRowCount(sheetArea) && this.rowRangeGroup.isCollapsed(row))
                        return false
            }
            var v = true;
            var infos = this._getRowInfos(sheetArea);
            if(infos && infos[row] && infos[row].visible !== undefined && infos[row].visible !== null)
                v = infos[row].visible;
            return v
        },
        setRowVisible: function(row, value, sheetArea)
        {
            this._bindToAutoRefresh(function(row, value, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var infos = this._getRowInfos(sheetArea);
                if(!infos[row])
                    infos[row] = {};
                if(infos[row].visible === value)
                    return;
                infos[row].visible = value;
                infos[row].dirty = true;
                this._trigger(UI.Events.RowChanged,{
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    sheetArea: sheetArea,
                    propertyName: "isVisible"
                })
            })(row,value,sheetArea)
        },
        getColumnWidth: function(col, sheetArea)
        {
            var w = this.defaults.colWidth;
            var SheetArea = UI.SheetArea;
            if(sheetArea === SheetArea.rowHeader)
                w = this.defaults.rowHeaderColWidth;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.colHeader || sheetArea === SheetArea.viewport)
            {
                if(col < 0 || col >= this.getColumnCount(sheetArea))
                    return 0;
                if(this.colRangeGroup && !this.colRangeGroup._isEmpty())
                    if(this.colRangeGroup.isCollapsed(col))
                        return 0
            }
            var infos = this._getColumnInfos(sheetArea);
            if(infos && infos[col])
            {
                if(infos[col].visible === false)
                    return 0;
                if(!isNaN(infos[col].size))
                    w = parseInt(infos[col].size,10)
            }
            return w
        },
        _getActualColumnWidth: function(col, sheetArea)
        {
            var w = this.defaults.colWidth;
            var SheetArea = UI.SheetArea;
            if(sheetArea === SheetArea.rowHeader)
                w = this.defaults.rowHeaderColWidth;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.colHeader || sheetArea === SheetArea.viewport || sheetArea === SheetArea.colFooter)
                if(col < 0 || col >= this.getColumnCount(sheetArea))
                    return 0;
            var infos = this._getColumnInfos(sheetArea);
            if(infos && infos[col])
                if(!isNaN(infos[col].size))
                    w = parseInt(infos[col].size,10);
            return w
        },
        setColumnWidth: function(col, value, sheetArea)
        {
            this._bindToAutoRefresh(function(col, value, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var infos = this._getColumnInfos(sheetArea);
                if(!infos[col])
                    infos[col] = {};
                infos[col].size = value;
                infos[col].dirty = true;
                this._trigger(UI.Events.ColumnChanged,{
                    sheet: this,
                    sheetName: this._name,
                    col: col,
                    sheetArea: sheetArea,
                    propertyName: _cssWidth
                });
                if(this._allowCellOverflow)
                    this._clearCellOverflowModelCache()
            })(col,value,sheetArea)
        },
        getColumnVisible: function(col, sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.colHeader || sheetArea === SheetArea.viewport)
                if(this.colRangeGroup && !this.colRangeGroup._isEmpty())
                    if(0 <= col && col < this.getColumnCount(sheetArea) && this.colRangeGroup.isCollapsed(col))
                        return false;
            var v = true;
            var infos = this._getColumnInfos(sheetArea);
            if(infos && infos[col] && infos[col].visible !== undefined && infos[col].visible !== null)
                v = infos[col].visible;
            return v
        },
        setColumnVisible: function(col, value, sheetArea)
        {
            this._bindToAutoRefresh(function(col, value, sheetArea)
            {
                if(sheetArea === undefined || sheetArea === null)
                    sheetArea = UI.SheetArea.viewport;
                var infos = this._getColumnInfos(sheetArea);
                if(!infos[col])
                    infos[col] = {};
                if(infos[col].visible === value)
                    return;
                infos[col].visible = value;
                infos[col].dirty = true;
                if(this._allowCellOverflow === true)
                    this._clearCellOverflowModelCache();
                this._trigger(UI.Events.ColumnChanged,{
                    sheet: this,
                    sheetName: this._name,
                    col: col,
                    sheetArea: sheetArea,
                    propertyName: "isVisible"
                })
            })(col,value,sheetArea)
        },
        zoom: function(factor)
        {
            factor = parseFloat(factor);
            if(isNaN(factor) || !isFinite(factor))
                return;
            if(factor > 4)
                factor = 4;
            else if(factor < 0.25)
                factor = 0.25;
            this._bindToAutoRefresh(function(factor)
            {
                if(this.showEditingLocator)
                    this._showEditingLocator();
                if(this._allowCellOverflow && this._zoomFactor !== factor)
                    this._clearCellOverflowModelCache();
                this._zoomFactor = factor
            })(factor)
        },
        invalidateLayout: function()
        {
            this._layoutModel = null;
            this._cachedGroupLayout = null;
            this._rowLayoutCache = {
                colHeader: [],
                viewport: [],
                colFooter: []
            };
            this._colLayoutCache = {
                rowHeader: [],
                viewport: []
            };
            this._clearCellOverflowModelCache();
            this._filterButtonsModel = null;
            if(this._eventHandler && window.gcGlobal.activeElement === this)
                this._eventHandler._updateValidationUI(this._activeRowIndex,this._activeColIndex);
            this._dirty = true
        },
        getViewportHeight: function(rowViewportIndex)
        {
            var layout = this._getSheetLayout();
            return rowViewportIndex > 0 ? layout.viewportHeight : layout.frozenHeight
        },
        getViewportWidth: function(columnViewportIndex)
        {
            var layout = this._getSheetLayout();
            return columnViewportIndex > 0 ? layout.viewportWidth : layout.frozenWidth
        },
        getViewportTopRow: function(rowViewportIndex)
        {
            if(rowViewportIndex === 0)
                return 0;
            else
                return Math.max(this.frozenRowCount,this._scrollTopRow)
        },
        getViewportBottomRow: function(rowViewportIndex)
        {
            var topRow = this.getViewportTopRow(rowViewportIndex);
            var viewportHeight = this.getViewportHeight(rowViewportIndex);
            var rowHeightTotal = 0;
            var rowCount = 0;
            var rc = this.getRowCount();
            if(rowViewportIndex === 0)
                rc = Math.min(this.frozenRowCount,rc);
            for(var index = topRow; index < rc && rowHeightTotal < viewportHeight; index++, rowCount++)
                rowHeightTotal += this._getZoomRowHeight(index);
            return topRow + rowCount - 1
        },
        getViewportLeftColumn: function(columnViewportIndex)
        {
            if(columnViewportIndex === 0)
                return 0;
            else
                return Math.max(this.frozenColCount,this._scrollLeftCol)
        },
        getViewportRightColumn: function(columnViewportIndex)
        {
            var leftColumn = this.getViewportLeftColumn(columnViewportIndex);
            var viewportWidth = this.getViewportWidth(columnViewportIndex);
            var columnCount = 0;
            var columnWidthTotal = 0;
            var cc = this.getColumnCount();
            if(columnViewportIndex === 0)
                cc = Math.min(this.frozenColCount,cc);
            for(var index = leftColumn; index < cc && columnWidthTotal < viewportWidth; index++, columnCount++)
                columnWidthTotal += this._getZoomColumnWidth(index);
            return leftColumn + columnCount - 1
        },
        clearSelection: function()
        {
            this._bindToAutoRefresh(function()
            {
                this._clearSelectionImp();
                this._setActiveCellImp(0,0)
            })()
        },
        _clearSelectionImp: function()
        {
            this._selectionModel.clear()
        },
        _validationError: function(row, column, value)
        {
            var dv = this.getDataValidator(row,column);
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    col: column,
                    validator: dv,
                    validationResult: UI.DataValidationResult.ForceApply
                };
            this._trigger(UI.Events.ValidationError,args);
            return args.validationResult
        },
        getSpans: function(range, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var sm = this._getSpanModel(sheetArea);
            if(!range)
                return sm.slice(0);
            var t = [];
            for(var i = 0; i < sm.length; i++)
            {
                var rg = sm[i];
                if(!range || rg.intersect(range.row,range.col,range.rowCount,range.colCount))
                    t.push(rg)
            }
            return t
        },
        getCell: function(row, col, sheetArea)
        {
            return new UI.Cell(this,row,col,sheetArea)
        },
        getCells: function(row, col, row2, col2, sheetArea)
        {
            var cell = this.getCell(row,col,sheetArea);
            cell.row2 = row2;
            cell.col2 = col2;
            return cell
        },
        getRow: function(index, sheetArea)
        {
            return new UI.Row(this,index,sheetArea)
        },
        getRows: function(index, index2, sheetArea)
        {
            var row = this.getRow(index,sheetArea);
            row.index2 = index2;
            return row
        },
        getColumn: function(index, sheetArea)
        {
            return new UI.Col(this,index,sheetArea)
        },
        getColumns: function(index, index2, sheetArea)
        {
            var col = this.getColumn(index,sheetArea);
            col.index2 = index2;
            return col
        },
        setBorder: function(cellRange, border, option, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            try
            {
                var actualRange = this._getActualRange(cellRange,sheetArea);
                var row = actualRange.row;
                var col = actualRange.col;
                var rowCount = actualRange.rowCount;
                var colCount = actualRange.colCount;
                var r,
                    c;
                if(option.left || option.all || option.outline)
                    for(r = 0; r < rowCount; r++)
                        this.getCell(row + r,col,sheetArea).borderLeft(border);
                if(option.top || option.all || option.outline)
                    for(c = 0; c < colCount; c++)
                        this.getCell(row,col + c,sheetArea).borderTop(border);
                if(option.right || option.all || option.outline)
                    for(r = 0; r < rowCount; r++)
                        this.getCell(row + r,col + colCount - 1,sheetArea).borderRight(border);
                if(option.bottom || option.all || option.outline)
                    for(c = 0; c < colCount; c++)
                        this.getCell(row + rowCount - 1,col + c,sheetArea).borderBottom(border);
                if(option.innerHorizontal || option.all || option.inside)
                    for(r = 0; r < rowCount - 1; r++)
                        for(c = 0; c < colCount; c++)
                        {
                            this.getCell(row + r,col + c,sheetArea).borderBottom(border);
                            this.getCell(row + r + 1,col + c,sheetArea).borderTop(border)
                        }
                if(option.innerVertical || option.all || option.inside)
                    for(c = 0; c < colCount - 1; c++)
                        for(r = 0; r < rowCount; r++)
                        {
                            this.getCell(row + r,col + c,sheetArea).borderRight(border);
                            this.getCell(row + r,col + c + 1,sheetArea).borderLeft(border)
                        }
            }
            finally
            {
                this.isPaintSuspended(oldState)
            }
        },
        search: function(searchCondition)
        {
            if(!searchCondition)
                return null;
            var SearchFoundFlags = UI.SearchFoundFlags;
            var SearchResult = UI.SearchResult;
            if(!searchCondition.searchString || searchCondition.searchTarget === SearchFoundFlags.None || this.getRowCount(searchCondition.sheetArea) <= 0 && this.getColumnCount(searchCondition.sheetArea) <= 0)
                return new SearchResult;
            if(searchCondition.rowStart === -1)
                searchCondition.rowStart = 0;
            if(searchCondition.columnStart === -1)
                searchCondition.columnStart = 0;
            if(searchCondition.findBeginRow === -1)
                searchCondition.findBeginRow = searchCondition.rowStart;
            if(searchCondition.findBeginColumn === -1)
                searchCondition.findBeginColumn = searchCondition.columnStart;
            if(searchCondition.rowEnd === -1)
                searchCondition.rowEnd = this.getRowCount(searchCondition.sheetArea) - 1;
            if(searchCondition.columnEnd === -1)
                searchCondition.columnEnd = this.getColumnCount(searchCondition.sheetArea) - 1;
            var searchResult = new SearchResult;
            var enumerator = new UI.CellsEnumerator(this,searchCondition);
            if((searchCondition.searchFlags & UI.SearchFlags.BlockRange) > 0)
                enumerator.isBlockRange = true;
            while(enumerator.moveNext())
            {
                var rowIndex = enumerator.currentRow;
                var columnIndex = enumerator.currentColumn;
                var cell = enumerator.current();
                if((searchCondition.searchTarget & SearchFoundFlags.CellText) > 0)
                {
                    var cellText = cell.text();
                    if(this._trySearch(cellText,searchCondition.searchString,searchCondition.searchFlags) && cellText !== "")
                    {
                        searchResult.searchFoundFlag |= SearchFoundFlags.CellText;
                        searchResult.foundString = cellText
                    }
                }
                if((searchCondition.searchTarget & SearchFoundFlags.CellFormula) > 0)
                {
                    var cellFormula = cell.formula();
                    if(typeof cellFormula === const_string)
                        cellFormula = cellFormula.toString();
                    else
                        cellFormula = null;
                    if(this._trySearch(cellFormula,searchCondition.searchString,searchCondition.searchFlags) && cellFormula !== "")
                    {
                        searchResult.searchFoundFlag |= SearchFoundFlags.CellFormula;
                        searchResult.foundString = cellFormula
                    }
                }
                if(searchResult.searchFoundFlag !== SearchFoundFlags.None)
                {
                    searchResult.foundRowIndex = rowIndex;
                    searchResult.foundColumnIndex = columnIndex;
                    return searchResult
                }
            }
            return new SearchResult
        },
        showCell: function(row, col, verticalPosition, horizontalPosition)
        {
            if(row < 0 || row >= this.getRowCount())
                return;
            if(col < 0 || col >= this.getColumnCount())
                return;
            var frozenRowCount = isNaN(this.frozenRowCount) ? 0 : this.frozenRowCount;
            var frozenColCount = isNaN(this.frozenColCount) ? 0 : this.frozenColCount;
            var topRow = this._scrollTopRow;
            var leftColumn = this._scrollLeftCol;
            var columnViewportIndex = 1;
            var rowViewportIndex = 1;
            var HorizontalPosition = UI.HorizontalPosition,
                dWidth;
            if(horizontalPosition !== HorizontalPosition.left)
                if(horizontalPosition === HorizontalPosition.center)
                {
                    dWidth = Math.floor((this.getViewportWidth(columnViewportIndex) - Math.floor(this.getColumnWidth(col) * this._zoomFactor)) / 2);
                    for(; 0 < col; col--)
                    {
                        dWidth -= Math.floor(this.getColumnWidth(col - 1) * this._zoomFactor);
                        if(dWidth < 0)
                            break
                    }
                }
                else if(horizontalPosition === HorizontalPosition.right)
                {
                    dWidth = this.getViewportWidth(columnViewportIndex) - Math.floor(this.getColumnWidth(col) * this._zoomFactor);
                    for(; 0 < col; col--)
                    {
                        dWidth -= Math.floor(this.getColumnWidth(col - 1) * this._zoomFactor);
                        if(dWidth < 0)
                            break
                    }
                }
                else if(horizontalPosition === HorizontalPosition.nearest)
                    if(col >= leftColumn)
                    {
                        dWidth = this.getViewportWidth(columnViewportIndex) - Math.floor(this.getColumnWidth(col) * this._zoomFactor);
                        for(; leftColumn < col; col--)
                        {
                            dWidth -= Math.floor(this.getColumnWidth(col - 1) * this._zoomFactor);
                            if(dWidth < 0)
                                break
                        }
                    }
            var VerticalPosition = UI.VerticalPosition,
                height;
            if(verticalPosition !== VerticalPosition.top)
                if(verticalPosition === VerticalPosition.center)
                {
                    height = Math.floor((this.getViewportHeight(rowViewportIndex) - Math.floor(this.getRowHeight(row) * this._zoomFactor)) / 2);
                    for(; 0 < row; row--)
                    {
                        height -= Math.floor(this.getRowHeight(row - 1) * this._zoomFactor);
                        if(height < 0)
                            break
                    }
                }
                else if(verticalPosition === VerticalPosition.bottom)
                {
                    height = this.getViewportHeight(rowViewportIndex) - Math.floor(this.getRowHeight(row) * this._zoomFactor);
                    for(; 0 < row; row--)
                    {
                        height -= Math.floor(this.getRowHeight(row - 1) * this._zoomFactor);
                        if(height < 0)
                            break
                    }
                }
                else if(verticalPosition === VerticalPosition.nearest)
                    if(!(row < topRow || topRow === -1))
                    {
                        height = this.getViewportHeight(rowViewportIndex) - Math.floor(this.getRowHeight(row) * this._zoomFactor);
                        for(; topRow < row; row--)
                        {
                            height -= Math.floor(this.getRowHeight(row - 1) * this._zoomFactor);
                            if(height < 0)
                                break
                        }
                    }
            if(row >= frozenRowCount && row !== topRow)
            {
                this._scrollTopRow = row;
                this._syncVScrollbarPosition()
            }
            if(col >= frozenColCount && col !== leftColumn)
            {
                this._scrollLeftCol = col;
                this._syncHScollbarPosition()
            }
            if(row !== topRow || col !== leftColumn)
            {
                this.invalidateLayout();
                this.repaint()
            }
        },
        showColumn: function(col, horizontalPosition)
        {
            this.showCell(this._scrollTopRow,col,UI.VerticalPosition.top,horizontalPosition)
        },
        showRow: function(row, verticalPosition)
        {
            this.showCell(row,this._scrollLeftCol,verticalPosition,UI.HorizontalPosition.left)
        },
        bind: function(type, data, fn)
        {
            this._eventHandler.bind(type + _gcSheet,data,fn)
        },
        unbind: function(type, fn)
        {
            this._eventHandler.unbind(type + _gcSheet,fn)
        },
        unbindAll: function()
        {
            this._eventHandler.unbind(_gcSheet)
        },
        _bind: function(type, data, fn)
        {
            this._eventHandler.bind(type + _gcSheetInternal,data,fn)
        },
        _unbind: function(type, fn)
        {
            this._eventHandler.unbind(type + _gcSheetInternal,fn)
        },
        _unbindAll: function()
        {
            this._eventHandler.unbind(_gcSheetInternal)
        },
        suspendEvent: function()
        {
            this._eventHandler._eventSuspended++
        },
        resumeEvent: function()
        {
            this._eventHandler._eventSuspended--;
            if(this._eventHandler._eventSuspended < 0)
                this._eventHandler._eventSuspended = 0
        },
        currentTheme: function(value)
        {
            if(arguments.length === 0)
            {
                if(!this._currentTheme)
                    this._currentTheme = UI.SpreadThemes.Office;
                return this._currentTheme
            }
            var spreadThemes = UI.SpreadThemes;
            if(typeof value === const_string)
                if(spreadThemes.hasOwnProperty(value))
                    value = spreadThemes[value];
                else
                    value = new UI.SpreadTheme(value);
            this._bindToAutoRefresh(function(value)
            {
                this._currentTheme = value
            })(value);
            return this
        },
        reset: function()
        {
            this.defaults = {
                rowHeight: 20,
                colWidth: 62,
                rowHeaderColWidth: 40,
                colHeaderRowHeight: 20
            };
            this.gridline = {
                color: "#D0D7E5",
                showVerticalGridline: true,
                showHorizontalGridline: true
            };
            this._rowLayoutCache = {
                colHeader: [],
                viewport: [],
                colFooter: []
            };
            this._colLayoutCache = {
                rowHeader: [],
                viewport: []
            };
            this._dragRect = {};
            this._render = new UI._SheetRender(this);
            this._eventHandler = new UI._SheetEventHandler(this);
            var GcSheetModel = UI._GcSheetModel;
            this._dataModel = new GcSheetModel;
            this._dataModel.name = this._name;
            this._calcDataModel = new GcSheetModel(this._dataModel.rowCount,this._dataModel.colCount,this._name + "_calc");
            this._rowHeaderModel = new GcSheetModel(this._dataModel.rowCount,1);
            this._colHeaderModel = new GcSheetModel(1,this._dataModel.colCount);
            this._colFooterModel = new GcSheetModel(1,this._dataModel.colCount,this._name + "cf");
            var SpanModel = UI._SpanModel;
            this._spanModel = new SpanModel;
            this._colHeaderSpanModel = new SpanModel;
            this._rowHeaderSpanModel = new SpanModel;
            this._selectionModel = new UI._SelectionModel;
            this._vpSheetSource = new GrapeCity.Calc._SheetSource(this,UI.SheetArea.viewport);
            this._cellOverflowModelCache = null;
            if(typeof UI.RangeGroup !== const_undefined)
            {
                this.rowRangeGroup = new UI.RangeGroup(this.getRowCount());
                this.colRangeGroup = new UI.RangeGroup(this.getColumnCount())
            }
            this._showRowRangeGroup = true;
            this._showColumnRangeGroup = true;
            this._rowInfos = null;
            this._colInfos = null;
            this._dataSource = null;
            this.dataContext = null;
            this.autoGenerateColumns = true;
            this.autoUpdate = true;
            this._rowFilter = null;
            if(typeof UI.HideRowFilter !== const_undefined)
                this._filterButtonsModel = null;
            this._initDefaultKeyMap();
            this._scrollTopRow = 0;
            this._scrollLeftCol = 0;
            this.frozenRowCount = 0;
            this.frozenColCount = 0;
            if(UI.WorksheetSparklineGroupManager)
                this._sparklineGroupManager = new UI.WorksheetSparklineGroupManager(this,this);
            this._syncScrollbarSize();
            this.invalidateLayout();
            this._dirty = true
        },
        undoManager: function()
        {
            if(!this._undoManager)
                this._undoManager = this.parent && this.parent._undoManager ? this.parent._undoManager : new UI._UndoManager(this,-1,this.allowUndo());
            return this._undoManager
        },
        clipBoardOptions: function(value)
        {
            if(arguments.length === 0)
            {
                if(this._clipBoardOptions === undefined || this._clipBoardOptions === null)
                    this._clipBoardOptions = UI.ClipboardPasteOptions.All;
                return this._clipBoardOptions
            }
            else
            {
                this._clipBoardOptions = value;
                return this
            }
        },
        doCommand: function(action)
        {
            this._doCommand(action)
        },
        copyTo: function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount, option)
        {
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            this.suspendEvent();
            staticMembers.copyTo(this,fromRow,fromColumn,this,toRow,toColumn,rowCount,columnCount,option);
            this.resumeEvent();
            this.isPaintSuspended(oldState)
        },
        moveTo: function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount, option)
        {
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            this.suspendEvent();
            staticMembers.moveTo(this,fromRow,fromColumn,this,toRow,toColumn,rowCount,columnCount,option);
            this.resumeEvent();
            this.isPaintSuspended(oldState)
        },
        setCsv: function(row, column, text, rowDelimiter, columnDelimiter, flags)
        {
            var oldState = this.isPaintSuspended();
            this.isPaintSuspended(true);
            this.suspendEvent();
            staticMembers.setRangeText(this,row,column,text,rowDelimiter,columnDelimiter,"\"",flags);
            this.resumeEvent();
            this.isPaintSuspended(oldState)
        },
        getCsv: function(row, column, rowCount, columnCount, rowDelimiter, columnDelimiter)
        {
            return staticMembers.getRangeText(this,row,rowCount,column,columnCount,rowDelimiter,columnDelimiter,"\"",false,UI.TextFileOpenFlags.None)
        },
        canUserDragDrop: function(value)
        {
            if(arguments.length === 0)
            {
                if(this.parent && this.parent.canUserDragDrop)
                    this._allowDragDrop = this.parent.canUserDragDrop();
                else if(this._allowDragDrop === undefined || this._allowDragDrop === null)
                    this._allowDragDrop = true;
                return this._allowDragDrop
            }
            else
            {
                if(this.parent && this.parent.canUserDragDrop)
                    this.parent.canUserDragDrop(value);
                else
                    this._allowDragDrop = value;
                return this
            }
        },
        canUserDragFill: function(value)
        {
            if(arguments.length === 0)
            {
                if(this.parent && this.parent.canUserDragFill)
                    this._allowDragFill = this.parent.canUserDragFill();
                else if(this._allowDragFill === undefined || this._allowDragFill === null)
                    this._allowDragFill = true;
                return this._allowDragFill
            }
            else
            {
                var oldValue = this.canUserDragFill();
                if(oldValue !== value)
                {
                    if(this.parent && this.parent.canUserDragFill)
                        this.parent.canUserDragFill(value);
                    else
                        this._allowDragFill = value;
                    if(this.getSelections().length === 1)
                        this._render.repaintSelection(this.getSelections().toArray()[0])
                }
                return this
            }
        },
        isColumnBound: function(column)
        {
            if(column < 0 || column >= this.getColumnCount())
                return false;
            var ds = this.getDataSource();
            if(ds)
                if(this._colInfos)
                {
                    var ci = this._colInfos[column];
                    return!!(ci && ci.name)
                }
            return false
        },
        getDataColumnName: function(column)
        {
            if(column < 0 || column >= this.getColumnCount())
                return null;
            var ds = this.getDataSource();
            if(ds)
                if(this._colInfos)
                {
                    var ci = this._colInfos[column];
                    return ci.displayName || ci.name
                }
            return null
        },
        getSparkline: function(row, col)
        {
            var sheetArea = UI.SheetArea.viewport;
            var m = this._getModel(sheetArea);
            return m.getSparkline(row,col)
        },
        setSparkline: function(row, col, dataRange, dataOrientation, sparklineType, sparklineSetting, dateAxisRange, dateAxisOrientation)
        {
            return this._bindToAutoRefresh(function(row, col, dataRange, dataOrientation, sparklineType, sparklineSetting, dateAxisRange, dateAxisOrientation)
                {
                    var data = dataRange;
                    var sparkline = new UI.Sparkline(row,col,data,dataOrientation,sparklineType,sparklineSetting);
                    if(dateAxisRange && dateAxisOrientation !== undefined && dateAxisOrientation !== null)
                    {
                        sparkline.dateAxisData(dateAxisRange);
                        sparkline.dateAxisOrientation(dateAxisOrientation);
                        sparkline.group().displayDateAxis = true
                    }
                    this.removeSparkline(row,col);
                    var m = this._getModel();
                    m.setSparkline(row,col,sparkline);
                    this._sparklineGroupManager.add(sparkline.group());
                    this._raiseCellChanged("sparkline",row,col,UI.SheetArea.viewport);
                    return sparkline
                })(row,col,dataRange,dataOrientation,sparklineType,sparklineSetting,dateAxisRange,dateAxisOrientation)
        },
        removeSparkline: function(row, col)
        {
            this._bindToAutoRefresh(function(row, col)
            {
                var sheetArea = UI.SheetArea.viewport;
                var m = this._getModel(sheetArea);
                var old = m.getSparkline(row,col);
                if(old)
                {
                    var g = old.group();
                    g.remove(old);
                    if(g.count() <= 0)
                        this._sparklineGroupManager.remove(g)
                }
                m.setSparkline(row,col,null)
            })(row,col)
        },
        groupSparkline: function(sparklines)
        {
            return this._bindToAutoRefresh(function(sparklines)
                {
                    var first = null;
                    for(var i = 0; i < sparklines.length; i++)
                    {
                        var si = sparklines[i];
                        if(!si)
                            continue;
                        if(!first)
                        {
                            first = si.group();
                            continue
                        }
                        var sg = si.group();
                        sg.remove(si);
                        first.add(si);
                        if(sg.count() <= 0)
                            this._sparklineGroupManager.remove(sg)
                    }
                    return first
                })(sparklines)
        },
        ungroupSparkline: function(group)
        {
            this._bindToAutoRefresh(function(group)
            {
                if(!group)
                    return;
                var sparklines = [];
                sparklines = sparklines.concat(group._innerList);
                for(var i = 0; i < sparklines.length; i++)
                {
                    var sparkline = sparklines[i];
                    if(sparkline)
                    {
                        group.remove(sparkline);
                        var newGroup = group.clone();
                        newGroup.add(sparkline);
                        this._sparklineGroupManager.add(newGroup)
                    }
                }
                this._sparklineGroupManager.remove(group)
            })(group)
        },
        fillAuto: function(startRange, wholeRange, series)
        {
            if(!wholeRange)
                throw new Error("range");
            if(!this._checkFillRange(startRange,wholeRange,series))
                return;
            this._bindToAutoRefresh(function(startRange, wholeRange, series)
            {
                if(startRange)
                    this._eventHandler._dragFillStartRange = startRange;
                var fill = new UI.FillImp(this);
                fill.fillAuto(wholeRange,series)
            })(startRange,wholeRange,series)
        },
        fillAutobyDirection: function(startRange, wholeRange, direction)
        {
            if(!wholeRange)
                throw new Error("range");
            if(!this._checkFillRange(startRange,wholeRange,null,direction))
                return;
            this._bindToAutoRefresh(function(startRange, wholeRange, direction)
            {
                if(startRange)
                    this._eventHandler._dragFillStartRange = startRange;
                var fill = new UI.FillImp(this);
                fill.fillAutobyDirection(wholeRange,direction)
            })(startRange,wholeRange,direction)
        },
        fillLinear: function(startRange, wholeRange, series, step, stop)
        {
            if(!wholeRange)
                throw new Error("range");
            if(!this._checkFillRange(startRange,wholeRange,series))
                return;
            this._bindToAutoRefresh(function(startRange, wholeRange, series, step, stop)
            {
                if(startRange)
                    this._eventHandler._dragFillStartRange = startRange;
                var fill = new UI.FillImp(this);
                fill.fillLinear(wholeRange,series,step,stop)
            })(startRange,wholeRange,series,step,stop)
        },
        fillGrowth: function(startRange, wholeRange, series, step, stop)
        {
            if(!wholeRange)
                throw new Error("range");
            if(!this._checkFillRange(startRange,wholeRange,series))
                return;
            this._bindToAutoRefresh(function(startRange, wholeRange, series, step, stop)
            {
                if(startRange)
                    this._eventHandler._dragFillStartRange = startRange;
                var fill = new UI.FillImp(this);
                fill.fillGrowth(wholeRange,series,step,stop)
            })(startRange,wholeRange,series,step,stop)
        },
        fillDate: function(startRange, wholeRange, series, unit, step, stop)
        {
            if(!wholeRange)
                throw new Error("range");
            if(!this._checkFillRange(startRange,wholeRange,series))
                return;
            this._bindToAutoRefresh(function(startRange, wholeRange, series, unit, step, stop)
            {
                if(startRange)
                    this._eventHandler._dragFillStartRange = startRange;
                var fill = new UI.FillImp(this);
                var oaStop = null;
                if(stop !== undefined && stop !== null)
                    oaStop = new UI._DateTimeHelper(stop).toOADate();
                fill.fillDate(wholeRange,series,unit,step,oaStop)
            })(startRange,wholeRange,series,unit,step,stop)
        },
        _checkFillRange: function(startRange, wholeRange, series, direction)
        {
            if(!startRange || !wholeRange)
                return false;
            if(!wholeRange.containsRange(startRange))
                return false;
            if(series !== undefined && series !== null)
            {
                var FillSeries = UI.FillSeries;
                if(series === FillSeries.Row)
                {
                    if(startRange.row === wholeRange.row && startRange.rowCount === wholeRange.rowCount)
                        return true
                }
                else if(series === FillSeries.Column)
                    if(startRange.col === wholeRange.col && startRange.colCount === wholeRange.colCount)
                        return true
            }
            if(direction !== undefined && direction !== null)
            {
                var FillDirection = UI.FillDirection;
                if(direction === FillDirection.Up || direction === FillDirection.Down)
                {
                    if(startRange.col === wholeRange.col && startRange.colCount === wholeRange.colCount)
                        return true
                }
                else if(direction === FillDirection.Left || direction === FillDirection.Right)
                    if(startRange.row === wholeRange.row && startRange.rowCount === wholeRange.rowCount)
                        return true
            }
            return false
        },
        clear: function(row, column, rowCount, columnCount, area, type)
        {
            this._bindToAutoRefresh(function(row, column, rowCount, columnCount, area, type)
            {
                this.suspendCalcService();
                try
                {
                    var r,
                        c,
                        i,
                        j;
                    var viewport = UI.SheetArea.viewport,
                        StorageType = UI.StorageType;
                    if(area === undefined || area === null || area === viewport)
                    {
                        if((type & StorageType.Data) === StorageType.Data)
                        {
                            if(this._dataSource || this.dataContext)
                            {
                                this.suspendEvent();
                                for(r = row; r < row + rowCount; r++)
                                    for(c = column; c < column + columnCount; c++)
                                        this.setValue(r,c,null,area);
                                this.resumeEvent()
                            }
                            if(this._conditionalFormats)
                                this._conditionalFormats._clearCache();
                            if(this._rowFilter && this._rowFilter.range)
                                this._rowFilter._clear(row,column,rowCount,columnCount)
                        }
                        if((type & StorageType.Sparkline) === StorageType.Sparkline)
                            if(this._sparklineGroupManager)
                                this._sparklineGroupManager.clear(row,column,rowCount,columnCount)
                    }
                    var block = this._getModel(area);
                    var calcBlock = this._getCalcModel(area);
                    if(block)
                    {
                        r = row === -1 ? 0 : row;
                        var rc = row === -1 ? block.rowCount : rowCount;
                        c = column === -1 ? 0 : column;
                        var cc = column === -1 ? block.colCount : columnCount;
                        block.clear(r,c,rc,cc,type);
                        if(calcBlock)
                            calcBlock.clear(r,c,rc,cc,type);
                        if((type & StorageType.Style) === StorageType.Style)
                            if(!(row >= 0 && column >= 0))
                                if(column >= 0)
                                    for(j = 0; j < cc; j++)
                                        this.setStyle(-1,c + j,null,area);
                                else if(row >= 0)
                                    for(i = 0; i < rc; i++)
                                        this.setStyle(r + i,-1,null,area);
                                else
                                    this.setStyle(-1,-1,null,area);
                        if((type & StorageType.Axis) === StorageType.Axis)
                            if(!(row >= 0 && column >= 0))
                                if(column >= 0)
                                    for(j = 0; j < cc; j++)
                                    {
                                        this.setColumnVisible(c + j,true,area);
                                        this.setColumnResizable(c + j,true,area);
                                        this.setColumnWidth(c + j,area === UI.SheetArea.rowHeader ? this.defaults.rowHeaderColWidth : this.defaults.colWidth,area)
                                    }
                                else if(row >= 0)
                                    for(i = 0; i < rc; i++)
                                    {
                                        this.setRowVisible(r + i,true,area);
                                        this.setRowResizable(r + i,true,area);
                                        this.setRowHeight(r + i,area === UI.SheetArea.colHeader ? this.defaults.colHeaderRowHeight : this.defaults.rowHeight,area)
                                    }
                                else
                                {
                                    for(j = 0; j < cc; j++)
                                    {
                                        this.setColumnVisible(c + j,true,area);
                                        this.setColumnResizable(c + j,true,area);
                                        this.setColumnWidth(c + j,area === UI.SheetArea.rowHeader ? this.defaults.rowHeaderColWidth : this.defaults.colWidth,area)
                                    }
                                    for(i = 0; i < rc; i++)
                                    {
                                        this.setRowVisible(r + i,true,area);
                                        this.setRowResizable(r + i,true,area);
                                        this.setRowHeight(r + i,area === UI.SheetArea.colHeader ? this.defaults.colHeaderRowHeight : this.defaults.rowHeight,area)
                                    }
                                }
                        for(i = 0; i < rc; i++)
                            for(j = 0; j < cc; j++)
                            {
                                r = row + i;
                                c = column + j;
                                if((type & StorageType.Data) === StorageType.Data)
                                    this._raiseCellChanged(_value,r,c,area);
                                if((type & StorageType.Style) === StorageType.Style)
                                    this._raiseCellChanged("style",r,c,area);
                                if((type & StorageType.Sparkline) === StorageType.Sparkline)
                                    this._raiseCellChanged("sparkline",r,c,area);
                                if((type & StorageType.Axis) === StorageType.Axis)
                                    this._raiseCellChanged("axis",r,c,area);
                                if((type & StorageType.BindingPath) === StorageType.BindingPath)
                                    this._raiseCellChanged("bindingPath",r,c,area)
                            }
                    }
                    if(area === undefined || area === null || area === viewport)
                        if((type & StorageType.Data) === StorageType.Data)
                            this._getSheetSource()._addCellsToDirty(row,column,rowCount,columnCount)
                }
                finally
                {
                    this.resumeCalcService()
                }
            })(row,column,rowCount,columnCount,area,type)
        },
        getConditionalFormats: function()
        {
            if(!this._conditionalFormats)
                this._conditionalFormats = new UI.ConditionalFormats(this);
            return this._conditionalFormats
        },
        rowFilter: function(value)
        {
            if(arguments.length === 0)
                return this._rowFilter;
            else
                return this._bindToAutoRefresh(function(value)
                    {
                        if(this._rowFilter)
                            this._rowFilter.reset();
                        this._rowFilter = value;
                        if(this._rowFilter)
                            this._rowFilter.sheet = this;
                        return this
                    })(value)
        },
        autoFitColumn: function(column)
        {
            if(column < 0 || column >= this.getColumnCount())
                return;
            var action = new UI.UndoRedo.ColumnAutoFitUndoAction(this,[{col: column}],false);
            action.execute(this)
        },
        autoFitRow: function(row)
        {
            if(row < 0 || row >= this.getRowCount())
                return;
            var action = new UI.UndoRedo.RowAutoFitUndoAction(this,[{row: row}],false);
            action.execute(this)
        },
        setGridlineOptions: function(options)
        {
            this._bindToAutoRefresh(function(options)
            {
                if(options)
                {
                    if(!this.gridline)
                        this.gridline = {};
                    if(options.color)
                        this.gridline.color = options.color;
                    if(options.showVerticalGridline !== null && options.showVerticalGridline !== undefined)
                        this.gridline.showVerticalGridline = options.showVerticalGridline;
                    if(options.showHorizontalGridline !== null && options.showHorizontalGridline !== undefined)
                        this.gridline.showHorizontalGridline = options.showHorizontalGridline
                }
            })(options)
        },
        getGridlineOptions: function()
        {
            if(!this.gridline)
                this.gridline = {};
            var options = {};
            options.color = this.gridline.color;
            options.showVerticalGridline = this.gridline.showVerticalGridline;
            options.showHorizontalGridline = this.gridline.showHorizontalGridline;
            return options
        },
        getFrozenRowCount: function()
        {
            return this.frozenRowCount
        },
        getFrozenColumnCount: function()
        {
            return this.frozenColCount
        },
        setRowHeaderVisible: function(visible)
        {
            this._bindToAutoRefresh(function(options)
            {
                this.rowHeaderVisible = visible
            })(visible)
        },
        getRowHeaderVisible: function()
        {
            return this.rowHeaderVisible
        },
        setColumnHeaderVisible: function(visible)
        {
            this._bindToAutoRefresh(function(options)
            {
                this.colHeaderVisible = visible
            })(visible)
        },
        getColumnHeaderVisible: function()
        {
            return this.colHeaderVisible
        },
        setRowHeaderAutoText: function(autoText)
        {
            this._bindToAutoRefresh(function(autoText)
            {
                this.rowHeaderAutoText = autoText
            })(autoText)
        },
        getRowHeaderAutoText: function()
        {
            return this.rowHeaderAutoText
        },
        setColumnHeaderAutoText: function(autoText)
        {
            this._bindToAutoRefresh(function(autoText)
            {
                this.colHeaderAutoText = autoText
            })(autoText)
        },
        getColumnHeaderAutoText: function()
        {
            return this.colHeaderAutoText
        },
        setRowHeaderAutoTextIndex: function(autoTextIndex)
        {
            this._bindToAutoRefresh(function(autoTextIndex)
            {
                this.rowHeaderAutoTextIndex = autoTextIndex
            })(autoTextIndex)
        },
        getRowHeaderAutoTextIndex: function()
        {
            return this.rowHeaderAutoTextIndex
        },
        setColumnHeaderAutoTextIndex: function(autoTextIndex)
        {
            this._bindToAutoRefresh(function(autoTextIndex)
            {
                this.colHeaderAutoTextIndex = autoTextIndex
            })(autoTextIndex)
        },
        getColumnHeaderAutoTextIndex: function()
        {
            return this.colHeaderAutoTextIndex
        },
        setIsProtected: function(isProtected)
        {
            this._bindToAutoRefresh(function(autoTextIndex)
            {
                this.isProtected = isProtected
            })(isProtected)
        },
        getIsProtected: function()
        {
            return this.isProtected
        },
        setArray: function(row, column, array, setFormula)
        {
            var rowCount = this.getRowCount(),
                columnCount = this.getColumnCount();
            if(array && 0 <= row && row < rowCount && 0 <= column && column < columnCount)
            {
                this.suspendCalcService();
                var oldState = this.isPaintSuspended();
                this.isPaintSuspended(true);
                try
                {
                    var self = this;
                    $.each(array,function(i, v)
                    {
                        if(!(v instanceof Array))
                        {
                            var r = row + i,
                                c = column;
                            if(r < rowCount && c < columnCount)
                                if(setFormula)
                                    self.setFormula(r,c,v,UI.SheetArea.viewport);
                                else
                                    self.setValue(r,c,v,UI.SheetArea.viewport,true)
                        }
                        else
                            $.each(v,function(j, vv)
                            {
                                var r = row + i,
                                    c = column + j;
                                if(r < rowCount && c < columnCount)
                                    if(setFormula)
                                        self.setFormula(r,c,vv,UI.SheetArea.viewport);
                                    else
                                        self.setValue(r,c,vv,UI.SheetArea.viewport,true)
                            })
                    })
                }
                finally
                {
                    this.resumeCalcService();
                    this.isPaintSuspended(oldState)
                }
            }
        },
        getArray: function(row, column, rowCount, columnCount, getFormula)
        {
            var array = [];
            var rc = this.getRowCount(),
                cc = this.getColumnCount();
            if(0 <= row && row < rc && 0 <= column && column < cc)
            {
                if(row + rowCount > rc)
                    rowCount = rc - row;
                if(column + columnCount > cc)
                    columnCount = cc - column;
                for(var i = 0; i < rowCount; i++)
                {
                    array[i] = [];
                    for(var j = 0; j < columnCount; j++)
                        if(getFormula)
                            array[i][j] = this.getFormula(row + i,column + j);
                        else
                            array[i][j] = this.getValue(row + i,column + j)
                }
            }
            return array
        },
        showRowRangeGroup: function(value)
        {
            if(arguments.length === 0)
                return this._showRowRangeGroup;
            if(this._showRowRangeGroup !== value)
                this._bindToAutoRefresh(function(value)
                {
                    this._showRowRangeGroup = value
                })(value);
            return this
        },
        showColumnRangeGroup: function(value)
        {
            if(arguments.length === 0)
                return this._showColumnRangeGroup;
            if(this._showColumnRangeGroup !== value)
                this._bindToAutoRefresh(function(value)
                {
                    this._showColumnRangeGroup = value
                })(value);
            return this
        },
        _GROUPBUTTON_WIDTH: 15.0,
        _GROUPBUTTON_HEIGHT: 15.0,
        _GROUPPADDING: 2.0,
        _rowLayoutCache: null,
        _colLayoutCache: null,
        _scrollCallback: null,
        _dragRect: null,
        _scrollTopRow: 0,
        _scrollLeftCol: 0,
        _activeRowDirty: false,
        _initPaint: function()
        {
            var isStandardCanvas = GrapeCity.UI._isStandardCanvas();
            if(isStandardCanvas)
                return;
            var control = this._getCanvas();
            if(control && control.firstChild && control.firstChild.loaded)
            {
                this.invalidateLayout();
                this.repaint()
            }
            else
            {
                var self = this;
                window.setTimeout(function()
                {
                    self.initPaint.call(self)
                },10)
            }
        },
        _bindToAutoRefresh: function(fn, context)
        {
            if(!context)
                context = this;
            return function()
                {
                    var t = fn.apply(context,arguments);
                    if(!context._paintSuspended)
                    {
                        if(typeof context.invalidateLayout === const_function)
                            context.invalidateLayout();
                        if(typeof context.repaint === const_function)
                            context.repaint()
                    }
                    return t
                }
        },
        _isValidSheetName: function(sheetName)
        {
            if(!sheetName || sheetName === "")
                return false;
            if(!this.parent)
                return true;
            var length = this.parent.sheets.length;
            for(var i = 0; i < length; i++)
            {
                var sheet = this.parent.sheets[i];
                if(sheet !== this)
                    if(sheetName === sheet._name)
                        return false
            }
            return true
        },
        _init: function(name)
        {
            this._name = name;
            this._bounds = new UI.Rect(0,0,0,0);
            this.reset()
        },
        applyOptions: function(options)
        {
            if(!options)
                return;
            if(typeof options.name === const_string && options.name.length > 0)
                this._name = options.name;
            if(options.data)
                this.setDataSource(options.data);
            if(typeof options.defaultRowHeight === const_number)
                this.defaults.rowHeight = options.defaultRowHeight;
            if(typeof options.defaultColWidth === const_number)
                this.defaults.colWidth = options.defaultColWidth;
            if(typeof options.defaultRowHeaderColWidth === const_number)
                this.defaults.rowHeaderColWidth = options.defaultRowHeaderColWidth;
            if(typeof options.defaultColHeaderRowHeight === const_number)
                this.defaults.colHeaderRowHeight = options.defaultColHeaderRowHeight;
            if(typeof options.rowCount === const_number)
                this.setRowCount(options.rowCount);
            if(typeof options.colCount === const_number)
                this.setColumnCount(options.colCount);
            if(typeof options.frozenRowCount === const_number)
                this.frozenRowCount = options.frozenRowCount;
            if(typeof options.frozenColCount === const_number)
                this.frozenColCount = options.frozenColCount;
            if(options.gridlineColor)
                this.gridline.color = options.gridlineColor;
            if(typeof options.showVerticalGridline === const_boolean)
                this.gridline.showVerticalGridline = options.showVerticalGridline;
            if(typeof options.showHorizontalGridline === const_boolean)
                this.gridline.showHorizontalGridline = options.showHorizontalGridline;
            if(options.borderColor)
                this.borderColor = options.borderColor;
            if(typeof options.borderWidth === const_number)
                this.borderWidth = options.borderWidth;
            if(typeof options._zoomFactor === const_number)
                this._zoomFactor = options._zoomFactor;
            if(typeof options.rowHeaderVisible === const_boolean)
                this.rowHeaderVisible = options.rowHeaderVisible;
            if(typeof options.colHeaderVisible === const_boolean)
                this.colHeaderVisible = options.colHeaderVisible;
            if(typeof options.autoUpdate === const_boolean)
                this.autoUpdate = options.autoUpdate;
            if(typeof options.autoGenerateColumns === const_boolean)
                this.autoGenerateColumns = options.autoGenerateColumns;
            if(options.rowHeaderAutoText)
                this.rowHeaderAutoText = options.rowHeaderAutoText;
            if(options.colHeaderAutoText)
                this.colHeaderAutoText = options.colHeaderAutoText;
            if(typeof options._activeRowIndex === const_number)
                this._activeRowIndex = options._activeRowIndex;
            if(typeof options._activeColIndex === const_number)
                this._activeColIndex = options._activeColIndex;
            if(typeof options._allowCellOverflow === const_boolean)
                this._allowCellOverflow = options._allowCellOverflow;
            if(typeof options.isProtected === const_boolean)
                this.isProtected = options.isProtected;
            if(typeof options.allowUndo === const_boolean)
                this.allowUndo(options.allowUndo);
            if(options.columns && options.columns.length > 0)
            {
                this.autoGenerateColumns = false;
                this.bindColumns(options.columns)
            }
            if(options.dataContext)
            {
                var dc = new UI.DataContext(options.dataContext.read,options.dataContext.create,options.dataContext.update,options.dataContext.remove);
                this.setDataContext(dc)
            }
        },
        _initDefaultKeyMap: function()
        {
            var spreadActions = UI.SpreadActions;
            var key = UI.Key;
            this.addKeyMap(key.left,false,false,false,spreadActions.navigationLeft);
            this.addKeyMap(key.left,true,false,false,spreadActions.navigationHome2);
            this.addKeyMap(key.right,false,false,false,spreadActions.navigationRight);
            this.addKeyMap(key.right,true,false,false,spreadActions.navigationEnd);
            this.addKeyMap(key.up,false,false,false,spreadActions.navigationUp);
            this.addKeyMap(key.up,true,false,false,spreadActions.navigationTop);
            this.addKeyMap(key.down,false,false,false,spreadActions.navigationDown);
            this.addKeyMap(key.down,true,false,false,spreadActions.navigationBottom);
            this.addKeyMap(key.home,false,false,false,spreadActions.navigationHome);
            this.addKeyMap(key.home,true,false,false,spreadActions.navigationFirst);
            this.addKeyMap(key.end,false,false,false,spreadActions.navigationEnd);
            this.addKeyMap(key.end,true,false,false,spreadActions.navigationLast);
            this.addKeyMap(key.tab,false,false,false,spreadActions.commitInputNavigationTabNext);
            this.addKeyMap(key.tab,false,true,false,spreadActions.commitInputNavigationTabPrevious);
            this.addKeyMap(key.pup,false,false,false,spreadActions.navigationPageUp);
            this.addKeyMap(key.pup,true,false,false,spreadActions.navigationPreviousSheet);
            this.addKeyMap(key.pdn,false,false,false,spreadActions.navigationPageDown);
            this.addKeyMap(key.pdn,true,false,false,spreadActions.navigationNextSheet);
            this.addKeyMap(key.del,false,false,false,spreadActions.clear);
            this.addKeyMap(key.backspace,false,false,false,spreadActions.clearAndEditing);
            this.addKeyMap(key.enter,false,false,false,spreadActions.commitInputNavigationDown);
            this.addKeyMap(key.enter,false,true,false,spreadActions.commitInputNavigationUp);
            this.addKeyMap(key.esc,false,false,false,spreadActions.cancelInput);
            this.addKeyMap(key.left,false,true,false,spreadActions.selectionLeft);
            this.addKeyMap(key.right,false,true,false,spreadActions.selectionRight);
            this.addKeyMap(key.up,false,true,false,spreadActions.selectionUp);
            this.addKeyMap(key.down,false,true,false,spreadActions.selectionDown);
            this.addKeyMap(key.home,false,true,false,spreadActions.selectionHome);
            this.addKeyMap(key.end,false,true,false,spreadActions.selectionEnd);
            this.addKeyMap(key.pup,false,true,false,spreadActions.selectionPageUp);
            this.addKeyMap(key.pdn,false,true,false,spreadActions.selectionPageDown);
            this.addKeyMap(key.left,true,true,false,spreadActions.selectionHome);
            this.addKeyMap(key.right,true,true,false,spreadActions.selectionEnd);
            this.addKeyMap(key.up,true,true,false,spreadActions.selectionTop);
            this.addKeyMap(key.down,true,true,false,spreadActions.selectionBottom);
            this.addKeyMap(key.home,true,true,false,spreadActions.selectionFirst);
            this.addKeyMap(key.end,true,true,false,spreadActions.selectionLast);
            this.addKeyMap(key.c,true,false,false,spreadActions.copy);
            this.addKeyMap(key.x,true,false,false,spreadActions.cut);
            this.addKeyMap(key.v,true,false,false,spreadActions.paste);
            this.addKeyMap(key.z,true,false,false,spreadActions.undo);
            this.addKeyMap(key.y,true,false,false,spreadActions.redo)
        },
        _setHost: function(host)
        {
            var canvas = document.createElement("canvas");
            canvas.setAttribute("id",host.getAttribute("id") + "_vp");
            $(canvas).html("You need a browser which full supports HTML5 Canvas to run SpreadJS");
            host.appendChild(canvas);
            canvas.gcObject = true;
            if(this._canvas)
            {
                $(this._canvas).unbind(_mouseDown_gcSheet);
                $(this._canvas).unbind(_mouseMove_gcSheet);
                $(this._canvas).unbind(_mouseUp_gcSheet);
                $(this._canvas).unbind(_mouseOut_gcSheet);
                $(this._canvas).unbind(_dblclick_gcSheet);
                $(this._canvas).unbind(_mouseWheel_gcSheet);
                if(this._canvas.parentNode)
                    this._canvas.parentNode.removeChild(this._canvas)
            }
            this._canvas = canvas;
            canvas.setAttribute('renderMethod','auto');
            var self = this;
            this._mouseDownDelegate = function(event)
            {
                return self._eventHandler.doMouseDown(event)
            };
            this._mouseMoveDelegate = function(event)
            {
                if(self._eventHandler._isMouseCapture)
                    return;
                self._eventHandler.doMouseMove(event)
            };
            this._mouseUpDelegate = function(event)
            {
                if(!self._continueMouseUpBubble)
                {
                    if(self._eventHandler._isMouseCapture)
                        return;
                    return self._eventHandler.doMouseUp(event)
                }
            };
            this._mouseOutDelegate = function(event)
            {
                return self._eventHandler.doMouseOut(event)
            };
            this._dblClickDelegate = function(event)
            {
                var sheet = self,
                    i,
                    selectedRange,
                    action;
                var currentTarget = sheet._currentTarget;
                if(sheet._currentTarget)
                {
                    sheet._trigger(UI.Events.CellDoubleClick,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        sheetArea: sheet._currentTarget.hitTestType,
                        row: sheet._currentTarget.row,
                        col: sheet._currentTarget.col
                    });
                    var resizeInfo = currentTarget.resizeInfo;
                    if(resizeInfo)
                    {
                        if(resizeInfo.action === "sizeRow")
                        {
                            var rowList = [];
                            if(sheet._isRowSelected(resizeInfo.index))
                                for(i = 0; i < sheet._selectionModel.length; i++)
                                {
                                    selectedRange = sheet._selectionModel[i];
                                    if(selectedRange.col === -1)
                                    {
                                        selectedRange = sheet._getActualRange(selectedRange);
                                        for(var r = 0; r < selectedRange.rowCount; r++)
                                            rowList.push({row: selectedRange.row + r})
                                    }
                                }
                            else
                                rowList.push({row: resizeInfo.index});
                            action = new UI.UndoRedo.RowAutoFitUndoAction(sheet,rowList,false);
                            sheet._doCommand(action)
                        }
                        else
                        {
                            var columnList = [];
                            if(sheet._isColumnSelected(resizeInfo.index))
                                for(i = 0; i < sheet._selectionModel.length; i++)
                                {
                                    selectedRange = sheet._selectionModel[i];
                                    if(selectedRange.row === -1)
                                    {
                                        selectedRange = sheet._getActualRange(selectedRange);
                                        for(var c = 0; c < selectedRange.colCount; c++)
                                            columnList.push({col: selectedRange.col + c})
                                    }
                                }
                            else
                                columnList.push({col: resizeInfo.index});
                            action = new UI.UndoRedo.ColumnAutoFitUndoAction(sheet,columnList,false);
                            sheet._doCommand(action)
                        }
                        return
                    }
                }
                return self._eventHandler.startEdit(event)
            };
            $(canvas).bind(_mouseDown_gcSheet,this._mouseDownDelegate);
            $(canvas).bind(_mouseMove_gcSheet,this._mouseMoveDelegate);
            $(canvas).bind(_mouseUp_gcSheet,this._mouseUpDelegate);
            $(canvas).bind(_mouseOut_gcSheet,this._mouseOutDelegate);
            $(canvas).bind(_dblclick_gcSheet,this._dblClickDelegate);
            this._mouseWheelDelegate = function(e)
            {
                e = e ? e : window.event;
                var wheelData = e.detail ? e.detail : e.wheelDelta / -40;
                self._eventHandler.doMouseWheel(e,parseInt(wheelData,10));
                UI.cancelDefault(e);
                return false
            };
            $(canvas).bind(_mouseWheel_gcSheet,this._mouseWheelDelegate);
            $(window).unbind(_resize_gcSheet);
            $(window).bind(_resize_gcSheet,UI.createEventHandler(this._eventHandler,this._eventHandler.doResize));
            this._initializeActiveCell();
            this._eventHandler.doResize()
        },
        _disposeValidationUI: function()
        {
            if(this._validationInputMessage)
            {
                $(this._validationInputMessage).remove();
                this._validationInputMessage = null
            }
            if(this._validationButton)
            {
                $(this._validationButton).remove();
                this._validationButton = null
            }
            if(this._validationSelect)
            {
                $(this._validationSelect).remove();
                this._validationSelect = null
            }
        },
        _dispose: function()
        {
            if(this.isEditing())
                this.endEdit();
            var canvas = this._canvas;
            if(canvas)
            {
                $(canvas).unbind(_mouseDown_gcSheet);
                $(canvas).unbind(_mouseMove_gcSheet);
                $(canvas).unbind(_mouseUp_gcSheet);
                $(canvas).unbind(_mouseOut_gcSheet);
                $(canvas).unbind(_dblclick_gcSheet);
                $(canvas).unbind(_mouseWheel_gcSheet);
                canvas.parentNode.removeChild(canvas)
            }
            this._eventHandler._dispose();
            this._canvas = null;
            $(window).unbind(_resize_gcSheet);
            if(this._filterDialiog)
                this._filterDialiog.close();
            if(this._smartTag)
                this._smartTag.close();
            if(this._editor)
                $(this._editor).remove();
            this._disposeValidationUI()
        },
        _getModel: function(sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport)
                return this._dataModel;
            else if(sheetArea === SheetArea.rowHeader)
                return this._rowHeaderModel;
            else if(sheetArea === SheetArea.colHeader)
                return this._colHeaderModel;
            return null
        },
        _getCalcModel: function(sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
                return this._calcDataModel;
            return null
        },
        _getValueImp: function(m, row, col, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport)
                if(this.xSheet)
                    return this.xSheet.getValue(row,col);
            var t = m.getValue(row,col);
            var ko = window.ko;
            if((t === undefined || t === null) && this._dataSource && (sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport))
                if(this._isDataView(this._dataSource))
                {
                    var dataLength = this._dataSource.count();
                    if(row < dataLength)
                    {
                        var drow = this._dataSource.item(row);
                        if(!drow)
                            return null;
                        var ci = this._colInfos[col];
                        if(ci && ci.name && ci.name.length > 0)
                            return this._dataSource.getProperty(drow,ci.name)
                    }
                }
                else if(ko && ko.isObservable(this._dataSource))
                {
                    var dataLength = this._dataSource().length;
                    if(row < dataLength)
                    {
                        var drow = this._dataSource()[row];
                        if(!drow)
                            return null;
                        var ci = this._colInfos[col];
                        if(ci && ci.name && ci.name.length > 0)
                            if(typeof ci.value === const_function)
                                return ci.value(drow);
                            else if(typeof ko !== const_undefined && ko.isObservable(drow[ci.name]))
                                t = drow[ci.name]();
                            else
                                t = drow[ci.name];
                        else if(typeof drow === "string" || !isNaN(drow))
                            if(col === 0)
                                return drow
                    }
                }
                else if(this._isCellBinding(this._dataSource))
                {
                    var path = this.getBindingPath(row,col,sheetArea);
                    if(path)
                        return this._dataSource.getValue(path)
                }
                else
                {
                    var dataLength = this._dataSource.length;
                    if(row < dataLength)
                    {
                        var drow = this._dataSource[row];
                        if(drow === undefined || drow === null)
                            return null;
                        var ci = this._colInfos[col];
                        if(ci && ci.name && ci.name.length > 0)
                            if(typeof ci.value === const_function)
                                return ci.value(drow);
                            else
                            {
                                var ko = window.ko;
                                if(typeof ko !== const_undefined && ko.isObservable(drow[ci.name]))
                                    t = drow[ci.name]();
                                else
                                    t = drow[ci.name]
                            }
                        else if(typeof drow === "string" || !isNaN(drow))
                            if(col === 0)
                                return drow
                    }
                }
            if(typeof t === const_string)
            {
                var x = t.match(_jsonDateRegExp);
                if(x && x.length > 0)
                {
                    x = x[0].substring(6);
                    t = new Date(parseFloat(x))
                }
            }
            return t
        },
        _getSwapIndex: function(array, start, index, count, row)
        {
            var t = array[index - start];
            while(t.index < index)
                t = array[t.index - start];
            return t.index
        },
        _quickSortImp: function(arr)
        {
            if(arr.length <= 1)
                return arr;
            var pivotIndex = Math.floor(arr.length / 2);
            var pivot = arr[pivotIndex];
            var left = [];
            var right = [];
            var equal = [];
            for(var i = 0; i < arr.length; i++)
            {
                var compareResult = this._sortCompare(arr[i],pivot);
                if(compareResult < 0)
                    left.push(arr[i]);
                else if(compareResult > 0)
                    right.push(arr[i]);
                else
                    equal.push(arr[i])
            }
            return this._quickSortImp(left).concat(equal,this._quickSortImp(right))
        },
        _quickSort: function(row, column, rowCount, columnCount, byRows, sortInfo)
        {
            var count = byRows ? rowCount : columnCount;
            var array = [];
            var temp;
            if(byRows)
                for(temp = 0; temp < count; temp++)
                    array[temp] = {
                        sheet: this,
                        index: row + temp,
                        byRows: byRows,
                        sortInfo: sortInfo
                    };
            else
                for(temp = 0; temp < count; temp++)
                    array[temp] = {
                        sheet: this,
                        index: column + temp,
                        byRows: byRows,
                        sortInfo: sortInfo
                    };
            array = this._quickSortImp(array);
            return array
        },
        _isEquals: function(v1, v2)
        {
            if(v1 instanceof Date && v2 instanceof Date)
                return new UI._DateTimeHelper(v1).toOADate() === new UI._DateTimeHelper(v2).toOADate();
            else
                return v1 === v2
        },
        _isGreaterThan: function(v1, v2)
        {
            if(typeof v1 === "boolean")
                v1 = v1 ? 1 : 0;
            else if(v1 instanceof Date)
                v1 = new UI._DateTimeHelper(v1).toOADate();
            if(typeof v2 === "boolean")
                v2 = v2 ? 1 : 0;
            else if(v2 instanceof Date)
                v2 = new UI._DateTimeHelper(v2).toOADate();
            if(typeof v1 !== typeof v2 && (typeof v1 === "number" || typeof v2 === "number"))
                return typeof v2 === "number";
            return v1 > v2
        },
        _sortCompare: function(x, y)
        {
            if(x.sortInfo && x.sortInfo.length > 0)
            {
                var ret = 0,
                    value1,
                    value2,
                    value1IsNullOrEmpty,
                    value2IsNullOrEmpty;
                for(var i = 0; i < x.sortInfo.length; i++)
                {
                    if(x.sortInfo[i])
                    {
                        var ascending = x.sortInfo[i].ascending;
                        var index = x.sortInfo[i].index;
                        if(0 <= index)
                            if(x.byRows)
                            {
                                value1 = x.sheet.getValue(x.index,index);
                                value2 = y.sheet.getValue(y.index,index);
                                value1IsNullOrEmpty = value1 === undefined || value1 === null || value1 === "";
                                value2IsNullOrEmpty = value2 === undefined || value2 === null || value2 === "";
                                if(value1IsNullOrEmpty || value2IsNullOrEmpty)
                                {
                                    if(value1IsNullOrEmpty && value2IsNullOrEmpty)
                                        ret = 0;
                                    else if(value1IsNullOrEmpty && !value2IsNullOrEmpty)
                                        ret = 1;
                                    else if(!value1IsNullOrEmpty && value2IsNullOrEmpty)
                                        ret = -1
                                }
                                else if(this._isEquals(value1,value2))
                                    ret = 0;
                                else if(this._isGreaterThan(value1,value2))
                                    ret = ascending ? 1 : -1;
                                else
                                    ret = ascending ? -1 : 1
                            }
                            else
                            {
                                value1 = x.sheet.getValue(index,x.index);
                                value2 = y.sheet.getValue(index,y.index);
                                value1IsNullOrEmpty = value1 === undefined || value1 === null || value1 === "";
                                value2IsNullOrEmpty = value2 === undefined || value2 === null || value2 === "";
                                if(value1IsNullOrEmpty || value2IsNullOrEmpty)
                                {
                                    if(value1IsNullOrEmpty && value2IsNullOrEmpty)
                                        ret = 0;
                                    else if(value1IsNullOrEmpty && !value2IsNullOrEmpty)
                                        ret = 1;
                                    else if(!value1IsNullOrEmpty && value2IsNullOrEmpty)
                                        ret = -1
                                }
                                else if(this._isEquals(value1,value2))
                                    ret = 0;
                                else if(this._isGreaterThan(value1,value2))
                                    ret = ascending ? 1 : -1;
                                else
                                    ret = ascending ? -1 : 1
                            }
                    }
                    if(ret !== 0)
                        break
                }
                return ret
            }
            return 0
        },
        _getActualRange: function(range, sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            var actualRange = new UI.Range;
            if(range === null || range === undefined)
                return actualRange;
            actualRange.col = range.col;
            actualRange.row = range.row;
            actualRange.colCount = range.colCount;
            actualRange.rowCount = range.rowCount;
            if(actualRange.col === -1)
            {
                actualRange.col = 0;
                actualRange.colCount = this.getColumnCount(sheetArea)
            }
            if(actualRange.row === -1)
            {
                actualRange.row = 0;
                actualRange.rowCount = this.getRowCount(sheetArea)
            }
            return actualRange
        },
        _getRangeRect: function(rowViewportIndex, colViewportIndex, range)
        {
            var layout = this._getSheetLayout();
            var leftCol = 0;
            var topRow = 0;
            var rect = new UI.Rect(layout.frozenX,layout.frozenY,0,0);
            var actualRange = this._getActualRange(range);
            var frozenColCount = isNaN(this.frozenColCount) ? 0 : this.frozenColCount;
            var frozenRowCount = isNaN(this.frozenRowCount) ? 0 : this.frozenRowCount;
            if(colViewportIndex > 0)
            {
                leftCol = Math.max(frozenColCount,this._scrollLeftCol);
                rect.x = layout.viewportX
            }
            if(rowViewportIndex > 0)
            {
                topRow = Math.max(frozenRowCount,this._scrollTopRow);
                rect.y = layout.viewportY
            }
            var row,
                col;
            if(actualRange.col >= leftCol)
            {
                for(col = leftCol; col < actualRange.col; col++)
                    if(this.getColumnVisible(col))
                    {
                        rect.x += this._getZoomColumnWidth(col);
                        if(rect.x > layout.x + layout.width)
                            return rect
                    }
                for(col = actualRange.col; col < actualRange.col + actualRange.colCount; col++)
                    if(this.getColumnVisible(col))
                    {
                        rect.width += this._getZoomColumnWidth(col);
                        if(rect.width + rect.x > layout.x + layout.width)
                            break
                    }
            }
            else if(frozenColCount > 0 && actualRange.col < frozenColCount)
            {
                for(col = frozenColCount - 1; col >= actualRange.col; col--)
                    if(this.getColumnVisible(col))
                    {
                        rect.x -= this._getZoomColumnWidth(col);
                        if(rect.x < layout.x)
                        {
                            col--;
                            break
                        }
                    }
                for(col = actualRange.col; col < Math.min(frozenColCount,actualRange.col + actualRange.colCount); col++)
                    if(this.getColumnVisible(col))
                    {
                        rect.width += this._getZoomColumnWidth(col);
                        if(rect.width + rect.x > layout.x + layout.width)
                            break
                    }
                for(col = leftCol; col < actualRange.col + actualRange.colCount; col++)
                    if(this.getColumnVisible(col))
                    {
                        rect.width += this._getZoomColumnWidth(col);
                        if(rect.width + rect.x > layout.x + layout.width)
                            break
                    }
            }
            else
            {
                for(col = leftCol - 1; col >= actualRange.col; col--)
                    if(this.getColumnVisible(col))
                    {
                        rect.x -= this._getZoomColumnWidth(col);
                        if(rect.x < layout.x)
                        {
                            col--;
                            break
                        }
                    }
                for(col = col + 1; col < actualRange.col + actualRange.colCount; col++)
                    if(this.getColumnVisible(col))
                    {
                        rect.width += this._getZoomColumnWidth(col);
                        if(rect.width + rect.x > layout.x + layout.width)
                            break
                    }
            }
            if(actualRange.row >= topRow)
            {
                for(row = topRow; row < actualRange.row; row++)
                    if(this.getRowVisible(row))
                    {
                        rect.y += this._getZoomRowHeight(row);
                        if(rect.y > layout.y + layout.height)
                            return rect
                    }
                for(row = actualRange.row; row < actualRange.row + actualRange.rowCount; row++)
                    if(this.getRowVisible(row))
                    {
                        rect.height += this._getZoomRowHeight(row);
                        if(rect.height + rect.y > layout.y + layout.height)
                            break
                    }
            }
            else if(frozenRowCount > 0 && actualRange.row < frozenRowCount)
            {
                for(row = frozenRowCount - 1; row >= actualRange.row; row--)
                    if(this.getRowVisible(row))
                    {
                        rect.y -= this._getZoomRowHeight(row);
                        if(rect.y < layout.y)
                        {
                            row--;
                            break
                        }
                    }
                for(row = actualRange.row; row < Math.min(frozenRowCount,actualRange.row + actualRange.rowCount); row++)
                    if(this.getRowVisible(row))
                    {
                        rect.height += this._getZoomRowHeight(row);
                        if(rect.height + rect.y > layout.y + layout.height)
                            break
                    }
                for(row = topRow; row < actualRange.row + actualRange.rowCount; row++)
                    if(this.getRowVisible(row))
                    {
                        rect.height += this._getZoomRowHeight(row);
                        if(rect.height + rect.y > layout.y + layout.height)
                            break
                    }
            }
            else
            {
                for(row = topRow - 1; row >= actualRange.row; row--)
                    if(this.getRowVisible(row))
                    {
                        rect.y -= this._getZoomRowHeight(row);
                        if(rect.y < layout.y)
                        {
                            row--;
                            break
                        }
                    }
                for(row = row + 1; row < actualRange.row + actualRange.rowCount; row++)
                    if(this.getRowVisible(row))
                    {
                        rect.height += this._getZoomRowHeight(row);
                        if(rect.height + rect.y > layout.y + layout.height)
                            break
                    }
            }
            return rect
        },
        _getActiveSelectionRect: function(rowViewportIndex, colViewportIndex)
        {
            return this._getRangeRect(rowViewportIndex,colViewportIndex,this._getActiveSelectedRange())
        },
        _getCanvas: function()
        {
            var c = this._canvas;
            if(!c && this.parent)
                c = this.parent.canvas;
            if(c && !c.getContext && c.firstChild)
                c.getContext = c.firstChild.getContext;
            return c
        },
        _draw: function(ctx, clipRect)
        {
            var ctx2 = this._render._getCtx();
            if(ctx2)
                this._render.paint(ctx2,clipRect)
        },
        _getStringWidth: function(value, font)
        {
            var htmlSpan = this._getEditingSpan();
            htmlSpan.style.font = "";
            if(font)
                htmlSpan.style.font = font;
            else
                htmlSpan.style.font = this._render._getZoomFont(this._render._getDefaultFont());
            value = value + "";
            $(htmlSpan).text(value);
            var spanWidth = htmlSpan.offsetWidth;
            var htmlPre = this._getEditingPre();
            if(font)
                htmlPre.style.font = font;
            else
                htmlPre.style.font = this._render._getZoomFont(this._render._getDefaultFont());
            $(htmlPre).text(value);
            var preWidth = htmlPre.offsetWidth;
            if($.browser.mozilla)
            {
                spanWidth += 3;
                preWidth += 3
            }
            else if($.browser.msie)
            {
                spanWidth += 1;
                preWidth += 1
            }
            return Math.max(spanWidth,preWidth)
        },
        _getFontHeight: function(font)
        {
            var htmlSpan = this._getEditingSpan();
            if(font)
                htmlSpan.style.font = font;
            else
                htmlSpan.style.font = this._render._getDefaultFont();
            htmlSpan.innerHTML = "H";
            return htmlSpan.offsetHeight
        },
        _getEditingSpan: function()
        {
            if(!this._editingSpan)
            {
                var span = document.createElement("span");
                span.style.visibility = _cssHidden;
                span.style.top = "-10000px";
                span.style.left = "-10000px";
                span.style.position = "absolute";
                span.className = "gcStringWidthSpanStyle";
                span.setAttribute("gcUIElement","gcStringWidthSpan");
                document.body.insertBefore(span,null);
                this._editingSpan = span
            }
            return this._editingSpan
        },
        _getEditingPre: function()
        {
            if(!this._editingPre)
            {
                var pre = document.createElement("pre");
                pre.style.visibility = _cssHidden;
                pre.style.top = "-10000px";
                pre.style.left = "-10000px";
                pre.style.position = "absolute";
                pre.className = "gcStringWidthPreStyle";
                pre.setAttribute("gcUIElement","gcStringWidthPre");
                document.body.insertBefore(pre,null);
                this._editingPre = pre
            }
            return this._editingPre
        },
        _getColumnPane: function(x)
        {
            var layout = this._getSheetLayout();
            var colViewportIndex = null;
            if(layout.headerX < x && x < layout.headerX + layout.rowHeaderWidth)
                colViewportIndex = -1;
            else if(layout.frozenX < x && x < layout.frozenX + layout.frozenWidth)
                colViewportIndex = 0;
            else if(layout.viewportX < x && x < layout.viewportX + layout.viewportWidth)
                colViewportIndex = 1;
            return colViewportIndex
        },
        _getRowPane: function(y)
        {
            var layout = this._getSheetLayout();
            var rowViewportIndex = null;
            if(layout.headerY < y && y < layout.headerY + layout.colHeaderHeight)
                rowViewportIndex = -1;
            else if(layout.frozenY < y && y < layout.frozenY + layout.frozenHeight)
                rowViewportIndex = 0;
            else if(layout.viewportY < y && y < layout.viewportY + layout.viewportHeight)
                rowViewportIndex = 1;
            return rowViewportIndex
        },
        _getRowIndex: function(y, rowViewportIndex)
        {
            var rowLayouts = null;
            if(rowViewportIndex === -1)
                rowLayouts = this._getRowLayout(0,UI.SheetArea.colHeader);
            else if(rowViewportIndex === 0)
                rowLayouts = this._getRowLayout(0);
            else
                rowLayouts = this._getRowLayout(1);
            for(var i = 0; i < rowLayouts.length; i++)
            {
                var layout = rowLayouts[i];
                if(layout.y <= y && y < layout.y + layout.height)
                    return layout.row
            }
        },
        _getColumnIndex: function(x, colViewportIndex)
        {
            var colLayouts = null;
            if(colViewportIndex === -1)
                colLayouts = this._getColumnLayout(0,UI.SheetArea.rowHeader);
            else if(colViewportIndex === 0)
                colLayouts = this._getColumnLayout(0);
            else
                colLayouts = this._getColumnLayout(1);
            for(var i = 0; i < colLayouts.length; i++)
            {
                var layout = colLayouts[i];
                if(layout.x <= x && x < layout.x + layout.width)
                    return layout.col
            }
        },
        _isActiveCell: function(r, c)
        {
            return this._activeRowIndex <= r && r < this._activeRowIndex + this._activeRowCount && this._activeColIndex <= c && c < this._activeColIndex + this._activeColCount
        },
        _isColumnSelected: function(c)
        {
            for(var i = 0; i < this._selectionModel.length; i++)
            {
                var selectedRange = this._selectionModel[i];
                var col = selectedRange.col === -1 ? 0 : selectedRange.col;
                if(selectedRange.row === -1 && c >= col && c < col + selectedRange.colCount)
                    return true
            }
            return false
        },
        _isRowSelected: function(r)
        {
            for(var i = 0; i < this._selectionModel.length; i++)
            {
                var selectedRange = this._selectionModel[i];
                var row = selectedRange.row === -1 ? 0 : selectedRange.row;
                if(selectedRange.col === -1 && r >= row && r < row + selectedRange.rowCount)
                    return true
            }
            return false
        },
        _isSelected: function(r, c, sheetArea)
        {
            var selected = false;
            for(var i = 0; i < this._selectionModel.length; i++)
            {
                var cr = this._selectionModel[i];
                var span = this._spanModel.find(cr.row,cr.col);
                if(span && span.containsRange(cr))
                    cr = span;
                var selectedRange = this._getActualRange(cr);
                var SheetArea = UI.SheetArea;
                if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport)
                    selected = selectedRange.row <= r && r < selectedRange.row + selectedRange.rowCount && selectedRange.col <= c && c < selectedRange.col + selectedRange.colCount;
                else if(sheetArea === SheetArea.rowHeader)
                    selected = r === this._activeRowIndex || selectedRange.row <= r && r < selectedRange.row + selectedRange.rowCount;
                else if(sheetArea === SheetArea.colHeader || sheetArea === SheetArea.colFooter)
                    selected = c === this._activeColIndex || selectedRange.col <= c && c < selectedRange.col + selectedRange.colCount || c < 0 && selectedRange.row === 0 && selectedRange.col === 0 && selectedRange.rowCount === this.getRowCount() && selectedRange.colCount === this.getColumnCount();
                else if(sheetArea === SheetArea.corner)
                    selected = selectedRange.row === -1 && selectedRange.col === -1 && selectedRange.rowCount === this.getRowCount() && selectedRange.colCount === this.getColumnCount();
                if(selected)
                    return selected
            }
            return selected
        },
        _isAllSelected: function(r, c, sheetArea)
        {
            var selected = false;
            var sheetRowCount = this.getRowCount();
            var sheetColCount = this.getColumnCount();
            var SheetArea = UI.SheetArea;
            for(var i = 0; i < this._selectionModel.length; i++)
            {
                var selectedRange = this._selectionModel[i];
                if(sheetArea !== undefined && sheetArea !== null && sheetArea !== SheetArea.viewport)
                    if(sheetArea === SheetArea.rowHeader)
                    {
                        var row = selectedRange.row === -1 ? 0 : selectedRange.row;
                        selected = selectedRange.col === -1 && r >= row && r < row + selectedRange.rowCount
                    }
                    else if(sheetArea === SheetArea.colHeader || sheetArea === SheetArea.colFooter)
                    {
                        var col = selectedRange.col === -1 ? 0 : selectedRange.col;
                        selected = selectedRange.row === -1 && c >= col && c < col + selectedRange.colCount
                    }
                    else if(sheetArea === SheetArea.corner)
                        selected = selectedRange.row === -1 && selectedRange.col === -1 && selectedRange.rowCount === sheetRowCount && selectedRange.colCount === sheetColCount;
                if(selected)
                    return selected
            }
            return selected
        },
        _isHover: function(r, c, sheetArea)
        {
            var ishover = false;
            var target = this._currentTarget;
            var SheetArea = UI.SheetArea;
            if(this._currentTarget && sheetArea !== undefined && sheetArea !== null)
                if(sheetArea === SheetArea.colHeader)
                {
                    var inSpans = false,
                        span = this._colHeaderSpanModel.find(target.row,target.col);
                    if(span)
                        inSpans = span.contains(r,c,1,1);
                    var hovered = r === target.row && c === target.col || inSpans;
                    return target.hitTestType === sheetArea && hovered
                }
                else if(sheetArea === SheetArea.rowHeader)
                {
                    var inSpans = false,
                        span = this._rowHeaderSpanModel.find(target.row,target.col);
                    if(span)
                        inSpans = span.contains(r,c,1,1);
                    var hovered = r === target.row && c === target.col || inSpans;
                    return target.hitTestType === sheetArea && hovered
                }
                else if(sheetArea === SheetArea.colFooter)
                    return target.hitTestType === sheetArea && r === target.row && c === target.col;
                else if(sheetArea === SheetArea.viewport)
                    return target.hitTestType === sheetArea && r === target.row && c === target.col;
                else if(sheetArea === SheetArea.corner)
                    return target.hitTestType === sheetArea;
            return ishover
        },
        _indexToLetters: function(index)
        {
            var t = "A";
            var aCode = t.charCodeAt(0);
            var sb = "";
            for(; index > 0; index = (index - 1) / 26)
            {
                var n = parseInt((index - 1) % 26,10);
                if(index === 1 || n >= 0 && index > 1)
                    sb = String.fromCharCode(aCode + n) + sb
            }
            return sb
        },
        _doStartEdit: function(canvas, x, y)
        {
            var target = this.hitTest(x,y);
            if(!target)
                return;
            if(target.row >= 0 && target.col >= 0 && target.rowViewportIndex >= 0 && target.colViewportIndex >= 0 && !target.resizeInfo && !target.dragInfo && target.row === this._activeRowIndex && target.col === this._activeColIndex)
            {
                var isEditing = this.isEditing();
                this._startEditImp(canvas,target.row,target.col);
                if(!isEditing && this.isEditing())
                {
                    var r = target.row,
                        c = target.col,
                        sheetArea = target.hitTestType;
                    var ct = this.getCellType(target.row,target.col);
                    if(ct._triggerButtonClicked)
                    {
                        var cellRect = this.getCellRect(r,c);
                        var cellStyle = this.getActualStyle(r,c,sheetArea);
                        var info = ct.getHitInfo(x,y,r,c,cellStyle,cellRect,sheetArea);
                        if(info && info.isReservedLocation)
                            ct._triggerButtonClicked(this,r,c)
                    }
                }
            }
        },
        _getSheetAreaFromHitTest: function(target)
        {
            var sheetArea = null;
            var SheetArea = UI.SheetArea;
            if(!(target.rowViewportIndex === 2 && target.colViewportIndex < 0))
                if(target.rowViewportIndex < 0 && target.colViewportIndex < 0)
                    sheetArea = SheetArea.corner;
                else if(target.rowViewportIndex < 0 && target.colViewportIndex >= 0)
                    sheetArea = SheetArea.colHeader;
                else if(target.rowViewportIndex >= 0 && target.rowViewportIndex < 2 && target.colViewportIndex < 0)
                    sheetArea = SheetArea.rowHeader;
                else if(target.rowViewportIndex >= 0 && target.rowViewportIndex < 2 && target.colViewportIndex >= 0)
                    sheetArea = SheetArea.viewport;
            return sheetArea
        },
        _startEditImp: function(canvas, row, col, rowViewportIndex, colViewportIndex, selectAll, defaultText)
        {
            if(this.isEditing())
                return;
            if(this.getRowHeight(row) <= 0 || this.getColumnWidth(col) <= 0)
                return;
            this.showCell(this._activeRowIndex,this._activeColIndex,UI.VerticalPosition.nearest,UI.HorizontalPosition.nearest);
            var cellStyle = this.getActualStyle(row,col);
            if(this.isProtected && cellStyle.locked !== false)
                return;
            var r = row;
            var c = col;
            if(r >= 0 && c >= 0)
            {
                this._activeRowIndex = r;
                this._activeColIndex = c;
                var ct = this.getCellType(row,col);
                if(!ct)
                    return;
                var editor = ct.createEditorElement();
                if(!editor)
                    return;
                this._editor = editor;
                Object.defineProperty(editor,"sheet",{
                    value: this,
                    writable: false
                });
                var args = {
                        sheet: this,
                        sheetName: this._name,
                        row: r,
                        col: c,
                        cancel: false
                    };
                this._trigger(UI.Events.EditStarting,args);
                if(args && args.cancel === true)
                    return;
                var v = this.getValue(r,c),
                    f = this.getFormula(r,c);
                var oldStatus = this._editorStatus;
                if(this._startEditByKeydown)
                    this._editorStatus = UI.EditorStatus.Enter;
                else if((v === null || v === undefined) && (f === null || f === undefined))
                    this._editorStatus = UI.EditorStatus.Enter;
                else
                    this._editorStatus = UI.EditorStatus.Edit;
                this._trigger(UI.Events.EditorStatusChanged,{
                    sheet: this,
                    sheetName: this._name,
                    oldStatus: oldStatus,
                    newStatus: this._editorStatus
                });
                var cellRect = this.getCellRect(r,c,rowViewportIndex,colViewportIndex);
                var sheetLayout = this._getSheetLayout();
                var curstyle = canvas.currentStyle;
                if(document.defaultView && document.defaultView.getComputedStyle)
                    curstyle = document.defaultView.getComputedStyle(canvas,'');
                if(!curstyle)
                    curstyle = canvas.style;
                if(curstyle.borderTopWidth !== undefined && curstyle.borderTopWidth !== null && !isNaN(curstyle.borderTopWidth))
                    cellRect.y += parseFloat(curstyle.borderTopWidth);
                if(curstyle.borderLeftWidth !== undefined && curstyle.borderLeftWidth !== null && !isNaN(curstyle.borderLeftWidth))
                    cellRect.x += parseFloat(curstyle.borderLeftWidth);
                ct.activateEditor(this._editor,cellStyle,cellRect);
                var t = this.getFormula(r,c);
                if(t)
                    t = "=" + t;
                var actualValue = t;
                if(!t || t.length === 0)
                {
                    t = this.getValue(r,c);
                    if(t && t.length > 0 && /^=/ig.test(t))
                        t = "'" + t;
                    actualValue = t;
                    t = ct._formatEditorValue(this._editor,cellStyle,t)
                }
                if(defaultText !== null && defaultText !== undefined)
                    t = defaultText;
                ct.setEditorValue(this._editor, t);
                this._editor._oldValue = t;
                this._editor._originalValue = actualValue;
                ct.updateEditor(this._editor,cellStyle,cellRect);
                var colHeader = UI.SheetArea.colHeader,
                    rowHeader = UI.SheetArea.rowHeader;
                if(this.showEditingLocator)
                {
                    var locator = ct._getLocator();
                    editor._editingLocator = locator;
                    var colHeaderText = this.getValue(this._getModel(colHeader).rowCount - 1,col,colHeader);
                    var rowHeaderText = this.getValue(row,this._getModel(rowHeader).colCount - 1,rowHeader);
                    locator.innerHTML = colHeaderText + "" + rowHeaderText;
                    ct._updateEditorLocator(this._editor);
                    document.body.insertBefore(locator,null)
                }
                ct.focus(this._editor);
                if(selectAll)
                    ct.selectAll(this._editor);
                var crect = this.getCellRect(row,col,rowViewportIndex,colViewportIndex);
                crect.x -= 2;
                crect.y -= 2;
                crect.width += 4;
                crect.height += 4;
                if(this._allowCellOverflow)
                {
                    crect.x = sheetLayout.frozenX;
                    crect.width = sheetLayout.viewportWidth
                }
                this.repaint(crect);
                window.gcGlobal.activeElement = this
            }
        },
        _showEditingLocator: function()
        {
            if(this.isEditing() === false)
                return;
            if(this._editor && this._editor._editingLocator)
            {
                var editor = $(this._editor);
                var x = parseInt(editor.css(_cssLeft),10) + this.getColumnWidth(this._activeColIndex) / 2,
                    y = parseInt(editor.css(_cssTop),10) + this.getRowHeight(this._activeRowIndex) / 2;
                var t = $(this._getCanvas()).offset();
                x -= t.left;
                y -= t.top;
                var row = this._getRowIndex(y,this._getRowPane(y));
                var col = this._getColumnIndex(x,this._getColumnPane(x));
                if(row === this._activeRowIndex && col === this._activeColIndex)
                    $(this._editor._editingLocator).css(cssVisibility,_cssHidden);
                else
                    $(this._editor._editingLocator).css(cssVisibility,"visible")
            }
        },
        _getKeyAction: function(keyCode, ctrl, shift, alt)
        {
            if(!this.keyMap)
                return null;
            var n = this.keyMap.length;
            for(var i = 0; i < n; i++)
            {
                var ka = this.keyMap[i];
                if(ka && ka.key === keyCode && ka.ctrl === ctrl && ka.shift === shift && ka.alt === alt)
                    return ka
            }
            return null
        },
        _moveActiveCellUp: function(r, c, wrap, checkTab, checkFocus)
        {
            if(r === 0 && !wrap)
                return;
            var rc = this.getRowCount();
            var cc = this.getColumnCount();
            if(this._leadingCellCol === undefined || this._leadingCellCol === null)
                this._leadingCellCol = 0;
            var cell = this._getPrevRow(r,this._leadingCellCol,checkTab,checkFocus);
            if(!wrap)
                this._adjustCell(cell);
            r = cell.r;
            c = cell.c;
            if(r < 0 && wrap)
            {
                c = this._getPrevVisualColumn(c);
                if(c < 0 || c === undefined || c === null)
                    c = this._getPrevVisualColumn(cc);
                this._leadingCellCol = c;
                cell = this._getPrevRow(rc,c,checkTab,checkFocus);
                r = cell.r;
                c = cell.c
            }
            if(this._canMoveCurrentTo(r,c))
            {
                this._leadingCellRow = r;
                this._activeRowIndex = r;
                this._activeColIndex = c
            }
        },
        _moveActiveCellDown: function(r, c, wrap, checkTab, checkFocus)
        {
            var rc = this.getRowCount();
            var cc = this.getColumnCount();
            if(r === rc - 1 && !wrap)
                return;
            if(this._leadingCellCol === undefined || this._leadingCellCol === null)
                this._leadingCellCol = 0;
            var cell = this._getNextRow(r,this._leadingCellCol,checkTab,checkFocus);
            if(!wrap)
                this._adjustCell(cell);
            r = cell.r;
            c = cell.c;
            if(r === rc && wrap)
            {
                c = this._getNextVisualColumn(c);
                if(c >= cc || c === undefined || c === null)
                    c = this._getNextVisualColumn(-1);
                this._leadingCellCol = c;
                cell = this._getNextRow(-1,c,checkTab,checkFocus);
                r = cell.r;
                c = cell.c
            }
            if(this._canMoveCurrentTo(r,c))
            {
                this._leadingCellRow = r;
                this._activeRowIndex = r;
                this._activeColIndex = c
            }
        },
        _moveActiveCellLeft: function(r, c, wrap, checkTab, checkFocus)
        {
            if(c === 0 && !wrap)
                return;
            var rc = this.getRowCount();
            var cc = this.getColumnCount();
            if(this._leadingCellRow === undefined || this._leadingCellRow === null)
                this._leadingCellRow = 0;
            var cell = this._getPrevColumn(this._leadingCellRow,c,checkTab,checkFocus);
            if(!wrap)
                this._adjustCell(cell);
            r = cell.r;
            c = cell.c;
            if(c < 0 && wrap)
            {
                r = this._getPrevVisualRow(r);
                if(r < 0 || r === undefined || r === null)
                    r = this._getPrevVisualRow(rc);
                this._leadingCellRow = r;
                cell = this._getPrevColumn(r,cc,checkTab,checkFocus);
                r = cell.r;
                c = cell.c
            }
            if(this._canMoveCurrentTo(r,c))
            {
                this._leadingCellCol = c;
                this._activeRowIndex = r;
                this._activeColIndex = c
            }
        },
        _adjustCell: function(cell)
        {
            if(cell.r < 0)
                cell.r = this._getFirstVisualRow();
            else if(cell.r >= this.getRowCount())
                cell.r = this._getLastVisualRow();
            if(cell.c < 0)
                cell.c = this._getFirstVisualColumn();
            else if(cell.c >= this.getColumnCount())
                cell.c = this._getLastVisualColumn()
        },
        _fixRange: function(range)
        {
            var r = range.row < 0 ? 0 : range.row,
                c = range.col < 0 ? 0 : range.col,
                rc = range.row < 0 ? this.getRowCount() : range.rowCount,
                cc = range.col < 0 ? this.getColumnCount() : range.colCount;
            return new UI.Range(r,c,rc,cc)
        },
        _moveActiveCellLeftInSelection: function(r, c)
        {
            var activeRange = this._fixRange(this._getActiveSelectedRange());
            var beginRowIndex = activeRange.row;
            var beginColIndex = activeRange.col;
            var endColIndex = activeRange.col + activeRange.colCount - 1;
            var cell = this._getPrevColumnInSelection(r,c,false,false);
            r = cell.r;
            c = cell.c;
            if(c < beginColIndex)
            {
                r -= 1;
                if(r < beginRowIndex)
                {
                    activeRange = this._fixRange(this._getActiveSelectedRange(UI.Direction.left));
                    var row = activeRange.row + activeRange.rowCount - 1;
                    var col = activeRange.col + activeRange.colCount;
                    if(col < this._scrollLeftCol)
                        this._scrollLeftCol = col;
                    else if(col > this._getPageRightColumn())
                    {
                        this._scrollLeftCol = col;
                        this._setLeftColumn(this._getPrevPageLeftColumn())
                    }
                    if(row < this._scrollTopRow)
                        this._setTopRow(row);
                    else if(row > this._getPageBottomRow())
                    {
                        this._scrollTopRow = row;
                        this._setTopRow(this._getPrevPageTopRow())
                    }
                    this._moveActiveCellLeftInSelection(row,col);
                    return
                }
                this._moveActiveCellLeftInSelection(r,endColIndex + 1);
                return
            }
            if(r >= 0)
            {
                this._activeRowIndex = r;
                this._activeColIndex = c;
                this._leadingCellRow = r;
                this._leadingCellCol = c
            }
        },
        _moveActiveCellRightInSelection: function(r, c)
        {
            var activeRange = this._fixRange(this._getActiveSelectedRange());
            var beginColIndex = activeRange.col;
            var endRowIndex = activeRange.row + activeRange.rowCount - 1;
            var endColIndex = activeRange.col + activeRange.colCount - 1;
            var cell = this._getNextColumnInSelection(r,c,false,false);
            r = cell.r;
            c = cell.c;
            if(c > endColIndex)
            {
                r += 1;
                if(r > endRowIndex)
                {
                    activeRange = this._fixRange(this._getActiveSelectedRange(UI.Direction.right));
                    var row = activeRange.row;
                    var col = activeRange.col;
                    if(col < this._scrollLeftCol)
                        this._setLeftColumn(this._getNextVisualColumn(col - 1));
                    else if(col > this._getPageRightColumn())
                    {
                        this._scrollLeftCol = col;
                        this._setLeftColumn(this._getPrevPageLeftColumn())
                    }
                    if(row < this._scrollTopRow)
                        this._setTopRow(this._getNextVisualRow(row - 1));
                    else if(row > this._getPageBottomRow())
                    {
                        this._scrollTopRow = row;
                        this._setTopRow(this._getPrevPageTopRow())
                    }
                    this._moveActiveCellRightInSelection(row,col - 1);
                    return
                }
                this._moveActiveCellRightInSelection(r,beginColIndex - 1);
                return
            }
            if(r >= 0)
            {
                this._activeRowIndex = r;
                this._activeColIndex = c;
                this._leadingCellRow = r;
                this._leadingCellCol = c
            }
        },
        _moveActiveCellRight: function(r, c, wrap, checkTab, checkFocus)
        {
            var rc = this.getRowCount();
            var cc = this.getColumnCount();
            if(c === cc - 1 && !wrap)
                return;
            if(this._leadingCellRow === undefined || this._leadingCellRow === null)
                this._leadingCellRow = 0;
            var cell = this._getNextColumn(this._leadingCellRow,c,checkTab,checkFocus);
            if(!wrap)
                this._adjustCell(cell);
            r = cell.r;
            c = cell.c;
            if(c === cc && wrap)
            {
                r = this._getNextVisualRow(r);
                if(r >= rc || r === undefined || r === null)
                    r = this._getNextVisualRow(-1);
                this._leadingCellRow = r;
                cell = this._getNextColumn(r,-1,checkTab,checkFocus);
                r = cell.r;
                c = cell.c
            }
            if(this._canMoveCurrentTo(r,c))
            {
                this._leadingCellCol = c;
                this._activeRowIndex = r;
                this._activeColIndex = c
            }
        },
        _getPrevColumn: function(r, c, checkTab, checkFocus)
        {
            var startPosition = {
                    r: r,
                    c: c
                };
            while(c >= 0)
            {
                c--;
                if(c < 0)
                    break;
                var spans = this.getSpans(new UI.Range(r,c,1,1));
                if(spans && spans.length > 0)
                {
                    var span = spans[0];
                    if(c >= span.col)
                    {
                        c = span.col;
                        r = span.row
                    }
                }
                if(this._canMoveCurrentTo(r,c,startPosition))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _getPrevColumnInSelection: function(r, c, checkTab, checkFocus)
        {
            while(c >= 0)
            {
                c--;
                if(c < 0)
                    break;
                var span = this._spanModel.find(r,c);
                if(span)
                {
                    var activeSelectedRange = this._getActiveSelectedRange();
                    if(activeSelectedRange.row <= span.row && span.row + span.rowCount <= activeSelectedRange.row + activeSelectedRange.rowCount && activeSelectedRange.col <= span.col && span.col + span.colCount <= activeSelectedRange.col + activeSelectedRange.colCount)
                    {
                        if(!(span.row === r && span.col === c))
                            continue
                    }
                    else
                        continue;
                    if(c >= span.col)
                    {
                        c = span.col;
                        r = span.row
                    }
                }
                if(this._canMoveCurrentTo(r,c))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _getNextColumn: function(r, c, checkTab, checkFocus)
        {
            var colCount = this.getColumnCount();
            var startPosition = {
                    r: r,
                    c: c
                };
            while(c < colCount)
            {
                var currentSpan = this._spanModel.find(r,c);
                if(!currentSpan)
                    c++;
                else
                    c += currentSpan.colCount;
                if(c >= colCount)
                    break;
                var spans = this.getSpans(new UI.Range(r,c,1,1));
                if(spans && spans.length > 0)
                {
                    var span = spans[0];
                    if(c > span.col)
                        c = Math.max(c,span.col + span.colCount);
                    else
                        r = span.row
                }
                if(this._canMoveCurrentTo(r,c,startPosition))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _getNextColumnInSelection: function(r, c, checkTab, checkFocus)
        {
            var colCount = this.getColumnCount();
            while(c < colCount)
            {
                var currentSpan = this._spanModel.find(r,c);
                if(!currentSpan)
                    c++;
                else
                    c += currentSpan.colCount;
                if(c >= colCount)
                    break;
                var span = this._spanModel.find(r,c);
                if(span)
                {
                    var activeSelectedRange = this._getActiveSelectedRange();
                    if(activeSelectedRange.row <= span.row && span.row + span.rowCount <= activeSelectedRange.row + activeSelectedRange.rowCount && activeSelectedRange.col <= span.col && span.col + span.colCount <= activeSelectedRange.col + activeSelectedRange.colCount)
                    {
                        if(!(span.row === r && span.col === c))
                            continue
                    }
                    else
                        continue;
                    if(c > span.col)
                        c = Math.max(c,span.col + span.colCount);
                    else
                        r = span.row
                }
                if(this._canMoveCurrentTo(r,c))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _canMoveCurrentTo: function(r, c, startPosition)
        {
            var canMove = false;
            var rowVisible = this.getRowVisible(r);
            var colVisible = this.getColumnVisible(c);
            var rowHeight = this._getZoomRowHeight(r);
            var colWidth = this._getZoomColumnWidth(c);
            canMove = r >= 0 && r < this.getRowCount() && c >= 0 && c < this.getColumnCount() && rowVisible && colVisible && rowHeight > 0 && colWidth > 0;
            return canMove
        },
        _getPrevRow: function(r, c, checkTab, checkFocus)
        {
            var startPosition = {
                    r: r,
                    c: c
                };
            while(r >= 0)
            {
                r--;
                if(r < 0)
                    break;
                var spans = this.getSpans(new UI.Range(r,c,1,1));
                if(spans && spans.length > 0)
                {
                    var span = spans[0];
                    if(r >= span.row)
                    {
                        r = span.row;
                        c = span.col
                    }
                }
                if(this._canMoveCurrentTo(r,c,startPosition))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _getNextRow: function(r, c, checkTab, checkFocus)
        {
            var rowCount = this.getRowCount();
            var startPosition = {
                    r: r,
                    c: c
                };
            while(r < rowCount)
            {
                var currentSpan = this._spanModel.find(r,c);
                if(!currentSpan)
                    r++;
                else
                    r += currentSpan.rowCount;
                if(r >= rowCount)
                    break;
                var spans = this.getSpans(new UI.Range(r,c,1,1));
                if(spans && spans.length > 0)
                {
                    var span = spans[0];
                    if(r > span.row)
                        r = Math.max(r,span.row + span.rowCount);
                    else
                        c = span.col
                }
                if(this._canMoveCurrentTo(r,c,startPosition))
                    return{
                            r: r,
                            c: c
                        }
            }
            return{
                    r: r,
                    c: c
                }
        },
        _setSelectedRange: function(r, c, rc, cc, repaint)
        {
            this._selectionModel.add(r,c,rc,cc);
            if(repaint)
                this._render.repaintSelection()
        },
        _extendSelectedRange: function(r, c, repaint)
        {
            var extendedRange = this._getExtendedRange(r,c);
            var newRow = extendedRange.row,
                newCol = extendedRange.col,
                newRowCount = extendedRange.rowCount,
                newColCount = extendedRange.colCount;
            var selectionPolicy = this.selectionPolicy(),
                selectionUnit = this.selectionUnit();
            if(selectionPolicy === UI.SelectionPolicy.Single)
                return;
            else if(selectionPolicy === UI.SelectionPolicy.Range)
                this._selectionModel.clear();
            if(selectionUnit === UI.SelectionUnit.Row)
            {
                newCol = -1;
                newColCount = -1
            }
            else if(selectionUnit === UI.SelectionUnit.Column)
            {
                newRow = -1;
                newRowCount = -1
            }
            this._replaceActiveSelectedRange(newRow,newCol,newRowCount,newColCount,repaint)
        },
        _getExtendedRange: function(r, c)
        {
            var anchorRange = new UI.Range(this._activeRowIndex,this._activeColIndex,1,1);
            var spanAnchorRange = this._spanModel.find(this._activeRowIndex,this._activeColIndex);
            if(spanAnchorRange)
                anchorRange = spanAnchorRange;
            var endRange = new UI.Range(r,c,1,1);
            var spanEndRange = this._spanModel.find(r,c);
            if(spanEndRange)
                endRange = spanEndRange;
            var extendedRange = anchorRange.union(endRange);
            var spans = this.getSpans();
            if(spans && spans.length > 0)
                extendedRange = this._inflateRangeToCoverSpans(spans,extendedRange);
            return extendedRange
        },
        _replaceActiveSelectedRange: function(r, c, rc, cc, repaint)
        {
            var oldSelectedRange = this._getActiveSelectedRange();
            if(this._selectionModel.length > 0)
                this._selectionModel.splice(this._selectionModel.activeSelectedRangeIndex,1,new UI.Range(r,c,rc,cc));
            else
                this._selectionModel.add(r,c,rc,cc);
            if(repaint)
            {
                var newSelectedRange = this._getActiveSelectedRange();
                if(newSelectedRange.row === oldSelectedRange.row && newSelectedRange.col === oldSelectedRange.col && newSelectedRange.rowCount === oldSelectedRange.rowCount && newSelectedRange.colCount === oldSelectedRange.colCount)
                    return;
                var render = this._render;
                if(oldSelectedRange.containsRange(newSelectedRange))
                    render.repaintSelection(oldSelectedRange);
                else if(newSelectedRange.containsRange(oldSelectedRange))
                    render.repaintSelection(newSelectedRange);
                else
                {
                    render.repaintSelection(oldSelectedRange);
                    render.repaintSelection(newSelectedRange)
                }
            }
        },
        _changeActiveSelectedRange: function(key, isCtrl)
        {
            if(this._selectionModel.length <= 0)
                return;
            var oldActiveRange = this._getActiveSelectedRange();
            var activeRange = new UI.Range(oldActiveRange.row,oldActiveRange.col,oldActiveRange.rowCount,oldActiveRange.colCount);
            if(activeRange.row < 0)
            {
                activeRange.row = 0;
                activeRange.rowCount = this.getRowCount()
            }
            if(activeRange.col < 0)
            {
                activeRange.col = 0;
                activeRange.colCount = this.getColumnCount()
            }
            var newRange = null;
            var Key = UI.Key;
            if(key === Key.left)
                newRange = isCtrl ? this._searchSelectedRangebyLeftCtrl(activeRange) : this._searchSelectedRangebyLeft(activeRange);
            else if(key === Key.right)
                newRange = isCtrl ? this._searchSelectedRangebyRightCtrl(activeRange) : this._searchSelectedRangebyRight(activeRange);
            else if(key === Key.up)
                newRange = isCtrl ? this._searchSelectedRangebyUpCtrl(activeRange) : this._searchSelectedRangebyUp(activeRange);
            else if(key === Key.down)
                newRange = isCtrl ? this._searchSelectedRangebyDownCtrl(activeRange) : this._searchSelectedRangebyDown(activeRange);
            else if(key === Key.home)
                newRange = isCtrl ? this._searchSelectedRangebyHomeCtrl(activeRange) : this._searchSelectedRangebyHome(activeRange);
            else if(key === Key.end)
                newRange = isCtrl ? this._searchSelectedRangebyEndCtrl(activeRange) : this._searchSelectedRangebyEnd(activeRange);
            else if(key === Key.pup)
                newRange = this._searchSelectedRangebyPageUp(activeRange);
            else if(key === Key.pdn)
                newRange = this._searchSelectedRangebyPageDown(activeRange);
            if(newRange)
            {
                if(oldActiveRange.row < 0)
                {
                    newRange.row = -1;
                    newRange.rowCount = -1
                }
                if(oldActiveRange.col < 0)
                {
                    newRange.col = -1;
                    newRange.colCount = -1
                }
                var oldSelections = this._selectionModel.toArray();
                var newRow = newRange.row,
                    newCol = newRange.col,
                    newRowCount = newRange.rowCount,
                    newColCount = newRange.colCount;
                var selectionPolicy = this.selectionPolicy(),
                    selectionUnit = this.selectionUnit();
                if(selectionPolicy === UI.SelectionPolicy.Single)
                    return;
                else if(selectionPolicy === UI.SelectionPolicy.Range)
                    this._selectionModel.clear();
                if(selectionUnit === UI.SelectionUnit.Row)
                {
                    newCol = -1;
                    newColCount = -1
                }
                else if(selectionUnit === UI.SelectionUnit.Column)
                {
                    newRow = -1;
                    newRowCount = -1
                }
                this._replaceActiveSelectedRange(newRow,newCol,newRowCount,newColCount,true);
                var newSelections = this._selectionModel.toArray();
                if(this._eventHandler._notEqualSelecions(oldSelections,newSelections))
                {
                    var E = UI.Events;
                    this._trigger(E.SelectionChanging,{
                        sheet: this,
                        sheetName: this._name,
                        oldSelections: oldSelections,
                        newSelections: newSelections
                    });
                    this._trigger(E.SelectionChanged,{
                        sheet: this,
                        sheetName: this._name
                    })
                }
            }
        },
        _searchSelectedRangebyLeft: function(activeRange)
        {
            var beginCol = activeRange.col + activeRange.colCount - 1;
            var endCol = 0;
            var startPosition = {
                    r: activeRange.row + activeRange.rowCount - 1,
                    c: beginCol
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginCol > endCol)
            {
                beginCol--;
                if(!this._canMoveCurrentTo(startPosition.r,beginCol,startPosition))
                    continue;
                extendedRange = this._getExtendedRange(startPosition.r,beginCol);
                row = Math.min(activeRange.row,extendedRange.row);
                col = Math.min(activeRange.col,extendedRange.col);
                row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.min(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                if(!(row === activeRange.row && col === activeRange.col && rowCount === activeRange.rowCount && colCount === activeRange.colCount))
                {
                    var newLeftCol = this._getPrevVisualColumn(this._scrollLeftCol);
                    if(col === newLeftCol || col2 === newLeftCol)
                        this._setLeftColumn(newLeftCol);
                    return new UI.Range(row,col,rowCount,colCount)
                }
            }
            return null
        },
        _searchSelectedRangebyLeftCtrl: function(activeRange, isHomeKey)
        {
            var firstCol = this.frozenColCount ? this._getNextVisualColumn(this.frozenColCount - 1) : this._getFirstVisualColumn();
            var beginCol = isHomeKey ? firstCol : this._getFirstVisualColumn();
            if(beginCol === undefined || beginCol === null)
                return;
            else if(this.frozenColCount <= 0 || isHomeKey)
                this._setLeftColumn(beginCol);
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(activeRange.row,beginCol);
            row = Math.min(activeRange.row,extendedRange.row);
            col = Math.min(activeRange.col,extendedRange.col);
            row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.min(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _searchSelectedRangebyRight: function(activeRange)
        {
            var beginCol = activeRange.col;
            var endCol = this.getColumnCount() - 1;
            var startPosition = {
                    r: activeRange.row + activeRange.rowCount - 1,
                    c: beginCol
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginCol < endCol)
            {
                beginCol++;
                if(!this._canMoveCurrentTo(startPosition.r,beginCol,startPosition))
                    continue;
                extendedRange = this._getExtendedRange(startPosition.r,beginCol);
                row = Math.min(activeRange.row,extendedRange.row);
                col = Math.max(activeRange.col,extendedRange.col);
                row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                if(!(row === activeRange.row && col === activeRange.col && rowCount === activeRange.rowCount && colCount === activeRange.colCount))
                {
                    var firstCol = this.frozenColCount ? this._getNextVisualColumn(this.frozenColCount - 1) : null;
                    var pageRightCol = this._getPageRightColumn();
                    if(firstCol !== undefined && firstCol !== null && (col === firstCol || col2 === firstCol))
                        this._setLeftColumn(firstCol);
                    else if(col === pageRightCol || col2 === pageRightCol)
                        this._setLeftColumn(this._getNextVisualColumn(this._scrollLeftCol));
                    return new UI.Range(row,col,rowCount,colCount)
                }
            }
            return null
        },
        _searchSelectedRangebyRightCtrl: function(activeRange)
        {
            var newPageLeftCol = this._getLastPageLeftColumn();
            if(newPageLeftCol === undefined || newPageLeftCol === null)
                return;
            else
                this._setLeftColumn(newPageLeftCol);
            var endCol = this._getLastVisualColumn();
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(activeRange.row,endCol);
            row = Math.min(activeRange.row,extendedRange.row);
            col = Math.max(activeRange.col,extendedRange.col);
            row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _searchSelectedRangebyUp: function(activeRange)
        {
            var beginRow = activeRange.row + activeRange.rowCount - 1;
            var endRow = 0;
            var startPosition = {
                    r: beginRow,
                    c: activeRange.col + activeRange.colCount - 1
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginRow > endRow)
            {
                beginRow--;
                if(!this._canMoveCurrentTo(beginRow,startPosition.c,startPosition))
                    continue;
                extendedRange = this._getExtendedRange(beginRow,startPosition.c);
                row = Math.min(activeRange.row,extendedRange.row);
                col = Math.min(activeRange.col,extendedRange.col);
                row2 = Math.min(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                if(!(row === activeRange.row && col === activeRange.col && rowCount === activeRange.rowCount && colCount === activeRange.colCount))
                {
                    var newTopRow = this._getPrevVisualRow(this._scrollTopRow);
                    if(row === newTopRow || row2 === newTopRow)
                        this._setTopRow(newTopRow);
                    return new UI.Range(row,col,rowCount,colCount)
                }
            }
            return null
        },
        _searchSelectedRangebyUpCtrl: function(activeRange, isHomeKey)
        {
            var firstRow = this.frozenRowCount ? this._getNextVisualRow(this.frozenRowCount - 1) : this._getFirstVisualRow();
            var beginRow = isHomeKey ? firstRow : this._getFirstVisualRow();
            if(beginRow === undefined || beginRow === null)
                return;
            else if(this.frozenRowCount <= 0 || isHomeKey)
                this._setTopRow(beginRow);
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(beginRow,activeRange.col);
            row = Math.min(activeRange.row,extendedRange.row);
            col = Math.min(activeRange.col,extendedRange.col);
            row2 = Math.min(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _searchSelectedRangebyDown: function(activeRange)
        {
            var beginRow = activeRange.row;
            var endRow = this.getRowCount() - 1;
            var startPosition = {
                    r: beginRow,
                    c: activeRange.col + activeRange.colCount - 1
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginRow < endRow)
            {
                beginRow++;
                if(!this._canMoveCurrentTo(beginRow,startPosition.c,startPosition))
                    continue;
                extendedRange = this._getExtendedRange(beginRow,startPosition.c);
                row = Math.max(activeRange.row,extendedRange.row);
                col = Math.min(activeRange.col,extendedRange.col);
                row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                if(!(row === activeRange.row && col === activeRange.col && rowCount === activeRange.rowCount && colCount === activeRange.colCount))
                {
                    var firstRow = this.frozenRowCount ? this._getNextVisualRow(this.frozenRowCount - 1) : null;
                    var pageBottomRow = this._getPageBottomRow();
                    if(firstRow !== undefined && firstRow !== null && (row === firstRow || row2 === firstRow))
                        this._setTopRow(firstRow);
                    else if(row === pageBottomRow || row2 === pageBottomRow)
                        this._setTopRow(this._getNextVisualRow(this._scrollTopRow));
                    return new UI.Range(row,col,rowCount,colCount)
                }
                else
                    continue
            }
            return null
        },
        _searchSelectedRangebyDownCtrl: function(activeRange)
        {
            var newTopRow = this._getLastPageTopRow();
            if(newTopRow === undefined || newTopRow === null)
                return;
            else
                this._setTopRow(newTopRow);
            var endRow = this._getLastVisualRow();
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(endRow,activeRange.col);
            row = Math.max(activeRange.row,extendedRange.row);
            col = Math.min(activeRange.col,extendedRange.col);
            row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _searchSelectedRangebyHome: function(activeRange)
        {
            var beginCol = this.frozenColCount ? this.frozenColCount - 1 : -1;
            var endCol = this._activeColIndex;
            var startPosition = {
                    r: activeRange.row + activeRange.rowCount - 1,
                    c: activeRange.col
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginCol < endCol)
            {
                beginCol++;
                if(!this._canMoveCurrentTo(startPosition.r,beginCol,startPosition))
                    continue;
                if(activeRange.col <= beginCol && activeRange.col + activeRange.colCount - 1 === this._activeColIndex)
                    break;
                extendedRange = this._getExtendedRange(startPosition.r,beginCol);
                row = Math.min(activeRange.row,extendedRange.row);
                col = Math.min(activeRange.col,extendedRange.col);
                row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.min(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                this._setLeftColumn(this._getFirstVisualColumn());
                return new UI.Range(row,col,rowCount,colCount)
            }
            return null
        },
        _searchSelectedRangebyHomeCtrl: function(activeRange)
        {
            activeRange = this._searchSelectedRangebyLeftCtrl(activeRange,true);
            activeRange = this._searchSelectedRangebyUpCtrl(activeRange,true);
            return activeRange
        },
        _searchSelectedRangebyEnd: function(activeRange)
        {
            var beginCol = this.getColumnCount();
            var endCol = this._activeColIndex;
            var startPosition = {
                    r: activeRange.row + activeRange.rowCount - 1,
                    c: activeRange.col + activeRange.colCount - 1
                };
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            while(beginCol > endCol)
            {
                beginCol--;
                if(!this._canMoveCurrentTo(startPosition.r,beginCol,startPosition))
                    continue;
                if(activeRange.col + activeRange.colCount - 1 >= beginCol && activeRange.col === this._activeColIndex)
                    break;
                extendedRange = this._getExtendedRange(startPosition.r,beginCol);
                row = Math.min(activeRange.row,extendedRange.row);
                col = Math.max(activeRange.col,extendedRange.col);
                row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
                col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
                rowCount = row2 - row + 1;
                colCount = col2 - col + 1;
                this._setLeftColumn(this._getLastPageLeftColumn());
                return new UI.Range(row,col,rowCount,colCount)
            }
            return null
        },
        _searchSelectedRangebyEndCtrl: function(activeRange)
        {
            activeRange = this._searchSelectedRangebyRightCtrl(activeRange);
            activeRange = this._searchSelectedRangebyDownCtrl(activeRange);
            return activeRange
        },
        _searchSelectedRangebyPageUp: function(activeRange)
        {
            var prevPageTopRow = this._getPrevPageTopRow();
            if(prevPageTopRow === undefined || prevPageTopRow === null)
                return null;
            var rls = this._getRowLayout(1);
            var scrolled = this._setTopRow(prevPageTopRow);
            var beginRow = -1;
            if(scrolled)
                beginRow = this._getNextVisualRow(activeRange.row + activeRange.rowCount - 1 - rls.length);
            else if(this.frozenRowCount <= 0)
                beginRow = this._getFirstVisualRow();
            if(beginRow < this._scrollTopRow)
                beginRow = this._scrollTopRow;
            else if(beginRow >= this._getPageBottomRow())
                beginRow = this._getPrevVisualRow(this._getPageBottomRow());
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(beginRow,activeRange.col);
            row = Math.min(activeRange.row,extendedRange.row);
            col = Math.min(activeRange.col,extendedRange.col);
            row2 = Math.min(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _searchSelectedRangebyPageDown: function(activeRange)
        {
            var nextPageTopRow = this._getNextPageTopRow();
            if(nextPageTopRow === undefined || nextPageTopRow === null)
                return null;
            var rls = this._getRowLayout(1);
            this._setTopRow(nextPageTopRow);
            var beginRow = this._getPrevVisualRow(activeRange.row + activeRange.rowCount - 1 + rls.length);
            if(beginRow < this._scrollTopRow)
                beginRow = this._scrollTopRow;
            else if(beginRow >= this._getPageBottomRow())
                if(this._scrollTopRow >= this._getLastPageTopRow())
                    beginRow = this._getPageBottomRow();
                else
                    beginRow = this._getPrevVisualRow(this._getPageBottomRow());
            var extendedRange,
                row,
                col,
                row2,
                col2,
                rowCount,
                colCount;
            extendedRange = this._getExtendedRange(beginRow,activeRange.col);
            row = Math.max(activeRange.row,extendedRange.row);
            col = Math.min(activeRange.col,extendedRange.col);
            row2 = Math.max(activeRange.row + activeRange.rowCount - 1,extendedRange.row + extendedRange.rowCount - 1);
            col2 = Math.max(activeRange.col + activeRange.colCount - 1,extendedRange.col + extendedRange.colCount - 1);
            rowCount = row2 - row + 1;
            colCount = col2 - col + 1;
            return new UI.Range(row,col,rowCount,colCount)
        },
        _getPrevPageTopRow: function()
        {
            var rls = this._getRowLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            var firstRow = this.frozenRowCount ? this._getNextVisualRow(this.frozenRowCount - 1) : this._getFirstVisualRow();
            var h = 0;
            var r = this._scrollTopRow;
            var sheetLayout = this._getSheetLayout();
            while(r > firstRow)
            {
                h += this._getZoomRowHeight(r);
                if(h > sheetLayout.viewportHeight)
                    break;
                r--
            }
            return r
        },
        _getPrevPageLeftColumn: function()
        {
            var rls = this._getColumnLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            if(rls[0].col === this._getFirstVisualColumn())
                return rls[0].col;
            var w = 0;
            var c = this._scrollLeftCol;
            var sheetLayout = this._getSheetLayout();
            while(c > 0)
            {
                w += this._getZoomColumnWidth(c);
                if(w > sheetLayout.viewportWidth)
                    break;
                c--
            }
            return c
        },
        _getNextPageTopRow: function()
        {
            var rls = this._getRowLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            if(this._getLastVisualRow() === rls[rls.length - 1].row)
                return this._scrollTopRow;
            return rls[rls.length - 1].row
        },
        _getLastPageTopRow: function()
        {
            if(this._getLastVisualRow() === this._getPageBottomRow())
            {
                var sheetLayout = this._getSheetLayout();
                var rls = this._getRowLayout(1);
                if(rls && rls.length >= 1)
                {
                    var endRowLayout = rls[rls.length - 1];
                    if(endRowLayout.y + endRowLayout.height <= sheetLayout.viewportHeight)
                        return this._scrollTopRow
                }
            }
            var catchTopRow = this._scrollTopRow;
            try
            {
                this._scrollTopRow = this._getLastVisualRow();
                var lastPageTopRow = this._getPrevPageTopRow();
                lastPageTopRow = this._getNextVisualRow(lastPageTopRow);
                return lastPageTopRow
            }
            catch(e){}
            finally
            {
                this._scrollTopRow = catchTopRow
            }
        },
        _getLastPageLeftColumn: function()
        {
            var sheetLayout;
            if(this._getLastVisualColumn() === this._getPageRightColumn())
            {
                sheetLayout = this._getSheetLayout();
                var rls = this._getColumnLayout(1);
                if(rls && rls.length >= 1)
                {
                    var endColLayout = rls[rls.length - 1];
                    if(endColLayout.x + endColLayout.width <= sheetLayout.width)
                        return this._scrollLeftCol
                }
            }
            sheetLayout = this._getSheetLayout();
            var width = 0;
            var col = this._getLastVisualColumn();
            while(col > 0)
            {
                width += this._getZoomColumnWidth(col);
                if(width > sheetLayout.viewportWidth)
                    break;
                col--
            }
            if(col > 0)
                col = this._getNextVisualColumn(col);
            return col
        },
        _getPageBottomRow: function()
        {
            var rls = this._getRowLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            return rls[rls.length - 1].row
        },
        _getPageRightColumn: function()
        {
            var rls = this._getColumnLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            return rls[rls.length - 1].col
        },
        _getLastFullyVisibleRow: function()
        {
            var rls = this._getRowLayout(1);
            if(!rls || rls.length <= 0)
                return null;
            var layout = this._getSheetLayout();
            var i = rls.length - 1;
            if(rls[i].y + rls[i].height <= layout.viewportY + layout.viewportHeight)
                return rls[i].row;
            else
                return rls[Math.max(i - 1,0)].row
        },
        _getLastFullyVisibleColumn: function()
        {
            var cls = this._getColumnLayout(1);
            if(!cls || cls.length <= 0)
                return null;
            var layout = this._getSheetLayout();
            var i = cls.length - 1;
            if(cls[i].x + cls[i].width <= layout.viewportX + layout.viewportWidth)
                return cls[i].col;
            else
                return cls[Math.max(i - 1,0)].col
        },
        _getFirstVisualRow: function()
        {
            return this._getNextVisualRow(-1)
        },
        _getLastVisualRow: function(sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            return this._getPrevVisualRow(this.getRowCount(sheetArea),sheetArea)
        },
        _getFirstVisualColumn: function()
        {
            return this._getNextVisualColumn(-1)
        },
        _getLastVisualColumn: function(sheetArea)
        {
            if(sheetArea === undefined || sheetArea === null)
                sheetArea = UI.SheetArea.viewport;
            return this._getPrevVisualColumn(this.getColumnCount(sheetArea),sheetArea)
        },
        _getFirstPageLeftColumn: function()
        {
            var firstLeftCol = 0;
            var frozenColCount = isNaN(this.frozenColCount) ? 0 : this.frozenColCount;
            if(frozenColCount > 0)
                firstLeftCol = this._getNextVisualColumn(frozenColCount - 1);
            else
                firstLeftCol = this._getFirstVisualColumn();
            return firstLeftCol
        },
        _getFirstPageTopRow: function()
        {
            var firsTopRow = 0;
            var frozenRowCount = isNaN(this.frozenRowCount) ? 0 : this.frozenRowCount;
            if(frozenRowCount > 0)
                firsTopRow = this._getNextVisualRow(frozenRowCount - 1);
            else
                firsTopRow = this._getFirstVisualRow();
            return firsTopRow
        },
        _getNextVisualRow: function(row)
        {
            var endRow = this.getRowCount() - 1;
            while(row < endRow)
            {
                row++;
                if(this.getRowVisible(row) && this._getZoomRowHeight(row) > 0)
                    return row
            }
            return null
        },
        _getPrevVisualRow: function(row, sheetArea)
        {
            while(row > 0)
            {
                row--;
                if(this.getRowVisible(row,sheetArea) && this._getZoomRowHeight(row,sheetArea) > 0)
                    return row
            }
            return null
        },
        _getNextVisualColumn: function(col)
        {
            var endCol = this.getColumnCount() - 1;
            while(col < endCol)
            {
                col++;
                if(this.getColumnVisible(col) && this._getZoomColumnWidth(col) > 0)
                    return col
            }
            return null
        },
        _getPrevVisualColumn: function(col, sheetArea)
        {
            while(col > 0)
            {
                col--;
                if(this.getColumnVisible(col,sheetArea) && this._getZoomColumnWidth(col,sheetArea) > 0)
                    return col
            }
            return null
        },
        _inflateRangeToCoverSpans: function(spans, cellRange)
        {
            if(spans && spans.length > 0)
                for(var i = 0; i < spans.length; i++)
                {
                    var cr = spans[i];
                    if(cellRange.intersect(cr.row,cr.col,cr.rowCount,cr.colCount))
                    {
                        spans.splice(i--,1);
                        return this._inflateRangeToCoverSpans(spans,cellRange.union(cr))
                    }
                }
            return cellRange
        },
        _getActiveSelectedRange: function(dir)
        {
            var activeSelectedRange = new UI.Range(-1,-1,0,0);
            if(this._selectionModel.length <= 0)
                return activeSelectedRange;
            var Dir = UI.Direction;
            if(dir === Dir.left)
            {
                this._selectionModel.activeSelectedRangeIndex--;
                if(this._selectionModel.activeSelectedRangeIndex < 0)
                    this._selectionModel.activeSelectedRangeIndex = this._selectionModel.length - 1
            }
            else if(dir === Dir.right)
            {
                this._selectionModel.activeSelectedRangeIndex++;
                if(this._selectionModel.activeSelectedRangeIndex >= this._selectionModel.length)
                    this._selectionModel.activeSelectedRangeIndex = 0
            }
            if(this._selectionModel.activeSelectedRangeIndex >= 0)
                activeSelectedRange = this._selectionModel[this._selectionModel.activeSelectedRangeIndex];
            var span = this._spanModel.find(activeSelectedRange.row,activeSelectedRange.col);
            if(span && span.containsRange(activeSelectedRange))
                activeSelectedRange = span;
            return activeSelectedRange
        },
        _initializeActiveCell: function()
        {
            if(this._activeRowIndex === undefined || this._activeRowIndex === null || this._activeColIndex === undefined || this._activeColIndex === null || this._selectionModel.length <= 0)
            {
                var row = 0;
                var col = 0;
                var spanCell = this._spanModel.find(row,col);
                if(!spanCell)
                {
                    this._selectionModel.add(row,col,1,1);
                    this._activeRowIndex = row;
                    this._activeColIndex = col;
                    this._activeRowCount = 1;
                    this._activeColCount = 1
                }
                else
                {
                    this._selectionModel.add(row,col,spanCell.rowCount,spanCell.colCount);
                    this._activeRowIndex = row;
                    this._activeColIndex = col;
                    this._activeRowCount = spanCell.rowCount;
                    this._activeColCount = spanCell.colCount
                }
                if(this._selectionModel.length > 0)
                {
                    var currentSelection = this._selectionModel[0];
                    this._render.repaintSelection(currentSelection)
                }
            }
        },
        _setHoverCell: function(target)
        {
            var hoveredCellChanged = false;
            var current = this._currentTarget;
            if(!current)
                hoveredCellChanged = true;
            if(!hoveredCellChanged && !target)
                hoveredCellChanged = true;
            if(!hoveredCellChanged)
                hoveredCellChanged = target.col !== current.col || target.row !== current.row || target.colViewportIndex !== current.colViewportIndex || target.rowViewportIndex !== current.rowViewportIndex || target.hitTestType !== current.hitTestType;
            this._currentTarget = target;
            var adjX,
                adjY,
                gl;
            if(hoveredCellChanged)
            {
                this._hoverCell = true;
                var sheetLayout = this._getSheetLayout();
                var r = null;
                var SheetArea = UI.SheetArea;
                if(current)
                    if(current.rowViewportIndex < 0 || current.colViewportIndex < 0)
                    {
                        r = this.getCellRect(current.row,current.col,current.rowViewportIndex,current.colViewportIndex);
                        if(r && r.width > 0 && r.height > 0)
                        {
                            adjX = 0;
                            adjY = 0;
                            gl = this._getGroupLayout();
                            if(gl)
                            {
                                adjX = gl.width;
                                adjY = gl.height
                            }
                            if(r.x < sheetLayout.rowHeaderWidth + adjX || r.y < sheetLayout.colHeaderHeight + adjY || r.y >= sheetLayout.height - sheetLayout.footerHeight)
                                if(current.colViewportIndex < 0 && current.col === this.getColumnCount(SheetArea.rowHeader) - 1)
                                    this._render.update(r.x - 1,r.y - 1,r.width + 1,r.height + 2);
                                else if(current.row === this.getRowCount(SheetArea.colHeader) - 1)
                                    this._render.update(r.x - 1,r.y - 1,r.width + 2,r.height + 1);
                                else
                                    this._render.update(r.x - 1,r.y - 1,r.width + 2,r.height + 2)
                        }
                    }
                if(target)
                    if(target.rowViewportIndex < 0 || target.colViewportIndex < 0)
                    {
                        r = this.getCellRect(target.row,target.col,target.rowViewportIndex,target.colViewportIndex);
                        if(r && r.width > 0 && r.height > 0)
                        {
                            adjX = 0;
                            adjY = 0;
                            gl = this._getGroupLayout();
                            if(gl)
                            {
                                adjX = gl.width;
                                adjY = gl.height
                            }
                            if(r.x < sheetLayout.rowHeaderWidth + adjX || r.y < sheetLayout.colHeaderHeight + adjY || r.y >= sheetLayout.height - sheetLayout.footerHeight)
                                if(target.colViewportIndex < 0 && target.col === this.getColumnCount(SheetArea.rowHeader) - 1)
                                    this._render.update(r.x - 1,r.y - 1,r.width + 1,r.height + 2);
                                else if(target.row === this.getRowCount(SheetArea.colHeader) - 1)
                                    this._render.update(r.x - 1,r.y - 1,r.width + 2,r.height + 1);
                                else
                                    this._render.update(r.x - 1,r.y - 1,r.width + 2,r.height + 2)
                        }
                    }
                this._hoverCell = false
            }
        },
        _getAvailableActiveCell: function(row, col, isHorizontal)
        {
            var range = this._skipSpanCell(row,col,isHorizontal);
            return this._skipInvisibleCell(range)
        },
        _skipSpanCell: function(row, col, isHorizontal)
        {
            var spanCell = this._spanModel.find(row,col);
            if(!spanCell)
                return new UI.Range(row,col,1,1);
            else if(isHorizontal && spanCell.rowCount === 1 || !isHorizontal && spanCell.colCount === 1)
                return spanCell;
            if(isHorizontal)
                col++;
            else
                row++;
            return this._skipSpanCell(row,col,isHorizontal)
        },
        _skipInvisibleCell: function(range)
        {
            var row = range.row,
                i;
            var rowCount = this.getRowCount();
            for(i = row; i < rowCount; i++)
                if(this.getRowVisible(i) === true)
                    break;
            if(i < rowCount)
                row = i;
            var col = range.col;
            var columnCount = this.getColumnCount();
            for(i = col; i < columnCount; i++)
                if(this.getColumnVisible(i) === true)
                    break;
            if(i < columnCount)
                col = i;
            return new UI.Range(row,col,range.rowCount,range.colCount)
        },
        _processKeyMap: function(event)
        {
            var ret = true;
            var ka = this._getKeyAction(event.keyCode,event.ctrlKey,event.shiftKey,event.altKey);
            if(ka)
                if(typeof ka.action === const_function)
                {
                    ret = ka.action.call(this);
                    if(event.keyCode === UI.Key.enter && event.ctrlKey === false && event.altKey === false)
                        UI.cancelDefault(event);
                    if(typeof ret === "object")
                    {
                        if(ret.processed)
                            UI.cancelDefault(event);
                        ret = false
                    }
                }
            return ret
        },
        _getRowInfos: function(sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
            {
                if(!this._rowInfos)
                    this._rowInfos = {};
                return this._rowInfos
            }
            else if(sheetArea === SheetArea.colHeader)
            {
                if(!this._colHeaderRowInfos)
                    this._colHeaderRowInfos = {};
                return this._colHeaderRowInfos
            }
        },
        _getZoomRowHeight: function(row, sheetArea)
        {
            return parseInt(this.getRowHeight(row,sheetArea) * this._zoomFactor,10)
        },
        _getColumnInfos: function(sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.colHeader)
            {
                if(!this._colInfos)
                    this._colInfos = {};
                return this._colInfos
            }
            else if(sheetArea === SheetArea.rowHeader)
            {
                if(!this._rowHeaderColInfos)
                    this._rowHeaderColInfos = {};
                return this._rowHeaderColInfos
            }
            return null
        },
        _getZoomColumnWidth: function(col, sheetArea)
        {
            return parseInt(this.getColumnWidth(col,sheetArea) * this._zoomFactor,10)
        },
        _getGroupLayout: function()
        {
            if(!this._cachedGroupLayout)
                this._cachedGroupLayout = this._createGroupLayout();
            return this._cachedGroupLayout
        },
        _createGroupLayout: function()
        {
            var groupLayout = {
                    x: 0,
                    y: 0,
                    width: 0,
                    height: 0
                };
            if(this._showRowRangeGroup && this.rowRangeGroup)
            {
                var rowMaxLevel = this.rowRangeGroup.getMaxLevel();
                if(rowMaxLevel >= 0)
                {
                    var width = Math.min(this._GROUPBUTTON_WIDTH,this._GROUPBUTTON_WIDTH * this._zoomFactor);
                    groupLayout.width = width * (rowMaxLevel + 2) + this._GROUPPADDING * 2
                }
            }
            if(this._showColumnRangeGroup && this.colRangeGroup)
            {
                var columnMaxLevel = this.colRangeGroup.getMaxLevel();
                if(columnMaxLevel >= 0)
                {
                    var height = Math.min(this._GROUPBUTTON_HEIGHT,this._GROUPBUTTON_HEIGHT * this._zoomFactor);
                    groupLayout.height = height * (columnMaxLevel + 2) + this._GROUPPADDING * 2
                }
            }
            return groupLayout
        },
        _createLayout: function()
        {
            var Rect = UI.Rect;
            var bounds = new Rect(this._bounds.x + this.borderWidth,this._bounds.y + this.borderWidth,Math.max(0,this._bounds.width - 2 * this.borderWidth),Math.max(0,this._bounds.height - 2 * this.borderWidth));
            var totalWidth = bounds.width;
            var totalHeight = bounds.height;
            var layout = {
                    x: bounds.x,
                    y: bounds.y,
                    width: bounds.width,
                    height: bounds.height,
                    rowHeaderWidth: 0,
                    colHeaderHeight: 0,
                    frozenWidth: 0,
                    frozenHeight: 0,
                    footerHeight: 0,
                    footerWidth: 0,
                    headerCornerRect: function()
                    {
                        return new Rect(this.x,this.y,this.rowHeaderWidth,this.colHeaderHeight)
                    },
                    colHeaderRect: function(colViewportIndex)
                    {
                        if(colViewportIndex === 0)
                            return new Rect(this.frozenX,this.y,this.frozenWidth,this.colHeaderHeight);
                        else if(colViewportIndex === 1)
                            return new Rect(this.viewportX,this.y,this.viewportWidth,this.colHeaderHeight);
                        else
                            return new Rect(this.frozenX,this.y,this.frozenWidth + this.viewportWidth,this.colHeaderHeight)
                    },
                    rowHeaderRect: function(rowViewportIndex)
                    {
                        if(rowViewportIndex === 0)
                            return new Rect(this.x,this.frozenY,this.rowHeaderWidth,this.frozenHeight);
                        else if(rowViewportIndex === 1)
                            return new Rect(this.x,this.viewportY,this.rowHeaderWidth,this.viewportHeight);
                        else
                            return new Rect(this.x,this.frozenY,this.rowHeaderWidth,this.frozenHeight + this.viewportHeight)
                    },
                    viewportRect: function(rowViewportIndex, colViewportIndex)
                    {
                        if(rowViewportIndex === 0)
                            if(colViewportIndex === 0)
                                return new Rect(this.frozenX,this.frozenY,this.frozenWidth,this.frozenHeight);
                            else if(colViewportIndex === 1)
                                return new Rect(this.viewportX,this.frozenY,this.viewportWidth,this.frozenHeight);
                            else
                                return new Rect(this.frozenX,this.frozenY,this.frozenWidth + this.viewportWidth,this.frozenHeight);
                        else if(rowViewportIndex === 1)
                            if(colViewportIndex === 0)
                                return new Rect(this.frozenX,this.viewportY,this.frozenWidth,this.viewportHeight);
                            else if(colViewportIndex === 1)
                                return new Rect(this.viewportX,this.viewportY,this.viewportWidth,this.viewportHeight);
                            else
                                return new Rect(this.frozenX,this.viewportY,this.frozenWidth + this.viewportWidth,this.viewportHeight);
                        else if(colViewportIndex === 0)
                            return new Rect(this.frozenX,this.frozenY,this.frozenWidth,this.frozenHeight + this.viewportHeight);
                        else if(colViewportIndex === 1)
                            return new Rect(this.viewportX,this.frozenY,this.viewportWidth,this.frozenHeight + this.viewportHeight);
                        else
                            return new Rect(this.frozenX,this.frozenY,this.frozenWidth + this.viewportWidth,this.frozenHeight + this.viewportHeight)
                    },
                    footerRect: function(colViewportIndex)
                    {
                        if(colViewportIndex === 0)
                            return new Rect(this.frozenX,this.footerY,this.frozenWidth,this.footerHeight);
                        else if(colViewportIndex === 1)
                            return new Rect(this.viewportX,this.footerY,this.viewportWidth,this.footerHeight);
                        else
                            return new Rect(this.frozenX,this.footerY,this.frozenWidth + this.viewportWidth,this.footerHeight)
                    },
                    footerCornerRect: function()
                    {
                        return new Rect(this.footerX,this.footerY,this.footerWidth,this.footerHeight)
                    }
                };
            var groupLayout = this._getGroupLayout();
            layout.x += groupLayout.width;
            layout.y += groupLayout.height;
            var SheetArea = UI.SheetArea,
                r,
                rc,
                c,
                cc;
            if(this.rowHeaderVisible === null || this.rowHeaderVisible === undefined || this.rowHeaderVisible)
            {
                cc = this.getColumnCount(SheetArea.rowHeader);
                for(c = 0; c < cc; c++)
                    layout.rowHeaderWidth += this._getZoomColumnWidth(c,SheetArea.rowHeader)
            }
            if(this.colHeaderVisible === null || this.colHeaderVisible === undefined || this.colHeaderVisible)
            {
                rc = this.getRowCount(SheetArea.colHeader);
                for(r = 0; r < rc; r++)
                    layout.colHeaderHeight += this._getZoomRowHeight(r,SheetArea.colHeader)
            }
            if(this._colFooterVisible)
            {
                rc = this.getRowCount(SheetArea.colFooter);
                for(r = 0; r < rc; r++)
                    layout.footerHeight += this._getZoomRowHeight(r,SheetArea.colFooter)
            }
            layout.footerWidth = layout.rowHeaderWidth;
            if(this.frozenColCount > 0)
            {
                cc = this.getColumnCount();
                for(c = 0; c < this.frozenColCount && c < cc; c++)
                    if(this.getColumnVisible(c))
                        layout.frozenWidth += this._getZoomColumnWidth(c)
            }
            if(layout.frozenWidth > layout.width)
                layout.frozenWidth = layout.width - layout.rowHeaderWidth;
            if(this.frozenRowCount > 0)
            {
                rc = this.getRowCount();
                for(r = 0; r < this.frozenRowCount && r < rc; r++)
                    if(this.getRowVisible(r))
                        layout.frozenHeight += this._getZoomRowHeight(r)
            }
            if(layout.frozenHeight > layout.height - layout.colHeaderHeight)
                layout.frozenHeight = layout.height - layout.colHeaderHeight;
            totalWidth -= layout.rowHeaderWidth;
            totalHeight -= layout.colHeaderHeight;
            totalWidth -= layout.frozenWidth;
            totalHeight -= layout.frozenHeight;
            totalHeight -= layout.footerHeight;
            layout.viewportWidth = Math.max(0,totalWidth);
            layout.viewportHeight = Math.max(0,totalHeight);
            layout.headerX = layout.x;
            layout.headerY = layout.y;
            layout.frozenX = layout.headerX + layout.rowHeaderWidth;
            layout.frozenY = layout.headerY + layout.colHeaderHeight;
            layout.viewportX = layout.frozenX + layout.frozenWidth;
            layout.viewportY = layout.frozenY + layout.frozenHeight;
            layout.footerX = layout.headerX;
            layout.footerY = layout.y + layout.height - layout.footerHeight;
            return layout
        },
        _getSheetLayout: function()
        {
            if(!this._layoutModel)
                this._layoutModel = this._createLayout();
            return this._layoutModel
        },
        _getColumnLayout: function(j, sheetArea)
        {
            var cl = null;
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.colHeader)
                cl = this._colLayoutCache.viewport[j];
            else if(sheetArea === SheetArea.rowHeader)
                cl = this._colLayoutCache.rowHeader[j];
            if(cl)
                return cl;
            cl = this._createColumnLayout(j,sheetArea);
            if(sheetArea === SheetArea.viewport || sheetArea === SheetArea.colHeader)
                this._colLayoutCache.viewport[j] = cl;
            else if(sheetArea === SheetArea.rowHeader)
                this._colLayoutCache.rowHeader[j] = cl;
            return cl
        },
        _createColumnLayout: function(j, sheetArea)
        {
            var colLayouts = new UI._LayoutModel;
            var layout = this._getSheetLayout();
            var viewportX = 0;
            var viewportWidth = 0;
            var col;
            var colCount = this.getColumnCount(sheetArea);
            var colX;
            var colWidth = 0;
            var frozenColCount = isNaN(this.frozenColCount) ? 0 : Math.min(this.frozenColCount,this.getColumnCount());
            var leftCol = 0;
            if(sheetArea === UI.SheetArea.rowHeader)
            {
                viewportX = layout.headerX;
                viewportWidth = layout.rowHeaderWidth
            }
            else
            {
                if(j === 0)
                    colCount = frozenColCount;
                else if(j > 0)
                    leftCol = Math.max(frozenColCount,this._scrollLeftCol);
                viewportX = j > 0 ? layout.viewportX : layout.frozenX;
                viewportWidth = j > 0 ? layout.viewportWidth : layout.frozenWidth
            }
            if(this.colVisibleCount === 0)
                colCount = 0;
            for(col = leftCol, colX = 0; col < colCount && (sheetArea === UI.SheetArea.rowHeader || j === 0 || colX <= viewportWidth); col++, colX += colWidth)
            {
                if(!this.getColumnVisible(col,sheetArea))
                {
                    colX -= colWidth;
                    continue
                }
                colWidth = this._getZoomColumnWidth(col,sheetArea);
                if(colWidth >= 0)
                    colLayouts.push(new UI._Layout(-1,col,viewportX + colX,-1,colWidth,-1))
            }
            return colLayouts
        },
        _getRowLayout: function(i, sheetArea)
        {
            var rl = null;
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
                rl = this._rowLayoutCache.viewport[i];
            else if(sheetArea === SheetArea.colHeader)
                rl = this._rowLayoutCache.colHeader[i];
            else if(sheetArea === SheetArea.colFooter)
                rl = this._rowLayoutCache.colFooter[i];
            if(rl)
                return rl;
            rl = this._createRowLayout(i,sheetArea);
            if(sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
                this._rowLayoutCache.viewport[i] = rl;
            else if(sheetArea === SheetArea.colHeader)
                this._rowLayoutCache.colHeader[i] = rl;
            else if(sheetArea === SheetArea.colFooter)
                this._rowLayoutCache.colFooter[i] = rl;
            return rl
        },
        _createRowLayout: function(i, sheetArea)
        {
            var rowLayouts = new UI._LayoutModel;
            var layout = this._getSheetLayout();
            var viewportY = 0;
            var viewportHeight = 0;
            var row;
            var rowCount = this.getRowCount(sheetArea);
            var rowY;
            var rowHeight = 0;
            var frozenRowCount = isNaN(this.frozenRowCount) ? 0 : Math.min(this.frozenRowCount,this.getRowCount());
            var topRow = 0;
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport || sheetArea === SheetArea.rowHeader)
            {
                if(i === 0)
                    rowCount = frozenRowCount;
                else if(i > 0)
                    topRow = Math.max(frozenRowCount,this._scrollTopRow);
                viewportY = i > 0 ? layout.viewportY : layout.frozenY;
                viewportHeight = i > 0 ? layout.viewportHeight : layout.frozenHeight
            }
            else if(sheetArea === SheetArea.colHeader)
            {
                viewportY = layout.headerY;
                viewportHeight = layout.colHeaderHeight
            }
            else if(sheetArea === SheetArea.colFooter)
            {
                viewportY = layout.footerY;
                viewportHeight = layout.footerHeight
            }
            for(row = topRow, rowY = viewportY; row < rowCount && (sheetArea === SheetArea.colHeader || sheetArea === SheetArea.colFooter || i === 0 || rowY < viewportY + viewportHeight); row++, rowY += rowHeight)
            {
                if(!this.getRowVisible(row,sheetArea))
                {
                    rowY -= rowHeight;
                    continue
                }
                rowHeight = this._getZoomRowHeight(row,sheetArea);
                if(rowHeight >= 0)
                    rowLayouts.push(new UI._Layout(row,-1,-1,rowY,-1,rowHeight))
            }
            return rowLayouts
        },
        _getCellLayout: function(i, j, sheetArea)
        {
            var layout = this._getSheetLayout();
            var viewportY = i > 0 ? layout.viewportY : layout.frozenY;
            var viewportHeight = i > 0 ? layout.viewportHeight : layout.frozenHeight;
            var viewportX = j > 0 ? layout.viewportX : layout.frozenX;
            var viewportWidth = j > 0 ? layout.viewportWidth : layout.frozenWidth;
            var SheetArea = UI.SheetArea;
            if(sheetArea === SheetArea.rowHeader)
            {
                viewportX = layout.headerX;
                viewportWidth = layout.rowHeaderWidth
            }
            else if(sheetArea === SheetArea.colHeader)
            {
                viewportY = layout.headerY;
                viewportHeight = layout.colHeaderHeight
            }
            else if(sheetArea === SheetArea.colFooter)
            {
                viewportY = layout.footerY;
                viewportHeight = layout.footerHeight
            }
            var rowCount = this.getRowCount(sheetArea);
            var colCount = this.getColumnCount(sheetArea);
            var rowLayoutModel = this._getRowLayout(i,sheetArea);
            var colLayoutModel = this._getColumnLayout(j,sheetArea);
            var cellLayoutModel = new UI._LayoutModel;
            if(rowLayoutModel.length > 0 && colLayoutModel.length > 0)
            {
                var topRow = rowLayoutModel[0].row;
                var leftCol = colLayoutModel[0].col;
                var bottomRow = rowLayoutModel[rowLayoutModel.length - 1].row;
                var rightCol = colLayoutModel[colLayoutModel.length - 1].col;
                var spans = this.getSpans(new UI.Range(topRow,leftCol,bottomRow - topRow + 1,rightCol - leftCol + 1),sheetArea);
                this._addCellLayout(spans,topRow,leftCol,bottomRow,rightCol,cellLayoutModel,rowCount,colCount,sheetArea,rowLayoutModel,colLayoutModel);
                if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport)
                {
                    spans = new UI._SpanModel;
                    this._addCellLayout(spans,topRow,leftCol,bottomRow,rightCol,cellLayoutModel,rowCount,colCount,sheetArea,rowLayoutModel,colLayoutModel)
                }
            }
            return cellLayoutModel
        },
        _addCellLayout: function(spans, topRow, leftCol, bottomRow, rightCol, cellLayoutModel, rowCount, colCount, sheetArea, rowLayoutModel, colLayoutModel)
        {
            for(var k = 0; k < spans.length; k++)
            {
                var cellSpan = spans[k];
                if(cellSpan.intersect(topRow,leftCol,bottomRow - topRow + 1,rightCol - leftCol + 1))
                {
                    var x = 0,
                        y = 0,
                        width = 0,
                        height = 0,
                        row,
                        col;
                    for(col = cellSpan.col; col < leftCol; col++)
                        x -= this._getZoomColumnWidth(col,sheetArea);
                    for(col = leftCol; col < cellSpan.col; col++)
                        x += this._getZoomColumnWidth(col,sheetArea);
                    for(row = cellSpan.row; row < topRow; row++)
                        y -= this._getZoomRowHeight(row,sheetArea);
                    for(row = topRow; row < cellSpan.row; row++)
                        y += this._getZoomRowHeight(row,sheetArea);
                    for(col = cellSpan.col; col < cellSpan.col + cellSpan.colCount && col < colCount; col++)
                        width += this._getZoomColumnWidth(col,sheetArea);
                    for(row = cellSpan.row; row < cellSpan.row + cellSpan.rowCount && row < rowCount; row++)
                        height += this._getZoomRowHeight(row,sheetArea);
                    cellLayoutModel.push(new UI._Layout(cellSpan.row,cellSpan.col,colLayoutModel[0].x + x,rowLayoutModel[0].y + y,width,height,cellSpan.rowCount,cellSpan.colCount))
                }
            }
        },
        _syncHScollbarPosition: function()
        {
            if(this._scrollCallback)
                this._scrollCallback({
                    action: "scroll",
                    orientation: "horizontal"
                })
        },
        _syncVScrollbarPosition: function()
        {
            if(this._scrollCallback)
                this._scrollCallback({
                    action: "scroll",
                    orientation: "vertical"
                })
        },
        _syncScrollbarSize: function()
        {
            if(this._scrollCallback)
                this._scrollCallback({action: "resize"})
        },
        _setTopRow: function(row, forceRepaint)
        {
            if(forceRepaint || row !== undefined && row !== null && row >= this._getFirstPageTopRow() && row <= this._getLastVisualRow() && row !== this._scrollTopRow)
            {
                this._trigger(UI.Events.TopRowChanged,{
                    sheet: this,
                    sheetName: this._name,
                    oldTopRow: this._scrollTopRow,
                    newTopRow: row
                });
                var painted = false;
                if(GrapeCity.UI._useDoubleBuffer())
                {
                    var bufferCtx = this._render._getBufferCtx();
                    var oldTop = this._scrollTopRow;
                    var sl = null;
                    var rls = this._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
                    this._scrollTopRow = row;
                    if(this._scrollTopRow > oldTop && rls)
                    {
                        var rl = rls.findRow(this._scrollTopRow);
                        if(rl)
                        {
                            painted = true;
                            sl = this._getSheetLayout();
                            if(rls.length <= 0)
                                return false;
                            var i = rls.length - 1;
                            var lrl = rls[i];
                            var adj = rls[i].height + 2;
                            if(rls[i].y + rls[i].height > sl.viewportHeight)
                                adj += rls[i - 1].height;
                            if(sl.viewportHeight - rl.y - adj > 0)
                            {
                                this._render.translateScreen(sl.x,rl.y,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - rl.y - adj,sl.x,sl.viewportY);
                                this._render._copyDoubleBufferRect(new UI.Rect(sl.x,rl.y,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - rl.y - adj),sl.x,sl.viewportY,null,bufferCtx,bufferCtx);
                                for(var i = oldTop; i < this._scrollTopRow; i++)
                                    this._clearCellOverflowModelCachebyRow(i);
                                var tmp = this._cellOverflowModelCache;
                                this.invalidateLayout();
                                this._cellOverflowModelCache = tmp;
                                rls = this._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
                                if(!rls || rls.length <= 0)
                                    return false;
                                var lrl2 = rls[rls.length - 1];
                                for(var i = lrl.row + 1; i <= lrl2.row + 1; i++)
                                    this._render._buildCellOverflowLayoutModel(i,GrapeCity.UI.SheetArea.viewport);
                                this._render.update(sl.x,sl.viewportY + sl.viewportHeight - rl.y - adj,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,rl.y + adj,false)
                            }
                            else
                            {
                                this.invalidateLayout();
                                this.repaint()
                            }
                        }
                    }
                    else
                    {
                        sl = this._getSheetLayout();
                        var h = 0;
                        for(var i = this._scrollTopRow; i < oldTop && h < sl.viewportHeight; i++)
                            h += this._getZoomRowHeight(i);
                        if(h < sl.viewportHeight)
                        {
                            painted = true;
                            var rls = this._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
                            if(!rls)
                                return false;
                            var frl = rls.findRow(oldTop);
                            if(frl)
                            {
                                var adj = frl.height + 2;
                                var activeCol = this.getActiveColumnIndex();
                                if(activeCol >= 0 && activeCol < this.getColumnCount())
                                {
                                    var colLayout = this._getColumnLayout(1,GrapeCity.UI.SheetArea.viewport).findCol(activeCol);
                                    if(colLayout)
                                    {
                                        var rect = this.getCellRect(frl.row,activeCol);
                                        if(rect)
                                            adj = rect.height + 2
                                    }
                                }
                                this._render.translateScreen(sl.x,sl.viewportY + adj,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - h - adj,sl.x,sl.viewportY + h + adj);
                                this._render._copyDoubleBufferRect(new UI.Rect(sl.x,sl.viewportY + adj,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - h - adj),sl.x,sl.viewportY + h + adj,null,bufferCtx,bufferCtx);
                                for(var i = this._scrollTopRow; i < oldTop; i++)
                                    this._render._buildCellOverflowLayoutModel(i,GrapeCity.UI.SheetArea.viewport);
                                if(rls.length <= 0)
                                    return false;
                                var lrl = rls[rls.length - 1];
                                var tmp = this._cellOverflowModelCache;
                                this.invalidateLayout();
                                this._cellOverflowModelCache = tmp;
                                rls = this._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
                                if(!rls || rls.length <= 0)
                                    return false;
                                var lrl2 = rls[rls.length - 1];
                                for(var i = lrl2.row + 1; i <= lrl.row; i++)
                                    this._clearCellOverflowModelCachebyRow(i);
                                this._render.update(sl.x,sl.viewportY,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,h + adj,false)
                            }
                        }
                    }
                }
                else
                    this._scrollTopRow = row;
                if(!painted)
                {
                    this.invalidateLayout();
                    this.repaint()
                }
                this._syncVScrollbarPosition();
                return true
            }
        },
        _setLeftColumn: function(col, forceRepaint)
        {
            if(forceRepaint || col !== undefined && col !== null && col >= this._getFirstPageLeftColumn() && col <= this._getLastVisualColumn() && col !== this._scrollLeftCol)
            {
                this._trigger(UI.Events.LeftColumnChanged,{
                    sheet: this,
                    sheetName: this._name,
                    oldLeftCol: this._scrollLeftCol,
                    newLeftCol: col
                });
                this._scrollLeftCol = col;
                this.invalidateLayout();
                this.repaint();
                this._syncHScollbarPosition();
                return true
            }
        },
        _getSpanModel: function(sheetArea)
        {
            var SheetArea = UI.SheetArea;
            if(sheetArea === undefined || sheetArea === null || sheetArea === SheetArea.viewport)
                return this._spanModel;
            else if(sheetArea === SheetArea.colHeader)
                return this._colHeaderSpanModel;
            else if(sheetArea === SheetArea.rowHeader)
                return this._rowHeaderSpanModel
        },
        _clipboardCopy: function(range, isCutting)
        {
            if(!range)
                return;
            var columnDelimiter = "\t";
            var rowDelimiter = "\r\n";
            var cellDelimiter = "\"";
            var newRange = new UI.Range(range.row,range.col,range.rowCount,range.colCount);
            if(newRange.row === -1)
                newRange.row = 0;
            if(newRange.col === -1)
                newRange.col = 0;
            if(newRange.rowCount === -1)
                newRange.rowCount = this.getRowCount() - newRange.row;
            if(newRange.colCount === -1)
                newRange.colCount = this.getColumnCount() - newRange.col;
            var copyData = this.getCsv(newRange.row,newRange.col,newRange.rowCount,newRange.colCount,rowDelimiter,columnDelimiter);
            var ch = this._getClipboardHelper();
            ch.fromSheet = this;
            ch.range = range;
            ch.isCutting = isCutting;
            try
            {
                if(window.clipboardData && window.clipboardData.setData)
                {
                    var args = {
                            sheet: this,
                            sheetName: this._name,
                            copyData: copyData,
                            cancel: false
                        };
                    var E = UI.Events;
                    this._trigger(E.ClipboardChanging,args);
                    if(args && args.cancel === false)
                    {
                        window.clipboardData.setData("Text",copyData);
                        this._trigger(E.ClipboardChanged,{
                            sheet: this,
                            sheetName: this._name,
                            copyData: copyData
                        })
                    }
                    else
                    {
                        ch.fromSheet = null;
                        ch.range = null
                    }
                }
            }
            catch(e){}
        },
        _trySearch: function(source, searchString, searchFlags)
        {
            if(source)
            {
                var sf = UI.SearchFlags;
                source = source.toString();
                searchString = searchString.toString();
                var exactMatch = (searchFlags & sf.ExactMatch) > 0;
                if(exactMatch && (searchFlags & sf.UseWildCards) === 0)
                    if((searchFlags & sf.IgnoreCase) > 0)
                    {
                        var sourceLower = source.toLowerCase();
                        var searchStringLower = searchString.toLowerCase();
                        return sourceLower === searchStringLower
                    }
                    else
                        return source === searchString;
                else
                {
                    var ignoreCase = (searchFlags & sf.IgnoreCase) > 0;
                    var useWildCards = (searchFlags & sf.UseWildCards) > 0;
                    var rgExp;
                    if(ignoreCase)
                        rgExp = new RegExp(fixFormulaKeyword(searchString,useWildCards,exactMatch),"i");
                    else
                        rgExp = new RegExp(fixFormulaKeyword(searchString,useWildCards,exactMatch));
                    var result = source.search(rgExp) > -1;
                    if(exactMatch && result && searchString.search(/\*/) <= -1)
                        result = source.length === searchString.length;
                    return result
                }
            }
            return false
        },
        _getFilterButtonHitInfo: function(target, x, y)
        {
            if(!this._rowFilter)
                return null;
            if(!this._filterButtonsModel)
            {
                this._filterButtonsModel = {};
                for(var rv = -1; rv <= 1; rv++)
                {
                    this._filterButtonsModel[rv] = {};
                    for(var cv = -1; cv <= 1; cv++)
                        this._filterButtonsModel[rv][cv] = []
                }
                var range = this._getActualRange(this._rowFilter.range);
                var row = range.row - 1,
                    col = range.col;
                var rowviewport = 1,
                    colviewport = 1;
                var sheetArea = UI.SheetArea.viewport;
                if(row < 0)
                {
                    rowviewport = -1;
                    sheetArea = UI.SheetArea.colHeader;
                    row = this.getRowCount(sheetArea) - 1
                }
                else if(row < this.frozenRowCount)
                    rowviewport = 0;
                var model = this._filterButtonsModel[rowviewport];
                for(var j = 0; j < range.colCount; j++)
                {
                    var tempRow = row,
                        tempCol = col + j;
                    var spans = this.getSpans(new UI.Range(tempRow,tempCol,1,1),sheetArea);
                    if(spans && spans.length > 0)
                        tempRow = spans[0].row;
                    colviewport = tempCol < this.frozenColCount ? 0 : 1;
                    var cellRect = this.getCellRect(tempRow,tempCol,rowviewport,colviewport);
                    var filterButtonRect = this._render._getFilterButtonRect(cellRect);
                    model[colviewport].push({
                        row: tempRow,
                        col: tempCol,
                        x: filterButtonRect.x,
                        y: filterButtonRect.y,
                        width: filterButtonRect.width,
                        height: filterButtonRect.height,
                        sheetArea: sheetArea
                    })
                }
            }
            for(var r in this._filterButtonsModel)
                if(this._filterButtonsModel[r])
                {
                    var rowFilterButtonsModel = this._filterButtonsModel[r];
                    for(var c in rowFilterButtonsModel)
                        if(rowFilterButtonsModel[c])
                        {
                            var filterButtonsModel = rowFilterButtonsModel[c];
                            if(filterButtonsModel.length > 0)
                                for(var i = 0; i < filterButtonsModel.length; i++)
                                {
                                    var filterButtonInfo = filterButtonsModel[i];
                                    if(target.row === filterButtonInfo.row && target.col === filterButtonInfo.col && target.hitTestType === filterButtonInfo.sheetArea)
                                        if(x >= filterButtonInfo.x && x <= filterButtonInfo.x + filterButtonInfo.width && y >= filterButtonInfo.y && y <= filterButtonInfo.y + filterButtonInfo.height)
                                            return filterButtonInfo
                                }
                        }
                }
            return null
        },
        _getCellTypeHitInfo: function(target, x, y)
        {
            var r = target.row,
                c = target.col,
                sheetArea = target.hitTestType;
            var ct = this.getCellType(r,c,sheetArea);
            var cellRect = this.getCellRect(r,c);
            var cellStyle = this.getActualStyle(r,c,sheetArea);
            if(this.isProtected && cellStyle.locked)
                return null;
            return this._allowEditorReservedLocations ? ct.getHitInfo(x,y,r,c,cellStyle,cellRect,sheetArea) : null
        },
        _clearCellOverflowModelCachebyRow: function(row, sheetArea)
        {
            if(this._cellOverflowModelCache && (sheetArea === undefined || sheetArea === null || sheetArea === UI.SheetArea.viewport))
                this._cellOverflowModelCache[row] = null
        },
        _clearCellOverflowModelCache: function()
        {
            if(this._cellOverflowModelCache)
                this._cellOverflowModelCache = null
        },
        _trigger: function(type, data)
        {
            this._eventHandler.trigger(type,data)
        },
        _disposeUserEvents: function()
        {
            this.unbindAll();
            this._unbindAll()
        },
        _doCommand: function(action)
        {
            var undoManager = this.undoManager();
            undoManager.doAction(action)
        },
        _refreshTabStrip: function()
        {
            if(this.parent && this.parent._tab && this.parent._tab.repaint)
                this.parent._tab.repaint()
        },
        _isAnyCellInRangeLocked: function(range)
        {
            var ar = this._getActualRange(range);
            for(var row = ar.row; row < ar.row + ar.rowCount; row++)
                for(var col = ar.col; col < ar.col + ar.colCount; col++)
                {
                    var style = this.getActualStyle(row,col);
                    if(style.locked === true)
                        return true
                }
            return false
        },
        _isValidRange: function(row, column, rowCount, columnCount, maxRowCount, maxColumnCount)
        {
            if(-1 <= row && row < maxRowCount && -1 <= column && column < maxColumnCount)
                if(row === -1 && column === -1)
                    return true;
                else if(row === -1)
                {
                    if(columnCount !== 0 && column + columnCount <= maxColumnCount)
                        return true
                }
                else if(column === -1)
                {
                    if(rowCount !== 0 && row + rowCount <= maxRowCount)
                        return true
                }
                else if(columnCount !== 0 && column + columnCount <= maxColumnCount && rowCount !== 0 && row + rowCount <= maxRowCount)
                    return true;
            return false
        },
        _setValueInternal: function(row, col, sheetArea, value, raiseCellPropertyChanged)
        {
            this.setValue(row,col,value,sheetArea,false)
        },
        _hasPartSpans: function(row, column, rowCount, columnCount)
        {
            var enumerator,
                cs;
            if(row < 0 && column < 0)
                return false;
            else if(row < 0)
            {
                var columnHeaderSpanModel = this._colHeaderSpanModel;
                if(columnHeaderSpanModel && columnHeaderSpanModel.length !== 0)
                {
                    enumerator = columnHeaderSpanModel.getEnumerator(-1,column,-1,columnCount);
                    cs = null;
                    while(enumerator.moveNext())
                    {
                        cs = enumerator.current();
                        if(cs.col < column || cs.col + cs.colCount > column + columnCount)
                            return true
                    }
                }
            }
            else if(column < 0)
            {
                var rowHeaderSpanModel = this._rowHeaderSpanModel;
                if(rowHeaderSpanModel && rowHeaderSpanModel.length !== 0)
                {
                    enumerator = rowHeaderSpanModel.getEnumerator(row,-1,rowCount,-1);
                    cs = null;
                    while(enumerator.moveNext())
                    {
                        cs = enumerator.current();
                        if(cs.row < row || cs.row + cs.rowCount > row + rowCount)
                            return true
                    }
                }
            }
            var spanModel = this._spanModel;
            if(spanModel && spanModel.length !== 0)
            {
                var spanEnumerator = spanModel.getEnumerator(row,column,rowCount,columnCount);
                cs = null;
                while(spanEnumerator.moveNext())
                {
                    cs = spanEnumerator.current();
                    if(row !== -1)
                        if(cs.row < row || cs.row + cs.rowCount > row + rowCount)
                            return true;
                    if(column !== -1)
                        if(cs.col < column || cs.col + cs.colCount > column + columnCount)
                            return true
                }
            }
            return false
        },
        _hasSpans: function(row, column, rowCount, columnCount)
        {
            var spans = this._spanModel;
            if(spans)
                for(var i = 0; i < spans.length; i++)
                {
                    var span = spans[i];
                    if(span.intersect(row,column,rowCount,columnCount))
                        return true
                }
            return false
        },
        _hasPartArrayFormulas: function(row, column, rowCount, columnCount)
        {
            var arrayFormulas = this._getsArrayFormulas(row,column,rowCount,columnCount);
            if(arrayFormulas && arrayFormulas.length > 0)
            {
                var count = arrayFormulas.length;
                for(var i = 0; i < count; i++)
                {
                    var cs = arrayFormulas[i][0];
                    if(row !== -1)
                        if(cs.row < row || cs.row + cs.rowCount > row + rowCount)
                            return true;
                    if(column !== -1)
                        if(cs.col < column || cs.col + cs.colCount > column + columnCount)
                            return true
                }
            }
            return false
        },
        _getsArrayFormulas: function(row, column, rowCount, columnCount)
        {
            var formulas = this._findFormulas(row,column,rowCount,columnCount);
            if(formulas && formulas.length > 0)
            {
                var arrayFormulas = [];
                var ranges = [];
                var count = formulas.length,
                    i;
                for(i = 0; i < count; i++)
                {
                    var formula = formulas[i][1];
                    if(formula && formula !== "" && formula[0] === "{" && formula[formula.length - 1] === "}")
                    {
                        ranges.push(formulas[i][0]);
                        arrayFormulas.push(formula)
                    }
                }
                if(arrayFormulas.length > 0)
                {
                    var ret = {};
                    for(i = 0; i < arrayFormulas.length; i++)
                    {
                        ret[i][0] = ranges[i];
                        ret[i][1] = arrayFormulas[i]
                    }
                    return ret
                }
            }
            return null
        },
        _raiseDragDropBlock: function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount, copy, insert, copyOption)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    fromRow: fromRow,
                    fromCol: fromColumn,
                    toRow: toRow,
                    toCol: toColumn,
                    rowCount: rowCount,
                    colCount: columnCount,
                    copy: copy,
                    insert: insert,
                    copyOption: copyOption,
                    cancel: false
                };
            this._trigger(UI.Events.DragDropBlock,args);
            return args && args.cancel === true
        },
        _raiseDragDropBlockCompleted: function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount, copy, insert, copyOption)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    fromRow: fromRow,
                    fromCol: fromColumn,
                    toRow: toRow,
                    toCol: toColumn,
                    rowCount: rowCount,
                    colCount: columnCount,
                    copy: copy,
                    insert: insert,
                    copyOption: copyOption
                };
            this._trigger(UI.Events.DragDropBlockCompleted,args)
        },
        _raiseInvalidOperation: function(message)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    message: message
                };
            this._trigger(UI.Events.InvalidOperation,args)
        },
        _suspendInvalidate: function()
        {
            this._layoutSuspended++
        },
        _resumeInvalidate: function()
        {
            this._layoutSuspended--;
            if(this._layoutSuspended <= 0)
            {
                if(!this.isPaintSuspended())
                {
                    this.invalidateLayout();
                    this.repaint()
                }
                this._layoutSuspended = 0
            }
        },
        _raiseSelectionChanging: function(oldSelections, newSelections)
        {
            var notEqual = this._eventHandler._notEqualSelecions(oldSelections,newSelections);
            if(notEqual === true)
            {
                this._trigger(UI.Events.SelectionChanging,{
                    sheet: this,
                    sheetName: this._name,
                    oldSelections: oldSelections,
                    newSelections: newSelections
                });
                return true
            }
            return false
        },
        _raiseSelectionChanged: function()
        {
            this._trigger(UI.Events.SelectionChanged,{
                sheet: this,
                sheetName: this._name
            })
        },
        _raiseDragFillBlock: function(fillRange, fillDirection, fillType)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    fillRange: fillRange,
                    autoFillType: fillType,
                    fillDirection: fillDirection,
                    cancel: false
                };
            this._trigger(UI.Events.DragFillBlock,args);
            return args && args.cancel === true
        },
        _raiseDragFillBlockCompleted: function(fillRange, fillDirection, fillType)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    fillRange: fillRange,
                    autoFillType: fillType,
                    fillDirection: fillDirection
                };
            this._trigger(UI.Events.DragFillBlockCompleted,args)
        },
        _raiseCellChanged: function(propertyName, row, column, sheetArea)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    col: column,
                    sheetArea: sheetArea,
                    propertyName: propertyName
                };
            this._trigger(UI.Events.CellChanged,args)
        },
        _raisePropertyChanged: function(propertyName){},
        _nextNonNullRow: function(row, rowHeader)
        {
            row++;
            var SheetArea = UI.SheetArea;
            var model = rowHeader ? this._getModel(SheetArea.rowHeader) : this._getModel(SheetArea.viewport);
            var count = model.rowCount;
            if(rowHeader === false && this._dataSource)
                count = Math.max(count,this._getDataLength(this._dataSource));
            while(row >= 0 && row < count)
            {
                if(model.dataTable.hasOwnProperty(row) && model.dataTable[row])
                    break;
                if(rowHeader === false && this._dataSource)
                    if(this._getDataItem(this._dataSource,row))
                        break;
                row++
            }
            if(row < count)
                return row;
            return-1
        },
        _nextNonNullColumn: function(row, col, columnHeader)
        {
            var dr = null;
            var SheetArea = UI.SheetArea;
            var model = columnHeader ? this._getModel(SheetArea.colHeader) : this._getModel(SheetArea.viewport);
            if(row >= 0 && row < model.rowCount)
                if(model.dataTable.hasOwnProperty(row))
                    dr = model.dataTable[row];
            if(columnHeader === false && !dr && this._dataSource)
                if(row >= 0 && row < this._getDataLength(this._dataSource))
                    dr = this._getDataItem(this._dataSource,row);
            if(!dr)
                return-1;
            col++;
            while(col >= 0 && (col < model.colCount || col < dr.length))
            {
                if(dr.hasOwnProperty(col) && dr[col])
                    break;
                if(columnHeader === false && this._dataSource)
                {
                    var value = this._getValueImp(model,row,col);
                    if(value !== undefined && value !== null)
                        break
                }
                col++
            }
            if(col < model.colCount || columnHeader === false && dr && col < dr.length)
                return col;
            return-1
        },
        _closeDragFillPopup: function()
        {
            if(this._smartTag)
                this._smartTag.close()
        },
        _cellRangeInflate: function(spans, cellRange)
        {
            if(spans && spans.length > 0)
                for(var i = 0; i < spans.length; i++)
                {
                    var cr = spans[i];
                    if(cellRange.intersect(cr.row,cr.col,cr.rowCount,cr.colCount))
                    {
                        spans.splice(i--,1);
                        return this._cellRangeInflate(spans,this._unionCellRange(cellRange,cr))
                    }
                }
            return cellRange
        },
        _unionCellRange: function(range1, range2)
        {
            var ltr = Math.min(range1.row,range2.row);
            var ltc = Math.min(range1.col,range2.col);
            var rbr = Math.max(range1.row + range1.rowCount - 1,range2.row + range2.rowCount - 1);
            var rbc = Math.max(range1.col + range1.colCount - 1,range2.col + range2.colCount - 1);
            var Range = UI.Range;
            if(ltr >= 0 && ltc >= 0)
                return new Range(ltr,ltc,rbr - ltr + 1,rbc - ltc + 1);
            else if(ltr >= 0)
                return new Range(ltr,-1,rbr - ltr + 1,-1);
            else if(ltc >= 0)
                return new Range(-1,ltc,-1,rbc - ltc + 1);
            else
                return new Range(-1,-1,-1,-1)
        },
        _getClipboardHelper: function()
        {
            if(!this._clipboardHelper && this.parent && this.parent._clipboardHelper)
                this._clipboardHelper = this.parent._clipboardHelper;
            else if(!this._clipboardHelper)
                this._clipboardHelper = {
                    fromSheet: null,
                    range: null,
                    isCutting: false
                };
            return this._clipboardHelper
        },
        _checkPastedRange: function(fromSheet, fromRange, toRange, isCutting, clipboardText, outPara)
        {
            var msg_sheetViewPasteSouceSheetCellsAreLocked = "Source sheet's cells are locked.";
            var msg_sheetViewTheCopyAreaAndPasteAreaAreNotTheSameSize = "The copy and paste areas are not the same size.";
            var msg_sheetViewPasteDestinationSheetCellsAreLocked = "The cell you are trying to change is protected and therefore read-only.";
            var msg_sheetViewPasteChangeMergeCell = "Cannot change part of a merged cell.";
            var msg_sheetViewPasteChangePartOfArrayFormula = "Cannot change part of an array.";
            outPara.pastedInternal = false;
            outPara.pastedRange = null;
            if(!fromSheet && (!clipboardText || clipboardText === ""))
                return false;
            var toSheet = this;
            if(this._isPastedInternal(fromSheet,fromRange,toSheet,clipboardText) || !clipboardText)
            {
                outPara.pastedInternal = true;
                if(isCutting && fromSheet.isProtected && fromSheet._isAnyCellInRangeLocked(fromRange))
                {
                    this._raiseInvalidOperation(msg_sheetViewPasteSouceSheetCellsAreLocked);
                    return false
                }
                outPara.pastedRange = this._getPastedRange(fromSheet,fromRange,toSheet,toRange,isCutting)
            }
            else
                outPara.pastedRange = this._getPastedRangefromText(toRange,clipboardText);
            if(!outPara.pastedRange)
            {
                this._raiseInvalidOperation(msg_sheetViewTheCopyAreaAndPasteAreaAreNotTheSameSize);
                return false
            }
            if(toSheet.isProtected && toSheet._isAnyCellInRangeLocked(outPara.pastedRange))
            {
                this._raiseInvalidOperation(msg_sheetViewPasteDestinationSheetCellsAreLocked);
                return false
            }
            if(outPara.pastedInternal)
            {
                if(fromSheet._hasPartSpans(fromRange.row,fromRange.col,fromRange.rowCount,fromRange.colCount))
                {
                    this._raiseInvalidOperation(msg_sheetViewPasteChangeMergeCell);
                    return false
                }
                if(fromSheet._hasPartArrayFormulas(fromRange.row,fromRange.col,fromRange.rowCount,fromRange.colCount))
                {
                    this._raiseInvalidOperation(msg_sheetViewPasteChangePartOfArrayFormula);
                    return false
                }
                var toRowCount = outPara.pastedRange.row < 0 ? toSheet.getRowCount() : outPara.pastedRange.rowCount;
                var toColumnCount = outPara.pastedRange.col < 0 ? toSheet.getColumnCount() : outPara.pastedRange.colCount;
                var rowCount = fromRange.row < 0 ? fromSheet.getRowCount() : fromRange.rowCount;
                var columnCount = fromRange.Column < 0 ? fromSheet.getColumnCount() : fromRange.colCount;
                if(toRowCount > rowCount || toColumnCount > columnCount)
                {
                    var toRow = toRange.row;
                    var toColumn = toRange.col;
                    if(toRange.row < 0 && rowCount < toSheet.getRowCount())
                        toRow = 0;
                    if(toRange.col < 0 && columnCount < toSheet.getColumnCount())
                        toColumn = 0;
                    if(toRowCount % rowCount !== 0 || toColumnCount % columnCount !== 0)
                    {
                        toRowCount = rowCount;
                        toColumnCount = columnCount;
                        outPara.pastedRange = new UI.Range(toRow,toColumn,toRowCount,toColumnCount)
                    }
                    var rn = Math.floor(toRowCount / rowCount);
                    var cn = Math.floor(toColumnCount / columnCount);
                    for(var r = 0; r < rn; r++)
                        for(var c = 0; c < cn; c++)
                        {
                            if(toSheet._hasPartSpans(toRow < 0 ? -1 : toRow + r * rowCount,toColumn < 0 ? -1 : toColumn + c * columnCount,toRow < 0 ? -1 : rowCount,toColumn < 0 ? -1 : columnCount))
                            {
                                this._raiseInvalidOperation(msg_sheetViewPasteChangeMergeCell);
                                return false
                            }
                            if(toSheet._hasPartArrayFormulas(toRow < 0 ? -1 : toRow + r * rowCount,toColumn < 0 ? -1 : toColumn + c * columnCount,toRow < 0 ? -1 : rowCount,toColumn < 0 ? -1 : columnCount))
                            {
                                this._raiseInvalidOperation(msg_sheetViewPasteChangePartOfArrayFormula);
                                return false
                            }
                        }
                }
                else
                {
                    if(toSheet._hasPartSpans(outPara.pastedRange.row,outPara.pastedRange.col,outPara.pastedRange.rowCount,outPara.pastedRange.colCount))
                    {
                        this._raiseInvalidOperation(msg_sheetViewPasteChangeMergeCell);
                        return false
                    }
                    if(toSheet._hasPartArrayFormulas(outPara.pastedRange.row,outPara.pastedRange.col,outPara.pastedRange.rowCount,outPara.pastedRange.colCount))
                    {
                        this._raiseInvalidOperation(msg_sheetViewPasteChangePartOfArrayFormula);
                        return false
                    }
                }
            }
            else
            {
                if(toSheet._hasPartSpans(outPara.pastedRange.row,outPara.pastedRange.col,outPara.pastedRange.rowCount,outPara.pastedRange.colCount))
                {
                    this._raiseInvalidOperation(msg_sheetViewPasteChangeMergeCell);
                    return false
                }
                if(toSheet._hasPartArrayFormulas(outPara.pastedRange.row,outPara.pastedRange.col,outPara.pastedRange.rowCount,outPara.pastedRange.colCount))
                {
                    this._raiseInvalidOperation(msg_sheetViewPasteChangePartOfArrayFormula);
                    return false
                }
                if(outPara.pastedRange.row + outPara.pastedRange.rowCount > toSheet.getRowCount() || outPara.pastedRange.col + outPara.pastedRange.colCount > toSheet.getColumnCount())
                {
                    this._raiseInvalidOperation(msg_sheetViewTheCopyAreaAndPasteAreaAreNotTheSameSize);
                    return false
                }
            }
            return true
        },
        _isPastedInternal: function(srcSheet, srcRange, destSheet, clipboadText)
        {
            return srcSheet && srcRange && destSheet && srcSheet.getCsv(srcRange.row,srcRange.col,srcRange.rowCount,srcRange.colCount,"\r\n","\t") === clipboadText
        },
        _getPastedRange: function(fromSheet, fromRange, toSheet, toRange, isCutting)
        {
            var fromRow = fromRange.row < 0 ? 0 : fromRange.row;
            var fromColumn = fromRange.col < 0 ? 0 : fromRange.col;
            var fromRowCount = fromRange.row < 0 ? fromSheet.getRowCount() : fromRange.rowCount;
            var fromColumnCount = fromRange.col < 0 ? fromSheet.getColumnCount() : fromRange.colCount;
            var toRow = toRange.row < 0 ? 0 : toRange.row;
            var toColumn = toRange.col < 0 ? 0 : toRange.col;
            var toRowCount = toRange.row < 0 ? toSheet.getRowCount() : toRange.rowCount;
            var toColumnCount = toRange.col < 0 ? toSheet.getColumnCount() : toRange.colCount;
            if(isCutting || toRowCount % fromRowCount !== 0 || toColumnCount % fromColumnCount !== 0)
            {
                toRowCount = fromRowCount;
                toColumnCount = fromColumnCount
            }
            if(!this._isValidRange(fromRow,fromColumn,fromRowCount,fromColumnCount,fromSheet.getRowCount(),fromSheet.getColumnCount()))
                return null;
            if(!this._isValidRange(toRow,toColumn,toRowCount,toColumnCount,toSheet.getRowCount(),toSheet.getColumnCount()))
                return null;
            var fixedToRange = new UI.Range(toRow,toColumn,toRowCount,toColumnCount);
            if(!isCutting && fromSheet._name === toSheet._name)
                if(fixedToRange.contains(fromRow,fromColumn,fromRowCount,fromColumnCount))
                {
                    if((fromRow - toRow) % fromRowCount !== 0 || (fromColumn - toColumn) % fromColumnCount !== 0)
                        return null
                }
                else if(fixedToRange.intersect(fromRow,fromColumn,fromRowCount,fromColumnCount))
                    if(toRowCount > fromRowCount || toColumnCount > fromColumnCount)
                        return null;
            if(toRange.row === -1)
            {
                toRow = -1;
                toRowCount = -1
            }
            if(toRange.col === -1)
            {
                toColumn = -1;
                toColumnCount = -1
            }
            return new UI.Range(toRow,toColumn,toRowCount,toColumnCount)
        },
        _getPastedRangefromText: function(toRange, clipboadText)
        {
            var ret = null;
            var textArray = staticMembers.parseCsv(clipboadText,"\r\n","\t","\"");
            if(textArray)
            {
                var row = toRange.row < 0 ? 0 : toRange.row;
                var column = toRange.col < 0 ? 0 : toRange.col;
                var rowCount = textArray.length;
                var columnCount = staticMembers.getMaxLength(textArray);
                ret = new UI.Range(row,column,rowCount,columnCount)
            }
            return ret
        },
        _getClipboardData: function()
        {
            try
            {
                if(window.clipboardData && window.clipboardData.getData)
                    return window.clipboardData.getData("Text")
            }
            catch(e)
            {
                return null
            }
        },
        _clearClipboard: function()
        {
            try
            {
                if(window.clipboardData && window.clipboardData.clearData)
                    window.clipboardData.clearData("Text")
            }
            catch(e){}
        },
        _clipboardPaste: function(fromSheet, fromRange, toSheet, toRange, isCutting, clipboardText, option)
        {
            if(fromSheet && toSheet._name === fromSheet._name && toSheet.parent && !toSheet.parent.sheets.contains(fromSheet))
            {
                this._clearClipboard();
                return
            }
            var toRow,
                toColumn,
                rowCount,
                columnCount,
                r,
                c;
            if(fromSheet && fromRange)
            {
                var convertPasteOption = UI.UndoRedo.ClipboardPasteRangeUndoAction.convertPasteOption;
                if(isCutting)
                {
                    staticMembers.moveTo(fromSheet,fromRange.row,fromRange.col,toSheet,toRange.row,toRange.col,fromRange.rowCount,fromRange.colCount,convertPasteOption(option));
                    this._clearClipboard()
                }
                else
                {
                    var toRowCount = toRange.row < 0 ? toSheet.getRowCount() : toRange.rowCount;
                    var toColumnCount = toRange.col < 0 ? toSheet.getColumnCount() : toRange.colCount;
                    rowCount = fromRange.row < 0 ? fromSheet.getRowCount() : fromRange.rowCount;
                    columnCount = fromRange.col < 0 ? fromSheet.getColumnCount() : fromRange.colCount;
                    if(toRowCount > rowCount || toColumnCount > columnCount)
                    {
                        toRow = toRange.row;
                        toColumn = toRange.col;
                        if(toRange.row < 0 && rowCount < toSheet.getRowCount())
                            toRow = 0;
                        if(toRange.col < 0 && columnCount < toSheet.getColumnCount())
                            toColumn = 0;
                        if(toRowCount % rowCount !== 0 || toColumnCount % columnCount !== 0)
                        {
                            toRowCount = rowCount;
                            toColumnCount = columnCount
                        }
                        var rn = Math.floor(toRowCount / rowCount);
                        var cn = Math.floor(toColumnCount / columnCount);
                        fromSheet.suspendCalcService();
                        toSheet.suspendCalcService();
                        try
                        {
                            for(r = 0; r < rn; r++)
                                for(c = 0; c < cn; c++)
                                    staticMembers.copyTo(fromSheet,fromRange.row,fromRange.col,toSheet,toRow < 0 ? -1 : toRow + r * rowCount,toColumn < 0 ? -1 : toColumn + c * columnCount,toRow < 0 ? -1 : rowCount,toColumn < 0 ? -1 : columnCount,convertPasteOption(option))
                        }
                        finally
                        {
                            fromSheet.resumeCalcService();
                            toSheet.resumeCalcService()
                        }
                    }
                    else
                        staticMembers.copyTo(fromSheet,fromRange.row,fromRange.col,toSheet,toRange.row,toRange.col,fromRange.rowCount,fromRange.colCount,convertPasteOption(option))
                }
            }
            else
            {
                toRow = toRange.row;
                toColumn = toRange.col;
                rowCount = toRange.rowCount;
                columnCount = toRange.colCount;
                var spanEnumerator = toSheet._spanModel.getEnumerator(toRow,toColumn,rowCount,columnCount);
                while(spanEnumerator.moveNext())
                {
                    var cs = spanEnumerator.current();
                    if(cs)
                        toSheet._spanModel.remove(cs)
                }
                if(!clipboardText || clipboardText === "")
                    for(r = 0; r < rowCount; r++)
                        for(c = 0; c < columnCount; c++)
                            toSheet.setValue(toRow + r,toColumn + c,null);
                else
                    toSheet.setCsv(toRow,toColumn,clipboardText,"\r\n","\t",UI.TextFileOpenFlags.ImportFormula)
            }
        },
        _raiseClipboardPasting: function(cellRange, pastOption)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    cellRange: cellRange,
                    pastOption: pastOption,
                    cancel: false
                };
            this._trigger(UI.Events.ClipboardPasting,args);
            return args.cancel === true
        },
        _raiseClipboardPasted: function(cellRange, pastOption)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    cellRange: cellRange,
                    pastOption: pastOption
                };
            this._trigger(UI.Events.ClipboardPasted,args)
        },
        _raiseValueChanged: function(row, column)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    col: column
                };
            this._trigger(UI.Events.ValueChanged,args)
        },
        _raiseRangeDataChanged: function(row, column, rowCount, columnCount)
        {
            var args = {
                    sheet: this,
                    sheetName: this._name,
                    row: row,
                    column: column,
                    rowCount: rowCount,
                    columnCount: columnCount
                };
            this._trigger(UI.Events.RangeChanged,args)
        },
        _copyFormula: function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount)
        {
            staticMembers.copyFormula(this,fromRow,fromColumn,this,toRow,toColumn,rowCount,columnCount)
        }
    }
})(window,jQuery);
(function(window)
{
    "use strict";;
    var GrapeCity = window.GrapeCity;
    if(typeof GrapeCity === "undefined")
        GrapeCity = window.GrapeCity = {};
    if(typeof GrapeCity.UI === "undefined")
        GrapeCity.UI = {};
    var UI = GrapeCity.UI;
    UI.AutoFillType = {
        CopyCells: 0,
        FillSeries: 1,
        FillFormattingOnly: 2,
        FillWithoutFormatting: 3,
        ClearValues: 4
    };
    var AutoFillType = UI.AutoFillType;
    UI.FillDirection = {
        Left: 0,
        Right: 1,
        Up: 2,
        Down: 3
    };
    var FillDirection = UI.FillDirection;
    UI.FillSeries = {
        Column: 0,
        Row: 1
    };
    var FillSeries = UI.FillSeries;
    UI.StorageType = {
        Data: 0x01,
        Style: 0x02,
        Sparkline: 0x10,
        Axis: 0x20,
        BindingPath: 0x40
    };
    var StorageType = UI.StorageType;
    UI.DragFillDirection = {
        Left: 0,
        Right: 1,
        Up: 2,
        Down: 3,
        LeftClear: 4,
        UpClear: 5
    };
    var DragFillDirection = UI.DragFillDirection;
    function CopyMoveSheetInfo(){}
    function __navigateNoWrap(sheet, direction)
    {
        if(sheet && sheet._editorStatus !== UI.EditorStatus.Edit)
        {
            sheet.moveActiveCell(direction,false);
            return true
        }
        return false
    }
    function __navigateNoWrapFrom(sheet, direction, row, col)
    {
        if(sheet && sheet._editorStatus !== UI.EditorStatus.Edit)
            sheet.moveActiveCell(direction,false,row,col)
    }
    function __alterSelection(sheet, key, isCtrl)
    {
        if(sheet && sheet._editorStatus !== UI.EditorStatus.Edit)
        {
            sheet.endEdit();
            sheet._changeActiveSelectedRange(key,isCtrl)
        }
    }
    function CellData(row, column, value)
    {
        this.row = row;
        this.column = column;
        this.value = value
    }
    function CopyMoveCellsInfo(rowCount, columnCount)
    {
        this._rowCount = rowCount;
        this._columnCount = columnCount;
        this._init()
    }
    CopyMoveCellsInfo.prototype = {
        _init: function()
        {
            this._values = [];
            this._formulas = [];
            this._sparklines = [];
            this._styles = [];
            this._tags = [];
            this._bindingPaths = [];
            this._spans = null;
            this._arrayFormulas = null;
            this._valueSaved = false;
            this._formulaSaved = false;
            this._sparklineSaved = false;
            this._styleSaved = false;
            this._tagSaved = false;
            this._spanSaved = false;
            this._arrayFormulaSaved = false;
            this._bindingPathSaved = false
        },
        saveValue: function(row, column, value)
        {
            if(value !== undefined && value !== null)
                this._values.push(new CellData(row,column,value));
            this._valueSaved = true
        },
        getValues: function()
        {
            return this._values
        },
        saveFormula: function(row, column, formula)
        {
            if(formula && formula !== "")
                this._formulas.push(new CellData(row,column,formula));
            this._formulaSaved = true
        },
        getFormulas: function()
        {
            return this._formulas
        },
        saveArrayFormula: function(arrayFormulas)
        {
            this._arrayFormulas = arrayFormulas;
            this._arrayFormulaSaved = true
        },
        getArrayFormula: function()
        {
            return this._arrayFormulas
        },
        saveSparkline: function(row, column, sparkline)
        {
            if(sparkline)
                this._sparklines.push(new CellData(row,column,sparkline));
            this._sparklineSaved = true
        },
        getSparklines: function()
        {
            return this._sparklines
        },
        saveStyle: function(row, column, style)
        {
            if(style)
                this._styles.push(new CellData(row,column,style));
            this._styleSaved = true
        },
        getStyles: function()
        {
            return this._styles
        },
        saveTag: function(row, column, tag)
        {
            if(tag !== undefined && tag !== null)
                this._tags.push(new CellData(row,column,tag));
            this._tagSaved = true
        },
        getTags: function()
        {
            return this._tags
        },
        saveBindingPath: function(row, column, path)
        {
            if(path !== undefined && path !== null)
                this._bindingPaths.push(new CellData(row,column,path));
            this._bindingPathSaved = true
        },
        getBindingPaths: function()
        {
            return this._bindingPaths
        },
        saveSpan: function(span)
        {
            if(!this._spans)
                this._spans = [];
            this._spans.push(span);
            this._spanSaved = true
        },
        isValueSaved: function()
        {
            return this._valueSaved
        },
        isFormulaSaved: function()
        {
            return this._formulaSaved
        },
        isArrayFormulaSaved: function()
        {
            return this._arrayFormulaSaved
        },
        isSparklineSaved: function()
        {
            return this._sparklineSaved
        },
        isStyleSaved: function()
        {
            return this._styleSaved
        },
        isTagSaved: function()
        {
            return this._tagSaved
        },
        isSpanSaved: function()
        {
            return this._spanSaved
        },
        isBindingPathSaved: function()
        {
            return this._bindingPathSaved
        }
    };
    function CopyMoveColumnsInfo(columnCount)
    {
        this._columnCount = columnCount;
        this._init()
    }
    CopyMoveColumnsInfo.prototype = {
        _init: function()
        {
            this._widths = {};
            this._visibles = {};
            this._resizables = {};
            this._tags = {};
            this._viewportColumnStyles = {};
            this._headerColumnStyles = {};
            this._levels = {};
            this._collapsed = {};
            this._bindingFields = {};
            this._widthSaved = false;
            this._visibleSaved = false;
            this._resizableSaved = false;
            this._tagSaved = false;
            this._viewportColumnStyleSaved = false;
            this._headerColumnStyleSaved = false;
            this._rangeGroupSaved = false;
            this._bindingFieldSaved = false
        },
        saveWidth: function(index, width)
        {
            if(this._widths[index] !== null)
                if(width < 0)
                    this._widths[index] = null;
                else
                    this._widths[index] = width;
            else if(width >= 0)
                this._widths[index] = width;
            this._widthSaved = true
        },
        getWidth: function(index)
        {
            if(this._widths[index] !== null)
                return this._widths[index];
            return-1
        },
        saveVisible: function(index, visible)
        {
            if(this._visibles[index] !== null)
                if(visible)
                    this._visibles[index] = null;
                else
                    this._visibles[index] = visible;
            else if(!visible)
                this._visibles[index] = visible;
            this._visibleSaved = true
        },
        getVisible: function(index)
        {
            if(this._visibles[index] !== null)
                return this._visibles[index];
            return true
        },
        saveResizable: function(index, resizable)
        {
            if(this._resizables[index] !== null)
                if(resizable)
                    this._resizables[index] = null;
                else
                    this._resizables[index] = resizable;
            else if(!resizable)
                this._resizables[index] = resizable;
            this._resizableSaved = true
        },
        getResizable: function(index)
        {
            if(this._resizables[index] !== null)
                return this._resizables[index];
            return true
        },
        saveTag: function(index, tag)
        {
            if(this._tags[index] !== null)
                if(tag === undefined || tag === null)
                    this._tags[index] = null;
                else
                    this._tags[index] = tag;
            else if(tag !== null)
                this._tags[index] = tag;
            this._tagSaved = true
        },
        getTag: function(index)
        {
            if(this._tags[index] !== null)
                return this._tags[index];
            return null
        },
        saveViewportColumnStyle: function(index, style)
        {
            if(this._viewportColumnStyles[index])
                if(!style)
                    this._viewportColumnStyles[index] = null;
                else
                    this._viewportColumnStyles[index] = style;
            else if(style)
                this._viewportColumnStyles[index] = style;
            this._viewportColumnStyleSaved = true
        },
        getViewportColumnStyle: function(index)
        {
            if(this._viewportColumnStyles[index])
                return this._viewportColumnStyles[index];
            return null
        },
        saveHeaderColumnStyle: function(index, style)
        {
            if(this._headerColumnStyles[index])
                if(!style)
                    this._headerColumnStyles[index] = null;
                else
                    this._headerColumnStyles[index] = style;
            else if(style)
                this._headerColumnStyles[index] = style;
            this._headerColumnStyleSaved = true
        },
        getHeaderColumnStyle: function(index)
        {
            if(this._headerColumnStyles[index])
                return this._headerColumnStyles[index];
            return null
        },
        saveRangeGroup: function(index, level, collapsed)
        {
            if(this._levels[index] !== null)
                if(level < 0)
                    this._levels[index] = null;
                else
                    this._levels[index] = level;
            else if(level >= 0)
                this._levels[index] = level;
            if(this._collapsed[index] !== null)
                if(collapsed)
                    this._collapsed[index] = collapsed;
                else
                    this._collapsed[index] = null;
            else if(collapsed)
                this._collapsed[index] = collapsed;
            this._rangeGroupSaved = true
        },
        getRangeGroup: function(index, outData)
        {
            outData.level = -1;
            outData.collapsed = false;
            if(this._levels[index] !== null)
                outData.level = this._levels[index];
            if(this._collapsed[index] !== null)
                outData.collapsed = this._collapsed[index]
        },
        saveBindingField: function(index, fieldName)
        {
            this._bindingFields[index] = fieldName;
            this._bindingFieldSaved = true
        },
        getBindingField: function(index, outData)
        {
            outData.fieldName = null;
            if(this._bindingFields[index] !== null)
            {
                outData.fieldName = this._bindingFields[index];
                return true
            }
            return false
        },
        isWidthSaved: function()
        {
            return this._widthSaved
        },
        isVisibleSaved: function()
        {
            return this._visibleSaved
        },
        isResizableSaved: function()
        {
            return this._resizableSaved
        },
        isTagSaved: function()
        {
            return this._tagSaved
        },
        isViewportColumnStyleSaved: function()
        {
            return this._viewportColumnStyleSaved
        },
        isHeaderColumnStyleSaved: function()
        {
            return this._headerColumnStyleSaved
        },
        isRangeGroupSaved: function()
        {
            return this._rangeGroupSaved
        },
        isBindingFieldSaved: function()
        {
            return this._bindingFieldSaved
        }
    };
    var CopyMoveHelper = {
            getStyleObject: function(sheet, row, column, area)
            {
                return sheet.getStyle(row,column,area)
            },
            setStyleObject: function(sheet, row, column, area, style)
            {
                if(typeof style !== "string")
                    sheet.setStyle(row,column,style,area)
            },
            saveSheetInfo: function(sheet, sheetInfo, option)
            {
                if((option & UI.CopyToOption.Style) > 0)
                {
                    sheetInfo.saveDefaultStyle(sheet.getDefaultStyle());
                    sheetInfo.saveColumnHeaderDefaultStyle(sheet.getDefaultStyle(UI.SheetArea.colHeader));
                    sheetInfo.saveRowHeaderDefaultStyle(sheet.getDefaultStyle(UI.SheetArea.rowHeader))
                }
                sheetInfo.saveDefaultColumnWidth(sheet.defaults.colWidth);
                sheetInfo.saveDefaultRowHeight(sheet.defaults.rowHeight);
                sheetInfo.saveColumnHeaderDefaultRowHeight(sheet.defaults.rowHeight);
                sheetInfo.saveRowHeaderDefaultColumnWidth(sheet.defaults.rowHeaderColWidth)
            },
            saveColumnHeaderInfo: function(sheet, headerCellsInfo, columnsInfo, baseColumn, option)
            {
                var rowCount = headerCellsInfo._rowCount;
                var columnCount = headerCellsInfo._columnCount;
                var r,
                    c;
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                    {
                        if((option & UI.CopyToOption.Value) > 0)
                        {
                            var value = sheet._getModel(UI.SheetArea.colHeader).getValue(r,baseColumn + c);
                            headerCellsInfo.saveValue(r,c,value)
                        }
                        if((option & UI.CopyToOption.Style) > 0)
                            headerCellsInfo.saveStyle(r,c,CopyMoveHelper.getStyleObject(sheet,r,baseColumn + c,UI.SheetArea.colHeader))
                    }
                if((option & UI.CopyToOption.Value) > 0)
                    for(c = 0; c < columnCount; c++)
                        if(sheet.isColumnBound(baseColumn + c))
                            columnsInfo.saveBindingField(c,sheet.getDataColumnName(baseColumn + c));
                if((option & UI.CopyToOption.Span) > 0)
                {
                    var spanEnumerator = sheet._colHeaderSpanModel.getEnumerator(0,baseColumn,rowCount,columnCount);
                    while(spanEnumerator.moveNext())
                        headerCellsInfo.saveSpan(spanEnumerator.current())
                }
                columnCount = columnsInfo._columnCount;
                for(c = 0; c < columnCount; c++)
                {
                    columnsInfo.saveWidth(c,sheet._getActualColumnWidth(baseColumn + c));
                    columnsInfo.saveVisible(c,sheet.getColumnVisible(baseColumn + c));
                    columnsInfo.saveResizable(c,sheet.getColumnResizable(baseColumn + c))
                }
                if((option & UI.CopyToOption.Style) > 0)
                    for(c = 0; c < columnCount; c++)
                    {
                        columnsInfo.saveViewportColumnStyle(c,CopyMoveHelper.getStyleObject(sheet,-1,baseColumn + c,UI.SheetArea.viewport));
                        columnsInfo.saveHeaderColumnStyle(c,CopyMoveHelper.getStyleObject(sheet,-1,baseColumn + c,UI.SheetArea.colHeader))
                    }
                if((option & UI.CopyToOption.RangeGroup) > 0)
                {
                    var group = sheet.colRangeGroup;
                    if(group && !group._isEmpty())
                        for(c = 0; c < columnCount; c++)
                            columnsInfo.saveRangeGroup(c,group.getLevel(baseColumn + c),group.getCollapsed(baseColumn + c))
                }
            },
            saveRowHeaderInfo: function(sheet, headerCellsInfo, rowsInfo, baseRow, option)
            {
                if((option & UI.CopyToOption.All) <= 0)
                    return;
                var rowCount = headerCellsInfo._rowCount;
                var columnCount = headerCellsInfo._columnCount;
                var r,
                    c;
                for(r = 0; r < rowCount; r++)
                    for(c = 0; c < columnCount; c++)
                    {
                        if((option & UI.CopyToOption.Value) > 0)
                        {
                            var value = sheet._getModel(UI.SheetArea.rowHeader).getValue(baseRow + r,c);
                            headerCellsInfo.saveValue(r,c,value)
                        }
                        if((option & UI.CopyToOption.Style) > 0)
                            headerCellsInfo.saveStyle(r,c,CopyMoveHelper.getStyleObject(sheet,baseRow + r,c,UI.SheetArea.rowHeader))
                    }
                if((option & UI.CopyToOption.Span) > 0)
                {
                    var spanEnumerator = sheet._rowHeaderSpanModel.getEnumerator(baseRow,0,rowCount,columnCount);
                    while(spanEnumerator.moveNext())
                        headerCellsInfo.saveSpan(spanEnumerator.current())
                }
                rowCount = rowsInfo._rowCount;
                for(r = 0; r < rowCount; r++)
                {
                    rowsInfo.saveHeight(r,sheet._getActualRowHeight(baseRow + r));
                    rowsInfo.saveVisible(r,sheet.getRowVisible(baseRow + r));
                    rowsInfo.saveResizable(r,sheet.getRowResizable(baseRow + r))
                }
                if((option & UI.CopyToOption.Style) > 0)
                    for(r = 0; r < rowCount; r++)
                    {
                        rowsInfo.saveViewportRowStyle(r,CopyMoveHelper.getStyleObject(sheet,baseRow + r,-1,UI.SheetArea.viewport));
                        rowsInfo.saveHeaderRowStyle(r,CopyMoveHelper.getStyleObject(sheet,baseRow + r,-1,UI.SheetArea.rowHeader))
                    }
                if((option & UI.CopyToOption.RangeGroup) > 0)
                {
                    var group = sheet.rowRangeGroup;
                    if(group && !group._isEmpty())
                        for(r = 0; r < rowCount; r++)
                            rowsInfo.saveRangeGroup(r,group.getLevel(baseRow + r),group.getCollapsed(baseRow + r))
                }
            },
            saveViewportInfo: function(sheet, cellsInfo, baseRow, baseColumn, option)
            {
                if((option & UI.CopyToOption.All) <= 0)
                    return;
                var rowCount = cellsInfo._rowCount;
                var columnCount = cellsInfo._columnCount;
                for(var r = 0; r < rowCount; r++)
                    for(var c = 0; c < columnCount; c++)
                    {
                        if((option & UI.CopyToOption.Value) > 0)
                            cellsInfo.saveValue(r,c,sheet.getValue(baseRow + r,baseColumn + c,UI.SheetArea.viewport));
                        if((option & UI.CopyToOption.Value) > 0 || (option & UI.CopyToOption.Formula) > 0)
                        {
                            cellsInfo.saveFormula(r,c,sheet.getFormula(baseRow + r,baseColumn + c));
                            var arrayFormulas = sheet._getsArrayFormulas(baseRow,baseColumn,rowCount,columnCount);
                            cellsInfo.saveArrayFormula(arrayFormulas)
                        }
                        if((option & UI.CopyToOption.Sparkline) > 0)
                        {
                            var sparkline = sheet.getSparkline(baseRow + r,baseColumn + c);
                            var dataRange = null;
                            var dataAxisRange = null;
                            if(sparkline)
                            {
                                dataRange = sparkline.data();
                                dataAxisRange = sparkline.dateAxisData()
                            }
                            if(sparkline && dataRange)
                                cellsInfo.saveSparkline(r,c,sparkline.clone());
                            else
                                cellsInfo.saveSparkline(r,c,null)
                        }
                        if((option & UI.CopyToOption.Style) > 0)
                            cellsInfo.saveStyle(r,c,CopyMoveHelper.getStyleObject(sheet,baseRow + r,baseColumn + c,UI.SheetArea.viewport));
                        if((option & UI.CopyToOption.BindingPath) > 0)
                            cellsInfo.saveBindingPath(r,c,sheet.getBindingPath(baseRow + r,baseColumn + c,UI.SheetArea.viewport))
                    }
                if((option & UI.CopyToOption.Span) > 0)
                {
                    var spanEnumerator = sheet._spanModel.getEnumerator(baseRow,baseColumn,rowCount,columnCount);
                    while(spanEnumerator.moveNext())
                        cellsInfo.saveSpan(spanEnumerator.current())
                }
            },
            undoCellsInfo: function(sheet, cellsInfo, baseRow, baseColumn, area)
            {
                var rowCount = cellsInfo._rowCount;
                var columnCount = cellsInfo._columnCount;
                var key,
                    cs,
                    cr,
                    formula,
                    count,
                    i;
                sheet.suspendCalcService();
                try
                {
                    for(var r = 0; r < rowCount; r++)
                        for(var c = 0; c < columnCount; c++)
                        {
                            if(cellsInfo.isBindingPathSaved())
                                sheet.setBindingPath(baseRow + r,baseColumn + c,null,area);
                            if(cellsInfo.isFormulaSaved() && area === UI.SheetArea.viewport)
                                sheet.setFormula(baseRow + r,baseColumn + c,null);
                            if(cellsInfo.isSparklineSaved() && area === UI.SheetArea.viewport)
                                sheet.removeSparkline(baseRow + r,baseColumn + c);
                            if(cellsInfo.isValueSaved())
                                sheet.setValue(baseRow + r,baseColumn + c,null,area);
                            if(cellsInfo.isStyleSaved())
                                CopyMoveHelper.setStyleObject(sheet,baseRow + r,baseColumn + c,area,null)
                        }
                    if(cellsInfo.isBindingPathSaved())
                    {
                        var paths = cellsInfo.getBindingPaths();
                        for(key = 0; key < paths.length; key++)
                        {
                            var p = paths[key];
                            sheet.setBindingPath(baseRow + p.row,baseColumn + p.column,p.value,area)
                        }
                    }
                    if(cellsInfo.isFormulaSaved() && area === UI.SheetArea.viewport)
                    {
                        var formulas = cellsInfo.getFormulas();
                        for(key = 0; key < formulas.length; key++)
                        {
                            formula = formulas[key];
                            sheet.setFormula(baseRow + formula.row,baseColumn + formula.column,formula.value)
                        }
                    }
                    if(cellsInfo.isSparklineSaved() && area === UI.SheetArea.viewport)
                    {
                        var sparklines = cellsInfo.getSparklines();
                        for(var s = 0; s < sparklines.length; s++)
                        {
                            var item = sparklines[s];
                            var sparkline = item.value;
                            if(!sparkline)
                                sheet.removeSparkline(baseRow + item.row,baseColumn + item.column);
                            else if(!sparkline.dateAxisData())
                                sheet.setSparkline(baseRow + item.row,baseColumn + item.column,sparkline.data(),sparkline.dataOrientation(),sparkline.sparklineType(),sparkline.setting());
                            else
                                sheet.setSparkline(baseRow + item.row,baseColumn + item.column,sparkline.data(),sparkline.dataOrientation(),sparkline.sparklineType(),sparkline.setting(),sparkline.dateAxisData(),sparkline.dateAxisOrientation())
                        }
                    }
                    if(cellsInfo.isValueSaved())
                    {
                        var values = cellsInfo.getValues();
                        for(key = 0; key < values.length; key++)
                        {
                            var v = values[key];
                            sheet.setValue(baseRow + v.row,baseColumn + v.column,v.value,area)
                        }
                    }
                    if(cellsInfo.isStyleSaved())
                    {
                        var styles = cellsInfo.getStyles();
                        for(key = 0; key < styles.length; key++)
                        {
                            var style = styles[key];
                            CopyMoveHelper.setStyleObject(sheet,baseRow + style.row,baseColumn + style.column,area,style.value)
                        }
                    }
                    if(cellsInfo.isArrayFormulaSaved() && area === UI.SheetArea.viewport)
                    {
                        var arrayFormulas = sheet._getsArrayFormulas(baseRow,baseColumn,rowCount,columnCount);
                        if(arrayFormulas && arrayFormulas.length > 0)
                        {
                            count = arrayFormulas.getLength(0);
                            for(i = 0; i < count; i++)
                            {
                                cr = arrayFormulas[i][0];
                                sheet.setFormula(cr.row,cr.col,cr.rowCount,cr.colCount,null)
                            }
                        }
                        arrayFormulas = cellsInfo.getArrayFormula();
                        if(arrayFormulas && arrayFormulas.length > 0)
                        {
                            count = arrayFormulas.getLength(0);
                            for(i = 0; i < count; i++)
                            {
                                cr = arrayFormulas[i][0];
                                formula = arrayFormulas[i][1];
                                if(formula.StartsWith("{") && formula.EndsWith("}"))
                                    formula = formula.substring(1,formula.length - 2);
                                sheet.setFormula(cr.row,cr.col,cr.rowCount,cr.colCount,formula)
                            }
                        }
                    }
                }
                finally
                {
                    sheet.resumeCalcService()
                }
                var spanModel = null;
                if(area === UI.SheetArea.viewport)
                    spanModel = sheet._spanModel;
                else if(area === UI.SheetArea.colHeader)
                    spanModel = sheet._colHeaderSpanModel;
                else if(area === UI.SheetArea.rowHeader)
                    spanModel = sheet._rowHeaderSpanModel;
                if(spanModel && spanModel.length > 0)
                {
                    var removedSpans = [];
                    var spans = spanModel.getEnumerator(baseRow,baseColumn,rowCount,columnCount);
                    while(spans.moveNext())
                    {
                        cs = spans.current();
                        if(cs)
                            removedSpans.push(cs)
                    }
                    for(key = 0; key < removedSpans.length; key++)
                    {
                        cs = removedSpans[key];
                        spanModel.remove(cs)
                    }
                }
                if(cellsInfo.isSpanSaved())
                    if(spanModel)
                        for(key = 0; key < cellsInfo._spans.length; key++)
                        {
                            cs = cellsInfo._spans[key];
                            spanModel.push(cs)
                        }
            },
            undoColumnsInfo: function(sheet, columnsInfo, baseColumn)
            {
                var columnCount = columnsInfo._columnCount;
                var c;
                if(columnsInfo.isBindingFieldSaved())
                {
                    var outdata = {fieldName: null};
                    for(c = 0; c < columnCount; c++)
                        if(columnsInfo.getBindingField(c,outdata))
                            sheet.bindColumn(baseColumn + c,outdata.fieldName)
                }
                if(columnsInfo.isWidthSaved())
                    for(c = 0; c < columnCount; c++)
                        sheet.setColumnWidth(baseColumn + c,columnsInfo.getWidth(c),UI.SheetArea.viewport);
                if(columnsInfo.isVisibleSaved())
                    for(c = 0; c < columnCount; c++)
                        sheet.setColumnVisible(baseColumn + c,columnsInfo.getVisible(c),UI.SheetArea.viewport);
                if(columnsInfo.isResizableSaved())
                    for(c = 0; c < columnCount; c++)
                        sheet.setColumnResizable(baseColumn + c,columnsInfo.getResizable(c),UI.SheetArea.viewport);
                if(columnsInfo.isViewportColumnStyleSaved())
                    for(c = 0; c < columnCount; c++)
                        CopyMoveHelper.setStyleObject(sheet,-1,baseColumn + c,UI.SheetArea.viewport,columnsInfo.getViewportColumnStyle(c));
                if(columnsInfo.isHeaderColumnStyleSaved())
                    for(c = 0; c < columnCount; c++)
                        CopyMoveHelper.setStyleObject(sheet,-1,baseColumn + c,UI.SheetArea.colHeader,columnsInfo.getHeaderColumnStyle(c));
                if(columnsInfo.isRangeGroupSaved())
                {
                    var group = sheet.colRangeGroup;
                    if(group)
                    {
                        var outData = {
                                level: null,
                                collapsed: null
                            };
                        for(c = 0; c < columnCount; c++)
                        {
                            columnsInfo.getRangeGroup(c,outData);
                            group._setLevel(baseColumn + c,outData.level);
                            group.setCollapsed(baseColumn + c,outData.collapsed)
                        }
                    }
                }
            },
            undoRowsInfo: function(sheet, rowsInfo, baseRow)
            {
                var rowCount = rowsInfo._rowCount;
                var r;
                if(rowsInfo.isHeightSaved())
                    for(r = 0; r < rowCount; r++)
                        sheet.setRowHeight(baseRow + r,rowsInfo.getHeight(r),UI.SheetArea.viewport);
                if(rowsInfo.isVisibleSaved())
                    for(r = 0; r < rowCount; r++)
                        sheet.setRowVisible(baseRow + r,rowsInfo.getVisible(r),UI.SheetArea.viewport);
                if(rowsInfo.isResizableSaved())
                    for(r = 0; r < rowCount; r++)
                        sheet.setRowResizable(baseRow + r,rowsInfo.getResizable(r),UI.SheetArea.viewport);
                if(rowsInfo.isViewportRowStyleSaved())
                    for(r = 0; r < rowCount; r++)
                        CopyMoveHelper.setStyleObject(sheet,baseRow + r,-1,UI.SheetArea.viewport,rowsInfo.getViewportRowStyle(r));
                if(rowsInfo.isHeaderRowStyleSaved())
                    for(r = 0; r < rowCount; r++)
                        CopyMoveHelper.setStyleObject(sheet,baseRow + r,-1,UI.SheetArea.rowHeader,rowsInfo.getHeaderRowStyle(r));
                if(rowsInfo.isRangeGroupSaved())
                {
                    var group = sheet.rowRangeGroup;
                    if(group)
                    {
                        var outData = {
                                level: null,
                                collapsed: null
                            };
                        for(r = 0; r < rowCount; r++)
                        {
                            rowsInfo.getRangeGroup(r,outData);
                            group._setLevel(baseRow + r,outData.level);
                            group.setCollapsed(baseRow + r,outData.collapsed)
                        }
                    }
                }
            },
            undoSheetInfo: function(sheet, sheetInfo)
            {
                if(sheetInfo.isDefaultStyleSaved())
                    sheet.setDefaultStyle(sheetInfo.getDefaultStyle());
                if(sheetInfo.isDefaultColumnWidthSaved())
                    sheet.defaults.colWidth = sheetInfo.getDefaultColumnWidth();
                if(sheetInfo.isDefaultRowHeightSaved())
                    sheet.defaults.rowHeight = sheetInfo.getDefaultRowHeight();
                if(sheetInfo.isColumnHeaderDefaultStyleSaved())
                    sheet.setDefaultStyle(sheetInfo.getColumnHeaderDefaultStyle(),UI.SheetArea.colHeader);
                if(sheetInfo.isColumnHeaderDefaultRowHeightSaved())
                    sheet.defaults.rowHeight = sheetInfo.getColumnHeaderDefaultRowHeight();
                if(sheetInfo.isRowHeaderDefaultStyleSaved())
                    sheet.setDefaultStyle(sheetInfo.getRowHeaderDefaultStyle(),UI.SheetArea.rowHeader);
                if(sheetInfo.isRowHeaderDefaultColumnWidthSaved())
                    sheet.defaults.rowHeaderColWidth = sheetInfo.getRowHeaderDefaultColumnWidth()
            },
            getValues: function(sheet, row, column, rowCount, columnCount)
            {
                if(row < 0)
                {
                    row = 0;
                    rowCount = sheet.getRowCount()
                }
                if(column < 0)
                {
                    column = 0;
                    columnCount = sheet.getColumnCount()
                }
                var values = [];
                for(var r = 0; r < rowCount; r++)
                    for(var c = 0; c < columnCount; c++)
                    {
                        var value = sheet.getValue(row + r,column + c);
                        if(value !== undefined && value !== null)
                            values.push(new CellData(r,c,value))
                    }
                return values
            },
            raiseRangeDataChanged: function(sheetView, row, column, rowCount, columnCount, oldValues)
            {
                if(!sheetView)
                    return;
                if(row < 0)
                {
                    row = 0;
                    rowCount = sheetView.getRowCount()
                }
                if(column < 0)
                {
                    column = 0;
                    columnCount = sheetView.getColumnCount()
                }
                sheetView._raiseRangeDataChanged(row,column,rowCount,columnCount)
            },
            convertToKey: function(row, column)
            {
                var key = 0;
                key = row;
                key <<= 32;
                key |= column;
                return key
            },
            remove: function(cellDatas, row, column)
            {
                var ret = null;
                var index = -1;
                var count = cellDatas.length;
                if(count > 0)
                    for(var i = 0; i < count; i++)
                        if(cellDatas[i].row === row && cellDatas[i].column === column)
                        {
                            index = i;
                            break
                        }
                if(index !== -1)
                {
                    ret = cellDatas[index];
                    cellDatas.splice(index,1)
                }
                return ret
            }
        };
    function CopyMoveRowsInfo(rowCount)
    {
        this._rowCount = rowCount;
        this._init()
    }
    CopyMoveRowsInfo.prototype = {
        _init: function()
        {
            this._heights = {};
            this._visibles = {};
            this._resizables = {};
            this._tags = {};
            this._viewportRowStyles = {};
            this._headerRowStyles = {};
            this._levels = {};
            this._collapsed = {};
            this._heightSaved = false;
            this._visibleSaved = false;
            this._resizableSaved = false;
            this._tagSaved = false;
            this._viewportRowStyleSaved = false;
            this._headerRowStyleSaved = false;
            this._rangeGroupSaved = false
        },
        saveHeight: function(index, height)
        {
            if(this._heights[index] !== null)
                if(height < 0)
                    this._heights[index] = null;
                else
                    this._heights[index] = height;
            else if(height >= 0)
                this._heights[index] = height;
            this._heightSaved = true
        },
        getHeight: function(index)
        {
            if(this._heights[index] !== null)
                return this._heights[index];
            return-1
        },
        saveVisible: function(index, visible)
        {
            if(this._visibles[index] !== null)
                if(visible)
                    this._visibles[index] = null;
                else
                    this._visibles[index] = visible;
            else if(!visible)
                this._visibles[index] = visible;
            this._visibleSaved = true
        },
        getVisible: function(index)
        {
            if(this._visibles[index] !== null)
                return this._visibles[index];
            return true
        },
        saveResizable: function(index, resizable)
        {
            if(this._resizables[index] !== null)
                if(resizable)
                    this._resizables[index] = null;
                else
                    this._resizables[index] = resizable;
            else if(!resizable)
                this._resizables[index] = resizable;
            this._resizableSaved = true
        },
        getResizable: function(index)
        {
            if(this._resizables[index] !== null)
                return this._resizables[index];
            return true
        },
        saveTag: function(index, tag)
        {
            if(this._tags[index] !== null)
                if(tag === undefined || tag === null)
                    this._tags[index] = null;
                else
                    this._tags[index] = tag;
            else if(tag !== null)
                this._tags[index] = tag;
            this._tagSaved = true
        },
        getTag: function(index)
        {
            if(this._tags[index] !== null)
                return this._tags[index];
            return null
        },
        saveViewportRowStyle: function(index, style)
        {
            if(this._viewportRowStyles[index])
                if(!style)
                    this._viewportRowStyles[index] = null;
                else
                    this._viewportRowStyles[index] = style;
            else if(style)
                this._viewportRowStyles[index] = style;
            this._viewportRowStyleSaved = true
        },
        getViewportRowStyle: function(index)
        {
            if(this._viewportRowStyles[index])
                return this._viewportRowStyles[index];
            return null
        },
        saveHeaderRowStyle: function(index, style)
        {
            if(this._headerRowStyles[index])
                if(!style)
                    this._headerRowStyles[index] = null;
                else
                    this._headerRowStyles[index] = style;
            else if(style)
                this._headerRowStyles[index] = style;
            this._headerRowStyleSaved = true
        },
        getHeaderRowStyle: function(index)
        {
            if(this._headerRowStyles[index])
                return this._headerRowStyles[index];
            return null
        },
        saveRangeGroup: function(index, level, collapsed)
        {
            if(this._levels[index] !== null)
                if(level < 0)
                    this._levels[index] = null;
                else
                    this._levels[index] = level;
            else if(level >= 0)
                this._levels[index] = level;
            if(this._collapsed[index] !== null)
                if(collapsed)
                    this._collapsed[index] = collapsed;
                else
                    this._collapsed[index] = null;
            else if(collapsed)
                this._collapsed[index] = collapsed;
            this._rangeGroupSaved = true
        },
        getRangeGroup: function(index, outData)
        {
            outData.level = -1;
            outData.collapsed = false;
            if(this._levels[index] !== null)
                outData.level = this._levels[index];
            if(this._collapsed[index] !== null)
                outData.collapsed = this._collapsed[index]
        },
        isHeightSaved: function()
        {
            return this._heightSaved
        },
        isVisibleSaved: function()
        {
            return this._visibleSaved
        },
        isResizableSaved: function()
        {
            return this._resizableSaved
        },
        isTagSaved: function()
        {
            return this._tagSaved
        },
        isViewportRowStyleSaved: function()
        {
            return this._viewportRowStyleSaved
        },
        isHeaderRowStyleSaved: function()
        {
            return this._headerRowStyleSaved
        },
        isRangeGroupSaved: function()
        {
            return this._rangeGroupSaved
        }
    };
    function ActionBase()
    {
        this.canExecuteChanged = null
    }
    ActionBase.prototype = {
        execute: function(arg){},
        canExecute: function(arg){},
        canUndo: function()
        {
            return true
        },
        saveState: function(){},
        undo: function(arg){},
        _raiseCanExecuteChanged: function()
        {
            if(this.canExecuteChanged && typeof this.canExecuteChanged === 'function')
                this.canExecuteChanged(this)
        },
        _suspendInvalidate: function(sender)
        {
            if(sender && sender._suspendInvalidate)
                sender._suspendInvalidate()
        },
        _resumeInvalidate: function(sender)
        {
            if(sender && sender._resumeInvalidate)
                sender._resumeInvalidate()
        }
    };
    function ColumnResizeUndoAction(sheet, columns, size, rowHeader)
    {
        this._sheet = sheet;
        this._columns = columns;
        this._size = size;
        this._rowHeader = rowHeader;
        this._oldSizes = [];
        this._oldVisibles = []
    }
    ColumnResizeUndoAction.prototype = new ActionBase;
    function RowResizeUndoAction(sheet, rows, size, columnHeader)
    {
        this._sheet = sheet;
        this._rows = rows;
        this._size = size;
        this._columnHeader = columnHeader;
        this._oldSizes = [];
        this._oldVisibles = []
    }
    RowResizeUndoAction.prototype = new ActionBase;
    function ColumnAutoFitUndoAction(sheet, columns, rowHeader)
    {
        this._sheet = sheet;
        this._columns = columns;
        this._rowHeader = rowHeader;
        this._oldSizes = [];
        this._oldVisibles = []
    }
    ColumnAutoFitUndoAction.prototype = new ActionBase;
    function RowAutoFitUndoAction(sheet, rows, columnHeader)
    {
        this._sheet = sheet;
        this._rows = rows;
        this._columnHeader = columnHeader;
        this._oldSizes = [];
        this._oldVisibles = []
    }
    RowAutoFitUndoAction.prototype = new ActionBase;
    function GroupExtent(index, count)
    {
        this.index = index;
        this.count = count
    }
    function ColumnGroupUndoAction(sheet, groupExtent)
    {
        this._sheet = sheet;
        this._columnGroupExtent = groupExtent
    }
    ColumnGroupUndoAction.prototype = new ActionBase;
    function ColumnUngroupUndoAction(sheet, groupExtent)
    {
        this._sheet = sheet;
        this._columnUngroupExtent = groupExtent;
        this._canUndo = false
    }
    ColumnUngroupUndoAction.prototype = new ActionBase;
    function RowGroupUndoAction(sheet, groupExtent)
    {
        this._sheet = sheet;
        this._rowGroupExtent = groupExtent
    }
    RowGroupUndoAction.prototype = new ActionBase;
    function RowUngroupUndoAction(sheet, groupExtent)
    {
        this._sheet = sheet;
        this._rowUngroupExtent = groupExtent;
        this._canUndo = false
    }
    RowUngroupUndoAction.prototype = new ActionBase;
    function ColumnGroupExpandUndoAction(sheet, columnExpandExtent)
    {
        this._sheet = sheet;
        this._columnExpandExtent = columnExpandExtent
    }
    ColumnGroupExpandUndoAction.prototype = new ActionBase;
    function RowGroupExpandUndoAction(sheet, rowExpandExtent)
    {
        this._sheet = sheet;
        this._rowExpandExtent = rowExpandExtent
    }
    RowGroupExpandUndoAction.prototype = new ActionBase;
    function ColumnGroupHeaderExpandUndoAction(sheet, columnGroupHeaderExpandExtent)
    {
        this._sheet = sheet;
        this._columnGroupHeaderExpandExtent = columnGroupHeaderExpandExtent;
        this._oldStatus = {}
    }
    ColumnGroupHeaderExpandUndoAction.prototype = new ActionBase;
    function RowGroupHeaderExpandUndoAction(sheet, rowGroupHeaderExpandExtent)
    {
        this._sheet = sheet;
        this._rowGroupHeaderExpandExtent = rowGroupHeaderExpandExtent;
        this._oldStatus = {}
    }
    RowGroupHeaderExpandUndoAction.prototype = new ActionBase;
    function DragDropExtent(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount)
    {
        this.fromRow = fromRow;
        this.fromColumn = fromColumn;
        this.toRow = toRow;
        this.toColumn = toColumn;
        this.rowCount = rowCount;
        this.columnCount = columnCount
    }
    function DragDropUndoAction(sheet, dragMoveExtent, copy, insert, option)
    {
        this._sheet = sheet;
        this._dragDropExtent = dragMoveExtent;
        this._copy = copy;
        this._insert = insert;
        this._option = option
    }
    DragDropUndoAction.prototype = new ActionBase;
    function CellEditUndoAction(sheet, cellEditInfo)
    {
        this._sheet = sheet;
        this._cellEditInfo = cellEditInfo;
        this._canUndo = false
    }
    CellEditUndoAction.prototype = new ActionBase;
    function SheetRenameUndoAction(sheet, newName)
    {
        this._sheet = sheet;
        this._newName = newName;
        this._oldName = null
    }
    SheetRenameUndoAction.prototype = new ActionBase;
    function ZoomUndoAction(sheet, newZoomFactor)
    {
        this._sheet = sheet;
        if(newZoomFactor < 0.25)
            newZoomFactor = 0.25;
        else if(newZoomFactor > 4)
            newZoomFactor = 4;
        this._zoomFactor = newZoomFactor;
        this._prevZoomFactor = -1
    }
    ZoomUndoAction.prototype = new ActionBase;
    function ClearRangeValueUndoAction(sheet, clearRange)
    {
        this._sheet = sheet;
        this._clearRange = clearRange;
        this._cachedFilteredColumns = null;
        this._cachedValues = null
    }
    ClearRangeValueUndoAction.prototype = new ActionBase;
    function ClearValueUndoAction(sheet, ranges)
    {
        this._sheet = sheet;
        this._cachedActions = null;
        if(ranges && ranges.length > 0)
        {
            this._cachedActions = [ranges.length];
            for(var i = 0; i < ranges.length; i++)
                this._cachedActions[i] = new ClearRangeValueUndoAction(sheet,ranges[i])
        }
    }
    ClearValueUndoAction.prototype = new ActionBase;
    function DragFillUndoAction(sheet, dragFillExtent)
    {
        this._workSheet = sheet;
        this._dragFillExtent = dragFillExtent;
        if(this._dragFillExtent.autoFillType === AutoFillType.ClearValues)
            this._clearValueUndoAction = new ClearValueUndoAction(sheet,[this._dragFillExtent.fillRange]);
        else
            this.initWholeFilledRange();
        if(this._dragFillExtent.fillDirection === FillDirection.Left || this._dragFillExtent.fillDirection === FillDirection.Right)
            this._fillSeries = FillSeries.Row;
        else
            this._fillSeries = FillSeries.Column
    }
    DragFillUndoAction.prototype = new ActionBase;
    function ClipboardPasteRangeUndoAction(sheet, srcSheet, destSheet, pasteExtent, option)
    {
        this._sheet = sheet;
        this._fromSheet = srcSheet;
        this._toSheet = destSheet;
        this._pasteExtent = pasteExtent;
        this._pasteOption = option
    }
    ClipboardPasteRangeUndoAction.prototype = new ActionBase;
    function ClipboardPasteUndoAction(sheet, srcSheet, destSheet, pasteExtent, option)
    {
        this._sheet = sheet;
        if(!destSheet)
            throw new Error("destSheet");
        if(!pasteExtent)
            throw new Error("pasteExtent");
        if(pasteExtent.pastedRanges && pasteExtent.pastedRanges.length > 0)
        {
            this._cachedActions = new Array(pasteExtent.pastedRanges.length);
            for(var i = 0; i < pasteExtent.pastedRanges.length; i++)
            {
                var extent = {
                        sourceRange: pasteExtent.fromRange,
                        targetRange: pasteExtent.pastedRanges[i],
                        isCutting: pasteExtent.isCutting,
                        clipboardText: pasteExtent.clipboardText
                    };
                this._cachedActions[i] = new ClipboardPasteRangeUndoAction(sheet,srcSheet,destSheet,extent,option)
            }
        }
    }
    ClipboardPasteUndoAction.prototype = new ActionBase;
    function CellValueEntry(value, isFormula)
    {
        this.value = value;
        this.isFormula = isFormula
    }
    UI.SpreadActions = {
        navigationLeft: function()
        {
            var processed = __navigateNoWrap(this,UI.Direction.left);
            return{processed: processed}
        },
        navigationRight: function()
        {
            var processed = __navigateNoWrap(this,UI.Direction.right);
            return{processed: processed}
        },
        navigationUp: function()
        {
            var processed = __navigateNoWrap(this,UI.Direction.up);
            return{processed: processed}
        },
        navigationDown: function()
        {
            var processed = __navigateNoWrap(this,UI.Direction.down);
            return{processed: processed}
        },
        commitInputNavigationDown: function()
        {
            this.moveActiveCell(UI.Direction.down,false)
        },
        commitInputNavigationUp: function()
        {
            this.moveActiveCell(UI.Direction.up,false)
        },
        navigationHome: function()
        {
            __navigateNoWrapFrom(this,UI.Direction.right,this._activeRowIndex,this.frozenColCount ? this.frozenColCount - 1 : -1)
        },
        navigationHome2: function()
        {
            __navigateNoWrapFrom(this,UI.Direction.right,this._activeRowIndex,-1)
        },
        navigationEnd: function()
        {
            __navigateNoWrapFrom(this,UI.Direction.left,this._activeRowIndex,this.getColumnCount())
        },
        navigationTop: function()
        {
            __navigateNoWrapFrom(this,UI.Direction.down,-1,this._activeColIndex)
        },
        navigationBottom: function()
        {
            __navigateNoWrapFrom(this,UI.Direction.up,this.getRowCount(),this._activeColIndex)
        },
        navigationPageUp: function()
        {
            if(this._editorStatus === UI.EditorStatus.Edit)
                return;
            else if(this._editorStatus === UI.EditorStatus.Enter)
                this.endEdit();
            var prevPageTopRow = this._getPrevPageTopRow();
            if(prevPageTopRow === null || prevPageTopRow === this._scrollTopRow)
                return;
            var rls = this._getRowLayout(1,UI.SheetArea.viewport);
            this._rowLayoutCache.viewport = {};
            var newActiveRow = this._getNextVisualRow(this._activeRowIndex - rls.length);
            if(newActiveRow < prevPageTopRow)
                newActiveRow = prevPageTopRow;
            else if(newActiveRow >= this._getPageBottomRow())
                newActiveRow = this._getPrevVisualRow(this._getPageBottomRow());
            this._activeRowIndex = newActiveRow;
            this._leadingCellRow = newActiveRow;
            var repaint = this.moveActiveCell();
            if(!repaint)
                this._setTopRow(prevPageTopRow,true);
            else
                this._setTopRow(prevPageTopRow)
        },
        navigationPageDown: function()
        {
            if(this._editorStatus === UI.EditorStatus.Edit)
                return;
            else if(this._editorStatus === UI.EditorStatus.Enter)
                this.endEdit();
            var nextPageTopRow = this._getNextPageTopRow();
            if(nextPageTopRow === null || nextPageTopRow === this._scrollTopRow)
                return;
            var rls = this._getRowLayout(1,UI.SheetArea.viewport);
            this._rowLayoutCache.viewport = {};
            var newActiveRow = this._getPrevVisualRow(this._activeRowIndex + rls.length);
            if(newActiveRow < nextPageTopRow)
                newActiveRow = nextPageTopRow;
            else if(newActiveRow >= this._getPageBottomRow())
                newActiveRow = this._getPrevVisualRow(this._getPageBottomRow());
            this._activeRowIndex = newActiveRow;
            this._leadingCellRow = newActiveRow;
            var repaint = this.moveActiveCell();
            if(!repaint)
                this._setTopRow(nextPageTopRow,true);
            else
                this._setTopRow(nextPageTopRow)
        },
        navigationNextSheet: function()
        {
            var spread = this.parent;
            if(spread || spread instanceof UI.GcSpread)
            {
                var count = spread.getSheetCount();
                var index = spread.getActiveSheetIndex();
                if(index < count - 1)
                {
                    index++;
                    spread.setActiveSheetIndex(index);
                    spread.repaint()
                }
            }
        },
        navigationPreviousSheet: function()
        {
            var spread = this.parent;
            if(spread || spread instanceof UI.GcSpread)
            {
                var index = spread.getActiveSheetIndex();
                if(index > 0)
                {
                    index--;
                    spread.setActiveSheetIndex(index);
                    spread.repaint()
                }
            }
        },
        navigationPrevious: function(){},
        navigationNext: function(){},
        navigationFirst: function()
        {
            if(this._editorStatus === UI.EditorStatus.Edit)
                return;
            var prevCol = this.frozenColCount ? this.frozenColCount - 1 : -1;
            var prevRow = this.frozenRowCount ? this.frozenRowCount - 1 : -1;
            this.moveActiveCell(UI.Direction.right,false,this._activeRowIndex,prevCol);
            this.moveActiveCell(UI.Direction.down,false,prevRow,this._activeColIndex)
        },
        navigationLast: function()
        {
            if(this._editorStatus === UI.EditorStatus.Edit)
                return;
            this.moveActiveCell(UI.Direction.left,false,this._activeRowIndex,this.getColumnCount());
            this.moveActiveCell(UI.Direction.up,false,this.getRowCount(),this._activeColIndex)
        },
        commitInputNavigationTabNext: function()
        {
            if(this._isNavigateInSelection)
                this._moveActiveCellInSelection(UI.Direction.right);
            else
                this.moveActiveCell(UI.Direction.right,true)
        },
        commitInputNavigationTabPrevious: function()
        {
            if(this._isNavigateInSelection)
                this._moveActiveCellInSelection(UI.Direction.left);
            else
                this.moveActiveCell(UI.Direction.left,true)
        },
        cancelInput: function()
        {
            if(this.isEditing())
            {
                var cacheValue = this.getValue(this._activeRowIndex,this._activeColIndex,UI.SheetArea.viewport);
                this.endEdit(true);
                this.setValue(this._activeRowIndex,this._activeColIndex,cacheValue,UI.SheetArea.viewport,true)
            }
        },
        clear: function()
        {
            if(!this.isEditing())
            {
                var sels = this.getSelections();
                for(var i = 0; i < sels.length; i++)
                    if(this.isProtected && this._isAnyCellInRangeLocked(sels[i]))
                        return;
                var ranges = sels.toArray();
                var action = new ClearValueUndoAction(this,ranges);
                if(action.canExecute(this))
                    this._doCommand(action)
            }
        },
        clearAndEditing: function()
        {
            var processed = false;
            if(!this.isEditing())
            {
                this.startEdit(true,"");
                processed = true
            }
            return{processed: processed}
        },
        copy: function()
        {
            if(!this.isEditing())
            {
                var sels = this.getSelections();
                if(sels && sels.length === 1)
                    this._clipboardCopy(sels[0],false)
            }
        },
        cut: function()
        {
            if(!this.isEditing())
            {
                var sels = this.getSelections();
                if(sels && sels.length === 1)
                    this._clipboardCopy(sels[0],true)
            }
        },
        paste: function()
        {
            var msg_spreadActionPasteSizeDifferent = "The pasted area should have the same size as the copy or cut area.";
            var sheet = this;
            if(sheet)
            {
                if(sheet.isEditing())
                    return;
                var ch = sheet._getClipboardHelper();
                var fromSheet = ch.fromSheet;
                var fromRange = ch.range;
                var clipboardText = sheet._getClipboardData();
                var isCutting = ch.isCutting;
                if(isCutting)
                {
                    ch.fromSheet = null;
                    ch.range = null;
                    ch.isCutting = false
                }
                if(isCutting && fromSheet && fromRange && fromSheet.isProtected && fromSheet._isAnyCellInRangeLocked(fromRange))
                    isCutting = false;
                var outPara = {
                        pastedRange: null,
                        pastedInternal: false
                    };
                var pastedRanges = [];
                var selections = sheet.getSelections();
                var toRange;
                if(selections.length > 1)
                    for(var i = 0; i < selections.length; i++)
                    {
                        toRange = selections[i];
                        if(!sheet._checkPastedRange(fromSheet,fromRange,toRange,isCutting,clipboardText,outPara))
                            return;
                        if(toRange.containsRange(outPara.pastedRange) && !toRange.equals(outPara.pastedRange))
                        {
                            sheet._raiseInvalidOperation(msg_spreadActionPasteSizeDifferent);
                            return
                        }
                        pastedRanges.push(outPara.pastedRange)
                    }
                else if(selections.length > 0)
                {
                    toRange = selections[0];
                    if(!sheet._checkPastedRange(fromSheet,fromRange,toRange,isCutting,clipboardText,outPara))
                        return;
                    pastedRanges.push(outPara.pastedRange)
                }
                else
                {
                    toRange = sheet._getSpanModel().find(sheet._activeRowIndex,sheet._activeColIndex);
                    if(!toRange)
                        toRange = new UI.Range(sheet._activeRowIndex,sheet._activeColIndex,1,1);
                    if(!sheet._checkPastedRange(fromSheet,fromRange,toRange,isCutting,clipboardText,outPara))
                        return;
                    pastedRanges.push(outPara.pastedRange)
                }
                if(pastedRanges.length > 0)
                {
                    if(!outPara.pastedInternal)
                    {
                        fromSheet = null;
                        fromRange = null
                    }
                    var pasteOption = sheet.clipBoardOptions();
                    if(isCutting)
                        pasteOption = UI.ClipboardPasteOptions.All;
                    var pasteExtent = {
                            fromRange: fromRange,
                            pastedRanges: pastedRanges.slice(0),
                            isCutting: isCutting,
                            clipboardText: clipboardText
                        };
                    var pasteUndoAction = new ClipboardPasteUndoAction(sheet,fromSheet,sheet,pasteExtent,pasteOption);
                    sheet._doCommand(pasteUndoAction)
                }
            }
        },
        selectionLeft: function()
        {
            __alterSelection(this,UI.Key.left)
        },
        selectionRight: function()
        {
            __alterSelection(this,UI.Key.right)
        },
        selectionUp: function()
        {
            __alterSelection(this,UI.Key.up)
        },
        selectionDown: function()
        {
            __alterSelection(this,UI.Key.down)
        },
        selectionHome: function()
        {
            __alterSelection(this,UI.Key.left,true)
        },
        selectionEnd: function()
        {
            __alterSelection(this,UI.Key.right,true)
        },
        selectionPageUp: function()
        {
            __alterSelection(this,UI.Key.pup)
        },
        selectionPageDown: function()
        {
            __alterSelection(this,UI.Key.pdn)
        },
        selectionTop: function()
        {
            __alterSelection(this,UI.Key.up,true)
        },
        selectionBottom: function()
        {
            __alterSelection(this,UI.Key.down,true)
        },
        selectionFirst: function()
        {
            __alterSelection(this,UI.Key.home,true)
        },
        selectionLast: function()
        {
            __alterSelection(this,UI.Key.end,true)
        },
        undo: function()
        {
            var undoManager = this.undoManager();
            if(this.isProtected === false && undoManager.canUndo())
                undoManager.undo()
        },
        redo: function()
        {
            var undoManager = this.undoManager();
            if(this.isProtected === false && undoManager.canRedo())
                undoManager.redo()
        }
    };
    ColumnResizeUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    ColumnResizeUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._columns && this._columns.length > 0)
        {
            this._suspendInvalidate(arg);
            var resizedColumns = this._getColumnsReiszed(this._columns);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    colList: resizedColumns,
                    header: this._rowHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.ColumnWidthChanging,args);
            if(args && args.cancel === true)
            {
                this._canUndo = false;
                this._resumeInvalidate(arg);
                return
            }
            else
                this._canUndo = true;
            this.saveState();
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            for(var c = 0; c < this._columns.length; c++)
            {
                var cw = this._columns[c];
                for(var c2 = cw.firstCol; c2 <= cw.lastCol; c2++)
                    if(0 <= c2 && c2 < columnCount)
                        if(this._rowHeader && sheet.getColumnResizable(c2,UI.SheetArea.rowHeader) && this._size !== sheet.getColumnWidth(c2,UI.SheetArea.rowHeader))
                            sheet.setColumnWidth(c2,this._size,UI.SheetArea.rowHeader);
                        else if(sheet.getColumnResizable(c2,UI.SheetArea.viewport) && this._size !== sheet.getColumnWidth(c2,UI.SheetArea.viewport))
                            sheet.setColumnWidth(c2,this._size,UI.SheetArea.viewport)
            }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.ColumnWidthChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                colList: resizedColumns,
                header: this._rowHeader
            })
        }
    };
    ColumnResizeUndoAction.prototype.saveState = function()
    {
        var sizes = null;
        var visibles = null;
        var sheet = this._sheet;
        if(sheet && this._columns && this._columns.length > 0)
        {
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            sizes = [this._columns.length];
            visibles = [this._columns.length];
            for(var c = 0; c < this._columns.length; c++)
            {
                var cw = this._columns[c];
                sizes[c] = [cw.lastCol - cw.firstCol + 1];
                visibles[c] = [cw.lastCol - cw.firstCol + 1];
                for(var c2 = cw.firstCol; c2 <= cw.lastCol; c2++)
                    if(0 <= c2 && c2 < columnCount)
                    {
                        sizes[c][c2 - cw.firstCol] = this._rowHeader ? sheet.getColumnWidth(c2,UI.SheetArea.rowHeader) : sheet.getColumnWidth(c2,UI.SheetArea.viewport);
                        visibles[c][c2 - cw.firstCol] = this._rowHeader ? sheet.getColumnVisible(c2,UI.SheetArea.rowHeader) : sheet.getColumnVisible(c2,UI.SheetArea.viewport)
                    }
                    else
                    {
                        sizes[c][c2 - cw.firstCol] = -1;
                        visibles[c][c2 - cw.firstCol] = false
                    }
            }
        }
        this._oldSizes = sizes;
        this._oldVisibles = visibles
    };
    ColumnResizeUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._columns && this._columns.length > 0)
        {
            this._suspendInvalidate(arg);
            var resizedColumns = this._getColumnsReiszed(this._columns);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    colList: resizedColumns,
                    header: this._rowHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.ColumnWidthChanging,args);
            if(args && args.cancel === true)
            {
                this._resumeInvalidate(arg);
                return false
            }
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            var oldsize,
                oldVisible;
            for(var c = 0; c < this._columns.length; c++)
            {
                var cw = this._columns[c];
                for(var c2 = cw.firstCol; c2 <= cw.lastCol; c2++)
                {
                    oldsize = this._oldSizes[c][c2 - cw.firstCol];
                    oldVisible = this._oldVisibles[c][c2 - cw.firstCol];
                    if(0 <= c2 && c2 < columnCount && oldsize !== -1)
                    {
                        if(this._rowHeader && sheet.getColumnResizable(c2,UI.SheetArea.rowHeader))
                        {
                            sheet.setColumnWidth(c2,oldsize,UI.SheetArea.rowHeader);
                            ret = true
                        }
                        else if(sheet.getColumnResizable(c2,UI.SheetArea.viewport))
                        {
                            sheet.setColumnWidth(c2,oldsize,UI.SheetArea.viewport);
                            ret = true
                        }
                        if(this._rowHeader && sheet.getColumnVisible(c2,UI.SheetArea.rowHeader) !== oldVisible)
                        {
                            sheet.setColumnVisible(c2,oldVisible,UI.SheetArea.rowHeader);
                            ret = true
                        }
                        else if(sheet.getColumnVisible(c2,UI.SheetArea.viewport) !== oldVisible)
                        {
                            sheet.setColumnVisible(c2,oldVisible,UI.SheetArea.viewport);
                            ret = true
                        }
                    }
                }
            }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.ColumnWidthChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                colList: resizedColumns,
                header: this._rowHeader
            })
        }
        return ret
    };
    ColumnResizeUndoAction.prototype._getColumnsReiszed = function(columnWidthChangeExtents)
    {
        var columns = [];
        for(var i = 0; i < columnWidthChangeExtents.length; i++)
        {
            var item = columnWidthChangeExtents[i];
            for(var col = item.firstCol; col <= item.lastCol; col++)
                columns.push(col)
        }
        return columns
    };
    ColumnResizeUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    RowResizeUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    RowResizeUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._rows && this._rows.length > 0)
        {
            this._suspendInvalidate(arg);
            var resizedRows = this._getRowsReiszed(this._rows);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    rowList: resizedRows,
                    header: this._columnHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.RowHeightChanging,args);
            if(args && args.cancel === true)
            {
                this._canUndo = false;
                this._resumeInvalidate(arg);
                return
            }
            else
                this._canUndo = true;
            this.saveState();
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            for(var r = 0; r < this._rows.length; r++)
            {
                var rh = this._rows[r];
                for(var r2 = rh.firstRow; r2 <= rh.lastRow; r2++)
                    if(0 <= r2 && r2 < rowCount)
                        if(this._columnHeader && sheet.getRowResizable(r2,UI.SheetArea.colHeader) && this._size !== sheet.getRowHeight(r2,UI.SheetArea.colHeader))
                            sheet.setRowHeight(r2,this._size,UI.SheetArea.colHeader);
                        else if(sheet.getRowResizable(r2,UI.SheetArea.viewport) && this._size !== sheet.getRowHeight(r2,UI.SheetArea.viewport))
                        {
                            sheet.setRowHeight(r2,this._size,UI.SheetArea.viewport);
                            if(sheet.rowFilter())
                                sheet.rowFilter()._addRowFilteredIn(r2)
                        }
            }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.RowHeightChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                rowList: resizedRows,
                header: this._columnHeader
            })
        }
    };
    RowResizeUndoAction.prototype.saveState = function()
    {
        var sizes = null;
        var visibles = null;
        var sheet = this._sheet;
        if(sheet && this._rows && this._rows.length > 0)
        {
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            sizes = [this._rows.length];
            visibles = [this._rows.length];
            for(var r = 0; r < this._rows.length; r++)
            {
                var rh = this._rows[r];
                sizes[r] = [rh.lastRow - rh.firstRow + 1];
                visibles[r] = [rh.lastRow - rh.firstRow + 1];
                for(var r2 = rh.firstRow; r2 <= rh.lastRow; r2++)
                    if(0 <= r2 && r2 < rowCount)
                    {
                        sizes[r][r2 - rh.firstRow] = this._columnHeader ? sheet.getRowHeight(r2,UI.SheetArea.colHeader) : sheet.getRowHeight(r2,UI.SheetArea.viewport);
                        visibles[r][r2 - rh.firstRow] = this._columnHeader ? sheet.getRowVisible(r2,UI.SheetArea.colHeader) : sheet.getRowVisible(r2,UI.SheetArea.viewport)
                    }
                    else
                    {
                        sizes[r][r2 - rh.firstRow] = -1;
                        visibles[r][r2 - rh.firstRow] = false
                    }
            }
        }
        this._oldVisibles = visibles;
        this._oldSizes = sizes
    };
    RowResizeUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._rows && this._rows.length > 0)
        {
            this._suspendInvalidate(arg);
            var resizedRows = this._getRowsReiszed(this._rows);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    rowList: resizedRows,
                    header: this._columnHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.RowHeightChanging,args);
            if(args && args.cancel === true)
            {
                this._resumeInvalidate(arg);
                return false
            }
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            var oldsize,
                oldVisible;
            for(var r = 0; r < this._rows.length; r++)
            {
                var rh = this._rows[r];
                for(var r2 = rh.firstRow; r2 <= rh.lastRow; r2++)
                {
                    oldsize = this._oldSizes[r][r2 - rh.firstRow];
                    oldVisible = this._oldVisibles[r][r2 - rh.firstRow];
                    if(0 <= r2 && r2 < rowCount && oldsize !== -1)
                    {
                        if(this._columnHeader && sheet.getRowResizable(r2,UI.SheetArea.colHeader))
                        {
                            sheet.setRowHeight(r2,oldsize,UI.SheetArea.colHeader);
                            ret = true
                        }
                        else if(sheet.getRowResizable(r2,UI.SheetArea.viewport))
                        {
                            sheet.setRowHeight(r2,oldsize,UI.SheetArea.viewport);
                            ret = true
                        }
                        if(this._columnHeader && sheet.getRowVisible(r2,UI.SheetArea.colHeader) !== oldVisible)
                        {
                            sheet.setRowVisible(r2,oldVisible,UI.SheetArea.colHeader);
                            ret = true
                        }
                        else if(sheet.getRowVisible(r2,UI.SheetArea.viewport) !== oldVisible)
                        {
                            sheet.setRowVisible(r2,oldVisible,UI.SheetArea.viewport);
                            ret = true
                        }
                    }
                }
            }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.RowHeightChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                rowList: resizedRows,
                header: this._columnHeader
            })
        }
        return ret
    };
    RowResizeUndoAction.prototype._getRowsReiszed = function(rowHeightChangeExtents)
    {
        var rows = [];
        for(var i = 0; i < rowHeightChangeExtents.length; i++)
        {
            var item = rowHeightChangeExtents[i];
            for(var row = item.firstRow; row <= item.lastRow; row++)
                rows.push(row)
        }
        return rows
    };
    RowResizeUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    ColumnAutoFitUndoAction.prototype.canExecute = function(arg)
    {
        return this._sheet && this._columns && this._columns.length > 0
    };
    ColumnAutoFitUndoAction.prototype.execute = function(arg)
    {
        if(this.canExecute(arg))
        {
            var sheet = this._sheet;
            this._suspendInvalidate(arg);
            var resizedColumns = this._getColumnsReiszed(this._columns);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    colList: resizedColumns,
                    header: this._rowHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.ColumnWidthChanging,args);
            if(args && args.cancel === true)
            {
                this._canUndo = false;
                this._resumeInvalidate(arg);
                return
            }
            else
                this._canUndo = true;
            this.saveState();
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            var oldState = sheet.isPaintSuspended();
            sheet.isPaintSuspended(true);
            var fitValue;
            for(var c = 0; c < this._columns.length; c++)
            {
                var ce = this._columns[c];
                if(0 <= ce.col && ce.col < columnCount)
                    if(this._rowHeader && sheet.getColumnResizable(ce.col,UI.SheetArea.rowHeader))
                    {
                        fitValue = this._getColumnAutoFitValue(ce.col,true);
                        if(fitValue !== sheet.getColumnWidth(ce.col,UI.SheetArea.rowHeader))
                        {
                            sheet.setColumnWidth(ce.col,fitValue,UI.SheetArea.rowHeader);
                            sheet._trigger(UI.Events.ColumnWidthChanged,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                colList: [ce.col],
                                header: this._rowHeader
                            })
                        }
                    }
                    else if(sheet.getColumnResizable(ce.col,UI.SheetArea.viewport))
                    {
                        fitValue = this._getColumnAutoFitValue(ce.col,false);
                        if(fitValue !== sheet.getColumnWidth(ce.col,UI.SheetArea.viewport))
                        {
                            sheet.setColumnWidth(ce.col,fitValue,UI.SheetArea.viewport);
                            sheet._trigger(UI.Events.ColumnWidthChanged,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                colList: [ce.col],
                                header: this._rowHeader
                            })
                        }
                    }
            }
            sheet.isPaintSuspended(oldState);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    ColumnAutoFitUndoAction.prototype.saveState = function()
    {
        var sizes = null;
        var visibles = null;
        var sheet = this._sheet;
        if(sheet && this._columns && this._columns.length > 0)
        {
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            sizes = [this._columns.length];
            visibles = [this._columns.length];
            for(var c = 0; c < this._columns.length; c++)
            {
                var ce = this._columns[c];
                if(0 <= ce.col && ce.col < columnCount)
                    if(this._rowHeader)
                    {
                        sizes[c] = sheet.getColumnWidth(ce.col,UI.SheetArea.rowHeader);
                        visibles[c] = sheet.getColumnVisible(ce.col,UI.SheetArea.rowHeader)
                    }
                    else
                    {
                        sizes[c] = sheet.getColumnWidth(ce.col,UI.SheetArea.viewport);
                        visibles[c] = sheet.getColumnVisible(ce.col,UI.SheetArea.viewport)
                    }
                else
                {
                    sizes[c] = -1;
                    visibles[c] = false
                }
            }
        }
        this._oldSizes = sizes;
        this._oldVisibles = visibles
    };
    ColumnAutoFitUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        if(this._sheet && this._columns && this._columns.length > 0)
        {
            var sheet = this._sheet;
            this._suspendInvalidate(arg);
            var resizedColumns = this._getColumnsReiszed(this._columns);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    colList: resizedColumns,
                    header: this._rowHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.ColumnWidthChanging,args);
            if(args && args.cancel === true)
            {
                this._resumeInvalidate(arg);
                return false
            }
            var columnCount = this._rowHeader ? sheet.getColumnCount(UI.SheetArea.rowHeader) : sheet.getColumnCount(UI.SheetArea.viewport);
            var oldSize,
                oldVisible;
            var oldState = sheet.isPaintSuspended();
            sheet.isPaintSuspended(true);
            for(var c = 0; c < this._columns.length; c++)
            {
                var ce = this._columns[c];
                oldSize = this._oldSizes[c];
                oldVisible = this._oldVisibles[c];
                if(0 <= c && c < columnCount && oldSize !== -1)
                    if(this._rowHeader && sheet.getColumnResizable(ce.col,UI.SheetArea.rowHeader))
                    {
                        sheet.setColumnWidth(ce.col,oldSize,UI.SheetArea.rowHeader);
                        sheet.setColumnVisible(ce.col,oldVisible,UI.SheetArea.rowHeader);
                        ret = true
                    }
                    else if(sheet.getColumnResizable(ce.col,UI.SheetArea.viewport))
                    {
                        sheet.setColumnWidth(ce.col,oldSize,UI.SheetArea.viewport);
                        sheet.setColumnVisible(ce.col,oldVisible,UI.SheetArea.viewport);
                        ret = true
                    }
            }
            sheet.isPaintSuspended(oldState);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.ColumnWidthChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                colList: resizedColumns,
                header: this._rowHeader
            })
        }
        return ret
    };
    ColumnAutoFitUndoAction.prototype._getColumnsReiszed = function(columnWidthChangeExtents)
    {
        var columns = [];
        for(var i = 0; i < columnWidthChangeExtents.length; i++)
        {
            var item = columnWidthChangeExtents[i];
            columns.push(item.col)
        }
        return columns
    };
    ColumnAutoFitUndoAction.prototype._nextAutoFitRow = function(row, col, rowHeader)
    {
        var sheet = this._sheet;
        var nextNonNullRow = sheet._nextNonNullRow(row,rowHeader);
        var nextCellTypeRow = -1;
        var sheetArea = rowHeader ? UI.SheetArea.rowHeader : UI.SheetArea.viewport;
        var rowCount = sheet.getRowCount(sheetArea);
        for(var i = row + 1; i < rowCount; i++)
        {
            var style = sheet.getActualStyle(i,col,sheetArea);
            if(style && style.cellType)
            {
                nextCellTypeRow = i;
                break
            }
        }
        if(nextNonNullRow >= 0 && nextCellTypeRow >= 0)
            return Math.min(nextNonNullRow,nextCellTypeRow);
        else if(nextNonNullRow >= 0)
            return nextNonNullRow;
        else if(nextCellTypeRow >= 0)
            return nextCellTypeRow;
        else
            return-1
    };
    ColumnAutoFitUndoAction.prototype._getColumnAutoFitValue = function(col, rowHeader)
    {
        var sheet = this._sheet;
        var width = 0;
        var row = 0;
        var sheetArea = rowHeader ? UI.SheetArea.rowHeader : UI.SheetArea.viewport;
        while(row >= 0)
        {
            var span = sheet._getSpanModel(sheetArea).find(row,col);
            if(span && (span.col < col || span.colCount > 1))
            {
                row = span.row + span.rowCount;
                continue
            }
            var style = sheet.getActualStyle(row,col,sheetArea);
            var font = style.font || sheet._render._getDefaultFont(sheetArea);
            style.font = sheet._render._getZoomFont(font);
            var valueWidth = 0;
            var cellType = sheet.getCellType(row,col,sheetArea);
            if(cellType)
            {
                var isFilterHeader = !!(sheet.rowFilter() && sheet.rowFilter().isFilterHeader(row,col,sheetArea));
                var text = sheet.getText(row,col,sheetArea);
                var value = sheet.getValue(row,col,sheetArea);
                valueWidth = cellType._getAutoFitWidth(sheet,value,text,style,isFilterHeader)
            }
            if(valueWidth > width)
                width = valueWidth;
            row = this._nextAutoFitRow(row,col,rowHeader)
        }
        if(width === 0)
            width = sheet.defaults.colWidth;
        else
            width += Math.ceil(4 / sheet._zoomFactor);
        return width
    };
    ColumnAutoFitUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    RowAutoFitUndoAction.prototype.canExecute = function(arg)
    {
        return this._sheet && this._rows && this._rows.length > 0
    };
    RowAutoFitUndoAction.prototype.execute = function(arg)
    {
        if(this.canExecute(arg))
        {
            var sheet = this._sheet;
            this._suspendInvalidate(arg);
            var resizedRows = this._getRowsResized(this._rows);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    rowList: resizedRows,
                    header: this._columnHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.RowHeightChanging,args);
            if(args && args.cancel === true)
            {
                this._canUndo = false;
                this._resumeInvalidate(arg);
                return
            }
            else
                this._canUndo = true;
            this.saveState();
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            var oldState = sheet.isPaintSuspended();
            sheet.isPaintSuspended(true);
            var fitValue;
            for(var r = 0; r < this._rows.length; r++)
            {
                var re = this._rows[r];
                if(0 <= re.row && re.row < rowCount)
                    if(this._columnHeader && sheet.getRowResizable(re.row,UI.SheetArea.colHeader))
                    {
                        fitValue = this._getRowAutoFitValue(re.row,true);
                        if(fitValue !== sheet.getRowHeight(re.row,UI.SheetArea.colHeader))
                        {
                            sheet.setRowHeight(re.row,fitValue,UI.SheetArea.colHeader);
                            sheet._trigger(UI.Events.RowHeightChanged,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                rowList: [re.row],
                                header: this._columnHeader
                            })
                        }
                    }
                    else if(sheet.getRowResizable(re.row,UI.SheetArea.viewport))
                    {
                        fitValue = this._getRowAutoFitValue(re.row,false);
                        if(fitValue !== sheet.getRowHeight(re.row,UI.SheetArea.viewport))
                        {
                            sheet.setRowHeight(re.row,fitValue,UI.SheetArea.viewport);
                            sheet._trigger(UI.Events.RowHeightChanged,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                rowList: [re.row],
                                header: this._columnHeader
                            })
                        }
                    }
            }
            sheet.isPaintSuspended(oldState);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    RowAutoFitUndoAction.prototype.saveState = function()
    {
        var sizes = null;
        var visibles = null;
        var sheet = this._sheet;
        if(sheet && this._rows && this._rows.length > 0)
        {
            sizes = [this._rows.length];
            visibles = [this._rows.length];
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            for(var r = 0; r < this._rows.length; r++)
            {
                var re = this._rows[r];
                if(0 <= re.row && re.row < rowCount)
                    if(this._columnHeader)
                    {
                        sizes[r] = sheet.getRowHeight(re.row,UI.SheetArea.colHeader);
                        visibles[r] = sheet.getRowVisible(re.row,UI.SheetArea.colHeader)
                    }
                    else
                    {
                        sizes[r] = sheet.getRowHeight(re.row,UI.SheetArea.viewport);
                        visibles[r] = sheet.getRowVisible(re.row,UI.SheetArea.viewport)
                    }
                else
                {
                    sizes[r] = -1;
                    visibles[r] = false
                }
            }
        }
        this._oldSizes = sizes;
        this._oldVisibles = visibles
    };
    RowAutoFitUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._rows && this._rows.length > 0)
        {
            this._suspendInvalidate(arg);
            var resizedRows = this._getRowsResized(this._rows);
            var args = {
                    sheet: sheet,
                    sheetName: sheet._name,
                    rowList: resizedRows,
                    header: this._columnHeader,
                    cancel: false
                };
            sheet._trigger(UI.Events.RowHeightChanging,args);
            if(args && args.cancel === true)
            {
                this._resumeInvalidate(arg);
                return false
            }
            var oldSize,
                oldVisible;
            var rowCount = this._columnHeader ? sheet.getRowCount(UI.SheetArea.colHeader) : sheet.getRowCount(UI.SheetArea.viewport);
            var oldState = sheet.isPaintSuspended();
            sheet.isPaintSuspended(true);
            for(var r = 0; r < this._rows.length; r++)
            {
                var re = this._rows[r];
                oldSize = this._oldSizes[r];
                oldVisible = this._oldVisibles[r];
                if(0 <= r && r < rowCount && oldSize !== -1)
                    if(this._columnHeader && sheet.getRowResizable(re.row,UI.SheetArea.colHeader))
                    {
                        sheet.setRowHeight(re.row,oldSize,UI.SheetArea.colHeader);
                        sheet.setRowVisible(re.row,oldVisible,UI.SheetArea.colHeader);
                        ret = true
                    }
                    else if(sheet.getRowResizable(re.row,UI.SheetArea.viewport))
                    {
                        sheet.setRowHeight(re.row,oldSize,UI.SheetArea.viewport);
                        sheet.setRowVisible(re.row,oldVisible,UI.SheetArea.viewport);
                        ret = true
                    }
            }
            sheet.isPaintSuspended(oldState);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._trigger(UI.Events.RowHeightChanged,{
                sheet: sheet,
                sheetName: sheet._name,
                rowList: resizedRows,
                header: this._columnHeader
            })
        }
        return ret
    };
    RowAutoFitUndoAction.prototype._getRowsResized = function(rowHeightChangeExtents)
    {
        var rows = [];
        for(var i = 0; i < rowHeightChangeExtents.length; i++)
        {
            var item = rowHeightChangeExtents[i];
            rows.push(item.row)
        }
        return rows
    };
    RowAutoFitUndoAction.prototype._nextAutoFitColumn = function(row, col, columnHeader)
    {
        var sheet = this._sheet;
        var nextNonNullCol = sheet._nextNonNullColumn(row,col,columnHeader);
        var nextCellTypeCol = -1;
        var sheetArea = columnHeader ? UI.SheetArea.colHeader : UI.SheetArea.viewport;
        var colCount = sheet.getColumnCount(sheetArea);
        for(var j = col + 1; j < colCount; j++)
        {
            var style = sheet.getActualStyle(row,j,sheetArea);
            if(style && style.cellType)
            {
                nextCellTypeCol = j;
                break
            }
        }
        if(nextNonNullCol >= 0 && nextCellTypeCol >= 0)
            return Math.min(nextNonNullCol,nextCellTypeCol);
        else if(nextNonNullCol >= 0)
            return nextNonNullCol;
        else if(nextCellTypeCol >= 0)
            return nextCellTypeCol;
        else
            return-1
    };
    RowAutoFitUndoAction.prototype._getRowAutoFitValue = function(row, columnHeader)
    {
        var sheet = this._sheet;
        var height = 0;
        var col = 0;
        var sheetArea = columnHeader ? UI.SheetArea.colHeader : UI.SheetArea.viewport;
        while(col >= 0)
        {
            var span = sheet._getSpanModel(sheetArea).find(row,col);
            if(span && (span.row < row || span.rowCount > 1))
            {
                col = span.col + span.colCount;
                continue
            }
            var style = sheet.getActualStyle(row,col,sheetArea);
            var font = style.font || sheet._render._getDefaultFont(sheetArea);
            style.font = sheet._render._getZoomFont(font);
            var valueHeight = 0;
            var cellType = sheet.getCellType(row,col,sheetArea);
            if(cellType)
            {
                var text = sheet.getText(row,col,sheetArea);
                var value = sheet.getValue(row,col,sheetArea);
                valueHeight = cellType._getAutoFitHeight(sheet,value,text,style)
            }
            if(valueHeight > height)
                height = valueHeight;
            col = this._nextAutoFitColumn(row,col,columnHeader)
        }
        if(height === 0)
            height = sheet.defaults.rowHeight;
        else
            height += Math.ceil(4 / sheet._zoomFactor);
        return height
    };
    RowAutoFitUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    ColumnGroupUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    ColumnGroupUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._columnGroupExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._columnGroupExtent.index;
            var count = this._columnGroupExtent.count;
            sheet.colRangeGroup.group(index,count);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    ColumnGroupUndoAction.prototype.saveState = function(){};
    ColumnGroupUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._columnGroupExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._columnGroupExtent.index;
            var count = this._columnGroupExtent.count;
            sheet.colRangeGroup.ungroupRange(index,count);
            ret = true;
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    ColumnUngroupUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    ColumnUngroupUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._columnUngroupExtent && sheet.colRangeGroup)
        {
            var index = this._columnUngroupExtent.index;
            var count = this._columnUngroupExtent.count;
            if(sheet.colRangeGroup.getLevel(index) >= 0 || sheet.colRangeGroup.getLevel(index + count - 1) >= 0)
            {
                this._suspendInvalidate(arg);
                this._canUndo = true;
                sheet.colRangeGroup.ungroupRange(index,count);
                this._resumeInvalidate(arg);
                sheet.invalidateLayout();
                sheet.repaint()
            }
            else
                this._canUndo = false
        }
    };
    ColumnUngroupUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    ColumnUngroupUndoAction.prototype.saveState = function(){};
    ColumnUngroupUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(this._canUndo === true && sheet && this._columnUngroupExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._columnUngroupExtent.index;
            var count = this._columnUngroupExtent.count;
            sheet.colRangeGroup.group(index,count);
            ret = true;
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    RowGroupUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    RowGroupUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._rowGroupExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._rowGroupExtent.index;
            var count = this._rowGroupExtent.count;
            sheet.rowRangeGroup.group(index,count);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    RowGroupUndoAction.prototype.saveState = function(){};
    RowGroupUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._rowGroupExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._rowGroupExtent.index;
            var count = this._rowGroupExtent.count;
            sheet.rowRangeGroup.ungroupRange(index,count);
            ret = true;
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    RowUngroupUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    RowUngroupUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._rowUngroupExtent && sheet.rowRangeGroup)
        {
            var index = this._rowUngroupExtent.index;
            var count = this._rowUngroupExtent.count;
            if(sheet.rowRangeGroup.getLevel(index) >= 0 || sheet.rowRangeGroup.getLevel(index + count - 1) >= 0)
            {
                this._suspendInvalidate(arg);
                this._canUndo = true;
                sheet.rowRangeGroup.ungroupRange(index,count);
                this._resumeInvalidate(arg);
                sheet.invalidateLayout();
                sheet.repaint()
            }
            else
                this._canUndo = false
        }
    };
    RowUngroupUndoAction.prototype.canUndo = function()
    {
        return this._canUndo
    };
    RowUngroupUndoAction.prototype.saveState = function(){};
    RowUngroupUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(this._canUndo === true && sheet && this._rowUngroupExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._rowUngroupExtent.index;
            var count = this._rowUngroupExtent.count;
            sheet.rowRangeGroup.group(index,count);
            ret = true;
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    ColumnGroupExpandUndoAction.prototype.canExecute = function()
    {
        return true
    };
    ColumnGroupExpandUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._columnExpandExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._columnExpandExtent.index;
            var collapsed = this._columnExpandExtent.collapsed;
            sheet.colRangeGroup.setCollapsed(index,collapsed);
            if(sheet._allowCellOverflow === true)
                sheet._clearCellOverflowModelCache();
            this._resumeInvalidate(arg);
            this._showColumnRangeGroup(collapsed);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    ColumnGroupExpandUndoAction.prototype.saveState = function(){};
    ColumnGroupExpandUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._columnExpandExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._columnExpandExtent.index;
            var collapsed = this._columnExpandExtent.collapsed;
            sheet.colRangeGroup.setCollapsed(index,!collapsed);
            if(sheet._allowCellOverflow === true)
                sheet._clearCellOverflowModelCache();
            ret = true;
            this._resumeInvalidate(arg);
            this._showColumnRangeGroup(!collapsed);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    ColumnGroupExpandUndoAction.prototype._showColumnRangeGroup = function(collapsed)
    {
        var sheet = this._sheet;
        var summaryIndex = this._columnExpandExtent.index;
        if(summaryIndex < 0 || summaryIndex >= sheet.getColumnCount())
            return;
        var rangeGroup,
            startIndex,
            endIndex,
            viewportIndex,
            leftColumn,
            viewportWidth,
            needViewportWidth;
        if(sheet.colRangeGroup.direction === UI.RangeGroupDirection.Forward)
        {
            rangeGroup = sheet.colRangeGroup.find(summaryIndex - 1,this._columnExpandExtent.level);
            if(!rangeGroup)
                return;
            startIndex = rangeGroup.start;
            endIndex = summaryIndex;
            viewportIndex = 1;
            if(collapsed)
                startIndex = summaryIndex;
            else if(startIndex < sheet.frozenColCount)
                startIndex = sheet.frozenColCount;
            leftColumn = sheet.getViewportLeftColumn(viewportIndex);
            if(startIndex < leftColumn)
                leftColumn = startIndex;
            viewportWidth = sheet.getViewportWidth(viewportIndex);
            needViewportWidth = this._getColsTotalWidth(sheet,leftColumn,endIndex);
            if(needViewportWidth > viewportWidth)
                leftColumn = this._getNewLeftColumn(sheet,leftColumn,needViewportWidth - viewportWidth);
            sheet._scrollLeftCol = this._tryGetNextScrollableCol(sheet,leftColumn)
        }
        else
        {
            rangeGroup = sheet.colRangeGroup.find(summaryIndex + 1,this._columnExpandExtent.level);
            if(!rangeGroup)
                return;
            startIndex = summaryIndex;
            endIndex = rangeGroup.end;
            viewportIndex = 1;
            if(collapsed)
                endIndex = summaryIndex;
            else
            {
                var colCount = sheet.getColumnCount();
                if(endIndex >= colCount)
                    endIndex = colCount - 1
            }
            leftColumn = sheet.getViewportLeftColumn(viewportIndex);
            if(startIndex < leftColumn)
                sheet._scrollLeftCol = this._tryGetNextScrollableCol(sheet,startIndex);
            else
            {
                viewportWidth = sheet.getViewportWidth(viewportIndex);
                needViewportWidth = this._getColsTotalWidth(sheet,leftColumn,endIndex);
                if(needViewportWidth > viewportWidth)
                {
                    leftColumn = this._getNewLeftColumn(sheet,leftColumn,needViewportWidth - viewportWidth);
                    sheet._scrollLeftCol = this._tryGetNextScrollableCol(sheet,Math.min(startIndex,leftColumn))
                }
            }
        }
        sheet._syncHScollbarPosition()
    };
    ColumnGroupExpandUndoAction.prototype._getColsTotalWidth = function(sheet, leftColumn, rightColumn)
    {
        var columnWidthTotal = 0;
        var colCount = sheet.getColumnCount();
        for(var index = leftColumn; index <= rightColumn && index < colCount; index++)
            columnWidthTotal += sheet.getColumnWidth(index) * sheet._zoomFactor;
        return columnWidthTotal
    };
    ColumnGroupExpandUndoAction.prototype._getNewLeftColumn = function(sheet, oldLeftColumn, increasedWidth)
    {
        var columnWidthTotal = 0;
        var colCount = sheet.getColumnCount();
        for(var index = oldLeftColumn; index < colCount && columnWidthTotal < increasedWidth; index++)
        {
            oldLeftColumn++;
            columnWidthTotal += sheet.getColumnWidth(index) * sheet._zoomFactor
        }
        return oldLeftColumn >= colCount ? colCount - 1 : oldLeftColumn
    };
    ColumnGroupExpandUndoAction.prototype._tryGetNextScrollableCol = function(sheet, startColumn)
    {
        var min = sheet.frozenColCount;
        var max = sheet.getColumnCount() - 1;
        if(startColumn < min)
            return min;
        if(startColumn > max)
            return max;
        for(var i = startColumn; i <= max; i++)
        {
            var columnHeight = sheet.getColumnWidth(i);
            if(columnHeight > 0)
                return i
        }
        return-1
    };
    RowGroupExpandUndoAction.prototype.canExecute = function()
    {
        return true
    };
    RowGroupExpandUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._rowExpandExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._rowExpandExtent.index;
            var collapsed = this._rowExpandExtent.collapsed;
            sheet.rowRangeGroup.setCollapsed(index,collapsed);
            this._resumeInvalidate(arg);
            this._showRowRangeGroup(collapsed);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    RowGroupExpandUndoAction.prototype.saveState = function(){};
    RowGroupExpandUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._rowExpandExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            var index = this._rowExpandExtent.index;
            var collapsed = this._rowExpandExtent.collapsed;
            sheet.rowRangeGroup.setCollapsed(index,!collapsed);
            ret = true;
            this._resumeInvalidate(arg);
            this._showRowRangeGroup(!collapsed);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    RowGroupExpandUndoAction.prototype._showRowRangeGroup = function(collapsed)
    {
        var sheet = this._sheet;
        var summaryIndex = this._rowExpandExtent.index;
        if(summaryIndex < 0 || summaryIndex >= sheet.getRowCount())
            return;
        var rangeGroup,
            startIndex,
            endIndex,
            viewportIndex,
            topRow,
            viewportHeight,
            needViewportHeight;
        if(sheet.rowRangeGroup.direction === UI.RangeGroupDirection.Forward)
        {
            rangeGroup = sheet.rowRangeGroup.find(summaryIndex - 1,this._rowExpandExtent.level);
            if(!rangeGroup)
                return;
            startIndex = rangeGroup.start;
            endIndex = summaryIndex;
            viewportIndex = 1;
            if(collapsed)
                startIndex = summaryIndex;
            else if(startIndex < sheet.frozenRowCount)
                startIndex = sheet.frozenRowCount;
            topRow = sheet.getViewportTopRow(viewportIndex);
            if(startIndex < topRow)
                topRow = startIndex;
            viewportHeight = sheet.getViewportHeight(viewportIndex);
            needViewportHeight = this._getRowsTotalHeight(sheet,topRow,endIndex);
            if(needViewportHeight > viewportHeight)
                topRow = this._getNewTopRow(sheet,topRow,needViewportHeight - viewportHeight);
            sheet._scrollTopRow = this._tryGetNextScrollableRow(sheet,topRow)
        }
        else
        {
            rangeGroup = sheet.rowRangeGroup.find(summaryIndex + 1,this._rowExpandExtent.level);
            if(!rangeGroup)
                return;
            startIndex = summaryIndex;
            endIndex = rangeGroup.end;
            viewportIndex = 1;
            if(collapsed)
                endIndex = summaryIndex;
            else
            {
                var rowCount = sheet.getRowCount();
                if(endIndex >= rowCount)
                    endIndex = rowCount - 1
            }
            topRow = sheet.getViewportTopRow(viewportIndex);
            if(startIndex < topRow)
                sheet._scrollTopRow = this._tryGetNextScrollableRow(sheet,startIndex);
            else
            {
                viewportHeight = sheet.getViewportHeight(viewportIndex);
                needViewportHeight = this._getRowsTotalHeight(sheet,topRow,endIndex);
                if(needViewportHeight > viewportHeight)
                {
                    topRow = this._getNewTopRow(sheet,topRow,needViewportHeight - viewportHeight);
                    sheet._scrollTopRow = this._tryGetNextScrollableRow(sheet,Math.min(startIndex,topRow))
                }
            }
        }
        sheet._syncVScrollbarPosition()
    };
    RowGroupExpandUndoAction.prototype._getRowsTotalHeight = function(sheet, topRow, bottomRow)
    {
        var rowHeightTotal = 0;
        var rowCount = sheet.getRowCount();
        for(var index = topRow; index <= bottomRow && index < rowCount; index++)
            rowHeightTotal += sheet.getRowHeight(index) * sheet._zoomFactor;
        return rowHeightTotal
    };
    RowGroupExpandUndoAction.prototype._getNewTopRow = function(sheet, oldTopRow, increasedHeight)
    {
        var rowHeightTotal = 0;
        var rowCount = sheet.getRowCount();
        for(var index = oldTopRow; index <= rowCount && rowHeightTotal < increasedHeight; index++)
        {
            oldTopRow++;
            rowHeightTotal += sheet.getRowHeight(index) * sheet._zoomFactor
        }
        return oldTopRow >= rowCount ? rowCount - 1 : oldTopRow
    };
    RowGroupExpandUndoAction.prototype._tryGetNextScrollableRow = function(sheet, startRow)
    {
        var min = sheet.frozenRowCount;
        var max = sheet.getRowCount() - 1;
        if(startRow < min)
            return min;
        if(startRow > max)
            return max;
        for(var i = startRow; i <= max; i++)
        {
            var rowHeight = sheet.getRowHeight(i);
            if(rowHeight > 0)
                return i
        }
        return-1
    };
    ColumnGroupHeaderExpandUndoAction.prototype.canExecute = function()
    {
        return true
    };
    ColumnGroupHeaderExpandUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._columnGroupHeaderExpandExtent && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            this.saveState();
            var level = this._columnGroupHeaderExpandExtent.level;
            for(var index = 0; index < level; index++)
                sheet.colRangeGroup.expand(index,true);
            sheet.colRangeGroup.expand(level,false);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    ColumnGroupHeaderExpandUndoAction.prototype.saveState = function()
    {
        var status = null;
        var sheet = this._sheet;
        if(sheet && this._columnGroupHeaderExpandExtent && sheet.colRangeGroup)
        {
            var level = this._columnGroupHeaderExpandExtent.level;
            status = {};
            for(var index = 0; index <= level; index++)
            {
                var columnIndex = 0;
                var columnCount = sheet.getColumnCount();
                var direction = sheet.colRangeGroup.direction;
                while(columnIndex < columnCount)
                {
                    var group = sheet.colRangeGroup.find(columnIndex,index);
                    if(group)
                    {
                        var summaryIndex = -1;
                        switch(direction)
                        {
                            case UI.RangeGroupDirection.Backward:
                                summaryIndex = group.start - 1;
                                break;
                            case UI.RangeGroupDirection.Forward:
                                summaryIndex = group.end + 1;
                                break;
                            default:
                                break
                        }
                        var isCollapsed = group.getState() === UI.GroupState.Collapsed;
                        if(!status[summaryIndex])
                            status[summaryIndex] = isCollapsed;
                        columnIndex += group.end - group.start + 1
                    }
                    columnIndex++
                }
            }
        }
        this._oldStatus = status
    };
    ColumnGroupHeaderExpandUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._oldStatus && sheet.colRangeGroup)
        {
            this._suspendInvalidate(arg);
            for(var index in this._oldStatus)
                if(index)
                {
                    sheet.colRangeGroup.setCollapsed(index,this._oldStatus[index]);
                    ret = true
                }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    RowGroupHeaderExpandUndoAction.prototype.canExecute = function()
    {
        return true
    };
    RowGroupHeaderExpandUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._rowGroupHeaderExpandExtent && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            this.saveState();
            var level = this._rowGroupHeaderExpandExtent.level;
            for(var index = 0; index < level; index++)
                sheet.rowRangeGroup.expand(index,true);
            sheet.rowRangeGroup.expand(level,false);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    RowGroupHeaderExpandUndoAction.prototype.saveState = function()
    {
        var status = null;
        var sheet = this._sheet;
        if(sheet && this._rowGroupHeaderExpandExtent && sheet.rowRangeGroup)
        {
            var level = this._rowGroupHeaderExpandExtent.level;
            status = {};
            for(var index = 0; index <= level; index++)
            {
                var rowIndex = 0;
                var rowCount = sheet.getRowCount();
                var direction = sheet.rowRangeGroup.direction;
                while(rowIndex < rowCount)
                {
                    var group = sheet.rowRangeGroup.find(rowIndex,index);
                    if(group)
                    {
                        var summaryIndex = -1;
                        switch(direction)
                        {
                            case UI.RangeGroupDirection.Backward:
                                summaryIndex = group.start - 1;
                                break;
                            case UI.RangeGroupDirection.Forward:
                                summaryIndex = group.end + 1;
                                break;
                            default:
                                break
                        }
                        var isCollapsed = group.getState() === UI.GroupState.Collapsed;
                        if(!status[summaryIndex])
                            status[summaryIndex] = isCollapsed;
                        rowIndex += group.end - group.start + 1
                    }
                    rowIndex++
                }
            }
        }
        this._oldStatus = status
    };
    RowGroupHeaderExpandUndoAction.prototype.undo = function(arg)
    {
        var ret = false;
        var sheet = this._sheet;
        if(sheet && this._oldStatus && sheet.rowRangeGroup)
        {
            this._suspendInvalidate(arg);
            for(var index in this._oldStatus)
                if(index)
                {
                    sheet.rowRangeGroup.setCollapsed(index,this._oldStatus[index]);
                    ret = true
                }
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
        return ret
    };
    DragDropUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    DragDropUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(!sheet._isValidRange(this._dragDropExtent.fromRow,this._dragDropExtent.fromColumn,this._dragDropExtent.rowCount,this._dragDropExtent.columnCount,this._sheet.getRowCount(),this._sheet.getColumnCount()))
            return;
        if(!this._insert)
            if(!sheet._isValidRange(this._dragDropExtent.toRow,this._dragDropExtent.toColumn,this._dragDropExtent.rowCount,this._dragDropExtent.columnCount,this._sheet.getRowCount(),this._sheet.getColumnCount()))
                return;
        this.saveState();
        var from,
            to,
            count,
            oldSelections,
            newSelections;
        if(this._insert)
        {
            var ifr = this._dragDropExtent.fromRow,
                ifc = this._dragDropExtent.fromColumn;
            if(ifc >= 0 && ifr < 0)
            {
                from = this._dragDropExtent.fromColumn;
                to = this._dragDropExtent.toColumn;
                count = this._dragDropExtent.columnCount;
                var activeColumn = this._dragDropExtent.toColumn;
                this._suspendInvalidate(arg);
                try
                {
                    this._sheet.addColumns(to,count);
                    if(this._copy)
                        this._sheet.copyTo(-1,to <= from ? from + count : from,-1,to,-1,count,this._option);
                    else
                    {
                        this._sheet.moveTo(-1,to <= from ? from + count : from,-1,to,-1,count,this._option);
                        this._sheet.deleteColumns(to <= from ? from + count : from,count);
                        if(from < to)
                            activeColumn = to - count
                    }
                }
                finally
                {
                    this._resumeInvalidate(arg)
                }
                if(sheet)
                {
                    oldSelections = sheet.getSelections().toArray();
                    sheet._clearSelectionImp();
                    sheet.addSelection(-1,activeColumn,sheet.getRowCount(),count);
                    newSelections = sheet.getSelections();
                    sheet._trigger(UI.Events.SelectionChanging,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        oldSelections: oldSelections,
                        newSelections: newSelections
                    });
                    sheet._trigger(UI.Events.SelectionChanged,{
                        sheet: sheet,
                        sheetName: sheet._name
                    });
                    sheet._setActiveCellImp(sheet._getFirstVisualRow(),activeColumn,sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
                    sheet.invalidateLayout();
                    sheet._dragRect = {};
                    sheet.repaint()
                }
            }
            else if(this._dragDropExtent.fromRow >= 0 && this._dragDropExtent.fromColumn < 0)
            {
                from = this._dragDropExtent.fromRow;
                to = this._dragDropExtent.toRow;
                count = this._dragDropExtent.rowCount;
                var activeRow = this._dragDropExtent.toRow;
                this._suspendInvalidate(arg);
                try
                {
                    this._sheet.addRows(to,count);
                    if(this._copy)
                        this._sheet.copyTo(to <= from ? from + count : from,-1,to,-1,count,-1,this._option);
                    else
                    {
                        this._sheet.moveTo(to <= from ? from + count : from,-1,to,-1,count,-1,this._option);
                        this._sheet.deleteRows(to <= from ? from + count : from,count);
                        if(from < to)
                            activeRow = to - count
                    }
                }
                finally
                {
                    this._resumeInvalidate(arg)
                }
                if(sheet)
                {
                    oldSelections = sheet.getSelections().toArray();
                    sheet._clearSelectionImp();
                    sheet.addSelection(activeRow,-1,count,sheet.getColumnCount());
                    newSelections = sheet.getSelections();
                    sheet._trigger(UI.Events.SelectionChanging,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        oldSelections: oldSelections,
                        newSelections: newSelections
                    });
                    sheet._trigger(UI.Events.SelectionChanged,{
                        sheet: sheet,
                        sheetName: sheet._name
                    });
                    sheet._setActiveCellImp(activeRow,sheet._getFirstVisualColumn(),sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
                    sheet.invalidateLayout();
                    sheet._dragRect = {};
                    sheet.repaint()
                }
            }
        }
        else
        {
            var fromRow = this._dragDropExtent.fromRow;
            var fromColumn = this._dragDropExtent.fromColumn;
            var toRow = this._dragDropExtent.toRow;
            var toColumn = this._dragDropExtent.toColumn;
            var rowCount = this._dragDropExtent.rowCount;
            var columnCount = this._dragDropExtent.columnCount;
            this._suspendInvalidate(arg);
            try
            {
                if(this._copy)
                    this._sheet.copyTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,this._option);
                else
                    this._sheet.moveTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,this._option);
                if(sheet)
                {
                    oldSelections = sheet.getSelections().toArray();
                    sheet._clearSelectionImp();
                    sheet.addSelection(toRow,toColumn,rowCount,columnCount);
                    newSelections = sheet.getSelections().toArray();
                    sheet._trigger(UI.Events.SelectionChanging,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        oldSelections: oldSelections,
                        newSelections: newSelections
                    });
                    sheet._trigger(UI.Events.SelectionChanged,{
                        sheet: sheet,
                        sheetName: sheet._name
                    });
                    sheet._setActiveCellImp(Math.max(sheet._getFirstVisualRow(),toRow),Math.max(sheet._getFirstVisualColumn(),toColumn),sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
                    if(!this._copy && this._savedFromViewportCells && this._savedFromViewportCells.isValueSaved())
                        CopyMoveHelper.raiseRangeDataChanged(sheet,fromRow,fromColumn,rowCount,columnCount,this._savedFromViewportCells.getValues());
                    if(this._savedToViewportCells && this._savedToViewportCells.isValueSaved())
                        CopyMoveHelper.raiseRangeDataChanged(sheet,toRow,toColumn,rowCount,columnCount,this._savedToViewportCells.getValues())
                }
            }
            finally
            {
                this._resumeInvalidate(arg)
            }
            if(sheet)
            {
                sheet.invalidateLayout();
                sheet._dragRect = {};
                sheet.repaint()
            }
        }
    };
    DragDropUndoAction.prototype.saveState = function()
    {
        this.initSaveState();
        var fromRow = this._dragDropExtent.fromRow < 0 ? 0 : this._dragDropExtent.fromRow;
        var fromColumn = this._dragDropExtent.fromColumn < 0 ? 0 : this._dragDropExtent.fromColumn;
        var toRow = this._dragDropExtent.toRow < 0 ? 0 : this._dragDropExtent.toRow;
        var toColumn = this._dragDropExtent.toColumn < 0 ? 0 : this._dragDropExtent.toColumn;
        var rowCount = this._dragDropExtent.fromRow < 0 ? this._sheet.getRowCount() : this._dragDropExtent.rowCount;
        var columnCount = this._dragDropExtent.fromColumn < 0 ? this._sheet.getColumnCount() : this._dragDropExtent.columnCount;
        if(!this._insert)
        {
            if(this._dragDropExtent.fromRow < 0)
            {
                var toColumnHeaderCellsInfo = new CopyMoveCellsInfo(this._sheet.getRowCount(UI.SheetArea.colHeader),columnCount);
                var toColumnsInfo = new CopyMoveColumnsInfo(columnCount);
                CopyMoveHelper.saveColumnHeaderInfo(this._sheet,toColumnHeaderCellsInfo,toColumnsInfo,toColumn,this._option);
                this._savedToColumnHeaderCells = toColumnHeaderCellsInfo;
                this._savedToColumns = toColumnsInfo;
                if(!this._copy)
                {
                    var fromColumnHeaderCellsInfo = new CopyMoveCellsInfo(this._sheet.getRowCount(UI.SheetArea.colHeader),columnCount);
                    var fromColumnsInfo = new CopyMoveColumnsInfo(columnCount);
                    CopyMoveHelper.saveColumnHeaderInfo(this._sheet,fromColumnHeaderCellsInfo,fromColumnsInfo,fromColumn,this._option);
                    this._savedFromColumnHeaderCells = fromColumnHeaderCellsInfo;
                    this._savedFromColumns = fromColumnsInfo
                }
            }
            if(this._dragDropExtent.fromColumn < 0)
            {
                var toRowHeaderCellsInfo = new CopyMoveCellsInfo(rowCount,this._sheet.getColumnCount(UI.SheetArea.rowHeader));
                var toRowsInfo = new CopyMoveRowsInfo(rowCount);
                CopyMoveHelper.saveRowHeaderInfo(this._sheet,toRowHeaderCellsInfo,toRowsInfo,toRow,this._option);
                this._savedToRowHeaderCells = toRowHeaderCellsInfo;
                this._savedToRows = toRowsInfo;
                if(!this._copy)
                {
                    var fromRowHeaderCellsInfo = new CopyMoveCellsInfo(rowCount,this._sheet.getColumnCount(UI.SheetArea.rowHeader));
                    var fromRowsInfo = new CopyMoveRowsInfo(rowCount);
                    CopyMoveHelper.saveRowHeaderInfo(this._sheet,fromRowHeaderCellsInfo,fromRowsInfo,fromRow,this._option);
                    this._savedFromRowHeaderCells = fromRowHeaderCellsInfo;
                    this._savedFromRows = fromRowsInfo
                }
            }
            var toViewportCellsInfo = new CopyMoveCellsInfo(rowCount,columnCount);
            CopyMoveHelper.saveViewportInfo(this._sheet,toViewportCellsInfo,toRow,toColumn,this._option);
            this._savedToViewportCells = toViewportCellsInfo;
            if(!this._copy)
            {
                var fromViewportCellsInfo = new CopyMoveCellsInfo(rowCount,columnCount);
                CopyMoveHelper.saveViewportInfo(this._sheet,fromViewportCellsInfo,fromRow,fromColumn,this._option);
                this._savedFromViewportCells = fromViewportCellsInfo
            }
        }
        this._savedAcitveRowViewportIndex = this._sheet.activeRowViewportIndex;
        this._savedAcitveColumnViewportIndex = this._sheet.activeColViewportIndex;
        this._savedActiveRow = this._sheet._activeRowIndex;
        this._savedActiveColumn = this._sheet._activeColIndex
    };
    DragDropUndoAction.prototype.initSaveState = function()
    {
        this._savedFromColumnHeaderCells = null;
        this._savedFromColumns = null;
        this._savedFromViewportCells = null;
        this._savedFromRowHeaderCells = null;
        this._savedFromRows = null;
        this._savedToColumnHeaderCells = null;
        this._savedToColumns = null;
        this._savedToViewportCells = null;
        this._savedToRowHeaderCells = null;
        this._savedToRows = null;
        this._savedAcitveRowViewportIndex = -2;
        this._savedAcitveColumnViewportIndex = -2;
        this._savedActiveRow = -1;
        this._savedActiveColumn = -1
    };
    DragDropUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._sheet;
        if(!sheet._isValidRange(this._dragDropExtent.fromRow,this._dragDropExtent.fromColumn,this._dragDropExtent.rowCount,this._dragDropExtent.columnCount,this._sheet.getRowCount(),this._sheet.getColumnCount()))
            return false;
        if(!this._insert)
            if(!sheet._isValidRange(this._dragDropExtent.toRow,this._dragDropExtent.toColumn,this._dragDropExtent.rowCount,this._dragDropExtent.columnCount,this._sheet.getRowCount(),this._sheet.getColumnCount()))
                return false;
        var ret = false,
            oldSelections,
            newSelections,
            count,
            from,
            to;
        if(this._insert)
        {
            if(!(this._dragDropExtent.fromColumn >= 0 && this._dragDropExtent.fromRow >= 0))
                if(this._dragDropExtent.fromColumn >= 0)
                {
                    var activeColumn = this._dragDropExtent.fromColumn;
                    count = this._dragDropExtent.columnCount;
                    this._suspendInvalidate(arg);
                    try
                    {
                        if(this._copy)
                            this._sheet.deleteColumns(this._dragDropExtent.toColumn,count);
                        else
                        {
                            from = this._dragDropExtent.toColumn;
                            to = this._dragDropExtent.fromColumn;
                            if(this._dragDropExtent.fromColumn < this._dragDropExtent.toColumn)
                                from = this._dragDropExtent.toColumn - count;
                            else
                                to = this._dragDropExtent.fromColumn + count;
                            this._sheet.addColumns(to,count);
                            this._sheet.copyTo(-1,to <= from ? from + count : from,-1,to,-1,count,this._option);
                            this._sheet.deleteColumns(to <= from ? from + count : from,count);
                            if(from < to)
                                activeColumn = to - count
                        }
                    }
                    finally
                    {
                        this._resumeInvalidate(arg)
                    }
                    if(sheet)
                    {
                        oldSelections = sheet.getSelections().toArray();
                        sheet._clearSelectionImp();
                        sheet.addSelection(-1,activeColumn,sheet.getRowCount(),count);
                        newSelections = sheet.getSelections();
                        sheet._trigger(UI.Events.SelectionChanging,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            oldSelections: oldSelections,
                            newSelections: newSelections
                        });
                        sheet._trigger(UI.Events.SelectionChanged,{
                            sheet: sheet,
                            sheetName: sheet._name
                        });
                        sheet.invalidateLayout();
                        sheet.repaint()
                    }
                    ret = true
                }
                else if(this._dragDropExtent.fromRow >= 0)
                {
                    count = this._dragDropExtent.rowCount;
                    var activeRow = this._dragDropExtent.fromRow;
                    this._suspendInvalidate(arg);
                    try
                    {
                        if(this._copy)
                            this._sheet.deleteRows(this._dragDropExtent.toRow,count);
                        else
                        {
                            from = this._dragDropExtent.toRow;
                            to = this._dragDropExtent.fromRow;
                            if(this._dragDropExtent.fromRow < this._dragDropExtent.toRow)
                                from = this._dragDropExtent.toRow - count;
                            else
                                to = this._dragDropExtent.fromRow + count;
                            this._sheet.addRows(to,count);
                            if(this._savedFromViewportCells)
                            {
                                CopyMoveHelper.undoCellsInfo(this._sheet,this._savedFromViewportCells,to,0,UI.SheetArea.viewport);
                                ret = true
                            }
                            if(this._savedFromRowHeaderCells)
                            {
                                CopyMoveHelper.undoCellsInfo(this._sheet,this._savedFromRowHeaderCells,to,0,UI.SheetArea.rowHeader);
                                ret = true
                            }
                            if(this._savedFromRows)
                            {
                                CopyMoveHelper.undoRowsInfo(this._sheet,this._savedFromRows,to);
                                ret = true
                            }
                            if(!ret)
                                this._sheet.copyTo(to <= from ? from + count : from,-1,to,-1,count,-1,this._option);
                            this._sheet.deleteRows(to <= from ? from + count : from,count);
                            if(from < to)
                                activeRow = to - count
                        }
                    }
                    finally
                    {
                        this._resumeInvalidate(arg)
                    }
                    if(sheet)
                    {
                        oldSelections = sheet.getSelections().toArray();
                        sheet._clearSelectionImp();
                        sheet.addSelection(activeRow,-1,count,sheet.getColumnCount());
                        newSelections = sheet.getSelections();
                        sheet._trigger(UI.Events.SelectionChanging,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            oldSelections: oldSelections,
                            newSelections: newSelections
                        });
                        sheet._trigger(UI.Events.SelectionChanged,{
                            sheet: sheet,
                            sheetName: sheet._name
                        });
                        sheet.invalidateLayout();
                        sheet.repaint()
                    }
                    ret = true
                }
        }
        else
        {
            var fromRow = this._dragDropExtent.fromRow < 0 ? 0 : this._dragDropExtent.fromRow;
            var fromColumn = this._dragDropExtent.fromColumn < 0 ? 0 : this._dragDropExtent.fromColumn;
            var toRow = this._dragDropExtent.toRow < 0 ? 0 : this._dragDropExtent.toRow;
            var toColumn = this._dragDropExtent.toColumn < 0 ? 0 : this._dragDropExtent.toColumn;
            var rowCount = this._dragDropExtent.fromRow < 0 ? this._sheet.getRowCount() : this._dragDropExtent.rowCount;
            var columnCount = this._dragDropExtent.fromColumn < 0 ? this._sheet.getColumnCount() : this._dragDropExtent.columnCount;
            var oldToValues = null;
            var oldFromValues = null;
            if(!this._copy && this._savedFromViewportCells && this._savedFromViewportCells.isValueSaved())
                oldFromValues = CopyMoveHelper.getValues(this._sheet,fromRow,fromColumn,rowCount,columnCount);
            if(this._savedToViewportCells && this._savedToViewportCells.isValueSaved())
                oldToValues = CopyMoveHelper.getValues(this._sheet,toRow,toColumn,rowCount,columnCount);
            this._suspendInvalidate(arg);
            try
            {
                if(this._savedToColumnHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedToColumnHeaderCells,0,toColumn,UI.SheetArea.colHeader);
                    ret = true
                }
                if(this._savedToColumns)
                {
                    CopyMoveHelper.undoColumnsInfo(this._sheet,this._savedToColumns,toColumn);
                    ret = true
                }
                if(this._savedToViewportCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedToViewportCells,toRow,toColumn,UI.SheetArea.viewport);
                    ret = true
                }
                if(this._savedToRowHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedToRowHeaderCells,toRow,0,UI.SheetArea.rowHeader);
                    ret = true
                }
                if(this._savedToRows)
                {
                    CopyMoveHelper.undoRowsInfo(this._sheet,this._savedToRows,toRow);
                    ret = true
                }
                if(this._savedFromColumnHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedFromColumnHeaderCells,0,fromColumn,UI.SheetArea.colHeader);
                    ret = true
                }
                if(this._savedFromColumns)
                {
                    CopyMoveHelper.undoColumnsInfo(this._sheet,this._savedFromColumns,fromColumn);
                    ret = true
                }
                if(this._savedFromViewportCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedFromViewportCells,fromRow,fromColumn,UI.SheetArea.viewport);
                    ret = true
                }
                if(this._savedFromRowHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._sheet,this._savedFromRowHeaderCells,fromRow,0,UI.SheetArea.rowHeader);
                    ret = true
                }
                if(this._savedFromRows)
                {
                    CopyMoveHelper.undoRowsInfo(this._sheet,this._savedFromRows,fromRow);
                    ret = true
                }
            }
            finally
            {
                this._resumeInvalidate(arg)
            }
            if(ret && sheet)
            {
                oldSelections = sheet.getSelections().toArray();
                sheet._clearSelectionImp();
                sheet.addSelection(this._dragDropExtent.fromRow,this._dragDropExtent.fromColumn,this._dragDropExtent.rowCount,this._dragDropExtent.columnCount);
                newSelections = sheet.getSelections();
                sheet._trigger(UI.Events.SelectionChanging,{
                    sheet: sheet,
                    sheetName: sheet._name,
                    oldSelections: oldSelections,
                    newSelections: newSelections
                });
                sheet._trigger(UI.Events.SelectionChanged,{
                    sheet: sheet,
                    sheetName: sheet._name
                });
                if(oldToValues)
                    CopyMoveHelper.raiseRangeDataChanged(sheet,toRow,toColumn,rowCount,columnCount,oldToValues);
                if(oldFromValues)
                    CopyMoveHelper.raiseRangeDataChanged(sheet,fromRow,fromColumn,rowCount,columnCount,oldFromValues)
            }
        }
        if(ret)
            if(sheet)
            {
                if(this._savedActiveRow !== -1 && this._savedActiveColumn !== -1)
                {
                    var selection = sheet.getSelections()[0];
                    if(selection.contains(this._savedActiveRow,this._savedActiveColumn))
                        sheet._setActiveCellImp(this._savedActiveRow,this._savedActiveColumn,false);
                    else
                        sheet._setActiveCellImp(Math.max(sheet._getFirstVisualRow(),selection.row),Math.max(sheet._getFirstVisualColumn(),selection.col),false)
                }
                if(this._savedAcitveRowViewportIndex !== -2 && this._savedAcitveColumnViewportIndex !== -2 && this._savedActiveRow !== -1 && this._savedActiveColumn !== -1)
                    sheet.showCell(this._savedActiveRow,this._savedActiveColumn,UI.VerticalPosition.nearest,UI.HorizontalPosition.nearest);
                sheet.invalidateLayout();
                sheet.repaint()
            }
        return ret
    };
    CellEditUndoAction.prototype.canExecute = function(arg)
    {
        return true
    };
    CellEditUndoAction.prototype.saveState = function()
    {
        var oldFormula = this._sheet.getFormula(this._cellEditInfo.row,this._cellEditInfo.col);
        if(!(oldFormula === null || oldFormula === ""))
        {
            this._oldValue = oldFormula;
            this._oldValueIsFormula = true
        }
        else
        {
            this._oldValue = this._sheet.getValue(this._cellEditInfo.row,this._cellEditInfo.col);
            this._oldValueIsFormula = false
        }
    };
    CellEditUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._sheet;
        var row = this._cellEditInfo.row;
        var col = this._cellEditInfo.col;
        try
        {
            this._suspendInvalidate(arg);
            sheet._bind(UI.Events.CellChanged,function(event, data)
            {
                if(data.propertyName === "value")
                    sheet._trigger(UI.Events.ValueChanged,{
                        sheet: data.sheet,
                        sheetName: data.sheetName,
                        row: data.row,
                        col: data.col,
                        oldValue: data._oldValue,
                        newValue: data.sheet.getValue(data.row,data.col)
                    })
            });
            if(this._oldValueIsFormula)
                sheet.setFormula(row,col,this._oldValue);
            else
            {
                var formula = sheet.getFormula(row,col);
                if(!(formula === null || formula === ""))
                    sheet.setFormula(row,col,null);
                sheet.setValue(row,col,this._oldValue)
            }
            this._resumeInvalidate(arg);
            this._sheet.repaint();
            return true
        }
        catch(ex)
        {
            return false
        }
        finally
        {
            sheet._unbind(UI.Events.CellChanged)
        }
    };
    CellEditUndoAction.prototype.execute = function(arg)
    {
        this._suspendInvalidate(arg);
        this.saveState();
        var sheet = this._sheet;
        var old = sheet.isPaintSuspended();
        try
        {
            sheet.isPaintSuspended(true);
            sheet._bind(UI.Events.CellChanged,function(event, data)
            {
                if(data.propertyName === "value")
                    sheet._trigger(UI.Events.ValueChanged,{
                        sheet: data.sheet,
                        sheetName: data.sheetName,
                        row: data.row,
                        col: data.col,
                        oldValue: data._oldValue,
                        newValue: data.sheet.getValue(data.row,data.col)
                    })
            });
            this.applyResult = this._applyEditing(arg)
        }
        finally
        {
            this._sheet._unbind(UI.Events.CellChanged);
            this._resumeInvalidate(arg);
            sheet.isPaintSuspended(old)
        }
        this._canUndo = this.applyResult === UI.DataValidationResult.ForceApply
    };
    CellEditUndoAction.prototype._applyEditing = function(arg)
    {
        var sheet = this._sheet;
        var row = this._cellEditInfo.row;
        var col = this._cellEditInfo.col;
        var text = this._cellEditInfo.newValue;
        var autoFormat = this._cellEditInfo.hasOwnProperty("autoFormat") ? this._cellEditInfo.autoFormat : true;
        var action = UI.DataValidationResult.ForceApply;
        var canUserEditFormula = sheet.parent ? sheet.parent.canUserEditFormula() : true;
        var value;
        if(text && text.length > 0 && text[0] === "=")
        {
            if(sheet.getDataValidator(row,col))
            {
                var newFormula = text.substring(1);
                if(newFormula !== '' && newFormula !== sheet.getFormula(row,col))
                {
                    var svc = sheet.getCalcService();
                    if(svc)
                    {
                        var expr = svc.parse(newFormula,row >= 0 ? row : 0,col >= 0 ? col : 0);
                        if(expr)
                        {
                            var calc = svc.evaluateParsedFormula(sheet._getSheetSource(),expr,row,col);
                            if(!sheet.isValid(row,col,calc))
                                action = sheet._validationError(row,col,calc)
                        }
                    }
                }
            }
        }
        else
        {
            value = this._getValueFromEditing(row,col,text,autoFormat);
            var valid = sheet.isValid(row,col,value);
            if(!valid)
            {
                action = sheet._validationError(row,col,text);
                sheet._eventHandler._forceCancelSelectiong = true
            }
        }
        if(!(action === UI.DataValidationResult.Discard || action === UI.DataValidationResult.Retry))
            if(action === UI.DataValidationResult.ForceApply)
                if(canUserEditFormula && text && text.length > 0 && text[0] === "=")
                {
                    try
                    {
                        sheet.setFormula(row,col,text.substring(1))
                    }
                    catch(e)
                    {
                        sheet._trigger(UI.Events.InvalidOperation,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            message: e.message
                        });
                        throw e;
                    }
                    sheet._trigger(UI.Events.UserFormulaEntered,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: row,
                        col: col,
                        formula: text.substring(1).toUpperCase()
                    })
                }
                else
                {
                    if(sheet.hasFormula(row,col))
                        sheet.setFormula(row,col,null);
                    try
                    {
                        if(/^('=)/ig.test(text))
                            text = text.substring(1);
                        if(value === undefined || value === null)
                            value = this._getValueFromEditing(row,col,text,autoFormat);
                        sheet.setValue(row,col,value)
                    }
                    catch(ex)
                    {
                        sheet.setValue(row,col,text)
                    }
                }
        return action
    };
    CellEditUndoAction.prototype.canUndo = function(arg)
    {
        return this._canUndo
    };
    CellEditUndoAction.prototype._getValueFromEditing = function(row, col, text, autoFormat)
    {
        var cellFormatter = null;
        var style = this._sheet.getActualStyle(row,col);
        if(style)
            if(style.formatter)
            {
                cellFormatter = style.formatter;
                if(typeof cellFormatter === 'string')
                {
                    cellFormatter = new UI.GeneralFormatter(cellFormatter);
                    if(this._sheet._editingTimeValue)
                        cellFormatter = new UI.GeneralFormatter("dd/mm/yyyy hh:mm:ss")
                }
            }
            else
                cellFormatter = style._autoFormatter;
        if(cellFormatter && !(cellFormatter instanceof UI.AutoFormatter))
        {
            var customerValue = null;
            try
            {
                customerValue = cellFormatter.Parse(text)
            }
            catch(ex){}
            return customerValue === undefined || customerValue === null ? text : customerValue
        }
        else if(autoFormat)
        {
            var aValRef = {};
            var autoDisplayFormatter = null;
            try
            {
                autoDisplayFormatter = (new UI.GeneralFormatter).GetPreferredDisplayFormatter(text,aValRef)
            }
            catch(ex){}
            var af = null;
            if(cellFormatter && cellFormatter instanceof UI.AutoFormatter && aValRef.value !== null && autoDisplayFormatter && autoDisplayFormatter.FormatString() !== "General")
                af = new UI.AutoFormatter(autoDisplayFormatter);
            else if(!cellFormatter && autoDisplayFormatter)
                af = new UI.AutoFormatter(autoDisplayFormatter);
            if(af)
            {
                var storedStyle = this._sheet.getStyle(row,col);
                if(!storedStyle)
                    storedStyle = new UI.Style;
                storedStyle._autoFormatter = af;
                this._sheet.setStyle(row,col,storedStyle)
            }
            return aValRef.value !== null ? aValRef.value : text
        }
        else
            return text
    };
    SheetRenameUndoAction.prototype.canUndo = function()
    {
        return!!this._oldName
    };
    SheetRenameUndoAction.prototype.canExecute = function(arg)
    {
        return this._sheet && this._newName && this._newName !== this._oldName
    };
    SheetRenameUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        if(sheet && this._newName && this._newName !== this._oldName)
        {
            this.saveState();
            this._suspendInvalidate(arg);
            sheet._name = this._newName;
            this._resumeInvalidate(arg);
            sheet._refreshTabStrip()
        }
    };
    SheetRenameUndoAction.prototype.canUndo = function()
    {
        return!!this._oldName
    };
    SheetRenameUndoAction.prototype.saveState = function()
    {
        if(this._sheet)
            this._oldName = this._sheet._name
    };
    SheetRenameUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._sheet;
        if(sheet)
        {
            this._suspendInvalidate(arg);
            sheet._name = this._oldName;
            this._resumeInvalidate(arg);
            sheet._refreshTabStrip();
            return true
        }
        return false
    };
    ZoomUndoAction.prototype.canExecute = function(arg)
    {
        return this._sheet && this._sheet.parent._allowUserZoom && this._sheet._zoomFactor !== this._zoomFactor
    };
    ZoomUndoAction.prototype.execute = function(arg)
    {
        var sheet = this._sheet;
        this.saveState();
        if(sheet && (!sheet.parent || sheet.parent._allowUserZoom === true) && sheet._zoomFactor !== this._zoomFactor)
        {
            if(sheet.isEditing() === true)
                sheet.endEdit();
            this._suspendInvalidate(arg);
            sheet.zoom(this._zoomFactor);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    ZoomUndoAction.prototype.canUndo = function()
    {
        return this._sheet && this._prevZoomFactor > 0
    };
    ZoomUndoAction.prototype.saveState = function()
    {
        if(this._sheet)
            this._prevZoomFactor = this._sheet._zoomFactor
    };
    ZoomUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._sheet;
        if(sheet)
        {
            this._suspendInvalidate(arg);
            sheet.zoom(this._prevZoomFactor);
            this._resumeInvalidate(arg);
            sheet.invalidateLayout();
            sheet.repaint();
            return true
        }
        return false
    };
    ClearValueUndoAction.prototype.canExecute = function(arg)
    {
        if(this._cachedActions)
        {
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var item = this._cachedActions[i];
                if(!item.canExecute(arg))
                    return false
            }
            return true
        }
        return false
    };
    ClearValueUndoAction.prototype.execute = function(arg)
    {
        this.saveState();
        if(this._cachedActions)
        {
            this._suspendInvalidate(arg);
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var item = this._cachedActions[i];
                item.execute(arg)
            }
            this._resumeInvalidate(arg);
            this._sheet.repaint()
        }
    };
    ClearValueUndoAction.prototype.canUndo = function()
    {
        if(this._cachedActions)
        {
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var item = this._cachedActions[i];
                if(!item.canUndo())
                    return false
            }
            return true
        }
        return false
    };
    ClearValueUndoAction.prototype.saveState = function()
    {
        if(this._cachedActions)
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var item = this._cachedActions[i];
                item.saveState()
            }
    };
    ClearValueUndoAction.prototype.undo = function(arg)
    {
        if(this._cachedActions)
        {
            for(var i = this._cachedActions.length - 1; i >= 0; i--)
            {
                var action = this._cachedActions[i];
                this._suspendInvalidate(arg);
                var ret = action.undo(arg);
                this._resumeInvalidate(arg);
                if(!ret)
                    return false;
                else
                    this._sheet.repaint()
            }
            return true
        }
        return false
    };
    ClearRangeValueUndoAction.prototype.execute = function(arg)
    {
        this.saveState();
        var sheet = this._sheet;
        if(sheet)
        {
            var range = sheet._getActualRange(this._clearRange);
            if(range.colCount > 0 && range.rowCount > 0)
                try
                {
                    sheet._bind(UI.Events.CellChanged,function(event, data)
                    {
                        if(data.propertyName === "value")
                            sheet._trigger(UI.Events.ValueChanged,{
                                sheet: data.sheet,
                                sheetName: data.sheetName,
                                row: data.row,
                                col: data.col
                            })
                    });
                    var oldState = sheet.isPaintSuspended();
                    sheet.isPaintSuspended(true);
                    sheet.suspendEvent();
                    sheet.clear(range.row,range.col,range.rowCount,range.colCount,UI.SheetArea.viewport,StorageType.Data);
                    sheet.resumeEvent();
                    sheet.isPaintSuspended(oldState);
                    sheet.repaint();
                    CopyMoveHelper.raiseRangeDataChanged(sheet,range.row,range.col,range.rowCount,range.colCount)
                }
                finally
                {
                    this._sheet._unbind(UI.Events.CellChanged)
                }
        }
    };
    ClearRangeValueUndoAction.prototype.canExecute = function(arg)
    {
        var sheet = this._sheet;
        return sheet.isProtected === true && sheet._isAnyCellInRangeLocked(this._clearRange) ? false : true
    };
    ClearRangeValueUndoAction.prototype.canUndo = function()
    {
        return!!this._cachedValues
    };
    ClearRangeValueUndoAction.prototype.saveState = function()
    {
        var sheet = this._sheet;
        if(sheet)
        {
            this._cachedFilteredColumns = [];
            var rowFilter = sheet.rowFilter(),
                row,
                column;
            if(rowFilter && rowFilter.range && rowFilter.isFiltered())
            {
                row = rowFilter.range.row;
                var rowCount = rowFilter.range.rowCount;
                if(rowFilter.showFilterButton)
                {
                    row = rowFilter.range.row - 1;
                    rowCount = rowFilter.range.rowCount + 1;
                    if(row < 0)
                    {
                        row = -1;
                        rowCount = -1
                    }
                }
                if((this._clearRange.row === -1 || this._clearRange.row <= row && row + rowCount <= this._clearRange.row + this._clearRange.rowCount) && (this._clearRange.col === -1 || this._clearRange.col <= rowFilter.range.col && rowFilter.range.col + rowFilter.range.colCount <= this._clearRange.col + this._clearRange.colCount))
                {
                    column = rowFilter.range.col < 0 ? 0 : rowFilter.range.col;
                    var columnCount = rowFilter.range.colCount < 0 ? sheet.getColumnCount() : rowFilter.range.colCount;
                    for(var c = 0; c < columnCount; c++)
                        if(rowFilter.isColumnFiltered(column + c))
                            this._cachedFilteredColumns.push(column + c)
                }
            }
            var range = sheet._getActualRange(this._clearRange);
            if(range.colCount > 0 && range.rowCount > 0)
            {
                this._cachedValues = [range.row + range.rowCount];
                for(var i = 0; i < range.rowCount; i++)
                {
                    this._cachedValues[range.row + i] = [range.col + range.colCount];
                    for(var j = 0; j < range.colCount; j++)
                    {
                        row = range.row + i;
                        column = range.col + j;
                        var formula = sheet.getFormula(row,column);
                        if(formula && formula !== "")
                            this._cachedValues[row][column] = new CellValueEntry(formula,true);
                        else
                        {
                            var value = sheet.getValue(row,column);
                            if(value !== undefined && value !== null)
                                this._cachedValues[row][column] = new CellValueEntry(value,false)
                        }
                    }
                }
            }
        }
    };
    ClearRangeValueUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._sheet;
        if(sheet)
        {
            var ret = false,
                i;
            var range = sheet._getActualRange(this._clearRange);
            if(this._cachedValues && range.colCount > 0 && range.rowCount > 0)
                try
                {
                    sheet._bind(UI.Events.CellChanged,function(event, data)
                    {
                        if(data.propertyName === "value")
                            sheet._trigger(UI.Events.ValueChanged,{
                                sheet: data.sheet,
                                sheetName: data.sheetName,
                                row: data.row,
                                col: data.col
                            })
                    });
                    var rc = range.rowCount;
                    var cc = range.colCount;
                    var oldAutoRefresh = sheet.isPaintSuspended();
                    sheet.isPaintSuspended(true);
                    sheet.suspendEvent();
                    for(i = 0; i < rc; i++)
                        for(var j = 0; j < cc; j++)
                        {
                            var row = range.row + i;
                            var column = range.col + j;
                            if(this._cachedValues[row][column])
                            {
                                var entry = this._cachedValues[row][column];
                                if(entry.isFormula)
                                    sheet.setFormula(row,column,entry.value);
                                else
                                {
                                    sheet.setFormula(row,column,null);
                                    sheet.setValue(row,column,entry.value)
                                }
                            }
                            else
                            {
                                sheet.setFormula(row,column,null);
                                sheet.setValue(row,column,null)
                            }
                        }
                    sheet.resumeEvent();
                    sheet.isPaintSuspended(oldAutoRefresh);
                    CopyMoveHelper.raiseRangeDataChanged(sheet,range.row,range.col,range.rowCount,range.colCount);
                    ret = true
                }
                finally
                {
                    sheet._unbind(UI.Events.CellChanged)
                }
            var filter = sheet.rowFilter();
            if(filter && this._cachedFilteredColumns && this._cachedFilteredColumns.length > 0)
                for(i = 0; i < this._cachedFilteredColumns.length; i++)
                {
                    var col = this._cachedFilteredColumns[i];
                    filter.filter(col)
                }
            if(ret)
            {
                sheet.repaint();
                return true
            }
        }
        return false
    };
    DragFillUndoAction.prototype.canExecute = function(arg)
    {
        if(this._dragFillExtent.autoFillType === AutoFillType.ClearValues)
            return this.canExecuteDragClear();
        else
            return this.canExecuteDragFill()
    };
    DragFillUndoAction.prototype.canExecuteDragClear = function()
    {
        return true
    };
    DragFillUndoAction.prototype.canExecuteDragFill = function()
    {
        var startRange = this._dragFillExtent.startRange;
        var fillRange = this._dragFillExtent.fillRange;
        return!fillRange.intersect(startRange.row,startRange.col,startRange.rowCount,startRange.colCount)
    };
    DragFillUndoAction.prototype.execute = function(arg)
    {
        if(this.canExecute(arg))
        {
            var sheet = this._workSheet;
            try
            {
                this._suspendInvalidate(sheet);
                sheet.suspendCalcService();
                this.saveState();
                this._execute(sheet)
            }
            finally
            {
                sheet.resumeCalcService();
                this._resumeInvalidate(sheet)
            }
            sheet.invalidateLayout();
            sheet.repaint()
        }
    };
    DragFillUndoAction.prototype._execute = function(sheetView)
    {
        var sheet = this._workSheet;
        var oldSelections = sheet.getSelections() ? sheet.getSelections().toArray() : null;
        if(this._dragFillExtent.autoFillType === AutoFillType.ClearValues)
            this.executeDragFillClear(sheetView);
        else
            this.executeDragFill(sheetView);
        if(this._savedFilledViewportCells && this._savedFilledViewportCells.isValueSaved() && sheetView === this._workSheet)
        {
            var fillRange = this._dragFillExtent.fillRange;
            CopyMoveHelper.raiseRangeDataChanged(sheetView,fillRange.row,fillRange.col,fillRange.rowCount,fillRange.colCount,this._savedFilledViewportCells.getValues())
        }
        var newSelections = sheet.getSelections() ? sheet.getSelections().toArray() : null;
        if(sheet._raiseSelectionChanging(oldSelections,newSelections))
            sheet._raiseSelectionChanged()
    };
    DragFillUndoAction.prototype.executeDragFillClear = function(sheetView)
    {
        this._clearValueUndoAction.execute(sheetView);
        var startRange = this._dragFillExtent.startRange;
        var clearRange = this._dragFillExtent.fillRange;
        if(!startRange.equals(clearRange))
        {
            var newRange;
            if(this._fillSeries === FillSeries.Column)
            {
                newRange = new UI.Range(startRange.row,startRange.col,Math.max(1,startRange.rowCount - clearRange.rowCount),startRange.colCount);
                sheetView._setActiveCellImp(Math.max(sheetView._getFirstVisualRow(),newRange.row),Math.max(sheetView._getFirstVisualColumn(),newRange.col),sheetView.activeRowViewportIndex,sheetView.activeColViewportIndex);
                sheetView._clearSelectionImp();
                sheetView.addSelection(newRange.row,newRange.col,newRange.rowCount,newRange.colCount)
            }
            else
            {
                newRange = new UI.Range(startRange.row,startRange.col,startRange.rowCount,Math.max(1,startRange.colCount - clearRange.colCount));
                sheetView._setActiveCellImp(Math.max(sheetView._getFirstVisualRow(),newRange.row),Math.max(sheetView._getFirstVisualColumn(),newRange.col),sheetView.activeRowViewportIndex,sheetView.activeColViewportIndex);
                sheetView._clearSelectionImp();
                sheetView.addSelection(newRange.row,newRange.col,newRange.rowCount,newRange.colCount)
            }
        }
    };
    DragFillUndoAction.prototype.executeDragFill = function(sheetView)
    {
        var sheet = this._workSheet;
        var startRange = this._dragFillExtent.startRange;
        var fillRange = this._dragFillExtent.fillRange;
        var r,
            c,
            isIncrease;
        if(this._dragFillExtent.autoFillType === AutoFillType.FillSeries)
        {
            this.clearData(fillRange);
            isIncrease = this._dragFillExtent.fillDirection === FillDirection.Down || this._dragFillExtent.fillDirection === FillDirection.Right;
            if(isIncrease)
                sheet.fillAuto(startRange,this._wholeFillRange,this._fillSeries);
            else
                sheet.fillLinear(startRange,this._wholeFillRange,this._fillSeries)
        }
        else if(this._dragFillExtent.autoFillType === AutoFillType.CopyCells)
            this.copyCells(startRange,fillRange,UI.CopyToOption.All);
        else if(this._dragFillExtent.autoFillType === AutoFillType.FillFormattingOnly)
            this.copyCells(startRange,fillRange,UI.CopyToOption.Style);
        else if(this._dragFillExtent.autoFillType === AutoFillType.FillWithoutFormatting)
        {
            this.clearData(fillRange);
            var isDragSingleCell = startRange.rowCount === 1 && startRange.colCount === 1 && !(startRange.row === -1 && startRange.col !== -1) && !(startRange.col === -1 && startRange.row !== -1);
            if(isDragSingleCell)
            {
                var noStyleOption = UI.CopyToOption.Formula | UI.CopyToOption.RangeGroup | UI.CopyToOption.Span | UI.CopyToOption.Sparkline | UI.CopyToOption.Tag | UI.CopyToOption.Value;
                this.copyCells(startRange,fillRange,noStyleOption)
            }
            else
            {
                var fixedRange = this.adjustRange(this._wholeFillRange);
                var savedStyle = new UI._GcSheetModel(fixedRange.rowCount,fixedRange.colCount,null);
                for(r = 0; r < fixedRange.rowCount; r++)
                    for(c = 0; c < fixedRange.colCount; c++)
                        savedStyle.setStyle(r,c,CopyMoveHelper.getStyleObject(this._workSheet,fixedRange.row + r,fixedRange.col + c,UI.SheetArea.viewport));
                isIncrease = this._dragFillExtent.fillDirection === FillDirection.Down || this._dragFillExtent.fillDirection === FillDirection.Right;
                if(isIncrease)
                    sheet.fillAuto(startRange,this._wholeFillRange,this._fillSeries);
                else
                    sheet.fillLinear(startRange,this._wholeFillRange,this._fillSeries);
                for(r = 0; r < fixedRange.rowCount; r++)
                    for(c = 0; c < fixedRange.colCount; c++)
                        CopyMoveHelper.setStyleObject(this._workSheet,fixedRange.row + r,fixedRange.col + c,UI.SheetArea.viewport,savedStyle.getStyle(r,c))
            }
        }
        sheet._setActiveCellImp(Math.max(sheetView._getFirstVisualRow(),this._wholeFillRange.row),Math.max(sheetView._getFirstVisualColumn(),this._wholeFillRange.col),sheetView.activeRowViewportIndex,sheetView.activeColViewportIndex);
        if(sheetView._selectionModel)
            sheetView._clearSelectionImp();
        sheet.addSelection(this._wholeFillRange.row,this._wholeFillRange.col,this._wholeFillRange.rowCount,this._wholeFillRange.colCount)
    };
    DragFillUndoAction.prototype.clearData = function(cellRange)
    {
        var allStorages = StorageType.Data;
        this._workSheet.clear(cellRange.row,cellRange.col,cellRange.rowCount,cellRange.colCount,UI.SheetArea.viewport,allStorages)
    };
    DragFillUndoAction.prototype.adjustRange = function(range)
    {
        var row = range.row !== -1 ? range.row : 0;
        var column = range.col !== -1 ? range.col : 0;
        var rowCount = range.rowCount !== -1 ? range.rowCount : this._workSheet.getRowCount();
        var columnCount = range.colCount !== -1 ? range.colCount : this._workSheet.getColumnCount();
        return new UI.Range(row,column,rowCount,columnCount)
    };
    DragFillUndoAction.prototype.copyCells = function(fromRange, toRange, copyOption)
    {
        var sheet = this._workSheet;
        var adjustedFromRange = this.adjustRange(fromRange);
        var adjustedToRange = this.adjustRange(toRange);
        var i,
            fromRow,
            fromColumn,
            toRow,
            toColumn,
            bottomRow,
            rowCount,
            columnCount;
        if(this._fillSeries === FillSeries.Column)
        {
            var rows = Math.floor(adjustedToRange.rowCount / adjustedFromRange.rowCount);
            for(i = 0; i < rows; i++)
            {
                fromRow = adjustedFromRange.row;
                fromColumn = adjustedFromRange.col;
                if(this._dragFillExtent.fillDirection === FillDirection.Down)
                    toRow = adjustedToRange.row + i * adjustedFromRange.rowCount;
                else
                {
                    bottomRow = adjustedToRange.row + adjustedToRange.rowCount;
                    toRow = bottomRow - (i + 1) * adjustedFromRange.rowCount
                }
                toColumn = adjustedToRange.col;
                rowCount = adjustedFromRange.rowCount;
                columnCount = adjustedFromRange.colCount;
                sheet.copyTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,copyOption)
            }
            var lastCopyRows = adjustedToRange.rowCount % adjustedFromRange.rowCount;
            if(lastCopyRows !== 0)
            {
                if(this._dragFillExtent.fillDirection === FillDirection.Down)
                    fromRow = adjustedFromRange.row;
                else
                {
                    var lastRow = adjustedFromRange.rowCount - (adjustedToRange.rowCount - adjustedFromRange.rowCount * rows);
                    fromRow = adjustedFromRange.row + lastRow
                }
                fromColumn = adjustedFromRange.col;
                if(this._dragFillExtent.fillDirection === FillDirection.Down)
                    toRow = adjustedToRange.row + adjustedFromRange.rowCount * rows;
                else
                {
                    bottomRow = adjustedToRange.row + adjustedToRange.rowCount;
                    toRow = bottomRow - rows * adjustedFromRange.rowCount - lastCopyRows
                }
                toColumn = adjustedToRange.col;
                rowCount = lastCopyRows;
                columnCount = adjustedFromRange.colCount;
                sheet.copyTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,copyOption)
            }
        }
        else
        {
            var columns = Math.floor(adjustedToRange.colCount / adjustedFromRange.colCount);
            for(i = 0; i < columns; i++)
            {
                fromRow = adjustedFromRange.row;
                fromColumn = adjustedFromRange.col;
                toRow = adjustedToRange.row;
                if(this._dragFillExtent.fillDirection === FillDirection.Right)
                    toColumn = adjustedToRange.col + i * adjustedFromRange.colCount;
                else
                {
                    var bottomColumn = adjustedToRange.col + adjustedToRange.colCount;
                    toColumn = bottomColumn - (i + 1) * adjustedFromRange.colCount
                }
                rowCount = adjustedFromRange.rowCount;
                columnCount = adjustedFromRange.colCount;
                sheet.copyTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,copyOption)
            }
            var lastCopyColumns = adjustedToRange.colCount % adjustedFromRange.colCount;
            if(lastCopyColumns !== 0)
            {
                fromRow = adjustedFromRange.row;
                if(this._dragFillExtent.fillDirection === FillDirection.Right)
                    fromColumn = adjustedFromRange.col;
                else
                {
                    var lastColumn = adjustedFromRange.colCount - (adjustedToRange.colCount - adjustedFromRange.colCount * columns);
                    fromColumn = adjustedFromRange.col + lastColumn
                }
                toRow = adjustedToRange.row;
                if(this._dragFillExtent.fillDirection === FillDirection.Right)
                    toColumn = adjustedToRange.col + adjustedFromRange.colCount * columns;
                else
                {
                    var leftColumn = adjustedToRange.col + adjustedToRange.colCount;
                    toColumn = leftColumn - columns * adjustedFromRange.colCount - lastCopyColumns
                }
                rowCount = adjustedFromRange.rowCount;
                columnCount = lastCopyColumns;
                sheet.copyTo(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount,copyOption)
            }
        }
    };
    DragFillUndoAction.prototype.saveState = function()
    {
        if(this._dragFillExtent.AutoFillType === AutoFillType.ClearValues)
            this.saveDragClearState();
        else
            this.saveDragFillState()
    };
    DragFillUndoAction.prototype.saveDragClearState = function()
    {
        this._clearValueUndoAction.saveState()
    };
    DragFillUndoAction.prototype.saveDragFillState = function()
    {
        this._savedFilledViewportCells = this.saveRangeStates(this._dragFillExtent.fillRange);
        this._savedStartViewportCells = this.saveRangeStates(this._dragFillExtent.startRange)
    };
    DragFillUndoAction.prototype.saveRangeStates = function(range)
    {
        var savedRange = this.adjustRange(range);
        var savedCellsInfo = new CopyMoveCellsInfo(savedRange.rowCount,savedRange.colCount);
        CopyMoveHelper.saveViewportInfo(this._workSheet,savedCellsInfo,savedRange.row,savedRange.col,UI.CopyToOption.All);
        return savedCellsInfo
    };
    DragFillUndoAction.prototype.undo = function(arg)
    {
        var sheet = this._workSheet;
        var result = false;
        try
        {
            result = this._undo(sheet)
        }
        finally
        {
            this._workSheet.resumeCalcService();
            this._resumeInvalidate(sheet)
        }
        return result
    };
    DragFillUndoAction.prototype._undo = function(sheet)
    {
        var result;
        var oldSelections = sheet.getSelections() ? sheet.getSelections().toArray() : null;
        var filledRangeCellValues = null;
        var fillRange = this._dragFillExtent.fillRange;
        if(this._savedFilledViewportCells && this._savedFilledViewportCells.isValueSaved())
            filledRangeCellValues = CopyMoveHelper.getValues(this._workSheet,fillRange.row,fillRange.col,fillRange.rowCount,fillRange.colCount);
        if(this._dragFillExtent.autoFillType === AutoFillType.ClearValues)
            result = this.undoDragClear(sheet);
        else
            result = this.undoDragFill(sheet);
        if(sheet._skipCloseDragFillSmartTag !== true)
            sheet._closeDragFillPopup();
        if(filledRangeCellValues)
            CopyMoveHelper.raiseRangeDataChanged(sheet,fillRange.row,fillRange.col,fillRange.rowCount,fillRange.colCount,filledRangeCellValues);
        var newSelections = sheet.getSelections() ? sheet.getSelections().toArray() : null;
        if(sheet._raiseSelectionChanging(oldSelections,newSelections))
            sheet._raiseSelectionChanged();
        sheet.repaint();
        return result
    };
    DragFillUndoAction.prototype.undoDragClear = function(sheet)
    {
        var result = this._clearValueUndoAction.undo(sheet);
        sheet._setActiveCellImp(Math.max(sheet._getFirstVisualRow(),this._dragFillExtent.startRange.row),Math.max(sheet._getFirstVisualColumn(),this._dragFillExtent.startRange.col),sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
        sheet._clearSelectionImp();
        sheet.addSelection(this._dragFillExtent.startRange.row,this._dragFillExtent.startRange.col,this._dragFillExtent.startRange.rowCount,this._dragFillExtent.startRange.colCount);
        return result
    };
    DragFillUndoAction.prototype.undoDragFill = function(sheet)
    {
        this._suspendInvalidate(sheet);
        sheet.suspendCalcService();
        try
        {
            this.undoRangeStates(this._savedFilledViewportCells,this._dragFillExtent.fillRange);
            this.undoRangeStates(this._savedStartViewportCells,this._dragFillExtent.startRange);
            sheet._setActiveCellImp(Math.max(sheet._getFirstVisualRow(),this._dragFillExtent.startRange.row),Math.max(sheet._getFirstVisualColumn(),this._dragFillExtent.startRange.col),sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
            sheet._clearSelectionImp();
            sheet.addSelection(this._dragFillExtent.startRange.row,this._dragFillExtent.startRange.col,this._dragFillExtent.startRange.rowCount,this._dragFillExtent.startRange.colCount)
        }
        finally
        {
            sheet.resumeCalcService();
            this._resumeInvalidate(sheet)
        }
        sheet.invalidateLayout();
        return true
    };
    DragFillUndoAction.prototype.undoRangeStates = function(savedInfo, range)
    {
        var savedRange = this.adjustRange(range);
        CopyMoveHelper.undoCellsInfo(this._workSheet,savedInfo,savedRange.row,savedRange.col,UI.SheetArea.viewport)
    };
    DragFillUndoAction.prototype.initWholeFilledRange = function()
    {
        var row = 0,
            rowCount = 0,
            column = 0,
            columnCount = 0;
        var direction = this._dragFillExtent.fillDirection;
        var startRange = this._dragFillExtent.startRange;
        var fillRange = this._dragFillExtent.fillRange;
        if(direction === FillDirection.Left || direction === FillDirection.Right)
        {
            row = startRange.row;
            rowCount = startRange.rowCount;
            column = direction === FillDirection.Left ? fillRange.col : startRange.col;
            columnCount = startRange.colCount + fillRange.colCount
        }
        else
        {
            row = direction === FillDirection.Up ? fillRange.row : startRange.row;
            rowCount = startRange.rowCount + fillRange.rowCount;
            column = startRange.col;
            columnCount = startRange.colCount
        }
        this._wholeFillRange = new UI.Range(row,column,rowCount,columnCount)
    };
    ClipboardPasteUndoAction.prototype.execute = function(sender)
    {
        if(this._cachedActions)
        {
            var sheetView = this._sheet;
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var action = this._cachedActions[i];
                if(!sheetView)
                    action.execute(sender);
                else
                {
                    var cancel = sheetView._raiseClipboardPasting(action.pasteRange(),action.pasteOption());
                    if(!cancel)
                    {
                        action.execute(sender);
                        sheetView._raiseClipboardPasted(action.pasteRange(),action.pasteOption())
                    }
                }
            }
            this.refreshSelection(sender);
            this.refreshUI(sender)
        }
    };
    ClipboardPasteUndoAction.prototype.refreshSelection = function(sender)
    {
        var sheetView = this._sheet;
        if(sheetView)
            if(this._cachedActions)
            {
                var oldSelection = sheetView.getSelections().toArray();
                sheetView._clearSelectionImp();
                if(this._cachedActions.length > 1)
                    for(var i = 0; i < this._cachedActions.length; i++)
                    {
                        var action = this._cachedActions[i];
                        var range = action.pasteRange();
                        sheetView.addSelection(range.row,range.col,range.rowCount,range.colCount)
                    }
                else if(this._cachedActions.length > 0)
                {
                    var toRange = this._cachedActions[0].pasteRange();
                    sheetView.addSelection(toRange.row,toRange.col,toRange.rowCount,toRange.colCount);
                    if(!toRange.contains(sheetView._activeRowIndex,sheetView._activeColIndex))
                        sheetView._setActiveCellImp(Math.max(sheetView._getFirstVisualRow(),toRange.row),Math.max(sheetView._getFirstVisualColumn(),toRange.col),sheetView.activeRowViewportIndex,sheetView.activeColViewportIndex)
                }
                if(sheetView._raiseSelectionChanging(oldSelection,sheetView.getSelections().toArray()))
                    sheetView._raiseSelectionChanged()
            }
    };
    ClipboardPasteUndoAction.prototype.refreshUI = function(sender)
    {
        var sheetView = this._sheet;
        if(sheetView)
        {
            sheetView.invalidateLayout();
            sheetView.repaint()
        }
    };
    ClipboardPasteUndoAction.prototype.canExecute = function(sender)
    {
        if(this._cachedActions)
        {
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var action = this._cachedActions[i];
                if(!action.canExecute(sender))
                    return false
            }
            return true
        }
        return false
    };
    ClipboardPasteUndoAction.prototype.canUndo = function()
    {
        if(this._cachedActions)
        {
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var action = this._cachedActions[i];
                if(!action.canUndo())
                    return false
            }
            return true
        }
        return false
    };
    ClipboardPasteUndoAction.prototype.saveState = function()
    {
        if(this._cachedActions)
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var action = this._cachedActions[i];
                action.saveState()
            }
    };
    ClipboardPasteUndoAction.prototype.undo = function(sender)
    {
        if(this._cachedActions)
        {
            var ret = true;
            for(var i = 0; i < this._cachedActions.length; i++)
            {
                var action = this._cachedActions[i];
                ret &= action.undo(sender)
            }
            this.refreshUI(sender);
            return ret
        }
        return false
    };
    ClipboardPasteRangeUndoAction.prototype.canUndo = function()
    {
        return true
    };
    ClipboardPasteRangeUndoAction.prototype.canExecute = function(sender)
    {
        return true
    };
    ClipboardPasteRangeUndoAction.prototype.saveState = function()
    {
        this.initSaveState();
        var isCutting = this._pasteExtent.isCutting;
        var option = ClipboardPasteRangeUndoAction.convertPasteOption(this._pasteOption);
        var fromRange = this._pasteExtent.sourceRange;
        var toRange = this._pasteExtent.targetRange;
        if(this._fromSheet && fromRange && isCutting)
        {
            var fromRow = fromRange.row < 0 ? 0 : fromRange.row;
            var fromColumn = fromRange.col < 0 ? 0 : fromRange.col;
            var fromRowCount = fromRange.row < 0 ? this._fromSheet.getRowCount() : fromRange.rowCount;
            var fromColumnCount = fromRange.col < 0 ? this._fromSheet.getColumnCount() : fromRange.colCount;
            if(fromRange.row < 0 && fromRange.col < 0 && toRange.row < 0 && toRange.col < 0)
                if(this._fromSheet._name !== this._toSheet._name)
                {
                    var fromSheetInfo = new CopyMoveSheetInfo;
                    CopyMoveHelper.saveSheetInfo(this._fromSheet,fromSheetInfo,option);
                    this._savedFromSheetInfo = fromSheetInfo
                }
            if(fromRange.row < 0)
            {
                var fromColumnHeaderCellsInfo = new CopyMoveCellsInfo(this._fromSheet.getRowCount(UI.SheetArea.colHeader),fromColumnCount);
                var fromColumnsInfo = new CopyMoveColumnsInfo(fromColumnCount);
                CopyMoveHelper.saveColumnHeaderInfo(this._fromSheet,fromColumnHeaderCellsInfo,fromColumnsInfo,fromColumn,option);
                this._savedFromColumnHeaderCells = fromColumnHeaderCellsInfo;
                this._savedFromColumns = fromColumnsInfo
            }
            if(fromRange.col < 0)
            {
                var fromRowHeaderCellsInfo = new CopyMoveCellsInfo(fromRowCount,this._fromSheet.getColumnCount(UI.SheetArea.rowHeader));
                var fromRowsInfo = new CopyMoveRowsInfo(fromRowCount);
                CopyMoveHelper.saveRowHeaderInfo(this._fromSheet,fromRowHeaderCellsInfo,fromRowsInfo,fromRow,option);
                this._savedFromRowHeaderCells = fromRowHeaderCellsInfo;
                this._savedFromRows = fromRowsInfo
            }
            var fromViewportCellsInfo = new CopyMoveCellsInfo(fromRowCount,fromColumnCount);
            CopyMoveHelper.saveViewportInfo(this._fromSheet,fromViewportCellsInfo,fromRow,fromColumn,option);
            this._savedFromViewportCells = fromViewportCellsInfo
        }
        var toRow = toRange.row < 0 ? 0 : toRange.row;
        var toColumn = toRange.col < 0 ? 0 : toRange.col;
        var toRowCount = toRange.row < 0 ? this._toSheet.getRowCount() : toRange.rowCount;
        var toColumnCount = toRange.col < 0 ? this._toSheet.getColumnCount() : toRange.colCount;
        if(this._fromSheet && fromRange)
        {
            if(fromRange.row < 0 && fromRange.col < 0 && toRange.row < 0 && toRange.col < 0)
                if(this._fromSheet._name !== this._toSheet._name)
                {
                    var toSheetInfo = new CopyMoveSheetInfo;
                    CopyMoveHelper.saveSheetInfo(this._toSheet,toSheetInfo,option);
                    this._savedToSheetInfo = toSheetInfo
                }
            if(fromRange.row < 0)
            {
                var toColumnHeaderCellsInfo = new CopyMoveCellsInfo(this._toSheet.getRowCount(UI.SheetArea.colHeader),toColumnCount);
                var toColumnsInfo = new CopyMoveColumnsInfo(toColumnCount);
                CopyMoveHelper.saveColumnHeaderInfo(this._toSheet,toColumnHeaderCellsInfo,toColumnsInfo,toColumn,option);
                this._savedToColumnHeaderCells = toColumnHeaderCellsInfo;
                this._savedToColumns = toColumnsInfo
            }
            if(fromRange.col < 0)
            {
                var toRowHeaderCellsInfo = new CopyMoveCellsInfo(toRowCount,this._toSheet.getColumnCount(UI.SheetArea.rowHeader));
                var toRowsInfo = new CopyMoveRowsInfo(toRowCount);
                CopyMoveHelper.saveRowHeaderInfo(this._toSheet,toRowHeaderCellsInfo,toRowsInfo,toRow,option);
                this._savedToRowHeaderCells = toRowHeaderCellsInfo;
                this._savedToRows = toRowsInfo
            }
        }
        var toViewportCellsInfo = new CopyMoveCellsInfo(toRowCount,toColumnCount);
        CopyMoveHelper.saveViewportInfo(this._toSheet,toViewportCellsInfo,toRow,toColumn,option);
        this._savedToViewportCells = toViewportCellsInfo
    };
    ClipboardPasteRangeUndoAction.prototype.initSaveState = function()
    {
        this._savedFromSheetInfo = null;
        this._savedFromColumnHeaderCells = null;
        this._savedFromColumns = null;
        this._savedFromViewportCells = null;
        this._savedFromRowHeaderCells = null;
        this._savedFromRows = null;
        this._savedToSheetInfo = null;
        this._savedToColumnHeaderCells = null;
        this._savedToColumns = null;
        this._savedToViewportCells = null;
        this._savedToRowHeaderCells = null;
        this._savedToRows = null
    };
    ClipboardPasteRangeUndoAction.prototype.pasteOption = function()
    {
        return this._pasteOption
    };
    ClipboardPasteRangeUndoAction.prototype.pasteRange = function()
    {
        return this._pasteExtent.targetRange
    };
    ClipboardPasteRangeUndoAction.prototype.execute = function(sender)
    {
        var fromRange = this._pasteExtent.sourceRange;
        var toRange = this._pasteExtent.targetRange;
        if(this._fromSheet && fromRange && !this._fromSheet._isValidRange(fromRange.row,fromRange.col,fromRange.rowCount,fromRange.colCount,this._fromSheet.getRowCount(),this._fromSheet.getColumnCount()))
            return;
        if(!this._toSheet || !toRange)
            return;
        if(!this._toSheet._isValidRange(toRange.row,toRange.col,toRange.rowCount,toRange.colCount,this._toSheet.getRowCount(),this._toSheet.getColumnCount()))
            return;
        this.saveState();
        this._suspendInvalidate(sender);
        try
        {
            this._toSheet._clipboardPaste(this._fromSheet,fromRange,this._toSheet,toRange,this._pasteExtent.isCutting,this._pasteExtent.clipboardText,this._pasteOption);
            var sheet = this._sheet;
            if(sheet)
            {
                if(this._pasteExtent.isCutting && this._savedFromViewportCells && this._savedFromViewportCells.isValueSaved() && this._fromSheet)
                    CopyMoveHelper.raiseRangeDataChanged(this._fromSheet,fromRange.row,fromRange.col,fromRange.rowCount,fromRange.colCount,this._savedFromViewportCells.getValues());
                if(this._savedToViewportCells && this._savedToViewportCells.isValueSaved() && this._toSheet)
                    CopyMoveHelper.raiseRangeDataChanged(this._toSheet,toRange.row,toRange.col,toRange.rowCount,toRange.colCount,this._savedToViewportCells.getValues())
            }
        }
        finally
        {
            this._resumeInvalidate(sender)
        }
    };
    ClipboardPasteRangeUndoAction.prototype.undo = function(sender)
    {
        var fromRange = this._pasteExtent.sourceRange;
        var toRange = this._pasteExtent.targetRange;
        if(!this._toSheet || !toRange)
            return false;
        if(!this._toSheet._isValidRange(toRange.row,toRange.col,toRange.rowCount,toRange.colCount,this._toSheet.getRowCount(),this._toSheet.getColumnCount()))
            return false;
        if(this._fromSheet && fromRange)
        {
            if(!this._fromSheet._isValidRange(fromRange.row,fromRange.col,fromRange.rowCount,fromRange.colCount,this._fromSheet.getRowCount(),this._fromSheet.getColumnCount()))
                return false;
            if(this._fromSheet && this._fromSheet._name === this._toSheet._name && this._toSheet.parent && !this._toSheet.parent.sheets.contains(this._fromSheet))
                return false
        }
        this._suspendInvalidate(sender);
        var ret = false;
        try
        {
            var oldToValues = null;
            var oldFromValues = null;
            var toRow = toRange.row < 0 ? 0 : toRange.row;
            var toColumn = toRange.col < 0 ? 0 : toRange.col;
            var toRowCount = toRange.row < 0 ? this._toSheet.getRowCount() : toRange.rowCount;
            var toColumnCount = toRange.col < 0 ? this._toSheet.getColumnCount() : toRange.colCount;
            if(this._savedToSheetInfo)
            {
                CopyMoveHelper.undoSheetInfo(this._toSheet,this._savedToSheetInfo);
                ret = true
            }
            if(this._savedToViewportCells && this._savedToViewportCells.isValueSaved())
                oldToValues = CopyMoveHelper.getValues(this._toSheet,toRow,toColumn,toRowCount,toColumnCount);
            if(this._savedToColumnHeaderCells)
            {
                CopyMoveHelper.undoCellsInfo(this._toSheet,this._savedToColumnHeaderCells,0,toColumn,UI.SheetArea.colHeader);
                ret = true
            }
            if(this._savedToColumns)
            {
                CopyMoveHelper.undoColumnsInfo(this._toSheet,this._savedToColumns,toColumn);
                ret = true
            }
            if(this._savedToViewportCells)
            {
                CopyMoveHelper.undoCellsInfo(this._toSheet,this._savedToViewportCells,toRow,toColumn,UI.SheetArea.viewport);
                ret = true
            }
            if(this._savedToRowHeaderCells)
            {
                CopyMoveHelper.undoCellsInfo(this._toSheet,this._savedToRowHeaderCells,toRow,0,UI.SheetArea.rowHeader);
                ret = true
            }
            if(this._savedToRows)
            {
                CopyMoveHelper.undoRowsInfo(this._toSheet,this._savedToRows,toRow);
                ret = true
            }
            var fromRow = 0;
            var fromColumn = 0;
            var fromRowCount = 0;
            var fromColumnCount = 0;
            if(this._fromSheet && fromRange)
            {
                fromRow = fromRange.row < 0 ? 0 : fromRange.row;
                fromColumn = fromRange.col < 0 ? 0 : fromRange.col;
                fromRowCount = fromRange.row < 0 ? this._fromSheet.getRowCount() : fromRange.rowCount;
                fromColumnCount = fromRange.col < 0 ? this._fromSheet.getColumnCount() : fromRange.colCount;
                if(this._savedFromViewportCells && this._savedFromViewportCells.isValueSaved())
                    oldFromValues = CopyMoveHelper.getValues(this._fromSheet,fromRow,fromColumn,fromRowCount,fromColumnCount);
                if(this._savedFromColumnHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._fromSheet,this._savedFromColumnHeaderCells,0,fromColumn,UI.SheetArea.colHeader);
                    ret = true
                }
                if(this._savedFromColumns)
                {
                    CopyMoveHelper.undoColumnsInfo(this._fromSheet,this._savedFromColumns,fromColumn);
                    ret = true
                }
                if(this._savedFromViewportCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._fromSheet,this._savedFromViewportCells,fromRow,fromColumn,UI.SheetArea.viewport);
                    ret = true
                }
                if(this._savedFromRowHeaderCells)
                {
                    CopyMoveHelper.undoCellsInfo(this._fromSheet,this._savedFromRowHeaderCells,fromRow,0,UI.SheetArea.rowHeader);
                    ret = true
                }
                if(this._savedFromRows)
                {
                    CopyMoveHelper.undoRowsInfo(this._fromSheet,this._savedFromRows,fromRow);
                    ret = true
                }
            }
            var sheet = sender;
            if(ret && sheet)
            {
                if(oldToValues && this._toSheet)
                    CopyMoveHelper.raiseRangeDataChanged(this._toSheet,toRow,toColumn,toRowCount,toColumnCount,oldToValues);
                if(oldFromValues && this._fromSheet)
                    CopyMoveHelper.raiseRangeDataChanged(this._fromSheet,fromRow,fromColumn,fromRowCount,fromColumnCount,oldFromValues)
            }
        }
        finally
        {
            this._resumeInvalidate(sender)
        }
        return ret
    };
    ClipboardPasteRangeUndoAction.convertPasteOption = function(pasteOption)
    {
        var copyOption = 0;
        if(pasteOption === UI.ClipboardPasteOptions.All || pasteOption === UI.ClipboardPasteOptions.Values)
            copyOption |= UI.CopyToOption.Value;
        if(pasteOption === UI.ClipboardPasteOptions.All || pasteOption === UI.ClipboardPasteOptions.Formatting)
            copyOption |= UI.CopyToOption.Style;
        if(pasteOption === UI.ClipboardPasteOptions.All || pasteOption === UI.ClipboardPasteOptions.Formulas)
            copyOption |= UI.CopyToOption.Formula;
        if(pasteOption === UI.ClipboardPasteOptions.All)
        {
            copyOption |= UI.CopyToOption.Span;
            copyOption |= UI.CopyToOption.Sparkline;
            copyOption |= UI.CopyToOption.BindingPath
        }
        return copyOption
    };
    CopyMoveSheetInfo.prototype = {
        saveDefaultStyle: function(style)
        {
            this._defaultStyle = style;
            this._defaultStyleSaved = true
        },
        getDefaultStyle: function()
        {
            return this._defaultStyle
        },
        saveDefaultColumnWidth: function(width)
        {
            this._defaultColumnWidth = width;
            this._defaultColumnWidthSaved = true
        },
        getDefaultColumnWidth: function()
        {
            return this._defaultColumnWidth
        },
        saveDefaultRowHeight: function(height)
        {
            this._defaultRowHeight = height;
            this._defaultRowHeightSaved = true
        },
        getDefaultRowHeight: function()
        {
            return this._defaultRowHeight
        },
        saveColumnHeaderDefaultStyle: function(style)
        {
            this._columnHeaderDefaultStyle = style;
            this._columnHeaderDefaultStyleSaved = true
        },
        getColumnHeaderDefaultStyle: function()
        {
            return this._columnHeaderDefaultStyle
        },
        saveColumnHeaderDefaultRowHeight: function(height)
        {
            this._columnHeaderDefaultRowHeight = height;
            this._columnHeaderDefaultRowHeightSaved = true
        },
        getColumnHeaderDefaultRowHeight: function()
        {
            return this._columnHeaderDefaultRowHeight
        },
        saveRowHeaderDefaultStyle: function(style)
        {
            this._rowHeaderDefaultStyle = style;
            this._rowHeaderDefaultStyleSaved = true
        },
        getRowHeaderDefaultStyle: function()
        {
            return this._rowHeaderDefaultStyle
        },
        saveRowHeaderDefaultColumnWidth: function(width)
        {
            this._rowHeaderDefaultColumnWidth = width;
            this._rowHeaderDefaultColumnWidthSaved = true
        },
        getRowHeaderDefaultColumnWidth: function()
        {
            return this._rowHeaderDefaultColumnWidth
        },
        isDefaultStyleSaved: function()
        {
            return this._defaultStyleSaved
        },
        isDefaultColumnWidthSaved: function()
        {
            return this._defaultColumnWidthSaved
        },
        isDefaultRowHeightSaved: function()
        {
            return this._defaultRowHeightSaved
        },
        isColumnHeaderDefaultStyleSaved: function()
        {
            return this._columnHeaderDefaultStyleSaved
        },
        isColumnHeaderDefaultRowHeightSaved: function()
        {
            return this._columnHeaderDefaultRowHeightSaved
        },
        isRowHeaderDefaultStyleSaved: function()
        {
            return this._rowHeaderDefaultStyleSaved
        },
        isRowHeaderDefaultColumnWidthSaved: function()
        {
            return this._rowHeaderDefaultColumnWidthSaved
        }
    };
    UI.CopyMoveCellsInfo = CopyMoveCellsInfo;
    UI.CopyMoveHelper = CopyMoveHelper;
    UI.UndoRedo = {
        DragDropExtent: DragDropExtent,
        GroupExtent: GroupExtent,
        ActionBase: ActionBase,
        ColumnResizeUndoAction: ColumnResizeUndoAction,
        RowResizeUndoAction: RowResizeUndoAction,
        ColumnAutoFitUndoAction: ColumnAutoFitUndoAction,
        RowAutoFitUndoAction: RowAutoFitUndoAction,
        ColumnGroupUndoAction: ColumnGroupUndoAction,
        ColumnUngroupUndoAction: ColumnUngroupUndoAction,
        RowGroupUndoAction: RowGroupUndoAction,
        RowUngroupUndoAction: RowUngroupUndoAction,
        ColumnGroupExpandUndoAction: ColumnGroupExpandUndoAction,
        RowGroupExpandUndoAction: RowGroupExpandUndoAction,
        ColumnGroupHeaderExpandUndoAction: ColumnGroupHeaderExpandUndoAction,
        RowGroupHeaderExpandUndoAction: RowGroupHeaderExpandUndoAction,
        DragDropUndoAction: DragDropUndoAction,
        CellEditUndoAction: CellEditUndoAction,
        SheetRenameUndoAction: SheetRenameUndoAction,
        ZoomUndoAction: ZoomUndoAction,
        ClearValueUndoAction: ClearValueUndoAction,
        DragFillUndoAction: DragFillUndoAction,
        ClipboardPasteUndoAction: ClipboardPasteUndoAction,
        ClipboardPasteRangeUndoAction: ClipboardPasteRangeUndoAction
    }
})(window);
(function(window)
{
    "use strict";;
    var GrapeCity = window.GrapeCity;
    if(typeof GrapeCity === "undefined")
        GrapeCity = window.GrapeCity = {};
    if(typeof GrapeCity.UI === "undefined")
        GrapeCity.UI = {};
    var LineStyle = GrapeCity.UI.LineStyle;
    var ComposedLineSide = {
            first: 1,
            second: 2
        };
    var Line = function(){};
    GrapeCity.UI.Line = Line;
    Line.prototype = {
        adjust: function(opt)
        {
            if(opt.orientation === 0)
            {
                if(opt.offsetEnd)
                    this._x2 += opt.offsetEnd;
                if(opt.offsetStart)
                    this._x1 += opt.offsetStart
            }
            else if(opt.orientation === 1)
            {
                if(opt.offsetEnd)
                    this._y2 += opt.offsetEnd;
                if(opt.offsetStart)
                    this._y1 += opt.offsetStart
            }
        },
        paint: function(ctx)
        {
            var needStroke = false;
            if(ctx.lineWidth !== this._lineWidth)
                needStroke = true;
            var color = this._color ? this._color : "#9EB6CE";
            if(ctx.strokeStyle !== color)
                needStroke = true;
            if(needStroke)
            {
                ctx.closePath();
                ctx.stroke();
                ctx.beginPath();
                ctx.lineWidth = this._lineWidth;
                ctx.strokeStyle = color
            }
            this.paintLine(ctx)
        },
        paintLine: function(ctx)
        {
            ctx.moveTo(this._x1,this._y1);
            ctx.lineTo(this._x2,this._y2)
        }
    };
    var SolidLine = function(x1, y1, x2, y2, color, width)
        {
            var isSnapToPixel = width % 2;
            if(!isSnapToPixel)
                if(x1 !== x2)
                {
                    y1 -= 0.5;
                    y2 -= 0.5
                }
                else
                {
                    x1 -= 0.5;
                    x2 -= 0.5
                }
            this._x1 = x1;
            this._y1 = y1;
            this._x2 = x2;
            this._y2 = y2;
            this._color = color;
            this._lineWidth = width
        };
    SolidLine.prototype = new Line;
    var DashedLine = function(x1, y1, x2, y2, color, width, pattern)
        {
            var isSnapToPixel = width % 2;
            if(!isSnapToPixel)
                if(x1 !== x2)
                {
                    y1 -= 0.5;
                    y2 -= 0.5
                }
                else
                {
                    x1 -= 0.5;
                    x2 -= 0.5
                }
            this._x1 = x1;
            this._y1 = y1;
            this._x2 = x2;
            this._y2 = y2;
            this._color = color;
            this._lineWidth = width;
            this._pattern = pattern
        };
    DashedLine.prototype = new Line;
    DashedLine.prototype.paintLine = function(ctx)
    {
        DashedLine.render(ctx,this._x1,this._y1,this._x2,this._y2,this._pattern)
    };
    DashedLine.render = function(ctx, x0, y0, x1, y1, pattern)
    {
        var length = Math.sqrt(Math.pow(x1 - x0,2) + Math.pow(y1 - y0,2));
        var vector = {
                x: (x1 - x0) / length,
                y: (y1 - y0) / length
            };
        var dist = 0,
            i = 0;
        pattern = pattern && pattern.length ? pattern : [4,4];
        while(dist < length)
        {
            var dashLength = Math.min(pattern[i++ % pattern.length],length - dist);
            var draw = i % 2;
            dist += dashLength;
            if(draw)
                ctx.moveTo(x0,y0);
            x0 += dashLength * vector.x;
            y0 += dashLength * vector.y;
            if(draw)
                ctx.lineTo(x0,y0)
        }
    };
    var SlantedLine = function(x1, y1, x2, y2, color, horizental, pattern1, pattern2)
        {
            if(horizental)
            {
                x1 -= 1;
                x2 -= 1
            }
            else
            {
                y1 -= 1;
                y2 -= 1
            }
            this._x1 = x1;
            this._y1 = y1;
            this._x2 = x2;
            this._y2 = y2;
            this._color = color;
            this._horizental = horizental;
            this._lineWidth = 1;
            this._pattern1 = pattern1;
            this._pattern2 = pattern2
        };
    SlantedLine.prototype = new Line;
    SlantedLine.prototype.paintLine = function(ctx)
    {
        var xOff = this._horizental ? 0 : 1;
        var yOff = this._horizental ? 1 : 0;
        DashedLine.render(ctx,this._x1 - xOff,this._y1 - yOff,this._x2 - xOff,this._y2 - yOff,this._pattern1);
        DashedLine.render(ctx,this._x1,this._y1,this._x2,this._y2,this._pattern2)
    };
    var DoubleLine = function(x1, y1, x2, y2, color, horizental)
        {
            var xOff = horizental ? 0 : 1;
            var yOff = horizental ? 1 : 0;
            this._line1 = new SolidLine(x1 - xOff,y1 - yOff,x2 - xOff,y2 - yOff,color,1);
            this._line2 = new SolidLine(x1 + xOff,y1 + yOff,x2 + xOff,y2 + yOff,color,1);
            this._color = color;
            this._horizental = horizental;
            this._lineWidth = 1
        };
    DoubleLine.prototype = new Line;
    DoubleLine.prototype.paintLine = function(ctx)
    {
        this._line1.paintLine(ctx);
        this._line2.paintLine(ctx)
    };
    DoubleLine.prototype.adjust = function(opt)
    {
        if(!opt.lineSide)
        {
            this._line1.adjust(opt);
            this._line2.adjust(opt)
        }
        else if(opt.lineSide === ComposedLineSide.first)
            this._line1.adjust(opt);
        else if(opt.lineSide === ComposedLineSide.second)
            this._line2.adjust(opt)
    };
    Line.Create = function(x1, y1, x2, y2, color, lineStyle)
    {
        if(lineStyle === undefined || lineStyle === null)
            lineStyle = LineStyle.thin;
        switch(lineStyle)
        {
            case LineStyle.thin:
                return new SolidLine(x1,y1,x2,y2,color,1);
            case LineStyle.medium:
                return new SolidLine(x1,y1,x2,y2,color,2);
            case LineStyle.thick:
                return new SolidLine(x1,y1,x2,y2,color,3);
            case LineStyle.dashed:
                return new DashedLine(x1,y1,x2,y2,color,1,[3,1]);
            case LineStyle.dashDot:
                return new DashedLine(x1,y1,x2,y2,color,1,[8,2,2,2]);
            case LineStyle.dotted:
                return new DashedLine(x1,y1,x2,y2,color,1,[2,2]);
            case LineStyle.dashDotDot:
                return new DashedLine(x1,y1,x2,y2,color,1,[9,3,3,3,3,3]);
            case LineStyle.slantedDashDot:
                return new SlantedLine(x1,y1,x2,y2,color,x1 !== x2,[11,1,5,1],[10,2,4,2]);
            case LineStyle.mediumDashDot:
                return new DashedLine(x1,y1,x2,y2,color,2,[9,3,3,3]);
            case LineStyle.mediumDashDotDot:
                return new DashedLine(x1,y1,x2,y2,color,2,[9,3,3,3,3,3]);
            case LineStyle.mediumDashed:
                return new DashedLine(x1,y1,x2,y2,color,2,[9,3]);
            case LineStyle.hair:
                return new DashedLine(x1,y1,x2,y2,color,1,[1]);
            case LineStyle.double:
                return new DoubleLine(x1,y1,x2,y2,color,x1 !== x2)
        }
        return null
    };
    var compareColor = function(color1, color2)
        {
            return 0
        };
    var compareLineStyle = function(line1, line2)
        {
            if(!line1)
            {
                if(!line2)
                    return 0;
                return-1
            }
            else if(!line2)
                return 1;
            var lw1 = GrapeCity.UI.LineBorder.prototype._weight(line1);
            var lw2 = GrapeCity.UI.LineBorder.prototype._weight(line2);
            if(lw1 === lw2)
                return compareColor(line1.color,line2.color);
            else
                return lw1 - lw2
        };
    var getDrawingThickness = function(lineItem)
        {
            if(lineItem)
            {
                if(lineItem.isGridLine)
                    return 1;
                if(lineItem.style)
                    return GrapeCity.UI.LineBorder.prototype.width(lineItem.style)
            }
            return 0
        };
    var isDoubleLine = function(line)
        {
            return line && line.style === LineStyle.double
        };
    var isSlantedLine = function(line)
        {
            return line && line.style === LineStyle.slantedDashDot
        };
    var LayoutEngine = function()
        {
            var LineType = {
                    previous: -1,
                    next: 1
                };
            var getMaxLine = function(line1, line2)
                {
                    if(!line1)
                    {
                        if(!line2)
                            return null;
                        return line2
                    }
                    else if(!line2)
                        return line1;
                    return compareLineStyle(line1.style,line2.style) > 0 ? line1 : line2
                };
            var adjustLine = function(lineItem, opt)
                {
                    if(lineItem && lineItem.line)
                        lineItem.line.adjust(opt)
                };
            var compareLine = function(lineItem1, lineItem2)
                {
                    if(lineItem1 === null || lineItem1 === undefined)
                        if(lineItem2 === null || lineItem2 === undefined)
                            return 0;
                        else
                            return-1;
                    else if(lineItem2 === null || lineItem2 === undefined)
                        return 1;
                    else
                    {
                        if(lineItem1.isGridLine)
                            if(lineItem2.isGridLine)
                                return 0;
                            else
                                return-1;
                        else if(lineItem2.isGridLine)
                            return 1;
                        return compareLineStyle(lineItem1.style,lineItem2.style)
                    }
                };
            var isDoubleLineItem = function(lineItem)
                {
                    return lineItem && isDoubleLine(lineItem.style)
                };
            var isAllowExtend = function(current, line, break1, break2)
                {
                    if(!isDoubleLineItem(current))
                    {
                        var doubleCnt = 0;
                        doubleCnt += isDoubleLineItem(line) ? 1 : 0;
                        doubleCnt += isDoubleLineItem(break1) ? 1 : 0;
                        doubleCnt += isDoubleLineItem(break2) ? 1 : 0;
                        return doubleCnt < 2
                    }
                    return true
                };
            var layout4CrossRoad = function(current, line, break1, break2, lineType, vertical)
                {
                    var opt = {
                            orientation: vertical ? 1 : 0,
                            offsetStart: 0,
                            offsetEnd: 0
                        };
                    var diff1 = compareLine(current,break1),
                        diff2 = compareLine(current,break2);
                    if(diff1 >= 0 && diff2 >= 0)
                    {
                        if(diff1 === 0 && diff2 === 0)
                        {
                            if(lineType !== LineType.previous)
                                if(lineType === LineType.next)
                                    opt.offsetEnd -= lineType
                        }
                        else if(lineType === LineType.previous)
                            opt.offsetStart -= lineType;
                        else if(lineType === lineType.next)
                            opt.offsetEnd -= 2 * lineType
                    }
                    else if(diff2 >= 0)
                    {
                        opt.lineSide = ComposedLineSide.second;
                        opt.offsetStart += lineType
                    }
                    else if(diff1 >= 0)
                    {
                        opt.lineSide = ComposedLineSide.first;
                        opt.offsetStart += lineType
                    }
                    adjustLine(current,opt)
                };
            var layout4TurnRoad = function(current, prevLine, nextLine, break1, break2, type, lineType, vertical, swap)
                {
                    var optFirst = {
                            orientation: vertical ? 1 : 0,
                            lineSide: swap ? ComposedLineSide.second : ComposedLineSide.first,
                            offsetStart: 0,
                            offsetEnd: 0
                        };
                    var optSecond = {
                            orientation: vertical ? 1 : 0,
                            lineSide: swap ? ComposedLineSide.first : ComposedLineSide.second,
                            offsetStart: 0,
                            offsetEnd: 0
                        };
                    var breakLine = type === 1 ? break1 : break2;
                    var neighborLine = lineType === LineType.next ? nextLine : prevLine;
                    var hasNeighborDoubleLine = isDoubleLineItem(neighborLine);
                    if(!hasNeighborDoubleLine)
                    {
                        if(compareLine(current,breakLine) >= 0)
                        {
                            if(lineType === LineType.previous)
                                optSecond.offsetStart -= 2 * lineType;
                            else if(lineType === LineType.next)
                                optSecond.offsetEnd -= 2 * lineType
                        }
                        else if(lineType === LineType.previous)
                            optFirst.offsetStart += 2 * lineType;
                        else if(lineType === LineType.next)
                            optFirst.offsetEnd += 2 * lineType
                    }
                    else
                    {
                        var diff = compareLine(current,breakLine);
                        if(diff === 0)
                        {
                            var diff1 = compareLine(current,neighborLine);
                            if(diff1 === 0)
                            {
                                if(lineType === LineType.next)
                                    optSecond.offsetEnd -= lineType
                            }
                            else if(diff1 > 0)
                                if(lineType === LineType.previous)
                                    optSecond.offsetStart -= 2 * lineType;
                                else if(lineType === LineType.next)
                                    optSecond.offsetEnd -= 2 * lineType
                        }
                        else if(diff > 0)
                        {
                            var diff2 = compareLine(current,neighborLine);
                            if(diff2 === 0)
                            {
                                if(lineType === LineType.next)
                                    optSecond.offsetEnd -= lineType
                            }
                            else if(diff2 > 0)
                                if(lineType === LineType.previous)
                                    optSecond.offsetStart -= 2 * lineType;
                                else if(lineType === LineType.next)
                                    optSecond.offsetEnd -= 2 * lineType
                        }
                        else
                        {
                            var diff3 = compareLine(current,neighborLine);
                            if(diff3 === 0)
                            {
                                if(lineType === LineType.previous)
                                    optFirst.offsetStart += 2 * lineType;
                                else if(lineType === LineType.next)
                                    optFirst.offsetEnd += 2 * lineType
                            }
                            else if(diff3 > 0)
                                if(lineType === LineType.previous)
                                    optFirst.offsetStart -= 3 * lineType;
                                else if(lineType === LineType.next)
                                    optFirst.offsetEnd -= 3 * lineType
                        }
                    }
                    var otherType = type === 1 ? 2 : 1;
                    var otherBreakLine = otherType === 1 ? break1 : break2;
                    var needMakeupCorner = false;
                    var thickness = 0;
                    if(!needMakeupCorner && isDoubleLineItem(otherBreakLine) && compareLine(otherBreakLine,current) > 0)
                    {
                        needMakeupCorner = true;
                        var drawThickness = getDrawingThickness(otherBreakLine);
                        if(compareLine(otherBreakLine,breakLine) > 0)
                        {
                            if(drawThickness > 0)
                                if(lineType === LineType.next && isDoubleLineItem(nextLine))
                                    thickness = drawThickness >= 2 ? 2 : 1;
                                else if(lineType === LineType.previous && isDoubleLineItem(prevLine))
                                    thickness = drawThickness >= 3 ? 2 : 1;
                                else
                                    thickness = drawThickness === 3 ? 3 : 2
                        }
                        else
                            thickness = drawThickness === 3 ? 3 : 2
                    }
                    if(!needMakeupCorner && !isDoubleLineItem(neighborLine) && (neighborLine && !neighborLine.isGridLine || otherBreakLine && !otherBreakLine.isGridLine))
                    {
                        needMakeupCorner = true;
                        if(lineType === LineType.previous)
                            thickness = 2;
                        else
                            thickness = 1
                    }
                    if(needMakeupCorner)
                        if(lineType === LineType.previous)
                        {
                            optFirst.offsetStart += lineType * thickness;
                            optSecond.offsetStart += lineType * thickness
                        }
                        else if(lineType === LineType.next)
                        {
                            optFirst.offsetEnd += lineType * thickness;
                            optSecond.offsetEnd += lineType * thickness
                        }
                    if(optFirst.offsetStart || optFirst.offsetEnd)
                        adjustLine(current,optFirst);
                    if(optSecond.offsetStart || optSecond.offsetEnd)
                        adjustLine(current,optSecond)
                };
            var layout4TRoad = function(current, line, break1, break2, lineType, vertical)
                {
                    if(compareLine(current,break1) >= 0 && compareLine(current,break2) >= 0)
                    {
                        var opt = {
                                orientation: vertical ? 1 : 0,
                                offsetStart: 0,
                                offsetEnd: 0
                            };
                        if(lineType === LineType.previous)
                        {
                            opt.offsetStart -= 2 * lineType;
                            if(isDoubleLineItem(current) && compareLine(line,current) > 0)
                                opt.offsetStart -= 1
                        }
                        else if(lineType === LineType.next)
                        {
                            opt.offsetEnd -= 2 * lineType;
                            if(isDoubleLineItem(current) && compareLine(line,current) > 0)
                                opt.offsetEnd += 1
                        }
                        adjustLine(current,opt)
                    }
                };
            var layout4Connected = function(current, line, break1, break2, lineType, vertical)
                {
                    if(isDoubleLineItem(current))
                    {
                        var breakLine = getMaxLine(break1,break2);
                        if(breakLine && !breakLine.isGridLine)
                        {
                            var drawThickness = getDrawingThickness(breakLine);
                            if(drawThickness > 0)
                            {
                                var opt = {
                                        orientation: vertical ? 1 : 0,
                                        offsetStart: 0,
                                        offsetEnd: 0
                                    };
                                if(lineType === LineType.previous)
                                    opt.offsetStart += drawThickness * lineType;
                                else
                                    opt.offsetEnd += drawThickness * lineType;
                                if(opt.offsetStart || opt.offsetEnd)
                                    adjustLine(current,opt)
                            }
                        }
                    }
                };
            return{
                    calcLayoutHorizontal: function(current, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
                    {
                        var drawThickness;
                        var diff;
                        if(prevLine || prevBreak1 || prevBreak2)
                        {
                            var prevBreak = getMaxLine(prevBreak1,prevBreak2);
                            if(!isAllowExtend(current,prevLine,prevBreak1,prevBreak2))
                                adjustLine(current,{
                                    orientation: 0,
                                    offsetStart: 1
                                });
                            else if((diff = compareLine(prevBreak,current)) > 0)
                            {
                                drawThickness = getDrawingThickness(prevBreak);
                                if(!(isDoubleLineItem(current) && (isDoubleLineItem(prevBreak1) || isDoubleLineItem(prevBreak2) || isDoubleLineItem(prevLine))))
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetStart: 1
                                        })
                            }
                            else if(prevBreak && diff < 0)
                            {
                                if((diff = compareLine(current,prevLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(prevBreak);
                                    if(drawThickness === 3 || drawThickness === 2)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetStart: -2
                                        });
                                    else if(drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetStart: -1
                                        })
                                }
                                else if(diff !== 0)
                                    if(compareLine(prevLine,prevBreak) > 0)
                                    {
                                        drawThickness = getDrawingThickness(prevBreak);
                                        if(drawThickness === 3)
                                            adjustLine(current,{
                                                orientation: 0,
                                                offsetStart: 1
                                            })
                                    }
                            }
                            else if(diff === 0)
                                if(!prevLine || compareLine(current,prevLine) > 0)
                                {
                                    drawThickness = getDrawingThickness(prevBreak);
                                    if(drawThickness === 3 || drawThickness === 2)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetStart: -2
                                        });
                                    else if(drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetStart: -1
                                        })
                                }
                        }
                        if(nextLine || nextBreak1 || nextBreak2)
                        {
                            var nextBreak = getMaxLine(nextBreak1,nextBreak2);
                            if(!isAllowExtend(current,nextLine,nextBreak1,nextBreak2))
                                adjustLine(current,{
                                    orientation: 0,
                                    offsetEnd: -2
                                });
                            else if((diff = compareLine(nextBreak,current)) > 0)
                            {
                                drawThickness = getDrawingThickness(nextBreak);
                                if(!(isDoubleLineItem(current) && (isDoubleLineItem(nextBreak1) || isDoubleLineItem(nextBreak2) || isDoubleLineItem(nextLine))))
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetEnd: -2
                                        });
                                    else if(drawThickness === 2 || drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetEnd: -1
                                        })
                            }
                            else if(diff < 0)
                            {
                                if((diff = compareLine(current,nextLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(nextBreak);
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetEnd: 1
                                        })
                                }
                                else if(diff !== 0)
                                    adjustLine(current,{
                                        orientation: 0,
                                        offsetEnd: -1
                                    })
                            }
                            else if(diff === 0)
                                if((diff = compareLine(current,nextLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(nextBreak);
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 0,
                                            offsetEnd: 1
                                        })
                                }
                                else if(diff !== 0)
                                    adjustLine(current,{
                                        orientation: 0,
                                        offsetEnd: -1
                                    })
                        }
                    },
                    calcLayoutVertical: function(current, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
                    {
                        var drawThickness;
                        var diff;
                        if(prevLine || prevBreak1 || prevBreak2)
                        {
                            var prevBreak = getMaxLine(prevBreak1,prevBreak2);
                            if(!isAllowExtend(current,prevLine,prevBreak1,prevBreak2))
                                adjustLine(current,{
                                    orientation: 1,
                                    offsetStart: 1
                                });
                            else if((diff = compareLine(prevBreak,current)) > 0)
                            {
                                drawThickness = getDrawingThickness(prevBreak);
                                if(!(isDoubleLineItem(current) && (isDoubleLineItem(prevBreak1) || isDoubleLineItem(prevBreak2) || isDoubleLineItem(prevLine))))
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetStart: 1
                                        })
                            }
                            else if(diff < 0)
                            {
                                if((diff = compareLine(current,prevLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(prevBreak);
                                    if(drawThickness === 3 || drawThickness === 2)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetStart: -2
                                        });
                                    else if(drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetStart: -1
                                        })
                                }
                                else if(diff !== 0)
                                    if(compareLine(prevLine,prevBreak) > 0)
                                    {
                                        drawThickness = getDrawingThickness(prevBreak);
                                        if(drawThickness === 3)
                                            adjustLine(current,{
                                                orientation: 1,
                                                offsetStart: 1
                                            })
                                    }
                            }
                            else if(diff === 0)
                                if(compareLine(current,prevLine) > 0)
                                {
                                    drawThickness = getDrawingThickness(prevBreak);
                                    if(drawThickness === 3 || drawThickness === 2)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetStart: -2
                                        });
                                    else if(drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetStart: -1
                                        })
                                }
                        }
                        if(nextLine || nextBreak1 || nextBreak2)
                        {
                            var nextBreak = getMaxLine(nextBreak1,nextBreak2);
                            if(!isAllowExtend(current,nextLine,nextBreak1,nextBreak2))
                                adjustLine(current,{
                                    orientation: 1,
                                    offsetEnd: -2
                                });
                            else if((diff = compareLine(current,nextBreak)) < 0)
                            {
                                drawThickness = getDrawingThickness(nextBreak);
                                if(!(isDoubleLineItem(current) && (isDoubleLineItem(nextBreak1) || isDoubleLineItem(nextBreak2) || isDoubleLineItem(nextLine))))
                                    if(drawThickness === 3 || drawThickness === 2)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetEnd: -2
                                        });
                                    else if(drawThickness === 1)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetEnd: -1
                                        })
                            }
                            else if(nextBreak !== null && diff > 0)
                            {
                                if((diff = compareLine(current,nextLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(nextBreak);
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetEnd: 1
                                        })
                                }
                                else if(diff !== 0)
                                    adjustLine(current,{
                                        orientation: 1,
                                        offsetEnd: -1
                                    })
                            }
                            else if(diff === 0)
                                if((diff = compareLine(current,nextLine)) > 0)
                                {
                                    drawThickness = getDrawingThickness(nextBreak);
                                    if(drawThickness === 3)
                                        adjustLine(current,{
                                            orientation: 1,
                                            offsetEnd: 1
                                        })
                                }
                                else if(diff !== 0)
                                    adjustLine(current,{
                                        orientation: 1,
                                        offsetEnd: -1
                                    })
                        }
                    },
                    calcDoubleLayout: function(current, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2, vertical)
                    {
                        if(vertical)
                            this.calcLayoutVertical(current,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                        else
                            this.calcLayoutHorizontal(current,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                        var break1DoubleLine = isDoubleLineItem(prevBreak1),
                            break2DoubleLine = isDoubleLineItem(prevBreak2),
                            prevDoubleLine = isDoubleLineItem(prevLine);
                        if(break1DoubleLine && break2DoubleLine && prevDoubleLine)
                            layout4CrossRoad(current,prevLine,prevBreak1,prevBreak2,LineType.previous,vertical);
                        else if(break1DoubleLine && !break2DoubleLine)
                            layout4TurnRoad(current,prevLine,nextLine,prevBreak1,prevBreak2,1,LineType.previous,vertical,true);
                        else if(!break1DoubleLine && break2DoubleLine)
                            layout4TurnRoad(current,prevLine,nextLine,prevBreak1,prevBreak2,2,LineType.previous,vertical,false);
                        else if(break1DoubleLine && break2DoubleLine && !prevDoubleLine)
                            layout4TRoad(current,prevLine,prevBreak1,prevBreak2,LineType.previous,vertical);
                        else if(prevDoubleLine)
                            layout4Connected(current,prevLine,prevBreak1,prevBreak2,LineType.previous,vertical);
                        break1DoubleLine = isDoubleLineItem(nextBreak1);
                        break2DoubleLine = isDoubleLineItem(nextBreak2);
                        var nextDoubleLine = isDoubleLineItem(nextLine);
                        if(break1DoubleLine && break2DoubleLine && nextDoubleLine)
                            layout4CrossRoad(current,nextLine,nextBreak1,nextBreak2,LineType.next,vertical);
                        else if(break1DoubleLine && !break2DoubleLine)
                            layout4TurnRoad(current,prevLine,nextLine,nextBreak1,nextBreak2,1,LineType.next,vertical,true);
                        else if(!break1DoubleLine && break2DoubleLine)
                            layout4TurnRoad(current,prevLine,nextLine,nextBreak1,nextBreak2,2,LineType.next,vertical,false);
                        else if(break1DoubleLine && break2DoubleLine && !nextDoubleLine)
                            layout4TRoad(current,nextLine,nextBreak1,nextBreak2,LineType.next,vertical);
                        else if(nextDoubleLine)
                            layout4Connected(current,nextLine,nextBreak1,nextBreak2,LineType.next,vertical)
                    }
                }
        }();
    var DefaultLineLayout = {
            layoutHorizontal: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
            {
                LayoutEngine.calcLayoutHorizontal(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2)
            },
            layoutVertical: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
            {
                LayoutEngine.calcLayoutVertical(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2)
            }
        };
    var DoubleLineLayout = {
            layoutHorizontal: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
            {
                LayoutEngine.calcDoubleLayout(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2,false)
            },
            layoutVertical: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2)
            {
                LayoutEngine.calcDoubleLayout(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2,true)
            }
        };
    var SlantedLineLayout = {
            layoutHorizontal: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2){},
            layoutVertical: function(line, prevLine, prevBreak1, prevBreak2, nextLine, nextBreak1, nextBreak2){}
        };
    GrapeCity.UI._GcBorders = function(sheet, rowViewportIndex, colViewportIndex, sheetArea)
    {
        this._sheet = sheet;
        this._sheetArea = sheetArea;
        this._rowViewportIndex = rowViewportIndex;
        this._colViewportIndex = colViewportIndex
    };
    GrapeCity.UI._GcBorders.prototype = {
        _isInitialized: false,
        _isMerged: false,
        _initialize: function()
        {
            this._spanCells = [];
            this._rowIndecies = [];
            this._colIndecies = [];
            this._overflowedCells = [];
            this._adjustingRanges = [];
            this._hGridLine = [];
            this._vGridLine = [];
            this._hBorders = [];
            this._vBorders = [];
            var leftCol = 0,
                rightCol = 0,
                topRow = 0,
                bottomRow = 0;
            if(this._sheetArea === GrapeCity.UI.SheetArea.viewport)
            {
                leftCol = this._sheet.getViewportLeftColumn(this._colViewportIndex);
                rightCol = this._sheet.getViewportRightColumn(this._colViewportIndex);
                topRow = this._sheet.getViewportTopRow(this._rowViewportIndex);
                bottomRow = this._sheet.getViewportBottomRow(this._rowViewportIndex)
            }
            else if(this._sheetArea === GrapeCity.UI.SheetArea.colHeader)
            {
                leftCol = this._sheet.getViewportLeftColumn(this._colViewportIndex);
                rightCol = this._sheet.getViewportRightColumn(this._colViewportIndex);
                bottomRow = this._sheet.getRowCount(this._sheetArea)
            }
            else if(this._sheetArea === GrapeCity.UI.SheetArea.rowHeader)
            {
                rightCol = this._sheet.getColumnCount(this._sheetArea);
                topRow = this._sheet.getViewportTopRow(this._rowViewportIndex);
                bottomRow = this._sheet.getViewportBottomRow(this._rowViewportIndex)
            }
            for(var r = topRow; r <= bottomRow; r++)
                if(this._sheet.getRowVisible(r,this._sheetArea))
                    this._rowIndecies.push(r);
            for(var c = leftCol; c <= rightCol; c++)
                if(this._sheet.getColumnVisible(c,this._sheetArea))
                    this._colIndecies.push(c);
            this._isInitialized = true
        },
        addCellLines: function(row, col, x, y, width, height, style, spanCellLayout, cellOverflowLayout)
        {
            if(!this._isInitialized)
                this._initialize();
            if(cellOverflowLayout)
            {
                var overflowedCell = {
                        row: row,
                        startCol: cellOverflowLayout.startCol,
                        endCol: cellOverflowLayout.endCol
                    };
                if(!this._overflowedCells.contains(overflowedCell))
                    this._overflowedCells.push(overflowedCell)
            }
            if(spanCellLayout)
                this._spanCells.push(spanCellLayout);
            else
            {
                var borderLeft,
                    borderTop,
                    borderRight,
                    borderBottom;
                var backColor;
                if(style)
                {
                    borderLeft = style.borderLeft;
                    borderTop = style.borderTop;
                    borderRight = style.borderRight;
                    borderBottom = style.borderBottom;
                    backColor = style.backColor;
                    if((backColor === undefined || backColor === null) && (style._backColor !== undefined || style._backColor !== null))
                        backColor = style._backColor
                }
                if(backColor && !borderLeft && !borderRight && !borderTop && !borderBottom)
                    this._adjustingRanges.push({
                        r: row,
                        c: col,
                        rc: 1,
                        cc: 1
                    });
                this._addCellLineImp(row,col,x,y,width,height,borderLeft,borderTop,borderRight,borderBottom,backColor)
            }
        },
        _addCellLineImp: function(row, col, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, backColor, noHGridLine, noVGridLine)
        {
            var addTopLineSucceeded = this._addCellLineSide(row,col,x,y - 0.5,x + width,y - 0.5,borderTop,this._hBorders);
            var addLeftLineSucceeded = this._addCellLineSide(row,col,x - 0.5,y,x - 0.5,y + height,borderLeft,this._vBorders);
            var addBottomLineSucceeded = this._addCellLineSide(row + 1,col,x,y + height - 0.5,x + width,y + height - 0.5,borderBottom,this._hBorders);
            var addRightLineSucceeded = this._addCellLineSide(row,col + 1,x + width - 0.5,y,x + width - 0.5,y + height,borderRight,this._vBorders);
            if(!backColor || this._sheet.getRowHeight(row) === 0 || this._sheet.getColumnWidth(col) === 0)
            {
                var needRenderHGridLine = !addBottomLineSucceeded && !noHGridLine,
                    needRenderVGridLine = !addRightLineSucceeded && !noVGridLine;
                if(needRenderHGridLine || needRenderVGridLine)
                    this._addGridLine(row,col,x,y,width,height,needRenderHGridLine,needRenderVGridLine)
            }
            if(addTopLineSucceeded || backColor !== undefined)
                this._removeLineItem(row - 1,col,this._hGridLine);
            if(addLeftLineSucceeded || backColor !== undefined)
                this._removeLineItem(row,col - 1,this._vGridLine);
            if(backColor && !borderLeft && !borderRight && !borderTop && !borderBottom)
            {
                this._adjustLineItem(row - 1,col - 1,this._vGridLine,false);
                this._adjustLineItem(row - 1,col - 1,this._hGridLine,true)
            }
        },
        _addCellLineSide: function(row, col, x, y, width, height, lineStyle, store)
        {
            if(lineStyle)
            {
                var borderLine;
                var query = this._queryLineItem(row,col,store,true);
                if(query.success)
                {
                    borderLine = query.lineItem;
                    if(borderLine.style.style !== LineStyle.double)
                        if(lineStyle.style === LineStyle.double || compareLineStyle(lineStyle,borderLine.style) > 0)
                        {
                            borderLine.line = Line.Create(x,y,width,height,lineStyle.color,lineStyle.style);
                            borderLine.style = lineStyle
                        }
                }
                else
                {
                    borderLine = this._queryLineItem(row,col,store).lineItem;
                    borderLine.line = Line.Create(x,y,width,height,lineStyle.color,lineStyle.style);
                    borderLine.style = lineStyle
                }
                return borderLine.line !== null
            }
            return false
        },
        _addGridLine: function(row, col, x, y, width, height, hLine, vLine)
        {
            var atViewport = this._sheetArea === GrapeCity.UI.SheetArea.viewport;
            var gridLine = this._sheet.gridline;
            if(!atViewport || gridLine)
            {
                var gridLineColor = !atViewport ? "#9EB6CE" : gridLine.color;
                if(hLine && (gridLine.showHorizontalGridline || !atViewport))
                {
                    var hGridLineItem = this._queryLineItem(row,col,this._hGridLine).lineItem;
                    hGridLineItem.isGridLine = true;
                    hGridLineItem.line = Line.Create(x,y + height - 0.5,x + width,y + height - 0.5,gridLineColor)
                }
                if(vLine && (gridLine.showVerticalGridline || !atViewport))
                {
                    var vGridLineItem = this._queryLineItem(row,col,this._vGridLine).lineItem;
                    vGridLineItem.isGridLine = true;
                    vGridLineItem.line = Line.Create(x + width - 0.5,y,x + width - 0.5,y + height,gridLineColor)
                }
            }
        },
        _adjustLineItem: function(r, c, store, h)
        {
            var query = this._queryLineItem(r,c,store,true);
            if(query.success)
            {
                var lineItem = query.lineItem;
                if(lineItem && lineItem.line)
                    lineItem.line.adjust({
                        orientation: h ? 0 : 1,
                        offsetEnd: -1
                    })
            }
        },
        _removeLineItem: function(r, c, store)
        {
            if(r >= 0 && c >= 0)
            {
                var firstDim = store[r];
                if(firstDim)
                {
                    var secondDim = firstDim[c];
                    if(secondDim)
                        firstDim[c] = null
                }
            }
        },
        _queryLineItem: function(r, c, store, noCreate)
        {
            if(r === -1 || c === -1)
                return{success: false};
            var firstDim = store[r];
            if(!firstDim)
            {
                if(noCreate)
                    return{success: false};
                store[r] = firstDim = []
            }
            var secondDim = firstDim[c];
            if(!secondDim)
            {
                if(noCreate)
                    return{success: false};
                firstDim[c] = secondDim = {}
            }
            return{
                    success: true,
                    lineItem: secondDim
                }
        },
        _processOverflowCells: function()
        {
            for(var i = 0; i < this._overflowedCells.length; i++)
            {
                var overflowCell = this._overflowedCells[i];
                var r = overflowCell.row,
                    sc = overflowCell.startCol,
                    ec = overflowCell.endCol;
                var query;
                for(var c = sc; c < ec; c++)
                {
                    query = this._queryLineItem(r,c + 1,this._vBorders,true);
                    if(query.success)
                        this._removeLineItem(r,c + 1,this._vBorders);
                    else
                    {
                        query = this._queryLineItem(r,c,this._vGridLine,true);
                        if(query.success)
                            this._removeLineItem(r,c,this._vGridLine)
                    }
                }
            }
        },
        _processSpans: function()
        {
            if(this._spanCells.length > 0)
                for(var i = 0; i < this._spanCells.length; i++)
                {
                    var spanLayout = this._spanCells[i];
                    this._processSpanCell(spanLayout)
                }
        },
        _processSpanCell: function(spanCellLayout)
        {
            var row = spanCellLayout.row,
                col = spanCellLayout.col;
            var x = spanCellLayout.x,
                y = spanCellLayout.y;
            var borderLeft,
                borderTop,
                borderRight,
                borderBottom;
            var spanCellStyle = this._sheet.getActualStyle(row,col,this._sheetArea);
            var backColor = spanCellStyle ? spanCellStyle.backColor : null;
            var i,
                r,
                c,
                rowHeight,
                colWidth,
                firstCol,
                firstRow,
                lastCol,
                lastRow,
                cellStyle;
            var ix = x,
                iy = y;
            if(spanCellLayout.rowCount === 1)
            {
                r = row;
                rowHeight = this._sheet._getZoomRowHeight(r,this._sheetArea);
                for(i = 0; i < spanCellLayout.colCount; i++)
                {
                    firstCol = i === 0;
                    lastCol = i === spanCellLayout.colCount - 1;
                    c = col + i;
                    colWidth = this._sheet._getZoomColumnWidth(c,this._sheetArea);
                    cellStyle = this._sheet.getActualStyle(r,c,this._sheetArea);
                    if(cellStyle)
                    {
                        borderLeft = cellStyle.borderLeft;
                        borderTop = cellStyle.borderTop;
                        borderRight = cellStyle.borderRight;
                        borderBottom = cellStyle.borderBottom
                    }
                    else
                        borderLeft = borderTop = borderRight = borderBottom = null;
                    if(firstCol)
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,borderTop,null,borderBottom,backColor,false,true);
                    else if(lastCol)
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,borderTop,borderRight,borderBottom,backColor);
                    else
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,borderTop,null,borderBottom,backColor,false,true);
                    ix += colWidth
                }
            }
            else if(spanCellLayout.colCount === 1)
            {
                c = col;
                colWidth = this._sheet._getZoomColumnWidth(c,this._sheetArea);
                for(i = 0; i < spanCellLayout.rowCount; i++)
                {
                    firstRow = i === 0;
                    lastRow = i === spanCellLayout.rowCount - 1;
                    r = row + i;
                    rowHeight = this._sheet._getZoomRowHeight(r,this._sheetArea);
                    cellStyle = this._sheet.getActualStyle(r,c,this._sheetArea);
                    if(cellStyle)
                    {
                        borderLeft = cellStyle.borderLeft;
                        borderTop = cellStyle.borderTop;
                        borderRight = cellStyle.borderRight;
                        borderBottom = cellStyle.borderBottom
                    }
                    else
                        borderLeft = borderTop = borderRight = borderBottom = null;
                    if(firstRow)
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,borderTop,borderRight,null,backColor,true,false);
                    else if(lastRow)
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,null,borderRight,borderBottom,backColor);
                    else
                        this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,null,borderRight,null,backColor,true,false);
                    iy += rowHeight
                }
            }
            else
                for(i = 0; i < spanCellLayout.rowCount; i++)
                {
                    r = row + i;
                    firstRow = i === 0;
                    lastRow = i === spanCellLayout.rowCount - 1;
                    rowHeight = this._sheet._getZoomRowHeight(r,this._sheetArea);
                    for(var j = 0; j < spanCellLayout.colCount; j++)
                    {
                        c = col + j;
                        firstCol = j === 0;
                        lastCol = j === spanCellLayout.colCount - 1;
                        colWidth = this._sheet._getZoomColumnWidth(c,this._sheetArea);
                        cellStyle = this._sheet.getActualStyle(r,c,this._sheetArea);
                        if(cellStyle)
                        {
                            borderLeft = cellStyle.borderLeft;
                            borderTop = cellStyle.borderTop;
                            borderRight = cellStyle.borderRight;
                            borderBottom = cellStyle.borderBottom
                        }
                        else
                            borderLeft = borderTop = borderRight = borderBottom = null;
                        if(firstRow)
                            if(firstCol)
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,borderTop,null,null,backColor,true,true);
                            else if(lastCol)
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,borderTop,borderRight,null,backColor,true,false);
                            else
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,borderTop,null,null,backColor,true,true);
                        else if(lastRow)
                            if(firstCol)
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,null,null,borderBottom,backColor,false,true);
                            else if(lastCol)
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,null,borderRight,borderBottom,backColor);
                            else
                                this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,null,null,borderBottom,backColor,false,true);
                        else if(firstCol)
                            this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,borderLeft,null,null,null,backColor,true,true);
                        else if(lastCol)
                            this._addCellLineImp(r,c,ix,iy,colWidth,rowHeight,null,null,borderRight,null,backColor,true,false);
                        ix += colWidth
                    }
                    ix = x;
                    iy += rowHeight
                }
            if(backColor && !borderLeft && !borderRight && !borderTop && !borderBottom)
                this._adjustingRanges.push({
                    r: row,
                    c: col,
                    rc: spanCellLayout.rowCount,
                    cc: spanCellLayout.colCount
                })
        },
        _adjust: function()
        {
            if(this._vBorders.length > 0 || this._hBorders.length > 0)
                this._adjustBorders();
            if(this._adjustingRanges.length > 0)
                this._adjustGridlines()
        },
        _adjustGridlines: function()
        {
            for(var i = 0; i < this._adjustingRanges.length; i++)
            {
                var range = this._adjustingRanges[i];
                var r = range.r,
                    c = range.c;
                var ar1 = r,
                    ar2 = r - 1;
                var ac1 = c - 1,
                    ac2 = c;
                if(range.rc > 1)
                    ar1 += range.rc - 1;
                if(range.cc > 1)
                    ac2 += range.cc - 1;
                var skipLeftBottom = false,
                    skipRightTop = false;
                for(var j = 0; j < this._adjustingRanges.length; j++)
                {
                    var next = this._adjustingRanges[j];
                    if(next.c === ac2 + 1 && next.r === r)
                        skipRightTop = true;
                    if(next.r === ar1 + 1 && next.c === c)
                        skipLeftBottom = true;
                    if(skipLeftBottom && skipRightTop)
                        break;
                    if(next.r > r + 1 && next.c > c + 1)
                        break
                }
                if(!skipLeftBottom)
                    this._adjustLineItem(ar1,ac1,this._hGridLine,true);
                if(!skipRightTop)
                    this._adjustLineItem(ar2,ac2,this._vGridLine,false)
            }
        },
        _adjustBorders: function()
        {
            var r,
                c,
                row,
                col;
            for(r = 0; r <= this._rowIndecies.length; r++)
            {
                row = this._rowIndecies[r];
                if(row === undefined && r === this._rowIndecies.length)
                    row = this._rowIndecies[r - 1] + 1;
                for(c = 0; c <= this._colIndecies.length; c++)
                {
                    col = this._colIndecies[c];
                    if(col === undefined && c === this._colIndecies.length)
                        col = this._colIndecies[c - 1] + 1;
                    this._adjustHorizontalBorderLine(r,c,row,col)
                }
            }
            for(c = 0; c <= this._colIndecies.length; c++)
            {
                col = this._colIndecies[c];
                if(col === undefined && c === this._colIndecies.length)
                    col = this._colIndecies[c - 1] + 1;
                for(r = 0; r <= this._rowIndecies.length; r++)
                {
                    row = this._rowIndecies[r];
                    if(row === undefined && r === this._rowIndecies.length)
                        row = this._rowIndecies[r - 1] + 1;
                    this._adjustVerticalBorderLine(r,c,row,col)
                }
            }
        },
        _adjustHorizontalBorderLine: function(r, c, row, col)
        {
            var line,
                prevLine,
                prevBreak1,
                prevBreak2,
                nextLine,
                nextBreak1,
                nextBreak2;
            var lineQuery = this._queryLineItem(row,col,this._hBorders,true);
            var borderLineCount = 0;
            if(!lineQuery.success)
            {
                lineQuery = this._queryLineItem(row - 1,col,this._hGridLine,true);
                if(!lineQuery.success)
                    return
            }
            else
                borderLineCount++;
            line = lineQuery.lineItem;
            prevLine = this._getLineItemImp(row,this._prevCol(c),false);
            if(this._isBorderLineInLayout(prevLine))
                borderLineCount++;
            prevBreak1 = this._getLineItemImp(this._prevRow(r),col,true);
            if(this._isBorderLineInLayout(prevBreak1))
                borderLineCount++;
            prevBreak2 = this._getLineItemImp(row,col,true);
            if(this._isBorderLineInLayout(prevBreak2))
                borderLineCount++;
            nextLine = this._getLineItemImp(row,this._nextCol(c),false);
            if(this._isBorderLineInLayout(nextLine))
                borderLineCount++;
            nextBreak1 = this._getLineItemImp(this._prevRow(r),this._nextCol(c),true);
            if(this._isBorderLineInLayout(nextBreak1))
                borderLineCount++;
            nextBreak2 = this._getLineItemImp(row,this._nextCol(c),true);
            if(this._isBorderLineInLayout(nextBreak2))
                borderLineCount++;
            if(borderLineCount > 0)
                if(isDoubleLine(line.style))
                    DoubleLineLayout.layoutHorizontal(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                else if(isSlantedLine(line.style))
                    SlantedLineLayout.layoutHorizontal(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                else
                    DefaultLineLayout.layoutHorizontal(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2)
        },
        _adjustVerticalBorderLine: function(r, c, row, col)
        {
            var line,
                prevLine,
                prevBreak1,
                prevBreak2,
                nextLine,
                nextBreak1,
                nextBreak2;
            var lineQuery = this._queryLineItem(row,col,this._vBorders,true);
            var borderLineCount = 0;
            if(!lineQuery.success)
            {
                lineQuery = this._queryLineItem(row,col - 1,this._vGridLine,true);
                if(!lineQuery.success)
                    return
            }
            else
                borderLineCount++;
            line = lineQuery.lineItem;
            prevLine = this._getLineItemImp(this._prevRow(r),col,true);
            if(this._isBorderLineInLayout(prevLine))
                borderLineCount++;
            prevBreak1 = this._getLineItemImp(row,this._prevCol(c),false);
            if(this._isBorderLineInLayout(prevBreak1))
                borderLineCount++;
            prevBreak2 = this._getLineItemImp(row,col,false);
            if(this._isBorderLineInLayout(prevBreak2))
                borderLineCount++;
            nextLine = this._getLineItemImp(this._nextRow(r),col,true);
            if(this._isBorderLineInLayout(nextLine))
                borderLineCount++;
            nextBreak1 = this._getLineItemImp(this._nextRow(r),this._prevCol(c),false);
            if(this._isBorderLineInLayout(nextBreak1))
                borderLineCount++;
            nextBreak2 = this._getLineItemImp(this._nextRow(r),col,false);
            if(this._isBorderLineInLayout(nextBreak2))
                borderLineCount++;
            if(borderLineCount > 0)
                if(isDoubleLine(line.style))
                    DoubleLineLayout.layoutVertical(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                else if(isSlantedLine(line.style))
                    SlantedLineLayout.layoutVertical(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2);
                else
                    DefaultLineLayout.layoutVertical(line,prevLine,prevBreak1,prevBreak2,nextLine,nextBreak1,nextBreak2)
        },
        _isBorderLineInLayout: function(line)
        {
            return line && !line.isGridLine && line.line
        },
        _prevCol: function(c)
        {
            if(c < 0)
                return-1;
            return this._colIndecies[c - 1]
        },
        _nextCol: function(c)
        {
            var col = this._colIndecies[c + 1];
            if(col === undefined && c + 1 >= this._colIndecies.length)
                return this._colIndecies[this._colIndecies.length - 1] + 1;
            return col
        },
        _prevRow: function(r)
        {
            if(r < 0)
                return-1;
            return this._rowIndecies[r - 1]
        },
        _nextRow: function(r)
        {
            var row = this._rowIndecies[r + 1];
            if(row === undefined && r + 1 >= this._rowIndecies.length)
                return this._rowIndecies[this._rowIndecies.length - 1] + 1;
            return row
        },
        _getLineItemImp: function(r, c, vertical)
        {
            if(r === undefined || r < 0 || c === undefined || c < 0)
                return null;
            var store = vertical ? this._vBorders : this._hBorders;
            var query = this._queryLineItem(r,c,store,true);
            if(query.success)
                return query.lineItem;
            store = vertical ? this._vGridLine : this._hGridLine;
            if(vertical)
            {
                c--;
                if(c < 0)
                    return null
            }
            else
            {
                r--;
                if(r < 0)
                    return null
            }
            query = this._queryLineItem(r,c,store,true);
            if(query.success)
                return query.lineItem;
            return null
        },
        paint: function(context, clipRect)
        {
            if(!this._isInitialized)
                return;
            if(!this._isMerged)
            {
                this._processSpans();
                this._processOverflowCells();
                this._adjust();
                this._isMerged = true
            }
            context.save();
            context.beginPath();
            this._paint(context,clipRect);
            context.closePath();
            context.stroke();
            context.restore()
        },
        _paint: function(context, clipRect)
        {
            this._paintGridLine(context);
            this._paintBorderLines(context)
        },
        _paintGridLine: function(context)
        {
            this._paintLines(context,this._hGridLine);
            this._paintLines(context,this._vGridLine)
        },
        _paintBorderLines: function(context)
        {
            this._paintLines(context,this._hBorders);
            this._paintLines(context,this._vBorders)
        },
        _paintLines: function(context, store)
        {
            if(store && store.length > 0)
                for(var i in store)
                    if(i)
                    {
                        var firstDim = store[i];
                        if(firstDim && firstDim.length > 0)
                            for(var j in firstDim)
                                if(j)
                                {
                                    var secondDim = firstDim[j];
                                    if(secondDim && secondDim.line)
                                        secondDim.line.paint(context)
                                }
                    }
        }
    }
})(window);
(function(window, $)
{
    var GrapeCity = window.GrapeCity;
    var const_undefined = "undefined";
    if(typeof GrapeCity === const_undefined)
        GrapeCity = window.GrapeCity = {};
    if(typeof GrapeCity.UI === const_undefined)
        GrapeCity.UI = {};
    var UI = GrapeCity.UI;
    var document = window.document;
    GrapeCity.UI._SheetEventHandler = function(sheet)
    {
        this._init(sheet)
    };
    GrapeCity.UI._SheetEventHandler.prototype = {
        _init: function(sheet)
        {
            this._sheet = sheet;
            this._elem = null;
            this._eventSuspended = 0
        },
        _getElem: function()
        {
            if(!this._elem)
                this._elem = document.createElement("input");
            return this._elem
        },
        _dispose: function()
        {
            if(this._hScrollTimer)
                this._hScrollTimer._dispose();
            if(this._vScrollTimer)
                this._vScrollTimer._dispose()
        },
        _getHScrollTimer: function()
        {
            if(!this._hScrollTimer)
                this._hScrollTimer = new GrapeCity.UI.Timer(this._sheet);
            return this._hScrollTimer
        },
        _getVScrollTimer: function()
        {
            if(!this._vScrollTimer)
                this._vScrollTimer = new GrapeCity.UI.Timer(this._sheet);
            return this._vScrollTimer
        },
        doResize: function()
        {
            var sheet = this._sheet;
            var canvas = sheet._getCanvas();
            if(!canvas || !canvas.parentNode)
                return;
            if(canvas.parentNode.clientWidth === 0 || canvas.parentNode.clientHeight === 0)
                return;
            var deltx = 0;
            var delty = 0;
            canvas.style.display = "none";
            canvas.width = Math.max(canvas.parentNode.clientWidth - deltx,0);
            canvas.height = Math.max(canvas.parentNode.clientHeight - delty,0);
            canvas.style.display = "";
            sheet._bounds.width = canvas.clientWidth || canvas.width;
            sheet._bounds.height = canvas.clientHeight || canvas.height;
            sheet.invalidateLayout();
            sheet.repaint()
        },
        _getCanvasOffset: function()
        {
            var sheet = this._sheet;
            var t = $(sheet._getCanvas()).offset();
            if(t)
            {
                if(!isNaN(document.body.clientTop))
                    t.top += document.body.clientTop;
                if(!isNaN(document.body.clientLeft))
                    t.left += document.body.clientLeft
            }
            else
                t = {
                    top: 0,
                    left: 0
                };
            return t
        },
        doMouseDown: function(e)
        {
            if(e.button === 2)
                return;
            var sheet = this._sheet;
            if(!sheet.inCanvas)
                this.handleDocumentMouseMove();
            var t = this._getCanvasOffset();
            var ret = this.doMouseDownImp(e,e.pageX - t.left,e.pageY - t.top);
            if(!sheet.isEditing() && !ret)
                this._setFocus();
            sheet._isMouseDownInSheet = true;
            return false
        },
        handleDocumentMouseMove: function()
        {
            var self = this;
            if(!this._isMouseCapture)
            {
                $(document).bind("mousemove.gcSheet",function(e)
                {
                    self.doMouseMove(e)
                });
                $(document).bind("mouseup.gcSheet",function(e)
                {
                    self.doMouseUp(e)
                });
                this._isMouseCapture = true
            }
        },
        unhandleDocumentMouseMove: function()
        {
            if(this._isMouseCapture)
            {
                this._isMouseCapture = false;
                $(document).unbind("mousemove.gcSheet");
                $(document).unbind("mouseup.gcSheet")
            }
        },
        doMouseDownImp: function(e, x, y)
        {
            var sheet = this._sheet;
            var target = sheet.hitTest(x,y);
            var hitInfo = target.groupHitInfo;
            if(hitInfo)
            {
                if(!sheet.isEditing())
                    this._doClickRangeGroup(hitInfo)
            }
            else
            {
                sheet._currentTarget = target;
                this.isMouseDown = true;
                if(target.resizeInfo)
                {
                    sheet.endEdit();
                    this.isWorking = true
                }
                else if(target.dragInfo && target.dragInfo.side && target.dragInfo.side !== "corner")
                {
                    if(!sheet.endEdit())
                        return;
                    this.startDragDropping(e,x,y,target)
                }
                else if(target.dragInfo && target.dragInfo.side === "corner")
                {
                    if(!sheet.endEdit())
                        return;
                    this.startDragFill(e,x,y,target)
                }
                else if(target.filterButtonHitInfo)
                {
                    if(!sheet.endEdit())
                        return;
                    this._openFilterDialog(target.filterButtonHitInfo)
                }
                else
                {
                    var oldActiveRow = sheet.getActiveRowIndex();
                    var oldActiveCol = sheet.getActiveColumnIndex();
                    if(target.cellTypeHitInfo)
                    {
                        var r = target.row,
                            c = target.col;
                        if(r !== oldActiveRow || c !== oldActiveCol)
                        {
                            var oldState = sheet.isPaintSuspended();
                            sheet.isPaintSuspended(true);
                            try
                            {
                                if(!sheet.endEdit())
                                    return;
                                var args = {
                                        sheet: sheet,
                                        sheetName: sheet._name,
                                        row: oldActiveRow,
                                        col: oldActiveCol,
                                        cancel: false
                                    };
                                sheet._trigger(GrapeCity.UI.Events.LeaveCell,args);
                                if(args && args.cancel === true)
                                    return;
                                var oldSels = sheet._selectionModel.toArray();
                                var newSels = null;
                                var span = sheet._spanModel.find(r,c);
                                if(span)
                                    newSels = [new UI.Range(span.row,span.col,span.rowCount,span.colCount)];
                                else
                                    newSels = [new UI.Range(r,c,1,1)];
                                sheet._trigger(GrapeCity.UI.Events.SelectionChanging,{
                                    sheet: sheet,
                                    sheetName: sheet._name,
                                    oldSelections: oldSels,
                                    newSelections: newSels
                                });
                                sheet.setActiveCell(r,c);
                                sheet._trigger(GrapeCity.UI.Events.EnterCell,{
                                    sheet: sheet,
                                    sheetName: sheet._name,
                                    row: r,
                                    col: c
                                });
                                this._lastSelections = newSels;
                                sheet._trigger(GrapeCity.UI.Events.SelectionChanged,{
                                    sheet: sheet,
                                    sheetName: sheet._name
                                });
                                this._updateValidationUI(r,c)
                            }
                            finally
                            {
                                sheet.isPaintSuspended(oldState)
                            }
                        }
                        var ct = sheet.getCellType(r,c,target.hitTestType);
                        target.cellTypeHitInfo.sheet = sheet;
                        ct.processMouseDown(target.cellTypeHitInfo)
                    }
                    if(target.cellTypeHitInfo && target.cellTypeHitInfo.isReservedLocation)
                        return true;
                    else
                    {
                        this.setMetaKeyState(e);
                        try
                        {
                            this._hitTestResult = target;
                            if(sheet.isEditing() && oldActiveRow === sheet.getActiveRowIndex() && oldActiveCol === sheet.getActiveColumnIndex() && !sheet.endEdit())
                                return
                        }
                        finally
                        {
                            this._hitTestResult = null
                        }
                        if(target.row === undefined || target.row === null || target.col === undefined || target.col === null)
                            return;
                        if(target.hitTestType === GrapeCity.UI.SheetArea.viewport)
                            this._updateValidationUI(target.row,target.col);
                        var oldSelections = sheet._selectionModel.toArray();
                        this.startSelecting(e,x,y,target);
                        var newSelections = sheet._selectionModel.toArray();
                        if(this._notEqualSelecions(oldSelections,newSelections))
                            sheet._trigger(GrapeCity.UI.Events.SelectionChanging,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                oldSelections: oldSelections,
                                newSelections: newSelections
                            })
                    }
                }
            }
        },
        _openFilterDialog: function(filterButtonInfo)
        {
            if(!filterButtonInfo)
                return;
            this._sheet._filterDialiog = new GrapeCity.UI._GcFilterDialog(this._sheet,filterButtonInfo);
            this._sheet._filterDialiog.open()
        },
        _doClickRangeGroup: function(hitInfo)
        {
            var sheet = this._sheet;
            if(!sheet || !hitInfo)
                return;
            var level,
                args,
                action,
                index,
                isExpanded;
            if(hitInfo.what === "rgh")
            {
                if(sheet && !sheet.isEditing())
                {
                    level = hitInfo.info.index;
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        isRowGroup: true,
                        index: -1,
                        level: level,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanging,args);
                    if(args && args.cancel === false)
                    {
                        action = new GrapeCity.UI.UndoRedo.RowGroupHeaderExpandUndoAction(sheet,{level: level});
                        sheet._doCommand(action);
                        sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanged,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            isRowGroup: true,
                            index: -1,
                            level: level
                        })
                    }
                }
            }
            else if(hitInfo.what === "cgh")
            {
                if(!sheet.isEditing())
                {
                    level = hitInfo.info.index;
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        isRowGroup: false,
                        index: -1,
                        level: level,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanging,args);
                    if(args && args.cancel === false)
                    {
                        action = new GrapeCity.UI.UndoRedo.ColumnGroupHeaderExpandUndoAction(sheet,{level: level});
                        sheet._doCommand(action);
                        sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanged,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            isRowGroup: false,
                            index: -1,
                            level: level
                        })
                    }
                }
            }
            else if(hitInfo.what === "rg")
            {
                if(sheet.rowRangeGroup)
                {
                    index = hitInfo.info.index;
                    isExpanded = hitInfo.info.isExpanded;
                    if(hitInfo.info.lineDirection === GrapeCity.UI.RangeGroupDirection.Forward)
                        index--;
                    else
                        index++;
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        isRowGroup: true,
                        index: index,
                        level: hitInfo.info.level,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanging,args);
                    if(args && args.cancel === false)
                    {
                        var rowGroupExpandUndoAction = new GrapeCity.UI.UndoRedo.RowGroupExpandUndoAction(sheet,{
                                index: hitInfo.info.index,
                                level: hitInfo.info.level,
                                collapsed: isExpanded
                            });
                        sheet._doCommand(rowGroupExpandUndoAction);
                        sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanged,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            isRowGroup: true,
                            index: index,
                            level: hitInfo.info.level
                        })
                    }
                }
            }
            else if(hitInfo.what === "cg")
                if(sheet.colRangeGroup)
                {
                    index = hitInfo.info.index;
                    isExpanded = hitInfo.info.isExpanded;
                    if(hitInfo.info.lineDirection === GrapeCity.UI.RangeGroupDirection.Forward)
                        index--;
                    else
                        index++;
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        isRowGroup: false,
                        index: index,
                        level: hitInfo.info.level,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanging,args);
                    if(args && args.cancel === false)
                    {
                        var columnGroupExpandUndoAction = new GrapeCity.UI.UndoRedo.ColumnGroupExpandUndoAction(sheet,{
                                index: hitInfo.info.index,
                                level: hitInfo.info.level,
                                collapsed: isExpanded
                            });
                        sheet._doCommand(columnGroupExpandUndoAction);
                        sheet._trigger(GrapeCity.UI.Events.RangeGroupStateChanged,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            isRowGroup: false,
                            index: index,
                            level: hitInfo.info.level
                        })
                    }
                }
        },
        _updateValidationUI: function(row, col)
        {
            var sheet = this._sheet;
            if(!sheet || !sheet.parent)
                return;
            sheet._disposeValidationUI();
            var activeSheet = sheet.parent.getActiveSheet();
            if(!activeSheet || sheet.getName() !== activeSheet.getName())
                return;
            var dv = sheet.getDataValidator(row,col);
            var offset = this._getCanvasOffset();
            var rect = sheet.getCellRect(row,col);
            var sheetLayout = sheet._getSheetLayout();
            if(rect.x === null || rect.x === undefined || rect.y === null || rect.y === undefined || rect.width === null || rect.width === undefined || rect.height === null || rect.height === undefined || rect.x + rect.width > sheetLayout.viewportX + sheetLayout.viewportWidth || rect.y + rect.height > sheetLayout.viewportY + sheetLayout.viewportHeight)
                return;
            if(dv && dv.showInputMessage && dv.inputMessage)
            {
                var span = document.createElement("span");
                $(span).css("position","absolute").css("border","1px #C0C0C0 solid").css("padding","3px 8px 3px 8px").css("background-color","#FFFFFF").css("box-shadow","1px 2px 5px rgba(0,0,0,0.4)").css("font","normal normal normal 12px/normal Arial").width("auto").height("auto").css("top",rect.y + rect.height + offset.top + 5).css("left",rect.x + rect.width / 2 + offset.left).html("<b>" + dv.inputTitle + "</b><br/>" + dv.inputMessage).attr("gcUIElement","gcValidationInputMessage").appendTo(document.body);
                sheet._validationInputMessage = span
            }
            if(dv && dv.type === UI.CriteriaType.List && dv.inCellDropdown)
            {
                var validList = dv.condition.getValidList(sheet,row,col);
                var length = validList.length;
                var select = document.createElement("select");
                var innerHtml = "";
                for(var i = 0; i < length; i++)
                {
                    var v = validList[i];
                    if(v === null || v === undefined)
                        v = "";
                    else if(v instanceof Date)
                        v = new UI._DateTimeHelper(v).localeFormat("d/M/yyyy h:mm:ss");
                    innerHtml += "<option value=\"" + v + "\">" + v + "</option>"
                }
                var cellStyle = sheet.getActualStyle(row,col);
                var font = cellStyle && cellStyle.font ? cellStyle.font : sheet._render._getDefaultFont();
                if(sheet._zoomFactor > 1)
                    font = sheet._render._getZoomFont(font);
                $(select).html(innerHtml).css("outline","none").css("position","absolute").css("font",font).width(rect.width).height(length > 8 ? 140 : "auto").css("top",rect.y + rect.height + offset.top).css("left",rect.x + offset.left).attr("gcUIElement","gcValidationSelect").appendTo(document.body).attr("size",length > 2 ? length : 2).hide().val(sheet.getValue(row,col)).bind("click",function()
                {
                    var newValue = $(select).val();
                    if(newValue)
                    {
                        var cellEditInfo = {
                                row: row,
                                col: col,
                                newValue: newValue,
                                autoFormat: true
                            };
                        var undoAction = new UI.UndoRedo.CellEditUndoAction(sheet,cellEditInfo);
                        sheet._doCommand(undoAction)
                    }
                    $(select).hide()
                }).bind("keydown",function(event)
                {
                    if(event.keyCode === UI.Key.enter && !event.ctrlKey && !event.shiftKey && !event.altKey)
                    {
                        var newValue = $(select).val();
                        if(newValue)
                        {
                            var cellEditInfo = {
                                    row: row,
                                    col: col,
                                    newValue: newValue,
                                    autoFormat: true
                                };
                            var undoAction = new UI.UndoRedo.CellEditUndoAction(sheet,cellEditInfo);
                            sheet._doCommand(undoAction)
                        }
                        $(select).hide()
                    }
                    else if(event.keyCode === UI.Key.esc && !event.ctrlKey && !event.shiftKey && !event.altKey)
                        $(select).hide()
                });
                sheet._validationSelect = select;
                var spans = sheet.getSpans(new UI.Range(row,col,1,1));
                var colSpan = 1;
                if(spans && spans.length > 0)
                    if(spans[0])
                        colSpan = spans[0].colCount;
                var isLastColumn = col + colSpan - 1 === sheet.getColumnCount() - 1;
                var button = document.createElement("input");
                button.type = "image";
                button.src = UI._GcFilterDialog.getImageSrc(UI._FilterButtonState.noSortFilter);
                button.alt = "v";
                var size = sheet.getRowHeight(row) * sheet._zoomFactor;
                if(size > 15)
                    size = 15;
                $(button).css("position","absolute").width(size).height(size).css("top",rect.y + rect.height + offset.top - (size + 3)).css("left",rect.x + rect.width + offset.left - (isLastColumn ? size : 0)).css("background-color","white").css("border","1px solid gray").attr("gcUIElement","gcValidationButton").appendTo(document.body).click(function()
                {
                    if(sheet.isEditing())
                        sheet.endEdit();
                    $(sheet._validationSelect).toggle().focus()
                });
                sheet._validationButton = button
            }
        },
        startSelecting: function(e, x, y, target)
        {
            var colIndex = 0,
                rowIndex = 0,
                rowCount = 0,
                colCount = 0;
            var sheet = this._sheet;
            this._getHScrollTimer().start();
            this._getVScrollTimer().start();
            if(!this.ctrl && !this.shift)
                sheet._clearSelectionImp();
            this.beginHitTest = target;
            var firstRow,
                args,
                cellRange,
                activeRowChanged;
            if(target.hitTestType === GrapeCity.UI.SheetArea.corner)
            {
                if(!this.shift)
                {
                    firstRow = sheet.frozenRowCount ? sheet._getFirstVisualRow() : sheet._scrollTopRow;
                    var leftCol = sheet.frozenColCount ? sheet._getFirstVisualColumn() : sheet._scrollLeftCol;
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: sheet._activeRowIndex,
                        col: sheet._activeColIndex,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.LeaveCell,args);
                    if(args && args.cancel === true)
                        return;
                    sheet._setActiveCellImp(firstRow,leftCol,1,1);
                    sheet._trigger(GrapeCity.UI.Events.EnterCell,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: firstRow,
                        col: leftCol
                    });
                    this._updateValidationUI(firstRow,leftCol)
                }
                if(!this.ctrl)
                    sheet._clearSelectionImp();
                sheet._setSelectedRange(-1,-1,sheet.getRowCount(),sheet.getColumnCount(),true);
                this.isWorking = true
            }
            else if(target.hitTestType === GrapeCity.UI.SheetArea.colHeader || target.hitTestType === GrapeCity.UI.SheetArea.colFooter)
            {
                if(!this.shift)
                {
                    firstRow = sheet.frozenRowCount ? sheet._getFirstVisualRow() : sheet._scrollTopRow;
                    cellRange = sheet._getAvailableActiveCell(firstRow,target.col,false);
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: sheet._activeRowIndex,
                        col: sheet._activeColIndex,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.LeaveCell,args);
                    if(args && args.cancel === true)
                        return;
                    sheet._setActiveCellImp(cellRange.row,cellRange.col,1,target.colViewportIndex);
                    sheet._trigger(GrapeCity.UI.Events.EnterCell,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: cellRange.row,
                        col: cellRange.col
                    });
                    this._updateValidationUI(cellRange.row,cellRange.col)
                }
                if(this.shift)
                {
                    colIndex = Math.min(sheet._activeColIndex,target.col);
                    colCount = Math.abs(sheet._activeColIndex - target.col) + 1;
                    sheet._replaceActiveSelectedRange(-1,colIndex,sheet.getRowCount(),colCount,true)
                }
                else
                    sheet._setSelectedRange(-1,sheet._activeColIndex,sheet.getRowCount(),1,true);
                this.isWorking = true
            }
            else if(target.hitTestType === GrapeCity.UI.SheetArea.rowHeader)
            {
                if(!this.shift)
                {
                    var firstCol = sheet.frozenColCount ? sheet._getFirstVisualColumn() : sheet._scrollLeftCol;
                    cellRange = sheet._getAvailableActiveCell(target.row,firstCol,true);
                    args = {
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: sheet._activeRowIndex,
                        col: sheet._activeColIndex,
                        cancel: false
                    };
                    sheet._trigger(GrapeCity.UI.Events.LeaveCell,args);
                    if(args && args.cancel === true)
                        return;
                    activeRowChanged = sheet._activeRowIndex !== cellRange.row;
                    sheet._setActiveCellImp(cellRange.row,cellRange.col,target.rowViewportIndex,1);
                    if(activeRowChanged)
                        sheet.doDataItemChanged();
                    sheet._trigger(GrapeCity.UI.Events.EnterCell,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        row: cellRange.row,
                        col: cellRange.col
                    });
                    this._updateValidationUI(cellRange.row,cellRange.col)
                }
                if(this.shift)
                {
                    rowIndex = Math.min(sheet._activeRowIndex,target.row);
                    rowCount = Math.abs(sheet._activeRowIndex - target.row) + 1;
                    sheet._replaceActiveSelectedRange(rowIndex,-1,rowCount,sheet.getColumnCount(),true)
                }
                else
                    sheet._setSelectedRange(sheet._activeRowIndex,-1,1,sheet.getColumnCount(),true);
                this.isWorking = true
            }
            else if(target.hitTestType === GrapeCity.UI.SheetArea.viewport)
                if(!isNaN(target.row) && !isNaN(target.col))
                {
                    if(!this.shift)
                        if(sheet._activeRowIndex !== target.row || sheet._activeColIndex !== target.col)
                        {
                            args = {
                                sheet: sheet,
                                sheetName: sheet._name,
                                row: sheet._activeRowIndex,
                                col: sheet._activeColIndex,
                                cancel: false
                            };
                            sheet._trigger(GrapeCity.UI.Events.LeaveCell,args);
                            if(args && args.cancel === true)
                                return;
                            activeRowChanged = sheet._activeRowIndex !== target.row;
                            sheet._setActiveCellImp(target.row,target.col,target.rowViewportIndex,target.colViewportIndex);
                            if(activeRowChanged)
                                sheet.doDataItemChanged();
                            sheet._trigger(GrapeCity.UI.Events.EnterCell,{
                                sheet: sheet,
                                sheetName: sheet._name,
                                row: target.row,
                                col: target.col
                            });
                            this._updateValidationUI(target.row,target.col)
                        }
                    if(this.shift)
                        sheet._extendSelectedRange(target.row,target.col,true);
                    else
                    {
                        var span = sheet._spanModel.find(target.row,target.col);
                        if(span)
                            sheet._setSelectedRange(span.row,span.col,span.rowCount,span.colCount,true);
                        else
                            sheet._setSelectedRange(target.row,target.col,1,1,true)
                    }
                    this.isWorking = true
                }
                else
                {
                    if(sheet.isEditing())
                    {
                        var rect = sheet.getCellRect(sheet._activeRowIndex,sheet._activeColIndex,sheet.activeRowViewportIndex,sheet.activeColViewportIndex);
                        sheet._render.update(rect.x,rect.y,rect.width,rect.height)
                    }
                    this.beginHitTest = null
                }
        },
        continueSelecting: function(e, x, y, target)
        {
            if(!this.beginHitTest)
                return;
            if(this._forceCancelSelectiong === true)
                return;
            this.isWorking = true;
            var sheet = this._sheet;
            if(!this.beginHitTest.freezeInfo)
            {
                var freezeInfo = {
                        freezeTop: false,
                        freezeLeft: false
                    };
                if(this.beginHitTest.col < sheet._getFirstPageLeftColumn())
                    freezeInfo.freezeLeft = true;
                if(this.beginHitTest.row < sheet._getFirstPageTopRow())
                    freezeInfo.freezeTop = true;
                this.beginHitTest.freezeInfo = freezeInfo
            }
            var hitTestType = this.beginHitTest.hitTestType;
            if(hitTestType === GrapeCity.UI.SheetArea.viewport)
                this.continueCellSelecting(e,x,y,target);
            else if(hitTestType === GrapeCity.UI.SheetArea.rowHeader)
                this.continueRowSelecting(e,x,y,target);
            else if(hitTestType === GrapeCity.UI.SheetArea.colHeader || hitTestType === GrapeCity.UI.SheetArea.colFooter)
                this.continueColumnSelecting(e,x,y,target)
        },
        continueCellSelecting: function(e, x, y, target)
        {
            var sheet = this._sheet;
            var self = this;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            var mousePosition = this.getMousePosition(e,x,y,GrapeCity.UI.SheetArea.viewport);
            if(mousePosition.left)
            {
                if(!freezeLeft)
                    this._getHScrollTimer().setAction(function()
                    {
                        var firstPageLeftCol = sheet._getFirstPageLeftColumn();
                        var newLeftCol = sheet._getPrevVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol >= firstPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellSelecting(e,x,y,target)
                        }
                    })
            }
            else if(mousePosition.right)
                if(freezeLeft)
                {
                    sheet._setLeftColumn(sheet._getFirstPageLeftColumn());
                    this.beginHitTest.freezeInfo.freezeLeft = false
                }
                else
                    this._getHScrollTimer().setAction(function()
                    {
                        var lastPageLeftCol = sheet._getLastPageLeftColumn();
                        var newLeftCol = sheet._getNextVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol <= lastPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellSelecting(e,x,y,target)
                        }
                    });
            if(mousePosition.top)
            {
                if(!freezeTop)
                    this._getVScrollTimer().setAction(function()
                    {
                        var firstPageTopRow = sheet._getFirstPageTopRow();
                        var newTopRow = sheet._getPrevVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(self.getIntervalFromDistance(mousePosition.distanceX) <= 50)
                            newTopRow = sheet._getPrevVisualRow(newTopRow);
                        if(newTopRow >= firstPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellSelecting(e,x,y,target)
                        }
                    })
            }
            else if(mousePosition.bottom)
                if(freezeTop)
                {
                    sheet._setTopRow(sheet._getFirstPageTopRow());
                    this.beginHitTest.freezeInfo.freezeTop = false
                }
                else
                    this._getVScrollTimer().setAction(function()
                    {
                        var lastPageTopRow = sheet._getLastPageTopRow();
                        var newTopRow = sheet._getNextVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(self.getIntervalFromDistance(mousePosition.distanceX) <= 50)
                            newTopRow = sheet._getNextVisualRow(newTopRow);
                        if(newTopRow <= lastPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellSelecting(e,x,y,target)
                        }
                    });
            this._getHScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceX));
            this._getVScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceY));
            target = sheet.hitTest(mousePosition.nearMouseX,mousePosition.nearMouseY);
            var oldSelections = sheet._selectionModel.toArray();
            sheet._extendSelectedRange(target.row,target.col,true);
            var newSelections = sheet._selectionModel.toArray();
            if(this._notEqualSelecions(oldSelections,newSelections))
                sheet._trigger(GrapeCity.UI.Events.SelectionChanging,{
                    sheet: sheet,
                    sheetName: sheet._name,
                    oldSelections: oldSelections,
                    newSelections: newSelections
                })
        },
        continueRowSelecting: function(e, x, y, target)
        {
            var sheet = this._sheet;
            var self = this;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            var mousePosition = this.getMousePosition(e,x,y,GrapeCity.UI.SheetArea.rowHeader);
            if(mousePosition.top)
            {
                if(!freezeTop)
                    this._getVScrollTimer().setAction(function()
                    {
                        var firstPageTopRow = sheet._getFirstPageTopRow();
                        var newTopRow = sheet._getPrevVisualRow(sheet._scrollTopRow);
                        if(newTopRow >= firstPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueRowSelecting(e,x,y,target)
                        }
                    })
            }
            else if(mousePosition.bottom)
                if(freezeTop)
                {
                    sheet._setTopRow(sheet._getFirstPageTopRow());
                    this.beginHitTest.freezeInfo.freezeTop = false
                }
                else
                    this._getVScrollTimer().setAction(function()
                    {
                        var lastPageTopRow = sheet._getLastPageTopRow();
                        var newTopRow = sheet._getNextVisualRow(sheet._scrollTopRow);
                        if(newTopRow <= lastPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueRowSelecting(e,x,y,target)
                        }
                    });
            this._getVScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceY));
            target = sheet.hitTest(mousePosition.nearMouseX,mousePosition.nearMouseY);
            var r = Math.min(sheet._activeRowIndex,target.row);
            var rc = Math.max(sheet._activeRowIndex,target.row) - r + 1;
            var c = -1;
            var cc = sheet.getColumnCount();
            var selectionPolicy = sheet.selectionPolicy();
            if(selectionPolicy === UI.SelectionPolicy.Single)
                return;
            var selectionUnit = sheet.selectionUnit();
            if(selectionUnit === UI.SelectionUnit.Column)
            {
                r = -1;
                rc = -1
            }
            var oldSelections = sheet._selectionModel.toArray();
            sheet._replaceActiveSelectedRange(r,c,rc,cc,true);
            var newSelections = sheet._selectionModel.toArray();
            if(this._notEqualSelecions(oldSelections,newSelections))
                sheet._trigger(GrapeCity.UI.Events.SelectionChanging,{
                    sheet: sheet,
                    sheetName: sheet._name,
                    oldSelections: oldSelections,
                    newSelections: newSelections
                })
        },
        continueColumnSelecting: function(e, x, y, target)
        {
            var sheet = this._sheet;
            var self = this;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            var mousePosition = this.getMousePosition(e,x,y,GrapeCity.UI.SheetArea.colHeader);
            if(mousePosition.left)
            {
                if(!freezeLeft)
                    this._getHScrollTimer().setAction(function()
                    {
                        var firstPageLeftCol = sheet._getFirstPageLeftColumn();
                        var newLeftCol = sheet._getPrevVisualColumn(sheet._scrollLeftCol);
                        if(newLeftCol >= firstPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueColumnSelecting(e,x,y,target)
                        }
                    })
            }
            else if(mousePosition.right)
                if(freezeLeft)
                {
                    sheet._setLeftColumn(sheet._getFirstPageLeftColumn());
                    this.beginHitTest.freezeInfo.freezeLeft = false
                }
                else
                    this._getHScrollTimer().setAction(function()
                    {
                        var lastPageLeftCol = sheet._getLastPageLeftColumn();
                        var newLeftCol = sheet._getNextVisualColumn(sheet._scrollLeftCol);
                        if(newLeftCol <= lastPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueColumnSelecting(e,x,y,target)
                        }
                    });
            this._getHScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceX));
            target = sheet.hitTest(mousePosition.nearMouseX,mousePosition.nearMouseY);
            var c = Math.min(sheet._activeColIndex,target.col);
            var cc = Math.max(sheet._activeColIndex,target.col) - c + 1;
            var r = -1;
            var rc = sheet.getRowCount();
            var selectionPolicy = sheet.selectionPolicy();
            if(selectionPolicy === UI.SelectionPolicy.Single)
                return;
            var selectionUnit = sheet.selectionUnit();
            if(selectionUnit === UI.SelectionUnit.Row)
            {
                c = -1;
                cc = -1
            }
            var oldSelections = sheet._selectionModel.toArray();
            sheet._replaceActiveSelectedRange(r,c,rc,cc,true);
            var newSelections = sheet._selectionModel.toArray();
            if(this._notEqualSelecions(oldSelections,newSelections))
                sheet._trigger(GrapeCity.UI.Events.SelectionChanging,{
                    sheet: sheet,
                    sheetName: sheet._name,
                    oldSelections: oldSelections,
                    newSelections: newSelections
                })
        },
        stopSelecting: function()
        {
            this.beginHitTest = null;
            this._getHScrollTimer().stop();
            this._getVScrollTimer().stop();
            this._forceCancelSelectiong = null;
            if(this.isWorking === false)
                return;
            else
                this.isWorking = false;
            var sheet = this._sheet;
            var needRaiseChangedEvent = !this._lastSelections;
            if(needRaiseChangedEvent)
                this._lastSelections = sheet._selectionModel.toArray();
            else
            {
                var currentSelections = sheet._selectionModel.toArray();
                needRaiseChangedEvent = this._notEqualSelecions(this._lastSelections,currentSelections);
                if(needRaiseChangedEvent)
                    this._lastSelections = currentSelections
            }
            if(needRaiseChangedEvent)
                sheet._trigger(GrapeCity.UI.Events.SelectionChanged,{
                    sheet: this._sheet,
                    sheetName: this._sheet._name
                })
        },
        startDragDropping: function(e, x, y, beginTarget)
        {
            var sheet = this._sheet;
            if(this.isDragDropping)
                return;
            var fromRange = null;
            if(sheet._selectionModel.length === 1)
                fromRange = sheet._selectionModel[0];
            else if(sheet._selectionModel.length < 1)
            {
                var spanActiveCell = sheet._spanModel.find(sheet._activeRowIndex,sheet._activeColIndex);
                if(spanActiveCell)
                    fromRange = spanActiveCell;
                else
                    fromRange = new GrapeCity.UI.Range(sheet._activeRowIndex,sheet._activeColIndex,1,1)
            }
            if(fromRange)
            {
                this.isDragDropping = true;
                this.isWorking = true;
                this._dragDropFromRange = fromRange;
                var rg = null;
                var activeSelRange = sheet._getActiveSelectedRange();
                if(activeSelRange && (activeSelRange.rowCount > 0 || activeSelRange.colCount > 0))
                    rg = {
                        r: activeSelRange.row,
                        c: activeSelRange.col,
                        rc: activeSelRange.rowCount,
                        cc: activeSelRange.colCount
                    };
                else
                    rg = {
                        r: sheet._activeRowIndex,
                        c: sheet._activeColIndex,
                        rc: 1,
                        cc: 1
                    };
                this.beginHitTest = beginTarget;
                var target = sheet._currentTarget;
                var rect = sheet._getActiveSelectionRect(target.rowViewportIndex,target.colViewportIndex);
                var dragRect = sheet._dragRect;
                dragRect.x = rect.x;
                dragRect.y = rect.y;
                dragRect.width = rect.width - 1;
                dragRect.height = rect.height - 1;
                dragRect.row = rg.r;
                dragRect.col = rg.c;
                dragRect.rowCount = rg.rc;
                dragRect.colCount = rg.cc;
                dragRect.beginHitRow = target.row;
                dragRect.beginHitCol = target.col;
                dragRect.hitRow = target.row;
                dragRect.hitCol = target.col;
                if(this.beginHitTest)
                {
                    var dragInfo = this.beginHitTest.dragInfo;
                    if(dragInfo.outside === true)
                        switch(dragInfo.side)
                        {
                            case"left":
                                dragRect.col--;
                                break;
                            case"right":
                                dragRect.col++;
                                break;
                            case"top":
                                dragRect.row--;
                                break;
                            case"bottom":
                                dragRect.row++;
                                break
                        }
                    dragRect.beginRow = dragRect.row;
                    dragRect.beginCol = dragRect.col
                }
                this._getHScrollTimer().start();
                this._getVScrollTimer().start()
            }
        },
        continueDragDropping: function(e, x, y)
        {
            var sheet = this._sheet;
            if(!this.beginHitTest)
                return;
            var target = sheet.hitTest(x,y,true);
            if(!this.isDragDropping || !this._dragDropFromRange)
                return;
            this.isWorking = true;
            var dragRect = sheet._dragRect;
            dragRect.hitTarget = target;
            if(!this.beginHitTest.freezeInfo)
            {
                var freezeInfo = {
                        freezeTop: false,
                        freezeLeft: false
                    };
                if(this.beginHitTest.col < sheet._getFirstPageLeftColumn())
                    freezeInfo.freezeLeft = true;
                if(this.beginHitTest.row < sheet._getFirstPageTopRow())
                    freezeInfo.freezeTop = true;
                this.beginHitTest.freezeInfo = freezeInfo
            }
            this.continueCellDragDropping(e,x,y)
        },
        continueCellDragDropping: function(e, x, y)
        {
            var sheet = this._sheet;
            var self = this;
            var mousePosition = this.getMousePosition(e,x,y,GrapeCity.UI.SheetArea.viewport);
            if(!mousePosition)
                return;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            if(mousePosition.left)
            {
                if(!freezeLeft)
                    this._getHScrollTimer().setAction(function()
                    {
                        var firstPageLeftCol = sheet._getFirstPageLeftColumn();
                        var newLeftCol = sheet._getPrevVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol >= firstPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellDragDropping(e,x,y)
                        }
                    })
            }
            else if(mousePosition.right)
                if(freezeLeft)
                {
                    sheet._setLeftColumn(sheet._getFirstPageLeftColumn());
                    this.beginHitTest.freezeInfo.freezeLeft = false
                }
                else
                    this._getHScrollTimer().setAction(function()
                    {
                        var lastPageLeftCol = sheet._getLastPageLeftColumn();
                        var newLeftCol = sheet._getNextVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol <= lastPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellDragDropping(e,x,y)
                        }
                    });
            if(mousePosition.top)
            {
                if(!freezeTop)
                    this._getVScrollTimer().setAction(function()
                    {
                        var firstPageTopRow = sheet._getFirstPageTopRow();
                        var newTopRow = sheet._getPrevVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(newTopRow >= firstPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellDragDropping(e,x,y)
                        }
                    })
            }
            else if(mousePosition.bottom)
                if(freezeTop)
                {
                    sheet._setTopRow(sheet._getFirstPageTopRow());
                    this.beginHitTest.freezeInfo.freezeTop = false
                }
                else
                    this._getVScrollTimer().setAction(function()
                    {
                        var lastPageTopRow = sheet._getLastPageTopRow();
                        var newTopRow = sheet._getNextVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(newTopRow <= lastPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellDragDropping(e,x,y)
                        }
                    });
            this._getHScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceX));
            this._getVScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceY));
            this.updateDragDropRect(mousePosition.nearMouseX,mousePosition.nearMouseY)
        },
        updateDragDropRect: function(x, y)
        {
            var sheet = this._sheet;
            if(!this.beginHitTest)
                return;
            var target = sheet.hitTest(x,y,true);
            if(target.row === undefined || target.row === null || target.col === undefined || target.col === null)
                return;
            if(!this.isDragDropping || !this._dragDropFromRange)
                return;
            var dragRect = sheet._dragRect;
            var activeSelRange = sheet._getActiveSelectedRange();
            if(activeSelRange.row === -1 && activeSelRange.col !== -1)
            {
                dragRect.row = -1;
                dragRect.col = target.col
            }
            else if(activeSelRange.row !== -1 && activeSelRange.col === -1)
            {
                dragRect.row = target.row;
                dragRect.col = -1
            }
            else
            {
                dragRect.row = dragRect.beginRow + (target.row - dragRect.beginHitRow);
                dragRect.col = dragRect.beginCol + (target.col - dragRect.beginHitCol);
                if(dragRect.row < 0)
                    dragRect.row = 0;
                if(dragRect.col < 0)
                    dragRect.col = 0
            }
            dragRect.hitRow = target.row;
            dragRect.hitCol = target.col;
            var sheetRowCount = sheet.getRowCount();
            var sheetColCount = sheet.getColumnCount();
            if(dragRect.row + dragRect.rowCount > sheetRowCount)
                dragRect.row = sheetRowCount - dragRect.rowCount;
            if(dragRect.col + dragRect.colCount > sheetColCount)
                dragRect.col = sheetColCount - dragRect.colCount;
            var row = dragRect.row < 0 ? 0 : dragRect.row;
            var col = dragRect.col < 0 ? 0 : dragRect.col;
            var dragRange = new GrapeCity.UI.Range(row,col,dragRect.rowCount,dragRect.colCount);
            var oldDragRange = sheet._oldDragRange;
            if(oldDragRange)
                if(dragRange.row === oldDragRange.row && dragRange.col === oldDragRange.col && dragRange.rowCount === oldDragRange.rowCount && dragRange.colCount === oldDragRange.colCount && dragRange.row > sheet._getFirstVisualRow() && dragRange.col > sheet._getFirstVisualColumn() && dragRange.row + dragRange.rowCount - 1 < sheet._getLastVisualRow() && dragRange.col + dragRange.colCount - 1 < sheet._getLastVisualColumn())
                    return;
            sheet._actualDragRange = dragRange;
            sheet._render.refreshDragDropIndicator()
        },
        stopDragDrop: function(e)
        {
            var isInvalid = false;
            var invalidMessage = "";
            var doCommand = false;
            var sheet = this._sheet;
            var rg = null;
            this.beginHitTest = null;
            this._getHScrollTimer().stop();
            this._getVScrollTimer().stop();
            var _selectedRange = sheet._getActiveSelectedRange();
            if(_selectedRange && (_selectedRange.rowCount > 0 || _selectedRange.colCount > 0))
                rg = {
                    r: _selectedRange.row,
                    c: _selectedRange.col,
                    rc: _selectedRange.rowCount,
                    cc: _selectedRange.colCount
                };
            else
                rg = {
                    r: sheet._activeRowIndex,
                    c: sheet._activeColIndex,
                    rc: 1,
                    cc: 1
                };
            if(this.isDragDropping === true && this.isWorking === true)
            {
                var fromRow = rg.r;
                var fromColumn = rg.c;
                var rowCount = rg.rc;
                var columnCount = rg.cc;
                var toRow = sheet._dragRect.row;
                var toColumn = sheet._dragRect.col;
                var action,
                    cancel,
                    dragMoveExtent;
                if(this._isDragInsert && (fromRow === -1 || fromColumn === -1))
                {
                    if(fromColumn >= 0 && fromRow < 0)
                    {
                        if(this._isDragCopy && (toColumn <= fromColumn || toColumn >= fromColumn + columnCount) || !this._isDragCopy && (toColumn < fromColumn || toColumn > fromColumn + columnCount))
                        {
                            if(sheet._hasPartSpans(-1,fromColumn,-1,columnCount) || sheet._hasPartSpans(-1,toColumn,-1,0))
                            {
                                isInvalid = true;
                                invalidMessage = "Cannot change part of a merged cell."
                            }
                            if(!isInvalid)
                                if(sheet._hasPartArrayFormulas(-1,fromColumn,-1,columnCount) || sheet._hasPartArrayFormulas(-1,toColumn,-1,0))
                                {
                                    isInvalid = true;
                                    invalidMessage = "Cannot change part of an array."
                                }
                            if(!isInvalid && sheet.isProtected)
                            {
                                isInvalid = true;
                                invalidMessage = "The column you are trying to change is protected and therefore read-only."
                            }
                            if(!isInvalid)
                            {
                                dragMoveExtent = new GrapeCity.UI.UndoRedo.DragDropExtent(-1,fromColumn,-1,toColumn,-1,columnCount);
                                cancel = sheet._raiseDragDropBlock(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                if(!cancel)
                                {
                                    action = new GrapeCity.UI.UndoRedo.DragDropUndoAction(sheet,dragMoveExtent,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                    sheet.doCommand(action);
                                    sheet._raiseDragDropBlockCompleted(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                    doCommand = true
                                }
                            }
                        }
                    }
                    else if(fromRow >= 0 && fromColumn < 0)
                        if(this._isDragCopy && (toRow <= fromRow || toRow >= fromRow + rowCount) || !this._isDragCopy && (toRow < fromRow || toRow > fromRow + rowCount))
                        {
                            if(sheet._hasPartSpans(fromRow,-1,rowCount,-1) || sheet._hasPartSpans(toRow,-1,0,-1))
                            {
                                isInvalid = true;
                                invalidMessage = "Cannot change part of a merged cell."
                            }
                            if(!isInvalid)
                                if(sheet._hasPartArrayFormulas(fromRow,-1,rowCount,-1) || sheet._hasPartArrayFormulas(toRow,-1,0,-1))
                                {
                                    isInvalid = true;
                                    invalidMessage = "Cannot change part of an array."
                                }
                            if(!isInvalid && sheet.isProtected)
                            {
                                isInvalid = true;
                                invalidMessage = "The row you are trying to change is protected and therefore read-only."
                            }
                            if(!isInvalid)
                            {
                                dragMoveExtent = new GrapeCity.UI.UndoRedo.DragDropExtent(fromRow,-1,toRow,-1,rowCount,-1);
                                cancel = sheet._raiseDragDropBlock(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                if(!cancel)
                                {
                                    action = new GrapeCity.UI.UndoRedo.DragDropUndoAction(sheet,dragMoveExtent,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                    sheet.doCommand(action);
                                    sheet._raiseDragDropBlockCompleted(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,true,GrapeCity.UI.CopyToOption.All);
                                    doCommand = true
                                }
                            }
                        }
                }
                else if(toRow !== fromRow || toColumn !== fromColumn)
                {
                    if(sheet._hasPartSpans(fromRow,fromColumn,rowCount,columnCount) || sheet._hasPartSpans(toRow,toColumn,rowCount,columnCount))
                    {
                        isInvalid = true;
                        invalidMessage = "Cannot change part of a merged cell."
                    }
                    if(!isInvalid)
                        if(sheet._hasPartArrayFormulas(fromRow,fromColumn,rowCount,columnCount) || sheet._hasPartArrayFormulas(toRow,toColumn,rowCount,columnCount))
                        {
                            isInvalid = true;
                            invalidMessage = "Cannot change part of an array."
                        }
                    if(!isInvalid && sheet.isProtected)
                        if(!this._isDragCopy && sheet._isAnyCellInRangeLocked(new GrapeCity.UI.Range(fromRow,fromColumn,rowCount,columnCount)) || sheet._isAnyCellInRangeLocked(new GrapeCity.UI.Range(toRow,toColumn,rowCount,columnCount)))
                        {
                            isInvalid = true;
                            invalidMessage = "The cells you are trying to change is protected and therefore read-only."
                        }
                    if(!isInvalid)
                    {
                        dragMoveExtent = new GrapeCity.UI.UndoRedo.DragDropExtent(fromRow,fromColumn,toRow,toColumn,rowCount,columnCount);
                        cancel = sheet._raiseDragDropBlock(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,false,GrapeCity.UI.CopyToOption.All);
                        if(!cancel)
                        {
                            action = new GrapeCity.UI.UndoRedo.DragDropUndoAction(sheet,dragMoveExtent,this._isDragCopy,false,GrapeCity.UI.CopyToOption.All);
                            sheet.doCommand(action);
                            sheet._raiseDragDropBlockCompleted(dragMoveExtent.fromRow,dragMoveExtent.fromColumn,dragMoveExtent.toRow,dragMoveExtent.toColumn,dragMoveExtent.rowCount,dragMoveExtent.columnCount,this._isDragCopy,false,GrapeCity.UI.CopyToOption.All);
                            doCommand = true
                        }
                    }
                }
            }
            this.isWorking = false;
            this.isDragDropping = false;
            this._dragDropFromRange = null;
            this._isDragInsert = false;
            this._isDragCopy = false;
            if(doCommand === false)
            {
                sheet._dragRect = {};
                sheet.repaint()
            }
            if(isInvalid)
                sheet._raiseInvalidOperation(invalidMessage)
        },
        startDragFill: function(e, x, y, target)
        {
            if(this.isDraggingFill === true || this.isWorking === true)
                return;
            this.beginHitTest = target;
            this.updateDragFillStartRange();
            if(!this._dragFillStartRange)
                return;
            this.isWorking = true;
            this._dragStartRowViewport = target.rowViewportIndex;
            this._dragStartColumnViewport = target.colViewportIndex;
            this._dragToRowViewport = target.rowViewportIndex;
            this._dragToColumnViewport = target.colViewportIndex;
            this.updateDragStartRangeViewports();
            this._getHScrollTimer().start();
            this._getVScrollTimer().start()
        },
        updateDragStartRangeViewports: function()
        {
            var dragFillStartTopRow = this.dragFillStartTopRow();
            if(dragFillStartTopRow >= 0 && dragFillStartTopRow < this._sheet.frozenRowCount)
                this._dragFillStartTopRowViewport = 0;
            else if(dragFillStartTopRow >= this._sheet.frozenRowCount && dragFillStartTopRow <= this._sheet.getRowCount())
                this._dragFillStartTopRowViewport = 1;
            if(this.isDragFillWholeColumns())
                this._dragFillStartBottomRowViewport = 1;
            else
                this._dragFillStartBottomRowViewport = this._dragStartRowViewport;
            var dragFillStartLeftColumn = this.dragFillStartLeftColumn();
            if(dragFillStartLeftColumn >= 0 && dragFillStartLeftColumn < this._sheet.frozenColCount)
                this._dragFillStartLeftColumnViewport = 0;
            else if(dragFillStartLeftColumn >= this._sheet.frozenColCount && dragFillStartLeftColumn <= this._sheet.getColumnCount())
                this._dragFillStartLeftColumnViewport = 1;
            if(this.isDragFillWholeRows())
                this._dragFillStartRightColumnViewport = 1;
            else
                this._dragFillStartRightColumnViewport = this._dragStartColumnViewport
        },
        updateDragToViewports: function(e, x, y)
        {
            this.updateDragToRowViewport(e,x,y);
            this.updateDragToColumnViewport(e,x,y)
        },
        updateDragToRowViewport: function(e, x, y)
        {
            this._dragToRowViewport = this._dragStartRowViewport;
            var row = this._sheet._getRowIndex(y,this._dragToRowViewport);
            if(row === undefined || row === null || this._sheet._getRowLayout(this._dragToRowViewport).findRow(row) === null)
            {
                var startHitTestY = this._sheet._currentTarget.y;
                if(y < startHitTestY)
                {
                    if(this._dragToRow <= this._sheet.frozenRowCount)
                        this._dragToRowViewport = 0;
                    else if(this._dragToRow <= this._sheet.getRowCount())
                        this._dragToRowViewport = 1
                }
                else if(this._dragStartRowViewport === 0 && this._dragToRow >= this._sheet.frozenRowCount)
                    this._dragToRowViewport = 1
            }
        },
        updateDragToColumnViewport: function(e, x, y)
        {
            this._dragToColumnViewport = this._dragStartColumnViewport;
            var col = this._sheet._getColumnIndex(x,this._dragToColumnViewport);
            if(col === undefined || col === null || this._sheet._getColumnLayout(this._dragToColumnViewport).findCol(col) === null)
            {
                var startHitTestX = this._sheet._currentTarget.x;
                if(x < startHitTestX)
                {
                    if(this._dragToColumn <= this._sheet.frozenColCount)
                        this._dragToColumnViewport = 0;
                    else if(this._dragToColumn <= this._sheet.getColumnCount())
                        this._dragToColumnViewport = 1
                }
                else if(this._dragStartColumnViewport === 0 && this._dragToColumn >= this._sheet.frozenColCount)
                    this._dragToColumnViewport = 1
            }
        },
        continueDragFill: function(e, x, y)
        {
            var sheet = this._sheet;
            if(!this.beginHitTest)
                return;
            if(!this.isWorking || !this._dragFillStartRange)
                return;
            this.isDraggingFill = true;
            if(!this.beginHitTest.freezeInfo)
            {
                var freezeInfo = {
                        freezeTop: false,
                        freezeLeft: false
                    };
                if(this.beginHitTest.col < sheet._getFirstPageLeftColumn())
                    freezeInfo.freezeLeft = true;
                if(this.beginHitTest.row < sheet._getFirstPageTopRow())
                    freezeInfo.freezeTop = true;
                this.beginHitTest.freezeInfo = freezeInfo
            }
            this.continueCellDragFill(e,x,y)
        },
        continueCellDragFill: function(e, x, y)
        {
            var sheet = this._sheet;
            var self = this;
            var mousePosition = this.getMousePosition(e,x,y,GrapeCity.UI.SheetArea.viewport);
            if(!mousePosition)
                return;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            if(mousePosition.left)
            {
                if(!freezeLeft)
                    this._getHScrollTimer().setAction(function()
                    {
                        var firstPageLeftCol = sheet._getFirstPageLeftColumn();
                        var newLeftCol = sheet._getPrevVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol >= firstPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellDragFill(e,x,y)
                        }
                    })
            }
            else if(mousePosition.right)
                if(freezeLeft)
                {
                    sheet._setLeftColumn(sheet._getFirstPageLeftColumn());
                    this.beginHitTest.freezeInfo.freezeLeft = false
                }
                else
                    this._getHScrollTimer().setAction(function()
                    {
                        var lastPageLeftCol = sheet._getLastPageLeftColumn();
                        var newLeftCol = sheet._getNextVisualColumn(isNaN(sheet.frozenColCount) ? sheet._scrollLeftCol : Math.max(sheet._scrollLeftCol,sheet.frozenColCount));
                        if(newLeftCol <= lastPageLeftCol)
                        {
                            sheet._setLeftColumn(newLeftCol);
                            self.continueCellDragFill(e,x,y)
                        }
                    });
            if(mousePosition.top)
            {
                if(!freezeTop)
                    this._getVScrollTimer().setAction(function()
                    {
                        var firstPageTopRow = sheet._getFirstPageTopRow();
                        var newTopRow = sheet._getPrevVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(newTopRow >= firstPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellDragFill(e,x,y)
                        }
                    })
            }
            else if(mousePosition.bottom)
                if(freezeTop)
                {
                    sheet._setTopRow(sheet._getFirstPageTopRow());
                    this.beginHitTest.freezeInfo.freezeTop = false
                }
                else
                    this._getVScrollTimer().setAction(function()
                    {
                        var lastPageTopRow = sheet._getLastPageTopRow();
                        var newTopRow = sheet._getNextVisualRow(isNaN(sheet.frozenRowCount) ? sheet._scrollTopRow : Math.max(sheet._scrollTopRow,sheet.frozenRowCount));
                        if(newTopRow <= lastPageTopRow)
                        {
                            sheet._setTopRow(newTopRow);
                            self.continueCellDragFill(e,x,y)
                        }
                    });
            this._getHScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceX));
            this._getVScrollTimer().setInterval(this.getIntervalFromDistance(mousePosition.distanceY));
            this.updateDragFillRect(e,mousePosition.nearMouseX,mousePosition.nearMouseY)
        },
        updateDragFillRect: function(e, x, y)
        {
            this.updateDragToViewports(e,x,y);
            this.updateDragToCoordinates(e,x,y);
            if(this._dragToRow < 0 && this._dragToColumn < 0)
                return;
            this.updateCurrentFillSettings(e,x,y);
            this.updateCurrentFillRange();
            this.refreshDragFill()
        },
        refreshDragFill: function()
        {
            if($.browser.chrome || $.browser.safari)
            {
                var sheet = this._sheet;
                var ctx = sheet._render._getCtx();
                var bufferCtx = sheet._render._getBufferCtx();
                var bufferCtx2 = sheet._render._getBufferCtx2();
                var rg = this.getDragFillFrameRange();
                if(this._oldDragFillFrameRange)
                {
                    var rect = null;
                    if(rg.containsRange(this._oldDragFillFrameRange))
                        rect = sheet._getRangeRect(1,1,rg);
                    else
                        rect = sheet._getRangeRect(1,1,this._oldDragFillFrameRange);
                    rect.x -= 2;
                    rect.y -= 2;
                    rect.width += 4;
                    rect.height += 4;
                    sheet._render._copyDoubleBufferRect(rect,null,null,null,bufferCtx,bufferCtx2)
                }
                if(rg)
                {
                    var rect = sheet._getRangeRect(1,1,rg);
                    this.refreshSelectionBorder(bufferCtx2);
                    sheet._render.paintDragRectangle(bufferCtx2,rect);
                    if(!this._oldDragFillFrameRange || rg.containsRange(this._oldDragFillFrameRange))
                        rect = sheet._getRangeRect(1,1,rg);
                    else
                        rect = sheet._getRangeRect(1,1,this._oldDragFillFrameRange);
                    rect.x -= 2;
                    rect.y -= 2;
                    rect.width += 4;
                    rect.height += 4;
                    sheet._render._copyDoubleBufferRect(rect,null,null,null,bufferCtx2,ctx)
                }
                this._oldDragFillFrameRange = rg
            }
            else
            {
                this.clearDragFill();
                this.refreshSelectionBorder();
                this.paintDragFill();
                this._oldDragFillFrameRange = this.getDragFillFrameRange()
            }
        },
        clearDragFill: function()
        {
            var sheet = this._sheet;
            if(this._oldDragFillFrameRange)
            {
                var oldDragFillRect = sheet._getRangeRect(1,1,this._oldDragFillFrameRange);
                oldDragFillRect.x -= 2;
                oldDragFillRect.y -= 2;
                oldDragFillRect.width += 4;
                oldDragFillRect.height += 4;
                sheet._render._copyDoubleBufferRect(oldDragFillRect)
            }
        },
        refreshSelectionBorder: function(ctx)
        {
            var sheet = this._sheet;
            sheet._render.repaintSelection(this._dragFillStartRange,null,ctx)
        },
        paintDragFill: function()
        {
            var sheet = this._sheet;
            var render = sheet._render;
            var dragFillFrameRange = this.getDragFillFrameRange();
            if(!dragFillFrameRange)
                return;
            var ctx = render._getCtx();
            var layout = sheet._getSheetLayout();
            for(var r = 0; r < 2; r++)
                for(var c = 0; c < 2; c++)
                {
                    var dragFillRect = sheet._getRangeRect(r,c,dragFillFrameRange);
                    var clipRect = layout.viewportRect(r,c);
                    ctx.save();
                    ctx.rect(clipRect.x,clipRect.y,clipRect.width,clipRect.height);
                    ctx.clip();
                    ctx.beginPath();
                    render.paintDragRectangle(ctx,dragFillRect);
                    ctx.beginPath();
                    ctx.restore()
                }
        },
        updateCurrentFillRange: function()
        {
            this._currentFillRange = this.getCurrentFillRange()
        },
        isDragFillWholeRows: function()
        {
            return this._dragFillStartRange.col === -1 && this._dragFillStartRange.row !== -1
        },
        isDragFillWholeColumns: function()
        {
            return this._dragFillStartRange.row === -1 && this._dragFillStartRange.col !== -1
        },
        isDragClear: function()
        {
            return this._currentFillDirection === GrapeCity.UI.DragFillDirection.LeftClear || this._currentFillDirection === GrapeCity.UI.DragFillDirection.UpClear
        },
        getCurrentFillRange: function()
        {
            var row = -1,
                column = -1,
                rowCount = -1,
                columnCount = -1;
            switch(this._currentFillDirection)
            {
                case GrapeCity.UI.DragFillDirection.Left:
                    if(this.isDragFillWholeColumns())
                    {
                        row = -1;
                        rowCount = -1
                    }
                    else
                    {
                        row = this.dragFillStartTopRow();
                        rowCount = this._dragFillStartRange.rowCount
                    }
                    column = this._dragToColumn;
                    columnCount = this.dragFillStartLeftColumn() - column;
                    break;
                case GrapeCity.UI.DragFillDirection.Right:
                    if(this.isDragFillWholeColumns())
                    {
                        row = -1;
                        rowCount = -1
                    }
                    else
                    {
                        row = this.dragFillStartTopRow();
                        rowCount = this._dragFillStartRange.rowCount
                    }
                    column = this.dragFillStartRightColumn() + 1;
                    columnCount = this._dragToColumn - column + 1;
                    break;
                case GrapeCity.UI.DragFillDirection.Up:
                    row = this._dragToRow;
                    rowCount = this.dragFillStartTopRow() - row;
                    if(this.isDragFillWholeRows())
                    {
                        column = -1;
                        columnCount = -1
                    }
                    else
                    {
                        column = this.dragFillStartLeftColumn();
                        columnCount = this._dragFillStartRange.colCount
                    }
                    break;
                case GrapeCity.UI.DragFillDirection.Down:
                    row = this.dragFillStartBottomRow() + 1;
                    rowCount = this._dragToRow - row + 1;
                    if(this.isDragFillWholeRows())
                    {
                        column = -1;
                        columnCount = -1
                    }
                    else
                    {
                        column = this.dragFillStartLeftColumn();
                        columnCount = this._dragFillStartRange.colCount
                    }
                    break;
                case GrapeCity.UI.DragFillDirection.UpClear:
                    row = this._dragToRow;
                    rowCount = this.dragFillStartBottomRow() - row + 1;
                    if(this.isDragFillWholeRows())
                    {
                        column = -1;
                        columnCount = -1
                    }
                    else
                    {
                        column = this.dragFillStartLeftColumn();
                        columnCount = this._dragFillStartRange.colCount
                    }
                    break;
                case GrapeCity.UI.DragFillDirection.LeftClear:
                    if(this.isDragFillWholeColumns())
                    {
                        row = -1;
                        rowCount = -1
                    }
                    else
                    {
                        row = this._dragFillStartRange.row;
                        rowCount = this._dragFillStartRange.rowCount
                    }
                    column = this._dragToColumn;
                    columnCount = this.dragFillStartRightColumn() - column + 1;
                    break;
                default:
                    break
            }
            return new GrapeCity.UI.Range(row,column,rowCount,columnCount)
        },
        updateDragToCoordinates: function(e, x, y)
        {
            var sheet = this._sheet;
            var target = sheet.hitTest(x,y,true);
            if(target.row === null || target.col === null)
                return;
            var lastFullyVisibleRow = sheet._getLastFullyVisibleRow();
            var lastFullyVisibleColumn = sheet._getLastFullyVisibleColumn();
            var lastVisualRow = sheet._getLastVisualRow();
            var lastVisualColumn = sheet._getLastVisualColumn();
            if(target.row > lastFullyVisibleRow && lastFullyVisibleRow < lastVisualRow)
                this._dragToRow = sheet._getPrevVisualRow(target.row);
            else
                this._dragToRow = target.row;
            if(target.col > lastFullyVisibleColumn && lastFullyVisibleColumn < lastVisualColumn)
                this._dragToColumn = sheet._getPrevVisualColumn(target.col);
            else
                this._dragToColumn = target.col
        },
        dragFillStartBottomRowLayout: function()
        {
            var dragStartBottomRow = this.dragFillStartBottomRow();
            if(dragStartBottomRow !== -1)
                return this._sheet._getRowLayout(this._dragFillStartBottomRowViewport).findRow(dragStartBottomRow);
            return null
        },
        dragFillToViewportBottomRowLayout: function()
        {
            return this._sheet._getRowLayout(this._dragToRowViewport).findRow(this.dragFillToViewportBottomRow())
        },
        dragFillToViewportBottomRow: function()
        {
            return this._sheet.getViewportBottomRow(this._dragToRowViewport)
        },
        dragFillStartRightColumnLayout: function()
        {
            var dragStartRightColumn = this.dragFillStartRightColumn();
            if(dragStartRightColumn !== -1)
                return this._sheet._getColumnLayout(this._dragFillStartRightColumnViewport).findCol(dragStartRightColumn);
            return null
        },
        dragFillToViewportRightColumnLayout: function()
        {
            return this._sheet._getColumnLayout(this._dragToColumnViewport).findCol(this.dragFillToViewportRightColumn())
        },
        dragFillToViewportRightColumn: function()
        {
            return this._sheet.getViewportRightColumn(this._dragToColumnViewport)
        },
        updateCurrentFillSettings: function(e, x, y)
        {
            var isWholeRows = this.isDragFillWholeRows(),
                isWholeColumns = this.isDragFillWholeColumns();
            var t = $(this._sheet._getCanvas()).offset();
            var actualX = e.pageX - t.left,
                actualY = e.pageY - t.top,
                notClear = false;
            var hOffset,
                vOffset;
            if(!isWholeRows && !isWholeColumns)
            {
                if(this._dragToRow >= this.dragFillStartTopRow() && this._dragToRow <= this.dragFillStartBottomRow())
                {
                    if(this._dragToColumn >= this.dragFillStartLeftColumn() && this._dragToColumn <= this.dragFillStartRightColumn())
                    {
                        hOffset = Math.abs(this._dragToColumn - this.dragFillStartRightColumn());
                        vOffset = Math.abs(this._dragToRow - this.dragFillStartBottomRow());
                        if(vOffset > hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.UpClear;
                        else if(vOffset < hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.LeftClear;
                        else
                        {
                            var dragFillStartBottomRowLayout = this.dragFillStartBottomRowLayout();
                            if(!dragFillStartBottomRowLayout)
                                dragFillStartBottomRowLayout = this.dragFillToViewportBottomRowLayout();
                            if(y > dragFillStartBottomRowLayout.y + dragFillStartBottomRowLayout.height)
                                this._currentFillDirection = GrapeCity.UI.DragFillDirection.Down;
                            else
                            {
                                var dragFillStartRightColumnLayout = this.dragFillStartRightColumnLayout();
                                if(!dragFillStartRightColumnLayout)
                                    dragFillStartRightColumnLayout = this.dragFillToViewportRightColumnLayout();
                                var hDistance = dragFillStartRightColumnLayout.x + dragFillStartRightColumnLayout.width - x;
                                var vDistance = dragFillStartBottomRowLayout.y + dragFillStartBottomRowLayout.height - y;
                                if(actualX >= dragFillStartRightColumnLayout.x && actualX <= dragFillStartRightColumnLayout.x + dragFillStartRightColumnLayout.width && actualY >= dragFillStartBottomRowLayout.y && actualY <= dragFillStartBottomRowLayout.y + dragFillStartBottomRowLayout.height)
                                    if(hDistance >= vDistance)
                                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.LeftClear;
                                    else
                                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.UpClear;
                                else
                                    notClear = true
                            }
                        }
                    }
                    else if(this._dragToColumn < this.dragFillStartLeftColumn())
                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.Left;
                    else if(this._dragToColumn > this.dragFillStartRightColumn())
                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.Right
                }
                else if(this._dragToRow < this.dragFillStartTopRow())
                {
                    if(this._dragToColumn >= this.dragFillStartLeftColumn() && this._dragToColumn <= this.dragFillStartRightColumn())
                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.Up;
                    else if(this._dragToColumn < this.dragFillStartLeftColumn())
                    {
                        hOffset = Math.abs(this._dragToColumn - this.dragFillStartLeftColumn());
                        vOffset = Math.abs(this._dragToRow - this.dragFillStartTopRow());
                        if(vOffset >= hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Up;
                        else
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Left
                    }
                    else if(this._dragToColumn > this.dragFillStartRightColumn())
                    {
                        hOffset = Math.abs(this._dragToColumn - this.dragFillStartRightColumn());
                        vOffset = Math.abs(this._dragToRow - this.dragFillStartTopRow());
                        if(vOffset >= hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Up;
                        else
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Right
                    }
                }
                else if(this._dragToRow > this.dragFillStartBottomRow())
                    if(this._dragToColumn >= this.dragFillStartLeftColumn() && this._dragToColumn <= this.dragFillStartRightColumn())
                        this._currentFillDirection = GrapeCity.UI.DragFillDirection.Down;
                    else if(this._dragToColumn < this.dragFillStartLeftColumn())
                    {
                        hOffset = Math.abs(this._dragToColumn - this.dragFillStartLeftColumn());
                        vOffset = Math.abs(this._dragToRow - this.dragFillStartBottomRow());
                        if(vOffset >= hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Down;
                        else
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Left
                    }
                    else if(this._dragToColumn > this.dragFillStartRightColumn())
                    {
                        hOffset = Math.abs(this._dragToColumn - this.dragFillStartRightColumn());
                        vOffset = Math.abs(this._dragToRow - this.dragFillStartBottomRow());
                        if(vOffset >= hOffset)
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Down;
                        else
                            this._currentFillDirection = GrapeCity.UI.DragFillDirection.Right
                    }
            }
            else if(isWholeColumns)
            {
                if(this._dragToColumn >= this.dragFillStartLeftColumn() && this._dragToColumn <= this.dragFillStartRightColumn())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.LeftClear;
                else if(this._dragToColumn < this.dragFillStartLeftColumn())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.Left;
                else if(this._dragToColumn > this.dragFillStartRightColumn())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.Right
            }
            else if(isWholeRows)
                if(this._dragToRow >= this.dragFillStartTopRow() && this._dragToRow <= this.dragFillStartBottomRow())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.UpClear;
                else if(this._dragToRow < this.dragFillStartTopRow())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.Up;
                else if(this._dragToRow > this.dragFillStartBottomRow())
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.Down;
            var rect = this._sheet._dragFillIndicatorRect;
            if(rect)
            {
                var currentRow = this.dragFillStartBottomRow(),
                    currentColumn = this.dragFillStartRightColumn(),
                    nextRow = currentRow + 1,
                    nextColumn = currentColumn + 1;
                var currentRowHieght = this._sheet.getRowHeight(currentRow,GrapeCity.UI.SheetArea.viewport),
                    currentColumnWidth = this._sheet.getColumnWidth(currentColumn,GrapeCity.UI.SheetArea.viewport),
                    nextRowHeight = this._sheet.getRowHeight(nextRow,GrapeCity.UI.SheetArea.viewport),
                    nextColumnWidth = this._sheet.getColumnWidth(nextColumn,GrapeCity.UI.SheetArea.viewport);
                var minX = rect.x + rect.width / 2 - Math.min(10,currentColumnWidth / 2),
                    maxX = rect.x + rect.width / 2 + Math.min(10,nextColumnWidth / 2),
                    minY = rect.y + rect.height / 2 - Math.min(10,currentRowHieght / 2),
                    maxY = rect.y + rect.height / 2 + Math.min(10,nextRowHeight / 2);
                var isAroundIndicator = false;
                if(!isWholeRows && !isWholeColumns)
                    isAroundIndicator = minX <= actualX && actualX <= maxX && minY <= actualY && actualY <= maxY;
                else if(isWholeColumns)
                    isAroundIndicator = minX <= actualX && actualX <= maxX;
                else if(isWholeRows)
                    isAroundIndicator = minY <= actualY && actualY <= maxY;
                if(isAroundIndicator || notClear)
                {
                    this._isDragAroundIndicator = true;
                    this._currentFillDirection = GrapeCity.UI.DragFillDirection.LeftClear
                }
                else
                    this._isDragAroundIndicator = false
            }
        },
        dragFillStartTopRow: function()
        {
            if(!this._dragFillStartRange)
                return-1;
            else if(this._dragFillStartRange.row === -1)
                return 0;
            else
                return this._dragFillStartRange.row
        },
        dragFillStartBottomRow: function()
        {
            if(!this._dragFillStartRange)
                return-1;
            else if(this._dragFillStartRange.row === -1)
                return this._sheet.getRowCount() - 1;
            else
                return this._dragFillStartRange.row + this._dragFillStartRange.rowCount - 1
        },
        dragFillStartLeftColumn: function()
        {
            if(!this._dragFillStartRange)
                return-1;
            else if(this._dragFillStartRange.col === -1)
                return 0;
            else
                return this._dragFillStartRange.col
        },
        dragFillStartRightColumn: function()
        {
            if(!this._dragFillStartRange)
                return-1;
            else if(this._dragFillStartRange.col === -1)
                return this._sheet.getColumnCount() - 1;
            else
                return this._dragFillStartRange.col + this._dragFillStartRange.colCount - 1
        },
        endDragFill: function(e)
        {
            this.beginHitTest = null;
            this._getHScrollTimer().stop();
            this._getVScrollTimer().stop();
            if(!this.isDraggingFill || !this.isWorking)
            {
                this.resetDragFill();
                return
            }
            this.isDraggingFill = false;
            this.isWorking = false;
            var wholeFillRange = this.getDragFillFrameRange();
            if(!wholeFillRange)
                return;
            var canDragFill = this.validateFillRange(wholeFillRange);
            if(!canDragFill || this._isDragAroundIndicator)
            {
                this.resetDragFill();
                this.refreshSelection(wholeFillRange)
            }
            else
            {
                var autoFillType = this.getDragAutoFillType();
                var cancel = this.executeDragFillAction(this._currentFillRange,autoFillType);
                if(!cancel && this.isDragFill())
                    this.showDragFillSmartTag(autoFillType);
                else
                    this.refreshSelection(wholeFillRange);
                this.resetDragFill()
            }
        },
        showDragFillSmartTag: function(autoFillType)
        {
            var sheet = this._sheet;
            var rect = sheet._dragFillIndicatorRect;
            var fillInfo = {
                    x: rect.x + rect.width,
                    y: rect.y + rect.height,
                    fillType: autoFillType
                };
            sheet._smartTag = new GrapeCity.UI._GcFillDialog(sheet,fillInfo);
            sheet._smartTag.open()
        },
        updateDragFillStartRange: function()
        {
            var sheet = this._sheet;
            if(sheet._selectionModel.length === 1)
                this._dragFillStartRange = sheet._selectionModel[0];
            else if(sheet._activeRowIndex >= 0 && sheet._activeColIndex >= 0)
                this._dragFillStartRange = new GrapeCity.UI.Range(sheet._activeRowIndex,sheet._activeColIndex,1,1)
        },
        resetDragFill: function()
        {
            this.isWorking = false;
            this.isDraggingFill = false
        },
        refreshSelection: function(range)
        {
            this._sheet._render.repaintSelection(range)
        },
        getDragAutoFillType: function()
        {
            if(this.isDragClear())
                return GrapeCity.UI.AutoFillType.ClearValues;
            var isDragSingleCell = this._dragFillStartRange.rowCount === 1 && this._dragFillStartRange.colCount === 1 && !this.isDragFillWholeColumns() && !this.isDragFillWholeRows();
            if(isDragSingleCell)
                if(this.isControlPressed)
                    return GrapeCity.UI.AutoFillType.FillSeries;
                else
                    return GrapeCity.UI.AutoFillType.CopyCells;
            else if(this.isControlPressed)
                return GrapeCity.UI.AutoFillType.CopyCells;
            else
                return GrapeCity.UI.AutoFillType.FillSeries
        },
        getDragFillFrameRange: function()
        {
            if(!this._dragFillStartRange)
                return null;
            if(this.isDragClear())
                return this._dragFillStartRange;
            if(!this._currentFillRange)
                return null;
            var row = 0,
                rowCount = 0,
                column = 0,
                columnCount = 0;
            if(this.isVerticalDragFill())
            {
                row = this._currentFillDirection === GrapeCity.UI.DragFillDirection.Up ? this._currentFillRange.row : this._dragFillStartRange.row;
                rowCount = this._dragFillStartRange.rowCount + this._currentFillRange.rowCount;
                column = this._dragFillStartRange.col;
                columnCount = this._dragFillStartRange.colCount
            }
            else
            {
                row = this._dragFillStartRange.row;
                rowCount = this._dragFillStartRange.rowCount;
                column = this._currentFillDirection === GrapeCity.UI.DragFillDirection.Left ? this._currentFillRange.col : this._dragFillStartRange.col;
                columnCount = this._dragFillStartRange.colCount + this._currentFillRange.colCount
            }
            return new GrapeCity.UI.Range(row,column,rowCount,columnCount)
        },
        validateFillRange: function(fillRange)
        {
            var sheet = this._sheet;
            var canDragFill = true;
            var invalidMessage = "";
            if(sheet._hasSpans(fillRange.row,fillRange.col,fillRange.rowCount,fillRange.colCount))
            {
                canDragFill = false;
                invalidMessage = "Can not fill range that contains merged cell."
            }
            if(canDragFill && sheet.isProtected)
                if(sheet._isAnyCellInRangeLocked(fillRange))
                {
                    canDragFill = false;
                    invalidMessage = "The cells you are trying to fill is protected and therefore read-only."
                }
            if(!canDragFill)
                sheet._raiseInvalidOperation(invalidMessage);
            return canDragFill
        },
        executeDragFillAction: function(fillRange, autoFillType)
        {
            var sheet = this._sheet;
            var savedRange = sheet._getActualRange(fillRange);
            this._preFillCellsInfo = new GrapeCity.UI.CopyMoveCellsInfo(savedRange.rowCount,savedRange.colCount);
            GrapeCity.UI.CopyMoveHelper.saveViewportInfo(sheet,this._preFillCellsInfo,savedRange.row,savedRange.col,GrapeCity.UI.CopyToOption.All);
            var dragFillExtent = {
                    startRange: this._dragFillStartRange,
                    fillRange: fillRange,
                    autoFillType: autoFillType,
                    fillDirection: this.getCurrentFillDirection()
                };
            var cancel = sheet._raiseDragFillBlock(dragFillExtent.fillRange,dragFillExtent.fillDirection,dragFillExtent.autoFillType);
            if(!cancel)
            {
                var dragFillUndoAction = new GrapeCity.UI.UndoRedo.DragFillUndoAction(sheet,dragFillExtent);
                sheet.doCommand(dragFillUndoAction);
                sheet._raiseDragFillBlockCompleted(dragFillExtent.fillRange,dragFillExtent.fillDirection,dragFillExtent.autoFillType);
                return false
            }
            return true
        },
        isDragFill: function()
        {
            return this.isIncreaseFill() || this.isDecreaseFill()
        },
        isIncreaseFill: function()
        {
            return this._currentFillDirection === GrapeCity.UI.DragFillDirection.Down || this._currentFillDirection === GrapeCity.UI.DragFillDirection.Right
        },
        isDecreaseFill: function()
        {
            return this._currentFillDirection === GrapeCity.UI.DragFillDirection.Left || this._currentFillDirection === GrapeCity.UI.DragFillDirection.Up
        },
        isVerticalDragFill: function()
        {
            return this._currentFillDirection === GrapeCity.UI.DragFillDirection.Up || this._currentFillDirection === GrapeCity.UI.DragFillDirection.Down || this._currentFillDirection === GrapeCity.UI.DragFillDirection.UpClear
        },
        isDragToRowInView: function()
        {
            return this.isRowInViewport(this._dragToRowViewport,this._dragToRow)
        },
        isRowInViewport: function(rowViewport, row)
        {
            var viewportTopRow = this._sheet.getViewportTopRow(rowViewport);
            var viewportBottomRow = this._sheet.getViewportBottomRow(rowViewport);
            if(row >= viewportTopRow && row <= viewportBottomRow)
                return true;
            else
                return false
        },
        getCurrentDragToRowLayout: function()
        {
            return this._sheet._getRowLayout(this._dragToRowViewport).findRow(this._dragToRow)
        },
        isDragFillStartBottomRowInView: function()
        {
            return this.isRowInViewport(this._dragFillStartBottomRowViewport,this.dragFillStartBottomRow())
        },
        dragFillStartViewportBottomRowLayout: function()
        {
            return this._sheet._getRowLayout(this._dragStartRowViewport).findRow(this.dragFillStartViewportBottomRow())
        },
        dragFillStartViewportBottomRow: function()
        {
            return this._sheet.getViewportBottomRow(this._dragStartRowViewport)
        },
        getValidVerDragToRowLayout: function()
        {
            var rowLayout;
            if(this.isIncreaseFill())
                if(this.isDragToRowInView())
                    rowLayout = this.getCurrentDragToRowLayout();
                else
                    rowLayout = this.dragFillToViewportBottomRowLayout();
            else if(this.isDragFillStartBottomRowInView)
                rowLayout = this.dragFillStartBottomRowLayout();
            else
                rowLayout = this.dragFillStartViewportBottomRowLayout();
            return rowLayout
        },
        isDragToColumnInView: function()
        {
            return this.isColumnInViewport(this._dragToColumnViewport,this._dragToColumn)
        },
        isColumnInViewport: function(columnViewport, column)
        {
            var viewportLeftColumn = this._sheet.getViewportLeftColumn(columnViewport);
            var viewportRightColumn = this._sheet.getViewportRightColumn(columnViewport);
            if(column >= viewportLeftColumn && column <= viewportRightColumn)
                return true;
            else
                return false
        },
        getCurrentDragToColumnLayout: function()
        {
            return this._sheet._getColumnLayout(this._dragToColumnViewport).findCol(this._dragToColumn)
        },
        isDragFillStartRightColumnInView: function()
        {
            return this.isColumnInViewport(this._dragFillStartRightColumnViewport,this.dragFillStartRightColumn())
        },
        dragFillStartViewportRightColumnLayout: function()
        {
            return this._sheet._getColumnLayout(this._dragStartColumnViewport).findCol(this.dragFillStartViewportRightColumn())
        },
        dragFillStartViewportRightColumn: function()
        {
            return this._sheet.getViewportRightColumn(this._dragStartColumnViewport)
        },
        getValidHorDragToColumnLayout: function()
        {
            var columnLayout;
            if(this.isIncreaseFill())
                if(this.isDragToColumnInView())
                    columnLayout = this.getCurrentDragToColumnLayout();
                else
                    columnLayout = this.dragFillToViewportRightColumnLayout();
            else if(this.isDragFillStartRightColumnInView())
                columnLayout = this.dragFillStartRightColumnLayout();
            else
                columnLayout = this.dragFillStartViewportRightColumnLayout();
            return columnLayout
        },
        dragFillToViewportTopRowLayout: function()
        {
            return this._sheet._getRowLayout(this._dragToRowViewport).findRow(this.dragFillToViewportTopRow())
        },
        dragFillToViewportTopRow: function()
        {
            return this._sheet.getViewportTopRow(this._dragToRowViewport)
        },
        dragFillToViewportLeftColumnLayout: function()
        {
            return this._sheet._getColumnLayout(this._dragToColumnViewport).findCol(this.dragFillToViewportLeftColumn())
        },
        dragFillToViewportLeftColumn: function()
        {
            return this._sheet.getViewportLeftColumn(this._dragToColumnViewport)
        },
        getCurrentFillDirection: function()
        {
            switch(this._currentFillDirection)
            {
                case GrapeCity.UI.DragFillDirection.Left:
                    return GrapeCity.UI.FillDirection.Left;
                case GrapeCity.UI.DragFillDirection.Right:
                    return GrapeCity.UI.FillDirection.Right;
                case GrapeCity.UI.DragFillDirection.Up:
                    return GrapeCity.UI.FillDirection.Up;
                case GrapeCity.UI.DragFillDirection.Down:
                    return GrapeCity.UI.FillDirection.Down;
                case GrapeCity.UI.DragFillDirection.LeftClear:
                    return GrapeCity.UI.FillDirection.Left;
                case GrapeCity.UI.DragFillDirection.UpClear:
                    return GrapeCity.UI.FillDirection.Up;
                default:
                    break
            }
            return GrapeCity.UI.FillDirection.Down
        },
        getMousePosition: function(e, x, y, sheetArea)
        {
            var mousePosition = null;
            if(sheetArea === GrapeCity.UI.SheetArea.viewport)
            {
                var viewPortRect = this.getViewPortRect();
                mousePosition = this.createMousePosition(e,x,y,viewPortRect)
            }
            else if(sheetArea === GrapeCity.UI.SheetArea.rowHeader)
            {
                var rowHeaderRect = this.getRowHeaderRect();
                mousePosition = this.createMousePosition(e,x,y,rowHeaderRect)
            }
            else if(sheetArea === GrapeCity.UI.SheetArea.colHeader)
            {
                var colHeaderRect = this.getColHeaderRect();
                mousePosition = this.createMousePosition(e,x,y,colHeaderRect)
            }
            return mousePosition
        },
        getViewPortRect: function()
        {
            var sheet = this._sheet;
            var sheetLayout = sheet._getSheetLayout();
            var cls = sheet._getColumnLayout(1,GrapeCity.UI.SheetArea.viewport);
            var rls = sheet._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
            var viewPortRect = null;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            if(freezeLeft && freezeTop)
                viewPortRect = new GrapeCity.UI.Rect(sheetLayout.x + sheetLayout.rowHeaderWidth,sheetLayout.y + sheetLayout.colHeaderHeight,sheetLayout.frozenWidth,sheetLayout.frozenHeight);
            else if(!freezeLeft && freezeTop)
                viewPortRect = new GrapeCity.UI.Rect(sheetLayout.viewportX,sheetLayout.y + sheetLayout.colHeaderHeight,sheetLayout.viewportWidth,sheetLayout.frozenHeight);
            else if(freezeLeft && !freezeTop)
                viewPortRect = new GrapeCity.UI.Rect(sheetLayout.x + sheetLayout.rowHeaderWidth,sheetLayout.viewportY,sheetLayout.frozenWidth,sheetLayout.viewportHeight);
            else if(!freezeLeft && !freezeTop)
                viewPortRect = new GrapeCity.UI.Rect(sheetLayout.viewportX,sheetLayout.viewportY,sheetLayout.viewportWidth,sheetLayout.viewportHeight);
            if(sheet._scrollLeftCol <= sheet._getFirstPageLeftColumn())
            {
                viewPortRect.x = sheetLayout.x + sheetLayout.rowHeaderWidth;
                viewPortRect.width = sheetLayout.width - viewPortRect.x
            }
            if(sheet._scrollTopRow <= sheet._getFirstPageTopRow())
            {
                viewPortRect.y = sheetLayout.y + sheetLayout.colHeaderHeight;
                viewPortRect.height = sheetLayout.height - viewPortRect.y
            }
            if(sheet._scrollLeftCol >= sheet._getLastPageLeftColumn() && !freezeLeft && cls.length > 0)
                viewPortRect.width = cls[cls.length - 1].x + cls[cls.length - 1].width - viewPortRect.x;
            if(sheet._scrollTopRow >= sheet._getLastPageTopRow() && !freezeTop && rls.length > 0)
                viewPortRect.height = rls[rls.length - 1].y + rls[rls.length - 1].height - viewPortRect.y;
            return viewPortRect
        },
        getRowHeaderRect: function()
        {
            var sheet = this._sheet;
            var sheetLayout = sheet._getSheetLayout();
            var rls = sheet._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
            var rowHeaderRect = null;
            var freezeTop = this.beginHitTest.freezeInfo.freezeTop;
            if(freezeTop)
                rowHeaderRect = new GrapeCity.UI.Rect(sheetLayout.headerX,sheetLayout.headerY,sheetLayout.rowHeaderWidth,sheetLayout.frozenHeight);
            else
                rowHeaderRect = new GrapeCity.UI.Rect(sheetLayout.headerX,sheetLayout.viewportY,sheetLayout.rowHeaderWidth,sheetLayout.viewportHeight);
            if(sheet._scrollTopRow === sheet._getFirstPageTopRow())
            {
                rowHeaderRect.y = sheetLayout.headerY + sheetLayout.colHeaderHeight;
                rowHeaderRect.height = sheetLayout.height - rowHeaderRect.y
            }
            if(sheet._scrollTopRow >= sheet._getLastPageTopRow() && !freezeTop && rls.length > 0)
                rowHeaderRect.height = rls[rls.length - 1].y + rls[rls.length - 1].height - rowHeaderRect.y;
            return rowHeaderRect
        },
        getColHeaderRect: function()
        {
            var sheet = this._sheet;
            var sheetLayout = sheet._getSheetLayout();
            var cls = sheet._getColumnLayout(1,GrapeCity.UI.SheetArea.viewport);
            var columnHeaderRect = null;
            var freezeLeft = this.beginHitTest.freezeInfo.freezeLeft;
            if(freezeLeft)
                columnHeaderRect = new GrapeCity.UI.Rect(sheetLayout.headerX,sheetLayout.headerY,sheetLayout.frozenWidth,sheetLayout.colHeaderHeight);
            else
                columnHeaderRect = new GrapeCity.UI.Rect(sheetLayout.viewportX,sheetLayout.headerY,sheetLayout.viewportWidth,sheetLayout.colHeaderHeight);
            if(sheet._scrollLeftCol === sheet._getFirstPageLeftColumn())
            {
                columnHeaderRect.x = sheetLayout.headerX + sheetLayout.rowHeaderWidth;
                columnHeaderRect.width = sheetLayout.width - columnHeaderRect.x
            }
            if(sheet._scrollLeftCol >= sheet._getLastPageLeftColumn() && !freezeLeft && cls.length > 0)
                columnHeaderRect.width = cls[cls.length - 1].x + cls[cls.length - 1].width - columnHeaderRect.x;
            return columnHeaderRect
        },
        createMousePosition: function(e, x, y, rect)
        {
            var mousePosition = {
                    top: false,
                    bottom: false,
                    left: false,
                    right: false,
                    distanceX: null,
                    distanceY: null,
                    nearMouseX: x,
                    nearMouseY: y
                };
            if(x <= rect.x)
                mousePosition.left = true;
            else if(x >= rect.x + rect.width)
                mousePosition.right = true;
            if(y <= rect.y)
                mousePosition.top = true;
            else if(y >= rect.y + rect.height)
                mousePosition.bottom = true;
            if(mousePosition.left)
            {
                mousePosition.distanceX = rect.x - x;
                mousePosition.nearMouseX = rect.x + 0.5
            }
            else if(mousePosition.right)
            {
                mousePosition.distanceX = x - rect.x - rect.width;
                mousePosition.nearMouseX = rect.x + rect.width - 0.5
            }
            if(mousePosition.top)
            {
                mousePosition.distanceY = rect.y - y;
                mousePosition.nearMouseY = rect.y + 0.5
            }
            else if(mousePosition.bottom)
            {
                mousePosition.distanceY = y - rect.y - rect.height;
                mousePosition.nearMouseY = rect.y + rect.height - 0.5
            }
            return mousePosition
        },
        getIntervalFromDistance: function(distance)
        {
            var interval = -1;
            if(!isNaN(distance) && distance > 0)
            {
                interval = Math.ceil(500 / distance);
                interval = Math.max(20,interval * 10);
                if(interval > 200)
                    interval = 200
            }
            return interval
        },
        updateRange: function(row, col, rowCount, colCount)
        {
            if(rowCount === 0 || colCount === 0)
                return;
            var sheet = this._sheet;
            var viewport = GrapeCity.UI.SheetArea.viewport;
            var frozRowLayoutModel = sheet._getRowLayout(0,viewport);
            var frozColLayoutModel = sheet._getColumnLayout(0,viewport);
            var rowLayoutModel = sheet._getRowLayout(1,viewport);
            var colLayoutModel = sheet._getColumnLayout(1,viewport);
            var maxCol = 0;
            if(frozColLayoutModel && frozColLayoutModel.length > 0)
                maxCol = frozColLayoutModel[frozColLayoutModel.length - 1].col;
            if(colLayoutModel && colLayoutModel.length > 0)
                maxCol = colLayoutModel[colLayoutModel.length - 1].col;
            var y = this.getYForRow(row,col,rowCount,colCount,true,maxCol,frozRowLayoutModel,rowLayoutModel);
            var y2 = this.getYForRow(row,col,rowCount,colCount,false,maxCol,frozRowLayoutModel,rowLayoutModel);
            var maxRow = 0;
            if(frozRowLayoutModel && frozRowLayoutModel.length > 0)
                maxRow = frozRowLayoutModel[frozRowLayoutModel.length - 1].row;
            if(rowLayoutModel && rowLayoutModel.length > 0)
                maxRow = rowLayoutModel[rowLayoutModel.length - 1].row;
            var x = this.getXForCol(row,col,rowCount,colCount,true,maxRow,frozColLayoutModel,colLayoutModel);
            var x2 = this.getXForCol(row,col,rowCount,colCount,false,maxRow,frozColLayoutModel,colLayoutModel);
            var layout = sheet._getSheetLayout();
            if(x2 > x && y2 > y)
                sheet._render.update(x - layout.headerX - 2,y - layout.headerY - 2,x2 - x + 2 * layout.headerX + 2,y2 - y + 2 * layout.headerY + 2);
            if(y2 > y)
                sheet._render.update(layout.headerX,y,layout.rowHeaderWidth,y2 - y);
            if(x2 > x)
            {
                sheet._render.update(x,layout.headerY,x2 - x,layout.colHeaderHeight);
                sheet._render.update(x,layout.footerY,x2 - x,layout.colHeaderHeight)
            }
        },
        getYForRow: function(row, col, rowCount, colCount, bTop, maxCol, frozRowLayoutModel, rowLayoutModel)
        {
            var sheet = this._sheet;
            var trow = row;
            if(!bTop)
                trow = row + rowCount - 1;
            if(trow < sheet.frozenRowCount)
            {
                if(frozRowLayoutModel.length < 1)
                    return-1
            }
            else
            {
                if(rowLayoutModel.length < 1)
                    return-1;
                if(bTop)
                {
                    if(trow < rowLayoutModel[0].row)
                        trow = rowLayoutModel[0].row
                }
                else if(trow > rowLayoutModel[rowLayoutModel.length - 1].row)
                    trow = rowLayoutModel[rowLayoutModel.length - 1].row
            }
            var y = 0;
            if(bTop)
                y = 90000;
            for(var c = Math.max(sheet._scrollLeftCol,col); c < col + colCount && c <= maxCol; c++)
            {
                var rect = sheet.getCellRect(trow,c);
                if(rect)
                    if(bTop)
                    {
                        if(rect.y < y)
                            y = rect.y
                    }
                    else if(y < rect.y + rect.height)
                        y = rect.y + rect.height
            }
            return y
        },
        getXForCol: function(row, col, rowCount, colCount, bLeft, maxRow, frozColLayoutModel, colLayoutModel)
        {
            var sheet = this._sheet;
            var tcol = col;
            if(!bLeft)
                tcol = col + colCount - 1;
            if(tcol < sheet.frozenColCount)
            {
                if(frozColLayoutModel.length < 1)
                    return
            }
            else
            {
                if(colLayoutModel.length < 1)
                    return;
                if(bLeft)
                {
                    if(tcol < colLayoutModel[0].col)
                        tcol = colLayoutModel[0].col
                }
                else if(tcol > colLayoutModel[colLayoutModel.length - 1].col)
                    tcol = colLayoutModel[colLayoutModel.length - 1].col
            }
            var x = 0;
            if(bLeft)
                x = 90000;
            for(var r = Math.max(sheet._scrollTopRow,row); r < row + rowCount && r <= maxRow; r++)
            {
                var rect = sheet.getCellRect(r,tcol);
                if(rect)
                    if(bLeft)
                    {
                        if(rect.x < x)
                            x = rect.x
                    }
                    else if(x < rect.x + rect.width)
                        x = rect.x + rect.width
            }
            return x
        },
        getResizingArea: function()
        {
            return 4
        },
        _getPrevVisualRowBeforeFindRow: function(row, sheetArea)
        {
            var sheet = this._sheet;
            var tempRow = row;
            if(sheet._render._isCellHiddenByGroup(tempRow,0,sheetArea))
            {
                tempRow = sheet._getPrevVisualRow(tempRow,sheetArea);
                return tempRow !== null ? tempRow : row
            }
            else
                return row
        },
        _getPrevVisualColBeforeFindCol: function(col, sheetArea)
        {
            var sheet = this._sheet;
            var tempCol = col;
            if(sheet._render._isCellHiddenByGroup(0,tempCol,sheetArea))
            {
                tempCol = sheet._getPrevVisualColumn(tempCol,sheetArea);
                return tempCol !== null ? tempCol : col
            }
            else
                return col
        },
        _getResizeRowInfo: function(sheet, target, resizeArea, sheetArea, y)
        {
            var op = null;
            var rowLayout = sheet._getRowLayout(target.rowViewportIndex,sheetArea);
            if(!isNaN(target.row) && !isNaN(target.col))
            {
                target.row = this._getPrevVisualRowBeforeFindRow(target.row,sheetArea);
                var rl = rowLayout.findRow(target.row);
                if(rl)
                    if(rl.y + rl.height - resizeArea < y && y < rl.y + rl.height + resizeArea)
                    {
                        op = {
                            action: "sizeRow",
                            index: target.row,
                            sheetArea: sheetArea
                        };
                        var lastRow = sheet.getRowCount(sheetArea) - 1;
                        if(lastRow >= 0)
                        {
                            var lastVisibleRow = sheet._getLastVisualRow(sheetArea);
                            if(op.index === lastVisibleRow && op.index !== lastRow)
                                if(rl.y + rl.height - resizeArea / 2 < y)
                                    op = {
                                        action: "sizeRow",
                                        index: lastRow,
                                        sheetArea: sheetArea
                                    }
                        }
                    }
                    else if(rl.y - resizeArea < y && y < rl.y + resizeArea)
                        if(rowLayout.indexOf(rl) > 0)
                            op = {
                                action: "sizeRow",
                                index: target.row - 1,
                                sheetArea: sheetArea
                            }
            }
            if(op && !sheet.getRowResizable(op.index,sheetArea))
                op = null;
            return op
        },
        _getResizeColInfo: function(sheet, target, resizeArea, sheetArea, x)
        {
            var op = null;
            var colLayout = sheet._getColumnLayout(target.colViewportIndex,sheetArea);
            if(!isNaN(target.col) && !isNaN(target.row))
            {
                target.col = this._getPrevVisualColBeforeFindCol(target.col,sheetArea);
                var cl = colLayout.findCol(target.col);
                if(cl)
                    if(cl.x + cl.width - resizeArea < x && x < cl.x + cl.width + resizeArea)
                    {
                        op = {
                            action: "sizeCol",
                            index: target.col,
                            sheetArea: sheetArea
                        };
                        var lastCol = sheet.getColumnCount(sheetArea) - 1;
                        if(lastCol >= 0)
                        {
                            var lastVisibleCol = sheet._getLastVisualColumn(sheetArea);
                            if(op.index === lastVisibleCol && op.index !== lastCol)
                                if(cl.x + cl.width - resizeArea / 2 < x)
                                    op = {
                                        action: "sizeCol",
                                        index: lastCol,
                                        sheetArea: sheetArea
                                    }
                        }
                    }
                    else if(cl.x - resizeArea < x && x < cl.x + resizeArea)
                        if(colLayout.indexOf(cl) > 0)
                            op = {
                                action: "sizeCol",
                                index: target.col - 1,
                                sheetArea: sheetArea
                            }
            }
            if(op && !sheet.getColumnResizable(op.index,sheetArea))
                op = null;
            return op
        },
        getResizingRowCol: function(target, x, y)
        {
            var sheet = this._sheet;
            var op = null,
                r,
                c;
            if(!sheet.parent || sheet.parent._allowUserResize)
            {
                var resizeArea = this.getResizingArea();
                var sheetLayout = sheet._getSheetLayout();
                if(target.rowViewportIndex < 0 && target.colViewportIndex >= 0)
                {
                    op = this._getResizeColInfo(sheet,target,resizeArea,GrapeCity.UI.SheetArea.colHeader,x);
                    if(!op)
                        op = this._getResizeRowInfo(sheet,target,resizeArea,GrapeCity.UI.SheetArea.colHeader,y)
                }
                else if(target.rowViewportIndex >= 0 && target.colViewportIndex < 0)
                {
                    op = this._getResizeRowInfo(sheet,target,resizeArea,GrapeCity.UI.SheetArea.rowHeader,y);
                    if(!op)
                        op = this._getResizeColInfo(sheet,target,resizeArea,GrapeCity.UI.SheetArea.rowHeader,x)
                }
                else if(target.rowViewportIndex < 0 && target.colViewportIndex < 0)
                {
                    if(sheet._getLastVisualRow(GrapeCity.UI.SheetArea.rowHeader) === null && Math.abs(y - sheetLayout.colHeaderHeight) <= resizeArea)
                    {
                        r = sheet.getRowCount() - 1;
                        if(r >= 0)
                            op = {
                                action: "sizeRow",
                                index: r,
                                sheetArea: GrapeCity.UI.SheetArea.rowHeader
                            }
                    }
                    else if(sheet._getLastVisualColumn(GrapeCity.UI.SheetArea.colHeader) === null && Math.abs(x - sheetLayout.rowHeaderWidth) <= resizeArea)
                    {
                        c = sheet.getColumnCount() - 1;
                        if(c >= 0)
                            op = {
                                action: "sizeCol",
                                index: c,
                                sheetArea: GrapeCity.UI.SheetArea.colHeader
                            }
                    }
                }
                else if(target.rowViewportIndex >= 0 && target.colViewportIndex >= 0)
                    if(sheetLayout.colHeaderHeight === 0 && y <= resizeArea)
                    {
                        r = sheet.getRowCount(GrapeCity.UI.SheetArea.colHeader) - 1;
                        if(r >= 0)
                            op = {
                                action: "sizeRow",
                                index: r,
                                sheetArea: GrapeCity.UI.SheetArea.colHeader
                            }
                    }
                    else if(sheetLayout.rowHeaderWidth === 0 && x <= resizeArea)
                    {
                        c = sheet.getColumnCount(GrapeCity.UI.SheetArea.rowHeader) - 1;
                        if(c >= 0)
                            op = {
                                action: "sizeCol",
                                index: c,
                                sheetArea: GrapeCity.UI.SheetArea.rowHeader
                            }
                    }
            }
            return op
        },
        getDragInfo: function(target, x, y)
        {
            var op = null;
            var sheet = this._sheet;
            var activeSelRange = sheet._getActiveSelectedRange();
            if(activeSelRange.row === -1 && activeSelRange.col === -1)
                return op;
            if(target.rowViewportIndex >= 0 && target.colViewportIndex >= 0 && sheet._selectionModel.length === 1)
            {
                var r = sheet._getActiveSelectionRect(target.rowViewportIndex,target.colViewportIndex);
                if(r.x - 4 < x && x < r.x + 4 && r.y <= y && y < r.y + r.height)
                    op = {
                        action: "drag",
                        side: "left"
                    };
                if(!op)
                {
                    var rect = this._sheet._dragFillIndicatorRect;
                    if(rect && rect.x <= x && x <= rect.x + rect.width && rect.y <= y && y <= rect.y + rect.height)
                        op = {
                            action: "drag",
                            side: "corner"
                        }
                }
                if(!op)
                    if(r.x + r.width - 4 < x && x < r.x + r.width + 4 && r.y <= y && y < r.y + r.height)
                        op = {
                            action: "drag",
                            side: "right"
                        };
                if(!op)
                    if(r.y - 4 < y && y < r.y + 4 && r.x <= x && x < r.x + r.width)
                        op = {
                            action: "drag",
                            side: "top"
                        };
                if(!op)
                    if(r.y + r.height - 4 < y && y < r.y + r.height + 4 && r.x <= x && x < r.x + r.width)
                        op = {
                            action: "drag",
                            side: "bottom"
                        };
                if(op)
                    if(x < r.x || x > r.x + r.width || y < r.y || y > r.y + r.height)
                        op.outside = true
            }
            if(!this._sheet.canUserDragDrop())
                if(op && op.side !== "corner")
                    op.side = null;
            if(!this._sheet.canUserDragFill())
                if(op && op.side === "corner")
                    op.side = null;
            return op
        },
        doMouseMove: function(e)
        {
            var t = this._getCanvasOffset();
            this.doMouseMoveImp(e,e.pageX - t.left,e.pageY - t.top)
        },
        doMouseOut: function(e)
        {
            var sheet = this._sheet;
            var oldTarget = sheet._currentTarget;
            if(oldTarget && oldTarget.cellTypeHitInfo)
            {
                var row = oldTarget.row,
                    col = oldTarget.col;
                var celltype = sheet.getCellType(row,col,oldTarget.hitTestType);
                celltype.processMouseLeave(oldTarget.cellTypeHitInfo)
            }
            if(this.isMouseDown)
                return;
            var outTarget = {
                    x: -10000,
                    y: -10000,
                    rowViewportIndex: null,
                    colViewportIndex: null,
                    row: -1,
                    col: -1,
                    resizeInfo: null,
                    hitTestType: null
                };
            sheet._setHoverCell(outTarget)
        },
        doMouseMoveImp: function(e, x, y)
        {
            var sheet = this._sheet;
            if(this.isMouseDown)
                if(!window.gcGlobal.activeElement)
                    window.gcGlobal.activeElement = sheet;
            if(this.isMouseDown && this.isWorking)
            {
                var currentTarget = sheet._currentTarget;
                var resizeInfo = currentTarget.resizeInfo;
                if(resizeInfo)
                {
                    if(currentTarget.x === x && currentTarget.y === y)
                        return;
                    var sheetLayout = sheet._getSheetLayout();
                    if(currentTarget.rowViewportIndex === -1 && currentTarget.colViewportIndex === -1)
                    {
                        currentTarget.rowViewportIndex = 1;
                        currentTarget.colViewportIndex = 1
                    }
                    var max;
                    if(resizeInfo.action === "sizeRow")
                    {
                        var rowLayout = sheet._getRowLayout(currentTarget.rowViewportIndex,resizeInfo.sheetArea);
                        resizeInfo.index = this._getPrevVisualRowBeforeFindRow(resizeInfo.index,resizeInfo.sheetArea);
                        var rl = rowLayout.findRow(resizeInfo.index);
                        if(!rl)
                            rl = rowLayout.findRow(currentTarget.row);
                        resizeInfo.startY = rl.y;
                        resizeInfo.movingY = y;
                        if(resizeInfo.movingY < rl.y)
                            resizeInfo.movingY = rl.y;
                        max = sheetLayout.y + sheetLayout.height;
                        if(resizeInfo.movingY > max)
                            resizeInfo.movingY = max;
                        sheet._render.update(sheetLayout.x,resizeInfo.startY,sheetLayout.width,sheetLayout.height - resizeInfo.startY,true)
                    }
                    else
                    {
                        var colLayout = sheet._getColumnLayout(currentTarget.colViewportIndex,resizeInfo.sheetArea);
                        resizeInfo.index = this._getPrevVisualColBeforeFindCol(resizeInfo.index,resizeInfo.sheetArea);
                        var cl = colLayout.findCol(resizeInfo.index);
                        if(!cl)
                            cl = colLayout.findCol(currentTarget.col);
                        resizeInfo.startX = cl.x;
                        resizeInfo.movingX = x;
                        if(resizeInfo.movingX < cl.x)
                            resizeInfo.movingX = cl.x;
                        max = sheetLayout.x + sheetLayout.width;
                        if(resizeInfo.movingX > max)
                            resizeInfo.movingX = max;
                        sheet._render.update(resizeInfo.startX,sheetLayout.y,sheetLayout.width - resizeInfo.startX,sheetLayout.height,true)
                    }
                }
                else if(currentTarget.dragInfo && currentTarget.dragInfo.side !== "corner")
                    this.continueDragDropping(e,x,y);
                else if(currentTarget.dragInfo && currentTarget.dragInfo.side === "corner")
                    this.continueDragFill(e,x,y);
                else
                    this.continueSelecting(e,x,y)
            }
            else
            {
                var target = sheet.hitTest(x,y);
                if(!target)
                    return;
                var canvas = sheet._getCanvas();
                if(!canvas)
                    return;
                var oldTarget = sheet._currentTarget;
                var targetChanged = !oldTarget || target.row !== oldTarget.row || target.col !== oldTarget.col || target.hitTestType !== oldTarget.hitTestType || target.resizeInfo && !oldTarget.resizeInfo || !target.resizeInfo && oldTarget.resizeInfo || target.resizeInfo && target.resizeInfo.action !== oldTarget.resizeInfo.action || target.dragInfo && !oldTarget.dragInfo || !target.dragInfo && oldTarget.dragInfo || target.dragInfo && target.dragInfo.action !== oldTarget.dragInfo.action;
                if(oldTarget && targetChanged)
                    if(oldTarget.cellTypeHitInfo)
                    {
                        var row = oldTarget.row,
                            col = oldTarget.col;
                        var celltype = sheet.getCellType(row,col,oldTarget.hitTestType);
                        celltype.processMouseLeave(oldTarget.cellTypeHitInfo)
                    }
                var op = target.resizeInfo;
                if(op)
                    if(op.action === "sizeCol")
                        canvas.style.cursor = "w-resize";
                    else if(op.action === "sizeRow")
                        canvas.style.cursor = "n-resize";
                    else
                        canvas.style.cursor = "default";
                else
                {
                    op = target.dragInfo;
                    if(op && op.action === "drag")
                    {
                        if(op.side === "corner")
                            canvas.style.cursor = "crosshair";
                        else if(op.side)
                            canvas.style.cursor = "move"
                    }
                    else
                    {
                        if(target.cellTypeHitInfo)
                        {
                            var row = target.row,
                                col = target.col;
                            var celltype = sheet.getCellType(row,col,target.hitTestType);
                            target.cellTypeHitInfo.sheet = sheet;
                            if(targetChanged)
                                celltype.processMouseEnter(target.cellTypeHitInfo);
                            celltype.processMouseMove(target.cellTypeHitInfo)
                        }
                        if(targetChanged || !target.cellTypeHitInfo || !target.cellTypeHitInfo.isReservedLocation)
                            canvas.style.cursor = "default"
                    }
                }
                if(target)
                    sheet._setHoverCell(target)
            }
        },
        doMouseUp: function(e)
        {
            var sheet = this._sheet;
            if(!sheet.inCanvas)
                this.unhandleDocumentMouseMove();
            var t = this._getCanvasOffset();
            this.doMouseUpImp(e,e.pageX - t.left,e.pageY - t.top);
            t = sheet._isMouseDownInSheet;
            return!t
        },
        doMouseUpImp: function(e, x, y)
        {
            var sheet = this._sheet;
            if(sheet._isMouseDownInSheet !== true)
                return;
            else
                sheet._isMouseDownInSheet = false;
            var ae = window.gcGlobal.activeElement;
            this.isMouseDown = false;
            if(ae && ae !== sheet && ae.endEdit)
            {
                ae.endEdit();
                ae.repaint()
            }
            var currentTarget = sheet._currentTarget;
            if(sheet._currentTarget)
            {
                var resizeInfo = currentTarget.resizeInfo;
                var value,
                    i,
                    selectedRange,
                    action;
                if(resizeInfo)
                {
                    if(resizeInfo.action === "sizeRow")
                    {
                        if(resizeInfo.movingY !== undefined && resizeInfo.movingY !== null)
                        {
                            value = Math.max(0,(resizeInfo.movingY - resizeInfo.startY) / sheet._zoomFactor);
                            var rowList = [];
                            if(sheet._isRowSelected(resizeInfo.index))
                                for(i = 0; i < sheet._selectionModel.length; i++)
                                {
                                    selectedRange = sheet._selectionModel[i];
                                    if(selectedRange.col === -1)
                                    {
                                        selectedRange = sheet._getActualRange(selectedRange);
                                        rowList.push({
                                            firstRow: selectedRange.row,
                                            lastRow: selectedRange.row + selectedRange.rowCount - 1
                                        })
                                    }
                                }
                            else
                                rowList.push({
                                    firstRow: resizeInfo.index,
                                    lastRow: resizeInfo.index
                                });
                            var isColHeader = resizeInfo.sheetArea === GrapeCity.UI.SheetArea.colHeader;
                            action = new GrapeCity.UI.UndoRedo.RowResizeUndoAction(sheet,rowList,value,isColHeader);
                            sheet._doCommand(action)
                        }
                    }
                    else if(resizeInfo.movingX !== undefined && resizeInfo.movingX !== null)
                    {
                        value = Math.max(0,(resizeInfo.movingX - resizeInfo.startX) / sheet._zoomFactor);
                        var columnList = [];
                        if(sheet._isColumnSelected(resizeInfo.index))
                            for(i = 0; i < sheet._selectionModel.length; i++)
                            {
                                selectedRange = sheet._selectionModel[i];
                                if(selectedRange.row === -1)
                                {
                                    selectedRange = sheet._getActualRange(selectedRange);
                                    columnList.push({
                                        firstCol: selectedRange.col,
                                        lastCol: selectedRange.col + selectedRange.colCount - 1
                                    })
                                }
                            }
                        else
                            columnList.push({
                                firstCol: resizeInfo.index,
                                lastCol: resizeInfo.index
                            });
                        var isRowHeader = resizeInfo.sheetArea === GrapeCity.UI.SheetArea.rowHeader;
                        action = new GrapeCity.UI.UndoRedo.ColumnResizeUndoAction(sheet,columnList,value,isRowHeader);
                        sheet._doCommand(action)
                    }
                    this.isWorking = false
                }
                else if(sheet._currentTarget.dragInfo && !this.isDraggingFill)
                {
                    this.stopDragDrop(e);
                    sheet._currentTarget = null
                }
                else if(sheet._currentTarget.dragInfo && this.isDraggingFill === true)
                {
                    this.endDragFill(e);
                    sheet._currentTarget = null
                }
                else
                {
                    if(sheet._currentTarget.cellTypeHitInfo)
                    {
                        var r = sheet._currentTarget.row,
                            c = sheet._currentTarget.col;
                        var ct = sheet.getCellType(r,c,sheet._currentTarget.hitTestType);
                        sheet._currentTarget.cellTypeHitInfo.sheet = sheet;
                        ct.processMouseUp(sheet._currentTarget.cellTypeHitInfo)
                    }
                    if(!sheet._currentTarget.cellTypeHitInfo || !sheet._currentTarget.cellTypeHitInfo.isReservedLocation)
                        sheet._trigger(GrapeCity.UI.Events.CellClick,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            sheetArea: sheet._currentTarget.hitTestType,
                            row: sheet._currentTarget.row,
                            col: sheet._currentTarget.col
                        })
                }
            }
            window.gcGlobal.activeElement = sheet;
            this.stopSelecting();
            this.setMetaKeyState(e)
        },
        startEdit: function(e)
        {
            var sheet = this._sheet;
            var canvas = sheet._getCanvas();
            var t = this._getCanvasOffset();
            if(!e.shiftKey && !e.ctrlKey)
                sheet._doStartEdit(canvas,e.pageX - t.left,e.pageY - t.top)
        },
        doKeyDown: function(event)
        {
            var sheet = this._sheet;
            var navKey = !sheet.isEditing() && !event.ctrlKey && (event.keyCode === GrapeCity.UI.Key.pdn || event.keyCode === GrapeCity.UI.Key.pup || event.keyCode === GrapeCity.UI.Key.left || event.keyCode === GrapeCity.UI.Key.right || event.keyCode === GrapeCity.UI.Key.tab || event.keyCode === GrapeCity.UI.Key.up || event.keyCode === GrapeCity.UI.Key.down);
            if(navKey)
            {
                if(this._keyPressed)
                {
                    if(this._keyPressedCount < 5)
                        this._keyPressedCount++;
                    GrapeCity.UI.cancelDefault(event);
                    return
                }
                this._keyPressed = true;
                this._keyPressedCount = 1;
                this._repeatKeyDown(event)
            }
            else
                this._keyDownImp(event)
        },
        _repeatKeyDown: function(event)
        {
            if(!this._keyPressed)
                return;
            var self = this;
            self._keyDownImp(event);
            if(this._keyPressed)
                window.setTimeout(function()
                {
                    self._repeatKeyDown(event)
                },100 / this._keyPressedCount)
        },
        _keyDownImp: function(event)
        {
            var sheet = this._sheet;
            this.setMetaKeyState(event);
            if(event.keyCode === GrapeCity.UI.Key.tab)
                GrapeCity.UI.cancelDefault(event);
            if(!sheet.isEditing() && event.keyCode === GrapeCity.UI.Key.esc && !event.altKey && !event.ctrlKey && !event.shiftKey && sheet._validationInputMessage)
            {
                $(sheet._validationInputMessage).remove();
                sheet._validationInputMessage = null
            }
            if(!sheet.isEditing() && (event.keyCode === GrapeCity.UI.Key.pdn || event.keyCode === GrapeCity.UI.Key.pup || event.keyCode === GrapeCity.UI.Key.end || event.keyCode === GrapeCity.UI.Key.home || event.keyCode === GrapeCity.UI.Key.up || event.keyCode === GrapeCity.UI.Key.down))
                GrapeCity.UI.cancelDefault(event);
            if(!sheet.isEditing() && (event.keyCode === GrapeCity.UI.Key.left || event.keyCode === GrapeCity.UI.Key.right))
                GrapeCity.UI.cancelDefault(event);
            if(!sheet._processKeyMap(event))
                return;
            var c = sheet._getCanvas();
            if(c && this.allowEnterEditing(event))
            {
                sheet._startEditByKeydown = true;
                try
                {
                    var isEditing = sheet.isEditing();
                    sheet._startEditImp(c,sheet._activeRowIndex,sheet._activeColIndex,null,null,true);
                    if(!isEditing && sheet.isEditing())
                    {
                        var ct = sheet.getCellType(sheet._activeRowIndex,sheet._activeColIndex);
                        if(ct._triggerButtonClicked && event.keyCode === UI.Key.space && !event.ctrlKey && !event.shiftKey && !event.altKey)
                            ct._triggerButtonClicked(sheet,sheet._activeRowIndex,sheet._activeColIndex);
                        if(ct._cancelDefaultKeydown)
                            ct._cancelDefaultKeydown(event)
                    }
                }
                finally
                {
                    sheet._startEditByKeydown = false
                }
            }
        },
        doKeyUp: function(event)
        {
            this._keyPressed = false;
            this.setMetaKeyState(event)
        },
        allowEnterEditing: function(e)
        {
            if(e.ctrlKey || e.altKey)
                return false;
            if(e.keyCode >= 65 && e.keyCode <= 90)
                return true;
            else if(e.keyCode >= 48 && e.keyCode <= 57 || e.keyCode >= 96 && e.keyCode <= 105)
                return true;
            else if(e.keyCode >= 186 && e.keyCode <= 192)
                return true;
            else if(e.keyCode >= 220 && e.keyCode <= 222 || e.keyCode === 219)
                return true;
            else if(e.keyCode >= 106 && e.keyCode <= 111)
                return true;
            else if(e.keyCode === 32)
                return true;
            else if(e.keyCode === 61)
                return true;
            else if(e.keyCode === 173)
                return true;
            else if(e.keyCode === 229 || e.keyCode === 0)
                return true;
            return false
        },
        setMetaKeyState: function(e)
        {
            var sheet = this._sheet;
            this.shift = e.shiftKey && !e.ctrlKey;
            this.ctrl = e.ctrlKey && !e.shiftKey;
            sheet._isNavigateInSelection = false;
            if(e.keyCode === GrapeCity.UI.Key.tab)
                if(sheet._selectionModel.length > 1)
                    sheet._isNavigateInSelection = true;
                else
                {
                    var range = sheet._getActiveSelectedRange();
                    if(range && sheet._selectionModel.length > 0)
                        sheet._isNavigateInSelection = !(sheet._activeRowIndex === range.row && sheet._activeColIndex === range.col && sheet._activeRowCount === range.rowCount && sheet._activeColCount === range.colCount)
                }
            if(this.isDragDropping === true)
            {
                var activeSelRange = sheet._getActiveSelectedRange();
                var tempInsert = this._isDragInsert;
                var tempCopy = this._isDragCopy;
                if(activeSelRange.row === -1 || activeSelRange.col === -1)
                    this._isDragInsert = e.shiftKey;
                else
                    this._isDragInsert = false;
                this._isDragCopy = e.ctrlKey;
                if(tempInsert !== this._isDragInsert || tempCopy !== this._isDragCopy)
                    sheet._render.refreshDragDropIndicator()
            }
            this.isShiftPressed = e.shiftKey;
            this.isControlPressed = e.ctrlKey
        },
        doMouseWheel: function(event, detail)
        {
            var sheet = this._sheet;
            if(!sheet.endEdit())
                return;
            if(event.ctrlKey)
            {
                if(!sheet.parent || sheet.parent._allowUserZoom)
                {
                    var oldZoomFactor = sheet._zoomFactor;
                    var newZoomFactor = sheet._zoomFactor - 0.05 * detail;
                    var action = new GrapeCity.UI.UndoRedo.ZoomUndoAction(sheet,newZoomFactor);
                    sheet._doCommand(action);
                    newZoomFactor = sheet._zoomFactor;
                    if(oldZoomFactor !== newZoomFactor)
                        sheet._trigger(GrapeCity.UI.Events.UserZooming,{
                            sheet: sheet,
                            sheetName: sheet._name,
                            oldZoomFactor: oldZoomFactor,
                            newZoomFactor: newZoomFactor
                        });
                    return
                }
            }
            else
            {
                var oldTopRow = sheet._scrollTopRow;
                if(sheet.frozenRowCount > 0)
                    if(sheet._scrollTopRow === 0 && detail > 0)
                        sheet._scrollTopRow = sheet.frozenRowCount;
                    else if(detail < 0 && sheet._scrollTopRow === sheet.frozenRowCount - detail)
                        sheet._scrollTopRow = 0;
                sheet._scrollTopRow = sheet._scrollTopRow + detail;
                if(sheet._scrollTopRow < sheet._getFirstPageTopRow())
                    sheet._scrollTopRow = sheet._getFirstPageTopRow();
                else if(sheet._scrollTopRow > sheet._getLastVisualRow())
                    sheet._scrollTopRow = sheet._getLastVisualRow();
                if(oldTopRow !== sheet._scrollTopRow)
                    sheet._trigger(GrapeCity.UI.Events.TopRowChanged,{
                        sheet: sheet,
                        sheetName: sheet._name,
                        oldTopRow: oldTopRow,
                        newTopRow: sheet._scrollTopRow
                    });
                this.scrolling = true
            }
            sheet.invalidateLayout();
            sheet.repaint();
            sheet._syncVScrollbarPosition()
        },
        waittime: 100,
        scrollTop: 0,
        scrollLeft: 0,
        oldLeft: 0,
        oldTop: 0,
        doVScroll: function(topRow)
        {
            var sheet = this._sheet;
            if(!sheet.endEdit())
                return;
            this.scrolling = true;
            sheet._scrollTopRow = topRow;
            var self = this;
            if(!this.scrollTimer)
                this.scrollTimer = window.setInterval(function()
                {
                    self._scrollView()
                },this.waittime)
        },
        doHScroll: function(leftColumn)
        {
            var sheet = this._sheet;
            if(!sheet.endEdit())
                return;
            this.scrolling = true;
            sheet._scrollLeftCol = leftColumn;
            var self = this;
            if(!this.scrollTimer)
                this.scrollTimer = window.setInterval(function()
                {
                    self._scrollView()
                },this.waittime)
        },
        _scrollView: function()
        {
            if(!this.scrolling)
            {
                if(this.scrollTimer)
                {
                    window.clearInterval(this.scrollTimer);
                    this.scrollTimer = null;
                    this._sheet.repaint();
                    var bLoadData = this.oldTop !== this._sheet._scrollTopRow;
                    this.oldTop = this._sheet._scrollTopRow;
                    this.oldLeft = this._sheet._scrollLeftCol;
                    if(bLoadData)
                    {
                        var topRow = this._sheet.getViewportTopRow(1);
                        var bottomRow = this._sheet.getViewportBottomRow(1);
                        var start = Math.max(0,topRow - 60);
                        if(start < this._sheet.getRowCount())
                            this._loadData(start,2 * bottomRow - topRow)
                    }
                }
                return
            }
            this.scrolling = false;
            this._updateView()
        },
        _getLoadingProgress: function(parentId)
        {
            var progId = parentId + "_loading";
            var prog = $("#" + progId);
            if(!prog || prog.length === 0)
            {
                var progDiv = document.createElement("div");
                prog = $(progDiv);
                prog.attr("id",progId);
                prog.css("textAlign","center");
                prog.css("background-color","#DCDCDC");
                document.body.insertBefore(progDiv,null)
            }
            prog.css("position","absolute");
            var jParent = $("#" + parentId);
            var pos = jParent.position();
            prog.css("left",pos.left);
            prog.css("top",pos.top);
            prog.css("width",jParent.width());
            prog.css("height",jParent.height());
            return{
                    show: function()
                    {
                        prog.fadeIn('fast');
                        prog.append("postback and loading ...")
                    },
                    hide: function()
                    {
                        prog.fadeOut('fast');
                        prog.html("")
                    }
                }
        },
        _loadData: function(startIndex, endIndex)
        {
            if(!this._sheet.parent || !this._sheet.parent._host)
                return;
            if(this._sheet.dataContext && this._sheet.dataContext.read)
            {
                var self = this;
                this._dataContextLoadDelegate = function(event, context)
                {
                    return self._dataContextLoaded(event,context)
                };
                this.lastLoadedRowIndex = startIndex;
                jQuery.ajax({
                    url: this._sheet.dataContext.read,
                    type: "POST",
                    data: JSON.stringify({
                        index: startIndex,
                        count: endIndex - startIndex + 1
                    }),
                    dataType: "json",
                    contentType: "application/json;charset=UTF-8",
                    success: this._dataContextLoadDelegate
                })
            }
            else
            {
                var id = this._sheet.parent._host.id;
                if(id && id.length > 0 && typeof window.WebForm_DoCallback !== "undefined")
                {
                    this.lastLoadedRowIndex = startIndex;
                    this._doLoadData(id,startIndex,endIndex)
                }
            }
        },
        _dataContextLoaded: function(result, context)
        {
            var tmp = result.data;
            if(tmp && tmp.length > 0)
            {
                var sheet = this._sheet;
                var ds = sheet.getDataSource();
                if(ds && this.lastLoadedRowIndex === result.start)
                    for(var i = 0; i < tmp.length; i++)
                        ds[result.start + i] = tmp[i];
                sheet.recalcAll();
                sheet.repaint()
            }
        },
        _doCallBack: function(cmd, context)
        {
            var id = this._sheet.parent._host.id;
            if(id && id.length > 0 && typeof window.WebForm_DoCallback !== "undefined")
            {
                var form = $(document.forms);
                if(!form || form.length === 0)
                    return;
                form = form[0];
                form.__EVENTTARGET.value = id;
                form.__EVENTARGUMENT.value = cmd;
                this._sheet.parent.saveData();
                window.__theFormPostCollection.length = 0;
                window.__theFormPostData = "";
                window.WebForm_InitCallback();
                window.__theFormPostData = "gcallback=true&" + window.__theFormPostData;
                if(form["__EVENTVALIDATION"])
                    window.__theFormPostData += "&__EVENTVALIDATION=" + WebForm_EncodeCallback(form["__EVENTVALIDATION"].value);
                var href = form.action;
                var loadProg = this._getLoadingProgress(id);
                if(loadProg)
                    loadProg.show();
                var self = this;
                this._updateDelegate = function(event, context)
                {
                    loadProg.hide();
                    return self._onUpdateCallback(event,context)
                };
                this._errorDelegate = function(event, contex)
                {
                    loadProg.hide()
                };
                $.ajax({
                    url: href,
                    type: "POST",
                    data: window.__theFormPostData,
                    dataType: "html",
                    contentType: "application/x-www-form-urlencoded, charset=UTF-8",
                    success: this._updateDelegate,
                    error: this._errorDelegate
                })
            }
        },
        _doLoadData: function(id, startIndex, endIndex)
        {
            var context = {
                    start: startIndex,
                    end: endIndex
                };
            var dirty = this._sheet.hasPendingChanges();
            var self = this;
            if(dirty)
            {
                var form = $(document.forms);
                if(!form || form.length === 0)
                    return;
                form = form[0];
                var cmd = "loadData," + startIndex + "," + endIndex;
                form.__EVENTTARGET.value = id;
                form.__EVENTARGUMENT.value = cmd;
                this._sheet.parent.saveData();
                window.__theFormPostCollection.length = 0;
                window.__theFormPostData = "";
                window.WebForm_InitCallback();
                window.__theFormPostData = "gcallback=true&" + window.__theFormPostData;
                if(form["__EVENTVALIDATION"])
                    window.__theFormPostData += "&__EVENTVALIDATION=" + WebForm_EncodeCallback(form["__EVENTVALIDATION"].value);
                var href = form.action;
                var loadProg = this._getLoadingProgress(id);
                if(loadProg)
                    loadProg.show();
                this._updateDelegate = function(event, context)
                {
                    loadProg.hide();
                    return self._onUpdateCallback(event,context)
                };
                this._errorDelegate = function(event, contex)
                {
                    loadProg.hide()
                };
                $.ajax({
                    url: href,
                    type: "POST",
                    data: window.__theFormPostData,
                    dataType: "html",
                    contentType: "application/x-www-form-urlencoded, charset=UTF-8",
                    success: this._updateDelegate,
                    error: this._errorDelegate
                })
            }
            else
            {
                this._loadDataDelegate = function(event, context)
                {
                    return self._onLoadDataCallback(event,context)
                };
                this._sheet.parent.saveData();
                window.__theFormPostCollection.length = 0;
                window.__theFormPostData = "";
                window.WebForm_InitCallback();
                window.WebForm_DoCallback(id,"loadData," + startIndex + "," + endIndex,this._loadDataDelegate,context,null,true)
            }
        },
        _onUpdateCallback: function(result, context)
        {
            this._sheet.clearPendingChanges();
            var doc = document;
            try
            {
                doc.selection.empty()
            }
            catch(e){}
            var buff = doc.createElement("div");
            if(!buff)
                return;
            buff.innerHTML = result;
            var form = $(document.forms);
            if(!form || form.length === 0)
                return;
            form = form[0];
            form.__EVENTTARGET.value = "";
            form.__EVENTARGUMENT.value = "";
            var old = doc.getElementById("__VIEWSTATE");
            var t = this.getElementById(buff,"__VIEWSTATE");
            if(old && t)
                old.value = t.value;
            old = doc.getElementById("__EVENTVALIDATION");
            t = this.getElementById(buff,"__EVENTVALIDATION");
            if(old && t)
                old.value = t.value;
            var id = this._sheet.parent._host.id;
            old = document.getElementById(id + "_data");
            t = this.getElementById(buff,id + "_data");
            if(old && t)
                old.value = t.value;
            buff.innerHTML = "";
            this._sheet.parent._loadData(true);
            this._sheet.parent.invalidateLayout();
            this._sheet.parent.repaint()
        },
        getElementById: function(parent, id)
        {
            if(!parent)
                return null;
            var t = parent.firstChild;
            while(t)
            {
                if(t.id === id || t.name === id)
                    return t;
                var t1 = this.getElementById(t,id);
                if(t1)
                    return t1;
                t = t.nextSibling
            }
            return null
        },
        _onLoadDataCallback: function(result, context)
        {
            if(!result)
                return;
            var sheet = this._sheet;
            var data = JSON.parse(result);
            if(!data)
                return;
            var tmp = data.dataSource,
                i;
            if(tmp && tmp.length > 0)
            {
                var ds = sheet.getDataSource();
                if(ds && this.lastLoadedRowIndex === context.start)
                {
                    var dataSource = JSON.parse(tmp);
                    for(i = 0; i < dataSource.length; i++)
                        ds[context.start + i] = dataSource[i]
                }
            }
            var sheetData = data.data;
            if(sheetData)
                if(this.lastLoadedRowIndex === context.start)
                {
                    for(i in sheetData)
                        if(typeof i !== "function")
                            sheet._dataModel.dataTable[i] = sheetData[i];
                    if(data.rows)
                        for(i in data.rows)
                            if(typeof i !== "function")
                                sheet._rowInfos[i] = data.rows[i];
                    sheet.suspendCalcService();
                    sheet.suspendEvent();
                    sheet.isPaintSuspended(true);
                    var columnCount = sheet.getColumnCount();
                    for(i in sheetData)
                        if(typeof i !== "function")
                        {
                            var rowData = sheetData[i];
                            if(rowData)
                                for(var c = 0; c < columnCount; c++)
                                {
                                    var formula = null;
                                    if(rowData[c])
                                        formula = rowData[c].formula;
                                    if(formula)
                                    {
                                        rowData[c].formula = null;
                                        sheet.setFormula(parseInt(i,10),c,formula)
                                    }
                                }
                        }
                    sheet.resumeCalcService();
                    sheet.resumeEvent();
                    sheet.isPaintSuspended(false)
                }
            sheet.suspendEvent();
            sheet.isPaintSuspended(true);
            sheet.recalcAll();
            sheet.resumeEvent();
            sheet.isPaintSuspended(false);
            sheet.clearPendingChanges();
            sheet.repaint()
        },
        _updateView: function()
        {
            var sheet = this._sheet;
            if(this.painting)
                return;
            this.painting = true;
            var painted = false;
            if(this.oldTop !== sheet._scrollTopRow && this.oldLeft === sheet._scrollLeftCol)
                painted = this._vScrollView(sheet);
            else if(this.oldTop === sheet._scrollTopRow && this.oldLeft !== sheet._scrollLeftCol)
                painted = this._hScrollView(sheet);
            if(!painted)
            {
                sheet.invalidateLayout();
                sheet.repaint()
            }
            this.painting = false
        },
        _vScrollView: function(sheet)
        {
            var painted = false,
                oldTop = this.oldTop,
                sl;
            if(sheet._scrollTopRow > oldTop)
            {
                var rls = sheet._getRowLayout(1,GrapeCity.UI.SheetArea.viewport);
                var rl = rls.findRow(sheet._scrollTopRow);
                if(rl)
                {
                    painted = true;
                    sl = sheet._getSheetLayout();
                    sheet._render.translateScreen(sl.x,rl.y,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - rl.y,sl.x,sl.viewportY);
                    sheet.invalidateLayout();
                    sheet._render.update(sl.x,sl.viewportY + sl.viewportHeight - rl.y,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,rl.y,false)
                }
            }
            else
            {
                sl = sheet._getSheetLayout();
                var h = 0;
                for(var i = sheet._scrollTopRow; i < oldTop && h < sl.viewportHeight; i++)
                    h += sheet._getZoomRowHeight(i);
                if(h < sl.viewportHeight)
                {
                    painted = true;
                    sheet._render.translateScreen(sl.x,sl.viewportY,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,sl.viewportHeight - h,sl.x,sl.viewportY + h);
                    sheet.invalidateLayout();
                    sheet._render.update(sl.x,sl.viewportY,sl.rowHeaderWidth + sl.frozenWidth + sl.viewportWidth,h,false)
                }
            }
            return painted
        },
        _hScrollView: function(sheet)
        {
            var painted = false,
                oldLeft = this.oldLeft,
                sl;
            if(sheet._scrollLeftCol > oldLeft)
            {
                var cls = sheet._getColumnLayout(1,GrapeCity.UI.SheetArea.viewport);
                var cl = cls.findCol(sheet._scrollLeftCol);
                if(cl)
                {
                    painted = true;
                    sl = sheet._getSheetLayout();
                    sheet._render.translateScreen(cl.x,sl.y,sl.viewportWidth - cl.x,sl.colHeaderHeight + sl.frozenHeight + sl.viewportHeight,sl.viewportX,sl.y);
                    sheet.invalidateLayout();
                    sheet._render.update(sl.viewportX + sl.viewportWidth - cl.x,sl.y,cl.x,sl.colHeaderHeight + sl.frozenHeight + sl.viewportHeight,false)
                }
            }
            else
            {
                sl = sheet._getSheetLayout();
                var w = 0;
                for(var i = sheet._scrollLeftCol; i < oldLeft && w < sl.viewportWidth; i++)
                    w += sheet._getZoomColumnWidth(i);
                if(w < sl.viewportWidth)
                {
                    painted = true;
                    sheet._render.translateScreen(sl.viewportX,sl.y,sl.viewportWidth - w,sl.colHeaderHeight + sl.frozenHeight + sl.viewportHeight,sl.viewportX + w,sl.y);
                    sheet.invalidateLayout();
                    sheet._render.update(sl.viewportX,sl.y,w,sl.colHeaderHeight + sl.frozenHeight + sl.viewportHeight,false)
                }
            }
            return painted
        },
        _notEqualSelecions: function(oldSelections, newSelections)
        {
            var notEqual = true;
            if(oldSelections.length === newSelections.length)
                for(var i = 0; i < oldSelections.length; i++)
                {
                    var oldItem = oldSelections[i];
                    var newItem = newSelections[i];
                    if(oldItem.row !== newItem.row || oldItem.col !== newItem.col || oldItem.rowCount !== newItem.rowCount || oldItem.colCount !== newItem.colCount)
                    {
                        notEqual = true;
                        break
                    }
                    else
                        notEqual = false
                }
            return notEqual
        },
        _setFocus: function()
        {
            if(!this._focusHolder)
            {
                var focusHolder = document.createElement("div");
                focusHolder.style.position = "relative";
                focusHolder.style.overflow = "hidden";
                focusHolder.style.width = "0px";
                focusHolder.style.height = "0px";
                var h = null;
                var c = this._sheet._getCanvas();
                if(c)
                    h = c.parentNode;
                if(h)
                    h.insertBefore(focusHolder,c);
                this._focusHolder = focusHolder
            }
            if(!this._focusElem)
            {
                var focusElem = document.createElement("input");
                focusElem.type = "text";
                focusElem.style.position = "absolute";
                focusElem.className = "gcSheetFocusInputStyle";
                focusElem.setAttribute("gcUIElement","gcSheetFocusInput");
                this._focusHolder.insertBefore(focusElem,null);
                this._focusElem = focusElem
            }
            var ar,
                ac,
                arvi,
                acvi;
            if(this._hitTestResult)
            {
                ar = this._hitTestResult.row;
                ac = this._hitTestResult.col;
                arvi = this._hitTestResult.rowViewportIndex;
                acvi = this._hitTestResult.colViewportIndex
            }
            else
            {
                ar = this._sheet.getActiveRowIndex();
                ac = this._sheet.getActiveColumnIndex();
                arvi = this._sheet.activeRowViewportIndex;
                acvi = this._sheet.activeColViewportIndex
            }
            var activeCellRect = this._sheet._getRangeRect(arvi,acvi,{
                    row: ar,
                    col: ac,
                    rowCount: 1,
                    colCount: 1
                });
            this._focusHolder.style.left = "" + (activeCellRect.x + 1) + "px";
            this._focusHolder.style.top = "" + (activeCellRect.y + 1) + "px";
            document.body.focus();
            this._focusElem.focus();
            if(!window.gcGlobal.activeElement)
            {
                window.gcGlobal.activeElement = this._sheet;
                if(this._sheet._eventHandler)
                    this._sheet._eventHandler._updateValidationUI(this._sheet._activeRowIndex,this._sheet._activeColIndex)
            }
        },
        bind: function(type, data, fn)
        {
            $(this._getElem()).bind(type,data,fn)
        },
        unbind: function(type, fn)
        {
            $(this._getElem()).unbind(type,fn)
        },
        trigger: function(type, data)
        {
            if(this._eventSuspended === 0)
                $(this._getElem()).trigger(type,data)
        }
    };
    UI.Events = {
        ValidationError: "ValidationError",
        CellClick: "CellClick",
        CellDoubleClick: "CellDoubleClick",
        EnterCell: "EnterCell",
        LeaveCell: "LeaveCell",
        ValueChanged: "ValueChanged",
        TopRowChanged: "TopRowChanged",
        LeftColumnChanged: "LeftColumnChanged",
        InvalidOperation: "InvalidOperation",
        RangeFiltering: "RangeFiltering",
        RangeFiltered: "RangeFiltered",
        RangeSorting: "RangeSorting",
        RangeSorted: "RangeSorted",
        ClipboardChanging: "ClipboardChanging",
        ClipboardChanged: "ClipboardChanged",
        ClipboardPasting: "ClipboardPasting",
        ClipboardPasted: "ClipboardPasted",
        ColumnWidthChanging: "ColumnWidthChanging",
        ColumnWidthChanged: "ColumnWidthChanged",
        RowHeightChanging: "RowHeightChanging",
        RowHeightChanged: "RowHeightChanged",
        DragDropBlock: "DragDropBlock",
        DragDropBlockCompleted: "DragDropBlockCompleted",
        DragFillBlock: "DragFillBlock",
        DragFillBlockCompleted: "DragFillBlockCompleted",
        EditStarting: "EditStarting",
        EditChange: "EditChange",
        EditEnd: "EditEnd",
        RangeGroupStateChanging: "RangeGroupStateChanging",
        RangeGroupStateChanged: "RangeGroupStateChanged",
        SelectionChanging: "SelectionChanging",
        SelectionChanged: "SelectionChanged",
        SheetTabClick: "SheetTabClick",
        SheetTabDoubleClick: "SheetTabDoubleClick",
        UserZooming: "UserZooming",
        UserFormulaEntered: "UserFormulaEntered",
        CellChanged: "CellChanged",
        ColumnChanged: "ColumnChanged",
        RowChanged: "RowChanged",
        ActiveSheetChanging: "ActiveSheetChanging",
        ActiveSheetChanged: "ActiveSheetChanged",
        SparklineChanged: "SparklineChanged",
        RangeChanged: "RangeChanged",
        ButtonClicked: "ButtonClicked",
        EditorStatusChanged: "EditorStatusChanged"
    }
})(window,jQuery);
(function(window)
{
    "use strict";;
    var GrapeCity = window.GrapeCity;
    var const_undefined = "undefined";
    if(typeof GrapeCity === const_undefined)
        GrapeCity = {};
    if(typeof GrapeCity.UI === const_undefined)
        GrapeCity.UI = {};
    var UI = GrapeCity.UI;
    UI.Range = function(r, c, rc, cc)
    {
        this.row = r;
        this.rowCount = rc;
        this.col = c;
        this.colCount = cc
    };
    UI.Range.prototype = {
        intersect: function(row, col, rowCount, colCount)
        {
            return(row === -1 || this.row === -1 || this.row < row + rowCount && row < this.row + this.rowCount) && (col === -1 || this.col === -1 || this.col < col + colCount && col < this.col + this.colCount)
        },
        contains: function(row, col, rowCount, colCount)
        {
            if(arguments.length === 2)
                return(this.row === -1 || this.row <= row && row < this.row + this.rowCount) && (this.col === -1 || this.col <= col && col < this.col + this.colCount);
            else if(arguments.length === 4)
                return this.containsRange(new UI.Range(row,col,rowCount,colCount))
        },
        containsRange: function(range)
        {
            return(this.row === -1 || this.row <= range.row && range.row + range.rowCount <= this.row + this.rowCount) && (this.col === -1 || this.col <= range.col && range.col + range.colCount <= this.col + this.colCount)
        },
        offset: function(x, y)
        {
            var column = this.col;
            var row = this.row;
            if(this.col !== -1)
                column += x;
            if(this.row !== -1)
                row += y;
            return new UI.Range(row,column,this.rowCount,this.colCount)
        },
        union: function(range)
        {
            var ltr = Math.min(this.row,range.row);
            var ltc = Math.min(this.col,range.col);
            var rbr = Math.max(this.row + this.rowCount - 1,range.row + range.rowCount - 1);
            var rbc = Math.max(this.col + this.colCount - 1,range.col + range.colCount - 1);
            return new UI.Range(ltr,ltc,rbr - ltr + 1,rbc - ltc + 1)
        },
        equals: function(range)
        {
            if(range instanceof UI.Range)
                return this.row === range.row && this.col === range.col && this.rowCount === range.rowCount && this.colCount === range.colCount;
            return false
        }
    };
    UI.SheetArea = {
        corner: 0,
        colHeader: 1,
        rowHeader: 2,
        viewport: 3
    };
    UI.CopyToOption = {
        Value: 0x01,
        Formula: 0x02,
        RangeGroup: 0x08,
        Sparkline: 0x10,
        Span: 0x20,
        Style: 0x40,
        Tag: 0x80,
        BindingPath: 0x100
    };
    var CopyToOption = UI.CopyToOption;
    CopyToOption.All = CopyToOption.Value | CopyToOption.Formula | CopyToOption.RangeGroup | CopyToOption.Sparkline | CopyToOption.Span | CopyToOption.Style | CopyToOption.Tag | CopyToOption.BindingPath;
    UI.SelectionPolicy = {
        Single: 0,
        Range: 1,
        MultiRange: 2
    };
    UI.SelectionUnit = {
        Cell: 0,
        Row: 1,
        Column: 2
    };
    var mergeSpanErrorStr = "This operation will cause overlapping spans.";
    function findImp(obj, condition)
    {
        for(var i = 0; i < obj.length; i++)
        {
            var t = obj[i];
            if(condition(t))
                return t
        }
        return null
    }
    UI._SpanModel = function(){};
    UI._SpanModel.prototype = [];
    var spanModelPrototype = UI._SpanModel.prototype;
    spanModelPrototype.find = function(row, col)
    {
        return findImp(this,function(t)
            {
                return t.contains(row,col)
            })
    };
    spanModelPrototype.remove = function(ele)
    {
        for(var i = 0; i < this.length; i++)
            if(this[i] === ele)
            {
                this.splice(i,1);
                return
            }
    };
    spanModelPrototype.copy = function(fromRow, fromColumn, toRow, toColumn, rowCount, columnCount)
    {
        var changed = false;
        var cellRangeCount = this.length;
        var cs;
        var cr,
            i;
        var temp;
        if(fromRow === -1)
        {
            temp = [];
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromColumn <= cs.col && cs.col < fromColumn + columnCount)
                {
                    temp.push(new UI.Range(cs.row,toColumn + cs.col - fromColumn,cs.rowCount,cs.colCount));
                    changed = true
                }
                else if(toColumn <= cs.col && cs.col < toColumn + columnCount)
                {
                    this.splice(i,1);
                    i--;
                    cellRangeCount--;
                    changed = true
                }
            }
            for(i = 0; i < temp.length; i++)
            {
                cr = temp[i];
                if(!this.isValid(this,0,this.length,cr))
                    throw new Error(mergeSpanErrorStr);
                this.push(cr)
            }
        }
        else if(fromColumn === -1)
        {
            temp = [];
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromRow <= cs.row && cs.row < fromRow + rowCount)
                {
                    temp.push(new UI.Range(toRow + cs.row - fromRow,cs.col,cs.rowCount,cs.colCount));
                    changed = true
                }
                else if(toRow <= cs.row && cs.row < toRow + rowCount)
                {
                    this.splice(i,1);
                    i--;
                    cellRangeCount--;
                    changed = true
                }
            }
            for(i = 0; i < temp.length; i++)
            {
                cr = temp[i];
                if(!this.isValid(this,0,this.length,cr))
                    throw new Error(mergeSpanErrorStr);
                this.push(cr)
            }
        }
        else
        {
            temp = [];
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromRow <= cs.row && cs.row < fromRow + rowCount && fromColumn <= cs.col && cs.col < fromColumn + columnCount)
                {
                    temp.push(new UI.Range(toRow + cs.row - fromRow,toColumn + cs.col - fromColumn,cs.rowCount,cs.colCount));
                    changed = true
                }
                else if(toRow <= cs.row && cs.row < toRow + rowCount && toColumn <= cs.col && cs.col < toColumn + columnCount)
                {
                    this.splice(i,1);
                    i--;
                    cellRangeCount--;
                    changed = true
                }
            }
            for(i = 0; i < temp.length; i++)
            {
                cr = temp[i];
                if(!this.isValid(this,0,this.length,cr))
                    throw new Error(mergeSpanErrorStr);
                this.push(cr)
            }
        }
    };
    spanModelPrototype.isValid = function(list, start, end, cellRange)
    {
        for(var i = start; i < end && i < list.length; i++)
        {
            var cr = list[i];
            if(cr.intersect(cellRange.row,cellRange.col,cellRange.rowCount,cellRange.colCount))
                return false
        }
        return true
    };
    spanModelPrototype.getEnumerator = function(row, col, rowCount, colCount)
    {
        return new UI._SpanEnumerator(this,row,col,rowCount,colCount)
    };
    spanModelPrototype.clear = function(row, col, rowCount, colCount)
    {
        for(var i = 0; i < this.length; i++)
        {
            var span = this[i];
            if((row === -1 || row <= span.row && span.row < row + rowCount) && (col === -1 || col <= span.col && span.col < col + colCount))
                this.splice(i--,1)
        }
    };
    spanModelPrototype.move = function(fromRow, fromCol, toRow, toCol, rowCount, colCount)
    {
        var changed = false;
        var tmpList = new UI._SpanModel;
        var changeList = [];
        var cellRangeCount = this.length;
        var cs;
        var Range = UI.Range;
        var i,
            cr;
        if(fromRow === -1)
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromCol <= cs.col && cs.col < fromCol + colCount)
                {
                    cr = new Range(cs.row,toCol + cs.col - fromCol,cs.rowCount,cs.colCount);
                    changeList.push(cr);
                    changed = true
                }
                else if(toCol < cs.col && cs.col < toCol + colCount)
                    changed = true;
                else
                    tmpList.push(cs)
            }
        else if(fromCol === -1)
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromRow <= cs.row && cs.row < fromRow + rowCount)
                {
                    cr = new Range(toRow + cs.row - fromRow,cs.col,cs.rowCount,cs.colCount);
                    changeList.push(cr);
                    changed = true
                }
                else if(toRow <= cs.row && cs.row < toRow + rowCount)
                    changed = true;
                else
                    tmpList.push(cs)
            }
        else
            for(i = 0; i < cellRangeCount; i++)
            {
                cs = this[i];
                if(fromRow <= cs.row && cs.row < fromRow + rowCount && fromCol <= cs.col && cs.col < fromCol + colCount)
                {
                    cr = new Range(toRow + cs.row - fromRow,toCol + cs.col - fromCol,cs.rowCount,cs.colCount);
                    changeList.push(cr);
                    changed = true
                }
                else if(toRow <= cs.row && cs.row < toRow + rowCount && toCol <= cs.col && cs.col < toCol + colCount)
                    changed = true;
                else
                    tmpList.push(cs)
            }
        if(changed)
        {
            if(changeList.length > 0)
                for(i = 0; i < changeList.length; i++)
                {
                    cr = changeList[i];
                    if(!this.isValid(tmpList,0,tmpList.length,cr))
                        throw new Error(mergeSpanErrorStr);
                    tmpList.push(cr)
                }
            this.length = 0;
            for(i = 0; i < tmpList.length; i++)
                this.push(tmpList[i])
        }
    };
    spanModelPrototype.isEmpty = function()
    {
        if(this.length <= 0)
            return true;
        return false
    };
    spanModelPrototype.addRows = function(row, count)
    {
        var changed = false;
        var countOld = this.length;
        var Range = UI.Range;
        for(var i = 0; i < countOld; i++)
        {
            var cs = this[i];
            if(cs.row >= row)
            {
                this[i] = new Range(cs.row + count,cs.col,cs.rowCount,cs.colCount);
                changed = true
            }
            else if(cs.row < row && row < cs.row + cs.rowCount)
            {
                this[i] = new Range(cs.row,cs.col,cs.rowCount + count,cs.colCount);
                changed = true
            }
        }
    };
    spanModelPrototype.addColumns = function(column, count)
    {
        var changed = false;
        var countOld = this.length;
        var Range = UI.Range;
        for(var i = 0; i < countOld; i++)
        {
            var cs = this[i];
            if(cs.col >= column)
            {
                this[i] = new Range(cs.row,cs.col + count,cs.rowCount,cs.colCount);
                changed = true
            }
            else if(cs.col < column && column < cs.col + cs.colCount)
            {
                this[i] = new Range(cs.row,cs.col,cs.rowCount,cs.colCount + count);
                changed = true
            }
        }
    };
    spanModelPrototype.removeRows = function(row, count)
    {
        var changed = false;
        var delList = [];
        var countOld = this.length;
        var Range = UI.Range;
        var i;
        for(i = 0; i < countOld; i++)
        {
            var cs = this[i];
            if(cs.row >= row)
                if(cs.row < row + count)
                {
                    delList.push(i);
                    changed = true
                }
                else
                {
                    this[i] = new Range(cs.row - count,cs.col,cs.rowCount,cs.colCount);
                    changed = true
                }
            else if(cs.row < row && row < cs.row + cs.rowCount)
            {
                this[i] = new Range(cs.row,cs.col,cs.rowCount - Math.min(cs.row + cs.rowCount - row,count),cs.colCount);
                if(this[i].rowCount === 1 && this[i].colCount === 1)
                    delList.push(i);
                changed = true
            }
        }
        for(i = 0; i < delList.length; i++)
        {
            var index = delList[i];
            this.splice(index,1)
        }
    };
    spanModelPrototype.removeColumns = function(column, count)
    {
        var changed = false;
        var delList = [];
        var countOld = this.length;
        var Range = UI.Range;
        var i;
        for(i = 0; i < countOld; i++)
        {
            var cs = this[i];
            if(cs.col >= column)
                if(cs.col < column + count)
                {
                    delList.push(i);
                    changed = true
                }
                else
                {
                    this[i] = new Range(cs.row,cs.col - count,cs.rowCount,cs.colCount);
                    changed = true
                }
            else if(cs.col < column && column < cs.col + cs.colCount)
            {
                this[i] = new Range(cs.row,cs.col,cs.rowCount,cs.colCount - Math.min(cs.col + cs.colCount - column,count));
                if(this[i].rowCount === 1 && this[i].colCount === 1)
                    delList.push(i);
                changed = true
            }
        }
        for(i = 0; i < delList.length; i++)
        {
            var index = delList[i];
            this.splice(index,1)
        }
    };
    spanModelPrototype.toJSON = function()
    {
        return this
    };
    spanModelPrototype.fromJSON = function(setting)
    {
        if(!setting)
            return;
        var spans = setting;
        for(var i = 0; i < spans.length; i++)
        {
            var cr = spans[i];
            this.push(new UI.Range(cr.row,cr.col,cr.rowCount,cr.colCount))
        }
    };
    UI._SpanEnumerator = function(model, row, col, rowCount, colCount)
    {
        this.model = model;
        this.row = row;
        this.column = col;
        this.rowCount = rowCount;
        this.columnCount = colCount;
        this.currentIndex = -1;
        if(row === -1 && col === -1)
            this.all = true
    };
    UI._SpanEnumerator.prototype = {
        current: function()
        {
            if(0 <= this.currentIndex && this.currentIndex < this.model.length)
                return this.model[this.currentIndex];
            else
                return null
        },
        moveNext: function()
        {
            this.currentIndex++;
            if(!this.all)
                while(this.currentIndex < this.model.length && !this.model[this.currentIndex].intersect(this.row,this.column,this.rowCount,this.columnCount))
                    this.currentIndex++;
            return this.currentIndex < this.model.length
        },
        reset: function()
        {
            this.currentIndex = -1
        }
    };
    UI._CellOverflowLayoutModel = function(){};
    UI._CellOverflowLayoutModel.prototype = [];
    var cellOverflowLayoutModelPrototype = UI._CellOverflowLayoutModel.prototype;
    cellOverflowLayoutModelPrototype.find = function(col)
    {
        return findImp(this,function(t)
            {
                return t.contains(col)
            })
    };
    UI._CellOverflowLayout = function(column, startCol, endCol, valueWidth, columnWidth, hAlign, columnPrevWidth)
    {
        this.column = column;
        this.startCol = startCol;
        this.endCol = endCol;
        this.columnWidth = columnWidth;
        this.hAlign = hAlign;
        this.columnPrevWidth = columnPrevWidth
    };
    UI._CellOverflowLayout.prototype.contains = function(col)
    {
        return col >= this.startCol && col <= this.endCol
    };
    UI._CellOverflowValueLayoutModel = function(){};
    UI._CellOverflowValueLayoutModel.prototype = [];
    UI._CellOverflowValueLayoutModel.prototype.find = function(col)
    {
        return findImp(this,function(t)
            {
                return t.contains(col)
            })
    };
    UI._CellOverflowValueLayout = function(data, row, col, x, y, width, height, sheetArea, cellOverflowLayout)
    {
        this.data = data;
        this.row = row;
        this.col = col;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.sheetArea = sheetArea;
        this.cellOverflowLayout = cellOverflowLayout
    };
    UI._CellOverflowValueLayout.prototype.contains = function(col)
    {
        return col === this.cellOverflowLayout.column
    };
    UI._SelectionModel = function()
    {
        this.selectionPolicy = UI.SelectionPolicy.MultiRange;
        this.selectionUnit = UI.SelectionUnit.Cell
    };
    UI._SelectionModel.prototype = [];
    var SelectionModelPrototype = UI._SelectionModel.prototype;
    SelectionModelPrototype.find = function(row, col)
    {
        return findImp(this,function(t)
            {
                return t.contains(row,col)
            })
    };
    SelectionModelPrototype.clear = function()
    {
        this.splice(0,this.length);
        this.activeSelectedRangeIndex = -1
    };
    SelectionModelPrototype.add = function(row, col, rowCount, colCount)
    {
        if(this.selectionPolicy === UI.SelectionPolicy.Single)
        {
            rowCount = Math.min(rowCount,1);
            colCount = Math.min(colCount,1);
            this.clear()
        }
        else if(this.selectionPolicy === UI.SelectionPolicy.Range)
            this.clear();
        if(this.selectionUnit === UI.SelectionUnit.Row)
        {
            col = -1;
            colCount = -1
        }
        else if(this.selectionUnit === UI.SelectionUnit.Column)
        {
            row = -1;
            rowCount = -1
        }
        var r = new UI.Range(row,col,rowCount,colCount);
        this.push(r);
        this.activeSelectedRangeIndex = this.length - 1
    };
    SelectionModelPrototype.toArray = function()
    {
        var newArray = [];
        for(var i = 0; i < this.length; i++)
            newArray.push(this[i]);
        return newArray
    };
    SelectionModelPrototype.toJSON = function()
    {
        return this
    };
    SelectionModelPrototype.fromJSON = function(setting)
    {
        if(!setting)
            return;
        var selections = setting,
            count = setting.length;
        for(var i = 0; i < count; i++)
        {
            var cr = selections[i];
            this.push(new UI.Range(cr.row,cr.col,cr.rowCount,cr.colCount))
        }
        if(setting.activeSelectedRangeIndex !== undefined && setting.activeSelectedRangeIndex !== null)
            this.activeSelectedRangeIndex = setting.activeSelectedRangeIndex
    };
    UI._LayoutModel = function(){};
    UI._LayoutModel.prototype = [];
    var LayoutModelPrototype = UI._LayoutModel.prototype;
    LayoutModelPrototype.findCell = function(row, col)
    {
        return findImp(this,function(layout)
            {
                return layout.contains(row,col)
            })
    };
    LayoutModelPrototype.findRow = function(row)
    {
        return findImp(this,function(layout)
            {
                return layout.row === row
            })
    };
    LayoutModelPrototype.findCol = function(col)
    {
        return findImp(this,function(layout)
            {
                return layout.col === col
            })
    };
    UI._Layout = function(row, col, x, y, width, height, rowCount, colCount)
    {
        this.rowCount = rowCount;
        this.colCount = colCount;
        this.row = row;
        this.col = col;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height
    };
    UI._Layout.prototype.contains = function(row, col)
    {
        return row < this.row + this.rowCount && this.row <= row && col < this.col + this.colCount && this.col <= col
    };
    UI._Layout.prototype.intersect = function(rect)
    {
        return(this.x < 0 || rect.x < this.x + this.width && this.x < rect.x + rect.width) && (this.y < 0 || rect.y < this.y + this.height && this.y < rect.y + rect.height)
    };
    UI._GcSheetModel = function(rowCount, colCount, name)
    {
        this.rowCount = rowCount !== null && rowCount !== undefined ? rowCount : 200;
        this.colCount = colCount !== null && colCount !== undefined ? colCount : 20;
        this.name = name;
        this.dataTable = {};
        this._rowDataArray = [];
        this._columnDataArray = [];
        this._defaultDataNode = null;
        this.dirtyNodes = {}
    };
    UI._GcSheetModel.prototype = {
        getRowCount: function()
        {
            return this.rowCount
        },
        getColumnCount: function()
        {
            return this.colCount
        },
        _updateDirty: function(row, col)
        {
            if(row >= 0 && col >= 0)
            {
                var dr = this.dataTable[row];
                if(dr.rs !== "n")
                    dr.rs = "e";
                this.dirtyNodes[row] = dr
            }
        },
        getValue: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node && node.value !== undefined && node.value !== null)
                return node.value;
            return null
        },
        setValue: function(row, col, value)
        {
            var node = this.getNode(row,col,true);
            if(node.value !== value)
            {
                node.value = value;
                this._updateDirty(row,col)
            }
        },
        getBindingPath: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node && node.bindingPath !== undefined && node.bindingPath !== null)
                return node.bindingPath;
            return null
        },
        setBindingPath: function(row, col, value)
        {
            var node = this.getNode(row,col,true);
            if(node.bindingPath !== value)
            {
                node.bindingPath = value;
                this._updateDirty(row,col)
            }
        },
        getSparkline: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node && node.sparkline)
                return node.sparkline;
            return null
        },
        setSparkline: function(row, col, sparkline)
        {
            var node = this.getNode(row,col,true);
            if(node.sparkline !== sparkline)
            {
                node.sparkline = sparkline;
                this._updateDirty(row,col)
            }
        },
        setFormula: function(row, col, value)
        {
            var node = this.getNode(row,col,true);
            if(node.formula !== value)
            {
                node.formula = value;
                this._updateDirty(row,col)
            }
        },
        getFormula: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node)
                return node.formula
        },
        getStyle: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node)
                return node.style
        },
        setStyle: function(row, col, value)
        {
            var node = this.getNode(row,col,true);
            if(node && node.style !== value)
            {
                node.style = value;
                this._updateDirty(row,col)
            }
        },
        getVisualState: function(row, col)
        {
            var node = this.getNode(row,col);
            if(node)
                return node.visualState
        },
        setVisualState: function(row, col, value)
        {
            var node = this.getNode(row,col,true);
            if(node.visualState !== value)
            {
                node.visualState = value;
                this._updateDirty(row,col)
            }
        },
        addRows: function(row, count)
        {
            if(row < 0 || row > this.rowCount || count < 0)
                return;
            this.addElements(this.dataTable,this.rowCount,row,count);
            this.addElements(this._rowDataArray,this.rowCount,row,count);
            this.addElements(this.dirtyNodes,this.rowCount,row,count);
            this.rowCount += count;
            for(var i = 0; i < count; i++)
            {
                this.dataTable[row + i] = {rs: "n"};
                this.dirtyNodes[row + i] = this.dataTable[row + i]
            }
        },
        deleteRows: function(row, count)
        {
            var n = this.rowCount;
            if(row < 0 || row >= n || count <= 0)
                return;
            if(row + count > n)
                count = n - row;
            this.deleteElements(this.dataTable,n,row,count);
            this.deleteElements(this._rowDataArray,n,row,count);
            this.deleteElements(this.dirtyNodes,n,row,count);
            this.rowCount -= count
        },
        addElements: function(a, aCount, index, count)
        {
            if(0 <= index && index < aCount)
            {
                var rows = [];
                for(var x in a)
                    if(a.hasOwnProperty(x) && !isNaN(x) && x >= index)
                        rows.push(x);
                rows.sort(function(a, b)
                {
                    return a - b
                });
                for(var i = 0; i < rows.length; i++)
                {
                    var k = rows[rows.length - i - 1];
                    var value = a[k];
                    a[k] = null;
                    a[parseInt(k,10) + count] = value
                }
            }
        },
        deleteElements: function(a, aCount, index, count)
        {
            if(0 <= index && index < aCount)
            {
                var rows = [];
                for(var x in a)
                    if(a.hasOwnProperty(x) && !isNaN(x))
                        if(index <= x && x < index + count)
                            a[x] = null;
                        else if(x >= index + count)
                            rows.push(x);
                rows.sort(function(c, d)
                {
                    return c - d
                });
                for(var i = 0; i < rows.length; i++)
                {
                    var k = rows[i];
                    var value = a[k];
                    a[k] = null;
                    a[parseInt(k,10) - count] = value
                }
            }
        },
        addColumns: function(col, count)
        {
            if(col < 0 || col > this.colCount || count < 0)
                return;
            for(var i = 0; i < this.rowCount; i++)
            {
                var tr = this.dataTable[i];
                if(tr && col < this.colCount)
                    this.addElements(tr,this.colCount,col,count)
            }
            this.addElements(this._columnDataArray,this.colCount,col,count);
            this.colCount += count
        },
        deleteColumns: function(col, count)
        {
            var n = this.colCount;
            if(col < 0 || col >= n || count < 0)
                return;
            for(var i = 0; i < this.rowCount; i++)
            {
                var tr = this.dataTable[i];
                if(tr && col < this.colCount)
                    this.deleteElements(tr,this.colCount,col,count)
            }
            this.deleteElements(this._columnDataArray,this.colCount,col,count);
            if(col + count > n)
                count = n - col;
            this.colCount -= count
        },
        getNode: function(row, col, create)
        {
            if(row >= this.rowCount || col >= this.colCount)
                return null;
            var node = null;
            if(row >= 0 && col >= 0)
            {
                var dr = this.dataTable[row];
                if(!dr && create)
                    dr = this.dataTable[row] = {};
                if(dr)
                {
                    node = dr[col];
                    if(!node && create)
                        node = dr[col] = {}
                }
            }
            else if(row === -1 && col >= 0)
            {
                node = this._columnDataArray[col];
                if(!node && create)
                    node = this._columnDataArray[col] = {}
            }
            else if(row >= 0 && col === -1)
            {
                node = this._rowDataArray[row];
                if(!node && create)
                    node = this._rowDataArray[row] = {}
            }
            else if(row === -1 && col === -1)
            {
                node = this._defaultDataNode;
                if(!node && create)
                    node = this._defaultDataNode = {}
            }
            return node
        },
        _setNode4Swap: function(or, oc, row, col, node)
        {
            if(row >= 0 && col >= 0)
            {
                var dr = this.dataTable[row];
                if(!dr)
                    dr = this.dataTable[row] = {};
                dr[col] = node;
                if(node && node.cellCalc)
                    delete node.cellCalc
            }
            else if(row >= 0 && col === -1 && or >= 0 && oc === -1)
                this._rowDataArray[row] = node;
            else if(col >= 0 && row === -1 && oc >= 0 && or === -1)
                this._columnDataArray[col] = node
        },
        swapNode: function(row, col, row2, col2)
        {
            var node = this.getNode(row,col);
            var node2 = this.getNode(row2,col2);
            if(node)
                this._setNode4Swap(row,col,row2,col2,node);
            else if(node2)
                this._setNode4Swap(row,col,row2,col2,null);
            if(node2)
                this._setNode4Swap(row2,col2,row,col,node2);
            else if(node)
                this._setNode4Swap(row2,col2,row,col,null)
        },
        getDataRowIndex: function(row)
        {
            return row
        },
        nextNonNullRow: function(row)
        {
            row++;
            while(row >= 0 && row < this.rowCount)
            {
                if(this.dataTable.hasOwnProperty(row) && this.dataTable[row])
                    break;
                row++
            }
            if(row < this.rowCount)
                return row;
            return-1
        },
        nextNonNullColumn: function(row, col)
        {
            var dr = null;
            if(row >= 0 && row < this.rowCount)
                if(this.dataTable.hasOwnProperty(row))
                    dr = this.dataTable[row];
            if(!dr)
                return-1;
            col++;
            while(col >= 0 && col < this.colCount)
            {
                if(dr.hasOwnProperty(col) && dr[col])
                    break;
                col++
            }
            if(col < this.colCount)
                return col;
            return-1
        },
        clear: function(row, column, rowCount, columnCount, type)
        {
            var nodes = [];
            var node,
                c,
                r;
            if(row >= 0 && column >= 0)
            {
                if(row + rowCount > this.rowCount)
                    rowCount = this.rowCount - row;
                if(rowCount <= 0)
                    return;
                if(column + columnCount > this.columnCount)
                    columnCount = this.columnCount - column;
                if(columnCount <= 0)
                    return;
                for(r = row; r < row + rowCount; r++)
                    for(c = column; c < column + columnCount; c++)
                    {
                        node = this.getNode(r,c);
                        if(node)
                            nodes.push(node)
                    }
            }
            else if(row >= 0 && column === -1)
            {
                if(row + rowCount > this.rowCount)
                    rowCount = this.rowCount - row;
                if(rowCount <= 0)
                    return;
                for(r = row; r < row + rowCount; r++)
                {
                    node = this.getNode(r,-1);
                    if(node)
                        nodes.push(node)
                }
            }
            else if(row === -1 && column >= 0)
            {
                if(column + columnCount > this.columnCount)
                    columnCount = this.columnCount - column;
                if(columnCount <= 0)
                    return;
                for(c = column; c < column + columnCount; c++)
                {
                    node = this.getNode(-1,c);
                    if(node)
                        nodes.push(node)
                }
            }
            else if(row === -1 && column === -1)
            {
                node = this._defaultDataNode;
                if(node)
                    nodes.push(node)
            }
            for(var i = 0; i < nodes.length; i++)
                if(nodes[i])
                {
                    if((type & UI.StorageType.Style) > 0)
                        nodes[i].style = null;
                    if((type & UI.StorageType.Data) > 0)
                    {
                        nodes[i].value = null;
                        nodes[i].formula = null
                    }
                    if((type & UI.StorageType.Sparkline) > 0)
                        nodes[i].sparkline = null;
                    if((type & UI.StorageType.BindingPath) > 0)
                        nodes[i].bindingPath = null
                }
        },
        toJSON: function()
        {
            return{
                    name: this.name,
                    rowCount: this.rowCount,
                    colCount: this.colCount,
                    dataTable: this.dataTable,
                    _rowDataArray: this._rowDataArray,
                    _columnDataArray: this._columnDataArray,
                    _defaultDataNode: this._defaultDataNode
                }
        },
        fromJSON: function(setting)
        {
            if(!setting)
                return;
            var dt = setting;
            this.name = dt.name;
            this.rowCount = dt.rowCount;
            this.colCount = dt.colCount;
            var data = dt.dataTable;
            if(data)
            {
                var dm = new GrapeCity.UI._GcSheetModel(this.rowCount,this.colCount);
                dm.dataTable = data;
                var r = dm.nextNonNullRow(-1);
                while(r >= 0)
                {
                    var c = dm.nextNonNullColumn(r,-1);
                    while(c >= 0)
                    {
                        var node = dm.getNode(r,c);
                        if(node)
                            this._copyJSONNode(r,c,node);
                        c = dm.nextNonNullColumn(r,c)
                    }
                    r = dm.nextNonNullRow(r)
                }
            }
            var rowData = dt._rowDataArray;
            if(rowData)
                for(var r = 0; r < this.rowCount; r++)
                    if(rowData.hasOwnProperty(r) && rowData[r])
                        this._copyJSONNode(r,-1,rowData[r]);
            var colData = dt._columnDataArray;
            if(colData)
                for(var c = 0; c < this.colCount; c++)
                    if(colData.hasOwnProperty(c) && colData[c])
                        this._copyJSONNode(-1,c,colData[c]);
            var defDataNode = dt._defaultDataNode;
            if(defDataNode)
                this._copyJSONNode(-1,-1,defDataNode)
        },
        _getCellTypeKinds: function()
        {
            if(!this._dict)
            {
                var dict = {};
                dict[UI.CellTypeKind.BaseCellType] = UI.BaseCellType;
                dict[UI.CellTypeKind.TextCellType] = UI.TextCellType;
                dict[UI.CellTypeKind.ColumnHeaderCellType] = UI.ColumnHeaderCellType;
                dict[UI.CellTypeKind.RowHeaderCellType] = UI.RowHeaderCellType;
                dict[UI.CellTypeKind.CornerCellType] = UI.CornerCellType;
                dict[UI.CellTypeKind.CheckBoxCellType] = UI.CheckBoxCellType;
                dict[UI.CellTypeKind.ButtonCellType] = UI.ButtonCellType;
                dict[UI.CellTypeKind.ComboBoxCellType] = UI.ComboBoxCellType;
                dict[UI.CellTypeKind.HyperLinkCellType] = UI.HyperLinkCellType;
                this._dict = dict
            }
            return this._dict
        },
        _copyJSONNode: function(row, col, node)
        {
            if(!node)
                return;
            var r = row,
                c = col;
            if(typeof node.value !== const_undefined)
                this.setValue(r,c,node.value);
            if(typeof node.formula !== const_undefined)
                this.setFormula(r,c,node.formula);
            if(typeof node.style !== const_undefined)
            {
                var style = null;
                if(node.style)
                {
                    style = new UI.Style;
                    style.copyFrom(node.style);
                    if(typeof node.style.validator !== const_undefined)
                    {
                        var dv = new UI.DefaultDataValidator;
                        dv.fromJSON(node.style.validator);
                        style.validator = dv
                    }
                    if(typeof node.style.cellType !== const_undefined)
                    {
                        var ct = null;
                        var dict = this._getCellTypeKinds();
                        var cellTypeClass = dict[node.style.cellType.type];
                        if(cellTypeClass)
                        {
                            ct = new cellTypeClass;
                            ct.fromJSON(node.style.cellType)
                        }
                        style.cellType = ct
                    }
                }
                this.setStyle(r,c,style)
            }
            if(typeof node.visualState !== const_undefined)
                this.setVisualState(r,c,node.visualState);
            if(typeof node.bindingPath !== const_undefined)
                this.setBindingPath(r,c,node.bindingPath)
        }
    };
    UI._UndoManager = function(context, maxLength, allowUndo)
    {
        this._context = context;
        if(parseInt(maxLength,10) < 0)
            maxLength = 2147483647;
        this._maxLength = maxLength;
        this._allowUndo = allowUndo;
        this._undoStack = [];
        this._redoStack = []
    };
    UI._UndoManager.prototype = {
        changed: null,
        context: function()
        {
            return this._context