function myToString() {
    //return this.toLocaleString();
    var d = this.getDate();
    var m = this.getMonth();
    var y = this.getFullYear();
    //return d + "/" + (m + 1) + "/" + y;
    //return Globalize.format(this, 'MMMM/y HH:mm:ss', 'el');
    return Globalize.format(this, 'dd/MM/yyyy HH:mm:ss', 'el');
    //return this.toLocaleString();
}
// Register the new function
Date.prototype.toString = myToString;

String.prototype.insert = function (index, string) {
    if (index > 0)
        return this.substring(0, index) + string + this.substring(index, this.length);
    else
        return string + this;
};

//Number.prototype.toString = function () {
//    return Globalize.format(this, '0.00', 'el');
//}

Globalize.culture("el-GR");




function zoomFactor_Changed(value) {
	var ss = $("#ss").wijspread("spread");
	var sheet = ss.getActiveSheet();
	sheet.zoom(value);
}
function selectionChanged(sender, args) {
	var spread = $("#ss").wijspread("spread");
	var sheet = spread.getActiveSheet();
	var content = sheet.getFormula(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $.wijmo.wijspread.SheetArea.viewport);
	if (!content)
		content = sheet.getValue(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $.wijmo.wijspread.SheetArea.viewport);
	else
		content = "=" + content;
	$("#formulabox").val(content);
	var position = sheet.getText(0, sheet.getActiveColumnIndex(), $.wijmo.wijspread.SheetArea.colHeader) + sheet.getText(sheet.getActiveRowIndex(), 0, $.wijmo.wijspread.SheetArea.rowHeader);
	$("#positionbox").val(position);
}
function formulaboxBlur() {
	var spread = $("#ss").wijspread("spread");
	var sheet = spread.getActiveSheet();
	var input = $("#formulabox").val();
	if (input.substr(0, 1) == "=")
		sheet.setFormula(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $("#formulabox").val(), $.wijmo.wijspread.SheetArea.viewport);
	else
		sheet.setValue(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $("#formulabox").val(), $.wijmo.wijspread.SheetArea.viewport);
}
function formulaboxKeyDown() {
	var x;
	if (window.event) // IE8 and earlier
	{
		x = event.keyCode;
	}
	else if (event.which) // IE9/Firefox/Chrome/Opera/Safari
	{
		x = event.which;
	}
	if (x == 13) {
		formulaboxBlur();
	}
}
var validatorType;
$(document).ready(function () {
	validatorType = "AnyValidator";
	$("#validatorTab1").hide();
	$("#validatorTab2").hide();
	$("#isIntTab").hide();
	$("#isTimeTab").hide();

	var barcolor = "#00FF00";
	var barbordercolor = "#008000";
	var barnegativefillcolor = "#008000";
	var barnegativebordercolor = "#000000";
	var baraxiscolor = "#0000FF";
	var mincolor = "red";
	var midcolor = "yellow";
	var maxcolor = "green";
	var selCellType = "TextCell";
	$('.premium-themes a, .jqueryui-themes a').click(function () {
		$("link[title='rocket-jqueryui']").attr("href", $(this).attr("href"));
		setTimeout(
				function () {
					var ss = $("#ss").wijspread("spread");
					ss.repaint();
				}, 100);

		return false;
	});

	$("#openFile").bind('change', function () {
		var file = $("#openFile").get(0).files[0];
		if (file) {
			var reader = new FileReader();

			reader.onprogress = function (evt) {
				if (evt.lengthComputable) {
					var loaded = (evt.loaded / evt.total);
					if (loaded < 1) {
					}
				}
			};
			reader.onload = function (evt) {
				// Obtain the read file data (string)
				var fileString = evt.target.result;
				// Handle UTF-8 file dump
				var spread = $("#ss").wijspread("spread");
				spread.isPaintSuspended(true);
				try {
					if (!spread.id) spread.id = spread.name;
					var dataField = document.getElementById(spread.id + "_data");
					if (!dataField) {
						dataField = document.createElement("input");
						dataField.id = spread.id + "_data";
						dataField.type = "hidden";
						document.body.appendChild(dataField);
					}

					dataField.value = fileString;
					spread._loadData();
					//if (JSON && JSON.parse) {
					//    var sd = JSON.parse(fileString);
					//    spread.fromJSON(sd);
					//}
				} catch (e) {
					alert("Η φόρτωση του αρχείου \"" + $("#openFile").val()
							+ "\" απέτυχε, παρακαλώ ελέγξτε αν το αρχείο είναι έγκυρο SpreadJS JSON.");
				} finally {
					spread.isPaintSuspended(false);
				}
			};
			reader.onerror = function (evt) {

			};

			// Read file into memory as UTF-8
			reader.readAsText(file, "UTF-8");
		}
	});

	$("#ribbon").wijribbon({
		click: function (e, cmd) {
			var spread = $("#ss").wijspread("spread");
			var sheet = spread.getActiveSheet();
			sheet.isPaintSuspended(true);
			switch (cmd.commandName) {
				case "import":
					var evt = document.createEvent("MouseEvents");
					evt.initEvent("click", true, false);
					document.getElementById("openFile").dispatchEvent(evt);
					break;
				case "cut":
					$.wijmo.wijspread.SpreadActions.cut.call(sheet);
					break;
				case "copy":
					$.wijmo.wijspread.SpreadActions.copy.call(sheet);
					break;
				case "paste":
					$.wijmo.wijspread.SpreadActions.paste.call(sheet);
					break;
				case "borders":
					$("#borderdialog").dialog("open");
					break;
				case "highlightcell":
					$("#Rule1 option:eq(0)").attr("selected", "selected");
					$("#Rule1").empty();
					$("#Rule1").show();
					$("#Rule1").append("<option value='0'>Τιμή</option>");
					$("#Rule1").append("<option value='1'>Κείμενο</option>");
					//$("#Rule1").append("<option value='2'>Date Occurring</option>");
					$("#Rule1").append("<option value='5'>Μοναδικές</option>");
					$("#Rule1").append("<option value='6'>Διπλές</option>");
					var rule = "0";
					var type = $("#ComparisonOperator1");
					setEnumTypeOfCF(rule, type);
					$("#conditionalformatdialog").dialog("open");
					break;
				case "topbottom":
					$("#Rule1 option:eq(1)").attr("selected", "selected");
					$("#Rule1").empty();
					$("#Rule1").show();
					$("#Rule1").append("<option value='4'>Καλύτερα/Χειρότερα</option>");
					$("#Rule1").append("<option value='7'>Τιμή</option>");
					var rule = "4";
					var type = $("#ComparisonOperator1");
					setEnumTypeOfCF(rule, type);
					$("#conditionalformatdialog").dialog("open");
					break;
				case "colorscale":
					$("#Rule1 option:eq(2)").attr("selected", "selected");
					$("#Rule1").empty();
					$("#Rule1").show();
					$("#Rule1").append("<option value='8'>2-Color Scale</option>");
					$("#Rule1").append("<option value='9'>3-Color Scale</option>");
					var rule = "8";
					var type = $("#ComparisonOperator1");
					setEnumTypeOfCF(rule, type);
					$("#conditionalformatdialog").dialog("open");
					break;
				case "otherofconditionalformat":
					$("#Rule1 option:eq(3)").attr("selected", "selected");
					$("#Rule1").empty();
					$("#Rule1").show();
					$("#Rule1").append("<option value='3'>FormulaRule</option>");
					var rule = "3";
					var type = $("#ComparisonOperator1");
					setEnumTypeOfCF(rule, type);
					$("#conditionalformatdialog").dialog("open");
					break;
				case "databar":
					$("#databardialog").dialog("open");
					break;
				case "iconset":
					createIconCriteriaDOM();
					$("#iconsetdialog").dialog("open");
					break;
				case "removeconditionalformats":
					var cfs = sheet.getConditionalFormats();
					var row = sheet.getActiveRowIndex(), col = sheet.getActiveColumnIndex();
					var rules = cfs.getRules(row, col);
					$.each(rules, function (i, v) {
						cfs.removeRule(v);
					});
					sheet.isPaintSuspended(false);
					break;
				case "textboxcelltype":
					$("#comboCellOptions").hide();
					$("#checkBoxCellOptions").hide();
					$("#buttonCellOptions").hide();
					$("#hyperlinkCellOptions").hide();
					var cellType = new $.wijmo.wijspread.TextCellType();
					sheet.isPaintSuspended(true);
					sheet.suspendEvent();
					var sels = sheet.getSelections();
					for (var i = 0; i < sels.length; i++) {
						var sel = sheet._getActualRange(sels[i]);
						for (var r = 0; r < sel.rowCount; r++) {
							for (var c = 0; c < sel.colCount; c++) {
								sheet.setCellType(sel.row + r, sel.col + c, cellType, $.wijmo.wijspread.SheetArea.viewport);
							}
						}
					}
					sheet.resumeEvent();
					sheet.isPaintSuspended(false);
					break;
				case "comboboxcelltype":
					$("#comboCellOptions").show();
					$("#checkBoxCellOptions").hide();
					$("#buttonCellOptions").hide();
					$("#hyperlinkCellOptions").hide();
					$("#celltypedialog").dialog("open");
					selCellType = "ComboCell";
					break;
				case "checkboxcelltype":
					$("#comboCellOptions").hide();
					$("#checkBoxCellOptions").show();
					$("#buttonCellOptions").hide();
					$("#hyperlinkCellOptions").hide();
					$("#celltypedialog").dialog("open");
					selCellType = "CheckBoxCell";
					break;
				case "buttoncelltype":
					$("#comboCellOptions").hide();
					$("#checkBoxCellOptions").hide();
					$("#buttonCellOptions").show();
					$("#hyperlinkCellOptions").hide();
					$("#celltypedialog").dialog("open");
					selCellType = "ButtonCell";
					break;
				case "hyperlinkcelltype":
					$("#comboCellOptions").hide();
					$("#checkBoxCellOptions").hide();
					$("#buttonCellOptions").hide();
					$("#hyperlinkCellOptions").show();
					$("#celltypedialog").dialog("open");
					selCellType = "HyperLinkCell";
					break;
				case "alloweditorreservedlocations":
					sheet.allowEditorReservedLocations($("#alleditorreserved").attr("checked") === "checked" ? true : false);
					break;
				case "ClearCellType":
					var sels = sheet.getSelections();
					for (var i = 0; i < sels.length; i++) {
						var sel = sheet._getActualRange(sels[i]);
						sheet.clear(sel.row, sel.col, sel.rowCount, sel.colCount, $.wijmo.wijspread.SheetArea.viewport, $.wijmo.wijspread.StorageType.Style);
					}
					sheet.isPaintSuspended(false);
					break;
				case "datavalidation":
					$("#datavalidationdialog").dialog("open");
					break;
				case "circleinvaliddata":
					spread.highlightInvalidData(true);
					break;
				case "clearvalidationcircles":
					spread.highlightInvalidData(false);
					break;
				case "isr1c1":
					var result = $("#isR1C1").prop("checked");
					if (result) {
						spread.referenceStyle($.wijmo.wijspread.ReferenceStyle.R1C1);
					}
					else {
						spread.referenceStyle($.wijmo.wijspread.ReferenceStyle.A1);
					}
					break;
				case "canuserdragdrop":
					var result = $("#canUserDragDrop").prop("checked");
					sheet.canUserDragDrop(result);
					sheet.isPaintSuspended(false);
					break;
				case "canuserdragfill":
					var result = $("#canUserDragFill").prop("checked");
					sheet.canUserDragFill(result);
					sheet.isPaintSuspended(false);
					break;
				case "canusereditformula":
					var result = $("#canUserEditFormula").prop("checked");
					spread.canUserEditFormula(result);
					break;
				case "merge":
					var sels = sheet.getSelections();
					var hasSpan = false;
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						if (sheet.getSpans(sel, $.wijmo.wijspread.SheetArea.viewport).length > 0) {
							for (var i = 0; i < sel.rowCount; i++) {
								for (var j = 0; j < sel.colCount; j++) {
									sheet.removeSpan(i + sel.row, j + sel.col);
								}
							}
							hasSpan = true;
						}
					}
					if (!hasSpan) {
						for (var n = 0; n < sels.length; n++) {
							var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
							sheet.addSpan(sel.row, sel.col, sel.rowCount, sel.colCount);
						}
					}
					break;
			    case "justifyleft":
			    case "justifycenter":
			    case "justifyright":
			        var align = $.wijmo.wijspread.HorizontalAlign.left;
			        if (cmd.commandName == "justifycenter") align = $.wijmo.wijspread.HorizontalAlign.center;
			        if (cmd.commandName == "justifyright") align = $.wijmo.wijspread.HorizontalAlign.right;
			        var sels = sheet.getSelections();
			        for (var n = 0; n < sels.length; n++) {
			            var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
			            sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).hAlign(align);
			        }
			        break;
			    case "aligntop":
			    case "alignmiddle":
			    case "alignbottom":
			        var align = $.wijmo.wijspread.VerticalAlign.top;
			        if (cmd.commandName == "alignmiddle") align = $.wijmo.wijspread.VerticalAlign.center;
			        if (cmd.commandName == "alignbottom") align = $.wijmo.wijspread.VerticalAlign.bottom;
			        var sels = sheet.getSelections();
			        for (var n = 0; n < sels.length; n++) {
			            var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
			            sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).vAlign(align);
			        }
			        break;
			    case "increaseindent":
				case "decreaseindent":
					var sels = sheet.getSelections();
					var offset = 1;
					if (cmd.commandName == "decreaseindent") offset = -1;
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						for (var i = 0; i < sel.rowCount; i++) {
							for (var j = 0; j < sel.colCount; j++) {
								var indent = sheet.getCell(i + sel.row, j + sel.col, $.wijmo.wijspread.SheetArea.viewport).textIndent();
								if (isNaN(indent)) indent = 0;
								sheet.getCell(i + sel.row, j + sel.col, $.wijmo.wijspread.SheetArea.viewport).textIndent(indent + offset);
							}
						}
					}
					break;
				case "backcolor":
				case "fontcolor":
					$("#colordialog").dialog({ title: cmd.commandName == "backcolor" ? "Χρώμα γεμίσματος" : "Χρώμα γραμμάτων" });
					$("#colordialog").dialog("open");
					break;
				case "tabStripColor":
					$("#colordialog").dialog({ title: "Tab Strip Color" });
					$("#colordialog").dialog("open");
					break;
				case "frozenlinecolor":
					$("#colordialog").dialog({ title: "Χρώμα γραμμής σταθεροποίησης" });
					$("#colordialog").dialog("open");
					break;
				case "bold":
				case "italic":
					var styleEle = document.getElementById("colorSample");
					var font = sheet.getCell(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $.wijmo.wijspread.SheetArea.viewport).font();
					if (font != undefined) {
						styleEle.style.font = font;
					} else {
						styleEle.style.font = "10pt Arial";
					}
					if (cmd.commandName == "bold") {
						if (styleEle.style.fontWeight == "bold") {
							styleEle.style.fontWeight = "";
						} else {
							styleEle.style.fontWeight = "bold";
						}
					} else if (cmd.commandName == "italic") {
						if (styleEle.style.fontStyle == "italic") {
							styleEle.style.fontStyle = "";
						} else {
							styleEle.style.fontStyle = "italic";
						}
					}
					var sels = sheet.getSelections();
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						//sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).font(document.defaultView.getComputedStyle(styleEle, "").font);
						sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).font(styleEle.style.font);
					}
					break;
				case "insertcol":
					sheet.addColumns(sheet.getActiveColumnIndex(), 1);
					break;
				case "insertrow":
					sheet.addRows(sheet.getActiveRowIndex(), 1);
					break;
				case "deleterow":
					sheet.deleteRows(sheet.getActiveRowIndex(), 1);
					break;
				case "deletecol":
					sheet.deleteColumns(sheet.getActiveColumnIndex(), 1);
					break;
				case "sortaz":
				case "sortza":
					var sels = sheet.getSelections();
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						sheet.sortRange(sel.row, sel.col, sel.rowCount, sel.colCount, true, [
							{ index: sel.col, ascending: cmd.commandName == "sortaz" }
						]);
					}
					break;
				case "filter":
					if (sheet.rowFilter()) {
						sheet.rowFilter(null);
					} else {
						var sels = sheet.getSelections();
						if (sels.length > 0) {
							var sel = sels[0];
							sheet.rowFilter(new $.wijmo.wijspread.HideRowFilter(sel));
						}
					}
					break;
				case "group":
					var sels = sheet.getSelections();
					var sel = sels[0];

					if (sel.col == -1) // row selection
					{
						var groupExtent = new $.wijmo.wijspread.UndoRedo.GroupExtent(sel.row, sel.rowCount);
						var action = new $.wijmo.wijspread.UndoRedo.RowGroupUndoAction(sheet, groupExtent);
						spread.doCommand(action);
						$("#showRowGroup").attr("disabled", false);
						if ($("#showRowGroup").attr("value") == "true") {
							$("#showRowGroupLabel").unbind("mouseup", rowlabelnoactive);
						}
						$("#showRowGroup").attr("value", "true");
						$("#showRowGroupLabel").attr("disabled", false);
						$("#showRowGroupLabel").removeClass("ui-state-disabled");
						$("#showRowGroupLabel").unbind("mouseup", rowlabelactive);
						sheet.showRowRangeGroup(true);
					}
					else if (sel.row == -1) // column selection
					{
						var groupExtent = new $.wijmo.wijspread.UndoRedo.GroupExtent(sel.col, sel.colCount);
						var action = new $.wijmo.wijspread.UndoRedo.ColumnGroupUndoAction(sheet, groupExtent);
						spread.doCommand(action);
						$("#showColGroup").attr("disabled", false);
						if ($("#showColGroup").attr("value") == "true") {
							$("#showColGroupLabel").unbind("mouseup", collabelnoactive);
						}
						$("#showColGroup").attr("value", "true");
						$("#showColGroupLabel").attr("disabled", false);
						$("#showColGroupLabel").removeClass("ui-state-disabled");
						$("#showColGroupLabel").unbind("mouseup", collabelactive);
						sheet.showColumnRangeGroup(true);
					}
					else // cell range selection
					{
						alert("Παρακαλώ επιλέξτε κάποιες γραμμές ή στήλες.");
					}
					break;
				case "ungroup":
					var sels = sheet.getSelections();
					var sel = sels[0];

					if (sel.col == -1 && sel.row == -1) // sheet selection
					{
						sheet.rowRangeGroup.ungroup(0, sheet.getRowCount());
						sheet.colRangeGroup.ungroup(0, sheet.getColumnCount());
					}
					else if (sel.col == -1) // row selection
					{
						//sheet.rowRangeGroup.ungroup(sel.row, sel.rowCount);
						var groupExtent = new $.wijmo.wijspread.UndoRedo.GroupExtent(sel.row, sel.rowCount);
						var action = new $.wijmo.wijspread.UndoRedo.RowUngroupUndoAction(sheet, groupExtent);
						spread.doCommand(action);
						if (sheet.rowRangeGroup.getMaxLevel() < 0) {
							$("#showRowGroup").attr("disabled", true);
							$("#showRowGroup").attr("value", "true");
							$("#showRowGroupLabel").attr("disabled", true);
							$("#showRowGroupLabel").addClass("ui-state-disabled");
							$("#showRowGroupLabel").bind("mouseup", rowlabelnoactive);
						}
					}
					else if (sel.row == -1) // column selection
					{
						//sheet.colRangeGroup.ungroup(sel.col, sel.colCount);
						var groupExtent = new $.wijmo.wijspread.UndoRedo.GroupExtent(sel.col, sel.colCount);
						var action = new $.wijmo.wijspread.UndoRedo.ColumnUngroupUndoAction(sheet, groupExtent);
						spread.doCommand(action);
						if (sheet.colRangeGroup.getMaxLevel() < 0) {
							$("#showColGroup").attr("disabled", true);
							$("#showColGroup").attr("value", "true");
							$("#showColGroupLabel").attr("disabled", true);
							$("#showColGroupLabel").addClass("ui-state-disabled");
							$("#showColGroupLabel").bind("mouseup", collabelnoactive);
						}
					}
					else // cell range selection
					{
					    alert("Παρακαλώ επιλέξτε κάποιες γραμμές ή στήλες.");
					}
					break;
				case "showdetail":
				case "hidedetail":
					var sels = sheet.getSelections();
					var sel = sels[0];

					if (sel.col == -1 && sel.row == -1) // sheet selection
					{
					}
					else if (sel.col == -1) // row selection
					{
						for (var i = 0; i < sel.rowCount; i++) {
							var rgi = sheet.rowRangeGroup.find(sel.row + i, 0);
							if (rgi) {
								sheet.rowRangeGroup.expand(rgi.level, cmd.commandName == "showdetail");
							}
						}
					}
					else if (sel.row == -1) // column selection
					{
						for (var i = 0; i < sel.colCount; i++) {
							var rgi = sheet.colRangeGroup.find(sel.col + i, 0);
							if (rgi) {
								sheet.colRangeGroup.expand(rgi.level, cmd.commandName == "showdetail");
							}
						}
					}
					else // cell range selection
					{
					}
					break;
				case "showrowrangegroup":
					if (!$("#showRowGroup").attr("disabled")) {
						sheet.showRowRangeGroup($("#showRowGroup").prop("checked"));
					}
					break;
				case "showcolrangegroup":
					if (!$("#showColGroup").attr("disabled")) {
						sheet.showColumnRangeGroup($("#showColGroup").prop("checked"));
					}
					break;
				case "enableUseWijmoTheme":
					if ($("#wijmothemecheck").prop("checked")) {
						$("#setTabStripColor").attr("disabled", false);
						$("#setTabStripColor").removeClass("ui-state-disabled");
						spread.useWijmoTheme = false;
						spread.repaint();
					} else {
						$("#setTabStripColor").attr("disabled", true);
						$("#setTabStripColor").addClass("ui-state-disabled");
						spread.useWijmoTheme = true;
						spread.repaint();
					}
					break;
				case "rowheader":
					//For Support IE7/8
					//sheet.rowHeaderVisible = !sheet.rowHeaderVisible;
					sheet.setRowHeaderVisible(!sheet.getRowHeaderVisible());
					break;
				case "columnheader":
					//For Support IE7/8
					//sheet.colHeaderVisible = !sheet.colHeaderVisible;
					sheet.setColumnHeaderVisible(!sheet.getColumnHeaderVisible());
					break;
				case "vgridline":
					//For Support IE7/8
					//sheet.gridline.showVerticalGridline = !sheet.gridline.showVerticalGridline;
					var vGridLine = sheet.gridline.showVerticalGridline;
					var hGridLine = sheet.gridline.showHorizontalGridline;
					sheet.setGridlineOptions({ showVerticalGridline: !vGridLine, showHorizontalGridline: hGridLine });
					break;
				case "hgridline":
					//For Support IE7/8
					//sheet.gridline.showHorizontalGridline = !sheet.gridline.showHorizontalGridline;
					var hGridLine = sheet.gridline.showHorizontalGridline;
					var vGridLine = sheet.gridline.showVerticalGridline;
					sheet.setGridlineOptions({ showVerticalGridline: vGridLine, showHorizontalGridline: !hGridLine });
					break;
				case "tabstrip":
					spread.tabStripVisible(!spread.tabStripVisible());
					break;
				case "newtab":
					spread.newTabVisible(!spread.newTabVisible());
					break;
				case "freezepane":
					sheet.setFrozenCount(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex());
					break;
				case "freezerows":
					sheet.setFrozenCount(sheet.getActiveRowIndex(), 0);
					break;
				case "freezecolumns":
					sheet.setFrozenCount(0, sheet.getActiveColumnIndex());
					break;
			    case "unfreeze":
			        sheet.setFrozenCount(0, 0);
			        break;
			    case "increasedecimals":
			    case "decreasedecimals":
			        var sels = sheet.getSelections();
			        for (var n = 0; n < sels.length; n++) {
			            var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
			            for (var r = sel.row; r < sel.row + sel.rowCount; r++) {
			                for (var c = sel.col; c < sel.col + sel.colCount; c++) {
			                    var value = sheet.getCell(r, c).value();
			                    if (value == null)
			                        break;
			                    var formatter = sheet.getCell(r, c).formatter();
			                    var formatString = null;
			                    if (formatter == null)
			                        formatter = new $.wijmo.wijspread.GeneralFormatter();
			                    if (typeof formatter === "string") {
			                        formatString = formatter;
			                        formatter = new $.wijmo.wijspread.GeneralFormatter(formatter);
			                    }
			                    formatString = formatter.FormatString();
			                    var numberFormatType = formatter.GetFormatType(value);
			                    if (typeof value == "number" && numberFormatType != $.wijmo.wijspread.NumberFormatType.DateTime) {
			                        if (formatString == "General")
			                            formatString = getGenericNumberFormat(value);
			                        //alert("formatString=" + formatString);
			                        if (cmd.commandName == "increasedecimals") {
			                            var pos = formatString.lastIndexOf("0");
			                            if (formatString.indexOf(",") != -1)
			                                formatString = formatString.insert(pos + 1, "0");
			                            else
			                                formatString = formatString.insert(pos + 1, ",0");
			                        }
			                        else {
			                            formatString = formatString.replace(",0", ",");
			                            if (formatString.indexOf(",0") == -1)
			                                formatString = formatString.replace(",", "");
			                        }
			                        //alert("formatString=" + formatString);
			                        sheet.getCell(r, c).formatter(new $.wijmo.wijspread.GeneralFormatter(formatString));
			                    }
			                }
			            }
			        }
			        break;
			    default:
			        if (cmd.commandName.substr(0, 6) == "format") {
			            var strFormat = $("#" + cmd.commandName).prop("title");
			            //alert(format);
			            var sels = sheet.getSelections();
			            for (var n = 0; n < sels.length; n++) {
			                var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
			                sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).formatter(new $.wijmo.wijspread.GeneralFormatter(strFormat, $.wijmo.wijspread.FormatMode.CustomMode));
			            }
                    }
                    else if (cmd.commandName.substr(0, 1) == "f") {
						var styleEle = document.getElementById("colorSample");
						var font = sheet.getCell(sheet.getActiveRowIndex(), sheet.getActiveColumnIndex(), $.wijmo.wijspread.SheetArea.viewport).font();
						if (font) {
							styleEle.style.font = font;
						}
						else {
							styleEle.style.font = "10pt Arial";
						}

						if (cmd.commandName.substr(0, 2) == "fn")
							styleEle.style.fontFamily = document.getElementById(cmd.commandName)["title"];
						if (cmd.commandName.substr(0, 2) == "fs")
							styleEle.style.fontSize = document.getElementById(cmd.commandName)["title"];
						var sels = sheet.getSelections();
						for (var n = 0; n < sels.length; n++) {
							var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
							//sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).font(document.defaultView.getComputedStyle(styleEle, "").font);
							sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).font(styleEle.style.font);
						}
					} else if (cmd.commandName.substr(0, 1) == "s") {
						if (cmd.commandName.substr(0, 2) == "sp") {
							var policy = 2;
							if (document.getElementById(cmd.commandName)["title"] == "Single") {
								policy = 0;
							} else if (document.getElementById(cmd.commandName)["title"] == "Range") {
								policy = 1;
							} else if (document.getElementById(cmd.commandName)["title"] == "MultiRange") {
								policy = 2;
							}
							sheet.selectionPolicy(policy);
						}
						if (cmd.commandName.substr(0, 2) == "su") {
							var unit = 0;
							if (document.getElementById(cmd.commandName)["title"] == "Cell") {
								unit = 0;
							} else if (document.getElementById(cmd.commandName)["title"] == "Row") {
								unit = 1;
							} else if (document.getElementById(cmd.commandName)["title"] == "Column") {
								unit = 2;
							}
							sheet.selectionUnit(unit);
						}
					}
					else {
					    alert(cmd.commandName);
					}

					break;
			}
			sheet.isPaintSuspended(false);
		}
	});
	$("#datavalidationdialog").wijribbon();
	$("#validationInputMessge").bind("mousedown", IsRangeSet);
	$("#validationErrorAlert").bind("mousedown", IsRangeSet);
	$("#validatorComparisonOperator").change(function () {
		if ($(this).val() >= 6) {
			$("#rangeStart").text("Ελάχιστο:");
			$("#rangeEnd").text("Μέγιστο:");
			$("#rangeEnd").show();
			$("#txtValidatorValue2").show();
		}
		else {
			$("#rangeStart").text("Τιμή:");
			$("#rangeEnd").hide();
			$("#txtValidatorValue2").hide();
		}
	});
	$("#validatorTypes").change(function () {
		validatorType = $(this).val();
		switch (validatorType) {
			case "AnyValidator":
				$("#validatorTab1").hide();
				$("#isTimeTab").hide();
				$("#isIntTab").hide();
				$("#validatorTab2").hide();
				break;
			case "DateValidator":
				$("#validatorTab1").show();
				$("#isTimeTab").show();
				$("#isIntTab").hide();
				$("#validatorTab2").hide();
				$("#rangeStart").text("Start date:");
				$("#rangeEnd").text("End date:");
				break;
			case "FormulaListValidator":
				$("#validatorTab2").show();
				$("#validatorTab1").hide();
				$("#rangevalidator").text("Formula:");
				$("#prompt").text("(e.g: E5:I5)");
				$("#datatitle").hide();
				break;
			case "FormulaValidator":
				$("#validatorTab2").show();
				$("#validatorTab1").hide();
				$("#rangevalidator").text("Formula:");
				$("#prompt").text("(e.g: =ISERROR(FIND(\" \",A1)))");
				$("#datatitle").hide();
				break;
			case "ListValidator":
				$("#validatorTab2").show();
				$("#validatorTab1").hide();
				$("#rangevalidator").text("Source");
				$("#prompt").text("(e.g: 1,2,3)");
				$("#datatitle").hide();
				break;
			case "NumberValidator":
				$("#validatorTab1").show();
				$("#isTimeTab").hide();
				$("#isIntTab").show();
				$("#validatorTab2").hide();
				$("#rangeStart").text("Ελάχιστο:");
				$("#rangeEnd").text("Μέγιστο:");
				break;
			case "TextLengthValidator":
				$("#validatorTab1").show();
				$("#isTimeTab").hide();
				$("#isIntTab").hide();
				$("#validatorTab2").hide();
				$("#rangeStart").text("Ελάχιστο:");
				$("#rangeEnd").text("Μέγιστο:");
				break;
		}
		if ($("#validatorComparisonOperator").val() >= 6) {
			$("#rangeStart").text("Ελάχιστο:");
			$("#rangeEnd").text("Μέγιστο:");
			$("#rangeEnd").show();
			$("#txtValidatorValue2").show();
		}
		else {
			$("#rangeStart").text("Τιμή:");
			$("#rangeEnd").hide();
			$("#txtValidatorValue2").hide();
		}
		
	});
	$("#chkValidatorIgnoreBlank").change(function () {
		var ss = $("#ss").wijspread("spread");
		var sheet = ss.getActiveSheet();
		var sels = sheet.getSelections();
		for (var i = 0; i < sels.length; i++) {
			var sel = sheet._getActualRange(sels[i]);
			for (var r = 0; r < sel.rowCount; r++) {
				for (var c = 0; c < sel.colCount; c++) {
					var dv = sheet.getDataValidator(sel.row + r, sel.col + c);
					if (dv) {
						dv.ignoreBlank = $(this).prop("checked");
					}
				}
			}
		}
	});

	$("#chkShowError").change(function () {
		var ss = $("#ss").wijspread("spread");
		var sheet = ss.getActiveSheet();
		var checked = $("#chkShowError").prop("checked");
		if (checked) {
			ss.bind($.wijmo.wijspread.Events.ValidationError, function (event, data) {
				var dv = data.validator;
				if (dv) {
					alert(dv.errorMessage);
				}
			});
		} else {
			ss.unbind($.wijmo.wijspread.Events.ValidationError);
		}
	});
	//  Conditional formatting rules
	$("#Rule1").bind("change", function () {
		var rule = $("#Rule1").val();
		var type = $("#ComparisonOperator1");
		setEnumTypeOfCF(rule, type);
	});
	$("#ComparisonOperator1").bind("change", function () {
		var type = $("#ComparisonOperator1").val();
		switch (type) {
			case "0":
			case "1":
			case "2":
			case "3":
			case "4":
			case "5":
				$("#andtext").hide();
				$("#value2").hide();
				break;
			case "6":
			case "7":
				$("#andtext").show();
				$("#andtext").text("και");
				$("#value2").show();
				break;
			default:
				$("#andtext").hide();
				$("#value2").hide();
				break;
		}
	});
	$("#conditionalformatdialog").dialog({
		autoOpen: false,
		height: 400,
		width: 550,
		modal: true,
		resizable: false,
		buttons: {
			OK: function () {
				var spread1 = $("#ss").wijspread("spread");
				var sheet = spread1.getActiveSheet();
				var sels = sheet.getSelections();
				var style = new $.wijmo.wijspread.Style();
				style.backColor = "red";
				style.foreColor = "green";
				var value1 = $("#value1").val();
				var value2 = $("#value2").val();
				var cfs = sheet.getConditionalFormats();
				var rule = $("#Rule1").val();
				var operator = parseInt($("#ComparisonOperator1").val());

				var minType = parseInt($("#minType").val());
				var midType = parseInt($("#midType").val());
				var maxType = parseInt($("#maxType").val());
				var midColor = midcolor;
				var minColor = mincolor;
				var maxColor = maxcolor;
				var midValue = $("#midValue").val();
				var maxValue = $("#maxValue").val();
				var minValue = $("#minValue").val();

				switch (rule) {
					case "0":
						var doubleValue1 = parseFloat(value1);
						var doubleValue2 = parseFloat(value2);
						cfs.addCellValueRule(operator, isNaN(doubleValue1) ? value1 : doubleValue1, isNaN(doubleValue2) ? value2 : doubleValue2, style, sels);
						break;
					case "1":
						cfs.addSpecificTextRule(operator, value1, style, sels);
						break;
					case "2":
						cfs.addDateOccurringRule(operator, style, sels);
						break;
					case "3":
						try {
							cfs.addFormulaRule(value1, style, sels);
						}
						catch (e) {
							cfs.removeRule(cfs.getRule(cfs.count() - 1));
							alert("Invalid Formula");
						}
						break;
					case "4":
						cfs.addTop10Rule(operator, parseInt(value1), style, sels);
						break;
					case "5":
						cfs.addUniqueRule(style, sels);
						break;
					case "6":
						cfs.addDuplicateRule(style, sels);
						break;
					case "7":
						cfs.addAverageRule(operator, style, sels);
						break;
					case "8":
						cfs.add2ScaleRule(minType, minValue, minColor, maxType, maxValue, maxColor, sels);
						break;
					case "9":
						cfs.add3ScaleRule(minType, minValue, minColor, midType, midValue, midColor, maxType, maxValue, maxColor, sels);
						break;
					default:
						var doubleValue1 = parseFloat(value1);
						var doubleValue2 = parseFloat(value2);
						cfs.addCellValueRule(operator, isNaN(doubleValue1) ? value1 : doubleValue1, isNaN(doubleValue2) ? value2 : doubleValue2, style, sels);
						break;
				}
				$(this).dialog("close");
				sheet.repaint();
			},
			Άκυρο: function () {
				$(this).dialog("close");
			}
		}
	});
	//  databar
	$("#databardialog").dialog({
		autoOpen: false,
		height: 500,
		width: 420,
		modal: true,
		resizable: false,
		buttons: {
			OK: function () {
				var spread1 = $("#ss").wijspread("spread");
				var sheet = spread1.getActiveSheet();
				sheet.isPaintSuspended(true);

				var selections = sheet.getSelections();
				if (selections) {
					var ranges = [];
					$.each(selections, function (i, v) {
						ranges.push(new $.wijmo.wijspread.Range(v.row, v.col, v.rowCount, v.colCount));
					});
					var cfs = sheet.getConditionalFormats();
					var dataBarRule = new $.wijmo.wijspread.DataBarRule();
					dataBarRule.ranges = ranges;
					dataBarRule.minimumType(parseInt($("#minimumType").val()));
					dataBarRule.minimumValue(parseValue($("#minimumValue").val()));
					dataBarRule.maximumType(parseInt($("#maximumType").val()));
					dataBarRule.maximumValue(parseValue($("#maximumValue").val()));
					dataBarRule.gradient($("#gradient").prop("checked"));
					dataBarRule.color(barcolor);
					dataBarRule.showBorder($("#showBorder").prop("checked"));
					dataBarRule.borderColor(barbordercolor);
					dataBarRule.dataBarDirection(parseInt($("#dataBarDirection").val()));
					dataBarRule.negativeFillColor(barnegativefillcolor);
					dataBarRule.useNegativeFillColor($("#useNegativeFillColor").prop("checked"));
					dataBarRule.negativeBorderColor(barnegativebordercolor);
					dataBarRule.useNegativeBorderColor($("#useNegativeBorderColor").prop("checked"));
					dataBarRule.axisPosition(parseInt($("#axisPosition").val()));
					dataBarRule.axisColor(baraxiscolor);
					dataBarRule.showBarOnly($("#showBarOnly").prop("checked"));
					cfs.addRule(dataBarRule);
				}

				sheet.isPaintSuspended(false);
				$(this).dialog("close");
			},
			Cancel: function () {
				$(this).dialog("close");
			}
		}
	});
	//  iconset
	$("#iconSetType").bind("change", function () {
		createIconCriteriaDOM();
	});
	$("#iconsetdialog").dialog({
		autoOpen: false,
		height: 400,
		width: 400,
		modal: true,
		resizable: false,
		buttons: {
			OK: function () {
				var spread1 = $("#ss").wijspread("spread");
				var sheet = spread1.getActiveSheet();
				sheet.isPaintSuspended(true);

				var selections = sheet.getSelections();
				if (selections) {
					var ranges = [];
					$.each(selections, function (i, v) {
						ranges.push(new $.wijmo.wijspread.Range(v.row, v.col, v.rowCount, v.colCount));
					});
					var cfs = sheet.getConditionalFormats();
					var iconSetRule = new $.wijmo.wijspread.IconSetRule();
					iconSetRule.ranges = ranges;
					iconSetRule.iconSetType(parseInt($("#iconSetType").val()));
					var $divs = $("#iconCriteriaSetting div");
					var iconCriteria = iconSetRule.iconCriteria();
					$.each($divs, function (i, v) {
						var isGreaterThanOrEqualTo = parseInt($(v.children[0]).val()) === 1;
						var iconValueType = parseInt($(v.children[2]).val());
						var iconValue = $(v.children[1]).val();
						if (iconValueType !== $.wijmo.wijspread.IconValueType.Formula) {
							iconValue = parseInt(iconValue);
						}
						iconCriteria[i] = new $.wijmo.wijspread.IconCriterion(isGreaterThanOrEqualTo, iconValueType, iconValue);
					});
					iconSetRule.reverseIconOrder($("#reverseIconOrder").prop("checked"));
					iconSetRule.showIconOnly($("#showIconOnly").prop("checked"));
					cfs.addRule(iconSetRule);
				}

				sheet.isPaintSuspended(false);
				$(this).dialog("close");
			},
			Cancel: function () {
				$(this).dialog("close");
			}
		}
	});
	$("#datavalidationdialog").dialog({
		autoOpen: false,
		height: 450,
		width: 400,
		modal: true,
		resizable: false,
		buttons: {
			"Καθαρισμός επικύρωσης": function () {
				var ss = $("#ss").wijspread("spread");
				var sheet = ss.getActiveSheet();
				var sels = sheet.getSelections();
				for (var i = 0; i < sels.length; i++) {
					var sel = sheet._getActualRange(sels[i]);
					for (var r = 0; r < sel.rowCount; r++) {
						for (var c = 0; c < sel.colCount; c++) {
							sheet.setDataValidator(sel.row + r, sel.col + c, null);
						}
					}
				}
				$("#validatorTypes").val("AnyValidator");
				$("#txtValidatorValue1").val("");
				$("#txtValidatorValue2").val("");
				$("#txtValidatorValue").val("");
				$("#validatorTab1").hide();
				$("#isTimeTab").hide();
				$("#isIntTab").hide();
				$("#validatorTab2").hide();
				$("#txtMessageTitle").val("");
				$("#txtMessageMessage").val("");
				$("#validatorErrorStyles").val("0");
				$("#txtErrorTitle").val("");
				$("#txtErrorMessage").val("");
				validatorType = "AnyValidator";
				$(this).dialog("close");
			},
			OK: function () {
				//setvalidator
				var gcdv = $.wijmo.wijspread.DefaultDataValidator;

				var ddv = null;
				var v1 = $("#txtValidatorValue1").val();
				var v2 = $("#txtValidatorValue2").val();
				switch (validatorType) {
					case "AnyValidator":
						ddv = new $.wijmo.wijspread.DefaultDataValidator();
						break;
					case "DateValidator":
						if ($("#chkIsTime").prop("checked")) {
							ddv = gcdv.createDateValidator(parseInt($("#validatorComparisonOperator").val()),
									isNaN(v1) ? v1 : new Date(v1),
									isNaN(v2) ? v2 : new Date(v2),
									true);
						} else {
							ddv = gcdv.createDateValidator(parseInt($("#validatorComparisonOperator").val()),
									isNaN(v1) ? v1 : new Date(v1),
									isNaN(v2) ? v2 : new Date(v2),
									false);
						}
						break;
					case "FormulaListValidator":
						ddv = gcdv.createFormulaListValidator($("#txtValidatorValue").val());
						break;
					case "FormulaValidator":
						ddv = gcdv.createFormulaValidator($("#txtValidatorValue").val());
						break;
					case "ListValidator":
						ddv = gcdv.createListValidator($("#txtValidatorValue").val());
						break;
					case "NumberValidator":
						if ($("#chkIsInteger").prop("checked")) {
							ddv = gcdv.createNumberValidator(parseInt($("#validatorComparisonOperator").val()),
									isNaN(v1) ? v1 : parseInt(v1),
									isNaN(v2) ? v2 : parseInt(v2),
									true);
						} else {
							ddv = gcdv.createNumberValidator(parseInt($("#validatorComparisonOperator").val()),
									isNaN(v1) ? v1 : parseFloat(v1),
									isNaN(v2) ? v2 : parseFloat(v2),
									false);
						}
						break;
					case "TextLengthValidator":
						ddv = gcdv.createTextLengthValidator(parseInt($("#validatorComparisonOperator").val()),
								isNaN(v1) ? v1 : parseInt(v1),
								isNaN(v2) ? v2 : parseInt(v2));
						break;
				}

				if (ddv != null) {
					ddv.errorMessage = $("#txtErrorMessage").val();
					ddv.errorStyle = parseInt($("#validatorErrorStyles").val());
					ddv.errorTitle = $("#txtErrorTitle").val();
					ddv.showErrorMessage = $("#chkShowError").prop("checked");
					ddv.ignoreBlank = $("#chkValidatorIgnoreBlank").prop("checked");
					var checked = $("#chkShowMessage").prop("checked");
					if (checked) {
						ddv.inputTitle = $("#txtMessageTitle").val();
						ddv.inputMessage = $("#txtMessageMessage").val();
					}

					var ss = $("#ss").wijspread("spread");
					var sheet = ss.getActiveSheet();
					sheet.isPaintSuspended(true);
					var sels = sheet.getSelections();
					for (var i = 0; i < sels.length; i++) {
						var sel = sheet._getActualRange(sels[i]);
						for (var r = 0; r < sel.rowCount; r++) {
							for (var c = 0; c < sel.colCount; c++) {
								sheet.setDataValidator(sel.row + r, sel.col + c, ddv);
							}
						}
					}
					sheet.isPaintSuspended(false);
				}
				$(this).dialog("close");
			},
			Άκυρο: function () {
				$(this).dialog("close");
			}
		}
	});
	//Cell Type

	$("#celltypedialog").dialog({
		autoOpen: false,
		height: 350,
		width: 350,
		modal: true,
		resizable: false,
		buttons: {
			Set: function () {
				var spread = $("#ss").wijspread("spread");
				var sheet = spread.getActiveSheet();
				var cellType;
				switch (selCellType) {
					case "TextCell":
						cellType = new $.wijmo.wijspread.TextCellType();
						break;
					case "ComboCell":
						cellType = new $.wijmo.wijspread.ComboBoxCellType();
						cellType.editorValueType(parseInt($("#selComboCellEditorValueType").val()));
						var itemsText = $("#txtComboCellItemsText").val().split(",");
						var itemsValue = $("#txtComboCellItemsValue").val().split(",");
						var itemsLength = itemsText.length > itemsValue.length ? itemsText.length : itemsValue.length;
						var items = [];
						for (var count = 0; count < itemsLength; count++) {
							var t = itemsText.length > count && itemsText[0] != "" ? itemsText[count] : undefined;
							var v = itemsValue.length > count && itemsValue[0] != "" ? itemsValue[count] : undefined;
							if (t != undefined && v != undefined) {
								items[count] = { text: t, value: v };
							}
							else if (t != undefined) {
								items[count] = { text: t };
							} else if (v != undefined) {
								items[count] = { value: v };
							}
						}
						cellType.items(items);
						break;
					case "CheckBoxCell":
						cellType = new $.wijmo.wijspread.CheckBoxCellType();
						if ($("#txtCheckBoxCellTextCaption").val() != "") {
							cellType.caption($("#txtCheckBoxCellTextCaption").val());
						}
						if ($("#txtCheckBoxCellTextTrue").val() != "") {
							cellType.textTrue($("#txtCheckBoxCellTextTrue").val());
						}
						if ($("#txtCheckBoxCellTextIndeterminate").val() != "") {
							cellType.textIndeterminate($("#txtCheckBoxCellTextIndeterminate").val());
						}
						if ($("#txtCheckBoxCellTextFalse").val() != "") {
							cellType.textFalse($("#txtCheckBoxCellTextFalse").val());
						}
						cellType.textAlign(parseInt($("#selCheckBoxCellAlign").val()));
						cellType.isThreeState($("#ckbCheckBoxCellIsThreeState").prop("checked"));
						break;
					case "ButtonCell":
						cellType = new $.wijmo.wijspread.ButtonCellType();
						if ($("#txtButtonCellMarginLeft").val() != "") {
							cellType.marginLeft(parseFloat($("#txtButtonCellMarginLeft").val()));
						}
						if ($("#txtButtonCellMarginTop").val() != "") {
							cellType.marginTop(parseFloat($("#txtButtonCellMarginTop").val()));
						}
						if ($("#txtButtonCellMarginRight").val() != "") {
							cellType.marginRight(parseFloat($("#txtButtonCellMarginRight").val()));
						}
						if ($("#txtButtonCellMarginBottom").val() != "") {
							cellType.marginBottom(parseFloat($("#txtButtonCellMarginBottom").val()));
						}
						if ($("#txtButtonCellText").val() != "") {
							cellType.text($("#txtButtonCellText").val());
						}
						if ($("#txtButtonCellBackColor").val() != "") {
							cellType.buttonBackColor($("#txtButtonCellBackColor").val());
						}
						break;
					case "HyperLinkCell":
						cellType = new $.wijmo.wijspread.HyperLinkCellType();
						if ($("#txtHyperLinkCellLinkColor").val() != "") {
							cellType.linkColor($("#txtHyperLinkCellLinkColor").val());
						}
						if ($("#txtHyperLinkCellVisitedLinkColor").val() != "") {
							cellType.visitedLinkColor($("#txtHyperLinkCellVisitedLinkColor").val());
						}
						if ($("#txtHyperLinkCellText").val() != "") {
							cellType.text($("#txtHyperLinkCellText").val());
						}
						if ($("#txtHyperLinkCellToolTip").val() != "") {
							cellType.linkToolTip($("#txtHyperLinkCellToolTip").val());
						}
						break;
				}
				sheet.isPaintSuspended(true);
				sheet.suspendEvent();
				var sels = sheet.getSelections();
				for (var i = 0; i < sels.length; i++) {
					var sel = sheet._getActualRange(sels[i]);
					for (var r = 0; r < sel.rowCount; r++) {
						for (var c = 0; c < sel.colCount; c++) {
							sheet.setCellType(sel.row + r, sel.col + c, cellType, $.wijmo.wijspread.SheetArea.viewport);
						}
					}
				}
				sheet.resumeEvent();
				sheet.isPaintSuspended(false);
				$(this).dialog("close");
			},
			Cancel: function () {
				$(this).dialog("close");
			}
		}
	});
	$("#colordialog").dialog({
		autoOpen: false,
		height: 420,
		width: 485,
		modal: true,
		resizable: false,
		buttons: {
			OK: function () {
				var spread = $("#ss").wijspread("spread");
				var sheet = spread.getActiveSheet();
				sheet.isPaintSuspended(true);
				var title = $("#colordialog").dialog("option", "title");
				if (title == "Χρώμα γεμίσματος") {
					var sels = sheet.getSelections();
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).backColor($("#selectedColor").val());
					}
				} else if (title == "Χρώμα γραμμάτων") {
					var sels = sheet.getSelections();
					for (var n = 0; n < sels.length; n++) {
						var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
						sheet.getCells(sel.row, sel.col, sel.row + sel.rowCount - 1, sel.col + sel.colCount - 1, $.wijmo.wijspread.SheetArea.viewport).foreColor($("#selectedColor").val());
					}
				} else if (title == "Tab Strip Color") {
					if (sheet) {
						var color = $("#selectedColor").val();
						sheet.sheetTabColor(color);
					}
				} else if (title == "Χρώμα γραμμής σταθεροποίησης") {
					if (sheet) {
						var color = $("#selectedColor").val();
						sheet.frozenlineColor(color);
					}
				} else if (title == "Bar Color") {
					barcolor = $("#selectedColor").val();
					$("#color").css("background", barcolor);
				} else if (title == "Bar Border Color") {
					barbordercolor = $("#selectedColor").val();
					$("#borderColor").css("background", barbordercolor);
				} else if (title == "Bar Negative Fill Color") {
					barnegativefillcolor = $("#selectedColor").val();
					$("#negativeFillColor").css("background", barnegativefillcolor);
				} else if (title == "Bar Negative Border Color") {
					barnegativebordercolor = $("#selectedColor").val();
					$("#negativeBorderColor").css("background", barnegativebordercolor);
				} else if (title == "Bar Axis Color") {
					baraxiscolor = $("#selectedColor").val();
					$("#axisColor").css("background", baraxiscolor);
				} else if (title == "Min Color") {
					mincolor = $("#selectedColor").val();
					$("#minColor").css("background", mincolor);
				} else if (title == "Mid Color") {
					midcolor = $("#selectedColor").val();
					$("#midColor").css("background", mincolor);
				} else if (title == "Max Color") {
					maxcolor = $("#selectedColor").val();
					$("#maxColor").css("background", maxcolor);
				}
				sheet.isPaintSuspended(false);
				$(this).dialog("close");
			},
			Άκυρο: function () {
				$(this).dialog("close");
			}
		}
	});
	$("#leftSide").change(function () {
		var checked = $("#leftSide").prop("checked");
		if (checked) {
			$("#border11").css("border-left", "1px solid gray");
			$("#border21").css("border-left", "1px solid gray");
			$("#bordertable").css("border-left", "1px solid gray");
		} else {
			$("#border11").css("border-left", "none");
			$("#border21").css("border-left", "none");
			$("#bordertable").css("border-left", "none");
		}
	});
	$("#topSide").change(function () {
		var checked = $("#topSide").prop("checked");
		if (checked) {
			$("#border11").css("border-top", "1px solid gray");
			$("#border12").css("border-top", "1px solid gray");
			$("#bordertable").css("border-top", "1px solid gray");
		} else {
			$("#border11").css("border-top", "none");
			$("#border12").css("border-top", "none");
			$("#bordertable").css("border-top", "none");
		}
	});
	$("#rightSide").change(function () {
		var checked = $("#rightSide").prop("checked");
		if (checked) {
			$("#border12").css("border-right", "1px solid gray");
			$("#border22").css("border-right", "1px solid gray");
			$("#bordertable").css("border-right", "1px solid gray");
		} else {
			$("#border12").css("border-right", "none");
			$("#border22").css("border-right", "none");
			$("#bordertable").css("border-right", "none");
		}
	});
	$("#bottomSide").change(function () {
		var checked = $("#bottomSide").prop("checked");
		if (checked) {
			$("#border21").css("border-bottom", "1px solid gray");
			$("#border22").css("border-bottom", "1px solid gray");
			$("#bordertable").css("border-bottom", "1px solid gray");
		} else {
			$("#border21").css("border-bottom", "none");
			$("#border22").css("border-bottom", "none");
			$("#bordertable").css("border-bottom", "none");
		}
	});
	$("#hInside").change(function () {
		var checked = $("#hInside").prop("checked");
		if (checked) {
			$("#border11").css("border-bottom", "1px solid gray");
			$("#border12").css("border-bottom", "1px solid gray");
			$("#border21").css("border-top", "1px solid gray");
			$("#border22").css("border-top", "1px solid gray");
		} else {
			$("#border11").css("border-bottom", "none");
			$("#border12").css("border-bottom", "none");
			$("#border21").css("border-top", "none");
			$("#border22").css("border-top", "none");
		}
	});
	$("#vInside").change(function () {
		var checked = $("#vInside").prop("checked");
		if (checked) {
			$("#border11").css("border-right", "1px solid gray");
			$("#border12").css("border-left", "1px solid gray");
			$("#border21").css("border-right", "1px solid gray");
			$("#border22").css("border-left", "1px solid gray");
		} else {
			$("#border11").css("border-right", "none");
			$("#border12").css("border-left", "none");
			$("#border21").css("border-right", "none");
			$("#border22").css("border-left", "none");
		}
	});

	$("#borderdialog").dialog({
		autoOpen: false,
		height: 450,
		width: 550,
		modal: true,
		resizable: false,
		buttons: {
			OK: function () {
				var spread = $("#ss").wijspread("spread");
				var sheet = spread.getActiveSheet();
				sheet.isPaintSuspended(true);
				var sels = sheet.getSelections();
				//var lineBorder = new $.wijmo.wijspread.LineBorder($("#lineColor").val(), $("#lineStyle").val());
				var lineBorder = new $.wijmo.wijspread.LineBorder($("#lineColor").val(), $.wijmo.wijspread.LineStyle[$("#lineStyle").val()]);
				for (var n = 0; n < sels.length; n++) {
					var sel = getActualCellRange(sels[n], sheet.getRowCount(), sheet.getColumnCount());
					sheet.setBorder(sel, lineBorder, {
						left: $("#leftSide").prop("checked"),
						top: $("#topSide").prop("checked"),
						right: $("#rightSide").prop("checked"),
						bottom: $("#bottomSide").prop("checked"),
						innerHorizontal: $("#hInside").prop("checked"),
						innerVertical: $("#vInside").prop("checked")
					});
				}
				sheet.isPaintSuspended(false);
				$(this).dialog("close");
			},
			Άκυρο: function () {
				$(this).dialog("close");
			}
		}
	});


	$("#ss").wijspread({ sheetCount: 2, newTabVisible: true }); // create wijspread control
	if ($.browser.msie && parseInt($.browser.version, 10) < 9) {
		//run for ie7/8
		var spread = $("#ss").wijspread("spread");
		spread.bind("SpreadsheetObjectLoaded", function () {
			initSpread();
		});
	} else {
		initSpread();
	}
});

function getGenericNumberFormat(value) {
    var strFormat = "0";
    var valueStr = value.toString();
    valueStr = valueStr.replace(".", ",");
    var dPoint = valueStr.lastIndexOf(",");
    if (dPoint > -1) {
        strFormat += ",";
        var decimals = valueStr.length - dPoint - 1;
        for (var i = 0; i < decimals; i++)
            strFormat += "0";
    }
    return strFormat;
}

function askisi_frouta2() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();


    sheet.reset();

    var jsonData = { "name": "Φρούτα", "defaults": { "rowHeight": 20, "colWidth": 62, "rowHeaderColWidth": 40, "colHeaderRowHeight": 20 }, "columns": { "0": { "size": 100, "dirty": true }, "1": { "size": 100, "dirty": true }, "2": { "size": 100, "dirty": true }, "3": { "size": 100, "dirty": true }, "4": { "size": 100, "dirty": true } }, "rows": { "0": { "size": 40, "dirty": true }, "2": { "size": 20, "dirty": true }, "3": { "size": 20, "dirty": true }, "4": { "size": 20, "dirty": true }, "5": { "size": 20, "dirty": true }, "6": { "size": 20, "dirty": true }, "7": { "size": 20, "dirty": true } }, "autoGenerateColumns": true, "dataSource": null, "frozenRowCount": 0, "frozenColCount": 0, "rowCount": 200, "columnCount": 20, "data": { "name": "Φύλλο1", "rowCount": 200, "colCount": 20, "dataTable": { "0": { "0": { "value": "Παραγωγή φρούτων", "style": { "backColor": "#BCF5A9", "hAlign": 1, "vAlign": 1, "font": "bold 30px 'comic sans ms'" } }, "rs": "e" }, "1": { "0": { "value": "Φρούτα", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": "Ιούνιος", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "2": { "value": "Ιούλιος", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "3": { "value": "Αύγουστος", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "4": { "value": "Σεπτέμβριος", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "5": { "value": "Σύνολο", "style": { "backColor": "#BEF781", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "rs": "e" }, "2": { "0": { "value": "Μήλα", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 345, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 400, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 125, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 90, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "3": { "0": { "value": "Πορτοκάλια", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 390, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 156, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 200, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 200, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "4": { "0": { "value": "Ανανάδες", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 400, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 125, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 345, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 156, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "5": { "0": { "value": "Κεράσια", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 125, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 200, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 390, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 400, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "6": { "0": { "value": "Σταφύλια", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 200, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 345, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 400, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 345, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "7": { "0": { "value": "Ροδάκινα", "style": { "backColor": "#D9FFD9", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "value": 156, "style": { "backColor": "#D9FFD9" } }, "2": { "value": 390, "style": { "backColor": "#D9FFD9" } }, "3": { "value": 345, "style": { "backColor": "#D9FFD9" } }, "4": { "value": 125, "style": { "backColor": "#D9FFD9" } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 } } }, "rs": "e" }, "8": { "0": { "value": "Σύνολο", "style": { "backColor": "#BEF781", "hAlign": 1, "vAlign": 1, "font": "bold 16px 'comic sans ms'" } }, "1": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } } }, "2": { "style": { "backColor": "#BEF781", "borderTop": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } } }, "3": { "style": { "backColor": "#BEF781", "borderTop": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } } }, "4": { "style": { "backColor": "#BEF781", "borderTop": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } } }, "5": { "style": { "backColor": "#BEF781", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } } }, "rs": "e" }, "10": { "0": { "value": "Προσπαθήστε να υπολογίσετε τις τιμές των κελιών μέσα στα κόκκινα πλαίσια χρησιμοποιώντας τους αντίστοιχους μαθηματικούς τύπους", "style": { "foreColor": "red", "hAlign": 1, "font": "bold 12px arial" } }, "rs": "e" } }, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0 } } }, "sparklineGroupManager": { "groups": [] }, "spans": { "0": { "row": 0, "rowCount": 1, "col": 0, "colCount": 6 }, "1": { "row": 10, "rowCount": 1, "col": 0, "colCount": 10 }, "length": 2 }, "selections": { "0": { "row": 10, "rowCount": 1, "col": 0, "colCount": 10 }, "selectionPolicy": 2, "selectionUnit": 0, "length": 1, "activeSelectedRangeIndex": 0 }, "activeRow": 10, "activeCol": 0, "gridline": { "color": "#D0D7E5", "showVerticalGridline": true, "showHorizontalGridline": true }, "allowCellOverflow": false, "referenceStyle": 0, "_zoomFactor": 1, "theme": { "_name": "Office", "_themeColor": { "_name": "Office", "_colorList": [{ "a": 255, "r": 255, "g": 255, "b": 255 }, { "a": 255, "r": 238, "g": 236, "b": 225 }, { "a": 255, "r": 0, "g": 0, "b": 0 }, { "a": 255, "r": 31, "g": 73, "b": 125 }, { "a": 255, "r": 79, "g": 129, "b": 189 }, { "a": 255, "r": 192, "g": 80, "b": 77 }, { "a": 255, "r": 155, "g": 187, "b": 89 }, { "a": 255, "r": 128, "g": 100, "b": 162 }, { "a": 255, "r": 75, "g": 172, "b": 198 }, { "a": 255, "r": 247, "g": 150, "b": 70 }, { "a": 255, "r": 0, "g": 0, "b": 255 }, { "a": 255, "r": 128, "g": 0, "b": 128 }] }, "_headingFont": "Cambria", "_bodyFont": "Calibri" }, "showRowRangeGroup": true, "showColumnRangeGroup": true, "rowRangeGroup": { "itemsCount": 200, "itemsData": [], "direction": 1, "head": null, "tail": null }, "colRangeGroup": { "itemsCount": 20, "itemsData": [], "direction": 1, "head": null, "tail": null }, "conditionalFormats": { "rules": [] }, "sheetTabColor": null, "frozenlineColor": "black", "rowHeaderAutoText": 1, "colHeaderAutoText": 2, "rowHeaderAutoTextIndex": -1, "colHeaderAutoTextIndex": -1, "rowHeaderVisible": true, "colHeaderVisible": true, "rowHeaderColCount": 1, "colHeaderRowCount": 1, "rowHeaderData": { "rowCount": 200, "colCount": 1, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "colHeaderData": { "rowCount": 1, "colCount": 20, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "rowHeaderSpan": {}, "colHeaderSpan": {}, "rowHeaderColInfos": {}, "colHeaderRowInfos": {}, "isProtected": false, "borderColor": "black", "borderWidth": 0, "allowDragDrop": false, "allowDragFill": true, "allowUndo": true, "allowEditorReservedLocations": true }
    sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.isPaintSuspended(false);
}


function askisi_podosfairo2() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();


    sheet.reset();

    var jsonData = { "name": "Ποδόσφαιρο", "defaults": { "rowHeight": 20, "colWidth": 62, "rowHeaderColWidth": 40, "colHeaderRowHeight": 20 }, "columns": { "0": { "size": 30, "dirty": true }, "1": { "size": 90, "dirty": true }, "2": { "size": 60, "dirty": true }, "3": { "size": 60, "dirty": true }, "4": { "size": 60, "dirty": true }, "5": { "size": 60, "dirty": true }, "6": { "size": 60, "dirty": true }, "7": { "size": 60, "dirty": true }, "8": { "size": 60, "dirty": true }, "9": { "size": 60, "dirty": true }, "10": { "size": 60, "dirty": true }, "11": { "size": 60, "dirty": true }, "12": { "size": 60, "dirty": true }, "13": { "size": 60, "dirty": true }, "14": { "size": 60, "dirty": true }, "15": { "size": 60, "dirty": true }, "16": { "size": 60, "dirty": true }, "17": { "size": 60, "dirty": true }, "18": { "size": 60, "dirty": true } }, "rows": { "0": { "size": 30, "dirty": true } }, "autoGenerateColumns": true, "dataSource": null, "frozenRowCount": 0, "frozenColCount": 0, "rowCount": 200, "columnCount": 26, "data": { "name": "Φύλλο1", "rowCount": 200, "colCount": 26, "dataTable": { "0": { "0": { "value": "Βαθμολογία Super League 2013", "style": { "backColor": "rgb(210, 211, 226)", "hAlign": 1, "vAlign": 1, "font": "bold 24px arial" } }, "1": { "style": { "vAlign": 1 } }, "2": { "style": { "vAlign": 1 } }, "3": { "style": { "vAlign": 1 } }, "4": { "style": { "vAlign": 1 } }, "5": { "style": { "vAlign": 1 } }, "6": { "style": { "vAlign": 1 } }, "7": { "style": { "vAlign": 1 } }, "8": { "style": { "vAlign": 1 } }, "9": { "style": { "vAlign": 1 } }, "10": { "style": { "vAlign": 1 } }, "11": { "style": { "vAlign": 1 } }, "12": { "style": { "vAlign": 1 } }, "13": { "style": { "vAlign": 1 } }, "14": { "style": { "vAlign": 1 } }, "15": { "style": { "vAlign": 1 } }, "16": { "style": { "vAlign": 1 } }, "17": { "style": { "vAlign": 1 } }, "rs": "e" }, "1": { "0": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "1": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "2": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "3": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "4": { "value": "Γκολ", "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "bold 12px arial" } }, "5": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "6": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "7": { "value": "Σύνολο", "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "bold 12px arial" } }, "8": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "9": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "10": { "value": "Εντός", "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "bold 12px arial" } }, "11": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "12": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "13": { "value": "Εκτός", "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "bold 12px arial" } }, "14": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "15": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "16": { "value": "Ισοβαθμίες", "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "bold 12px arial" } }, "17": { "style": { "vAlign": 1, "font": "bold 12px arial" } }, "rs": "e" }, "2": { "0": { "value": "Ομάδα", "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "1": { "style": { "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "2": { "value": "Αγώνες", "style": { "backColor": "rgb(239, 230, 137)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "3": { "value": "Βαθμοί", "style": { "backColor": "rgb(239, 230, 137)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "4": { "value": "+", "style": { "backColor": "rgb(183, 207, 222)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "5": { "value": "-", "style": { "backColor": "rgb(183, 207, 222)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "6": { "value": "ΔΙΑΦ.", "style": { "backColor": "rgb(183, 207, 222)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "7": { "value": "Νίκες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "8": { "value": "Ισοπαλίες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "9": { "value": "Ήτες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "10": { "value": "Νίκες", "style": { "backColor": "rgb(214, 214, 214)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "11": { "value": "Ισοπαλίες", "style": { "backColor": "rgb(214, 214, 214)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "12": { "value": "Ήτες", "style": { "backColor": "rgb(214, 214, 214)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "13": { "value": "Νίκες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "14": { "value": "Ισοπαλίες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "15": { "value": "Ήτες", "style": { "backColor": "rgb(228, 228, 228)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "16": { "value": "Βαθμοί", "style": { "backColor": "rgb(214, 214, 214)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "value": "Δ.Γκολ", "style": { "backColor": "rgb(214, 214, 214)", "hAlign": 1, "vAlign": 1, "font": "bold 11px arial", "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "3": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "Ολυμπιακός" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 77 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 64 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 16 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 48 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 24 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 5 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "red", "style": 12 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 1 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 12 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 12 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 0 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "4": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "Π.Α.Ο.Κ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 62 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 46 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 19 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 27 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 18 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 4 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 12 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "5": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΑΣΤ.ΤΡΙΠΟΛΗΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 56 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 41 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 25 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 16 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 17 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 5 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "6": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΑΤΡΟΜΗΤΟΣ ΑΘ." }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 46 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 26 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 22 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 4 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 11 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 13 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 6 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 8 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 10 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "7": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΠΑΣ ΓΙΑΝΝΙΝΑ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 44 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 28 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 24 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 4 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 12 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "8": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΠΑΝΑΘΗΝΑΪΚΟΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 40 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 32 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 2 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 12 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 0 }, "rs": "e" }, "9": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "SKODA ΞΑΝΘΗ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 40 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 28 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 26 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 2 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 0 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "10": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 8 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΠΑΝΙΩΝΙΟΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 36 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 35 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 42 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -7 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 11 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 3 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 16 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 8 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 9 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "11": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 9 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΠΛΑΤΑΝΙΑΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 36 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 29 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 42 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -13 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 6 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 14 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 10 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "12": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 10 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΠΑΝΘΡΑΚΙΚΟΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 36 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 33 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -3 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 10 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 6 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 14 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "13": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΛΕΒΑΔΕΙΑΚΟΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 34 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 21 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 35 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -14 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 9 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 7 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 14 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 9 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "14": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 12 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΒΕΡΟΙΑ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 33 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 35 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -5 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 9 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 13 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 8 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "rs": "e" }, "15": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 13 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΑΡΗΣ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 33 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 32 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 40 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -8 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 7 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 12 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 11 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 9 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": -1 }, "rs": "e" }, "16": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 14 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "Ο.Φ.Η." }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 32 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 33 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 46 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -13 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 14 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "17": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 15 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "A.E.K." }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 27 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 21 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 36 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": -15 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 8 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 6 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "DarkGray", "style": 4 } }, "value": 16 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 6 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 4 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 2 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "18": { "0": { "style": { "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 16 }, "1": { "style": { "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": "ΚΕΡΚΥΡΑ" }, "2": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 30 }, "3": { "style": { "backColor": "rgb(249, 244, 189)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "LightGray", "style": 2 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } }, "value": 20 }, "4": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 16 }, "5": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 41 }, "6": { "style": { "backColor": "rgb(212, 225, 233)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "red", "style": 12 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "red", "style": 12 } }, "value": -25 }, "7": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "red", "style": 12 } }, "value": 4 }, "8": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "DarkGray", "style": 4 }, "borderBottom": { "color": "red", "style": 12 } }, "value": 8 }, "9": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderLeft": { "color": "DarkGray", "style": 4 }, "borderTop": { "color": "DarkGray", "style": 4 }, "borderRight": { "color": "red", "style": 12 }, "borderBottom": { "color": "red", "style": 12 } }, "value": 18 }, "10": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "11": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 5 }, "12": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 7 }, "13": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 1 }, "14": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 3 }, "15": { "style": { "backColor": "rgb(244, 244, 244)", "hAlign": 1, "vAlign": 1, "font": "11px arial", "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } }, "value": 11 }, "16": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "17": { "style": { "backColor": "rgb(230, 230, 230)", "hAlign": 1, "vAlign": 1, "borderTop": { "color": "LightGray", "style": 2 }, "borderBottom": { "color": "LightGray", "style": 2 } } }, "rs": "e" }, "20": { "0": { "value": "Προσπαθήστε να υπολογίσετε τις τιμές των κελιών μέσα στα κόκκινα πλαίσια χρησιμοποιώντας τους αντίστοιχους μαθηματικούς τύπους", "style": { "foreColor": "red", "hAlign": 1, "font": "bold 12px arial" } }, "rs": "e" } }, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0 } } }, "sparklineGroupManager": { "groups": [] }, "spans": { "0": { "row": 0, "rowCount": 1, "col": 0, "colCount": 18 }, "1": { "row": 1, "rowCount": 1, "col": 4, "colCount": 3 }, "2": { "row": 1, "rowCount": 1, "col": 7, "colCount": 3 }, "3": { "row": 1, "rowCount": 1, "col": 10, "colCount": 3 }, "4": { "row": 1, "rowCount": 1, "col": 13, "colCount": 3 }, "5": { "row": 1, "rowCount": 1, "col": 16, "colCount": 2 }, "6": { "row": 2, "rowCount": 1, "col": 0, "colCount": 2 }, "7": { "row": 20, "rowCount": 1, "col": 0, "colCount": 18 }, "length": 8 }, "selections": { "0": { "row": 20, "rowCount": 1, "col": 0, "colCount": 18 }, "selectionPolicy": 2, "selectionUnit": 0, "length": 1, "activeSelectedRangeIndex": 0 }, "activeRow": 20, "activeCol": 0, "gridline": { "color": "#D0D7E5", "showVerticalGridline": true, "showHorizontalGridline": true }, "allowCellOverflow": false, "referenceStyle": 0, "_zoomFactor": 1, "theme": { "_name": "Office", "_themeColor": { "_name": "Office", "_colorList": [{ "a": 255, "r": 255, "g": 255, "b": 255 }, { "a": 255, "r": 238, "g": 236, "b": 225 }, { "a": 255, "r": 0, "g": 0, "b": 0 }, { "a": 255, "r": 31, "g": 73, "b": 125 }, { "a": 255, "r": 79, "g": 129, "b": 189 }, { "a": 255, "r": 192, "g": 80, "b": 77 }, { "a": 255, "r": 155, "g": 187, "b": 89 }, { "a": 255, "r": 128, "g": 100, "b": 162 }, { "a": 255, "r": 75, "g": 172, "b": 198 }, { "a": 255, "r": 247, "g": 150, "b": 70 }, { "a": 255, "r": 0, "g": 0, "b": 255 }, { "a": 255, "r": 128, "g": 0, "b": 128 }] }, "_headingFont": "Cambria", "_bodyFont": "Calibri" }, "showRowRangeGroup": true, "showColumnRangeGroup": true, "rowRangeGroup": { "itemsCount": 200, "itemsData": [], "direction": 1, "head": null, "tail": null }, "colRangeGroup": { "itemsCount": 26, "itemsData": [], "direction": 1, "head": null, "tail": null }, "conditionalFormats": { "rules": [] }, "sheetTabColor": null, "frozenlineColor": "black", "rowHeaderAutoText": 1, "colHeaderAutoText": 2, "rowHeaderAutoTextIndex": -1, "colHeaderAutoTextIndex": -1, "rowHeaderVisible": true, "colHeaderVisible": true, "rowHeaderColCount": 1, "colHeaderRowCount": 1, "rowHeaderData": { "rowCount": 200, "colCount": 1, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "colHeaderData": { "rowCount": 1, "colCount": 26, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "rowHeaderSpan": {}, "colHeaderSpan": {}, "rowHeaderColInfos": {}, "colHeaderRowInfos": {}, "isProtected": false, "borderColor": "black", "borderWidth": 0, "allowDragDrop": false, "allowDragFill": true, "allowUndo": true, "allowEditorReservedLocations": true }

    sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.isPaintSuspended(false);
}


function askisi_bookstore() {

    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();

    sheet.reset();

    var jsonData = { "name": "Βιβλιοπωλείο", "defaults": { "rowHeight": 20, "colWidth": 62, "rowHeaderColWidth": 40, "colHeaderRowHeight": 20 }, "columns": { "0": { "size": 37, "dirty": true }, "1": { "size": 130, "dirty": true }, "2": { "size": 88, "dirty": true }, "3": { "size": 116, "dirty": true }, "4": { "size": 80, "dirty": true }, "6": { "size": 95, "dirty": true }, "7": { "size": 120, "dirty": true }, "8": { "size": 85, "dirty": true }, "length": 20 }, "rows": { "0": { "size": 29, "dirty": true }, "length": 199 }, "autoGenerateColumns": true, "dataSource": null, "frozenRowCount": 0, "frozenColCount": 0, "rowCount": 199, "columnCount": 20, "data": { "name": "Φύλλο1", "rowCount": 199, "colCount": 20, "dataTable": { "0": { "0": { "value": "ΤΙΜΟΛΟΓΙΟ ΒΙΒΛΙΟΠΩΛΕΙΟΥ", "style": { "hAlign": 1, "font": "bold 20px arial", "_autoFormatter": null } }, "1": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "2": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "3": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "4": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "5": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "6": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "7": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "8": { "style": { "hAlign": 1, "font": "bold 20px arial" } }, "rs": "e" }, "1": { "0": { "style": { "font": "12px arial" } }, "1": { "style": { "font": "12px arial" } }, "2": { "style": { "font": "12px arial" } }, "3": { "style": { "font": "12px arial" } }, "4": { "style": { "font": "12px arial" } }, "5": { "style": { "font": "12px arial" } }, "6": { "style": { "font": "12px arial" } }, "7": { "style": { "font": "12px arial" } }, "8": { "style": { "font": "12px arial" } }, "rs": "e" }, "2": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΗΜΕΡΟΜΗΝΙΑ", "style": { "hAlign": 1, "font": "12px arial" } }, "2": { "value": "/Date(1379624400000)/", "style": { "hAlign": 1, "font": "bold 12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDateTime"], "validDateTimeFormatString": "dd/MM/yyyy", "formatString": "dd/mm/yyyy", "hasJD": false, "absoluteTime": null, "absTimeParts": null, "hasYearDelay": false, "partLocaleID": null, "partDbNumberFormat": null, "ExactlyMatch": false }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "dd/MM/yyyy" }] } } }, "3": { "style": { "font": "12px arial" } }, "4": { "style": { "font": "12px arial" } }, "5": { "style": { "font": "12px arial" } }, "6": { "value": "ΕΠΩΝΥΜΙΑ", "style": { "hAlign": 1, "font": "12px arial" } }, "7": { "value": "ΒΑΣΙΛΕΙΟΥ ΓΕΩΡΓΙΟΣ", "style": { "hAlign": 1, "font": "bold 12px arial" } }, "8": { "style": { "font": "12px arial" } }, "rs": "e" }, "3": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΑΡΙΘΜ. ΠΑΡΑΣΤΑΤΙΚΟΥ", "style": { "font": "12px arial", "_autoFormatter": null } }, "2": { "value": 456, "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "3": { "style": { "font": "12px arial" } }, "4": { "style": { "font": "12px arial" } }, "5": { "style": { "font": "12px arial" } }, "6": { "value": "ΑΦΜ", "style": { "hAlign": 1, "font": "12px arial", "_autoFormatter": null } }, "7": { "value": 123456789, "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "8": { "style": { "font": "12px arial" } }, "rs": "e" }, "4": { "0": { "style": { "font": "12px arial" } }, "1": { "style": { "font": "12px arial" } }, "2": { "style": { "font": "12px arial" } }, "3": { "style": { "font": "12px arial" } }, "4": { "style": { "font": "12px arial" } }, "5": { "style": { "font": "12px arial" } }, "6": { "style": { "font": "12px arial" } }, "7": { "style": { "font": "12px arial" } }, "8": { "style": { "font": "12px arial" } }, "rs": "e" }, "5": { "0": { "value": "A/A", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "1": { "value": "ΕΙΔΟΣ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "2": { "value": "ΠΟΣΟΤΗΤΑ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "3": { "value": "ΤΙΜΗ ΜΟΝΑΔΑΣ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "4": { "value": "ΚΑΘΑΡΗ ΑΞΙΑ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "5": { "value": "ΦΠΑ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "6": { "value": "ΑΞΙΑ ΜΕ ΦΠΑ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "7": { "value": "ΕΚΠΤΩΣΗ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "8": { "value": "ΤΕΛΙΚΗ ΑΞΙΑ", "style": { "backColor": "#E0E6F8", "hAlign": 1, "font": "bold 12px arial", "borderBottom": { "color": "Silver", "style": 1 } } }, "rs": "e" }, "6": { "0": { "value": 1, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "ΒΙΒΛΙΑ", "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "2": { "value": 5, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "3": { "value": 15.4, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "4": { "value": null, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "5": { "value": 0.23, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0%", "fullFormatString": "0%", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0%", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0%" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "6": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 } } }, "7": { "value": 10, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "8": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 } } }, "rs": "e" }, "7": { "0": { "value": 2, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "ΤΕΤΡΑΔΙΑ", "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "2": { "value": 10, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "3": { "value": 1.2, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "4": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true, "_autoFormatter": null }, "bindingPath": null }, "5": { "value": 0.12, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0%", "fullFormatString": "0%", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0%", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0%" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "6": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 } } }, "7": { "value": 2, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "8": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true }, "bindingPath": null }, "rs": "e" }, "8": { "0": { "value": 3, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "ΣΤΥΛΟ", "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "2": { "value": 5, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "3": { "value": 1.5, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "4": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true, "_autoFormatter": null }, "bindingPath": null }, "5": { "value": 0.08, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0%", "fullFormatString": "0%", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0%", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0%" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "6": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 } } }, "7": { "value": 1.5, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "8": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true }, "bindingPath": null }, "rs": "e" }, "9": { "0": { "value": 4, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "ΜΑΡΚΑΔΟΡΟΙ", "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "2": { "value": 25, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "3": { "value": 2.7, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "4": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true, "_autoFormatter": null }, "bindingPath": null }, "5": { "value": 0.05, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0%", "fullFormatString": "0%", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0%", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0%" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "6": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 } } }, "7": { "value": 9, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "8": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Silver", "style": 1 }, "locked": true }, "bindingPath": null }, "rs": "e" }, "10": { "0": { "value": 5, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "ΜΟΛΥΒΙΑ", "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "bold 12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "2": { "value": 20, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "3": { "value": 0.7, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "4": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 }, "locked": true, "_autoFormatter": null }, "bindingPath": null }, "5": { "value": 0.1, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0%", "fullFormatString": "0%", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0%", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0%" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "6": { "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } } }, "7": { "value": 3, "style": { "backColor": "#E0F2F7", "hAlign": 1, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Silver", "style": 1 }, "borderBottom": { "color": "Silver", "style": 1 }, "_autoFormatter": null } }, "8": { "value": null, "formula": "", "style": { "backColor": "#E0F2F7", "foreColor": "black", "hAlign": 1, "vAlign": 0, "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Silver", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 }, "locked": true }, "bindingPath": null }, "rs": "e" }, "11": { "0": { "style": { "font": "12px arial" } }, "1": { "style": { "font": "12px arial" } }, "2": { "style": { "font": "12px arial" } }, "3": { "style": { "font": "12px arial" } }, "4": { "style": { "font": "12px arial" } }, "5": { "style": { "font": "12px arial" } }, "6": { "style": { "font": "12px arial" } }, "7": { "style": { "font": "12px arial" } }, "8": { "style": { "font": "12px arial" } }, "rs": "e" }, "12": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΣΥΝΟΛΑ", "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "2": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "3": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "4": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 0 } } }, "5": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Red", "style": 0 }, "borderBottom": { "color": "Red", "style": 0 } } }, "6": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 0 } } }, "7": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "8": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 } } }, "rs": "e" }, "13": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΜΕΣΟΣ ΟΡΟΣ", "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "2": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "3": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "4": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 } } }, "5": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "6": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 } } }, "7": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] } } }, "8": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 } } }, "rs": "e" }, "14": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΜΕΓΙΣΤΗ ΤΙΜΗ", "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "2": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 0 }, "borderTop": { "color": "Red", "style": 0 } } }, "3": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Red", "style": 0 } } }, "4": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 0 }, "borderRight": { "color": "Red", "style": 12 } } }, "5": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Red", "style": 0 } } }, "6": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 0 }, "borderRight": { "color": "Red", "style": 12 } } }, "7": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderTop": { "color": "Red", "style": 0 } } }, "8": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 0 }, "borderRight": { "color": "Red", "style": 12 } } }, "rs": "e" }, "15": { "0": { "style": { "font": "12px arial" } }, "1": { "value": "ΕΛΑΧΙΣΤΗ ΤΙΜΗ", "style": { "hAlign": 1, "font": "bold 12px arial", "_autoFormatter": null } }, "2": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 0 }, "borderBottom": { "color": "Red", "style": 0 } } }, "3": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderBottom": { "color": "Red", "style": 0 } } }, "4": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } } }, "5": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderBottom": { "color": "Red", "style": 0 } } }, "6": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } } }, "7": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderBottom": { "color": "Red", "style": 0 } } }, "8": { "style": { "font": "12px arial", "formatter": { "formatters": [{ "_classNames": ["CustomNumberFormat", "IFormatter", "IFormatProviderSupport"], "conditionFormatPart": null, "colorFormatPart": null, "localeIDFormatPart": null, "dbNumberFormatPart": null, "numberFormat": { "numberFormatString": "0,00", "fullFormatString": "0,00", "isGeneralNumber": false, "fractionIntegerFormat": null, "fractionNumeratorFormat": null, "fractionDenominatorFormat": null, "excelFormatString": "0,00", "_classNames": ["NumberFormatBase", "IFormatter", "IFormatProviderSupport", "NumberFormatDigital"], "numberStringConverter": null, "numberFormatInfo": null, "dateTimeFormatInfo": null, "partLocaleID": null, "partDbNumberFormat": null }, "dateTimeFormatInfo": null, "numberFormatInfo": null, "formatCached": "0,00" }] }, "borderLeft": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } } }, "rs": "e" }, "16": { "0": { "value": "Προσπαθήστε να υπολογίσετε τις τιμές των κελιών μέσα στα κόκκινα πλαίσια χρησιμοποιώντας τους αντίστοιχους μαθηματικούς τύπους", "formula": "", "style": { "foreColor": "red", "hAlign": 1, "vAlign": 0, "font": "bold 12px arial", "locked": true }, "bindingPath": null }, "1": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "2": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "3": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "4": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "5": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "6": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "7": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "8": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "9": { "value": null, "formula": "", "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0, "locked": true }, "bindingPath": null }, "10": { "value": null, "formula": "", "style": null, "bindingPath": null }, "11": { "value": null, "formula": "", "style": null, "bindingPath": null }, "12": { "value": null, "formula": "", "style": null, "bindingPath": null }, "13": { "value": null, "formula": "", "style": null, "bindingPath": null }, "14": { "value": null, "formula": "", "style": null, "bindingPath": null }, "15": { "value": null, "formula": "", "style": null, "bindingPath": null }, "16": { "value": null, "formula": "", "style": null, "bindingPath": null }, "17": { "value": null, "formula": "", "style": null, "bindingPath": null }, "rs": "e" } }, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0 } } }, "sparklineGroupManager": { "groups": [] }, "spans": { "0": { "row": 0, "rowCount": 1, "col": 0, "colCount": 9 }, "1": { "row": 16, "rowCount": 1, "col": 0, "colCount": 10 }, "length": 2 }, "selections": { "0": { "row": 16, "rowCount": 1, "col": 0, "colCount": 10 }, "selectionPolicy": 2, "selectionUnit": 0, "length": 1, "activeSelectedRangeIndex": 0 }, "activeRow": 16, "activeCol": 0, "gridline": { "color": "#D0D7E5", "showVerticalGridline": true, "showHorizontalGridline": true }, "allowCellOverflow": false, "referenceStyle": 0, "_zoomFactor": 1, "theme": { "_name": "Office", "_themeColor": { "_name": "Office", "_colorList": [{ "a": 255, "r": 255, "g": 255, "b": 255 }, { "a": 255, "r": 238, "g": 236, "b": 225 }, { "a": 255, "r": 0, "g": 0, "b": 0 }, { "a": 255, "r": 31, "g": 73, "b": 125 }, { "a": 255, "r": 79, "g": 129, "b": 189 }, { "a": 255, "r": 192, "g": 80, "b": 77 }, { "a": 255, "r": 155, "g": 187, "b": 89 }, { "a": 255, "r": 128, "g": 100, "b": 162 }, { "a": 255, "r": 75, "g": 172, "b": 198 }, { "a": 255, "r": 247, "g": 150, "b": 70 }, { "a": 255, "r": 0, "g": 0, "b": 255 }, { "a": 255, "r": 128, "g": 0, "b": 128 }] }, "_headingFont": "Cambria", "_bodyFont": "Calibri" }, "showRowRangeGroup": true, "showColumnRangeGroup": true, "rowRangeGroup": { "itemsCount": 199, "itemsData": [], "direction": 1, "head": null, "tail": null }, "colRangeGroup": { "itemsCount": 20, "itemsData": [], "direction": 1, "head": null, "tail": null }, "conditionalFormats": { "rules": [] }, "sheetTabColor": null, "frozenlineColor": "black", "rowHeaderAutoText": 1, "colHeaderAutoText": 2, "rowHeaderAutoTextIndex": -1, "colHeaderAutoTextIndex": -1, "rowHeaderVisible": true, "colHeaderVisible": true, "rowHeaderColCount": 1, "colHeaderRowCount": 1, "rowHeaderData": { "rowCount": 199, "colCount": 1, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "colHeaderData": { "rowCount": 1, "colCount": 20, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "rowHeaderSpan": {}, "colHeaderSpan": {}, "rowHeaderColInfos": {}, "colHeaderRowInfos": {}, "clipBoardOptions": 0, "isProtected": false, "borderColor": "black", "borderWidth": 0, "allowDragDrop": false, "allowDragFill": true, "allowUndo": true, "allowEditorReservedLocations": true }
	sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.getCell(2, 2).formatter(new $.wijmo.wijspread.GeneralFormatter("dd/MM/yyyy", $.wijmo.wijspread.FormatMode.CustomMode));
    sheet.getCells(6, 3, 10, 4).formatter(new $.wijmo.wijspread.GeneralFormatter("0,00", $.wijmo.wijspread.FormatMode.CustomMode));
    sheet.getCells(6, 5, 10, 5).formatter(new $.wijmo.wijspread.GeneralFormatter("0%", $.wijmo.wijspread.FormatMode.CustomMode));
    sheet.getCells(6, 6, 10, 8).formatter(new $.wijmo.wijspread.GeneralFormatter("0,00", $.wijmo.wijspread.FormatMode.CustomMode));
    sheet.getCells(12, 2, 15, 8).formatter(new $.wijmo.wijspread.GeneralFormatter("0,00", $.wijmo.wijspread.FormatMode.CustomMode));

    sheet.isPaintSuspended(false);
}

function askisi_calendar() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();

    sheet.reset();

	var jsonData = {"name":"Ημερολόγιο","defaults":{"rowHeight":20,"colWidth":62,"rowHeaderColWidth":40,"colHeaderRowHeight":20},"columns":{"0":{"size":102,"dirty":true},"1":{"size":102,"dirty":true},"2":{"size":102,"dirty":true},"3":{"size":102,"dirty":true},"4":{"size":102,"dirty":true},"5":{"size":102,"dirty":true},"6":{"size":102,"dirty":true},"length":20},"rows":{"0":{"size":50.84375,"dirty":true},"1":{"size":28.84375,"dirty":true},"2":{"size":62.84375,"dirty":true},"3":{"size":62.84375,"dirty":true},"4":{"size":62.84375,"dirty":true},"5":{"size":62.84375,"dirty":true},"6":{"size":62.84375,"dirty":true},"length":200},"autoGenerateColumns":true,"dataSource":null,"frozenRowCount":0,"frozenColCount":0,"rowCount":200,"columnCount":20,"data":{"name":"Φύλλο1","rowCount":200,"colCount":20,"dataTable":{"0":{"0":{"value":"Ιανουάριος 2014","style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond","_autoFormatter":null}},"1":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"2":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"3":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"4":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"5":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"6":{"style":{"backColor":"#084B8A","foreColor":"#FFFFFF","hAlign":1,"font":"30pt Garamond"}},"rs":"e"},"1":{"0":{"value":"Δευ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"1":{"value":"Τρι","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"2":{"value":"Τετ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"3":{"value":"Πεμ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"4":{"value":"Παρ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"5":{"value":"Σαβ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"6":{"value":"Κυρ","style":{"backColor":"#A9BCF5","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Gray","style":5},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"rs":"e"},"2":{"0":{"style":{"backColor":"#E6E6E6","foreColor":"#848484","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"value":30},"1":{"style":{"backColor":"#E6E6E6","foreColor":"#848484","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"value":31},"2":{"value":1,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"3":{"value":2,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"4":{"value":3,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"5":{"value":4,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"6":{"value":5,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"rs":"e"},"3":{"0":{"value":6,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"1":{"value":7,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"2":{"value":8,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"3":{"value":9,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"4":{"value":10,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"5":{"value":11,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"6":{"value":12,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"rs":"e"},"4":{"0":{"value":13,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"1":{"value":14,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"2":{"value":15,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"3":{"value":16,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"4":{"value":17,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"5":{"value":18,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"6":{"value":19,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null},"bindingPath":null},"rs":"e"},"5":{"0":{"value":20,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"1":{"value":21,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"2":{"value":22,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"3":{"value":23,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"4":{"value":24,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"5":{"value":25,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"6":{"value":26,"formula":null,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Silver","style":1},"_autoFormatter":null}},"rs":"e"},"6":{"0":{"value":27,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Gray","style":5},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"1":{"value":28,"style":{"backColor":"#CED8F6","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"2":{"value":19,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"3":{"value":30,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"4":{"value":31,"style":{"backColor":"#CED8F6","foreColor":"black","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"5":{"value":1,"formula":null,"style":{"backColor":"#E6E6E6","foreColor":"#848484","hAlign":0,"vAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Silver","style":1},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null}},"6":{"style":{"backColor":"#E6E6E6","foreColor":"#848484","hAlign":0,"font":"bold 12pt Garamond","borderLeft":{"color":"Silver","style":1},"borderTop":{"color":"Silver","style":1},"borderRight":{"color":"Gray","style":5},"borderBottom":{"color":"Gray","style":5},"_autoFormatter":null},"value":2},"rs":"e"}},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":3,"vAlign":0}}},"sparklineGroupManager":{"groups":[]},"spans":{"0":{"row":0,"rowCount":1,"col":0,"colCount":7},"length":1},"selections":{"0":{"row":0,"rowCount":1,"col":0,"colCount":7},"selectionPolicy":2,"selectionUnit":0,"length":1,"activeSelectedRangeIndex":0},"activeRow":0,"activeCol":0,"gridline":{"color":"#D0D7E5","showVerticalGridline":true,"showHorizontalGridline":true},"allowCellOverflow":false,"referenceStyle":0,"_zoomFactor":1,"theme":{"_name":"Office","_themeColor":{"_name":"Office","_colorList":[{"a":255,"r":255,"g":255,"b":255},{"a":255,"r":238,"g":236,"b":225},{"a":255,"r":0,"g":0,"b":0},{"a":255,"r":31,"g":73,"b":125},{"a":255,"r":79,"g":129,"b":189},{"a":255,"r":192,"g":80,"b":77},{"a":255,"r":155,"g":187,"b":89},{"a":255,"r":128,"g":100,"b":162},{"a":255,"r":75,"g":172,"b":198},{"a":255,"r":247,"g":150,"b":70},{"a":255,"r":0,"g":0,"b":255},{"a":255,"r":128,"g":0,"b":128}]},"_headingFont":"Cambria","_bodyFont":"Calibri"},"showRowRangeGroup":true,"showColumnRangeGroup":true,"rowRangeGroup":{"itemsCount":200,"itemsData":[],"direction":1,"head":null,"tail":null},"colRangeGroup":{"itemsCount":20,"itemsData":[],"direction":1,"head":null,"tail":null},"conditionalFormats":{"rules":[]},"sheetTabColor":null,"frozenlineColor":"black","rowHeaderAutoText":1,"colHeaderAutoText":2,"rowHeaderAutoTextIndex":-1,"colHeaderAutoTextIndex":-1,"rowHeaderVisible":true,"colHeaderVisible":true,"rowHeaderColCount":1,"colHeaderRowCount":1,"rowHeaderData":{"rowCount":200,"colCount":1,"dataTable":{},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":1,"vAlign":1}}},"colHeaderData":{"rowCount":1,"colCount":20,"dataTable":{},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":1,"vAlign":1}}},"rowHeaderSpan":{},"colHeaderSpan":{},"rowHeaderColInfos":{},"colHeaderRowInfos":{},"isProtected":false,"borderColor":"black","borderWidth":0,"allowDragDrop":false,"allowDragFill":true,"allowUndo":true,"allowEditorReservedLocations":true}
    sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.isPaintSuspended(false);
}

function askisi_programma() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();


    sheet.reset();

	var jsonData = {"name":"Πρόγραμμα","defaults":{"rowHeight":20,"colWidth":62,"rowHeaderColWidth":40,"colHeaderRowHeight":20},"columns":{"0":{"size":46,"dirty":true},"1":{"size":138,"dirty":true},"2":{"size":138,"dirty":true},"3":{"size":138,"dirty":true},"4":{"size":138,"dirty":true},"5":{"size":138,"dirty":true}},"rows":{"0":{"size":28.84375,"dirty":true},"1":{"size":32.84375,"dirty":true},"2":{"size":32.84375,"dirty":true},"3":{"size":32.84375,"dirty":true},"4":{"size":32.84375,"dirty":true},"5":{"size":32.84375,"dirty":true},"6":{"size":32.84375,"dirty":true},"7":{"size":32.84375,"dirty":true}},"autoGenerateColumns":true,"dataSource":null,"frozenRowCount":0,"frozenColCount":0,"rowCount":200,"columnCount":20,"data":{"name":"Φύλλο1","rowCount":200,"colCount":20,"dataTable":{"0":{"0":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Ώρες"},"1":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Δευτέρα"},"2":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Τρίτη"},"3":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Τετάρτη"},"4":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Πέμπτη"},"5":{"style":{"backColor":"#F5A9E1","hAlign":1,"font":"bold 12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Παρασκευή"},"rs":"e"},"1":{"0":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"1η","bindingPath":null,"sparkline":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Αγγλικά"},"2":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"3":{"bindingPath":null,"value":"Γυμναστική","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"4":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"5":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"rs":"e"},"2":{"0":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"2η","bindingPath":null,"sparkline":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Πληροφορική"},"2":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"3":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Θεατρ. Αγωγή"},"4":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"5":{"bindingPath":null,"value":"Γλώσσα","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"rs":"e"},"3":{"0":{"value":"3η","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"bindingPath":null,"sparkline":null,"formula":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Γλώσσα"},"2":{"bindingPath":null,"value":"Μαθηματικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"3":{"bindingPath":null,"value":"Μαθηματικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"4":{"bindingPath":null,"value":"Μαθηματικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"5":{"bindingPath":null,"value":"Ευελ. Ζώνη","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"rs":"e"},"4":{"0":{"value":"4η","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"bindingPath":null,"sparkline":null,"formula":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Φιλαναγνωσία"},"2":{"bindingPath":null,"value":"Αγγλικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"3":{"bindingPath":null,"value":"Ιστορία","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"4":{"bindingPath":null,"value":"Γυμναστική","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"5":{"bindingPath":null,"value":"Γυμναστική","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"rs":"e"},"5":{"0":{"value":"5η","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"bindingPath":null,"sparkline":null,"formula":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Μαθηματικά"},"2":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Γυμναστική"},"3":{"bindingPath":null,"value":"Μελέτη","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"4":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Εικαστικά"},"5":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Μελέτη"},"rs":"e"},"6":{"0":{"value":"6η","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"bindingPath":null,"sparkline":null,"formula":null},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Ιστορία"},"2":{"bindingPath":null,"value":"Πληροφορική","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"3":{"bindingPath":null,"value":"Αγγλικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"4":{"bindingPath":null,"value":"Αγγλικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"5":{"bindingPath":null,"value":"Θρησκευτικά","formula":"","style":{"backColor":"#F8E0EC","foreColor":"black","hAlign":1,"vAlign":0,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderBottom":{"color":"Maroon","style":1},"locked":true,"_autoFormatter":null},"sparkline":null},"rs":"e"},"7":{"0":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"7η"},"1":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Μελέτη"},"2":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Μουσική"},"3":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Θρησκευτικά"},"4":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"borderRight":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Ευελ. Ζώνη"},"5":{"style":{"backColor":"#F8E0EC","hAlign":1,"font":"12pt Tahoma","borderLeft":{"color":"Maroon","style":1},"borderTop":{"color":"Maroon","style":1},"_autoFormatter":null},"value":"Σχολ. Ζωή"},"rs":"e"}},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":3,"vAlign":0}}},"sparklineGroupManager":{"groups":[]},"spans":{},"selections":{"0":{"row":9,"rowCount":1,"col":3,"colCount":1},"selectionPolicy":2,"selectionUnit":0,"length":1,"activeSelectedRangeIndex":0},"activeRow":9,"activeCol":3,"gridline":{"color":"#D0D7E5","showVerticalGridline":true,"showHorizontalGridline":true},"allowCellOverflow":false,"referenceStyle":0,"_zoomFactor":1,"theme":{"_name":"Office","_themeColor":{"_name":"Office","_colorList":[{"a":255,"r":255,"g":255,"b":255},{"a":255,"r":238,"g":236,"b":225},{"a":255,"r":0,"g":0,"b":0},{"a":255,"r":31,"g":73,"b":125},{"a":255,"r":79,"g":129,"b":189},{"a":255,"r":192,"g":80,"b":77},{"a":255,"r":155,"g":187,"b":89},{"a":255,"r":128,"g":100,"b":162},{"a":255,"r":75,"g":172,"b":198},{"a":255,"r":247,"g":150,"b":70},{"a":255,"r":0,"g":0,"b":255},{"a":255,"r":128,"g":0,"b":128}]},"_headingFont":"Cambria","_bodyFont":"Calibri"},"showRowRangeGroup":true,"showColumnRangeGroup":true,"rowRangeGroup":{"itemsCount":200,"itemsData":[],"direction":1,"head":null,"tail":null},"colRangeGroup":{"itemsCount":20,"itemsData":[],"direction":1,"head":null,"tail":null},"conditionalFormats":{"rules":[]},"sheetTabColor":null,"frozenlineColor":"black","rowHeaderAutoText":1,"colHeaderAutoText":2,"rowHeaderAutoTextIndex":-1,"colHeaderAutoTextIndex":-1,"rowHeaderVisible":true,"colHeaderVisible":true,"rowHeaderColCount":1,"colHeaderRowCount":1,"rowHeaderData":{"rowCount":200,"colCount":1,"dataTable":{},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":1,"vAlign":1}}},"colHeaderData":{"rowCount":1,"colCount":20,"dataTable":{},"_rowDataArray":[],"_columnDataArray":[],"_defaultDataNode":{"style":{"foreColor":"black","hAlign":1,"vAlign":1}}},"rowHeaderSpan":{},"colHeaderSpan":{},"rowHeaderColInfos":{},"colHeaderRowInfos":{"0":{"size":19.84375,"dirty":true}},"clipBoardOptions":0,"isProtected":false,"borderColor":"black","borderWidth":0,"allowDragDrop":false,"allowDragFill":true,"allowUndo":true,"allowEditorReservedLocations":true}
    sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.isPaintSuspended(false);
}

function askisi_thermokrasies() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    //var sheet = spread.getSheet(0);        // get active worksheet of the wijspread control
    var sheet = spread.getActiveSheet();

    sheet.reset();

    var jsonData = { "name": "Θερμοκρασίες", "defaults": { "rowHeight": 20, "colWidth": 62, "rowHeaderColWidth": 40, "colHeaderRowHeight": 20 }, "columns": { "0": { "size": 113, "dirty": true }, "1": { "size": 112, "dirty": true }, "2": { "size": 114, "dirty": true }, "length": 20 }, "rows": { "0": { "size": 34.84375, "dirty": true }, "1": { "size": 27.84375, "dirty": true }, "2": { "size": 32.84375, "dirty": true }, "3": { "size": 42.84375, "dirty": true }, "4": { "size": 42, "dirty": true }, "5": { "size": 42.84375, "dirty": true }, "6": { "size": 42.84375, "dirty": true }, "7": { "size": 42.84375, "dirty": true }, "8": { "size": 35.84375, "dirty": true }, "9": null, "length": 200 }, "autoGenerateColumns": true, "dataSource": null, "frozenRowCount": 0, "frozenColCount": 0, "rowCount": 199, "columnCount": 20, "data": { "name": "Φύλλο1", "rowCount": 199, "colCount": 20, "dataTable": { "0": { "0": { "value": "Θερμοκρασίες Ελληνικών Πόλεων", "style": { "backColor": "#F7FE2E", "hAlign": 1, "vAlign": 1, "font": "bold 14pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "Gray", "style": 5 }, "borderRight": { "color": "Yellow", "style": 1 }, "borderBottom": { "color": "Yellow", "style": 1 }, "_autoFormatter": null } }, "1": { "style": { "backColor": "#F7FE2E", "hAlign": 1, "vAlign": 1, "font": "bold 14pt Garamond", "borderLeft": { "color": "Yellow", "style": 1 }, "borderTop": { "color": "Gray", "style": 5 }, "borderRight": { "color": "Yellow", "style": 1 }, "borderBottom": { "color": "Yellow", "style": 1 } } }, "2": { "style": { "backColor": "#F7FE2E", "hAlign": 1, "vAlign": 1, "font": "bold 14pt Garamond", "borderLeft": { "color": "Yellow", "style": 1 }, "borderTop": { "color": "Gray", "style": 5 }, "borderRight": { "color": "Gray", "style": 5 }, "borderBottom": { "color": "Yellow", "style": 1 } } }, "rs": "e" }, "1": { "0": { "value": "Πόλη", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "Yellow", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "1": { "value": "Θερμοκρασία", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "Yellow", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "Yellow", "style": 1 }, "borderRight": { "color": "Gray", "style": 5 }, "borderBottom": { "color": "White", "style": 1 } } }, "rs": "e" }, "2": { "0": { "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 } } }, "1": { "value": "Κελσίου (C)", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "value": "Φαρενάιτ (F)", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "Gray", "style": 5 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "4": { "value": "Ο τύπος που μετατρέπει τους βαθμούς Κελσίου σε Φαρενάιτ είναι:", "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "_autoFormatter": null } }, "5": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "6": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "7": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "8": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "9": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "10": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1 } }, "rs": "e" }, "3": { "0": { "value": "Αθήνα", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "1": { "value": 20, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "White", "style": 1 } }, "bindingPath": null }, "3": { "style": { "hAlign": 1 } }, "4": { "value": "F = 9/5 * C + 32", "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial", "_autoFormatter": null } }, "5": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "6": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "7": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "8": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "9": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "10": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "11": { "style": { "hAlign": 1 } }, "12": { "style": { "hAlign": 1 } }, "13": { "style": { "hAlign": 1 } }, "14": { "style": { "hAlign": 1 } }, "15": { "style": { "hAlign": 1 } }, "16": { "style": { "hAlign": 1 } }, "17": { "style": { "hAlign": 1 } }, "18": { "style": { "hAlign": 1 } }, "19": { "style": { "hAlign": 1 } }, "rs": "e" }, "4": { "0": { "value": "Θεσσαλονίκη", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "1": { "value": 17, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "White", "style": 1 } }, "bindingPath": null }, "3": { "style": { "hAlign": 1 } }, "4": { "value": "(όπου F βαθμοί Φαρενάϊτ και C βαθμοί Κελσίου)", "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0, "_autoFormatter": null } }, "5": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "6": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "7": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "8": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "9": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "10": { "style": { "backColor": "#FFFF00", "hAlign": 1, "vAlign": 0 } }, "11": { "style": { "hAlign": 1 } }, "12": { "style": { "hAlign": 1 } }, "13": { "style": { "hAlign": 1 } }, "14": { "style": { "hAlign": 1 } }, "15": { "style": { "hAlign": 1 } }, "16": { "style": { "hAlign": 1 } }, "17": { "style": { "hAlign": 1 } }, "18": { "style": { "hAlign": 1 } }, "19": { "style": { "hAlign": 1 } }, "rs": "e" }, "5": { "0": { "value": "Πάτρα", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "1": { "value": 22, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "White", "style": 1 } }, "bindingPath": null }, "3": { "style": { "hAlign": 1 } }, "4": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "5": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "6": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "7": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "8": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "9": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "10": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "11": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "12": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "13": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "14": { "style": { "hAlign": 1 } }, "15": { "style": { "hAlign": 1 } }, "16": { "style": { "hAlign": 1 } }, "17": { "style": { "hAlign": 1 } }, "18": { "style": { "hAlign": 1 } }, "19": { "style": { "hAlign": 1 } }, "rs": "e" }, "6": { "0": { "value": "Καβάλα", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "1": { "value": 15, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "White", "style": 1 }, "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "White", "style": 1 } }, "bindingPath": null }, "3": { "style": { "hAlign": 1 } }, "4": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "5": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "6": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "7": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "8": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "9": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "10": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "11": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "12": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "13": { "style": { "hAlign": 1 }, "bindingPath": null, "value": null, "formula": "", "sparkline": null }, "14": { "style": { "hAlign": 1 } }, "15": { "style": { "hAlign": 1 } }, "16": { "style": { "hAlign": 1 } }, "17": { "style": { "hAlign": 1 } }, "18": { "style": { "hAlign": 1 } }, "19": { "style": { "hAlign": 1 } }, "rs": "e" }, "7": { "0": { "value": "Ηράκλειο", "style": { "backColor": "#D8F781", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Gray", "style": 5 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "Gray", "style": 5 }, "_autoFormatter": null } }, "1": { "value": 25, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "White", "style": 1 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "White", "style": 1 }, "borderBottom": { "color": "Gray", "style": 5 }, "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "backColor": "#ECF8E0", "hAlign": 1, "vAlign": 1, "font": "bold 12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "White", "style": 1 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } }, "bindingPath": null }, "3": { "style": { "hAlign": 1 } }, "4": { "style": { "hAlign": 1 } }, "5": { "style": { "hAlign": 1 } }, "6": { "style": { "hAlign": 1 } }, "7": { "style": { "hAlign": 1 } }, "8": { "style": { "hAlign": 1 } }, "9": { "style": { "hAlign": 1 } }, "10": { "style": { "hAlign": 1 } }, "11": { "style": { "hAlign": 1 } }, "12": { "style": { "hAlign": 1 } }, "13": { "style": { "hAlign": 1 } }, "14": { "style": { "hAlign": 1 } }, "15": { "style": { "hAlign": 1 } }, "16": { "style": { "hAlign": 1 } }, "17": { "style": { "hAlign": 1 } }, "18": { "style": { "hAlign": 1 } }, "19": { "style": { "hAlign": 1 } }, "rs": "e" }, "8": { "0": { "style": { "font": "12pt Garamond" } }, "1": { "value": "Μέσος όρος", "style": { "backColor": "#D358F7", "hAlign": 1, "vAlign": 1, "font": "12pt Garamond", "_autoFormatter": null } }, "2": { "value": null, "formula": null, "style": { "hAlign": 1, "vAlign": 1, "font": "12pt Garamond", "borderLeft": { "color": "Red", "style": 12 }, "borderTop": { "color": "Red", "style": 12 }, "borderRight": { "color": "Red", "style": 12 }, "borderBottom": { "color": "Red", "style": 12 } } }, "rs": "e" }, "9": { "0": { "bindingPath": null, "value": "Προσπαθήστε να υπολογίσετε τις τιμές των κελιών μέσα στα κόκκινα  πλαίσια χρησιμοποιώντας τους αντίστοιχους μαθηματικούς τύπους", "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true, "_autoFormatter": null }, "sparkline": null }, "1": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "2": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "3": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "4": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "5": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "6": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "7": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "8": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "9": { "bindingPath": null, "value": null, "formula": "", "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 0, "font": "bold 10pt Arial", "locked": true }, "sparkline": null }, "10": { "style": { "foreColor": "#FE2E2E", "hAlign": 1, "vAlign": 1, "font": "bold 10pt Arial" } }, "11": { "style": { "foreColor": "#FE2E2E", "hAlign": 1, "font": "bold 10pt Arial" } }, "rs": "e" }, "10": null }, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 3, "vAlign": 0 } } }, "sparklineGroupManager": { "groups": [] }, "spans": { "0": { "row": 1, "rowCount": 1, "col": 1, "colCount": 2 }, "1": { "row": 1, "rowCount": 2, "col": 0, "colCount": 1 }, "2": { "row": 0, "rowCount": 1, "col": 0, "colCount": 3 }, "3": { "row": 2, "rowCount": 1, "col": 4, "colCount": 7 }, "4": { "row": 3, "rowCount": 1, "col": 4, "colCount": 7 }, "5": { "row": 4, "rowCount": 1, "col": 4, "colCount": 7 }, "6": { "row": 9, "rowCount": 1, "col": 0, "colCount": 12 }, "length": 7 }, "selections": { "0": { "row": 9, "rowCount": 1, "col": 0, "colCount": 12 }, "selectionPolicy": 2, "selectionUnit": 0, "length": 1, "activeSelectedRangeIndex": 0 }, "activeRow": 9, "activeCol": 0, "gridline": { "color": "#D0D7E5", "showVerticalGridline": true, "showHorizontalGridline": true }, "allowCellOverflow": false, "referenceStyle": 0, "_zoomFactor": 1, "theme": { "_name": "Office", "_themeColor": { "_name": "Office", "_colorList": [{ "a": 255, "r": 255, "g": 255, "b": 255 }, { "a": 255, "r": 238, "g": 236, "b": 225 }, { "a": 255, "r": 0, "g": 0, "b": 0 }, { "a": 255, "r": 31, "g": 73, "b": 125 }, { "a": 255, "r": 79, "g": 129, "b": 189 }, { "a": 255, "r": 192, "g": 80, "b": 77 }, { "a": 255, "r": 155, "g": 187, "b": 89 }, { "a": 255, "r": 128, "g": 100, "b": 162 }, { "a": 255, "r": 75, "g": 172, "b": 198 }, { "a": 255, "r": 247, "g": 150, "b": 70 }, { "a": 255, "r": 0, "g": 0, "b": 255 }, { "a": 255, "r": 128, "g": 0, "b": 128 }] }, "_headingFont": "Cambria", "_bodyFont": "Calibri" }, "showRowRangeGroup": true, "showColumnRangeGroup": true, "rowRangeGroup": { "itemsCount": 199, "itemsData": [], "direction": 1, "head": null, "tail": null }, "colRangeGroup": { "itemsCount": 20, "itemsData": [], "direction": 1, "head": null, "tail": null }, "conditionalFormats": { "rules": [] }, "sheetTabColor": null, "frozenlineColor": "black", "rowHeaderAutoText": 1, "colHeaderAutoText": 2, "rowHeaderAutoTextIndex": -1, "colHeaderAutoTextIndex": -1, "rowHeaderVisible": true, "colHeaderVisible": true, "rowHeaderColCount": 1, "colHeaderRowCount": 1, "rowHeaderData": { "rowCount": 199, "colCount": 1, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "colHeaderData": { "rowCount": 1, "colCount": 20, "dataTable": {}, "_rowDataArray": [], "_columnDataArray": [], "_defaultDataNode": { "style": { "foreColor": "black", "hAlign": 1, "vAlign": 1 } } }, "rowHeaderSpan": {}, "colHeaderSpan": {}, "rowHeaderColInfos": {}, "colHeaderRowInfos": {}, "clipBoardOptions": 0, "isProtected": false, "borderColor": "black", "borderWidth": 0, "allowDragDrop": false, "allowDragFill": true, "allowUndo": true, "allowEditorReservedLocations": true }
    sheet.allowCellOverflow = true;

    sheet.isPaintSuspended(true);

    sheet.fromJSON(jsonData);

    sheet.isPaintSuspended(false);
}


function initSpread() {
    var spread = $("#ss").wijspread("spread"); // get instance of wijspread control
    spread.canUserDragDrop(false);

	var sheet = spread.getActiveSheet(); // get active worksheet of the wijspread control
	spread.useWijmoTheme = true;
	spread.repaint();
	spread.bind("EnterCell", selectionChanged);

    //show range group
	$("#showRowGroup").attr("disabled", true);
	$("#showColGroup").attr("disabled", true);
	$("#showRowGroupLabel").attr("disabled", true);
	$("#showColGroupLabel").attr("disabled", true);
	$("#showRowGroup").attr("value", "false");
	$("#showColGroup").attr("value", "false");
	$("#showRowGroupLabel").addClass("ui-state-disabled");
	$("#showColGroupLabel").addClass("ui-state-disabled");
	$("#showRowGroupLabel").bind("mouseup", rowlabelactive);
	$("#showColGroupLabel").bind("mouseup", collabelactive);

	$("#setTabStripColor").attr("disabled", true);
	$("#setTabStripColor").addClass("ui-state-disabled");

	setstatus(sheet);
	sheet.bind($.wijmo.wijspread.Events.EditorStatusChanged, function () {
		setstatus(sheet);
	});

	$("#btnDeleteSheet").on("click", function () {
	    var idx = spread.getActiveSheetIndex();
	    if (spread.getSheetCount() > 1) {
            if (confirm("Είστε σίγουροι για την διαγραφή του φύλλου;"))
	            spread.removeSheet(idx);
	    }
	});

	$("#btnLoadAskisi").on("click", function () {
	    var sel = $("#ddlAskiseis").val();
	    switch (sel) {
	        case "1":
	            askisi_frouta2();
	            break;
	        case "2":
	            askisi_programma();
	            break;
	        case "3":
	            askisi_calendar();
	            break;
	        case "4":
	            askisi_bookstore();
	            break;
	        case "5":
	            askisi_thermokrasies();
	            break;
	        case "6":
	            askisi_podosfairo2();
	            break;
	    }
	    selectionChanged();
	    spread.bind("EnterCell", selectionChanged);
	    setstatus(sheet);
	    sheet.bind($.wijmo.wijspread.Events.EditorStatusChanged, function () {
	        setstatus(sheet);
	    });
	});



	//$("#btnToJson").click(function () {
	$("#btnToJson").on("click", function () {
	    var curSpread = $("#ss").wijspread("spread"); // get instance of wijspread control
	    var obj = curSpread.getActiveSheet().toJSON();
	    $("#txtJson").text(JSON.stringify(obj));
	});


}
;
function rowlabelactive() {
	$("#showRowGroupLabel").addClass("ui-state-active");
}
function rowlabelnoactive() {
	$("#showRowGroupLabel").removeClass("ui-state-active");
}
function collabelactive() {
	$("#showColGroupLabel").addClass("ui-state-active");
}
function collabelnoactive() {
	$("#showColGroupLabel").removeClass("ui-state-active");
}
function IsRangeSet() {
    if (validatorType == "NumberValidator" || validatorType == "TextLengthValidator" || validatorType == "DateValidator") {
		if ($("#validatorComparisonOperator").val() >= 6){
			if ($("#txtValidatorValue1").val().length == 0 || $("#txtValidatorValue2").val().length == 0) {
				alert("Πρέπει να δώσετε ένα μέγιστο και ένα ελάχιστο.");
			}
		}
		else {
			if ($("#txtValidatorValue1").val().length == 0) {
				alert("Πρέπει να δώσετε μία τιμή");
			}
		}
    }
        /*else if (validatorType == "DateValidator") {
		if ($("#txtValidatorValue1").val().length == 0 || $("#txtValidatorValue2").val().length == 0) {
			alert("You must enter both a End Date and a Start Date.");
		}
	}*/
    else if (validatorType == "ListValidator") {
		if ($("#txtValidatorValue").val().length == 0) {
			alert("Πρέπει να δώσετε μία πηγή.");
		}
	} else if (validatorType == "FormulaListValidator" || validatorType == "FormulaValidator") {
		if ($("#txtValidatorValue").val().length == 0) {
			alert("You must enter a Formula.");
		}
	}
}
function setstatus(sheet) {
	var statusnow = sheet.editorStatus();
	if (statusnow === $.wijmo.wijspread.EditorStatus.Ready) {
		$("#rapidInputMode").val("Έτοιμο");
	} else if (statusnow === $.wijmo.wijspread.EditorStatus.Enter) {
		$("#rapidInputMode").val("Γράφει..");
	} else if (statusnow === $.wijmo.wijspread.EditorStatus.Edit) {
		$("#rapidInputMode").val("Έτοιμο");
	}
}
function setBarColor() {
	$("#colordialog").dialog({ title: "Bar Color" });
	$("#colordialog").dialog("open");
}
function setBarBorderColor() {
	$("#colordialog").dialog({ title: "Bar Border Color" });
	$("#colordialog").dialog("open");
}
function setBarNegativeFillColor() {
	$("#colordialog").dialog({ title: "Bar Negative Fill Color" });
	$("#colordialog").dialog("open");
}
function setBarNegativeBorderColor() {
	$("#colordialog").dialog({ title: "Bar Negative Border Color" });
	$("#colordialog").dialog("open");
}
function setBarAxisColor() {
	$("#colordialog").dialog({ title: "Bar Axis Color" });
	$("#colordialog").dialog("open");
}

function setminColor() {
	$("#colordialog").dialog({ title: "Min Color" });
	$("#colordialog").dialog("open");
}
function setmidColor() {
	$("#colordialog").dialog({ title: "Mid Color" });
	$("#colordialog").dialog("open");
}
function setmaxColor() {
	$("#colordialog").dialog({ title: "Max Color" });
	$("#colordialog").dialog("open");
}
function parseValue(value) {
	if (!isNaN(value) && isFinite(value)) {
		return parseFloat(value);
	} else {
		return value;
	}
}
function getSelected(v1, v2) {
	return v1 === v2 ? "selected='selected'" : "";
}
function createIconCriteriaDOM() {
	var IconSetType = $.wijmo.wijspread.IconSetType,
			IconCriterion = $.wijmo.wijspread.IconCriterion,
			IconValueType = $.wijmo.wijspread.IconValueType;
	var iconSetType = parseInt($("#iconSetType").val());
	var iconCriteria = [];
	if (iconSetType >= IconSetType.ThreeArrowsColored &&
			iconSetType <= IconSetType.ThreeSymbolsUncircled) {
		iconCriteria = new Array(2);
		iconCriteria[0] = new IconCriterion(true, IconValueType.Percent, 33);
		iconCriteria[1] = new IconCriterion(true, IconValueType.Percent, 67);
	}
	else if (iconSetType >= IconSetType.FourArrowsColored &&
			iconSetType <= IconSetType.FourTrafficLights) {
		iconCriteria = new Array(3);
		iconCriteria[0] = new IconCriterion(true, IconValueType.Percent, 25);
		iconCriteria[1] = new IconCriterion(true, IconValueType.Percent, 50);
		iconCriteria[2] = new IconCriterion(true, IconValueType.Percent, 75);
	}
	else if (iconSetType >= IconSetType.FiveArrowsColored &&
			iconSetType <= IconSetType.FiveBoxes) {
		iconCriteria = new Array(4);
		iconCriteria[0] = new IconCriterion(true, IconValueType.Percent, 20);
		iconCriteria[1] = new IconCriterion(true, IconValueType.Percent, 40);
		iconCriteria[2] = new IconCriterion(true, IconValueType.Percent, 60);
		iconCriteria[3] = new IconCriterion(true, IconValueType.Percent, 80);
	}

	$("#iconCriteriaSetting").empty();
	$.each(iconCriteria, function (i, v) {
		var $div = $("<div style='margin-top: 10px'></div>"),
				$selectOperator = $("<select></select>"),
				$input = $("<input style='margin-left: 10px'/>"),
				$selectType = $("<select style='margin-left: 10px'></select>");
		$selectOperator.html("<option value=1 " + getSelected(v.isGreaterThanOrEqualTo, true) + ">>=</option>" +
				"<option value=0 " + getSelected(v.isGreaterThanOrEqualTo, false) + ">></option>");
		$input.val(v.iconValue);
		$selectType.html("<option value=1 " + getSelected(v.iconValueType, 1) + ">Number</option>" +
				"<option value=4 " + getSelected(v.iconValueType, 4) + ">Percent</option>" +
				"<option value=7 " + getSelected(v.iconValueType, 7) + ">Formula</option>" +
				"<option value=5 " + getSelected(v.iconValueType, 5) + ">Percentile</option>");
		$div.append($selectOperator).append($input).append($selectType);
		$("#iconCriteriaSetting").append($div);
	});
}
function noborderclick() {
	$(":checkbox").prop("checked", false);
	$("#border11").css("border-right", "none");
	$("#border11").css("border-bottom", "none");
	$("#border11").css("border-left", "none");
	$("#border11").css("border-top", "none");
	$("#border12").css("border-right", "none");
	$("#border12").css("border-bottom", "none");
	$("#border12").css("border-left", "none");
	$("#border12").css("border-top", "none");
	$("#border21").css("border-right", "none");
	$("#border21").css("border-bottom", "none");
	$("#border21").css("border-left", "none");
	$("#border21").css("border-top", "none");
	$("#border22").css("border-right", "none");
	$("#border22").css("border-bottom", "none");
	$("#border22").css("border-left", "none");
	$("#border22").css("border-top", "none");
	$("#bordertable").css("border", "none");
}
function outlineborderclick() {
	$(":checkbox").prop("checked", false);
	$("[id*=Side]").prop("checked", true);
	$("#border11").css("border-left", "1px solid gray");
	$("#border11").css("border-top", "1px solid gray");
	$("#border12").css("border-right", "1px solid gray");
	$("#border12").css("border-top", "1px solid gray");
	$("#border21").css("border-left", "1px solid gray");
	$("#border21").css("border-bottom", "1px solid gray");
	$("#border22").css("border-bottom", "1px solid gray");
	$("#border22").css("border-right", "1px solid gray");
	$("#border11").css("border-right", "none");
	$("#border11").css("border-bottom", "none");
	$("#border12").css("border-left", "none");
	$("#border12").css("border-bottom", "none");
	$("#border21").css("border-right", "none");
	$("#border21").css("border-top", "none");
	$("#border22").css("border-top", "none");
	$("#border22").css("border-left", "none");
	$("#bordertable").css("border", "1px solid gray");
}

function allborderclick() {
	$(":checkbox").prop("checked", true);
	$("#border11").css("border-right", "1px solid gray");
	$("#border11").css("border-bottom", "1px solid gray");
	$("#border11").css("border-left", "1px solid gray");
	$("#border11").css("border-top", "1px solid gray");
	$("#border12").css("border-right", "1px solid gray");
	$("#border12").css("border-bottom", "1px solid gray");
	$("#border12").css("border-left", "1px solid gray");
	$("#border12").css("border-top", "1px solid gray");
	$("#border21").css("border-right", "1px solid gray");
	$("#border21").css("border-bottom", "1px solid gray");
	$("#border21").css("border-left", "1px solid gray");
	$("#border21").css("border-top", "1px solid gray");
	$("#border22").css("border-right", "1px solid gray");
	$("#border22").css("border-bottom", "1px solid gray");
	$("#border22").css("border-left", "1px solid gray");
	$("#border22").css("border-top", "1px solid gray");
	$("#bordertable").css("border", "1px solid gray");
}

function setEnumTypeOfCF(rule, type) {
	switch (rule) {
		case "0":
			$("#ruletext").text("Μορφοποίηση μόνο των κελιών που έχουν:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			type.show();
			$("#ComparisonOperator1").show();
			$("#value1").show();
			$("#value1").val("");
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>Ίση με</option>");
			type.append("<option value='1'>Όχι ίση με</option>");
			type.append("<option value='2'>Μεγαλύτερη</option>");
			type.append("<option value='3'>Μεγαλύτερη ή ίση</option>");
			type.append("<option value='4'>Μικρότερη</option>");
			type.append("<option value='5'>Μικρότερη ή ίση</option>");
			type.append("<option value='6'>Μεταξύ</option>");
			type.append("<option value='7'>Όχι μεταξύ</option>");
			break;
		case "1":
			$("#ruletext").text("Μορφοποίηση μόνο των κελιών που έχουν:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			type.show();
			$("#ComparisonOperator1").show();
			$("#value1").show();
			$("#value1").val("");
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>Περιέχει</option>");
			type.append("<option value='1'>Δεν περιέχει</option>");
			type.append("<option value='2'>Ξεκινά με</option>");
			type.append("<option value='3'>Τελειώνει με</option>");
			break;
		case "2":
			$("#ruletext").text("Format only cells with:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			type.show();
			$("#ComparisonOperator1").show();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>Today</option>");
			type.append("<option value='1'>Yesterday</option>");
			type.append("<option value='2'>Tomorrow</option>");
			type.append("<option value='3'>Last7Days</option>");
			type.append("<option value='4'>ThisMonth</option>");
			type.append("<option value='5'>LastMonth</option>");
			type.append("<option value='6'>NextMonth</option>");
			type.append("<option value='7'>ThisWeek</option>");
			type.append("<option value='8'>LastWeek</option>");
			type.append("<option value='9'>NextWeek</option>");
			break;
		case "3":
			$("#ruletext").text("Format values where this formula is true:");
			$("#andtext").hide();
			$("#formattext").show();
			$("#formattext").text("eg:=COUNTIF($B$1:$B$5,A1).");
			type.empty();
			$("#ComparisonOperator1").hide();
			$("#value1").show();
			$("#value1").val("");
			$("#value2").hide();
			$("#colorScale").hide();
			break;
		case "4":
			$("#ruletext").text("Μορφοποίησε τα κελιά  που βρίσκονται στα:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			$("#ComparisonOperator1").show();
			$("#value1").show();
			$("#value1").val("10");
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>Καλύτερα</option>");
			type.append("<option value='1'>Χειρότερα</option>");
			break;
		case "5":
			$("#ruletext").text("Μορφοποίησε όλα τα κελιά με:");
			$("#andtext").hide();
			$("#formattext").show();
			$("#formattext").text("τιμές στην επιλεγμένη περιοχή.");
			type.empty();
			$("#ComparisonOperator1").hide();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").hide();
			break;
		case "6":
			$("#ruletext").text("Μορφοποίησε όλα τα κελιά με:");
			$("#andtext").hide();
			$("#formattext").show();
			$("#formattext").text("τιμές στην επιλεγμένη περιοχή.");
			type.empty();
			$("#ComparisonOperator1").hide();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").hide();
			break;
		case "7":
			$("#ruletext").text("Μορφοποίησε όλα τα κελιά με:");
			$("#andtext").hide();
			$("#formattext").show();
			$("#formattext").text("του μέσου όρου της επιλεγμένης περιοχής.");
			type.empty();
			type.show();
			$("#ComparisonOperator1").show();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>Μεγαλύτερη</option>");
			type.append("<option value='1'>Μικρότερη</option>");
			type.append("<option value='2'>Μεγαλύτερη ή ίση</option>");
			type.append("<option value='3'>Μικρότερη ή ίση</option>");
			//type.append("<option value='4'>Above1StdDev</option>");
			//type.append("<option value='5'>Below1StdDev</option>");
			//type.append("<option value='6'>Above2StdDev</option>");
			//type.append("<option value='7'>Below2StdDev</option>");
			//type.append("<option value='8'>Above3StdDev</option>");
			//type.append("<option value='9'>Below3StdDev</option>");
			break;
		case "8":
			$("#ruletext").text("Format all cells based on their values:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			type.hide();
			$("#ComparisonOperator1").hide();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").show();
			$("#midpoint").hide();
			$("#midType").hide();
			$("#midValue").hide();
			$("#midColor").hide();
			break;
		case "9":
			$("#ruletext").text("Format all cells based on their values:");
			$("#andtext").hide();
			$("#formattext").hide();
			type.empty();
			type.hide();
			$("#ComparisonOperator1").hide();
			$("#value1").hide();
			$("#value2").hide();
			$("#colorScale").show();
			$("#midpoint").show();
			$("#midType").show();
			$("#midValue").show();
			$("#midColor").show();
			break;
		default:
			$("#andtext").hide();
			type.empty();
			type.show();
			$("#ComparisonOperator1").show();
			$("#value1").show();
			$("#value1").val("");
			$("#value2").hide();
			$("#colorScale").hide();
			type.append("<option value='0'>EqualsTo</option>");
			type.append("<option value='1'>NotEqualsTo</option>");
			type.append("<option value='2'>GreaterThan</option>");
			type.append("<option value='3'>GreaterThanOrEqualsTo</option>");
			type.append("<option value='4'>LessThan</option>");
			type.append("<option value='5'>LessThanOrEqualsTo</option>");
			type.append("<option value='6'>Between</option>");
			type.append("<option value='7'>NotBetween</option>");
			break;
	}
}

function fillSampleData(sheet, range) {
	for (var i = 0; i < range.rowCount; i++) {
		for (var j = 0; j < range.colCount; j++) {
			sheet.setValue(range.row + i, range.col + j, Math.ceil(Math.random() * 300));
		}
	}
}

function colorSelected(event) {
	var event = event || window.event;
	var target = event.srcElement || event.target;
	$("#selectedColor").val(target.bgColor);
	$("#colorSample").attr("style", "background-color:" + target.bgColor);
}

function getActualCellRange(cellRange, rowCount, columnCount) {
	if (cellRange.row == -1 && cellRange.col == -1) {
		return new $.wijmo.wijspread.Range(0, 0, rowCount, columnCount);
	}
	else if (cellRange.row == -1) {
		return new $.wijmo.wijspread.Range(0, cellRange.col, rowCount, cellRange.colCount);
	}
	else if (cellRange.col == -1) {
		return new $.wijmo.wijspread.Range(cellRange.row, 0, cellRange.rowCount, columnCount);
	}

	return cellRange;
}

/*
 var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-208280-14']);
_gaq.push(['_trackPageview']);

(function () {
	var ga = document.createElement('script');
	ga.type = 'text/javascript';
	ga.async = true;
	ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	var s = document.getElementsByTagName('script')[0];
	s.parentNode.insertBefore(ga, s);
})();
*/
