var canvas;
var cntx;
var cnvBackBuffer;
var cntxBackBuffer;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}
      
function initialiseEvents(){
    $("#visualisation").on("mousedown touchstart",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });
    
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });
    
    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });
} 

function initialiseGUI(){
    Intro=document.getElementById("Intro");
    IntroHelp=document.getElementById("IntroHelp");
}

function initialValues(){
    $("#resolutionSlctr").val("800x600");
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    
    LadderBottom=height-BottomPanelHeight-border-LadderShift;
    HorScaleYcoord=LadderBottom+HorScaleOffset+MajorScaleSize;
    Ball1Left=parseInt(width/2)-step;
    Ball1Top=LadderBottom-2*BallRadius;
    Ball2Left=parseInt(width/2)+parseInt(step/3);
    Ball2Top=LadderBottom-2*BallRadius;
    PlaneA=-1;
    PlaneB=LadderBottom+parseInt(width/2)+step;
}

function drawBasicScreen(){
    var message="";
    var messageX,messageY;

    cntx.clearRect(0,0,canvas.width,canvas.height);
    
    drawFrames();
    drawLogoImage();
    
    cntx.font=2*fontSize+"px Arial";
    var title="Ψηφιακή Κλίμακα";
    var titleX=(width/2-cntx.measureText(title).width)/2;
    var titleY=TopPanelHeight+65;
    cnvsWrite("rgb(255,0,0)",2*fontSize,"Arial",titleX,titleY,title);
    var title="Αναλογική Κλίμακα";
    var titleX=(width/2-cntx.measureText(title).width)/2+width/2;
    cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",titleX,titleY,title);
    
    var promptYCoord=BottomPanelTop+25;
    var prompt="";
    var prompt2="";
    var promptColor=LetterColor;
    prompt="Χρησιμοποίησε το ποντίκι για να σύρεις τις σφαίρες.";
    drawYCoordSwitch();
    drawXCoordSwitch();
    prompt2="Κάνε κλικ στη σκάλα ή στο κεκλιμένο επίπεδο για δεις πως μεταβάλλεται το ύψος.";
    cnvsWrite(promptColor,fontSize,"Arial",-1,promptYCoord,prompt);
    promptYCoord+=28;
    cnvsWrite(promptColor,fontSize,"Arial",-1,promptYCoord,prompt2);
    promptYCoord+=20;
    
    if(showXCoord || showYCoord){
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",-1,BottomPanelTop-20,Info);
    }
    
    if(showXCoord){
        cntx.font=fontSize+"px Arial";
        message="x1="+Ball1Left;          
        messageX=Ball1Left;
        if(messageX+cntx.measureText(message).width>=width/2) messageX=width/2-cntx.measureText(message).width;
        cnvsWrite("rgb(0,0,0)",fontSize,"Arial",messageX,TopMessage+LadderShift,message);
        
        message="x2="+(Ball2Left);
        cnvsWrite("rgb(0,0,0)",fontSize,"Arial",Ball2Left,TopMessage+LadderShift,message);
    }
    if(showYCoord){
        message="y1="+(height-Ball1Top);
        cnvsWrite("rgb(0,0,0)",fontSize,"Arial",width/2-LadderSteps*step-cntx.measureText(message+"  ").width,Ball1Top+2*BallRadius,message);
        message="y2="+(height-Ball2Top);
        cnvsWrite("rgb(0,0,0)",fontSize,"Arial",width/2+(LadderSteps+1)*step+cntx.measureText(message+"  ").width,Ball2Top+2*BallRadius,message);
        if((height-Ball2Top) % 20>=7 && (height-Ball2Top) % 20<=13){
            cnvsWrite("rgb(255,0,0)",fontSize,"Arial",width/2-35,Ball2Top+2*BallRadius,""+(20*(parseInt((height-Ball2Top)/20))+10));
            cnvsWrite("rgb(255,0,0)",fontSize,"Arial",-1,TopBorder+70,"Παρατήρησε την αντίστοιχη ψηφιακή ('στρογγυλοποιημένη') τιμή.");
        }
    }
    
    DrawLadder();
    DrawPlane();
    DrawBalls();
    DrawDottedLines();
    DrawScale();
}

function drawFrames(){
    cntx.fillStyle="white";
    cntx.strokeStyle="black";
    //Περιοχή σχεδίασης
    cntx.fillRect(0,TopPanelHeight,width,height-TopPanelHeight-BottomPanelHeight);
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,TopPanelHeight);
    //κάτω πλαίσιο
    cntx.rect(0,BottomPanelTop,width,BottomPanelHeight);

    cntx.stroke();
    cnvsWrite(LetterColor,32,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
}

function drawLogoImage(){
    cntx.drawImage(imgLogo,logoLeft,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){
    Ball1Grabbed=ball1Hover();
    Ball2Grabbed=ball2Hover();
    drawBasicScreen();
}

function handleMouseMove(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    if (mx>=xCoordSwitchLeft && mx<xCoordSwitchLeft+switchSize && my>=xCoordSwitchTop && my<xCoordSwitchTop+switchSize){
        xCoordSwitchHover=true;
    }
    else{
        xCoordSwitchHover=false;
    }
    if (mx>=yCoordSwitchLeft && mx<yCoordSwitchLeft+switchSize && my>=yCoordSwitchTop && my<yCoordSwitchTop+switchSize){
        yCoordSwitchHover=true;
    }
    else{
        yCoordSwitchHover=false;
    }
    if(xCoordSwitchHover || yCoordSwitchHover || ball1Hover() || ball2Hover()){
        canvas.style.cursor="pointer";
    }
    else{
        canvas.style.cursor="default";
    }
    if(Ball1Grabbed){
        DragCounter=(DragCounter+1) % MaxDragCounter;
        Info="Οι συντεταγμένες μεταβάλλονται κατά τρόπο διακριτό.";
        SkalopatiX=parseInt((parseInt(width/2)-(mx-BallRadius))/step);
        SkalopatiY=parseInt((LadderBottom-(my-BallRadius))/step);
        if (SkalopatiX<=LadderSteps && SkalopatiX>=1 && SkalopatiX==SkalopatiY){
            Ball1Left=parseInt(width/2)-SkalopatiX*step;
            Ball1Top=LadderBottom-SkalopatiY*step;
        }
    }
    
    if(Ball2Grabbed){
        DragCounter=(DragCounter+1) % MaxDragCounter;
        Info="Οι συντεταγμένες μεταβάλλονται κατά τρόπο συνεχή.";
        PlaneY=parseInt(PlaneA*mx+PlaneB);
        if (mx>=parseInt(width/2)+step-BallRadius*(1+Math.sin(Math.PI)) && mx<=parseInt(width/2)+(LadderSteps+1)*step-BallRadius && my<PlaneY && PlaneY-my<=2*BallRadius){
            Ball2Left=mx-BallRadius;              
            Ball2Top=parseInt(PlaneA*(mx+BallRadius)+PlaneB-2*BallRadius*Math.cos(Math.PI/4));
            if (Ball2Top>LadderBottom-2*BallRadius)
                Ball2Top=LadderBottom-2*BallRadius;         
        }
    }
    if (DragCounter>MaxDragCounter/2) {
        prompt1="Ενεργοποίησε την εμφάνιση συντεταγμένων";
    }
    else {
        prompt1="";
    }

    drawBasicScreen();
    //console.log("mx="+mx+" , my="+my+" ,infoSwitchHover="+infoSwitchHover+" ,coordSwitchHover="+coordSwitchHover);
}

function handleMouseUp(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        showHTML();
    }
    
    if(xCoordSwitchHover){
        showXCoord=!showXCoord;
    }
    if(yCoordSwitchHover){
        showYCoord=!showYCoord;
    }
    Ball1Grabbed=false;
    Ball2Grabbed=false;

    
    var plx1,ply1,plx2,ply2;
    plx1=parseInt(width/2)+step;
    ply1=parseInt(PlaneA*plx1+PlaneB);
    plx2=parseInt(width/2)+(LadderSteps+1)*step;
    ply2=parseInt(PlaneA*plx2+PlaneB);
    DrawLadderClickedPoint=false;
    DrawPlaneClickedPoint=false;
    if(mx>parseInt(width/2)-LadderSteps*step && mx<parseInt(width/2) && my<LadderBottom && my>LadderBottom-LadderSteps*step){
        SelectedStep=parseInt((parseInt(width/2)-mx)/step);
        yy=LadderBottom-SelectedStep*step;
        if (Math.abs(yy-my)<step/4){
            DrawLadderClickedPoint=true;
        }
    }
    else if(mx>plx1 && mx<plx2 && my<ply1 && my>ply2){
        SelectedStep=mx;
        yy=parseInt(PlaneA*mx+PlaneB);
        if(Math.abs(yy-my)<step/4) DrawPlaneClickedPoint=true;
    }

    drawBasicScreen();
}

function drawXCoordSwitch(){
    if(xCoordSwitchHover){
        cntx.strokeStyle="#0000ff";
        cntx.fillStyle="#ffffff";
    }
    else{
        cntx.strokeStyle="#000000";
        cntx.fillStyle="#e1e1e1";
    }
    cntx.fillRect(xCoordSwitchLeft,xCoordSwitchTop,switchSize,switchSize);
    cntx.beginPath(); 
    cntx.rect(xCoordSwitchLeft,xCoordSwitchTop,switchSize,switchSize);
    if(showXCoord){
        cntx.moveTo(xCoordSwitchLeft+switchSize,xCoordSwitchTop+switchSize);
        cntx.lineTo(xCoordSwitchLeft,xCoordSwitchTop);
        cntx.moveTo(xCoordSwitchLeft+switchSize,xCoordSwitchTop);
        cntx.lineTo(xCoordSwitchLeft,xCoordSwitchTop+switchSize);
    }
    cntx.stroke();
    cnvsWrite(LetterColor,fontSize-2,"Arial",xCoordSwitchLeft+switchSize+captionPadding,xCoordSwitchTop+switchSize,"Εμφάνιση Χ συντεταγμένης");
}

function drawYCoordSwitch(){
    if(yCoordSwitchHover){
        cntx.strokeStyle="#0000ff";
        cntx.fillStyle="#ffffff";
    }
    else{
        cntx.strokeStyle="#000000";
        cntx.fillStyle="#e1e1e1";
    }
    cntx.fillRect(yCoordSwitchLeft,yCoordSwitchTop,switchSize,switchSize);
    cntx.beginPath(); 
    cntx.rect(yCoordSwitchLeft,yCoordSwitchTop,switchSize,switchSize);
    if(showYCoord){
        cntx.moveTo(yCoordSwitchLeft+switchSize,yCoordSwitchTop+switchSize);
        cntx.lineTo(yCoordSwitchLeft,yCoordSwitchTop);
        cntx.moveTo(yCoordSwitchLeft+switchSize,yCoordSwitchTop);
        cntx.lineTo(yCoordSwitchLeft,yCoordSwitchTop+switchSize);
    }
    cntx.stroke();
    cnvsWrite(LetterColor,fontSize-2,"Arial",yCoordSwitchLeft+switchSize+captionPadding,yCoordSwitchTop+switchSize,"Εμφάνιση Y συντεταγμένης");
}

function DrawLadder(){
    var xx,yy,DottedLineY1,DottedLineY2;
    cntx.strokeStyle="rgb(255,0,0)";
    xx=width/2;
    yy=LadderBottom;
    cntx.beginPath();
    for(var i=0;i<LadderSteps;++i) {
        cntx.moveTo(xx,yy);
        cntx.lineTo(xx-step,yy);
        cntx.moveTo(xx-step,yy);
        cntx.lineTo(xx-step,yy-step);
        if (DrawLadderClickedPoint && i==SelectedStep){
            cnvsWrite(LetterColor,fontSize-2,"Arial",xx,yy,height+step-yy+"");
            DottedLineY1=yy;
            while(DottedLineY1<LadderBottom+HorScaleOffset){
                DottedLineY2=DottedLineY1+step/DottedLineSize;
                if(DottedLineY2>LadderBottom+HorScaleOffset) DottedLineY2=LadderBottom+HorScaleOffset;
                cntx.moveTo(xx-step/2,DottedLineY1);
                cntx.lineTo(xx-step/2,DottedLineY2);

                DottedLineY1=DottedLineY1+2*step/DottedLineSize;
                if (DottedLineY1>LadderBottom+HorScaleOffset) DottedLineY1=LadderBottom+HorScaleOffset;
            }
        }
        xx=xx-step;
        yy=yy-step;
    }
    cntx.stroke();
}

function DrawPlane(){
    var p1x,p1y,p2x,p2y,DottedLineY1,DottedLineY2;;
    cntx.strokeStyle="rgb(0,0,255)";
    cntx.beginPath();
    cntx.moveTo(width/2,LadderBottom);
    cntx.lineTo(width/2+step,LadderBottom);

    p1x = width/2+step;
    p1y = parseInt(PlaneA*p1x+PlaneB);
    p2x = width/2+(LadderSteps+1)*step;
    p2y = parseInt(PlaneA*p2x+PlaneB);
    cntx.moveTo(p1x,p1y);
    cntx.lineTo(p2x,p2y);

    if (DrawPlaneClickedPoint){
        DottedLineY1=parseInt(PlaneA*SelectedStep+PlaneB);
        cnvsWrite(LetterColor,fontSize-2,"Arial",SelectedStep,DottedLineY1,height+step-DottedLineY1+"");
        
        while(DottedLineY1<LadderBottom+HorScaleOffset){
            DottedLineY2=DottedLineY1+step/DottedLineSize;
            if(DottedLineY2>LadderBottom+HorScaleOffset) DottedLineY2=LadderBottom+HorScaleOffset;
            cntx.moveTo(SelectedStep,DottedLineY1);
            cntx.lineTo(SelectedStep,DottedLineY2);

            
            DottedLineY1=DottedLineY1+2*step/DottedLineSize;
            if (DottedLineY1>LadderBottom+HorScaleOffset) DottedLineY1=LadderBottom+HorScaleOffset;
        }
    }
    cntx.stroke();
}

function DrawScale(){       
    var i;
    cntx.strokeStyle="rgb(255,0,0)";
    cntx.beginPath();
    cntx.moveTo(width/2-1,LadderBottom);
    cntx.lineTo(width/2-1,LadderBottom-LadderSteps*step);

    cntx.moveTo(width/2-1,LadderBottom+HorScaleOffset+MajorScaleSize);
    cntx.lineTo(width/2-LadderSteps*step-BallRadius,LadderBottom+HorScaleOffset+MajorScaleSize);
    //====================
    //= Minor Left Scale =
    //====================
    //for (i=0;i<=(MinorScalePoints+1)*LadderSteps;i++)
    //  g.drawLine(width/2-1,height-border-i*step/(MinorScalePoints+1),width/2-MinorScaleSize,height-border-i*step/(MinorScalePoints+1));
    
    //====================
    //= Major Left Scale =
    //====================
    for(i=0;i<=LadderSteps;i++){
      cntx.moveTo(width/2-1,LadderBottom-i*step);
      cntx.lineTo(width/2-MajorScaleSize,LadderBottom-i*step);

      cntx.moveTo(width/2-i*step-BallRadius,LadderBottom+HorScaleOffset);
      cntx.lineTo(width/2-i*step-BallRadius,LadderBottom+HorScaleOffset+MajorScaleSize);
    }
    cntx.strokeStyle="rgb(0,0,255)";
    
    cntx.moveTo(width/2+1,LadderBottom);
    cntx.lineTo(width/2+1,LadderBottom-LadderSteps*step);

    cntx.moveTo(width/2+1,LadderBottom+HorScaleOffset+MajorScaleSize);
    cntx.lineTo(width/2+LadderSteps*step+BallRadius,LadderBottom+HorScaleOffset+MajorScaleSize);
    //=======================
    //= Minor Right Scale Y =
    //=======================
    i=LadderBottom;
    while(i>=LadderBottom-LadderSteps*step){
        cntx.moveTo(width/2+1,i);
        cntx.lineTo(width/2+MinorScaleSize,i);
        i=i-4;
    }
    //=======================
    //= Minor Right Scale X =
    //=======================
    i=width/2+LadderSteps*step+BallRadius;
    while(i>=width/2+1){
        cntx.moveTo(i,LadderBottom+HorScaleOffset+MajorScaleSize);
        cntx.lineTo(i,LadderBottom+HorScaleOffset+MajorScaleSize-MinorScaleSize);
        i=i-4;
    }
    //=====================
    //= Major Right Scale =
    //=====================
    for(i=0;i<=LadderSteps;i++){
      cntx.moveTo(width/2+1,LadderBottom-i*step);
      cntx.lineTo(width/2+MajorScaleSize,LadderBottom-i*step);

      cntx.moveTo(width/2+i*step+BallRadius,LadderBottom+HorScaleOffset);
      cntx.lineTo(width/2+i*step+BallRadius,LadderBottom+HorScaleOffset+MajorScaleSize);
    }
    cntx.stroke();
}

function DrawBalls(){
    cntx.strokeStyle="rgb(0,0,0)";
    if(ball1Hover()){
        cntx.fillStyle="rgb(100,100,100)";
    }
    else{
        cntx.fillStyle="rgb(180,180,180)";
    }
    cntx.beginPath();
    cntx.arc(Ball1Left+BallRadius,Ball1Top+BallRadius,BallRadius,0,2*Math.PI);
    cntx.fill();
    cntx.stroke();
    if(ball2Hover()){
        cntx.fillStyle="rgb(100,100,100)";
    }
    else{
        cntx.fillStyle="rgb(180,180,180)";
    }
    cntx.beginPath();
    cntx.arc(Ball2Left+BallRadius,Ball2Top+BallRadius,BallRadius,0,2*Math.PI);
    cntx.fill();
    cntx.stroke();
}

function DrawDottedLines(){
    var DottedLineX1,DottedLineX2,DottedLineY1,DottedLineY2,LeftX,RightX;
    //==================
    //= Vertical lines =
    //==================
    cntx.beginPath();
    if(showXCoord){
        if(DrawFullDottedLine){
            //Σχεδίαση διακεκομένης ΠΑΝΩ από την αριστερή μπάλα
            DottedLineY1=Ball1Top;
            while(DottedLineY1>TopMessage+LadderShift){
                DottedLineY2=DottedLineY1-step/DottedLineSize;
                if(DottedLineY2<TopMessage) DottedLineY2=TopMessage;
                cntx.moveTo(Ball1Left+BallRadius,DottedLineY1);
                cntx.lineTo(Ball1Left+BallRadius,DottedLineY2);
                DottedLineY1=DottedLineY1-2*step/DottedLineSize;
                if(DottedLineY1<TopBorder)DottedLineY1=TopBorder;
            }
        }
        
        //Σχεδίαση διακεκομένης ΚΑΤΩ από την αριστερή μπάλα
        DottedLineY1=Ball1Top+2*BallRadius;
        while(DottedLineY1<LadderBottom+HorScaleOffset){
            DottedLineY2=DottedLineY1+step/DottedLineSize;
            if(DottedLineY2>LadderBottom+HorScaleOffset) DottedLineY2=LadderBottom+HorScaleOffset;
            cntx.moveTo(Ball1Left+BallRadius,DottedLineY1);
            cntx.lineTo(Ball1Left+BallRadius,DottedLineY2);
            DottedLineY1=DottedLineY1+2*step/DottedLineSize;
            if(DottedLineY1>LadderBottom+HorScaleOffset) DottedLineY1=LadderBottom+HorScaleOffset;
        }
        
        if (DrawFullDottedLine){
            //Σχεδίαση διακεκομένης ΠΑΝΩ από τη δεξιά μπάλα
            DottedLineY1=Ball2Top;
            while(DottedLineY1>TopMessage+LadderShift){
                DottedLineY2=DottedLineY1-step/DottedLineSize;
                if(DottedLineY2<TopMessage)DottedLineY2=TopMessage;
                cntx.moveTo(Ball2Left+BallRadius,DottedLineY1);
                cntx.lineTo(Ball2Left+BallRadius,DottedLineY2);
                DottedLineY1=DottedLineY1-2*step/DottedLineSize;
                if(DottedLineY1<TopBorder)DottedLineY1=TopBorder;
            }
        }
        
        //Σχεδίαση διακεκομένης ΚΑΤΩ από τη δεξιά μπάλα
        DottedLineY1=Ball2Top+2*BallRadius;
        while (DottedLineY1<HorScaleYcoord){
            DottedLineY2=DottedLineY1+step/DottedLineSize;              
            if (DottedLineY2>HorScaleYcoord) DottedLineY2=HorScaleYcoord;
            cntx.moveTo(Ball2Left+BallRadius,DottedLineY1);
            cntx.lineTo(Ball2Left+BallRadius,DottedLineY2);
            DottedLineY1=DottedLineY1+2*step/DottedLineSize;            
            if(DottedLineY1>HorScaleYcoord) DottedLineY1=HorScaleYcoord;
        }
    }
    //====================
    //= Horizontal lines =
    //====================
    if (showYCoord){
        RightX=width/2-1;
        DottedLineX1=Ball1Left+2*BallRadius;
        while(DottedLineX1<RightX){
            DottedLineX2=DottedLineX1+step/DottedLineSize;
            if(DottedLineX2>=RightX)DottedLineX2=RightX;
            cntx.moveTo(DottedLineX1,Ball1Top+2*BallRadius);
            cntx.lineTo(DottedLineX2,Ball1Top+2*BallRadius);
            DottedLineX1=DottedLineX1+2*step/DottedLineSize;
            if(DottedLineX1>=RightX)DottedLineX1=RightX;
        }
        LeftX=width/2+1;
        DottedLineX1=Ball2Left;
        while (DottedLineX1>LeftX){
            DottedLineX2=DottedLineX1-step/DottedLineSize;
            if(DottedLineX2<=LeftX) DottedLineX2=LeftX;
            cntx.moveTo(DottedLineX1,Ball2Top+2*BallRadius);
            cntx.lineTo(DottedLineX2,Ball2Top+2*BallRadius);
            DottedLineX1=DottedLineX1-2*step/DottedLineSize;
            if (DottedLineX1<=LeftX) DottedLineX1=LeftX;
        }
    }
    cntx.stroke();
}

function ball1Hover(){
    if(mx>=Ball1Left && mx<=Ball1Left+2*BallRadius && my>=Ball1Top && my<=Ball1Top+2*BallRadius){
        return true;
    }
    else{
        return false;
    }
}

function ball2Hover(){
    if(mx>=Ball2Left && mx<=Ball2Left+2*BallRadius && my>=Ball2Top && my<=Ball2Top+2*BallRadius){
        return true;
    }
    else{
        return false;
    }
}
