// (c) by Sitsanlis Ilias All rights reserved

THREE.myLine = function ( dir, origin, length, width, hex ) {
	THREE.Object3D.call( this );
	if ( length === undefined ) length = 20;
	if ( hex === undefined ) hex = 0xffffff;
	if ( width === undefined) width=0.6

	//vectorConeLength=width*5

	var cylinderGeometry = new THREE.CylinderGeometry( width, width, 1, 20, 1 );
	this.cylinder = new THREE.Mesh( cylinderGeometry, new THREE.MeshBasicMaterial( { color: hex, transparent:false } ) );
	this.cylinder.position.set( 0, 1/2, 0 );
	this.add( this.cylinder );

	var coneGeometry = new THREE.CylinderGeometry( 0, width*3, width*12, 20, 1 );
	this.cone = new THREE.Mesh( coneGeometry, new THREE.MeshBasicMaterial( { color: hex, transparent:false } ) );
	this.cone.position.set( 0, 1, 0 );
	this.add( this.cone );

	if ( origin instanceof THREE.Vector3 ) this.position = origin;
	this.setDirection( dir );
	this.setLength( length );
};

THREE.myLine.prototype = Object.create( THREE.Object3D.prototype );

THREE.myLine.prototype.setDirection = function ( dir ) {
    var d = THREE.myLine.__v1.copy( dir ).normalize();
    if ( d.y > 0.999 ) {
        this.rotation.set( 0, 0, 0 );
    } else if ( d.y < - 0.999 ) {
        this.rotation.set( Math.PI, 0, 0 );
    } else {
		var axis = THREE.myLine.__v2.set( d.z, 0, - d.x ).normalize();
		var radians = Math.acos( d.y );
		var quaternion = THREE.myLine.__q1.setFromAxisAngle( axis, radians );
		this.rotation.setEulerFromQuaternion( quaternion, this.eulerOrder );
	}
};

THREE.myLine.prototype.setLength = function ( length ) {
	if (Math.abs(length)<=1) {
		this.cone.visible = false;
		this.cylinder.visible=false;
	} else {
		this.cone.visible = true;
		this.cylinder.visible=true;
	}
	
	this.cone.scale.set(1,1,1);
	this.cylinder.scale.set(1,length,1);
	this.cone.position.set(0,length/2,0);
	this.cylinder.position.set(0,length/2,0);

	//this.cylinder.scale.set(1,length,1);
	
};

THREE.myLine.prototype.setColor = function ( hex, opacity ) {
	if ( opacity === undefined ) opacity = 1;

	this.cylinder.material.color.setHex( hex );
	this.cylinder.material.opacity=opacity

	this.cone.material.color.setHex( hex );
	this.cone.material.opacity=opacity
};


THREE.myLine.__v1 = new THREE.Vector3();
THREE.myLine.__v2 = new THREE.Vector3();
THREE.myLine.__q1 = new THREE.Quaternion();
