// (c) by Sitsanlis Ilias All rights reserved

var	vectorConeLength=1.2;
var	lMin=6;

THREE.myVector = function ( dir, origin, length, width, hex ) {
	THREE.Object3D.call( this );
	if ( length === undefined ) length = 20;
	if ( hex === undefined ) hex = 0xffffff;
	if ( width === undefined) width=0.6

	//vectorConeLength=width*5

	var cylinderGeometry = new THREE.CylinderGeometry( width, width, 1, 20, 1 );
	this.cylinder = new THREE.Mesh( cylinderGeometry, new THREE.MeshBasicMaterial( { color: hex, transparent:false } ) );
	this.cylinder.position.set( 0, 1/2, 0 );
	this.add( this.cylinder );

	var coneGeometry = new THREE.CylinderGeometry( 0, 2.5*width,  5*width, 20, 1 );
	this.cone = new THREE.Mesh( coneGeometry, new THREE.MeshBasicMaterial( { color: hex, transparent:false } ) );
	this.cone.position.set( 0, 1, 0 );
	this.add( this.cone );

	if ( origin instanceof THREE.Vector3 ) this.position = origin;
	this.setDirection( dir );
	this.setLength( length ,width);
};

THREE.myVector.prototype = Object.create( THREE.Object3D.prototype );

THREE.myVector.prototype.setDirection = function ( dir ) {
    var d = THREE.myVector.__v1.copy( dir ).normalize();
    if ( d.y > 0.999 ) {
        this.rotation.set( 0, 0, 0 );
    } else if ( d.y < - 0.999 ) {
        this.rotation.set( Math.PI, 0, 0 );
    } else {
		var axis = THREE.myVector.__v2.set( d.z, 0, - d.x ).normalize();
		var radians = Math.acos( d.y );
		var quaternion = THREE.myVector.__q1.setFromAxisAngle( axis, radians );
		this.rotation.setEulerFromQuaternion( quaternion, this.eulerOrder );
	}
};

THREE.myVector.prototype.setLength = function ( length , width) {
	if (width==undefined) {lMin=6;vectorConeLength=1.2} else {lMin=width*8;vectorConeLength=5*width}
	if (Math.abs(length)<=1.5*width) {
		this.cone.visible = false;
		this.cylinder.visible=false;
	} else {
		this.cone.visible = true;
		this.cylinder.visible=true;
	}
	
	
	
	if (Math.abs(length)>=lMin) {
		var e=length/Math.abs(length);
		this.cone.scale.set(1,e,1);
		this.cylinder.scale.set(1,e*(e*length-vectorConeLength/2),1);
		this.cone.position.set(0,e*(e*length-vectorConeLength/2),0);
		this.cylinder.position.set(0,e*(e*length-vectorConeLength/2)/2,0);
	} else {
		this.cone.scale.set(1,length/lMin,1);
		this.cylinder.scale.set(1,length-(length*vectorConeLength/lMin)/2,1);
		this.cone.position.set(0,length-(length*vectorConeLength/lMin)/2,0);
		this.cylinder.position.set(0,(length-(length*vectorConeLength/lMin)/2)/2,0);
	}
	//this.cylinder.scale.set(1,length,1);
	if (length==0) {
		this.cylinder.scale.set(0,0,0)
		this.cone.scale.set(0,0,0)
	}
};

THREE.myVector.prototype.setColor = function ( hex, opacity ) {
	if ( opacity === undefined ) opacity = 1;

	this.cylinder.material.color.setHex( hex );
	this.cylinder.material.opacity=opacity

	this.cone.material.color.setHex( hex );
	this.cone.material.opacity=opacity
};


THREE.myVector.__v1 = new THREE.Vector3();
THREE.myVector.__v2 = new THREE.Vector3();
THREE.myVector.__q1 = new THREE.Quaternion();
