/* global Object3D, THREE */

/**
 * @author WestLangley / http://github.com/WestLangley
 * @author zz85 / http://github.com/zz85
 * @author bhouston / http://clara.io
 *************************************  modified 28/7/18 dimitrios aggelis
 * Creates an arrow for visualizing directions
 *
 * Parameters:
 *  dir - Vector3
 *  origin - Vector3
 *  length - Number
 *  color - color in hex value
 *  headLength - Number
 *  headWidth - Number
 */


//
//
//  modified segments to 12 
var epsilon = 1E-15;

THREE.Arrow = function (dirx, diry, dirz, origin, length, color, headLength, headWidth, lineWidth) {
    var lineGeometry;
    var coneGeometry;
    var material;
    this.headLength;
    this.headWidth;
    this.r1; // scalex,scalez of line cylinder
    // dir is assumed to be normalized

    THREE.Object3D.call(this);

    if (color === undefined)
        color = 0xffff00;
    if (length === undefined)
        length = 1;
    if (headLength === undefined)
        headLength = 0.2 * length;
    if (headWidth === undefined)
        headWidth = 0.2 * headLength;
    if (lineWidth === undefined)
        lineWidth = 0.02;// * headLength;
    /// save values 
    this.r1 = lineWidth / 2;
    this.headLength = headLength;
    this.headWidth = headWidth;

    if (lineGeometry === undefined) {


        lineGeometry = new THREE.CylinderBufferGeometry(1, 1, 1, 12, 1);

        lineGeometry.translate(0, +0.5, 0);
        coneGeometry = new THREE.CylinderBufferGeometry(0, 0.5, 1, 12, 1);
        coneGeometry.translate(0, -0.5, 0);

    }

    this.position.copy(origin);
    material = new THREE.MeshBasicMaterial({color: color});
    this.line = new THREE.Mesh(lineGeometry, material);
    this.line.matrixAutoUpdate = false;
    this.add(this.line);

    this.cone = new THREE.Mesh(coneGeometry, material);
    this.cone.matrixAutoUpdate = false;
    this.add(this.cone);

    this.setDirection(dirx, diry, dirz);
    this.setLength(length, headLength, headWidth);

}

THREE.Arrow.prototype = Object.create(THREE.Object3D.prototype);
THREE.Arrow.prototype.constructor = THREE.Arrow;
/*
 THREE.Arrow.prototype.setDirection = ( function () {
 
 var axis = new  THREE.Vector3();
 var radians;
 
 return function setDirection( x,y,z ) {
 var dir=new  THREE.Vector3(x,y,z);
 
 dir.normalize();
 // dir is assumed to be normalized
 
 if ( dir.y > 0.99999 ) {
 
 this.quaternion.set( 0, 0, 0, 1 );
 
 } else if ( dir.y < - 0.99999 ) {
 
 this.quaternion.set( 1, 0, 0, 0 );
 
 } else {
 
 axis.set( dir.z, 0, - dir.x ).normalize();
 
 radians = Math.acos( dir.y );
 
 this.quaternion.setFromAxisAngle( axis, radians );
 
 }
 
 };
 
 }() );
 */

THREE.Arrow.prototype.setDirection = function (x, y, z) {
    var dir = new THREE.Vector3(x, y, z);
    var axis = new THREE.Vector3();
    var radians;

    dir.normalize();
    // dir is assumed to be normalized

    if (dir.y > 0.99999) {

        this.quaternion.set(0, 0, 0, 1);

    } else if (dir.y < -0.99999) {

        this.quaternion.set(1, 0, 0, 0);

    } else {

        axis.set(dir.z, 0, -dir.x).normalize();

        radians = Math.acos(dir.y);

        this.quaternion.setFromAxisAngle(axis, radians);

    }

};




THREE.Arrow.prototype.setLength = function (length) {
    /// make absMath.abs( );
    length = Math.abs(length);
    var hl = this.headLength; /// if too small length 
    if (Math.abs(hl) < 0.0001)
        hl = 0.0001;

    if (hl > length / 2)
        hl = length / 2;
    var hw = this.headWidth;
    if (hw > hl) {
        // hl=length/2;
        hw = hl;

    }


    this.line.scale.set(this.r1, Math.max(epsilon, length - hl), this.r1);
    this.line.updateMatrix();
    this.cone.visible = false;
    /// if hl===0 its a line 
    if (Math.abs(hl) > 0.0001) {

        this.cone.visible = true;
        this.cone.scale.set(hw, hl, hw);
        this.cone.position.y = length;
        this.cone.updateMatrix();
    }

};
THREE.Arrow.prototype.setHeadLength = function (headLength) {




    this.headLength = headLength;

};
THREE.Arrow.prototype.setHeadWidth = function (headWidth) {
    this.headWidth = headWidth;

};
THREE.Arrow.prototype.setLineWidth = function (lineWidth) {
    this.r1 = lineWidth / 2;


};



THREE.Arrow.prototype.setColor = function (color) {

    this.line.material.color.set(color);
    this.cone.material.color.set(color);

};


