/* global Object3D, THREE */

var epsilon = 1E-15;
function Arrow2(dir, origin, length, width, headLength) {

    var lineGeometry;
    var coneGeometry;
    // dir is assumed to be normalized

    THREE.Object3D.call(this);

    if (color === undefined)
        color = 0xffff00;
    if (length === undefined)
        length = 1;

    if (width === undefined)
        width = 0.2;
    if (headLength === undefined)
        headLength = 0.2 * length;
    this.headlen = headLength;
    //if ( headWidth === undefined ) headWidth = 0.2 * headLength;

    if (lineGeometry === undefined) {

        //lineGeometry = new THREE.BufferGeometry();
        //lineGeometry.addAttribute( 'position', new THREE.Float32BufferAttribute( [ 0, 0, 0, 0, 1, 0 ], 3 ) );
        lineGeometry = new THREE.CylinderBufferGeometry(width, width, 1, 24, 1);
        lineGeometry.translate(0, 0.5, 0);
        coneGeometry = new THREE.CylinderBufferGeometry(0, 2.85 * width, 1, 24, 1);
        coneGeometry.translate(0, -0.5, 0);

    }
    var color = new THREE.Color();
    this.position.copy(origin);

    this.line = new THREE.Mesh(lineGeometry, new THREE.MeshBasicMaterial({color: color}));
    this.line.matrixAutoUpdate = false;
    this.add(this.line);

    this.cone = new THREE.Mesh(coneGeometry, new THREE.MeshBasicMaterial({color: color}));
    this.cone.matrixAutoUpdate = false;
    this.add(this.cone);

    this.setDirection(dir.x, dir.y, dir.z);
    this.setLength(length, headLength, width);

}

Arrow2.prototype = Object.create(THREE.Object3D.prototype);
Arrow2.prototype.constructor = Arrow2;

 




    var _axis = new THREE.Vector3();
  

    Arrow2.prototype.setDirection=function(x, y, z) {
        var dir = new THREE.Vector3(x, y, z);


        dir.normalize();
        // dir is assumed to be normalized

        if (dir.y > 0.99999) {

            this.quaternion.set(0, 0, 0, 1);

        } else if (dir.y < -0.99999) {

            this.quaternion.set(1, 0, 0, 0);

        } else {

            _axis.set(dir.z, 0, -dir.x).normalize();

         

            this.quaternion.setFromAxisAngle(_axis, Math.acos(dir.y));

        }

    };
Arrow2.prototype.setDirection=function(x, y, z) {
        var dir = new THREE.Vector3(x, y, z);


        dir.normalize();
        // dir is assumed to be normalized

        if (dir.y > 0.99999) {

            this.quaternion.set(0, 0, 0, 1);

        } else if (dir.y < -0.99999) {

            this.quaternion.set(1, 0, 0, 0);

        } else {

            _axis.set(dir.z, 0, -dir.x).normalize();

         

            this.quaternion.setFromAxisAngle(_axis, Math.acos(dir.y));

        }

    };
 Arrow2.prototype.fromxyz=function(x, y, z) {
        this.setDirection(x,y,z);
        this.setLength(Math.sqrt(x*x,y*y+z*z),this.headlen)

    };

Arrow2.prototype.setLength = function (length, headLength) {

    if (headLength === undefined)
        headLength = abs(this.headlen) * sign(length);

    var f1 = 0.075;
    if (abs(headLength) > abs(length / 2))
        headLength = 0.5 * sign(length) * abs(length)

    var cyllen = abs(length) - abs(headLength);
    var kl = cyllen * sign(length);
    if (iszero(kl)) {
        kl = epsilon;

        this.line.visible = false;
        this.cone.visible = false;

    } else {
        this.line.visible = !false;
        this.cone.visible = !false;
    }
    //this.line.scale.set( 1, Math.max( 0, length - headLength ), 1 );
    this.line.scale.set(1, kl, 1);
    this.line.updateMatrix();

    ///this.cone.scale.set( headWidth, headLength, headWidth );
    this.cone.scale.set(1, headLength, 1);
    this.cone.position.y = length;
    this.cone.updateMatrix();

};

Arrow2.prototype.setColor = function (color) {

    this.line.material.color.copy(color);
    this.cone.material.color.copy(color);

};



