"use strict";

function LogoSandBox() {
    this.metavlites = {};
    this.ErrorMessage = "";
}

LogoSandBox.prototype.SetMet = function (strScope, strMet, value) {
    var met = strScope + "." + strMet;
    this.metavlites[met] = (value == null) ? 0 : value; 
};

LogoSandBox.prototype.GetMet =  function (strScope, strMet) {
    if ($.isNumeric(strMet))
        return Number(strMet);
    var met = strScope + "." + strMet;
    var newStatement = this.ParseStatement(strScope, strMet);
    if (newStatement == ""){
        console.log( this.ErrorMessage);
        return undefined;
    }
    var ret = eval(newStatement);
    return ret;

    if (this.metavlites[met] === undefined) {
        met = "Κεντρικό" + "." + strMet;
        if (this.metavlites[met] === undefined)
            return undefined;
    }
    return this.metavlites[met];
}

LogoSandBox.prototype.MetToString = function(strScope, strMet) {
    var met = strScope + "." + strMet;
    if (this.metavlites[met] === undefined) {
        met = "Κεντρικό" + "." + strMet;
        if (this.metavlites[met] === undefined)
            return "";
    }
    return "this.metavlites['" + met + "']";
}

LogoSandBox.prototype.Clear = function() {
    for (var met in this.metavlites){
        //console.log(met);
        delete this.metavlites[met];
    }
        
}

LogoSandBox.prototype.ParseStatement = function (strScope, strStatement) {
    strStatement = strStatement.replace(/ /gi, ""); //remove spaces
    var newStatement = "";
    var arrStatement = strStatement.split('');  
    var operators = "+-*/()><=!|&[],";
    var strMet = new String("");    
    var strVar = new String("");
    
    for (var i=0, len = arrStatement.length; i < len; i++){
        var ch = arrStatement[i];
        if (operators.indexOf(ch) == -1) {
            strMet += ch;
        }
        else {
            if (strMet == "") {
                newStatement += ch;
                continue;
            }
            if (!$.isNumeric(strMet)) {
                strVar = this.MetToString(strScope, strMet);
                if (strVar == "") {
                    this.ErrorMessage = "Άγνωστο -> " + strMet;
                    return "";                 
                }
            }
            else
                strVar = strMet;
            newStatement += strVar + ch;
            strMet = "";
            strVar = "";
        }
    }
    strVar = strMet;
    if (strMet != "" && !$.isNumeric(strMet)) {
        strVar = this.MetToString(strScope, strMet);
        if (strVar == "") {
            this.ErrorMessage = "Άγνωστο -> " + strMet;
            return "";                 
        }
    }
    newStatement += strVar;   
    return newStatement;
}   

LogoSandBox.prototype.MakeAssignment = function (strScope, strStatement) {
    strStatement = strStatement.replace(/ /gi, ""); //remove spaces
    var arrParam = strStatement.split("=");
    if (arrParam.length != 2) {
        this.ErrorMessage = "Σφάλμα -> " + strStatement;
        console.log("Σφάλμα -> " + strStatement);
        return false;
    }
    //console.log(arrParam);
    var paramName = arrParam[0];
    var met = strScope + "." + arrParam[0];
    var v = this.metavlites[met];
    if (v === undefined)
        v = 0;
    this.SetMet(strScope, arrParam[0], v);
    paramName = this.MetToString(strScope, arrParam[0]);
    
    var newStatement = this.ParseStatement(strScope, arrParam[1]);
    if (newStatement == ""){
        console.log( this.ErrorMessage);
        return false;
    }
    
    newStatement = paramName + "=" + newStatement;
    //console.log(newStatement);
    eval(newStatement); 
    this.ErrorMessage = "";
    return true;
}

LogoSandBox.prototype.CheckCondition = function (strScope, strStatement) {
    var ret = true;
    strStatement = strStatement.replace("=", "==");
    strStatement = strStatement.replace(/===/g, "==");
    strStatement = strStatement.replace(/!==/g, "!=");
    strStatement = strStatement.replace(/>==/g, ">=");
    strStatement = strStatement.replace(/<==/g, "<=");
    
    var newStatement = this.ParseStatement(strScope, strStatement);
    if (newStatement == ""){
        console.log( this.ErrorMessage);
        return undefined;
    }
    //console.log(newStatement);
    try {
        ret = eval(newStatement); 
    }
    catch(e) {
        this.ErrorMessage = "Συντακτικό σφάλμα";
        return undefined;
    }
    this.ErrorMessage = "";
    return ret;
}
