/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class IEMA_Klimakes_Main
extends Applet {
    ImagePanel panel = null;
    public int ww = 1200;
    public int hh = 600;
    private static final long serialVersionUID = 6612584571445496597L;
    Piano piano = null;
    Pent pent = null;
    public boolean NextNoteOK = false;
    public JComboBox<?> cMidiOut;
    JComboBox<String> cMajorMinor;
    JComboBox<String> cClimax;
    JComboBox<String> cIWant;
    String[] course1 = new String[]{"\u039d\u03c4\u03cc \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a3\u03bf\u03bb \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a1\u03b5 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u039b\u03b1 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u039c\u03b9 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a3\u03b9 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a6\u03b1", "\u039d\u03c4\u03bf", "\u03a3\u03bf\u03bb", "\u03a1\u03b5", "\u039b\u03b1", "\u039c\u03b9", "\u03a3\u03b9", "\u03a6\u03b1 \u03b4\u03af\u03b5\u03c3\u03b7", "\u039d\u03c4\u03cc \u03b4\u03af\u03b5\u03c3\u03b7"};
    String[] course2 = new String[]{"\u039b\u03b1 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u039c\u03b9 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a3\u03b9 \u03cd\u03c6\u03b5\u03c3\u03b7", "\u03a6\u03b1", "\u039d\u03c4\u03bf", "\u03a3\u03bf\u03bb", "\u03a1\u03b5", "\u039b\u03b1", "\u039c\u03b9", "\u03a3\u03b9", "\u03a6\u03b1 \u03b4\u03af\u03b5\u03c3\u03b7", "\u039d\u03c4\u03bf \u03b4\u03af\u03b5\u03c3\u03b7", "\u03a3\u03bf\u03bb \u03b4\u03af\u03b5\u03c3\u03b7", "\u03a1\u03b5 \u03b4\u03af\u03b5\u03c3\u03b7", "\u039b\u03b1 \u03b4\u03af\u03b5\u03c3\u03b7"};
    int[] AllNotesX = new int[128];
    ArrayList<Note> ConstructingClimax = new ArrayList(0);
    Sequencer sequencer = null;
    public JButton bhelp;
    public JButton bcr;
    public HelpCenter hc;

    public static void OpenAbout(Class c) {
        try {
            URL helpURL = IEMA_Klimakes_Main.class.getResource("chourdakis.html");
            JEditorPane website = new JEditorPane(helpURL);
            website.setEditable(false);
            JFrame frame = new JFrame("About...");
            frame.add(new JScrollPane(website));
            frame.setVisible(true);
            frame.pack();
            frame.setSize(new Dimension(1000, 800));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addTrack(Sequence s, int instrument, int tempo, int[] MM, int nn) throws InvalidMidiDataException {
        Track track = s.createTrack();
        ShortMessage sm = new ShortMessage();
        sm.setMessage(192, 0, instrument, 0);
        track.add(new MidiEvent(sm, 0L));
        int j = 0;
        while (j < nn) {
            int jd = j * 16;
            ShortMessage on = new ShortMessage();
            on.setMessage(144, 0, MM[j], 127);
            ShortMessage off = new ShortMessage();
            off.setMessage(128, 0, MM[j], 127);
            track.add(new MidiEvent(on, jd + 16));
            track.add(new MidiEvent(off, jd + 16 + 16));
            ++j;
        }
    }

    public void Release2() {
        try {
            int i = 0;
            while (i < 128) {
                if (this.AllNotesX[i] != 0) {
                    ShortMessage myMsg = new ShortMessage();
                    myMsg.setMessage(128, 0, i, 93);
                    long timeStamp = -1L;
                    Receiver rcvr = MidiSystem.getReceiver();
                    rcvr.send(myMsg, timeStamp);
                    this.AllNotesX[i] = 0;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean MidiEqual(int m1, int m2) {
        return m1 % 12 == m2 % 12;
    }

    public void Play2(int m) {
        try {
            ShortMessage myMsg = new ShortMessage();
            this.AllNotesX[m] = 1;
            myMsg.setMessage(144, 0, m, 93);
            long timeStamp = -1L;
            Receiver rcvr = MidiSystem.getReceiver();
            rcvr.send(myMsg, timeStamp);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void Play(int[] m) {
        if (this.sequencer == null) {
            try {
                this.sequencer = MidiSystem.getSequencer();
                this.sequencer.open();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Sequence sequence = new Sequence(0.0f, 16);
            int[] mx = new int[m.length];
            int j = 0;
            while (j < m.length) {
                mx[j] = m[j];
                ++j;
            }
            IEMA_Klimakes_Main.addTrack(sequence, 0, 120, mx, mx.length);
            this.sequencer.setSequence(sequence);
            this.sequencer.setTempoInBPM(120.0f);
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage msg) {
                    msg.getType();
                }
            });
            this.sequencer.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void CreateBG() {
        Rectangle r4 = new Rectangle(new Point(0, 0), new Dimension(this.ww, this.hh));
    }

    public void CreateHelpCenter() {
        this.hc = new HelpCenter();
        this.panel.add(this.hc);
        Rectangle r2 = new Rectangle(new Point(400, 0), new Dimension(this.ww - 400, this.hh));
        this.hc.setBounds(r2);
        this.hc.setVisible(true);
        this.hc.repaint();
    }

    public void infoBox(String infoMessage, String title) {
        IEMA_Klimakes_Main.OpenAbout(this.getClass());
    }

    public void CreateHelpButton() {
        this.bhelp = new JButton("");
        try {
            this.bhelp.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResource("help.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.panel.add(this.bhelp);
        Rectangle r = new Rectangle(new Point(410, 5), new Dimension(90, 30));
        this.bhelp.setFont(new Font("Serif", 1, 12));
        this.bhelp.setBounds(r);
        this.bhelp.repaint();
        this.bhelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean a = IEMA_Klimakes_Main.this.hc.isVisible();
                a = !a;
                IEMA_Klimakes_Main.this.hc.setVisible(a);
                IEMA_Klimakes_Main.this.hc.repaint();
            }
        });
    }

    public void CreateCreditsButton() {
        this.bcr = new JButton("");
        try {
            this.bcr.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResource("info.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.panel.add(this.bcr);
        Rectangle r = new Rectangle(new Point(500, 5), new Dimension(90, 30));
        this.bcr.setBounds(r);
        this.bcr.repaint();
        this.bcr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IEMA_Klimakes_Main.this.infoBox("\u039a\u03bb\u03af\u03bc\u03b1\u03ba\u03b5\u03c2, Copyright (C) - ", "About...");
            }
        });
    }

    public void CreateSoundCardItems() {
        String[] course = new String[]{};
        JComboBox<String> combo = new JComboBox<String>(course);
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                if (device instanceof MidiDevice) {
                    combo.addItem(infos[i].getName());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        this.panel.add(combo);
        Rectangle r = new Rectangle(new Point(0, this.hh - 130), new Dimension(200, 20));
        combo.setBounds(r);
        combo.repaint();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
                int idx = IEMA_Klimakes_Main.this.cMidiOut.getSelectedIndex();
                if (idx < infos.length) {
                    try {
                        MidiDevice device = MidiSystem.getMidiDevice(infos[idx]);
                        device.open();
                        if (IEMA_Klimakes_Main.this.sequencer != null) {
                            IEMA_Klimakes_Main.this.sequencer.close();
                        }
                        IEMA_Klimakes_Main.this.sequencer = MidiSystem.getSequencer(false);
                        Receiver MidiOutReceiver = device.getReceiver();
                        Transmitter trs = IEMA_Klimakes_Main.this.sequencer.getTransmitter();
                        trs.setReceiver(MidiOutReceiver);
                        IEMA_Klimakes_Main.this.sequencer.open();
                    }
                    catch (MidiUnavailableException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.cMidiOut = combo;
    }

    public JComboBox<String> CreateIWantComboBox() {
        JLabel lab = new JLabel("\u0398\u03ad\u03bb\u03c9 \u03bd\u03b1: ");
        this.panel.add(lab);
        Rectangle r = new Rectangle(new Point(0, 95), new Dimension(70, 50));
        lab.setBounds(r);
        lab.repaint();
        String[] course = new String[]{"\u03a6\u03c4\u03b9\u03ac\u03be\u03c9", "\u0391\u03ba\u03bf\u03cd\u03c3\u03c9"};
        JComboBox<String> combo = new JComboBox<String>(course);
        combo.setSelectedIndex(0);
        combo.setFont(new Font("Serif", 1, 18));
        this.panel.add(combo);
        r = new Rectangle(new Point(70, 100), new Dimension(100, 35));
        combo.setBounds(r);
        combo.repaint();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IEMA_Klimakes_Main.this.pent.repaint();
                IEMA_Klimakes_Main.this.CleateClimaxIfHearing();
            }
        });
        return combo;
    }

    public JComboBox<String> CreateSelectMode() {
        String[] course = new String[]{"\u039c\u03b5\u03af\u03b6\u03bf\u03bd\u03b1", "\u0395\u03bb\u03ac\u03c3\u03c3\u03bf\u03bd\u03b1 \u0391\u03c1\u03bc\u03bf\u03bd\u03b9\u03ba\u03ae", "\u0395\u03bb\u03ac\u03c3\u03c3\u03bf\u03bd\u03b1 \u039c\u03b5\u03bb\u03c9\u03b4\u03b9\u03ba\u03ae"};
        JComboBox<String> combo = new JComboBox<String>(course);
        combo.setSelectedIndex(0);
        this.panel.add(combo);
        Rectangle r = new Rectangle(new Point(180, 100), new Dimension(200, 35));
        combo.setFont(new Font("Serif", 1, 18));
        combo.setBounds(r);
        combo.repaint();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IEMA_Klimakes_Main.this.ConstructingClimax.clear();
                IEMA_Klimakes_Main.this.pent.repaint();
                IEMA_Klimakes_Main.this.cClimax = IEMA_Klimakes_Main.this.CreateChooseClimax();
                IEMA_Klimakes_Main.this.CleateClimaxIfHearing();
            }
        });
        return combo;
    }

    public void CleateClimaxIfHearing() {
        if (this.cIWant.getSelectedIndex() == 1) {
            int[] c1 = new int[]{2, 2, 1, 2, 2, 2, 1};
            int[] c2 = new int[]{2, 1, 2, 2, 1, 3, 1};
            int[] c3 = new int[]{2, 1, 2, 2, 2, 2, 1};
            int[] c = null;
            c = this.cMajorMinor.getSelectedIndex() == 0 ? c1 : (this.cMajorMinor.getSelectedIndex() == 1 ? c2 : c3);
            int NoteMustMidi = 0;
            if (this.cClimax.getSelectedIndex() == 0) {
                NoteMustMidi = 47;
            }
            if (this.cClimax.getSelectedIndex() == 1) {
                NoteMustMidi = 54;
            }
            if (this.cClimax.getSelectedIndex() == 2) {
                NoteMustMidi = 49;
            }
            if (this.cClimax.getSelectedIndex() == 3) {
                NoteMustMidi = 44;
            }
            if (this.cClimax.getSelectedIndex() == 4) {
                NoteMustMidi = 51;
            }
            if (this.cClimax.getSelectedIndex() == 5) {
                NoteMustMidi = 46;
            }
            if (this.cClimax.getSelectedIndex() == 6) {
                NoteMustMidi = 53;
            }
            if (this.cClimax.getSelectedIndex() == 7) {
                NoteMustMidi = 48;
            }
            if (this.cClimax.getSelectedIndex() == 8) {
                NoteMustMidi = 55;
            }
            if (this.cClimax.getSelectedIndex() == 9) {
                NoteMustMidi = 50;
            }
            if (this.cClimax.getSelectedIndex() == 10) {
                NoteMustMidi = 57;
            }
            if (this.cClimax.getSelectedIndex() == 11) {
                NoteMustMidi = 52;
            }
            if (this.cClimax.getSelectedIndex() == 12) {
                NoteMustMidi = 59;
            }
            if (this.cClimax.getSelectedIndex() == 13) {
                NoteMustMidi = 54;
            }
            if (this.cClimax.getSelectedIndex() == 14) {
                NoteMustMidi = 49;
            }
            if (this.cMajorMinor.getSelectedIndex() == 1 || this.cMajorMinor.getSelectedIndex() == 2) {
                NoteMustMidi -= 3;
            }
            if (NoteMustMidi > 0) {
                this.ConstructingClimax.clear();
                Note nx = new Note();
                nx.midi = NoteMustMidi;
                this.ConstructingClimax.add(nx);
                int j = 1;
                while (j < 8) {
                    Note nx2 = new Note();
                    nx2.midi = NoteMustMidi += c[j - 1];
                    this.ConstructingClimax.add(nx2);
                    ++j;
                }
            }
        }
    }

    public JComboBox<String> CreateChooseClimax() {
        int ke = 7;
        if (this.cClimax != null) {
            ke = this.cClimax.getSelectedIndex();
            this.panel.remove(this.cClimax);
            this.cClimax = null;
        }
        JComboBox<String> combo = null;
        combo = this.cMajorMinor != null && this.cMajorMinor.getSelectedIndex() != 0 ? new JComboBox<String>(this.course2) : new JComboBox<String>(this.course1);
        combo.setSelectedIndex(ke);
        this.panel.add(combo);
        Rectangle r = new Rectangle(new Point(390, 100), new Dimension(180, 35));
        combo.setBounds(r);
        combo.setFont(new Font("Serif", 1, 18));
        combo.repaint();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IEMA_Klimakes_Main.this.ConstructingClimax.clear();
                IEMA_Klimakes_Main.this.CleateClimaxIfHearing();
                IEMA_Klimakes_Main.this.pent.repaint();
            }
        });
        return combo;
    }

    public void CreatePanel() {
        this.panel = new ImagePanel(this.ww, this.hh, "bg.jpg");
        this.panel.setPreferredSize(new Dimension(this.ww, this.hh));
        this.panel.setBackground(new Color(0, 0, 0, 0));
        this.setSize(this.ww, this.hh);
        this.panel.setLayout(null);
        this.CreateCreditsButton();
        this.CreateHelpCenter();
        this.cIWant = this.CreateIWantComboBox();
        this.cMajorMinor = this.CreateSelectMode();
        this.cClimax = this.CreateChooseClimax();
        this.piano = new Piano();
        this.panel.add(this.piano);
        Rectangle r = new Rectangle(new Point(0, this.hh - 100), new Dimension(this.ww, 100));
        this.piano.setBounds(r);
        this.piano.repaint();
        this.piano.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                boolean NeedsUpdate = false;
                int i = 0;
                while (i < IEMA_Klimakes_Main.this.piano.Notes.size()) {
                    Note n = IEMA_Klimakes_Main.this.piano.Notes.get(i);
                    if (n.Down) {
                        NeedsUpdate = true;
                    }
                    n.Down = false;
                    ++i;
                }
                if (NeedsUpdate) {
                    IEMA_Klimakes_Main.this.piano.repaint();
                }
                IEMA_Klimakes_Main.this.Release2();
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                int[] m8;
                Note n = IEMA_Klimakes_Main.this.piano.Hit(arg0.getX(), arg0.getY());
                if (n == null) {
                    return;
                }
                n.Down = true;
                if (IEMA_Klimakes_Main.this.cIWant.getSelectedIndex() == 1) {
                    m8 = new int[3];
                    int i = 0;
                    while (i < IEMA_Klimakes_Main.this.ConstructingClimax.size()) {
                        Note n4 = IEMA_Klimakes_Main.this.ConstructingClimax.get(i);
                        n4.Black = false;
                        if (n4.midi % 12 == n.midi % 12) {
                            int iType = IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex();
                            n4.Black = true;
                            m8[0] = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi;
                            boolean thmax = true;
                            if (iType == 0 && (i == 1 || i == 2 || i == 5 || i == 6)) {
                                thmax = false;
                            }
                            if (iType == 1 && (i == 0 || i == 1 || i == 3 || i == 6)) {
                                thmax = false;
                            }
                            if (iType == 2 && (i == 0 || i == 1 || i == 5 || i == 6)) {
                                thmax = false;
                            }
                            m8[1] = thmax ? IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi + 4 : IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi + 3;
                            int fika = 0;
                            if (iType == 0 && i == 6) {
                                fika = -1;
                            }
                            if (iType == 1 && (i == 6 || i == 1)) {
                                fika = -1;
                            }
                            if ((iType == 1 || iType == 2) && i == 2) {
                                fika = 1;
                            }
                            if (iType == 2 && (i == 5 || i == 6)) {
                                fika = -1;
                            }
                            if (fika == 0) {
                                m8[2] = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi + 7;
                            }
                            if (fika == 1) {
                                m8[2] = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi + 8;
                            }
                            if (fika != -1) break;
                            m8[2] = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi + 6;
                            break;
                        }
                        ++i;
                    }
                    IEMA_Klimakes_Main.this.pent.repaint();
                    if (m8[0] != 0) {
                        IEMA_Klimakes_Main.this.Play(m8);
                    }
                }
                if (IEMA_Klimakes_Main.this.cIWant.getSelectedIndex() == 0) {
                    int[] c1 = new int[]{2, 2, 1, 2, 2, 2, 1};
                    int[] c2 = new int[]{2, 1, 2, 2, 1, 3, 1};
                    int[] c3 = new int[]{2, 1, 2, 2, 2, 2, 1};
                    int[] c = null;
                    c = IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex() == 0 ? c1 : (IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex() == 1 ? c2 : c3);
                    int NoteMustMidi = 0;
                    if (IEMA_Klimakes_Main.this.ConstructingClimax.size() != 8) {
                        if (IEMA_Klimakes_Main.this.ConstructingClimax.size() == 0) {
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 0) {
                                NoteMustMidi = 47;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 1) {
                                NoteMustMidi = 54;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 2) {
                                NoteMustMidi = 49;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 3) {
                                NoteMustMidi = 44;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 4) {
                                NoteMustMidi = 51;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 5) {
                                NoteMustMidi = 46;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 6) {
                                NoteMustMidi = 53;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 7) {
                                NoteMustMidi = 48;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 8) {
                                NoteMustMidi = 55;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 9) {
                                NoteMustMidi = 50;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 10) {
                                NoteMustMidi = 57;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 11) {
                                NoteMustMidi = 52;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 12) {
                                NoteMustMidi = 59;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 13) {
                                NoteMustMidi = 54;
                            }
                            if (IEMA_Klimakes_Main.this.cClimax.getSelectedIndex() == 14) {
                                NoteMustMidi = 49;
                            }
                            if (IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex() == 1 || IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex() == 2) {
                                NoteMustMidi -= 3;
                            }
                        } else {
                            int p = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)(IEMA_Klimakes_Main.this.ConstructingClimax.size() - 1)).midi;
                            NoteMustMidi = p + c[IEMA_Klimakes_Main.this.ConstructingClimax.size() - 1];
                        }
                    }
                    if (IEMA_Klimakes_Main.this.MidiEqual(NoteMustMidi, n.midi) && IEMA_Klimakes_Main.this.ConstructingClimax.size() < 8) {
                        IEMA_Klimakes_Main.this.NextNoteOK = true;
                        Note nx = new Note();
                        nx.midi = NoteMustMidi;
                        if (IEMA_Klimakes_Main.this.ConstructingClimax.size() != 0) {
                            int p = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)(IEMA_Klimakes_Main.this.ConstructingClimax.size() - 1)).midi;
                            while (NoteMustMidi < p) {
                                NoteMustMidi += 12;
                            }
                            while (NoteMustMidi > p + 12) {
                                NoteMustMidi -= 12;
                            }
                            nx.midi = NoteMustMidi;
                        }
                        IEMA_Klimakes_Main.this.ConstructingClimax.add(nx);
                        IEMA_Klimakes_Main.this.pent.repaint();
                    } else {
                        IEMA_Klimakes_Main.this.NextNoteOK = false;
                    }
                }
                if (IEMA_Klimakes_Main.this.NextNoteOK && IEMA_Klimakes_Main.this.cIWant.getSelectedIndex() == 0) {
                    IEMA_Klimakes_Main.this.Play2(n.midi);
                    if (IEMA_Klimakes_Main.this.ConstructingClimax.size() == 8) {
                        m8 = new int[8];
                        int i = 0;
                        while (i < 8) {
                            m8[i] = IEMA_Klimakes_Main.this.ConstructingClimax.get((int)i).midi;
                            ++i;
                        }
                        IEMA_Klimakes_Main.this.Play(m8);
                    }
                }
                IEMA_Klimakes_Main.this.piano.repaint();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
        this.pent = new Pent();
        this.panel.add(this.pent);
        r = new Rectangle(new Point(0, this.hh - 230), new Dimension(this.ww, 100));
        this.pent.setBounds(r);
        this.pent.repaint();
        this.setVisible(true);
        this.add(this.panel);
    }

    @Override
    public void init() {
        this.CreatePanel();
        int i = 0;
        while (i < 128) {
            this.AllNotesX[i] = 0;
            ++i;
        }
    }

    public class HelpCenter
    extends JComponent {
        private static final long serialVersionUID = 2312645221395721638L;

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setColor(new Color(150, 150, 150, 200));
            g2.setFont(new Font("Calibri", 0, 18));
            g2.drawString("H \u03b5\u03c6\u03b1\u03c1\u03bc\u03bf\u03b3\u03ae \u03b1\u03c5\u03c4\u03ae \u03ad\u03c7\u03b5\u03b9 2 \u03b4\u03c5\u03bd\u03b1\u03c4\u03cc\u03c4\u03b7\u03c4\u03b5\u03c2. \u039c\u03c0\u03bf\u03c1\u03b5\u03af\u03c4\u03b5 \u03bd\u03b1 \u03c6\u03c4\u03b9\u03ac\u03be\u03b5\u03c4\u03b5 \u03bc\u03b9\u03b1 \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1", 220, 30);
            g2.drawString("(\u03bc\u03b5\u03af\u03b6\u03bf\u03bd\u03b1 \u03ae \u03b5\u03bb\u03ac\u03c3\u03c3\u03bf\u03bd\u03b1) \u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03ce\u03bd\u03c4\u03b1\u03c2 \u03c4\u03bf \u03bc\u03b9\u03ba\u03c1\u03cc \u03c0\u03b9\u03ac\u03bd\u03bf. \u0391\u03c6\u03bf\u03cd \u03b4\u03b9\u03b1\u03bb\u03ad\u03be\u03b5\u03c4\u03b5", 220, 50);
            g2.drawString("\u03c4\u03b7\u03bd \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1, \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5, \u03c0\u03b1\u03c4\u03ce\u03bd\u03c4\u03b1\u03c2 \u03bc\u03b5 \u03c4\u03bf \u03c0\u03bf\u03bd\u03c4\u03af\u03ba\u03b9, \u03c4\u03b9\u03c2 \u03bd\u03cc\u03c4\u03b5\u03c2 \u03c4\u03b7\u03c2 \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1\u03c2", 220, 70);
            g2.drawString("\u03b1\u03c0\u03cc \u03c4\u03bf \u03c0\u03b9\u03ac\u03bd\u03bf. \u039a\u03ac\u03b8\u03b5 \u03c3\u03c9\u03c3\u03c4\u03ae \u03bd\u03cc\u03c4\u03b1 \u03c0\u03bf\u03c5 \u03b5\u03c0\u03b9\u03bb\u03ad\u03b3\u03b5\u03c4\u03b1\u03b9 \u03b3\u03af\u03bd\u03b5\u03c4\u03b1\u03b9 \u03bc\u03c0\u03bb\u03b5 \u03ba\u03b1\u03b9 \u03b7 \u03bd\u03cc\u03c4\u03b1", 220, 90);
            g2.drawString("\u03b3\u03c1\u03ac\u03c6\u03b5\u03c4\u03b1\u03b9 \u03c3\u03c4\u03bf \u03c0\u03b5\u03bd\u03c4\u03ac\u03b3\u03c1\u03b1\u03bc\u03bc\u03bf. \u0391\u03bd \u03b7 \u03bd\u03cc\u03c4\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03bb\u03b1\u03bd\u03b8\u03b1\u03c3\u03bc\u03ad\u03bd\u03b7, \u03c4\u03bf \u03c0\u03bb\u03ae\u03ba\u03c4\u03c1\u03bf ", 220, 110);
            g2.drawString("\u03b3\u03af\u03bd\u03b5\u03c4\u03b1\u03b9 \u03ba\u03cc\u03ba\u03ba\u03b9\u03bd\u03bf. \u039c\u03cc\u03bb\u03b9\u03c2 \u03c4\u03b5\u03bb\u03b5\u03b9\u03ce\u03c3\u03b5\u03c4\u03b5 \u03b7 \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1 \u03b1\u03ba\u03bf\u03cd\u03b3\u03b5\u03c4\u03b1\u03b9 \u03bf\u03bb\u03bf\u03ba\u03bb\u03b7\u03c1\u03c9\u03bc\u03ad\u03bd\u03b7.", 220, 130);
            g2.drawString("\u039c\u03c0\u03bf\u03c1\u03b5\u03af\u03c4\u03b5 \u03b5\u03c0\u03af\u03c3\u03b7\u03c2 \u03bd\u03b1 \u03b1\u03ba\u03bf\u03cd\u03c3\u03b5\u03c4\u03b5 \u03c4\u03b9\u03c2 \u03c3\u03c5\u03b3\u03c7\u03bf\u03c1\u03b4\u03af\u03b5\u03c2 \u03bc\u03af\u03b1\u03c2 \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1\u03c2. \u0391\u03c6\u03bf\u03cd \u03b4\u03b9\u03b1\u03bb\u03ad\u03be\u03b5\u03c4\u03b5", 220, 220);
            g2.drawString("\u03c4\u03b7\u03bd \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1 \u03c0\u03bf\u03c5 \u03b8\u03ad\u03bb\u03b5\u03c4\u03b5, \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03bc\u03b5 \u03c4\u03bf \u03c0\u03bf\u03bd\u03c4\u03af\u03ba\u03b9 \u03bc\u03af\u03b1 \u03b1\u03c0\u03cc \u03c4\u03b9\u03c2 \u03bd\u03cc\u03c4\u03b5\u03c2 \u03c4\u03b7\u03c2 \u03c3\u03c4\u03bf \u03c0\u03b9\u03ac\u03bd\u03bf. ", 220, 240);
            g2.drawString("\u0391\u03bd \u03b7 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03ae \u03c4\u03cc\u03c4\u03b5 \u03b1\u03ba\u03bf\u03cd\u03b3\u03b5\u03c4\u03b1\u03b9 \u03b7 \u03c3\u03c5\u03b3\u03c7\u03bf\u03c1\u03b4\u03af\u03b1 \u03c3\u03b5 \u03b1\u03c5\u03c4\u03ae \u03c4\u03b7 \u03bd\u03cc\u03c4\u03b1", 220, 260);
            g2.drawString("\u03b3\u03b9\u03b1 \u03c4\u03b7\u03bd \u03ba\u03bb\u03af\u03bc\u03b1\u03ba\u03b1 \u03c0\u03bf\u03c5 \u03ad\u03c7\u03b5\u03c4\u03b5 \u03b5\u03c0\u03b9\u03bb\u03ad\u03be\u03b5\u03b9.", 220, 280);
        }
    }

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1966796964914128229L;
        public String imgf = null;
        public Image imgi = null;
        public int width;
        public int height;

        public void ReloadImage(String img, int wi, int he) {
            this.imgf = img;
            this.width = wi;
            this.height = he;
            if (this.imgf == null) {
                return;
            }
            try {
                URL in = this.getClass().getResource(this.imgf);
                this.imgi = ImageIO.read(in);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public ImagePanel(int wi, int he, String img) {
            this.ReloadImage(img, wi, he);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.imgi != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(this.imgi, 0, 0, null);
            }
        }
    }

    public class JImage
    extends JComponent {
        private static final long serialVersionUID = 2312156221393221638L;
        public String imgf = null;
        public Image imgi = null;
        public int width;
        public int height;

        public void ReloadImage(String img, int wi, int he) {
            this.imgf = img;
            this.width = wi;
            this.height = he;
            if (this.imgf == null) {
                return;
            }
            try {
                URL in = this.getClass().getResource(this.imgf);
                this.imgi = ImageIO.read(in);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public JImage(int wi, int he, String img) {
            this.ReloadImage(img, wi, he);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.imgi, 0, 0, null);
        }
    }

    public class Note {
        Rectangle r = new Rectangle();
        int midi = 0;
        boolean Black = false;
        boolean Down = false;

        Note() {
        }
    }

    public class Pent
    extends JComponent {
        private static final long serialVersionUID = -5909027834443592135L;

        @Override
        public Dimension getPreferredSize() {
            Dimension n = super.getPreferredSize();
            n.width = IEMA_Klimakes_Main.this.ww;
            n.height = 70;
            return n;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color cw = new Color(255, 255, 255, 255);
            g2.setColor(cw);
            try {
                BufferedImage iClef = ImageIO.read(this.getClass().getResource("clef.png"));
                g2.drawImage((Image)iClef, 0, -10, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < 5) {
                Color c = new Color(0, 0, 0, 255);
                g2.setColor(c);
                g2.setStroke(new BasicStroke(1.0f));
                g2.drawLine(0, 20 + i * 9, d.width, 20 + i * 9);
                ++i;
            }
            float step = 4.6f;
            int PX = 0;
            int mode = IEMA_Klimakes_Main.this.cMajorMinor.getSelectedIndex();
            int climax = IEMA_Klimakes_Main.this.cClimax.getSelectedIndex();
            if (climax == 0) {
                PX = 0;
            }
            if (climax == 1) {
                PX = 4;
            }
            if (climax == 2) {
                PX = 1;
            }
            if (climax == 3) {
                PX = 5;
            }
            if (climax == 4) {
                PX = 2;
            }
            if (climax == 5) {
                PX = 6;
            }
            if (climax == 6) {
                PX = 3;
            }
            if (climax == 7) {
                PX = 0;
            }
            if (climax == 8) {
                PX = 4;
            }
            if (climax == 9) {
                PX = 1;
            }
            if (climax == 10) {
                PX = 5;
            }
            if (climax == 11) {
                PX = 2;
            }
            if (climax == 12) {
                PX = 6;
            }
            if (climax == 13) {
                PX = 3;
            }
            if (climax == 14) {
                PX = 0;
            }
            if (mode == 1 || mode == 2) {
                PX = PX >= 2 ? (PX -= 2) : (PX += 5);
            }
            int NextX = 100;
            int i2 = 0;
            while (i2 < IEMA_Klimakes_Main.this.ConstructingClimax.size()) {
                int[] hexclx;
                Note n = IEMA_Klimakes_Main.this.ConstructingClimax.get(i2);
                float y = 0.0f;
                y = 61.5f;
                y -= step * (float)PX;
                y -= step * (float)i2;
                boolean HasL = false;
                int acc = 0;
                int ji = i2;
                if (ji == 7) {
                    ji = 0;
                }
                if (mode != 0) {
                    ji -= 2;
                }
                if (ji < 0) {
                    ji += 7;
                }
                if (climax >= 7) {
                    int[] nArray = new int[8];
                    nArray[1] = 64;
                    nArray[2] = 68;
                    nArray[3] = 100;
                    nArray[4] = 102;
                    nArray[5] = 118;
                    nArray[6] = 119;
                    nArray[7] = 127;
                    hexclx = nArray;
                    if ((1 << ji & hexclx[climax - 7]) != 0) {
                        acc = 1;
                    }
                    if ((mode == 1 || mode == 2) && i2 == 6 && ++acc == 0) {
                        acc = 1000;
                    }
                    if (mode == 2 && i2 == 5 && ++acc == 0) {
                        acc = 1000;
                    }
                } else {
                    hexclx = new int[]{8, 9, 25, 27, 59, 63, 127};
                    if ((1 << ji & hexclx[6 - climax]) != 0) {
                        acc = -1;
                    }
                    if ((mode == 1 || mode == 2) && i2 == 6 && ++acc == 0) {
                        acc = 1000;
                    }
                    if (mode == 2 && i2 == 5 && ++acc == 0) {
                        acc = 1000;
                    }
                }
                if ((double)y >= 61.5) {
                    HasL = true;
                }
                if (y <= 10.0f) {
                    HasL = true;
                }
                if (acc != 0) {
                    try {
                        BufferedImage iacc;
                        if (acc == 1) {
                            iacc = ImageIO.read(this.getClass().getResource("sharp.png"));
                            g2.drawImage((Image)iacc, NextX - 20, (int)y - 8, null);
                        }
                        if (acc == 2) {
                            iacc = ImageIO.read(this.getClass().getResource("doublesharp.png"));
                            g2.drawImage((Image)iacc, NextX - 20, (int)y - 8, null);
                        }
                        if (acc == -1) {
                            iacc = ImageIO.read(this.getClass().getResource("flat.png"));
                            g2.drawImage((Image)iacc, NextX - 20, (int)y - 10, null);
                        }
                        if (acc == -2) {
                            iacc = ImageIO.read(this.getClass().getResource("doubleflat.png"));
                            g2.drawImage((Image)iacc, NextX - 20, (int)y - 12, null);
                        }
                        if (acc == 1000) {
                            iacc = ImageIO.read(this.getClass().getResource("natural.png"));
                            g2.drawImage((Image)iacc, NextX - 20, (int)y - 8, null);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Ellipse2D.Double ellipse = new Ellipse2D.Double(NextX, y, 8.0, 8.0);
                if (n.Black) {
                    g2.fill(ellipse);
                } else {
                    g2.draw(ellipse);
                }
                if (HasL) {
                    if (n.midi % 12 == 11) {
                        g2.drawLine(NextX - 3, (int)(y + 8.0f), NextX + 10, (int)(y + 8.0f));
                    } else {
                        g2.drawLine(NextX - 3, (int)(y + 4.0f), NextX + 10, (int)(y + 4.0f));
                    }
                }
                NextX += 40;
                ++i2;
            }
        }
    }

    public class Piano
    extends JComponent {
        private static final long serialVersionUID = 9206905938910683118L;
        ArrayList<Note> Notes = null;

        @Override
        public Dimension getPreferredSize() {
            Dimension n = super.getPreferredSize();
            n.width = IEMA_Klimakes_Main.this.ww;
            n.height = 70;
            return n;
        }

        Note Hit(int x, int y) {
            Note n;
            int i = 0;
            while (i < this.Notes.size()) {
                n = this.Notes.get(i);
                if (n != null && n.Black && x >= n.r.x && x <= n.r.x + n.r.width && y >= n.r.y && y <= n.r.y + n.r.height) {
                    return n;
                }
                ++i;
            }
            i = 0;
            while (i < this.Notes.size()) {
                n = this.Notes.get(i);
                if (n != null && !n.Black && x >= n.r.x && x <= n.r.x + n.r.width && y >= n.r.y && y <= n.r.y + n.r.height) {
                    return n;
                }
                ++i;
            }
            return null;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension d = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color cb1 = new Color(30, 30, 30, 255);
            Color cr = new Color(255, 0, 0, 255);
            if (IEMA_Klimakes_Main.this.NextNoteOK) {
                cr = new Color(0, 0, 255, 255);
            }
            Color cw3 = new Color(110, 110, 110, 255);
            Color cw2 = new Color(190, 190, 190, 255);
            Color cw1 = new Color(200, 200, 200, 255);
            Color cw = new Color(255, 255, 255, 255);
            g2.setColor(cw);
            g2.fillRect(0, 0, d.width, d.height);
            if (this.Notes == null) {
                this.Notes = new ArrayList(0);
                this.Notes.clear();
                int i = 0;
                while (i < 30) {
                    Note n = null;
                    n = new Note();
                    n.Down = false;
                    this.Notes.add(n);
                    ++i;
                }
            }
            float WhiteWidth = (float)IEMA_Klimakes_Main.this.ww / 15.0f;
            g2.setColor(cw1);
            int[] nmd_w = new int[]{48, 50, 52, 53, 55, 57, 59, 60, 62, 64, 65, 67, 69, 71, 72};
            int i = 0;
            while (i < 15) {
                Note n = this.Notes.get(i);
                float x = (float)i * WhiteWidth;
                g2.setColor(cw2);
                if (n.Down) {
                    g2.setColor(cr);
                } else if (i == 0 || i == 7 || i == 14) {
                    g2.setColor(cw3);
                } else {
                    g2.setColor(cw2);
                }
                g2.fillRoundRect((int)x, 0, (int)WhiteWidth - 2, d.height, 5, 5);
                n.r.x = (int)x;
                n.r.y = 0;
                n.r.width = (int)(WhiteWidth - 2.0f);
                n.r.height = d.height;
                n.midi = nmd_w[i];
                ++i;
            }
            int[] nArray = new int[15];
            nArray[0] = 49;
            nArray[1] = 51;
            nArray[3] = 54;
            nArray[4] = 56;
            nArray[5] = 58;
            nArray[7] = 61;
            nArray[8] = 63;
            nArray[10] = 66;
            nArray[11] = 68;
            nArray[12] = 70;
            int[] nmd_b = nArray;
            int i2 = 0;
            while (i2 < 15) {
                Note n = this.Notes.get(i2 + 15);
                float x = (float)i2 * WhiteWidth;
                x += WhiteWidth / 2.0f;
                x += WhiteWidth / 4.0f;
                x -= 5.0f;
                float ww = WhiteWidth / 2.0f;
                ww += 5.0f;
                if (n.Down) {
                    g2.setColor(cr);
                } else {
                    g2.setColor(cb1);
                }
                if (i2 != 2 && i2 != 6 && i2 != 9 && i2 != 13 && i2 != 14) {
                    g2.fillRect((int)x, 0, (int)ww, d.height / 2);
                }
                n.Black = true;
                n.r.x = (int)x;
                n.r.y = 0;
                n.r.width = (int)ww;
                n.r.height = d.height / 2;
                n.midi = nmd_b[i2];
                ++i2;
            }
        }
    }
}

