﻿/// <reference path="jquery/jquery-1.7.2.min.js" />
/// <reference path="jquery-ui/jquery-ui-1.8.16.custom.min.js" />

$.fn.smartBackgroundImage = function (url) {
    var t = this;
    //create an img so the browser will download the image:
    $('<img />')
    .attr('src', url)
    .load(function () { //attach onload to set background-image
        t.each(function () {
            $(this).css('backgroundImage', 'url(' + url + ')');
        });
    });
    return this;
}

$.fn.preLoadImage = function (url, callbackLoad) {
    var t = this;
    //create an img so the browser will download the image:
    $('<img />')
    .attr('src', url)
    .load(function () { //attach onload to set background-image
        if ( callbackLoad != null)
            callbackLoad();
    });
    return this;
}


var bRolling = false;
var iterMin = 10;
var iterMax = 25;
var curExample = 1;
var animTimeOutUp = -1;
var animTimeOutDown = -1;

Shadowbox.init({
    handleOversize: "resize",
    modal: true
});

function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

jQuery.fn.reverse = function () {
    return this.pushStack(this.get().reverse(), arguments);
};


function RollSlot($slot, stopSlot, maxIter, delay, removeSlot) {
    var i = 1;
    var slotHeight = $(".slotMachine .slot:first").outerHeight(true);
    var machineHeight = $(".slotMachine:first").height();
    var numSlots = $(".slot", $slot).length;
    var totalHeight = numSlots * slotHeight;

    if (removeSlot == null)
        removeSlot = false;

    $slot.css("top", machineHeight + "px");
    $(".slot", $slot).attr("iter", i);
    $slot.attr("name", "started");
    $slot.animate({
        top: "-=" + totalHeight + "px"
    }, delay, "linear", function animateAgain() {
        if (i < maxIter) {
            i++;
            var $slots = $(".slot:lt(" + numSlots + ")", $slot).clone(true, true);
            $slots.attr("iter", i);
            $slots.appendTo($slot);

            if ($(".slot", $slot).length >= 3 * numSlots) {
                $(".slot:lt(" + numSlots + ")", $slot).remove();
                $slot.css("top", "+=" + totalHeight + "px");
            }

            $slot.animate({
                top: "-=" + totalHeight + "px"
            }, delay, "linear", animateAgain);
        }
        else {
            $(".slot:lt(" + numSlots + ")", $slot).remove();
            $slot.css("top", machineHeight + "px");
            $slot.animate({
                top: (stopSlot - 1) * (-slotHeight) - 1 + "px"
            }, delay * numSlots, "easeOutBack", function () {
                var $stopSlot = $(".slot:eq(" + (stopSlot - 1) + ")", $slot);

                $slot.disableSelection();
                $slot.attr("name", "stopped");
                $slot.attr("slot", stopSlot);

                if (removeSlot) {
                    $slot.children().not($stopSlot).css("display", "none");
                    $slot.css("top", "0px");
                }

                if ($(".slotMachine .slotContainer[name='started']").length == 0) {
                    //alert("all stopped!!");
                    bRolling = false;
                    $("#imgRefresh").attr("src", "images/refresh.png");
                    $("#imgRefresh").css("border-color", "transparent");
                    $(".tipMid").html("");
                    $(".slotMachine .slotContainer .slot").betterTooltip({ speed: 150, delay: 800 });

                    clearTimeout(animTimeOutUp);
                    clearTimeout(animTimeOutDown);
                    animTimeOutUp = -1;
                    animTimeOutDown = -1;
                    $(".slotArrows:eq(0) img").attr("src", "images/up.png");
                    $(".slotArrows:eq(1) img").attr("src", "images/down.png");

//                    $(".desktop").stop(true, false);
//                    $(".desktop").animate({
//                        backgroundColor: "white"
//                    }, 400);

                    $(".slot")
					    .hover(
						    function () {
						        $(".slot").stop(true, false);
						        $(".slot").css("opacity", "1.0");
						        $(".slot").not($(this)).animate({
						            opacity: 0.1
						        }, 500);
						    },
						    function () {
						        $(".slot").not($(this)).stop(true, false);
						        $(".slot").not($(this)).animate({
						            opacity: 1.0
						        }, 500);
						    });

                    $("#imgEnter")
					    .hover(
						    function () {
						        $(this).attr("src", "images/enter_on.png");
						    },
						    function () {
						        $(this).attr("src", "images/enter.png");
						    })
                        .click(function () {
                            var url = "";
                            $(".slotMachine .slotContainer").each(function () {
                                var slot = $(this).attr("slot");
                                var $slot = $(this).children(".slot:eq(" + (slot - 1) + ")");
                                var slotText = $slot.contents().filter(function () {
                                    return this.nodeType == 3;
                                }).text();
                                url = url + slotText;
                            });
                            //alert(url);
                            //url = "http://www.ptyxiouxos.net"
                            var urlHttp;
                            urlHttp = url;
                            if (url.indexOf("http://") != 0)
                                urlHttp = "http://" + url;
                            Shadowbox.open({
                                content: "<iframe src='" + urlHttp + "' style='width:648px; height:545px' frameborder='0' marginheight='0' marginwidth='0' />",
                                player: "html",
                                title: "Άνοιγμα " + url,
                                width: 650,
                                height: 550
                            });
                        });

                    if (removeSlot)
                        return;

                    $(".slotUpArrow").css('cursor', "pointer")
					    .hover(
						    function () {
						        $(this).children("img").attr("src", "images/up_on.png");
						    },
						    function () {
						        $(this).children("img").attr("src", "images/up.png");
						    })
                        .click(function () {
                            //alert($(this).index());
                            var idx = $(this).index();
                            var $curContainer = $(".slotMachine .slot" + (idx + 1));
                            var curSlot = $curContainer.attr("slot");
                            var pos;
                            if (curSlot < numSlots) {
                                curSlot++;
                                $curContainer.attr("slot", curSlot);
                                pos = (curSlot - 1) * (-slotHeight) - 1;
                                //$curContainer.css("top", pos + "px");
                                $curContainer.stop(true, false);
                                $curContainer.animate({
                                    top: pos + "px"
                                }, 400, "easeOutBack");
                            }
                        });

                    $(".slotDownArrow").css('cursor', "pointer")
					    .hover(
						    function () {
						        $(this).children("img").attr("src", "images/down_on.png");
						    },
						    function () {
						        $(this).children("img").attr("src", "images/down.png");
						    })
                        .click(function () {
                            //alert($(this).index());
                            var idx = $(this).index();
                            var $curContainer = $(".slotMachine .slot" + (idx + 1));
                            var curSlot = $curContainer.attr("slot");
                            var pos;
                            if (curSlot > 1) {
                                curSlot--;
                                $curContainer.attr("slot", curSlot);
                                pos = (curSlot - 1) * (-slotHeight) - 1;
                                //$curContainer.css("top", pos + "px");
                                $curContainer.stop(true, false);
                                $curContainer.animate({
                                    top: pos + "px"
                                }, 400, "easeOutBack");
                            }
                        });
                }

            });
        }
    });
}

function SlotAnimation($arrow, dir){
	var strImageOff; 
	var strImageOn; 
	strImageOff = (dir == 0) ? "images/up.png" : "images/down.png";
	strImageOn = (dir == 0) ? "images/up_on.png" : "images/down_on.png";
	
	var $prev = $arrow.prev();
	var $next = $arrow.next();

	if ($prev.length)
		$prev.children("img:first").attr("src", strImageOff)
	else 
		$(".slotArrows:eq(" + dir + ")").children().last().children("img:first").attr("src", strImageOff);

	$arrow.children("img:first").attr("src", strImageOn)

	if ($next.length == 0)
		$next = $(".slotArrows:eq(" + dir + ")").children().first();
		
	if (dir == 0)
		animTimeOutUp = setTimeout(function(){SlotAnimation($next, dir)}, 80);
	else
		animTimeOutDown = setTimeout(function(){SlotAnimation($next, dir)}, 80);
}

function RollMachine(bShuffle, bRemoveSlot, numIter) {

    if (bShuffle == null)
        bShuffle = false;
    if (bRemoveSlot == null)
        bRemoveSlot = false;
    
    $(".slotMachine .slotContainer:gt(0)").remove();

    $(".slotMachine .slotContainer").off('hover');
    $(".slotMachine .slotContainer .slot").off('hover'); ;
    $(".slotUpArrow").off('hover');
    $(".slotUpArrow").off('click');
    $(".slotUpArrow").css('cursor', "default");
    $(".slotDownArrow").off('hover');
    $(".slotDownArrow").off('click');
    $(".slotDownArrow").css('cursor', "default");

    if (bShuffle == false) {
        $(".slotUpArrow").attr("title", "Ανακατέψτε πρώτα!");
        $(".slotDownArrow").attr("title", "Ανακατέψτε πρώτα!");
    }
    else {
        $(".slotUpArrow").removeAttr("title");
        $(".slotDownArrow").removeAttr("title");
    }

    $("#imgEnter").off('click');
    $("#imgEnter").off('hover');

    $(".slotMachine .slotContainer .slot").css("display", "");


    var numSlots = $(".slotMachine .slot").length;
    var $contFirst = $(".slotMachine .slotContainer:first");

    var $slotContainer = $contFirst.clone(true, true);
    if ($contFirst.hasClass("slot1") == false)
        $contFirst.addClass("slot1");
    var i;
    for (i = 1; i < numSlots; i++) {
        var $cloned = $slotContainer.clone(true, true);
        $cloned.removeClass("slot1");
        $cloned.addClass("slot" + (i + 1));
        $cloned.appendTo(".slotToolBar");
    }
    bRolling = true;
    $("#imgRefresh").css("border-color", "#cccccc");
    $("#imgRefresh").attr("src", "images/loading.gif");
	
	$(".slotArrows:eq(0) img").attr("src", "images/up.png");
	$(".slotArrows:eq(1) img").attr("src", "images/down.png");
	
	SlotAnimation($(".slotArrows:eq(0)").children().first(), 0);
	SlotAnimation($(".slotArrows:eq(1)").children().first(), 1);

//	$(".desktop").animate({
//	        backgroundColor: "#" + ("000" + (Math.random() * (1 << 24) | 0).toString(16)).substr(-6)
//	    }, 2000, "swing", function AnimateBG() { 
//            $(".desktop").animate({
//                backgroundColor: "#" + ("000" + (Math.random() * (1 << 24) | 0).toString(16)).substr(-6)
//	    }, 2000, "swing", AnimateBG)
//    });
	
    for (i = 1; i <= numSlots; i++) {
        var iter = 0;
        var stopSlot;
        do {
            iter = Math.floor((Math.random() * iterMax) + 1);
        } while (iter < iterMin);
        stopSlot = Math.floor((Math.random() * numSlots) + 1);
		if (numIter != null)
			iter = numIter ;
		if (iter < 2)
			iter = 2;
        if (bShuffle)
            RollSlot($(".slotMachine .slot" + i), stopSlot, iter, 200, bRemoveSlot);
        else
            RollSlot($(".slotMachine .slot" + i), i, iter, 200, bRemoveSlot);
    }
}

$(document).ready(function () {

    //$('.desktop').smartBackgroundImage("images/bground.png");
    $(".slotArrows").css("visibility", "hidden");
    $(".slotMachine").css("visibility", "hidden");
    $.fn.preLoadImage("images/bground.png", function () {
        //alert("OK!");
        $(".desktop").css('backgroundImage', "url(images/bground.png)");
        $(".slotArrows").css("visibility", "visible");
        $(".slotMachine").css("visibility", "visible");
        RollMachine(false, true, 2);
        $("#spanLoading").css("display", "none");
        $("#spanHelp").css("display", "");
    });

    $.fn.preLoadImage("images/down_on.png")
    $.fn.preLoadImage("images/up_on.png")
    $.fn.preLoadImage("images/left_on.png")
    $.fn.preLoadImage("images/right_on.png")
    $.fn.preLoadImage("images/refresh_on.png")
    $.fn.preLoadImage("images/enter_on.png")
    $.fn.preLoadImage("css/tooltip/theme/images/tipBottom_down.png")
    $.fn.preLoadImage("css/tooltip/theme/images/tipMid.png")
    $.fn.preLoadImage("css/tooltip/theme/images/tipTop_up.png")

    /// <reference path="../css/tooltip/theme/images/tipBottom_down.png" />

    $("#imgLeft").hover(function () {
        $(this).attr("src", "images/left_on.png")
        $(this).css("border-color", "#cccccc");
    },
		function () {
		    $(this).attr("src", "images/left.png")
		    $(this).css("border-color", "transparent");
		}).click(function () {
		    if (bRolling)
		        return false;
		    if (curExample > 1) {
		        curExample--;
		        var $newExample = $("#divExamples .slotContainer:eq(" + (curExample - 1) + ")");
		        $(".slotMachine .slotContainer:first").html($newExample.contents().clone(true, true));
		        RollMachine(false, true, 2);
		    }
		});
    $("#imgRight").hover(function () {
        $(this).attr("src", "images/right_on.png")
        $(this).css("border-color", "#cccccc");
    },
		function () {
		    $(this).attr("src", "images/right.png")
		    $(this).css("border-color", "transparent");
		}).click(function () {
		    if (bRolling)
		        return false;
		    var maxExamples = $("#divExamples .slotContainer").length;
		    if (curExample < maxExamples) {
		        curExample++;
		        var $newExample = $("#divExamples .slotContainer:eq(" + (curExample - 1) + ")");
		        $(".slotMachine .slotContainer:first").html($newExample.contents().clone(true, true));
		        RollMachine(false, true, 2);
		    }
		});

    $("#imgRefresh").hover(function () {
        if (bRolling)
            return false;
        $(this).attr("src", "images/refresh_on.png")
        $(this).css("border-color", "#cccccc");
    },
	function () {
	    if (bRolling)
	        return false;
	    $(this).attr("src", "images/refresh.png");
	    $(this).css("border-color", "transparent");
	}).click(function () {
	    if (bRolling)
	        return false;
	    RollMachine(true, false);
	});

});