/*-------------------------------------------------------------------------------
	A Better jQuery Tooltip
	Version 1.0
	By Jon Cazier
	jon@3nhanced.com
	01.22.08
-------------------------------------------------------------------------------*/
var timeout = -1;

$.fn.betterTooltip = function (options) {

    /* Setup the options for the tooltip that can be 
    accessed from outside the plugin              */
    var defaults = {
        speed: 200,
        delay: 300
    };

    var options = $.extend(defaults, options);

    /* Create a function that builds the tooltip 
    markup. Then, prepend the tooltip to the body */
    getTip = function () {
        var tTip =
			"<div class='tip'>" +
				"<div class='tipMid'>" +
				"</div>" +
				"<div class='tipBtm'></div>" +
			"</div>";
        if ($(".tip").length)
            return $(".tip");
        else
            return tTip;
    }
    $("body").prepend(getTip());

    /* Give each item with the class associated with 
    the plugin the ability to call the tooltip    */
    $(this).each(function () {

        var $this = $(this);
        var tip = $('.tip');
        var tipInner = $('.tip .tipMid');

        tip.disableSelection();
        tipInner.disableSelection();

        var $toolTip = $this.children("span:first");
        $toolTip.css("display", "none");


        /* Mouse over and out functions*/
        $this.hover(
			function () {
			    if (timeout != -1) {
			        stopTimer();
			        tip.hide();
			        clearTimeout(timeout);
			        timeout = -1;
			    }
			    tipInner.html("");
			    tipInner.html($toolTip.clone(true).contents());
			    setTip($(this));
			    setTimer();
			},
			function () {
			    if (timeout != -1) {
			        stopTimer();
			        tip.hide();
			        clearTimeout(timeout);
			        timeout = -1;
			    }
			    timeout = setTimeout(function () {
			        stopTimer();
			        tip.hide();
			    }, 500);
			}
		);

        tip.hover(
            function () {
                if (timeout != -1) {
                    clearTimeout(timeout);
                    timeout = -1;
                }
            },
            function () {
                stopTimer();
                tip.hide();
            });

        /* Delay the fade-in animation of the tooltip */
        setTimer = function () {
            if ($this.showTipTimer != -1)
                stopTimer();
            //$this.showTipTimer = setInterval("showTip()", defaults.delay);
            $this.showTipTimer = setTimeout("showTip()", defaults.delay);
        }

        stopTimer = function () {
            //clearInterval($this.showTipTimer);
            clearTimeout($this.showTipTimer);
            $this.showTipTimer = -1;
        }

        /* Position the tooltip relative to the class 
        associated with the tooltip                */
        setTip = function ($owner) {
            //var topOffset = tip.height();
            var topOffset = $owner.height();
            var leftOffset = $owner.outerWidth(true);
            var offset = $owner.offset();
            var left = offset.left;
            var top = offset.top;
            var xTip = ((left - 85) + (leftOffset / 2)) + "px";
            var yTip = (top + topOffset + 30) + "px";
            //alert(left);
            tip.css({ 'top': yTip, 'left': xTip });
        }

        /* This function stops the timer and creates the
        fade-in animation                          */
        showTip = function () {
            stopTimer();
            tip.animate({ "top": "-=20px", "opacity": "toggle" }, defaults.speed);
        }
    });
};