var canvas;
var cntx;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    showAppTitle();
    InitData();
    InitialValues();
    InitialiseGUI();
    InitGame();
    initialiseEvents();
    drawBasicScreen();
}
    
function initialiseEvents(){
    $("#visualisation").contextmenu(function(evt){
        evt.preventDefault();
        evt.stopPropagation();
    });
    
    $("#visualisation").on("mousedown touchstart",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown(evt);
    });

    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove(evt);
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp(evt);
    });
} 

function mouseExited(e) {
    // called when the pointer leaves the applet's rectangular area
    imgLogo=document.getElementById("Logo");
}

function PlaceLetter(){
    var FirstPart,SecondPart;
    if (PlaceHolderI==0){
        if (PlaceHolderJ>0) {
            FirstPart=UserSolutions[CurrentUserSolution].substring(0,PlaceHolderJ);
        }
        else {
            FirstPart="";
        }
        if (PlaceHolderJ>=SelectedNoOfLetters+4){
            SecondPart="";
        }
        else {
            SecondPart=UserSolutions[CurrentUserSolution].substring(PlaceHolderJ+1);
        }
        UserSolutions[CurrentUserSolution]=FirstPart.concat(Letter[SelectedNoOfLetters][SelectedWord][LetterHovered]).concat(SecondPart);
        LetterUsed[LetterHovered]=true;
        CheckCompletion();
    }
    DragLetter=false;
    LetterHovered=-1;
    PlaceHolderI=-1;
    PlaceHolderJ=-1;
}

function InitialiseGUI(){
    countingLeftHand=document.getElementById("Counting_left_hand");
    countingRightHand=document.getElementById("Counting_right_hand");
    
    Solve=document.getElementById("btnSolve");
    NewWord=document.getElementById("btnNewWord");
    Clear=document.getElementById("btnClear");
    LevelSelector=document.getElementById("scrLevelSelector");
    LengthSelector=document.getElementById("scrLengthSelector");
    
    ScrLeftNoToShow=document.getElementById("scrLeftNoToShow");
    ScrRightNoToShow=document.getElementById("scrRightNoToShow");
    
    chkAnalog=document.getElementById("chkAnalog");
    chkDigital=document.getElementById("chkDigital");
    chkBinary=document.getElementById("chkBinary");
    chkBinary2=document.getElementById("chkBinary2");
    chkBAux=document.getElementById("chkBAux");
    
    InitialiseGUI_values();
}

function InitialiseGUI_values(){
    TitleTOP=20,TitleWIDTH=550,TitleLEFT=(width-TitleWIDTH)/2,TitleHEIGHT=35;
    LevelSelector.value=1;
    LengthSelector.value=4;
    ScrLeftNoToShow.value=0;
    ScrRightNoToShow.value=0;
    chkAnalog.checked=true;
    chkDigital.checked=false;
    chkBinary.checked=false;
    chkBinary2.checked=false;
    chkBAux.checked=false;
    
    $("#levelSelectorValue").html(LevelSelector.value);
    $("#lengthSelectorValue").html(LengthSelector.value);
    SelectedLevel=parseInt(LevelSelector.value);
    SelectedNoOfLetters=parseInt(LengthSelector.value)-4;
}

function InitialValues(){
    BinaryHands=document.getElementById("binary_fingers");
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;
    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");
    imgAnalogClock=document.getElementById("analog_clock_medium");
    imgDigitalClock=document.getElementById("digital_clock_small");
    imgBinaryClock=document.getElementById("BinaryFrame");
    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
    SolveWIDTH=100;
    SolveHEIGHT=40;
    SolveLEFT=675;
    SolveTOP=BottomPanelTop-SolveHEIGHT-10;
    NewWordWIDTH=SolveWIDTH;
    NewWordHEIGHT=SolveHEIGHT;
    NewWordLEFT=SolveLEFT;
    NewWordTOP=SolveTOP-NewWordHEIGHT-10;
    ClearWIDTH=SolveWIDTH;
    ClearHEIGHT=SolveHEIGHT;
    ClearLEFT=150;
    ClearTOP=280;
    LengthSelectorHEIGHT=32;
    LengthSelectorWIDTH=50;
    LengthSelectorLEFT=NewWordLEFT-LengthSelectorWIDTH-10;
    LengthSelectorTOP=SolveTOP;
    LevelSelectorWIDTH=LengthSelectorWIDTH;
    LevelSelectorHEIGHT=LengthSelectorHEIGHT;
    LevelSelectorLEFT=LengthSelectorLEFT;
    LevelSelectorTOP=LengthSelectorTOP-LevelSelectorHEIGHT-20;
    SelectedWordX=150;
    SelectedWordY=TopPanelHeight+150;
    LetterStep=30;
    PlaceHolderI=-1;
    PlaceHolderJ=-1;
    LetterHovered=-1;
    CurrentUserSolution=0;
    AnalogClockLEFT=280;
    AnalogClockTOP=TopPanelHeight+20;
    DigitalClockLEFT=30;
    DigitalClockTOP=AnalogClockTOP+220;
    BinaryClockLEFT=620;
    BinaryClockTOP=380;
}

function drawBasicScreen(){
    //Φόντα οθόνης
    cntx.clearRect(0,0,canvas.width,canvas.height);
    
    cntx.fillStyle=MainAreaColor;
    cntx.fillRect(0,0,width,height);

    cntx.fillStyle=PanelColor;
    cntx.fillRect(0,0,width,TopPanelHeight);
    cntx.fillRect(0,BottomPanelTop,width,BottomPanelHeight);
    //Διακοπή προσομοίωσης ρολογιών
    clearInterval(timerLoop);
    //Εικόνες
    if (!ShowProgramID) {
        $("#wordGame").hide();
        $("#countingHands").hide();
        $("#clocksControls").hide();
        if (introStep==wordsStep){
            $("#wordGame").show();
            drawWordsStep();
        }
        else if (introStep==ClocksStep){
            $("#clocksControls").show();
            timerLoop=setInterval(
                    function(){
                        DrawClocksStep();
                    },
                    simSpeed
            );
        }
        else if (introStep==HandsStep3){
            DrawBinaryHands();
        }
        else if (introStep==HandsStep1 || introStep==HandsStep2){
            $("#countingHands").show();
            DrawHandsStep();
        }
        else {
            drawIntroImage();
        }
        cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,"Σύμβολα και Κωδικοποίηση");
    }
    //Πλαίσιου μαύρου χρώματος
    cntx.strokeStyle="rgb(0,0,0)";
    cntx.beginPath();
    cntx.rect(0,0,width-1,TopPanelHeight);
    cntx.rect(0,TopPanelHeight,width-1,height-TopPanelHeight-BottomPanelHeight);
    cntx.rect(0,BottomPanelTop,width-1,BottomPanelHeight-1);
    cntx.stroke();
    cntx.drawImage(imgLogo,logoLeft,logoTop);
    
    if(introStep==LastIntroStep){
        $("#btnArea").show();
    }
    else{
        $("#btnArea").hide();
    }
    
    if (introStep==HandsStep1 || introStep==HandsStep2){
        if (HandCounting==8) {
            drawButtonNext();
        }
    }
    else if(introStep==HandsStep3){
        drawButtonNext();
    }
    else if(introStep<LastIntroStep) {
        drawButtonNext();
    }
    if (introStep>1) drawButtonBack();
}

function DrawHandsStep(){
    var promptYCoord=BottomPanelTop+20;
    var tilex=3,tiley=2;
    var clipX=0;
    var clipY=0;
    var clipWidth=0;
    var clipHeight=0;
    
    clipWidth=countingLeftHand.width/tilex;
    clipHeight=countingLeftHand.height/tiley;
    clipX=(ScrLeftNoToShow.value % tilex)*clipWidth;
    clipY=(parseInt(ScrLeftNoToShow.value/tilex))*clipHeight;
    cntx.drawImage(countingLeftHand,clipX,clipY,clipWidth,clipHeight,400-clipWidth,TopPanelHeight+5,clipWidth,clipHeight);

    clipWidth=countingRightHand.width/tilex;
    clipHeight=countingRightHand.height/tiley;
    clipX=(ScrRightNoToShow.value % tilex)*clipWidth;
    clipY=(parseInt(ScrRightNoToShow.value/tilex))*clipHeight;
    cntx.drawImage(countingRightHand,clipX,clipY,clipWidth,clipHeight,400,TopPanelHeight+5,clipWidth,clipHeight);
    
    cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",320,360,""+ScrLeftNoToShow.value);
    cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",460,360,""+ScrRightNoToShow.value);

    var NoToShow="";
    if(introStep==HandsStep1){
        cnvsWrite("rgb(0,0,255)",20,"Arial",280,300,"Κάθε δάχτυλο έχει αξία μονάδας.");
        NoToShow=NoToShow.concat(""+(parseInt(ScrLeftNoToShow.value)+parseInt(ScrRightNoToShow.value)));
    }
    else{
        cnvsWrite("rgb(0,0,255)",20,"Arial",100,280,"τα δάχτυλα του αριστερού χεριού      τα δάχτυλα του δεξιού χεριού");
        cnvsWrite("rgb(0,0,255)",20,"Arial",100,310,"          συμβολίζουν δεκάδες.              συμβολίζουν μονάδες.");
        NoToShow=NoToShow.concat(""+(ScrLeftNoToShow.value+ScrRightNoToShow.value));
    }
    
    cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",120,420,"Συμβολίζουμε τον αριθμό: "+NoToShow);
    
    //Οδηγίες
    if(introStep==HandsStep1){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Αυξομείωσε τη μπάρα που αντιστοιχεί στο δεξί χέρι για να αρχίσεις τη μέτρηση.");
        promptYCoord=promptYCoord+15;
        if (ScrRightNoToShow.value==5){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Αυξομείωσε τη μπάρα που αντιστοιχεί στο αριστερό χέρι για να συνεχίσεις τη μέτρηση.");
            promptYCoord=promptYCoord+15;
        }
        else if (ScrLeftNoToShow.value>0){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Καλύτερα να εξαντλήσεις τη μέτρηση με το δεξί χέρι πριν χρησιμοποιήσεις και το αριστερό.");
            promptYCoord=promptYCoord+15;
        }
        if(HandCounting>7){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Αυτός είναι ένας πολύ απλός τρόπος για να μετρήσουμε αλλά περιορίζεται μέχρι το 10.");
            promptYCoord=promptYCoord+15;
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Στο επόμενο βήμα θα δεις ένα τρόπο για να συμβολίσεις μεγαλύτερους αριθμούς, όπως το 23 ή το 55.");
            promptYCoord=promptYCoord+15;
        }
    }
    else{
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Χρησιμοποίησε το δεξί χέρι για να τροποποιήσεις τις μονάδες και το αριστερό για τις δεκάδες.");
        promptYCoord=promptYCoord+15;
        if (HandCounting>7){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Το μειονέκτημα που έχει αυτός ο τρόπος μέτρησης είναι ότι δεν περιλαμβάνει όλους τους ενδιάμεσους");
            promptYCoord=promptYCoord+15;
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"αριθμούς, όπως π.χ. το 7, το 18, το 26 κ.λπ., αφού δεν έχουμε... αρκετά δάχτυλα σε κάθε χέρι.");
            promptYCoord=promptYCoord+15;
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Στο επόμενο βήμα θα δεις ένα τρόπο κωδικοποίησης που θα σου επιτρέψει να μετρήσεις μέχρι το 1023!");
        }
    }
}

function DrawBinaryHands(){
    var promptYCoord=BottomPanelTop+20;
    var XCoord=380,YCoord=120;
    cntx.drawImage(BinaryHands,20,TopPanelHeight+10);
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"Ξεκινώντας από το μικρό δάχτυλο του δεξιού");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"χεριού που συμβολίζει τη μονάδα, μπορούμε");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"να δώσουμε σε κάθε επόμενο δάχτυλο");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"διπλάσια αξία, όπως φαίνεται στο σχήμα.");
    YCoord=YCoord+40;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"Μαζεύοντας όλα τα δάχτυλα συμβολίζουμε");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"το Μηδέν.");
    YCoord=YCoord+40;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"Απλώνοντας όλα τα δάχτυλα συμβολίζουμε");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"τον αριθμό 1023.");
    YCoord=YCoord+40;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"Όλοι οι υπόλοιποι συνδυασμοί μπορούν");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"να αναπαραστήσουν όλους τους");
    YCoord=YCoord+30;
    cnvsWrite("rgb(0,0,255)",20,"Arial",XCoord,YCoord,"ενδιάμεσους αριθμούς.");
    cnvsWrite("rgb(0,0,255)",11,"Arial",10,BottomPanelTop-12,"Πηγή: Arthur C. Clarke - Frederik Pohl: 'Το Τελευταίο θεώρημα'");
    cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Πειραματίσου και προσπάθησε να αναπαραστήσεις διάφορους αριθμούς με τα 'δυαδικά' δάχτυλά σου.");
    promptYCoord=promptYCoord+15;
    cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Μπορείς να βρεις διάφορα σχετικά video στο internet.");
    promptYCoord=promptYCoord+20;
    cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Στην επόμενη οθόνη μπορείς να δεις μια ακόμη χρήση του Δυαδικού Συμβολισμού.");
}

function DrawClocksStep(){
    var promptYCoord=BottomPanelTop+20;
    
    chkBAux.disabled=!chkBinary.checked;
    chkBinary2.disabled=!chkBinary.checked;

    ShowClocks();
    if (!chkAnalog.checked){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Ενεργοποίησε το Αναλογικό Ρολόι για μια κλασική εικόνα μέτρησης του χρόνου.");
        promptYCoord=promptYCoord+15;
    }
    if (!chkDigital.checked){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Ενεργοποίησε το Ψηφιακό Ρολόι για να δεις τη μοντέρνα εικόνα μέτρησης του χρόνου.");
        promptYCoord=promptYCoord+15;
    }
    if (!chkBinary.checked){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Ενεργοποίησε το Δυαδικό Ρολόι και κάνε τη σύγκριση.");
        promptYCoord=promptYCoord+15;
    }
    else{
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Κάνε σύγκριση με τα άλλα είδη και προσπάθησε να καταλάβεις τη λογική του Δυαδικού Ρολογιού.");
        promptYCoord=promptYCoord+15;
        if (!chkBAux.checked){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Αν δυσκολεύεσαι, εμφάνισε τις Βοηθητικές Πληροφορίες.");
            promptYCoord=promptYCoord+15;
        }
    }
}

function drawWordsStep(){
    var promptYCoord=BottomPanelTop+20;
    if (GameOver){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Διάλεξε [Νέα Λέξη], Επίπεδο Δυσκολίας ή Μήκος Λέξης για να συνεχίσεις το παιχνίδι.");
    }
    else {
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Διάλεξε [Νέα Λέξη], Επίπεδο Δυσκολίας, Μήκος Λέξης.");
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord+15,"Σύρε τα γράμματα με το ποντίκι στις θέσεις αριστερά, για να συνθέσεις μια λέξη");
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord+30,"ή κάνε δεξί κλικ για να τα τοποθετήσεις στην πρώτη διαθέσιμη θέση.");
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord+45,"Αν δυσκολευτείς κάνε κλικ στο [Επίλυση]. Σβήσε τη λέξη σου με το [Διαγραφή]");
    }
    if (SolutionVisible) {
        ShowSolution();
    }
    else {
        if (!GameOver){
            Clear.style.display="block";
            ShowUserSolutions();
            ShowSelectedWord();
            ShowPlaceholders();
        }
        else {
            Clear.style.display="none";
        }
        ShowCorrectSolutionsAndPlaceholders();
    }
}

function drawIntroImage(){
    Intro=document.getElementById("img"+introStep);
    var picTop=(height-Intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+Intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    Adding=false;
    cntx.drawImage(Intro,1,picTop);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

//function actionPerformed(ActionEvent ae){
/*function actionPerformed(ae){
    if (ae.getSource()==Solve){
        SolutionVisible=true;
        GameOver=true;
        Solve.setEnabled(false);
        Clear.setEnabled(false);
    }
    if (ae.getSource()==NewWord){
        GetWord();
    }
    if (ae.getSource()==Clear){
        ResetUsedLetters();
        UserSolutions[CurrentUserSolution]="      ";
    }
    repaint();
}*/

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (ButtonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function ButtonNextHover(){
    if (mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function drawButtonBack(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (ButtonBackHover()){
        cntx.drawImage(imgBackStepSelected, BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled, BackStepLeft,BackStepTop);
    }
}

function ButtonBackHover(){
    if (mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function InitGame(){
    SelectedLevel=1;
    SelectedNoOfLetters=0;
    GetWord();
    ResetUserAnswers();
}

function GetWord(){
    var Flag=false;
    CurrentUserSolution=0;
    ResetUserAnswers();
    while(!Flag){
        SelectedWord=parseInt(MaxNoOfWords*Math.random());
        if (Level[SelectedNoOfLetters][SelectedWord]==SelectedLevel && Enabled[SelectedNoOfLetters][SelectedWord]) Flag=true;
    }
    for(var i=0;i<5;i++){
        CorrectFound[i]=false;
    }
    SolutionVisible=false;
    for(var i=0;i<5;i++) ThisSolutionVisible[i]=false;
    return Flag;
}

function ShowSelectedWord(){
    var i;
    var colorToUse="";
    for (i=0;i<SelectedNoOfLetters+4;i++){
        if (i==LetterHovered){
            if (DragLetter){
                colorToUse="rgb(128,128,128)";
            }
            else {
                colorToUse="rgb(255,0,0)";
            }
        }
        else {
            if (LetterUsed[i]) {
                colorToUse="rgb(0,0,0)";
            }
            else {
                colorToUse="rgb(0,0,255)";
            }
        }
        cnvsWrite(colorToUse,2*fontSize,"Arial",SelectedWordX+i*LetterStep,SelectedWordY,Letter[SelectedNoOfLetters][SelectedWord][i]);
    }
    if (DragLetter){
        cnvsWrite("rgb(255,0,0)",2*fontSize,"Arial",mx,my,Letter[SelectedNoOfLetters][SelectedWord][LetterHovered]);
    }
}

function ShowPlaceholders(){
    var i,j,X,Y;
    i=0;
    cntx.strokeStyle="rgb(0,0,255)";
    for(j=0;j<SelectedNoOfLetters+4;j++){
        X=SolutionX(j);
        Y=SolutionY(i);
        if (DragLetter && i==CurrentUserSolution && i==PlaceHolderI && j==PlaceHolderJ) {
            cntx.strokeStyle="rgb(255,0,0)";
        }
        else {
            cntx.strokeStyle="rgb(0,0,255)";
        }
        cntx.beginPath();
        cntx.moveTo(X,Y);
        cntx.lineTo(X+40,Y);
        cntx.stroke();
    }
    i++;
}

function ShowCorrectSolutionsAndPlaceholders(){
    var i,j,X,Y;
    var CurrentLetter="";
    i=0;
    while (i<5 && !Correct[SelectedNoOfLetters][SelectedWord][i]==""){
        for (j=0;j<SelectedNoOfLetters+4;j++){
            if (ThisSolutionVisible[i]){
                CurrentLetter=""+Correct[SelectedNoOfLetters][SelectedWord][i].charAt(j);
                X=SolutionX(j)+(LetterWidth-cntx.measureText(CurrentLetter).width)/2+FoundSolutionsXOffset;
                Y=SolutionY(i);
                cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",X,Y,CurrentLetter);
            }
            else {
                X=SolutionX(j)+FoundSolutionsXOffset;
                Y=SolutionY(i);
                cntx.strokeStyle="rgb(0,0,255)";
                cntx.beginPath();
                cntx.moveTo(X,Y);
                cntx.lineTo(X+40,Y);
                cntx.stroke();
            }
        }
        i++;
    }
}

function ShowUserSolutions(){
    var i,j,X,Y;
    var CurrentLetter="";
    i=CurrentUserSolution;
    while (i<5 && !Correct[SelectedNoOfLetters][SelectedWord][i]==""){
        for (j=0;j<SelectedNoOfLetters+4;j++){
            CurrentLetter=""+UserSolutions[i].charAt(j);
            X=SolutionX(j)+(LetterWidth-cntx.measureText(CurrentLetter).width)/2;
            Y=SolutionY(0);
            cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",X,Y,CurrentLetter);
        }
        i++;
    }
}

function ShowSolution(){
    var i,j,X,Y;
    var CurrentLetter="";
    i=0;
    while (i<5 && !Correct[SelectedNoOfLetters][SelectedWord][i]==""){
        for (j=0;j<SelectedNoOfLetters+4;j++){
            CurrentLetter=""+Correct[SelectedNoOfLetters][SelectedWord][i].charAt(j);
            X=SolutionX(j)+(LetterWidth-cntx.measureText(CurrentLetter).width)/2+FoundSolutionsXOffset;
            Y=SolutionY(i);
            cnvsWrite("rgb(0,0,255)",2*fontSize,"Arial",X,Y,CurrentLetter);
        }
        i++;
    }
}

function SolutionX(j){
    return 100+j*LetterWidth;
}

function SolutionY(i){
    return TopPanelHeight+(i+1)*50;
}

function checkLetterHover(){
    var i=0;
    var Found=false;
    LetterHovered=-1;
    while(!Found && i<SelectedNoOfLetters+4){
        if (mx>SelectedWordX+i*LetterStep && mx<SelectedWordX+(i+1)*LetterStep && my<SelectedWordY && my>SelectedWordY-20){
            Found=true;
            if (!LetterUsed[i]){
                LetterHovered=i;
            }
        }
        else {
            i++;
        }
    }
}

function CheckPlaceHolderHover(){
    var Done;
    var i,j,X,Y;
    PlaceHolderI=-1;
    PlaceHolderJ=-1;
    Done=false;
    i=0;
    j=0;
    while (DragLetter && !Done){
        X=SolutionX(j);
        Y=SolutionY(i);
        if (mx>=X && mx<=X+40 && my<=Y+10 && my>=Y-30) {
            Done=true;
            PlaceHolderI=i;
            PlaceHolderJ=j;
        }
        else {
            j++;
            if (j==SelectedNoOfLetters+4){
                j=0;
                i++;
                if (i==5 || Correct[SelectedNoOfLetters][SelectedWord][i]=="") Done=true;
            }
        } 
    }
}

function ResetUserAnswers(){
    var i;
    // Διαγραφή λύσεων χρήστη
    for (i=0;i<5;i++){
        UserSolutions[i]="      ";
        ThisSolutionVisible[i]=false;
    }
    //Επαναφορά χρησιμοποιημένων γραμμάτων
    ResetUsedLetters();
    GameOver=false;
    //Solve.setEnabled(true);
    //Clear.setEnabled(true);
}

function CheckCompletion(){
    var i=0;
    var WordCompleted=false;
    while (i<5 && !WordCompleted){
        if (Correct[SelectedNoOfLetters][SelectedWord][i]==UserSolutions[CurrentUserSolution].substring(0,SelectedNoOfLetters+4)){
            WordCompleted=true;
        }
        else {
            i++;
        }
    }
    //Έλεγχος ολοκλήρωσης λέξης
    if (WordCompleted){
        if (!ThisSolutionVisible[i]) {
            ThisSolutionVisible[i]=true;
            if (CurrentUserSolution<4) CurrentUserSolution++;
        }
        else {
            UserSolutions[CurrentUserSolution]="      ";
        }
        ResetUsedLetters();
        //Έλεγχος ολοκλήρωσης παιχνιδιού
        GameOver=true;
        i=0;
        while (i<5 && !Correct[SelectedNoOfLetters][SelectedWord][i]==""){
          GameOver=GameOver & ThisSolutionVisible[i];
          i++;
        }
        if(GameOver){
            Solve.disabled=true;
            Clear.disabled=true;
        }
    }
}

function ResetUsedLetters(){
    for(var i=0;i<SelectedNoOfLetters+4;i++) {
        LetterUsed[i]=false;
    }
}

function ShowClocks(){
    var now=new Date();
    var h=now.getHours();
    var m=now.getMinutes();
    var s=now.getSeconds();
    if (chkAnalog.checked){
        cntx.drawImage(imgAnalogClock,AnalogClockLEFT,AnalogClockTOP);
        ShowAnalogTime(h,m,s);
    }
    if (chkDigital.checked){
        cntx.drawImage(imgDigitalClock,DigitalClockLEFT,DigitalClockTOP);
        ShowDigitalTime(h,m,s);
    }
    if (chkBinary.checked){
        cntx.drawImage(imgBinaryClock,BinaryClockLEFT-90,BinaryClockTOP-250);
        ShowBinaryTime(h,m,s);
    }
}

function ShowAnalogTime(h,m,s){
    var hrR=45,minR=60,secR=50;
    var CenterX=378,CenterY=201;
    var hrX2,hrY2,minX2,minY2,secX2,secY2;
    var hrAngle=2*(h*3600+m*60+s)*Math.PI/43200-Math.PI/2;
    var RectifyAngle=15;
    var minAngle=2*(m*60+s+RectifyAngle)*Math.PI/3600-Math.PI/2;
    var secAngle=2*s*Math.PI/60-Math.PI/2;
    cntx.strokeStyle="rgb(0,0,0)";
    cntx.beginPath();
    
    hrX2=parseInt(hrR*Math.cos(hrAngle))+CenterX;
    hrY2=parseInt(hrR*Math.sin(hrAngle))+CenterY;
    cntx.moveTo(CenterX,CenterY);
    cntx.lineTo(hrX2,hrY2);
    
    
    minX2=parseInt(minR*Math.cos(minAngle))+CenterX;
    minY2=parseInt(minR*Math.sin(minAngle))+CenterY;
    cntx.moveTo(CenterX,CenterY);
    cntx.lineTo(minX2,minY2);
    
    secX2=parseInt(secR*Math.cos(secAngle))+CenterX;
    secY2=parseInt(secR*Math.sin(secAngle))+CenterY;
    cntx.moveTo(CenterX,CenterY);
    cntx.lineTo(secX2,secY2);
    cntx.stroke();
}

function ShowDigitalTime(h,m,s){
    var X=DigitalClockLEFT+95;
    var h1=parseInt(h/10),h2=h % 10;
    var m1=parseInt(m/10),m2=m % 10;
    var s1=parseInt(s/10),s2=s % 10;
    cntx.strokeStyle="rgb(0,0,0)";
    PatternWidth=3;
    PatternHeight=18;
    ShowDigit(h1,X);
    X=X+20;
    ShowDigit(h2,X);
    X=X+30;
    ShowDigit(m1,X);
    X=X+20;
    ShowDigit(m2,X);
    X=X+15;
    PatternWidth=2;
    PatternHeight=8;
    ShowDigit(s1,X);
    X=X+12;
    ShowDigit(s2,X);
}

function ShowDigit(dgt,X){
    var Y=DigitalClockTOP+35;
    if (dgt==0){
        ShowDigit0(X,Y);
    }
    else if (dgt==1){
        ShowDigit1(X,Y);
    }
    else if (dgt==2){
        ShowDigit2(X,Y);
    }
    else if (dgt==3){
        ShowDigit3(X,Y);
    }
    else if (dgt==4){
        ShowDigit4(X,Y);
    }
    else if (dgt==5){
        ShowDigit5(X,Y);
    }
    else if (dgt==6){
        ShowDigit6(X,Y);
    }
    else if (dgt==7){
        ShowDigit7(X,Y);
    }
    else if (dgt==8){
        ShowDigit8(X,Y);
    }
    else if (dgt==9){
        ShowDigit9(X,Y);
    }
}

function ShowDigit0(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawLeft(X-4*PatternWidth,Y+PatternHeight);
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
}

function ShowDigit1(X,Y){
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
}

function ShowDigit2(X,Y){
    drawLeft(X-4*PatternWidth,Y+PatternHeight);
    drawRight(X,Y);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit3(X,Y){
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit4(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit5(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit6(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawLeft(X-4*PatternWidth,Y+PatternHeight);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit7(X,Y){
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
}

function ShowDigit8(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawLeft(X-4*PatternWidth,Y+PatternHeight);
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function ShowDigit9(X,Y){
    drawLeft(X-4*PatternWidth,Y);
    drawRight(X,Y);
    drawRight(X,Y+PatternHeight);
    drawUpper(X-4*PatternWidth,Y);
    drawLower(X-4*PatternWidth,Y+2*PatternHeight-PatternWidth);
    drawMiddle(X-4*PatternWidth,Y+PatternHeight);
}

function drawSegment(n,x,y){
    cntx.fillStyle="#000";
    cntx.beginPath();
    cntx.moveTo(x[0],y[0]);
    for(var i=1;i<n;i++){
        cntx.lineTo(x[i],y[i]);
    }
    cntx.closePath();
    cntx.fill();
}

function drawMiddle(X,Y){
    var border=2;
    var n=6;
    var x=[];
    var y=[];
    x[0]=X+border;
    x[1]=X+border+PatternWidth;
    x[2]=X+4*PatternWidth-border;
    x[3]=X+5*PatternWidth-border;
    x[4]=X+4*PatternWidth-border;
    x[5]=X+PatternWidth+border;
    
    y[0]=Y;
    y[1]=Y-2*PatternWidth/3;
    y[2]=Y-2*PatternWidth/3;
    y[3]=Y;
    y[4]=Y+2*PatternWidth/3;
    y[5]=Y+2*PatternWidth/3;
    drawSegment(n,x,y);
}

function drawLower(X,Y){
    var border=2;
    var n=4;
    var x=[];
    var y=[];
    x[0]=X+PatternWidth+border;
    x[1]=X+4*PatternWidth-border;
    x[2]=X+5*PatternWidth-border;
    x[3]=X+border;
    
    y[0]=Y;
    y[1]=Y;
    y[2]=Y+PatternWidth;
    y[3]=Y+PatternWidth;
    drawSegment(n,x,y);
}

function drawUpper(X,Y){
    var border=2;
    var n=4;
    var x=[];
    var y=[];
    x[0]=X+border;
    x[1]=X+5*PatternWidth-border;
    x[2]=X+4*PatternWidth-border;
    x[3]=X+PatternWidth+border;
    
    y[0]=Y;
    y[1]=Y;
    y[2]=Y+PatternWidth;
    y[3]=Y+PatternWidth;
    drawSegment(n,x,y);
}

function drawRight(X,Y){
    var n=4;
    var x=[];
    var y=[];
    x[0]=X;
    x[1]=X+PatternWidth;
    x[2]=x[1];
    x[3]=x[0];
    
    y[0]=Y+PatternWidth;
    y[1]=Y;
    y[2]=Y+PatternHeight;
    y[3]=Y+PatternHeight-PatternWidth;
    drawSegment(n,x,y);
}

function drawLeft(X,Y){
    var n=4;
    var x=[];
    var y=[];
    x[0]=X;
    x[1]=X+PatternWidth;
    x[2]=x[1];
    x[3]=x[0];
    
    y[0]=Y;
    y[1]=Y+PatternWidth;
    y[2]=Y+PatternHeight-PatternWidth;
    y[3]=Y+PatternHeight;
    drawSegment(n,x,y);
}

function ShowBinaryTime(h,m,s){
    var RectSize=22,RectXOffset=5;
    var HXOffset=BinaryClockLEFT,MXOffset=HXOffset+30,SXOffset=MXOffset+30;
    var hh=h,mm=m,ss=s;
    if (chkBAux.checked){
        ShowAuxBinaryInfo(h,m,s,HXOffset,MXOffset,SXOffset,BinaryClockTOP,RectSize,RectXOffset);
    }
    if (chkBinary2.checked){
        ShowRects(hh,HXOffset,RectSize,RectXOffset,1);
        ShowRects(mm,MXOffset,RectSize,RectXOffset,1);
        ShowRects(ss,SXOffset,RectSize,RectXOffset,1);
    }
    else{
        ShowRects(parseInt(hh/10),HXOffset,RectSize,RectXOffset,1);
        ShowRects(hh%10,HXOffset,RectSize,RectXOffset,2);
        ShowRects(parseInt(mm/10),MXOffset,RectSize,RectXOffset,1);
        ShowRects(mm%10,MXOffset,RectSize,RectXOffset,2);
        ShowRects(parseInt(ss/10),SXOffset,RectSize,RectXOffset,1);
        ShowRects(ss%10,SXOffset,RectSize,RectXOffset,2);
    }
}

function ShowRects(dd,XOffset,RectSize,RectXOffset,Selector){
    var RectWidth,RectOffset=0;
    if(chkBinary2.checked){
        RectWidth=RectSize;
    }
    else{
        RectWidth=RectSize/2-1;
        if (Selector==2){
            RectOffset=RectWidth+1;
        }
    }
    for(var i=NoOfRects();i>-1;i--){
        if (dd%2==1){
            cntx.fillStyle="rgb(170,0,255)";
        }
        else {
            cntx.fillStyle="rgb(180,180,180)";
        }
        cntx.fillRect(RectOffset+XOffset-2-RectSize,RectYCoord(i,RectSize,RectXOffset)+YOffset(RectSize),RectWidth,RectSize); 
        dd=parseInt(dd/2);
    }
}

function ShowAuxBinaryInfo(h,m,s,HXOffset,MXOffset,SXOffset,BinaryClockTOP,RectSize,RectXOffset){
    cnvsWrite(LetterColor,fontSize,"Arial",HXOffset-20,BinaryClockTOP,""+h);
    cnvsWrite(LetterColor,fontSize,"Arial",MXOffset-20,BinaryClockTOP,""+m);
    cnvsWrite(LetterColor,fontSize,"Arial",SXOffset-20,BinaryClockTOP,""+s);
    for(var i=NoOfRects();i>-1;i--){
        cnvsWrite(LetterColor,fontSize,"Arial",SXOffset,RectYCoord(i,RectSize,RectXOffset)+YOffset(RectSize)+2*RectSize/3,""+parseInt(Math.pow(2,NoOfRects()-i)));
    }
}

function NoOfRects(){
    if(chkBinary2.checked){
        return 5;
    }
    else {
        return 3;
    }
}

function YOffset(RectSize){
    if (chkBinary2.checked){
        return 0;
    }
    else {
        return 2*RectSize;
    }
}

function RectYCoord(i,RectSize,RectXOffset){
    return 40+BinaryClockTOP+i*(RectSize+4)+RectXOffset-220;
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(evt){
    isButtonPressed=true;
    
    if(introStep==wordsStep){
        if(LetterHovered>-1){
            if(evt.button==leftMouseBtnId){
                DragLetter=true;
            }
        }
    }
    drawBasicScreen();
}

function handleMouseMove(evt){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else {
        imgLogo=document.getElementById("Logo");
        ShowProgramID=false;
    }

    if(introStep==LastIntroStep){
        if (mx>=98 && mx<125 && my>=207 && my<=212){
            $("#visualisation").css("cursor","pointer");
        }
        else if (mx>=474 && mx<501 && my>=267 && my<=275){
            $("#visualisation").css("cursor","pointer");
        }
        else{
            $("#visualisation").css("cursor","default");
        }
    }
    
    if(introStep==wordsStep){
        if(DragLetter){
            CheckPlaceHolderHover();
        }
        else{
            checkLetterHover();
        }
    }
    if(introStep!=ClocksStep)drawBasicScreen();
    //console.log("mx="+mx+" , my="+my+" , introStep="+introStep);
}

function handleMouseUp(evt){
    evt.preventDefault();
    isButtonPressed=false;
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        if(MyInfo){
            ShowProgramID=!ShowProgramID;
        }
        else {
            showHTML();
        }
    }
    //var RIGHT_CTRL_MASK = InputEvent.BUTTON3_MASK + InputEvent.ALT_MASK + InputEvent.CTRL_MASK + InputEvent.SHIFT_MASK;
    ProgramID="";
    /*if ((e.getModifiers() & RIGHT_CTRL_MASK)==RIGHT_CTRL_MASK && e.getX()>7*width/8 && e.getY()<TopPanelHeight/2){
        ProgramID="(c) 2012 Panagiotis Tsakonas (ptsakon@yahoo.com)";
    }*/

    if(mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && introStep<wordsStep){
        if (introStep==HandsStep1 || introStep==HandsStep2){
            if (HandCounting==8) {
                introStep++;
            }
        }
        else if (introStep==HandsStep3){
            introStep++;
        }
        else if (introStep<LastIntroStep) {
                introStep++;
        }
        InitialiseGUI_values();
    }
    if(mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && introStep>1){
        if (introStep==wordsStep) {
            introStep=LastIntroStep;
        }
        else {
            introStep--;
        }
        InitialiseGUI_values();
    }
    if(introStep==LastIntroStep){
        if (mx>=98 && mx<125 && my>=207 && my<=212){
            introStep=wordsStep;
        }
        if (mx>=474 && mx<501 && my>=267 && my<=275){
            introStep=HandsStep1;
        }
    }
    if(introStep==wordsStep){
        if (LetterHovered>-1){
            if(evt.button==leftMouseBtnId){
                if (DragLetter){
                    PlaceLetter();
                    DragLetter=false;
                }
            }
            else if(evt.button==rightMouseBtnId){
                LetterUsed[LetterHovered]=true;
                var i=0;
                while (UserSolutions[CurrentUserSolution].charAt(i)!=' '){
                    i++;
                }
                PlaceHolderI=0;
                PlaceHolderJ=i;
                PlaceLetter();
            }
        }
    }
    drawBasicScreen();
}

function solveWordGame(){
    SolutionVisible=true;
    GameOver=true;
    Solve.disabled=true;
    Clear.disabled=true;
    drawBasicScreen();
}

function clearWordGame(){
    ResetUsedLetters();
    UserSolutions[CurrentUserSolution]="      ";
    drawBasicScreen();
}

function newWordGame(){
    GetWord();
    Clear.disabled=false;
    Solve.disabled=false;
    drawBasicScreen();
}

function handleHandsScrollBars(){
    if(introStep==HandsStep1 || introStep==HandsStep2){
        if(HandCounting<8){
            HandCounting++;
        }
    }
   drawBasicScreen();
}

function handleWordScrollBars(){
    $("#levelSelectorValue").html(LevelSelector.value);
    $("#lengthSelectorValue").html(LengthSelector.value);
    SelectedLevel=parseInt(LevelSelector.value);
    SelectedNoOfLetters=parseInt(LengthSelector.value)-4;
    //GetWord();
    newWordGame();
}

function handleCheckBoxes(){
    drawBasicScreen();
}