var canvas;
var cntx;

function init(){
	canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}
      
function initialiseEvents(){
	$("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });

    $("#visualisation").on("mousedown touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });

    window.addEventListener("beforeunload",function(e){
        clearInterval(timerLoop);
    });
    
    window.addEventListener("keydown",this.keyPressed,false);
}

function initialiseGUI(){

}

function initialValues(){
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");
    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
    $("#Algorithms").val("");
    Keyb=document.getElementById("keyboard");
    RAMdataYcoord=BottomPanelTop-12;
    prompt1="";
    prompt2="";
    SimulationStep=-1;
}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    //Εικόνες
    drawIntroImage();
    drawLogoImage();

    if(introStep==introLastStep){
        $("#divShowRAM").show();
        if(StateRestored){
            $("#algorithmSelector").show();
            $("#divShowRAM").show();
        }
        $("#cmdNextStep").show();
        if(SelectedAlgorithm>0){
            $("#controlButtons").show();
            DefineFlowChart();
            drawFlowChart(0,MainXcoord,MainYcoord,true);
        }
        else{
            $("#controlButtons").hide();
        }
        cntx.fillStyle="rgb(220,255,255)";
        cntx.strokeStyle="rgb(0,0,255)";
        cntx.beginPath();
        cntx.fillRect(2,BottomPanelTop-30,450,25);
        cntx.rect(2,BottomPanelTop-30,450,25);
        cntx.stroke();
        if(WaitingForUserInput){
            cntx.drawImage(Keyb,KeybLeft,KeybTop);
        }
        if($("#chkShowRAM").prop("checked")) drawMemoryData();
        if(SelectedAlgorithm==3){
            DrawUserInputSoFar(TopScreenLine);
            if(SimulationStep==4 || SimulationStep==5) {
                ShowFullScreenData();
            }
        }        
        showUserPrompts();
    }
    else{
        $("#divShowRAM").hide();
        $("#controlButtons").hide();
        $("#algorithmSelector").hide();
        Drawing=false;
    }

    if(introStep<introLastStep){
        drawButtonNext();
    }
    if(introStep>1){
    	drawButtonBack();
    }
}

function showUserPrompts(){
    var vTxtOffset=25;
    var promptYCoord;
    promptYCoord=BottomPanelTop+20;
    if(Drawing){
        promptYCoord=BottomPanelTop+15;
        vTxtOffset=20;
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Παρακολούθησε τα βήματα εκτέλεσης στο διάγραμμα ροής,");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"σε συνδυασμό με τα αποτελέσματα στην οθόνη.");
        promptYCoord=promptYCoord+vTxtOffset;
        if($("#chkShowRAM").prop("checked")){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Λάβε υπόψη σου και τα περιεχόμενα των μεταβλητών.");
            promptYCoord=promptYCoord+vTxtOffset;
        }
        if(WaitingForUserInput){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Τροφοδότησε τον αλγόριθμο με τα επιθυμητά δεδομένα.");
            promptYCoord=promptYCoord+vTxtOffset;
        }
    }
    else if(StateRestored){
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Διάλεξε έναν Αλγόριθμο από τη λίστα για να δεις το Διάγραμμα Ροής του.");
        promptYCoord=promptYCoord+vTxtOffset;
        if(SelectedAlgorithm>0){
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Χρησιμοποίησε τα κουμπιά [Έναρξη], [Επόμενο Βήμα] για να δεις τη λειτουργία του.");
            promptYCoord=promptYCoord+vTxtOffset;
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Χρησιμοποίησε το διακόπτη [Περιεχόμενα Μνήμης] για να παρακολουθήσεις τα περιεχόμενα των μεταβλητών.");
            promptYCoord=promptYCoord+vTxtOffset;
            cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Στο τέλος, πάτησε το κουμπί [Επαναφορα] για να επιλέξεις άλλο αλγόριθμο.");
            promptYCoord=promptYCoord+vTxtOffset;
        }
    }
    else{
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Σύγκρινε το διάγραμμα ροής με τα αποτελέσματα σητν οθόνη.");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Μπορείς να ξανατρέξεις τομν αλγόριθμο πατώντας το κουμπί [Έναρξη].");
        promptYCoord=promptYCoord+vTxtOffset;
        cnvsWrite(LetterColor,fontSize,"Arial",50,promptYCoord,"Πάτησε το κουμπί [Επαναφορά] για να επανέλθεις στην αρχική κατάσταση ή για να επιλέξεις άλλον αλγόριθμο.");
        promptYCoord=promptYCoord+vTxtOffset;
    }
}

function drawIntroImage(){
	Intro=document.getElementById("img"+introStep);
    var picTop=(height-Intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+Intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
    cntx.drawImage(Intro,1,picTop);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if(buttonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function buttonNextHover(){
    if(mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function drawButtonBack(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if(buttonBackHover()){
        cntx.drawImage(imgBackStepSelected,BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled,BackStepLeft,BackStepTop);
    }
}

function buttonBackHover(){
    if(mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    if(fontName!=""){
    	cntx.font=fontSize+"px "+fontName;
    }
    if(clr!=""){
    	cntx.fillStyle=clr;
    }
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){

}

function handleMouseMove(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    
    if(!Drawing)drawBasicScreen();
    if(debug)console.log("mx="+mx+" , my="+my);
}

function handleMouseUp(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight){
        showHTML();
    }
    if(mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && introStep<introLastStep){
        introStep++;
    }
    if(mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && introStep>1){
        introStep--;
    }
    
    if(WaitingForUserInput){
        if(my>=421 && my<=437){
            if(mx>=495 && mx<=684){
                var keyCode=parseInt((((mx-495)/19+1) % 10)+48);
                if(keyCode==58)keyCode=48;
                //char c=(char)dgt;
                HandleUserInputDigit(keyCode);
            }
            else if(mx>=728 && mx<=761){
                HandleUserBackSpace();
            }
        }
        else if(mx>=727 && mx<=760 && my>=460 && my<=474){
            HandleUserInputTermination();
        }
    }    
    drawBasicScreen();
}

function keyPressed(k){
    if(WaitingForUserInput){
        var keyCode=k.keyCode;
        switch(keyCode){
            case codeKeyEnter:
              HandleUserInputTermination();
              break;
            case codeKeyBackspace:
              HandleUserBackSpace();
              break;
            case 48:
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:
                HandleUserInputDigit(keyCode);
                break;
        }
        drawBasicScreen();
    }
}

function run(){
    if(Drawing){
        if(!WaitingForUserInput){
            //Αν η συνθήκη είναι ψευδής ΚΑΙ είσαι στο βήμα προσομοίωσής της ΤΟΤΕ ακολούθησε το δεύτερο κλάδο
            if(((SelectedAlgorithm==2 && SimulationStep==5) || (SelectedAlgorithm==3 && SimulationStep==3)) && !MainBranch){
                SimulationStep=ChartShapes[SimulationStep][2];
            }
            else{
                SimulationStep++;
            }
            if(SimulationStep==MaxNoOfShapes || ChartShapes[SimulationStep][1]==0){
                Drawing=false;
                //$("#cmdSimulate").attr("disabled",false);
                $("#cmdSimulate").show();
                //$("#cmdNextStep").attr("disabled",false);
                $("#cmdNextStep").show();
                $("#cmdNextStep").html("Επαναφορά");
            }
            if(SelectedAlgorithm<3 && (SimulationStep==2 || SimulationStep==4)){
                UserInput="";
                WaitingForUserInput=true;
            }
            else if(SelectedAlgorithm==3 && SimulationStep==7){
                UserInput="";
                WaitingForUserInput=true;
            }
            else{
                if(StepByStepSimulation){
                    Drawing=false;
                    //$("#cmdNextStep").attr("disabled",false);
                    $("#cmdNextStep").show();
                }
            }
        }
        drawBasicScreen();
    }
}

function resetDrawingLoop(){
    LoopCounter=0;
    Drawing=true;
    initiateSiumulation();
}

function initiateSiumulation(){
    if(introStep==introLastStep){
        clearInterval(timerLoop);
        //var simulationSpeed=parseInt($("#HScrDrawSpeed").attr("max"))-parseInt($("#HScrDrawSpeed").val());
        timerLoop=setInterval(function(){run();},simulationSpeed);
    }
}

function drawMemoryData(){
    var fontSizeToUse=14;
    var Xscr=180;
    var colorToUse="rgb(0,0,255)";
    if(SelectedAlgorithm==1 || SelectedAlgorithm==2){
        if(SimulationStep>2){
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"α="+No1);
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"α=...");
        }
        Xscr=Xscr+60;
        if(SimulationStep>4){
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"β="+No2);
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"β=...");
        }
        Xscr=Xscr+60;
        if(SimulationStep>5 && (SelectedAlgorithm==1 || SelectedAlgorithm==2 && No2!=0)) {
            if(SelectedAlgorithm==1){
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"γ="+No1*No2);
            }
            else{
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"γ="+parseInt(decimals*No1/No2)/decimals);
            }
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"γ=...");
        }
    }
    else if(SelectedAlgorithm==3){
        if(SimulationStep>1){
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"i="+(ForCounter+1));
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"i=...");
        }
        Xscr=Xscr+60;
        if(SimulationStep>7 || SimulationStep>1 && ForCounter>0){
            if(SimulationStep==8){
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"x="+Number[ForCounter]);
            }
            else{
                cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"x="+Number[ForCounter-1]);
            }
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"x=...");
        }
        Xscr=Xscr+60;
        if(SimulationStep>1){
            var s=0;
            for(var k=0;k<ForCounter;k++) s=s+Number[k]; 
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"Αθρ="+s);
        }
        else{
            cnvsWrite(colorToUse,fontSizeToUse,"Arial",Xscr,RAMdataYcoord,"Αθρ=...");
        }
    }
}

function itemStateChanged(slctr){
    if(slctr=="Algorithms"){
        SelectedAlgorithm=$("#Algorithms").prop("selectedIndex");
        SimulationStep=-1;
        StateRestored=true;
    }
    drawBasicScreen();
}

function actionPerformed(slctr){
    if(slctr=="cmdSimulate"){
        $("#divShowRAM").hide();
        $("#algorithmSelector").hide();
        //$("#cmdSimulate").attr("disabled",true);
        $("#cmdSimulate").hide();
        $("#cmdNextStep").html("Επόμενο βήμα");
        //$("#cmdNextStep").attr("disabled",true);
        $("#cmdNextStep").hide();
        WaitingForUserInput=false;
        StepByStepSimulation=false;
        SimulationStep=-1;
        MainBranch=true;
        Drawing=true;
        ForCounter=0;
        StateRestored=false;
        resetDrawingLoop();
    }
    else if(slctr=="cmdNextStep"){
        if($("#cmdNextStep").html()=="Επόμενο Βήμα"){
            StepByStepSimulation=true;
            Drawing=true;
            initiateSiumulation();
        }
        else if($("#cmdNextStep").html()=="Επαναφορά"){
            $("#cmdNextStep").html("Επόμενο Βήμα");
            StepByStepSimulation=true;
            SimulationStep=-1;
            ForCounter=0;
            $("#divShowRAM").show();
            $("#algorithmSelector").show();
            StateRestored=true;
            drawBasicScreen();
        }
    }
}

function HandleUserInputDigit(keyCode){
    var c=String.fromCharCode(keyCode);
    if(c>="0" && c<="9" && UserInput.length<5){
        UserInput=UserInput+c;
    }
}

function HandleUserBackSpace(){
    if(UserInput.length>0) UserInput=UserInput.substring(0,UserInput.length-1);
}

function HandleUserInputTermination(){
    if(SelectedAlgorithm<3){
        if(UserInput!=""){
            //$("#cmdNextStep").attr("disabled",false);
            $("#cmdNextStep").show();
            if(SimulationStep==2) {
                No1=parseInt(UserInput);
            }
            else if(SimulationStep==4){
                No2=parseInt(UserInput);
            }
            WaitingForUserInput=false;
        }
    }
    else{
        if(UserInput!=""){
            //$("#cmdNextStep").attr("disabled",false);
            $("#cmdNextStep").show();
            Number[ForCounter]=parseInt(UserInput);
            WaitingForUserInput=false;
        }
    }
}

function DrawUserInputSoFar(ScreenLine){
    var colorToUse=userScreenColor;
    for(var j=0;j<ForCounter;j++){
        cnvsWrite(colorToUse,userInputFontSize,"Arial",450,ScreenLine,"Δώσε x");
        ScreenLine=ScreenLine+20;
        cnvsWrite(colorToUse,userInputFontSize,"Arial",450,ScreenLine,Number[j]);
        ScreenLine=ScreenLine+20;
    }
}

function ShowFullScreenData(){
    DrawUserInputSoFar(TopScreenLine);
    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,TopScreenLine+5*40,Sum);
}

function DefineFlowChart(){
    /* Shape Types
     *-1 = dummy shape
     * 1 = Έλλειψη ΑΡΧΗ - ΤΕΛΟΣ
     * 2 = Πλάγιο Παραλληλόγραμμο ΔΙΑΒΑΣΕ - ΓΡΑΨΕ
     * 3 = Ορθογώνιο Παραλληλόγραμμο
     * 4 = Ρόμβος
    */        
    if(SelectedAlgorithm==1){
        DefineMult();
    }
    else if(SelectedAlgorithm==2){
        DefineDiv();
    }
    else if(SelectedAlgorithm==3){
        DefineFor();
    }
}

function DefineMult(){
    //ΑΡΧΗ
    ChartShapes[0][0]=1;
    ChartShapes[0][1]=1;
    ChartShapes[0][2]=0;        
    ChartLabels[0]="ΑΡΧΗ";
    //ΓΡΑΨΕ προτρεπτικό
    ChartShapes[1][0]=2;
    ChartShapes[1][1]=2;
    ChartShapes[1][2]=0;        
    ChartLabels[1]="ΓΡΑΨΕ 'Δώσε α'";
    //ΔΙΑΒΑΣΕ α
    ChartShapes[2][0]=2;
    ChartShapes[2][1]=3;
    ChartShapes[2][2]=0;        
    ChartLabels[2]="ΔΙΑΒΑΣΕ α";
    //ΓΡΑΨΕ προτρεπτικό
    ChartShapes[3][0]=2;
    ChartShapes[3][1]=4;
    ChartShapes[3][2]=0;
    ChartLabels[3]="ΓΡΑΨΕ 'Δώσε β'";
    //ΔΙΑΒΑΣΕ β
    ChartShapes[4][0]=2;
    ChartShapes[4][1]=5;
    ChartShapes[4][2]=0;
    ChartLabels[4]="ΔΙΑΒΑΣΕ β";
    // Εκτέλεση Πολλαπλασιασμού
    ChartShapes[5][0]=3;
    ChartShapes[5][1]=6;
    ChartShapes[5][2]=0;
    ChartLabels[5]="γ <-- α*β";
    // ΓΡΑΨΕ αποτέλεσμα
    ChartShapes[6][0]=2;
    ChartShapes[6][1]=7;
    ChartShapes[6][2]=0;
    ChartLabels[6]="ΓΡΑΨΕ γ";
    // ΤΕΛΟΣ
    ChartShapes[7][0]=1;
    ChartShapes[7][1]=0;
    ChartShapes[7][2]=0;
    ChartLabels[7]="ΤΕΛΟΣ";
}

function DefineDiv(){
    //ΑΡΧΗ
    ChartShapes[0][0]=1;
    ChartShapes[0][1]=1;
    ChartShapes[0][2]=0;
    ChartLabels[0]="ΑΡΧΗ";
    //ΓΡΑΨΕ προτρεπτικό
    ChartShapes[1][0]=2;
    ChartShapes[1][1]=2;
    ChartShapes[1][2]=0;
    ChartLabels[1]="ΓΡΑΨΕ 'Δώσε α'";
    //ΔΙΑΒΑΣΕ α
    ChartShapes[2][0]=2;
    ChartShapes[2][1]=3;
    ChartShapes[2][2]=0;
    ChartLabels[2]="ΔΙΑΒΑΣΕ α";
    //ΓΡΑΨΕ προτρεπτικό
    ChartShapes[3][0]=2;
    ChartShapes[3][1]=4;
    ChartShapes[3][2]=0;
    ChartLabels[3]="ΓΡΑΨΕ 'Δώσε β'";
    //ΔΙΑΒΑΣΕ β
    ChartShapes[4][0]=2;
    ChartShapes[4][1]=5;
    ChartShapes[4][2]=0;
    ChartLabels[4]="ΔΙΑΒΑΣΕ β";
    // β<>0
    ChartShapes[5][0]=4;
    ChartShapes[5][1]=6;
    ChartShapes[5][2]=9;
    ChartLabels[5]=" β<>0 ";
    // Εκτέλεση Διαίρεσης
    ChartShapes[6][0]=3;
    ChartShapes[6][1]=7;
    ChartShapes[6][2]=0;
    ChartLabels[6]="γ <-- α/β";
    // ΓΡΑΨΕ αποτέλεσμα
    ChartShapes[7][0]=2;
    ChartShapes[7][1]=8;
    ChartShapes[7][2]=0;
    ChartLabels[7]="ΓΡΑΨΕ γ";
    // ΤΕΛΟΣ
    ChartShapes[8][0]=1;
    ChartShapes[8][1]=0;
    ChartShapes[8][2]=0;
    ChartLabels[8]="ΤΕΛΟΣ";
    // ΓΡΑΨΕ διαγνωστικό
    ChartShapes[9][0]=2;
    ChartShapes[9][1]=10;
    ChartShapes[9][2]=0;
    ChartLabels[9]="ΓΡΑΨΕ 'Διαίρεση Αδύνατη'";
    // dummy shape
    ChartShapes[10][0]=-1;
    ChartShapes[10][1]=8;
    ChartShapes[10][2]=0;
    ChartLabels[10]="dummy";
}

function DefineFor(){
    //ΑΡΧΗ
    ChartShapes[0][0]=1;
    ChartShapes[0][1]=1;
    ChartShapes[0][2]=0;
    ChartLabels[0]="ΑΡΧΗ";
    //sum=0
    ChartShapes[1][0]=3;
    ChartShapes[1][1]=2;
    ChartShapes[1][2]=0;
    ChartLabels[1]="Αθρ=0";
    //i=1
    ChartShapes[2][0]=3;
    ChartShapes[2][1]=3;
    ChartShapes[2][2]=0;
    ChartLabels[2]="i <-- 1";
    // i>MaxLoopValue
    ChartShapes[3][0]=4;
    ChartShapes[3][1]=4;
    ChartShapes[3][2]=6;
    ChartLabels[3]=" i < "+(MaxLoopValue+1)+" ";
    // ΓΡΑΨΕ αποτέλεσμα
    ChartShapes[4][0]=2;
    ChartShapes[4][1]=5;
    ChartShapes[4][2]=0;
    ChartLabels[4]="ΓΡΑΨΕ Αθρ";
    // ΤΕΛΟΣ
    ChartShapes[5][0]=1;
    ChartShapes[5][1]=0;
    ChartShapes[5][2]=0;
    ChartLabels[5]="ΤΕΛΟΣ";
    // ΓΡΑΨΕ προτρεπτικό
    ChartShapes[6][0]=2;
    ChartShapes[6][1]=7;
    ChartShapes[6][2]=0;
    ChartLabels[6]="ΓΡΑΨΕ 'Δώσε x'";
    // ΔΙΑΒΑΣΕ x
    ChartShapes[7][0]=2;
    ChartShapes[7][1]=8;
    ChartShapes[7][2]=0;
    ChartLabels[7]="ΔΙΑΒΑΣΕ x";
    //sum=sum+x
    ChartShapes[8][0]=3;
    ChartShapes[8][1]=9;
    ChartShapes[8][2]=0;
    ChartLabels[8]="Αθρ <-- Αθρ+x";
    //i=i+1
    ChartShapes[9][0]=3;
    ChartShapes[9][1]=10;
    ChartShapes[9][2]=0;
    ChartLabels[9]="i <-- i+1";
    // dummy shape
    ChartShapes[10][0]=-1;
    ChartShapes[10][1]=3;
    ChartShapes[10][2]=0;
    ChartLabels[10]="dummy";
}

function drawFlowChart(i,Xcoord,YOffset,SimulationSwitch){
    var LineWidth=3;
    var NextShape,NextYOffset,NewXcoord,SideA,HorizontalOffset=100,LineLength=20;
    var RectType;
    if(ChartShapes[i][0]!=-1) YOffset=YOffset+ShapeOffset;
    //Ρόμβος
    if(ChartShapes[i][0]==4){
        SideA=DrawDiamond(Xcoord,YOffset-ShapeOffset/2,i);
        //Επιλογή κλάδου
        if(SelectedAlgorithm==2){
            //Στη Δομή Επιλογής
            if(No2==0){
                MainBranch=false;
            }
            else{
                MainBranch=true;
            }
        }
        else if(SelectedAlgorithm==3){
            //Στη Δομή Επανάληψης
            if(ForCounter==MaxLoopValue){
                MainBranch=true;
                //drawBasicScreen();
            }
            else {
                MainBranch=false;
            }
        }
        //ΠΡΩΤΟΣ ΚΛΑΔΟΣ (TRUE)
        NextShape=ChartShapes[i][1];
        if(NextShape!=0){
            //Αν α) προσομοιώνεις, β) έχεις φτάσει εδώ και γ)Συνθήκη Αληθής ΤΟΤΕ ζωγράφισε έντονη γραμμή
            if(i<SimulationStep && MainBranch){
                if(SelectedAlgorithm==2){
                    cntx.fillStyle="rgb(0,225,0)";
                }
                else{
                    cntx.fillStyle="rgb(225,0,0)";
                }
                cntx.beginPath();
                cntx.fillRect(Xcoord-LineWidth/2,YOffset,LineWidth,LineLength);
                cntx.fill();
            }
            //αλλιώς ζωγράφισε λεπτή γραμμή
            else{
                cntx.strokeStyle="rgb(0,0,0)";
                cntx.beginPath();
                cntx.moveTo(Xcoord,YOffset);
                cntx.lineTo(Xcoord,YOffset+LineLength);
                cntx.stroke();
            }
            NextYOffset=YOffset+LineLength;
            //Σχεδίασε τον υπόλοιπο κλάδο TRUE
            drawFlowChart(NextShape,Xcoord,NextYOffset,MainBranch);
        }
        //ΔΕΥΤΕΡΟΣ ΚΛΑΔΟΣ (TRUE)
        NextShape=ChartShapes[i][2];
        if(NextShape!=0){
            NewXcoord=Xcoord+SideA/2+HorizontalOffset;
            //Αν α) προσομοιώνεις, β) έχεις φτάσει εδώ και γ)Συνθήκη Ψευδής ΤΟΤΕ ζωγράφισε έντονη γραμμή
            if(i<SimulationStep && !MainBranch){
                if(SelectedAlgorithm==2){
                    cntx.fillStyle="rgb(225,0,0)";
                }
                else{
                    cntx.fillStyle="rgb(0,225,0)";
                }
                cntx.beginPath();
                cntx.fillRect(Xcoord+SideA/2,YOffset-12-LineWidth/2,HorizontalOffset,LineWidth);
                cntx.fillRect(NewXcoord-LineWidth/2,YOffset-12,LineWidth,LineLength+12);
                cntx.fill();
            }
            //αλλιώς ζωγράφισε λεπτή γραμμή
            else{
                cntx.strokeStyle="rgb(0,0,0)";
                cntx.beginPath();
                cntx.moveTo(Xcoord+SideA/2,YOffset-12);
                cntx.lineTo(NewXcoord,YOffset-12);
                cntx.moveTo(NewXcoord,YOffset-12);
                cntx.lineTo(NewXcoord,YOffset+LineLength);
                cntx.stroke();
            }
            NextYOffset=YOffset+LineLength;
            //Σχεδίασε τον υπόλοιπο κλάδο FALSE
            drawFlowChart(NextShape,NewXcoord,NextYOffset,!MainBranch);
        }
    }
    else{
        //Έλλειψη
        if(ChartShapes[i][0]==1){
            var OkToDraw=SimulationSwitch || (SelectedAlgorithm==2 && SimulationStep==11);
            drawEllipse(Xcoord,YOffset,i,OkToDraw);                 
        }
        //Πλάγιο Παραλληλόγραμμο
        else if(ChartShapes[i][0]==2){
            RectType=2;
            drawRectangle(RectType,Xcoord,YOffset,i,SimulationSwitch);
        }
        //Ορθογώνιο Παραλληλόγραμμο
        else if(ChartShapes[i][0]==3){
            RectType=1;
            drawRectangle(RectType,Xcoord,YOffset,i,SimulationSwitch);
        }
        //Σχεδίαση γραμμής εξόδου από το σχήμα
        if(ChartLabels[i]!="ΤΕΛΟΣ"){
            if((i<SimulationStep || (SelectedAlgorithm==2 && SimulationStep==10)) && SimulationSwitch){
                cntx.fillStyle="rgb(0,0,255)";
                cntx.beginPath();
                cntx.fillRect(Xcoord-LineWidth/2,YOffset,LineWidth,LineLength);
                cntx.fill();
            }
            else{
                cntx.fillStyle="rgb(0,0,0)";
                cntx.beginPath();
                cntx.moveTo(Xcoord,YOffset);
                cntx.lineTo(Xcoord,YOffset+LineLength);
                cntx.stroke();
            }
            YOffset=YOffset+LineLength;
        }
        NextShape=ChartShapes[i][1];
        if(NextShape>i){
            //Συνέχεια σχεδίασης του κλάδου
            if(NextShape!=0) drawFlowChart(NextShape,Xcoord,YOffset,SimulationSwitch);
        }
        else if(NextShape!=0){
            //επιστροφή στον κύριο κλάδο
            var NewY=MainYcoord+NextShape*(ShapeOffset+LineLength)-LineLength/2;
            if(ChartLabels[NextShape]=="ΤΕΛΟΣ"){
                //Επανασύνδεση προς τα κάτω
                if(i<=SimulationStep && SimulationSwitch){
                    cntx.fillStyle="rgb(0,0,255)";
                    cntx.beginPath();
                    cntx.fillRect(Xcoord-LineWidth/2,YOffset,LineWidth,NewY-YOffset);
                    cntx.fillRect(MainXcoord,NewY-LineWidth/2,Xcoord-MainXcoord,LineWidth);
                    //Συμπλήρωσε την κατακόρυφη προς το ΤΕΛΟΣ
                    cntx.fillRect(MainXcoord-LineWidth/2,NewY,LineWidth,LineLength/2);
                    cntx.fill();
                }
                else{
                    cntx.fillStyle="rgb(0,0,0)";
                    cntx.beginPath();
                    cntx.moveTo(Xcoord,YOffset);
                    cntx.lineTo(Xcoord,NewY);
                    cntx.moveTo(Xcoord,NewY);
                    cntx.lineTo(MainXcoord,NewY);
                    cntx.stroke();
                }
            }
            else{
                //Επανασύνδεση προς τα πάνω
                NewXcoord=Xcoord+HorizontalOffset;
                if(i<=SimulationStep && SimulationSwitch || SimulationStep==10){
                    cntx.fillStyle="rgb(0,0,255)";
                    //Κατακόρυφη προς τα κάτω
                    cntx.beginPath();
                    cntx.fillRect(Xcoord-LineWidth/2,YOffset-2*LineLength,LineWidth,2*LineLength);
                    //Οριζόντια προς τα δεξιά
                    cntx.fillRect(Xcoord,YOffset-LineWidth/2,NewXcoord-Xcoord,LineWidth);
                    //Κατακόρυφη προς τα πάνω
                    cntx.fillRect(NewXcoord-LineWidth/2,NewY,LineWidth,YOffset-NewY);
                    //Οριζόντια προς τα αριστερά
                    cntx.fillRect(MainXcoord,NewY-LineWidth/2,NewXcoord-MainXcoord,LineWidth);
                    cntx.fill();
                }
                else{
                    cntx.fillStyle="rgb(0,0,0)";
                    cntx.beginPath();
                    cntx.moveTo(Xcoord,YOffset);
                    cntx.lineTo(NewXcoord,YOffset);
                    cntx.moveTo(NewXcoord,YOffset);
                    cntx.lineTo(NewXcoord,NewY);
                    cntx.moveTo(NewXcoord,NewY);
                    cntx.lineTo(MainXcoord,NewY);
                    cntx.stroke();
                }
                if(i<=SimulationStep) SimulationStep=NextShape-1;
            }
        }
    }
}

function drawEllipse(Xc,Yc,i,SimulationSwitch){
    cntx.font=flowChartFontSize+"px Arial";
    var Radius1=cntx.measureText(ChartLabels[i]).width;
    var Radius2=12;
    var lft=Xc,tp=Yc-Radius2;
    var FillColor,BorderColor,TextColor;
    if(i<=SimulationStep && SimulationSwitch){
        FillColor=Vivid;
        BorderColor="rgb(0,0,255)";
        TextColor="rgb(0,0,255)";
    }
    else{
        FillColor=Fade;
        BorderColor="rgb(0,0,0)";
        TextColor="rgb(0,0,0)";
    }
    cntx.fillStyle=FillColor;
    cntx.beginPath();
    cntx.ellipse(lft,tp,Radius1,Radius2,0,0,2*Math.PI);
    cntx.fill();
    cntx.strokeStyle=BorderColor;
    cntx.beginPath();
    cntx.ellipse(lft,tp,Radius1,Radius2,0,0,2*Math.PI);
    cntx.stroke();
    cnvsWrite(TextColor,flowChartFontSize,"Arial",lft-Radius1/2,tp+Radius2/2,ChartLabels[i]);
}

function DrawDiamond(Xc,Yc,i){
    var DiamondBorder=5;
    cntx.font=flowChartFontSize+"px Arial";
    var SideA=5*cntx.measureText(ChartLabels[i]).width;
    var SideB=12;
    var lft=Xc-SideA/2,tp=Yc-SideB;
    var Xcoord=[0,0,0,0,0];
    var Ycoord=[0,0,0,0,0];
    var FillColor;
    var BorderColor="rgb(255,0,0)";
    var TextColor="rgb(255,0,0)";
    Xcoord[0]=lft-DiamondBorder;
    Ycoord[0]=Yc;
    Xcoord[1]=lft+SideA/2;
    Ycoord[1]=tp;
    Xcoord[2]=lft+DiamondBorder+SideA;
    Ycoord[2]=Ycoord[0];
    Xcoord[3]=Xcoord[1];
    Ycoord[3]=Yc+SideB;
    Xcoord[4]=lft-DiamondBorder;
    Ycoord[4]=Yc;
    if(i<=SimulationStep && (SelectedAlgorithm!=3 || SimulationStep!=10)){
        FillColor=Vivid;
        if(SelectedAlgorithm==2){
            if(No2!=0){
                BorderColor="rgb(0,225,0)";
                TextColor="rgb(0,225,0)";
            }
            else{
                BorderColor="rgb(255,0,0)";
                TextColor="rgb(255,0,0)";
            }
        }
        else if(SelectedAlgorithm==3){
            if(ForCounter==MaxLoopValue){
                BorderColor="rgb(255,0,0)";
                TextColor="rgb(255,0,0)";
            }
            else{
                BorderColor="rgb(0,225,0)";
                TextColor="rgb(0,225,0)";
            }
        }
    }
    else{
        FillColor=Fade;
        BorderColor="rgb(0,0,0)";
        TextColor="rgb(0,0,0)";
    }
    fillPolygon(Xcoord,Ycoord,5,FillColor);
    drawPolygon(Xcoord,Ycoord,5,BorderColor);

    cnvsWrite(TextColor,flowChartFontSize,"Arial",lft+0.4*SideA,Yc+SideB/3,ChartLabels[i]);
    cntx.strokeStyle="rgb(0,0,0))";
    if(SelectedAlgorithm==2){
        cnvsWrite("rgb(0,255,0)",flowChartFontSize,"Arial",Xcoord[3]+4,Ycoord[3]+15,"A");
        cnvsWrite("rgb(255,0,0)",flowChartFontSize,"Arial",Xcoord[2]+4,Ycoord[2]-2,"Ψ");
    }
    else{
        cnvsWrite("rgb(255,0,0)",flowChartFontSize,"Arial",Xcoord[3]+4,Ycoord[3]+15,"Ψ");
        cnvsWrite("rgb(0,255,0)",flowChartFontSize,"Arial",Xcoord[2]+4,Ycoord[2]-2,"A");
    }
    return SideA;
}

function drawRectangle(RectType,Xc,Yc,i,SimulationSwitch){
    var StringToDraw;
    var RectBorder=5;
    var SideA=cntx.measureText(ChartLabels[i]).width;
    var SideB=24;
    var lft=Xc-SideA/2,tp=Yc-SideB;
    var Xcoord=[0,0,0,0,0];
    var Ycoord=[0,0,0,0,0];
    var FillColor,BorderColor,TextColor;
    if(i<=SimulationStep && SimulationSwitch){
        FillColor=Vivid;
        BorderColor="rgb(0,0,255)";
        TextColor="rgb(0,0,255)";
    }
    else{
        FillColor=Fade;
        BorderColor="rgb(0,0,0)";
        TextColor="rgb(0,0,0)";
    }

    if(RectType==1){
        Xcoord[0]=lft-RectBorder;
        Ycoord[0]=tp;
        Xcoord[1]=lft+RectBorder+SideA;
        Ycoord[1]=Ycoord[0];
        Xcoord[2]=Xcoord[1];
        Ycoord[2]=tp+SideB;
        Xcoord[3]=Xcoord[0];
        Ycoord[3]=Ycoord[2];
        Xcoord[4]=lft-RectBorder;
        Ycoord[4]=tp;
        fillPolygon(Xcoord,Ycoord,5,FillColor);
        drawPolygon(Xcoord,Ycoord,5,BorderColor);
    }
    else{
        Xcoord[0]=lft-RectBorder;
        Ycoord[0]=tp;
        Xcoord[1]=lft+RectBorder+SideA+parseInt(SideB*Math.cos(Math.PI/4));
        Ycoord[1]=Ycoord[0];
        Xcoord[2]=lft+RectBorder+SideA;
        Ycoord[2]=tp+SideB;
        Xcoord[3]=lft-RectBorder-parseInt(SideB*Math.cos(Math.PI/4));
        Ycoord[3]=Ycoord[2];
        Xcoord[4]=lft-RectBorder;
        Ycoord[4]=tp;
        fillPolygon(Xcoord,Ycoord,5,FillColor);
        drawPolygon(Xcoord,Ycoord,5,BorderColor);
    }
    cnvsWrite(TextColor,flowChartFontSize,"Arial",lft,tp+2*SideB/3,ChartLabels[i]);
    if(i<=SimulationStep){
        var ScreenLine=TopScreenLine;
        if(SelectedAlgorithm<3){
            if(i==1){
                cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Δώσε α");
            }
            ScreenLine=ScreenLine+20;
            if(i==2){
                if(SimulationStep==2){
                    //$("#cmdNextStep").attr("disabled",true);
                    $("#cmdNextStep").hide();
                    if(CursorOn) {
                        StringToDraw=UserInput+"_";
                    }
                    else{
                        StringToDraw=UserInput;
                    }
                    CursorOn=!CursorOn;
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,StringToDraw);
                }
                else{
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,No1);
                }
            }
            ScreenLine=ScreenLine+20;
            if(i==3){
                cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Δώσε β");
            }
            ScreenLine=ScreenLine+20;
            if(i==4){
                if(SimulationStep==4){
                    //$("#cmdNextStep").attr("disabled",true);
                    $("#cmdNextStep").hide();
                    if(CursorOn){
                        StringToDraw=UserInput+"_";
                    }
                    else{
                        StringToDraw=UserInput;
                    }
                    CursorOn=!CursorOn;
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,StringToDraw);
                }
                else{
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,No2);
                }
            }
            ScreenLine=ScreenLine+20;
            if(SelectedAlgorithm==1 && i==6){
                cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,No1*No2);
            }
            if(SelectedAlgorithm==2){
                if(No2!=0 && SimulationStep>=7){
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,parseInt(decimals*No1/No2)/decimals);
                }
                else if(No2==0 && SimulationStep>=9){
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Διαίρεση Αδύνατη");
                }
            }
        }
        else if(SelectedAlgorithm==3){
            if(i==6){
                //ΓΡΑΨΕ I/O προηγούμενων επαναλήψεων
                if(SimulationStep==6 || SimulationStep==7){
                    for(var j=0;j<ForCounter;j++){
                        cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Δώσε x");
                        ScreenLine=ScreenLine+20;
                        cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,Number[j]);
                        ScreenLine=ScreenLine+20;
                    }
                }
                //ΓΡΑΨΕ I/O τρέχουσας επανάληψης
                cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Δώσε x");
            }
            if(i==7){
                ScreenLine=ScreenLine+20+40*(ForCounter);
                if(SimulationStep==7){
                    //$("#cmdNextStep").attr("disabled",true);
                    $("#cmdNextStep").hide();
                    if(CursorOn) {
                        StringToDraw=UserInput+"_";
                    }
                    else{
                        StringToDraw=UserInput;
                    }
                    CursorOn=!CursorOn;
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,StringToDraw);
                }
                else if(SimulationStep<7){
                    cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,Number[ForCounter]);
                }
            }
            if(i==8){
                var Last_j;
                if(SimulationStep==8){
                    Last_j=Math.min(ForCounter+1,MaxLoopValue);
                }
                else{
                    Last_j=Math.min(ForCounter,MaxLoopValue);
                }
                    for(var j=0;j<Last_j;j++){
                        cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,"Δώσε x");
                        ScreenLine=ScreenLine+20;
                        cnvsWrite(userScreenColor,userInputFontSize,"Arial",450,ScreenLine,Number[j]);
                        ScreenLine=ScreenLine+20;
                    }
                Sum=0;
                for(var j=0;j<ForCounter;j++) Sum=Sum+Number[j];
            }
            if(i==9 && SimulationStep==9 && ForCounter<MaxLoopValue) ForCounter++;
        }
        cntx.strokeStyle=BorderColor;
    }
}

function fillPolygon(X,Y,noOfPoints,fillColor){
    cntx.fillStyle=fillColor;
    cntx.beginPath();
    cntx.moveTo(X[noOfPoints],Y[noOfPoints]);
    for(var ii=0;ii<noOfPoints;ii++){
        cntx.lineTo(X[ii],Y[ii]);
    }
    cntx.fill();
}

function drawPolygon(X,Y,noOfPoints,drawColor){
    cntx.strokeStyle=drawColor;
    cntx.beginPath();
    cntx.moveTo(X[noOfPoints],Y[noOfPoints]);
    for(var ii=0;ii<noOfPoints;ii++){
        cntx.lineTo(X[ii],Y[ii]);
    }
    cntx.stroke();
}