var canvas;
var cntx;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}
      
function initialiseEvents(){
    $("#visualisation").contextmenu(function(evt){
        evt.preventDefault();
        evt.stopPropagation();
    });

    $("#visualisation").on("mousedown touchstart",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });

    $("#visualisation").on("mousemove",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp(evt.which);
    });

    $("#visualisation").on("keydown",function(evt){
        handleKeyDown(evt.keyCode);
    });

    window.addEventListener("beforeunload",function(e){
        clearInterval(timerLoop);
    });
} 

function initialiseGUI(){
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");

    chkShowAlgorithm=new chkbox(cntx,chkShowAlgorithmLEFT,chkShowAlgorithmTOP,"Εμφάνιση Αλγόριθμου",false);
    chkShowGrid=new chkbox(cntx,chkShowGridLEFT,chkShowGridTOP,"Σχεδίαση Πλέγματος",false);
    chkShowRAM=new chkbox(cntx,chkShowRAMLEFT,chkShowRAMTOP,"Περιεχόμενα Μνήμης",false);

    //listbox
    $("#algorithmSlctr").append("<option value='user' selected='selected'>(χρήστης)</option>");
    if(SimpleVersion){
        $("#algorithmSlctr").append("<option value='line'>Γραμμή</option>");
        $("#algorithmSlctr").append("<option value='circle'>Κύκλος</option>");
        $("#algorithmSlctr").append("<option value='rays'>Ακτίνες</option>");
        $("#algorithmSlctr").append("<option value='rombus'>Ρόμβοι</option>");
        $("#algorithmSlctr").append("<option value='lighthouse'>Φάρος</option>");
        $("#algorithmSlctr").append("<option value='explosion'>Έκρηξη</option>");
    }
    else{
        $("#algorithmSlctr").append("<option value='square'>Τετράγωνα</option>");
        $("#algorithmSlctr").append("<option value='rombus1'>Ρόμβοι 1</option>");
        $("#algorithmSlctr").append("<option value='ray'>Ακτίνες</option>");
        $("#algorithmSlctr").append("<option value='rombus2'>Ρόμβοι 2</option>");
        $("#algorithmSlctr").append("<option value='lighthouse'>Φάρος</option>");
        $("#algorithmSlctr").append("<option value='star'>Αστέρι</option>");
    }
    $("#algorithmSlctr").append("<option value='cocentric'>Ομόκεντροι</option>");
    $("#algorithmSlctr").append("<option value='pattern'>Μοτίβο</option>");
    $("#algorithmSlctr").append("<option value='doppler'>Doppler</option>");
    $("#algorithmSlctr").append("<option value='impact'>Κρουστικό</option>");
}

function initialValues(){
    $("#resolutionSlctr").val("800x600");
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;

    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
    
    introStep=firstIntroStep;
    LoadIntroImage();
	InitAlgoCommands();
	InitialisePalette();
}

function drawBasicScreen(){
	var promptYCoord=BottomPanelTop+13;
    cntx.clearRect(0,0,width,height);
    drawIntroImage();
    drawLogoImage();
    if(introStep==5){
    	chkShowRAM.render();
    	chkShowAlgorithm.render();
    	chkShowGrid.render();
    	$("#simTools").show();
    	$("#divAlgorithmSlctr").show();
    }
    else{
    	$("#simTools").hide();
    	$("#divAlgorithmSlctr").hide();
    }
    if(introStep==4){
    	$("#editTools").show();
    }
    else{
    	$("#editTools").hide();
    }

    if(introStep==5){
        if(Drawing && !StepByStepSimulation){
            $("#cmdSimulate").prop("disabled",true);
            //$("#cmdNextStep").prop("disabled",true);
        }
        else{
            $("#cmdSimulate").prop("disabled",false);
            if(chkShowAlgorithm.value){
                $("#cmdNextStep").prop("disabled",false);                   
            }
            else{
                $("#cmdNextStep").prop("disabled",true);
            }
        }
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Χρησιμοποίησε τα κουμπιά [Έναρξη] ή [Επόμενο Βήμα] για να δεις το αποτέλεσμα.");
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord+20,"Διάλεξε άλλα παραδείγματα από τη λίστα και προσπάθησε να συνθέσεις τους αντίστοιχους αλγόριθμους.");
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord+40,"Αν δυσκολευτείς χρησιμοποίησε το διακόπτη [Εμφάνιση Αλγόριθμου].");

        if(chkShowAlgorithm.value){
            if(SelectedAlgorithm>0){
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord+60,"Μπορείς να τροποποιήσεις τις εντολές πατώντας [Επεξεργασία Αλγόριθμου].");
            }
            else{
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord+60,"Μπορείς να τροποποιήσεις τις εντολές επιστρέφοντας στο προηγούμενο βήμα.");
            }
        }
        if(chkShowGrid.value) DrawCartesian();
        if(chkShowRAM.value) ShowRAM();
        if(AlgoRunning){
            runAlgo();
        }
        else{
            if(chkShowAlgorithm.value)ShowAlgo(-1);
        }
    }
    else if(introStep==4){
        if(PaletteVisible)DrawPalette();
        if(WaitingForUserInput){
            if(AlgoStep[PointedAtCommandIndex][0]==ColorCmdIndex){
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Κάνε κλικ σε ένα χρώμα της παλέτας ή πληκτρολόγησε τον κωδικό του χρώματος (0-15)");
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord+15,"και πάτησε enter για να συνεχίσεις τη σύνθεση του αλγόριθμου.");
            }
            else{
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Πάτησε enter για να συνεχίσεις τη σύνθεση του αλγόριθμου.");
            }
        }
        else{
            cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Κάνε κλικ στις Διαθέσιμες Εντολές για να συνθέσεις τον αλγόριθμό σου (το πολύ "+NoOfAlgoSteps+" εντολές).");
            promptYCoord=promptYCoord+15;
            cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Κάνε κλικ σε εντολή του αλγόριθμου για να συμπληρώσεις την παράμετρό της ή δεξί κλικ για διαγραφή.");
            promptYCoord=promptYCoord+15;
            if(CurrentAlgoSteps>1){
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Άλλαξε τη σειρά των εντολών σύροντάς τες με το ποντίκι σου.");
            }
            else{
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Όταν θα έχεις έναν πλήρη αλγόριθμο θα μπορέσεις να πας στο επόμενο βήμα για να τον 'τρέξεις'.");
            }
            promptYCoord=promptYCoord+15;
            if(CurrentAlgoSteps>VisibleAlgoLines){
                cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Κάνε κλικ στη βάση (στην κορυφή) του χαρτιού για να το (ξε)τυλίξεις.");
                promptYCoord=promptYCoord+15;
            }
        }
        ShowAvailableCommands();
        ShowAlgo(-1);
        if(AlgoReadyToRun && CurrentAlgoSteps>0 && !WaitingForUserInput){
            cnvsWrite("rgb(0,0,255)",fontSize,"Arial",50,promptYCoord,"Μπορείς να δεις το αποτέλεσμα του αλγόριθμού σου στην επόμενη οθόνη.");
        }
        if(!WaitingForUserInput && isButtonPressed && cmdToMove>-1){
            var colorToUse="";
            if(mx>=ProgramLeft && mx<=ProgramRight){
                colorToUse="rgb(150,150,150)";
            }
            else{
                colorToUse="rgb(220,220,220)";
            }
            if(my>=ProgramTop && my<=ProgramBottom){
                cnvsWrite(colorToUse,fontSize,"Arial",mx,my,AlgoCommand[AlgoStep[cmdToMove][0]]);
            }
        }
    }
    else{
        if(introStep==3) DrawCartesian();
    }    

    if(introStep<4 || (introStep==4 && AlgoReadyToRun && !WaitingForUserInput)){
        drawButtonNext();
    }
    if(introStep>firstIntroStep && !Drawing){
        drawButtonBack();
    }
    $("#visualisation").focus();
}

function drawIntroImage(){
    var picTop=(height-intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
    cntx.drawImage(intro,1,TopPanelHeight+1);
}

function drawLogoImage(){
    cntx.drawImage(imgLogo,logoLeft,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    if(fontName!=""){
    	cntx.font=fontSize+"px "+fontName;
    }
    if(clr!=""){
    	cntx.fillStyle=clr;
    }
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){
	isButtonPressed=true;
	if(introStep==4 && !WaitingForUserInput){
		if(PointedAtCommandIndex>-1){
			cmdToMove=PointedAtCommandIndex;
			cmdMoveStartY=my;
		}
		else{
			cmdToMove=-1;
		}
	}
	drawBasicScreen();
}

function handleMouseMove(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    
    canvas.style.cursor="default";
    
    if(chkShowRAM.hover(mx,my)){
        canvas.style.cursor="pointer";
    }
    
    if(chkShowAlgorithm.hover(mx,my)){
        canvas.style.cursor="pointer";
    }
    
    if(chkShowGrid.hover(mx,my)){
        canvas.style.cursor="pointer";
    }
    if(introStep>=4){
        //Κύληση φύλλου αλγορίθμου
        if(!WaitingForUserInput && mx>=10 && mx<=254){
            if(my>=90 && my<=105 && CurrentAlgoSteps>VisibleAlgoLines && FirstVisibleLine>0){
                canvas.style.cursor="n-resize";
                PointedAtCommandIndex=-1;
            }
            else if(my>450 && my<=465 && CurrentAlgoSteps>VisibleAlgoLines && FirstVisibleLine+VisibleAlgoLines<=CurrentAlgoSteps-1){
                canvas.style.cursor="ne-resize";
                PointedAtCommandIndex=-1;
            }
            else if(introStep==4 && !WaitingForUserInput){
                // Κατάδειξη εντολής αλγορίθμου και τροποποίηση του δείκτη ποντικιού
                // ανάλογα με το αν η εντολή απαιτεί παράμετρο ή όχι
                if(AlgoCommandHover(false)>-1){
                    canvas.style.cursor="grab";
                }
            }
        }
        else if(!WaitingForUserInput && introStep==4){
            //Κατάδειξη διαθέσιμων εντολών με τροποποίηση του δείκτη ποντικιού
            AvailableCommandHover();
            if(AvailableCommandIndex>-1){
                canvas.style.cursor="grab";
            }
        }
        else if(PaletteVisible && introStep==4){
            if(PaletteHover()){
                canvas.style.cursor="grab";
            }
        }
    }
    drawBasicScreen();
    //console.log("mx="+mx+" , my="+my+" ,infoSwitchHover="+infoSwitchHover+" ,coordSwitchHover="+coordSwitchHover);
}

function handleMouseUp(mouseButton){
	isButtonPressed=false;
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight){
        showHTML();
    }
    if (mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && (introStep<4 || introStep==4 && AlgoReadyToRun && !WaitingForUserInput)) {
        introStep++;
        LoadIntroImage();
    }
    if (mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && introStep>1 && !WaitingForUserInput && !Drawing) {
        introStep--;
        LoadIntroImage();
    }
    
    if(chkShowRAM.hovering){
        chkShowRAM.toggleValue();
        itemStateChanged(chkShowRAMIndx);
    }
    if(chkShowAlgorithm.hovering){
        chkShowAlgorithm.toggleValue();
        itemStateChanged(chkShowAlgorithmIndx);
    }
    if(chkShowGrid.hovering){
        chkShowGrid.toggleValue();
        itemStateChanged(chkShowGridIndx);
    }
    //Κύληση φύλλου αλγορίθμου
	  if(!WaitingForUserInput && introStep>=introSteps-2 && mx>=10 && mx<=254 && CurrentAlgoSteps>0){
		  if(my>=90 && my<=105){
			  FirstVisibleLine=Math.max(FirstVisibleLine-1,0);
		  }
		  if(my>=450 && my<=465){
			  FirstVisibleLine=Math.min(FirstVisibleLine+1,Math.max(CurrentAlgoSteps-VisibleAlgoLines,0));
		  }
	  }
	  //Επιλογή από τη λίστα διαθέσιμων εντολών
	  if(introStep==4 && !WaitingForUserInput){
		  if(cmdToMove>-1 && cmdMoveStartY!=my){
			  MoveCommand();
		  }
		  else{
			  AvailableCommandHover();
			  if(AvailableCommandIndex>-1 && !MemoryFull){
				  AlgoStep[CurrentAlgoSteps][0]=AvailableCommandIndex;
				  AlgoParam[CurrentAlgoSteps][0]="...";
				  CurrentAlgoSteps++;
				  UserAlgoSteps=CurrentAlgoSteps;
				  if(CurrentAlgoSteps==NoOfAlgoSteps) MemoryFull=true;
				  //Αυτόματη ολίσθηση του φύλλου σε περίπτωση προσθήκης εντολής εκτός ορατών ορίων
				  if(CurrentAlgoSteps-FirstVisibleLine>VisibleAlgoLines) FirstVisibleLine++;
			  }
			  else{
				  if(AlgoCommandHover(true)>-1 && mouseButton==3){
					  DeleteAlgoCommand();
				  }
				  else if(!WaitingForUserInput && AlgoCommandHover(true)>-1 && mouseButton==1){
					  if(CmdRequiresParam[AlgoStep[PointedAtCommandIndex][0]]){
						  if(AlgoStep[PointedAtCommandIndex][0]==ColorCmdIndex){
							  PaletteVisible=true;
							  if(AlgoParam[PointedAtCommandIndex][0]!="..."){
								  SelectedColorIndex=parseInt(AlgoParam[PointedAtCommandIndex][0]);
							  }
							  else{
								  SelectedColorIndex=-1;
							  }
						  }
						  else{
							  PaletteVisible=false;
						  }
						  $("#visualisation").focus();
						  if(AlgoParam[PointedAtCommandIndex][0]=="..."){
							  UserInput="";
						  }
						  else{
							  UserInput=AlgoParam[PointedAtCommandIndex][0];
						  }
						  WaitingForUserInput=true;
						  Drawing=true;
						  timerLoop=setInterval(function(){run();},simSpeed);
					  }
				  }
			  }			  
		  }
	  }
	  else{
		  if(introStep==4 && WaitingForUserInput && PaletteHover()){
			  SelectPaletteColor();
			  UserInput=""+SelectedColorIndex;
		  }
	  }
    drawBasicScreen();
}

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if(buttonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function buttonNextHover(){
    if(mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else{
        return false;
    }
}

function drawButtonBack(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if(buttonBackHover()){
        cntx.drawImage(imgBackStepSelected,BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled,BackStepLeft,BackStepTop);
    }
}

function buttonBackHover(){
    if(mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else{
        return false;
    }
}

//*******************************************************************
function InitAlgoCommands(){
	  AlgoCommand[0]="x1 = ";
	  AlgoCommand[1]="y1 = ";
	  AlgoCommand[2]="x2 = ";
	  AlgoCommand[3]="y2 = ";
	  AlgoCommand[4]="R = ";
	  AlgoCommand[5]="ΕΠΑΝΑΛΑΒΕ ";
	  AlgoCommand[6]="ΓΡΑΜΜΗ (x1,y1,x2,y2)";
	  AlgoCommand[7]="ΚΥΚΛΟΣ (x1,y1),R";
	  AlgoCommand[8]="x1 = x1 +";
	  AlgoCommand[9]="y1 = y1 +";
	  AlgoCommand[10]="x2 = x2 +";
	  AlgoCommand[11]="y2 = y2 +";
	  AlgoCommand[12]="R = R +";
	  AlgoCommand[13]="]";
	  AlgoCommand[14]="ΧΡΩΜΑ ";

	  CmdRequiresParam[0]=true;
	  CmdRequiresParam[1]=true;
	  CmdRequiresParam[2]=true;
	  CmdRequiresParam[3]=true;
	  CmdRequiresParam[4]=true;
	  CmdRequiresParam[5]=true;
	  CmdRequiresParam[6]=false;
	  CmdRequiresParam[7]=false;
	  CmdRequiresParam[8]=true;
	  CmdRequiresParam[9]=true;
	  CmdRequiresParam[10]=true;
	  CmdRequiresParam[11]=true;
	  CmdRequiresParam[12]=true;
	  CmdRequiresParam[13]=false;
	  CmdRequiresParam[14]=true;
}

function SelectAlgorithm(){
	  if(SelectedAlgorithm==0){
		  CurrentAlgoSteps=UserAlgoSteps;
	  }
	  else if  (SelectedAlgorithm==1){
		  InitSquares();
	  }
	  else if  (SelectedAlgorithm==2){
		  InitRhombus1();
	  }
	  else if  (SelectedAlgorithm==3){
		  InitRays();
	  }
	  else if  (SelectedAlgorithm==4){
		  InitRhombus2();
	  }
	  else if  (SelectedAlgorithm==5){
		  InitLightHouse();
	  }
	  else if  (SelectedAlgorithm==6){
		  InitAlgoStar();
	  }
	  else if  (SelectedAlgorithm==7){
		  InitAlgoSameCenter();
	  }
	  else if  (SelectedAlgorithm==8){
		  InitAlgoPattern();
	  }
	  else if  (SelectedAlgorithm==9){
		  InitAlgoDoppler();
	  }
	  else if  (SelectedAlgorithm==10){
		  InitAlgoSound();
	  }
}

function InitSquares(){
	  if(SimpleVersion){
		  AlgoStep[0][1]=0;
		  AlgoStep[1][1]=1;
		  AlgoStep[2][1]=2;
		  AlgoStep[3][1]=3;
		  AlgoStep[4][1]=6;
		  
		  AlgoParam[0][1]="-100";
		  AlgoParam[1][1]="100";
		  AlgoParam[2][1]="100";
		  AlgoParam[3][1]="-100";
		  AlgoParam[4][1]="...";
		  
		  CurrentAlgoSteps=5;
	  }
	  else{
		  //Πάνω πλευρά
		  AlgoStep[0][1]=0;
		  AlgoStep[1][1]=1;
		  AlgoStep[2][1]=2;
		  AlgoStep[3][1]=3;
		  AlgoStep[4][1]=5;
		  AlgoStep[5][1]=6;
		  AlgoStep[6][1]=8;
		  AlgoStep[7][1]=9;
		  AlgoStep[8][1]=10;
		  AlgoStep[9][1]=11;
		  AlgoStep[10][1]=13;
		  
		  AlgoParam[0][1]="-100";
		  AlgoParam[1][1]="100";
		  AlgoParam[2][1]="100";
		  AlgoParam[3][1]="100";
		  AlgoParam[4][1]="5";
		  AlgoParam[5][1]="...";
		  AlgoParam[6][1]="20";
		  AlgoParam[7][1]="-20";
		  AlgoParam[8][1]="-20";
		  AlgoParam[9][1]="-20";
		  AlgoParam[10][1]="...";
		  
		  //Αριστερή πλευρά
		  AlgoStep[11][1]=0;
		  AlgoStep[12][1]=1;
		  AlgoStep[13][1]=2;
		  AlgoStep[14][1]=3;
		  AlgoStep[15][1]=5;
		  AlgoStep[16][1]=6;
		  AlgoStep[17][1]=8;
		  AlgoStep[18][1]=9;
		  AlgoStep[19][1]=10;
		  AlgoStep[20][1]=11;
		  AlgoStep[21][1]=13;
		  
		  AlgoParam[11][1]="-100";
		  AlgoParam[12][1]="100";
		  AlgoParam[13][1]="-100";
		  AlgoParam[14][1]="-100";
		  AlgoParam[15][1]="5";
		  AlgoParam[16][1]="...";
		  AlgoParam[17][1]="20";
		  AlgoParam[18][1]="-20";
		  AlgoParam[19][1]="20";
		  AlgoParam[20][1]="20";
		  AlgoParam[21][1]="...";
		  
		  //Δεξιά πλευρά
		  AlgoStep[22][1]=0;
		  AlgoStep[23][1]=1;
		  AlgoStep[24][1]=2;
		  AlgoStep[25][1]=3;
		  AlgoStep[26][1]=5;
		  AlgoStep[27][1]=6;
		  AlgoStep[28][1]=8;
		  AlgoStep[29][1]=9;
		  AlgoStep[30][1]=10;
		  AlgoStep[31][1]=11;
		  AlgoStep[32][1]=13;
		  
		  AlgoParam[22][1]="100";
		  AlgoParam[23][1]="100";
		  AlgoParam[24][1]="100";
		  AlgoParam[25][1]="-100";
		  AlgoParam[26][1]="5";
		  AlgoParam[27][1]="...";
		  AlgoParam[28][1]="-20";
		  AlgoParam[29][1]="-20";
		  AlgoParam[30][1]="-20";
		  AlgoParam[31][1]="20";
		  AlgoParam[32][1]="...";
		  
		  //Κάτω πλευρά
		  AlgoStep[33][1]=0;
		  AlgoStep[34][1]=1;
		  AlgoStep[35][1]=2;
		  AlgoStep[36][1]=3;
		  AlgoStep[37][1]=5;
		  AlgoStep[38][1]=6;
		  AlgoStep[39][1]=8;
		  AlgoStep[40][1]=9;
		  AlgoStep[41][1]=10;
		  AlgoStep[42][1]=11;
		  AlgoStep[43][1]=13;
		  
		  AlgoParam[33][1]="-100";
		  AlgoParam[34][1]="-100";
		  AlgoParam[35][1]="100";
		  AlgoParam[36][1]="-100";
		  AlgoParam[37][1]="5";
		  AlgoParam[38][1]="...";
		  AlgoParam[39][1]="20";
		  AlgoParam[40][1]="20";
		  AlgoParam[41][1]="-20";
		  AlgoParam[42][1]="20";
		  AlgoParam[43][1]="...";
		  
		  CurrentAlgoSteps=44;
	  }
}

function InitRhombus1(){
	  if(SimpleVersion){
		  AlgoStep[0][2]=0;
		  AlgoStep[1][2]=1;
		  AlgoStep[2][2]=4;
		  AlgoStep[3][2]=7;
		  
		  AlgoParam[0][2]="0";
		  AlgoParam[1][2]="0";
		  AlgoParam[2][2]="50";
		  AlgoParam[3][2]="...";
		  
		  CurrentAlgoSteps=4;
	  }
	  else{
		  //Πάνω αριστερά
		  AlgoStep[0][2]=0;
		  AlgoStep[1][2]=1;
		  AlgoStep[2][2]=2;
		  AlgoStep[3][2]=3;
		  AlgoStep[4][2]=5;
		  AlgoStep[5][2]=6;
		  AlgoStep[6][2]=8;
		  AlgoStep[7][2]=11;
		  AlgoStep[8][2]=13;
		  
		  AlgoParam[0][2]="-100";
		  AlgoParam[1][2]="0";
		  AlgoParam[2][2]="0";
		  AlgoParam[3][2]="100";
		  AlgoParam[4][2]="10";
		  AlgoParam[5][2]="...";
		  AlgoParam[6][2]="10";
		  AlgoParam[7][2]="-10";
		  AlgoParam[8][2]="...";
		  
		  //Κάτω αριστερά
		  AlgoStep[9][2]=0;
		  AlgoStep[10][2]=1;
		  AlgoStep[11][2]=2;
		  AlgoStep[12][2]=3;
		  AlgoStep[13][2]=5;
		  AlgoStep[14][2]=6;
		  AlgoStep[15][2]=8;
		  AlgoStep[16][2]=11;
		  AlgoStep[17][2]=13;
		  
		  AlgoParam[9][2]="-100";
		  AlgoParam[10][2]="0";
		  AlgoParam[11][2]="0";
		  AlgoParam[12][2]="-100";
		  AlgoParam[13][2]="10";
		  AlgoParam[14][2]="...";
		  AlgoParam[15][2]="10";
		  AlgoParam[16][2]="10";
		  AlgoParam[17][2]="...";
		  
		  //Πάνω δεξιά
		  AlgoStep[18][2]=0;
		  AlgoStep[19][2]=1;
		  AlgoStep[20][2]=2;
		  AlgoStep[21][2]=3;
		  AlgoStep[22][2]=5;
		  AlgoStep[23][2]=6;
		  AlgoStep[24][2]=8;
		  AlgoStep[25][2]=11;
		  AlgoStep[26][2]=13;
		  
		  AlgoParam[18][2]="100";
		  AlgoParam[19][2]="0";
		  AlgoParam[20][2]="0";
		  AlgoParam[21][2]="100";
		  AlgoParam[22][2]="10";
		  AlgoParam[23][2]="...";
		  AlgoParam[24][2]="-10";
		  AlgoParam[25][2]="-10";
		  AlgoParam[26][2]="...";
		  
		  //Κάτω δεξιά
		  AlgoStep[27][2]=0;
		  AlgoStep[28][2]=1;
		  AlgoStep[29][2]=2;
		  AlgoStep[30][2]=3;
		  AlgoStep[31][2]=5;
		  AlgoStep[32][2]=6;
		  AlgoStep[33][2]=8;
		  AlgoStep[34][2]=11;
		  AlgoStep[35][2]=13;
		  
		  AlgoParam[27][2]="100";
		  AlgoParam[28][2]="0";
		  AlgoParam[29][2]="0";
		  AlgoParam[30][2]="-100";
		  AlgoParam[31][2]="10";
		  AlgoParam[32][2]="...";
		  AlgoParam[33][2]="-10";
		  AlgoParam[34][2]="10";
		  AlgoParam[35][2]="...";
		  
		  CurrentAlgoSteps=36;
	  }
}

function InitRays(){
	  AlgoStep[0][3]=0;
	  AlgoStep[1][3]=1;
	  AlgoStep[2][3]=2;
	  AlgoStep[3][3]=3;
	  AlgoStep[4][3]=5;
	  AlgoStep[5][3]=6;
	  AlgoStep[6][3]=10;
	  AlgoStep[7][3]=13;

	  AlgoParam[0][3]="0";
	  AlgoParam[1][3]="100";
	  AlgoParam[2][3]="-100";
	  AlgoParam[3][3]="0";
	  AlgoParam[4][3]="100";
	  AlgoParam[5][3]="...";
	  AlgoParam[6][3]="2";
	  AlgoParam[7][3]="...";

	  CurrentAlgoSteps=8;
}

function InitRhombus2(){
	  AlgoStep[0][4]=0;
	  AlgoStep[1][4]=1;
	  AlgoStep[2][4]=2;
	  AlgoStep[3][4]=3;
	  AlgoStep[4][4]=5;
	  AlgoStep[5][4]=6;
	  AlgoStep[6][4]=8;
	  AlgoStep[7][4]=13;

	  AlgoParam[0][4]="-100";
	  AlgoParam[1][4]="0";
	  AlgoParam[2][4]="0";
	  AlgoParam[3][4]="100";
	  AlgoParam[4][4]="11";
	  AlgoParam[5][4]="...";
	  AlgoParam[6][4]="20";
	  AlgoParam[7][4]="...";

	  AlgoStep[8][4]=0;
	  AlgoStep[9][4]=1;
	  AlgoStep[10][4]=2;
	  AlgoStep[11][4]=3;
	  AlgoStep[12][4]=5;
	  AlgoStep[13][4]=6;
	  AlgoStep[14][4]=8;
	  AlgoStep[15][4]=13;

	  AlgoParam[8][4]="-100";
	  AlgoParam[9][4]="0";
	  AlgoParam[10][4]="0";
	  AlgoParam[11][4]="-100";
	  AlgoParam[12][4]="11";
	  AlgoParam[13][4]="...";
	  AlgoParam[14][4]="20";
	  AlgoParam[15][4]="...";
	  
	  CurrentAlgoSteps=16;
}

function InitLightHouse(){
	  AlgoStep[0][5]=0;
	  AlgoStep[1][5]=1;
	  AlgoStep[2][5]=2;
	  AlgoStep[3][5]=3;
	  AlgoStep[4][5]=5;
	  AlgoStep[5][5]=6;
	  AlgoStep[6][5]=9;
	  AlgoStep[7][5]=13;

	  AlgoParam[0][5]="-100";
	  AlgoParam[1][5]="100";
	  AlgoParam[2][5]="0";
	  AlgoParam[3][5]="0";
	  AlgoParam[4][5]="11";
	  AlgoParam[5][5]="...";
	  AlgoParam[6][5]="-20";
	  AlgoParam[7][5]="...";
	  
	  AlgoStep[8][5]=0;
	  AlgoStep[9][5]=1;
	  AlgoStep[10][5]=2;
	  AlgoStep[11][5]=3;
	  AlgoStep[12][5]=5;
	  AlgoStep[13][5]=6;
	  AlgoStep[14][5]=9;
	  AlgoStep[15][5]=13;

	  AlgoParam[8][5]="100";
	  AlgoParam[9][5]="100";
	  AlgoParam[10][5]="0";
	  AlgoParam[11][5]="0";
	  AlgoParam[12][5]="11";
	  AlgoParam[13][5]="...";
	  AlgoParam[14][5]="-20";
	  AlgoParam[15][5]="...";
	  
	  CurrentAlgoSteps=16;
}

function InitAlgoStar(){
	  if(SimpleVersion){
		  AlgoStep[0][6]=0;
		  AlgoStep[1][6]=1;
		  AlgoStep[2][6]=2;
		  AlgoStep[3][6]=3;
		  AlgoStep[4][6]=5;
		  AlgoStep[5][6]=6;
		  AlgoStep[6][6]=8;
		  AlgoStep[7][6]=9;
		  AlgoStep[8][6]=10;
		  AlgoStep[9][6]=11;
		  AlgoStep[10][6]=13;
		  
		  AlgoParam[0][6]="-100";
		  AlgoParam[1][6]="-50";
		  AlgoParam[2][6]="100";
		  AlgoParam[3][6]="50";
		  AlgoParam[4][6]="10";
		  AlgoParam[5][6]="0";
		  AlgoParam[6][6]="20";
		  AlgoParam[7][6]="20";
		  AlgoParam[8][6]="-20";
		  AlgoParam[9][6]="-20";
		  AlgoParam[10][6]="0";
		  
		  CurrentAlgoSteps=11;
	  }
	  else{
		  //Πάνω αριστερά
		  AlgoStep[0][6]=0;
		  AlgoStep[1][6]=1;
		  AlgoStep[2][6]=2;
		  AlgoStep[3][6]=3;
		  AlgoStep[4][6]=5;
		  AlgoStep[5][6]=6;
		  AlgoStep[6][6]=8;
		  AlgoStep[7][6]=11;
		  AlgoStep[8][6]=13;
		  
		  AlgoParam[0][6]="-100";
		  AlgoParam[1][6]="0";
		  AlgoParam[2][6]="0";
		  AlgoParam[3][6]="0";
		  AlgoParam[4][6]="11";
		  AlgoParam[5][6]="0";
		  AlgoParam[6][6]="10";
		  AlgoParam[7][6]="10";
		  AlgoParam[8][6]="0";
		  
		  //Κάτω αριστερά
		  AlgoStep[9][6]=0;
		  AlgoStep[10][6]=1;
		  AlgoStep[11][6]=2;
		  AlgoStep[12][6]=3;
		  AlgoStep[13][6]=5;
		  AlgoStep[14][6]=6;
		  AlgoStep[15][6]=8;
		  AlgoStep[16][6]=11;
		  AlgoStep[17][6]=13;
		  
		  AlgoParam[9][6]="-100";
		  AlgoParam[10][6]="0";
		  AlgoParam[11][6]="0";
		  AlgoParam[12][6]="0";
		  AlgoParam[13][6]="11";
		  AlgoParam[14][6]="0";
		  AlgoParam[15][6]="10";
		  AlgoParam[16][6]="-10";
		  AlgoParam[17][6]="0";
		  
		  //Πάνω δεξιά
		  AlgoStep[18][6]=0;
		  AlgoStep[19][6]=1;
		  AlgoStep[20][6]=2;
		  AlgoStep[21][6]=3;
		  AlgoStep[22][6]=5;
		  AlgoStep[23][6]=6;
		  AlgoStep[24][6]=8;
		  AlgoStep[25][6]=11;
		  AlgoStep[26][6]=13;
		  
		  AlgoParam[18][6]="100";
		  AlgoParam[19][6]="0";
		  AlgoParam[20][6]="0";
		  AlgoParam[21][6]="0";
		  AlgoParam[22][6]="11";
		  AlgoParam[23][6]="0";
		  AlgoParam[24][6]="-10";
		  AlgoParam[25][6]="10";
		  AlgoParam[26][6]="0";
		  
		  //Κάτω δεξιά
		  AlgoStep[27][6]=0;
		  AlgoStep[28][6]=1;
		  AlgoStep[29][6]=2;
		  AlgoStep[30][6]=3;
		  AlgoStep[31][6]=5;
		  AlgoStep[32][6]=6;
		  AlgoStep[33][6]=8;
		  AlgoStep[34][6]=11;
		  AlgoStep[35][6]=13;
		  
		  AlgoParam[27][6]="100";
		  AlgoParam[28][6]="0";
		  AlgoParam[29][6]="0";
		  AlgoParam[30][6]="0";
		  AlgoParam[31][6]="11";
		  AlgoParam[32][6]="0";
		  AlgoParam[33][6]="-10";
		  AlgoParam[34][6]="-10";
		  AlgoParam[35][6]="0";
		  
		  CurrentAlgoSteps=36;
	  }
}

function InitAlgoSameCenter(){
	  AlgoStep[0][7]=0;
	  AlgoStep[1][7]=1;
	  AlgoStep[2][7]=4;
	  AlgoStep[3][7]=5;
	  AlgoStep[4][7]=7;
	  AlgoStep[5][7]=12;
	  AlgoStep[6][7]=13;
	  
	  AlgoParam[0][7]="0";
	  AlgoParam[1][7]="0";
	  AlgoParam[2][7]="200";
	  AlgoParam[3][7]="20";
	  AlgoParam[4][7]="...";
	  AlgoParam[5][7]="-10";
	  AlgoParam[6][7]="...";
	  
	  CurrentAlgoSteps=7;
}

function InitAlgoPattern(){
	  if(SimpleVersion){
		  AlgoStep[0][8]=0;
		  AlgoStep[1][8]=1;
		  AlgoStep[2][8]=4;
		  AlgoStep[3][8]=5;
		  AlgoStep[4][8]=7;
		  AlgoStep[5][8]=12;
		  AlgoStep[6][8]=13;
		  
		  AlgoParam[0][8]="0";
		  AlgoParam[1][8]="0";
		  AlgoParam[2][8]="200";
		  AlgoParam[3][8]="100";
		  AlgoParam[4][8]="...";
		  AlgoParam[5][8]="-2";
		  AlgoParam[6][8]="...";
		  
		  CurrentAlgoSteps=7;
	  }
	  else{
		  AlgoStep[0][8]=0;
		  AlgoStep[1][8]=1;
		  AlgoStep[2][8]=4;
		  AlgoStep[3][8]=5;
		  AlgoStep[4][8]=7;
		  AlgoStep[5][8]=8;
		  AlgoStep[6][8]=9;
		  AlgoStep[7][8]=12;
		  AlgoStep[8][8]=13;
		  
		  AlgoParam[0][8]="0";
		  AlgoParam[1][8]="0";
		  AlgoParam[2][8]="60";
		  AlgoParam[3][8]="5";
		  AlgoParam[4][8]="...";
		  AlgoParam[5][8]="-30";
		  AlgoParam[6][8]="20";
		  AlgoParam[7][8]="-10";
		  AlgoParam[8][8]="...";
		  
		  AlgoStep[9][8]=0;
		  AlgoStep[10][8]=1;
		  AlgoStep[11][8]=4;
		  AlgoStep[12][8]=5;
		  AlgoStep[13][8]=7;
		  AlgoStep[14][8]=8;
		  AlgoStep[15][8]=9;
		  AlgoStep[16][8]=12;
		  AlgoStep[17][8]=13;
		  
		  AlgoParam[9][8]="0";
		  AlgoParam[10][8]="0";
		  AlgoParam[11][8]="60";
		  AlgoParam[12][8]="5";
		  AlgoParam[13][8]="...";
		  AlgoParam[14][8]="30";
		  AlgoParam[15][8]="20";
		  AlgoParam[16][8]="-10";
		  AlgoParam[17][8]="...";

		  AlgoStep[18][8]=0;
		  AlgoStep[19][8]=1;
		  AlgoStep[20][8]=4;
		  AlgoStep[21][8]=5;
		  AlgoStep[22][8]=7;
		  AlgoStep[23][8]=8;
		  AlgoStep[24][8]=9;
		  AlgoStep[25][8]=12;
		  AlgoStep[26][8]=13;
		  
		  AlgoParam[18][8]="0";
		  AlgoParam[19][8]="0";
		  AlgoParam[20][8]="60";
		  AlgoParam[21][8]="5";
		  AlgoParam[22][8]="...";
		  AlgoParam[23][8]="-30";
		  AlgoParam[24][8]="-20";
		  AlgoParam[25][8]="-10";
		  AlgoParam[26][8]="...";
		  
		  AlgoStep[27][8]=0;
		  AlgoStep[28][8]=1;
		  AlgoStep[29][8]=4;
		  AlgoStep[30][8]=5;
		  AlgoStep[31][8]=7;
		  AlgoStep[32][8]=8;
		  AlgoStep[33][8]=9;
		  AlgoStep[34][8]=12;
		  AlgoStep[35][8]=13;
		  
		  AlgoParam[27][8]="0";
		  AlgoParam[28][8]="0";
		  AlgoParam[29][8]="60";
		  AlgoParam[30][8]="5";
		  AlgoParam[31][8]="...";
		  AlgoParam[32][8]="30";
		  AlgoParam[33][8]="-20";
		  AlgoParam[34][8]="-10";
		  AlgoParam[35][8]="...";
		  
		  CurrentAlgoSteps=36;
	  }
}

function InitAlgoDoppler(){
	  AlgoStep[0][9]=0;
	  AlgoStep[1][9]=1;
	  AlgoStep[2][9]=4;
	  AlgoStep[3][9]=5;
	  AlgoStep[4][9]=7;
	  AlgoStep[5][9]=8;
	  AlgoStep[6][9]=12;
	  AlgoStep[7][9]=13;
	  
	  AlgoParam[0][9]="-60";
	  AlgoParam[1][9]="0";
	  AlgoParam[2][9]="120";
	  AlgoParam[3][9]="10";
	  AlgoParam[4][9]="...";
	  AlgoParam[5][9]="20";
	  AlgoParam[6][9]="-10";
	  AlgoParam[7][9]="...";
	  
	  CurrentAlgoSteps=8;
}

function InitAlgoSound(){
	  AlgoStep[0][10]=0;
	  AlgoStep[1][10]=1;
	  AlgoStep[2][10]=4;
	  AlgoStep[3][10]=5;
	  AlgoStep[4][10]=7;
	  AlgoStep[5][10]=8;
	  AlgoStep[6][10]=12;
	  AlgoStep[7][10]=13;
	  
	  AlgoParam[0][10]="-20";
	  AlgoParam[1][10]="0";
	  AlgoParam[2][10]="170";
	  AlgoParam[3][10]="17";
	  AlgoParam[4][10]="...";
	  AlgoParam[5][10]="10";
	  AlgoParam[6][10]="-10";
	  AlgoParam[7][10]="...";
	  
	  CurrentAlgoSteps=8;
}

function ShowAlgo(ShowLine){
    //if(CurrentAlgoSteps==0)return;
    var i,AlgoLineNoX=15,AlgoX=30+AlgoLineNoX,AlgoY=TopPanelHeight+40,CurrentTab=0,TabStep=15;
    var EndingLine=Math.min(CurrentAlgoSteps,FirstVisibleLine+VisibleAlgoLines);
    var LineNoSeparator=":",ShowSign="",StringToShow;
    var CharsToShow;
    AlgoReadyToRun=true;
    //Η πρώτη Επανάληψη διατρέχει τις μη ορατές γραμμές του αλγόριθμου
    // για να υπολογίσει σωστά την εσοχή του κώδικα
    for(i=0;i<FirstVisibleLine;i++){
        if(AlgoStep[i][SelectedAlgorithm]==RepeatCmdIndex){
            CurrentTab=CurrentTab+TabStep;
        }
        else if(AlgoStep[i][SelectedAlgorithm]==EndRepeatCmdIndex){
            CurrentTab=CurrentTab-TabStep;
        }
    }
    //Η δεύτερη Επανάληψη εμφανίζει όσες γραμμές κώδικα
    //χωρούν στο χαρτί ξεκινώντας από την πρώτη ορατή
    for(i=FirstVisibleLine;i<EndingLine;i++){
        //backg.setFont(new Font("Dialog",Font.PLAIN,fontSize));
        //backg.setColor(new Color(0,0,255));
        //backg.drawString((i+1)+LineNoSeparator,AlgoLineNoX,AlgoY);
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",AlgoLineNoX,AlgoY,(i+1)+LineNoSeparator);
        if(AlgoStep[i][SelectedAlgorithm]<RepeatCmdIndex || (AlgoStep[i][SelectedAlgorithm]>7 && AlgoStep[i][SelectedAlgorithm]<EndRepeatCmdIndex) || AlgoStep[i][SelectedAlgorithm]==ColorCmdIndex){
            DefineAlgoLineColor(i,ShowLine);
            CharsToShow=AlgoCommand[AlgoStep[i][SelectedAlgorithm]].length;
            if(WaitingForUserInput && i==PointedAtCommandIndex){
                if(UserInput=="" || UserInput=="-" || parseInt(UserInput)>=0){
                    ShowSign="";
                    StringToShow=UserInput+CursorToShow;
                    if(UserInput=="-") CharsToShow--;
                }
                else{
                    ShowSign="-";
                    if(AlgoStep[i][SelectedAlgorithm]>7 && AlgoStep[i][SelectedAlgorithm]<EndRepeatCmdIndex) CharsToShow--;
                    StringToShow=Math.abs(parseInt(UserInput))+CursorToShow;
                }
            }
            else{
                if(AlgoParam[i][SelectedAlgorithm]=="..." || parseInt(AlgoParam[i][SelectedAlgorithm])>=0){
                    ShowSign="";
                    StringToShow=AlgoParam[i][SelectedAlgorithm];
                }
                else{
                    ShowSign="-";
                    if(AlgoStep[i][SelectedAlgorithm]>7 && AlgoStep[i][SelectedAlgorithm]<EndRepeatCmdIndex) CharsToShow--;
                    StringToShow=""+Math.abs(parseInt(AlgoParam[i][SelectedAlgorithm]));
                }
            }
            //backg.drawString(AlgoCommand[AlgoStep[i][SelectedAlgorithm]].substring(0,CharsToShow)+ShowSign+" "+StringToShow,AlgoX+CurrentTab,AlgoY);
            cnvsWrite("",fontSize,"",AlgoX+CurrentTab,AlgoY,AlgoCommand[AlgoStep[i][SelectedAlgorithm]].substring(0,CharsToShow)+ShowSign+" "+StringToShow);
        }
        else if(AlgoStep[i][SelectedAlgorithm]==RepeatCmdIndex){
            DefineAlgoLineColor(i,ShowLine);
            if(WaitingForUserInput && i==PointedAtCommandIndex){
                //backg.drawString(AlgoCommand[AlgoStep[i][SelectedAlgorithm]]+UserInput+CursorToShow+" [",AlgoX+CurrentTab,AlgoY);
                cnvsWrite("",fontSize,"",AlgoX+CurrentTab,AlgoY,AlgoCommand[AlgoStep[i][SelectedAlgorithm]]+UserInput+CursorToShow+" [");
            }
            else{
                //backg.drawString(AlgoCommand[AlgoStep[i][SelectedAlgorithm]]+AlgoParam[i][SelectedAlgorithm]+" [",AlgoX+CurrentTab,AlgoY);
                cnvsWrite("",fontSize,"",AlgoX+CurrentTab,AlgoY,AlgoCommand[AlgoStep[i][SelectedAlgorithm]]+AlgoParam[i][SelectedAlgorithm]+" [");
            }
            CurrentTab=CurrentTab+TabStep;
        }
        else if(AlgoStep[i][SelectedAlgorithm]==6 || AlgoStep[i][SelectedAlgorithm]==7){
            var colorToUse=0;
            if(i==ShowLine){
                colorToUse="rgb(255,0,255)";
            }
            else{
                colorToUse="rgb(0,0,255)";
            }
            //backg.drawString(AlgoCommand[AlgoStep[i][SelectedAlgorithm]],AlgoX+CurrentTab,AlgoY);
            cnvsWrite(colorToUse,fontSize,"Arial",AlgoX+CurrentTab,AlgoY,AlgoCommand[AlgoStep[i][SelectedAlgorithm]]);
        }
        else if(AlgoStep[i][SelectedAlgorithm]==EndRepeatCmdIndex){
            var colorToUse=0;
            if(CurrentTab<TabStep){
                colorToUse="rgb(255,0,0)";
                AlgoReadyToRun=false;
            }
            else{
                CurrentTab=CurrentTab-TabStep;
                if(i==ShowLine){
                    colorToUse="rgb(255,0,255)";
                }
                else{
                    colorToUse="rgb(0,0,255)";
                }
            }
            cnvsWrite(colorToUse,fontSize,"Arial",AlgoX+CurrentTab,AlgoY,AlgoCommand[AlgoStep[i][SelectedAlgorithm]]);
        }
        AlgoY=AlgoY+15;
    }
    if(CurrentTab>0 || CurrentAlgoSteps==0) AlgoReadyToRun=false;
    cntx.font=fontSize+"px Arial";
}

function DefineAlgoLineColor(i,ShowLine){
    cntx.font=fontSize+"px Arial";
	if(AlgoParam[i][SelectedAlgorithm]=="..."){
		cntx.fillStyle="rgb(255,0,0)";
		AlgoReadyToRun=false;
	}
	else{
		if(i==ShowLine){
			cntx.fillStyle="rgb(255,0,255)";
		}
		else{
			cntx.fillStyle="rgb(0,0,255)";
		}
	}
	if(introStep==4 && i==PointedAtCommandIndex){
		cntx.font="bold "+fontSize+"px Arial";
	}
}

function runAlgo(){
    var i,dLine;
    var done=false;
    cntx.fillStyle="rgb(0,0,255)";
    i=0;
    var SimulationCounter=0;
    LoopNo=-1;
    while(!done){
        if(chkShowAlgorithm.value){
            cntx.fillStyle="rgb(220,255,255)";
            cntx.beginPath();
            cntx.fillRect(ProgramLeft-30,ProgramTop,ProgramRight-ProgramLeft+32,ProgramBottom-ProgramTop+4);
            cntx.fill();
            if(Drawing || StepByStepSimulation){
                dLine=i-FirstVisibleLine;
                while(i<FirstVisibleLine || i>FirstVisibleLine+VisibleAlgoLines-1){
                    FirstVisibleLine=FirstVisibleLine+parseInt(Math.sign(dLine)); 
                }
                ShowAlgo(i);
            }
            else{
                ShowAlgo(-1);
            }
        }
        if(SimulationCounter>SimulationCounterToReach){
            done=true;
        }
        else if(AlgoStep[i][SelectedAlgorithm]==EndRepeatCmdIndex){
            LoopCounter[LoopNo]--;
            if(LoopCounter[LoopNo]>0){
                i=LoopEntry[LoopNo];
            }
            else{
                LoopNo--;
                i++;
                if(i==CurrentAlgoSteps){
                    done=true;
                    $("#cmdSimulate").prop("disabled",false);
                    if(chkShowAlgorithm.value) $("#cmdNextStep").prop("disabled",false);
                }
            }
            SimulationCounter++;
        }
        else{
            if(AlgoStep[i][SelectedAlgorithm]==0){
                X1=parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==1){
                Y1=parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==2){
                X2=parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==3){
                Y2=parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==4){
                R=parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==RepeatCmdIndex){
                LoopNo++;
                LoopCounter[LoopNo]=parseInt(AlgoParam[i][SelectedAlgorithm]);
                LoopEntry[LoopNo]=i+1;
            }
            else if(AlgoStep[i][SelectedAlgorithm]==6){
                ClipLine(OriginX+X1,OriginY-Y1,OriginX+X2,OriginY-Y2,ScaleLeft,ScaleTop,ScaleRight,ScaleBottom);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==7){
                ClipCircle(OriginX+X1,OriginY-Y1,R,ScaleLeft,ScaleTop,ScaleRight,ScaleBottom);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==8){
                X1=X1+parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==9){
                Y1=Y1+parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==10){
                X2=X2+parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==11){
                Y2=Y2+parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==12){
                R=R+parseInt(AlgoParam[i][SelectedAlgorithm]);
            }
            else if(AlgoStep[i][SelectedAlgorithm]==ColorCmdIndex){
                //backg.setColor(new Color(PaletteR[SelectedColorIndex],PaletteG[SelectedColorIndex],PaletteB[SelectedColorIndex]));
                cntx.strokeStyle="rgb("+PaletteR[SelectedColorIndex]+","+PaletteG[SelectedColorIndex]+","+PaletteB[SelectedColorIndex]+")";
            }
            i++;
            SimulationCounter++;
        }
        if(i==CurrentAlgoSteps){
        	terminateSimultation();
        }
    }
}

function DrawCartesian(){
	  var i,GridStep=20;
	  cntx.strokeStyle="rgb(200,200,200)";
	  cntx.beginPath();
	  for(i=OriginX;i>ScaleLeft;i=i-GridStep){
		  cntx.moveTo(i,ScaleTop);
		  cntx.lineTo(i,ScaleBottom);
	  }
	  for(i=OriginX;i<ScaleRight;i=i+GridStep){
		  cntx.moveTo(i,ScaleTop);
		  cntx.lineTo(i,ScaleBottom);
	  }
	  for(i=OriginY;i>ScaleTop;i=i-GridStep){
		  cntx.moveTo(ScaleLeft,i);
		  cntx.lineTo(ScaleRight,i);
	  }
	  for(i=OriginY;i<ScaleBottom;i=i+GridStep){
		  cntx.moveTo(ScaleLeft,i);
		  cntx.lineTo(ScaleRight,i);
	  }
	  cntx.stroke();
	  cntx.beginPath();
	  cntx.strokeStyle="rgb(50,50,50)";
	  cntx.moveTo(ScaleLeft,OriginY);
	  cntx.lineTo(ScaleRight,OriginY);
	  
	  cntx.moveTo(OriginX,ScaleTop);
	  cntx.lineTo(OriginX,ScaleBottom);
	  cntx.stroke();
}

function ShowAvailableCommands(){
	  var i=0;
	  var Xscr=390,Yscr=TopPanelHeight+90;
	  var AdditionalColor=0;
	  var colorToUse="";
	  if(MemoryFull) AdditionalColor=255;		  
	  for(i=0;i<AvailableAlgoCommands;i++){
		  if(i==AvailableCommandIndex){
			  colorToUse="rgb("+AdditionalColor+",0,255)";
			  cntx.font="bold "+fontSize+"px Arial";
		  }
		  else{
			  colorToUse="rgb("+AdditionalColor+",0,130)";
			  cntx.font=fontSize+"px Arial";
		  }
		  cnvsWrite(colorToUse,fontSize,"",Xscr,Yscr,AlgoCommand[i]);
		  Yscr=Yscr+20;
	  }
}

function ShowRAM(){
	  var RAMData="X1="+X1+" , Y1="+Y1+" , X2="+X2+" , Y2="+Y2+" , R="+R;
	  var FrameBorder=5;
	  var RAMLEFT=chkShowRAMLEFT+170;
	  var RAMTOP=chkShowRAMTOP+10;
	  var RAMWIDTH=cntx.measureText(RAMData).width+2*FrameBorder;
	  var RAMHEIGHT=20;
	  cntx.beginPath();
	  cntx.fillStyle="rgb(220,255,255)";
	  cntx.fillRect(RAMLEFT,RAMTOP,RAMWIDTH,RAMHEIGHT);
	  cntx.fill();
	  cntx.strokeStyle="rgb(0,0,0)";
	  cntx.rect(RAMLEFT,RAMTOP,RAMWIDTH,RAMHEIGHT);
	  cntx.stroke();
	  cnvsWrite("rgb(0,0,255)",fontSize,"Arial",RAMLEFT+FrameBorder,RAMTOP+RAMHEIGHT-4,RAMData);
}

function ClearAlgoSteps(){
	  var i;
	  for(i=0;i<NoOfAlgoSteps;i++){
		  AlgoStep[i][0]=-1;
	  }
}

function ClearAlgoParameters(){
	  var i;
	  for(i=0;i<NoOfAlgoSteps;i++){
		  AlgoParam[i][0]="...";
	  }
}

function DeleteAlgoCommand(){
	  var i;
	  if(PointedAtCommandIndex==NoOfAlgoSteps-1){
		  AlgoStep[PointedAtCommandIndex][0]=-1;
		  AlgoParam[PointedAtCommandIndex][0]="...";
	  }
	  else{
		  for(i=PointedAtCommandIndex;i<CurrentAlgoSteps-1;i++){
			  AlgoStep[i][0]=AlgoStep[i+1][0];
			  AlgoParam[i][0]=AlgoParam[i+1][0];
		  }
		  AlgoParam[CurrentAlgoSteps-1][0]="...";
	  }
	  CurrentAlgoSteps--;
UserAlgoSteps=CurrentAlgoSteps;
	  MemoryFull=false;
	  if(CurrentAlgoSteps-FirstVisibleLine<VisibleAlgoLines && FirstVisibleLine>0) FirstVisibleLine--;
}

function AlgoCommandHover(DontCheckForParameters){
	  if(mx>=ProgramLeft && mx<=ProgramRight && my>=ProgramTop && my<=ProgramBottom){
		  PointedAtCommandIndex=parseInt((my-110)/15+FirstVisibleLine);
		  if(PointedAtCommandIndex>-1 && PointedAtCommandIndex<CurrentAlgoSteps){
			  if(CmdRequiresParam[AlgoStep[PointedAtCommandIndex][0]] || DontCheckForParameters){
				  return PointedAtCommandIndex;
			  }
			  else{
				  return -1;
			  }
		  }
		  else{
			  //Το ποντίκι είναι μέσα στο πλαίσιο αλλά δε σημαδεύει εντολή
			  PointedAtCommandIndex=-2;
			  return -2;
		  }
	  }
	  else{
		  //Το ποντίκι είναι έξω από το πλαίσιο
		  PointedAtCommandIndex=-1;
		  return -1;
	  }
}

function MoveCommand(){
	  var Destination=AlgoCommandHover(true);
	  var i,cmdToMoveType=AlgoStep[cmdToMove][0];
	  var SelectedParam=AlgoParam[cmdToMove][0];
	  //μετακίνηση στο τέλος
	  if(Destination==-1){
		  //Απόρριψη μετακίνησης
	  }
	  else if(Destination==-2){
		  for(i=cmdToMove;i<CurrentAlgoSteps-1;i++){
			  AlgoStep[i][0]=AlgoStep[i+1][0];
			  AlgoParam[i][0]=AlgoParam[i+1][0];
		  }
		  AlgoStep[CurrentAlgoSteps-1][0]=cmdToMoveType;
		  AlgoParam[CurrentAlgoSteps-1][0]=SelectedParam;
	  }
	  else{
		  //μετακίνηση πριν την καταδεικνυόμενη εντολή
		  //που βρίσκεται ΚΑΤΩ από την επιλεγμενη
		  if(cmdToMove<Destination){
			  for(i=cmdToMove;i<Destination-1;i++){
				  AlgoStep[i][0]=AlgoStep[i+1][0];
				  AlgoParam[i][0]=AlgoParam[i+1][0];
			  }
			  AlgoStep[Destination-1][0]=cmdToMoveType;
			  AlgoParam[Destination-1][0]=SelectedParam;
		  }
		  //μετακίνηση πριν την καταδεικνυόμενη εντολή
		  //που βρίσκεται ΠΑΝΩ από την επιλεγμενη
		  else if(cmdToMove>Destination){
			  for(i=cmdToMove;i>Destination;i--){
				  AlgoStep[i][0]=AlgoStep[i-1][0];
				  AlgoParam[i][0]=AlgoParam[i-1][0];
			  }
			  AlgoStep[Destination][0]=cmdToMoveType;
			  AlgoParam[Destination][0]=SelectedParam;
		  }
	  }
}

function AvailableCommandHover(){
	  if(mx>=370 && mx<=600 && my>=160 && my<460){
		  AvailableCommandIndex=parseInt((my-160)/20);
	  }
	  else{
		  AvailableCommandIndex=-1;
	  }
}


//=========================================================
function handleKeyDown(key){
    if(WaitingForUserInput){
        switch(key){
            case 13: //enter
                if(!UserInput==""){
                    AlgoParam[PointedAtCommandIndex][0]=UserInput;
                }
                else{
                    AlgoParam[PointedAtCommandIndex][0]="...";
                }
                PaletteVisible=false;
                WaitingForUserInput=false;
                Drawing=false;
                PointedAtCommandIndex=-1;
                clearInterval(timerLoop);
                break;
            case 8: //backspace:
                if(UserInput.length>0){
                    UserInput=UserInput.substring(0,UserInput.length-1);
                    if(AlgoStep[PointedAtCommandIndex][0]==ColorCmdIndex){
                        if(UserInput==""){
                            SelectedColorIndex=-1;
                        }
                        else{
                            SelectedColorIndex=parseInt(UserInput);
                        }
                    }
                }
                break;
            default:
                var c=String.fromCharCode(key);
                var AllowedLength=3;
                if(AlgoStep[PointedAtCommandIndex][0]==ColorCmdIndex) AllowedLength=2;
                if(UserInput.startsWith("-")) AllowedLength=4;
                //η Ακτίνα,το Πλήθος Επαναλήψεων και το Χρώμα δε δέχονται αρνητικές τιμές
                if(c=="-" && UserInput=="" && AlgoStep[PointedAtCommandIndex][0]!=4 && AlgoStep[PointedAtCommandIndex][0]!=RepeatCmdIndex && AlgoStep[PointedAtCommandIndex][0]!=ColorCmdIndex){
                    UserInput=UserInput+c;
                }
                else if(c>="0" && c<="9" && UserInput.length<AllowedLength){
                    if(AlgoStep[PointedAtCommandIndex][0]==ColorCmdIndex){
                        if(parseInt(UserInput+c)<16){
                            UserInput=UserInput+c;
                            SelectedColorIndex=parseInt(UserInput);
                        }
                    }
                    else{
                        UserInput=UserInput+c;
                    }
                }
                    
        }
        drawBasicScreen();
    }
}

function ClipCircle(CenterX,CenterY,Radius,Xleft,Ytop,Xright,Ybottom){
	var i,XX,YY;
	var angle;
	if(Radius>=0){
		cntx.strokeStyle="rgb("+PaletteR[SelectedColorIndex]+","+PaletteG[SelectedColorIndex]+","+PaletteB[SelectedColorIndex]+")";
		cntx.beginPath();
        for(i=0;i<720;i++){
            angle=i*Math.PI/360;
            XX=parseInt(CenterX+Radius*Math.cos(angle));
            YY=parseInt(CenterY+Radius*Math.sin(angle));
            if(XX>Xleft && XX<Xright && YY>Ytop && YY<Ybottom){
                cntx.rect(XX,YY,0,0);
            }
        }
		cntx.stroke();
	}
}

function ClipLine(X1,Y1,X2,Y2,Xleft,Ytop,Xright,Ybottom){
	  var XX,aux_X1=0,aux_X2=0,aux_Y1=0,aux_Y2=0;
	  var a,b;
	  var LineOk;
	  
	  if(Out(X1,X2,Xleft,Xright) || Out(Y1,Y2,Ytop,Ybottom)){
		  LineOk=false;
	  }
	  else{
		  LineOk=true;
		  if(X1==X2){
			  aux_X1=X1;
			  aux_X2=X1;
			  aux_Y1=Math.min(Math.max(Y1,Ytop),Ybottom);
			  aux_Y2=Math.min(Math.max(Y2,Ytop),Ybottom);
		  }
		  else{
			  a=parseFloat(Y2-Y1)/parseFloat(X2-X1);
			  b=Y2-a*X2;
			  if(a!=0){
				  XX=Math.max(Math.min(X1,Xright),Xleft);
				  aux_X1=CheckLineX(a,b,XX,Ytop,Ybottom);
				  aux_Y1=CheckLineY(a,b,XX,Ytop,Ybottom);
				  XX=Math.max(Math.min(X2,Xright),Xleft);
				  aux_X2=CheckLineX(a,b,XX,Ytop,Ybottom);
				  aux_Y2=CheckLineY(a,b,XX,Ytop,Ybottom);
			  }
			  else{
				  aux_X1=Math.min(Math.max(X1,Xleft),Xright);
				  aux_X2=Math.min(Math.max(X2,Xleft),Xright);
				  aux_Y1=Y1;
				  aux_Y2=Y1;
			  }
		  }
	  }
	  if(LineOk && (aux_X1!=aux_X2 || aux_Y1!=aux_Y2)){
		  cntx.strokeStyle="rgb("+PaletteR[SelectedColorIndex]+","+PaletteG[SelectedColorIndex]+","+PaletteB[SelectedColorIndex]+")";
		  cntx.beginPath();
		  cntx.moveTo(aux_X1,aux_Y1);
		  cntx.lineTo(aux_X2,aux_Y2);
		  cntx.stroke();
	  }
}

function CheckLineX(a,b,XX,Ytop,Ybottom){
	  var aux_X,YY;
	  YY=parseInt(a*XX+b);
	  if(Ytop<=YY && YY<=Ybottom){
		  aux_X=XX;
	  }
	  else{
		  if(YY<Ytop){
			  aux_X=parseInt((Ytop-b)/a);
		  }
		  else{
			  aux_X=parseInt((Ybottom-b)/a);
		  }
	  }
	  return aux_X;
}

function CheckLineY(a,b,XX,Ytop,Ybottom){
	  var aux_Y,YY;
	  YY=parseInt(a*XX+b);
	  if(Ytop<=YY && YY<=Ybottom){
		  aux_Y=YY;
	  }
	  else{
		  if(YY<Ytop){
			  aux_Y=Ytop;
		  }
		  else{
			  aux_Y=Ybottom;
		  }
	  }
	  return aux_Y;
}

function Out(A1,A2,Lim1,Lim2){
	  if((A1<=Lim1 && A2<=Lim1) || (A1>=Lim2 && A2>=Lim2)){
		  return true;
	  }
	  else{
		  return false;
	  }
}

function InitialisePalette(){
	  PaletteR[0]=0; PaletteG[0]=0; PaletteB[0]=0;
	  PaletteR[1]=0; PaletteG[1]=0; PaletteB[1]=255;
	  PaletteR[2]=0; PaletteG[2]=155; PaletteB[2]=0;
	  PaletteR[3]=0; PaletteG[3]=155; PaletteB[3]=155;
	  PaletteR[4]=155; PaletteG[4]=0; PaletteB[4]=0;
	  PaletteR[5]=155; PaletteG[5]=0; PaletteB[5]=155;
	  PaletteR[6]=155; PaletteG[6]=155; PaletteB[6]=0;
	  PaletteR[7]=200; PaletteG[7]=200; PaletteB[7]=200;
	  PaletteR[8]=155; PaletteG[8]=155; PaletteB[8]=155;
	  PaletteR[9]=0; PaletteG[9]=0; PaletteB[9]=255;
	  PaletteR[10]=0; PaletteG[10]=255; PaletteB[10]=0;
	  PaletteR[11]=0; PaletteG[11]=255; PaletteB[11]=255;
	  PaletteR[12]=255; PaletteG[12]=0; PaletteB[12]=0;
	  PaletteR[13]=255; PaletteG[13]=0; PaletteB[13]=255;
	  PaletteR[14]=255; PaletteG[14]=255; PaletteB[14]=0;
	  PaletteR[15]=255; PaletteG[15]=255; PaletteB[15]=255;
}

function DrawPalette(){
	  var i;
	  for(i=0;i<NoOfPaletteColors;i++){
		  cntx.fillStyle="rgb("+PaletteR[i]+","+PaletteG[i]+","+PaletteB[i]+")";
		  cntx.fillRect(PaletteLeft+PaletteSlotSize*i,PaletteTop,PaletteSlotSize,PaletteSlotSize);
	  }
	  var X1=PaletteLeft+PaletteSlotSize*SelectedColorIndex;
	  var Y1=PaletteTop;
	  var X2=X1+PaletteSlotSize;
	  var Y2=Y1+PaletteSlotSize;
	  if(SelectedColorIndex>9){
		  cntx.strokeStyle="rgb(0,0,0)";
	  }
	  else{
		  cntx.strokeStyle="rgb(255,255,255)";
	  }
	  cntx.beginPath();
	  cntx.moveTo(X1,Y1);
	  cntx.lineTo(X2,Y2);
	  
	  cntx.moveTo(X1,Y2);
	  cntx.lineTo(X2,Y1);
	  cntx.stroke();
}

function PaletteHover(){
	  return (mx>=PaletteLeft && mx<PaletteLeft+NoOfPaletteColors*PaletteSlotSize && my>=PaletteTop && my<=PaletteTop+PaletteSlotSize);
}

function SelectPaletteColor(){
	  SelectedColorIndex=parseInt((mx-PaletteLeft)/PaletteSlotSize);
}

function CopyAlgo(){
	  var i;
	  for(i=0;i<CurrentAlgoSteps;i++){
		  AlgoStep[i][0]=AlgoStep[i][SelectedAlgorithm];
		  AlgoParam[i][0]=AlgoParam[i][SelectedAlgorithm];
	  }
	  UserAlgoSteps=CurrentAlgoSteps;
}

function actionPerformed(slctr){
	if(slctr==0){
        $("#cmdSimulate").prop("disabled",true);
        $("#cmdNextStep").prop("disabled",false);
        $("#cmdNextStep").text("Επαναφορά");
        StepByStepSimulation=false;
        LoopNo=-1;
        AlgoRunning=true;
        SimulationCounterToReach=-2;
        Drawing=true;
        timerLoop=setInterval(function(){run();},simSpeed);
	}
	else if(slctr==1){
	    if($("#cmdNextStep").text()=="Επόμενο βήμα"){
            AlgoRunning=true;
            if(!StepByStepSimulation){
                SimulationCounterToReach=-2;
                LoopNo=-1;
            }
            StepByStepSimulation=true;
            Drawing=true;
            timerLoop=setInterval(function(){run();},simSpeed);
        }
	    else if($("#cmdNextStep").text()=="Επαναφορά"){
            terminateSimultation();
            drawBasicScreen();
        }
	}
	else if(slctr==3){
        ClearAlgoSteps();
        ClearAlgoParameters();
        CurrentAlgoSteps=0;
        FirstVisibleLine=0;
        drawBasicScreen();
	}
	else if(slctr==2){
        CopyAlgo();
        introStep--;
        LoadIntroImage();
        drawBasicScreen();
	}
}

function terminateSimultation(){
    $("#cmdNextStep").text("Επόμενο βήμα");
    clearInterval(timerLoop);
    done=true;
    Drawing=false;
    StepByStepSimulation=false;
}

function LoadIntroImage(){
	defineSimulationRate();
    intro=document.getElementById("img"+introStep);
    if(introStep==4){
        AvailableCommandIndex=-1;
        PointedAtCommandIndex=-1;
        SelectedAlgorithm=0;
        CurrentAlgoSteps=UserAlgoSteps;
        FirstVisibleLine=0;
    }
    else if(introStep==5){
        chkShowAlgorithm.value==true;
        $("#algorithmSlctr").val("user").change();
        AlgoRunning=false;
        UserAlgoSteps=CurrentAlgoSteps;
    }
}

function itemStateChanged(slctr){
    if(slctr==algorithmSlctrIndx){ //algorithmSlctr
        FirstVisibleLine=0;
        SelectedAlgorithm=$("#algorithmSlctr").prop("selectedIndex");
        SimulationCounterToReach=-2;
        $("#cmdSimulate").prop("disabled",false);
        if(chkShowAlgorithm.value)$("#cmdNextStep").prop("disabled",false);
        $("#cmdEditAlgo").hide();
        if(SelectedAlgorithm>0){
            SelectAlgorithm();
            chkShowAlgorithm.value=false;
            //$("#cmdEditAlgo").hide();
            
        }
        else{
            chkShowAlgorithm.value=true;
            CurrentAlgoSteps=UserAlgoSteps;
        }
        defineSimulationRate();
        drawBasicScreen();
        $("#cmdSimulate").prop("disabled",false);
        if(chkShowAlgorithm.value)$("#cmdNextStep").prop("disabled",false);
    }
    else if(slctr==chkShowAlgorithmIndx){//chkShowAlgorithm
        if(chkShowAlgorithm.value && SelectedAlgorithm>0){
            $("#cmdEditAlgo").show();
        }
        else{
            $("#cmdEditAlgo").hide();
        }
        defineSimulationRate();
        drawBasicScreen();
    }
    else if(slctr==chkShowRAMIndx || slctr==chkShowGridIndx){//chkShowRAM OR chkShowGrid
        drawBasicScreen();
    }
}

function run(){
    if(Drawing){
        if(WaitingForUserInput){
            if(CursorToShow=="_"){
                CursorToShow=" ";
            }
            else{
                CursorToShow="_";
            }
        }
        else{
        	SimulationCounterToReach++;
        }
        drawBasicScreen();
        if(StepByStepSimulation)Drawing=false;
    }
}

function defineSimulationRate(){
    if(introStep==4 || chkShowAlgorithm==null || chkShowAlgorithm.value){
        simSpeed=500;
    }
    else{
        simSpeed=1;
    }
}