var canvas;
var cntx;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
}
      
function initialiseEvents(){
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });
} 

function initialiseGUI(){

}

function initialValues(){
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    for(var i=0;i<BallColumns;i++){
        for(var j=0;j<BallRowsUpper+BallRowsLower;j++){
            Balls[i][j]=0;
        }
    }
    InitialiseBallsPositions();
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBackStepEnabled=document.getElementById("BackEnabledSmall");
    imgBackStepSelected=document.getElementById("BackSelSmall");
    imgAvaxStructure=document.getElementById("AvaxStructure");
    imgBall=document.getElementById("BallSmaller");
    nxtStepLeft=width-nxtStepWidth-15-logoWidth;
    nxtStepTop=BottomPanelTop+20;
    BackStepLeft=2;
    BackStepTop=nxtStepTop;
    AvaxLeft=20;
    AvaxTop=TopPanelHeight+15;
}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    //Φόντα οθόνης
    drawIntroImage();
    drawLogoImage();
    //Εικόνες
    if(introStep==9){
        $("#controlsDIV1").show();
        $("#controlsDIV2").show();
        DrawBalls();
        CheckButtonsState();
        if($("#chkSum").prop("checked")){
            if(!AdditionSelected){
                $("#txtNo1").show();
                $("#lblNo1").show();
                $("#txtNo2").show();
                $("#lblNo2").show();
            }
            if(!Adding)$("#btnAdd").show();
            $("#chkStepByStep").show();
            $("#lblStepByStep").show();
        }
        else{
            $("#txtNo1").show();
            $("#lblNo1").show();
            $("#txtNo2").hide();
            $("#lblNo2").hide();
            $("#btnAdd").hide();
            $("#chkStepByStep").hide();
            $("#lblStepByStep").hide();
        }
        if($("#chkShowDigits").prop("checked"))showDigits();
        var promptXCoord=50;
        var promptYCoord=BottomPanelTop+25;
        if($("#chkSum").prop("checked")){
            if(simulationPending){
                var msg="";
                if(CurrentDigitToAdd==0){
                    msg="Εμφάνιση πρώτου προσθετέου.";
                }
                else{
                    msg="Πρόσθεση ψηφίων "+CurrentDigitToAdd+"ης στήλης.";
                }
                cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,msg);
                promptYCoord+=20;
            }
            else{
                cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Πληκτρολόγησε δύο αριθμούς.Ξεκίνα τη διαδικασία πατώντας το κουμπί [Εκτέλεση].");
                promptYCoord+=20;
                cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Συνέχισε την πρόσθεση με το κουμπί [Επόμενο].");
                promptYCoord+=20;
                cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Για αυτοματοποίηση της διαδικασίας απενεργοποίησε τη βηματική εκτέλεση");
            }
        }
        else{
            cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Κάνε κλικ σε μια σφαίρα για να τη μετακινήσεις. Ενεργοποίησε την [Εμφάνιση Ψηφίων].");
            promptYCoord+=20;
            cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Πειραματίσου με το διακόπτη [Αυτόματη Απλοποίηση]. Καθάρισε την τιμή με το κουμπί [Μηδενισμός].");
            promptYCoord+=20;
            cnvsWrite(LetterColor,fontSize,"Arial",promptXCoord,promptYCoord,"Αυξομείωσε την τιμή του Άβακα με τα κουμπιά [+] και [-]. Ενεργοποίησε την πρόσθεση και πειραματίσου.");
        }
    }
    else{
        $("#controlsDIV1").hide();
        $("#controlsDIV2").hide();
    }
    if(introStep<9) drawButtonNext();
    if(introStep>1) drawButtonBack();
}

function PresentProgramID(){
    var ProgramID;
    ProgramID=getImage(getCodeBase(), "progID.JPG");
    backg.drawImage(ProgramID,50,TopPanelHeight+2,this);
}

function drawIntroImage(){
    Intro=document.getElementById("img"+introStep);
    var picTop=(height-Intro.height)/2;
    cntx.strokeStyle="black";
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,picTop-1);
    //κάτω πλαίσιο
    var lowRectTop=picTop+Intro.height+1;
    cntx.rect(0,lowRectTop,width,height-lowRectTop);

    cntx.stroke();
    cnvsWrite(LetterColor,35,"Arial",-1,TitleTOP+TitleHEIGHT,"Χρήση του Άβακα");
    cntx.drawImage(Intro,1,picTop);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function textValueChanged(slctr){
    var newVal=Math.max(1,parseInt($("#"+slctr).val()));
    newVal=Math.min(9999999999999,newVal);
    $("#"+slctr).val(newVal);
    if(slctr=="txtNo1"){
        No1=parseInt($("#txtNo1").val());
        if(!$("#chkSum").prop("checked")){
            calculateDigits(newVal);
            simplifyAvax();
        }
    }
    if(slctr=="txtNo2"){
        No2=parseInt($("#txtNo2").val());
    }
    drawBasicScreen();
}

function drawButtonNext(){
    if(buttonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function buttonNextHover(){
    if(mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else{
        return false;
    }
}

function drawButtonBack(){
    if(buttonBackHover()){
        cntx.drawImage(imgBackStepSelected,BackStepLeft,BackStepTop);
    }
    else{
        cntx.drawImage(imgBackStepEnabled,BackStepLeft,BackStepTop);
    }
}

function buttonBackHover(){
    if(mx>=BackStepLeft && mx<=BackStepLeft+BackStepWidth && my>=BackStepTop && my<=BackStepTop+BackStepHeight){
        return true;
    }
    else{
        return false;
    }
}

function run(){
    if(Adding){
        PerformAdditionStep();
    }
}

function PerformAdditionStep(){
    if(CurrentDigitToAdd>0){
        No1=No1+parseInt(sNo2.charAt(NoOfDigits-CurrentDigitToAdd))*Math.pow(10,CurrentDigitToAdd-1);
        No2=No2-parseInt(sNo2.charAt(NoOfDigits-CurrentDigitToAdd))*Math.pow(10,CurrentDigitToAdd-1);
        $("#txtNo2").val(""+No2);
    }
    calculateDigits(No1);
    simplifyAvax();
    CurrentDigitToAdd++;
    if(CurrentDigitToAdd>NoOfDigits){
        resetSimulation();
    }
    else{
        if($("#chkStepByStep").prop("checked")) Adding=false;
    }
    drawBasicScreen();
}

function DrawBalls(){
    for(var i=0;i<BallColumns;i++){
        for(var j=0;j<BallRowsUpper;j++){
            cntx.drawImage(imgBall,BallLeftCoord(i),BallTopCoord(1,i,j));
        }
        for(var j=0;j<BallRowsLower;j++){
            cntx.drawImage(imgBall,BallLeftCoord(i),BallTopCoord(2,i,j));
        }
    }
}

function BallLeftCoord(i){
    return AvaxLeft+BallXOffset[i];
}

function BallTopCoord(AreaSelector,i,j){
    if(AreaSelector==1){
        return UpperAreaTop+BallRowsUpper*BallHeight-(j+1)*BallHeight+53*Balls[i][BallRowsLower+j];
    }
    else{
        return LowerAreaBottom-(j+1)*BallHeight-88*Balls[i][j];
    }
}

function CheckBallHover(){
    var i,j;
    var Found;
    BallSelI=-1;
    BallSelJ=-1;
    if(mx>=AvaxLeft+BallXOffset[0] && mx<=AvaxLeft+BallXOffset[12]+BallWidth){
        if(UpperAreaTop<=my && my<=LowerAreaBottom ){
              Found=false;
              i=0;
              while(i<BallColumns && !Found){
                  if(BallLeftCoord(i)<mx && BallLeftCoord(i)+BallWidth>mx){
                      BallSelI=i;
                      Found=true;
                  }
                  i++;
              }
              if(Found){//Αν βρέθηκε η στήλη...
                  //...αναζήτηση στην κάτω περιοχή
                  Found=false;
                  j=0;
                  while(j<BallRowsLower && !Found){
                      if(my>BallTopCoord(2,BallSelI,j) && my<BallTopCoord(2,BallSelI,j)+BallHeight){
                          BallSelJ=j;
                          Found=true;
                      }
                      j++;
                  }
                  
                  //Αναζήτηση στην πάνω περιοχή
                  Found=false;
                  j=0;
                  while(j<BallRowsUpper && !Found){
                      if(my>BallTopCoord(1,BallSelI,j) && my<BallTopCoord(1,BallSelI,j)+BallHeight){
                          BallSelJ=BallRowsLower+j;
                          Found=true;
                      }
                      j++;
                  }
              }
        }
    }
}

function InitialiseBallsPositions(){
    BallXOffset[0]=28;
    BallXOffset[1]=BallXOffset[0]+35;
    BallXOffset[2]=BallXOffset[1]+34;
    BallXOffset[3]=BallXOffset[2]+35;
    BallXOffset[4]=BallXOffset[3]+34;
    BallXOffset[5]=BallXOffset[4]+34;
    BallXOffset[6]=BallXOffset[5]+34;
    BallXOffset[7]=BallXOffset[6]+34;
    BallXOffset[8]=BallXOffset[7]+34;
    BallXOffset[9]=BallXOffset[8]+34;
    BallXOffset[10]=BallXOffset[9]+34;
    BallXOffset[11]=BallXOffset[10]+34;
    BallXOffset[12]=BallXOffset[11]+35;
}

function number(){
    var n=0;
    var i,j;
    for(i=0;i<BallColumns;i++){
        n=10*n;
        for(j=0;j<BallRowsLower;j++){
            n=n+Balls[i][j];
        }
        for(j=0;j<BallRowsUpper;j++){
            n=n+5*Balls[i][BallRowsLower+j];
        }
    }
    return n;
}

function calculateDigits(n){
    var i;
    $("#txtNo1").val(""+n);
    for(i=BallColumns-1;i>-1;i--){
        digits[i]=n % 10;
        n=parseInt(n/10);
    }
}

function simplifyAvax(){
    var i,j,dgt;
    ResetBalls();
    for(i=0;i<BallColumns;i++){
        dgt=digits[i];
        if(dgt>4){
            Balls[i][BallRowsLower]=1;
            dgt=dgt-5;
        }
        j=BallRowsLower-1;
        while (dgt>0){
            Balls[i][j]=1;
            dgt--;
            j--;
        }
    }
}

function ResetBalls(){
    for(var i=0;i<BallColumns;i++){
        for(var j=0;j<BallRowsLower+BallRowsUpper;j++){
            Balls[i][j]=0;
        }
    }
}

function CheckButtonsState(){
    if(number()==0){
        document.getElementById("btnDecrement").disabled=true;
    }
    else{
        document.getElementById("btnDecrement").disabled=false;
    }
    
    if(number()==Math.pow(10,BallColumns)-1){
        document.getElementById("btnIncrement").disabled=true;
    }
    else{
        document.getElementById("btnIncrement").disabled=false;
    }
}

function showDigits(){
    for(var i=0;i<BallColumns;i++){
        cnvsWrite("rgb(255,255,0)",txtFontSize,"Arial",BallLeftCoord(i)+BallWidth/2,LowerAreaTop-7,""+digits[i]);
    }
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseMove(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
        ShowProgramID=false;
    }
    if(introStep==9){
        CheckBallHover();
        if(BallSelI>-1 && BallSelJ>-1){
            $("#visualisation").css("cursor","pointer");
        }
        else{
            $("#visualisation").css("cursor","default");
        }
    }
    drawBasicScreen();
}

function handleMouseUp(){
    if(mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight){
        if(MyInfo){
            ShowProgramID=!ShowProgramID;
        }
        else{
            showHTML();
        }
    }
    ProgramID="";
    if(mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight && introStep<9){
        introStep++;
        drawBasicScreen();
    }
    if(mx>=BackStepLeft && mx<BackStepLeft+BackStepWidth && my>=BackStepTop && my<BackStepTop+BackStepHeight && introStep>1){
        introStep--;
        drawBasicScreen();
    }       
    if(introStep==9 && BallSelI>-1 && BallSelJ>-1){
        var FirstBall,LastBall;
        if(Balls[BallSelI][BallSelJ]==0){//Ανέβασμα
            if(BallSelJ>=BallRowsLower){
                LastBall=BallSelJ+1;
                FirstBall=BallRowsLower;
            }
            else{
                FirstBall=BallSelJ;
                LastBall=BallRowsLower;
            }
            for(var j=FirstBall;j<LastBall;j++){
                Balls[BallSelI][j]=1;
            }
        }
        else{//Κατέβασμα
            if(BallSelJ>=BallRowsLower){
                FirstBall=BallSelJ;
                LastBall=BallRowsLower+BallRowsUpper-1;
            }
            else{
                FirstBall=0;
                LastBall=BallSelJ;
            }
            for(var j=FirstBall;j<=LastBall;j++){
                Balls[BallSelI][j]=0;
            }
        }
        calculateDigits(number());
        if($("#chkAutoSimplify").prop("checked")) simplifyAvax();
        $("#txtNo1").val(""+number());
        drawBasicScreen();
    }       
}

function resetAvax(){
    calculateDigits(0);
    simplifyAvax();
    drawBasicScreen();
}

function itemStateChanged(slctr){
    if(slctr=="chkShowDigits"){

    }
    else if(slctr=="chkAutoSimplify"){
        simplifyAvax();
    }
    else if(slctr=="chkSum"){
        var label="";
        if($("#chkSum").prop("checked")){
            label="Πρώτος αριθμός";
        }
        else{
            label="Ένδειξη άβακα";
        }
        $("#lblΝο1").text(label);
    }
    else if(slctr=="chkStepByStep"){

    }
    drawBasicScreen();
}

function actionPerformed(slctr){
    if(slctr=="btnIncrement"){
        changeNoByOne(1);
    }
    if(slctr=="btnDecrement"){
        changeNoByOne(-1);
    }
    if(slctr=="btnResetAvax"){
        resetAvax();
    }
    if(slctr=="btnAdd"){
        if($("#btnAdd").html()=="Εκτέλεση"){
            AdditionSelected=true;
            $("#btnAdd").hide();
            sNo2=""+No2;
            NoOfDigits=sNo2.length;
            CurrentDigitToAdd=0;
            if($("#chkStepByStep").prop("checked")){
                $("#btnAdd").html("Επόμενο");
            }
            initialiseSimulation();
        }
        else{
            PerformAdditionStep();
        }
    }
}

function changeNoByOne(step){
    var n=number();
    calculateDigits(n+step);
    simplifyAvax();
    drawBasicScreen();
}

function initialiseSimulation(){
    Adding=true;
    simulationPending=true;
    resetAvax();
    timerLoop=setInterval(function(){run();},simulationSpeed);  
}

function resetSimulation(){
    clearInterval(timerLoop);
    simulationPending=false;
    AdditionSelected=false;
    Adding=false;
    $("#btnAdd").html("Εκτέλεση");
    $("#btnAdd").show();
    $("#txtNo1").show();
    $("#lblNo1").show();
    $("#txtNo2").show();
    $("#lblNo2").show();
}