var canvas;
var cntx;
var cnvBackBuffer;
var cntxBackBuffer;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    cnvBackBuffer=document.getElementById("backBuffer");
    cntxBackBuffer=cnvBackBuffer.getContext("2d");
    showAppTitle();
    
    imgLogo=document.getElementById("Logo");
    img=document.getElementById("imgToShow");
    
    initialValues();
    InitialiseCaptions();
    for(var i=0;i<NoOfCategories;i++){
        SelectedImage[i]=0;
    }
    InitialiseImageFileNames();
    initialiseGUI();
    nxtStepLeft=8;
    nxtStepTop=BottomPanelTop+20;
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");

    initialiseEvents();
    drawBasicScreen();
}
    
function initialiseEvents(){
    $("#visualisation").contextmenu(function(evt){
        evt.preventDefault();
        evt.stopPropagation();
    });
    
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove(evt);
    });

    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp(evt);
    });
    
    $("#visualisation").on("mouseout",function(evt){
        imgLogo=document.getElementById("Logo");
        drawBasicScreen();
    });
}

function InitialiseImageFileNames(){
    FileName[0]="BTNadministration";
    FileName[1]="BTNeducation";
    FileName[2]="BTNmedicine";
    FileName[3]="BTNresearch";
    FileName[4]="BTNsupermarket";
    FileName[5]="BTNtransport";
    FileName[6]="BTNtrapeza";
    FileName[7]="BTNprof";
}

function initialValues(){
    width=canvas.width;
    height=canvas.height;
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-10;
    logoTop=BottomPanelTop+10;
    SectionTitle=0;//BottomPanelTop-20;
    BTNTop=TopPanelHeight+Column1Left;
}

function initialiseGUI(){
    logoLeft=width-logoWidth-10;
    logoTop=BottomPanelTop+10;
    imgLogo=document.getElementById("Logo");
    for(var i=0;i<NoOfCategories;i++){
        imgButtons[i]=document.getElementById(FileName[i]+"2");
        imgButtonsHovered[i]=document.getElementById(FileName[i]+"1");
        ButtonHover[i]=false;
    }
    InitialiseGUI_values();
}

function InitialiseGUI_values(){
    //ImageTop=TopPanelHeight+imgButtons[0].height+Column1Top;
    ImageTop=TopPanelHeight;
}

function drawBasicScreen(){
    //Φόντα οθόνης
    cntx.clearRect(0,0,canvas.width,canvas.height);
    
    cntx.fillStyle=MainAreaColor;
    cntx.fillRect(0,0,width,height);

    cntx.fillStyle=PanelColor;
    cntx.fillRect(0,0,width,TopPanelHeight);
    cntx.fillRect(0,BottomPanelTop,width,BottomPanelHeight);
    //Τίτλος εφαρμογής
    cnvsWrite(LetterColor,30,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
    //Κουμπιά
    var BTNw,BTNh,BTNLeft=Column1Left,BTNTop=TopPanelHeight+Column1Top;
    for(var i=0;i<NoOfCategories;i++){
        if (i==NoOfCategories/2) {
            BTNTop=TopPanelHeight+Column1Top;
            BTNLeft=width-imgButtons[i].width-Column1Left;
        }
        if (ButtonHover[i]){
            //backg.drawImage(imgButtonsHovered[i],BTNLeft,BTNTop,this);
            cntx.drawImage(imgButtonsHovered[i],BTNLeft,BTNTop);
        }
        else {
            //backg.drawImage(imgButtons[i],BTNLeft,BTNTop,this);
            cntx.drawImage(imgButtons[i],BTNLeft,BTNTop);
        }
        BTNTop=BTNTop+imgButtons[i].height+Column1Top;
    }
    
    drawButtonNext();

    //Εικόνες
    var imgMainLeft=(width-iw)/2;
    //var imgMainTop=(SectionTitle-ImageTop-ih)/2+ImageTop;
    var imgMainTop=(BottomPanelTop-TopPanelHeight-ih)/2+TopPanelHeight;
    
    cntxBackBuffer.drawImage(img,0,0);
    ShowCaption();

    if(iw>0){
    	imgData=cntxBackBuffer.getImageData(0,0,iw,ih);
    	if(DrawingFinished){
            cntx.putImageData(imgData,imgMainLeft,imgMainTop);
    	}
    	else{
            timerLoop=setInterval(
                    function(){
                        drawSelectedImage(imgMainLeft,imgMainTop);
                    },
                    simSpeed);
    	}
    }
    
    cnvsWrite(LetterColor,fontSize-10,"Arial",-1,BottomPanelTop+67,"Κάνε διαδοχικά κλικ σε μια κατηγορία για να δεις ένα νέο παράδειγμα.");    

    //Πλαίσια μαύρου χρώματος
    cntx.strokeStyle="rgb(0,0,0)";
    cntx.beginPath();
    cntx.rect(0,0,width-1,TopPanelHeight);
    cntx.rect(0,TopPanelHeight,width-1,height-TopPanelHeight-BottomPanelHeight);
    cntx.rect(0,BottomPanelTop,width-1,BottomPanelHeight-1);
    if(iw>0){
        cntx.rect(imgMainLeft-1,imgMainTop-1,iw+1,ih+1);
    }
    cntx.stroke();
    cntx.drawImage(imgLogo,logoLeft,logoTop);
}

function drawSelectedImage(imgMainLeft,imgMainTop){
	imgData=cntxBackBuffer.getImageData(0,0,iw,ih);
	switch(effectSlctr){
	case 0:
	    effFadeIn();
		break;
	case 1:
		effHorizontal();
		break;
	case 2:
	    effVertical();
		break;
	case 3:
	    effRgbEffect();
		break;
	case 4:
	    effCircleEffect();
	    break;
        break;
	}
	//
	cntx.putImageData(imgData,imgMainLeft,imgMainTop);
}

function effFadeIn(){
	imgOpacity+=20;
	if(imgOpacity>255){
		DrawingFinished=true;
	    clearInterval(timerLoop);
	}
	else{
		for(var i=3;i<imgData.data.length;i+=4){
			imgData.data[i]=imgOpacity;
		}
	}
}

function effHorizontal(){
	var noOfPixels=iw*ih;
	visiblePixels+=iw;
	if(visiblePixels>noOfPixels/2){
		DrawingFinished=true;
	    clearInterval(timerLoop);
	}
	else{
		for(var i=visiblePixels;i<noOfPixels-visiblePixels;i++){
			imgData.data[4*i+3]=0;
		}
	}
}

function effVertical(){
	visibleColumns+=2;
	if(visibleColumns>iw/2){
		DrawingFinished=true;
	    clearInterval(timerLoop);
	}
	else{
		for(var i=0;i<=ih;i++){
			for(var j=visibleColumns;j<=iw-visibleColumns;j++){
				imgData.data[((i-1)*iw+j)*4+3]=0;
			}
		}
	}
}

function effRgbEffect(){
	rgbEffectStage++;
	if(rgbEffectStage>2){
		DrawingFinished=true;
	    clearInterval(timerLoop);
	}
	else{
		for(var i=0;i<iw*ih;i++){
			for(var component=rgbEffectStage;component<3;component++){
				imgData.data[4*i+component]=0;
			}
		}
	}
}

function effCircleEffect(){
    effectRadius+=10;
    if(effectRadius>Math.sqrt(Math.pow(iw,2)+Math.pow(ih,2))/radiusDenominatior){
        DrawingFinished=true;
        clearInterval(timerLoop);
    }
    else{
        for(var i=0;i<=ih;i++){
            for(var j=0;j<=iw;j++){
                var r=Math.sqrt(Math.pow(i-yCenterOffset,2)+Math.pow(j-xCenterOffset,2));
                if(r>effectRadius){
                    imgData.data[4*((i-1)*iw+j)+3]=0;
                }
            }
        }
    }
}

function getImagesData(){
    imgData=cntx.getImageData(width+10,10,iw,ih);
}

function drawLogoImage(){
    var picTop=(height-Intro.height)/2;
    var lowRectTop=picTop+Intro.height+1;
    var logoTop=lowRectTop+((height-lowRectTop)-imgLogo.height)/2;
    cntx.drawImage(imgLogo,width-imgLogo.width-2,logoTop);
}

function drawButtonNext(){
    //Διαχείριση κουμπιού [Επόμενο Βήμα]
    if (ButtonNextHover()){
        cntx.drawImage(imgNxtStepSelected,nxtStepLeft,nxtStepTop);
    }
    else{
        cntx.drawImage(imgNxtStepEnabled,nxtStepLeft,nxtStepTop);
    }
}

function ButtonNextHover(){
    if (mx>=nxtStepLeft && mx<=nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<=nxtStepTop+nxtStepHeight){
        return true;
    }
    else {
        return false;
    }
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseMove(evt){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else {
        imgLogo=document.getElementById("Logo");
        ShowProgramID=false;
    }
    
    for (i=0;i<NoOfCategories;i++) ButtonHover[i]=false;
    if (mx>=Column1Left && mx<=Column1Left+imgButtons[0].width){
        for (i=0;i<NoOfCategories/2;i++){
            if (my>Column1Top+(i+1)*imgButtons[0].height && my<Column1Top+(i+2)*imgButtons[0].height) ButtonHover[i]=true;
        }
    }
    else if (mx>=width-Column1Left-imgButtons[4].width && mx<=width-Column1Left){
        for (i=NoOfCategories/2;i<NoOfCategories;i++){
            if (my>Column1Top+(i-3)*imgButtons[4].height && my<Column1Top+(i-2)*imgButtons[4].height) ButtonHover[i]=true;
        }
    }
    
    if(DrawingFinished)drawBasicScreen();
    //console.log("mx="+mx+" , my="+my);
}

function handleMouseUp(evt){
    evt.preventDefault();
    isButtonPressed=false;
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight){
        if(MyInfo){
            ShowProgramID=!ShowProgramID;
        }
        else {
            showHTML();
        }
        drawBasicScreen();
    }
    
    if(DrawingFinished){
        var Found=false;

        if(mx>=nxtStepLeft && mx<nxtStepLeft+nxtStepWidth && my>=nxtStepTop && my<nxtStepTop+nxtStepHeight){
            Found=true;
        }
        
        var i=0;
        while(i<NoOfCategories && !Found){
            if (ButtonHover[i]){
                Found=true;
                SelectedCategory=i;
            }
            else {
                i++;
            }
        }
        if(Found){
            OpaquePercent=0;
            SelectImage(SelectedCategory);
            NextPic=true;
        }
        drawBasicScreen();
    }
}

function SelectImage(i){
    var SelectedFile;
    var AvailableFiles,FileNo;
    if(i==0){
        SelectedFile="administration";
        AvailableFiles=9;
    }
    else if(i==1){
        SelectedFile="education";
        AvailableFiles=13;
    }
    else if(i==2){
        SelectedFile="medicine";
        AvailableFiles=10;
    }
    else if(i==3){
        SelectedFile="research";
        AvailableFiles=12;
    }
    else if(i==4){
        SelectedFile="supermarket";
        AvailableFiles=9;
    }
    else if(i==5){
        SelectedFile="transport";           
        AvailableFiles=10;
    }
    else if(i==6){
        SelectedFile="trapeza";
        AvailableFiles=11;              
    }
    else{
        SelectedFile="prof";
        AvailableFiles=9;           
    }
    do{
        FileNo=parseInt(Math.random()*AvailableFiles+1);
    }while(FileNo==SelectedImage[i] || FileNo>AvailableFiles);
    SelectedImage[i]=FileNo;
    
    var downloadingImage=new Image();
    downloadingImage.onload=function(){
        img.src=this.src;
        iw=img.width;
        ih=img.height;
    	DrawingFinished=false;
    	selectEffect();
        drawBasicScreen();
    };
    
    //φόρτωση επιλεγμένης εικόνας
    downloadingImage.src="img/PIC"+SelectedFile+FileNo+".jpg";
    
    captionToShow=AvailableCaptions[i][FileNo-1];
}

function ShowCaption(){
    if(captionToShow!=""){
        cnvsWrite(LetterColor,16,"Arial",-1,BottomPanelTop+20,Sections[SelectedCategory]);
        cnvsWrite(LetterColor,18,"Arial",-1,BottomPanelTop+42,captionToShow);
    }
}

function InitialiseCaptions(){
    Sections[0]="ΔΗΜΟΣΙΑ ΔΙΟΙΚΗΣΗ";
    Sections[1]="ΕΚΠΑΙΔΕΥΣΗ";
    Sections[2]="ΙΑΤΡΙΚΗ";
    Sections[3]="ΕΡΕΥΝΑ";
    Sections[4]="ΣΟΥΠΕΡ ΜΑΡΚΕΤ";
    Sections[5]="ΣΥΓΚΟΙΝΩΝΙΕΣ";
    Sections[6]="ΤΡΑΠΕΖΑ";
    Sections[7]="ΕΠΑΓΓΕΛΜΑΤΑ";
    AvailableCaptions[0][0]="Οι Δημόσιες Υπηρεσίες με το πάτημα ενός κουμπιού";
    AvailableCaptions[0][1]="Διακρατικές Συνεργασίες";
    AvailableCaptions[0][2]="Ηλεκτρονική επικοινωνία";
    AvailableCaptions[0][3]="Το πληκτρολόγιο του Υπολογιστή μια πύλη για τον κόσμο";
    AvailableCaptions[0][4]="Τα Κέντρα Εξυπηρέτησης Πολιτών παρέχουν υπηρεσίες ηλεκτρονικά";
    AvailableCaptions[0][5]="Η Κάρτα του Πολίτη αυτοματοποιεί τις δοσοληψίες με το Δημόσιο";
    AvailableCaptions[0][6]="Υποβολή Δήλωσης μέσω Υπολογιστή";
    AvailableCaptions[0][7]="Γενική Γραμματεία Πληροφοριακών Συστημάτων";
    AvailableCaptions[0][8]="Ηλεκτρονική Υποβολή Αίτησης";
    AvailableCaptions[0][9]="";
    AvailableCaptions[0][10]="";
    AvailableCaptions[0][11]="";
    AvailableCaptions[0][12]="";
    AvailableCaptions[1][0]="Οι παραδοσιακές διδακτικές προσεγγίσεις συνδυάζονται με μοντέρνες";
    AvailableCaptions[1][1]="Δικτύωση Ελληνικών Εκπαιδευτικών Κέντρων και Σχολείων";
    AvailableCaptions[1][2]="Ποιός έχει το 'πάνω χέρι' σε θέματα τεχνολογίας;";
    AvailableCaptions[1][3]="Ηλεκτρονική μάθηση";
    AvailableCaptions[1][4]="Ταυτόχρονη πρόσβαση σε πολλές πηγές γνώσης";
    AvailableCaptions[1][5]="Πανελλήνιο Σχολικό Δίκτυο";
    AvailableCaptions[1][6]="Ο Κόσμος της Παιδείας αυτοματοποιείται";
    AvailableCaptions[1][7]="Μαθητικά Ιστολόγια και Εκπαιδευτικές Κοινότητες";
    AvailableCaptions[1][8]="Πανελλήνιο Σχολικό Δίκτυο";
    AvailableCaptions[1][9]="Πανελλήνιο Σχολικό Δίκτυο";
    AvailableCaptions[1][10]="Ηλεκτρονική Τάξη για μαθήματα εξ αποστάσεως και αυτοδιδασκαλία";
    AvailableCaptions[1][11]="Πληροφορίες μέσω διαδικτύου για εκπαιδευτικούς";
    AvailableCaptions[1][12]="Πρόγραμμα έκδοσης βαθμολογίας";
    AvailableCaptions[2][0]="Ο υπολογιστής βοηθά να ξεκλειδώσουμε τα μυστικά της ζωής";
    AvailableCaptions[2][1]="Ιατρικές εξετάσεις με εξοπλισμό που ελέγχεται από υπολογιστή";
    AvailableCaptions[2][2]="Ο Υπολογιστής συμβάλλει στην επιτυχέστερη διενέργεια επεμβάσεων";
    AvailableCaptions[2][3]="Ρομποτικοί βοηθοί για όλες τις ανάγκες";
    AvailableCaptions[2][4]="Επεμβάσεις ακριβείας με τη βοήθεια του Υπολογιστή";
    AvailableCaptions[2][5]="Ανάλυση αποτελεσμάτων με τη βοήθεια Υπολογιστή";
    AvailableCaptions[2][6]="Ανάλυση αποτελεσμάτων με τη βοήθεια Υπολογιστή";
    AvailableCaptions[2][7]="Ανάλυση αποτελεσμάτων με τη βοήθεια Υπολογιστή";
    AvailableCaptions[2][8]="Τα 'μάτια' του γιατρού";
    AvailableCaptions[2][9]="Ο Υπολογιστής στο ιατρικό εργαστήριο";
    AvailableCaptions[2][10]="";
    AvailableCaptions[2][11]="";
    AvailableCaptions[2][12]="";
    AvailableCaptions[3][0]="Σύγχρονο τηλεσκόπιο που κατασκευάζεται με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][1]="Ο Υπολογιστής δίνει μεγαλύτερη ακρίβεια στις αστρονομικές παρατηρήσεις";
    AvailableCaptions[3][2]="Ο Υπολογιστής χρησιμοποιείται για τον έλεγχο των σύγχρονων τηλεσκοπίων";
    AvailableCaptions[3][3]="Σχεδίαση εξοπλισμού με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][4]="Δημιουργία αντικειμένων με μηχανές που ελέγχονται από Υπολογιστή";
    AvailableCaptions[3][5]="Σχεδίαση ακριβείας με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][6]="Ο Υπολογιστής στην υπηρεσία της επιστημονικής έρευνας";
    AvailableCaptions[3][7]="Τεχνική Σχεδίαση με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][8]="Δημιουργία μοντέλων μηχανών και δοκιμαστικοί έλεγχοι";
    AvailableCaptions[3][9]="Σχεδίαση εξαρτημάτων με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][10]="Έλεγχος πτητικής ικανότητας με τη βοήθεια του Υπολογιστή";
    AvailableCaptions[3][11]="Σχεδίαση ειδικού εξοπλισμού με τη βοήθεια Υπολογιστή";
    AvailableCaptions[3][12]="";
    AvailableCaptions[4][0]="Οπτικός αναγνώστης κωδικών και τιμών προϊόντος";
    AvailableCaptions[4][1]="Οπτικός αναγνώστης κωδικών και τιμών προϊόντος";
    AvailableCaptions[4][2]="Ηλεκτρονικός υπολογισμός του λογαριασμού";
    AvailableCaptions[4][3]="Ταμείο χωρίς ταμία";
    AvailableCaptions[4][4]="Ηλεκτρονική ζυγαρία για τον υπολογισμό βάρους και κόστους";
    AvailableCaptions[4][5]="Ηλεκτρονική ζυγαρία για τον υπολογισμό βάρους και κόστους";
    AvailableCaptions[4][6]="Ηλεκτρονική ζυγαρία μη μνήμη για ένα πλήθος διαφορετικών προϊόντων";
    AvailableCaptions[4][7]="Υπολογιστής στη θέση ταμειακής μηχανής";
    AvailableCaptions[4][8]="Ηλεκτρονική ζυγαρία μη μνήμη για ένα πλήθος διαφορετικών προϊόντων";
    AvailableCaptions[4][9]="Εκτύπωση απόδειξης σε παράδοση κατ΄ οίκον";
    AvailableCaptions[4][10]="Ηλεκτρονική έκδοση απόδειξης/τιμολογίου";
    AvailableCaptions[4][11]="";
    AvailableCaptions[4][12]="";
    AvailableCaptions[5][0]="Εκτύπωση πληροφοριών μέσα στο όχημα";
    AvailableCaptions[5][1]="Παροχή πληροφοριών δρομολογίων";
    AvailableCaptions[5][2]="Ειδοποίηση για την άφιξη του επόμενου λεωφορείου";
    AvailableCaptions[5][3]="Μια κάρτα για όλες τις διαδρομές στο Μετρό";
    AvailableCaptions[5][4]="Αυτόματη χρέωση κατά τη διέλευση από διόδια";
    AvailableCaptions[5][5]="Μηδενική καθυστέρηση κατά τη διέλευση από διόδια";
    AvailableCaptions[5][6]="Η ΜΕΓΑΛΗ δύναμη του ΜΙΚΡΟ-τσιπ";       
    AvailableCaptions[5][7]="Αυτοματοποιημένη έκδοση εισιτηρίου";
    AvailableCaptions[5][8]="Μηχανές έκδοσης εισιτηρίων";
    AvailableCaptions[5][9]="Το εσωτερικό ενός αυτοματοποιημένου εκδοτηρίου";
    AvailableCaptions[5][10]="";
    AvailableCaptions[5][11]="";
    AvailableCaptions[5][12]="";
    AvailableCaptions[6][0]="Συναλλαγές με τη βοήθεια του Υπολογιστή";
    AvailableCaptions[6][1]="Αυτόματες Ταμειολογιστικές Μηχανές - ΑΤΜ";
    AvailableCaptions[6][2]="Ηλεκτρονική Τραπεζική";
    AvailableCaptions[6][3]="Το πληκτρολόγιο γίνετια πύλη συναλλαγών";
    AvailableCaptions[6][4]="Ο ηλεκτρονικός κουμπαράς";
    AvailableCaptions[6][5]="Πληρωμές χωρίς μετρητά";
    AvailableCaptions[6][6]="Το ηλεκτρονικό πορτοφόλι";
    AvailableCaptions[6][7]="Ηλεκτρονική Τραπεζική";
    AvailableCaptions[6][8]="Διεθνείς Συναλλαγές";
    AvailableCaptions[6][9]="Ο Υπολογιστής μας βοηθά να εξοφλούμε χωρίς μετρητά";
    AvailableCaptions[6][10]="Κάρτες πληρωμών";
    AvailableCaptions[6][11]="";
    AvailableCaptions[6][12]="";
    AvailableCaptions[7][0]="Έκδοση Κοινοχρήστων";
    AvailableCaptions[7][1]="Ηλεκτρονική Νομοθεσία";
    AvailableCaptions[7][2]="Ηλεκτρονική Νομοθεσία";
    AvailableCaptions[7][3]="Βιομηχανική Σχεδίαση";
    AvailableCaptions[7][4]="Τεχνολογία";
    AvailableCaptions[7][5]="Συνεργείο Αυτοκινήτων";
    AvailableCaptions[7][6]="Αρχιτεκτονική";
    AvailableCaptions[7][7]="Βιομηχανική Σχεδίαση";
    AvailableCaptions[7][8]="Ηλεκτρονικοί Ηθοποιοί";
    AvailableCaptions[7][9]="";
    AvailableCaptions[7][10]="";
    AvailableCaptions[7][11]="";
    AvailableCaptions[7][12]="";
}

function selectEffect(){
    //Επιλογή εφφέ
    effectSlctr=parseInt(Math.random()*noOfEffects);
    //Αρχικοποίηση παραμέτρων
    imgOpacity=0;
    visiblePixels=0;
    visibleColumns=0;
    rgbEffectStage=-1;
    effectRadius=0;
    simSpeed=10;
    switch(effectSlctr){
        case 3: //rgb
            simSpeed=200;
            break;
        case 4: //circle
            var centerSlctr=Math.random();
            if(centerSlctr<0.33){
                xCenterOffset=0;
                yCenterOffset=0;
                radiusDenominatior=1;
            }
            else if(centerSlctr<0.66){
                xCenterOffset=iw/2;
                yCenterOffset=ih/2;
                radiusDenominatior=2;
            }
            else{
                xCenterOffset=iw;
                yCenterOffset=ih;
                radiusDenominatior=1;
            }
            break;
    }
}