﻿/// <reference path="jquery/jquery-1.7.min.js" />
/// <reference path="jquery-ui/jquery-ui-1.8.16.custom.min.js" />
/// <reference path="draw/jquery.draw.js" />
/// <reference path="jQueryRotate/jQueryRotate.2.1.js" />

function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

jQuery.fn.reverse = function () {
    return this.pushStack(this.get().reverse(), arguments);
};

var posTurtleX = 0;
var posTurtleY = 0;
var degTurtle = 0;
var halfTurtleWidth = 0;
var halfTurtleHeight = 0;

var bPenDown = true;

var timeoutID = 0;
var loops = 0;
var MAX_LOOPS = 1000;
var SPEED = 200;
var MAX_SPEED = 1000;


var tab_counter = 1;
var $curTab = null;

function setMessage(strMsg) {
    $("#divMessage").html(strMsg);
}


function showDialog(strTitle, htmlContent, objButtons) {
    if (objButtons == null) {
        objButtons = {
            "Κλείσιμο": function () {
                $(this).dialog("close");
            } 
        };
    }

    $("#divDialog").dialog("destroy");
    $("#divDialog .content").html(htmlContent);
    $("#divDialog").dialog({
        resizable: false,
        title: strTitle,
        dialogClass: 'DialogMessage',
        height: 160,
        modal: true,
        buttons: objButtons
    });
}


function disableButtons(bToogle) {
    $("#btnPrev").button({ disabled: bToogle });
    $("#btnNext").button({ disabled: bToogle });
    $("#btnPlay").button({ disabled: bToogle });
}

function rotateTurtle(angle) {
    degTurtle += angle;
    var mod = degTurtle % 360;
    if (mod > 180)
        mod = mod - 360;
    degTurtle = mod;
    $("#imgTurtle").rotate(-degTurtle);
}

function moveTurtle(dist, bDraw, index) {
    if (bDraw == null)
        bDraw = true;
    if (index == null)
        index = -1;

    var oldX = posTurtleX;
    var oldY = posTurtleY;
    var rad = degTurtle * 0.0174532925;
    var l = $(".rightPage").offset().left;
    var t = $(".rightPage").offset().top;
    var w = $(".rightPage").innerWidth();
    var h = $(".rightPage").innerHeight();

    var pos;
    var curClass = (index != -1) ? "poolLine" + index : "";
    var options = {};
    options.stroke = 2;
    options.color = (bDraw == true) ? "red" : "transparent";
    options.strClass = curClass;
    pos = $("#myCanvas").drawVector(oldX, oldY, dist, rad, options, { left: l, top: t, width: w, height: h });


    posTurtleX = pos.x;
    posTurtleY = pos.y;

    $("#imgTurtle").css("position", "absolute");
    $("#imgTurtle").css("left", (posTurtleX - halfTurtleWidth) + "px");
    $("#imgTurtle").css("top", (posTurtleY - halfTurtleHeight) + "px");
}

function animateTo($source, $animTarget, $appendTarget, $spanNumber) {

    $source.css("position", "relative");

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";


    $source.animate(
    {
        "left": strLeft,
        "top": strTop
    },
    {
        duration: 500,
        easing: "easeOutExpo",
        complete: function () {
            $(this).appendTo($appendTarget);
            $(this).css("position", "static");

            //if ($(this).hasClass("line"))
            //    createLineEvents($(this));

            var $selLine = $(".selected:first");
            if ($selLine.size() > 0)
                animateLine($selLine, $animTarget, $appendTarget, $spanNumber);
            else {
                var $selGroup = $(".group:first");
                if ($selGroup.size() > 0)
                    animateGroup($selGroup, $spanNumber);
            }
        },
        queue: true
    });
}

function animateGroupTo($source, $animTarget) {

    $source.css("position", "relative");

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";


    $source.animate(
    {
        "left": strLeft,
        "top": strTop
    },
    {
        duration: 750,
        easing: "easeOutExpo",
        complete: function () {
            var index = parseInt($source.attr("index"));
            $animTarget.html(index + 1);
            $source.remove();
            var $selGroup = $(".group:first");
            if ($selGroup.size() > 0)
                animateGroup($selGroup, $animTarget);
        },
        queue: true
    }
    );
}

function animateGroup($selGroup, $animTarget) {
    var index = $selGroup.attr("index");
    var $animGroup = $(".group" + index, $curTab);
    animateGroupTo($animGroup, $animTarget);
}

function animateLine($selLine, $animTarget, $appendTarget, $spanNumber) {
    removeLineButtons($selLine);
    removeControls($selLine);
    $selLine.removeClass("highlightLine");
    $selLine.removeClass("highlightRunLine");
    $selLine.removeClass("selected");
    var strCloneCommand = $(".spanCommand:first", $selLine).text();


    if ((strCloneCommand != "μπ") && (strCloneCommand != "πι") && (strCloneCommand != "αρ") && (strCloneCommand != "δε") && (strCloneCommand != "επανάλαβε")) {
        $(".spanNumber:first", $selLine).addClass("spanHidden").text("1");
    }

    animateTo($selLine, $animTarget, $appendTarget, $spanNumber);
}




function clearBoard() {
    $(".drawElement").remove();
    var cx = ($("#myCanvas").innerWidth() / 2);
    var cy = ($("#myCanvas").innerHeight() / 2);

    cx += $("#myCanvas").offset().left;
    cy += $("#myCanvas").offset().top;

    posTurtleX = cx;
    posTurtleY = cy;
    degTurtle = 0;

    rotateTurtle(90);
    moveTurtle(0, false, -1);
}

function parseCommand($command, index) {
    if (index == null)
        index = -1;

	var strCommand = $.trim($(".spanCommand", $command).text());
	var strNumber = $.trim($(".spanNumber", $command).text());
	if (strCommand == "στκ")
		bPenDown = true;
	if (strCommand == "στα")
		bPenDown = false;
	if (strCommand == "αρ") {
		rotateTurtle(parseInt(strNumber));
	}
	if (strCommand == "δε") {
		rotateTurtle(-parseInt(strNumber));
	}
	if (strCommand == "μπ") {
		moveTurtle(parseInt(strNumber), bPenDown, index);
	}
	if (strCommand == "πι") {
		moveTurtle(-parseInt(strNumber), bPenDown, index);
	}
	if (strCommand == "σβγ") {
		clearBoard();
	}
}

function runCode($commands, index) {
    if (index == null)
        index = -1;

    $commands.children().each(function (idx) {
        var $command = $(this);
        if ($command.hasClass("blockCommand")) {
            var strCommand = $(".line:first .spanCommand", $command).text();
            var strNumber = $(".line:first .spanNumber", $command).text();
            if (strCommand == "επανάλαβε") {
                var loops = parseInt(strNumber);
                var $block = $(".block:first", $command);
                var i;
                for (i = 0; i < loops; i++)
                    runCode($block, index);
            }
        }
        else {
            if ($command.hasClass("blockProcedure")) {
                var strProcedure = $(".spanCommand:first", $command).text();
                //var $tabProcedure = $("#tab-" + strProcedure);
                var $tabProcedure = $("#" + $command.attr("name"));
                //alert("Running " + strProcedure);
                runCode($(".block:first", $tabProcedure), index);
            }
            else {
                if ($command.hasClass("line")) {
                    parseCommand($command, index);
                }
            }
        }
   });
}

function runCodeLoops(numLoops) {
    if (loops % 10 == 0)
        clearBoard();
    var $tabProcedure = $("#tab-1");
    var $tabProcedure = $("#tabMain");
    runCode($(".block:first", $tabProcedure));
    loops++;
    if (loops < numLoops) {
        timeoutID = setTimeout(function () {
            runCodeLoops(numLoops);
        }, SPEED);
    }
}


function addLinePool($codeLine, $tab, strClass) {
    $newLine = $codeLine.clone();

    if (strClass != null)
        $newLine.addClass(strClass);

    $newLine.removeClass("highlightRunLine");
    $newLine.removeClass("highlightLine");
    $newLine.attr("tab", $tab.attr("id"));
    $newLine.data("codeLine", $codeLine);
    $("#divPool").append($newLine);
}

function createLinesPool($commands, $tab) {
    $commands.children().each(function (idx) {
        var $divLine = $(this);
        if ($divLine.hasClass("blockCommand")) {
            var strCommand = $(".line:first .spanCommand", $divLine).text();
            var strNumber = $(".line:first .spanNumber", $divLine).text();
            if (strCommand == "επανάλαβε") {
                var loops = parseInt(strNumber);
                var $block = $(".block:first", $divLine);
                var i;
                for (i = 0; i < loops; i++) {
                    var $blockHeader = $(".blockHeader:first", $divLine);
                    addLinePool($blockHeader, $tab, "dummy");

                    createLinesPool($block, $tab);

                    var $blockEnd = $(".blockEnd:last", $divLine);
                    addLinePool($blockEnd, $tab, "dummy");
                }
            }
        }
        else
            if ($divLine.hasClass("blockProcedure")) {
                var strProcedure = $(".spanCommand:first", $divLine).text();
                //var $tabProcedure = $("#tab-" + strProcedure);
                var $tabProcedure = $("#" + $divLine.attr("name"));
                //alert("Running " + strProcedure);

                /*
                // step-into start
                addLinePool($divLine, $tab, "dummy");
                var $blockStart = $(".blockStart:first", $tabProcedure);
                addLinePool($blockStart, $tabProcedure, "dummy");

                createLinesPool($(".block:first", $tabProcedure), $tabProcedure);

                var $blockEnd = $(".blockEnd:last", $tabProcedure);
                addLinePool($blockEnd, $tabProcedure, "dummy");
                // step-into end
                */

                
                // Uncomment this block to enable step-over in procedures.
                // Don't forget to do the same in runNextPoolLine()
                addLinePool($divLine, $tab, "blockProcedure");
                

            }
            else
                if ($divLine.hasClass("line")) {
                    addLinePool($divLine, $tab);
                }
    });
}

function runNextPoolLine() {
    var $poolLine = $(".highlightRunLine:first", $("#divPool"));
    var $poolNextLine = $poolLine.next();

    $(".line, .blockStart, .blockEnd, .blockHeader", $(".leftPage")).removeClass("highlightRunLine");
    $(".line, .blockStart, .blockEnd, .blockHeader", $("#divPool")).removeClass("highlightRunLine");

    var poolIndex = $poolLine.index();
    if ($poolLine.hasClass("dummy") == false)
        parseCommand($poolLine, poolIndex);

    
    // Uncomment this block to enable step-over in procedures
    // Don't forget to do the same in createLinesPool()
    if ($poolLine.hasClass("blockProcedure")) {
        var strProcedure = $(".spanCommand:first", $poolLine).text();
        //var $tabProcedure = $("#tab-" + strProcedure);
        var $tabProcedure = $("#" + $poolLine.attr("name"));
        //alert("Running " + strProcedure);
        runCode($(".block:first", $tabProcedure), poolIndex);
    }


    var $divLine;
    if ($poolNextLine.size() > 0) {
        $divLine = $poolNextLine.data("codeLine");
        $divLine.addClass("highlightRunLine");
        $poolNextLine.addClass("highlightRunLine");
        var tabId = $poolNextLine.attr("tab");
        $(".leftPage").tabs('select', '#' + tabId);
    }
    else {
        $("#btnNext").button("option", "disabled", true);
        $("#btnPrev").button("option", "disabled", true);
    }
}

function undoCommand($command) {
    var index = $command.index();
    var strCommand = $.trim($(".spanCommand", $command).text());
    var strNumber = $.trim($(".spanNumber", $command).text());
    if (strCommand == "στκ")
        bPenDown = false;
    if (strCommand == "στα")
        bPenDown = true;
    if (strCommand == "δε") {
        rotateTurtle(parseInt(strNumber));
    }
    if (strCommand == "αρ") {
        rotateTurtle(-parseInt(strNumber));
    }
    if (strCommand == "μπ") {
        $(".poolLine" + index, $("#myCanvas")).remove();
        moveTurtle(-parseInt(strNumber), false, index);
    }
    if (strCommand == "πι") {
        $(".poolLine" + index, $("#myCanvas")).remove();
        moveTurtle(parseInt(strNumber), false, index);
    }
//    if (strCommand == "σβγ") {
//        clearBoard();
//    }
}

function undoPoolLine() {
    var $curPoolLine = $(".highlightRunLine:first", $("#divPool"));
    var index = $curPoolLine.index();
    if (index > 0) {
        $(".line, .blockStart, .blockEnd, .blockHeader", $(".leftPage")).removeClass("highlightRunLine");
        $(".line, .blockStart, .blockEnd, .blockHeader", $("#divPool")).removeClass("highlightRunLine");
        var $divLine;
        var $poolPrevLine = $curPoolLine.prev();

        if ($poolPrevLine.hasClass("blockProcedure") == true) {
            index = $poolPrevLine.index();
            $(".poolLine" + index, $("#myCanvas")).remove();
        }
        else {
            if ($poolPrevLine.hasClass("dummy") == false)
                undoCommand($poolPrevLine);
        }

        $divLine = $poolPrevLine.data("codeLine");

        $divLine.addClass("highlightRunLine");
        $poolPrevLine.addClass("highlightRunLine");

        var tabId = $poolPrevLine.attr("tab");
        $(".leftPage").tabs('select', '#' + tabId);
    }
    else
        $("#btnPrev").button("option", "disabled", true);
}

function createNewLine() {
    return $('<div class="line"><span class="spanCommand">μπ</span><span class="spanNumber">1</span></div>');
}




function resetCode() {
    clearBoard();
    bPenDown = true;
    loops = 0;
    clearTimeout(timeoutID);
    timeoutID = -1;
    $("#divPool").html("");
    $(".line, .blockStart, .blockEnd", $(".leftPage")).removeClass("highlightRunLine");
    //$(".leftPage *").removeClass("highlightRunLine").removeClass("selected");
    $("#btnNext").button("option", "disabled", false);
    $("#btnPrev").button("option", "disabled", true);
}



function addTab($tabs) {
    var strTabName = prompt("Δώστε όνομα για την νέα διαδικασία:", "Διαδικασία" + (tab_counter + 1));
    if (strTabName != null) {
        strTabName = $.trim(strTabName);
        if (strTabName == "") {
            showDialog("Προσοχή", "Πρέπει να δώσετε όνομα!");
            return "";
        }
        if (strTabName.indexOf(" ") != -1) {
            showDialog("Προσοχή", "Δεν επιτρέπονται τα κενά στο όνομα!");
            return "";
        }
        if (strTabName.length > 15) {
            showDialog("Προσοχή", "Επιτρέπονται ονόματα μέχρι 15 χαρακτήρες.");
            return "";
        }
        if ( ($("#ddlCommandsHidden > option[value='" + strTabName + "']").size() != 0) ||
             (strTabName == "Κεντρικό")) 
        {
            showDialog("Προσοχή", "Η διαδικασία υπάρχει ήδη!");
            return "";
        }
        var $newCommand = $("<option>" + strTabName + "</option>")
            .attr("value", strTabName);
        $("#ddlCommandsHidden").append($newCommand);
        $tabs.tabs("add", "#tab-" + strTabName, strTabName);
        return strTabName;
    }
    return "";
}


function createTabs() {
    var $tabs = $(".leftPage").tabs({
        tabTemplate: "<li><a href='#{href}'>#{label}</a><span class='ui-icon ui-icon-close' title='Διαγραφή διαδικασίας'>Διαγραφή  διαδικασίας</span></li>",
        panelTemplate: "<div><code class='procedure'><div class='blockStart'>για <span class='spanName'></span></div><div class='block'></div><div class='blockEnd'>τέλος</div></code></div>",
        add: function (event, ui) {
            tab_counter++;

            var strTabName = $(ui.tab).text();
            $(".spanName", $(ui.panel)).html(strTabName);
            $("code", $(ui.panel)).attr("name", strTabName);
            createBlockHeaderEvents();
            //$tabs.tabs('select', '#' + ui.panel.id);
            //$tabs.find(".ui-tabs-nav").sortable({ axis: "x" });
        },
        select: function (event, ui) {
            $curTab = $(ui.panel);
            $(".line", $(".leftPage")).removeClass("selected");
        }
    });

//    $(".leftPage span.ui-icon-close").live("click", function () {
//        var index = $("li", $tabs).index($(this).parent());
//        if (index != 0) {
//            var strTabName = $(this).parent().children("a:first").text();
//            if (confirm("Η διαδικασία " + strTabName + " θα διαγραφεί. Είστε σίγουροι;")) {
//                $("#ddlCommandsHidden > option[value='" + strTabName + "']").remove();
//                $tabs.tabs("remove", index);
//                resetCode();
//            }
//        }
//    }).
//    disableSelection();

//    $(".leftPage li span.ui-icon-plus").click("click", function () {
//        if (addTab($tabs) != "")
//            resetCode();
//    }).
//    disableSelection();


    $curTab = $("#tabMain");

}

$(document).ready(function () {

    halfTurtleWidth = ($("#imgTurtle").outerWidth() / 2);
    halfTurtleHeight = ($("#imgTurtle").outerHeight() / 2);

    $("#myCanvas").hover(function () {
        $("#imgTurtle").stop(true, false);
        $("#imgTurtle").animate({ opacity: 0.1 });
    },
    function () {
        $("#imgTurtle").stop(true, false);
        $("#imgTurtle").animate({ opacity: 1.0 });
    });

    clearBoard();

    createTabs();

    $("#btnPlay").button({
        text: false,
        icons: {
            primary: "ui-icon-play"
        }
    }).
    click(function () {
        var $code = $("code", $curTab);
        var strName;
        strName = $code.attr("name");

        if ($code.hasClass("program")) {
            resetCode();
            if ($(".toggle:first").is(":visible")) {
                runCodeLoops(10);
            }
            else
                runCodeLoops(MAX_LOOPS);
        }
        else {
            showDialog("Εκτέλεση διαδικασίας", "Εκτέλεση " + strName, {
                "OK": function () {
                    $(this).dialog("close");
                    resetCode();
                    runCode($(".block:first", $code));
                },
                "Άκυρο": function () {
                    $(this).dialog("close");
                }
            });
        }
    });

    $("#btnRestart").button({
        text: false,
        icons: {
            primary: "ui-icon-refresh"
        }
    })
    .click(function () {
        resetCode();
        $(".line, .blockCommand", $(".leftPage")).removeClass("selected");
        $("#btnConvert").button("option", "disabled", true);
        $("#btnConvertProcedure").button("option", "disabled", true);
    });

    $("#btnNext").button({
        text: false,
        icons: {
            primary: "ui-icon-seek-next",
            secondary: "ui-icon-grip-dotted-horizontal"
        }
    })
    .click(function () {
        if ($(".highlightRunLine", $("#divPool")).size() == 0) {
            resetCode();
            //$(".toggle:eq(1)").slideUp("fast");
            var $code = $("code", $curTab);
            if ($code.hasClass("program")) {
                $(".toggle:eq(0)").slideDown("fast");
                $(".toggle:eq(1)").slideUp();
            }
            else {
                $(".toggle:eq(0)").show();
                $(".toggle:eq(1)").hide();
            }
            createLinesPool($(".program"), $("#tabMain"));
            $(".line:first", $("#divPool")).addClass("highlightRunLine");
            //$(".line:not(.blockHeader)", $(".program")).first().addClass("highlightRunLine");
            $(".line", $(".program")).first().addClass("highlightRunLine");
            $("#btnPrev").button("option", "disabled", false);
            $(".leftPage").tabs('select', '#tabMain');
        }
        else {
            //$(".toggle:eq(0)").slideDown("fast");
            //$(".toggle:eq(1)").slideUp("fast");
            $(".toggle:eq(0)").show();
            $(".toggle:eq(1)").hide();
            runNextPoolLine();
        }
    });

    $("#btnPrev").button({
        text: false,
        icons: {
            primary: "ui-icon-grip-dotted-horizontal",
            secondary: "ui-icon-seek-prev"
        },
        disabled: true
    })
    .click(function () {
        if ($(".highlightRunLine:first", $("#divPool")).index() > 0) {
            undoPoolLine();
        }
    });

    $("#sliderSpeed").slider({
        range: "min",
        value: MAX_SPEED / 2,
        min: 20,
        max: MAX_SPEED,
        slide: function (event, ui) {
            //$("#amount").val("$" + ui.value);
            SPEED = MAX_SPEED - ui.value;
        }
    });

    $(".toggle span.ui-icon").click(function () {
        //        $(".toggle:eq(0)").slideToggle("fast", function () {
        //            $(".toggle:eq(1)").slideToggle("fast");
        //        });
        $(".toggle").slideToggle("fast");
        resetCode();
    });
});