﻿/// <reference path="jquery/jquery-1.7.min.js" />
/// <reference path="jquery-ui/jquery-ui-1.8.16.custom.min.js" />
/// <reference path="draw/jquery.draw.js" />


jQuery.fn.reverse = function () {
    return this.pushStack(this.get().reverse(), arguments);
};


var nStep = 0;
var StepMessage = [ "Πατήστε Έναρξη για να ξεκινήσετε.",
                    "Παρατηρώντας το παραπάνω πρόγραμμα βλέπουμε ότι οι εντολές <b>μπ 100</b> και <b>δε 90</b> επαναλαμβάνονται 4 φορές.",
                    "Μπορούμε να έχουμε το ίδιο αποτέλεσμα ομαδοποιώντας τις δύο εντολές σε μία εντολή που να τις επαναλαμβάνει 4 φορές.",
                    "Η εντολή αυτή είναι η : <code><b>επανέλαβε</b> <i>αριθμός_επαναλήψεων</i> <b>[</b><i>λίστα οδηγιών</><b>]</b></code>.",
                    "Μέσα στις αγκύλες <b>[&nbsp;]</b> εσωκλείουμε τις εντολές που θέλουμε να επαναληφθούν.",
                    "Η εκτέλεση των εντολών επαναλαμβάνεται όσο αυξάνει ο μετρητής των επαναλήψεων.",
                    "Η εκτέλεση των εντολών επαναλαμβάνεται όσο αυξάνει ο μετρητής των επαναλήψεων.",
                    "Η εντολή <code><b>επανέλαβε</b></code> επαναλαμβάνει τις εντολές όσες φορές ορίζει ο <code><i>αριθμός_επαναλήψεων</i></code>."
                  ];

function stopGroupAnimations() {
    $(".group").stop(false, true);
}

function slideCommand(strElement, bShow) {
    stopGroupAnimations();
    disableButtons(true);
    $(strElement).stop(true, true);
    if (bShow) {
        $("#divEpanelave").css("visibility", "visible");
        $(strElement).css("display", "inline");
        $(strElement).show("slide", 1000, function () {
            disableButtons(false);
        });
    }
    else {
        $(strElement).hide("slide", 1000, function () {
            $("#divEpanelave").css("visibility", "hidden");
            $(strElement).css("display", "none");
            disableButtons(false);
        });
    }
}

function setMessage(nStep) {
    $("#divMessage").html(StepMessage[nStep]);
}

function disableButtons(bToogle) {
    $("#btnPrev").button({ disabled: bToogle });
    $("#btnNext").button({ disabled: bToogle });
    $("#btnPlay").button({ disabled: bToogle });
}

function pulsateLeftPage(nTimes, duration) {

    stopGroupAnimations();

    disableButtons(true);

    $(".leftPage .group1").show("pulsate", { times: nTimes }, duration, function () {
        $(".leftPage .group2").show("pulsate", { times: nTimes }, duration, function () {
            $(".leftPage .group3").show("pulsate", { times: nTimes }, duration, function () {
                $(".leftPage .group4").show("pulsate", { times: nTimes }, duration, function () {
                    disableButtons(false);
                });
            });
        });
    });
}

function animateGroupTo(nGroup, strAnimate, strAppend) {

    if (strAppend == null)
        strAppend = "#spanGroup";

    var $source = $(".leftPage .group" + nGroup);
    var $animTarget = $(strAnimate);
    var $appendTarget = $(strAppend);

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";

    stopGroupAnimations();
    disableButtons(true);

    $source.animate(
        {
            "left": strLeft,
            "top": strTop
        },
        1000,
        "easeOutExpo",
        function () {
            if (nGroup > 1)
                $(this).hide("explode", "slow", function () {
                    $(this).appendTo($appendTarget);
                    $(this).css("position", "static");
                    disableButtons(false);
                });
            else {
                $(this).appendTo($appendTarget);
                $(this).css("position", "static");
                disableButtons(false);
            }
            switch (nGroup) {
                case 1:
                    $("#myCanvas").drawPolygon([515, 515], [318, 218], { color: "red", stroke: 2 });
                    $("#imgTurtle").css("left", "500px");
                    $("#imgTurtle").css("top", "200px");
                    $("#imgTurtle").attr("src", "images/turtleLeft.png");
                    break;
                case 2:
                    $("#myCanvas").drawPolygon([515, 615], [218, 218], { color: "red", stroke: 2 });
                    $("#imgTurtle").css("left", "600px");
                    $("#imgTurtle").css("top", "200px");
                    $("#imgTurtle").attr("src", "images/turtleDown.png");
                    break;
                case 3:
                    $("#myCanvas").drawPolygon([615, 615], [218, 318], { color: "red", stroke: 2 });
                    $("#imgTurtle").css("left", "600px");
                    $("#imgTurtle").css("top", "300px");
                    $("#imgTurtle").attr("src", "images/turtleRight.png");
                    break;
                case 4:
                    $("#myCanvas").drawPolygon([615, 515], [318, 318], { color: "red", stroke: 2 });
                    $("#imgTurtle").css("left", "500px");
                    $("#imgTurtle").css("top", "300px");
                    $("#imgTurtle").attr("src", "images/turtleUp.png");
                    break;
            }
            $("#spanTimes").text(nGroup);
        });
}

function animateGroupBackTo(nGroup, strAnimate, strInsBefore, bStopAnimations) {

    if (bStopAnimations == null)
        bStopAnimations = true;
    if (bStopAnimations == true)
        stopGroupAnimations();

    disableButtons(true);

    var $source = $(".leftPage .group" + nGroup);
    $source.css("position", "relative");
    $source.css("left", "");
    $source.css("top", "");
    $source.css("display", "");

    var $InsBefore = $(strInsBefore);
    var $animTarget = $(strAnimate);

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";


    $source.animate(
        {
            "left": strLeft,
            "top": strTop
        },
        1000,
        "easeOutExpo",
        function () {
            $(this).css("left", "");
            $(this).css("top", "");
            $(this).insertBefore($InsBefore);


            switch (nGroup) {
                case 1:
                    $("#myCanvas").drawPolygon([515, 515], [318, 218], { color: "#EAEAEA", stroke: 2 });
                    $("#imgTurtle").css("left", "500px");
                    $("#imgTurtle").css("top", "300px");
                    $("#imgTurtle").attr("src", "images/turtleUp.png");
                    break;
                case 2:
                    $("#myCanvas").drawPolygon([515, 615], [218, 218], { color: "#EAEAEA", stroke: 2 });
                    $("#imgTurtle").css("left", "500px");
                    $("#imgTurtle").css("top", "200px");
                    $("#imgTurtle").attr("src", "images/turtleLeft.png");
                    break;
                case 3:
                    $("#myCanvas").drawPolygon([615, 615], [218, 318], { color: "#EAEAEA", stroke: 2 });
                    $("#imgTurtle").css("left", "600px");
                    $("#imgTurtle").css("top", "200px");
                    $("#imgTurtle").attr("src", "images/turtleDown.png");
                    break;
                case 4:
                    $("#myCanvas").drawPolygon([615, 515], [318, 318], { color: "#EAEAEA", stroke: 2 });
                    $("#imgTurtle").css("left", "600px");
                    $("#imgTurtle").css("top", "300px");
                    $("#imgTurtle").attr("src", "images/turtleRight.png");
                    break;
            }
           
           
            disableButtons(false);
        });
    
    $("#spanTimes").text(nGroup - 1);
}

function nextStep() {
    if (nStep < 7) {
        nStep++;
        setMessage(nStep);
        switch (nStep) {
            case 1:
                //pulsateLeftPage(3, 500);
                break;
            case 2:
                //animateGroupTo(0, ".rightPage code", ".rightPage code");
                $("#divEpanelave").css("display", "inline");
                $("#divEpanelave").css("visibility", "hidden");
                $("#spanTimes").text(0);
                break;
            case 3:
                slideCommand("#divEpanelave", true);
                break;
            case 4:
                animateGroupTo(1, "#spanGroup", "#spanGroup");
                break;
            case 5:
                animateGroupTo(2, "#spanTimes", "#spanGroup");
                break;
            case 6:
                animateGroupTo(3, "#spanTimes", "#spanGroup");
                break;
            case 7:
                animateGroupTo(4, "#spanTimes", "#spanGroup");
                break;

        }
    }
}

$(document).ready(function () {

    $("#btnPlay").button({
        text: false,
        icons: {
            primary: "ui-icon-play"
        }
    }).
    click(function () {
        disableButtons(false);
        $(this).button("option", "label", "Έναρξη από την αρχή");
        if (nStep > 0) {
            //animateGroupBackTo(0, ".leftPage code");
            $("#divEpanelave").css("display", "inline");
            $("#divEpanelave").css("visibility", "hidden");
            $("#spanTimes").text(0);
            slideCommand("#divEpanelave", false);
            animateGroupBackTo(4, ".leftPage .group0", ".leftPage .group0");
            animateGroupBackTo(3, ".leftPage .group0", ".leftPage .group0");
            animateGroupBackTo(2, ".leftPage .group0", ".leftPage .group0");
            animateGroupBackTo(1, ".leftPage .group0", ".leftPage .group0");
        }
        nStep = 0;
        nextStep();
    });

    $("#btnPrev").button({
        text: false,
        disabled: true,
        icons: {
            primary: "ui-icon-seek-prev"
        }
    })
    .click(function () {
        if (nStep > 1) {
            switch (nStep) {
                case 1:
                    pulsateLeftPage(3, 500);
                    break;
                case 2:
                    $("#divEpanelave").css("display", "none");
                    $("#divEpanelave").css("visibility", "hidden");
                    $("#spanTimes").text(0);
                    //pulsateLeftPage(3, 500);
                    break;
                case 3:
                    slideCommand("#divEpanelave", false);
                    break;
                case 4:
                    animateGroupBackTo(1, ".leftPage .group0", ".leftPage .group0");
                    break;
                case 5:
                    animateGroupBackTo(2, ".leftPage .group0", ".leftPage .group0");
                    break;
                case 6:
                    animateGroupBackTo(3, ".leftPage .group0", ".leftPage .group0");
                    break;
                case 7:
                    animateGroupBackTo(4, ".leftPage .group0", ".leftPage .group0");
                    break;

            }
            nStep--;
            setMessage(nStep);
        }
    });

    $("#btnNext").button({
        text: false,
        disabled: true,
        icons: {
            primary: "ui-icon-seek-next"
        }
    })
    .click(function () {
        nextStep();
    });

});