var canvas;
var cntx;
var cnvBackBuffer;
var cntxBackBuffer;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    CheckButtons();
    drawBasicScreen();
}
      
function initialiseEvents(){
    $("#visualisation").on("mousedown touchstart",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });
    
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });
    
    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });
} 

function initialiseGUI(){

}

function initialValues(){
    $("#resolutionSlctr").val("800x600");
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;

    ByteTop=35*height/100;
    ByteLeft=(width-(NoOfDigitsPerPlaceHolder*BitWidth+2*BitBorder)*NoOfBits)/2;
    for(var i=0;i<NoOfBits;i++){
        bits[i]=0;
    }

}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    
    drawFrames();
    drawLogoImage();
    
    var promptYCoord=BottomPanelTop+25;
    var prompt="";
    var promptColor=LetterColor;
    prompt="Κάνε κλικ στα ψηφία για να αλλάξεις την τιμή τους.";
    cnvsWrite(promptColor,fontSize-6,"Arial",-1,promptYCoord,prompt);
    promptYCoord+=28;

    DrawBytePlaceHolder();
    DrawByte();
}

function drawFrames(){
    cntx.fillStyle="white";
    cntx.strokeStyle="black";
    cntx.beginPath();
    //Περιοχή σχεδίασης
    cntx.fillRect(0,TopPanelHeight,width,height-TopPanelHeight-BottomPanelHeight);
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,TopPanelHeight);
    //κάτω πλαίσιο
    cntx.rect(0,BottomPanelTop,width,BottomPanelHeight);

    cntx.stroke();
    cnvsWrite(LetterColor,32,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
}

function drawLogoImage(){
    cntx.drawImage(imgLogo,logoLeft,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleMouseDown(){
    drawBasicScreen();
}

function handleMouseMove(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    if (MouseOverByte()){
        SelBit=parseInt((mx-ByteLeft)/(NoOfDigitsPerPlaceHolder*BitWidth));
    }
    else{
        SelBit=-1;
    }
    drawBasicScreen();
    //console.log("mx="+mx+" , my="+my+" ,infoSwitchHover="+infoSwitchHover+" ,coordSwitchHover="+coordSwitchHover);
}

function handleMouseUp(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        showHTML();
    }
    if(SelBit>=0){
        bits[SelBit]=(1-bits[SelBit]);
        CheckButtons();
    }    
    drawBasicScreen();
}

function Dec2Bin(sum){
    for(var i=0;i<NoOfBits;i++){
        bits[NoOfBits-1-i]=sum % 2;
        sum=parseInt(sum/2);
    }
}

function MouseOverByte(){
    if(mx>=ByteLeft && mx<=ByteLeft+NoOfDigitsPerPlaceHolder*NoOfBits*BitWidth+BitBorder && my<=ByteTop-BitBorder && my>=ByteTop-BitBorder-fontSize){
        return true;
    }
    else{
        return false;
    }
}

function DrawByte(){
    var X1,X2,msgWidth;
    var message;
    var bitColor;
    for(var i=0;i<NoOfBits;i++){
        X1=ByteLeft+NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder;
        X2=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder;
        message=""+bits[i];
        msgWidth=cntx.measureText(message).width;
        if(i==SelBit){
            bitColor="rgb(0,215,255)";
        }
        else{
            bitColor="rgb(0,0,0)";
        }
        cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder,message);
    }
}

function DrawBytePlaceHolder(){
    var X1,X2,msgWidth,value,sum=0;
    var message;
    var bitColor=0;
    //Σχεδίαση θέσεων
    cntx.strokeStyle=FactorsColor;
    cntx.beginPath();
    for(var i=0;i<NoOfBits;i++){
        X1=ByteLeft+NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder;
        X2=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder;
        cntx.moveTo(X1,ByteTop);
        cntx.lineTo(X2,ByteTop);
        
        cntx.moveTo(X1,ByteTop);
        cntx.lineTo(X1,ByteTop-BitBorder);
        
        cntx.moveTo(X2,ByteTop);
        cntx.lineTo(X2,ByteTop-BitBorder);
        value=parseInt(Math.pow(2,NoOfBits-i-1));
        message=""+value;
        msgWidth=cntx.measureText(message).width;
        //Σχεδίαση αξίας θέσης
        if(bits[i]==0){
            bitColor=ColOff;
        }
        else{
            bitColor=ColOn;
        }
        cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop+8*BitBorder,message);

        value=value*bits[i];
        message=""+value;
        msgWidth=cntx.measureText(message).width;
        sum=sum+value;
        cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop+20*BitBorder,message);
        if(i<NoOfBits-1){
            message="+";
            msgWidth=cntx.measureText(message).width;
            X1=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder;
            X2=ByteLeft+NoOfDigitsPerPlaceHolder*(i+1)*BitWidth+BitBorder;
            cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop+20*BitBorder,message);
        }
    }
    cntx.stroke();
    X2=ByteLeft+NoOfDigitsPerPlaceHolder*NoOfBits*BitWidth+BitBorder;
    cnvsWrite(ColOn,fontSize,"Arial",X2,ByteTop+20*BitBorder,"= "+sum);
}

function CheckButtons(){
    var sum=CalculateSum();
    if(sum==255){
        $("#increment").prop("disabled",true);
    }
    else{
        $("#increment").prop("disabled",false);
    }
    if(sum==0){
        $("#decrement").prop("disabled",true);
    }
    else{
        $("#decrement").prop("disabled",false);
    }
}

function CalculateSum(){
    var sum=0;
    for(var i=0;i<NoOfBits;i++){
        sum=sum+parseInt(Math.pow(2,NoOfBits-i-1)*bits[i]);
    }
    return sum;
}

function actionPerformed(btnSlctr){
    var sum=CalculateSum();
    if(btnSlctr==0){
        sum++;
        Dec2Bin(sum);
        CheckButtons();             
    }
    else if(btnSlctr==1){
        sum--;
        Dec2Bin(sum);
        CheckButtons();             
    }
    else if(btnSlctr==2){
        sum=0;
        Dec2Bin(sum);
        CheckButtons();
    }
    drawBasicScreen();
}
