var canvas;
var cntx;
var cnvBackBuffer;
var cntxBackBuffer;

function init(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    
    showAppTitle();
    initialValues();
    initialiseGUI();
    initialiseEvents();
    drawBasicScreen();
    timerLoop=setInterval(function(){run();},simSpeed);
}
      
function initialiseEvents(){
    $("#visualisation").on("mousedown touchstart",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseDown();
    });
    
    $("#visualisation").on("mousemove touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseMove();
    });
    
    $("#visualisation").on("mouseup touchend",function(evt){
        var rect=canvas.getBoundingClientRect();
        mx=evt.clientX-rect.left;
        my=evt.clientY-rect.top;
        handleMouseUp();
    });
    
    $("#visualisation").on("keydown",function(evt){
        handleKeyDown(evt.keyCode);
    });
    
    $("#noOfCombinations").on("input propertychange paste", function(){
        textValueChanged();
    });
    
    window.addEventListener("beforeunload",function(e){
        clearInterval(timerLoop);
    });
} 

function initialiseGUI(){
    $("#noOfCombinations").val("");
    
    msg[0]=document.getElementById("msg1");
    msg[1]=document.getElementById("msg2");
    msg[2]=document.getElementById("msg3");

    imgNxtStep=document.getElementById("ButtonSmall");
    imgNxtStepEnabled=document.getElementById("ButtonEnabledSmall");
    imgNxtStepSelected=document.getElementById("ButtonSelSmall");
    imgBack=document.getElementById("BackSmall");
    imgBackEnabled=document.getElementById("BackEnabledSmall");
    imgBackSelected=document.getElementById("BackSelSmall");
    $("#noOfCombinations").focus();
}

function initialValues(){
    DecimalValueColor=BackR;
    TitleTOP=20;
    TitleWIDTH=550;
    TitleLEFT=(width-TitleWIDTH)/2;
    TitleHEIGHT=35;
    imgLogo=document.getElementById("Logo");
    width=canvas.width;
    height=canvas.height;
    ByteTop=height/2;

    BottomPanelTop=height-BottomPanelHeight;
    logoLeft=width-logoWidth-5;
    logoTop=BottomPanelTop+(BottomPanelHeight-logoHeight)/2;

    WaitCounter=0;
    ByteRight=parseInt((width+(NoOfDigitsPerPlaceHolder*BitWidth+2*BitBorder)*NoOfBits)/2);
    ByteHeight=fontSize+BitBorder;
    ByteTop=TopPanelHeight+ByteHeight+60;
    CurrentState=stateWaitingForInput;
    SumColorR=AddInfoR;
    SumColorG=AddInfoG;
    SumColorB=AddInfoB;
    LineNumberColorRed=LetterColorR;
    LineNumberColorGreen=LetterColorG;
    LineNumberColorBlue=LetterColorB;
    for(var j=0;j<NoOfSeries;j++){
        for(var i=0;i<NoOfBits;i++){
            bits[i][j]=0;
        }
    }
    NxtStepLeft=logoLeft-NxtStepWidth-BORDER;
    NxtStepTop=BottomPanelTop+8;
    BackLeft=BORDER;
    BackTop=NxtStepTop;

    InitBytes();        
    if(SimulationNo==1){           
        framerate=15;
        CurrentQuestion=1;
        CurrentState=stateCombiInput;
        SimulationRunning=true;
    }
    else if(SimulationNo==2){
        ShowingBitNo=1;
        CurrentState=stateShowCombinations;
        //SimulationRunning=false; //Έχουμε φροντίσει το SimulationRunning να είναι πάντα true για να αποφεύγουμε το flickering
    }
    else if(SimulationNo==3) {             
        Info="Ας ξεκινήσουμε αυξάνοντας το πλήθος των συνδυασμών...";           
        framerate=15;
        NoOfBits=1;
        InitialSeriesValue=Math.pow(2,NoOfBits);
        NoOfSeries=InitialSeriesValue;
        PreviousNoOfBits=NoOfBits;
        CurrentState=stateWaitingForInput;
        ShowNoOfBits();
        SimulationRunning=true;
    }
}

function drawBasicScreen(){
    cntx.clearRect(0,0,canvas.width,canvas.height);
    
    drawFrames();
    drawLogoImage();
    
    DrawButtonNext();
    DrawButtonBack();
    if(SimulationNo==1){
        DrawSimulation1();
    }
    /*else if(SimulationNo==2){
        DrawSimulation2();
    }*/
    else if(SimulationNo==3){
        //PromptUser.setVisible(true);
        DrawSimulation3();
    }
    var promptColor=LetterColor;
    var promptYCoord=BottomPanelTop+25;
    cnvsWrite(promptColor,fontSize-10,"Arial",-1,promptYCoord,prompt);
    promptYCoord+=25;
    cnvsWrite(promptColor,fontSize-10,"Arial",-1,promptYCoord,prompt2);
    promptYCoord+=28;
}

function drawFrames(){
    cntx.fillStyle="white";
    cntx.strokeStyle="black";
    cntx.beginPath();
    //Περιοχή σχεδίασης
    cntx.fillRect(0,TopPanelHeight,width,height-TopPanelHeight-BottomPanelHeight);
    //πλαίσιο καμβά
    cntx.rect(0,0,width,height);
    //άνω πλαίσιο
    cntx.rect(0,0,width,TopPanelHeight);
    //κάτω πλαίσιο
    cntx.rect(0,BottomPanelTop,width,BottomPanelHeight);

    cntx.stroke();
    cnvsWrite(LetterColor,32,"Arial",-1,TitleTOP+TitleHEIGHT,appTitle);
}

function drawLogoImage(){
    cntx.drawImage(imgLogo,logoLeft,logoTop);
}

function showHTML(){
    window.open("index_DS_I_DS_II.html","_blank");
}

function cnvsWrite(clr,fontSize,fontName,txtX,txtY,txt){       
    cntx.font=fontSize+"px "+fontName;
    cntx.fillStyle=clr;
    if(txtX<0) txtX=(canvas.width-cntx.measureText(txt).width)/2;
    cntx.fillText(txt,txtX,txtY);
}

function handleKeyDown(key){
    if(SimulationNo==1 && CurrentState==stateTypingBits){
        switch(key){
            case 39://right
                BitPos--;
                if(BitPos<0){
                    BitPos=0;
                    }
                break;
            case 37: //left
                BitPos++;
                if(BitPos==CurrentQuestion){
                    BitPos=CurrentQuestion-1;
                }
                break;
            case 38://up
                SeriesPos--;
                if(SeriesPos<0){
                    SeriesPos=0;
                }
                break;
            case 40://down:
                SeriesPos++;
                if(SeriesPos==NoOfSeries){
                    SeriesPos=NoOfSeries-1;
                }
                break;
            case 46://delete
                bits[BitPos][SeriesPos]=2;
                SeriesEmpty[SeriesPos]=true;
                for(var i=0;i<CurrentQuestion;i++){
                    SeriesEmpty[SeriesPos]=SeriesEmpty[SeriesPos] & bits[i][SeriesPos]==2;
                }
                break;
            case 48://0
            case 49://1
                bits[BitPos][SeriesPos]=key-48;
                CheckUserTyping();
                break;
          }
    }
    drawBasicScreen();
}

function handleMouseDown(){
    drawBasicScreen();
}

function handleMouseMove(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my>=logoTop && my<logoTop+logoHeight){
        imgLogo=document.getElementById("LogoSel");
    }
    else{
        imgLogo=document.getElementById("Logo");
    }
    drawBasicScreen();
    //console.log("mx="+mx+" , my="+my+" ,infoSwitchHover="+infoSwitchHover+" ,coordSwitchHover="+coordSwitchHover);
}

function handleMouseUp(){
    if (mx>=logoLeft && mx<logoLeft+logoWidth && my >=logoTop && my<logoTop+logoHeight) {
        showHTML();
    }
    else if(mx>=NxtStepLeft && mx<=NxtStepLeft+NxtStepWidth && my>=NxtStepTop && my<=NxtStepTop+NxtStepHeight && NextStateEnabled){
        ShowNextState();
    }
    else if(mx>=BackLeft && mx<=BackLeft+BackWidth && my>=BackTop && my<=BackTop+BackHeight && BackEnabled && BackVisible){
        if(SimulationNo==1){
            BackEnabled=false;
            BackVisible=false;
            initialValues();            
        }
        else if(SimulationNo==2 && ShowingBitNo>1){
            ShowingBitNo--;
        }
        else if(SimulationNo==3){
            SimulationRunning=false;
            BackVisible=false;
            BackEnabled=false;                  
            SimulationNo=1;
            initialValues();
        }
    }
    drawBasicScreen();
}

function DrawByte(){
    var X1,X2,msgWidth;
    var message;
    for(var j=0;j<NoOfSeriesToDraw();j++){
        X1=ByteRight-(NoOfDigitsPerPlaceHolder*(-1)*BitWidth+BitBorder);
        X2=ByteRight-(NoOfDigitsPerPlaceHolder*(0)*BitWidth-BitBorder);
        message=" :"+(j+1);
        msgWidth=cntx.measureText(message).width;
        if(j<NoOfSeries/2 || CurrentState==stateWaitingForInput || CurrentState==stateFadeInAdditionalInfo || CurrentState==stateFadeOutAdditionalInfo2 || CurrentState==stateRemoveAdditionalBits || CurrentState==stateFadeInAdditionalInfo2){
            cntx.strokeStyle="rgb("+LineNumberColorRed+","+LineNumberColorGreen+","+LineNumberColorBlue+")";
            cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
        }
        cntx.strokeStyle="rgb(0,0,0)";
        for(var i=0;i<BitsToDraw();i++){
            X1=ByteRight-(NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder);
            X2=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder);
            message=""+bits[i][j];
            msgWidth=cntx.measureText(message).width;
            if(CurrentState==stateRemoveAdditionalBits){
                if(i==BitsToDraw()-1){
                    cntx.strokeStyle="rgb("+AdditionalBitColorR+","+AdditionalBitColorG+","+AdditionalBitColorB+")";
                }
                else{
                    cntx.strokeStyle="rgb(0,0,255)";
                }
                cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
            }
            else if(CurrentState==stateMoveMatrixUp){
                cntx.strokeStyle="rgb(0,0,255)";
                cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
                cntx.strokeStyle="rgb(120,120,120)";
                cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,SecondHalfMatrixTop+j*ByteHeight,message);
            }
            else if(CurrentState>=stateCopyMatrix && CurrentState<=stateFadeInAdditionalInfo && j>=NoOfSeries/2){
                cntx.strokeStyle="rgb(180,180,180)";
                cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight,message);
            }
            else{
                cntx.strokeStyle=ColOn;
                cnvsWrite(bitColor,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
            }
            cntx.strokeStyle="rgb(0,0,0)";
        }
    }
}

function DrawBytePlaceHolder(){
    var X1,X2,value,sum;
    var message;
    cntx.strokeStyle=PlaceHoldersColor;
    //Σχεδίαση θέσεων
    cntx.beginPath();
    for(var j=0;j<NoOfSeriesToDraw();j++){
        sum=0;
        for(var i=0;i<BitsToDraw();i++){
            X1=ByteRight-(NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder);
            X2=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder);
            if(CurrentState>=stateCopyMatrix && CurrentState<=stateFadeInAdditionalInfo && j>=NoOfSeries/2){
                cntx.moveTo(X1,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight);
                cntx.lineTo(X2,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight);

                cntx.moveTo(X1,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight);
                cntx.lineTo(X1,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight-BitBorder);

                cntx.moveTo(X2,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight);
                cntx.lineTo(X2,SecondHalfMatrixTop+(j-NoOfSeries/2)*ByteHeight-BitBorder);
            }
            else{
                cntx.moveTo(X1,ByteTop+j*ByteHeight);
                cntx.lineTo(X2,ByteTop+j*ByteHeight);
                
                cntx.miveTo(X1,ByteTop+j*ByteHeight);
                cntx.lineTo(X1,ByteTop-BitBorder+j*ByteHeight);
                
                cntx.moveTo(X2,ByteTop+j*ByteHeight);
                cntx.lineTo(X2,ByteTop-BitBorder+j*ByteHeight);
            }               
            value=Math.pow(2,i);
            message=""+value;
            value=value*bits[i][j];
            
            cntx.strokeStyle=PlaceHoldersColor;
            message=""+value;
            sum=sum+value;
            if(i<NoOfBits-1){
                message="+";
                X1=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder);
                X2=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth+BitBorder);
            }
        }
        cntx.stroke();
        if(DrawSum){
            message=sum+" =";
            cntx.strokeStyle="rgb("+SumColorR+","+SumColorG+","+SumColorB+")";
            X2=ByteRight-(NoOfDigitsPerPlaceHolder*BitsToDraw()*BitWidth+BitBorder)-cntx.measureText(message).width;
            if(j<NoOfSeries/2 || CurrentState==stateWaitingForInput || CurrentState>=stateFadeInAdditionalInfo){
                cnvsWrite(bitColor,fontSize,"Arial",X2,ByteTop+j*ByteHeight,sum+" =");
            }
            cntx.strokeStyle=PlaceHoldersColor;
        }
    }
}

function NumberOK(No){
    var sum=0;
    var Flag=OK;
    var digit;
    for(var i=0;i<No.length;i++){
        digit=No.charAt(i);
        if (digit<"0" || digit>"9"){
            Flag=InvalidCharacter;
        }
        else{
            sum=sum+parseInt(parseInt(digit)*Math.pow(10,No.length-i-1));
        }           
    }
    if(sum>9 && Flag==OK)Flag=ValueOutOfBounds;
    if (sum==0 && Flag==OK)Flag=ValueZero;
    return Flag;
}

function run(){
    if(SimulationRunning){
        if(CurrentState==stateWaitingForInput){
            if(FirstTime) {
                Info="Για να ξεκινήσουμε, ας τροποποιήσουμε το πλήθος των bit";
            }
            else{
                Info="Ας τροποποιήσουμε ξανά το πλήθος των bit";
            }
            HideNextStep();
            if(PreviousNoOfBits<NoOfBits){
                //SecondHalfMatrixTop=ByteTop-BitBorder;
            }
            else{
                //SecondHalfMatrixTop=ByteTop-BitBorder+NoOfSeries*ByteHeight;
            }
        }
        else if(CurrentState==stateCopyMatrix){
            CopyMatrix();
            Info="";
            FirstTime=false;
        }
        else if(CurrentState==stateFadeOutAdditionalInfo){
            Info="Ας αφαιρέσουμε την πρόσθετη πληροφορία...";
            FadeOutAdditionalInfo();
        }
        else if(CurrentState==stateMoveMatrixDown){
            HideNextStep();
            Info="Δημιουργούμε αντίγραφο των συνδυασμών...";
            MoveMatrixDown();
        }
        else if(CurrentState==stateFinaliseMatrixPosition){
            FinaliseMatrixPosition();
        }
        else if(CurrentState==stateFillMissingBits){
            HideNextStep();
            Info="Συμπληρώνουμε το πρωτότυπο με '0' και το αντίγραφο με '1'.";
            ShowNextStep();
            FillMissingBits();
        }
        else if(CurrentState==stateFadeInAdditionalInfo){
            Info="Έχουμε πλέον αναπαραστήσει τους αριθμούς 0-"+(NoOfSeries-1);
            HideNextStep();
            FadeInAdditionalInfo();
        }
        else if(CurrentState==stateRemoveAdditionalBits){
            RemoveAdditionalBits();
        }
        else if(CurrentState==stateFadeOutAdditionalInfo2){
            Info="Ας αφαιρέσουμε την πρόσθετη πληροφορία...";
            FadeOutAdditionalInfo2();
        }
        else if(CurrentState==stateMoveMatrixUp){
            MoveMatrixUp();
        }
        else if(CurrentState==stateFinaliseMatrixPosition2){
            FinaliseMatrixPosition2();
        }
        else if(CurrentState==stateFadeInAdditionalInfo2){
            FadeInAdditionalInfo2();
        }
        else if(CurrentState==stateTypingBits){
            WaitCounter++;
            if(WaitCounter==10){
                ShowHelp=!ShowHelp;
                WaitCounter=0;
            }                   
        }
        else if(CurrentState==stateShowCombinations){                      
            //ShowingBitNo++;
        }
    }
    drawBasicScreen();
}

function InitBytes(){
    var AuxV,i;
    for(var value=0;value<16;value++){
        AuxV=value;
        i=0;
        do{
            bits[i][value]=AuxV % 2;
            AuxV=parseInt(AuxV/2);
            i++;
        }while(i<MaxNoOfBits);
    }
}

function NoOfSeriesToDraw(){
    if(CurrentState==stateFadeOutAdditionalInfo2 || CurrentState==stateRemoveAdditionalBits){
        return 2*NoOfSeries;
    }
    else{
        return NoOfSeries;
    }       
}

function textValueChanged(){
    var txt;
    var NoResult;

    NoResult=NumberOK($("#noOfCombinations").val());
    if(NoResult==OK){
        $("#noOfCombinations").css("color","#0000ff");
        CurrentState=stateCombiInput;
        prompt="Πληκτρολόγησε 0 ή 1 | Μετακινήσου με τα πλήκτρα του δρομέα | Σβήσε με delete";
        ShowNextState();
    }
    else if(NoResult==InvalidCharacter || NoResult==ValueZero) {
        $("#noOfCombinations").css("color","#ff0000");
        NextStateEnabled=false;
        prompt="Γράψε καλύτερα μη μηδενικό αριθμό...";
        CurrentState=stateWaitingForInput;
    }
    else if(NoResult==ValueOutOfBounds) {
        $("#noOfCombinations").css("color","#ff0000");
        NextStateEnabled=false;
        prompt="Μήπως υπερβάλλεις λιγάκι;";
        CurrentState=stateWaitingForInput;
    }    
    drawBasicScreen();
}

function ShowNextState(){
    if(SimulationNo==1){
        if(CurrentState==stateCombiInput){
            NoOfSeries=parseInt($("#noOfCombinations").val());
            if(NoOfSeries>SeriesCorrectNo){
                UserInputStatus=UserInputOver;
            }
            else if(NoOfSeries<SeriesCorrectNo){
                UserInputStatus=UserInputUnder;
            }
            else{
                UserInputStatus=UserInputOK;
            }
            CurrentState=stateTypingBits;
            for(var j=0;j<MaxNoOfSeries;j++){
                TwinSeries[j]=-1;
                for(var i=0;i<MaxNoOfBits;i++){                        
                    bits[i][j]=2;
                }
            }               
            //Η επόμενη κλήση είναι απαραίτητη για να λειτουργούν
            //τα πλήκτρα δρομέα και η πληκτρολόγηση στον καμβά
            $("#visualisation").focus();
        }
        else if(CurrentState==stateTypingBits){
            InitBytes();
            ShowingBitNo=CurrentQuestion;               
            prompt2="";                
            CurrentState=stateShowCombinations;
        }
        else if(CurrentState==stateShowCombinations){
            ShowingBitNo=CurrentQuestion;               
            CurrentQuestion++;
            if(CurrentQuestion==4) {
                SimulationNo=3;
                initialValues();
            }
            else{
                CurrentState=stateCombiInput;
            }
        }
    }
    else if(SimulationNo==2){
        ShowingBitNo++;
        if(ShowingBitNo==5){
            SimulationNo=3;
            //HscrNoOfBits.setVisible(true);
            initialValues();
            NextStateEnabled=false;
            SimulationRunning=false;
        }
    }
    else{
        SimulationRunning=true;
        NextStateEnabled=false;
    }
}

function DrawSimulation1(){
    var ChkUsrAnswers;
    //lblNextStep.setVisible(true);
    //lblNoOfBits.setFont(new Font("Dialog",Font.PLAIN,fontSize));
    //lblInfo.setText(Prompt);
    if(CurrentState==stateWaitingForInput){
        //lblNoOfBits.setText("Αναπαράσταση Αριθμών με Δυαδικά Ψηφία");
        NextStateVisible=false;
        SimulationRunning=false;
    }
    else if(CurrentState==stateCombiInput){
        SimulationRunning=true;
        //lblNoOfBits.setText("Αναπαράσταση Αριθμών με Δυαδικά Ψηφία");
        NextStateVisible=false;
        ShowQuestion();
    }
    else if(CurrentState==stateTypingBits){
        SimulationRunning=true;
        //lblNoOfBits.setText("Αναπαράσταση Αριθμών με Δυαδικά Ψηφία");
        ShowPlaceHoldersForUserAnswer();
        ShowUserAnswer();
        if(ShowHelp){
            ChkUsrAnswers=CheckUserAnswers();
            if(ChkUsrAnswers==0){
                //Ο χρήστης έχει συμπληρώσει σωστά τους συνδυασμούς
                prompt2="Ωραία! Βρήκες όλους τους συνδυασμούς";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=true;
                NextStateEnabled=true;
            }
            else if(ChkUsrAnswers==1){
                //Ο χρήστης έχει συμπληρώσει σωστά τους συνδυασμούς,
                //αλλά έχει ορίσει περισσότερες γραμμμές απ' όσες χρειάζονται
                prompt2="Σβήσε τις όμοιες γραμμές...";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=false;
                NextStateEnabled=false;
            }
            else if(ChkUsrAnswers==2){
                //Ο χρήστης δεν έχει συμπληρώσει όλους τους συνδυασμούς,
                //αλλά δεν υπάρχουν περισσότεροι απ' όσους συμπλήρωσε
                prompt2="Μάλλον οι υπόλοιπες γραμμές δε χρειάζονται...";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=false;
                NextStateEnabled=false;
            }
            else if(ChkUsrAnswers==3){
                //Ο χρήστης δεν έχει συμπληρώσει όλους τους συνδυασμούς,
                //και έχει διπλοεγγραφές
                prompt2="Σβήσε τις όμοιες γραμμές.";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=false;
                NextStateEnabled=false;
            }
            else if(ChkUsrAnswers==4){
                //Ο χρήστης δεν έχει συμπληρώσει όλους τους συνδυασμούς,
                //και οι συνδυασμοί είναι ελλιπείς
                prompt2="Μπορείς να συμπληρώσεις τα κενά;";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=false;
                NextStateEnabled=false;
            }
            else if(ChkUsrAnswers==5){
                //Ο χρήστης έχει συμπληρώσει όλους τους συνδυασμούς,
                //αλλά οι γραμμές που όρισε δεν ήταν εξ αρχής αρκετές
                prompt2="Μήπως λείπουν γραμμές;";
                BackVisible=false;
                BackEnabled=false;
                NextStateVisible=false;
                NextStateEnabled=false;
            }
        }
        else{
            prompt2="";
        }
    }
    else if(CurrentState==stateShowCombinations){
        //** Prompt="";
        //** PromptUser.setVisible(false);
        prompt="";
        $("#divNoOfCombinations").hide();
        //** lblNoOfBits.setText("Υπολογισμός Πλήθους Συνδυασμών");              
        ShowingBitNo=CurrentQuestion;
        //BackVisible=false;
        NextStateVisible=true;
        NextStateEnabled=true;
        if(ShowingBitNo<4){
            DrawBitBoxed();
        }
    }
}

function DrawSimulation2(){
    //lblNoOfBits.setText("Υπολογισμός Πλήθους Συνδυασμών");
    BackVisible=false;
    if(ShowingBitNo<4){            
        DrawBitBoxed();
        if(ShowingBitNo>1) {
            BackVisible=true;
            BackEnabled=true;
        }
    }
    else{
        ShowSystematicMessage();
    }
    ShowInfo();
    RequestNextState();
}

function DrawSimulation3(){
    //lblNoOfBits.setFont(new Font("Dialog",Font.PLAIN,fontSize-10));
    DrawBytePlaceHolder();
    DrawByte();
    ShowInfo();
}

function DrawButtonNext(){
    if(NextStateVisible){
        if(NextStateEnabled){
            if(ButtonNextHover()){
                cntx.drawImage(imgNxtStepSelected, NxtStepLeft,NxtStepTop);
            }
            else{
                cntx.drawImage(imgNxtStepEnabled, NxtStepLeft,NxtStepTop);
            }
        }
        else{
            cntx.drawImage(imgNxtStep, NxtStepLeft,NxtStepTop);
        }
    }
}

function DrawButtonBack(){
    if(BackVisible){
        if(BackEnabled){
            if(ButtonBackHover()){
                cntx.drawImage(imgBackSelected, BackLeft,BackTop);
            }
            else{
                cntx.drawImage(imgBackEnabled, BackLeft,BackTop);
            }
        }
        else{
            cntx.drawImage(imgBack, BackLeft,BackTop);
        }
    }
}

function ShowQuestion(){
    SeriesPos=0;
    BitPos=CurrentQuestion-1;
    //lblNextStep.setText("");
    SeriesCorrectNo=Math.pow(2,CurrentQuestion);
    ShowHelp=false;
    var PromptUserString="";
    if(CurrentQuestion==1){
        PromptUserString="Πόσους αριθμούς νομίζεις ότι μπορούμε να αναπαραστήσουμε με 1 bit;";
    }
    else if(CurrentQuestion==2){
        PromptUserString="Πόσους αριθμούς νομίζεις ότι μπορούμε να αναπαραστήσουμε με 2 bit;";
    }
    else{
        PromptUserString="Πόσους αριθμούς νομίζεις ότι μπορούμε να αναπαραστήσουμε με 3 bit;";
    }
    $("#promptNoOfCombinations").html(PromptUserString);
    $("#noOfCombinations").val("");
    $("#divNoOfCombinations").show();
    $("#noOfCombinations").focus();
}

function ShowPlaceHoldersForUserAnswer(){
    var X1,X2,i,j;
    for(j=0;j<NoOfSeries;j++){
        for(i=0;i<CurrentQuestion;i++){                
            X1=ByteRight-(NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder);
            X2=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder);
            if(j==SeriesPos && i==BitPos){
                cntx.strokeStyle="rgb(0,0,200)";
            }
            else{
                cntx.strokeStyle="rgb(160,160,160)";
            }
            cntx.beginPath();
            cntx.moveTo(X1,ByteTop+j*ByteHeight);
            cntx.lineTo(X2,ByteTop+j*ByteHeight);
            
            cntx.moveTo(X1,ByteTop+j*ByteHeight);
            cntx.lineTo(X1,ByteTop-BitBorder+j*ByteHeight);
            
            cntx.moveTo(X2,ByteTop+j*ByteHeight);
            cntx.lineTo(X2,ByteTop-BitBorder+j*ByteHeight);
            cntx.stroke();
        }
    }
    prompt="Πληκτρολόγησε 0 ή 1 | Μετακινήσου με τα πλήκτρα του δρομέα | Σβήσε με delete";
    NextStateEnabled=true;
    NextStateVisible=true;
}

function ButtonNextHover(){
    if(mx>=NxtStepLeft && mx<=NxtStepLeft+NxtStepWidth && my>=NxtStepTop && my<=NxtStepTop+NxtStepHeight){
        return true;
    }
    else{
        return false;
    }
}

function ButtonBackHover(){
    if(mx>=BackLeft && mx<=BackLeft+BackWidth && my>=BackTop && my<=BackTop+BackHeight){
        return true;
    }
    else{
        return false;
    }
}

function ShowUserAnswer(){
    var BitWritten;
    var X1,X2,msgWidth;
    var message;
    var colorToUse="rgb(0,0,0)";
    for(var j=0;j<NoOfSeries;j++){
        cntx.strokeStyle="rgb(0,0,255)";
        X1=ByteRight-(NoOfDigitsPerPlaceHolder*(CurrentQuestion)*BitWidth+BitBorder);
        X2=ByteRight-(NoOfDigitsPerPlaceHolder*(CurrentQuestion+1)*BitWidth-BitBorder);
        message=(j+1)+":";
        msgWidth=cntx.measureText(message).width;
        cnvsWrite("rgb(0,0,255)",fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
        if(TwinSeries[j]>0){
            colorToUse="rgb(255,0,0)";
        }
        else{
            colorToUse="rgb(0,0,255)";
        }
        BitWritten=false;
        for(var i=0;i<CurrentQuestion;i++){
            if(bits[i][j]!=2){ 
                X1=ByteRight-(NoOfDigitsPerPlaceHolder*i*BitWidth+BitBorder);
                X2=ByteRight-(NoOfDigitsPerPlaceHolder*(i+1)*BitWidth-BitBorder);
                message=""+bits[i][j];
                msgWidth=cntx.measureText(message).width;
                cnvsWrite(colorToUse,fontSize,"Arial",parseInt((X2-X1-msgWidth)/2)+X1,ByteTop-BitBorder+j*ByteHeight,message);
                BitWritten=true;
            }
        }
        if(BitWritten && TwinSeries[j]>0){
            cnvsWrite(colorToUse,fontSize,"Arial",ByteRight,ByteTop-BitBorder+j*ByteHeight,"Ίδιο με τη γραμμή "+TwinSeries[j]);
        }
    }
    cntx.strokeStyle="rgb(0,0,0)";
}

function CheckUserTyping(){
    var flag;
    var jj;
    for(var j=1;j<NoOfSeries;j++){
        TwinSeries[j]=0;
        jj=0;
        do{
            flag=true;
            for(var i=0;i<CurrentQuestion;i++){
                flag=flag && bits[i][j]==bits[i][jj];
            }
            if(flag){
                TwinSeries[j]=jj+1;
            }
            jj++;
        }while(jj<j);
    }
}

function DrawBitBoxed(){
    var Xoffset=20;
    var BoxWidth=50,BoxHeight=40,ColumnBorder=40,RowBorder,BoxBorder=3;
    var NoOfBoxes,digit,digitX,digitY;
    var X,Y,previousX,previousY,previousI,PreviousRowBorder;
    ColumnBorder=parseInt((3*width/4-MaxNoOfBits*BoxWidth)/MaxNoOfBits);
    for(var j=1;j<=ShowingBitNo;j++){
        digit=0;
        NoOfBoxes=Math.pow(2,j);
        X=j*ColumnBorder+(j-1)*BoxWidth-3*BoxWidth/4-Xoffset;
        for(var i=1;i<=NoOfBoxes;i++){
            RowBorder=parseInt((height-NoOfBoxes*BoxHeight-TopPanelHeight-BottomPanelHeight)/(NoOfBoxes+1));
            Y=TopPanelHeight+i*RowBorder+(i-1)*BoxHeight;
            //Σχεδίαση μαύρου πλαισίου
            cntx.strokeStyle="rgb(0,0,0)";
            cntx.fillRect(X,Y,BoxWidth,BoxHeight);
            //Σχεδίαση γραμμών σύνδεσης
            if(j>1){
                previousX=(j-1)*(ColumnBorder+BoxWidth)-3*BoxWidth/4-Xoffset;
                if(i % 2 == 1){
                    previousI=(i+1)/2;
                }
                else{
                    previousI=i/2;
                }                   
                PreviousRowBorder=parseInt((height-NoOfBoxes*BoxHeight/2-TopPanelHeight-BottomPanelHeight)/(NoOfBoxes/2+1));
                previousY=TopPanelHeight+previousI*PreviousRowBorder+(previousI-1)*BoxHeight+parseInt(BoxHeight/2);
                cntx.beginPath();
                cntx.moveTo(previousX,previousY);
                cntx.lineTo(X,Y+BoxHeight/2);
                cntx.stroke();
            }
            //Σχεδίαση εσωτερικού
            cntx.fillStyle=ButtonFaceColor;
            cntx.fillRect(X+BoxBorder,Y+BoxBorder,BoxWidth-2*BoxBorder,BoxHeight-2*BoxBorder);
            //Εμφάνιση ψηφίου
            var digitColor="rgb("+LetterColorR+","+LetterColorG+","+LetterColorB+")";
            digitX=X+(BoxWidth-cntx.measureText(""+digit).width)/2;                 
            digitY=Y+30;
            cnvsWrite(digitColor,fontSize,"Arial",digitX,digitY,digit+"");
            //Εμφάνιση συνδυασμού
            if (j==ShowingBitNo){
                cnvsWrite(digitColor,fontSize,"Arial",X+BoxWidth+BitWidth,Y+30,"=");
                for(var i2=0;i2<ShowingBitNo;i2++){
                    cnvsWrite(digitColor,fontSize,"Arial",X+BoxWidth+BitBorder+(i2+2)*BitWidth,Y+30,""+bits[ShowingBitNo-1-i2][i-1]);
                }
            }
            //Προετοιμασία επόμενου ψηφίου
            digit=(digit+1) % 2;
        }
    }
    Info="Παραλλαγές με "+ShowingBitNo+" bit";
    cntx.drawImage(msg[ShowingBitNo-1],454,TopPanelHeight+5);
    if(ShowingBitNo==3) {
        if(FullVersion){
            //lblNextStep.setText("Μάλλον είσαι έτοιμος για το επόμενο βήμα");
            prompt2="Μάλλον είσαι έτοιμος για το επόμενο βήμα";
        }
        else{
            //lblNextStep.setText("Μπορείς να ξαναδοκιμάσεις τις γνώσεις σου...");
            prompt2="Μπορείς να ξαναδοκιμάσεις τις γνώσεις σου...";
            BackEnabled=true;
            BackVisible=true;
            NextStateVisible=false;
            NextStateEnabled=false;
        }
    }
    else {
        //lblNextStep.setText("");
        prompt2="";
    }
}

function CheckUserAnswers(){
    var Result=[];
    var factor,sum,SumOfSums=0,CorrectSumOfSums;
    var AllSeriesFilled=true,MissingBit=false,MultiZeroes=false;
    for(var j=0;j<NoOfSeries;j++){
        Result[j]=-1;
    }
    for(var j=0;j<NoOfSeries;j++){
        factor=1;
        sum=0;
        MissingBit=false;
        for(var i=0;i<CurrentQuestion;i++){
            if(bits[i][j]==2){
                AllSeriesFilled=false;
                MissingBit=true;
            }
            else{
                sum=sum+bits[i][j]*factor;
            }
            factor=2*factor;
        }
        if(!MissingBit){
            if(sum==0 && Result[0]==0){
                MultiZeroes=true;
            }
            else{
                Result[sum]=sum;
            }               
        }
        SumOfSums=SumOfSums+sum;
    }
    CorrectSumOfSums=(Math.pow(2,CurrentQuestion)*(Math.pow(2,CurrentQuestion)-1)/2);
    if(AllSeriesFilled){
        //1. Συμπληρώθηκαν όλες ...
        if(SumOfSums==CorrectSumOfSums && Result[0]==0 && !MultiZeroes){
            //... ΟΡΘΑ (1α)
            return 0;
        }
        else{
            if(UserInputStatus==UserInputOver){
                //... ΜΕ ΔΙΠΛΟΕΓΓΡΑΦΕΣ (1β)
                return 1;
            }
            else{
                //===================================================================================================
                //= Το if αυτό δε μπορεί να ενεργοποιηθεί γιατί ο compiler θεωρεί ότι δεν επιστρέφεται τιμή πάντοτε =
                //= Έτσι κι αλλιώς όμως η σνυθήκη εννοείται δι' αποκλεισμού                                         =
                //===================================================================================================
                //if(UserInputStatus==UserInputUnder) { 
                    //... ΑΛΛΑ ΔΕΝ ΗΤΑΝ ΕΞ ΑΡΧΗΣ ΑΡΚΕΤΕΣ (1γ)
                    return 5;
                //}
            }
        }
    }
    else{
        //2. Λείπουν συνδυασμοί...
        if(SumOfSums==CorrectSumOfSums && Result[0]==0){
            //...αλλά οι υπόλοιποι σωστοί (2α)
            return 2;
        }
        else if(SumOfSums>CorrectSumOfSums){
            //...έχουν διπλοεγγραφές (2β)
            return 3;
        }
        else{
            //...λείπουν (2γ)
            return 4;
        }
    }
}