/// <reference path="jquery/jquery-1.7.min.js" />
/// <reference path="jquery-ui/jquery-ui-1.8.16.custom.min.js" />
/// <reference path="draw/jquery.draw.js" />
/// <reference path="jQueryRotate/jQueryRotate.2.1.js" />
/// <reference path="mydropdown/jquery.mydropdown.js" />
/// <reference path="spinner/ui.spinner.js" />

"use strict";

Shadowbox.init({
    handleOversize: "resize",
    modal: true
});


function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

jQuery.fn.reverse = function () {
    return this.pushStack(this.get().reverse(), arguments);
};

var posTurtleX = 0;
var posTurtleY = 0;
var degTurtle = 0;
var halfTurtleWidth = 0;
var halfTurtleHeight = 0;
var canvasWidth = 0;
var canvasHeight = 0;

var bPenDown = true;

var timeoutID = 0;
var runSpeed = 100;
var maxSpeed = 500;
var runAuto = false;
var $poolLine;

var StepMessage = ["Χρησιμοποιώντας απλές εντολές Logo μπορούμε να σχεδιάσουμε απλά γεωμετρικά σχήματα.",
                    "Χρησιμοποιώντας απλές εντολές Logo μπορούμε να σχεδιάσουμε απλά γεωμετρικά σχήματα.",
                    "Όσο τα σχήματα γίνονται πιο πολύπλοκα, ο αριθμός των εντολών αυξάνεται.",
                    "Μπορούμε να ομαδοποιήσουμε τις εντολές που επαναλαμβάνονται μέσα σε μία εντολή <b><code>επανάλαβε</code></b>.",
                    "Μπορείς να επιλέξεις εντολές και να τις ομαδοποιήσεις σε μία εντολή <b><code>επανάλαβε</code></b>.",
                    "Βλέπουμε ότι με την εντολή <b><code>επανάλαβε</code></b> ο αριθμός των εντολών μειώνεται θεαματικά.",
                    "Χρησιμοποίησε τα κουμπιά κάθε γραμμής για να αλλάξεις τις παραμέτρους κάθε εντολής.",
                    "Χρησιμοποίησε τα κουμπιά κάθε γραμμής για να αλλάξεις τις παραμέτρους κάθε εντολής.",
                    "Όσο η πολυπλοκότητα των εντολών αυξάνει, τα αποτελέσματα γίνονται εντυπωσιακά. "
                  ];

var tab_counter = 1;
var $curTab = null;
var $leftPage = null;
var $imgTurtle;



//var metavlites = {};

var logoProgram = new LogoSandBox();

var svgManager;

function drawVector(x, y, l, angle, opts, box) {

    var x1 = x + (l * Math.cos(angle));
    var y1 = y - (l * Math.sin(angle));
    //var g = svgManager.group({stroke: 'black', strokeWidth: 2});  
    
//    if (box != null) {
//        if (x1 < 0)
//            x1 = 0;
//        if (x1 > box.width)
//            x1 = box.width;
//        if (y1 <0 )
//            y1 = 0;
//        if (y1 > box.height)
//            y1 = box.height;
//    }
    svgManager.line(null, x, y, x1, y1, opts);

    //return $(this);
    return { x: x1, y: y1 };
}

function setMessage(strMsg) {
    $("#divMessage").html(strMsg);
}


function showDialog(strTitle, htmlContent, objButtons) {
    if (objButtons == null) {
        objButtons = {
            "Κλείσιμο": function () {
                $(this).dialog("close");
            } 
        };
    }

    $("#divDialog").dialog("destroy");
    $("#divDialog .content").html(htmlContent);
    $("#divDialog").dialog({
        resizable: false,
        title: strTitle,
        dialogClass: 'DialogMessage',
        height: 160,
        modal: true,
        buttons: objButtons
    });
}


function disableButtons(bToogle) {
    $("#btnPrev").button({ disabled: bToogle });
    $("#btnNext").button({ disabled: bToogle });
    $("#btnPlay").button({ disabled: bToogle });
}

function rotateTurtle(angle) {
    degTurtle += angle;
    var mod = degTurtle % 360;
    if (mod > 180)
        mod = mod - 360;
    degTurtle = mod;
    $imgTurtle.rotate(-degTurtle);
}

function moveTurtle(dist, bDraw, index) {
    if (bDraw == null)
        bDraw = true;
    if (index == null)
        index = -1;

    var oldX = posTurtleX;
    var oldY = posTurtleY;
    var rad = degTurtle * 0.0174532925;

    var pos;
    var curClass = (index != -1) ? "poolLine" + index : "sakis";
    var options = {};
    options.strokeWidth = 1;
    options.stroke = (bDraw == true) ? "red" : "transparent";
    options.class = curClass;

    //pos = $("#myCanvas").drawVector(oldX, oldY, dist, rad, options, { left: l, top: t, width: w, height: h });
    //pos = drawVector(oldX, oldY, dist, rad, options, { width: canvasWidth, height: canvasHeight }, svgGroup);
    pos = drawVector(oldX, oldY, dist, rad, options, null);


    posTurtleX = pos.x;
    posTurtleY = pos.y;

    //$("#imgTurtle").css("position", "absolute");
    $imgTurtle.css("left", (posTurtleX - halfTurtleWidth) + "px");
    $imgTurtle.css("top", (posTurtleY - halfTurtleHeight) + "px");
}

function removeControls($divLine) {
    var $parent;
    if ($divLine == null)
        $parent = $curTab;
    else
        $parent = $divLine;

    $(".genHeader", $parent).remove();
    $(".advMenuUL", $parent).remove();
    $(".ui-spinner", $parent).remove();
    $(".ui-spinner-up", $parent).remove();
    $(".ui-spinner-down", $parent).remove();
    $(".ddlCommands", $parent).remove();
    $(".hidden", $parent).removeClass("hidden");

    //$(".leftPage").css("background-color", "#EAEAEA");
};

function showSpinner($spanParameter) {
    var $divLine = $spanParameter.parent();
    var $input = $('<input type="text" value="' + $spanParameter.text() + '" />');
    var opts = {
        decimals: 0,
        stepping: 1,
        start: 0,
        incremental: true,
        currency: false,
        format: '%',
        items: []
    };
    
    var width = $spanParameter.outerWidth(false);
    if (width < 30)
        width=30;

    $input.val($spanParameter.text());
    $spanParameter.addClass("hidden");
    $input.insertAfter($spanParameter);
    
        $input.bind("change", function () {
        var val = $.trim($(this).val());
        if (isNumber(val)) {
            val = parseInt(val);
            $(this).val(val);
            $spanParameter.text(val);
        }
        else {
            $(this).val(val);
            var enVal = val.replace(/</g, "&lt;")
            var enVal = val.replace(/>/g, "&gt;")
            $spanParameter.html(enVal);          
        }
    });

    $input.spinner(opts);
    
    var $spinner = $(".ui-spinner:first");
    var $spinnerBox = $(".ui-spinner-box:first");
    var $spinButtons = $(".ui-spinner-up, .ui-spinner-down");

    $spinner.css("width", (width + 30) + "px");
    $spinnerBox.css("width", (width + 10) + "px");
    $spinner.css("background-color", "transparent");
    $spinner.css("border-width", "1px");
    $spinner.css("border-style", "solid");
    $spinner.css("border-color", "transparent");
    $spinner.hover(function () {
        $spinner.css("border-color", "#FFCB97");
        $spinner.css("border-style", "solid");
    },
    function () {
        $spinner.css("border-style", "solid");
        $spinner.css("border-color", "transparent");
        $input.trigger("change");
    });

    $spinButtons.each(function () {
        $(this).disableSelection();
//        $(this).on("mouseup", function () {
//            $input.trigger("change");
//        });
    });
}

function removeBlockCommand($blockCommand, $divLine) {
    $(".blockStart", $blockCommand).remove();
    $(".block", $blockCommand).remove();
    $(".blockEnd", $blockCommand).remove();
    $divLine.unwrap();
    $divLine.removeClass("blockHeader");
    return $divLine;
}

function showBlockButtons($blockLine) {
    var $lineParent = $blockLine.parent();
    var strIcon;
    var $block;

    removeLineButtons();
    removeControls();

    if ($blockLine.hasClass("blockStart")) {
        $blockLine.append("<button class='addLine'>Εισαγωγή γραμμής κάτω</button>");
        strIcon = "ui-icon-arrowthickstop-1-s";
        var $spanParameter = $(".spanParameter", $blockLine);
        //if ($spanParameter.css("visibility") != "hidden")
        showSpinner($spanParameter);
        $block = $blockLine.next();
    }
    else {
        $blockLine.append("<button class='addLine'>Εισαγωγή γραμμής πάνω</button>");
        strIcon = "ui-icon-arrowthickstop-1-n";
        $block = $blockLine.prev();
    }

    var $btnAddLine = $(".addLine", $blockLine);
    $btnAddLine.button({
        text: false,
        icons: {
            primary: strIcon
        }
    })
    .click(function () {
        var $newLine;
        $newLine = createNewLine();
        if ($blockLine.hasClass("blockStart"))
            $block.prepend($newLine);
        else
            $block.append($newLine);

        createLineEvents($newLine);
        resetCode();
    });
    makeButtonFlat($btnAddLine);

    showButtonPaste($blockLine);
}



function createBlockHeaderEvents($blockLine) {
    if ($blockLine == null)
        $blockLine = $(".blockStart, .blockEnd");

    $blockLine.each(function () {
        $(this).mouseenter(function () {
            var $lines = $(".line", $curTab);
            $lines.removeClass("highlightLine");
            $(this).addClass("highlightLine");
            showBlockButtons($(this));
        });
        $(this).mouseleave(function () {
            $(this).removeClass("highlightLine");
            removeLineButtons();
            removeControls();
        });
    });
}


function animateTo($source, $animTarget, $appendTarget, $spanParameter) {

    $source.css("position", "relative");

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";


    $source.animate(
    {
        "left": strLeft,
        "top": strTop
    },
    {
        duration: 500,
        easing: "easeOutExpo",
        complete: function () {
            $(this).appendTo($appendTarget);
            $(this).css("position", "static");

            //if ($(this).hasClass("line"))
            //    createLineEvents($(this));

            var $selLine = $(".selected:first");
            if ($selLine.size() > 0)
                animateLine($selLine, $animTarget, $appendTarget, $spanParameter);
            else {
                var $selGroup = $(".group:first");
                if ($selGroup.size() > 0)
                    animateGroup($selGroup, $spanParameter);
            }
        },
        queue: true
    });
}

function animateGroupTo($source, $animTarget) {

    $source.css("position", "relative");

    var animLeft = $animTarget.offset().left - $source.offset().left;
    var animTop = $animTarget.offset().top - $source.offset().top;

    var strLeft = (animLeft >= 0) ? "+=" + animLeft + "px" : "-=" + Math.abs(animLeft) + "px";
    var strTop = (animTop >= 0) ? "+=" + animTop + "px" : "-=" + Math.abs(animTop) + "px";


    $source.animate(
    {
        "left": strLeft,
        "top": strTop
    },
    {
        duration: 750,
        easing: "easeOutExpo",
        complete: function () {
            var index = parseInt($source.attr("index"));
            $animTarget.html(index + 1);
            $source.remove();
            var $selGroup = $(".group:first");
            if ($selGroup.size() > 0)
                animateGroup($selGroup, $animTarget);
        },
        queue: true
    }
    );
}

function animateGroup($selGroup, $animTarget) {
    var index = $selGroup.attr("index");
    var $animGroup = $(".group" + index, $curTab);
    animateGroupTo($animGroup, $animTarget);
}

function animateLine($selLine, $animTarget, $appendTarget, $spanParameter) {
    removeLineButtons($selLine);
    removeControls($selLine);
    $selLine.removeClass("highlightLine");
    $selLine.removeClass("highlightRunLine");
    $selLine.removeClass("selected");
    var strCloneCommand = $(".spanCommand:first", $selLine).text();

    //if ((strCloneCommand != "μπ") && (strCloneCommand != "πι") && (strCloneCommand != "αρ") && (strCloneCommand != "δε") && (strCloneCommand != "επανάλαβε") && (strCloneCommand != "θέσε")) {
    if (strCloneCommand == "στα" || strCloneCommand == "στκ" || strCloneCommand == "σβγ") 
        $(".spanParameter:first", $selLine).addClass("spanHidden").text("1");

    animateTo($selLine, $animTarget, $appendTarget, $spanParameter);
}

function groupSelectionDown($group, index, strSelection, groupLength) {
    var strGroup = "";
    var $nextGroup;
    $group.each(function () {
        var strLine = $.trim($(this).text());
        strGroup += strLine;
    });
    if (index == 0) {
        strSelection = strGroup;
        $group.addClass("selected");
        $nextGroup = $group.last().nextAll(":lt(" + groupLength + ")");
        index = groupSelectionDown($nextGroup, index + 1, strSelection, groupLength);
    }
    else {
        if (strGroup == strSelection) {
            $group.addClass("group");
            $group.addClass("group" + index);
            $group.attr("index", index);
            $nextGroup = $group.last().nextAll(":lt(" + groupLength + ")");
            index = groupSelectionDown($nextGroup, index + 1, strSelection, groupLength);
        }
    }
    return index;
}

function groupSelectionUp($group, index, strSelection, groupLength) {
    var strGroup = "";
    var $nextGroup;
    var $prevGroup;
    $group.each(function () {
        var strLine = $.trim($(this).text());
        strGroup += strLine;
    });
    if (index == -1) {
        strSelection = strGroup;
        $group.addClass("selected");
        index = 0;

        $prevGroup = $group.prevAll(":lt(" + groupLength + ")").reverse();
        index = groupSelectionUp($prevGroup, index, strSelection, groupLength);

        index++;
        
        $nextGroup = $group.last().nextAll(":lt(" + groupLength + ")");
        index = groupSelectionDown($nextGroup, index, strSelection, groupLength);
    }
    else {
        if (strGroup == strSelection) {

            $prevGroup = $group.prevAll(":lt(" + groupLength + ")").reverse();
            index = groupSelectionUp($prevGroup, index, strSelection, groupLength);
            
            index++;

            $group.addClass("group");
            $group.addClass("group" + index);
            $group.attr("index", index);
        }
    }
    return index;
}

function selectionValid($selLines) {
    var groupLength = $selLines.size();
    if ($selLines.parent().size() > 1) {
        //alert("selected not siblings!");
        return false;
    }

    var idxFirst = $(".selected:first", $curTab).index();
    var idxLast = $(".selected:last", $curTab).index();
    if (groupLength != idxLast - idxFirst + 1) {
        //alert("selection not adjacement!");
        return false;
    }
    return true;
}

function convertToBlockCommand(strCommand) {
    $("#btnConvert").button("option", "disabled", true);
    $("#btnConvertProcedure").button("option", "disabled", true);
    var $selLines = $(".selected", $curTab);
    if ($selLines.size() == 0) {
        return null;
    }

    var groupLength = $selLines.size();
    var index;
    if (selectionValid($selLines)) {
        index = groupSelectionUp($selLines, -1, "", groupLength);
        //alert("index = " + index);
        $(".group", $curTab).each(function () {
            removeLineEvents($(this));
        });
    }

    var $divLine = $selLines.first();
    $divLine.removeClass("highlightRunLine");
    $divLine.removeClass("highlightLine");
    removeLineButtons($divLine);
    removeControls($divLine);
    var $blockHeader = $('<div class="line blockHeader"><span class="spanCommand">' + strCommand + '</span><span class="spanParameter">1</span></div>');
    var $blockCommand = $blockHeader.wrap("<div class='blockCommand' />").parent();
    $blockCommand.insertBefore($divLine);
    $blockCommand
        .append('<div class="blockStart">[</div>')
        .append('<div class="block"></div>')
        .append('<div class="blockEnd">]</div>');

    createLineEvents($blockHeader);

    var $spanParameter = $(".spanParameter:first", $blockCommand);
    $blockCommand.hide();
    $blockCommand.animate({ height: "show" }, 1000, "easeOutBounce", function () {
        var $animTarget = $blockCommand.find(".blockEnd:first");
        var $appendTarget = $blockCommand.find(".block:first");

        $(".selected:first", $curTab).each(function () {
            var $selLine = $(this);
            animateLine($selLine, $animTarget, $appendTarget, $spanParameter);
        });
    });

    createBlockHeaderEvents($blockCommand.find(".blockStart:first, .blockEnd:first"));
    resetCode();
    return $blockCommand;
}

function createBlockCommand($divLine, strCommand) {
    var spanParameter;
    var $blockHeader;
    if (strCommand == "επανάλαβε") {
        $blockHeader = $('<div class="line blockHeader"><span class="spanCommand">επανάλαβε</span><span class="spanParameter">1</span></div>');
    }
    if (strCommand == "αν")
        $blockHeader = $('<div class="line blockHeader"><span class="spanCommand">αν</span><span class="spanParameter"></span></div>');
    if (strCommand == "αν...αλλιώς")
        $blockHeader = $('<div class="line blockHeader"><span class="spanCommand">αν...αλλιώς</span><span class="spanParameter"></span></div>');
    
    var $blockCommand = $blockHeader.wrap("<div class='blockCommand' />").parent();
    $blockCommand.insertBefore($divLine);
    $blockCommand
        .append('<div class="blockStart">[</div>')
        .append('<div class="block"></div>')
        .append('<div class="blockEnd">]</div>');
    
    if (strCommand == "αν...αλλιώς") {
        //var $elseBlockHeader = $('<div class="line blockHeader"><span class="spanCommand">αλλιώς</span></div>') 
        $blockCommand
            //.append($elseBlockHeader)
            .append('<div class="blockStart">[</div>')
            .append('<div class="block"></div>')
            .append('<div class="blockEnd">]</div>');
    }

    createLineEvents($blockHeader);
    $divLine.remove();

    var $spanParameter = $(".spanParameter:first", $blockCommand);
    $blockCommand.hide();
    $blockCommand.animate({ height: "show" }, 1000, "easeOutBounce", function () {
    });

    createBlockHeaderEvents($blockCommand.find(".blockStart, .blockEnd"));
    resetCode();
    return $blockCommand;
}


function showDropDownList($spanCommand) {
    var $divLine = $spanCommand.parent();
    var $lineParent = $divLine.parent();

    $spanCommand.addClass("hidden");

    var strSelect = '<select class="ddlCommands" style="display:none;">';
    strSelect += $("#ddlCommandsHidden").html();
    strSelect += '</select>';

    var $ddlCommands = $(strSelect);
    $ddlCommands.insertAfter($spanCommand);
    $ddlCommands.children().each(function () {
        if ($(this).text() == $spanCommand.text())
            this.selected = true;
    });

    var arrDropDown = $ddlCommands.MyDropdown($curTab);
    var $ddlHeader = arrDropDown[0];
    var $ddlMenu = arrDropDown[1];

    $ddlCommands.bind("change", function () {
        var strCommand = $(this).val();
        var strOldCommand = $spanCommand.text();

        if (strCommand == strOldCommand)      // no change
            return true;

        var $code = $("code", $curTab);
        var strTabName;
        strTabName = $code.attr("name");

//        if (strCommand == strTabName) {      // prevent recursion
//            showDialog("Προσοχή!", "Δεν μπορείς να καλέσεις τον εαυτό σου!");
//            return false;
//        }


        if ($lineParent.hasClass("blockCommand")) {
            if (confirm("Η ενέργεια αυτή θα διαγράψει όλες τις εσωτερικές εντολές. Είστε σίγουροι;"))
                $divLine = removeBlockCommand($lineParent, $divLine);
            else {
                $ddlHeader.html(strOldCommand);
                return true;
            }
        }

        if ($divLine.hasClass("blockProcedure"))
            $divLine.removeClass("blockProcedure");


        if ((strCommand == "μπ") || (strCommand == "πι") || (strCommand == "αρ") || (strCommand == "δε") || (strCommand == "επανάλαβε") || (strCommand == "θέσε") || (strCommand == "αν") || (strCommand == "αν...αλλιώς")) {
            $(".spanParameter", $divLine).removeClass("spanHidden");
            if (strCommand == "επανάλαβε" || strCommand == "αν" || strCommand == "αν...αλλιώς") {
                createBlockCommand($divLine, strCommand);
            }
        }
        else {
            if ((strCommand != "στα") && (strCommand != "στκ") && (strCommand != "σβγ")) 
                $divLine.addClass("blockProcedure");
            else
                $(".spanParameter", $divLine).addClass("spanHidden").text("1");
        }

        resetCode();
        $spanCommand.html(strCommand);
    });

    $ddlHeader.css("display", "inline");
    $ddlHeader.css("height", "20px");
    $ddlHeader.css("line-height", "20px");
    $ddlHeader.css("max-height", "20px");
    $ddlHeader.css("padding-left", "0px");
    $ddlHeader.css("padding-top", "0px");
    $ddlHeader.css("padding-bottom", "0px");
    $ddlHeader.css("background-color", "transparent");
    $ddlHeader.css("border-width", "1px");
    $ddlHeader.css("border-style", "solid");
    $ddlHeader.css("border-color", "transparent");
    $ddlHeader.hover(function () {
        $ddlHeader.css("border-color", "#FFCB97");
        $ddlHeader.css("border-style", "solid");
    },
    function () {
        $ddlHeader.css("border-style", "solid");
        $ddlHeader.css("border-color", "transparent");
    });

    $ddlMenu.css("position", "absolute");
}

function clearBoard() {
    //$(".drawElement").remove();
    svgManager.clear();
    
    var cx = (canvasWidth / 2);
    var cy = (canvasHeight / 2);

    //cx += $("#myCanvas").offset().left;
    //cy += $("#myCanvas").offset().top;

    posTurtleX = cx;
    posTurtleY = cy;
    degTurtle = 0;

    rotateTurtle(90);
    moveTurtle(0, false, -1);
}

function makeAssignment(curProgram, strParameter) {
    return logoProgram.MakeAssignment(curProgram, strParameter);
}

function parseCommand($command, curProgram, poolRun,  index) {
    if (index == null)
        index = -1;

	var strCommand = $command.find(".spanCommand").text();
	var strParameter = $command.find(".spanParameter").text();
    //var curProgram = $command.parents("code:first").attr("name");

	if (strCommand == "στκ") {
		bPenDown = true;
        (poolRun == true) ? addLinePool($command, curProgram) : null;
    }
    else if (strCommand == "στα") {
		bPenDown = false;
        (poolRun == true) ? addLinePool($command, curProgram) : null;
    }
    else if (strCommand == "σβγ") {
		clearBoard();
        (poolRun == true) ? addLinePool($command, curProgram) : null;
	} 
    else if (strCommand == "θέσε") {
        if (poolRun) {
            addLinePool($command, curProgram, "dummy");
        }
        return makeAssignment(curProgram, strParameter);
	}
    else {
        var num = logoProgram.GetMet(curProgram, strParameter);
        if (num === undefined) {
            logoProgram.ErrorMessage =  "Άγνωστο -> " + strParameter;
            return false;
        }
         if (poolRun) {
            $(".spanParameter", $command).text(num);
            addLinePool($command, curProgram);
             $(".spanParameter", $command).text(strParameter);
        }
        else {
            if (strCommand == "αρ") {
                rotateTurtle(num);
            }
            else
            if (strCommand == "δε") {
                rotateTurtle(-num);
            }
            else
            if (strCommand == "μπ") {
                moveTurtle(num, bPenDown, index);
            }
            else
            if (strCommand == "πι") {
                moveTurtle(-num, bPenDown, index);
            }
        }
    }
    return true;
}

function runCode($commands, curProgram, poolRun, strParameters, strValues) {
    var exitCode = true;
    //console.log("Program : " + curProgram)

    
    if (strParameters != undefined && strParameters != "") {
        var arrParameters = strParameters.split(",");
        var arrValues = strValues.split(",");
        for (var i=0, len=arrParameters.length; i < len; i++) {
            var strMet = $.trim(arrParameters[i]);
            var value = (arrValues[i] === undefined) ? 0 : $.trim(arrValues[i]);
            logoProgram.SetMet(curProgram, strMet, Number(value));
        }
    }

    $commands.children().each(function (idx) {
        var $command = $(this);
        if ($command.hasClass("blockCommand")) {
            var $block;
            var strCommand = $command.find(".line:first .spanCommand").text();
            var spanParameter = $command.find(".line:first .spanParameter").text();
            if (strCommand == "επανάλαβε") {
                //var curProgram = $command.parents("code:first").attr("name");
                var loops = logoProgram.GetMet(curProgram, spanParameter);
                if (loops === undefined){
                    logoProgram.ErrorMessage =  "Άγνωστο -> " + spanParameter;
                    alert(logoProgram.ErrorMessage);
                    exitCode = false;
                    return false;
                }                
                
                $block = $command.find(".block:first");
                for (var i = 0; i < loops; i++) {
                    if (poolRun) {
                        var $blockHeader = $command.find(".blockHeader:first");
                        addLinePool($blockHeader, curProgram, "dummy");
                    }

                    if (runCode($block, curProgram, poolRun) == false) {
                        //resetCode();
                        exitCode = false;
                        return false;
                    }

                     if (poolRun) {
                        var $blockEnd = $command.find(".blockEnd:last");
                        addLinePool($blockEnd, curProgram, "dummy");
                     }
                }
            }
            if (strCommand == "αν" || strCommand == "αν...αλλιώς") {
                var cond = logoProgram.CheckCondition(curProgram, spanParameter);
                if (cond === undefined){
                    alert(logoProgram.ErrorMessage);
                    exitCode = false;
                    return false;
                }
                
                if (poolRun) {
                    var $blockHeader = $command.find(".blockHeader:first");
                    addLinePool($blockHeader, curProgram, "dummy");
                }                
                
                if (cond == true) {
                    $block = $command.children(".block").first();
                    if (runCode($block, curProgram, poolRun) == false) {
                        exitCode = false;
                        return false;
                    }
                    if (poolRun) {
                        var $blockEnd = $block.next();
                        addLinePool($blockEnd, curProgram, "dummy");
                    }                    
                }
                else  
                    if (strCommand == "αν...αλλιώς") {
                        $block = $command.children(".block").last();
                        if (runCode($block, curProgram, poolRun) == false) {
                            exitCode = false;
                            return false;
                        }
                        if (poolRun) {
                            var $blockEnd = $command.find(".blockEnd:last");
                            addLinePool($blockEnd, curProgram, "dummy");
                        }                            
                    }
                
            }
        }
        else {
            if ($command.hasClass("blockProcedure")) {
                var strProcedure = $command.find(".spanCommand:first").text();
                var $tabProcedure = $("#tab-" + strProcedure);
                var spanParameter = $command.find(".spanParameter").text();
                var strProcParams = $tabProcedure.find(".blockStart:first .spanParameter").text();
                var newProgram = $tabProcedure.find("code:first").attr("name");
                var strValues = "";
                
                if (spanParameter != ""){
                    var arrParams = spanParameter.split(",");
                    for (var i=0, len=arrParams.length; i < len; i++){
                        var strMet = $.trim(arrParams[i]);
                        var v = logoProgram.GetMet(curProgram, strMet);
                        if (v === undefined) {
                            logoProgram.ErrorMessage =  "Άγνωστο -> " + strMet;
                            alert(logoProgram.ErrorMessage);
                            exitCode = false;
                            return false;                       
                        }
                        strValues += (strValues == "") ? v.toString() : "," + v.toString();
                    }
                }
                
                //alert(strProcedure + " " + spanParameter);
                //console.log("strProcParams -> " + strProcParams);
                //console.log("strValues -> " + strValues);
                var strProgram = curProgram + "." + newProgram;
                
                if (poolRun) {
                    // step-into start
                    addLinePool($command, curProgram, "dummy");
                    var $blockStart = $tabProcedure.find(".blockStart:first");
                    addLinePool($blockStart, strProgram, "dummy");                
                }
                if (runCode($tabProcedure.find(".block:first"), strProgram, poolRun, strProcParams, strValues) == false) {
                    exitCode = false;
                    return false;
                }
                if (poolRun) {
                    var $blockEnd = $tabProcedure.find(".blockEnd:last");
                    addLinePool($blockEnd, strProgram, "dummy");  
                }
            }
            else {
                if ($command.hasClass("line")) {
                    if (parseCommand($command, curProgram, poolRun) == false){
                        alert(logoProgram.ErrorMessage);
                        exitCode = false;
                        return false;
                    }
                }
            }
        }
    });
    return exitCode;
}

function addLinePool($codeLine, strTab, strClass) {
    var $newLine = $codeLine.clone();
    //var $poolContainer = $("<p>");
    
    if (strClass != null)
        $newLine.addClass(strClass);

    //removeLineButtons($newLine);
    //removeControls($newLine);
    $newLine.removeClass("highlightRunLine");
    $newLine.removeClass("highlightLine");
    $newLine.attr("tab", strTab);
    $newLine.data("codeLine", $codeLine);
    $("#divPool").append($newLine);
    //$poolContainer.append($newLine);
}


function runPoolLine(directionBack) {
    if (directionBack == null)
        directionBack = false;
    
    if (directionBack && timeoutID != -1){
        clearInterval(timeoutID);
        timeoutID = -1;
    }
    
    if ($poolLine === undefined || $poolLine.length == 0) {
        
    }
    var $divLine;
    $divLine = $poolLine.data("codeLine");

    $divLine.removeClass("highlightRunLine");
    $poolLine.removeClass("highlightRunLine");

    
    if ($poolLine.hasClass("dummy") == false && !directionBack)
        parseCommand($poolLine, "", null, false, $poolLine.index());

    /*
    // Uncomment this block to enable step-over in procedures
    // Don't forget to do the same in createLinesPool()
    if ($poolLine.hasClass("blockProcedure")) {
        var strProcedure = $(".spanCommand:first", $poolLine).text();
        var $tabProcedure = $("#tab-" + strProcedure);
        //alert("Running " + strProcedure);
        runCode($(".block:first", $tabProcedure));
    }
    */
    if (runAuto == false || runSpeed > maxSpeed / 2)
        $poolLine = (directionBack == false) ? $poolLine.next() : $poolLine.prev();
    else {
        do {
            $poolLine = (directionBack == false) ? $poolLine.next() : $poolLine.prev();
        } while ($poolLine == undefined || $poolLine.hasClass("dummy") == true);
    }


    if ($poolLine.length > 0) {
        
        if ($poolLine.hasClass("dummy") == false && directionBack)
            undoCommand($poolLine);
        
        $divLine = $poolLine.data("codeLine");
        $divLine.addClass("highlightRunLine");
        $poolLine.addClass("highlightRunLine");
        var tabId;
        var strTab = $poolLine.attr("tab");
        var li = strTab.lastIndexOf(".");
        if (li == -1)
            tabId = "tabMain";
        else
            tabId = "tab-" + strTab.substring(li+1);
        
        $leftPage.tabs('select', '#' + tabId);
        var $tab = $('#' + tabId);        
        var tabOffset = $tab.offset().top;
        var tabHeight = $tab.innerHeight() - 30;
        var scrollTop = $tab.scrollTop()
        var divOffset = $divLine.offset().top + scrollTop - tabOffset ;   
        var d = Math.floor(divOffset / tabHeight);
        var newTop = d * tabHeight;
        if (divOffset < scrollTop || divOffset > scrollTop + tabHeight)
            $tab.scrollTop(newTop);
        
    }
    else {
        $("#btnNext").button("option", "disabled", true);
        $("#btnPrev").button("option", "disabled", true);
        clearInterval(timeoutID);
        timeoutID = -1;
    }
}

function undoCommand($command) {
    var index = $command.index();
    var strCommand = $.trim($(".spanCommand", $command).text());
    var strNumber = $.trim($(".spanParameter", $command).text());
    if (strCommand == "στκ")
        bPenDown = false;
    if (strCommand == "στα")
        bPenDown = true;
    if (strCommand == "δε") {
        rotateTurtle(parseInt(strNumber));
    }
    if (strCommand == "αρ") {
        rotateTurtle(-parseInt(strNumber));
    }
    if (strCommand == "μπ") {
        $(".poolLine" + index, $("#myCanvas")).remove();
        moveTurtle(-parseInt(strNumber), false, index);
    }
    if (strCommand == "πι") {
        $(".poolLine" + index, $("#myCanvas")).remove();
        moveTurtle(parseInt(strNumber), false, index);
    }
//    if (strCommand == "σβγ") {
//        clearBoard();
//    }
}


function createNewLine() {
    return $('<div class="line"><span class="spanCommand">μπ</span><span class="spanParameter">1</span></div>');
}

function makeButtonFlat($btn) {
    $btn.css("width", "20px");
    $btn.css("height", "18px");
    $btn.css("margin-top", "3px");
    $btn.css("background", "#FFE9E2");
    $btn.css("border-style", "hidden");
    $btn.hover(function () {
        $(this).css("border-style", "inset");
    },
    function () {
        $(this).css("border-style", "hidden");
    });
}

function showButtonPaste($divLine) {
    // button paste
    if ($.trim($("#divClipBoard").html()) == "")
        return false; 

    $divLine.append("<button class='pasteLine'>Επικόλληση</button>");
    var $btnPasteLine = $(".pasteLine", $divLine);
    $btnPasteLine.button({
        text: false,
        icons: {
            primary: "ui-icon-clipboard"
        }
    })
    .click(function () {
        var $divClipBoard = $("#divClipBoard");
        var $codeClip = $($divClipBoard.html());

        if ($divLine.hasClass("blockEnd")) {
            var $blockCommand = $divLine.parent();
            var $block = $divLine.prev();
            $block.append($codeClip);
        }
        else {
            if ($divLine.hasClass("blockStart")) {
                var $blockCommand = $divLine.parent();
                var $block = $divLine.next();
                $block.prepend($codeClip);
            }
            else {
                $divLine.after($codeClip);
            }
        }

        $codeClip.each(function () {
            if ($(this).hasClass("blockCommand")) {
                createLineEvents( $(".line", $(this)) );
                createBlockHeaderEvents( $(".blockStart:first, .blockEnd:first", $(this)) );
            }
            else
                createLineEvents($(this));
        });
        resetCode();
    });
    makeButtonFlat($btnPasteLine);
}

function toggleConvert() {
    if ($(".selected", $curTab).size() > 0) {
        $("#btnConvert").button("option", "disabled", false);
        $("#btnConvertProcedure").button("option", "disabled", false);
    }
    else {
        $("#btnConvert").button("option", "disabled", true);
        $("#btnConvertProcedure").button("option", "disabled", true);
    }
}

function removeNestedSelections() {
    $(".selected", $curTab).each(function () {
        var $sel = $(this);
        var $selChildren = $(".selected", $sel);
        if ($selChildren.size() > 0)
            $selChildren.removeClass("selected");
    });
}

function showLineButtons($divLine) {
    var $lineParent = $divLine.parent();

    removeLineButtons();
    removeControls();

    var $spanCommand = $(".spanCommand", $divLine);
    showDropDownList($spanCommand);

    var $spanParameter = $(".spanParameter", $divLine);
    if ($spanParameter.css("visibility") != "hidden")
        showSpinner($spanParameter);

    // button delete
    $divLine.append("<button class='removeLine'>Διαγραφή</button>");
    var $btnRemoveLine = $(".removeLine", $divLine);
    $btnRemoveLine.button({
        text: false,
        icons: {
            primary: "ui-icon-trash"
        }
    })
    .click(function () {
        var $delLine;
        if ($lineParent.hasClass("blockCommand"))
            $delLine = $lineParent;
        else
            $delLine = $divLine;

        if (confirm("Είστε σίγουροι για την διαγραφή;")) {
            if ($lineParent.hasClass("blockCommand"))
                $divLine = removeBlockCommand($lineParent, $divLine);

            $divLine.addClass("selected");
            $(".selected", $curTab).remove();
            if ($(".program").children().size() == 0) {
                var $newLine = createNewLine();
                $newLine.appendTo($(".program"));
                createLineEvents($newLine);
            }
            resetCode();

            toggleConvert();
        }
        else {
            return true;
        }
    });
    makeButtonFlat($btnRemoveLine);

    // button add
    $divLine.append("<button class='addLine'>Εισαγωγή γραμμής</button>");
    var $btnAddLine = $(".addLine", $divLine);
    $btnAddLine.button({
        text: false,
        icons: {
            primary: "ui-icon-plus"
        }
    })
    .click(function () {
        var $newLine;
        if ($lineParent.hasClass("blockCommand")) {
            $newLine = createNewLine();
            $newLine.insertAfter($lineParent);
        }
        else {
            $newLine = $divLine.clone(false);
            $newLine.removeClass("highlightLine");
            $newLine.removeClass("highlightRunLine");
            $newLine.insertAfter($divLine);
        }

        removeLineButtons($newLine);
        removeControls($newLine);
        createLineEvents($newLine);
        resetCode();

        toggleConvert();
    });
    if ($lineParent.hasClass("blockCommand")) {
        $btnAddLine.button("option", "label", "Εισαγωγή γραμμής μετά");
        $btnAddLine.button("option", "icons", { primary: "ui-icon-arrowthickstop-1-s" });
        $divLine.append("<button class='addBeforeLine'>Εισαγωγή γραμμής πριν</button>");
        var $btnAddBeforeLine = $(".addBeforeLine", $divLine);
        $btnAddBeforeLine.button({
            text: false,
            icons: {
                primary: "ui-icon-arrowthickstop-1-n"
            }
        })
        .click(function () {
            var $newLine;
            $newLine = createNewLine();
            $newLine.removeClass("highlightLine");
            $newLine.removeClass("highlightRunLine");
            $newLine.insertBefore($lineParent);
            removeLineButtons($newLine);
            removeControls($newLine);
            createLineEvents($newLine);
            resetCode();

            toggleConvert();
        });
        makeButtonFlat($btnAddBeforeLine);
    }
    makeButtonFlat($btnAddLine);

    if ($lineParent.hasClass("blockCommand") == false) {  // An einai block entoli, min deixneis to paste
        // button paste
        showButtonPaste($divLine);
    }

    // button copy
    $divLine.append("<button class='copyLine'>Αντιγραφή</button>");
    var $btnCopyLine = $(".copyLine", $divLine);
    $btnCopyLine.button({
        text: false,
        icons: {
            primary: "ui-icon-copy"
        }
    })
    .click(function () {
        $("#divClipBoard").html("");
        if ($divLine.hasClass("blockHeader"))
            $lineParent.addClass("selected");
        else
            $divLine.addClass("selected");
        $divLine.removeClass("highlightLine");
        $divLine.removeClass("highlightRunLine");

        removeNestedSelections();

        var $selected = $(".selected", $curTab);
        $selected.removeClass("selected");
        var $clipLines = $selected.clone(false);
        $clipLines.appendTo($("#divClipBoard"));
        removeLineButtons($clipLines);
        removeControls($clipLines);
        $clipLines.removeClass("highlightLine");
        $clipLines.removeClass("highlightRunLine");
        $clipLines.removeClass("selected");

        toggleConvert();
    }); 
    makeButtonFlat($btnCopyLine);

    // select button
    $divLine.append("<button class='selectLine'>Επιλογή</button>");
    var $btnSelectLine = $(".selectLine", $divLine);
    $btnSelectLine.button({
        text: false,
        icons: {
            primary: "ui-icon-check"
        }
    })
    .click(function () {
        if ($divLine.hasClass("blockHeader"))
            $lineParent.toggleClass("selected");
        else
            $divLine.toggleClass("selected");

        removeNestedSelections();
        toggleConvert();
    });
    makeButtonFlat($btnSelectLine);
}

function removeLineButtons($divLine) {
    if ($divLine == null) {
        $(".addLine").remove();
        $(".removeLine").remove();
        $(".selectLine").remove();
        $(".addBeforeLine").remove();
        $(".copyLine").remove();
        $(".pasteLine").remove();
    }
    else {
        $(".addLine", $divLine).remove();
        $(".removeLine", $divLine).remove();
        $(".selectLine", $divLine).remove();
        $(".addBeforeLine", $divLine).remove();
        $(".copyLine", $divLine).remove();
        $(".pasteLine", $divLine).remove();
    }
}


function removeLineEvents($Line) {
    var $divLine;

    if ($Line == null) {
        $divLine = $(".line", $leftPage);
    }
    else {
        $divLine = $Line;
    }

    $divLine.each(function () {
        $(this).unbind("mouseenter");
        $(this).unbind("mouseleave");
    });
}



function createLineEvents($Line) {
    var $divLine;

    if ($Line == null) {
        $divLine = $(".line", $leftPage);
    }
    else {
        $divLine = $Line;
    }

    $divLine.each(function () {
        $(this).mouseenter(function () {
            var $lines = $(".line", $curTab);
            $lines.removeClass("highlightLine");
            $(this).addClass("highlightLine");
            showLineButtons($(this));
        });
        $(this).mouseleave(function () {
            $(this).removeClass("highlightLine");
            removeLineButtons();
            removeControls();
        });
    });
}

function resetCode() {
    clearBoard();
    bPenDown = true;
    $("#divPool").html("");
    $(".line, .blockStart, .blockEnd", $leftPage).removeClass("highlightRunLine");
    //$(".leftPage *").removeClass("highlightRunLine").removeClass("selected");
    $("#btnNext").button("option", "disabled", false);
    $("#btnPrev").button("option", "disabled", true);
    logoProgram.Clear();
    if (timeoutID != -1)
        clearInterval(timeoutID);
    timeoutID =-1 ;
    $poolLine = undefined;
    ToggleAutoControls(false);
}



function addTab($tabs) {
    var strTabName = prompt("Δώστε όνομα για την νέα διαδικασία:", "Διαδικασία" + (tab_counter + 1));
    if (strTabName != null) {
        strTabName = $.trim(strTabName);
        if (strTabName == "") {
            showDialog("Προσοχή", "Πρέπει να δώσετε όνομα!");
            return "";
        }
        if (strTabName.indexOf(" ") != -1) {
            showDialog("Προσοχή", "Δεν επιτρέπονται τα κενά στο όνομα!");
            return "";
        }
        if (strTabName.length > 15) {
            showDialog("Προσοχή", "Επιτρέπονται ονόματα μέχρι 15 χαρακτήρες.");
            return "";
        }
        if ( ($("#ddlCommandsHidden > option[value='" + strTabName + "']").size() != 0) ||
             (strTabName == "Κεντρικό")) 
        {
            showDialog("Προσοχή", "Η διαδικασία υπάρχει ήδη!");
            return "";
        }
        var $newCommand = $("<option>" + strTabName + "</option>")
            .attr("value", strTabName);
        $("#ddlCommandsHidden").append($newCommand);
        $tabs.tabs("add", "#tab-" + strTabName, strTabName);
        return strTabName;
    }
    return "";
}



function convertToProcedure() {
    $("#btnConvert").button("option", "disabled", true);
    $("#btnConvertProcedure").button("option", "disabled", true);

    var $selLines = $(".selected", $curTab);
    if ($selLines.size() == 0) {
        return false;
    }

    var $tabs = $(".leftPage");

    var strProcedure = addTab($tabs);
    if (strProcedure == "") {
        $("#btnConvert").button("option", "disabled", false);
        $("#btnConvertProcedure").button("option", "disabled", false);
        return false;
    }
    var $divLine = $selLines.first();
    var $newLine = createNewLine();
    $newLine.insertBefore($divLine);
    $newLine.addClass("blockProcedure");
    createLineEvents($newLine);

    var $spanCommand = $(".spanCommand:first", $newLine);
    $spanCommand.text(strProcedure);
    var $spanParameter = $(".spanParameter:first", $newLine);
    $spanParameter.html("");
    //$spanParameter.addClass("spanHidden");

    $newLine.hide();
    $newLine.animate({ height: "show" }, 1000, "easeOutBounce", function () {
        var $newTab = $("#tab-" + strProcedure);
        var $animTarget = $("a[href='#tab-" + strProcedure + "']");
        var $appendTarget = $(".block:first", $newTab);

        $(".selected:first", $curTab).each(function () {
            var $selLine = $(this);
            animateLine($selLine, $animTarget, $appendTarget, $spanParameter);
        });
    });
    resetCode();
    return $newLine;
}

function RegisterRemoveTabEvent($tabs, $tab) {
    $tab.find(".ui-icon-close").on("click", function () {
        var index = $("li", $tabs).index($(this).parent());
        //alert(index);
        if (index != 0) {
            var strTabName = $(this).parent().children("a:first").text();
            if (confirm("Η διαδικασία " + strTabName + " θα διαγραφεί. Είστε σίγουροι;")) {
                $("#ddlCommandsHidden > option[value='" + strTabName + "']").remove();
                $tabs.tabs("remove", index);
                resetCode();
            }
        }
    });      
}


function createTabs() {
    var $tabs = $leftPage.tabs({
        tabTemplate: "<li><a href='#{href}'>#{label}</a><span class='ui-icon ui-icon-close' title='Διαγραφή διαδικασίας'>Διαγραφή  διαδικασίας</span></li>",
        panelTemplate: "<div><code class='procedure'><div class='blockStart'>για <span class='spanName'></span> <span class='spanParameter'></span></div><div class='block'></div><div class='blockEnd'>τέλος</div></code></div>",
        add: function (event, ui) {
            tab_counter++;
            var strTabName = $(ui.tab).text();
            $(".spanName", $(ui.panel)).html(strTabName);
            $("code", $(ui.panel)).attr("name", strTabName);
            RegisterRemoveTabEvent($tabs, $(ui.tab).parent());
            createBlockHeaderEvents();
            //$tabs.tabs('select', '#' + ui.panel.id);
            //$tabs.find(".ui-tabs-nav").sortable({ axis: "x" });
        },
        select: function (event, ui) {
            $curTab = $(ui.panel);
            $(".line", $leftPage).removeClass("selected");
        }
    });

    $tabs.find("ul>li").each(function() {
        RegisterRemoveTabEvent($tabs, $(this));                 
    });

    $leftPage.find("li span.ui-icon-plus").click("click", function () {
        if (addTab($tabs) != "")
            resetCode();
    }).
    disableSelection();


    $curTab = $("#tabMain");

}

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}

function loadExample(strExampleID, arrCommands) {
    //var $leftPage = $(".leftPage");
    var strNewProgram, strNewCommand;
    $leftPage.tabs( "destroy" );
    $leftPage.html("");  
    strNewProgram = $("#" + strExampleID).html();
    strNewProgram = decodeHtml(strNewProgram);
    $leftPage.html(strNewProgram);
    $("#ddlCommandsHidden").html($("#ddlBuiltInCommands").html());
    for (var i=0, len=arrCommands.length; i <len; i++) {
        strNewCommand = "<option value='" + arrCommands[i] + "'>" + arrCommands[i] + "</option>";
        $("#ddlCommandsHidden").append(strNewCommand);        
    }
    createTabs();    
    
}

function ToggleAutoControls(bShow) {
    if (bShow){
        $("#labelAuto").css("visibility", "visible");
        $("#sliderSpeed").css("visibility", "visible");
    }
    else {
        $("#labelAuto").css("visibility", "hidden");
        $("#sliderSpeed").css("visibility", "hidden");
    }
}

function RunAutomatic(step){
    if (timeoutID != -1)
        clearInterval(timeoutID);
    timeoutID = -1;
    runSpeed = maxSpeed - step;
    if ($poolLine !== undefined && $poolLine.length > 0) {
        timeoutID = setInterval(function() {
            runPoolLine();
        }, runSpeed);
    }
}

$(document).ready(function () {
    
    
    $('#myCanvas').svg({
         onLoad: function () {
            svgManager = $('#myCanvas').svg('get');            
        }
    });

    $leftPage = $(".leftPage");
    $imgTurtle = $("#imgTurtle");
    
    halfTurtleWidth = ($("#imgTurtle").outerWidth() / 2);
    halfTurtleHeight = ($("#imgTurtle").outerHeight() / 2);
    canvasWidth = $("#myCanvas").innerWidth();
    canvasHeight = $("#myCanvas").innerHeight();
    clearBoard();

    createTabs();

    createLineEvents();
    createBlockHeaderEvents();


    $("#btnPlay").button({
        text: false,
        icons: {
            primary: "ui-icon-play"
        }
    }).
    click(function () {

        var $code = $("code", $curTab);
        var strName = $code.attr("name");

        if ($code.hasClass("program")) {
            resetCode();
            var  dStart, dEnd;
            console.log("Start execution");
            dStart = new Date().getTime();
            runCode($code, strName, false);
            dEnd = new Date().getTime();
            console.log("Time lapsed: " + (dEnd - dStart) + " ms");
            console.log("lines ->" + $("line", svgManager.root()).length);
            //$("line", svgManager.root()).css("display", "none");
        }
        else {
            showDialog("Εκτέλεση διαδικασίας", "Εκτέλεση " + strName, {
                "OK": function () {
                    $(this).dialog("close");
                    resetCode();
                    runCode($(".block:first", $code), strName);
                },
                "Άκυρο": function () {
                    $(this).dialog("close");
                }
            });
        }
    });

    $("#btnRestart").button({
        text: false,
        icons: {
            primary: "ui-icon-refresh"
        }
    })
    .click(function () {
        resetCode();
        $(".line, .blockCommand", $leftPage).removeClass("selected");
        $("#btnConvert").button("option", "disabled", true);
        $("#btnConvertProcedure").button("option", "disabled", true);


//        var $program = $(".program", $("#tabMain"));
//        var strCode = $program.text();
//        strCode = strCode.replace(/\s/g, "");              // εξαφάνισε όλα τα κενά
//        strCode = strCode.replace(/\b/g, " ");             // βάλε κενό στην αρχή κάθε λέξης
//        strCode = strCode.replace(/\s(?=\W)/g, "\n");      // αντικατέστησε τα κενά που ακολουθούνται από non-word με enter 
//        strCode = strCode.replace(/\x5B/g, "[\n");         // αντικατέστησε τα [ με [enter 
//        strCode = strCode.replace(/\x5D/g, "]\n");         // αντικατέστησε τα ] με ]enter 
//        //alert(strCode);
//        $("#divCode").html("<pre>" + strCode + "</pre>");
//        $("#divCode").select();
//        //window.location = "data:application/octet-stream," + $("#txtCode").val();

    });

    $("#btnNext").button({
        text: false,
        icons: {
            primary: "ui-icon-seek-next",
            secondary: "ui-icon-grip-dotted-horizontal"
        }
    })
    .click(function () {
        if ($(".highlightRunLine", $("#divPool")).size() == 0) {
            resetCode();
            
            var $code = $(".program");
            var strName = $code.attr("name");
            //alert(strName);
            runCode($code, strName, true);  // true = copy program commands into pool
            
            
            $poolLine = $(".line:first", $("#divPool"));
            $poolLine.addClass("highlightRunLine");
            //$(".line:not(.blockHeader)", $(".program")).first().addClass("highlightRunLine");
            $(".line", $(".program")).first().addClass("highlightRunLine");
            $("#btnPrev").button("option", "disabled", false);
            $leftPage.tabs('select', '#tabMain');
            
            ToggleAutoControls(true);
            
//            if (runAuto)
//                RunAutomatic($( "#sliderSpeed" ).slider("value"));
//            else
//                runPoolLine();
        }
        else{
            if (runAuto)
                RunAutomatic($( "#sliderSpeed" ).slider("value"));
            else
                runPoolLine();
        }
    });

    $("#btnPrev").button({
        text: false,
        icons: {
            primary: "ui-icon-grip-dotted-horizontal",
            secondary: "ui-icon-seek-prev"
        },
        disabled: true
    })
    .click(function () {
        if ($(".highlightRunLine:first", $("#divPool")).index() > 0) {
            //undoPoolLine();
            runPoolLine(true);      // true = back direction
        }
    });


    $("#btnConvert").button({
        text: true,
        icons: {
            primary: "ui-icon-lightbulb",
            secondary: "ui-icon-check"
        },
        disabled: true
    })
    .click(function () {
        convertToBlockCommand("επανάλαβε");
    });

    $("#btnConvertProcedure").button({
        text: true,
        icons: {
            primary: "ui-icon-newwin",
            secondary: "ui-icon-check"
        },
        disabled: true
    })
    .click(function () {
        convertToProcedure();
    });

    $("#btnHelp").button({
        text: false,
        title: "Βοήθεια",
        icons: {
            primary: "ui-icon-help"        
        },
    })
    .click(function () {
        return false;
    });

    $("#ddlExamples").change(function () {
        var val = parseInt($(this).val());


        switch (val) {
            case 1:
                loadExample("codeSpeira", ["Σπείρα"]);
                break;  
            case 2:
                loadExample("codeSpeiraEpan", ["ΣπείραΕπαν"]);
                break;    
            case 3:
                loadExample("codeSquareFlake", ["line", "ΤετρΝιφάδα"]);
                break;
            case 4:
                loadExample("codeKochIsland", ["πλευρά", "Νιφάδα"]);
                break;
            case 5:
                loadExample("codeSierpinski", ["Σιερπ"]);                
                break;                
            case 6:
                loadExample("codeTree", ["Δέντρο"]);                
                break;                

        }
        //setMessage(StepMessage[val]);
        resetCode();

        toggleConvert();

        createLineEvents();
        createBlockHeaderEvents();
    });
    var arrDropDown = $("#ddlExamples").MyDropdown();
    var $ddlHeader = arrDropDown[0];
    var $ddlMenu = arrDropDown[1];
    $ddlHeader.width(75);
    $ddlHeader.height(25);
    
    
    $("#btnSizer").button({
        text: false,
        icons: {
            primary: "ui-icon-carat-1-e"        
        },
    })
    .click(function () {
        if ($(".rightPage").css("display") == "none") {
            $leftPage.css("width", "375px");
            $(".rightPage").show();
            $(this).button("option", "icons", {
                primary: "ui-icon-carat-1-e"        
            });           
        }
        else {
            $leftPage.css("width", "760px");
            $(".rightPage").hide();
            $(this).button("option", "icons", {
                primary: "ui-icon-carat-1-w"        
            });           
        }

    });
    
    $("#imgTurtle").on("click", function() {
       $(this).toggleClass("transparent"); 
    });
    
    $( "#sliderSpeed" ).slider({
        range: "min",
        value: runSpeed,
        min: 1,
        max: maxSpeed,
        disabled: true,
        slide: function( event, ui ) {
            if (runAuto)
                RunAutomatic(ui.value);
        }
    });
    $( "#sliderSpeed" ).slider("disable");
    
    $( "#checkAuto" ).button({
        icons: {
        primary: ""
      },
      text: false
    }).on("click", function() {
        if ($(this).attr("checked") === undefined) {
            runAuto = false;
            clearInterval(timeoutID);
            timeoutID = -1;
            $( "#sliderSpeed" ).slider("disable");
            $(this).button( "option", "icons", { primary: ""});
        }
        else {
            runAuto = true;
            $( "#sliderSpeed" ).slider("enable");;
            $(this).button( "option", "icons", { primary: "ui-icon-check"});
        }
    });
    
    ToggleAutoControls(false);
});