/**
 * @author Paul Chan / KF Software House
 * http://www.kfsoft.info
 * Modified by Aleksey Kuznetsov (AK) at 2011/10/14  
 *
 * Version 0.6
 * Copyright (c) 2011 KF Software House
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/mit-license.php
 *
 */

(function ($) {
    var _options = new Array()
    var _optionsMenuLength = new Array()
    var timeoutId = 0
    jQuery.fn.MyDropdown = function ($scrollParent) {
        _options[_options.length] = 1
        _optionsMenuLength[_options.length] = 0
        var idx = _options.length - 1
        $(this).attr('idx', idx)
        $(this).each(function () {
            var selectmenu = $(this)
            var menuoptions = selectmenu.find('option')
            var val
            var genMenu = ''
            _optionsMenuLength[idx] = menuoptions.length
            for (var i = 0; i != menuoptions.length; i++) {
                val = menuoptions[i].value
                txt = menuoptions[i].text
                genMenu += '<li v="' + val + '">' + txt // AK
            }
            genMenu = menuoptions.length > 0 ? '<ul class="advMenuUL advMenuUL' + idx + '">' + genMenu + '</ul>' : ''
            var genHeader = '<div class="genHeader genHeader' + idx + '">SELECT</div>'
            selectmenu.hide()
            selectmenu.after(genHeader + genMenu)
            var lineHeight = $('.genHeader' + idx).height();
            $('.advMenuUL' + idx).addClass('menuHeader').addClass('menuHeader' + idx)
            $('.genHeader' + idx).click(function () {
                // AK --
                var selv = $(selectmenu).val()
                $('.advMenuUL li').each(function () {
                    var v = $(this).attr('v')
                    if (v == selv) {
                        this.className = 'sel'
                        return false // AK - break
                    }
                })
                $('.menuHeader' + idx).css('height', _optionsMenuLength[idx] * lineHeight)
                // AK --
                if ($('.genHeader' + idx).width() + 32 > $('.advMenuUL' + idx).width())
                    $('.advMenuUL' + idx).css('width', $('.genHeader' + idx).width() + 32)

                if ($scrollParent != null) {
                    $('.menuHeader' + idx).css("display", "block");
                    $('.menuHeader' + idx).offset({ top: $('.genHeader' + idx).offset().top + lineHeight - 5 });
                    $('.menuHeader' + idx).css("display", "none");
                }
                $('.menuHeader' + idx).toggle('fast'); // AK
            }).mouseleave(function () {
                timeoutId = setTimeout(function () {
                    $('.menuHeader' + idx).hide()
                }, 1000)
            })
            $('.menuHeader' + idx).mouseenter(function () {
                clearTimeout(timeoutId)
            }).mouseleave(function () {
                $(this).hide()
            })
            $('.genHeader' + idx).mouseenter(function () {
                $(this).addClass('genHeaderSel')
            }).mouseleave(function () {
                $(this).removeClass('genHeaderSel')
            }).mousedown(function () { // AK - disable selection on double click for Mozilla. (For IE it should be disabling of "onstartselect", but it conflicts with jQuery)
                return false
            })
            $('.advMenuUL' + idx + ' li').click(function () {
                $('.genHeader' + idx).html($(this).text())
                var v = $(this).attr('v')
                $(selectmenu).children().each(function () {
                    if ($(this).val() == v) {
                        this.selected = true
                        selectmenu.trigger('change') // AK -- onChange!
                        return false // AK - break
                    }
                })
                $('.menuHeader' + idx).hide()
            }).mouseover(function () { // AK --
                $('.advMenuUL li').each(function () {
                    this.className = ''
                })
            })
            $('.advMenuUL').hide()
            //init
            $(selectmenu).children().each(function () {
                if (this.selected) {
                    var selv = $(this).val()
                    var selt = $(this).text()
                    $('.advMenuUL li').each(function () {
                        var v = $(this).attr('v')
                        if (v == selv) {
                            $('.genHeader' + idx).html(selt)
                            return false // AK - break
                        }
                    })
                }
            })
        });
        return [$('.genHeader' + idx), $('.advMenuUL' + idx)];
    }
})(jQuery)