/*
 * Decompiled with CFR 0.152.
 */
package gr.talent.avakeeo.webinstaller;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;

class Download
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 4096;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;
    private URL url;
    private String filenameToSave = null;
    private int size;
    private int downloaded;
    private int status;

    public Download(URL url, String filenameToSave) {
        this.url = url;
        this.filenameToSave = filenameToSave;
        this.size = -1;
        this.downloaded = 0;
        this.status = 0;
    }

    public String getUrl() {
        return this.url.toString();
    }

    public int getSize() {
        return this.size;
    }

    public double getProgress() {
        return (double)this.downloaded / (double)this.size * 100.0;
    }

    public int getStatus() {
        return this.status;
    }

    public void pause() {
        this.status = 1;
        this.stateChanged();
    }

    public void start() {
        this.status = 0;
        this.stateChanged();
        this.download();
    }

    public void resume() {
        this.status = 0;
        this.stateChanged();
        this.download();
    }

    public void cancel() {
        this.status = 3;
        this.stateChanged();
    }

    private void error() {
        this.status = 4;
        this.stateChanged();
    }

    private void download() {
        Thread thread = new Thread(this);
        thread.start();
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    public void run() {
        block28: {
            InputStream stream = null;
            DataOutputStream dos = null;
            try {
                try {
                    int contentLength;
                    HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                    connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
                    connection.connect();
                    if (connection.getResponseCode() / 100 != 2) {
                        this.error();
                    }
                    if ((contentLength = connection.getContentLength()) < 1) {
                        this.error();
                    }
                    if (this.size == -1) {
                        this.size = contentLength;
                        System.out.println("Size is :" + contentLength);
                        this.stateChanged();
                    }
                    System.out.println("URL to get :" + this.url);
                    String property = "java.io.tmpdir";
                    String tempDir = System.getProperty(property);
                    File f = new File(String.valueOf(tempDir) + File.separator + this.filenameToSave);
                    System.out.println("tempDir :" + tempDir);
                    if (f.exists()) {
                        System.out.println("exists!");
                        System.out.println("Deleted :" + f.delete());
                    }
                    dos = new DataOutputStream(new FileOutputStream(f));
                    byte[] buffer = new byte[4096];
                    stream = connection.getInputStream();
                    while (this.status == 0) {
                        int read = stream.read(buffer);
                        if (read == -1) break;
                        dos.write(buffer, 0, read);
                        this.downloaded += read;
                        this.stateChanged();
                    }
                    System.out.println("Doneee! :");
                    if (this.status != 0) break block28;
                    this.status = 2;
                    System.out.println("Complete! :" + this.getProgress());
                    try {
                        dos.flush();
                        dos.close();
                        System.out.println("FILE CLOSED!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.stateChanged();
                }
                catch (Exception e) {
                    this.error();
                    e.printStackTrace();
                    try {
                        dos.flush();
                        dos.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (stream == null) break block28;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                }
            }
            finally {
                try {
                    dos.flush();
                    dos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }
}

